/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.VisitorState;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class AssertThrowsUtils {
    public static Optional<Fix> tryFailToAssertThrows(TryTree tryTree, List<? extends StatementTree> throwingStatements, Optional<Tree> failureMessage, VisitorState state) {
        boolean useExpressionLambda;
        List<? extends CatchTree> catchTrees = tryTree.getCatches();
        if (catchTrees.size() != 1) {
            return Optional.empty();
        }
        CatchTree catchTree = (CatchTree)Iterables.getOnlyElement(catchTrees);
        SuggestedFix.Builder fix = SuggestedFix.builder();
        StringBuilder fixPrefix = new StringBuilder();
        String fixSuffix = "";
        if (throwingStatements.isEmpty()) {
            return Optional.empty();
        }
        List<? extends StatementTree> catchStatements = catchTree.getBlock().getStatements();
        fix.addStaticImport("org.junit.Assert.assertThrows");
        List<? extends Tree> resources = tryTree.getResources();
        if (!resources.isEmpty()) {
            fixPrefix.append(resources.stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(Collectors.joining("\n", "try (", ") {\n")));
            fixSuffix = "\n}";
        }
        if (!catchStatements.isEmpty()) {
            fixPrefix.append(String.format("%s = ", state.getSourceForNode((Tree)catchTree.getParameter())));
        }
        fixPrefix.append(String.format("assertThrows(%s%s.class, () -> ", failureMessage.filter(t -> ASTHelpers.constValue((Tree)t, String.class) == null).map(t -> state.getSourceForNode(t) + ", ").orElse(""), state.getSourceForNode(catchTree.getParameter().getType())));
        boolean bl = useExpressionLambda = throwingStatements.size() == 1 && ((StatementTree)Iterables.getOnlyElement(throwingStatements)).getKind() == Tree.Kind.EXPRESSION_STATEMENT;
        if (!useExpressionLambda) {
            fixPrefix.append("{");
        }
        fix.replace(ASTHelpers.getStartPosition((Tree)tryTree), ASTHelpers.getStartPosition((Tree)throwingStatements.iterator().next()), fixPrefix.toString());
        if (useExpressionLambda) {
            fix.postfixWith((Tree)((ExpressionStatementTree)throwingStatements.iterator().next()).getExpression(), ")");
        } else {
            fix.postfixWith((Tree)Iterables.getLast(throwingStatements), "});");
        }
        if (catchStatements.isEmpty()) {
            fix.replace(state.getEndPosition((Tree)Iterables.getLast(throwingStatements)), state.getEndPosition((Tree)tryTree), fixSuffix);
        } else {
            fix.replace(state.getEndPosition((Tree)Iterables.getLast(throwingStatements)), ASTHelpers.getStartPosition((Tree)catchStatements.get(0)), "\n");
            fix.replace(state.getEndPosition((Tree)Iterables.getLast(catchStatements)), state.getEndPosition((Tree)tryTree), fixSuffix);
        }
        return Optional.of(fix.build());
    }

    private AssertThrowsUtils() {
    }
}

