/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.HashSet;

@BugPattern(summary="Map#ofEntries will throw an IllegalArgumentException if there are any duplicate keys", severity=BugPattern.SeverityLevel.ERROR)
public class DuplicateMapKeys
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> METHOD_MATCHER = MethodMatchers.staticMethod().onClass("java.util.Map").named("ofEntries");
    private static final Matcher<ExpressionTree> ENTRY_MATCHER = MethodMatchers.staticMethod().onClass("java.util.Map").named("entry");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!METHOD_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        HashSet<Object> keySet = new HashSet<Object>();
        for (ExpressionTree expressionTree : tree.getArguments()) {
            MethodInvocationTree entryInvocation;
            Object key;
            if (!(expressionTree instanceof MethodInvocationTree) || !ENTRY_MATCHER.matches((Tree)expressionTree, state) || (key = ASTHelpers.constValue((Tree)(entryInvocation = (MethodInvocationTree)expressionTree).getArguments().get(0))) == null || keySet.add(key)) continue;
            return this.buildDescription(tree).setMessage(String.format("duplicate key '%s'; Map#ofEntries will throw an IllegalArgumentException", key)).build();
        }
        return Description.NO_MATCH;
    }
}

