/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib;

import com.github.difflib.algorithm.DiffAlgorithmI;
import com.github.difflib.algorithm.DiffAlgorithmListener;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.algorithm.myers.MyersDiff;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Patch;
import com.github.difflib.patch.PatchFailedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public final class DiffUtils {
    public static <T> Patch<T> diff(List<T> original, List<T> revised, DiffAlgorithmListener progress) throws DiffException {
        return DiffUtils.diff(original, revised, new MyersDiff(), progress);
    }

    public static <T> Patch<T> diff(List<T> original, List<T> revised) throws DiffException {
        return DiffUtils.diff(original, revised, new MyersDiff(), null);
    }

    public static Patch<String> diff(String sourceText, String targetText, DiffAlgorithmListener progress) throws DiffException {
        return DiffUtils.diff(Arrays.asList(sourceText.split("\n")), Arrays.asList(targetText.split("\n")), progress);
    }

    public static <T> Patch<T> diff(List<T> source, List<T> target, BiPredicate<T, T> equalizer) throws DiffException {
        if (equalizer != null) {
            return DiffUtils.diff(source, target, new MyersDiff<T>(equalizer));
        }
        return DiffUtils.diff(source, target, new MyersDiff());
    }

    public static <T> Patch<T> diff(List<T> original, List<T> revised, DiffAlgorithmI<T> algorithm, DiffAlgorithmListener progress) throws DiffException {
        Objects.requireNonNull(original, "original must not be null");
        Objects.requireNonNull(revised, "revised must not be null");
        Objects.requireNonNull(algorithm, "algorithm must not be null");
        return Patch.generate(original, revised, algorithm.computeDiff(original, revised, progress));
    }

    public static <T> Patch<T> diff(List<T> original, List<T> revised, DiffAlgorithmI<T> algorithm) throws DiffException {
        return DiffUtils.diff(original, revised, algorithm, null);
    }

    public static Patch<String> diffInline(String original, String revised) throws DiffException {
        Character character;
        int n;
        ArrayList<String> origList = new ArrayList<String>();
        ArrayList<String> revList = new ArrayList<String>();
        char[] cArray = original.toCharArray();
        int n2 = cArray.length;
        for (n = 0; n < n2; ++n) {
            character = Character.valueOf(cArray[n]);
            origList.add(character.toString());
        }
        cArray = revised.toCharArray();
        n2 = cArray.length;
        for (n = 0; n < n2; ++n) {
            character = Character.valueOf(cArray[n]);
            revList.add(character.toString());
        }
        Patch<String> patch = DiffUtils.diff(origList, revList);
        for (AbstractDelta delta : patch.getDeltas()) {
            delta.getSource().setLines(DiffUtils.compressLines(delta.getSource().getLines(), ""));
            delta.getTarget().setLines(DiffUtils.compressLines(delta.getTarget().getLines(), ""));
        }
        return patch;
    }

    private static List<String> compressLines(List<String> lines, String delimiter) {
        if (lines.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(lines.stream().collect(Collectors.joining(delimiter)));
    }

    public static <T> List<T> patch(List<T> original, Patch<T> patch) throws PatchFailedException {
        return patch.applyTo(original);
    }

    public static <T> List<T> unpatch(List<T> revised, Patch<T> patch) {
        return patch.restore(revised);
    }

    private DiffUtils() {
    }
}

