/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.model.ApiVersion;

public class DefaultApiVersion
implements ApiVersion {
    private final int mApiLevel;
    private final String mCodename;

    public DefaultApiVersion(int apiLevel, String codename) {
        this.mApiLevel = apiLevel;
        this.mCodename = codename;
    }

    public DefaultApiVersion(int apiLevel) {
        this(apiLevel, null);
    }

    public DefaultApiVersion(String codename) {
        this(1, codename);
    }

    public static ApiVersion create(Object value) {
        if (value instanceof Integer) {
            return new DefaultApiVersion((Integer)value, null);
        }
        if (value instanceof String) {
            return new DefaultApiVersion(1, (String)value);
        }
        return new DefaultApiVersion(1, null);
    }

    public int getApiLevel() {
        return this.mApiLevel;
    }

    public String getCodename() {
        return this.mCodename;
    }

    public String getApiString() {
        return this.mCodename != null ? this.mCodename : Integer.toString(this.mApiLevel);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultApiVersion that = (DefaultApiVersion)o;
        if (this.mApiLevel != that.mApiLevel) {
            return false;
        }
        return !(this.mCodename != null ? !this.mCodename.equals(that.mCodename) : that.mCodename != null);
    }

    public int hashCode() {
        int result = this.mApiLevel;
        result = 31 * result + (this.mCodename != null ? this.mCodename.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DefaultApiVersion{mApiLevel=" + this.mApiLevel + ", mCodename='" + this.mCodename + '\'' + '}';
    }
}

