/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;

public class AlarmDetector
extends Detector
implements Detector.JavaScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(AlarmDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create((String)"ShortAlarm", (String)"Short or Frequent Alarm", (String)"Frequent alarms are bad for battery life. As of API 22, the `AlarmManager` will override near-future and high-frequency alarm requests, delaying the alarm at least 5 seconds into the future and ensuring that the repeat interval is at least 60 seconds.\n\nIf you really need to do work sooner than 5 seconds, post a delayed message or runnable to a Handler.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);

    public boolean appliesTo(Context context, File file) {
        return true;
    }

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("setRepeating");
    }

    public void visitMethod(JavaContext context, AstVisitor visitor, MethodInvocation node) {
        JavaParser.ResolvedMethod method;
        JavaParser.ResolvedNode resolved = context.resolve((Node)node);
        if (resolved instanceof JavaParser.ResolvedMethod && (method = (JavaParser.ResolvedMethod)resolved).getContainingClass().matches("android.app.AlarmManager") && method.getArgumentCount() == 4) {
            AlarmDetector.ensureAtLeast(context, node, 1, 5000L);
            AlarmDetector.ensureAtLeast(context, node, 2, 60000L);
        }
    }

    private static void ensureAtLeast(JavaContext context, MethodInvocation node, int parameter, long min) {
        Iterator iterator = node.astArguments().iterator();
        Expression argument = null;
        for (int i = 0; i <= parameter; ++i) {
            if (!iterator.hasNext()) {
                return;
            }
            argument = (Expression)iterator.next();
        }
        if (argument == null) {
            return;
        }
        long value = AlarmDetector.getLongValue(context, argument);
        if (value < min) {
            String message = String.format("Value will be forced up to %d as of Android 5.1; don't rely on this to be exact", min);
            context.report(ISSUE, (Node)argument, context.getLocation((Node)argument), message);
        }
    }

    private static long getLongValue(JavaContext context, Expression argument) {
        Object value = ConstantEvaluator.evaluate((JavaContext)context, (Node)argument);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.MAX_VALUE;
    }
}

