/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.Arrays;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.StrictListAccessor;

public class SslCertificateSocketFactoryDetector
extends Detector
implements Detector.JavaScanner {
    private static final Implementation IMPLEMENTATION_JAVA = new Implementation(SslCertificateSocketFactoryDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue CREATE_SOCKET = Issue.create((String)"SSLCertificateSocketFactoryCreateSocket", (String)"Insecure call to `SSLCertificateSocketFactory.createSocket()`", (String)"When `SSLCertificateSocketFactory.createSocket()` is called with an `InetAddress` as the first parameter, TLS/SSL hostname verification is not performed, which could result in insecure network traffic caused by trusting arbitrary hostnames in TLS/SSL certificates presented by peers. In this case, developers must ensure that the `InetAddress` is explicitly verified against the certificate through other means, such as by calling `SSLCertificateSocketFactory.getDefaultHostnameVerifier() to get a `HostnameVerifier` and calling `HostnameVerifier.verify()`.", (Category)Category.SECURITY, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_JAVA);
    public static final Issue GET_INSECURE = Issue.create((String)"SSLCertificateSocketFactoryGetInsecure", (String)"Call to `SSLCertificateSocketFactory.getInsecure()`", (String)"The `SSLCertificateSocketFactory.getInsecure()` method returns an SSLSocketFactory with all TLS/SSL security checks disabled, which could result in insecure network traffic caused by trusting arbitrary TLS/SSL certificates presented by peers. This method should be avoided unless needed for a special circumstance such as debugging. Instead, `SSLCertificateSocketFactory.getDefault()` should be used.", (Category)Category.SECURITY, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_JAVA);
    private static final String INET_ADDRESS_CLASS = "java.net.InetAddress";
    private static final String SSL_CERTIFICATE_SOCKET_FACTORY_CLASS = "android.net.SSLCertificateSocketFactory";

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public List<String> getApplicableMethodNames() {
        return Arrays.asList("createSocket", "getInsecure");
    }

    public void visitMethod(JavaContext context, AstVisitor visitor, MethodInvocation node) {
        JavaParser.ResolvedNode resolved = context.resolve((Node)node);
        if (resolved instanceof JavaParser.ResolvedMethod) {
            String methodName = node.astName().astValue();
            JavaParser.ResolvedClass resolvedClass = ((JavaParser.ResolvedMethod)resolved).getContainingClass();
            if (resolvedClass.isSubclassOf(SSL_CERTIFICATE_SOCKET_FACTORY_CLASS, false)) {
                if ("createSocket".equals(methodName)) {
                    JavaParser.ResolvedClass firstParameterClass;
                    JavaParser.TypeDescriptor firstParameterType;
                    StrictListAccessor argumentList = node.astArguments();
                    if (argumentList != null && (firstParameterType = context.getType(argumentList.first())) != null && (firstParameterClass = firstParameterType.getTypeClass()) != null && firstParameterClass.isSubclassOf(INET_ADDRESS_CLASS, false)) {
                        context.report(CREATE_SOCKET, (Node)node, context.getLocation((Node)node), "Use of `SSLCertificateSocketFactory.createSocket()` with an InetAddress parameter can cause insecure network traffic due to trusting arbitrary hostnames in TLS/SSL certificates presented by peers");
                    }
                } else if ("getInsecure".equals(methodName)) {
                    context.report(GET_INSECURE, (Node)node, context.getLocation((Node)node), "Use of `SSLCertificateSocketFactory.getInsecure()` can cause insecure network traffic due to trusting arbitrary TLS/SSL certificates presented by peers");
                }
            }
        }
    }
}

