/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.UUID;

class UUIDCodec
implements ObjectCodec<UUID> {
    UUIDCodec() {
    }

    @Override
    public Class<UUID> getEncodedClass() {
        return UUID.class;
    }

    @Override
    public void serialize(SerializationContext unusedContext, UUID uuid, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeInt64NoTag(uuid.getMostSignificantBits());
        codedOut.writeInt64NoTag(uuid.getLeastSignificantBits());
    }

    @Override
    public UUID deserialize(DeserializationContext unusedContext, CodedInputStream codedIn) throws SerializationException, IOException {
        return new UUID(codedIn.readInt64(), codedIn.readInt64());
    }
}

