//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
)

type SCRIPTING_CMD uint64

const (
	// Start a REPL session.
	SCRIPTING_CMD_REPL_START SCRIPTING_CMD = 0
	// End a REPL session.
	SCRIPTING_CMD_REPL_STOP SCRIPTING_CMD = 1
	// Stop execution of scripts.
	SCRIPTING_CMD_STOP SCRIPTING_CMD = 2
	// Stop execution of scripts and restart.
	SCRIPTING_CMD_STOP_AND_RESTART SCRIPTING_CMD = 3
)

var value_to_label_SCRIPTING_CMD = map[SCRIPTING_CMD]string{
	SCRIPTING_CMD_REPL_START:       "SCRIPTING_CMD_REPL_START",
	SCRIPTING_CMD_REPL_STOP:        "SCRIPTING_CMD_REPL_STOP",
	SCRIPTING_CMD_STOP:             "SCRIPTING_CMD_STOP",
	SCRIPTING_CMD_STOP_AND_RESTART: "SCRIPTING_CMD_STOP_AND_RESTART",
}

var label_to_value_SCRIPTING_CMD = map[string]SCRIPTING_CMD{
	"SCRIPTING_CMD_REPL_START":       SCRIPTING_CMD_REPL_START,
	"SCRIPTING_CMD_REPL_STOP":        SCRIPTING_CMD_REPL_STOP,
	"SCRIPTING_CMD_STOP":             SCRIPTING_CMD_STOP,
	"SCRIPTING_CMD_STOP_AND_RESTART": SCRIPTING_CMD_STOP_AND_RESTART,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e SCRIPTING_CMD) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_SCRIPTING_CMD[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *SCRIPTING_CMD) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_SCRIPTING_CMD[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = SCRIPTING_CMD(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e SCRIPTING_CMD) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
