//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

type MAV_ARM_AUTH_DENIED_REASON uint64

const (
	// Not a specific reason
	MAV_ARM_AUTH_DENIED_REASON_GENERIC MAV_ARM_AUTH_DENIED_REASON = 0
	// Authorizer will send the error as string to GCS
	MAV_ARM_AUTH_DENIED_REASON_NONE MAV_ARM_AUTH_DENIED_REASON = 1
	// At least one waypoint have a invalid value
	MAV_ARM_AUTH_DENIED_REASON_INVALID_WAYPOINT MAV_ARM_AUTH_DENIED_REASON = 2
	// Timeout in the authorizer process(in case it depends on network)
	MAV_ARM_AUTH_DENIED_REASON_TIMEOUT MAV_ARM_AUTH_DENIED_REASON = 3
	// Airspace of the mission in use by another vehicle, second result parameter can have the waypoint id that caused it to be denied.
	MAV_ARM_AUTH_DENIED_REASON_AIRSPACE_IN_USE MAV_ARM_AUTH_DENIED_REASON = 4
	// Weather is not good to fly
	MAV_ARM_AUTH_DENIED_REASON_BAD_WEATHER MAV_ARM_AUTH_DENIED_REASON = 5
)

var value_to_label_MAV_ARM_AUTH_DENIED_REASON = map[MAV_ARM_AUTH_DENIED_REASON]string{
	MAV_ARM_AUTH_DENIED_REASON_GENERIC:          "MAV_ARM_AUTH_DENIED_REASON_GENERIC",
	MAV_ARM_AUTH_DENIED_REASON_NONE:             "MAV_ARM_AUTH_DENIED_REASON_NONE",
	MAV_ARM_AUTH_DENIED_REASON_INVALID_WAYPOINT: "MAV_ARM_AUTH_DENIED_REASON_INVALID_WAYPOINT",
	MAV_ARM_AUTH_DENIED_REASON_TIMEOUT:          "MAV_ARM_AUTH_DENIED_REASON_TIMEOUT",
	MAV_ARM_AUTH_DENIED_REASON_AIRSPACE_IN_USE:  "MAV_ARM_AUTH_DENIED_REASON_AIRSPACE_IN_USE",
	MAV_ARM_AUTH_DENIED_REASON_BAD_WEATHER:      "MAV_ARM_AUTH_DENIED_REASON_BAD_WEATHER",
}

var label_to_value_MAV_ARM_AUTH_DENIED_REASON = map[string]MAV_ARM_AUTH_DENIED_REASON{
	"MAV_ARM_AUTH_DENIED_REASON_GENERIC":          MAV_ARM_AUTH_DENIED_REASON_GENERIC,
	"MAV_ARM_AUTH_DENIED_REASON_NONE":             MAV_ARM_AUTH_DENIED_REASON_NONE,
	"MAV_ARM_AUTH_DENIED_REASON_INVALID_WAYPOINT": MAV_ARM_AUTH_DENIED_REASON_INVALID_WAYPOINT,
	"MAV_ARM_AUTH_DENIED_REASON_TIMEOUT":          MAV_ARM_AUTH_DENIED_REASON_TIMEOUT,
	"MAV_ARM_AUTH_DENIED_REASON_AIRSPACE_IN_USE":  MAV_ARM_AUTH_DENIED_REASON_AIRSPACE_IN_USE,
	"MAV_ARM_AUTH_DENIED_REASON_BAD_WEATHER":      MAV_ARM_AUTH_DENIED_REASON_BAD_WEATHER,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_ARM_AUTH_DENIED_REASON) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MAV_ARM_AUTH_DENIED_REASON[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_ARM_AUTH_DENIED_REASON) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MAV_ARM_AUTH_DENIED_REASON[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_ARM_AUTH_DENIED_REASON(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_ARM_AUTH_DENIED_REASON) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
