package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

type ListSchemaAndTableRequestBody struct {

	// **参数解释**: SQL文本。 **约束限制**: 不涉及。 **取值范围**: 不涉及。 **默认取值**: 不涉及。
	SqlText string `json:"sql_text"`

	// **参数解释**: 实例ID。 **约束限制**: 不涉及。 **取值范围**: 只能由英文字母、数字组成，且长度为36个字符。 **默认取值**: 不涉及。
	InstanceId *string `json:"instance_id,omitempty"`
}

func (o ListSchemaAndTableRequestBody) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "ListSchemaAndTableRequestBody struct{}"
	}

	return strings.Join([]string{"ListSchemaAndTableRequestBody", string(data)}, " ")
}
