//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
	"strings"
)

// Flags in the HIGHRES_IMU message indicate which fields have updated since the last message
type HIGHRES_IMU_UPDATED_FLAGS uint64

const (
	// The value in the xacc field has been updated
	HIGHRES_IMU_UPDATED_XACC HIGHRES_IMU_UPDATED_FLAGS = 1
	// The value in the yacc field has been updated
	HIGHRES_IMU_UPDATED_YACC HIGHRES_IMU_UPDATED_FLAGS = 2
	// The value in the zacc field has been updated since
	HIGHRES_IMU_UPDATED_ZACC HIGHRES_IMU_UPDATED_FLAGS = 4
	// The value in the xgyro field has been updated
	HIGHRES_IMU_UPDATED_XGYRO HIGHRES_IMU_UPDATED_FLAGS = 8
	// The value in the ygyro field has been updated
	HIGHRES_IMU_UPDATED_YGYRO HIGHRES_IMU_UPDATED_FLAGS = 16
	// The value in the zgyro field has been updated
	HIGHRES_IMU_UPDATED_ZGYRO HIGHRES_IMU_UPDATED_FLAGS = 32
	// The value in the xmag field has been updated
	HIGHRES_IMU_UPDATED_XMAG HIGHRES_IMU_UPDATED_FLAGS = 64
	// The value in the ymag field has been updated
	HIGHRES_IMU_UPDATED_YMAG HIGHRES_IMU_UPDATED_FLAGS = 128
	// The value in the zmag field has been updated
	HIGHRES_IMU_UPDATED_ZMAG HIGHRES_IMU_UPDATED_FLAGS = 256
	// The value in the abs_pressure field has been updated
	HIGHRES_IMU_UPDATED_ABS_PRESSURE HIGHRES_IMU_UPDATED_FLAGS = 512
	// The value in the diff_pressure field has been updated
	HIGHRES_IMU_UPDATED_DIFF_PRESSURE HIGHRES_IMU_UPDATED_FLAGS = 1024
	// The value in the pressure_alt field has been updated
	HIGHRES_IMU_UPDATED_PRESSURE_ALT HIGHRES_IMU_UPDATED_FLAGS = 2048
	// The value in the temperature field has been updated
	HIGHRES_IMU_UPDATED_TEMPERATURE HIGHRES_IMU_UPDATED_FLAGS = 4096
)

var values_HIGHRES_IMU_UPDATED_FLAGS = []HIGHRES_IMU_UPDATED_FLAGS{
	HIGHRES_IMU_UPDATED_XACC,
	HIGHRES_IMU_UPDATED_YACC,
	HIGHRES_IMU_UPDATED_ZACC,
	HIGHRES_IMU_UPDATED_XGYRO,
	HIGHRES_IMU_UPDATED_YGYRO,
	HIGHRES_IMU_UPDATED_ZGYRO,
	HIGHRES_IMU_UPDATED_XMAG,
	HIGHRES_IMU_UPDATED_YMAG,
	HIGHRES_IMU_UPDATED_ZMAG,
	HIGHRES_IMU_UPDATED_ABS_PRESSURE,
	HIGHRES_IMU_UPDATED_DIFF_PRESSURE,
	HIGHRES_IMU_UPDATED_PRESSURE_ALT,
	HIGHRES_IMU_UPDATED_TEMPERATURE,
}

var value_to_label_HIGHRES_IMU_UPDATED_FLAGS = map[HIGHRES_IMU_UPDATED_FLAGS]string{
	HIGHRES_IMU_UPDATED_XACC:          "HIGHRES_IMU_UPDATED_XACC",
	HIGHRES_IMU_UPDATED_YACC:          "HIGHRES_IMU_UPDATED_YACC",
	HIGHRES_IMU_UPDATED_ZACC:          "HIGHRES_IMU_UPDATED_ZACC",
	HIGHRES_IMU_UPDATED_XGYRO:         "HIGHRES_IMU_UPDATED_XGYRO",
	HIGHRES_IMU_UPDATED_YGYRO:         "HIGHRES_IMU_UPDATED_YGYRO",
	HIGHRES_IMU_UPDATED_ZGYRO:         "HIGHRES_IMU_UPDATED_ZGYRO",
	HIGHRES_IMU_UPDATED_XMAG:          "HIGHRES_IMU_UPDATED_XMAG",
	HIGHRES_IMU_UPDATED_YMAG:          "HIGHRES_IMU_UPDATED_YMAG",
	HIGHRES_IMU_UPDATED_ZMAG:          "HIGHRES_IMU_UPDATED_ZMAG",
	HIGHRES_IMU_UPDATED_ABS_PRESSURE:  "HIGHRES_IMU_UPDATED_ABS_PRESSURE",
	HIGHRES_IMU_UPDATED_DIFF_PRESSURE: "HIGHRES_IMU_UPDATED_DIFF_PRESSURE",
	HIGHRES_IMU_UPDATED_PRESSURE_ALT:  "HIGHRES_IMU_UPDATED_PRESSURE_ALT",
	HIGHRES_IMU_UPDATED_TEMPERATURE:   "HIGHRES_IMU_UPDATED_TEMPERATURE",
}

var label_to_value_HIGHRES_IMU_UPDATED_FLAGS = map[string]HIGHRES_IMU_UPDATED_FLAGS{
	"HIGHRES_IMU_UPDATED_XACC":          HIGHRES_IMU_UPDATED_XACC,
	"HIGHRES_IMU_UPDATED_YACC":          HIGHRES_IMU_UPDATED_YACC,
	"HIGHRES_IMU_UPDATED_ZACC":          HIGHRES_IMU_UPDATED_ZACC,
	"HIGHRES_IMU_UPDATED_XGYRO":         HIGHRES_IMU_UPDATED_XGYRO,
	"HIGHRES_IMU_UPDATED_YGYRO":         HIGHRES_IMU_UPDATED_YGYRO,
	"HIGHRES_IMU_UPDATED_ZGYRO":         HIGHRES_IMU_UPDATED_ZGYRO,
	"HIGHRES_IMU_UPDATED_XMAG":          HIGHRES_IMU_UPDATED_XMAG,
	"HIGHRES_IMU_UPDATED_YMAG":          HIGHRES_IMU_UPDATED_YMAG,
	"HIGHRES_IMU_UPDATED_ZMAG":          HIGHRES_IMU_UPDATED_ZMAG,
	"HIGHRES_IMU_UPDATED_ABS_PRESSURE":  HIGHRES_IMU_UPDATED_ABS_PRESSURE,
	"HIGHRES_IMU_UPDATED_DIFF_PRESSURE": HIGHRES_IMU_UPDATED_DIFF_PRESSURE,
	"HIGHRES_IMU_UPDATED_PRESSURE_ALT":  HIGHRES_IMU_UPDATED_PRESSURE_ALT,
	"HIGHRES_IMU_UPDATED_TEMPERATURE":   HIGHRES_IMU_UPDATED_TEMPERATURE,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e HIGHRES_IMU_UPDATED_FLAGS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for _, val := range values_HIGHRES_IMU_UPDATED_FLAGS {
		if e&val == val {
			names = append(names, value_to_label_HIGHRES_IMU_UPDATED_FLAGS[val])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *HIGHRES_IMU_UPDATED_FLAGS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask HIGHRES_IMU_UPDATED_FLAGS
	for _, label := range labels {
		if value, ok := label_to_value_HIGHRES_IMU_UPDATED_FLAGS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= HIGHRES_IMU_UPDATED_FLAGS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e HIGHRES_IMU_UPDATED_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
