//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
	"strings"
)

// Flags for CURRENT_EVENT_SEQUENCE.
type MAV_EVENT_CURRENT_SEQUENCE_FLAGS uint64

const (
	// A sequence reset has happened (e.g. vehicle reboot).
	MAV_EVENT_CURRENT_SEQUENCE_FLAGS_RESET MAV_EVENT_CURRENT_SEQUENCE_FLAGS = 1
)

var values_MAV_EVENT_CURRENT_SEQUENCE_FLAGS = []MAV_EVENT_CURRENT_SEQUENCE_FLAGS{
	MAV_EVENT_CURRENT_SEQUENCE_FLAGS_RESET,
}

var value_to_label_MAV_EVENT_CURRENT_SEQUENCE_FLAGS = map[MAV_EVENT_CURRENT_SEQUENCE_FLAGS]string{
	MAV_EVENT_CURRENT_SEQUENCE_FLAGS_RESET: "MAV_EVENT_CURRENT_SEQUENCE_FLAGS_RESET",
}

var label_to_value_MAV_EVENT_CURRENT_SEQUENCE_FLAGS = map[string]MAV_EVENT_CURRENT_SEQUENCE_FLAGS{
	"MAV_EVENT_CURRENT_SEQUENCE_FLAGS_RESET": MAV_EVENT_CURRENT_SEQUENCE_FLAGS_RESET,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_EVENT_CURRENT_SEQUENCE_FLAGS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for _, val := range values_MAV_EVENT_CURRENT_SEQUENCE_FLAGS {
		if e&val == val {
			names = append(names, value_to_label_MAV_EVENT_CURRENT_SEQUENCE_FLAGS[val])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_EVENT_CURRENT_SEQUENCE_FLAGS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask MAV_EVENT_CURRENT_SEQUENCE_FLAGS
	for _, label := range labels {
		if value, ok := label_to_value_MAV_EVENT_CURRENT_SEQUENCE_FLAGS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= MAV_EVENT_CURRENT_SEQUENCE_FLAGS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_EVENT_CURRENT_SEQUENCE_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
