//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
	"strings"
)

// Flags used to report computer status.
type COMPUTER_STATUS_FLAGS uint64

const (
	// Indicates if the system is experiencing voltage outside of acceptable range.
	COMPUTER_STATUS_FLAGS_UNDER_VOLTAGE COMPUTER_STATUS_FLAGS = 1
	// Indicates if CPU throttling is active.
	COMPUTER_STATUS_FLAGS_CPU_THROTTLE COMPUTER_STATUS_FLAGS = 2
	// Indicates if thermal throttling is active.
	COMPUTER_STATUS_FLAGS_THERMAL_THROTTLE COMPUTER_STATUS_FLAGS = 4
	// Indicates if main disk is full.
	COMPUTER_STATUS_FLAGS_DISK_FULL COMPUTER_STATUS_FLAGS = 8
)

var values_COMPUTER_STATUS_FLAGS = []COMPUTER_STATUS_FLAGS{
	COMPUTER_STATUS_FLAGS_UNDER_VOLTAGE,
	COMPUTER_STATUS_FLAGS_CPU_THROTTLE,
	COMPUTER_STATUS_FLAGS_THERMAL_THROTTLE,
	COMPUTER_STATUS_FLAGS_DISK_FULL,
}

var value_to_label_COMPUTER_STATUS_FLAGS = map[COMPUTER_STATUS_FLAGS]string{
	COMPUTER_STATUS_FLAGS_UNDER_VOLTAGE:    "COMPUTER_STATUS_FLAGS_UNDER_VOLTAGE",
	COMPUTER_STATUS_FLAGS_CPU_THROTTLE:     "COMPUTER_STATUS_FLAGS_CPU_THROTTLE",
	COMPUTER_STATUS_FLAGS_THERMAL_THROTTLE: "COMPUTER_STATUS_FLAGS_THERMAL_THROTTLE",
	COMPUTER_STATUS_FLAGS_DISK_FULL:        "COMPUTER_STATUS_FLAGS_DISK_FULL",
}

var label_to_value_COMPUTER_STATUS_FLAGS = map[string]COMPUTER_STATUS_FLAGS{
	"COMPUTER_STATUS_FLAGS_UNDER_VOLTAGE":    COMPUTER_STATUS_FLAGS_UNDER_VOLTAGE,
	"COMPUTER_STATUS_FLAGS_CPU_THROTTLE":     COMPUTER_STATUS_FLAGS_CPU_THROTTLE,
	"COMPUTER_STATUS_FLAGS_THERMAL_THROTTLE": COMPUTER_STATUS_FLAGS_THERMAL_THROTTLE,
	"COMPUTER_STATUS_FLAGS_DISK_FULL":        COMPUTER_STATUS_FLAGS_DISK_FULL,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e COMPUTER_STATUS_FLAGS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for _, val := range values_COMPUTER_STATUS_FLAGS {
		if e&val == val {
			names = append(names, value_to_label_COMPUTER_STATUS_FLAGS[val])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *COMPUTER_STATUS_FLAGS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask COMPUTER_STATUS_FLAGS
	for _, label := range labels {
		if value, ok := label_to_value_COMPUTER_STATUS_FLAGS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= COMPUTER_STATUS_FLAGS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e COMPUTER_STATUS_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
