//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
	"strings"
)

// Flags for high level gimbal manager operation The first 16 bits are identical to the GIMBAL_DEVICE_FLAGS.
type GIMBAL_MANAGER_FLAGS uint64

const (
	// Based on GIMBAL_DEVICE_FLAGS_RETRACT.
	GIMBAL_MANAGER_FLAGS_RETRACT GIMBAL_MANAGER_FLAGS = 1
	// Based on GIMBAL_DEVICE_FLAGS_NEUTRAL.
	GIMBAL_MANAGER_FLAGS_NEUTRAL GIMBAL_MANAGER_FLAGS = 2
	// Based on GIMBAL_DEVICE_FLAGS_ROLL_LOCK.
	GIMBAL_MANAGER_FLAGS_ROLL_LOCK GIMBAL_MANAGER_FLAGS = 4
	// Based on GIMBAL_DEVICE_FLAGS_PITCH_LOCK.
	GIMBAL_MANAGER_FLAGS_PITCH_LOCK GIMBAL_MANAGER_FLAGS = 8
	// Based on GIMBAL_DEVICE_FLAGS_YAW_LOCK.
	GIMBAL_MANAGER_FLAGS_YAW_LOCK GIMBAL_MANAGER_FLAGS = 16
	// Based on GIMBAL_DEVICE_FLAGS_YAW_IN_VEHICLE_FRAME.
	GIMBAL_MANAGER_FLAGS_YAW_IN_VEHICLE_FRAME GIMBAL_MANAGER_FLAGS = 32
	// Based on GIMBAL_DEVICE_FLAGS_YAW_IN_EARTH_FRAME.
	GIMBAL_MANAGER_FLAGS_YAW_IN_EARTH_FRAME GIMBAL_MANAGER_FLAGS = 64
	// Based on GIMBAL_DEVICE_FLAGS_ACCEPTS_YAW_IN_EARTH_FRAME.
	GIMBAL_MANAGER_FLAGS_ACCEPTS_YAW_IN_EARTH_FRAME GIMBAL_MANAGER_FLAGS = 128
	// Based on GIMBAL_DEVICE_FLAGS_RC_EXCLUSIVE.
	GIMBAL_MANAGER_FLAGS_RC_EXCLUSIVE GIMBAL_MANAGER_FLAGS = 256
	// Based on GIMBAL_DEVICE_FLAGS_RC_MIXED.
	GIMBAL_MANAGER_FLAGS_RC_MIXED GIMBAL_MANAGER_FLAGS = 512
)

var values_GIMBAL_MANAGER_FLAGS = []GIMBAL_MANAGER_FLAGS{
	GIMBAL_MANAGER_FLAGS_RETRACT,
	GIMBAL_MANAGER_FLAGS_NEUTRAL,
	GIMBAL_MANAGER_FLAGS_ROLL_LOCK,
	GIMBAL_MANAGER_FLAGS_PITCH_LOCK,
	GIMBAL_MANAGER_FLAGS_YAW_LOCK,
	GIMBAL_MANAGER_FLAGS_YAW_IN_VEHICLE_FRAME,
	GIMBAL_MANAGER_FLAGS_YAW_IN_EARTH_FRAME,
	GIMBAL_MANAGER_FLAGS_ACCEPTS_YAW_IN_EARTH_FRAME,
	GIMBAL_MANAGER_FLAGS_RC_EXCLUSIVE,
	GIMBAL_MANAGER_FLAGS_RC_MIXED,
}

var value_to_label_GIMBAL_MANAGER_FLAGS = map[GIMBAL_MANAGER_FLAGS]string{
	GIMBAL_MANAGER_FLAGS_RETRACT:                    "GIMBAL_MANAGER_FLAGS_RETRACT",
	GIMBAL_MANAGER_FLAGS_NEUTRAL:                    "GIMBAL_MANAGER_FLAGS_NEUTRAL",
	GIMBAL_MANAGER_FLAGS_ROLL_LOCK:                  "GIMBAL_MANAGER_FLAGS_ROLL_LOCK",
	GIMBAL_MANAGER_FLAGS_PITCH_LOCK:                 "GIMBAL_MANAGER_FLAGS_PITCH_LOCK",
	GIMBAL_MANAGER_FLAGS_YAW_LOCK:                   "GIMBAL_MANAGER_FLAGS_YAW_LOCK",
	GIMBAL_MANAGER_FLAGS_YAW_IN_VEHICLE_FRAME:       "GIMBAL_MANAGER_FLAGS_YAW_IN_VEHICLE_FRAME",
	GIMBAL_MANAGER_FLAGS_YAW_IN_EARTH_FRAME:         "GIMBAL_MANAGER_FLAGS_YAW_IN_EARTH_FRAME",
	GIMBAL_MANAGER_FLAGS_ACCEPTS_YAW_IN_EARTH_FRAME: "GIMBAL_MANAGER_FLAGS_ACCEPTS_YAW_IN_EARTH_FRAME",
	GIMBAL_MANAGER_FLAGS_RC_EXCLUSIVE:               "GIMBAL_MANAGER_FLAGS_RC_EXCLUSIVE",
	GIMBAL_MANAGER_FLAGS_RC_MIXED:                   "GIMBAL_MANAGER_FLAGS_RC_MIXED",
}

var label_to_value_GIMBAL_MANAGER_FLAGS = map[string]GIMBAL_MANAGER_FLAGS{
	"GIMBAL_MANAGER_FLAGS_RETRACT":                    GIMBAL_MANAGER_FLAGS_RETRACT,
	"GIMBAL_MANAGER_FLAGS_NEUTRAL":                    GIMBAL_MANAGER_FLAGS_NEUTRAL,
	"GIMBAL_MANAGER_FLAGS_ROLL_LOCK":                  GIMBAL_MANAGER_FLAGS_ROLL_LOCK,
	"GIMBAL_MANAGER_FLAGS_PITCH_LOCK":                 GIMBAL_MANAGER_FLAGS_PITCH_LOCK,
	"GIMBAL_MANAGER_FLAGS_YAW_LOCK":                   GIMBAL_MANAGER_FLAGS_YAW_LOCK,
	"GIMBAL_MANAGER_FLAGS_YAW_IN_VEHICLE_FRAME":       GIMBAL_MANAGER_FLAGS_YAW_IN_VEHICLE_FRAME,
	"GIMBAL_MANAGER_FLAGS_YAW_IN_EARTH_FRAME":         GIMBAL_MANAGER_FLAGS_YAW_IN_EARTH_FRAME,
	"GIMBAL_MANAGER_FLAGS_ACCEPTS_YAW_IN_EARTH_FRAME": GIMBAL_MANAGER_FLAGS_ACCEPTS_YAW_IN_EARTH_FRAME,
	"GIMBAL_MANAGER_FLAGS_RC_EXCLUSIVE":               GIMBAL_MANAGER_FLAGS_RC_EXCLUSIVE,
	"GIMBAL_MANAGER_FLAGS_RC_MIXED":                   GIMBAL_MANAGER_FLAGS_RC_MIXED,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GIMBAL_MANAGER_FLAGS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for _, val := range values_GIMBAL_MANAGER_FLAGS {
		if e&val == val {
			names = append(names, value_to_label_GIMBAL_MANAGER_FLAGS[val])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GIMBAL_MANAGER_FLAGS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask GIMBAL_MANAGER_FLAGS
	for _, label := range labels {
		if value, ok := label_to_value_GIMBAL_MANAGER_FLAGS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= GIMBAL_MANAGER_FLAGS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e GIMBAL_MANAGER_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
