//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

type MAV_ODID_OPERATOR_LOCATION_TYPE uint64

const (
	// The location/altitude of the operator is the same as the take-off location.
	MAV_ODID_OPERATOR_LOCATION_TYPE_TAKEOFF MAV_ODID_OPERATOR_LOCATION_TYPE = 0
	// The location/altitude of the operator is dynamic. E.g. based on live GNSS data.
	MAV_ODID_OPERATOR_LOCATION_TYPE_LIVE_GNSS MAV_ODID_OPERATOR_LOCATION_TYPE = 1
	// The location/altitude of the operator are fixed values.
	MAV_ODID_OPERATOR_LOCATION_TYPE_FIXED MAV_ODID_OPERATOR_LOCATION_TYPE = 2
)

var value_to_label_MAV_ODID_OPERATOR_LOCATION_TYPE = map[MAV_ODID_OPERATOR_LOCATION_TYPE]string{
	MAV_ODID_OPERATOR_LOCATION_TYPE_TAKEOFF:   "MAV_ODID_OPERATOR_LOCATION_TYPE_TAKEOFF",
	MAV_ODID_OPERATOR_LOCATION_TYPE_LIVE_GNSS: "MAV_ODID_OPERATOR_LOCATION_TYPE_LIVE_GNSS",
	MAV_ODID_OPERATOR_LOCATION_TYPE_FIXED:     "MAV_ODID_OPERATOR_LOCATION_TYPE_FIXED",
}

var label_to_value_MAV_ODID_OPERATOR_LOCATION_TYPE = map[string]MAV_ODID_OPERATOR_LOCATION_TYPE{
	"MAV_ODID_OPERATOR_LOCATION_TYPE_TAKEOFF":   MAV_ODID_OPERATOR_LOCATION_TYPE_TAKEOFF,
	"MAV_ODID_OPERATOR_LOCATION_TYPE_LIVE_GNSS": MAV_ODID_OPERATOR_LOCATION_TYPE_LIVE_GNSS,
	"MAV_ODID_OPERATOR_LOCATION_TYPE_FIXED":     MAV_ODID_OPERATOR_LOCATION_TYPE_FIXED,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_ODID_OPERATOR_LOCATION_TYPE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MAV_ODID_OPERATOR_LOCATION_TYPE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_ODID_OPERATOR_LOCATION_TYPE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MAV_ODID_OPERATOR_LOCATION_TYPE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_ODID_OPERATOR_LOCATION_TYPE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_ODID_OPERATOR_LOCATION_TYPE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
