//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package development

import (
	"fmt"
	"strconv"
)

// State of RAIM processing.
type GPS_RAIM_STATE uint64

const (
	// RAIM capability is unknown.
	GPS_RAIM_STATE_UNKNOWN GPS_RAIM_STATE = 0
	// RAIM is disabled.
	GPS_RAIM_STATE_DISABLED GPS_RAIM_STATE = 1
	// RAIM integrity check was successful.
	GPS_RAIM_STATE_OK GPS_RAIM_STATE = 2
	// RAIM integrity check failed.
	GPS_RAIM_STATE_FAILED GPS_RAIM_STATE = 3
)

var value_to_label_GPS_RAIM_STATE = map[GPS_RAIM_STATE]string{
	GPS_RAIM_STATE_UNKNOWN:  "GPS_RAIM_STATE_UNKNOWN",
	GPS_RAIM_STATE_DISABLED: "GPS_RAIM_STATE_DISABLED",
	GPS_RAIM_STATE_OK:       "GPS_RAIM_STATE_OK",
	GPS_RAIM_STATE_FAILED:   "GPS_RAIM_STATE_FAILED",
}

var label_to_value_GPS_RAIM_STATE = map[string]GPS_RAIM_STATE{
	"GPS_RAIM_STATE_UNKNOWN":  GPS_RAIM_STATE_UNKNOWN,
	"GPS_RAIM_STATE_DISABLED": GPS_RAIM_STATE_DISABLED,
	"GPS_RAIM_STATE_OK":       GPS_RAIM_STATE_OK,
	"GPS_RAIM_STATE_FAILED":   GPS_RAIM_STATE_FAILED,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GPS_RAIM_STATE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_GPS_RAIM_STATE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GPS_RAIM_STATE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_GPS_RAIM_STATE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = GPS_RAIM_STATE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e GPS_RAIM_STATE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
