//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package loweheiser

import (
	"fmt"
	"strconv"
)

type MAV_CMD uint64

const (
	// Set Loweheiser desired states
	MAV_CMD_LOWEHEISER_SET_STATE MAV_CMD = 10151
)

var value_to_label_MAV_CMD = map[MAV_CMD]string{
	MAV_CMD_LOWEHEISER_SET_STATE: "MAV_CMD_LOWEHEISER_SET_STATE",
}

var label_to_value_MAV_CMD = map[string]MAV_CMD{
	"MAV_CMD_LOWEHEISER_SET_STATE": MAV_CMD_LOWEHEISER_SET_STATE,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_CMD) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MAV_CMD[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_CMD) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MAV_CMD[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_CMD(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_CMD) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
