//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package minimal

import (
	"fmt"
	"strconv"
)

// MAVLINK component type reported in HEARTBEAT message. Flight controllers must report the type of the vehicle on which they are mounted (e.g. MAV_TYPE_OCTOROTOR). All other components must report a value appropriate for their type (e.g. a camera must use MAV_TYPE_CAMERA).
type MAV_TYPE uint64

const (
	// Generic micro air vehicle
	MAV_TYPE_GENERIC MAV_TYPE = 0
	// Fixed wing aircraft.
	MAV_TYPE_FIXED_WING MAV_TYPE = 1
	// Quadrotor
	MAV_TYPE_QUADROTOR MAV_TYPE = 2
	// Coaxial helicopter
	MAV_TYPE_COAXIAL MAV_TYPE = 3
	// Normal helicopter with tail rotor.
	MAV_TYPE_HELICOPTER MAV_TYPE = 4
	// Ground installation
	MAV_TYPE_ANTENNA_TRACKER MAV_TYPE = 5
	// Operator control unit / ground control station
	MAV_TYPE_GCS MAV_TYPE = 6
	// Airship, controlled
	MAV_TYPE_AIRSHIP MAV_TYPE = 7
	// Free balloon, uncontrolled
	MAV_TYPE_FREE_BALLOON MAV_TYPE = 8
	// Rocket
	MAV_TYPE_ROCKET MAV_TYPE = 9
	// Ground rover
	MAV_TYPE_GROUND_ROVER MAV_TYPE = 10
	// Surface vessel, boat, ship
	MAV_TYPE_SURFACE_BOAT MAV_TYPE = 11
	// Submarine
	MAV_TYPE_SUBMARINE MAV_TYPE = 12
	// Hexarotor
	MAV_TYPE_HEXAROTOR MAV_TYPE = 13
	// Octorotor
	MAV_TYPE_OCTOROTOR MAV_TYPE = 14
	// Tricopter
	MAV_TYPE_TRICOPTER MAV_TYPE = 15
	// Flapping wing
	MAV_TYPE_FLAPPING_WING MAV_TYPE = 16
	// Kite
	MAV_TYPE_KITE MAV_TYPE = 17
	// Onboard companion controller
	MAV_TYPE_ONBOARD_CONTROLLER MAV_TYPE = 18
	// Two-rotor Tailsitter VTOL that additionally uses control surfaces in vertical operation. Note, value previously named MAV_TYPE_VTOL_DUOROTOR.
	MAV_TYPE_VTOL_TAILSITTER_DUOROTOR MAV_TYPE = 19
	// Quad-rotor Tailsitter VTOL using a V-shaped quad config in vertical operation. Note: value previously named MAV_TYPE_VTOL_QUADROTOR.
	MAV_TYPE_VTOL_TAILSITTER_QUADROTOR MAV_TYPE = 20
	// Tiltrotor VTOL. Fuselage and wings stay (nominally) horizontal in all flight phases. It able to tilt (some) rotors to provide thrust in cruise flight.
	MAV_TYPE_VTOL_TILTROTOR MAV_TYPE = 21
	// VTOL with separate fixed rotors for hover and cruise flight. Fuselage and wings stay (nominally) horizontal in all flight phases.
	MAV_TYPE_VTOL_FIXEDROTOR MAV_TYPE = 22
	// Tailsitter VTOL. Fuselage and wings orientation changes depending on flight phase: vertical for hover, horizontal for cruise. Use more specific VTOL MAV_TYPE_VTOL_TAILSITTER_DUOROTOR or MAV_TYPE_VTOL_TAILSITTER_QUADROTOR if appropriate.
	MAV_TYPE_VTOL_TAILSITTER MAV_TYPE = 23
	// Tiltwing VTOL. Fuselage stays horizontal in all flight phases. The whole wing, along with any attached engine, can tilt between vertical and horizontal mode.
	MAV_TYPE_VTOL_TILTWING MAV_TYPE = 24
	// VTOL reserved 5
	MAV_TYPE_VTOL_RESERVED5 MAV_TYPE = 25
	// Gimbal
	MAV_TYPE_GIMBAL MAV_TYPE = 26
	// ADSB system
	MAV_TYPE_ADSB MAV_TYPE = 27
	// Steerable, nonrigid airfoil
	MAV_TYPE_PARAFOIL MAV_TYPE = 28
	// Dodecarotor
	MAV_TYPE_DODECAROTOR MAV_TYPE = 29
	// Camera
	MAV_TYPE_CAMERA MAV_TYPE = 30
	// Charging station
	MAV_TYPE_CHARGING_STATION MAV_TYPE = 31
	// FLARM collision avoidance system
	MAV_TYPE_FLARM MAV_TYPE = 32
	// Servo
	MAV_TYPE_SERVO MAV_TYPE = 33
	// Open Drone ID. See https://mavlink.io/en/services/opendroneid.html.
	MAV_TYPE_ODID MAV_TYPE = 34
	// Decarotor
	MAV_TYPE_DECAROTOR MAV_TYPE = 35
	// Battery
	MAV_TYPE_BATTERY MAV_TYPE = 36
	// Parachute
	MAV_TYPE_PARACHUTE MAV_TYPE = 37
	// Log
	MAV_TYPE_LOG MAV_TYPE = 38
	// OSD
	MAV_TYPE_OSD MAV_TYPE = 39
	// IMU
	MAV_TYPE_IMU MAV_TYPE = 40
	// GPS
	MAV_TYPE_GPS MAV_TYPE = 41
	// Winch
	MAV_TYPE_WINCH MAV_TYPE = 42
	// Generic multirotor that does not fit into a specific type or whose type is unknown
	MAV_TYPE_GENERIC_MULTIROTOR MAV_TYPE = 43
	// Illuminator. An illuminator is a light source that is used for lighting up dark areas external to the system: e.g. a torch or searchlight (as opposed to a light source for illuminating the system itself, e.g. an indicator light).
	MAV_TYPE_ILLUMINATOR MAV_TYPE = 44
	// Orbiter spacecraft. Includes satellites orbiting terrestrial and extra-terrestrial bodies. Follows NASA Spacecraft Classification.
	MAV_TYPE_SPACECRAFT_ORBITER MAV_TYPE = 45
	// A generic four-legged ground vehicle (e.g., a robot dog).
	MAV_TYPE_GROUND_QUADRUPED MAV_TYPE = 46
	// VTOL hybrid of helicopter and autogyro. It has a main rotor for lift and separate propellers for forward flight. The rotor must be powered for hover but can autorotate in cruise flight. See: https://en.wikipedia.org/wiki/Gyrodyne
	MAV_TYPE_VTOL_GYRODYNE MAV_TYPE = 47
	// Gripper
	MAV_TYPE_GRIPPER MAV_TYPE = 48
	// Radio
	MAV_TYPE_RADIO MAV_TYPE = 49
)

var value_to_label_MAV_TYPE = map[MAV_TYPE]string{
	MAV_TYPE_GENERIC:                   "MAV_TYPE_GENERIC",
	MAV_TYPE_FIXED_WING:                "MAV_TYPE_FIXED_WING",
	MAV_TYPE_QUADROTOR:                 "MAV_TYPE_QUADROTOR",
	MAV_TYPE_COAXIAL:                   "MAV_TYPE_COAXIAL",
	MAV_TYPE_HELICOPTER:                "MAV_TYPE_HELICOPTER",
	MAV_TYPE_ANTENNA_TRACKER:           "MAV_TYPE_ANTENNA_TRACKER",
	MAV_TYPE_GCS:                       "MAV_TYPE_GCS",
	MAV_TYPE_AIRSHIP:                   "MAV_TYPE_AIRSHIP",
	MAV_TYPE_FREE_BALLOON:              "MAV_TYPE_FREE_BALLOON",
	MAV_TYPE_ROCKET:                    "MAV_TYPE_ROCKET",
	MAV_TYPE_GROUND_ROVER:              "MAV_TYPE_GROUND_ROVER",
	MAV_TYPE_SURFACE_BOAT:              "MAV_TYPE_SURFACE_BOAT",
	MAV_TYPE_SUBMARINE:                 "MAV_TYPE_SUBMARINE",
	MAV_TYPE_HEXAROTOR:                 "MAV_TYPE_HEXAROTOR",
	MAV_TYPE_OCTOROTOR:                 "MAV_TYPE_OCTOROTOR",
	MAV_TYPE_TRICOPTER:                 "MAV_TYPE_TRICOPTER",
	MAV_TYPE_FLAPPING_WING:             "MAV_TYPE_FLAPPING_WING",
	MAV_TYPE_KITE:                      "MAV_TYPE_KITE",
	MAV_TYPE_ONBOARD_CONTROLLER:        "MAV_TYPE_ONBOARD_CONTROLLER",
	MAV_TYPE_VTOL_TAILSITTER_DUOROTOR:  "MAV_TYPE_VTOL_TAILSITTER_DUOROTOR",
	MAV_TYPE_VTOL_TAILSITTER_QUADROTOR: "MAV_TYPE_VTOL_TAILSITTER_QUADROTOR",
	MAV_TYPE_VTOL_TILTROTOR:            "MAV_TYPE_VTOL_TILTROTOR",
	MAV_TYPE_VTOL_FIXEDROTOR:           "MAV_TYPE_VTOL_FIXEDROTOR",
	MAV_TYPE_VTOL_TAILSITTER:           "MAV_TYPE_VTOL_TAILSITTER",
	MAV_TYPE_VTOL_TILTWING:             "MAV_TYPE_VTOL_TILTWING",
	MAV_TYPE_VTOL_RESERVED5:            "MAV_TYPE_VTOL_RESERVED5",
	MAV_TYPE_GIMBAL:                    "MAV_TYPE_GIMBAL",
	MAV_TYPE_ADSB:                      "MAV_TYPE_ADSB",
	MAV_TYPE_PARAFOIL:                  "MAV_TYPE_PARAFOIL",
	MAV_TYPE_DODECAROTOR:               "MAV_TYPE_DODECAROTOR",
	MAV_TYPE_CAMERA:                    "MAV_TYPE_CAMERA",
	MAV_TYPE_CHARGING_STATION:          "MAV_TYPE_CHARGING_STATION",
	MAV_TYPE_FLARM:                     "MAV_TYPE_FLARM",
	MAV_TYPE_SERVO:                     "MAV_TYPE_SERVO",
	MAV_TYPE_ODID:                      "MAV_TYPE_ODID",
	MAV_TYPE_DECAROTOR:                 "MAV_TYPE_DECAROTOR",
	MAV_TYPE_BATTERY:                   "MAV_TYPE_BATTERY",
	MAV_TYPE_PARACHUTE:                 "MAV_TYPE_PARACHUTE",
	MAV_TYPE_LOG:                       "MAV_TYPE_LOG",
	MAV_TYPE_OSD:                       "MAV_TYPE_OSD",
	MAV_TYPE_IMU:                       "MAV_TYPE_IMU",
	MAV_TYPE_GPS:                       "MAV_TYPE_GPS",
	MAV_TYPE_WINCH:                     "MAV_TYPE_WINCH",
	MAV_TYPE_GENERIC_MULTIROTOR:        "MAV_TYPE_GENERIC_MULTIROTOR",
	MAV_TYPE_ILLUMINATOR:               "MAV_TYPE_ILLUMINATOR",
	MAV_TYPE_SPACECRAFT_ORBITER:        "MAV_TYPE_SPACECRAFT_ORBITER",
	MAV_TYPE_GROUND_QUADRUPED:          "MAV_TYPE_GROUND_QUADRUPED",
	MAV_TYPE_VTOL_GYRODYNE:             "MAV_TYPE_VTOL_GYRODYNE",
	MAV_TYPE_GRIPPER:                   "MAV_TYPE_GRIPPER",
	MAV_TYPE_RADIO:                     "MAV_TYPE_RADIO",
}

var label_to_value_MAV_TYPE = map[string]MAV_TYPE{
	"MAV_TYPE_GENERIC":                   MAV_TYPE_GENERIC,
	"MAV_TYPE_FIXED_WING":                MAV_TYPE_FIXED_WING,
	"MAV_TYPE_QUADROTOR":                 MAV_TYPE_QUADROTOR,
	"MAV_TYPE_COAXIAL":                   MAV_TYPE_COAXIAL,
	"MAV_TYPE_HELICOPTER":                MAV_TYPE_HELICOPTER,
	"MAV_TYPE_ANTENNA_TRACKER":           MAV_TYPE_ANTENNA_TRACKER,
	"MAV_TYPE_GCS":                       MAV_TYPE_GCS,
	"MAV_TYPE_AIRSHIP":                   MAV_TYPE_AIRSHIP,
	"MAV_TYPE_FREE_BALLOON":              MAV_TYPE_FREE_BALLOON,
	"MAV_TYPE_ROCKET":                    MAV_TYPE_ROCKET,
	"MAV_TYPE_GROUND_ROVER":              MAV_TYPE_GROUND_ROVER,
	"MAV_TYPE_SURFACE_BOAT":              MAV_TYPE_SURFACE_BOAT,
	"MAV_TYPE_SUBMARINE":                 MAV_TYPE_SUBMARINE,
	"MAV_TYPE_HEXAROTOR":                 MAV_TYPE_HEXAROTOR,
	"MAV_TYPE_OCTOROTOR":                 MAV_TYPE_OCTOROTOR,
	"MAV_TYPE_TRICOPTER":                 MAV_TYPE_TRICOPTER,
	"MAV_TYPE_FLAPPING_WING":             MAV_TYPE_FLAPPING_WING,
	"MAV_TYPE_KITE":                      MAV_TYPE_KITE,
	"MAV_TYPE_ONBOARD_CONTROLLER":        MAV_TYPE_ONBOARD_CONTROLLER,
	"MAV_TYPE_VTOL_TAILSITTER_DUOROTOR":  MAV_TYPE_VTOL_TAILSITTER_DUOROTOR,
	"MAV_TYPE_VTOL_TAILSITTER_QUADROTOR": MAV_TYPE_VTOL_TAILSITTER_QUADROTOR,
	"MAV_TYPE_VTOL_TILTROTOR":            MAV_TYPE_VTOL_TILTROTOR,
	"MAV_TYPE_VTOL_FIXEDROTOR":           MAV_TYPE_VTOL_FIXEDROTOR,
	"MAV_TYPE_VTOL_TAILSITTER":           MAV_TYPE_VTOL_TAILSITTER,
	"MAV_TYPE_VTOL_TILTWING":             MAV_TYPE_VTOL_TILTWING,
	"MAV_TYPE_VTOL_RESERVED5":            MAV_TYPE_VTOL_RESERVED5,
	"MAV_TYPE_GIMBAL":                    MAV_TYPE_GIMBAL,
	"MAV_TYPE_ADSB":                      MAV_TYPE_ADSB,
	"MAV_TYPE_PARAFOIL":                  MAV_TYPE_PARAFOIL,
	"MAV_TYPE_DODECAROTOR":               MAV_TYPE_DODECAROTOR,
	"MAV_TYPE_CAMERA":                    MAV_TYPE_CAMERA,
	"MAV_TYPE_CHARGING_STATION":          MAV_TYPE_CHARGING_STATION,
	"MAV_TYPE_FLARM":                     MAV_TYPE_FLARM,
	"MAV_TYPE_SERVO":                     MAV_TYPE_SERVO,
	"MAV_TYPE_ODID":                      MAV_TYPE_ODID,
	"MAV_TYPE_DECAROTOR":                 MAV_TYPE_DECAROTOR,
	"MAV_TYPE_BATTERY":                   MAV_TYPE_BATTERY,
	"MAV_TYPE_PARACHUTE":                 MAV_TYPE_PARACHUTE,
	"MAV_TYPE_LOG":                       MAV_TYPE_LOG,
	"MAV_TYPE_OSD":                       MAV_TYPE_OSD,
	"MAV_TYPE_IMU":                       MAV_TYPE_IMU,
	"MAV_TYPE_GPS":                       MAV_TYPE_GPS,
	"MAV_TYPE_WINCH":                     MAV_TYPE_WINCH,
	"MAV_TYPE_GENERIC_MULTIROTOR":        MAV_TYPE_GENERIC_MULTIROTOR,
	"MAV_TYPE_ILLUMINATOR":               MAV_TYPE_ILLUMINATOR,
	"MAV_TYPE_SPACECRAFT_ORBITER":        MAV_TYPE_SPACECRAFT_ORBITER,
	"MAV_TYPE_GROUND_QUADRUPED":          MAV_TYPE_GROUND_QUADRUPED,
	"MAV_TYPE_VTOL_GYRODYNE":             MAV_TYPE_VTOL_GYRODYNE,
	"MAV_TYPE_GRIPPER":                   MAV_TYPE_GRIPPER,
	"MAV_TYPE_RADIO":                     MAV_TYPE_RADIO,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_TYPE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MAV_TYPE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_TYPE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MAV_TYPE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_TYPE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_TYPE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
