/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// RequestStatusMetadata struct for RequestStatusMetadata
type RequestStatusMetadata struct {
	// Resource's Entity Tag as defined in http://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.11  Entity Tag is also added as an 'ETag response header to requests which don't use 'depth' parameter.
	Etag    *string          `json:"etag,omitempty"`
	Message *string          `json:"message,omitempty"`
	Status  *string          `json:"status,omitempty"`
	Targets *[]RequestTarget `json:"targets,omitempty"`
}

// NewRequestStatusMetadata instantiates a new RequestStatusMetadata object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRequestStatusMetadata() *RequestStatusMetadata {
	this := RequestStatusMetadata{}

	return &this
}

// NewRequestStatusMetadataWithDefaults instantiates a new RequestStatusMetadata object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRequestStatusMetadataWithDefaults() *RequestStatusMetadata {
	this := RequestStatusMetadata{}
	return &this
}

// GetEtag returns the Etag field value
// If the value is explicit nil, nil is returned
func (o *RequestStatusMetadata) GetEtag() *string {
	if o == nil {
		return nil
	}

	return o.Etag

}

// GetEtagOk returns a tuple with the Etag field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RequestStatusMetadata) GetEtagOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Etag, true
}

// SetEtag sets field value
func (o *RequestStatusMetadata) SetEtag(v string) {

	o.Etag = &v

}

// HasEtag returns a boolean if a field has been set.
func (o *RequestStatusMetadata) HasEtag() bool {
	if o != nil && o.Etag != nil {
		return true
	}

	return false
}

// GetMessage returns the Message field value
// If the value is explicit nil, nil is returned
func (o *RequestStatusMetadata) GetMessage() *string {
	if o == nil {
		return nil
	}

	return o.Message

}

// GetMessageOk returns a tuple with the Message field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RequestStatusMetadata) GetMessageOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Message, true
}

// SetMessage sets field value
func (o *RequestStatusMetadata) SetMessage(v string) {

	o.Message = &v

}

// HasMessage returns a boolean if a field has been set.
func (o *RequestStatusMetadata) HasMessage() bool {
	if o != nil && o.Message != nil {
		return true
	}

	return false
}

// GetStatus returns the Status field value
// If the value is explicit nil, nil is returned
func (o *RequestStatusMetadata) GetStatus() *string {
	if o == nil {
		return nil
	}

	return o.Status

}

// GetStatusOk returns a tuple with the Status field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RequestStatusMetadata) GetStatusOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Status, true
}

// SetStatus sets field value
func (o *RequestStatusMetadata) SetStatus(v string) {

	o.Status = &v

}

// HasStatus returns a boolean if a field has been set.
func (o *RequestStatusMetadata) HasStatus() bool {
	if o != nil && o.Status != nil {
		return true
	}

	return false
}

// GetTargets returns the Targets field value
// If the value is explicit nil, nil is returned
func (o *RequestStatusMetadata) GetTargets() *[]RequestTarget {
	if o == nil {
		return nil
	}

	return o.Targets

}

// GetTargetsOk returns a tuple with the Targets field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RequestStatusMetadata) GetTargetsOk() (*[]RequestTarget, bool) {
	if o == nil {
		return nil, false
	}

	return o.Targets, true
}

// SetTargets sets field value
func (o *RequestStatusMetadata) SetTargets(v []RequestTarget) {

	o.Targets = &v

}

// HasTargets returns a boolean if a field has been set.
func (o *RequestStatusMetadata) HasTargets() bool {
	if o != nil && o.Targets != nil {
		return true
	}

	return false
}

func (o RequestStatusMetadata) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Etag != nil {
		toSerialize["etag"] = o.Etag
	}

	if o.Message != nil {
		toSerialize["message"] = o.Message
	}

	if o.Status != nil {
		toSerialize["status"] = o.Status
	}

	if o.Targets != nil {
		toSerialize["targets"] = o.Targets
	}

	return json.Marshal(toSerialize)
}

type NullableRequestStatusMetadata struct {
	value *RequestStatusMetadata
	isSet bool
}

func (v NullableRequestStatusMetadata) Get() *RequestStatusMetadata {
	return v.value
}

func (v *NullableRequestStatusMetadata) Set(val *RequestStatusMetadata) {
	v.value = val
	v.isSet = true
}

func (v NullableRequestStatusMetadata) IsSet() bool {
	return v.isSet
}

func (v *NullableRequestStatusMetadata) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRequestStatusMetadata(val *RequestStatusMetadata) *NullableRequestStatusMetadata {
	return &NullableRequestStatusMetadata{value: val, isSet: true}
}

func (v NullableRequestStatusMetadata) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRequestStatusMetadata) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
