/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// KubernetesNodePoolLan struct for KubernetesNodePoolLan
type KubernetesNodePoolLan struct {
	// The datacenter ID, requires system privileges, for internal usage only
	DatacenterId *string `json:"datacenterId,omitempty"`
	// Specifies whether the Kubernetes node pool LAN reserves an IP with DHCP.
	Dhcp *bool `json:"dhcp,omitempty"`
	// The LAN ID of an existing LAN at the related data center
	Id *int32 `json:"id"`
	// The array of additional LANs attached to worker nodes.
	Routes *[]KubernetesNodePoolLanRoutes `json:"routes,omitempty"`
}

// NewKubernetesNodePoolLan instantiates a new KubernetesNodePoolLan object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewKubernetesNodePoolLan(id int32) *KubernetesNodePoolLan {
	this := KubernetesNodePoolLan{}

	this.Id = &id

	return &this
}

// NewKubernetesNodePoolLanWithDefaults instantiates a new KubernetesNodePoolLan object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewKubernetesNodePoolLanWithDefaults() *KubernetesNodePoolLan {
	this := KubernetesNodePoolLan{}
	return &this
}

// GetDatacenterId returns the DatacenterId field value
// If the value is explicit nil, nil is returned
func (o *KubernetesNodePoolLan) GetDatacenterId() *string {
	if o == nil {
		return nil
	}

	return o.DatacenterId

}

// GetDatacenterIdOk returns a tuple with the DatacenterId field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *KubernetesNodePoolLan) GetDatacenterIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.DatacenterId, true
}

// SetDatacenterId sets field value
func (o *KubernetesNodePoolLan) SetDatacenterId(v string) {

	o.DatacenterId = &v

}

// HasDatacenterId returns a boolean if a field has been set.
func (o *KubernetesNodePoolLan) HasDatacenterId() bool {
	if o != nil && o.DatacenterId != nil {
		return true
	}

	return false
}

// GetDhcp returns the Dhcp field value
// If the value is explicit nil, nil is returned
func (o *KubernetesNodePoolLan) GetDhcp() *bool {
	if o == nil {
		return nil
	}

	return o.Dhcp

}

// GetDhcpOk returns a tuple with the Dhcp field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *KubernetesNodePoolLan) GetDhcpOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}

	return o.Dhcp, true
}

// SetDhcp sets field value
func (o *KubernetesNodePoolLan) SetDhcp(v bool) {

	o.Dhcp = &v

}

// HasDhcp returns a boolean if a field has been set.
func (o *KubernetesNodePoolLan) HasDhcp() bool {
	if o != nil && o.Dhcp != nil {
		return true
	}

	return false
}

// GetId returns the Id field value
// If the value is explicit nil, nil is returned
func (o *KubernetesNodePoolLan) GetId() *int32 {
	if o == nil {
		return nil
	}

	return o.Id

}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *KubernetesNodePoolLan) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.Id, true
}

// SetId sets field value
func (o *KubernetesNodePoolLan) SetId(v int32) {

	o.Id = &v

}

// HasId returns a boolean if a field has been set.
func (o *KubernetesNodePoolLan) HasId() bool {
	if o != nil && o.Id != nil {
		return true
	}

	return false
}

// GetRoutes returns the Routes field value
// If the value is explicit nil, nil is returned
func (o *KubernetesNodePoolLan) GetRoutes() *[]KubernetesNodePoolLanRoutes {
	if o == nil {
		return nil
	}

	return o.Routes

}

// GetRoutesOk returns a tuple with the Routes field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *KubernetesNodePoolLan) GetRoutesOk() (*[]KubernetesNodePoolLanRoutes, bool) {
	if o == nil {
		return nil, false
	}

	return o.Routes, true
}

// SetRoutes sets field value
func (o *KubernetesNodePoolLan) SetRoutes(v []KubernetesNodePoolLanRoutes) {

	o.Routes = &v

}

// HasRoutes returns a boolean if a field has been set.
func (o *KubernetesNodePoolLan) HasRoutes() bool {
	if o != nil && o.Routes != nil {
		return true
	}

	return false
}

func (o KubernetesNodePoolLan) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.DatacenterId != nil {
		toSerialize["datacenterId"] = o.DatacenterId
	}

	if o.Dhcp != nil {
		toSerialize["dhcp"] = o.Dhcp
	}

	if o.Id != nil {
		toSerialize["id"] = o.Id
	}

	if o.Routes != nil {
		toSerialize["routes"] = o.Routes
	}

	return json.Marshal(toSerialize)
}

type NullableKubernetesNodePoolLan struct {
	value *KubernetesNodePoolLan
	isSet bool
}

func (v NullableKubernetesNodePoolLan) Get() *KubernetesNodePoolLan {
	return v.value
}

func (v *NullableKubernetesNodePoolLan) Set(val *KubernetesNodePoolLan) {
	v.value = val
	v.isSet = true
}

func (v NullableKubernetesNodePoolLan) IsSet() bool {
	return v.isSet
}

func (v *NullableKubernetesNodePoolLan) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableKubernetesNodePoolLan(val *KubernetesNodePoolLan) *NullableKubernetesNodePoolLan {
	return &NullableKubernetesNodePoolLan{value: val, isSet: true}
}

func (v NullableKubernetesNodePoolLan) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableKubernetesNodePoolLan) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
