package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// CreateResolveTaskParam 生成短链的参数对象。
type CreateResolveTaskParam struct {

	// 创建解析任务时填写用户唯一标识，手机号码或者任何的唯一标识，唯一标识不超过64个字符。 发送智能信息时则必须填客户的手机号码。样例为：130****0001。
	CustFlag string `json:"cust_flag"`

	// 动态参数。  > 使用动态参数模板时，aim_code_type字段只能为individual。
	DyncParams map[string]string `json:"dync_params,omitempty"`

	// 自定义跳转地址。长度要求不超过2048。 > - 未填时，终端用户点击短信原文中的短链后，跳转智能信息模板H5页 > - 已填时，终端用户点击短信原文中的短链后，跳转该字段对应的页面，填写时必须为http或https作为前缀 > - 使用自定义跳转链接功能请联系KooMessage运营人员进行域名备案 > - 自定义短码时即generation_type为2时不支持自定义跳转链接功能，传入的参数值无效
	CustomUrl *string `json:"custom_url,omitempty"`

	// 自定义短码，支持长度为3到10位的数字或大小写字母。样例为：aDC123。 > 自定义短码时即generation_type为2时，此参数为必填。
	CustomShortCode *string `json:"custom_short_code,omitempty"`

	// 短信模板参数。 - 短信模板中的变量类型可以是：短链、电话号码、其他号码（验证码、订单号、密码等）、日期时间、金额、其他（名称、账号、地址等）。 - 字符串数组，最多19个。 - 数组中参数按短信模板中除了短链类型参数外的变量的顺序进行匹配，比如短信模板内容中按顺序有3个变量：${1}、${2}、${3}，其中${1}表示手机号码，${2}表示短链，${3}表示日期，则sms_params传的是：[手机号码, 日期]。 - 如果短信模板只包含短链1个参数，则sms_params传空数组。 - 电话号码长度限制1-15个字符，可以传入手机号、座机号、95或400、800电话等。 - 其他号码长度限制1-20个字符，不允许出现手机号、QQ号、微信号、URL等联系方式，仅支持大小写字母和数字组合。 - 时间长度限制1-20个字符，日期格式：yyyyMMdd、yyyy-MM-dd、yyyy/MM/dd、yyyy年mm月dd日，时间格式：HH:mm:ss、HH:mm、HH点mm分、HH点mm。如果需要同时指定日期和时间，请在模板中填充两个变量，一个变量传入日期，另一个变量传入时间。 - 金额长度限制1-20个字符，仅支持传入能够正常表达金额的数字、小数点或中文，例如壹、贰、叁、肆等，支持传入IP地址，例如：10.1.1.10。￥$等货币符号需要放在模板中，不支持变量传入。 - 其他长度限制1-20个字符，可以设置为公司/产品/地址/姓名/内容/账号/会员名等。不允许出现QQ号/微信号（公众号）/手机号/网址/座机号等联系方式。如果确有需要，请将联系方式放入模板中，不允许在传入值中携带“.”、“。”、“'”、“<”、“>”、“{”或“}”。否则，可能导致模板变量解析异常。不允许在传入值中携带“.”，即不支持传入IP地址，如变量取值为IP地址，请申请模板时选择变量属性为“金额”。
	SmsParams *[]string `json:"sms_params,omitempty"`
}

func (o CreateResolveTaskParam) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "CreateResolveTaskParam struct{}"
	}

	return strings.Join([]string{"CreateResolveTaskParam", string(data)}, " ")
}
