// Code generated by smithy-go-codegen DO NOT EDIT.

package signin

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/signin/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpCreateOAuth2Token struct {
}

func (*awsRestjson1_serializeOpCreateOAuth2Token) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateOAuth2Token) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateOAuth2TokenInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/token")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.TokenInput != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentCreateOAuth2TokenRequestBody(input.TokenInput, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateOAuth2TokenInput(v *CreateOAuth2TokenInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateOAuth2TokenRequestBody(v *types.CreateOAuth2TokenRequestBody, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientId != nil {
		ok := object.Key("clientId")
		ok.String(*v.ClientId)
	}

	if v.Code != nil {
		ok := object.Key("code")
		ok.String(*v.Code)
	}

	if v.CodeVerifier != nil {
		ok := object.Key("codeVerifier")
		ok.String(*v.CodeVerifier)
	}

	if v.GrantType != nil {
		ok := object.Key("grantType")
		ok.String(*v.GrantType)
	}

	if v.RedirectUri != nil {
		ok := object.Key("redirectUri")
		ok.String(*v.RedirectUri)
	}

	if v.RefreshToken != nil {
		ok := object.Key("refreshToken")
		ok.String(*v.RefreshToken)
	}

	return nil
}
