// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package discoveryengine provides access to the Discovery Engine API.
//
// For product documentation, see: https://cloud.google.com/generative-ai-app-builder/docs/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/discoveryengine/v1"
//	...
//	ctx := context.Background()
//	discoveryengineService, err := discoveryengine.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	discoveryengineService, err := discoveryengine.NewService(ctx, option.WithScopes(discoveryengine.DiscoveryengineReadwriteScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	discoveryengineService, err := discoveryengine.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	discoveryengineService, err := discoveryengine.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package discoveryengine // import "google.golang.org/api/discoveryengine/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "discoveryengine:v1"
const apiName = "discoveryengine"
const apiVersion = "v1"
const basePath = "https://discoveryengine.googleapis.com/"
const basePathTemplate = "https://discoveryengine.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://discoveryengine.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// Search your organization's data in the Cloud Search index
	CloudSearchQueryScope = "https://www.googleapis.com/auth/cloud_search.query"

	// View your Agentspace chat history, including uploaded files and generated
	// reports and visualizations, and interact with the Agentspace assistant on
	// your behalf.
	DiscoveryengineAssistReadwriteScope = "https://www.googleapis.com/auth/discoveryengine.assist.readwrite"

	// View, edit, create, and delete all your data associated with any Discovery
	// Engine API product, such as Agentspace, Vertex AI Search, or NotebookLM
	// Enterprise, including both end user data and administration or configuration
	// data.
	DiscoveryengineReadwriteScope = "https://www.googleapis.com/auth/discoveryengine.readwrite"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/cloud_search.query",
		"https://www.googleapis.com/auth/discoveryengine.assist.readwrite",
		"https://www.googleapis.com/auth/discoveryengine.readwrite",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Media = NewMediaService(s)
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Media *MediaService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewMediaService(s *Service) *MediaService {
	rs := &MediaService{s: s}
	return rs
}

type MediaService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	rs.Operations = NewProjectsOperationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService

	Operations *ProjectsOperationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.CmekConfigs = NewProjectsLocationsCmekConfigsService(s)
	rs.Collections = NewProjectsLocationsCollectionsService(s)
	rs.DataStores = NewProjectsLocationsDataStoresService(s)
	rs.GroundingConfigs = NewProjectsLocationsGroundingConfigsService(s)
	rs.IdentityMappingStores = NewProjectsLocationsIdentityMappingStoresService(s)
	rs.LicenseConfigs = NewProjectsLocationsLicenseConfigsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.Podcasts = NewProjectsLocationsPodcastsService(s)
	rs.RankingConfigs = NewProjectsLocationsRankingConfigsService(s)
	rs.UserEvents = NewProjectsLocationsUserEventsService(s)
	rs.UserStores = NewProjectsLocationsUserStoresService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	CmekConfigs *ProjectsLocationsCmekConfigsService

	Collections *ProjectsLocationsCollectionsService

	DataStores *ProjectsLocationsDataStoresService

	GroundingConfigs *ProjectsLocationsGroundingConfigsService

	IdentityMappingStores *ProjectsLocationsIdentityMappingStoresService

	LicenseConfigs *ProjectsLocationsLicenseConfigsService

	Operations *ProjectsLocationsOperationsService

	Podcasts *ProjectsLocationsPodcastsService

	RankingConfigs *ProjectsLocationsRankingConfigsService

	UserEvents *ProjectsLocationsUserEventsService

	UserStores *ProjectsLocationsUserStoresService
}

func NewProjectsLocationsCmekConfigsService(s *Service) *ProjectsLocationsCmekConfigsService {
	rs := &ProjectsLocationsCmekConfigsService{s: s}
	return rs
}

type ProjectsLocationsCmekConfigsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsService(s *Service) *ProjectsLocationsCollectionsService {
	rs := &ProjectsLocationsCollectionsService{s: s}
	rs.DataConnector = NewProjectsLocationsCollectionsDataConnectorService(s)
	rs.DataStores = NewProjectsLocationsCollectionsDataStoresService(s)
	rs.Engines = NewProjectsLocationsCollectionsEnginesService(s)
	rs.Operations = NewProjectsLocationsCollectionsOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsService struct {
	s *Service

	DataConnector *ProjectsLocationsCollectionsDataConnectorService

	DataStores *ProjectsLocationsCollectionsDataStoresService

	Engines *ProjectsLocationsCollectionsEnginesService

	Operations *ProjectsLocationsCollectionsOperationsService
}

func NewProjectsLocationsCollectionsDataConnectorService(s *Service) *ProjectsLocationsCollectionsDataConnectorService {
	rs := &ProjectsLocationsCollectionsDataConnectorService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataConnectorOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataConnectorService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataConnectorOperationsService
}

func NewProjectsLocationsCollectionsDataConnectorOperationsService(s *Service) *ProjectsLocationsCollectionsDataConnectorOperationsService {
	rs := &ProjectsLocationsCollectionsDataConnectorOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataConnectorOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresService(s *Service) *ProjectsLocationsCollectionsDataStoresService {
	rs := &ProjectsLocationsCollectionsDataStoresService{s: s}
	rs.Branches = NewProjectsLocationsCollectionsDataStoresBranchesService(s)
	rs.CompletionConfig = NewProjectsLocationsCollectionsDataStoresCompletionConfigService(s)
	rs.CompletionSuggestions = NewProjectsLocationsCollectionsDataStoresCompletionSuggestionsService(s)
	rs.Controls = NewProjectsLocationsCollectionsDataStoresControlsService(s)
	rs.Conversations = NewProjectsLocationsCollectionsDataStoresConversationsService(s)
	rs.CustomModels = NewProjectsLocationsCollectionsDataStoresCustomModelsService(s)
	rs.Models = NewProjectsLocationsCollectionsDataStoresModelsService(s)
	rs.Operations = NewProjectsLocationsCollectionsDataStoresOperationsService(s)
	rs.Schemas = NewProjectsLocationsCollectionsDataStoresSchemasService(s)
	rs.ServingConfigs = NewProjectsLocationsCollectionsDataStoresServingConfigsService(s)
	rs.Sessions = NewProjectsLocationsCollectionsDataStoresSessionsService(s)
	rs.SiteSearchEngine = NewProjectsLocationsCollectionsDataStoresSiteSearchEngineService(s)
	rs.SuggestionDenyListEntries = NewProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService(s)
	rs.UserEvents = NewProjectsLocationsCollectionsDataStoresUserEventsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresService struct {
	s *Service

	Branches *ProjectsLocationsCollectionsDataStoresBranchesService

	CompletionConfig *ProjectsLocationsCollectionsDataStoresCompletionConfigService

	CompletionSuggestions *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsService

	Controls *ProjectsLocationsCollectionsDataStoresControlsService

	Conversations *ProjectsLocationsCollectionsDataStoresConversationsService

	CustomModels *ProjectsLocationsCollectionsDataStoresCustomModelsService

	Models *ProjectsLocationsCollectionsDataStoresModelsService

	Operations *ProjectsLocationsCollectionsDataStoresOperationsService

	Schemas *ProjectsLocationsCollectionsDataStoresSchemasService

	ServingConfigs *ProjectsLocationsCollectionsDataStoresServingConfigsService

	Sessions *ProjectsLocationsCollectionsDataStoresSessionsService

	SiteSearchEngine *ProjectsLocationsCollectionsDataStoresSiteSearchEngineService

	SuggestionDenyListEntries *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService

	UserEvents *ProjectsLocationsCollectionsDataStoresUserEventsService
}

func NewProjectsLocationsCollectionsDataStoresBranchesService(s *Service) *ProjectsLocationsCollectionsDataStoresBranchesService {
	rs := &ProjectsLocationsCollectionsDataStoresBranchesService{s: s}
	rs.Documents = NewProjectsLocationsCollectionsDataStoresBranchesDocumentsService(s)
	rs.Operations = NewProjectsLocationsCollectionsDataStoresBranchesOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresBranchesService struct {
	s *Service

	Documents *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService

	Operations *ProjectsLocationsCollectionsDataStoresBranchesOperationsService
}

func NewProjectsLocationsCollectionsDataStoresBranchesDocumentsService(s *Service) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService {
	rs := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresBranchesOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresBranchesOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresBranchesOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresBranchesOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresCompletionConfigService(s *Service) *ProjectsLocationsCollectionsDataStoresCompletionConfigService {
	rs := &ProjectsLocationsCollectionsDataStoresCompletionConfigService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresCompletionConfigService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresCompletionSuggestionsService(s *Service) *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsService {
	rs := &ProjectsLocationsCollectionsDataStoresCompletionSuggestionsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresCompletionSuggestionsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresControlsService(s *Service) *ProjectsLocationsCollectionsDataStoresControlsService {
	rs := &ProjectsLocationsCollectionsDataStoresControlsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresControlsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresConversationsService(s *Service) *ProjectsLocationsCollectionsDataStoresConversationsService {
	rs := &ProjectsLocationsCollectionsDataStoresConversationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresConversationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresCustomModelsService(s *Service) *ProjectsLocationsCollectionsDataStoresCustomModelsService {
	rs := &ProjectsLocationsCollectionsDataStoresCustomModelsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresCustomModelsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresModelsService(s *Service) *ProjectsLocationsCollectionsDataStoresModelsService {
	rs := &ProjectsLocationsCollectionsDataStoresModelsService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataStoresModelsOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresModelsService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataStoresModelsOperationsService
}

func NewProjectsLocationsCollectionsDataStoresModelsOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresModelsOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresModelsOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresModelsOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSchemasService(s *Service) *ProjectsLocationsCollectionsDataStoresSchemasService {
	rs := &ProjectsLocationsCollectionsDataStoresSchemasService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataStoresSchemasOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresSchemasService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataStoresSchemasOperationsService
}

func NewProjectsLocationsCollectionsDataStoresSchemasOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresSchemasOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresSchemasOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSchemasOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresServingConfigsService(s *Service) *ProjectsLocationsCollectionsDataStoresServingConfigsService {
	rs := &ProjectsLocationsCollectionsDataStoresServingConfigsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresServingConfigsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSessionsService(s *Service) *ProjectsLocationsCollectionsDataStoresSessionsService {
	rs := &ProjectsLocationsCollectionsDataStoresSessionsService{s: s}
	rs.Answers = NewProjectsLocationsCollectionsDataStoresSessionsAnswersService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresSessionsService struct {
	s *Service

	Answers *ProjectsLocationsCollectionsDataStoresSessionsAnswersService
}

func NewProjectsLocationsCollectionsDataStoresSessionsAnswersService(s *Service) *ProjectsLocationsCollectionsDataStoresSessionsAnswersService {
	rs := &ProjectsLocationsCollectionsDataStoresSessionsAnswersService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSessionsAnswersService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSiteSearchEngineService(s *Service) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineService {
	rs := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService(s)
	rs.Sitemaps = NewProjectsLocationsCollectionsDataStoresSiteSearchEngineSitemapsService(s)
	rs.TargetSites = NewProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService

	Sitemaps *ProjectsLocationsCollectionsDataStoresSiteSearchEngineSitemapsService

	TargetSites *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService
}

func NewProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSiteSearchEngineSitemapsService(s *Service) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineSitemapsService {
	rs := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineSitemapsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineSitemapsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService(s *Service) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService {
	rs := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService
}

func NewProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService(s *Service) *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService {
	rs := &ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresUserEventsService(s *Service) *ProjectsLocationsCollectionsDataStoresUserEventsService {
	rs := &ProjectsLocationsCollectionsDataStoresUserEventsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresUserEventsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesService(s *Service) *ProjectsLocationsCollectionsEnginesService {
	rs := &ProjectsLocationsCollectionsEnginesService{s: s}
	rs.Assistants = NewProjectsLocationsCollectionsEnginesAssistantsService(s)
	rs.CompletionConfig = NewProjectsLocationsCollectionsEnginesCompletionConfigService(s)
	rs.Controls = NewProjectsLocationsCollectionsEnginesControlsService(s)
	rs.Conversations = NewProjectsLocationsCollectionsEnginesConversationsService(s)
	rs.Operations = NewProjectsLocationsCollectionsEnginesOperationsService(s)
	rs.ServingConfigs = NewProjectsLocationsCollectionsEnginesServingConfigsService(s)
	rs.Sessions = NewProjectsLocationsCollectionsEnginesSessionsService(s)
	return rs
}

type ProjectsLocationsCollectionsEnginesService struct {
	s *Service

	Assistants *ProjectsLocationsCollectionsEnginesAssistantsService

	CompletionConfig *ProjectsLocationsCollectionsEnginesCompletionConfigService

	Controls *ProjectsLocationsCollectionsEnginesControlsService

	Conversations *ProjectsLocationsCollectionsEnginesConversationsService

	Operations *ProjectsLocationsCollectionsEnginesOperationsService

	ServingConfigs *ProjectsLocationsCollectionsEnginesServingConfigsService

	Sessions *ProjectsLocationsCollectionsEnginesSessionsService
}

func NewProjectsLocationsCollectionsEnginesAssistantsService(s *Service) *ProjectsLocationsCollectionsEnginesAssistantsService {
	rs := &ProjectsLocationsCollectionsEnginesAssistantsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesAssistantsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesCompletionConfigService(s *Service) *ProjectsLocationsCollectionsEnginesCompletionConfigService {
	rs := &ProjectsLocationsCollectionsEnginesCompletionConfigService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesCompletionConfigService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesControlsService(s *Service) *ProjectsLocationsCollectionsEnginesControlsService {
	rs := &ProjectsLocationsCollectionsEnginesControlsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesControlsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesConversationsService(s *Service) *ProjectsLocationsCollectionsEnginesConversationsService {
	rs := &ProjectsLocationsCollectionsEnginesConversationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesConversationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesOperationsService(s *Service) *ProjectsLocationsCollectionsEnginesOperationsService {
	rs := &ProjectsLocationsCollectionsEnginesOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesServingConfigsService(s *Service) *ProjectsLocationsCollectionsEnginesServingConfigsService {
	rs := &ProjectsLocationsCollectionsEnginesServingConfigsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesServingConfigsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesSessionsService(s *Service) *ProjectsLocationsCollectionsEnginesSessionsService {
	rs := &ProjectsLocationsCollectionsEnginesSessionsService{s: s}
	rs.Answers = NewProjectsLocationsCollectionsEnginesSessionsAnswersService(s)
	return rs
}

type ProjectsLocationsCollectionsEnginesSessionsService struct {
	s *Service

	Answers *ProjectsLocationsCollectionsEnginesSessionsAnswersService
}

func NewProjectsLocationsCollectionsEnginesSessionsAnswersService(s *Service) *ProjectsLocationsCollectionsEnginesSessionsAnswersService {
	rs := &ProjectsLocationsCollectionsEnginesSessionsAnswersService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesSessionsAnswersService struct {
	s *Service
}

func NewProjectsLocationsCollectionsOperationsService(s *Service) *ProjectsLocationsCollectionsOperationsService {
	rs := &ProjectsLocationsCollectionsOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresService(s *Service) *ProjectsLocationsDataStoresService {
	rs := &ProjectsLocationsDataStoresService{s: s}
	rs.Branches = NewProjectsLocationsDataStoresBranchesService(s)
	rs.CompletionConfig = NewProjectsLocationsDataStoresCompletionConfigService(s)
	rs.CompletionSuggestions = NewProjectsLocationsDataStoresCompletionSuggestionsService(s)
	rs.Controls = NewProjectsLocationsDataStoresControlsService(s)
	rs.Conversations = NewProjectsLocationsDataStoresConversationsService(s)
	rs.Models = NewProjectsLocationsDataStoresModelsService(s)
	rs.Operations = NewProjectsLocationsDataStoresOperationsService(s)
	rs.Schemas = NewProjectsLocationsDataStoresSchemasService(s)
	rs.ServingConfigs = NewProjectsLocationsDataStoresServingConfigsService(s)
	rs.Sessions = NewProjectsLocationsDataStoresSessionsService(s)
	rs.SiteSearchEngine = NewProjectsLocationsDataStoresSiteSearchEngineService(s)
	rs.SuggestionDenyListEntries = NewProjectsLocationsDataStoresSuggestionDenyListEntriesService(s)
	rs.UserEvents = NewProjectsLocationsDataStoresUserEventsService(s)
	return rs
}

type ProjectsLocationsDataStoresService struct {
	s *Service

	Branches *ProjectsLocationsDataStoresBranchesService

	CompletionConfig *ProjectsLocationsDataStoresCompletionConfigService

	CompletionSuggestions *ProjectsLocationsDataStoresCompletionSuggestionsService

	Controls *ProjectsLocationsDataStoresControlsService

	Conversations *ProjectsLocationsDataStoresConversationsService

	Models *ProjectsLocationsDataStoresModelsService

	Operations *ProjectsLocationsDataStoresOperationsService

	Schemas *ProjectsLocationsDataStoresSchemasService

	ServingConfigs *ProjectsLocationsDataStoresServingConfigsService

	Sessions *ProjectsLocationsDataStoresSessionsService

	SiteSearchEngine *ProjectsLocationsDataStoresSiteSearchEngineService

	SuggestionDenyListEntries *ProjectsLocationsDataStoresSuggestionDenyListEntriesService

	UserEvents *ProjectsLocationsDataStoresUserEventsService
}

func NewProjectsLocationsDataStoresBranchesService(s *Service) *ProjectsLocationsDataStoresBranchesService {
	rs := &ProjectsLocationsDataStoresBranchesService{s: s}
	rs.Documents = NewProjectsLocationsDataStoresBranchesDocumentsService(s)
	rs.Operations = NewProjectsLocationsDataStoresBranchesOperationsService(s)
	return rs
}

type ProjectsLocationsDataStoresBranchesService struct {
	s *Service

	Documents *ProjectsLocationsDataStoresBranchesDocumentsService

	Operations *ProjectsLocationsDataStoresBranchesOperationsService
}

func NewProjectsLocationsDataStoresBranchesDocumentsService(s *Service) *ProjectsLocationsDataStoresBranchesDocumentsService {
	rs := &ProjectsLocationsDataStoresBranchesDocumentsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresBranchesDocumentsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresBranchesOperationsService(s *Service) *ProjectsLocationsDataStoresBranchesOperationsService {
	rs := &ProjectsLocationsDataStoresBranchesOperationsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresBranchesOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresCompletionConfigService(s *Service) *ProjectsLocationsDataStoresCompletionConfigService {
	rs := &ProjectsLocationsDataStoresCompletionConfigService{s: s}
	return rs
}

type ProjectsLocationsDataStoresCompletionConfigService struct {
	s *Service
}

func NewProjectsLocationsDataStoresCompletionSuggestionsService(s *Service) *ProjectsLocationsDataStoresCompletionSuggestionsService {
	rs := &ProjectsLocationsDataStoresCompletionSuggestionsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresCompletionSuggestionsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresControlsService(s *Service) *ProjectsLocationsDataStoresControlsService {
	rs := &ProjectsLocationsDataStoresControlsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresControlsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresConversationsService(s *Service) *ProjectsLocationsDataStoresConversationsService {
	rs := &ProjectsLocationsDataStoresConversationsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresConversationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresModelsService(s *Service) *ProjectsLocationsDataStoresModelsService {
	rs := &ProjectsLocationsDataStoresModelsService{s: s}
	rs.Operations = NewProjectsLocationsDataStoresModelsOperationsService(s)
	return rs
}

type ProjectsLocationsDataStoresModelsService struct {
	s *Service

	Operations *ProjectsLocationsDataStoresModelsOperationsService
}

func NewProjectsLocationsDataStoresModelsOperationsService(s *Service) *ProjectsLocationsDataStoresModelsOperationsService {
	rs := &ProjectsLocationsDataStoresModelsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresModelsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresOperationsService(s *Service) *ProjectsLocationsDataStoresOperationsService {
	rs := &ProjectsLocationsDataStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresSchemasService(s *Service) *ProjectsLocationsDataStoresSchemasService {
	rs := &ProjectsLocationsDataStoresSchemasService{s: s}
	return rs
}

type ProjectsLocationsDataStoresSchemasService struct {
	s *Service
}

func NewProjectsLocationsDataStoresServingConfigsService(s *Service) *ProjectsLocationsDataStoresServingConfigsService {
	rs := &ProjectsLocationsDataStoresServingConfigsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresServingConfigsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresSessionsService(s *Service) *ProjectsLocationsDataStoresSessionsService {
	rs := &ProjectsLocationsDataStoresSessionsService{s: s}
	rs.Answers = NewProjectsLocationsDataStoresSessionsAnswersService(s)
	return rs
}

type ProjectsLocationsDataStoresSessionsService struct {
	s *Service

	Answers *ProjectsLocationsDataStoresSessionsAnswersService
}

func NewProjectsLocationsDataStoresSessionsAnswersService(s *Service) *ProjectsLocationsDataStoresSessionsAnswersService {
	rs := &ProjectsLocationsDataStoresSessionsAnswersService{s: s}
	return rs
}

type ProjectsLocationsDataStoresSessionsAnswersService struct {
	s *Service
}

func NewProjectsLocationsDataStoresSiteSearchEngineService(s *Service) *ProjectsLocationsDataStoresSiteSearchEngineService {
	rs := &ProjectsLocationsDataStoresSiteSearchEngineService{s: s}
	rs.Sitemaps = NewProjectsLocationsDataStoresSiteSearchEngineSitemapsService(s)
	rs.TargetSites = NewProjectsLocationsDataStoresSiteSearchEngineTargetSitesService(s)
	return rs
}

type ProjectsLocationsDataStoresSiteSearchEngineService struct {
	s *Service

	Sitemaps *ProjectsLocationsDataStoresSiteSearchEngineSitemapsService

	TargetSites *ProjectsLocationsDataStoresSiteSearchEngineTargetSitesService
}

func NewProjectsLocationsDataStoresSiteSearchEngineSitemapsService(s *Service) *ProjectsLocationsDataStoresSiteSearchEngineSitemapsService {
	rs := &ProjectsLocationsDataStoresSiteSearchEngineSitemapsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresSiteSearchEngineSitemapsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresSiteSearchEngineTargetSitesService(s *Service) *ProjectsLocationsDataStoresSiteSearchEngineTargetSitesService {
	rs := &ProjectsLocationsDataStoresSiteSearchEngineTargetSitesService{s: s}
	return rs
}

type ProjectsLocationsDataStoresSiteSearchEngineTargetSitesService struct {
	s *Service
}

func NewProjectsLocationsDataStoresSuggestionDenyListEntriesService(s *Service) *ProjectsLocationsDataStoresSuggestionDenyListEntriesService {
	rs := &ProjectsLocationsDataStoresSuggestionDenyListEntriesService{s: s}
	return rs
}

type ProjectsLocationsDataStoresSuggestionDenyListEntriesService struct {
	s *Service
}

func NewProjectsLocationsDataStoresUserEventsService(s *Service) *ProjectsLocationsDataStoresUserEventsService {
	rs := &ProjectsLocationsDataStoresUserEventsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresUserEventsService struct {
	s *Service
}

func NewProjectsLocationsGroundingConfigsService(s *Service) *ProjectsLocationsGroundingConfigsService {
	rs := &ProjectsLocationsGroundingConfigsService{s: s}
	return rs
}

type ProjectsLocationsGroundingConfigsService struct {
	s *Service
}

func NewProjectsLocationsIdentityMappingStoresService(s *Service) *ProjectsLocationsIdentityMappingStoresService {
	rs := &ProjectsLocationsIdentityMappingStoresService{s: s}
	rs.Operations = NewProjectsLocationsIdentityMappingStoresOperationsService(s)
	return rs
}

type ProjectsLocationsIdentityMappingStoresService struct {
	s *Service

	Operations *ProjectsLocationsIdentityMappingStoresOperationsService
}

func NewProjectsLocationsIdentityMappingStoresOperationsService(s *Service) *ProjectsLocationsIdentityMappingStoresOperationsService {
	rs := &ProjectsLocationsIdentityMappingStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsIdentityMappingStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsLicenseConfigsService(s *Service) *ProjectsLocationsLicenseConfigsService {
	rs := &ProjectsLocationsLicenseConfigsService{s: s}
	return rs
}

type ProjectsLocationsLicenseConfigsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsPodcastsService(s *Service) *ProjectsLocationsPodcastsService {
	rs := &ProjectsLocationsPodcastsService{s: s}
	rs.Operations = NewProjectsLocationsPodcastsOperationsService(s)
	return rs
}

type ProjectsLocationsPodcastsService struct {
	s *Service

	Operations *ProjectsLocationsPodcastsOperationsService
}

func NewProjectsLocationsPodcastsOperationsService(s *Service) *ProjectsLocationsPodcastsOperationsService {
	rs := &ProjectsLocationsPodcastsOperationsService{s: s}
	return rs
}

type ProjectsLocationsPodcastsOperationsService struct {
	s *Service
}

func NewProjectsLocationsRankingConfigsService(s *Service) *ProjectsLocationsRankingConfigsService {
	rs := &ProjectsLocationsRankingConfigsService{s: s}
	return rs
}

type ProjectsLocationsRankingConfigsService struct {
	s *Service
}

func NewProjectsLocationsUserEventsService(s *Service) *ProjectsLocationsUserEventsService {
	rs := &ProjectsLocationsUserEventsService{s: s}
	return rs
}

type ProjectsLocationsUserEventsService struct {
	s *Service
}

func NewProjectsLocationsUserStoresService(s *Service) *ProjectsLocationsUserStoresService {
	rs := &ProjectsLocationsUserStoresService{s: s}
	rs.UserLicenses = NewProjectsLocationsUserStoresUserLicensesService(s)
	return rs
}

type ProjectsLocationsUserStoresService struct {
	s *Service

	UserLicenses *ProjectsLocationsUserStoresUserLicensesService
}

func NewProjectsLocationsUserStoresUserLicensesService(s *Service) *ProjectsLocationsUserStoresUserLicensesService {
	rs := &ProjectsLocationsUserStoresUserLicensesService{s: s}
	return rs
}

type ProjectsLocationsUserStoresUserLicensesService struct {
	s *Service
}

func NewProjectsOperationsService(s *Service) *ProjectsOperationsService {
	rs := &ProjectsOperationsService{s: s}
	return rs
}

type ProjectsOperationsService struct {
	s *Service
}

// GdataBlobstore2Info: Information to read/write to blobstore2.
type GdataBlobstore2Info struct {
	// BlobGeneration: The blob generation id.
	BlobGeneration int64 `json:"blobGeneration,omitempty,string"`
	// BlobId: The blob id, e.g., /blobstore/prod/playground/scotty
	BlobId string `json:"blobId,omitempty"`
	// DownloadReadHandle: Read handle passed from Bigstore -> Scotty for a GCS
	// download. This is a signed, serialized blobstore2.ReadHandle proto which
	// must never be set outside of Bigstore, and is not applicable to non-GCS
	// media downloads.
	DownloadReadHandle string `json:"downloadReadHandle,omitempty"`
	// ReadToken: The blob read token. Needed to read blobs that have not been
	// replicated. Might not be available until the final call.
	ReadToken string `json:"readToken,omitempty"`
	// UploadMetadataContainer: Metadata passed from Blobstore -> Scotty for a new
	// GCS upload. This is a signed, serialized blobstore2.BlobMetadataContainer
	// proto which must never be consumed outside of Bigstore, and is not
	// applicable to non-GCS media uploads.
	UploadMetadataContainer string `json:"uploadMetadataContainer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlobGeneration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobGeneration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataBlobstore2Info) MarshalJSON() ([]byte, error) {
	type NoMethod GdataBlobstore2Info
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataCompositeMedia: A sequence of media data references representing
// composite data. Introduced to support Bigstore composite objects. For
// details, visit http://go/bigstore-composites.
type GdataCompositeMedia struct {
	// BlobRef: Blobstore v1 reference, set if reference_type is BLOBSTORE_REF This
	// should be the byte representation of a blobstore.BlobRef. Since Blobstore is
	// deprecating v1, use blobstore2_info instead. For now, any v2 blob will also
	// be represented in this field as v1 BlobRef.
	BlobRef string `json:"blobRef,omitempty"`
	// Blobstore2Info: Blobstore v2 info, set if reference_type is BLOBSTORE_REF
	// and it refers to a v2 blob.
	Blobstore2Info *GdataBlobstore2Info `json:"blobstore2Info,omitempty"`
	// CosmoBinaryReference: A binary data reference for a media download. Serves
	// as a technology-agnostic binary reference in some Google infrastructure.
	// This value is a serialized storage_cosmo.BinaryReference proto. Storing it
	// as bytes is a hack to get around the fact that the cosmo proto (as well as
	// others it includes) doesn't support JavaScript. This prevents us from
	// including the actual type of this field.
	CosmoBinaryReference string `json:"cosmoBinaryReference,omitempty"`
	// Crc32cHash: crc32.c hash for the payload.
	Crc32cHash int64 `json:"crc32cHash,omitempty"`
	// Inline: Media data, set if reference_type is INLINE
	Inline string `json:"inline,omitempty"`
	// Length: Size of the data, in bytes
	Length int64 `json:"length,omitempty,string"`
	// Md5Hash: MD5 hash for the payload.
	Md5Hash string `json:"md5Hash,omitempty"`
	// ObjectId: Reference to a TI Blob, set if reference_type is BIGSTORE_REF.
	ObjectId *GdataObjectId `json:"objectId,omitempty"`
	// Path: Path to the data, set if reference_type is PATH
	Path string `json:"path,omitempty"`
	// ReferenceType: Describes what the field reference contains.
	//
	// Possible values:
	//   "PATH" - Reference contains a GFS path or a local path.
	//   "BLOB_REF" - Reference points to a blobstore object. This could be either
	// a v1 blob_ref or a v2 blobstore2_info. Clients should check blobstore2_info
	// first, since v1 is being deprecated.
	//   "INLINE" - Data is included into this proto buffer
	//   "BIGSTORE_REF" - Reference points to a bigstore object
	//   "COSMO_BINARY_REFERENCE" - Indicates the data is stored in
	// cosmo_binary_reference.
	ReferenceType string `json:"referenceType,omitempty"`
	// Sha1Hash: SHA-1 hash for the payload.
	Sha1Hash string `json:"sha1Hash,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlobRef") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobRef") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataCompositeMedia) MarshalJSON() ([]byte, error) {
	type NoMethod GdataCompositeMedia
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataContentTypeInfo: Detailed Content-Type information from Scotty. The
// Content-Type of the media will typically be filled in by the header or
// Scotty's best_guess, but this extended information provides the backend with
// more information so that it can make a better decision if needed. This is
// only used on media upload requests from Scotty.
type GdataContentTypeInfo struct {
	// BestGuess: Scotty's best guess of what the content type of the file is.
	BestGuess string `json:"bestGuess,omitempty"`
	// FromBytes: The content type of the file derived by looking at specific bytes
	// (i.e. "magic bytes") of the actual file.
	FromBytes string `json:"fromBytes,omitempty"`
	// FromFileName: The content type of the file derived from the file extension
	// of the original file name used by the client.
	FromFileName string `json:"fromFileName,omitempty"`
	// FromHeader: The content type of the file as specified in the request
	// headers, multipart headers, or RUPIO start request.
	FromHeader string `json:"fromHeader,omitempty"`
	// FromUrlPath: The content type of the file derived from the file extension of
	// the URL path. The URL path is assumed to represent a file name (which is
	// typically only true for agents that are providing a REST API).
	FromUrlPath string `json:"fromUrlPath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BestGuess") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BestGuess") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataContentTypeInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GdataContentTypeInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataDiffChecksumsResponse: Backend response for a Diff get checksums
// response. For details on the Scotty Diff protocol, visit
// http://go/scotty-diff-protocol.
type GdataDiffChecksumsResponse struct {
	// ChecksumsLocation: Exactly one of these fields must be populated. If
	// checksums_location is filled, the server will return the corresponding
	// contents to the user. If object_location is filled, the server will
	// calculate the checksums based on the content there and return that to the
	// user. For details on the format of the checksums, see
	// http://go/scotty-diff-protocol.
	ChecksumsLocation *GdataCompositeMedia `json:"checksumsLocation,omitempty"`
	// ChunkSizeBytes: The chunk size of checksums. Must be a multiple of 256KB.
	ChunkSizeBytes int64 `json:"chunkSizeBytes,omitempty,string"`
	// ObjectLocation: If set, calculate the checksums based on the contents and
	// return them to the caller.
	ObjectLocation *GdataCompositeMedia `json:"objectLocation,omitempty"`
	// ObjectSizeBytes: The total size of the server object.
	ObjectSizeBytes int64 `json:"objectSizeBytes,omitempty,string"`
	// ObjectVersion: The object version of the object the checksums are being
	// returned for.
	ObjectVersion string `json:"objectVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChecksumsLocation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChecksumsLocation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataDiffChecksumsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GdataDiffChecksumsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataDiffDownloadResponse: Backend response for a Diff download response.
// For details on the Scotty Diff protocol, visit
// http://go/scotty-diff-protocol.
type GdataDiffDownloadResponse struct {
	// ObjectLocation: The original object location.
	ObjectLocation *GdataCompositeMedia `json:"objectLocation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectLocation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectLocation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataDiffDownloadResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GdataDiffDownloadResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataDiffUploadRequest: A Diff upload request. For details on the Scotty
// Diff protocol, visit http://go/scotty-diff-protocol.
type GdataDiffUploadRequest struct {
	// ChecksumsInfo: The location of the checksums for the new object. Agents must
	// clone the object located here, as the upload server will delete the contents
	// once a response is received. For details on the format of the checksums, see
	// http://go/scotty-diff-protocol.
	ChecksumsInfo *GdataCompositeMedia `json:"checksumsInfo,omitempty"`
	// ObjectInfo: The location of the new object. Agents must clone the object
	// located here, as the upload server will delete the contents once a response
	// is received.
	ObjectInfo *GdataCompositeMedia `json:"objectInfo,omitempty"`
	// ObjectVersion: The object version of the object that is the base version the
	// incoming diff script will be applied to. This field will always be filled
	// in.
	ObjectVersion string `json:"objectVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChecksumsInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChecksumsInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataDiffUploadRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GdataDiffUploadRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataDiffUploadResponse: Backend response for a Diff upload request. For
// details on the Scotty Diff protocol, visit http://go/scotty-diff-protocol.
type GdataDiffUploadResponse struct {
	// ObjectVersion: The object version of the object at the server. Must be
	// included in the end notification response. The version in the end
	// notification response must correspond to the new version of the object that
	// is now stored at the server, after the upload.
	ObjectVersion string `json:"objectVersion,omitempty"`
	// OriginalObject: The location of the original file for a diff upload request.
	// Must be filled in if responding to an upload start notification.
	OriginalObject *GdataCompositeMedia `json:"originalObject,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataDiffUploadResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GdataDiffUploadResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataDiffVersionResponse: Backend response for a Diff get version response.
// For details on the Scotty Diff protocol, visit
// http://go/scotty-diff-protocol.
type GdataDiffVersionResponse struct {
	// ObjectSizeBytes: The total size of the server object.
	ObjectSizeBytes int64 `json:"objectSizeBytes,omitempty,string"`
	// ObjectVersion: The version of the object stored at the server.
	ObjectVersion string `json:"objectVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectSizeBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectSizeBytes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataDiffVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GdataDiffVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataDownloadParameters: Parameters specific to media downloads.
type GdataDownloadParameters struct {
	// AllowGzipCompression: A boolean to be returned in the response to Scotty.
	// Allows/disallows gzip encoding of the payload content when the server thinks
	// it's advantageous (hence, does not guarantee compression) which allows
	// Scotty to GZip the response to the client.
	AllowGzipCompression bool `json:"allowGzipCompression,omitempty"`
	// IgnoreRange: Determining whether or not Apiary should skip the inclusion of
	// any Content-Range header on its response to Scotty.
	IgnoreRange bool `json:"ignoreRange,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowGzipCompression") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowGzipCompression") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataDownloadParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GdataDownloadParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataMedia: A reference to data stored on the filesystem, on GFS or in
// blobstore.
type GdataMedia struct {
	// Algorithm: Deprecated, use one of explicit hash type fields instead.
	// Algorithm used for calculating the hash. As of 2011/01/21, "MD5" is the only
	// possible value for this field. New values may be added at any time.
	Algorithm string `json:"algorithm,omitempty"`
	// BigstoreObjectRef: Use object_id instead.
	BigstoreObjectRef string `json:"bigstoreObjectRef,omitempty"`
	// BlobRef: Blobstore v1 reference, set if reference_type is BLOBSTORE_REF This
	// should be the byte representation of a blobstore.BlobRef. Since Blobstore is
	// deprecating v1, use blobstore2_info instead. For now, any v2 blob will also
	// be represented in this field as v1 BlobRef.
	BlobRef string `json:"blobRef,omitempty"`
	// Blobstore2Info: Blobstore v2 info, set if reference_type is BLOBSTORE_REF
	// and it refers to a v2 blob.
	Blobstore2Info *GdataBlobstore2Info `json:"blobstore2Info,omitempty"`
	// CompositeMedia: A composite media composed of one or more media objects, set
	// if reference_type is COMPOSITE_MEDIA. The media length field must be set to
	// the sum of the lengths of all composite media objects. Note: All composite
	// media must have length specified.
	CompositeMedia []*GdataCompositeMedia `json:"compositeMedia,omitempty"`
	// ContentType: MIME type of the data
	ContentType string `json:"contentType,omitempty"`
	// ContentTypeInfo: Extended content type information provided for Scotty
	// uploads.
	ContentTypeInfo *GdataContentTypeInfo `json:"contentTypeInfo,omitempty"`
	// CosmoBinaryReference: A binary data reference for a media download. Serves
	// as a technology-agnostic binary reference in some Google infrastructure.
	// This value is a serialized storage_cosmo.BinaryReference proto. Storing it
	// as bytes is a hack to get around the fact that the cosmo proto (as well as
	// others it includes) doesn't support JavaScript. This prevents us from
	// including the actual type of this field.
	CosmoBinaryReference string `json:"cosmoBinaryReference,omitempty"`
	// Crc32cHash: For Scotty Uploads: Scotty-provided hashes for uploads For
	// Scotty Downloads: (WARNING: DO NOT USE WITHOUT PERMISSION FROM THE SCOTTY
	// TEAM.) A Hash provided by the agent to be used to verify the data being
	// downloaded. Currently only supported for inline payloads. Further, only
	// crc32c_hash is currently supported.
	Crc32cHash int64 `json:"crc32cHash,omitempty"`
	// DiffChecksumsResponse: Set if reference_type is DIFF_CHECKSUMS_RESPONSE.
	DiffChecksumsResponse *GdataDiffChecksumsResponse `json:"diffChecksumsResponse,omitempty"`
	// DiffDownloadResponse: Set if reference_type is DIFF_DOWNLOAD_RESPONSE.
	DiffDownloadResponse *GdataDiffDownloadResponse `json:"diffDownloadResponse,omitempty"`
	// DiffUploadRequest: Set if reference_type is DIFF_UPLOAD_REQUEST.
	DiffUploadRequest *GdataDiffUploadRequest `json:"diffUploadRequest,omitempty"`
	// DiffUploadResponse: Set if reference_type is DIFF_UPLOAD_RESPONSE.
	DiffUploadResponse *GdataDiffUploadResponse `json:"diffUploadResponse,omitempty"`
	// DiffVersionResponse: Set if reference_type is DIFF_VERSION_RESPONSE.
	DiffVersionResponse *GdataDiffVersionResponse `json:"diffVersionResponse,omitempty"`
	// DownloadParameters: Parameters for a media download.
	DownloadParameters *GdataDownloadParameters `json:"downloadParameters,omitempty"`
	// Filename: Original file name
	Filename string `json:"filename,omitempty"`
	// Hash: Deprecated, use one of explicit hash type fields instead. These two
	// hash related fields will only be populated on Scotty based media uploads and
	// will contain the content of the hash group in the NotificationRequest:
	// http://cs/#google3/blobstore2/api/scotty/service/proto/upload_listener.proto&q=class:Hash
	// Hex encoded hash value of the uploaded media.
	Hash string `json:"hash,omitempty"`
	// HashVerified: For Scotty uploads only. If a user sends a hash code and the
	// backend has requested that Scotty verify the upload against the client hash,
	// Scotty will perform the check on behalf of the backend and will reject it if
	// the hashes don't match. This is set to true if Scotty performed this
	// verification.
	HashVerified bool `json:"hashVerified,omitempty"`
	// Inline: Media data, set if reference_type is INLINE
	Inline string `json:"inline,omitempty"`
	// IsPotentialRetry: |is_potential_retry| is set false only when Scotty is
	// certain that it has not sent the request before. When a client resumes an
	// upload, this field must be set true in agent calls, because Scotty cannot be
	// certain that it has never sent the request before due to potential failure
	// in the session state persistence.
	IsPotentialRetry bool `json:"isPotentialRetry,omitempty"`
	// Length: Size of the data, in bytes
	Length int64 `json:"length,omitempty,string"`
	// Md5Hash: Scotty-provided MD5 hash for an upload.
	Md5Hash string `json:"md5Hash,omitempty"`
	// MediaId: Media id to forward to the operation GetMedia. Can be set if
	// reference_type is GET_MEDIA.
	MediaId string `json:"mediaId,omitempty"`
	// ObjectId: Reference to a TI Blob, set if reference_type is BIGSTORE_REF.
	ObjectId *GdataObjectId `json:"objectId,omitempty"`
	// Path: Path to the data, set if reference_type is PATH
	Path string `json:"path,omitempty"`
	// ReferenceType: Describes what the field reference contains.
	//
	// Possible values:
	//   "PATH" - Reference contains a GFS path or a local path.
	//   "BLOB_REF" - Reference points to a blobstore object. This could be either
	// a v1 blob_ref or a v2 blobstore2_info. Clients should check blobstore2_info
	// first, since v1 is being deprecated.
	//   "INLINE" - Data is included into this proto buffer
	//   "GET_MEDIA" - Data should be accessed from the current service using the
	// operation GetMedia.
	//   "COMPOSITE_MEDIA" - The content for this media object is stored across
	// multiple partial media objects under the composite_media field.
	//   "BIGSTORE_REF" - Reference points to a bigstore object
	//   "DIFF_VERSION_RESPONSE" - Indicates the data is stored in
	// diff_version_response.
	//   "DIFF_CHECKSUMS_RESPONSE" - Indicates the data is stored in
	// diff_checksums_response.
	//   "DIFF_DOWNLOAD_RESPONSE" - Indicates the data is stored in
	// diff_download_response.
	//   "DIFF_UPLOAD_REQUEST" - Indicates the data is stored in
	// diff_upload_request.
	//   "DIFF_UPLOAD_RESPONSE" - Indicates the data is stored in
	// diff_upload_response.
	//   "COSMO_BINARY_REFERENCE" - Indicates the data is stored in
	// cosmo_binary_reference.
	//   "ARBITRARY_BYTES" - Informs Scotty to generate a response payload with the
	// size specified in the length field. The contents of the payload are
	// generated by Scotty and are undefined. This is useful for testing download
	// speeds between the user and Scotty without involving a real payload source.
	// Note: range is not supported when using arbitrary_bytes.
	ReferenceType string `json:"referenceType,omitempty"`
	// Sha1Hash: Scotty-provided SHA1 hash for an upload.
	Sha1Hash string `json:"sha1Hash,omitempty"`
	// Sha256Hash: Scotty-provided SHA256 hash for an upload.
	Sha256Hash string `json:"sha256Hash,omitempty"`
	// Timestamp: Time at which the media data was last updated, in milliseconds
	// since UNIX epoch
	Timestamp uint64 `json:"timestamp,omitempty,string"`
	// Token: A unique fingerprint/version id for the media data
	Token string `json:"token,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Algorithm") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Algorithm") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataMedia) MarshalJSON() ([]byte, error) {
	type NoMethod GdataMedia
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataObjectId: This is a copy of the tech.blob.ObjectId proto, which could
// not be used directly here due to transitive closure issues with JavaScript
// support; see http://b/8801763.
type GdataObjectId struct {
	// BucketName: The name of the bucket to which this object belongs.
	BucketName string `json:"bucketName,omitempty"`
	// Generation: Generation of the object. Generations are monotonically
	// increasing across writes, allowing them to be be compared to determine which
	// generation is newer. If this is omitted in a request, then you are
	// requesting the live object. See http://go/bigstore-versions
	Generation int64 `json:"generation,omitempty,string"`
	// ObjectName: The name of the object.
	ObjectName string `json:"objectName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BucketName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BucketName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataObjectId) MarshalJSON() ([]byte, error) {
	type NoMethod GdataObjectId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleApiDistribution: `Distribution` contains summary statistics for a
// population of values. It optionally contains a histogram representing the
// distribution of those values across a set of buckets. The summary statistics
// are the count, mean, sum of the squared deviation from the mean, the
// minimum, and the maximum of the set of population of values. The histogram
// is based on a sequence of buckets and gives a count of values that fall into
// each bucket. The boundaries of the buckets are given either explicitly or by
// formulas for buckets of fixed or exponentially increasing widths. Although
// it is not forbidden, it is generally a bad idea to include non-finite values
// (infinities or NaNs) in the population of values, as this will render the
// `mean` and `sum_of_squared_deviation` fields meaningless.
type GoogleApiDistribution struct {
	// BucketCounts: The number of values in each bucket of the histogram, as
	// described in `bucket_options`. If the distribution does not have a
	// histogram, then omit this field. If there is a histogram, then the sum of
	// the values in `bucket_counts` must equal the value in the `count` field of
	// the distribution. If present, `bucket_counts` should contain N values, where
	// N is the number of buckets specified in `bucket_options`. If you supply
	// fewer than N values, the remaining values are assumed to be 0. The order of
	// the values in `bucket_counts` follows the bucket numbering schemes described
	// for the three bucket types. The first value must be the count for the
	// underflow bucket (number 0). The next N-2 values are the counts for the
	// finite buckets (number 1 through N-2). The N'th value in `bucket_counts` is
	// the count for the overflow bucket (number N-1).
	BucketCounts googleapi.Int64s `json:"bucketCounts,omitempty"`
	// BucketOptions: Defines the histogram bucket boundaries. If the distribution
	// does not contain a histogram, then omit this field.
	BucketOptions *GoogleApiDistributionBucketOptions `json:"bucketOptions,omitempty"`
	// Count: The number of values in the population. Must be non-negative. This
	// value must equal the sum of the values in `bucket_counts` if a histogram is
	// provided.
	Count int64 `json:"count,omitempty,string"`
	// Exemplars: Must be in increasing order of `value` field.
	Exemplars []*GoogleApiDistributionExemplar `json:"exemplars,omitempty"`
	// Mean: The arithmetic mean of the values in the population. If `count` is
	// zero then this field must be zero.
	Mean float64 `json:"mean,omitempty"`
	// Range: If specified, contains the range of the population values. The field
	// must not be present if the `count` is zero.
	Range *GoogleApiDistributionRange `json:"range,omitempty"`
	// SumOfSquaredDeviation: The sum of squared deviations from the mean of the
	// values in the population. For values x_i this is: Sumi=1..n ((x_i - mean)^2)
	// Knuth, "The Art of Computer Programming", Vol. 2, page 232, 3rd edition
	// describes Welford's method for accumulating this sum in one pass. If `count`
	// is zero then this field must be zero.
	SumOfSquaredDeviation float64 `json:"sumOfSquaredDeviation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BucketCounts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BucketCounts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiDistribution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiDistribution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleApiDistribution) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleApiDistribution
	var s1 struct {
		Mean                  gensupport.JSONFloat64 `json:"mean"`
		SumOfSquaredDeviation gensupport.JSONFloat64 `json:"sumOfSquaredDeviation"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Mean = float64(s1.Mean)
	s.SumOfSquaredDeviation = float64(s1.SumOfSquaredDeviation)
	return nil
}

// GoogleApiDistributionBucketOptions: `BucketOptions` describes the bucket
// boundaries used to create a histogram for the distribution. The buckets can
// be in a linear sequence, an exponential sequence, or each bucket can be
// specified explicitly. `BucketOptions` does not include the number of values
// in each bucket. A bucket has an inclusive lower bound and exclusive upper
// bound for the values that are counted for that bucket. The upper bound of a
// bucket must be strictly greater than the lower bound. The sequence of N
// buckets for a distribution consists of an underflow bucket (number 0), zero
// or more finite buckets (number 1 through N - 2) and an overflow bucket
// (number N - 1). The buckets are contiguous: the lower bound of bucket i (i >
// 0) is the same as the upper bound of bucket i - 1. The buckets span the
// whole range of finite values: lower bound of the underflow bucket is
// -infinity and the upper bound of the overflow bucket is +infinity. The
// finite buckets are so-called because both bounds are finite.
type GoogleApiDistributionBucketOptions struct {
	// ExplicitBuckets: The explicit buckets.
	ExplicitBuckets *GoogleApiDistributionBucketOptionsExplicit `json:"explicitBuckets,omitempty"`
	// ExponentialBuckets: The exponential buckets.
	ExponentialBuckets *GoogleApiDistributionBucketOptionsExponential `json:"exponentialBuckets,omitempty"`
	// LinearBuckets: The linear bucket.
	LinearBuckets *GoogleApiDistributionBucketOptionsLinear `json:"linearBuckets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExplicitBuckets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExplicitBuckets") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiDistributionBucketOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiDistributionBucketOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleApiDistributionBucketOptionsExplicit: Specifies a set of buckets with
// arbitrary widths. There are `size(bounds) + 1` (= N) buckets. Bucket `i` has
// the following boundaries: Upper bound (0 <= i < N-1): bounds[i] Lower bound
// (1 <= i < N); bounds[i - 1] The `bounds` field must contain at least one
// element. If `bounds` has only one element, then there are no finite buckets,
// and that single element is the common boundary of the overflow and underflow
// buckets.
type GoogleApiDistributionBucketOptionsExplicit struct {
	// Bounds: The values must be monotonically increasing.
	Bounds []float64 `json:"bounds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bounds") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bounds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiDistributionBucketOptionsExplicit) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiDistributionBucketOptionsExplicit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleApiDistributionBucketOptionsExplicit) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleApiDistributionBucketOptionsExplicit
	var s1 struct {
		Bounds []gensupport.JSONFloat64 `json:"bounds"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Bounds = make([]float64, len(s1.Bounds))
	for i := range s1.Bounds {
		s.Bounds[i] = float64(s1.Bounds[i])
	}
	return nil
}

// GoogleApiDistributionBucketOptionsExponential: Specifies an exponential
// sequence of buckets that have a width that is proportional to the value of
// the lower bound. Each bucket represents a constant relative uncertainty on a
// specific value in the bucket. There are `num_finite_buckets + 2` (= N)
// buckets. Bucket `i` has the following boundaries: Upper bound (0 <= i <
// N-1): scale * (growth_factor ^ i). Lower bound (1 <= i < N): scale *
// (growth_factor ^ (i - 1)).
type GoogleApiDistributionBucketOptionsExponential struct {
	// GrowthFactor: Must be greater than 1.
	GrowthFactor float64 `json:"growthFactor,omitempty"`
	// NumFiniteBuckets: Must be greater than 0.
	NumFiniteBuckets int64 `json:"numFiniteBuckets,omitempty"`
	// Scale: Must be greater than 0.
	Scale float64 `json:"scale,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GrowthFactor") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GrowthFactor") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiDistributionBucketOptionsExponential) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiDistributionBucketOptionsExponential
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleApiDistributionBucketOptionsExponential) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleApiDistributionBucketOptionsExponential
	var s1 struct {
		GrowthFactor gensupport.JSONFloat64 `json:"growthFactor"`
		Scale        gensupport.JSONFloat64 `json:"scale"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.GrowthFactor = float64(s1.GrowthFactor)
	s.Scale = float64(s1.Scale)
	return nil
}

// GoogleApiDistributionBucketOptionsLinear: Specifies a linear sequence of
// buckets that all have the same width (except overflow and underflow). Each
// bucket represents a constant absolute uncertainty on the specific value in
// the bucket. There are `num_finite_buckets + 2` (= N) buckets. Bucket `i` has
// the following boundaries: Upper bound (0 <= i < N-1): offset + (width * i).
// Lower bound (1 <= i < N): offset + (width * (i - 1)).
type GoogleApiDistributionBucketOptionsLinear struct {
	// NumFiniteBuckets: Must be greater than 0.
	NumFiniteBuckets int64 `json:"numFiniteBuckets,omitempty"`
	// Offset: Lower bound of the first bucket.
	Offset float64 `json:"offset,omitempty"`
	// Width: Must be greater than 0.
	Width float64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NumFiniteBuckets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NumFiniteBuckets") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiDistributionBucketOptionsLinear) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiDistributionBucketOptionsLinear
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleApiDistributionBucketOptionsLinear) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleApiDistributionBucketOptionsLinear
	var s1 struct {
		Offset gensupport.JSONFloat64 `json:"offset"`
		Width  gensupport.JSONFloat64 `json:"width"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Offset = float64(s1.Offset)
	s.Width = float64(s1.Width)
	return nil
}

// GoogleApiDistributionExemplar: Exemplars are example points that may be used
// to annotate aggregated distribution values. They are metadata that gives
// information about a particular value added to a Distribution bucket, such as
// a trace ID that was active when a value was added. They may contain further
// information, such as a example values and timestamps, origin, etc.
type GoogleApiDistributionExemplar struct {
	// Attachments: Contextual information about the example value. Examples are:
	// Trace: type.googleapis.com/google.monitoring.v3.SpanContext Literal string:
	// type.googleapis.com/google.protobuf.StringValue Labels dropped during
	// aggregation: type.googleapis.com/google.monitoring.v3.DroppedLabels There
	// may be only a single attachment of any given message type in a single
	// exemplar, and this is enforced by the system.
	Attachments []googleapi.RawMessage `json:"attachments,omitempty"`
	// Timestamp: The observation (sampling) time of the above value.
	Timestamp string `json:"timestamp,omitempty"`
	// Value: Value of the exemplar point. This value determines to which bucket
	// the exemplar belongs.
	Value float64 `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attachments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attachments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiDistributionExemplar) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiDistributionExemplar
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleApiDistributionExemplar) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleApiDistributionExemplar
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

// GoogleApiDistributionRange: The range of the population values.
type GoogleApiDistributionRange struct {
	// Max: The maximum of the population values.
	Max float64 `json:"max,omitempty"`
	// Min: The minimum of the population values.
	Min float64 `json:"min,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Max") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Max") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiDistributionRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiDistributionRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleApiDistributionRange) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleApiDistributionRange
	var s1 struct {
		Max gensupport.JSONFloat64 `json:"max"`
		Min gensupport.JSONFloat64 `json:"min"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Max = float64(s1.Max)
	s.Min = float64(s1.Min)
	return nil
}

// GoogleApiHttpBody: Message that represents an arbitrary HTTP body. It should
// only be used for payload formats that can't be represented as JSON, such as
// raw binary or an HTML page. This message can be used both in streaming and
// non-streaming API methods in the request as well as the response. It can be
// used as a top-level request field, which is convenient if one wants to
// extract parameters from either the URL or HTTP template into the request
// fields and also want access to the raw HTTP body. Example: message
// GetResourceRequest { // A unique request id. string request_id = 1; // The
// raw HTTP body is bound to this field. google.api.HttpBody http_body = 2; }
// service ResourceService { rpc GetResource(GetResourceRequest) returns
// (google.api.HttpBody); rpc UpdateResource(google.api.HttpBody) returns
// (google.protobuf.Empty); } Example with streaming methods: service
// CaldavService { rpc GetCalendar(stream google.api.HttpBody) returns (stream
// google.api.HttpBody); rpc UpdateCalendar(stream google.api.HttpBody) returns
// (stream google.api.HttpBody); } Use of this type only changes how the
// request and response bodies are handled, all other features will continue to
// work unchanged.
type GoogleApiHttpBody struct {
	// ContentType: The HTTP Content-Type header value specifying the content type
	// of the body.
	ContentType string `json:"contentType,omitempty"`
	// Data: The HTTP request/response body as raw binary.
	Data string `json:"data,omitempty"`
	// Extensions: Application specific response metadata. Must be set in the first
	// response for streaming APIs.
	Extensions []googleapi.RawMessage `json:"extensions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContentType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiHttpBody) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiHttpBody
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleApiMetric: A specific metric, identified by specifying values for all
// of the labels of a `MetricDescriptor`.
type GoogleApiMetric struct {
	// Labels: The set of label values that uniquely identify this metric. All
	// labels listed in the `MetricDescriptor` must be assigned values.
	Labels map[string]string `json:"labels,omitempty"`
	// Type: An existing metric type, see google.api.MetricDescriptor. For example,
	// `custom.googleapis.com/invoice/paid/amount`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiMetric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiMetric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleApiMonitoredResource: An object representing a resource that can be
// used for monitoring, logging, billing, or other purposes. Examples include
// virtual machine instances, databases, and storage devices such as disks. The
// `type` field identifies a MonitoredResourceDescriptor object that describes
// the resource's schema. Information in the `labels` field identifies the
// actual resource and its attributes according to the schema. For example, a
// particular Compute Engine VM instance could be represented by the following
// object, because the MonitoredResourceDescriptor for "gce_instance" has
// labels "project_id", "instance_id" and "zone": { "type":
// "gce_instance", "labels": { "project_id": "my-project", "instance_id":
// "12345678901234", "zone": "us-central1-a" }}
type GoogleApiMonitoredResource struct {
	// Labels: Required. Values for all of the labels listed in the associated
	// monitored resource descriptor. For example, Compute Engine VM instances use
	// the labels "project_id", "instance_id", and "zone".
	Labels map[string]string `json:"labels,omitempty"`
	// Type: Required. The monitored resource type. This field must match the
	// `type` field of a MonitoredResourceDescriptor object. For example, the type
	// of a Compute Engine VM instance is `gce_instance`. Some descriptors include
	// the service name in the type; for example, the type of a Datastream stream
	// is `datastream.googleapis.com/Stream`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiMonitoredResource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiMonitoredResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleApiMonitoredResourceMetadata: Auxiliary metadata for a
// MonitoredResource object. MonitoredResource objects contain the minimum set
// of information to uniquely identify a monitored resource instance. There is
// some other useful auxiliary metadata. Monitoring and Logging use an
// ingestion pipeline to extract metadata for cloud resources of all types, and
// store the metadata in this message.
type GoogleApiMonitoredResourceMetadata struct {
	// SystemLabels: Output only. Values for predefined system metadata labels.
	// System labels are a kind of metadata extracted by Google, including
	// "machine_image", "vpc", "subnet_id", "security_group", "name", etc. System
	// label values can be only strings, Boolean values, or a list of strings. For
	// example: { "name": "my-test-instance", "security_group": ["a", "b", "c"],
	// "spot_instance": false }
	SystemLabels googleapi.RawMessage `json:"systemLabels,omitempty"`
	// UserLabels: Output only. A map of user-defined metadata labels.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SystemLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SystemLabels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiMonitoredResourceMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiMonitoredResourceMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingConnectorRunErrorContext: The error payload
// that is populated on LRO sync APIs, including the following: *
// `google.cloud.discoveryengine.v1main.DataConnectorService.SetUpDataConnector`
//
//	*
//
// `google.cloud.discoveryengine.v1main.DataConnectorService.StartConnectorRun`
type GoogleCloudDiscoveryengineLoggingConnectorRunErrorContext struct {
	// ConnectorRun: The full resource name of the Connector Run. Format:
	// `projects/*/locations/*/collections/*/dataConnector/connectorRuns/*`. The
	// `connector_run_id` is system-generated.
	ConnectorRun string `json:"connectorRun,omitempty"`
	// DataConnector: The full resource name of the DataConnector. Format:
	// `projects/*/locations/*/collections/*/dataConnector`.
	DataConnector string `json:"dataConnector,omitempty"`
	// EndTime: The time when the connector run ended.
	EndTime string `json:"endTime,omitempty"`
	// Entity: The entity to sync for the connector run.
	Entity string `json:"entity,omitempty"`
	// Operation: The operation resource name of the LRO to sync the connector.
	Operation string `json:"operation,omitempty"`
	// StartTime: The time when the connector run started.
	StartTime string `json:"startTime,omitempty"`
	// SyncType: The type of sync run. Can be one of the following: * `FULL` *
	// `INCREMENTAL`
	SyncType string `json:"syncType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectorRun") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectorRun") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineLoggingConnectorRunErrorContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingConnectorRunErrorContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingErrorContext: A description of the context
// in which an error occurred.
type GoogleCloudDiscoveryengineLoggingErrorContext struct {
	// HttpRequest: The HTTP request which was processed when the error was
	// triggered.
	HttpRequest *GoogleCloudDiscoveryengineLoggingHttpRequestContext `json:"httpRequest,omitempty"`
	// ReportLocation: The location in the source code where the decision was made
	// to report the error, usually the place where it was logged.
	ReportLocation *GoogleCloudDiscoveryengineLoggingSourceLocation `json:"reportLocation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HttpRequest") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HttpRequest") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineLoggingErrorContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingErrorContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingErrorLog: An error log which is reported to
// the Error Reporting system.
type GoogleCloudDiscoveryengineLoggingErrorLog struct {
	// ConnectorRunPayload: The error payload that is populated on LRO connector
	// sync APIs.
	ConnectorRunPayload *GoogleCloudDiscoveryengineLoggingConnectorRunErrorContext `json:"connectorRunPayload,omitempty"`
	// Context: A description of the context in which the error occurred.
	Context *GoogleCloudDiscoveryengineLoggingErrorContext `json:"context,omitempty"`
	// ImportPayload: The error payload that is populated on LRO import APIs.
	ImportPayload *GoogleCloudDiscoveryengineLoggingImportErrorContext `json:"importPayload,omitempty"`
	// Message: A message describing the error.
	Message string `json:"message,omitempty"`
	// RequestPayload: The API request payload, represented as a protocol buffer.
	// Most API request types are supported—for example: *
	// `type.googleapis.com/google.cloud.discoveryengine.v1alpha.DocumentService.Cre
	// ateDocumentRequest` *
	// `type.googleapis.com/google.cloud.discoveryengine.v1alpha.UserEventService.Wr
	// iteUserEventRequest`
	RequestPayload googleapi.RawMessage `json:"requestPayload,omitempty"`
	// ResponsePayload: The API response payload, represented as a protocol buffer.
	// This is used to log some "soft errors", where the response is valid but we
	// consider there are some quality issues like unjoined events. The following
	// API responses are supported, and no PII is included: *
	// `google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend` *
	// `google.cloud.discoveryengine.v1alpha.UserEventService.WriteUserEvent` *
	// `google.cloud.discoveryengine.v1alpha.UserEventService.CollectUserEvent`
	ResponsePayload googleapi.RawMessage `json:"responsePayload,omitempty"`
	// ServiceContext: The service context in which this error has occurred.
	ServiceContext *GoogleCloudDiscoveryengineLoggingServiceContext `json:"serviceContext,omitempty"`
	// Status: The RPC status associated with the error log.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectorRunPayload") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectorRunPayload") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineLoggingErrorLog) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingErrorLog
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingHttpRequestContext: HTTP request data that
// is related to a reported error.
type GoogleCloudDiscoveryengineLoggingHttpRequestContext struct {
	// ResponseStatusCode: The HTTP response status code for the request.
	ResponseStatusCode int64 `json:"responseStatusCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResponseStatusCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResponseStatusCode") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineLoggingHttpRequestContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingHttpRequestContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingImportErrorContext: The error payload that
// is populated on LRO import APIs, including the following: *
// `google.cloud.discoveryengine.v1alpha.DocumentService.ImportDocuments` *
// `google.cloud.discoveryengine.v1alpha.UserEventService.ImportUserEvents`
type GoogleCloudDiscoveryengineLoggingImportErrorContext struct {
	// Document: The detailed content which caused the error on importing a
	// document.
	Document string `json:"document,omitempty"`
	// GcsPath: Google Cloud Storage file path of the import source. Can be set for
	// batch operation error.
	GcsPath string `json:"gcsPath,omitempty"`
	// LineNumber: Line number of the content in file. Should be empty for
	// permission or batch operation error.
	LineNumber string `json:"lineNumber,omitempty"`
	// Operation: The operation resource name of the LRO.
	Operation string `json:"operation,omitempty"`
	// UserEvent: The detailed content which caused the error on importing a user
	// event.
	UserEvent string `json:"userEvent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineLoggingImportErrorContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingImportErrorContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingServiceContext: Describes a running service
// that sends errors.
type GoogleCloudDiscoveryengineLoggingServiceContext struct {
	// Service: An identifier of the service—for example,
	// `discoveryengine.googleapis.com`.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Service") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Service") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineLoggingServiceContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingServiceContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingSourceLocation: Indicates a location in the
// source code of the service for which errors are reported.
type GoogleCloudDiscoveryengineLoggingSourceLocation struct {
	// FunctionName: Human-readable name of a function or method—for example,
	// `google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend`.
	FunctionName string `json:"functionName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FunctionName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FunctionName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineLoggingSourceLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingSourceLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AclConfig: Access Control Configuration.
type GoogleCloudDiscoveryengineV1AclConfig struct {
	// IdpConfig: Identity provider config.
	IdpConfig *GoogleCloudDiscoveryengineV1IdpConfig `json:"idpConfig,omitempty"`
	// Name: Immutable. The full resource name of the acl configuration. Format:
	// `projects/{project}/locations/{location}/aclConfig`. This field must be a
	// UTF-8 encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "IdpConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdpConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AclConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AclConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ActionConfig: Informations to support actions on
// the connector.
type GoogleCloudDiscoveryengineV1ActionConfig struct {
	// ActionParams: Optional. Action parameters in structured json format.
	ActionParams googleapi.RawMessage `json:"actionParams,omitempty"`
	// IsActionConfigured: Output only. The connector contains the necessary
	// parameters and is configured to support actions.
	IsActionConfigured bool `json:"isActionConfigured,omitempty"`
	// JsonActionParams: Optional. Action parameters in json string format.
	JsonActionParams string `json:"jsonActionParams,omitempty"`
	// ServiceName: Optional. The Service Directory resource name
	// (projects/*/locations/*/namespaces/*/services/*) representing a VPC network
	// endpoint used to connect to the data source's `instance_uri`, defined in
	// DataConnector.params. Required when VPC Service Controls are enabled.
	ServiceName string `json:"serviceName,omitempty"`
	// UseStaticSecrets: Optional. Whether to use static secrets for the connector.
	// If true, the secrets provided in the action_params will be ignored.
	UseStaticSecrets bool `json:"useStaticSecrets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionParams") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionParams") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ActionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ActionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequest: Request message
// for CompletionService.AdvancedCompleteQuery method. .
type GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequest struct {
	// BoostSpec: Optional. Specification to boost suggestions matching the
	// condition.
	BoostSpec *GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestBoostSpec `json:"boostSpec,omitempty"`
	// ExperimentIds: Optional. Experiment ids for this request.
	ExperimentIds []string `json:"experimentIds,omitempty"`
	// IncludeTailSuggestions: Indicates if tail suggestions should be returned if
	// there are no suggestions that match the full query. Even if set to true, if
	// there are suggestions that match the full query, those are returned and no
	// tail suggestions are returned.
	IncludeTailSuggestions bool `json:"includeTailSuggestions,omitempty"`
	// Query: Required. The typeahead input used to fetch suggestions. Maximum
	// length is 128 characters. The query can not be empty for most of the
	// suggestion types. If it is empty, an `INVALID_ARGUMENT` error is returned.
	// The exception is when the suggestion_types contains only the type
	// `RECENT_SEARCH`, the query can be an empty string. The is called "zero
	// prefix" feature, which returns user's recently searched queries given the
	// empty query.
	Query string `json:"query,omitempty"`
	// QueryModel: Specifies the autocomplete query model, which only applies to
	// the QUERY SuggestionType. This overrides any model specified in the
	// Configuration > Autocomplete section of the Cloud console. Currently
	// supported values: * `document` - Using suggestions generated from
	// user-imported documents. * `search-history` - Using suggestions generated
	// from the past history of SearchService.Search API calls. Do not use it when
	// there is no traffic for Search API. * `user-event` - Using suggestions
	// generated from user-imported search events. * `document-completable` - Using
	// suggestions taken directly from user-imported document fields marked as
	// completable. Default values: * `document` is the default model for regular
	// dataStores. * `search-history` is the default model for site search
	// dataStores.
	QueryModel string `json:"queryModel,omitempty"`
	// SuggestionTypeSpecs: Optional. Specification of each suggestion type.
	SuggestionTypeSpecs []*GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestSuggestionTypeSpec `json:"suggestionTypeSpecs,omitempty"`
	// SuggestionTypes: Optional. Suggestion types to return. If empty or
	// unspecified, query suggestions are returned. Only one suggestion type is
	// supported at the moment.
	//
	// Possible values:
	//   "SUGGESTION_TYPE_UNSPECIFIED" - Default value.
	//   "QUERY" - Returns query suggestions.
	//   "PEOPLE" - Returns people suggestions.
	//   "CONTENT" - Returns content suggestions.
	//   "RECENT_SEARCH" - Returns recent search suggestions.
	//   "GOOGLE_WORKSPACE" - Returns Google Workspace suggestions.
	SuggestionTypes []string `json:"suggestionTypes,omitempty"`
	// UserInfo: Optional. Information about the end user. This should be the same
	// identifier information as UserEvent.user_info and SearchRequest.user_info.
	UserInfo *GoogleCloudDiscoveryengineV1UserInfo `json:"userInfo,omitempty"`
	// UserPseudoId: Optional. A unique identifier for tracking visitors. For
	// example, this could be implemented with an HTTP cookie, which should be able
	// to uniquely identify a visitor on a single device. This unique identifier
	// should not change if the visitor logs in or out of the website. This field
	// should NOT have a fixed value such as `unknown_visitor`. This should be the
	// same identifier as UserEvent.user_pseudo_id and
	// SearchRequest.user_pseudo_id. The field must be a UTF-8 encoded string with
	// a length limit of 128
	UserPseudoId string `json:"userPseudoId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestBoostSpec:
// Specification to boost suggestions based on the condtion of the suggestion.
type GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestBoostSpec struct {
	// ConditionBoostSpecs: Condition boost specifications. If a suggestion matches
	// multiple conditions in the specifications, boost values from these
	// specifications are all applied and combined in a non-linear way. Maximum
	// number of specifications is 20. Note: Currently only support language
	// condition boost.
	ConditionBoostSpecs []*GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestBoostSpecConditionBoostSpec `json:"conditionBoostSpecs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConditionBoostSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConditionBoostSpecs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestBoostSpecConditionBoo
// stSpec: Boost applies to suggestions which match a condition.
type GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestBoostSpecConditionBoostSpec struct {
	// Boost: Strength of the boost, which should be in [-1, 1]. Negative boost
	// means demotion. Default is 0.0. Setting to 1.0 gives the suggestions a big
	// promotion. However, it does not necessarily mean that the top result will be
	// a boosted suggestion. Setting to -1.0 gives the suggestions a big demotion.
	// However, other suggestions that are relevant might still be shown. Setting
	// to 0.0 means no boost applied. The boosting condition is ignored.
	Boost float64 `json:"boost,omitempty"`
	// Condition: An expression which specifies a boost condition. The syntax is
	// the same as filter expression syntax
	// (https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata#filter-expression-syntax).
	// Currently, the only supported condition is a list of BCP-47 lang codes.
	// Example: * To boost suggestions in languages `en` or `fr`: `(lang_code:
	// ANY("en", "fr"))`
	Condition string `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestBoostSpecConditionBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestBoostSpecConditionBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestBoostSpecConditionBoostSpec) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestBoostSpecConditionBoostSpec
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

// GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestSuggestionTypeSpec:
// Specification of each suggestion type.
type GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestSuggestionTypeSpec struct {
	// MaxSuggestions: Optional. Maximum number of suggestions to return for each
	// suggestion type.
	MaxSuggestions int64 `json:"maxSuggestions,omitempty"`
	// SuggestionType: Optional. Suggestion type.
	//
	// Possible values:
	//   "SUGGESTION_TYPE_UNSPECIFIED" - Default value.
	//   "QUERY" - Returns query suggestions.
	//   "PEOPLE" - Returns people suggestions.
	//   "CONTENT" - Returns content suggestions.
	//   "RECENT_SEARCH" - Returns recent search suggestions.
	//   "GOOGLE_WORKSPACE" - Returns Google Workspace suggestions.
	SuggestionType string `json:"suggestionType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxSuggestions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestSuggestionTypeSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestSuggestionTypeSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponse: Response message
// for CompletionService.AdvancedCompleteQuery method.
type GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponse struct {
	// ContentSuggestions: Results of the matched content suggestions. The result
	// list is ordered and the first result is the top suggestion.
	ContentSuggestions []*GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseContentSuggestion `json:"contentSuggestions,omitempty"`
	// PeopleSuggestions: Results of the matched people suggestions. The result
	// list is ordered and the first result is the top suggestion.
	PeopleSuggestions []*GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponsePersonSuggestion `json:"peopleSuggestions,omitempty"`
	// QuerySuggestions: Results of the matched query suggestions. The result list
	// is ordered and the first result is a top suggestion.
	QuerySuggestions []*GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseQuerySuggestion `json:"querySuggestions,omitempty"`
	// RecentSearchSuggestions: Results of the matched "recent search" suggestions.
	// The result list is ordered and the first result is the top suggestion.
	RecentSearchSuggestions []*GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseRecentSearchSuggestion `json:"recentSearchSuggestions,omitempty"`
	// TailMatchTriggered: True if the returned suggestions are all tail
	// suggestions. For tail matching to be triggered, include_tail_suggestions in
	// the request must be true and there must be no suggestions that match the
	// full query.
	TailMatchTriggered bool `json:"tailMatchTriggered,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContentSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentSuggestions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseContentSuggestion:
// Suggestions as content.
type GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseContentSuggestion struct {
	// ContentType: The type of the content suggestion.
	//
	// Possible values:
	//   "CONTENT_TYPE_UNSPECIFIED" - Default value.
	//   "GOOGLE_WORKSPACE" - The suggestion is from a Google Workspace source.
	//   "THIRD_PARTY" - The suggestion is from a third party source.
	ContentType string `json:"contentType,omitempty"`
	// DataStore: The name of the dataStore that this suggestion belongs to.
	DataStore string `json:"dataStore,omitempty"`
	// DestinationUri: The destination uri of the content suggestion.
	DestinationUri string `json:"destinationUri,omitempty"`
	// Document: The document data snippet in the suggestion. Only a subset of
	// fields will be populated.
	Document *GoogleCloudDiscoveryengineV1Document `json:"document,omitempty"`
	// IconUri: The icon uri of the content suggestion.
	IconUri string `json:"iconUri,omitempty"`
	// Score: The score of each suggestion. The score is in the range of [0, 1].
	Score float64 `json:"score,omitempty"`
	// Suggestion: The suggestion for the query.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseContentSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseContentSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseContentSuggestion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseContentSuggestion
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponsePersonSuggestion:
// Suggestions as people.
type GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponsePersonSuggestion struct {
	// DataStore: The name of the dataStore that this suggestion belongs to.
	DataStore string `json:"dataStore,omitempty"`
	// DestinationUri: The destination uri of the person suggestion.
	DestinationUri string `json:"destinationUri,omitempty"`
	// DisplayPhotoUri: The photo uri of the person suggestion.
	DisplayPhotoUri string `json:"displayPhotoUri,omitempty"`
	// Document: The document data snippet in the suggestion. Only a subset of
	// fields is populated.
	Document *GoogleCloudDiscoveryengineV1Document `json:"document,omitempty"`
	// PersonType: The type of the person.
	//
	// Possible values:
	//   "PERSON_TYPE_UNSPECIFIED" - Default value.
	//   "CLOUD_IDENTITY" - The suggestion is from a GOOGLE_IDENTITY source.
	//   "THIRD_PARTY_IDENTITY" - The suggestion is from a THIRD_PARTY_IDENTITY
	// source.
	PersonType string `json:"personType,omitempty"`
	// Score: The score of each suggestion. The score is in the range of [0, 1].
	Score float64 `json:"score,omitempty"`
	// Suggestion: The suggestion for the query.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponsePersonSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponsePersonSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponsePersonSuggestion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponsePersonSuggestion
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseQuerySuggestion:
// Suggestions as search queries.
type GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseQuerySuggestion struct {
	// CompletableFieldPaths: The unique document field paths that serve as the
	// source of this suggestion if it was generated from completable fields. This
	// field is only populated for the document-completable model.
	CompletableFieldPaths []string `json:"completableFieldPaths,omitempty"`
	// DataStore: The name of the dataStore that this suggestion belongs to.
	DataStore []string `json:"dataStore,omitempty"`
	// Score: The score of each suggestion. The score is in the range of [0, 1].
	Score float64 `json:"score,omitempty"`
	// Suggestion: The suggestion for the query.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletableFieldPaths") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletableFieldPaths") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseQuerySuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseQuerySuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseQuerySuggestion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseQuerySuggestion
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseRecentSearchSuggesti
// on: Suggestions from recent search history.
type GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseRecentSearchSuggestion struct {
	// RecentSearchTime: The time when this recent rearch happened.
	RecentSearchTime string `json:"recentSearchTime,omitempty"`
	// Score: The score of each suggestion. The score is in the range of [0, 1].
	Score float64 `json:"score,omitempty"`
	// Suggestion: The suggestion for the query.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RecentSearchTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RecentSearchTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseRecentSearchSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseRecentSearchSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseRecentSearchSuggestion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseRecentSearchSuggestion
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDiscoveryengineV1AdvancedSiteSearchConfig: Configuration data for
// advance site search.
type GoogleCloudDiscoveryengineV1AdvancedSiteSearchConfig struct {
	// DisableAutomaticRefresh: If set true, automatic refresh is disabled for the
	// DataStore.
	DisableAutomaticRefresh bool `json:"disableAutomaticRefresh,omitempty"`
	// DisableInitialIndex: If set true, initial indexing is disabled for the
	// DataStore.
	DisableInitialIndex bool `json:"disableInitialIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisableAutomaticRefresh") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisableAutomaticRefresh") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AdvancedSiteSearchConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AdvancedSiteSearchConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AlertPolicyConfig: The connector level alert
// config.
type GoogleCloudDiscoveryengineV1AlertPolicyConfig struct {
	// AlertEnrollments: Optional. The enrollment states of each alert.
	AlertEnrollments []*GoogleCloudDiscoveryengineV1AlertPolicyConfigAlertEnrollment `json:"alertEnrollments,omitempty"`
	// AlertPolicyName: Immutable. The fully qualified resource name of the
	// AlertPolicy.
	AlertPolicyName string `json:"alertPolicyName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlertEnrollments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlertEnrollments") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AlertPolicyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AlertPolicyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AlertPolicyConfigAlertEnrollment: The alert
// enrollment status.
type GoogleCloudDiscoveryengineV1AlertPolicyConfigAlertEnrollment struct {
	// AlertId: Immutable. The id of an alert.
	AlertId string `json:"alertId,omitempty"`
	// EnrollState: Required. The enrollment status of a customer.
	//
	// Possible values:
	//   "ENROLL_STATES_UNSPECIFIED" - Default value. Used for customers who have
	// not responded to the alert policy.
	//   "ENROLLED" - Customer is enrolled in this policy.
	//   "DECLINED" - Customer declined this policy.
	EnrollState string `json:"enrollState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlertId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlertId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AlertPolicyConfigAlertEnrollment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AlertPolicyConfigAlertEnrollment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AlloyDbSource: AlloyDB source import data from.
type GoogleCloudDiscoveryengineV1AlloyDbSource struct {
	// ClusterId: Required. The AlloyDB cluster to copy the data from with a length
	// limit of 256 characters.
	ClusterId string `json:"clusterId,omitempty"`
	// DatabaseId: Required. The AlloyDB database to copy the data from with a
	// length limit of 256 characters.
	DatabaseId string `json:"databaseId,omitempty"`
	// GcsStagingDir: Intermediate Cloud Storage directory used for the import with
	// a length limit of 2,000 characters. Can be specified if one wants to have
	// the AlloyDB export to a specific Cloud Storage directory. Ensure that the
	// AlloyDB service account has the necessary Cloud Storage Admin permissions to
	// access the specified Cloud Storage directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`
	// LocationId: Required. The AlloyDB location to copy the data from with a
	// length limit of 256 characters.
	LocationId string `json:"locationId,omitempty"`
	// ProjectId: The project ID that contains the AlloyDB source. Has a length
	// limit of 128 characters. If not specified, inherits the project ID from the
	// parent request.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Required. The AlloyDB table to copy the data from with a length
	// limit of 256 characters.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AlloyDbSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AlloyDbSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Answer: Defines an answer.
type GoogleCloudDiscoveryengineV1Answer struct {
	// AnswerSkippedReasons: Additional answer-skipped reasons. This provides the
	// reason for ignored cases. If nothing is skipped, this field is not set.
	//
	// Possible values:
	//   "ANSWER_SKIPPED_REASON_UNSPECIFIED" - Default value. The answer skipped
	// reason is not specified.
	//   "ADVERSARIAL_QUERY_IGNORED" - The adversarial query ignored case.
	//   "NON_ANSWER_SEEKING_QUERY_IGNORED" - The non-answer seeking query ignored
	// case Google skips the answer if the query is chit chat.
	//   "OUT_OF_DOMAIN_QUERY_IGNORED" - The out-of-domain query ignored case.
	// Google skips the answer if there are no high-relevance search results.
	//   "POTENTIAL_POLICY_VIOLATION" - The potential policy violation case. Google
	// skips the answer if there is a potential policy violation detected. This
	// includes content that may be violent or toxic.
	//   "NO_RELEVANT_CONTENT" - The no relevant content case. Google skips the
	// answer if there is no relevant content in the retrieved search results.
	//   "JAIL_BREAKING_QUERY_IGNORED" - The jail-breaking query ignored case. For
	// example, "Reply in the tone of a competing company's CEO". Google skips the
	// answer if the query is classified as a jail-breaking query.
	//   "CUSTOMER_POLICY_VIOLATION" - The customer policy violation case. Google
	// skips the summary if there is a customer policy violation detected. The
	// policy is defined by the customer.
	//   "NON_ANSWER_SEEKING_QUERY_IGNORED_V2" - The non-answer seeking query
	// ignored case. Google skips the answer if the query doesn't have clear
	// intent.
	//   "LOW_GROUNDED_ANSWER" - The low-grounded answer case. Google skips the
	// answer if a well grounded answer was unable to be generated.
	//   "USER_DEFINED_CLASSIFICATION_QUERY_IGNORED" - The user defined query
	// classification ignored case. Google skips the answer if the query is
	// classified as a user defined query classification.
	//   "UNHELPFUL_ANSWER" - The unhelpful answer case. Google skips the answer if
	// the answer is not helpful. This can be due to a variety of factors,
	// including but not limited to: the query is not answerable, the answer is not
	// relevant to the query, or the answer is not well-formatted.
	AnswerSkippedReasons []string `json:"answerSkippedReasons,omitempty"`
	// AnswerText: The textual answer.
	AnswerText string `json:"answerText,omitempty"`
	// Citations: Citations.
	Citations []*GoogleCloudDiscoveryengineV1AnswerCitation `json:"citations,omitempty"`
	// CompleteTime: Output only. Answer completed timestamp.
	CompleteTime string `json:"completeTime,omitempty"`
	// CreateTime: Output only. Answer creation timestamp.
	CreateTime string `json:"createTime,omitempty"`
	// GroundingScore: A score in the range of [0, 1] describing how grounded the
	// answer is by the reference chunks.
	GroundingScore float64 `json:"groundingScore,omitempty"`
	// GroundingSupports: Optional. Grounding supports.
	GroundingSupports []*GoogleCloudDiscoveryengineV1AnswerGroundingSupport `json:"groundingSupports,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/{project}/locations/global/collections/{collection}/engines/{engine
	// }/sessions/*/answers/*`
	Name string `json:"name,omitempty"`
	// QueryUnderstandingInfo: Query understanding information.
	QueryUnderstandingInfo *GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfo `json:"queryUnderstandingInfo,omitempty"`
	// References: References.
	References []*GoogleCloudDiscoveryengineV1AnswerReference `json:"references,omitempty"`
	// RelatedQuestions: Suggested related questions.
	RelatedQuestions []string `json:"relatedQuestions,omitempty"`
	// SafetyRatings: Optional. Safety ratings.
	SafetyRatings []*GoogleCloudDiscoveryengineV1SafetyRating `json:"safetyRatings,omitempty"`
	// State: The state of the answer generation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown.
	//   "IN_PROGRESS" - Answer generation is currently in progress.
	//   "FAILED" - Answer generation currently failed.
	//   "SUCCEEDED" - Answer generation has succeeded.
	//   "STREAMING" - Answer generation is currently in progress.
	State string `json:"state,omitempty"`
	// Steps: Answer generation steps.
	Steps []*GoogleCloudDiscoveryengineV1AnswerStep `json:"steps,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnswerSkippedReasons") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerSkippedReasons") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Answer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Answer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1Answer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1Answer
	var s1 struct {
		GroundingScore gensupport.JSONFloat64 `json:"groundingScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.GroundingScore = float64(s1.GroundingScore)
	return nil
}

// GoogleCloudDiscoveryengineV1AnswerCitation: Citation info for a segment.
type GoogleCloudDiscoveryengineV1AnswerCitation struct {
	// EndIndex: End of the attributed segment, exclusive. Measured in bytes (UTF-8
	// unicode). If there are multi-byte characters,such as non-ASCII characters,
	// the index measurement is longer than the string length.
	EndIndex int64 `json:"endIndex,omitempty,string"`
	// Sources: Citation sources for the attributed segment.
	Sources []*GoogleCloudDiscoveryengineV1AnswerCitationSource `json:"sources,omitempty"`
	// StartIndex: Index indicates the start of the segment, measured in bytes
	// (UTF-8 unicode). If there are multi-byte characters,such as non-ASCII
	// characters, the index measurement is longer than the string length.
	StartIndex int64 `json:"startIndex,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerCitation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerCitation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerCitationSource: Citation source.
type GoogleCloudDiscoveryengineV1AnswerCitationSource struct {
	// ReferenceId: ID of the citation source.
	ReferenceId string `json:"referenceId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReferenceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReferenceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerCitationSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerCitationSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerGenerationSpec: The specification for
// answer generation.
type GoogleCloudDiscoveryengineV1AnswerGenerationSpec struct {
	// UserDefinedClassifierSpec: Optional. The specification for user specified
	// classifier spec.
	UserDefinedClassifierSpec *GoogleCloudDiscoveryengineV1AnswerGenerationSpecUserDefinedClassifierSpec `json:"userDefinedClassifierSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UserDefinedClassifierSpec")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserDefinedClassifierSpec") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerGenerationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerGenerationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerGenerationSpecUserDefinedClassifierSpec:
// The specification for user defined classifier.
type GoogleCloudDiscoveryengineV1AnswerGenerationSpecUserDefinedClassifierSpec struct {
	// EnableUserDefinedClassifier: Optional. Whether or not to enable and include
	// user defined classifier.
	EnableUserDefinedClassifier bool `json:"enableUserDefinedClassifier,omitempty"`
	// ModelId: Optional. The model id to be used for the user defined classifier.
	ModelId string `json:"modelId,omitempty"`
	// Preamble: Optional. The preamble to be used for the user defined classifier.
	Preamble string `json:"preamble,omitempty"`
	// Seed: Optional. The seed value to be used for the user defined classifier.
	Seed int64 `json:"seed,omitempty"`
	// TaskMarker: Optional. The task marker to be used for the user defined
	// classifier.
	TaskMarker string `json:"taskMarker,omitempty"`
	// Temperature: Optional. The temperature value to be used for the user defined
	// classifier.
	Temperature float64 `json:"temperature,omitempty"`
	// TopK: Optional. The top-k value to be used for the user defined classifier.
	TopK int64 `json:"topK,omitempty,string"`
	// TopP: Optional. The top-p value to be used for the user defined classifier.
	TopP float64 `json:"topP,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "EnableUserDefinedClassifier") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableUserDefinedClassifier") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerGenerationSpecUserDefinedClassifierSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerGenerationSpecUserDefinedClassifierSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1AnswerGenerationSpecUserDefinedClassifierSpec) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerGenerationSpecUserDefinedClassifierSpec
	var s1 struct {
		Temperature gensupport.JSONFloat64 `json:"temperature"`
		TopP        gensupport.JSONFloat64 `json:"topP"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Temperature = float64(s1.Temperature)
	s.TopP = float64(s1.TopP)
	return nil
}

// GoogleCloudDiscoveryengineV1AnswerGroundingSupport: Grounding support for a
// claim in `answer_text`.
type GoogleCloudDiscoveryengineV1AnswerGroundingSupport struct {
	// EndIndex: Required. End of the claim, exclusive.
	EndIndex int64 `json:"endIndex,omitempty,string"`
	// GroundingCheckRequired: Indicates that this claim required grounding check.
	// When the system decided this claim didn't require attribution/grounding
	// check, this field is set to false. In that case, no grounding check was done
	// for the claim and therefore `grounding_score`, `sources` is not returned.
	GroundingCheckRequired bool `json:"groundingCheckRequired,omitempty"`
	// GroundingScore: A score in the range of [0, 1] describing how grounded is a
	// specific claim by the references. Higher value means that the claim is
	// better supported by the reference chunks.
	GroundingScore float64 `json:"groundingScore,omitempty"`
	// Sources: Optional. Citation sources for the claim.
	Sources []*GoogleCloudDiscoveryengineV1AnswerCitationSource `json:"sources,omitempty"`
	// StartIndex: Required. Index indicates the start of the claim, measured in
	// bytes (UTF-8 unicode).
	StartIndex int64 `json:"startIndex,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerGroundingSupport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerGroundingSupport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1AnswerGroundingSupport) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerGroundingSupport
	var s1 struct {
		GroundingScore gensupport.JSONFloat64 `json:"groundingScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.GroundingScore = float64(s1.GroundingScore)
	return nil
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequest: Request message for
// ConversationalSearchService.AnswerQuery method.
type GoogleCloudDiscoveryengineV1AnswerQueryRequest struct {
	// AnswerGenerationSpec: Answer generation specification.
	AnswerGenerationSpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpec `json:"answerGenerationSpec,omitempty"`
	// AsynchronousMode: Deprecated: This field is deprecated. Streaming Answer API
	// will be supported. Asynchronous mode control. If enabled, the response will
	// be returned with answer/session resource name without final answer. The API
	// users need to do the polling to get the latest status of answer/session by
	// calling ConversationalSearchService.GetAnswer or
	// ConversationalSearchService.GetSession method.
	AsynchronousMode bool `json:"asynchronousMode,omitempty"`
	// EndUserSpec: Optional. End user specification.
	EndUserSpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpec `json:"endUserSpec,omitempty"`
	// GroundingSpec: Optional. Grounding specification.
	GroundingSpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestGroundingSpec `json:"groundingSpec,omitempty"`
	// Query: Required. Current user query.
	Query *GoogleCloudDiscoveryengineV1Query `json:"query,omitempty"`
	// QueryUnderstandingSpec: Query understanding specification.
	QueryUnderstandingSpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpec `json:"queryUnderstandingSpec,omitempty"`
	// RelatedQuestionsSpec: Related questions specification.
	RelatedQuestionsSpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestRelatedQuestionsSpec `json:"relatedQuestionsSpec,omitempty"`
	// SafetySpec: Model specification.
	SafetySpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestSafetySpec `json:"safetySpec,omitempty"`
	// SearchSpec: Search specification.
	SearchSpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpec `json:"searchSpec,omitempty"`
	// Session: The session resource name. Not required. When session field is not
	// set, the API is in sessionless mode. We support auto session mode: users can
	// use the wildcard symbol `-` as session ID. A new ID will be automatically
	// generated and assigned.
	Session string `json:"session,omitempty"`
	// UserLabels: The user labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Google Cloud Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// UserPseudoId: A unique identifier for tracking visitors. For example, this
	// could be implemented with an HTTP cookie, which should be able to uniquely
	// identify a visitor on a single device. This unique identifier should not
	// change if the visitor logs in or out of the website. This field should NOT
	// have a fixed value such as `unknown_visitor`. The field must be a UTF-8
	// encoded string with a length limit of 128 characters. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	UserPseudoId string `json:"userPseudoId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerGenerationSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerGenerationSpec") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpec: Answer
// generation specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpec struct {
	// AnswerLanguageCode: Language code for Answer. Use language tags defined by
	// BCP47 (https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Note: This is an
	// experimental feature.
	AnswerLanguageCode string `json:"answerLanguageCode,omitempty"`
	// IgnoreAdversarialQuery: Specifies whether to filter out adversarial queries.
	// The default value is `false`. Google employs search-query classification to
	// detect adversarial queries. No answer is returned if the search query is
	// classified as an adversarial query. For example, a user might ask a question
	// regarding negative comments about the company or submit a query designed to
	// generate unsafe, policy-violating output. If this field is set to `true`, we
	// skip generating answers for adversarial queries and return fallback messages
	// instead.
	IgnoreAdversarialQuery bool `json:"ignoreAdversarialQuery,omitempty"`
	// IgnoreJailBreakingQuery: Optional. Specifies whether to filter out
	// jail-breaking queries. The default value is `false`. Google employs
	// search-query classification to detect jail-breaking queries. No summary is
	// returned if the search query is classified as a jail-breaking query. A user
	// might add instructions to the query to change the tone, style, language,
	// content of the answer, or ask the model to act as a different entity, e.g.
	// "Reply in the tone of a competing company's CEO". If this field is set to
	// `true`, we skip generating summaries for jail-breaking queries and return
	// fallback messages instead.
	IgnoreJailBreakingQuery bool `json:"ignoreJailBreakingQuery,omitempty"`
	// IgnoreLowRelevantContent: Specifies whether to filter out queries that have
	// low relevance. If this field is set to `false`, all search results are used
	// regardless of relevance to generate answers. If set to `true` or unset, the
	// behavior will be determined automatically by the service.
	IgnoreLowRelevantContent bool `json:"ignoreLowRelevantContent,omitempty"`
	// IgnoreNonAnswerSeekingQuery: Specifies whether to filter out queries that
	// are not answer-seeking. The default value is `false`. Google employs
	// search-query classification to detect answer-seeking queries. No answer is
	// returned if the search query is classified as a non-answer seeking query. If
	// this field is set to `true`, we skip generating answers for non-answer
	// seeking queries and return fallback messages instead.
	IgnoreNonAnswerSeekingQuery bool `json:"ignoreNonAnswerSeekingQuery,omitempty"`
	// IncludeCitations: Specifies whether to include citation metadata in the
	// answer. The default value is `false`.
	IncludeCitations bool `json:"includeCitations,omitempty"`
	// ModelSpec: Answer generation model specification.
	ModelSpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecModelSpec `json:"modelSpec,omitempty"`
	// PromptSpec: Answer generation prompt specification.
	PromptSpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecPromptSpec `json:"promptSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerLanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerLanguageCode") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecModelSpec:
// Answer Generation Model specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecModelSpec struct {
	// ModelVersion: Model version. If not set, it will use the default stable
	// model. Allowed values are: stable, preview.
	ModelVersion string `json:"modelVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecModelSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecModelSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecPromptSpec:
//
//	Answer generation prompt specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecPromptSpec struct {
	// Preamble: Customized preamble.
	Preamble string `json:"preamble,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Preamble") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Preamble") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecPromptSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecPromptSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpec: End user
// specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpec struct {
	// EndUserMetadata: Optional. End user metadata.
	EndUserMetadata []*GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaData `json:"endUserMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndUserMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndUserMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaData:
// End user metadata.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaData struct {
	// ChunkInfo: Chunk information.
	ChunkInfo *GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaDataChunkInfo `json:"chunkInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaDataChunk
// Info: Chunk information.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaDataChunkInfo struct {
	// Content: Chunk textual content. It is limited to 8000 characters.
	Content string `json:"content,omitempty"`
	// DocumentMetadata: Metadata of the document from the current chunk.
	DocumentMetadata *GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaDataChunkInfoDocumentMetadata `json:"documentMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaDataChunkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaDataChunkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaDataChunk
// InfoDocumentMetadata: Document metadata contains the information of the
// document of the current chunk.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaDataChunkInfoDocumentMetadata struct {
	// Title: Title of the document.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Title") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Title") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaDataChunkInfoDocumentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaDataChunkInfoDocumentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestGroundingSpec: Grounding
// specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestGroundingSpec struct {
	// FilteringLevel: Optional. Specifies whether to enable the filtering based on
	// grounding score and at what level.
	//
	// Possible values:
	//   "FILTERING_LEVEL_UNSPECIFIED" - Default is no filter
	//   "FILTERING_LEVEL_LOW" - Filter answers based on a low threshold.
	//   "FILTERING_LEVEL_HIGH" - Filter answers based on a high threshold.
	FilteringLevel string `json:"filteringLevel,omitempty"`
	// IncludeGroundingSupports: Optional. Specifies whether to include
	// grounding_supports in the answer. The default value is `false`. When this
	// field is set to `true`, returned answer will have `grounding_score` and will
	// contain GroundingSupports for each claim.
	IncludeGroundingSupports bool `json:"includeGroundingSupports,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FilteringLevel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FilteringLevel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestGroundingSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestGroundingSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpec: Query
// understanding specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpec struct {
	// DisableSpellCorrection: Optional. Whether to disable spell correction. The
	// default value is `false`.
	DisableSpellCorrection bool `json:"disableSpellCorrection,omitempty"`
	// QueryClassificationSpec: Query classification specification.
	QueryClassificationSpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryClassificationSpec `json:"queryClassificationSpec,omitempty"`
	// QueryRephraserSpec: Query rephraser specification.
	QueryRephraserSpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpec `json:"queryRephraserSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisableSpellCorrection") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisableSpellCorrection") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryClas
// sificationSpec: Query classification specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryClassificationSpec struct {
	// Types: Enabled query classification types.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified query classification type.
	//   "ADVERSARIAL_QUERY" - Adversarial query classification type.
	//   "NON_ANSWER_SEEKING_QUERY" - Non-answer-seeking query classification type,
	// for chit chat.
	//   "JAIL_BREAKING_QUERY" - Jail-breaking query classification type.
	//   "NON_ANSWER_SEEKING_QUERY_V2" - Non-answer-seeking query classification
	// type, for no clear intent.
	//   "USER_DEFINED_CLASSIFICATION_QUERY" - User defined query classification
	// type.
	Types []string `json:"types,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Types") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Types") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryClassificationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryClassificationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryReph
// raserSpec: Query rephraser specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpec struct {
	// Disable: Disable query rephraser.
	Disable bool `json:"disable,omitempty"`
	// MaxRephraseSteps: Max rephrase steps. The max number is 5 steps. If not set
	// or set to < 1, it will be set to 1 by default.
	MaxRephraseSteps int64 `json:"maxRephraseSteps,omitempty"`
	// ModelSpec: Optional. Query Rephraser Model specification.
	ModelSpec *GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpecModelSpec `json:"modelSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disable") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryReph
// raserSpecModelSpec: Query Rephraser Model specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpecModelSpec struct {
	// ModelType: Optional. Enabled query rephraser model type. If not set, it will
	// use LARGE by default.
	//
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED" - Unspecified model type.
	//   "SMALL" - Small query rephraser model. Gemini 1.0 XS model.
	//   "LARGE" - Large query rephraser model. Gemini 1.0 Pro model.
	ModelType string `json:"modelType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpecModelSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpecModelSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestRelatedQuestionsSpec: Related
// questions specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestRelatedQuestionsSpec struct {
	// Enable: Enable related questions feature if true.
	Enable bool `json:"enable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enable") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestRelatedQuestionsSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestRelatedQuestionsSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSafetySpec: Safety
// specification. There are two use cases: 1. when only safety_spec.enable is
// set, the BLOCK_LOW_AND_ABOVE threshold will be applied for all categories.
// 2. when safety_spec.enable is set and some safety_settings are set, only
// specified safety_settings are applied.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSafetySpec struct {
	// Enable: Enable the safety filtering on the answer response. It is false by
	// default.
	Enable bool `json:"enable,omitempty"`
	// SafetySettings: Optional. Safety settings. This settings are effective only
	// when the safety_spec.enable is true.
	SafetySettings []*GoogleCloudDiscoveryengineV1AnswerQueryRequestSafetySpecSafetySetting `json:"safetySettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enable") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSafetySpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSafetySpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSafetySpecSafetySetting:
// Safety settings.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSafetySpecSafetySetting struct {
	// Category: Required. Harm category.
	//
	// Possible values:
	//   "HARM_CATEGORY_UNSPECIFIED" - The harm category is unspecified.
	//   "HARM_CATEGORY_HATE_SPEECH" - The harm category is hate speech.
	//   "HARM_CATEGORY_DANGEROUS_CONTENT" - The harm category is dangerous
	// content.
	//   "HARM_CATEGORY_HARASSMENT" - The harm category is harassment.
	//   "HARM_CATEGORY_SEXUALLY_EXPLICIT" - The harm category is sexually explicit
	// content.
	//   "HARM_CATEGORY_CIVIC_INTEGRITY" - The harm category is civic integrity.
	Category string `json:"category,omitempty"`
	// Threshold: Required. The harm block threshold.
	//
	// Possible values:
	//   "HARM_BLOCK_THRESHOLD_UNSPECIFIED" - Unspecified harm block threshold.
	//   "BLOCK_LOW_AND_ABOVE" - Block low threshold and above (i.e. block more).
	//   "BLOCK_MEDIUM_AND_ABOVE" - Block medium threshold and above.
	//   "BLOCK_ONLY_HIGH" - Block only high threshold (i.e. block less).
	//   "BLOCK_NONE" - Block none.
	//   "OFF" - Turn off the safety filter.
	Threshold string `json:"threshold,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Category") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSafetySpecSafetySetting) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSafetySpecSafetySetting
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpec: Search
// specification.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpec struct {
	// SearchParams: Search parameters.
	SearchParams *GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchParams `json:"searchParams,omitempty"`
	// SearchResultList: Search result list.
	SearchResultList *GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultList `json:"searchResultList,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchParams") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchParams") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchParams: Search
// parameters.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchParams struct {
	// BoostSpec: Boost specification to boost certain documents in search results
	// which may affect the answer query response. For more information on
	// boosting, see Boosting (https://cloud.google.com/retail/docs/boosting#boost)
	BoostSpec *GoogleCloudDiscoveryengineV1SearchRequestBoostSpec `json:"boostSpec,omitempty"`
	// DataStoreSpecs: Specs defining dataStores to filter on in a search call and
	// configurations for those dataStores. This is only considered for engines
	// with multiple dataStores use case. For single dataStore within an engine,
	// they should use the specs at the top level.
	DataStoreSpecs []*GoogleCloudDiscoveryengineV1SearchRequestDataStoreSpec `json:"dataStoreSpecs,omitempty"`
	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the documents being
	// filtered. Filter expression is case-sensitive. This will be used to filter
	// search results which may affect the Answer response. If this field is
	// unrecognizable, an `INVALID_ARGUMENT` is returned. Filtering in Vertex AI
	// Search is done by mapping the LHS filter key to a key property defined in
	// the Vertex AI Search backend -- this mapping is defined by the customer in
	// their schema. For example a media customers might have a field 'name' in
	// their schema. In this case the filter would look like this: filter -->
	// name:'ANY("king kong")' For more information about filtering including
	// syntax and filter operators, see Filter
	// (https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
	Filter string `json:"filter,omitempty"`
	// MaxReturnResults: Number of search results to return. The default value is
	// 10.
	MaxReturnResults int64 `json:"maxReturnResults,omitempty"`
	// OrderBy: The order in which documents are returned. Documents can be ordered
	// by a field in an Document object. Leave it unset if ordered by relevance.
	// `order_by` expression is case-sensitive. For more information on ordering,
	// see Ordering (https://cloud.google.com/retail/docs/filter-and-order#order)
	// If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
	OrderBy string `json:"orderBy,omitempty"`
	// SearchResultMode: Specifies the search result mode. If unspecified, the
	// search result mode defaults to `DOCUMENTS`. See parse and chunk documents
	// (https://cloud.google.com/generative-ai-app-builder/docs/parse-chunk-documents)
	//
	// Possible values:
	//   "SEARCH_RESULT_MODE_UNSPECIFIED" - Default value.
	//   "DOCUMENTS" - Returns documents in the search result.
	//   "CHUNKS" - Returns chunks in the search result. Only available if the
	// DocumentProcessingConfig.chunking_config is specified.
	SearchResultMode string `json:"searchResultMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchParams) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultList:
// Search result list.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultList struct {
	// SearchResults: Search results.
	SearchResults []*GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResult `json:"searchResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchResults") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearc
// hResult: Search result.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResult struct {
	// ChunkInfo: Chunk information.
	ChunkInfo *GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfo `json:"chunkInfo,omitempty"`
	// UnstructuredDocumentInfo: Unstructured document information.
	UnstructuredDocumentInfo *GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfo `json:"unstructuredDocumentInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearc
// hResultChunkInfo: Chunk information.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfo struct {
	// Chunk: Chunk resource name.
	Chunk string `json:"chunk,omitempty"`
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// DocumentMetadata: Metadata of the document from the current chunk.
	DocumentMetadata *GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfoDocumentMetadata `json:"documentMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearc
// hResultChunkInfoDocumentMetadata: Document metadata contains the information
// of the document of the current chunk.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfoDocumentMetadata struct {
	// Title: Title of the document.
	Title string `json:"title,omitempty"`
	// Uri: Uri of the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Title") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Title") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfoDocumentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfoDocumentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearc
// hResultUnstructuredDocumentInfo: Unstructured document information.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfo struct {
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// DocumentContexts: List of document contexts. The content will be used for
	// Answer Generation. This is supposed to be the main content of the document
	// that can be long and comprehensive.
	DocumentContexts []*GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoDocumentContext `json:"documentContexts,omitempty"`
	// ExtractiveAnswers: Deprecated: This field is deprecated and will have no
	// effect on the Answer generation. Please use document_contexts and
	// extractive_segments fields. List of extractive answers.
	ExtractiveAnswers []*GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveAnswer `json:"extractiveAnswers,omitempty"`
	// ExtractiveSegments: List of extractive segments.
	ExtractiveSegments []*GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveSegment `json:"extractiveSegments,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearc
// hResultUnstructuredDocumentInfoDocumentContext: Document context.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoDocumentContext struct {
	// Content: Document content to be used for answer generation.
	Content string `json:"content,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoDocumentContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoDocumentContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearc
// hResultUnstructuredDocumentInfoExtractiveAnswer: Extractive answer. Guide
// (https://cloud.google.com/generative-ai-app-builder/docs/snippets#get-answers)
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveAnswer struct {
	// Content: Extractive answer content.
	Content string `json:"content,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearc
// hResultUnstructuredDocumentInfoExtractiveSegment: Extractive segment. Guide
// (https://cloud.google.com/generative-ai-app-builder/docs/snippets#extractive-segments)
// Answer generation will only use it if document_contexts is empty. This is
// supposed to be shorter snippets.
type GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveSegment struct {
	// Content: Extractive segment content.
	Content string `json:"content,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryResponse: Response message for
// ConversationalSearchService.AnswerQuery method.
type GoogleCloudDiscoveryengineV1AnswerQueryResponse struct {
	// Answer: Answer resource object. If
	// AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec.max_rephrase_ste
	// ps is greater than 1, use Answer.name to fetch answer information using
	// ConversationalSearchService.GetAnswer API.
	Answer *GoogleCloudDiscoveryengineV1Answer `json:"answer,omitempty"`
	// AnswerQueryToken: A global unique ID used for logging.
	AnswerQueryToken string `json:"answerQueryToken,omitempty"`
	// Session: Session resource object. It will be only available when session
	// field is set and valid in the AnswerQueryRequest request.
	Session *GoogleCloudDiscoveryengineV1Session `json:"session,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfo: Query
// understanding information.
type GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfo struct {
	// QueryClassificationInfo: Query classification information.
	QueryClassificationInfo []*GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfoQueryClassificationInfo `json:"queryClassificationInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryClassificationInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryClassificationInfo") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfoQueryClassificationIn
// fo: Query classification information.
type GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfoQueryClassificationInfo struct {
	// Positive: Classification output.
	Positive bool `json:"positive,omitempty"`
	// Type: Query classification type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified query classification type.
	//   "ADVERSARIAL_QUERY" - Adversarial query classification type.
	//   "NON_ANSWER_SEEKING_QUERY" - Non-answer-seeking query classification type,
	// for chit chat.
	//   "JAIL_BREAKING_QUERY" - Jail-breaking query classification type.
	//   "NON_ANSWER_SEEKING_QUERY_V2" - Non-answer-seeking query classification
	// type, for no clear intent.
	//   "USER_DEFINED_CLASSIFICATION_QUERY" - User defined query classification
	// type.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Positive") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Positive") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfoQueryClassificationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfoQueryClassificationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerReference: Reference.
type GoogleCloudDiscoveryengineV1AnswerReference struct {
	// ChunkInfo: Chunk information.
	ChunkInfo *GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfo `json:"chunkInfo,omitempty"`
	// StructuredDocumentInfo: Structured document information.
	StructuredDocumentInfo *GoogleCloudDiscoveryengineV1AnswerReferenceStructuredDocumentInfo `json:"structuredDocumentInfo,omitempty"`
	// UnstructuredDocumentInfo: Unstructured document information.
	UnstructuredDocumentInfo *GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfo `json:"unstructuredDocumentInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfo: Chunk information.
type GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfo struct {
	// Chunk: Chunk resource name.
	Chunk string `json:"chunk,omitempty"`
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// DocumentMetadata: Document metadata.
	DocumentMetadata *GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfoDocumentMetadata `json:"documentMetadata,omitempty"`
	// RelevanceScore: The relevance of the chunk for a given query. Values range
	// from 0.0 (completely irrelevant) to 1.0 (completely relevant). This value is
	// for informational purpose only. It may change for the same query and chunk
	// at any time due to a model retraining or change in implementation.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfo
	var s1 struct {
		RelevanceScore gensupport.JSONFloat64 `json:"relevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelevanceScore = float64(s1.RelevanceScore)
	return nil
}

// GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfoDocumentMetadata:
// Document metadata.
type GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfoDocumentMetadata struct {
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// StructData: The structured JSON metadata for the document. It is populated
	// from the struct data from the Chunk in search result.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfoDocumentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfoDocumentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerReferenceStructuredDocumentInfo:
// Structured search information.
type GoogleCloudDiscoveryengineV1AnswerReferenceStructuredDocumentInfo struct {
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// StructData: Structured search data.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Output only. The title of the document.
	Title string `json:"title,omitempty"`
	// Uri: Output only. The URI of the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerReferenceStructuredDocumentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerReferenceStructuredDocumentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfo:
// Unstructured document information.
type GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfo struct {
	// ChunkContents: List of cited chunk contents derived from document content.
	ChunkContents []*GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfoChunkContent `json:"chunkContents,omitempty"`
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// StructData: The structured JSON metadata for the document. It is populated
	// from the struct data from the Chunk in search result.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkContents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfoChunkConte
// nt: Chunk content.
type GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfoChunkContent struct {
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// RelevanceScore: The relevance of the chunk for a given query. Values range
	// from 0.0 (completely irrelevant) to 1.0 (completely relevant). This value is
	// for informational purpose only. It may change for the same query and chunk
	// at any time due to a model retraining or change in implementation.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfoChunkContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfoChunkContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfoChunkContent) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfoChunkContent
	var s1 struct {
		RelevanceScore gensupport.JSONFloat64 `json:"relevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelevanceScore = float64(s1.RelevanceScore)
	return nil
}

// GoogleCloudDiscoveryengineV1AnswerStep: Step information.
type GoogleCloudDiscoveryengineV1AnswerStep struct {
	// Actions: Actions.
	Actions []*GoogleCloudDiscoveryengineV1AnswerStepAction `json:"actions,omitempty"`
	// Description: The description of the step.
	Description string `json:"description,omitempty"`
	// State: The state of the step.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown.
	//   "IN_PROGRESS" - Step is currently in progress.
	//   "FAILED" - Step currently failed.
	//   "SUCCEEDED" - Step has succeeded.
	State string `json:"state,omitempty"`
	// Thought: The thought of the step.
	Thought string `json:"thought,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerStep) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerStep
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerStepAction: Action.
type GoogleCloudDiscoveryengineV1AnswerStepAction struct {
	// Observation: Observation.
	Observation *GoogleCloudDiscoveryengineV1AnswerStepActionObservation `json:"observation,omitempty"`
	// SearchAction: Search action.
	SearchAction *GoogleCloudDiscoveryengineV1AnswerStepActionSearchAction `json:"searchAction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Observation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Observation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerStepAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerStepAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerStepActionObservation: Observation.
type GoogleCloudDiscoveryengineV1AnswerStepActionObservation struct {
	// SearchResults: Search results observed by the search action, it can be
	// snippets info or chunk info, depending on the citation type set by the user.
	SearchResults []*GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResult `json:"searchResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchResults") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerStepActionObservation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerStepActionObservation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResult struct {
	// ChunkInfo: If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
	// populate chunk info.
	ChunkInfo []*GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultChunkInfo `json:"chunkInfo,omitempty"`
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// SnippetInfo: If citation_type is DOCUMENT_LEVEL_CITATION, populate document
	// level snippets.
	SnippetInfo []*GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultSnippetInfo `json:"snippetInfo,omitempty"`
	// StructData: Data representation. The structured JSON data for the document.
	// It's populated from the struct data from the Document, or the Chunk in
	// search result.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultChunkInfo:
//
//	Chunk information.
type GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultChunkInfo struct {
	// Chunk: Chunk resource name.
	Chunk string `json:"chunk,omitempty"`
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// RelevanceScore: The relevance of the chunk for a given query. Values range
	// from 0.0 (completely irrelevant) to 1.0 (completely relevant). This value is
	// for informational purpose only. It may change for the same query and chunk
	// at any time due to a model retraining or change in implementation.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultChunkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultChunkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultChunkInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultChunkInfo
	var s1 struct {
		RelevanceScore gensupport.JSONFloat64 `json:"relevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelevanceScore = float64(s1.RelevanceScore)
	return nil
}

// GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultSnippetInf
// o: Snippet information.
type GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultSnippetInfo struct {
	// Snippet: Snippet content.
	Snippet string `json:"snippet,omitempty"`
	// SnippetStatus: Status of the snippet defined by the search team.
	SnippetStatus string `json:"snippetStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Snippet") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Snippet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultSnippetInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultSnippetInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AnswerStepActionSearchAction: Search action.
type GoogleCloudDiscoveryengineV1AnswerStepActionSearchAction struct {
	// Query: The query to search.
	Query string `json:"query,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Query") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Query") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AnswerStepActionSearchAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AnswerStepActionSearchAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistAnswer: AssistAnswer resource, main part
// of AssistResponse.
type GoogleCloudDiscoveryengineV1AssistAnswer struct {
	// AssistSkippedReasons: Reasons for not answering the assist call.
	//
	// Possible values:
	//   "ASSIST_SKIPPED_REASON_UNSPECIFIED" - Default value. Skip reason is not
	// specified.
	//   "NON_ASSIST_SEEKING_QUERY_IGNORED" - The assistant ignored the query,
	// because it did not appear to be answer-seeking.
	//   "CUSTOMER_POLICY_VIOLATION" - The assistant ignored the query or refused
	// to answer because of a customer policy violation (e.g., the query or the
	// answer contained a banned phrase).
	AssistSkippedReasons []string `json:"assistSkippedReasons,omitempty"`
	// CustomerPolicyEnforcementResult: Optional. The field contains information
	// about the various policy checks' results like the banned phrases or the
	// Model Armor checks. This field is populated only if the assist call was
	// skipped due to a policy violation.
	CustomerPolicyEnforcementResult *GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResult `json:"customerPolicyEnforcementResult,omitempty"`
	// Name: Immutable. Identifier. Resource name of the `AssistAnswer`. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/engines/{en
	// gine}/sessions/{session}/assistAnswers/{assist_answer}` This field must be a
	// UTF-8 encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// Replies: Replies of the assistant.
	Replies []*GoogleCloudDiscoveryengineV1AssistAnswerReply `json:"replies,omitempty"`
	// State: State of the answer generation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown.
	//   "IN_PROGRESS" - Assist operation is currently in progress.
	//   "FAILED" - Assist operation has failed.
	//   "SUCCEEDED" - Assist operation has succeeded.
	//   "SKIPPED" - Assist operation has been skipped.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssistSkippedReasons") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssistSkippedReasons") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResult:
// Customer policy enforcement results. Contains the results of the various
// policy checks, like the banned phrases or the Model Armor checks.
type GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResult struct {
	// PolicyResults: Customer policy enforcement results. Populated only if the
	// assist call was skipped due to a policy violation. It contains results from
	// those filters that blocked the processing of the query.
	PolicyResults []*GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResultPolicyEnforcementResult `json:"policyResults,omitempty"`
	// Verdict: Final verdict of the customer policy enforcement. If only one
	// policy blocked the processing, the verdict is BLOCK.
	//
	// Possible values:
	//   "UNSPECIFIED" - Unknown value.
	//   "ALLOW" - There was no policy violation.
	//   "BLOCK" - Processing was blocked by the customer policy.
	Verdict string `json:"verdict,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PolicyResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PolicyResults") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResultBanned
// PhraseEnforcementResult: Customer policy enforcement result for the banned
// phrase policy.
type GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResultBannedPhraseEnforcementResult struct {
	// BannedPhrases: The banned phrases that were found in the query or the
	// answer.
	BannedPhrases []string `json:"bannedPhrases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BannedPhrases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BannedPhrases") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResultBannedPhraseEnforcementResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResultBannedPhraseEnforcementResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResultModelA
// rmorEnforcementResult: Customer policy enforcement result for the Model
// Armor policy.
type GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResultModelArmorEnforcementResult struct {
	// Error: The error returned by Model Armor if the policy enforcement failed
	// for some reason.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// ModelArmorViolation: The Model Armor violation that was found.
	ModelArmorViolation string `json:"modelArmorViolation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResultModelArmorEnforcementResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResultModelArmorEnforcementResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResultPolicy
// EnforcementResult: Customer policy enforcement result for a single policy
// type.
type GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResultPolicyEnforcementResult struct {
	// BannedPhraseEnforcementResult: The policy enforcement result for the banned
	// phrase policy.
	BannedPhraseEnforcementResult *GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResultBannedPhraseEnforcementResult `json:"bannedPhraseEnforcementResult,omitempty"`
	// ModelArmorEnforcementResult: The policy enforcement result for the Model
	// Armor policy.
	ModelArmorEnforcementResult *GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResultModelArmorEnforcementResult `json:"modelArmorEnforcementResult,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "BannedPhraseEnforcementResult") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BannedPhraseEnforcementResult")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResultPolicyEnforcementResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistAnswerCustomerPolicyEnforcementResultPolicyEnforcementResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistAnswerReply: One part of the multi-part
// response of the assist call.
type GoogleCloudDiscoveryengineV1AssistAnswerReply struct {
	// GroundedContent: Possibly grounded response text or media from the
	// assistant.
	GroundedContent *GoogleCloudDiscoveryengineV1AssistantGroundedContent `json:"groundedContent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GroundedContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GroundedContent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistAnswerReply) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistAnswerReply
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistUserMetadata: User metadata of the
// request.
type GoogleCloudDiscoveryengineV1AssistUserMetadata struct {
	// PreferredLanguageCode: Optional. Preferred language to be used for answering
	// if language detection fails. Also used as the language of error messages
	// created by actions, regardless of language detection results.
	PreferredLanguageCode string `json:"preferredLanguageCode,omitempty"`
	// TimeZone: Optional. IANA time zone, e.g. Europe/Budapest.
	TimeZone string `json:"timeZone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PreferredLanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PreferredLanguageCode") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistUserMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistUserMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Assistant: Discovery Engine Assistant resource.
type GoogleCloudDiscoveryengineV1Assistant struct {
	// CustomerPolicy: Optional. Customer policy for the assistant.
	CustomerPolicy *GoogleCloudDiscoveryengineV1AssistantCustomerPolicy `json:"customerPolicy,omitempty"`
	// EnabledTools: Optional. Note: not implemented yet. Use enabled_actions
	// instead. The enabled tools on this assistant. The keys are connector name,
	// for example
	// "projects/{projectId}/locations/{locationId}/collections/{collectionId}/datac
	// onnector The values consist of admin enabled tools towards the connector
	// instance. Admin can selectively enable multiple tools on any of the
	// connector instances that they created in the project. For example
	// {"jira1ConnectorName": [(toolId1, "createTicket"), (toolId2,
	// "transferTicket")], "gmail1ConnectorName": [(toolId3, "sendEmail"),..] }
	EnabledTools map[string]GoogleCloudDiscoveryengineV1AssistantToolList `json:"enabledTools,omitempty"`
	// GenerationConfig: Optional. Configuration for the generation of the
	// assistant response.
	GenerationConfig *GoogleCloudDiscoveryengineV1AssistantGenerationConfig `json:"generationConfig,omitempty"`
	// Name: Immutable. Resource name of the assistant. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/engines/{en
	// gine}/assistants/{assistant}` It must be a UTF-8 encoded string with a
	// length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// WebGroundingType: Optional. The type of web grounding to use.
	//
	// Possible values:
	//   "WEB_GROUNDING_TYPE_UNSPECIFIED" - Default, unspecified setting. This is
	// the same as disabled.
	//   "WEB_GROUNDING_TYPE_DISABLED" - Web grounding is disabled.
	//   "WEB_GROUNDING_TYPE_GOOGLE_SEARCH" - Grounding with Google Search is
	// enabled.
	//   "WEB_GROUNDING_TYPE_ENTERPRISE_WEB_SEARCH" - Grounding with Enterprise Web
	// Search is enabled.
	WebGroundingType string `json:"webGroundingType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CustomerPolicy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomerPolicy") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Assistant) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Assistant
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistantContent: Multi-modal content.
type GoogleCloudDiscoveryengineV1AssistantContent struct {
	// CodeExecutionResult: Result of executing an ExecutableCode.
	CodeExecutionResult *GoogleCloudDiscoveryengineV1AssistantContentCodeExecutionResult `json:"codeExecutionResult,omitempty"`
	// ExecutableCode: Code generated by the model that is meant to be executed.
	ExecutableCode *GoogleCloudDiscoveryengineV1AssistantContentExecutableCode `json:"executableCode,omitempty"`
	// File: A file, e.g., an audio summary.
	File *GoogleCloudDiscoveryengineV1AssistantContentFile `json:"file,omitempty"`
	// InlineData: Inline binary data.
	InlineData *GoogleCloudDiscoveryengineV1AssistantContentBlob `json:"inlineData,omitempty"`
	// Role: The producer of the content. Can be "model" or "user".
	Role string `json:"role,omitempty"`
	// Text: Inline text.
	Text string `json:"text,omitempty"`
	// Thought: Optional. Indicates if the part is thought from the model.
	Thought bool `json:"thought,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CodeExecutionResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CodeExecutionResult") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistantContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistantContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistantContentBlob: Inline blob.
type GoogleCloudDiscoveryengineV1AssistantContentBlob struct {
	// Data: Required. Raw bytes.
	Data string `json:"data,omitempty"`
	// MimeType: Required. The media type (MIME type) of the generated data.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Data") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Data") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistantContentBlob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistantContentBlob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistantContentCodeExecutionResult: Result of
// executing ExecutableCode.
type GoogleCloudDiscoveryengineV1AssistantContentCodeExecutionResult struct {
	// Outcome: Required. Outcome of the code execution.
	//
	// Possible values:
	//   "OUTCOME_UNSPECIFIED" - Unspecified status. This value should not be used.
	//   "OUTCOME_OK" - Code execution completed successfully.
	//   "OUTCOME_FAILED" - Code execution finished but with a failure. `stderr`
	// should contain the reason.
	//   "OUTCOME_DEADLINE_EXCEEDED" - Code execution ran for too long, and was
	// cancelled. There may or may not be a partial output present.
	Outcome string `json:"outcome,omitempty"`
	// Output: Optional. Contains stdout when code execution is successful, stderr
	// or other description otherwise.
	Output string `json:"output,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Outcome") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Outcome") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistantContentCodeExecutionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistantContentCodeExecutionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistantContentExecutableCode: Code generated
// by the model that is meant to be executed by the model.
type GoogleCloudDiscoveryengineV1AssistantContentExecutableCode struct {
	// Code: Required. The code content. Currently only supports Python.
	Code string `json:"code,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistantContentExecutableCode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistantContentExecutableCode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistantContentFile: A file, e.g., an audio
// summary.
type GoogleCloudDiscoveryengineV1AssistantContentFile struct {
	// FileId: Required. The file ID.
	FileId string `json:"fileId,omitempty"`
	// MimeType: Required. The media type (MIME type) of the file.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistantContentFile) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistantContentFile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistantCustomerPolicy: Customer-defined policy
// for the assistant.
type GoogleCloudDiscoveryengineV1AssistantCustomerPolicy struct {
	// BannedPhrases: Optional. List of banned phrases.
	BannedPhrases []*GoogleCloudDiscoveryengineV1AssistantCustomerPolicyBannedPhrase `json:"bannedPhrases,omitempty"`
	// ModelArmorConfig: Optional. Model Armor configuration to be used for
	// sanitizing user prompts and assistant responses.
	ModelArmorConfig *GoogleCloudDiscoveryengineV1AssistantCustomerPolicyModelArmorConfig `json:"modelArmorConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BannedPhrases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BannedPhrases") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistantCustomerPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistantCustomerPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistantCustomerPolicyBannedPhrase: Definition
// of a customer-defined banned phrase. A banned phrase is not allowed to
// appear in the user query or the LLM response, or else the answer will be
// refused.
type GoogleCloudDiscoveryengineV1AssistantCustomerPolicyBannedPhrase struct {
	// IgnoreDiacritics: Optional. If true, diacritical marks (e.g., accents,
	// umlauts) are ignored when matching banned phrases. For example, "cafe" would
	// match "café".
	IgnoreDiacritics bool `json:"ignoreDiacritics,omitempty"`
	// MatchType: Optional. Match type for the banned phrase.
	//
	// Possible values:
	//   "BANNED_PHRASE_MATCH_TYPE_UNSPECIFIED" - Defaults to SIMPLE_STRING_MATCH.
	//   "SIMPLE_STRING_MATCH" - The banned phrase matches if it is found anywhere
	// in the text as an exact substring.
	//   "WORD_BOUNDARY_STRING_MATCH" - Banned phrase only matches if the pattern
	// found in the text is surrounded by word delimiters. The phrase itself may
	// still contain word delimiters.
	MatchType string `json:"matchType,omitempty"`
	// Phrase: Required. The raw string content to be banned.
	Phrase string `json:"phrase,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IgnoreDiacritics") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IgnoreDiacritics") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistantCustomerPolicyBannedPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistantCustomerPolicyBannedPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistantCustomerPolicyModelArmorConfig:
// Configuration for customer defined Model Armor templates to be used for
// sanitizing user prompts and assistant responses.
type GoogleCloudDiscoveryengineV1AssistantCustomerPolicyModelArmorConfig struct {
	// FailureMode: Optional. Defines the failure mode for Model Armor
	// sanitization.
	//
	// Possible values:
	//   "FAILURE_MODE_UNSPECIFIED" - Unspecified failure mode, default behavior is
	// `FAIL_CLOSED`.
	//   "FAIL_OPEN" - In case of a Model Armor processing failure, the request is
	// allowed to proceed without any changes.
	//   "FAIL_CLOSED" - In case of a Model Armor processing failure, the request
	// is rejected.
	FailureMode string `json:"failureMode,omitempty"`
	// ResponseTemplate: Optional. The resource name of the Model Armor template
	// for sanitizing assistant responses. Format:
	// `projects/{project}/locations/{location}/templates/{template_id}` If not
	// specified, no sanitization will be applied to the assistant response.
	ResponseTemplate string `json:"responseTemplate,omitempty"`
	// UserPromptTemplate: Optional. The resource name of the Model Armor template
	// for sanitizing user prompts. Format:
	// `projects/{project}/locations/{location}/templates/{template_id}` If not
	// specified, no sanitization will be applied to the user prompt.
	UserPromptTemplate string `json:"userPromptTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailureMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailureMode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistantCustomerPolicyModelArmorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistantCustomerPolicyModelArmorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistantGenerationConfig: Configuration for the
// generation of the assistant response.
type GoogleCloudDiscoveryengineV1AssistantGenerationConfig struct {
	// DefaultLanguage: The default language to use for the generation of the
	// assistant response. Use an ISO 639-1 language code such as `en`. If not
	// specified, the language will be automatically detected.
	DefaultLanguage string `json:"defaultLanguage,omitempty"`
	// SystemInstruction: System instruction, also known as the prompt preamble for
	// LLM calls. See also
	// https://cloud.google.com/vertex-ai/generative-ai/docs/learn/prompts/system-instructions
	SystemInstruction *GoogleCloudDiscoveryengineV1AssistantGenerationConfigSystemInstruction `json:"systemInstruction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultLanguage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultLanguage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistantGenerationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistantGenerationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistantGenerationConfigSystemInstruction:
// System instruction, also known as the prompt preamble for LLM calls.
type GoogleCloudDiscoveryengineV1AssistantGenerationConfigSystemInstruction struct {
	// AdditionalSystemInstruction: Optional. Additional system instruction that
	// will be added to the default system instruction.
	AdditionalSystemInstruction string `json:"additionalSystemInstruction,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AdditionalSystemInstruction") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalSystemInstruction") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistantGenerationConfigSystemInstruction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistantGenerationConfigSystemInstruction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistantGroundedContent: A piece of content and
// possibly its grounding information. Not all content needs grounding. Phrases
// like "Of course, I will gladly search it for you." do not need grounding.
type GoogleCloudDiscoveryengineV1AssistantGroundedContent struct {
	// CitationMetadata: Source attribution of the generated content. See also
	// https://cloud.google.com/vertex-ai/generative-ai/docs/learn/overview#citation_check
	CitationMetadata *GoogleCloudDiscoveryengineV1CitationMetadata `json:"citationMetadata,omitempty"`
	// Content: The content.
	Content *GoogleCloudDiscoveryengineV1AssistantContent `json:"content,omitempty"`
	// TextGroundingMetadata: Metadata for grounding based on text sources.
	TextGroundingMetadata *GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadata `json:"textGroundingMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistantGroundedContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistantGroundedContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadata:
// Grounding details for text sources.
type GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadata struct {
	// References: References for the grounded text.
	References []*GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataReference `json:"references,omitempty"`
	// Segments: Grounding information for parts of the text.
	Segments []*GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataSegment `json:"segments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "References") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "References") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataRefe
// rence: Referenced content and related document metadata.
type GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataReference struct {
	// Content: Referenced text content.
	Content string `json:"content,omitempty"`
	// DocumentMetadata: Document metadata.
	DocumentMetadata *GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataReferenceDocumentMetadata `json:"documentMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataRefe
// renceDocumentMetadata: Document metadata.
type GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataReferenceDocumentMetadata struct {
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// Domain: Domain name from the document URI. Note that the `uri` field may
	// contain a URL that redirects to the actual website, in which case this will
	// contain the domain name of the target site.
	Domain string `json:"domain,omitempty"`
	// MimeType: The mime type of the document.
	// https://www.iana.org/assignments/media-types/media-types.xhtml.
	MimeType string `json:"mimeType,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document. It may contain a URL that redirects to the actual
	// website.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataReferenceDocumentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataReferenceDocumentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataSegm
// ent: Grounding information for a segment of the text.
type GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataSegment struct {
	// EndIndex: End of the segment, exclusive.
	EndIndex int64 `json:"endIndex,omitempty,string"`
	// GroundingScore: Score for the segment.
	GroundingScore float64 `json:"groundingScore,omitempty"`
	// ReferenceIndices: References for the segment.
	ReferenceIndices []int64 `json:"referenceIndices,omitempty"`
	// StartIndex: Zero-based index indicating the start of the segment, measured
	// in bytes of a UTF-8 string (i.e. characters encoded on multiple bytes have a
	// length of more than one).
	StartIndex int64 `json:"startIndex,omitempty,string"`
	// Text: The text segment itself.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataSegment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataSegment
	var s1 struct {
		GroundingScore gensupport.JSONFloat64 `json:"groundingScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.GroundingScore = float64(s1.GroundingScore)
	return nil
}

// GoogleCloudDiscoveryengineV1AssistantToolInfo: Information to identify a
// tool.
type GoogleCloudDiscoveryengineV1AssistantToolInfo struct {
	// ToolDisplayName: The display name of the tool.
	ToolDisplayName string `json:"toolDisplayName,omitempty"`
	// ToolName: The name of the tool as defined by
	// DataConnectorService.QueryAvailableActions. Note: it's using `action` in the
	// DataConnectorService apis, but they are the same as the `tool` here.
	ToolName string `json:"toolName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ToolDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ToolDisplayName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistantToolInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistantToolInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AssistantToolList: The enabled tools on a
// connector
type GoogleCloudDiscoveryengineV1AssistantToolList struct {
	// ToolInfo: The list of tools with corresponding tool information.
	ToolInfo []*GoogleCloudDiscoveryengineV1AssistantToolInfo `json:"toolInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ToolInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ToolInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1AssistantToolList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1AssistantToolList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BAPConfig: The configuration for the BAP
// connector.
type GoogleCloudDiscoveryengineV1BAPConfig struct {
	// EnabledActions: Optional. The actions enabled on the associated BAP
	// connection.
	EnabledActions []string `json:"enabledActions,omitempty"`
	// SupportedConnectorModes: Required. The supported connector modes for the
	// associated BAP connection.
	//
	// Possible values:
	//   "CONNECTOR_MODE_UNSPECIFIED" - Connector mode unspecified.
	//   "DATA_INGESTION" - Connector utilized for data ingestion.
	//   "ACTIONS" - Connector utilized for Actions
	//   "END_USER_AUTHENTICATION" - Connector utilized for End User
	// Authentication.
	SupportedConnectorModes []string `json:"supportedConnectorModes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnabledActions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnabledActions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BAPConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BAPConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BatchCreateTargetSiteMetadata: Metadata related
// to the progress of the SiteSearchEngineService.BatchCreateTargetSites
// operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1BatchCreateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BatchCreateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BatchCreateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BatchCreateTargetSitesRequest: Request message
// for SiteSearchEngineService.BatchCreateTargetSites method.
type GoogleCloudDiscoveryengineV1BatchCreateTargetSitesRequest struct {
	// Requests: Required. The request message specifying the resources to create.
	// A maximum of 20 TargetSites can be created in a batch.
	Requests []*GoogleCloudDiscoveryengineV1CreateTargetSiteRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BatchCreateTargetSitesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BatchCreateTargetSitesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BatchCreateTargetSitesResponse: Response message
// for SiteSearchEngineService.BatchCreateTargetSites method.
type GoogleCloudDiscoveryengineV1BatchCreateTargetSitesResponse struct {
	// TargetSites: TargetSites created.
	TargetSites []*GoogleCloudDiscoveryengineV1TargetSite `json:"targetSites,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TargetSites") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TargetSites") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BatchCreateTargetSitesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BatchCreateTargetSitesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponse: Response
// message for DocumentService.BatchGetDocumentsMetadata method.
type GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponse struct {
	// DocumentsMetadata: The metadata of the Documents.
	DocumentsMetadata []*GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponseDocumentMetadata `json:"documentsMetadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DocumentsMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentsMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponseDocumentMetadata
// : The metadata of a Document.
type GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponseDocumentMetadata struct {
	// DataIngestionSource: The data ingestion source of the Document. Allowed
	// values are: * `batch`: Data ingested via Batch API, e.g., ImportDocuments. *
	// `streaming` Data ingested via Streaming API, e.g., FHIR streaming.
	DataIngestionSource string `json:"dataIngestionSource,omitempty"`
	// LastRefreshedTime: The timestamp of the last time the Document was last
	// indexed.
	LastRefreshedTime string `json:"lastRefreshedTime,omitempty"`
	// MatcherValue: The value of the matcher that was used to match the Document.
	MatcherValue *GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponseDocumentMetadataMatcherValue `json:"matcherValue,omitempty"`
	// State: The state of the document.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Should never be set.
	//   "INDEXED" - The Document is indexed.
	//   "NOT_IN_TARGET_SITE" - The Document is not indexed because its URI is not
	// in the TargetSite.
	//   "NOT_IN_INDEX" - The Document is not indexed.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataIngestionSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataIngestionSource") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponseDocumentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponseDocumentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponseDocumentMetadata
// MatcherValue: The value of the matcher that was used to match the Document.
type GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponseDocumentMetadataMatcherValue struct {
	// FhirResource: Format:
	// projects/{project}/locations/{location}/datasets/{dataset}/fhirStores/{fhir_s
	// tore}/fhir/{resource_type}/{fhir_resource_id}
	FhirResource string `json:"fhirResource,omitempty"`
	// Uri: If match by URI, the URI of the Document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FhirResource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FhirResource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponseDocumentMetadataMatcherValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponseDocumentMetadataMatcherValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesMetadata: Metadata
// related to the progress of the UserLicenseService.BatchUpdateUserLicenses
// operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of user licenses that failed to be updated.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of user licenses successfully updated.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesRequest: Request message
// for UserLicenseService.BatchUpdateUserLicenses method.
type GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesRequest struct {
	// DeleteUnassignedUserLicenses: Optional. If true, if user licenses removed
	// associated license config, the user license will be deleted. By default
	// which is false, the user license will be updated to unassigned state.
	DeleteUnassignedUserLicenses bool `json:"deleteUnassignedUserLicenses,omitempty"`
	// InlineSource: The inline source for the input content for document
	// embeddings.
	InlineSource *GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesRequestInlineSource `json:"inlineSource,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "DeleteUnassignedUserLicenses") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeleteUnassignedUserLicenses") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesRequestInlineSource: The
// inline source for the input config for BatchUpdateUserLicenses method.
type GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesRequestInlineSource struct {
	// UpdateMask: Optional. The list of fields to update.
	UpdateMask string `json:"updateMask,omitempty"`
	// UserLicenses: Required. A list of user licenses to update. Each user license
	// must have a valid UserLicense.user_principal.
	UserLicenses []*GoogleCloudDiscoveryengineV1UserLicense `json:"userLicenses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UpdateMask") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UpdateMask") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesRequestInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesResponse: Response
// message for UserLicenseService.BatchUpdateUserLicenses method.
type GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// UserLicenses: UserLicenses successfully updated.
	UserLicenses []*GoogleCloudDiscoveryengineV1UserLicense `json:"userLicenses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BatchVerifyTargetSitesRequest: Request message
// for SiteSearchEngineService.BatchVerifyTargetSites method.
type GoogleCloudDiscoveryengineV1BatchVerifyTargetSitesRequest struct {
}

// GoogleCloudDiscoveryengineV1BigQuerySource: BigQuery source import data
// from.
type GoogleCloudDiscoveryengineV1BigQuerySource struct {
	// DataSchema: The schema to use when parsing the data from the source.
	// Supported values for user event imports: * `user_event` (default): One
	// UserEvent per row. Supported values for document imports: * `document`
	// (default): One Document format per row. Each document must have a valid
	// Document.id and one of Document.json_data or Document.struct_data. *
	// `custom`: One custom data per row in arbitrary format that conforms to the
	// defined Schema of the data store. This can only be used by the GENERIC Data
	// Store vertical.
	DataSchema string `json:"dataSchema,omitempty"`
	// DatasetId: Required. The BigQuery data set to copy the data from with a
	// length limit of 1,024 characters.
	DatasetId string `json:"datasetId,omitempty"`
	// GcsStagingDir: Intermediate Cloud Storage directory used for the import with
	// a length limit of 2,000 characters. Can be specified if one wants to have
	// the BigQuery export to a specific Cloud Storage directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`
	// PartitionDate: BigQuery time partitioned table's _PARTITIONDATE in
	// YYYY-MM-DD format.
	PartitionDate *GoogleTypeDate `json:"partitionDate,omitempty"`
	// ProjectId: The project ID or the project number that contains the BigQuery
	// source. Has a length limit of 128 characters. If not specified, inherits the
	// project ID from the parent request.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Required. The BigQuery table to copy the data from with a length
	// limit of 1,024 characters.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BigQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BigQuerySource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BigtableOptions: The Bigtable Options object
// that contains information to support the import.
type GoogleCloudDiscoveryengineV1BigtableOptions struct {
	// Families: The mapping from family names to an object that contains column
	// families level information for the given column family. If a family is not
	// present in this map it will be ignored.
	Families map[string]GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumnFamily `json:"families,omitempty"`
	// KeyFieldName: The field name used for saving row key value in the document.
	// The name has to match the pattern `a-zA-Z0-9*`.
	KeyFieldName string `json:"keyFieldName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Families") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Families") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BigtableOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BigtableOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumn: The column of the
// Bigtable.
type GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumn struct {
	// Encoding: The encoding mode of the values when the type is not `STRING`.
	// Acceptable encoding values are: * `TEXT`: indicates values are alphanumeric
	// text strings. * `BINARY`: indicates values are encoded using `HBase
	// Bytes.toBytes` family of functions. This can be overridden for a specific
	// column by listing that column in `columns` and specifying an encoding for
	// it.
	//
	// Possible values:
	//   "ENCODING_UNSPECIFIED" - The encoding is unspecified.
	//   "TEXT" - Text encoding.
	//   "BINARY" - Binary encoding.
	Encoding string `json:"encoding,omitempty"`
	// FieldName: The field name to use for this column in the document. The name
	// has to match the pattern `a-zA-Z0-9*`. If not set, it is parsed from the
	// qualifier bytes with best effort. However, due to different naming patterns,
	// field name collisions could happen, where parsing behavior is undefined.
	FieldName string `json:"fieldName,omitempty"`
	// Qualifier: Required. Qualifier of the column. If it cannot be decoded with
	// utf-8, use a base-64 encoded string instead.
	Qualifier string `json:"qualifier,omitempty"`
	// Type: The type of values in this column family. The values are expected to
	// be encoded using `HBase Bytes.toBytes` function when the encoding value is
	// set to `BINARY`.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The type is unspecified.
	//   "STRING" - String type.
	//   "NUMBER" - Numerical type.
	//   "INTEGER" - Integer type.
	//   "VAR_INTEGER" - Variable length integer type.
	//   "BIG_NUMERIC" - BigDecimal type.
	//   "BOOLEAN" - Boolean type.
	//   "JSON" - JSON type.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Encoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Encoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumn) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumn
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumnFamily: The column
// family of the Bigtable.
type GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumnFamily struct {
	// Columns: The list of objects that contains column level information for each
	// column. If a column is not present in this list it will be ignored.
	Columns []*GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumn `json:"columns,omitempty"`
	// Encoding: The encoding mode of the values when the type is not STRING.
	// Acceptable encoding values are: * `TEXT`: indicates values are alphanumeric
	// text strings. * `BINARY`: indicates values are encoded using `HBase
	// Bytes.toBytes` family of functions. This can be overridden for a specific
	// column by listing that column in `columns` and specifying an encoding for
	// it.
	//
	// Possible values:
	//   "ENCODING_UNSPECIFIED" - The encoding is unspecified.
	//   "TEXT" - Text encoding.
	//   "BINARY" - Binary encoding.
	Encoding string `json:"encoding,omitempty"`
	// FieldName: The field name to use for this column family in the document. The
	// name has to match the pattern `a-zA-Z0-9*`. If not set, it is parsed from
	// the family name with best effort. However, due to different naming patterns,
	// field name collisions could happen, where parsing behavior is undefined.
	FieldName string `json:"fieldName,omitempty"`
	// Type: The type of values in this column family. The values are expected to
	// be encoded using `HBase Bytes.toBytes` function when the encoding value is
	// set to `BINARY`.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The type is unspecified.
	//   "STRING" - String type.
	//   "NUMBER" - Numerical type.
	//   "INTEGER" - Integer type.
	//   "VAR_INTEGER" - Variable length integer type.
	//   "BIG_NUMERIC" - BigDecimal type.
	//   "BOOLEAN" - Boolean type.
	//   "JSON" - JSON type.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Columns") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Columns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumnFamily) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumnFamily
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BigtableSource: The Cloud Bigtable source for
// importing data.
type GoogleCloudDiscoveryengineV1BigtableSource struct {
	// BigtableOptions: Required. Bigtable options that contains information needed
	// when parsing data into typed structures. For example, column type
	// annotations.
	BigtableOptions *GoogleCloudDiscoveryengineV1BigtableOptions `json:"bigtableOptions,omitempty"`
	// InstanceId: Required. The instance ID of the Cloud Bigtable that needs to be
	// imported.
	InstanceId string `json:"instanceId,omitempty"`
	// ProjectId: The project ID that contains the Bigtable source. Has a length
	// limit of 128 characters. If not specified, inherits the project ID from the
	// parent request.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Required. The table ID of the Cloud Bigtable that needs to be
	// imported.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigtableOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigtableOptions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BigtableSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BigtableSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CheckGroundingRequest: Request message for
// GroundedGenerationService.CheckGrounding method.
type GoogleCloudDiscoveryengineV1CheckGroundingRequest struct {
	// AnswerCandidate: Answer candidate to check. It can have a maximum length of
	// 4096 tokens.
	AnswerCandidate string `json:"answerCandidate,omitempty"`
	// Facts: List of facts for the grounding check. We support up to 200 facts.
	Facts []*GoogleCloudDiscoveryengineV1GroundingFact `json:"facts,omitempty"`
	// GroundingSpec: Configuration of the grounding check.
	GroundingSpec *GoogleCloudDiscoveryengineV1CheckGroundingSpec `json:"groundingSpec,omitempty"`
	// UserLabels: The user labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Google Cloud Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerCandidate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerCandidate") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CheckGroundingRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CheckGroundingRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CheckGroundingResponse: Response message for the
// GroundedGenerationService.CheckGrounding method.
type GoogleCloudDiscoveryengineV1CheckGroundingResponse struct {
	// CitedChunks: List of facts cited across all claims in the answer candidate.
	// These are derived from the facts supplied in the request.
	CitedChunks []*GoogleCloudDiscoveryengineV1FactChunk `json:"citedChunks,omitempty"`
	// CitedFacts: List of facts cited across all claims in the answer candidate.
	// These are derived from the facts supplied in the request.
	CitedFacts []*GoogleCloudDiscoveryengineV1CheckGroundingResponseCheckGroundingFactChunk `json:"citedFacts,omitempty"`
	// Claims: Claim texts and citation info across all claims in the answer
	// candidate.
	Claims []*GoogleCloudDiscoveryengineV1CheckGroundingResponseClaim `json:"claims,omitempty"`
	// SupportScore: The support score for the input answer candidate. Higher the
	// score, higher is the fraction of claims that are supported by the provided
	// facts. This is always set when a response is returned.
	SupportScore float64 `json:"supportScore,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CitedChunks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitedChunks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CheckGroundingResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CheckGroundingResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1CheckGroundingResponse) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1CheckGroundingResponse
	var s1 struct {
		SupportScore gensupport.JSONFloat64 `json:"supportScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SupportScore = float64(s1.SupportScore)
	return nil
}

// GoogleCloudDiscoveryengineV1CheckGroundingResponseCheckGroundingFactChunk:
// Fact chunk for grounding check.
type GoogleCloudDiscoveryengineV1CheckGroundingResponseCheckGroundingFactChunk struct {
	// ChunkText: Text content of the fact chunk. Can be at most 10K characters
	// long.
	ChunkText string `json:"chunkText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CheckGroundingResponseCheckGroundingFactChunk) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CheckGroundingResponseCheckGroundingFactChunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CheckGroundingResponseClaim: Text and citation
// info for a claim in the answer candidate.
type GoogleCloudDiscoveryengineV1CheckGroundingResponseClaim struct {
	// CitationIndices: A list of indices (into 'cited_chunks') specifying the
	// citations associated with the claim. For instance [1,3,4] means that
	// cited_chunks[1], cited_chunks[3], cited_chunks[4] are the facts cited
	// supporting for the claim. A citation to a fact indicates that the claim is
	// supported by the fact.
	CitationIndices []int64 `json:"citationIndices,omitempty"`
	// ClaimText: Text for the claim in the answer candidate. Always provided
	// regardless of whether citations or anti-citations are found.
	ClaimText string `json:"claimText,omitempty"`
	// EndPos: Position indicating the end of the claim in the answer candidate,
	// exclusive, in bytes. Note that this is not measured in characters and,
	// therefore, must be rendered as such. For example, if the claim text contains
	// non-ASCII characters, the start and end positions vary when measured in
	// characters (programming-language-dependent) and when measured in bytes
	// (programming-language-independent).
	EndPos int64 `json:"endPos,omitempty"`
	// GroundingCheckRequired: Indicates that this claim required grounding check.
	// When the system decided this claim doesn't require attribution/grounding
	// check, this field will be set to false. In that case, no grounding check was
	// done for the claim and therefore citation_indices should not be returned.
	GroundingCheckRequired bool `json:"groundingCheckRequired,omitempty"`
	// Score: Confidence score for the claim in the answer candidate, in the range
	// of [0, 1]. This is set only when
	// `CheckGroundingRequest.grounding_spec.enable_claim_level_score` is true.
	Score float64 `json:"score,omitempty"`
	// StartPos: Position indicating the start of the claim in the answer
	// candidate, measured in bytes. Note that this is not measured in characters
	// and, therefore, must be rendered in the user interface keeping in mind that
	// some characters may take more than one byte. For example, if the claim text
	// contains non-ASCII characters, the start and end positions vary when
	// measured in characters (programming-language-dependent) and when measured in
	// bytes (programming-language-independent).
	StartPos int64 `json:"startPos,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationIndices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationIndices") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CheckGroundingResponseClaim) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CheckGroundingResponseClaim
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1CheckGroundingResponseClaim) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1CheckGroundingResponseClaim
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDiscoveryengineV1CheckGroundingSpec: Specification for the
// grounding check.
type GoogleCloudDiscoveryengineV1CheckGroundingSpec struct {
	// CitationThreshold: The threshold (in [0,1]) used for determining whether a
	// fact must be cited for a claim in the answer candidate. Choosing a higher
	// threshold will lead to fewer but very strong citations, while choosing a
	// lower threshold may lead to more but somewhat weaker citations. If unset,
	// the threshold will default to 0.6.
	CitationThreshold float64 `json:"citationThreshold,omitempty"`
	// EnableClaimLevelScore: The control flag that enables claim-level grounding
	// score in the response.
	EnableClaimLevelScore bool `json:"enableClaimLevelScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationThreshold") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationThreshold") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CheckGroundingSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CheckGroundingSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1CheckGroundingSpec) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1CheckGroundingSpec
	var s1 struct {
		CitationThreshold gensupport.JSONFloat64 `json:"citationThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CitationThreshold = float64(s1.CitationThreshold)
	return nil
}

// GoogleCloudDiscoveryengineV1Chunk: Chunk captures all raw metadata
// information of items to be recommended or searched in the chunk mode.
type GoogleCloudDiscoveryengineV1Chunk struct {
	// AnnotationContents: Output only. Annotation contents if the current chunk
	// contains annotations.
	AnnotationContents []string `json:"annotationContents,omitempty"`
	// AnnotationMetadata: Output only. The annotation metadata includes structured
	// content in the current chunk.
	AnnotationMetadata []*GoogleCloudDiscoveryengineV1ChunkAnnotationMetadata `json:"annotationMetadata,omitempty"`
	// ChunkMetadata: Output only. Metadata of the current chunk.
	ChunkMetadata *GoogleCloudDiscoveryengineV1ChunkChunkMetadata `json:"chunkMetadata,omitempty"`
	// Content: Content is a string from a document (parsed content).
	Content string `json:"content,omitempty"`
	// DataUrls: Output only. Image Data URLs if the current chunk contains images.
	// Data URLs are composed of four parts: a prefix (data:), a MIME type
	// indicating the type of data, an optional base64 token if non-textual, and
	// the data itself: data:,
	DataUrls []string `json:"dataUrls,omitempty"`
	// DerivedStructData: Output only. This field is OUTPUT_ONLY. It contains
	// derived data that are not in the original input document.
	DerivedStructData googleapi.RawMessage `json:"derivedStructData,omitempty"`
	// DocumentMetadata: Metadata of the document from the current chunk.
	DocumentMetadata *GoogleCloudDiscoveryengineV1ChunkDocumentMetadata `json:"documentMetadata,omitempty"`
	// Id: Unique chunk ID of the current chunk.
	Id string `json:"id,omitempty"`
	// Name: The full resource name of the chunk. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/branches/{branch}/documents/{document_id}/chunks/{chunk_id}`.
	// This field must be a UTF-8 encoded string with a length limit of 1024
	// characters.
	Name string `json:"name,omitempty"`
	// PageSpan: Page span of the chunk.
	PageSpan *GoogleCloudDiscoveryengineV1ChunkPageSpan `json:"pageSpan,omitempty"`
	// RelevanceScore: Output only. Represents the relevance score based on
	// similarity. Higher score indicates higher chunk relevance. The score is in
	// range [-1.0, 1.0]. Only populated on SearchResponse.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationContents") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Chunk) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Chunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1Chunk) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1Chunk
	var s1 struct {
		RelevanceScore gensupport.JSONFloat64 `json:"relevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelevanceScore = float64(s1.RelevanceScore)
	return nil
}

// GoogleCloudDiscoveryengineV1ChunkAnnotationMetadata: The annotation metadata
// includes structured content in the current chunk.
type GoogleCloudDiscoveryengineV1ChunkAnnotationMetadata struct {
	// ImageId: Output only. Image id is provided if the structured content is
	// based on an image.
	ImageId string `json:"imageId,omitempty"`
	// StructuredContent: Output only. The structured content information.
	StructuredContent *GoogleCloudDiscoveryengineV1ChunkStructuredContent `json:"structuredContent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ChunkAnnotationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ChunkAnnotationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ChunkChunkMetadata: Metadata of the current
// chunk. This field is only populated on SearchService.Search API.
type GoogleCloudDiscoveryengineV1ChunkChunkMetadata struct {
	// NextChunks: The next chunks of the current chunk. The number is controlled
	// by SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks. This field is
	// only populated on SearchService.Search API.
	NextChunks []*GoogleCloudDiscoveryengineV1Chunk `json:"nextChunks,omitempty"`
	// PreviousChunks: The previous chunks of the current chunk. The number is
	// controlled by SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks.
	// This field is only populated on SearchService.Search API.
	PreviousChunks []*GoogleCloudDiscoveryengineV1Chunk `json:"previousChunks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NextChunks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextChunks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ChunkChunkMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ChunkChunkMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ChunkDocumentMetadata: Document metadata
// contains the information of the document of the current chunk.
type GoogleCloudDiscoveryengineV1ChunkDocumentMetadata struct {
	// MimeType: The mime type of the document.
	// https://www.iana.org/assignments/media-types/media-types.xhtml.
	MimeType string `json:"mimeType,omitempty"`
	// StructData: Data representation. The structured JSON data for the document.
	// It should conform to the registered Schema or an `INVALID_ARGUMENT` error is
	// thrown.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title of the document.
	Title string `json:"title,omitempty"`
	// Uri: Uri of the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MimeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MimeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ChunkDocumentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ChunkDocumentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ChunkPageSpan: Page span of the chunk.
type GoogleCloudDiscoveryengineV1ChunkPageSpan struct {
	// PageEnd: The end page of the chunk.
	PageEnd int64 `json:"pageEnd,omitempty"`
	// PageStart: The start page of the chunk.
	PageStart int64 `json:"pageStart,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageEnd") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageEnd") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ChunkPageSpan) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ChunkPageSpan
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ChunkStructuredContent: The structured content
// information.
type GoogleCloudDiscoveryengineV1ChunkStructuredContent struct {
	// Content: Output only. The content of the structured content.
	Content string `json:"content,omitempty"`
	// StructureType: Output only. The structure type of the structured content.
	//
	// Possible values:
	//   "STRUCTURE_TYPE_UNSPECIFIED" - Default value.
	//   "SHAREHOLDER_STRUCTURE" - Shareholder structure.
	//   "SIGNATURE_STRUCTURE" - Signature structure.
	//   "CHECKBOX_STRUCTURE" - Checkbox structure.
	StructureType string `json:"structureType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ChunkStructuredContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ChunkStructuredContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Citation: Source attributions for content.
type GoogleCloudDiscoveryengineV1Citation struct {
	// EndIndex: Output only. End index into the content.
	EndIndex int64 `json:"endIndex,omitempty"`
	// License: Output only. License of the attribution.
	License string `json:"license,omitempty"`
	// PublicationDate: Output only. Publication date of the attribution.
	PublicationDate *GoogleTypeDate `json:"publicationDate,omitempty"`
	// StartIndex: Output only. Start index into the content.
	StartIndex int64 `json:"startIndex,omitempty"`
	// Title: Output only. Title of the attribution.
	Title string `json:"title,omitempty"`
	// Uri: Output only. Url reference of the attribution.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Citation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Citation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CitationMetadata: A collection of source
// attributions for a piece of content.
type GoogleCloudDiscoveryengineV1CitationMetadata struct {
	// Citations: Output only. List of citations.
	Citations []*GoogleCloudDiscoveryengineV1Citation `json:"citations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Citations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Citations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CitationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CitationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CloudSqlSource: Cloud SQL source import data
// from.
type GoogleCloudDiscoveryengineV1CloudSqlSource struct {
	// DatabaseId: Required. The Cloud SQL database to copy the data from with a
	// length limit of 256 characters.
	DatabaseId string `json:"databaseId,omitempty"`
	// GcsStagingDir: Intermediate Cloud Storage directory used for the import with
	// a length limit of 2,000 characters. Can be specified if one wants to have
	// the Cloud SQL export to a specific Cloud Storage directory. Ensure that the
	// Cloud SQL service account has the necessary Cloud Storage Admin permissions
	// to access the specified Cloud Storage directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`
	// InstanceId: Required. The Cloud SQL instance to copy the data from with a
	// length limit of 256 characters.
	InstanceId string `json:"instanceId,omitempty"`
	// Offload: Option for serverless export. Enabling this option will incur
	// additional cost. More info can be found here
	// (https://cloud.google.com/sql/pricing#serverless).
	Offload bool `json:"offload,omitempty"`
	// ProjectId: The project ID that contains the Cloud SQL source. Has a length
	// limit of 128 characters. If not specified, inherits the project ID from the
	// parent request.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Required. The Cloud SQL table to copy the data from with a length
	// limit of 256 characters.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatabaseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatabaseId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CloudSqlSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CloudSqlSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CmekConfig: Configurations used to enable CMEK
// data encryption with Cloud KMS keys.
type GoogleCloudDiscoveryengineV1CmekConfig struct {
	// IsDefault: Output only. The default CmekConfig for the Customer.
	IsDefault bool `json:"isDefault,omitempty"`
	// KmsKey: Required. KMS key resource name which will be used to encrypt
	// resources
	// `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId
	// }`.
	KmsKey string `json:"kmsKey,omitempty"`
	// KmsKeyVersion: Output only. KMS key version resource name which will be used
	// to encrypt resources `/cryptoKeyVersions/{keyVersion}`.
	KmsKeyVersion string `json:"kmsKeyVersion,omitempty"`
	// LastRotationTimestampMicros: Output only. The timestamp of the last key
	// rotation.
	LastRotationTimestampMicros int64 `json:"lastRotationTimestampMicros,omitempty,string"`
	// Name: Required. The name of the CmekConfig of the form
	// `projects/{project}/locations/{location}/cmekConfig` or
	// `projects/{project}/locations/{location}/cmekConfigs/{cmek_config}`.
	Name string `json:"name,omitempty"`
	// NotebooklmState: Output only. Whether the NotebookLM Corpus is ready to be
	// used.
	//
	// Possible values:
	//   "NOTEBOOK_LM_STATE_UNSPECIFIED" - The NotebookLM state is unknown.
	//   "NOTEBOOK_LM_NOT_READY" - The NotebookLM is not ready.
	//   "NOTEBOOK_LM_READY" - The NotebookLM is ready to be used.
	//   "NOTEBOOK_LM_NOT_ENABLED" - The NotebookLM is not enabled.
	NotebooklmState string `json:"notebooklmState,omitempty"`
	// SingleRegionKeys: Optional. Single-regional CMEKs that are required for some
	// VAIS features.
	SingleRegionKeys []*GoogleCloudDiscoveryengineV1SingleRegionKey `json:"singleRegionKeys,omitempty"`
	// State: Output only. The states of the CmekConfig.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The CmekConfig state is unknown.
	//   "CREATING" - The CmekConfig is creating.
	//   "ACTIVE" - The CmekConfig can be used with DataStores.
	//   "KEY_ISSUE" - The CmekConfig is unavailable, most likely due to the KMS
	// Key being revoked.
	//   "DELETING" - The CmekConfig is deleting.
	//   "DELETE_FAILED" - The CmekConfig deletion process failed.
	//   "UNUSABLE" - The CmekConfig is not usable, most likely due to some
	// internal issue.
	//   "ACTIVE_ROTATING" - The KMS key version is being rotated.
	//   "DELETED" - The KMS key is soft deleted. Some cleanup policy will
	// eventually be applied.
	//   "EXPIRED" - The KMS key is expired, meaning the key has been disabled for
	// 30+ days. The customer can call DeleteCmekConfig to change the state to
	// DELETED.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "IsDefault") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsDefault") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CmekConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CmekConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Collection: Collection is a container for
// configuring resources and access to a set of DataStores.
type GoogleCloudDiscoveryengineV1Collection struct {
	// CreateTime: Output only. Timestamp the Collection was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. The Collection display name. This field must be a
	// UTF-8 encoded string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Immutable. The full resource name of the Collection. Format:
	// `projects/{project}/locations/{location}/collections/{collection_id}`. This
	// field must be a UTF-8 encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Collection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Collection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CompleteQueryResponse: Response message for
// CompletionService.CompleteQuery method.
type GoogleCloudDiscoveryengineV1CompleteQueryResponse struct {
	// QuerySuggestions: Results of the matched query suggestions. The result list
	// is ordered and the first result is a top suggestion.
	QuerySuggestions []*GoogleCloudDiscoveryengineV1CompleteQueryResponseQuerySuggestion `json:"querySuggestions,omitempty"`
	// TailMatchTriggered: True if the returned suggestions are all tail
	// suggestions. For tail matching to be triggered, include_tail_suggestions in
	// the request must be true and there must be no suggestions that match the
	// full query.
	TailMatchTriggered bool `json:"tailMatchTriggered,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "QuerySuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuerySuggestions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CompleteQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CompleteQueryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CompleteQueryResponseQuerySuggestion:
// Suggestions as search queries.
type GoogleCloudDiscoveryengineV1CompleteQueryResponseQuerySuggestion struct {
	// CompletableFieldPaths: The unique document field paths that serve as the
	// source of this suggestion if it was generated from completable fields. This
	// field is only populated for the document-completable model.
	CompletableFieldPaths []string `json:"completableFieldPaths,omitempty"`
	// Suggestion: The suggestion for the query.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletableFieldPaths") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletableFieldPaths") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CompleteQueryResponseQuerySuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CompleteQueryResponseQuerySuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CompletionInfo: Detailed completion information
// including completion attribution token and clicked completion info.
type GoogleCloudDiscoveryengineV1CompletionInfo struct {
	// SelectedPosition: End user selected
	// CompleteQueryResponse.QuerySuggestion.suggestion position, starting from 0.
	SelectedPosition int64 `json:"selectedPosition,omitempty"`
	// SelectedSuggestion: End user selected
	// CompleteQueryResponse.QuerySuggestion.suggestion.
	SelectedSuggestion string `json:"selectedSuggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SelectedPosition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SelectedPosition") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CompletionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CompletionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CompletionSuggestion: Autocomplete suggestions
// that are imported from Customer.
type GoogleCloudDiscoveryengineV1CompletionSuggestion struct {
	// AlternativePhrases: Alternative matching phrases for this suggestion.
	AlternativePhrases []string `json:"alternativePhrases,omitempty"`
	// Frequency: Frequency of this suggestion. Will be used to rank suggestions
	// when score is not available.
	Frequency int64 `json:"frequency,omitempty,string"`
	// GlobalScore: Global score of this suggestion. Control how this suggestion
	// would be scored / ranked.
	GlobalScore float64 `json:"globalScore,omitempty"`
	// GroupId: If two suggestions have the same groupId, they will not be returned
	// together. Instead the one ranked higher will be returned. This can be used
	// to deduplicate semantically identical suggestions.
	GroupId string `json:"groupId,omitempty"`
	// GroupScore: The score of this suggestion within its group.
	GroupScore float64 `json:"groupScore,omitempty"`
	// LanguageCode: BCP-47 language code of this suggestion.
	LanguageCode string `json:"languageCode,omitempty"`
	// Suggestion: Required. The suggestion text.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlternativePhrases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternativePhrases") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CompletionSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CompletionSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1CompletionSuggestion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1CompletionSuggestion
	var s1 struct {
		GlobalScore gensupport.JSONFloat64 `json:"globalScore"`
		GroupScore  gensupport.JSONFloat64 `json:"groupScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.GlobalScore = float64(s1.GlobalScore)
	s.GroupScore = float64(s1.GroupScore)
	return nil
}

// GoogleCloudDiscoveryengineV1Condition: Defines circumstances to be checked
// before allowing a behavior
type GoogleCloudDiscoveryengineV1Condition struct {
	// ActiveTimeRange: Range of time(s) specifying when condition is active.
	// Maximum of 10 time ranges.
	ActiveTimeRange []*GoogleCloudDiscoveryengineV1ConditionTimeRange `json:"activeTimeRange,omitempty"`
	// QueryRegex: Optional. Query regex to match the whole search query. Cannot be
	// set when Condition.query_terms is set. Only supported for Basic Site Search
	// promotion serving controls.
	QueryRegex string `json:"queryRegex,omitempty"`
	// QueryTerms: Search only A list of terms to match the query on. Cannot be set
	// when Condition.query_regex is set. Maximum of 10 query terms.
	QueryTerms []*GoogleCloudDiscoveryengineV1ConditionQueryTerm `json:"queryTerms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActiveTimeRange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveTimeRange") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Condition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Condition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ConditionQueryTerm: Matcher for search request
// query
type GoogleCloudDiscoveryengineV1ConditionQueryTerm struct {
	// FullMatch: Whether the search query needs to exactly match the query term.
	FullMatch bool `json:"fullMatch,omitempty"`
	// Value: The specific query value to match against Must be lowercase, must be
	// UTF-8. Can have at most 3 space separated terms if full_match is true.
	// Cannot be an empty string. Maximum length of 5000 characters.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FullMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FullMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ConditionQueryTerm) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ConditionQueryTerm
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ConditionTimeRange: Used for time-dependent
// conditions.
type GoogleCloudDiscoveryengineV1ConditionTimeRange struct {
	// EndTime: End of time range. Range is inclusive. Must be in the future.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Start of time range. Range is inclusive.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ConditionTimeRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ConditionTimeRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Control: Defines a conditioned behavior to
// employ during serving. Must be attached to a ServingConfig to be considered
// at serving time. Permitted actions dependent on `SolutionType`.
type GoogleCloudDiscoveryengineV1Control struct {
	// AssociatedServingConfigIds: Output only. List of all ServingConfig IDs this
	// control is attached to. May take up to 10 minutes to update after changes.
	AssociatedServingConfigIds []string `json:"associatedServingConfigIds,omitempty"`
	// BoostAction: Defines a boost-type control
	BoostAction *GoogleCloudDiscoveryengineV1ControlBoostAction `json:"boostAction,omitempty"`
	// Conditions: Determines when the associated action will trigger. Omit to
	// always apply the action. Currently only a single condition may be specified.
	// Otherwise an INVALID ARGUMENT error is thrown.
	Conditions []*GoogleCloudDiscoveryengineV1Condition `json:"conditions,omitempty"`
	// DisplayName: Required. Human readable name. The identifier used in UI views.
	// Must be UTF-8 encoded string. Length limit is 128 characters. Otherwise an
	// INVALID ARGUMENT error is thrown.
	DisplayName string `json:"displayName,omitempty"`
	// FilterAction: Defines a filter-type control Currently not supported by
	// Recommendation
	FilterAction *GoogleCloudDiscoveryengineV1ControlFilterAction `json:"filterAction,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/*/locations/global/dataStore/*/controls/*`
	Name string `json:"name,omitempty"`
	// PromoteAction: Promote certain links based on predefined trigger queries.
	PromoteAction *GoogleCloudDiscoveryengineV1ControlPromoteAction `json:"promoteAction,omitempty"`
	// RedirectAction: Defines a redirect-type control.
	RedirectAction *GoogleCloudDiscoveryengineV1ControlRedirectAction `json:"redirectAction,omitempty"`
	// SolutionType: Required. Immutable. What solution the control belongs to.
	// Must be compatible with vertical of resource. Otherwise an INVALID ARGUMENT
	// error is thrown.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionType string `json:"solutionType,omitempty"`
	// SynonymsAction: Treats a group of terms as synonyms of one another.
	SynonymsAction *GoogleCloudDiscoveryengineV1ControlSynonymsAction `json:"synonymsAction,omitempty"`
	// UseCases: Specifies the use case for the control. Affects what condition
	// fields can be set. Only applies to SOLUTION_TYPE_SEARCH. Currently only
	// allow one use case per control. Must be set when solution_type is
	// SolutionType.SOLUTION_TYPE_SEARCH.
	//
	// Possible values:
	//   "SEARCH_USE_CASE_UNSPECIFIED" - Value used when unset. Will not occur in
	// CSS.
	//   "SEARCH_USE_CASE_SEARCH" - Search use case. Expects the traffic has a
	// non-empty query.
	//   "SEARCH_USE_CASE_BROWSE" - Browse use case. Expects the traffic has an
	// empty query.
	UseCases []string `json:"useCases,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AssociatedServingConfigIds")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssociatedServingConfigIds") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Control) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Control
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ControlBoostAction: Adjusts order of products in
// returned list.
type GoogleCloudDiscoveryengineV1ControlBoostAction struct {
	// Boost: Strength of the boost, which should be in [-1, 1]. Negative boost
	// means demotion. Default is 0.0 (No-op).
	Boost float64 `json:"boost,omitempty"`
	// DataStore: Required. Specifies which data store's documents can be boosted
	// by this control. Full data store name e.g.
	// projects/123/locations/global/collections/default_collection/dataStores/defau
	// lt_data_store
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Required. Specifies which products to apply the boost to. If no
	// filter is provided all products will be boosted (No-op). Syntax
	// documentation: https://cloud.google.com/retail/docs/filter-and-order Maximum
	// length is 5000 characters. Otherwise an INVALID ARGUMENT error is thrown.
	Filter string `json:"filter,omitempty"`
	// FixedBoost: Optional. Strength of the boost, which should be in [-1, 1].
	// Negative boost means demotion. Default is 0.0 (No-op).
	FixedBoost float64 `json:"fixedBoost,omitempty"`
	// InterpolationBoostSpec: Optional. Complex specification for custom ranking
	// based on customer defined attribute value.
	InterpolationBoostSpec *GoogleCloudDiscoveryengineV1ControlBoostActionInterpolationBoostSpec `json:"interpolationBoostSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ControlBoostAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ControlBoostAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1ControlBoostAction) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1ControlBoostAction
	var s1 struct {
		Boost      gensupport.JSONFloat64 `json:"boost"`
		FixedBoost gensupport.JSONFloat64 `json:"fixedBoost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	s.FixedBoost = float64(s1.FixedBoost)
	return nil
}

// GoogleCloudDiscoveryengineV1ControlBoostActionInterpolationBoostSpec:
// Specification for custom ranking based on customer specified attribute
// value. It provides more controls for customized ranking than the simple
// (condition, boost) combination above.
type GoogleCloudDiscoveryengineV1ControlBoostActionInterpolationBoostSpec struct {
	// AttributeType: Optional. The attribute type to be used to determine the
	// boost amount. The attribute value can be derived from the field value of the
	// specified field_name. In the case of numerical it is straightforward i.e.
	// attribute_value = numerical_field_value. In the case of freshness however,
	// attribute_value = (time.now() - datetime_field_value).
	//
	// Possible values:
	//   "ATTRIBUTE_TYPE_UNSPECIFIED" - Unspecified AttributeType.
	//   "NUMERICAL" - The value of the numerical field will be used to dynamically
	// update the boost amount. In this case, the attribute_value (the x value) of
	// the control point will be the actual value of the numerical field for which
	// the boost_amount is specified.
	//   "FRESHNESS" - For the freshness use case the attribute value will be the
	// duration between the current time and the date in the datetime field
	// specified. The value must be formatted as an XSD `dayTimeDuration` value (a
	// restricted subset of an ISO 8601 duration value). The pattern for this is:
	// `nDnM]`. For example, `5D`, `3DT12H30M`, `T24H`.
	AttributeType string `json:"attributeType,omitempty"`
	// ControlPoints: Optional. The control points used to define the curve. The
	// monotonic function (defined through the interpolation_type above) passes
	// through the control points listed here.
	ControlPoints []*GoogleCloudDiscoveryengineV1ControlBoostActionInterpolationBoostSpecControlPoint `json:"controlPoints,omitempty"`
	// FieldName: Optional. The name of the field whose value will be used to
	// determine the boost amount.
	FieldName string `json:"fieldName,omitempty"`
	// InterpolationType: Optional. The interpolation type to be applied to connect
	// the control points listed below.
	//
	// Possible values:
	//   "INTERPOLATION_TYPE_UNSPECIFIED" - Interpolation type is unspecified. In
	// this case, it defaults to Linear.
	//   "LINEAR" - Piecewise linear interpolation will be applied.
	InterpolationType string `json:"interpolationType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ControlBoostActionInterpolationBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ControlBoostActionInterpolationBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ControlBoostActionInterpolationBoostSpecControlPo
// int: The control points used to define the curve. The curve defined through
// these control points can only be monotonically increasing or
// decreasing(constant values are acceptable).
type GoogleCloudDiscoveryengineV1ControlBoostActionInterpolationBoostSpecControlPoint struct {
	// AttributeValue: Optional. Can be one of: 1. The numerical field value. 2.
	// The duration spec for freshness: The value must be formatted as an XSD
	// `dayTimeDuration` value (a restricted subset of an ISO 8601 duration value).
	// The pattern for this is: `nDnM]`.
	AttributeValue string `json:"attributeValue,omitempty"`
	// BoostAmount: Optional. The value between -1 to 1 by which to boost the score
	// if the attribute_value evaluates to the value specified above.
	BoostAmount float64 `json:"boostAmount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeValue") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ControlBoostActionInterpolationBoostSpecControlPoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ControlBoostActionInterpolationBoostSpecControlPoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1ControlBoostActionInterpolationBoostSpecControlPoint) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1ControlBoostActionInterpolationBoostSpecControlPoint
	var s1 struct {
		BoostAmount gensupport.JSONFloat64 `json:"boostAmount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BoostAmount = float64(s1.BoostAmount)
	return nil
}

// GoogleCloudDiscoveryengineV1ControlFilterAction: Specified which products
// may be included in results. Uses same filter as boost.
type GoogleCloudDiscoveryengineV1ControlFilterAction struct {
	// DataStore: Required. Specifies which data store's documents can be filtered
	// by this control. Full data store name e.g.
	// projects/123/locations/global/collections/default_collection/dataStores/defau
	// lt_data_store
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Required. A filter to apply on the matching condition results.
	// Required Syntax documentation:
	// https://cloud.google.com/retail/docs/filter-and-order Maximum length is 5000
	// characters. Otherwise an INVALID ARGUMENT error is thrown.
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ControlFilterAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ControlFilterAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ControlPromoteAction: Promote certain links
// based on some trigger queries. Example: Promote shoe store link when
// searching for `shoe` keyword. The link can be outside of associated data
// store.
type GoogleCloudDiscoveryengineV1ControlPromoteAction struct {
	// DataStore: Required. Data store with which this promotion is attached to.
	DataStore string `json:"dataStore,omitempty"`
	// SearchLinkPromotion: Required. Promotion attached to this action.
	SearchLinkPromotion *GoogleCloudDiscoveryengineV1SearchLinkPromotion `json:"searchLinkPromotion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ControlPromoteAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ControlPromoteAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ControlRedirectAction: Redirects a shopper to
// the provided URI.
type GoogleCloudDiscoveryengineV1ControlRedirectAction struct {
	// RedirectUri: Required. The URI to which the shopper will be redirected.
	// Required. URI must have length equal or less than 2000 characters. Otherwise
	// an INVALID ARGUMENT error is thrown.
	RedirectUri string `json:"redirectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RedirectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RedirectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ControlRedirectAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ControlRedirectAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ControlSynonymsAction: Creates a set of terms
// that will act as synonyms of one another. Example: "happy" will also be
// considered as "glad", "glad" will also be considered as "happy".
type GoogleCloudDiscoveryengineV1ControlSynonymsAction struct {
	// Synonyms: Defines a set of synonyms. Can specify up to 100 synonyms. Must
	// specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is thrown.
	Synonyms []string `json:"synonyms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Synonyms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ControlSynonymsAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ControlSynonymsAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Conversation: External conversation proto
// definition.
type GoogleCloudDiscoveryengineV1Conversation struct {
	// EndTime: Output only. The time the conversation finished.
	EndTime string `json:"endTime,omitempty"`
	// Messages: Conversation messages.
	Messages []*GoogleCloudDiscoveryengineV1ConversationMessage `json:"messages,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/{project}/locations/global/collections/{collection}/dataStore/*/con
	// versations/*` or
	// `projects/{project}/locations/global/collections/{collection}/engines/*/conve
	// rsations/*`.
	Name string `json:"name,omitempty"`
	// StartTime: Output only. The time the conversation started.
	StartTime string `json:"startTime,omitempty"`
	// State: The state of the Conversation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown.
	//   "IN_PROGRESS" - Conversation is currently open.
	//   "COMPLETED" - Conversation has been completed.
	State string `json:"state,omitempty"`
	// UserPseudoId: A unique identifier for tracking users.
	UserPseudoId string `json:"userPseudoId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Conversation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Conversation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ConversationContext: Defines context of the
// conversation
type GoogleCloudDiscoveryengineV1ConversationContext struct {
	// ActiveDocument: The current active document the user opened. It contains the
	// document resource reference.
	ActiveDocument string `json:"activeDocument,omitempty"`
	// ContextDocuments: The current list of documents the user is seeing. It
	// contains the document resource references.
	ContextDocuments []string `json:"contextDocuments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActiveDocument") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveDocument") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ConversationContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ConversationContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ConversationMessage: Defines a conversation
// message.
type GoogleCloudDiscoveryengineV1ConversationMessage struct {
	// CreateTime: Output only. Message creation timestamp.
	CreateTime string `json:"createTime,omitempty"`
	// Reply: Search reply.
	Reply *GoogleCloudDiscoveryengineV1Reply `json:"reply,omitempty"`
	// UserInput: User text input.
	UserInput *GoogleCloudDiscoveryengineV1TextInput `json:"userInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ConversationMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ConversationMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ConverseConversationRequest: Request message for
// ConversationalSearchService.ConverseConversation method.
type GoogleCloudDiscoveryengineV1ConverseConversationRequest struct {
	// BoostSpec: Boost specification to boost certain documents in search results
	// which may affect the converse response. For more information on boosting,
	// see Boosting (https://cloud.google.com/retail/docs/boosting#boost)
	BoostSpec *GoogleCloudDiscoveryengineV1SearchRequestBoostSpec `json:"boostSpec,omitempty"`
	// Conversation: The conversation to be used by auto session only. The name
	// field will be ignored as we automatically assign new name for the
	// conversation in auto session.
	Conversation *GoogleCloudDiscoveryengineV1Conversation `json:"conversation,omitempty"`
	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the documents being
	// filtered. Filter expression is case-sensitive. This will be used to filter
	// search results which may affect the summary response. If this field is
	// unrecognizable, an `INVALID_ARGUMENT` is returned. Filtering in Vertex AI
	// Search is done by mapping the LHS filter key to a key property defined in
	// the Vertex AI Search backend -- this mapping is defined by the customer in
	// their schema. For example a media customer might have a field 'name' in
	// their schema. In this case the filter would look like this: filter -->
	// name:'ANY("king kong")' For more information about filtering including
	// syntax and filter operators, see Filter
	// (https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
	Filter string `json:"filter,omitempty"`
	// Query: Required. Current user input.
	Query *GoogleCloudDiscoveryengineV1TextInput `json:"query,omitempty"`
	// SafeSearch: Whether to turn on safe search.
	SafeSearch bool `json:"safeSearch,omitempty"`
	// ServingConfig: The resource name of the Serving Config to use. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store_id}/servingConfigs/{serving_config_id}` If this is not set, the
	// default serving config will be used.
	ServingConfig string `json:"servingConfig,omitempty"`
	// SummarySpec: A specification for configuring the summary returned in the
	// response.
	SummarySpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec `json:"summarySpec,omitempty"`
	// UserLabels: The user labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Google Cloud Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ConverseConversationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ConverseConversationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ConverseConversationResponse: Response message
// for ConversationalSearchService.ConverseConversation method.
type GoogleCloudDiscoveryengineV1ConverseConversationResponse struct {
	// Conversation: Updated conversation including the answer.
	Conversation *GoogleCloudDiscoveryengineV1Conversation `json:"conversation,omitempty"`
	// Reply: Answer to the current query.
	Reply *GoogleCloudDiscoveryengineV1Reply `json:"reply,omitempty"`
	// SearchResults: Search Results.
	SearchResults []*GoogleCloudDiscoveryengineV1SearchResponseSearchResult `json:"searchResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ConverseConversationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ConverseConversationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CreateDataStoreMetadata: Metadata related to the
// progress of the DataStoreService.CreateDataStore operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1CreateDataStoreMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CreateDataStoreMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CreateDataStoreMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CreateEngineMetadata: Metadata related to the
// progress of the EngineService.CreateEngine operation. This will be returned
// by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1CreateEngineMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CreateEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CreateEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CreateSchemaMetadata: Metadata for Create Schema
// LRO.
type GoogleCloudDiscoveryengineV1CreateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CreateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CreateSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CreateSitemapMetadata: Metadata related to the
// progress of the SiteSearchEngineService.CreateSitemap operation. This will
// be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1CreateSitemapMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CreateSitemapMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CreateSitemapMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CreateTargetSiteMetadata: Metadata related to
// the progress of the SiteSearchEngineService.CreateTargetSite operation. This
// will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1CreateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CreateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CreateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CreateTargetSiteRequest: Request message for
// SiteSearchEngineService.CreateTargetSite method.
type GoogleCloudDiscoveryengineV1CreateTargetSiteRequest struct {
	// Parent: Required. Parent resource name of TargetSite, such as
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/siteSearchEngine`.
	Parent string `json:"parent,omitempty"`
	// TargetSite: Required. The TargetSite to create.
	TargetSite *GoogleCloudDiscoveryengineV1TargetSite `json:"targetSite,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CreateTargetSiteRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CreateTargetSiteRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CustomAttribute: A custom attribute that is not
// explicitly modeled in a resource, e.g. UserEvent.
type GoogleCloudDiscoveryengineV1CustomAttribute struct {
	// Numbers: The numerical values of this custom attribute. For example, `[2.3,
	// 15.4]` when the key is "lengths_cm". Exactly one of CustomAttribute.text or
	// CustomAttribute.numbers should be set. Otherwise, an `INVALID_ARGUMENT`
	// error is returned.
	Numbers []float64 `json:"numbers,omitempty"`
	// Text: The textual values of this custom attribute. For example, `["yellow",
	// "green"]` when the key is "color". Empty string is not allowed. Otherwise,
	// an `INVALID_ARGUMENT` error is returned. Exactly one of CustomAttribute.text
	// or CustomAttribute.numbers should be set. Otherwise, an `INVALID_ARGUMENT`
	// error is returned.
	Text []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Numbers") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Numbers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CustomAttribute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CustomAttribute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1CustomAttribute) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1CustomAttribute
	var s1 struct {
		Numbers []gensupport.JSONFloat64 `json:"numbers"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Numbers = make([]float64, len(s1.Numbers))
	for i := range s1.Numbers {
		s.Numbers[i] = float64(s1.Numbers[i])
	}
	return nil
}

// GoogleCloudDiscoveryengineV1CustomTuningModel: Metadata that describes a
// custom tuned model.
type GoogleCloudDiscoveryengineV1CustomTuningModel struct {
	// CreateTime: Deprecated: Timestamp the Model was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: The display name of the model.
	DisplayName string `json:"displayName,omitempty"`
	// ErrorMessage: Currently this is only populated if the model state is
	// `INPUT_VALIDATION_FAILED`.
	ErrorMessage string `json:"errorMessage,omitempty"`
	// Metrics: The metrics of the trained model.
	Metrics map[string]float64 `json:"metrics,omitempty"`
	// ModelState: The state that the model is in (e.g.`TRAINING` or
	// `TRAINING_FAILED`).
	//
	// Possible values:
	//   "MODEL_STATE_UNSPECIFIED" - Default value.
	//   "TRAINING_PAUSED" - The model is in a paused training state.
	//   "TRAINING" - The model is currently training.
	//   "TRAINING_COMPLETE" - The model has successfully completed training.
	//   "READY_FOR_SERVING" - The model is ready for serving.
	//   "TRAINING_FAILED" - The model training failed.
	//   "NO_IMPROVEMENT" - The model training finished successfully but metrics
	// did not improve.
	//   "INPUT_VALIDATION_FAILED" - Input data validation failed. Model training
	// didn't start.
	ModelState string `json:"modelState,omitempty"`
	// ModelVersion: The version of the model.
	ModelVersion int64 `json:"modelVersion,omitempty,string"`
	// Name: Required. The fully qualified resource name of the model. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/customTuningModels/{custom_tuning_model}`. Model must be an
	// alpha-numerical string with limit of 40 characters.
	Name string `json:"name,omitempty"`
	// TrainingStartTime: Timestamp the model training was initiated.
	TrainingStartTime string `json:"trainingStartTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CustomTuningModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CustomTuningModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DataConnector: Manages the connection to
// external data sources for all data stores grouped under a Collection. It's a
// singleton resource of Collection. The initialization is only supported
// through DataConnectorService.SetUpDataConnector method, which will create a
// new Collection and initialize its DataConnector.
type GoogleCloudDiscoveryengineV1DataConnector struct {
	// AclEnabled: Optional. Whether the connector will be created with an ACL
	// config. Currently this field only affects Cloud Storage and BigQuery
	// connectors.
	AclEnabled bool `json:"aclEnabled,omitempty"`
	// ActionConfig: Optional. Action configurations to make the connector support
	// actions.
	ActionConfig *GoogleCloudDiscoveryengineV1ActionConfig `json:"actionConfig,omitempty"`
	// ActionState: Output only. State of the action connector. This reflects
	// whether the action connector is initializing, active or has encountered
	// errors.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value.
	//   "CREATING" - The connector is being set up.
	//   "ACTIVE" - The connector is successfully set up and awaiting next sync
	// run.
	//   "FAILED" - The connector is in error. The error details can be found in
	// DataConnector.errors. If the error is unfixable, the DataConnector can be
	// deleted by [CollectionService.DeleteCollection] API.
	//   "RUNNING" - The connector is actively syncing records from the data
	// source.
	//   "WARNING" - The connector has completed a sync run, but encountered
	// non-fatal errors.
	//   "INITIALIZATION_FAILED" - Connector initialization failed. Potential
	// causes include runtime errors or issues in the asynchronous pipeline,
	// preventing the request from reaching downstream services (except for some
	// connector types).
	//   "UPDATING" - Connector is in the process of an update.
	ActionState string `json:"actionState,omitempty"`
	// AlertPolicyConfigs: Optional. The connector level alert config.
	AlertPolicyConfigs []*GoogleCloudDiscoveryengineV1AlertPolicyConfig `json:"alertPolicyConfigs,omitempty"`
	// AutoRunDisabled: Optional. Indicates whether the connector is disabled for
	// auto run. It can be used to pause periodical and real time sync. Update:
	// with the introduction of incremental_sync_disabled, auto_run_disabled is
	// used to pause/disable only full syncs
	AutoRunDisabled bool `json:"autoRunDisabled,omitempty"`
	// BapConfig: Optional. The configuration for establishing a BAP connection.
	BapConfig *GoogleCloudDiscoveryengineV1BAPConfig `json:"bapConfig,omitempty"`
	// BlockingReasons: Output only. User actions that must be completed before the
	// connector can start syncing data.
	//
	// Possible values:
	//   "BLOCKING_REASON_UNSPECIFIED" - Default value.
	//   "ALLOWLIST_STATIC_IP" - Connector requires customer to allowlist static
	// IPs.
	//   "ALLOWLIST_IN_SERVICE_ATTACHMENT" - Connector requires customer to
	// allowlist our project in their service attachment.
	//   "ALLOWLIST_SERVICE_ACCOUNT" - Connector requires customer to allowlist
	// service account in their project.
	BlockingReasons []string `json:"blockingReasons,omitempty"`
	// ConnectorModes: Optional. The modes enabled for this connector. Default
	// state is CONNECTOR_MODE_UNSPECIFIED.
	//
	// Possible values:
	//   "CONNECTOR_MODE_UNSPECIFIED" - Connector mode unspecified.
	//   "DATA_INGESTION" - Connector utilized for data ingestion.
	//   "ACTIONS" - Connector utilized for actions.
	//   "FEDERATED" - Connector utilized for federated search.
	//   "EUA" - Connector utilized for End User Authentication.
	//   "FEDERATED_AND_EUA" - Hybrid connector utilized for federated search and
	// End User Authentication.
	ConnectorModes []string `json:"connectorModes,omitempty"`
	// ConnectorType: Output only. The type of connector. Each source can only map
	// to one type. For example, salesforce, confluence and jira have THIRD_PARTY
	// connector type. It is not mutable once set by system.
	//
	// Possible values:
	//   "CONNECTOR_TYPE_UNSPECIFIED" - Default value.
	//   "THIRD_PARTY" - Third party connector to connector to third party
	// application.
	//   "GCP_FHIR" - Data connector connects between FHIR store and VAIS
	// datastore.
	//   "BIG_QUERY" - Big query connector.
	//   "GCS" - Google Cloud Storage connector.
	//   "GOOGLE_MAIL" - Gmail connector.
	//   "GOOGLE_CALENDAR" - Google Calendar connector.
	//   "GOOGLE_DRIVE" - Google Drive connector.
	//   "NATIVE_CLOUD_IDENTITY" - Native Cloud Identity connector for people
	// search powered by People API.
	//   "THIRD_PARTY_FEDERATED" - Federated connector, it is a third party
	// connector that doesn't ingestion data, and search is powered by third party
	// application's API.
	//   "THIRD_PARTY_EUA" - Connector utilized for End User Authentication
	// features.
	//   "GCNV" - Google Cloud NetApp Volumes connector.
	ConnectorType string `json:"connectorType,omitempty"`
	// CreateEuaSaas: Optional. Whether the END USER AUTHENTICATION connector is
	// created in SaaS.
	CreateEuaSaas bool `json:"createEuaSaas,omitempty"`
	// CreateTime: Output only. Timestamp the DataConnector was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DataSource: Required. The name of the data source. Supported values:
	// `salesforce`, `jira`, `confluence`, `bigquery`.
	DataSource string `json:"dataSource,omitempty"`
	// DestinationConfigs: Optional. Any target destinations used to connect to
	// third-party services.
	DestinationConfigs []*GoogleCloudDiscoveryengineV1DestinationConfig `json:"destinationConfigs,omitempty"`
	// EndUserConfig: Optional. Any params and credentials used specifically for
	// EUA connectors.
	EndUserConfig *GoogleCloudDiscoveryengineV1DataConnectorEndUserConfig `json:"endUserConfig,omitempty"`
	// Entities: List of entities from the connected data source to ingest.
	Entities []*GoogleCloudDiscoveryengineV1DataConnectorSourceEntity `json:"entities,omitempty"`
	// Errors: Output only. The errors from initialization or from the latest
	// connector run.
	Errors []*GoogleRpcStatus `json:"errors,omitempty"`
	// FederatedConfig: Optional. Any params and credentials used specifically for
	// hybrid connectors supporting FEDERATED mode. This field should only be set
	// if the connector is a hybrid connector and we want to enable FEDERATED mode.
	FederatedConfig *GoogleCloudDiscoveryengineV1DataConnectorFederatedConfig `json:"federatedConfig,omitempty"`
	// HybridIngestionDisabled: Optional. If the connector is a hybrid connector,
	// determines whether ingestion is enabled and appropriate resources are
	// provisioned during connector creation. If the connector is not a hybrid
	// connector, this field is ignored.
	HybridIngestionDisabled bool `json:"hybridIngestionDisabled,omitempty"`
	// IdentityRefreshInterval: The refresh interval to sync the Access Control
	// List information for the documents ingested by this connector. If not set,
	// the access control list will be refreshed at the default interval of 30
	// minutes. The identity refresh interval can be at least 30 minutes and at
	// most 7 days.
	IdentityRefreshInterval string `json:"identityRefreshInterval,omitempty"`
	// IdentityScheduleConfig: The configuration for the identity data
	// synchronization runs. This contains the refresh interval to sync the Access
	// Control List information for the documents ingested by this connector.
	IdentityScheduleConfig *GoogleCloudDiscoveryengineV1IdentityScheduleConfig `json:"identityScheduleConfig,omitempty"`
	// IncrementalRefreshInterval: Optional. The refresh interval specifically for
	// incremental data syncs. If unset, incremental syncs will use the default
	// from env, set to 3hrs. The minimum is 30 minutes and maximum is 7 days.
	// Applicable to only 3P connectors. When the refresh interval is set to the
	// same value as the incremental refresh interval, incremental sync will be
	// disabled.
	IncrementalRefreshInterval string `json:"incrementalRefreshInterval,omitempty"`
	// IncrementalSyncDisabled: Optional. Indicates whether incremental syncs are
	// paused for this connector. This is independent of auto_run_disabled.
	// Applicable to only 3P connectors. When the refresh interval is set to the
	// same value as the incremental refresh interval, incremental sync will be
	// disabled, i.e. set to true.
	IncrementalSyncDisabled bool `json:"incrementalSyncDisabled,omitempty"`
	// JsonParams: Required data connector parameters in json string format.
	JsonParams string `json:"jsonParams,omitempty"`
	// KmsKeyName: Input only. The KMS key to be used to protect the DataStores
	// managed by this connector. Must be set for requests that need to comply with
	// CMEK Org Policy protections. If this field is set and processed
	// successfully, the DataStores created by this connector will be protected by
	// the KMS key.
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// LastSyncTime: Output only. For periodic connectors only, the last time a
	// data sync was completed.
	LastSyncTime string `json:"lastSyncTime,omitempty"`
	// LatestPauseTime: Output only. The most recent timestamp when this
	// DataConnector was paused, affecting all functionalities such as data
	// synchronization. Pausing a connector has the following effects: - All
	// functionalities, including data synchronization, are halted. - Any ongoing
	// data synchronization job will be canceled. - No future data synchronization
	// runs will be scheduled nor can be triggered.
	LatestPauseTime string `json:"latestPauseTime,omitempty"`
	// Name: Output only. The full resource name of the Data Connector. Format:
	// `projects/*/locations/*/collections/*/dataConnector`.
	Name string `json:"name,omitempty"`
	// NextSyncTime: Defines the scheduled time for the next data synchronization.
	// This field requires hour , minute, and time_zone from the IANA Time Zone
	// Database (https://www.iana.org/time-zones). This is utilized when the data
	// connector has a refresh interval greater than 1 day. When the hours or
	// minutes are not specified, we will assume a sync time of 0:00. The user must
	// provide a time zone to avoid ambiguity.
	NextSyncTime *GoogleTypeDateTime `json:"nextSyncTime,omitempty"`
	// Params: Required data connector parameters in structured json format.
	Params googleapi.RawMessage `json:"params,omitempty"`
	// PrivateConnectivityProjectId: Output only. The tenant project ID associated
	// with private connectivity connectors. This project must be allowlisted by in
	// order for the connector to function.
	PrivateConnectivityProjectId string `json:"privateConnectivityProjectId,omitempty"`
	// RealtimeState: Output only. real-time sync state
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value.
	//   "CREATING" - The connector is being set up.
	//   "ACTIVE" - The connector is successfully set up and awaiting next sync
	// run.
	//   "FAILED" - The connector is in error. The error details can be found in
	// DataConnector.errors. If the error is unfixable, the DataConnector can be
	// deleted by [CollectionService.DeleteCollection] API.
	//   "RUNNING" - The connector is actively syncing records from the data
	// source.
	//   "WARNING" - The connector has completed a sync run, but encountered
	// non-fatal errors.
	//   "INITIALIZATION_FAILED" - Connector initialization failed. Potential
	// causes include runtime errors or issues in the asynchronous pipeline,
	// preventing the request from reaching downstream services (except for some
	// connector types).
	//   "UPDATING" - Connector is in the process of an update.
	RealtimeState string `json:"realtimeState,omitempty"`
	// RealtimeSyncConfig: Optional. The configuration for realtime sync.
	RealtimeSyncConfig *GoogleCloudDiscoveryengineV1DataConnectorRealtimeSyncConfig `json:"realtimeSyncConfig,omitempty"`
	// RefreshInterval: Required. The refresh interval for data sync. If duration
	// is set to 0, the data will be synced in real time. The streaming feature is
	// not supported yet. The minimum is 30 minutes and maximum is 7 days. When the
	// refresh interval is set to the same value as the incremental refresh
	// interval, incremental sync will be disabled.
	RefreshInterval string `json:"refreshInterval,omitempty"`
	// RemoveParamKeys: Optional. Specifies keys to be removed from the 'params'
	// field. This is only active when 'params' is included in the 'update_mask' in
	// an UpdateDataConnectorRequest. Deletion takes precedence if a key is both in
	// 'remove_param_keys' and present in the 'params' field of the request.
	RemoveParamKeys []string `json:"removeParamKeys,omitempty"`
	// State: Output only. State of the connector.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value.
	//   "CREATING" - The connector is being set up.
	//   "ACTIVE" - The connector is successfully set up and awaiting next sync
	// run.
	//   "FAILED" - The connector is in error. The error details can be found in
	// DataConnector.errors. If the error is unfixable, the DataConnector can be
	// deleted by [CollectionService.DeleteCollection] API.
	//   "RUNNING" - The connector is actively syncing records from the data
	// source.
	//   "WARNING" - The connector has completed a sync run, but encountered
	// non-fatal errors.
	//   "INITIALIZATION_FAILED" - Connector initialization failed. Potential
	// causes include runtime errors or issues in the asynchronous pipeline,
	// preventing the request from reaching downstream services (except for some
	// connector types).
	//   "UPDATING" - Connector is in the process of an update.
	State string `json:"state,omitempty"`
	// StaticIpAddresses: Output only. The static IP addresses used by this
	// connector.
	StaticIpAddresses []string `json:"staticIpAddresses,omitempty"`
	// StaticIpEnabled: Optional. Whether customer has enabled static IP addresses
	// for this connector.
	StaticIpEnabled bool `json:"staticIpEnabled,omitempty"`
	// SyncMode: The data synchronization mode supported by the data connector.
	//
	// Possible values:
	//   "PERIODIC" - The connector will sync data periodically based on the
	// refresh_interval. Use it with auto_run_disabled to pause the periodic sync,
	// or indicate a one-time sync.
	//   "STREAMING" - The data will be synced in real time.
	//   "UNSPECIFIED" - Connector that doesn't ingest data will have this value
	SyncMode string `json:"syncMode,omitempty"`
	// UpdateTime: Output only. Timestamp the DataConnector was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AclEnabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AclEnabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DataConnector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DataConnector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DataConnectorEndUserConfig: Any params and
// credentials used specifically for EUA connectors.
type GoogleCloudDiscoveryengineV1DataConnectorEndUserConfig struct {
	// AdditionalParams: Optional. Any additional parameters needed for EUA.
	AdditionalParams googleapi.RawMessage `json:"additionalParams,omitempty"`
	// AuthParams: Optional. Any authentication parameters specific to EUA
	// connectors.
	AuthParams googleapi.RawMessage `json:"authParams,omitempty"`
	// JsonAuthParams: Optional. Any authentication parameters specific to EUA
	// connectors in json string format.
	JsonAuthParams string `json:"jsonAuthParams,omitempty"`
	// Tenant: Optional. The tenant project the connector is connected to.
	Tenant *GoogleCloudDiscoveryengineV1Tenant `json:"tenant,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalParams") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalParams") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DataConnectorEndUserConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DataConnectorEndUserConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DataConnectorFederatedConfig: Any params and
// credentials used specifically for hybrid connectors supporting FEDERATED
// mode.
type GoogleCloudDiscoveryengineV1DataConnectorFederatedConfig struct {
	// AdditionalParams: Optional. Any additional parameters needed for FEDERATED.
	AdditionalParams googleapi.RawMessage `json:"additionalParams,omitempty"`
	// AuthParams: Optional. Any authentication parameters specific to FEDERATED
	// connectors.
	AuthParams googleapi.RawMessage `json:"authParams,omitempty"`
	// JsonAuthParams: Optional. Any authentication parameters specific to
	// FEDERATED connectors in json string format.
	JsonAuthParams string `json:"jsonAuthParams,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalParams") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalParams") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DataConnectorFederatedConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DataConnectorFederatedConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DataConnectorRealtimeSyncConfig: The
// configuration for realtime sync to store additional params for realtime
// sync.
type GoogleCloudDiscoveryengineV1DataConnectorRealtimeSyncConfig struct {
	// RealtimeSyncSecret: Optional. The ID of the Secret Manager secret used for
	// webhook secret.
	RealtimeSyncSecret string `json:"realtimeSyncSecret,omitempty"`
	// StreamingError: Optional. Streaming error details.
	StreamingError *GoogleCloudDiscoveryengineV1DataConnectorRealtimeSyncConfigStreamingError `json:"streamingError,omitempty"`
	// WebhookUri: Optional. Webhook url for the connector to specify additional
	// params for realtime sync.
	WebhookUri string `json:"webhookUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RealtimeSyncSecret") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RealtimeSyncSecret") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DataConnectorRealtimeSyncConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DataConnectorRealtimeSyncConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DataConnectorRealtimeSyncConfigStreamingError:
// Streaming error details.
type GoogleCloudDiscoveryengineV1DataConnectorRealtimeSyncConfigStreamingError struct {
	// Error: Optional. Error details.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// StreamingErrorReason: Optional. Streaming error.
	//
	// Possible values:
	//   "STREAMING_ERROR_REASON_UNSPECIFIED" - Streaming error reason unspecified.
	//   "STREAMING_SETUP_ERROR" - Some error occurred while setting up resources
	// for realtime sync.
	//   "STREAMING_SYNC_ERROR" - Some error was encountered while running realtime
	// sync for the connector.
	//   "INGRESS_ENDPOINT_REQUIRED" - Ingress endpoint is required when setting up
	// realtime sync in private connectivity.
	StreamingErrorReason string `json:"streamingErrorReason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DataConnectorRealtimeSyncConfigStreamingError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DataConnectorRealtimeSyncConfigStreamingError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DataConnectorSourceEntity: Represents an entity
// in the data source. For example, the `Account` object in Salesforce.
type GoogleCloudDiscoveryengineV1DataConnectorSourceEntity struct {
	// DataStore: Output only. The full resource name of the associated data store
	// for the source entity. Format:
	// `projects/*/locations/*/collections/*/dataStores/*`. When the connector is
	// initialized by the DataConnectorService.SetUpDataConnector method, a
	// DataStore is automatically created for each source entity.
	DataStore string `json:"dataStore,omitempty"`
	// EntityName: The name of the entity. Supported values by data source: *
	// Salesforce: `Lead`, `Opportunity`, `Contact`, `Account`, `Case`, `Contract`,
	// `Campaign` * Jira: `Issue` * Confluence: `Content`, `Space`
	EntityName string `json:"entityName,omitempty"`
	// HealthcareFhirConfig: Optional. Configuration for `HEALTHCARE_FHIR`
	// vertical.
	HealthcareFhirConfig *GoogleCloudDiscoveryengineV1HealthcareFhirConfig `json:"healthcareFhirConfig,omitempty"`
	// JsonParams: The parameters for the entity to facilitate data ingestion in
	// json string format.
	JsonParams string `json:"jsonParams,omitempty"`
	// KeyPropertyMappings: Attributes for indexing. Key: Field name. Value: The
	// key property to map a field to, such as `title`, and `description`.
	// Supported key properties: * `title`: The title for data record. This would
	// be displayed on search results. * `description`: The description for data
	// record. This would be displayed on search results.
	KeyPropertyMappings map[string]string `json:"keyPropertyMappings,omitempty"`
	// Params: The parameters for the entity to facilitate data ingestion in
	// structured json format.
	Params googleapi.RawMessage `json:"params,omitempty"`
	// StartingSchema: Optional. The start schema to use for the DataStore created
	// from this SourceEntity. If unset, a default vertical specialized schema will
	// be used. This field is only used by SetUpDataConnector API, and will be
	// ignored if used in other APIs. This field will be omitted from all API
	// responses including GetDataConnector API. To retrieve a schema of a
	// DataStore, use SchemaService.GetSchema API instead. The provided schema will
	// be validated against certain rules on schema. Learn more from this doc
	// (https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
	StartingSchema *GoogleCloudDiscoveryengineV1Schema `json:"startingSchema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DataConnectorSourceEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DataConnectorSourceEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DataStore: DataStore captures global settings
// and configs at the DataStore level.
type GoogleCloudDiscoveryengineV1DataStore struct {
	// AclEnabled: Immutable. Whether data in the DataStore has ACL information. If
	// set to `true`, the source data must have ACL. ACL will be ingested when data
	// is ingested by DocumentService.ImportDocuments methods. When ACL is enabled
	// for the DataStore, Document can't be accessed by calling
	// DocumentService.GetDocument or DocumentService.ListDocuments. Currently ACL
	// is only supported in `GENERIC` industry vertical with non-`PUBLIC_WEBSITE`
	// content config.
	AclEnabled bool `json:"aclEnabled,omitempty"`
	// AdvancedSiteSearchConfig: Optional. Configuration for advanced site search.
	AdvancedSiteSearchConfig *GoogleCloudDiscoveryengineV1AdvancedSiteSearchConfig `json:"advancedSiteSearchConfig,omitempty"`
	// BillingEstimation: Output only. Data size estimation for billing.
	BillingEstimation *GoogleCloudDiscoveryengineV1DataStoreBillingEstimation `json:"billingEstimation,omitempty"`
	// CmekConfig: Output only. CMEK-related information for the DataStore.
	CmekConfig *GoogleCloudDiscoveryengineV1CmekConfig `json:"cmekConfig,omitempty"`
	// ConfigurableBillingApproach: Optional. Configuration for configurable
	// billing approach. See
	//
	// Possible values:
	//   "CONFIGURABLE_BILLING_APPROACH_UNSPECIFIED" - Default value. For Spark and
	// non-Spark non-configurable billing approach.
	//   "CONFIGURABLE_SUBSCRIPTION_INDEXING_CORE" - Use the subscription base +
	// overage billing for indexing core for non embedding storage.
	//   "CONFIGURABLE_CONSUMPTION_EMBEDDING" - Use the consumption pay-as-you-go
	// billing for embedding storage add-on.
	ConfigurableBillingApproach string `json:"configurableBillingApproach,omitempty"`
	// ConfigurableBillingApproachUpdateTime: Output only. The timestamp when
	// configurable_billing_approach was last updated.
	ConfigurableBillingApproachUpdateTime string `json:"configurableBillingApproachUpdateTime,omitempty"`
	// ContentConfig: Immutable. The content config of the data store. If this
	// field is unset, the server behavior defaults to ContentConfig.NO_CONTENT.
	//
	// Possible values:
	//   "CONTENT_CONFIG_UNSPECIFIED" - Default value.
	//   "NO_CONTENT" - Only contains documents without any Document.content.
	//   "CONTENT_REQUIRED" - Only contains documents with Document.content.
	//   "PUBLIC_WEBSITE" - The data store is used for public website search.
	//   "GOOGLE_WORKSPACE" - The data store is used for workspace search. Details
	// of workspace data store are specified in the WorkspaceConfig.
	ContentConfig string `json:"contentConfig,omitempty"`
	// CreateTime: Output only. Timestamp the DataStore was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DefaultSchemaId: Output only. The id of the default Schema associated to
	// this data store.
	DefaultSchemaId string `json:"defaultSchemaId,omitempty"`
	// DisplayName: Required. The data store display name. This field must be a
	// UTF-8 encoded string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	DisplayName string `json:"displayName,omitempty"`
	// DocumentProcessingConfig: Configuration for Document understanding and
	// enrichment.
	DocumentProcessingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfig `json:"documentProcessingConfig,omitempty"`
	// HealthcareFhirConfig: Optional. Configuration for `HEALTHCARE_FHIR`
	// vertical.
	HealthcareFhirConfig *GoogleCloudDiscoveryengineV1HealthcareFhirConfig `json:"healthcareFhirConfig,omitempty"`
	// IdentityMappingStore: Immutable. The fully qualified resource name of the
	// associated IdentityMappingStore. This field can only be set for acl_enabled
	// DataStores with `THIRD_PARTY` or `GSUITE` IdP. Format:
	// `projects/{project}/locations/{location}/identityMappingStores/{identity_mapp
	// ing_store}`.
	IdentityMappingStore string `json:"identityMappingStore,omitempty"`
	// IndustryVertical: Immutable. The industry vertical that the data store
	// registers.
	//
	// Possible values:
	//   "INDUSTRY_VERTICAL_UNSPECIFIED" - Value used when unset.
	//   "GENERIC" - The generic vertical for documents that are not specific to
	// any industry vertical.
	//   "MEDIA" - The media industry vertical.
	//   "HEALTHCARE_FHIR" - The healthcare FHIR vertical.
	IndustryVertical string `json:"industryVertical,omitempty"`
	// IsInfobotFaqDataStore: Optional. If set, this DataStore is an Infobot FAQ
	// DataStore.
	IsInfobotFaqDataStore bool `json:"isInfobotFaqDataStore,omitempty"`
	// KmsKeyName: Input only. The KMS key to be used to protect this DataStore at
	// creation time. Must be set for requests that need to comply with CMEK Org
	// Policy protections. If this field is set and processed successfully, the
	// DataStore will be protected by the KMS key, as indicated in the cmek_config
	// field.
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// Name: Immutable. Identifier. The full resource name of the data store.
	// Format:
	// `projects/{project}/locations/{location}/collections/{collection_id}/dataStor
	// es/{data_store_id}`. This field must be a UTF-8 encoded string with a length
	// limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// ServingConfigDataStore: Optional. Stores serving config at DataStore level.
	ServingConfigDataStore *GoogleCloudDiscoveryengineV1DataStoreServingConfigDataStore `json:"servingConfigDataStore,omitempty"`
	// SolutionTypes: The solutions that the data store enrolls. Available
	// solutions for each industry_vertical: * `MEDIA`:
	// `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`. * `SITE_SEARCH`:
	// `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other solutions cannot be
	// enrolled.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionTypes []string `json:"solutionTypes,omitempty"`
	// StartingSchema: The start schema to use for this DataStore when provisioning
	// it. If unset, a default vertical specialized schema will be used. This field
	// is only used by CreateDataStore API, and will be ignored if used in other
	// APIs. This field will be omitted from all API responses including
	// CreateDataStore API. To retrieve a schema of a DataStore, use
	// SchemaService.GetSchema API instead. The provided schema will be validated
	// against certain rules on schema. Learn more from this doc
	// (https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
	StartingSchema *GoogleCloudDiscoveryengineV1Schema `json:"startingSchema,omitempty"`
	// WorkspaceConfig: Config to store data store type configuration for workspace
	// data. This must be set when DataStore.content_config is set as
	// DataStore.ContentConfig.GOOGLE_WORKSPACE.
	WorkspaceConfig *GoogleCloudDiscoveryengineV1WorkspaceConfig `json:"workspaceConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AclEnabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AclEnabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DataStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DataStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DataStoreBillingEstimation: Estimation of data
// size per data store.
type GoogleCloudDiscoveryengineV1DataStoreBillingEstimation struct {
	// StructuredDataSize: Data size for structured data in terms of bytes.
	StructuredDataSize int64 `json:"structuredDataSize,omitempty,string"`
	// StructuredDataUpdateTime: Last updated timestamp for structured data.
	StructuredDataUpdateTime string `json:"structuredDataUpdateTime,omitempty"`
	// UnstructuredDataSize: Data size for unstructured data in terms of bytes.
	UnstructuredDataSize int64 `json:"unstructuredDataSize,omitempty,string"`
	// UnstructuredDataUpdateTime: Last updated timestamp for unstructured data.
	UnstructuredDataUpdateTime string `json:"unstructuredDataUpdateTime,omitempty"`
	// WebsiteDataSize: Data size for websites in terms of bytes.
	WebsiteDataSize int64 `json:"websiteDataSize,omitempty,string"`
	// WebsiteDataUpdateTime: Last updated timestamp for websites.
	WebsiteDataUpdateTime string `json:"websiteDataUpdateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StructuredDataSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StructuredDataSize") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DataStoreBillingEstimation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DataStoreBillingEstimation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DataStoreServingConfigDataStore: Stores
// information regarding the serving configurations at DataStore level.
type GoogleCloudDiscoveryengineV1DataStoreServingConfigDataStore struct {
	// DisabledForServing: Optional. If set true, the DataStore will not be
	// available for serving search requests.
	DisabledForServing bool `json:"disabledForServing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisabledForServing") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisabledForServing") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DataStoreServingConfigDataStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DataStoreServingConfigDataStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DeleteCmekConfigMetadata: Metadata related to
// the progress of the CmekConfigService.DeleteCmekConfig operation. This will
// be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1DeleteCmekConfigMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DeleteCmekConfigMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DeleteCmekConfigMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DeleteCollectionMetadata: Metadata related to
// the progress of the CollectionService.UpdateCollection operation. This will
// be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1DeleteCollectionMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DeleteCollectionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DeleteCollectionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DeleteDataStoreMetadata: Metadata related to the
// progress of the DataStoreService.DeleteDataStore operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1DeleteDataStoreMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DeleteDataStoreMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DeleteDataStoreMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DeleteEngineMetadata: Metadata related to the
// progress of the EngineService.DeleteEngine operation. This will be returned
// by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1DeleteEngineMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DeleteEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DeleteEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DeleteIdentityMappingStoreMetadata: Metadata
// related to the progress of the
// IdentityMappingStoreService.DeleteIdentityMappingStore operation. This will
// be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1DeleteIdentityMappingStoreMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DeleteIdentityMappingStoreMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DeleteIdentityMappingStoreMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DeleteSchemaMetadata: Metadata for DeleteSchema
// LRO.
type GoogleCloudDiscoveryengineV1DeleteSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DeleteSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DeleteSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DeleteSitemapMetadata: Metadata related to the
// progress of the SiteSearchEngineService.DeleteSitemap operation. This will
// be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1DeleteSitemapMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DeleteSitemapMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DeleteSitemapMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DeleteTargetSiteMetadata: Metadata related to
// the progress of the SiteSearchEngineService.DeleteTargetSite operation. This
// will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1DeleteTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DeleteTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DeleteTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DestinationConfig: Defines target endpoints used
// to connect to third-party sources.
type GoogleCloudDiscoveryengineV1DestinationConfig struct {
	// Destinations: Optional. The destinations for the corresponding key.
	Destinations []*GoogleCloudDiscoveryengineV1DestinationConfigDestination `json:"destinations,omitempty"`
	// JsonParams: Additional parameters for this destination config in json string
	// format.
	JsonParams string `json:"jsonParams,omitempty"`
	// Key: Optional. Unique destination identifier that is supported by the
	// connector.
	Key string `json:"key,omitempty"`
	// Params: Optional. Additional parameters for this destination config in
	// structured json format.
	Params googleapi.RawMessage `json:"params,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Destinations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Destinations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DestinationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DestinationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DestinationConfigDestination: Defines a target
// endpoint
type GoogleCloudDiscoveryengineV1DestinationConfigDestination struct {
	// Host: Publicly routable host.
	Host string `json:"host,omitempty"`
	// Port: Optional. Target port number accepted by the destination.
	Port int64 `json:"port,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Host") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Host") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DestinationConfigDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DestinationConfigDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.DisableAdvancedSiteSearch operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchRequest: Request
// message for SiteSearchEngineService.DisableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchRequest struct {
}

// GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchResponse: Response
// message for SiteSearchEngineService.DisableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchResponse struct {
}

// GoogleCloudDiscoveryengineV1Document: Document captures all raw metadata
// information of items to be recommended or searched.
type GoogleCloudDiscoveryengineV1Document struct {
	// AclInfo: Access control information for the document.
	AclInfo *GoogleCloudDiscoveryengineV1DocumentAclInfo `json:"aclInfo,omitempty"`
	// Content: The unstructured data linked to this document. Content can only be
	// set and must be set if this document is under a `CONTENT_REQUIRED` data
	// store.
	Content *GoogleCloudDiscoveryengineV1DocumentContent `json:"content,omitempty"`
	// DerivedStructData: Output only. This field is OUTPUT_ONLY. It contains
	// derived data that are not in the original input document.
	DerivedStructData googleapi.RawMessage `json:"derivedStructData,omitempty"`
	// Id: Immutable. The identifier of the document. Id should conform to RFC-1034
	// (https://tools.ietf.org/html/rfc1034) standard with a length limit of 128
	// characters.
	Id string `json:"id,omitempty"`
	// IndexStatus: Output only. The index status of the document. * If document is
	// indexed successfully, the index_time field is populated. * Otherwise, if
	// document is not indexed due to errors, the error_samples field is populated.
	// * Otherwise, if document's index is in progress, the pending_message field
	// is populated.
	IndexStatus *GoogleCloudDiscoveryengineV1DocumentIndexStatus `json:"indexStatus,omitempty"`
	// IndexTime: Output only. The last time the document was indexed. If this
	// field is set, the document could be returned in search results. This field
	// is OUTPUT_ONLY. If this field is not populated, it means the document has
	// never been indexed.
	IndexTime string `json:"indexTime,omitempty"`
	// JsonData: The JSON string representation of the document. It should conform
	// to the registered Schema or an `INVALID_ARGUMENT` error is thrown.
	JsonData string `json:"jsonData,omitempty"`
	// Name: Immutable. The full resource name of the document. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/branches/{branch}/documents/{document_id}`. This field must be
	// a UTF-8 encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// ParentDocumentId: The identifier of the parent document. Currently supports
	// at most two level document hierarchy. Id should conform to RFC-1034
	// (https://tools.ietf.org/html/rfc1034) standard with a length limit of 63
	// characters.
	ParentDocumentId string `json:"parentDocumentId,omitempty"`
	// SchemaId: The identifier of the schema located in the same data store.
	SchemaId string `json:"schemaId,omitempty"`
	// StructData: The structured JSON data for the document. It should conform to
	// the registered Schema or an `INVALID_ARGUMENT` error is thrown.
	StructData googleapi.RawMessage `json:"structData,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AclInfo") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AclInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Document) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Document
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentAclInfo: ACL Information of the
// Document.
type GoogleCloudDiscoveryengineV1DocumentAclInfo struct {
	// Readers: Readers of the document.
	Readers []*GoogleCloudDiscoveryengineV1DocumentAclInfoAccessRestriction `json:"readers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Readers") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Readers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentAclInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentAclInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentAclInfoAccessRestriction: AclRestriction
// to model complex inheritance restrictions. Example: Modeling a "Both Permit"
// inheritance, where to access a child document, user needs to have access to
// parent document. Document Hierarchy - Space_S --> Page_P. Readers: Space_S:
// group_1, user_1 Page_P: group_2, group_3, user_2 Space_S ACL Restriction - {
// "acl_info": { "readers": [ { "principals": [ { "group_id": "group_1" }, {
// "user_id": "user_1" } ] } ] } } Page_P ACL Restriction. { "acl_info": {
// "readers": [ { "principals": [ { "group_id": "group_2" }, { "group_id":
// "group_3" }, { "user_id": "user_2" } ], }, { "principals": [ { "group_id":
// "group_1" }, { "user_id": "user_1" } ], } ] } }
type GoogleCloudDiscoveryengineV1DocumentAclInfoAccessRestriction struct {
	// IdpWide: All users within the Identity Provider.
	IdpWide bool `json:"idpWide,omitempty"`
	// Principals: List of principals.
	Principals []*GoogleCloudDiscoveryengineV1Principal `json:"principals,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IdpWide") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdpWide") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentAclInfoAccessRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentAclInfoAccessRestriction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentContent: Unstructured data linked to
// this document.
type GoogleCloudDiscoveryengineV1DocumentContent struct {
	// MimeType: The MIME type of the content. Supported types: * `application/pdf`
	// (PDF, only native PDFs are supported for now) * `text/html` (HTML) *
	// `text/plain` (TXT) * `application/xml` or `text/xml` (XML) *
	// `application/json` (JSON) *
	// `application/vnd.openxmlformats-officedocument.wordprocessingml.document`
	// (DOCX) *
	// `application/vnd.openxmlformats-officedocument.presentationml.presentation`
	// (PPTX) * `application/vnd.openxmlformats-officedocument.spreadsheetml.sheet`
	// (XLSX) * `application/vnd.ms-excel.sheet.macroenabled.12` (XLSM) The
	// following types are supported only if layout parser is enabled in the data
	// store: * `image/bmp` (BMP) * `image/gif` (GIF) * `image/jpeg` (JPEG) *
	// `image/png` (PNG) * `image/tiff` (TIFF) See
	// https://www.iana.org/assignments/media-types/media-types.xhtml.
	MimeType string `json:"mimeType,omitempty"`
	// RawBytes: The content represented as a stream of bytes. The maximum length
	// is 1,000,000 bytes (1 MB / ~0.95 MiB). Note: As with all `bytes` fields,
	// this field is represented as pure binary in Protocol Buffers and
	// base64-encoded string in JSON. For example, `abc123!?$*&()'-=@~` should be
	// represented as `YWJjMTIzIT8kKiYoKSctPUB+` in JSON. See
	// https://developers.google.com/protocol-buffers/docs/proto3#json.
	RawBytes string `json:"rawBytes,omitempty"`
	// Uri: The URI of the content. Only Cloud Storage URIs (e.g.
	// `gs://bucket-name/path/to/file`) are supported. The maximum file size is 2.5
	// MB for text-based formats, 200 MB for other formats.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MimeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MimeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentIndexStatus: Index status of the
// document.
type GoogleCloudDiscoveryengineV1DocumentIndexStatus struct {
	// ErrorSamples: A sample of errors encountered while indexing the document. If
	// this field is populated, the document is not indexed due to errors.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// IndexTime: The time when the document was indexed. If this field is
	// populated, it means the document has been indexed.
	IndexTime string `json:"indexTime,omitempty"`
	// PendingMessage: Immutable. The message indicates the document index is in
	// progress. If this field is populated, the document index is pending.
	PendingMessage string `json:"pendingMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentIndexStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentIndexStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentInfo: Detailed document information
// associated with a user event.
type GoogleCloudDiscoveryengineV1DocumentInfo struct {
	// ConversionValue: Optional. The conversion value associated with this
	// Document. Must be set if UserEvent.event_type is "conversion". For example,
	// a value of 1000 signifies that 1000 seconds were spent viewing a Document
	// for the `watch` conversion type.
	ConversionValue float64 `json:"conversionValue,omitempty"`
	// Id: The Document resource ID.
	Id string `json:"id,omitempty"`
	// Joined: Output only. Whether the referenced Document can be found in the
	// data store.
	Joined bool `json:"joined,omitempty"`
	// Name: The Document resource full name, of the form:
	// `projects/{project}/locations/{location}/collections/{collection_id}/dataStor
	// es/{data_store_id}/branches/{branch_id}/documents/{document_id}`
	Name string `json:"name,omitempty"`
	// PromotionIds: The promotion IDs associated with this Document. Currently,
	// this field is restricted to at most one ID.
	PromotionIds []string `json:"promotionIds,omitempty"`
	// Quantity: Quantity of the Document associated with the user event. Defaults
	// to 1. For example, this field is 2 if two quantities of the same Document
	// are involved in a `add-to-cart` event. Required for events of the following
	// event types: * `add-to-cart` * `purchase`
	Quantity int64 `json:"quantity,omitempty"`
	// Uri: The Document URI - only allowed for website data stores.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversionValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversionValue") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1DocumentInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentInfo
	var s1 struct {
		ConversionValue gensupport.JSONFloat64 `json:"conversionValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConversionValue = float64(s1.ConversionValue)
	return nil
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfig: A singleton resource
// of DataStore. If it's empty when DataStore is created and DataStore is set
// to DataStore.ContentConfig.CONTENT_REQUIRED, the default parser will default
// to digital parser.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfig struct {
	// ChunkingConfig: Whether chunking mode is enabled.
	ChunkingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfig `json:"chunkingConfig,omitempty"`
	// DefaultParsingConfig: Configurations for default Document parser. If not
	// specified, we will configure it as default DigitalParsingConfig, and the
	// default parsing config will be applied to all file types for Document
	// parsing.
	DefaultParsingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig `json:"defaultParsingConfig,omitempty"`
	// Name: The full resource name of the Document Processing Config. Format:
	// `projects/*/locations/*/collections/*/dataStores/*/documentProcessingConfig`.
	Name string `json:"name,omitempty"`
	// ParsingConfigOverrides: Map from file type to override the default parsing
	// configuration based on the file type. Supported keys: * `pdf`: Override
	// parsing config for PDF files, either digital parsing, ocr parsing or layout
	// parsing is supported. * `html`: Override parsing config for HTML files, only
	// digital parsing and layout parsing are supported. * `docx`: Override parsing
	// config for DOCX files, only digital parsing and layout parsing are
	// supported. * `pptx`: Override parsing config for PPTX files, only digital
	// parsing and layout parsing are supported. * `xlsm`: Override parsing config
	// for XLSM files, only digital parsing and layout parsing are supported. *
	// `xlsx`: Override parsing config for XLSX files, only digital parsing and
	// layout parsing are supported.
	ParsingConfigOverrides map[string]GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig `json:"parsingConfigOverrides,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkingConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentProcessingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentProcessingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfig:
// Configuration for chunking config.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfig struct {
	// LayoutBasedChunkingConfig: Configuration for the layout based chunking.
	LayoutBasedChunkingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig `json:"layoutBasedChunkingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LayoutBasedChunkingConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LayoutBasedChunkingConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfigLayoutBased
// ChunkingConfig: Configuration for the layout based chunking.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig struct {
	// ChunkSize: The token size limit for each chunk. Supported values: 100-500
	// (inclusive). Default value: 500.
	ChunkSize int64 `json:"chunkSize,omitempty"`
	// IncludeAncestorHeadings: Whether to include appending different levels of
	// headings to chunks from the middle of the document to prevent context loss.
	// Default value: False.
	IncludeAncestorHeadings bool `json:"includeAncestorHeadings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig: Related
// configurations applied to a specific type of document parser.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig struct {
	// DigitalParsingConfig: Configurations applied to digital parser.
	DigitalParsingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigDigitalParsingConfig `json:"digitalParsingConfig,omitempty"`
	// LayoutParsingConfig: Configurations applied to layout parser.
	LayoutParsingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigLayoutParsingConfig `json:"layoutParsingConfig,omitempty"`
	// OcrParsingConfig: Configurations applied to OCR parser. Currently it only
	// applies to PDFs.
	OcrParsingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigOcrParsingConfig `json:"ocrParsingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DigitalParsingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DigitalParsingConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigDigitalParsi
// ngConfig: The digital parsing configurations for documents.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigDigitalParsingConfig struct {
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigLayoutParsin
// gConfig: The layout parsing configurations for documents.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigLayoutParsingConfig struct {
	// EnableGetProcessedDocument: Optional. If true, the processed document will
	// be made available for the GetProcessedDocument API.
	EnableGetProcessedDocument bool `json:"enableGetProcessedDocument,omitempty"`
	// EnableImageAnnotation: Optional. If true, the LLM based annotation is added
	// to the image during parsing.
	EnableImageAnnotation bool `json:"enableImageAnnotation,omitempty"`
	// EnableTableAnnotation: Optional. If true, the LLM based annotation is added
	// to the table during parsing.
	EnableTableAnnotation bool `json:"enableTableAnnotation,omitempty"`
	// ExcludeHtmlClasses: Optional. List of HTML classes to exclude from the
	// parsed content.
	ExcludeHtmlClasses []string `json:"excludeHtmlClasses,omitempty"`
	// ExcludeHtmlElements: Optional. List of HTML elements to exclude from the
	// parsed content.
	ExcludeHtmlElements []string `json:"excludeHtmlElements,omitempty"`
	// ExcludeHtmlIds: Optional. List of HTML ids to exclude from the parsed
	// content.
	ExcludeHtmlIds []string `json:"excludeHtmlIds,omitempty"`
	// StructuredContentTypes: Optional. Contains the required structure types to
	// extract from the document. Supported values: * `shareholder-structure`
	StructuredContentTypes []string `json:"structuredContentTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableGetProcessedDocument")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableGetProcessedDocument") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigLayoutParsingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigLayoutParsingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigOcrParsingCo
// nfig: The OCR parsing configurations for documents.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigOcrParsingConfig struct {
	// EnhancedDocumentElements: [DEPRECATED] This field is deprecated. To use the
	// additional enhanced document elements processing, please switch to
	// `layout_parsing_config`.
	EnhancedDocumentElements []string `json:"enhancedDocumentElements,omitempty"`
	// UseNativeText: If true, will use native text instead of OCR text on pages
	// containing native text.
	UseNativeText bool `json:"useNativeText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnhancedDocumentElements")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnhancedDocumentElements") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigOcrParsingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigOcrParsingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DoubleList: Double list.
type GoogleCloudDiscoveryengineV1DoubleList struct {
	// Values: Double values.
	Values []float64 `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DoubleList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DoubleList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1DoubleList) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1DoubleList
	var s1 struct {
		Values []gensupport.JSONFloat64 `json:"values"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Values = make([]float64, len(s1.Values))
	for i := range s1.Values {
		s.Values[i] = float64(s1.Values[i])
	}
	return nil
}

// GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.EnableAdvancedSiteSearch operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchRequest: Request message
// for SiteSearchEngineService.EnableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchRequest struct {
}

// GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchResponse: Response
// message for SiteSearchEngineService.EnableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchResponse struct {
}

// GoogleCloudDiscoveryengineV1Engine: Metadata that describes the training and
// serving parameters of an Engine.
type GoogleCloudDiscoveryengineV1Engine struct {
	// AppType: Optional. Immutable. This the application type which this engine
	// resource represents. NOTE: this is a new concept independ of existing
	// industry vertical or solution type.
	//
	// Possible values:
	//   "APP_TYPE_UNSPECIFIED" - All non specified apps.
	//   "APP_TYPE_INTRANET" - App type for intranet search and Agentspace.
	AppType string `json:"appType,omitempty"`
	// ChatEngineConfig: Configurations for the Chat Engine. Only applicable if
	// solution_type is SOLUTION_TYPE_CHAT.
	ChatEngineConfig *GoogleCloudDiscoveryengineV1EngineChatEngineConfig `json:"chatEngineConfig,omitempty"`
	// ChatEngineMetadata: Output only. Additional information of the Chat Engine.
	// Only applicable if solution_type is SOLUTION_TYPE_CHAT.
	ChatEngineMetadata *GoogleCloudDiscoveryengineV1EngineChatEngineMetadata `json:"chatEngineMetadata,omitempty"`
	// CommonConfig: Common config spec that specifies the metadata of the engine.
	CommonConfig *GoogleCloudDiscoveryengineV1EngineCommonConfig `json:"commonConfig,omitempty"`
	// ConfigurableBillingApproach: Optional. Configuration for configurable
	// billing approach.
	//
	// Possible values:
	//   "CONFIGURABLE_BILLING_APPROACH_UNSPECIFIED" - Default value. For Spark and
	// non-Spark non-configurable billing approach. General pricing model.
	//   "CONFIGURABLE_BILLING_APPROACH_ENABLED" - The billing approach follows
	// configurations specified by customer.
	ConfigurableBillingApproach string `json:"configurableBillingApproach,omitempty"`
	// CreateTime: Output only. Timestamp the Recommendation Engine was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DataStoreIds: Optional. The data stores associated with this engine. For
	// SOLUTION_TYPE_SEARCH and SOLUTION_TYPE_RECOMMENDATION type of engines, they
	// can only associate with at most one data store. If solution_type is
	// SOLUTION_TYPE_CHAT, multiple DataStores in the same Collection can be
	// associated here. Note that when used in CreateEngineRequest, one DataStore
	// id must be provided as the system will use it for necessary initializations.
	DataStoreIds []string `json:"dataStoreIds,omitempty"`
	// DisableAnalytics: Optional. Whether to disable analytics for searches
	// performed on this engine.
	DisableAnalytics bool `json:"disableAnalytics,omitempty"`
	// DisplayName: Required. The display name of the engine. Should be human
	// readable. UTF-8 encoded string with limit of 1024 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Features: Optional. Feature config for the engine to opt in or opt out of
	// features. Supported keys: * `*`: all features, if it's present, all other
	// feature state settings are ignored. * `agent-gallery` *
	// `no-code-agent-builder` * `prompt-gallery` * `model-selector` *
	// `notebook-lm` * `people-search` * `people-search-org-chart` *
	// `bi-directional-audio` * `feedback` * `session-sharing` *
	// `personalization-memory` * `disable-agent-sharing` *
	// `disable-image-generation` * `disable-video-generation` *
	// `disable-onedrive-upload` * `disable-talk-to-content` *
	// `disable-google-drive-upload`
	Features map[string]string `json:"features,omitempty"`
	// IndustryVertical: Optional. The industry vertical that the engine registers.
	// The restriction of the Engine industry vertical is based on DataStore:
	// Vertical on Engine has to match vertical of the DataStore linked to the
	// engine.
	//
	// Possible values:
	//   "INDUSTRY_VERTICAL_UNSPECIFIED" - Value used when unset.
	//   "GENERIC" - The generic vertical for documents that are not specific to
	// any industry vertical.
	//   "MEDIA" - The media industry vertical.
	//   "HEALTHCARE_FHIR" - The healthcare FHIR vertical.
	IndustryVertical string `json:"industryVertical,omitempty"`
	// MediaRecommendationEngineConfig: Configurations for the Media Engine. Only
	// applicable on the data stores with solution_type
	// SOLUTION_TYPE_RECOMMENDATION and IndustryVertical.MEDIA vertical.
	MediaRecommendationEngineConfig *GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfig `json:"mediaRecommendationEngineConfig,omitempty"`
	// Name: Immutable. Identifier. The fully qualified resource name of the
	// engine. This field must be a UTF-8 encoded string with a length limit of
	// 1024 characters. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/engines/{en
	// gine}` engine should be 1-63 characters, and valid characters are /a-z0-9*/.
	// Otherwise, an INVALID_ARGUMENT error is returned.
	Name string `json:"name,omitempty"`
	// SearchEngineConfig: Configurations for the Search Engine. Only applicable if
	// solution_type is SOLUTION_TYPE_SEARCH.
	SearchEngineConfig *GoogleCloudDiscoveryengineV1EngineSearchEngineConfig `json:"searchEngineConfig,omitempty"`
	// SolutionType: Required. The solutions of the engine.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionType string `json:"solutionType,omitempty"`
	// UpdateTime: Output only. Timestamp the Recommendation Engine was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AppType") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Engine) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Engine
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EngineChatEngineConfig: Configurations for a
// Chat Engine.
type GoogleCloudDiscoveryengineV1EngineChatEngineConfig struct {
	// AgentCreationConfig: The configurationt generate the Dialogflow agent that
	// is associated to this Engine. Note that these configurations are one-time
	// consumed by and passed to Dialogflow service. It means they cannot be
	// retrieved using EngineService.GetEngine or EngineService.ListEngines API
	// after engine creation.
	AgentCreationConfig *GoogleCloudDiscoveryengineV1EngineChatEngineConfigAgentCreationConfig `json:"agentCreationConfig,omitempty"`
	// AllowCrossRegion: Optional. If the flag set to true, we allow the agent and
	// engine are in different locations, otherwise the agent and engine are
	// required to be in the same location. The flag is set to false by default.
	// Note that the `allow_cross_region` are one-time consumed by and passed to
	// EngineService.CreateEngine. It means they cannot be retrieved using
	// EngineService.GetEngine or EngineService.ListEngines API after engine
	// creation.
	AllowCrossRegion bool `json:"allowCrossRegion,omitempty"`
	// DialogflowAgentToLink: The resource name of an exist Dialogflow agent to
	// link to this Chat Engine. Customers can either provide
	// `agent_creation_config` to create agent or provide an agent name that links
	// the agent with the Chat engine. Format: `projects//locations//agents/`. Note
	// that the `dialogflow_agent_to_link` are one-time consumed by and passed to
	// Dialogflow service. It means they cannot be retrieved using
	// EngineService.GetEngine or EngineService.ListEngines API after engine
	// creation. Use ChatEngineMetadata.dialogflow_agent for actual agent
	// association after Engine is created.
	DialogflowAgentToLink string `json:"dialogflowAgentToLink,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentCreationConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentCreationConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineChatEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineChatEngineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EngineChatEngineConfigAgentCreationConfig:
// Configurations for generating a Dialogflow agent. Note that these
// configurations are one-time consumed by and passed to Dialogflow service. It
// means they cannot be retrieved using EngineService.GetEngine or
// EngineService.ListEngines API after engine creation.
type GoogleCloudDiscoveryengineV1EngineChatEngineConfigAgentCreationConfig struct {
	// Business: Name of the company, organization or other entity that the agent
	// represents. Used for knowledge connector LLM prompt and for knowledge
	// search.
	Business string `json:"business,omitempty"`
	// DefaultLanguageCode: Required. The default language of the agent as a
	// language tag. See Language Support
	// (https://cloud.google.com/dialogflow/docs/reference/language) for a list of
	// the currently supported language codes.
	DefaultLanguageCode string `json:"defaultLanguageCode,omitempty"`
	// Location: Agent location for Agent creation, supported values: global/us/eu.
	// If not provided, us Engine will create Agent using us-central-1 by default;
	// eu Engine will create Agent using eu-west-1 by default.
	Location string `json:"location,omitempty"`
	// TimeZone: Required. The time zone of the agent from the time zone database
	// (https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
	TimeZone string `json:"timeZone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Business") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Business") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineChatEngineConfigAgentCreationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineChatEngineConfigAgentCreationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EngineChatEngineMetadata: Additional information
// of a Chat Engine. Fields in this message are output only.
type GoogleCloudDiscoveryengineV1EngineChatEngineMetadata struct {
	// DialogflowAgent: The resource name of a Dialogflow agent, that this Chat
	// Engine refers to. Format: `projects//locations//agents/`.
	DialogflowAgent string `json:"dialogflowAgent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowAgent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowAgent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineChatEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineChatEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EngineCommonConfig: Common configurations for an
// Engine.
type GoogleCloudDiscoveryengineV1EngineCommonConfig struct {
	// CompanyName: The name of the company, business or entity that is associated
	// with the engine. Setting this may help improve LLM related features.
	CompanyName string `json:"companyName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompanyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompanyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineCommonConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineCommonConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfig:
// Additional config specs for a Media Recommendation engine.
type GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfig struct {
	// EngineFeaturesConfig: Optional. Additional engine features config.
	EngineFeaturesConfig *GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigEngineFeaturesConfig `json:"engineFeaturesConfig,omitempty"`
	// OptimizationObjective: The optimization objective. e.g., `cvr`. This field
	// together with optimization_objective describe engine metadata to use to
	// control engine training and serving. Currently supported values: `ctr`,
	// `cvr`. If not specified, we choose default based on engine type. Default
	// depends on type of recommendation: `recommended-for-you` => `ctr`
	// `others-you-may-like` => `ctr`
	OptimizationObjective string `json:"optimizationObjective,omitempty"`
	// OptimizationObjectiveConfig: Name and value of the custom threshold for cvr
	// optimization_objective. For target_field `watch-time`, target_field_value
	// must be an integer value indicating the media progress time in seconds
	// between (0, 86400] (excludes 0, includes 86400) (e.g., 90). For target_field
	// `watch-percentage`, the target_field_value must be a valid float value
	// between (0, 1.0] (excludes 0, includes 1.0) (e.g., 0.5).
	OptimizationObjectiveConfig *GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigOptimizationObjectiveConfig `json:"optimizationObjectiveConfig,omitempty"`
	// TrainingState: The training state that the engine is in (e.g. `TRAINING` or
	// `PAUSED`). Since part of the cost of running the service is frequency of
	// training - this can be used to determine when to train engine in order to
	// control cost. If not specified: the default value for `CreateEngine` method
	// is `TRAINING`. The default value for `UpdateEngine` method is to keep the
	// state the same as before.
	//
	// Possible values:
	//   "TRAINING_STATE_UNSPECIFIED" - Unspecified training state.
	//   "PAUSED" - The engine training is paused.
	//   "TRAINING" - The engine is training.
	TrainingState string `json:"trainingState,omitempty"`
	// Type: Required. The type of engine. e.g., `recommended-for-you`. This field
	// together with optimization_objective describe engine metadata to use to
	// control engine training and serving. Currently supported values:
	// `recommended-for-you`, `others-you-may-like`, `more-like-this`,
	// `most-popular-items`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EngineFeaturesConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EngineFeaturesConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigEngineFeatur
// esConfig: More feature configs of the selected engine type.
type GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigEngineFeaturesConfig struct {
	// MostPopularConfig: Most popular engine feature config.
	MostPopularConfig *GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigMostPopularFeatureConfig `json:"mostPopularConfig,omitempty"`
	// RecommendedForYouConfig: Recommended for you engine feature config.
	RecommendedForYouConfig *GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigRecommendedForYouFeatureConfig `json:"recommendedForYouConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MostPopularConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MostPopularConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigEngineFeaturesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigEngineFeaturesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigMostPopularF
// eatureConfig: Feature configurations that are required for creating a Most
// Popular engine.
type GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigMostPopularFeatureConfig struct {
	// TimeWindowDays: The time window of which the engine is queried at training
	// and prediction time. Positive integers only. The value translates to the
	// last X days of events. Currently required for the `most-popular-items`
	// engine.
	TimeWindowDays int64 `json:"timeWindowDays,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "TimeWindowDays") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TimeWindowDays") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigMostPopularFeatureConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigMostPopularFeatureConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigOptimization
// ObjectiveConfig: Custom threshold for `cvr` optimization_objective.
type GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigOptimizationObjectiveConfig struct {
	// TargetField: Required. The name of the field to target. Currently supported
	// values: `watch-percentage`, `watch-time`.
	TargetField string `json:"targetField,omitempty"`
	// TargetFieldValueFloat: Required. The threshold to be applied to the target
	// (e.g., 0.5).
	TargetFieldValueFloat float64 `json:"targetFieldValueFloat,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TargetField") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TargetField") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigOptimizationObjectiveConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigOptimizationObjectiveConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigOptimizationObjectiveConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigOptimizationObjectiveConfig
	var s1 struct {
		TargetFieldValueFloat gensupport.JSONFloat64 `json:"targetFieldValueFloat"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TargetFieldValueFloat = float64(s1.TargetFieldValueFloat)
	return nil
}

// GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigRecommendedF
// orYouFeatureConfig: Additional feature configurations for creating a
// `recommended-for-you` engine.
type GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigRecommendedForYouFeatureConfig struct {
	// ContextEventType: The type of event with which the engine is queried at
	// prediction time. If set to `generic`, only `view-item`, `media-play`,and
	// `media-complete` will be used as `context-event` in engine training. If set
	// to `view-home-page`, `view-home-page` will also be used as `context-events`
	// in addition to `view-item`, `media-play`, and `media-complete`. Currently
	// supported for the `recommended-for-you` engine. Currently supported values:
	// `view-home-page`, `generic`.
	ContextEventType string `json:"contextEventType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextEventType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextEventType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigRecommendedForYouFeatureConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigRecommendedForYouFeatureConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EngineSearchEngineConfig: Configurations for a
// Search Engine.
type GoogleCloudDiscoveryengineV1EngineSearchEngineConfig struct {
	// SearchAddOns: The add-on that this search engine enables.
	//
	// Possible values:
	//   "SEARCH_ADD_ON_UNSPECIFIED" - Default value when the enum is unspecified.
	// This is invalid to use.
	//   "SEARCH_ADD_ON_LLM" - Large language model add-on.
	SearchAddOns []string `json:"searchAddOns,omitempty"`
	// SearchTier: The search feature tier of this engine. Different tiers might
	// have different pricing. To learn more, check the pricing documentation.
	// Defaults to SearchTier.SEARCH_TIER_STANDARD if not specified.
	//
	// Possible values:
	//   "SEARCH_TIER_UNSPECIFIED" - Default value when the enum is unspecified.
	// This is invalid to use.
	//   "SEARCH_TIER_STANDARD" - Standard tier.
	//   "SEARCH_TIER_ENTERPRISE" - Enterprise tier.
	SearchTier string `json:"searchTier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchAddOns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchAddOns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineSearchEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineSearchEngineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1FactChunk: Fact Chunk.
type GoogleCloudDiscoveryengineV1FactChunk struct {
	// ChunkText: Text content of the fact chunk. Can be at most 10K characters
	// long.
	ChunkText string `json:"chunkText,omitempty"`
	// Domain: The domain of the source.
	Domain string `json:"domain,omitempty"`
	// Index: The index of this chunk. Currently, only used for the streaming mode.
	Index int64 `json:"index,omitempty"`
	// Source: Source from which this fact chunk was retrieved. If it was retrieved
	// from the GroundingFacts provided in the request then this field will contain
	// the index of the specific fact from which this chunk was retrieved.
	Source string `json:"source,omitempty"`
	// SourceMetadata: More fine-grained information for the source reference.
	SourceMetadata map[string]string `json:"sourceMetadata,omitempty"`
	// Title: The title of the source.
	Title string `json:"title,omitempty"`
	// Uri: The URI of the source.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1FactChunk) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1FactChunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1FetchDomainVerificationStatusResponse: Response
// message for SiteSearchEngineService.FetchDomainVerificationStatus method.
type GoogleCloudDiscoveryengineV1FetchDomainVerificationStatusResponse struct {
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TargetSites: List of TargetSites containing the site verification status.
	TargetSites []*GoogleCloudDiscoveryengineV1TargetSite `json:"targetSites,omitempty"`
	// TotalSize: The total number of items matching the request. This will always
	// be populated in the response.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1FetchDomainVerificationStatusResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1FetchDomainVerificationStatusResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1FetchSitemapsResponse: Response message for
// SiteSearchEngineService.FetchSitemaps method.
type GoogleCloudDiscoveryengineV1FetchSitemapsResponse struct {
	// SitemapsMetadata: List of Sitemaps fetched.
	SitemapsMetadata []*GoogleCloudDiscoveryengineV1FetchSitemapsResponseSitemapMetadata `json:"sitemapsMetadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "SitemapsMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SitemapsMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1FetchSitemapsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1FetchSitemapsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1FetchSitemapsResponseSitemapMetadata: Contains a
// Sitemap and its metadata.
type GoogleCloudDiscoveryengineV1FetchSitemapsResponseSitemapMetadata struct {
	// Sitemap: The Sitemap.
	Sitemap *GoogleCloudDiscoveryengineV1Sitemap `json:"sitemap,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Sitemap") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Sitemap") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1FetchSitemapsResponseSitemapMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1FetchSitemapsResponseSitemapMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1FhirStoreSource: Cloud FhirStore source import
// data from.
type GoogleCloudDiscoveryengineV1FhirStoreSource struct {
	// FhirStore: Required. The full resource name of the FHIR store to import data
	// from, in the format of
	// `projects/{project}/locations/{location}/datasets/{dataset}/fhirStores/{fhir_
	// store}`.
	FhirStore string `json:"fhirStore,omitempty"`
	// GcsStagingDir: Intermediate Cloud Storage directory used for the import with
	// a length limit of 2,000 characters. Can be specified if one wants to have
	// the FhirStore export to a specific Cloud Storage directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`
	// ResourceTypes: The FHIR resource types to import. The resource types should
	// be a subset of all supported FHIR resource types
	// (https://cloud.google.com/generative-ai-app-builder/docs/fhir-schema-reference#resource-level-specification).
	// Default to all supported FHIR resource types if empty.
	ResourceTypes []string `json:"resourceTypes,omitempty"`
	// UpdateFromLatestPredefinedSchema: Optional. Whether to update the DataStore
	// schema to the latest predefined schema. If true, the DataStore schema will
	// be updated to include any FHIR fields or resource types that have been added
	// since the last import and corresponding FHIR resources will be imported from
	// the FHIR store. Note this field cannot be used in conjunction with
	// `resource_types`. It should be used after initial import.
	UpdateFromLatestPredefinedSchema bool `json:"updateFromLatestPredefinedSchema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FhirStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FhirStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1FhirStoreSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1FhirStoreSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1FirestoreSource: Firestore source import data
// from.
type GoogleCloudDiscoveryengineV1FirestoreSource struct {
	// CollectionId: Required. The Firestore collection (or entity) to copy the
	// data from with a length limit of 1,500 characters.
	CollectionId string `json:"collectionId,omitempty"`
	// DatabaseId: Required. The Firestore database to copy the data from with a
	// length limit of 256 characters.
	DatabaseId string `json:"databaseId,omitempty"`
	// GcsStagingDir: Intermediate Cloud Storage directory used for the import with
	// a length limit of 2,000 characters. Can be specified if one wants to have
	// the Firestore export to a specific Cloud Storage directory. Ensure that the
	// Firestore service account has the necessary Cloud Storage Admin permissions
	// to access the specified Cloud Storage directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`
	// ProjectId: The project ID that the Cloud SQL source is in with a length
	// limit of 128 characters. If not specified, inherits the project ID from the
	// parent request.
	ProjectId string `json:"projectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CollectionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CollectionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1FirestoreSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1FirestoreSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1GcsSource: Cloud Storage location for input
// content.
type GoogleCloudDiscoveryengineV1GcsSource struct {
	// DataSchema: The schema to use when parsing the data from the source.
	// Supported values for document imports: * `document` (default): One JSON
	// Document per line. Each document must have a valid Document.id. * `content`:
	// Unstructured data (e.g. PDF, HTML). Each file matched by `input_uris`
	// becomes a document, with the ID set to the first 128 bits of SHA256(URI)
	// encoded as a hex string. * `custom`: One custom data JSON per row in
	// arbitrary format that conforms to the defined Schema of the data store. This
	// can only be used by the GENERIC Data Store vertical. * `csv`: A CSV file
	// with header conforming to the defined Schema of the data store. Each entry
	// after the header is imported as a Document. This can only be used by the
	// GENERIC Data Store vertical. Supported values for user event imports: *
	// `user_event` (default): One JSON UserEvent per line.
	DataSchema string `json:"dataSchema,omitempty"`
	// InputUris: Required. Cloud Storage URIs to input files. Each URI can be up
	// to 2000 characters long. URIs can match the full object path (for example,
	// `gs://bucket/directory/object.json`) or a pattern matching one or more
	// files, such as `gs://bucket/directory/*.json`. A request can contain at most
	// 100 files (or 100,000 files if `data_schema` is `content`). Each file can be
	// up to 2 GB (or 100 MB if `data_schema` is `content`).
	InputUris []string `json:"inputUris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1GcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1GroundingFact: Grounding Fact.
type GoogleCloudDiscoveryengineV1GroundingFact struct {
	// Attributes: Attributes associated with the fact. Common attributes include
	// `source` (indicating where the fact was sourced from), `author` (indicating
	// the author of the fact), and so on.
	Attributes map[string]string `json:"attributes,omitempty"`
	// FactText: Text content of the fact. Can be at most 10K characters long.
	FactText string `json:"factText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1GroundingFact) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1GroundingFact
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1HealthcareFhirConfig: Config to data store for
// `HEALTHCARE_FHIR` vertical.
type GoogleCloudDiscoveryengineV1HealthcareFhirConfig struct {
	// EnableConfigurableSchema: Whether to enable configurable schema for
	// `HEALTHCARE_FHIR` vertical. If set to `true`, the predefined healthcare fhir
	// schema can be extended for more customized searching and filtering.
	EnableConfigurableSchema bool `json:"enableConfigurableSchema,omitempty"`
	// EnableStaticIndexingForBatchIngestion: Whether to enable static indexing for
	// `HEALTHCARE_FHIR` batch ingestion. If set to `true`, the batch ingestion
	// will be processed in a static indexing mode which is slower but more capable
	// of handling larger volume.
	EnableStaticIndexingForBatchIngestion bool `json:"enableStaticIndexingForBatchIngestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableConfigurableSchema")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableConfigurableSchema") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1HealthcareFhirConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1HealthcareFhirConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1IdentityMappingEntry: Identity Mapping Entry
// that maps an external identity to an internal identity.
type GoogleCloudDiscoveryengineV1IdentityMappingEntry struct {
	// ExternalIdentity: Required. Identity outside the customer identity provider.
	// The length limit of external identity will be of 100 characters.
	ExternalIdentity string `json:"externalIdentity,omitempty"`
	// GroupId: Group identifier. For Google Workspace user account, group_id
	// should be the google workspace group email. For non-google identity
	// provider, group_id is the mapped group identifier configured during the
	// workforcepool config.
	GroupId string `json:"groupId,omitempty"`
	// UserId: User identifier. For Google Workspace user account, user_id should
	// be the google workspace user email. For non-google identity provider,
	// user_id is the mapped user identifier configured during the workforcepool
	// config.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExternalIdentity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExternalIdentity") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1IdentityMappingEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1IdentityMappingEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1IdentityMappingEntryOperationMetadata:
// IdentityMappingEntry LongRunningOperation metadata for
// IdentityMappingStoreService.ImportIdentityMappings and
// IdentityMappingStoreService.PurgeIdentityMappings
type GoogleCloudDiscoveryengineV1IdentityMappingEntryOperationMetadata struct {
	// FailureCount: The number of IdentityMappingEntries that failed to be
	// processed.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: The number of IdentityMappingEntries that were successfully
	// processed.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// TotalCount: The total number of IdentityMappingEntries that were processed.
	TotalCount int64 `json:"totalCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "FailureCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailureCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1IdentityMappingEntryOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1IdentityMappingEntryOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1IdentityMappingStore: Identity Mapping Store
// which contains Identity Mapping Entries.
type GoogleCloudDiscoveryengineV1IdentityMappingStore struct {
	// CmekConfig: Output only. CMEK-related information for the Identity Mapping
	// Store.
	CmekConfig *GoogleCloudDiscoveryengineV1CmekConfig `json:"cmekConfig,omitempty"`
	// KmsKeyName: Input only. The KMS key to be used to protect this Identity
	// Mapping Store at creation time. Must be set for requests that need to comply
	// with CMEK Org Policy protections. If this field is set and processed
	// successfully, the Identity Mapping Store will be protected by the KMS key,
	// as indicated in the cmek_config field.
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// Name: Immutable. The full resource name of the identity mapping store.
	// Format:
	// `projects/{project}/locations/{location}/identityMappingStores/{identity_mapp
	// ing_store}`. This field must be a UTF-8 encoded string with a length limit
	// of 1024 characters.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CmekConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CmekConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1IdentityMappingStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1IdentityMappingStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1IdentityScheduleConfig: The configuration for
// the identity data synchronization runs.
type GoogleCloudDiscoveryengineV1IdentityScheduleConfig struct {
	// NextSyncTime: Optional. The UTC time when the next data sync is expected to
	// start for the Data Connector. Customers are only able to specify the hour
	// and minute to schedule the data sync. This is utilized when the data
	// connector has a refresh interval greater than 1 day.
	NextSyncTime *GoogleTypeDateTime `json:"nextSyncTime,omitempty"`
	// RefreshInterval: Optional. The refresh interval to sync the Access Control
	// List information for the documents ingested by this connector. If not set,
	// the access control list will be refreshed at the default interval of 30
	// minutes. The identity refresh interval can be at least 30 minutes and at
	// most 7 days.
	RefreshInterval string `json:"refreshInterval,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NextSyncTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextSyncTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1IdentityScheduleConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1IdentityScheduleConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1IdpConfig: Identity Provider Config.
type GoogleCloudDiscoveryengineV1IdpConfig struct {
	// ExternalIdpConfig: External Identity provider config.
	ExternalIdpConfig *GoogleCloudDiscoveryengineV1IdpConfigExternalIdpConfig `json:"externalIdpConfig,omitempty"`
	// IdpType: Identity provider type configured.
	//
	// Possible values:
	//   "IDP_TYPE_UNSPECIFIED" - Default value. ACL search not enabled.
	//   "GSUITE" - Google 1P provider.
	//   "THIRD_PARTY" - Third party provider.
	IdpType string `json:"idpType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExternalIdpConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExternalIdpConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1IdpConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1IdpConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1IdpConfigExternalIdpConfig: Third party IDP
// Config.
type GoogleCloudDiscoveryengineV1IdpConfigExternalIdpConfig struct {
	// WorkforcePoolName: Workforce pool name. Example:
	// "locations/global/workforcePools/pool_id"
	WorkforcePoolName string `json:"workforcePoolName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WorkforcePoolName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WorkforcePoolName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1IdpConfigExternalIdpConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1IdpConfigExternalIdpConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsMetadata: Metadata
// related to the progress of the ImportCompletionSuggestions operation. This
// will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of CompletionSuggestions that failed to be imported.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of CompletionSuggestions successfully imported.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequest: Request
// message for CompletionService.ImportCompletionSuggestions method.
type GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequest struct {
	// BigquerySource: BigQuery input source.
	BigquerySource *GoogleCloudDiscoveryengineV1BigQuerySource `json:"bigquerySource,omitempty"`
	// ErrorConfig: The desired location of errors incurred during the Import.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`
	// GcsSource: Cloud Storage location for the input content.
	GcsSource *GoogleCloudDiscoveryengineV1GcsSource `json:"gcsSource,omitempty"`
	// InlineSource: The Inline source for suggestion entries.
	InlineSource *GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequestInlineSource `json:"inlineSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigquerySource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigquerySource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequestInlineSource:
// The inline source for CompletionSuggestions.
type GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequestInlineSource struct {
	// Suggestions: Required. A list of all denylist entries to import. Max of 1000
	// items.
	Suggestions []*GoogleCloudDiscoveryengineV1CompletionSuggestion `json:"suggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Suggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Suggestions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequestInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsResponse: Response of
// the CompletionService.ImportCompletionSuggestions method. If the long
// running operation is done, this message is returned by the
// google.longrunning.Operations.response field if the operation is successful.
type GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsResponse struct {
	// ErrorConfig: The desired location of errors incurred during the Import.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportDocumentsMetadata: Metadata related to the
// progress of the ImportDocuments operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1ImportDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// TotalCount: Total count of entries that were processed.
	TotalCount int64 `json:"totalCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportDocumentsRequest: Request message for
// Import methods.
type GoogleCloudDiscoveryengineV1ImportDocumentsRequest struct {
	// AlloyDbSource: AlloyDB input source.
	AlloyDbSource *GoogleCloudDiscoveryengineV1AlloyDbSource `json:"alloyDbSource,omitempty"`
	// AutoGenerateIds: Whether to automatically generate IDs for the documents if
	// absent. If set to `true`, Document.ids are automatically generated based on
	// the hash of the payload, where IDs may not be consistent during multiple
	// imports. In which case ReconciliationMode.FULL is highly recommended to
	// avoid duplicate contents. If unset or set to `false`, Document.ids have to
	// be specified using id_field, otherwise, documents without IDs fail to be
	// imported. Supported data sources: * GcsSource. GcsSource.data_schema must be
	// `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown. *
	// BigQuerySource. BigQuerySource.data_schema must be `custom` or `csv`.
	// Otherwise, an INVALID_ARGUMENT error is thrown. * SpannerSource. *
	// CloudSqlSource. * FirestoreSource. * BigtableSource.
	AutoGenerateIds bool `json:"autoGenerateIds,omitempty"`
	// BigquerySource: BigQuery input source.
	BigquerySource *GoogleCloudDiscoveryengineV1BigQuerySource `json:"bigquerySource,omitempty"`
	// BigtableSource: Cloud Bigtable input source.
	BigtableSource *GoogleCloudDiscoveryengineV1BigtableSource `json:"bigtableSource,omitempty"`
	// CloudSqlSource: Cloud SQL input source.
	CloudSqlSource *GoogleCloudDiscoveryengineV1CloudSqlSource `json:"cloudSqlSource,omitempty"`
	// ErrorConfig: The desired location of errors incurred during the Import.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`
	// FhirStoreSource: FhirStore input source.
	FhirStoreSource *GoogleCloudDiscoveryengineV1FhirStoreSource `json:"fhirStoreSource,omitempty"`
	// FirestoreSource: Firestore input source.
	FirestoreSource *GoogleCloudDiscoveryengineV1FirestoreSource `json:"firestoreSource,omitempty"`
	// ForceRefreshContent: Optional. Whether to force refresh the unstructured
	// content of the documents. If set to `true`, the content part of the
	// documents will be refreshed regardless of the update status of the
	// referencing content.
	ForceRefreshContent bool `json:"forceRefreshContent,omitempty"`
	// GcsSource: Cloud Storage location for the input content.
	GcsSource *GoogleCloudDiscoveryengineV1GcsSource `json:"gcsSource,omitempty"`
	// IdField: The field indicates the ID field or column to be used as unique IDs
	// of the documents. For GcsSource it is the key of the JSON field. For
	// instance, `my_id` for JSON `{"my_id": "some_uuid"}`. For others, it may be
	// the column name of the table where the unique ids are stored. The values of
	// the JSON field or the table column are used as the Document.ids. The JSON
	// field or the table column must be of string type, and the values must be set
	// as valid strings conform to RFC-1034 (https://tools.ietf.org/html/rfc1034)
	// with 1-63 characters. Otherwise, documents without valid IDs fail to be
	// imported. Only set this field when auto_generate_ids is unset or set as
	// `false`. Otherwise, an INVALID_ARGUMENT error is thrown. If it is unset, a
	// default value `_id` is used when importing from the allowed data sources.
	// Supported data sources: * GcsSource. GcsSource.data_schema must be `custom`
	// or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown. * BigQuerySource.
	// BigQuerySource.data_schema must be `custom` or `csv`. Otherwise, an
	// INVALID_ARGUMENT error is thrown. * SpannerSource. * CloudSqlSource. *
	// BigtableSource.
	IdField string `json:"idField,omitempty"`
	// InlineSource: The Inline source for the input content for documents.
	InlineSource *GoogleCloudDiscoveryengineV1ImportDocumentsRequestInlineSource `json:"inlineSource,omitempty"`
	// ReconciliationMode: The mode of reconciliation between existing documents
	// and the documents to be imported. Defaults to
	// ReconciliationMode.INCREMENTAL.
	//
	// Possible values:
	//   "RECONCILIATION_MODE_UNSPECIFIED" - Defaults to `INCREMENTAL`.
	//   "INCREMENTAL" - Inserts new documents or updates existing documents.
	//   "FULL" - Calculates diff and replaces the entire document dataset.
	// Existing documents may be deleted if they are not present in the source
	// location. When using this mode, there won't be any downtime on the dataset
	// targeted. Any document that should remain unchanged or that should be
	// updated will continue serving while the operation is running.
	ReconciliationMode string `json:"reconciliationMode,omitempty"`
	// SpannerSource: Spanner input source.
	SpannerSource *GoogleCloudDiscoveryengineV1SpannerSource `json:"spannerSource,omitempty"`
	// UpdateMask: Indicates which fields in the provided imported documents to
	// update. If not set, the default is to update all fields.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlloyDbSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlloyDbSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportDocumentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportDocumentsRequestInlineSource: The inline
// source for the input config for ImportDocuments method.
type GoogleCloudDiscoveryengineV1ImportDocumentsRequestInlineSource struct {
	// Documents: Required. A list of documents to update/create. Each document
	// must have a valid Document.id. Recommended max of 100 items.
	Documents []*GoogleCloudDiscoveryengineV1Document `json:"documents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Documents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportDocumentsRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportDocumentsRequestInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportDocumentsResponse: Response of the
// ImportDocumentsRequest. If the long running operation is done, then this
// message is returned by the google.longrunning.Operations.response field if
// the operation was successful.
type GoogleCloudDiscoveryengineV1ImportDocumentsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors in the request
	// if set.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportErrorConfig: Configuration of destination
// for Import related errors.
type GoogleCloudDiscoveryengineV1ImportErrorConfig struct {
	// GcsPrefix: Cloud Storage prefix for import errors. This must be an empty,
	// existing Cloud Storage directory. Import errors are written to sharded files
	// in this directory, one per line, as a JSON-encoded `google.rpc.Status`
	// message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportErrorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportErrorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportIdentityMappingsRequest: Request message
// for IdentityMappingStoreService.ImportIdentityMappings
type GoogleCloudDiscoveryengineV1ImportIdentityMappingsRequest struct {
	// InlineSource: The inline source to import identity mapping entries from.
	InlineSource *GoogleCloudDiscoveryengineV1ImportIdentityMappingsRequestInlineSource `json:"inlineSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InlineSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InlineSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportIdentityMappingsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportIdentityMappingsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportIdentityMappingsRequestInlineSource: The
// inline source to import identity mapping entries from.
type GoogleCloudDiscoveryengineV1ImportIdentityMappingsRequestInlineSource struct {
	// IdentityMappingEntries: A maximum of 10000 entries can be imported at one
	// time
	IdentityMappingEntries []*GoogleCloudDiscoveryengineV1IdentityMappingEntry `json:"identityMappingEntries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IdentityMappingEntries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdentityMappingEntries") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportIdentityMappingsRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportIdentityMappingsRequestInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportIdentityMappingsResponse: Response message
// for IdentityMappingStoreService.ImportIdentityMappings
type GoogleCloudDiscoveryengineV1ImportIdentityMappingsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportIdentityMappingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportIdentityMappingsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesMetadata:
// Metadata related to the progress of the ImportSuggestionDenyListEntries
// operation. This is returned by the google.longrunning.Operation.metadata
// field.
type GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequest: Request
// message for CompletionService.ImportSuggestionDenyListEntries method.
type GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequest struct {
	// GcsSource: Cloud Storage location for the input content. Only 1 file can be
	// specified that contains all entries to import. Supported values
	// `gcs_source.schema` for autocomplete suggestion deny list entry imports: *
	// `suggestion_deny_list` (default): One JSON [SuggestionDenyListEntry] per
	// line.
	GcsSource *GoogleCloudDiscoveryengineV1GcsSource `json:"gcsSource,omitempty"`
	// InlineSource: The Inline source for the input content for suggestion deny
	// list entries.
	InlineSource *GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequestInlineSource `json:"inlineSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequestInlineSourc
// e: The inline source for SuggestionDenyListEntry.
type GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequestInlineSource struct {
	// Entries: Required. A list of all denylist entries to import. Max of 1000
	// items.
	Entries []*GoogleCloudDiscoveryengineV1SuggestionDenyListEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequestInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesResponse:
// Response message for CompletionService.ImportSuggestionDenyListEntries
// method.
type GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// FailedEntriesCount: Count of deny list entries that failed to be imported.
	FailedEntriesCount int64 `json:"failedEntriesCount,omitempty,string"`
	// ImportedEntriesCount: Count of deny list entries successfully imported.
	ImportedEntriesCount int64 `json:"importedEntriesCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportUserEventsMetadata: Metadata related to
// the progress of the Import operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1ImportUserEventsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportUserEventsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportUserEventsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportUserEventsRequest: Request message for the
// ImportUserEvents request.
type GoogleCloudDiscoveryengineV1ImportUserEventsRequest struct {
	// BigquerySource: BigQuery input source.
	BigquerySource *GoogleCloudDiscoveryengineV1BigQuerySource `json:"bigquerySource,omitempty"`
	// ErrorConfig: The desired location of errors incurred during the Import.
	// Cannot be set for inline user event imports.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`
	// GcsSource: Cloud Storage location for the input content.
	GcsSource *GoogleCloudDiscoveryengineV1GcsSource `json:"gcsSource,omitempty"`
	// InlineSource: The Inline source for the input content for UserEvents.
	InlineSource *GoogleCloudDiscoveryengineV1ImportUserEventsRequestInlineSource `json:"inlineSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigquerySource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigquerySource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportUserEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportUserEventsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportUserEventsRequestInlineSource: The inline
// source for the input config for ImportUserEvents method.
type GoogleCloudDiscoveryengineV1ImportUserEventsRequestInlineSource struct {
	// UserEvents: Required. A list of user events to import. Recommended max of
	// 10k items.
	UserEvents []*GoogleCloudDiscoveryengineV1UserEvent `json:"userEvents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UserEvents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserEvents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportUserEventsRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportUserEventsRequestInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportUserEventsResponse: Response of the
// ImportUserEventsRequest. If the long running operation was successful, then
// this message is returned by the google.longrunning.Operations.response field
// if the operation was successful.
type GoogleCloudDiscoveryengineV1ImportUserEventsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors if this field
	// was set in the request.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// JoinedEventsCount: Count of user events imported with complete existing
	// Documents.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`
	// UnjoinedEventsCount: Count of user events imported, but with Document
	// information not found in the existing Branch.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Interval: A floating point interval.
type GoogleCloudDiscoveryengineV1Interval struct {
	// ExclusiveMaximum: Exclusive upper bound.
	ExclusiveMaximum float64 `json:"exclusiveMaximum,omitempty"`
	// ExclusiveMinimum: Exclusive lower bound.
	ExclusiveMinimum float64 `json:"exclusiveMinimum,omitempty"`
	// Maximum: Inclusive upper bound.
	Maximum float64 `json:"maximum,omitempty"`
	// Minimum: Inclusive lower bound.
	Minimum float64 `json:"minimum,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExclusiveMaximum") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExclusiveMaximum") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Interval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Interval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1Interval) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1Interval
	var s1 struct {
		ExclusiveMaximum gensupport.JSONFloat64 `json:"exclusiveMaximum"`
		ExclusiveMinimum gensupport.JSONFloat64 `json:"exclusiveMinimum"`
		Maximum          gensupport.JSONFloat64 `json:"maximum"`
		Minimum          gensupport.JSONFloat64 `json:"minimum"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ExclusiveMaximum = float64(s1.ExclusiveMaximum)
	s.ExclusiveMinimum = float64(s1.ExclusiveMinimum)
	s.Maximum = float64(s1.Maximum)
	s.Minimum = float64(s1.Minimum)
	return nil
}

// GoogleCloudDiscoveryengineV1LicenseConfig: Information about users'
// licenses.
type GoogleCloudDiscoveryengineV1LicenseConfig struct {
	// AutoRenew: Optional. Whether the license config should be auto renewed when
	// it reaches the end date.
	AutoRenew bool `json:"autoRenew,omitempty"`
	// EndDate: Optional. The planed end date.
	EndDate *GoogleTypeDate `json:"endDate,omitempty"`
	// FreeTrial: Optional. Whether the license config is for free trial.
	FreeTrial bool `json:"freeTrial,omitempty"`
	// GeminiBundle: Output only. Whether the license config is for Gemini bundle.
	GeminiBundle bool `json:"geminiBundle,omitempty"`
	// LicenseCount: Required. Number of licenses purchased.
	LicenseCount int64 `json:"licenseCount,omitempty,string"`
	// Name: Immutable. Identifier. The fully qualified resource name of the
	// license config. Format:
	// `projects/{project}/locations/{location}/licenseConfigs/{license_config}`
	Name string `json:"name,omitempty"`
	// StartDate: Required. The start date.
	StartDate *GoogleTypeDate `json:"startDate,omitempty"`
	// State: Output only. The state of the license config.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value. The license config does not exist.
	//   "ACTIVE" - The license config is effective and being used.
	//   "EXPIRED" - The license config has expired.
	//   "NOT_STARTED" - The license config has not started yet, and its start date
	// is in the future.
	State string `json:"state,omitempty"`
	// SubscriptionTerm: Required. Subscription term.
	//
	// Possible values:
	//   "SUBSCRIPTION_TERM_UNSPECIFIED" - Default value, do not use.
	//   "SUBSCRIPTION_TERM_ONE_MONTH" - 1 month.
	//   "SUBSCRIPTION_TERM_ONE_YEAR" - 1 year.
	//   "SUBSCRIPTION_TERM_THREE_YEARS" - 3 years.
	SubscriptionTerm string `json:"subscriptionTerm,omitempty"`
	// SubscriptionTier: Required. Subscription tier information for the license
	// config.
	//
	// Possible values:
	//   "SUBSCRIPTION_TIER_UNSPECIFIED" - Default value.
	//   "SUBSCRIPTION_TIER_SEARCH" - Search tier. Search tier can access VAIS
	// search features and NotebookLM features.
	//   "SUBSCRIPTION_TIER_SEARCH_AND_ASSISTANT" - Search + assistant tier. Search
	// + assistant tier can access VAIS search features, NotebookLM features and
	// assistant features.
	//   "SUBSCRIPTION_TIER_NOTEBOOK_LM" - NotebookLM tier. NotebookLM is a
	// subscription tier can only access NotebookLM features.
	//   "SUBSCRIPTION_TIER_FRONTLINE_WORKER" - Frontline worker tier.
	//   "SUBSCRIPTION_TIER_AGENTSPACE_STARTER" - Agentspace Starter tier.
	//   "SUBSCRIPTION_TIER_AGENTSPACE_BUSINESS" - Agentspace Business tier.
	//   "SUBSCRIPTION_TIER_ENTERPRISE" - Enterprise tier.
	//   "SUBSCRIPTION_TIER_EDU" - EDU tier.
	//   "SUBSCRIPTION_TIER_EDU_PRO" - EDU Pro tier.
	//   "SUBSCRIPTION_TIER_EDU_EMERGING" - EDU emerging market tier.
	//   "SUBSCRIPTION_TIER_EDU_PRO_EMERGING" - EDU Pro emerging market tier.
	SubscriptionTier string `json:"subscriptionTier,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AutoRenew") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoRenew") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1LicenseConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1LicenseConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListCmekConfigsResponse: Response message for
// CmekConfigService.ListCmekConfigs method.
type GoogleCloudDiscoveryengineV1ListCmekConfigsResponse struct {
	// CmekConfigs: All the customer's CmekConfigs.
	CmekConfigs []*GoogleCloudDiscoveryengineV1CmekConfig `json:"cmekConfigs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CmekConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CmekConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListCmekConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListCmekConfigsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListControlsResponse: Response for ListControls
// method.
type GoogleCloudDiscoveryengineV1ListControlsResponse struct {
	// Controls: All the Controls for a given data store.
	Controls []*GoogleCloudDiscoveryengineV1Control `json:"controls,omitempty"`
	// NextPageToken: Pagination token, if not returned indicates the last page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Controls") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Controls") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListControlsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListControlsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListConversationsResponse: Response for
// ListConversations method.
type GoogleCloudDiscoveryengineV1ListConversationsResponse struct {
	// Conversations: All the Conversations for a given data store.
	Conversations []*GoogleCloudDiscoveryengineV1Conversation `json:"conversations,omitempty"`
	// NextPageToken: Pagination token, if not returned indicates the last page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Conversations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListConversationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListConversationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListCustomModelsResponse: Response message for
// SearchTuningService.ListCustomModels method.
type GoogleCloudDiscoveryengineV1ListCustomModelsResponse struct {
	// Models: List of custom tuning models.
	Models []*GoogleCloudDiscoveryengineV1CustomTuningModel `json:"models,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Models") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Models") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListCustomModelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListCustomModelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListDataStoresResponse: Response message for
// DataStoreService.ListDataStores method.
type GoogleCloudDiscoveryengineV1ListDataStoresResponse struct {
	// DataStores: All the customer's DataStores.
	DataStores []*GoogleCloudDiscoveryengineV1DataStore `json:"dataStores,omitempty"`
	// NextPageToken: A token that can be sent as ListDataStoresRequest.page_token
	// to retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DataStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListDataStoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListDataStoresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListDocumentsResponse: Response message for
// DocumentService.ListDocuments method.
type GoogleCloudDiscoveryengineV1ListDocumentsResponse struct {
	// Documents: The Documents.
	Documents []*GoogleCloudDiscoveryengineV1Document `json:"documents,omitempty"`
	// NextPageToken: A token that can be sent as ListDocumentsRequest.page_token
	// to retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Documents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListEnginesResponse: Response message for
// EngineService.ListEngines method.
type GoogleCloudDiscoveryengineV1ListEnginesResponse struct {
	// Engines: All the customer's Engines.
	Engines []*GoogleCloudDiscoveryengineV1Engine `json:"engines,omitempty"`
	// NextPageToken: Not supported.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Engines") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Engines") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListEnginesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListEnginesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListIdentityMappingStoresResponse: Response
// message for IdentityMappingStoreService.ListIdentityMappingStores
type GoogleCloudDiscoveryengineV1ListIdentityMappingStoresResponse struct {
	// IdentityMappingStores: The Identity Mapping Stores.
	IdentityMappingStores []*GoogleCloudDiscoveryengineV1IdentityMappingStore `json:"identityMappingStores,omitempty"`
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "IdentityMappingStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdentityMappingStores") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListIdentityMappingStoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListIdentityMappingStoresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListIdentityMappingsResponse: Response message
// for IdentityMappingStoreService.ListIdentityMappings
type GoogleCloudDiscoveryengineV1ListIdentityMappingsResponse struct {
	// IdentityMappingEntries: The Identity Mapping Entries.
	IdentityMappingEntries []*GoogleCloudDiscoveryengineV1IdentityMappingEntry `json:"identityMappingEntries,omitempty"`
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "IdentityMappingEntries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdentityMappingEntries") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListIdentityMappingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListIdentityMappingsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListSchemasResponse: Response message for
// SchemaService.ListSchemas method.
type GoogleCloudDiscoveryengineV1ListSchemasResponse struct {
	// NextPageToken: A token that can be sent as ListSchemasRequest.page_token to
	// retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Schemas: The Schemas.
	Schemas []*GoogleCloudDiscoveryengineV1Schema `json:"schemas,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListSchemasResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListSchemasResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListServingConfigsResponse: Response for
// ListServingConfigs method.
type GoogleCloudDiscoveryengineV1ListServingConfigsResponse struct {
	// NextPageToken: Pagination token, if not returned indicates the last page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ServingConfigs: All the ServingConfigs for a given dataStore.
	ServingConfigs []*GoogleCloudDiscoveryengineV1ServingConfig `json:"servingConfigs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListServingConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListServingConfigsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListSessionsResponse: Response for ListSessions
// method.
type GoogleCloudDiscoveryengineV1ListSessionsResponse struct {
	// NextPageToken: Pagination token, if not returned indicates the last page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Sessions: All the Sessions for a given data store.
	Sessions []*GoogleCloudDiscoveryengineV1Session `json:"sessions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListSessionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListSessionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListTargetSitesResponse: Response message for
// SiteSearchEngineService.ListTargetSites method.
type GoogleCloudDiscoveryengineV1ListTargetSitesResponse struct {
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TargetSites: List of TargetSites.
	TargetSites []*GoogleCloudDiscoveryengineV1TargetSite `json:"targetSites,omitempty"`
	// TotalSize: The total number of items matching the request. This will always
	// be populated in the response.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListTargetSitesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListTargetSitesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ListUserLicensesResponse: Response message for
// UserLicenseService.ListUserLicenses.
type GoogleCloudDiscoveryengineV1ListUserLicensesResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// UserLicenses: All the customer's UserLicenses.
	UserLicenses []*GoogleCloudDiscoveryengineV1UserLicense `json:"userLicenses,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ListUserLicensesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ListUserLicensesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1MediaInfo: Media-specific user event
// information.
type GoogleCloudDiscoveryengineV1MediaInfo struct {
	// MediaProgressDuration: The media progress time in seconds, if applicable.
	// For example, if the end user has finished 90 seconds of a playback video,
	// then MediaInfo.media_progress_duration.seconds should be set to 90.
	MediaProgressDuration string `json:"mediaProgressDuration,omitempty"`
	// MediaProgressPercentage: Media progress should be computed using only the
	// media_progress_duration relative to the media total length. This value must
	// be between `[0, 1.0]` inclusive. If this is not a playback or the progress
	// cannot be computed (e.g. ongoing livestream), this field should be unset.
	MediaProgressPercentage float64 `json:"mediaProgressPercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MediaProgressDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MediaProgressDuration") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1MediaInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1MediaInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1MediaInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1MediaInfo
	var s1 struct {
		MediaProgressPercentage gensupport.JSONFloat64 `json:"mediaProgressPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MediaProgressPercentage = float64(s1.MediaProgressPercentage)
	return nil
}

// GoogleCloudDiscoveryengineV1PageInfo: Detailed page information.
type GoogleCloudDiscoveryengineV1PageInfo struct {
	// PageCategory: The most specific category associated with a category page. To
	// represent full path of category, use '>' sign to separate different
	// hierarchies. If '>' is part of the category name, replace it with other
	// character(s). Category pages include special pages such as sales or
	// promotions. For instance, a special sale page may have the category
	// hierarchy: "pageCategory" : "Sales > 2017 Black Friday Deals". Required
	// for `view-category-page` events. Other event types should not set this
	// field. Otherwise, an `INVALID_ARGUMENT` error is returned.
	PageCategory string `json:"pageCategory,omitempty"`
	// PageviewId: A unique ID of a web page view. This should be kept the same for
	// all user events triggered from the same pageview. For example, an item
	// detail page view could trigger multiple events as the user is browsing the
	// page. The `pageview_id` property should be kept the same for all these
	// events so that they can be grouped together properly. When using the client
	// side event reporting with JavaScript pixel and Google Tag Manager, this
	// value is filled in automatically.
	PageviewId string `json:"pageviewId,omitempty"`
	// ReferrerUri: The referrer URL of the current page. When using the client
	// side event reporting with JavaScript pixel and Google Tag Manager, this
	// value is filled in automatically. However, some browser privacy restrictions
	// may cause this field to be empty.
	ReferrerUri string `json:"referrerUri,omitempty"`
	// Uri: Complete URL (window.location.href) of the user's current page. When
	// using the client side event reporting with JavaScript pixel and Google Tag
	// Manager, this value is filled in automatically. Maximum length 5,000
	// characters.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageCategory") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageCategory") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PanelInfo: Detailed panel information associated
// with a user event.
type GoogleCloudDiscoveryengineV1PanelInfo struct {
	// DisplayName: The display name of the panel.
	DisplayName string `json:"displayName,omitempty"`
	// Documents: Optional. The document IDs associated with this panel.
	Documents []*GoogleCloudDiscoveryengineV1DocumentInfo `json:"documents,omitempty"`
	// PanelId: Required. The panel ID.
	PanelId string `json:"panelId,omitempty"`
	// PanelPosition: The ordered position of the panel, if shown to the user with
	// other panels. If set, then total_panels must also be set.
	PanelPosition int64 `json:"panelPosition,omitempty"`
	// TotalPanels: The total number of panels, including this one, shown to the
	// user. Must be set if panel_position is set.
	TotalPanels int64 `json:"totalPanels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PanelInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PanelInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Principal: Principal identifier of a user or a
// group.
type GoogleCloudDiscoveryengineV1Principal struct {
	// ExternalEntityId: For 3P application identities which are not present in the
	// customer identity provider.
	ExternalEntityId string `json:"externalEntityId,omitempty"`
	// GroupId: Group identifier. For Google Workspace user account, group_id
	// should be the google workspace group email. For non-google identity provider
	// user account, group_id is the mapped group identifier configured during the
	// workforcepool config.
	GroupId string `json:"groupId,omitempty"`
	// UserId: User identifier. For Google Workspace user account, user_id should
	// be the google workspace user email. For non-google identity provider user
	// account, user_id is the mapped user identifier configured during the
	// workforcepool config.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExternalEntityId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExternalEntityId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Principal) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Principal
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Project: Metadata and configurations for a
// Google Cloud project in the service.
type GoogleCloudDiscoveryengineV1Project struct {
	// ConfigurableBillingStatus: Output only. The current status of the project's
	// configurable billing.
	ConfigurableBillingStatus *GoogleCloudDiscoveryengineV1ProjectConfigurableBillingStatus `json:"configurableBillingStatus,omitempty"`
	// CreateTime: Output only. The timestamp when this project is created.
	CreateTime string `json:"createTime,omitempty"`
	// CustomerProvidedConfig: Optional. Customer provided configurations.
	CustomerProvidedConfig *GoogleCloudDiscoveryengineV1ProjectCustomerProvidedConfig `json:"customerProvidedConfig,omitempty"`
	// Name: Output only. Full resource name of the project, for example
	// `projects/{project}`. Note that when making requests, project number and
	// project id are both acceptable, but the server will always respond in
	// project number.
	Name string `json:"name,omitempty"`
	// ProvisionCompletionTime: Output only. The timestamp when this project is
	// successfully provisioned. Empty value means this project is still
	// provisioning and is not ready for use.
	ProvisionCompletionTime string `json:"provisionCompletionTime,omitempty"`
	// ServiceTermsMap: Output only. A map of terms of services. The key is the
	// `id` of ServiceTerms.
	ServiceTermsMap map[string]GoogleCloudDiscoveryengineV1ProjectServiceTerms `json:"serviceTermsMap,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfigurableBillingStatus")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfigurableBillingStatus") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Project) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Project
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ProjectConfigurableBillingStatus: Represents the
// currently effective configurable billing parameters. These values are
// derived from the customer's subscription history stored internally and
// reflect the thresholds actively being used for billing purposes at the time
// of the GetProject call. This includes the start_time of the subscription and
// may differ from the values in `customer_provided_config` due to billing
// rules (e.g., scale-downs taking effect only at the start of a new month).
type GoogleCloudDiscoveryengineV1ProjectConfigurableBillingStatus struct {
	// EffectiveIndexingCoreThreshold: Optional. The currently effective Indexing
	// Core threshold. This is the threshold against which Indexing Core usage is
	// compared for overage calculations.
	EffectiveIndexingCoreThreshold int64 `json:"effectiveIndexingCoreThreshold,omitempty,string"`
	// EffectiveSearchQpmThreshold: Optional. The currently effective Search QPM
	// threshold in queries per minute. This is the threshold against which QPM
	// usage is compared for overage calculations.
	EffectiveSearchQpmThreshold int64 `json:"effectiveSearchQpmThreshold,omitempty,string"`
	// StartTime: Optional. The start time of the currently active billing
	// subscription.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "EffectiveIndexingCoreThreshold") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EffectiveIndexingCoreThreshold")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ProjectConfigurableBillingStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ProjectConfigurableBillingStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ProjectCustomerProvidedConfig: Customer provided
// configurations.
type GoogleCloudDiscoveryengineV1ProjectCustomerProvidedConfig struct {
	// NotebooklmConfig: Optional. Configuration for NotebookLM settings.
	NotebooklmConfig *GoogleCloudDiscoveryengineV1ProjectCustomerProvidedConfigNotebooklmConfig `json:"notebooklmConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NotebooklmConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NotebooklmConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ProjectCustomerProvidedConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ProjectCustomerProvidedConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ProjectCustomerProvidedConfigNotebooklmConfig:
// Configuration for NotebookLM.
type GoogleCloudDiscoveryengineV1ProjectCustomerProvidedConfigNotebooklmConfig struct {
	// ModelArmorConfig: Model Armor configuration to be used for sanitizing user
	// prompts and LLM responses.
	ModelArmorConfig *GoogleCloudDiscoveryengineV1ProjectCustomerProvidedConfigNotebooklmConfigModelArmorConfig `json:"modelArmorConfig,omitempty"`
	// OptOutNotebookSharing: Optional. Whether to disable the notebook sharing
	// feature for the project. Default to false if not specified.
	OptOutNotebookSharing bool `json:"optOutNotebookSharing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelArmorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelArmorConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ProjectCustomerProvidedConfigNotebooklmConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ProjectCustomerProvidedConfigNotebooklmConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ProjectCustomerProvidedConfigNotebooklmConfigMode
// lArmorConfig: Configuration for customer defined Model Armor templates to be
// used for sanitizing user prompts and LLM responses.
type GoogleCloudDiscoveryengineV1ProjectCustomerProvidedConfigNotebooklmConfigModelArmorConfig struct {
	// ResponseTemplate: Optional. The resource name of the Model Armor Template
	// for sanitizing LLM responses. Format:
	// projects/{project}/locations/{location}/templates/{template_id} If not
	// specified, no sanitization will be applied to the LLM response.
	ResponseTemplate string `json:"responseTemplate,omitempty"`
	// UserPromptTemplate: Optional. The resource name of the Model Armor Template
	// for sanitizing user prompts. Format:
	// projects/{project}/locations/{location}/templates/{template_id} If not
	// specified, no sanitization will be applied to the user prompt.
	UserPromptTemplate string `json:"userPromptTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResponseTemplate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResponseTemplate") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ProjectCustomerProvidedConfigNotebooklmConfigModelArmorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ProjectCustomerProvidedConfigNotebooklmConfigModelArmorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ProjectServiceTerms: Metadata about the terms of
// service.
type GoogleCloudDiscoveryengineV1ProjectServiceTerms struct {
	// AcceptTime: The last time when the project agreed to the terms of service.
	AcceptTime string `json:"acceptTime,omitempty"`
	// DeclineTime: The last time when the project declined or revoked the
	// agreement to terms of service.
	DeclineTime string `json:"declineTime,omitempty"`
	// Id: The unique identifier of this terms of service. Available terms: *
	// `GA_DATA_USE_TERMS`: Terms for data use
	// (https://cloud.google.com/retail/data-use-terms). When using this as `id`,
	// the acceptable version to provide is `2022-11-23`.
	Id string `json:"id,omitempty"`
	// State: Whether the project has accepted/rejected the service terms or it is
	// still pending.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value of the enum. This value is not
	// actually used.
	//   "TERMS_ACCEPTED" - The project has given consent to the terms of service.
	//   "TERMS_PENDING" - The project is pending to review and accept the terms of
	// service.
	//   "TERMS_DECLINED" - The project has declined or revoked the agreement to
	// terms of service.
	State string `json:"state,omitempty"`
	// Version: The version string of the terms of service. For acceptable values,
	// see the comments for id above.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceptTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceptTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ProjectServiceTerms) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ProjectServiceTerms
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ProvisionProjectMetadata: Metadata associated
// with a project provision operation.
type GoogleCloudDiscoveryengineV1ProvisionProjectMetadata struct {
}

// GoogleCloudDiscoveryengineV1ProvisionProjectRequest: Request for
// ProjectService.ProvisionProject method.
type GoogleCloudDiscoveryengineV1ProvisionProjectRequest struct {
	// AcceptDataUseTerms: Required. Set to `true` to specify that caller has read
	// and would like to give consent to the Terms for data use
	// (https://cloud.google.com/retail/data-use-terms).
	AcceptDataUseTerms bool `json:"acceptDataUseTerms,omitempty"`
	// DataUseTermsVersion: Required. The version of the Terms for data use
	// (https://cloud.google.com/retail/data-use-terms) that caller has read and
	// would like to give consent to. Acceptable version is `2022-11-23`, and this
	// may change over time.
	DataUseTermsVersion string `json:"dataUseTermsVersion,omitempty"`
	// SaasParams: Optional. Parameters for Agentspace.
	SaasParams *GoogleCloudDiscoveryengineV1ProvisionProjectRequestSaasParams `json:"saasParams,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceptDataUseTerms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceptDataUseTerms") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ProvisionProjectRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ProvisionProjectRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ProvisionProjectRequestSaasParams: Parameters
// for Agentspace.
type GoogleCloudDiscoveryengineV1ProvisionProjectRequestSaasParams struct {
	// AcceptBizQos: Optional. Set to `true` to specify that caller has read and
	// would like to give consent to the [Terms for Agent Space quality of
	// service].
	AcceptBizQos bool `json:"acceptBizQos,omitempty"`
	// IsBiz: Optional. Indicates if the current request is for Biz edition (=
	// true) or not (= false).
	IsBiz bool `json:"isBiz,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceptBizQos") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceptBizQos") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ProvisionProjectRequestSaasParams) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ProvisionProjectRequestSaasParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsMetadata: Metadata
// related to the progress of the PurgeCompletionSuggestions operation. This is
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsRequest: Request
// message for CompletionService.PurgeCompletionSuggestions method.
type GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsRequest struct {
}

// GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsResponse: Response
// message for CompletionService.PurgeCompletionSuggestions method.
type GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// PurgeSucceeded: Whether the completion suggestions were successfully purged.
	PurgeSucceeded bool `json:"purgeSucceeded,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata: Metadata related to the
// progress of the PurgeDocuments operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// IgnoredCount: Count of entries that were ignored as entries were not found.
	IgnoredCount int64 `json:"ignoredCount,omitempty,string"`
	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeDocumentsRequest: Request message for
// DocumentService.PurgeDocuments method.
type GoogleCloudDiscoveryengineV1PurgeDocumentsRequest struct {
	// ErrorConfig: The desired location of errors incurred during the purge.
	ErrorConfig *GoogleCloudDiscoveryengineV1PurgeErrorConfig `json:"errorConfig,omitempty"`
	// Filter: Required. Filter matching documents to purge. Only currently
	// supported value is `*` (all items).
	Filter string `json:"filter,omitempty"`
	// Force: Actually performs the purge. If `force` is set to false, return the
	// expected purge count without deleting any documents.
	Force bool `json:"force,omitempty"`
	// GcsSource: Cloud Storage location for the input content. Supported
	// `data_schema`: * `document_id`: One valid Document.id per line.
	GcsSource *GoogleCloudDiscoveryengineV1GcsSource `json:"gcsSource,omitempty"`
	// InlineSource: Inline source for the input content for purge.
	InlineSource *GoogleCloudDiscoveryengineV1PurgeDocumentsRequestInlineSource `json:"inlineSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeDocumentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeDocumentsRequestInlineSource: The inline
// source for the input config for DocumentService.PurgeDocuments method.
type GoogleCloudDiscoveryengineV1PurgeDocumentsRequestInlineSource struct {
	// Documents: Required. A list of full resource name of documents to purge. In
	// the format
	// `projects/*/locations/*/collections/*/dataStores/*/branches/*/documents/*`.
	// Recommended max of 100 items.
	Documents []string `json:"documents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Documents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeDocumentsRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeDocumentsRequestInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeDocumentsResponse: Response message for
// DocumentService.PurgeDocuments method. If the long running operation is
// successfully done, then this message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1PurgeDocumentsResponse struct {
	// PurgeCount: The total count of documents purged as a result of the
	// operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`
	// PurgeSample: A sample of document names that will be deleted. Only populated
	// if `force` is set to false. A max of 100 names will be returned and the
	// names are chosen at random.
	PurgeSample []string `json:"purgeSample,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PurgeCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeErrorConfig: Configuration of destination
// for Purge related errors.
type GoogleCloudDiscoveryengineV1PurgeErrorConfig struct {
	// GcsPrefix: Cloud Storage prefix for purge errors. This must be an empty,
	// existing Cloud Storage directory. Purge errors are written to sharded files
	// in this directory, one per line, as a JSON-encoded `google.rpc.Status`
	// message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeErrorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeErrorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeIdentityMappingsRequest: Request message
// for IdentityMappingStoreService.PurgeIdentityMappings
type GoogleCloudDiscoveryengineV1PurgeIdentityMappingsRequest struct {
	// Filter: Filter matching identity mappings to purge. The eligible field for
	// filtering is: * `update_time`: in ISO 8601 "zulu" format. * `external_id`
	// Examples: * Deleting all identity mappings updated in a time range:
	// `update_time > "2012-04-23T18:25:43.511Z" AND update_time <
	// "2012-04-23T18:30:43.511Z" * Deleting all identity mappings for a given
	// external_id: `external_id = "id1" * Deleting all identity mappings inside
	// an identity mapping store: `*` The filtering fields are assumed to have an
	// implicit AND. Should not be used with source. An error will be thrown, if
	// both are provided.
	Filter string `json:"filter,omitempty"`
	// Force: Actually performs the purge. If `force` is set to false, return the
	// expected purge count without deleting any identity mappings. This field is
	// only supported for purge with filter. For input source this field is ignored
	// and data will be purged regardless of the value of this field.
	Force bool `json:"force,omitempty"`
	// InlineSource: The inline source to purge identity mapping entries from.
	InlineSource *GoogleCloudDiscoveryengineV1PurgeIdentityMappingsRequestInlineSource `json:"inlineSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeIdentityMappingsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeIdentityMappingsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeIdentityMappingsRequestInlineSource: The
// inline source to purge identity mapping entries from.
type GoogleCloudDiscoveryengineV1PurgeIdentityMappingsRequestInlineSource struct {
	// IdentityMappingEntries: A maximum of 10000 entries can be purged at one time
	IdentityMappingEntries []*GoogleCloudDiscoveryengineV1IdentityMappingEntry `json:"identityMappingEntries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IdentityMappingEntries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdentityMappingEntries") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeIdentityMappingsRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeIdentityMappingsRequestInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesMetadata: Metadata
// related to the progress of the PurgeSuggestionDenyListEntries operation.
// This is returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesRequest: Request
// message for CompletionService.PurgeSuggestionDenyListEntries method.
type GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesRequest struct {
}

// GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesResponse: Response
// message for CompletionService.PurgeSuggestionDenyListEntries method.
type GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// PurgeCount: Number of suggestion deny list entries purged.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeUserEventsRequest: Request message for
// PurgeUserEvents method.
type GoogleCloudDiscoveryengineV1PurgeUserEventsRequest struct {
	// Filter: Required. The filter string to specify the events to be deleted with
	// a length limit of 5,000 characters. The eligible fields for filtering are: *
	// `eventType`: Double quoted UserEvent.event_type string. * `eventTime`: in
	// ISO 8601 "zulu" format. * `userPseudoId`: Double quoted string. Specifying
	// this will delete all events associated with a visitor. * `userId`: Double
	// quoted string. Specifying this will delete all events associated with a
	// user. Note: This API only supports purging a max range of 30 days. Examples:
	// * Deleting all events in a time range: `eventTime >
	// "2012-04-23T18:25:43.511Z" eventTime < "2012-04-23T18:30:43.511Z" *
	// Deleting specific eventType in a time range: `eventTime >
	// "2012-04-23T18:25:43.511Z" eventTime < "2012-04-23T18:30:43.511Z" eventType
	// = "search" * Deleting all events for a specific visitor in a time range:
	// `eventTime > "2012-04-23T18:25:43.511Z" eventTime <
	// "2012-04-23T18:30:43.511Z" userPseudoId = "visitor1024" * Deleting the past
	// 30 days of events inside a DataStore: `*` The filtering fields are assumed
	// to have an implicit AND.
	Filter string `json:"filter,omitempty"`
	// Force: The `force` field is currently not supported. Purge user event
	// requests will permanently delete all purgeable events. Once the development
	// is complete: If `force` is set to false, the method will return the expected
	// purge count without deleting any user events. This field will default to
	// false if not included in the request.
	Force bool `json:"force,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeUserEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeUserEventsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Query: Defines a user inputed query.
type GoogleCloudDiscoveryengineV1Query struct {
	// QueryId: Output only. Unique Id for the query.
	QueryId string `json:"queryId,omitempty"`
	// Text: Plain text.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Query) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Query
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1RankRequest: Request message for
// RankService.Rank method.
type GoogleCloudDiscoveryengineV1RankRequest struct {
	// IgnoreRecordDetailsInResponse: If true, the response will contain only
	// record ID and score. By default, it is false, the response will contain
	// record details.
	IgnoreRecordDetailsInResponse bool `json:"ignoreRecordDetailsInResponse,omitempty"`
	// Model: The identifier of the model to use. It is one of: *
	// `semantic-ranker-512@latest`: Semantic ranking model with maximum input
	// token size 512. It is set to `semantic-ranker-512@latest` by default if
	// unspecified.
	Model string `json:"model,omitempty"`
	// Query: The query to use.
	Query string `json:"query,omitempty"`
	// Records: Required. A list of records to rank.
	Records []*GoogleCloudDiscoveryengineV1RankingRecord `json:"records,omitempty"`
	// TopN: The number of results to return. If this is unset or no bigger than
	// zero, returns all results.
	TopN int64 `json:"topN,omitempty"`
	// UserLabels: The user labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Google Cloud Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "IgnoreRecordDetailsInResponse") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IgnoreRecordDetailsInResponse")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1RankRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1RankRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1RankResponse: Response message for
// RankService.Rank method.
type GoogleCloudDiscoveryengineV1RankResponse struct {
	// Records: A list of records sorted by descending score.
	Records []*GoogleCloudDiscoveryengineV1RankingRecord `json:"records,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Records") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Records") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1RankResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1RankResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1RankingRecord: Record message for
// RankService.Rank method.
type GoogleCloudDiscoveryengineV1RankingRecord struct {
	// Content: The content of the record. Empty by default. At least one of title
	// or content should be set otherwise an INVALID_ARGUMENT error is thrown.
	Content string `json:"content,omitempty"`
	// Id: The unique ID to represent the record.
	Id string `json:"id,omitempty"`
	// Score: The score of this record based on the given query and selected model.
	// The score will be rounded to 2 decimal places. If the score is close to 0,
	// it will be rounded to 0.0001 to avoid returning unset.
	Score float64 `json:"score,omitempty"`
	// Title: The title of the record. Empty by default. At least one of title or
	// content should be set otherwise an INVALID_ARGUMENT error is thrown.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1RankingRecord) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1RankingRecord
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1RankingRecord) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1RankingRecord
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDiscoveryengineV1RecommendRequest: Request message for Recommend
// method.
type GoogleCloudDiscoveryengineV1RecommendRequest struct {
	// Filter: Filter for restricting recommendation results with a length limit of
	// 5,000 characters. Currently, only filter expressions on the `filter_tags`
	// attribute is supported. Examples: * `(filter_tags: ANY("Red", "Blue") OR
	// filter_tags: ANY("Hot", "Cold"))` * `(filter_tags: ANY("Red", "Blue")) AND
	// NOT (filter_tags: ANY("Green"))` If `attributeFilteringSyntax` is set to
	// true under the `params` field, then attribute-based expressions are expected
	// instead of the above described tag-based syntax. Examples: * (language:
	// ANY("en", "es")) AND NOT (categories: ANY("Movie")) * (available: true) AND
	// (language: ANY("en", "es")) OR (categories: ANY("Movie")) If your filter
	// blocks all results, the API returns generic (unfiltered) popular Documents.
	// If you only want results strictly matching the filters, set
	// `strictFiltering` to `true` in RecommendRequest.params to receive empty
	// results instead. Note that the API never returns Documents with
	// `storageStatus` as `EXPIRED` or `DELETED` regardless of filter choices.
	Filter string `json:"filter,omitempty"`
	// PageSize: Maximum number of results to return. Set this property to the
	// number of recommendation results needed. If zero, the service chooses a
	// reasonable default. The maximum allowed value is 100. Values above 100 are
	// set to 100.
	PageSize int64 `json:"pageSize,omitempty"`
	// Params: Additional domain specific parameters for the recommendations.
	// Allowed values: * `returnDocument`: Boolean. If set to `true`, the
	// associated Document object is returned in
	// RecommendResponse.RecommendationResult.document. * `returnScore`: Boolean.
	// If set to true, the recommendation score corresponding to each returned
	// Document is set in RecommendResponse.RecommendationResult.metadata. The
	// given score indicates the probability of a Document conversion given the
	// user's context and history. * `strictFiltering`: Boolean. True by default.
	// If set to `false`, the service returns generic (unfiltered) popular
	// Documents instead of empty if your filter blocks all recommendation results.
	// * `diversityLevel`: String. Default empty. If set to be non-empty, then it
	// needs to be one of: * `no-diversity` * `low-diversity` * `medium-diversity`
	// * `high-diversity` * `auto-diversity` This gives request-level control and
	// adjusts recommendation results based on Document category. *
	// `attributeFilteringSyntax`: Boolean. False by default. If set to true, the
	// `filter` field is interpreted according to the new, attribute-based syntax.
	Params googleapi.RawMessage `json:"params,omitempty"`
	// UserEvent: Required. Context about the user, what they are looking at and
	// what action they took to trigger the Recommend request. Note that this user
	// event detail won't be ingested to userEvent logs. Thus, a separate userEvent
	// write request is required for event logging. Don't set
	// UserEvent.user_pseudo_id or UserEvent.user_info.user_id to the same fixed ID
	// for different users. If you are trying to receive non-personalized
	// recommendations (not recommended; this can negatively impact model
	// performance), instead set UserEvent.user_pseudo_id to a random unique ID and
	// leave UserEvent.user_info.user_id unset.
	UserEvent *GoogleCloudDiscoveryengineV1UserEvent `json:"userEvent,omitempty"`
	// UserLabels: The user labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Requirements for labels
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// ValidateOnly: Use validate only mode for this recommendation query. If set
	// to `true`, a fake model is used that returns arbitrary Document IDs. Note
	// that the validate only mode should only be used for testing the API, or if
	// the model is not ready.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1RecommendRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1RecommendRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1RecommendResponse: Response message for
// Recommend method.
type GoogleCloudDiscoveryengineV1RecommendResponse struct {
	// AttributionToken: A unique attribution token. This should be included in the
	// UserEvent logs resulting from this recommendation, which enables accurate
	// attribution of recommendation model performance.
	AttributionToken string `json:"attributionToken,omitempty"`
	// MissingIds: IDs of documents in the request that were missing from the
	// default Branch associated with the requested ServingConfig.
	MissingIds []string `json:"missingIds,omitempty"`
	// Results: A list of recommended Documents. The order represents the ranking
	// (from the most relevant Document to the least).
	Results []*GoogleCloudDiscoveryengineV1RecommendResponseRecommendationResult `json:"results,omitempty"`
	// ValidateOnly: True if RecommendRequest.validate_only was set.
	ValidateOnly bool `json:"validateOnly,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AttributionToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributionToken") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1RecommendResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1RecommendResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1RecommendResponseRecommendationResult:
// RecommendationResult represents a generic recommendation result with
// associated metadata.
type GoogleCloudDiscoveryengineV1RecommendResponseRecommendationResult struct {
	// Document: Set if `returnDocument` is set to true in RecommendRequest.params.
	Document *GoogleCloudDiscoveryengineV1Document `json:"document,omitempty"`
	// Id: Resource ID of the recommended Document.
	Id string `json:"id,omitempty"`
	// Metadata: Additional Document metadata or annotations. Possible values: *
	// `score`: Recommendation score in double value. Is set if `returnScore` is
	// set to true in RecommendRequest.params.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1RecommendResponseRecommendationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1RecommendResponseRecommendationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1RecrawlUrisRequest: Request message for
// SiteSearchEngineService.RecrawlUris method.
type GoogleCloudDiscoveryengineV1RecrawlUrisRequest struct {
	// SiteCredential: Optional. Credential id to use for crawling.
	SiteCredential string `json:"siteCredential,omitempty"`
	// Uris: Required. List of URIs to crawl. At most 10K URIs are supported,
	// otherwise an INVALID_ARGUMENT error is thrown. Each URI should match at
	// least one TargetSite in `site_search_engine`.
	Uris []string `json:"uris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SiteCredential") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SiteCredential") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1RecrawlUrisRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1RecrawlUrisRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Reply: Defines a reply message to user.
type GoogleCloudDiscoveryengineV1Reply struct {
	// Summary: Summary based on search results.
	Summary *GoogleCloudDiscoveryengineV1SearchResponseSummary `json:"summary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Summary") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Summary") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Reply) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Reply
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SafetyRating: Safety rating corresponding to the
// generated content.
type GoogleCloudDiscoveryengineV1SafetyRating struct {
	// Blocked: Output only. Indicates whether the content was filtered out because
	// of this rating.
	Blocked bool `json:"blocked,omitempty"`
	// Category: Output only. Harm category.
	//
	// Possible values:
	//   "HARM_CATEGORY_UNSPECIFIED" - The harm category is unspecified.
	//   "HARM_CATEGORY_HATE_SPEECH" - The harm category is hate speech.
	//   "HARM_CATEGORY_DANGEROUS_CONTENT" - The harm category is dangerous
	// content.
	//   "HARM_CATEGORY_HARASSMENT" - The harm category is harassment.
	//   "HARM_CATEGORY_SEXUALLY_EXPLICIT" - The harm category is sexually explicit
	// content.
	//   "HARM_CATEGORY_CIVIC_INTEGRITY" - The harm category is civic integrity.
	Category string `json:"category,omitempty"`
	// Probability: Output only. Harm probability levels in the content.
	//
	// Possible values:
	//   "HARM_PROBABILITY_UNSPECIFIED" - Harm probability unspecified.
	//   "NEGLIGIBLE" - Negligible level of harm.
	//   "LOW" - Low level of harm.
	//   "MEDIUM" - Medium level of harm.
	//   "HIGH" - High level of harm.
	Probability string `json:"probability,omitempty"`
	// ProbabilityScore: Output only. Harm probability score.
	ProbabilityScore float64 `json:"probabilityScore,omitempty"`
	// Severity: Output only. Harm severity levels in the content.
	//
	// Possible values:
	//   "HARM_SEVERITY_UNSPECIFIED" - Harm severity unspecified.
	//   "HARM_SEVERITY_NEGLIGIBLE" - Negligible level of harm severity.
	//   "HARM_SEVERITY_LOW" - Low level of harm severity.
	//   "HARM_SEVERITY_MEDIUM" - Medium level of harm severity.
	//   "HARM_SEVERITY_HIGH" - High level of harm severity.
	Severity string `json:"severity,omitempty"`
	// SeverityScore: Output only. Harm severity score.
	SeverityScore float64 `json:"severityScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blocked") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blocked") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SafetyRating) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SafetyRating
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1SafetyRating) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1SafetyRating
	var s1 struct {
		ProbabilityScore gensupport.JSONFloat64 `json:"probabilityScore"`
		SeverityScore    gensupport.JSONFloat64 `json:"severityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ProbabilityScore = float64(s1.ProbabilityScore)
	s.SeverityScore = float64(s1.SeverityScore)
	return nil
}

// GoogleCloudDiscoveryengineV1Schema: Defines the structure and layout of a
// type of document data.
type GoogleCloudDiscoveryengineV1Schema struct {
	// JsonSchema: The JSON representation of the schema.
	JsonSchema string `json:"jsonSchema,omitempty"`
	// Name: Immutable. The full resource name of the schema, in the format of
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/schemas/{schema}`. This field must be a UTF-8 encoded string
	// with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// StructSchema: The structured representation of the schema.
	StructSchema googleapi.RawMessage `json:"structSchema,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "JsonSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JsonSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Schema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Schema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchInfo: Detailed search information.
type GoogleCloudDiscoveryengineV1SearchInfo struct {
	// Offset: An integer that specifies the current offset for pagination (the
	// 0-indexed starting location, amongst the products deemed by the API as
	// relevant). See SearchRequest.offset for definition. If this field is
	// negative, an `INVALID_ARGUMENT` is returned. This can only be set for
	// `search` events. Other event types should not set this field. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	Offset int64 `json:"offset,omitempty"`
	// OrderBy: The order in which products are returned, if applicable. See
	// SearchRequest.order_by for definition and syntax. The value must be a UTF-8
	// encoded string with a length limit of 1,000 characters. Otherwise, an
	// `INVALID_ARGUMENT` error is returned. This can only be set for `search`
	// events. Other event types should not set this field. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	OrderBy string `json:"orderBy,omitempty"`
	// SearchQuery: The user's search query. See SearchRequest.query for
	// definition. The value must be a UTF-8 encoded string with a length limit of
	// 5,000 characters. Otherwise, an `INVALID_ARGUMENT` error is returned. At
	// least one of search_query or PageInfo.page_category is required for `search`
	// events. Other event types should not set this field. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	SearchQuery string `json:"searchQuery,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Offset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Offset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchLinkPromotion: Promotion proto includes
// uri and other helping information to display the promotion.
type GoogleCloudDiscoveryengineV1SearchLinkPromotion struct {
	// Description: Optional. The Promotion description. Maximum length: 200
	// characters.
	Description string `json:"description,omitempty"`
	// Document: Optional. The Document the user wants to promote. For site search,
	// leave unset and only populate uri. Can be set along with uri.
	Document string `json:"document,omitempty"`
	// Enabled: Optional. The enabled promotion will be returned for any serving
	// configs associated with the parent of the control this promotion is attached
	// to. This flag is used for basic site search only.
	Enabled bool `json:"enabled,omitempty"`
	// ImageUri: Optional. The promotion thumbnail image url.
	ImageUri string `json:"imageUri,omitempty"`
	// Title: Required. The title of the promotion. Maximum length: 160 characters.
	Title string `json:"title,omitempty"`
	// Uri: Optional. The URL for the page the user wants to promote. Must be set
	// for site search. For other verticals, this is optional.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchLinkPromotion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchLinkPromotion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequest: Request message for
// SearchService.Search method.
type GoogleCloudDiscoveryengineV1SearchRequest struct {
	// BoostSpec: Boost specification to boost certain documents. For more
	// information on boosting, see Boosting
	// (https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
	BoostSpec *GoogleCloudDiscoveryengineV1SearchRequestBoostSpec `json:"boostSpec,omitempty"`
	// Branch: The branch resource name, such as
	// `projects/*/locations/global/collections/default_collection/dataStores/defaul
	// t_data_store/branches/0`. Use `default_branch` as the branch ID or leave
	// this field empty, to search documents under the default branch.
	Branch string `json:"branch,omitempty"`
	// CanonicalFilter: The default filter that is applied when a user performs a
	// search without checking any filters on the search page. The filter applied
	// to every search request when quality improvement such as query expansion is
	// needed. In the case a query does not have a sufficient amount of results
	// this filter will be used to determine whether or not to enable the query
	// expansion flow. The original filter will still be used for the query
	// expanded search. This field is strongly recommended to achieve high search
	// quality. For more information about filter syntax, see SearchRequest.filter.
	CanonicalFilter string `json:"canonicalFilter,omitempty"`
	// ContentSearchSpec: A specification for configuring the behavior of content
	// search.
	ContentSearchSpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpec `json:"contentSearchSpec,omitempty"`
	// DataStoreSpecs: Specifications that define the specific DataStores to be
	// searched, along with configurations for those data stores. This is only
	// considered for Engines with multiple data stores. For engines with a single
	// data store, the specs directly under SearchRequest should be used.
	DataStoreSpecs []*GoogleCloudDiscoveryengineV1SearchRequestDataStoreSpec `json:"dataStoreSpecs,omitempty"`
	// DisplaySpec: Optional. Config for display feature, like match highlighting
	// on search results.
	DisplaySpec *GoogleCloudDiscoveryengineV1SearchRequestDisplaySpec `json:"displaySpec,omitempty"`
	// FacetSpecs: Facet specifications for faceted search. If empty, no facets are
	// returned. A maximum of 100 values are allowed. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	FacetSpecs []*GoogleCloudDiscoveryengineV1SearchRequestFacetSpec `json:"facetSpecs,omitempty"`
	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the documents being
	// filtered. Filter expression is case-sensitive. If this field is
	// unrecognizable, an `INVALID_ARGUMENT` is returned. Filtering in Vertex AI
	// Search is done by mapping the LHS filter key to a key property defined in
	// the Vertex AI Search backend -- this mapping is defined by the customer in
	// their schema. For example a media customer might have a field 'name' in
	// their schema. In this case the filter would look like this: filter -->
	// name:'ANY("king kong")' For more information about filtering including
	// syntax and filter operators, see Filter
	// (https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
	Filter string `json:"filter,omitempty"`
	// ImageQuery: Raw image query.
	ImageQuery *GoogleCloudDiscoveryengineV1SearchRequestImageQuery `json:"imageQuery,omitempty"`
	// LanguageCode: The BCP-47 language code, such as "en-US" or "sr-Latn". For
	// more information, see Standard fields
	// (https://cloud.google.com/apis/design/standard_fields). This field helps to
	// better interpret the query. If a value isn't specified, the query language
	// code is automatically detected, which may not be accurate.
	LanguageCode string `json:"languageCode,omitempty"`
	// NaturalLanguageQueryUnderstandingSpec: Optional. Config for natural language
	// query understanding capabilities, such as extracting structured field
	// filters from the query. Refer to this documentation
	// (https://cloud.google.com/generative-ai-app-builder/docs/natural-language-queries)
	// for more information. If `naturalLanguageQueryUnderstandingSpec` is not
	// specified, no additional natural language query understanding will be done.
	NaturalLanguageQueryUnderstandingSpec *GoogleCloudDiscoveryengineV1SearchRequestNaturalLanguageQueryUnderstandingSpec `json:"naturalLanguageQueryUnderstandingSpec,omitempty"`
	// Offset: A 0-indexed integer that specifies the current offset (that is,
	// starting result location, amongst the Documents deemed by the API as
	// relevant) in search results. This field is only considered if page_token is
	// unset. If this field is negative, an `INVALID_ARGUMENT` is returned. A large
	// offset may be capped to a reasonable threshold.
	Offset int64 `json:"offset,omitempty"`
	// OneBoxPageSize: The maximum number of results to return for OneBox. This
	// applies to each OneBox type individually. Default number is 10.
	OneBoxPageSize int64 `json:"oneBoxPageSize,omitempty"`
	// OrderBy: The order in which documents are returned. Documents can be ordered
	// by a field in an Document object. Leave it unset if ordered by relevance.
	// `order_by` expression is case-sensitive. For more information on ordering
	// the website search results, see Order web search results
	// (https://cloud.google.com/generative-ai-app-builder/docs/order-web-search-results).
	// For more information on ordering the healthcare search results, see Order
	// healthcare search results
	// (https://cloud.google.com/generative-ai-app-builder/docs/order-hc-results).
	// If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
	OrderBy string `json:"orderBy,omitempty"`
	// PageSize: Maximum number of Documents to return. The maximum allowed value
	// depends on the data type. Values above the maximum value are coerced to the
	// maximum value. * Websites with basic indexing: Default `10`, Maximum `25`. *
	// Websites with advanced indexing: Default `25`, Maximum `50`. * Other:
	// Default `50`, Maximum `100`. If this field is negative, an
	// `INVALID_ARGUMENT` is returned.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: A page token received from a previous SearchService.Search call.
	// Provide this to retrieve the subsequent page. When paginating, all other
	// parameters provided to SearchService.Search must match the call that
	// provided the page token. Otherwise, an `INVALID_ARGUMENT` error is returned.
	PageToken string `json:"pageToken,omitempty"`
	// Params: Additional search parameters. For public website search only,
	// supported values are: * `user_country_code`: string. Default empty. If set
	// to non-empty, results are restricted or boosted based on the location
	// provided. For example, `user_country_code: "au" For available codes see
	// Country Codes
	// (https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
	// * `search_type`: double. Default empty. Enables non-webpage searching
	// depending on the value. The only valid non-default value is 1, which enables
	// image searching. For example, `search_type: 1`
	Params googleapi.RawMessage `json:"params,omitempty"`
	// Query: Raw search query.
	Query string `json:"query,omitempty"`
	// QueryExpansionSpec: The query expansion specification that specifies the
	// conditions under which query expansion occurs.
	QueryExpansionSpec *GoogleCloudDiscoveryengineV1SearchRequestQueryExpansionSpec `json:"queryExpansionSpec,omitempty"`
	// RankingExpression: Optional. The ranking expression controls the customized
	// ranking on retrieval documents. This overrides
	// ServingConfig.ranking_expression. The syntax and supported features depend
	// on the `ranking_expression_backend` value. If `ranking_expression_backend`
	// is not provided, it defaults to `RANK_BY_EMBEDDING`. If
	// ranking_expression_backend is not provided or set to `RANK_BY_EMBEDDING`, it
	// should be a single function or multiple functions that are joined by "+". *
	// ranking_expression = function, { " + ", function }; Supported functions: *
	// double * relevance_score * double * dotProduct(embedding_field_path)
	// Function variables: * `relevance_score`: pre-defined keywords, used for
	// measure relevance between query and document. * `embedding_field_path`: the
	// document embedding field used with query embedding vector. * `dotProduct`:
	// embedding function between `embedding_field_path` and query embedding
	// vector. Example ranking expression: If document has an embedding field
	// doc_embedding, the ranking expression could be `0.5 * relevance_score + 0.3
	// * dotProduct(doc_embedding)`. If ranking_expression_backend is set to
	// `RANK_BY_FORMULA`, the following expression types (and combinations of those
	// chained using + or * operators) are supported: * `double` * `signal` *
	// `log(signal)` * `exp(signal)` * `rr(signal, double > 0)` -- reciprocal rank
	// transformation with second argument being a denominator constant. *
	// `is_nan(signal)` -- returns 0 if signal is NaN, 1 otherwise. *
	// `fill_nan(signal1, signal2 | double)` -- if signal1 is NaN, returns signal2
	// | double, else returns signal1. Here are a few examples of ranking formulas
	// that use the supported ranking expression types: - `0.2 *
	// semantic_similarity_score + 0.8 * log(keyword_similarity_score)` -- mostly
	// rank by the logarithm of `keyword_similarity_score` with slight
	// `semantic_smilarity_score` adjustment. - `0.2 *
	// exp(fill_nan(semantic_similarity_score, 0)) + 0.3 *
	// is_nan(keyword_similarity_score)` -- rank by the exponent of
	// `semantic_similarity_score` filling the value with 0 if it's NaN, also add
	// constant 0.3 adjustment to the final score if `semantic_similarity_score` is
	// NaN. - `0.2 * rr(semantic_similarity_score, 16) + 0.8 *
	// rr(keyword_similarity_score, 16)` -- mostly rank by the reciprocal rank of
	// `keyword_similarity_score` with slight adjustment of reciprocal rank of
	// `semantic_smilarity_score`. The following signals are supported: *
	// `semantic_similarity_score`: semantic similarity adjustment that is
	// calculated using the embeddings generated by a proprietary Google model.
	// This score determines how semantically similar a search query is to a
	// document. * `keyword_similarity_score`: keyword match adjustment uses the
	// Best Match 25 (BM25) ranking function. This score is calculated using a
	// probabilistic model to estimate the probability that a document is relevant
	// to a given query. * `relevance_score`: semantic relevance adjustment that
	// uses a proprietary Google model to determine the meaning and intent behind a
	// user's query in context with the content in the documents. * `pctr_rank`:
	// predicted conversion rate adjustment as a rank use predicted Click-through
	// rate (pCTR) to gauge the relevance and attractiveness of a search result
	// from a user's perspective. A higher pCTR suggests that the result is more
	// likely to satisfy the user's query and intent, making it a valuable signal
	// for ranking. * `freshness_rank`: freshness adjustment as a rank *
	// `document_age`: The time in hours elapsed since the document was last
	// updated, a floating-point number (e.g., 0.25 means 15 minutes). *
	// `topicality_rank`: topicality adjustment as a rank. Uses proprietary Google
	// model to determine the keyword-based overlap between the query and the
	// document. * `base_rank`: the default rank of the result
	RankingExpression string `json:"rankingExpression,omitempty"`
	// RankingExpressionBackend: Optional. The backend to use for the ranking
	// expression evaluation.
	//
	// Possible values:
	//   "RANKING_EXPRESSION_BACKEND_UNSPECIFIED" - Default option for
	// unspecified/unknown values.
	//   "BYOE" - Deprecated: Use `RANK_BY_EMBEDDING` instead. Ranking by custom
	// embedding model, the default way to evaluate the ranking expression. Legacy
	// enum option, `RANK_BY_EMBEDDING` should be used instead.
	//   "CLEARBOX" - Deprecated: Use `RANK_BY_FORMULA` instead. Ranking by custom
	// formula. Legacy enum option, `RANK_BY_FORMULA` should be used instead.
	//   "RANK_BY_EMBEDDING" - Ranking by custom embedding model, the default way
	// to evaluate the ranking expression.
	//   "RANK_BY_FORMULA" - Ranking by custom formula.
	RankingExpressionBackend string `json:"rankingExpressionBackend,omitempty"`
	// RelevanceScoreSpec: Optional. The specification for returning the relevance
	// score.
	RelevanceScoreSpec *GoogleCloudDiscoveryengineV1SearchRequestRelevanceScoreSpec `json:"relevanceScoreSpec,omitempty"`
	// RelevanceThreshold: The relevance threshold of the search results. Default
	// to Google defined threshold, leveraging a balance of precision and recall to
	// deliver both highly accurate results and comprehensive coverage of relevant
	// information. This feature is not supported for healthcare search.
	//
	// Possible values:
	//   "RELEVANCE_THRESHOLD_UNSPECIFIED" - Default value. In this case, server
	// behavior defaults to Google defined threshold.
	//   "LOWEST" - Lowest relevance threshold.
	//   "LOW" - Low relevance threshold.
	//   "MEDIUM" - Medium relevance threshold.
	//   "HIGH" - High relevance threshold.
	RelevanceThreshold string `json:"relevanceThreshold,omitempty"`
	// SafeSearch: Whether to turn on safe search. This is only supported for
	// website search.
	SafeSearch bool `json:"safeSearch,omitempty"`
	// SearchAsYouTypeSpec: Search as you type configuration. Only supported for
	// the IndustryVertical.MEDIA vertical.
	SearchAsYouTypeSpec *GoogleCloudDiscoveryengineV1SearchRequestSearchAsYouTypeSpec `json:"searchAsYouTypeSpec,omitempty"`
	// Session: The session resource name. Optional. Session allows users to do
	// multi-turn /search API calls or coordination between /search API calls and
	// /answer API calls. Example #1 (multi-turn /search API calls): Call /search
	// API with the session ID generated in the first call. Here, the previous
	// search query gets considered in query standing. I.e., if the first query is
	// "How did Alphabet do in 2022?" and the current query is "How about 2023?",
	// the current query will be interpreted as "How did Alphabet do in 2023?".
	// Example #2 (coordination between /search API calls and /answer API calls):
	// Call /answer API with the session ID generated in the first call. Here, the
	// answer generation happens in the context of the search results from the
	// first search call. Multi-turn Search feature is currently at private GA
	// stage. Please use v1alpha or v1beta version instead before we launch this
	// feature to public GA. Or ask for allowlisting through Google Support team.
	Session string `json:"session,omitempty"`
	// SessionSpec: Session specification. Can be used only when `session` is set.
	SessionSpec *GoogleCloudDiscoveryengineV1SearchRequestSessionSpec `json:"sessionSpec,omitempty"`
	// SpellCorrectionSpec: The spell correction specification that specifies the
	// mode under which spell correction takes effect.
	SpellCorrectionSpec *GoogleCloudDiscoveryengineV1SearchRequestSpellCorrectionSpec `json:"spellCorrectionSpec,omitempty"`
	// UserInfo: Information about the end user. Highly recommended for analytics
	// and personalization. UserInfo.user_agent is used to deduce `device_type` for
	// analytics.
	UserInfo *GoogleCloudDiscoveryengineV1UserInfo `json:"userInfo,omitempty"`
	// UserLabels: The user labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Google Cloud Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// UserPseudoId: Optional. A unique identifier for tracking visitors. For
	// example, this could be implemented with an HTTP cookie, which should be able
	// to uniquely identify a visitor on a single device. This unique identifier
	// should not change if the visitor logs in or out of the website. This field
	// should NOT have a fixed value such as `unknown_visitor`. This should be the
	// same identifier as UserEvent.user_pseudo_id and
	// CompleteQueryRequest.user_pseudo_id The field must be a UTF-8 encoded string
	// with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT`
	// error is returned.
	UserPseudoId string `json:"userPseudoId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestBoostSpec: Boost specification to
// boost certain documents.
type GoogleCloudDiscoveryengineV1SearchRequestBoostSpec struct {
	// ConditionBoostSpecs: Condition boost specifications. If a document matches
	// multiple conditions in the specifications, boost scores from these
	// specifications are all applied and combined in a non-linear way. Maximum
	// number of specifications is 20.
	ConditionBoostSpecs []*GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpec `json:"conditionBoostSpecs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConditionBoostSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConditionBoostSpecs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpec: Boost
// applies to documents which match a condition.
type GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpec struct {
	// Boost: Strength of the condition boost, which should be in [-1, 1]. Negative
	// boost means demotion. Default is 0.0. Setting to 1.0 gives the document a
	// big promotion. However, it does not necessarily mean that the boosted
	// document will be the top result at all times, nor that other documents will
	// be excluded. Results could still be shown even when none of them matches the
	// condition. And results that are significantly more relevant to the search
	// query can still trump your heavily favored but irrelevant documents. Setting
	// to -1.0 gives the document a big demotion. However, results that are deeply
	// relevant might still be shown. The document will have an upstream battle to
	// get a fairly high ranking, but it is not blocked out completely. Setting to
	// 0.0 means no boost applied. The boosting condition is ignored. Only one of
	// the (condition, boost) combination or the boost_control_spec below are set.
	// If both are set then the global boost is ignored and the more fine-grained
	// boost_control_spec is applied.
	Boost float64 `json:"boost,omitempty"`
	// BoostControlSpec: Complex specification for custom ranking based on customer
	// defined attribute value.
	BoostControlSpec *GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpecBoostControlSpec `json:"boostControlSpec,omitempty"`
	// Condition: An expression which specifies a boost condition. The syntax and
	// supported fields are the same as a filter expression. See
	// SearchRequest.filter for detail syntax and limitations. Examples: * To boost
	// documents with document ID "doc_1" or "doc_2", and color "Red" or "Blue":
	// `(document_id: ANY("doc_1", "doc_2")) AND (color: ANY("Red", "Blue"))`
	Condition string `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpec) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpec
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

// GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpecBoostCont
// rolSpec: Specification for custom ranking based on customer specified
// attribute value. It provides more controls for customized ranking than the
// simple (condition, boost) combination above.
type GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpecBoostControlSpec struct {
	// AttributeType: The attribute type to be used to determine the boost amount.
	// The attribute value can be derived from the field value of the specified
	// field_name. In the case of numerical it is straightforward i.e.
	// attribute_value = numerical_field_value. In the case of freshness however,
	// attribute_value = (time.now() - datetime_field_value).
	//
	// Possible values:
	//   "ATTRIBUTE_TYPE_UNSPECIFIED" - Unspecified AttributeType.
	//   "NUMERICAL" - The value of the numerical field will be used to dynamically
	// update the boost amount. In this case, the attribute_value (the x value) of
	// the control point will be the actual value of the numerical field for which
	// the boost_amount is specified.
	//   "FRESHNESS" - For the freshness use case the attribute value will be the
	// duration between the current time and the date in the datetime field
	// specified. The value must be formatted as an XSD `dayTimeDuration` value (a
	// restricted subset of an ISO 8601 duration value). The pattern for this is:
	// `nDnM]`. For example, `5D`, `3DT12H30M`, `T24H`.
	AttributeType string `json:"attributeType,omitempty"`
	// ControlPoints: The control points used to define the curve. The monotonic
	// function (defined through the interpolation_type above) passes through the
	// control points listed here.
	ControlPoints []*GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint `json:"controlPoints,omitempty"`
	// FieldName: The name of the field whose value will be used to determine the
	// boost amount.
	FieldName string `json:"fieldName,omitempty"`
	// InterpolationType: The interpolation type to be applied to connect the
	// control points listed below.
	//
	// Possible values:
	//   "INTERPOLATION_TYPE_UNSPECIFIED" - Interpolation type is unspecified. In
	// this case, it defaults to Linear.
	//   "LINEAR" - Piecewise linear interpolation will be applied.
	InterpolationType string `json:"interpolationType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpecBoostControlSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpecBoostControlSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpecBoostCont
// rolSpecControlPoint: The control points used to define the curve. The curve
// defined through these control points can only be monotonically increasing or
// decreasing(constant values are acceptable).
type GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint struct {
	// AttributeValue: Can be one of: 1. The numerical field value. 2. The duration
	// spec for freshness: The value must be formatted as an XSD `dayTimeDuration`
	// value (a restricted subset of an ISO 8601 duration value). The pattern for
	// this is: `nDnM]`.
	AttributeValue string `json:"attributeValue,omitempty"`
	// BoostAmount: The value between -1 to 1 by which to boost the score if the
	// attribute_value evaluates to the value specified above.
	BoostAmount float64 `json:"boostAmount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeValue") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint
	var s1 struct {
		BoostAmount gensupport.JSONFloat64 `json:"boostAmount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BoostAmount = float64(s1.BoostAmount)
	return nil
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpec: A specification
// for configuring the behavior of content search.
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpec struct {
	// ChunkSpec: Specifies the chunk spec to be returned from the search response.
	// Only available if the SearchRequest.ContentSearchSpec.search_result_mode is
	// set to CHUNKS
	ChunkSpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecChunkSpec `json:"chunkSpec,omitempty"`
	// ExtractiveContentSpec: If there is no extractive_content_spec provided,
	// there will be no extractive answer in the search response.
	ExtractiveContentSpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecExtractiveContentSpec `json:"extractiveContentSpec,omitempty"`
	// SearchResultMode: Specifies the search result mode. If unspecified, the
	// search result mode defaults to `DOCUMENTS`.
	//
	// Possible values:
	//   "SEARCH_RESULT_MODE_UNSPECIFIED" - Default value.
	//   "DOCUMENTS" - Returns documents in the search result.
	//   "CHUNKS" - Returns chunks in the search result. Only available if the
	// DocumentProcessingConfig.chunking_config is specified.
	SearchResultMode string `json:"searchResultMode,omitempty"`
	// SnippetSpec: If `snippetSpec` is not specified, snippets are not included in
	// the search response.
	SnippetSpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSnippetSpec `json:"snippetSpec,omitempty"`
	// SummarySpec: If `summarySpec` is not specified, summaries are not included
	// in the search response.
	SummarySpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec `json:"summarySpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecChunkSpec:
// Specifies the chunk spec to be returned from the search response. Only
// available if the SearchRequest.ContentSearchSpec.search_result_mode is set
// to CHUNKS
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecChunkSpec struct {
	// NumNextChunks: The number of next chunks to be returned of the current
	// chunk. The maximum allowed value is 3. If not specified, no next chunks will
	// be returned.
	NumNextChunks int64 `json:"numNextChunks,omitempty"`
	// NumPreviousChunks: The number of previous chunks to be returned of the
	// current chunk. The maximum allowed value is 3. If not specified, no previous
	// chunks will be returned.
	NumPreviousChunks int64 `json:"numPreviousChunks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NumNextChunks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NumNextChunks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecChunkSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecChunkSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecExtractiveContentSp
// ec: A specification for configuring the extractive content in a search
// response.
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecExtractiveContentSpec struct {
	// MaxExtractiveAnswerCount: The maximum number of extractive answers returned
	// in each search result. An extractive answer is a verbatim answer extracted
	// from the original document, which provides a precise and contextually
	// relevant answer to the search query. If the number of matching answers is
	// less than the `max_extractive_answer_count`, return all of the answers.
	// Otherwise, return the `max_extractive_answer_count`. At most five answers
	// are returned for each SearchResult.
	MaxExtractiveAnswerCount int64 `json:"maxExtractiveAnswerCount,omitempty"`
	// MaxExtractiveSegmentCount: The max number of extractive segments returned in
	// each search result. Only applied if the DataStore is set to
	// DataStore.ContentConfig.CONTENT_REQUIRED or DataStore.solution_types is
	// SOLUTION_TYPE_CHAT. An extractive segment is a text segment extracted from
	// the original document that is relevant to the search query, and, in general,
	// more verbose than an extractive answer. The segment could then be used as
	// input for LLMs to generate summaries and answers. If the number of matching
	// segments is less than `max_extractive_segment_count`, return all of the
	// segments. Otherwise, return the `max_extractive_segment_count`.
	MaxExtractiveSegmentCount int64 `json:"maxExtractiveSegmentCount,omitempty"`
	// NumNextSegments: Return at most `num_next_segments` segments after each
	// selected segments.
	NumNextSegments int64 `json:"numNextSegments,omitempty"`
	// NumPreviousSegments: Specifies whether to also include the adjacent from
	// each selected segments. Return at most `num_previous_segments` segments
	// before each selected segments.
	NumPreviousSegments int64 `json:"numPreviousSegments,omitempty"`
	// ReturnExtractiveSegmentScore: Specifies whether to return the confidence
	// score from the extractive segments in each search result. This feature is
	// available only for new or allowlisted data stores. To allowlist your data
	// store, contact your Customer Engineer. The default value is `false`.
	ReturnExtractiveSegmentScore bool `json:"returnExtractiveSegmentScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxExtractiveAnswerCount")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxExtractiveAnswerCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecExtractiveContentSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecExtractiveContentSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSnippetSpec: A
// specification for configuring snippets in a search response.
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSnippetSpec struct {
	// MaxSnippetCount: [DEPRECATED] This field is deprecated. To control snippet
	// return, use `return_snippet` field. For backwards compatibility, we will
	// return snippet if max_snippet_count > 0.
	MaxSnippetCount int64 `json:"maxSnippetCount,omitempty"`
	// ReferenceOnly: [DEPRECATED] This field is deprecated and will have no affect
	// on the snippet.
	ReferenceOnly bool `json:"referenceOnly,omitempty"`
	// ReturnSnippet: If `true`, then return snippet. If no snippet can be
	// generated, we return "No snippet is available for this page." A
	// `snippet_status` with `SUCCESS` or `NO_SNIPPET_AVAILABLE` will also be
	// returned.
	ReturnSnippet bool `json:"returnSnippet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxSnippetCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxSnippetCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSnippetSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSnippetSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec: A
// specification for configuring a summary returned in a search response.
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec struct {
	// IgnoreAdversarialQuery: Specifies whether to filter out adversarial queries.
	// The default value is `false`. Google employs search-query classification to
	// detect adversarial queries. No summary is returned if the search query is
	// classified as an adversarial query. For example, a user might ask a question
	// regarding negative comments about the company or submit a query designed to
	// generate unsafe, policy-violating output. If this field is set to `true`, we
	// skip generating summaries for adversarial queries and return fallback
	// messages instead.
	IgnoreAdversarialQuery bool `json:"ignoreAdversarialQuery,omitempty"`
	// IgnoreJailBreakingQuery: Optional. Specifies whether to filter out
	// jail-breaking queries. The default value is `false`. Google employs
	// search-query classification to detect jail-breaking queries. No summary is
	// returned if the search query is classified as a jail-breaking query. A user
	// might add instructions to the query to change the tone, style, language,
	// content of the answer, or ask the model to act as a different entity, e.g.
	// "Reply in the tone of a competing company's CEO". If this field is set to
	// `true`, we skip generating summaries for jail-breaking queries and return
	// fallback messages instead.
	IgnoreJailBreakingQuery bool `json:"ignoreJailBreakingQuery,omitempty"`
	// IgnoreLowRelevantContent: Specifies whether to filter out queries that have
	// low relevance. The default value is `false`. If this field is set to
	// `false`, all search results are used regardless of relevance to generate
	// answers. If set to `true`, only queries with high relevance search results
	// will generate answers.
	IgnoreLowRelevantContent bool `json:"ignoreLowRelevantContent,omitempty"`
	// IgnoreNonSummarySeekingQuery: Specifies whether to filter out queries that
	// are not summary-seeking. The default value is `false`. Google employs
	// search-query classification to detect summary-seeking queries. No summary is
	// returned if the search query is classified as a non-summary seeking query.
	// For example, `why is the sky blue` and `Who is the best soccer player in the
	// world?` are summary-seeking queries, but `SFO airport` and `world cup 2026`
	// are not. They are most likely navigational queries. If this field is set to
	// `true`, we skip generating summaries for non-summary seeking queries and
	// return fallback messages instead.
	IgnoreNonSummarySeekingQuery bool `json:"ignoreNonSummarySeekingQuery,omitempty"`
	// IncludeCitations: Specifies whether to include citations in the summary. The
	// default value is `false`. When this field is set to `true`, summaries
	// include in-line citation numbers. Example summary including citations:
	// BigQuery is Google Cloud's fully managed and completely serverless
	// enterprise data warehouse [1]. BigQuery supports all data types, works
	// across clouds, and has built-in machine learning and business intelligence,
	// all within a unified platform [2, 3]. The citation numbers refer to the
	// returned search results and are 1-indexed. For example, [1] means that the
	// sentence is attributed to the first search result. [2, 3] means that the
	// sentence is attributed to both the second and third search results.
	IncludeCitations bool `json:"includeCitations,omitempty"`
	// LanguageCode: Language code for Summary. Use language tags defined by BCP47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Note: This is an
	// experimental feature.
	LanguageCode string `json:"languageCode,omitempty"`
	// ModelPromptSpec: If specified, the spec will be used to modify the prompt
	// provided to the LLM.
	ModelPromptSpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelPromptSpec `json:"modelPromptSpec,omitempty"`
	// ModelSpec: If specified, the spec will be used to modify the model
	// specification provided to the LLM.
	ModelSpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelSpec `json:"modelSpec,omitempty"`
	// SummaryResultCount: The number of top results to generate the summary from.
	// If the number of results returned is less than `summaryResultCount`, the
	// summary is generated from all of the results. At most 10 results for
	// documents mode, or 50 for chunks mode, can be used to generate a summary.
	// The chunks mode is used when
	// SearchRequest.ContentSearchSpec.search_result_mode is set to CHUNKS.
	SummaryResultCount int64 `json:"summaryResultCount,omitempty"`
	// UseSemanticChunks: If true, answer will be generated from most relevant
	// chunks from top search results. This feature will improve summary quality.
	// Note that with this feature enabled, not all top search results will be
	// referenced and included in the reference list, so the citation source index
	// only points to the search results listed in the reference list.
	UseSemanticChunks bool `json:"useSemanticChunks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IgnoreAdversarialQuery") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IgnoreAdversarialQuery") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelPro
// mptSpec: Specification of the prompt to use with the model.
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelPromptSpec struct {
	// Preamble: Text at the beginning of the prompt that instructs the assistant.
	// Examples are available in the user guide.
	Preamble string `json:"preamble,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Preamble") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Preamble") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelPromptSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelPromptSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelSpe
// c: Specification of the model.
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelSpec struct {
	// Version: The model version used to generate the summary. Supported values
	// are: * `stable`: string. Default value when no value is specified. Uses a
	// generally available, fine-tuned model. For more information, see Answer
	// generation model versions and lifecycle
	// (https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
	// * `preview`: string. (Public preview) Uses a preview model. For more
	// information, see Answer generation model versions and lifecycle
	// (https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestDataStoreSpec: A struct to define
// data stores to filter on in a search call and configurations for those data
// stores. Otherwise, an `INVALID_ARGUMENT` error is returned.
type GoogleCloudDiscoveryengineV1SearchRequestDataStoreSpec struct {
	// BoostSpec: Optional. Boost specification to boost certain documents. For
	// more information on boosting, see Boosting
	// (https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
	BoostSpec *GoogleCloudDiscoveryengineV1SearchRequestBoostSpec `json:"boostSpec,omitempty"`
	// CustomSearchOperators: Optional. Custom search operators which if specified
	// will be used to filter results from workspace data stores. For more
	// information on custom search operators, see SearchOperators
	// (https://support.google.com/cloudsearch/answer/6172299).
	CustomSearchOperators string `json:"customSearchOperators,omitempty"`
	// DataStore: Required. Full resource name of DataStore, such as
	// `projects/{project}/locations/{location}/collections/{collection_id}/dataStor
	// es/{data_store_id}`. The path must include the project number, project id is
	// not supported for this field.
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Optional. Filter specification to filter documents in the data store
	// specified by data_store field. For more information on filtering, see
	// Filtering
	// (https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestDataStoreSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestDataStoreSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestDisplaySpec: Specifies features for
// display, like match highlighting.
type GoogleCloudDiscoveryengineV1SearchRequestDisplaySpec struct {
	// MatchHighlightingCondition: The condition under which match highlighting
	// should occur.
	//
	// Possible values:
	//   "MATCH_HIGHLIGHTING_CONDITION_UNSPECIFIED" - Server behavior is the same
	// as `MATCH_HIGHLIGHTING_DISABLED`.
	//   "MATCH_HIGHLIGHTING_DISABLED" - Disables match highlighting on all
	// documents.
	//   "MATCH_HIGHLIGHTING_ENABLED" - Enables match highlighting on all
	// documents.
	MatchHighlightingCondition string `json:"matchHighlightingCondition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MatchHighlightingCondition")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MatchHighlightingCondition") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestDisplaySpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestDisplaySpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestFacetSpec: A facet specification to
// perform faceted search.
type GoogleCloudDiscoveryengineV1SearchRequestFacetSpec struct {
	// EnableDynamicPosition: Enables dynamic position for this facet. If set to
	// true, the position of this facet among all facets in the response is
	// determined automatically. If dynamic facets are enabled, it is ordered
	// together. If set to false, the position of this facet in the response is the
	// same as in the request, and it is ranked before the facets with dynamic
	// position enable and all dynamic facets. For example, you may always want to
	// have rating facet returned in the response, but it's not necessarily to
	// always display the rating facet at the top. In that case, you can set
	// enable_dynamic_position to true so that the position of rating facet in
	// response is determined automatically. Another example, assuming you have the
	// following facets in the request: * "rating", enable_dynamic_position = true
	// * "price", enable_dynamic_position = false * "brands",
	// enable_dynamic_position = false And also you have a dynamic facets enabled,
	// which generates a facet `gender`. Then the final order of the facets in the
	// response can be ("price", "brands", "rating", "gender") or ("price",
	// "brands", "gender", "rating") depends on how API orders "gender" and
	// "rating" facets. However, notice that "price" and "brands" are always ranked
	// at first and second position because their enable_dynamic_position is false.
	EnableDynamicPosition bool `json:"enableDynamicPosition,omitempty"`
	// ExcludedFilterKeys: List of keys to exclude when faceting. By default,
	// FacetKey.key is not excluded from the filter unless it is listed in this
	// field. Listing a facet key in this field allows its values to appear as
	// facet results, even when they are filtered out of search results. Using this
	// field does not affect what search results are returned. For example, suppose
	// there are 100 documents with the color facet "Red" and 200 documents with
	// the color facet "Blue". A query containing the filter "color:ANY("Red")" and
	// having "color" as FacetKey.key would by default return only "Red" documents
	// in the search results, and also return "Red" with count 100 as the only
	// color facet. Although there are also blue documents available, "Blue" would
	// not be shown as an available facet value. If "color" is listed in
	// "excludedFilterKeys", then the query returns the facet values "Red" with
	// count 100 and "Blue" with count 200, because the "color" key is now excluded
	// from the filter. Because this field doesn't affect search results, the
	// search results are still correctly filtered to return only "Red" documents.
	// A maximum of 100 values are allowed. Otherwise, an `INVALID_ARGUMENT` error
	// is returned.
	ExcludedFilterKeys []string `json:"excludedFilterKeys,omitempty"`
	// FacetKey: Required. The facet key specification.
	FacetKey *GoogleCloudDiscoveryengineV1SearchRequestFacetSpecFacetKey `json:"facetKey,omitempty"`
	// Limit: Maximum facet values that are returned for this facet. If
	// unspecified, defaults to 20. The maximum allowed value is 300. Values above
	// 300 are coerced to 300. For aggregation in healthcare search, when the
	// [FacetKey.key] is "healthcare_aggregation_key", the limit will be overridden
	// to 10,000 internally, regardless of the value set here. If this field is
	// negative, an `INVALID_ARGUMENT` is returned.
	Limit int64 `json:"limit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableDynamicPosition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableDynamicPosition") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestFacetSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestFacetSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestFacetSpecFacetKey: Specifies how a
// facet is computed.
type GoogleCloudDiscoveryengineV1SearchRequestFacetSpecFacetKey struct {
	// CaseInsensitive: True to make facet keys case insensitive when getting
	// faceting values with prefixes or contains; false otherwise.
	CaseInsensitive bool `json:"caseInsensitive,omitempty"`
	// Contains: Only get facet values that contain the given strings. For example,
	// suppose "category" has three values "Action > 2022", "Action > 2021" and
	// "Sci-Fi > 2022". If set "contains" to "2022", the "category" facet only
	// contains "Action > 2022" and "Sci-Fi > 2022". Only supported on textual
	// fields. Maximum is 10.
	Contains []string `json:"contains,omitempty"`
	// Intervals: Set only if values should be bucketed into intervals. Must be set
	// for facets with numerical values. Must not be set for facet with text
	// values. Maximum number of intervals is 30.
	Intervals []*GoogleCloudDiscoveryengineV1Interval `json:"intervals,omitempty"`
	// Key: Required. Supported textual and numerical facet keys in Document
	// object, over which the facet values are computed. Facet key is
	// case-sensitive.
	Key string `json:"key,omitempty"`
	// OrderBy: The order in which documents are returned. Allowed values are: *
	// "count desc", which means order by SearchResponse.Facet.values.count
	// descending. * "value desc", which means order by
	// SearchResponse.Facet.values.value descending. Only applies to textual
	// facets. If not set, textual values are sorted in natural order
	// (https://en.wikipedia.org/wiki/Natural_sort_order); numerical intervals are
	// sorted in the order given by FacetSpec.FacetKey.intervals.
	OrderBy string `json:"orderBy,omitempty"`
	// Prefixes: Only get facet values that start with the given string prefix. For
	// example, suppose "category" has three values "Action > 2022", "Action >
	// 2021" and "Sci-Fi > 2022". If set "prefixes" to "Action", the "category"
	// facet only contains "Action > 2022" and "Action > 2021". Only supported on
	// textual fields. Maximum is 10.
	Prefixes []string `json:"prefixes,omitempty"`
	// RestrictedValues: Only get facet for the given restricted values. Only
	// supported on textual fields. For example, suppose "category" has three
	// values "Action > 2022", "Action > 2021" and "Sci-Fi > 2022". If set
	// "restricted_values" to "Action > 2022", the "category" facet only contains
	// "Action > 2022". Only supported on textual fields. Maximum is 10.
	RestrictedValues []string `json:"restrictedValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaseInsensitive") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaseInsensitive") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestFacetSpecFacetKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestFacetSpecFacetKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestImageQuery: Specifies the image
// query input.
type GoogleCloudDiscoveryengineV1SearchRequestImageQuery struct {
	// ImageBytes: Base64 encoded image bytes. Supported image formats: JPEG, PNG,
	// and BMP.
	ImageBytes string `json:"imageBytes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageBytes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestImageQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestImageQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestNaturalLanguageQueryUnderstandingSpe
// c: Specification to enable natural language understanding capabilities for
// search requests.
type GoogleCloudDiscoveryengineV1SearchRequestNaturalLanguageQueryUnderstandingSpec struct {
	// AllowedFieldNames: Optional. Allowlist of fields that can be used for
	// natural language filter extraction. By default, if this is unspecified, all
	// indexable fields are eligible for natural language filter extraction (but
	// are not guaranteed to be used). If any fields are specified in
	// allowed_field_names, only the fields that are both marked as indexable in
	// the schema and specified in the allowlist will be eligible for natural
	// language filter extraction. Note: for multi-datastore search, this is not
	// yet supported, and will be ignored.
	AllowedFieldNames []string `json:"allowedFieldNames,omitempty"`
	// ExtractedFilterBehavior: Optional. Controls behavior of how extracted
	// filters are applied to the search. The default behavior depends on the
	// request. For single datastore structured search, the default is
	// `HARD_FILTER`. For multi-datastore search, the default behavior is
	// `SOFT_BOOST`. Location-based filters are always applied as hard filters, and
	// the `SOFT_BOOST` setting will not affect them. This field is only used if
	// SearchRequest.natural_language_query_understanding_spec.filter_extraction_con
	// dition is set to FilterExtractionCondition.ENABLED.
	//
	// Possible values:
	//   "EXTRACTED_FILTER_BEHAVIOR_UNSPECIFIED" -
	// `EXTRACTED_FILTER_BEHAVIOR_UNSPECIFIED` will use the default behavior for
	// extracted filters. For single datastore search, the default is to apply as
	// hard filters. For multi-datastore search, the default is to apply as soft
	// boosts.
	//   "HARD_FILTER" - Applies all extracted filters as hard filters on the
	// results. Results that do not pass the extracted filters will not be returned
	// in the result set.
	//   "SOFT_BOOST" - Applies all extracted filters as soft boosts. Results that
	// pass the filters will be boosted up to higher ranks in the result set.
	ExtractedFilterBehavior string `json:"extractedFilterBehavior,omitempty"`
	// FilterExtractionCondition: The condition under which filter extraction
	// should occur. Server behavior defaults to `DISABLED`.
	//
	// Possible values:
	//   "CONDITION_UNSPECIFIED" - Server behavior defaults to `DISABLED`.
	//   "DISABLED" - Disables NL filter extraction.
	//   "ENABLED" - Enables NL filter extraction.
	FilterExtractionCondition string `json:"filterExtractionCondition,omitempty"`
	// GeoSearchQueryDetectionFieldNames: Field names used for location-based
	// filtering, where geolocation filters are detected in natural language search
	// queries. Only valid when the FilterExtractionCondition is set to `ENABLED`.
	// If this field is set, it overrides the field names set in
	// ServingConfig.geo_search_query_detection_field_names.
	GeoSearchQueryDetectionFieldNames []string `json:"geoSearchQueryDetectionFieldNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedFieldNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedFieldNames") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestNaturalLanguageQueryUnderstandingSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestNaturalLanguageQueryUnderstandingSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestQueryExpansionSpec: Specification
// to determine under which conditions query expansion should occur.
type GoogleCloudDiscoveryengineV1SearchRequestQueryExpansionSpec struct {
	// Condition: The condition under which query expansion should occur. Default
	// to Condition.DISABLED.
	//
	// Possible values:
	//   "CONDITION_UNSPECIFIED" - Unspecified query expansion condition. In this
	// case, server behavior defaults to Condition.DISABLED.
	//   "DISABLED" - Disabled query expansion. Only the exact search query is
	// used, even if SearchResponse.total_size is zero.
	//   "AUTO" - Automatic query expansion built by the Search API.
	Condition string `json:"condition,omitempty"`
	// PinUnexpandedResults: Whether to pin unexpanded results. If this field is
	// set to true, unexpanded products are always at the top of the search
	// results, followed by the expanded results.
	PinUnexpandedResults bool `json:"pinUnexpandedResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestQueryExpansionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestQueryExpansionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestRelevanceScoreSpec: The
// specification for returning the document relevance score.
type GoogleCloudDiscoveryengineV1SearchRequestRelevanceScoreSpec struct {
	// ReturnRelevanceScore: Optional. Whether to return the relevance score for
	// search results. The higher the score, the more relevant the document is to
	// the query.
	ReturnRelevanceScore bool `json:"returnRelevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReturnRelevanceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReturnRelevanceScore") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestRelevanceScoreSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestRelevanceScoreSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestSearchAsYouTypeSpec: Specification
// for search as you type in search requests.
type GoogleCloudDiscoveryengineV1SearchRequestSearchAsYouTypeSpec struct {
	// Condition: The condition under which search as you type should occur.
	// Default to Condition.DISABLED.
	//
	// Possible values:
	//   "CONDITION_UNSPECIFIED" - Server behavior defaults to Condition.DISABLED.
	//   "DISABLED" - Disables Search As You Type.
	//   "ENABLED" - Enables Search As You Type.
	//   "AUTO" - Automatic switching between search-as-you-type and standard
	// search modes, ideal for single-API implementations (e.g., debouncing).
	Condition string `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestSearchAsYouTypeSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestSearchAsYouTypeSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestSessionSpec: Session specification.
// Multi-turn Search feature is currently at private GA stage. Please use
// v1alpha or v1beta version instead before we launch this feature to public
// GA. Or ask for allowlisting through Google Support team.
type GoogleCloudDiscoveryengineV1SearchRequestSessionSpec struct {
	// QueryId: If set, the search result gets stored to the "turn" specified by
	// this query ID. Example: Let's say the session looks like this: session {
	// name: ".../sessions/xxx" turns { query { text: "What is foo?" query_id:
	// ".../questions/yyy" } answer: "Foo is ..." } turns { query { text: "How
	// about bar then?" query_id: ".../questions/zzz" } } } The user can call
	// /search API with a request like this: session: ".../sessions/xxx"
	// session_spec { query_id: ".../questions/zzz" } Then, the API stores the
	// search result, associated with the last turn. The stored search result can
	// be used by a subsequent /answer API call (with the session ID and the query
	// ID specified). Also, it is possible to call /search and /answer in parallel
	// with the same session ID & query ID.
	QueryId string `json:"queryId,omitempty"`
	// SearchResultPersistenceCount: The number of top search results to persist.
	// The persisted search results can be used for the subsequent /answer api
	// call. This field is similar to the `summary_result_count` field in
	// SearchRequest.ContentSearchSpec.SummarySpec.summary_result_count. At most 10
	// results for documents mode, or 50 for chunks mode.
	SearchResultPersistenceCount int64 `json:"searchResultPersistenceCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestSessionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestSessionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestSpellCorrectionSpec: The
// specification for query spell correction.
type GoogleCloudDiscoveryengineV1SearchRequestSpellCorrectionSpec struct {
	// Mode: The mode under which spell correction replaces the original search
	// query. Defaults to Mode.AUTO.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Unspecified spell correction mode. In this case,
	// server behavior defaults to Mode.AUTO.
	//   "SUGGESTION_ONLY" - Search API tries to find a spelling suggestion. If a
	// suggestion is found, it is put in the SearchResponse.corrected_query. The
	// spelling suggestion won't be used as the search query.
	//   "AUTO" - Automatic spell correction built by the Search API. Search will
	// be based on the corrected query if found.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Mode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Mode") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestSpellCorrectionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestSpellCorrectionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponse: Response message for
// SearchService.Search method.
type GoogleCloudDiscoveryengineV1SearchResponse struct {
	// AttributionToken: A unique search token. This should be included in the
	// UserEvent logs resulting from this search, which enables accurate
	// attribution of search model performance. This also helps to identify a
	// request during the customer support scenarios.
	AttributionToken string `json:"attributionToken,omitempty"`
	// CorrectedQuery: Contains the spell corrected query, if found. If the spell
	// correction type is AUTOMATIC, then the search results are based on
	// corrected_query. Otherwise the original query is used for search.
	CorrectedQuery string `json:"correctedQuery,omitempty"`
	// Facets: Results of facets requested by user.
	Facets []*GoogleCloudDiscoveryengineV1SearchResponseFacet `json:"facets,omitempty"`
	// NextPageToken: A token that can be sent as SearchRequest.page_token to
	// retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// QueryExpansionInfo: Query expansion information for the returned results.
	QueryExpansionInfo *GoogleCloudDiscoveryengineV1SearchResponseQueryExpansionInfo `json:"queryExpansionInfo,omitempty"`
	// RedirectUri: The URI of a customer-defined redirect page. If redirect action
	// is triggered, no search is performed, and only redirect_uri and
	// attribution_token are set in the response.
	RedirectUri string `json:"redirectUri,omitempty"`
	// Results: A list of matched documents. The order represents the ranking.
	Results []*GoogleCloudDiscoveryengineV1SearchResponseSearchResult `json:"results,omitempty"`
	// SearchLinkPromotions: Promotions for site search.
	SearchLinkPromotions []*GoogleCloudDiscoveryengineV1SearchLinkPromotion `json:"searchLinkPromotions,omitempty"`
	// SessionInfo: Session information. Only set if SearchRequest.session is
	// provided. See its description for more details.
	SessionInfo *GoogleCloudDiscoveryengineV1SearchResponseSessionInfo `json:"sessionInfo,omitempty"`
	// Summary: A summary as part of the search results. This field is only
	// returned if SearchRequest.ContentSearchSpec.summary_spec is set.
	Summary *GoogleCloudDiscoveryengineV1SearchResponseSummary `json:"summary,omitempty"`
	// TotalSize: The estimated total count of matched items irrespective of
	// pagination. The count of results returned by pagination may be less than the
	// total_size that matches.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AttributionToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributionToken") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseFacet: A facet result.
type GoogleCloudDiscoveryengineV1SearchResponseFacet struct {
	// DynamicFacet: Whether the facet is dynamically generated.
	DynamicFacet bool `json:"dynamicFacet,omitempty"`
	// Key: The key for this facet. For example, "colors" or "price". It
	// matches SearchRequest.FacetSpec.FacetKey.key.
	Key string `json:"key,omitempty"`
	// Values: The facet values for this field.
	Values []*GoogleCloudDiscoveryengineV1SearchResponseFacetFacetValue `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DynamicFacet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DynamicFacet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseFacet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseFacet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseFacetFacetValue: A facet value
// which contains value names and their count.
type GoogleCloudDiscoveryengineV1SearchResponseFacetFacetValue struct {
	// Count: Number of items that have this facet value.
	Count int64 `json:"count,omitempty,string"`
	// Interval: Interval value for a facet, such as 10, 20) for facet "price". It
	// matches [SearchRequest.FacetSpec.FacetKey.intervals.
	Interval *GoogleCloudDiscoveryengineV1Interval `json:"interval,omitempty"`
	// Value: Text value of a facet, such as "Black" for facet "colors".
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseFacetFacetValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseFacetFacetValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseQueryExpansionInfo: Information
// describing query expansion including whether expansion has occurred.
type GoogleCloudDiscoveryengineV1SearchResponseQueryExpansionInfo struct {
	// ExpandedQuery: Bool describing whether query expansion has occurred.
	ExpandedQuery bool `json:"expandedQuery,omitempty"`
	// PinnedResultCount: Number of pinned results. This field will only be set
	// when expansion happens and
	// SearchRequest.QueryExpansionSpec.pin_unexpanded_results is set to true.
	PinnedResultCount int64 `json:"pinnedResultCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ExpandedQuery") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExpandedQuery") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseQueryExpansionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseQueryExpansionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseSearchResult: Represents the
// search results.
type GoogleCloudDiscoveryengineV1SearchResponseSearchResult struct {
	// Chunk: The chunk data in the search response if the
	// SearchRequest.ContentSearchSpec.search_result_mode is set to CHUNKS.
	Chunk *GoogleCloudDiscoveryengineV1Chunk `json:"chunk,omitempty"`
	// Document: The document data snippet in the search response. Only fields that
	// are marked as `retrievable` are populated.
	Document *GoogleCloudDiscoveryengineV1Document `json:"document,omitempty"`
	// Id: Document.id of the searched Document.
	Id string `json:"id,omitempty"`
	// ModelScores: Output only. Google provided available scores.
	ModelScores map[string]GoogleCloudDiscoveryengineV1DoubleList `json:"modelScores,omitempty"`
	// RankSignals: Optional. A set of ranking signals associated with the result.
	RankSignals *GoogleCloudDiscoveryengineV1SearchResponseSearchResultRankSignals `json:"rankSignals,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSearchResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseSearchResultRankSignals: A set of
// ranking signals.
type GoogleCloudDiscoveryengineV1SearchResponseSearchResultRankSignals struct {
	// BoostingFactor: Optional. Combined custom boosts for a doc.
	BoostingFactor float64 `json:"boostingFactor,omitempty"`
	// CustomSignals: Optional. A list of custom clearbox signals.
	CustomSignals []*GoogleCloudDiscoveryengineV1SearchResponseSearchResultRankSignalsCustomSignal `json:"customSignals,omitempty"`
	// DefaultRank: Optional. The default rank of the result.
	DefaultRank float64 `json:"defaultRank,omitempty"`
	// DocumentAge: Optional. Age of the document in hours.
	DocumentAge float64 `json:"documentAge,omitempty"`
	// KeywordSimilarityScore: Optional. Keyword matching adjustment.
	KeywordSimilarityScore float64 `json:"keywordSimilarityScore,omitempty"`
	// PctrRank: Optional. Predicted conversion rate adjustment as a rank.
	PctrRank float64 `json:"pctrRank,omitempty"`
	// RelevanceScore: Optional. Semantic relevance adjustment.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// SemanticSimilarityScore: Optional. Semantic similarity adjustment.
	SemanticSimilarityScore float64 `json:"semanticSimilarityScore,omitempty"`
	// TopicalityRank: Optional. Topicality adjustment as a rank.
	TopicalityRank float64 `json:"topicalityRank,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostingFactor") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostingFactor") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSearchResultRankSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSearchResultRankSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1SearchResponseSearchResultRankSignals) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSearchResultRankSignals
	var s1 struct {
		BoostingFactor          gensupport.JSONFloat64 `json:"boostingFactor"`
		DefaultRank             gensupport.JSONFloat64 `json:"defaultRank"`
		DocumentAge             gensupport.JSONFloat64 `json:"documentAge"`
		KeywordSimilarityScore  gensupport.JSONFloat64 `json:"keywordSimilarityScore"`
		PctrRank                gensupport.JSONFloat64 `json:"pctrRank"`
		RelevanceScore          gensupport.JSONFloat64 `json:"relevanceScore"`
		SemanticSimilarityScore gensupport.JSONFloat64 `json:"semanticSimilarityScore"`
		TopicalityRank          gensupport.JSONFloat64 `json:"topicalityRank"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BoostingFactor = float64(s1.BoostingFactor)
	s.DefaultRank = float64(s1.DefaultRank)
	s.DocumentAge = float64(s1.DocumentAge)
	s.KeywordSimilarityScore = float64(s1.KeywordSimilarityScore)
	s.PctrRank = float64(s1.PctrRank)
	s.RelevanceScore = float64(s1.RelevanceScore)
	s.SemanticSimilarityScore = float64(s1.SemanticSimilarityScore)
	s.TopicalityRank = float64(s1.TopicalityRank)
	return nil
}

// GoogleCloudDiscoveryengineV1SearchResponseSearchResultRankSignalsCustomSignal
// : Custom clearbox signal represented by name and value pair.
type GoogleCloudDiscoveryengineV1SearchResponseSearchResultRankSignalsCustomSignal struct {
	// Name: Optional. Name of the signal.
	Name string `json:"name,omitempty"`
	// Value: Optional. Float value representing the ranking signal (e.g. 1.25 for
	// BM25).
	Value float64 `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSearchResultRankSignalsCustomSignal) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSearchResultRankSignalsCustomSignal
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1SearchResponseSearchResultRankSignalsCustomSignal) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSearchResultRankSignalsCustomSignal
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

// GoogleCloudDiscoveryengineV1SearchResponseSessionInfo: Information about the
// session.
type GoogleCloudDiscoveryengineV1SearchResponseSessionInfo struct {
	// Name: Name of the session. If the auto-session mode is used (when
	// SearchRequest.session ends with "-"), this field holds the newly generated
	// session name.
	Name string `json:"name,omitempty"`
	// QueryId: Query ID that corresponds to this search API call. One session can
	// have multiple turns, each with a unique query ID. By specifying the session
	// name and this query ID in the Answer API call, the answer generation happens
	// in the context of the search results from this search call.
	QueryId string `json:"queryId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSessionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSessionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseSummary: Summary of the top N
// search results specified by the summary spec.
type GoogleCloudDiscoveryengineV1SearchResponseSummary struct {
	// SafetyAttributes: A collection of Safety Attribute categories and their
	// associated confidence scores.
	SafetyAttributes *GoogleCloudDiscoveryengineV1SearchResponseSummarySafetyAttributes `json:"safetyAttributes,omitempty"`
	// SummarySkippedReasons: Additional summary-skipped reasons. This provides the
	// reason for ignored cases. If nothing is skipped, this field is not set.
	//
	// Possible values:
	//   "SUMMARY_SKIPPED_REASON_UNSPECIFIED" - Default value. The summary skipped
	// reason is not specified.
	//   "ADVERSARIAL_QUERY_IGNORED" - The adversarial query ignored case. Only
	// used when SummarySpec.ignore_adversarial_query is set to `true`.
	//   "NON_SUMMARY_SEEKING_QUERY_IGNORED" - The non-summary seeking query
	// ignored case. Google skips the summary if the query is chit chat. Only used
	// when SummarySpec.ignore_non_summary_seeking_query is set to `true`.
	//   "OUT_OF_DOMAIN_QUERY_IGNORED" - The out-of-domain query ignored case.
	// Google skips the summary if there are no high-relevance search results. For
	// example, the data store contains facts about company A but the user query is
	// asking questions about company B.
	//   "POTENTIAL_POLICY_VIOLATION" - The potential policy violation case. Google
	// skips the summary if there is a potential policy violation detected. This
	// includes content that may be violent or toxic.
	//   "LLM_ADDON_NOT_ENABLED" - The LLM addon not enabled case. Google skips the
	// summary if the LLM addon is not enabled.
	//   "NO_RELEVANT_CONTENT" - The no relevant content case. Google skips the
	// summary if there is no relevant content in the retrieved search results.
	//   "JAIL_BREAKING_QUERY_IGNORED" - The jail-breaking query ignored case. For
	// example, "Reply in the tone of a competing company's CEO". Only used when
	// [SearchRequest.ContentSearchSpec.SummarySpec.ignore_jail_breaking_query] is
	// set to `true`.
	//   "CUSTOMER_POLICY_VIOLATION" - The customer policy violation case. Google
	// skips the summary if there is a customer policy violation detected. The
	// policy is defined by the customer.
	//   "NON_SUMMARY_SEEKING_QUERY_IGNORED_V2" - The non-answer seeking query
	// ignored case. Google skips the summary if the query doesn't have clear
	// intent. Only used when
	// [SearchRequest.ContentSearchSpec.SummarySpec.ignore_non_answer_seeking_query]
	//  is set to `true`.
	//   "TIME_OUT" - The time out case. Google skips the summary if the time out.
	SummarySkippedReasons []string `json:"summarySkippedReasons,omitempty"`
	// SummaryText: The summary content.
	SummaryText string `json:"summaryText,omitempty"`
	// SummaryWithMetadata: Summary with metadata information.
	SummaryWithMetadata *GoogleCloudDiscoveryengineV1SearchResponseSummarySummaryWithMetadata `json:"summaryWithMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SafetyAttributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SafetyAttributes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseSummaryCitation: Citation info for
// a segment.
type GoogleCloudDiscoveryengineV1SearchResponseSummaryCitation struct {
	// EndIndex: End of the attributed segment, exclusive.
	EndIndex int64 `json:"endIndex,omitempty,string"`
	// Sources: Citation sources for the attributed segment.
	Sources []*GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationSource `json:"sources,omitempty"`
	// StartIndex: Index indicates the start of the segment, measured in
	// bytes/unicode.
	StartIndex int64 `json:"startIndex,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSummaryCitation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSummaryCitation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationMetadata: Citation
// metadata.
type GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationMetadata struct {
	// Citations: Citations for segments.
	Citations []*GoogleCloudDiscoveryengineV1SearchResponseSummaryCitation `json:"citations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Citations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Citations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationSource: Citation
// source.
type GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationSource struct {
	// ReferenceIndex: Document reference index from
	// SummaryWithMetadata.references. It is 0-indexed and the value will be zero
	// if the reference_index is not set explicitly.
	ReferenceIndex int64 `json:"referenceIndex,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ReferenceIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReferenceIndex") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseSummaryReference: Document
// reference.
type GoogleCloudDiscoveryengineV1SearchResponseSummaryReference struct {
	// ChunkContents: List of cited chunk contents derived from document content.
	ChunkContents []*GoogleCloudDiscoveryengineV1SearchResponseSummaryReferenceChunkContent `json:"chunkContents,omitempty"`
	// Document: Required. Document.name of the document. Full resource name of the
	// referenced document, in the format
	// `projects/*/locations/*/collections/*/dataStores/*/branches/*/documents/*`.
	Document string `json:"document,omitempty"`
	// Title: Title of the document.
	Title string `json:"title,omitempty"`
	// Uri: Cloud Storage or HTTP uri for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkContents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSummaryReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSummaryReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseSummaryReferenceChunkContent:
// Chunk content.
type GoogleCloudDiscoveryengineV1SearchResponseSummaryReferenceChunkContent struct {
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSummaryReferenceChunkContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSummaryReferenceChunkContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchResponseSummarySafetyAttributes: Safety
// Attribute categories and their associated confidence scores.
type GoogleCloudDiscoveryengineV1SearchResponseSummarySafetyAttributes struct {
	// Categories: The display names of Safety Attribute categories associated with
	// the generated content. Order matches the Scores.
	Categories []string `json:"categories,omitempty"`
	// Scores: The confidence scores of the each category, higher value means
	// higher confidence. Order matches the Categories.
	Scores []float64 `json:"scores,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Categories") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Categories") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSummarySafetyAttributes) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSummarySafetyAttributes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1SearchResponseSummarySafetyAttributes) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSummarySafetyAttributes
	var s1 struct {
		Scores []gensupport.JSONFloat64 `json:"scores"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Scores = make([]float64, len(s1.Scores))
	for i := range s1.Scores {
		s.Scores[i] = float64(s1.Scores[i])
	}
	return nil
}

// GoogleCloudDiscoveryengineV1SearchResponseSummarySummaryWithMetadata:
// Summary with metadata information.
type GoogleCloudDiscoveryengineV1SearchResponseSummarySummaryWithMetadata struct {
	// CitationMetadata: Citation metadata for given summary.
	CitationMetadata *GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationMetadata `json:"citationMetadata,omitempty"`
	// References: Document References.
	References []*GoogleCloudDiscoveryengineV1SearchResponseSummaryReference `json:"references,omitempty"`
	// Summary: Summary text with no citation information.
	Summary string `json:"summary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchResponseSummarySummaryWithMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchResponseSummarySummaryWithMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ServingConfig: Configures metadata that is used
// to generate serving time results (e.g. search results or recommendation
// predictions). The ServingConfig is passed in the search and predict request
// and generates results.
type GoogleCloudDiscoveryengineV1ServingConfig struct {
	// AnswerGenerationSpec: Optional. The specification for answer generation.
	AnswerGenerationSpec *GoogleCloudDiscoveryengineV1AnswerGenerationSpec `json:"answerGenerationSpec,omitempty"`
	// BoostControlIds: Boost controls to use in serving path. All triggered boost
	// controls will be applied. Boost controls must be in the same data store as
	// the serving config. Maximum of 20 boost controls.
	BoostControlIds []string `json:"boostControlIds,omitempty"`
	// CreateTime: Output only. ServingConfig created timestamp.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. The human readable serving config display name. Used
	// in Discovery UI. This field must be a UTF-8 encoded string with a length
	// limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.
	DisplayName string `json:"displayName,omitempty"`
	// DissociateControlIds: Condition do not associate specifications. If multiple
	// do not associate conditions match, all matching do not associate controls in
	// the list will execute. Order does not matter. Maximum number of
	// specifications is 100. Can only be set if SolutionType is
	// SOLUTION_TYPE_SEARCH.
	DissociateControlIds []string `json:"dissociateControlIds,omitempty"`
	// DiversityLevel: How much diversity to use in recommendation model results
	// e.g. `medium-diversity` or `high-diversity`. Currently supported values: *
	// `no-diversity` * `low-diversity` * `medium-diversity` * `high-diversity` *
	// `auto-diversity` If not specified, we choose default based on recommendation
	// model type. Default value: `no-diversity`. Can only be set if SolutionType
	// is SOLUTION_TYPE_RECOMMENDATION.
	DiversityLevel string `json:"diversityLevel,omitempty"`
	// FilterControlIds: Filter controls to use in serving path. All triggered
	// filter controls will be applied. Filter controls must be in the same data
	// store as the serving config. Maximum of 20 filter controls.
	FilterControlIds []string `json:"filterControlIds,omitempty"`
	// GenericConfig: The GenericConfig of the serving configuration.
	GenericConfig *GoogleCloudDiscoveryengineV1ServingConfigGenericConfig `json:"genericConfig,omitempty"`
	// IgnoreControlIds: Condition ignore specifications. If multiple ignore
	// conditions match, all matching ignore controls in the list will execute.
	// Order does not matter. Maximum number of specifications is 100.
	IgnoreControlIds []string `json:"ignoreControlIds,omitempty"`
	// MediaConfig: The MediaConfig of the serving configuration.
	MediaConfig *GoogleCloudDiscoveryengineV1ServingConfigMediaConfig `json:"mediaConfig,omitempty"`
	// ModelId: The id of the model to use at serving time. Currently only
	// RecommendationModels are supported. Can be changed but only to a compatible
	// model (e.g. others-you-may-like CTR to others-you-may-like CVR). Required
	// when SolutionType is SOLUTION_TYPE_RECOMMENDATION.
	ModelId string `json:"modelId,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/{project}/locations/{location}/collections/{collection_id}/engines/
	// {engine_id}/servingConfigs/{serving_config_id}`
	Name string `json:"name,omitempty"`
	// OnewaySynonymsControlIds: Condition oneway synonyms specifications. If
	// multiple oneway synonyms conditions match, all matching oneway synonyms
	// controls in the list will execute. Maximum number of specifications is 100.
	// Can only be set if SolutionType is SOLUTION_TYPE_SEARCH.
	OnewaySynonymsControlIds []string `json:"onewaySynonymsControlIds,omitempty"`
	// PromoteControlIds: Condition promote specifications. Maximum number of
	// specifications is 100.
	PromoteControlIds []string `json:"promoteControlIds,omitempty"`
	// RankingExpression: The ranking expression controls the customized ranking on
	// retrieval documents. To leverage this, document embedding is required. The
	// ranking expression setting in ServingConfig applies to all search requests
	// served by the serving config. However, if `SearchRequest.ranking_expression`
	// is specified, it overrides the ServingConfig ranking expression. The ranking
	// expression is a single function or multiple functions that are joined by
	// "+". * ranking_expression = function, { " + ", function }; Supported
	// functions: * double * relevance_score * double *
	// dotProduct(embedding_field_path) Function variables: * `relevance_score`:
	// pre-defined keywords, used for measure relevance between query and document.
	// * `embedding_field_path`: the document embedding field used with query
	// embedding vector. * `dotProduct`: embedding function between
	// embedding_field_path and query embedding vector. Example ranking expression:
	// If document has an embedding field doc_embedding, the ranking expression
	// could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
	RankingExpression string `json:"rankingExpression,omitempty"`
	// RedirectControlIds: IDs of the redirect controls. Only the first triggered
	// redirect action is applied, even if multiple apply. Maximum number of
	// specifications is 100. Can only be set if SolutionType is
	// SOLUTION_TYPE_SEARCH.
	RedirectControlIds []string `json:"redirectControlIds,omitempty"`
	// ReplacementControlIds: Condition replacement specifications. Applied
	// according to the order in the list. A previously replaced term can not be
	// re-replaced. Maximum number of specifications is 100. Can only be set if
	// SolutionType is SOLUTION_TYPE_SEARCH.
	ReplacementControlIds []string `json:"replacementControlIds,omitempty"`
	// SolutionType: Required. Immutable. Specifies the solution type that a
	// serving config can be associated with.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionType string `json:"solutionType,omitempty"`
	// SynonymsControlIds: Condition synonyms specifications. If multiple synonyms
	// conditions match, all matching synonyms controls in the list will execute.
	// Maximum number of specifications is 100. Can only be set if SolutionType is
	// SOLUTION_TYPE_SEARCH.
	SynonymsControlIds []string `json:"synonymsControlIds,omitempty"`
	// UpdateTime: Output only. ServingConfig updated timestamp.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnswerGenerationSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerGenerationSpec") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ServingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ServingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ServingConfigGenericConfig: Specifies the
// configurations needed for Generic Discovery.Currently we support: *
// `content_search_spec`: configuration for generic content search.
type GoogleCloudDiscoveryengineV1ServingConfigGenericConfig struct {
	// ContentSearchSpec: Specifies the expected behavior of content search. Only
	// valid for content-search enabled data store.
	ContentSearchSpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpec `json:"contentSearchSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentSearchSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentSearchSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ServingConfigGenericConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ServingConfigGenericConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ServingConfigMediaConfig: Specifies the
// configurations needed for Media Discovery. Currently we support: *
// `demote_content_watched`: Threshold for watched content demotion. Customers
// can specify if using watched content demotion or use viewed detail page.
// Using the content watched demotion, customers need to specify the watched
// minutes or percentage exceeds the threshold, the content will be demoted in
// the recommendation result. * `promote_fresh_content`: cutoff days for fresh
// content promotion. Customers can specify if using content freshness
// promotion. If the content was published within the cutoff days, the content
// will be promoted in the recommendation result. Can only be set if
// SolutionType is SOLUTION_TYPE_RECOMMENDATION.
type GoogleCloudDiscoveryengineV1ServingConfigMediaConfig struct {
	// ContentFreshnessCutoffDays: Specifies the content freshness used for
	// recommendation result. Contents will be demoted if contents were published
	// for more than content freshness cutoff days.
	ContentFreshnessCutoffDays int64 `json:"contentFreshnessCutoffDays,omitempty"`
	// ContentWatchedPercentageThreshold: Specifies the content watched percentage
	// threshold for demotion. Threshold value must be between [0, 1.0] inclusive.
	ContentWatchedPercentageThreshold float64 `json:"contentWatchedPercentageThreshold,omitempty"`
	// ContentWatchedSecondsThreshold: Specifies the content watched minutes
	// threshold for demotion.
	ContentWatchedSecondsThreshold float64 `json:"contentWatchedSecondsThreshold,omitempty"`
	// DemoteContentWatchedPastDays: Optional. Specifies the number of days to look
	// back for demoting watched content. If set to zero or unset, defaults to the
	// maximum of 365 days.
	DemoteContentWatchedPastDays int64 `json:"demoteContentWatchedPastDays,omitempty"`
	// DemotionEventType: Specifies the event type used for demoting recommendation
	// result. Currently supported values: * `view-item`: Item viewed. *
	// `media-play`: Start/resume watching a video, playing a song, etc. *
	// `media-complete`: Finished or stopped midway through a video, song, etc. If
	// unset, watch history demotion will not be applied. Content freshness
	// demotion will still be applied.
	DemotionEventType string `json:"demotionEventType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentFreshnessCutoffDays")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentFreshnessCutoffDays") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ServingConfigMediaConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ServingConfigMediaConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1ServingConfigMediaConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1ServingConfigMediaConfig
	var s1 struct {
		ContentWatchedPercentageThreshold gensupport.JSONFloat64 `json:"contentWatchedPercentageThreshold"`
		ContentWatchedSecondsThreshold    gensupport.JSONFloat64 `json:"contentWatchedSecondsThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ContentWatchedPercentageThreshold = float64(s1.ContentWatchedPercentageThreshold)
	s.ContentWatchedSecondsThreshold = float64(s1.ContentWatchedSecondsThreshold)
	return nil
}

// GoogleCloudDiscoveryengineV1Session: External session proto definition.
type GoogleCloudDiscoveryengineV1Session struct {
	// DisplayName: Optional. The display name of the session. This field is used
	// to identify the session in the UI. By default, the display name is the first
	// turn query text in the session.
	DisplayName string `json:"displayName,omitempty"`
	// EndTime: Output only. The time the session finished.
	EndTime string `json:"endTime,omitempty"`
	// IsPinned: Optional. Whether the session is pinned, pinned session will be
	// displayed on the top of the session list.
	IsPinned bool `json:"isPinned,omitempty"`
	// Labels: Optional. The labels for the session. Can be set as filter in
	// ListSessionsRequest.
	Labels []string `json:"labels,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/{project}/locations/global/collections/{collection}/engines/{engine
	// }/sessions/*`
	Name string `json:"name,omitempty"`
	// StartTime: Output only. The time the session started.
	StartTime string `json:"startTime,omitempty"`
	// State: The state of the session.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is unspecified.
	//   "IN_PROGRESS" - The session is currently open.
	State string `json:"state,omitempty"`
	// Turns: Turns.
	Turns []*GoogleCloudDiscoveryengineV1SessionTurn `json:"turns,omitempty"`
	// UserPseudoId: A unique identifier for tracking users.
	UserPseudoId string `json:"userPseudoId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Session) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Session
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SessionTurn: Represents a turn, including a
// query from the user and a answer from service.
type GoogleCloudDiscoveryengineV1SessionTurn struct {
	// Answer: Optional. The resource name of the answer to the user query. Only
	// set if the answer generation (/answer API call) happened in this turn.
	Answer string `json:"answer,omitempty"`
	// DetailedAnswer: Output only. In ConversationalSearchService.GetSession API,
	// if GetSessionRequest.include_answer_details is set to true, this field will
	// be populated when getting answer query session.
	DetailedAnswer *GoogleCloudDiscoveryengineV1Answer `json:"detailedAnswer,omitempty"`
	// DetailedAssistAnswer: Output only. In ConversationalSearchService.GetSession
	// API, if GetSessionRequest.include_answer_details is set to true, this field
	// will be populated when getting assistant session.
	DetailedAssistAnswer *GoogleCloudDiscoveryengineV1AssistAnswer `json:"detailedAssistAnswer,omitempty"`
	// Query: Optional. The user query. May not be set if this turn is merely
	// regenerating an answer to a different turn
	Query *GoogleCloudDiscoveryengineV1Query `json:"query,omitempty"`
	// QueryConfig: Optional. Represents metadata related to the query config, for
	// example LLM model and version used, model parameters (temperature, grounding
	// parameters, etc.). The prefix "google." is reserved for Google-developed
	// functionality.
	QueryConfig map[string]string `json:"queryConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SessionTurn) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SessionTurn
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SetUpDataConnectorMetadata: Metadata for
// DataConnectorService.SetUpDataConnector method.
type GoogleCloudDiscoveryengineV1SetUpDataConnectorMetadata struct {
}

// GoogleCloudDiscoveryengineV1SetUpDataConnectorRequest: Request for
// DataConnectorService.SetUpDataConnector method.
type GoogleCloudDiscoveryengineV1SetUpDataConnectorRequest struct {
	// CollectionDisplayName: Required. The display name of the Collection. Should
	// be human readable, used to display collections in the Console Dashboard.
	// UTF-8 encoded string with limit of 1024 characters.
	CollectionDisplayName string `json:"collectionDisplayName,omitempty"`
	// CollectionId: Required. The ID to use for the Collection, which will become
	// the final component of the Collection's resource name. A new Collection is
	// created as part of the DataConnector setup. DataConnector is a singleton
	// resource under Collection, managing all DataStores of the Collection. This
	// field must conform to RFC-1034 (https://tools.ietf.org/html/rfc1034)
	// standard with a length limit of 63 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	CollectionId string `json:"collectionId,omitempty"`
	// DataConnector: Required. The DataConnector to initialize in the newly
	// created Collection.
	DataConnector *GoogleCloudDiscoveryengineV1DataConnector `json:"dataConnector,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CollectionDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CollectionDisplayName") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SetUpDataConnectorRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SetUpDataConnectorRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SingleRegionKey: Metadata for single-regional
// CMEKs.
type GoogleCloudDiscoveryengineV1SingleRegionKey struct {
	// KmsKey: Required. Single-regional kms key resource name which will be used
	// to encrypt resources
	// `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId
	// }`.
	KmsKey string `json:"kmsKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SingleRegionKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SingleRegionKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SiteSearchEngine: SiteSearchEngine captures
// DataStore level site search persisting configurations. It is a singleton
// value per data store.
type GoogleCloudDiscoveryengineV1SiteSearchEngine struct {
	// Name: The fully qualified resource name of the site search engine. Format:
	// `projects/*/locations/*/dataStores/*/siteSearchEngine`
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SiteSearchEngine) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SiteSearchEngine
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SiteVerificationInfo: Verification information
// for target sites in advanced site search.
type GoogleCloudDiscoveryengineV1SiteVerificationInfo struct {
	// SiteVerificationState: Site verification state indicating the ownership and
	// validity.
	//
	// Possible values:
	//   "SITE_VERIFICATION_STATE_UNSPECIFIED" - Defaults to VERIFIED.
	//   "VERIFIED" - Site ownership verified.
	//   "UNVERIFIED" - Site ownership pending verification or verification failed.
	//   "EXEMPTED" - Site exempt from verification, e.g., a public website that
	// opens to all.
	SiteVerificationState string `json:"siteVerificationState,omitempty"`
	// VerifyTime: Latest site verification time.
	VerifyTime string `json:"verifyTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SiteVerificationState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SiteVerificationState") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SiteVerificationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SiteVerificationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Sitemap: A sitemap for the SiteSearchEngine.
type GoogleCloudDiscoveryengineV1Sitemap struct {
	// CreateTime: Output only. The sitemap's creation time.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Output only. The fully qualified resource name of the sitemap.
	// `projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine/sitemaps/
	// *` The `sitemap_id` suffix is system-generated.
	Name string `json:"name,omitempty"`
	// Uri: Public URI for the sitemap, e.g. `www.example.com/sitemap.xml`.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Sitemap) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Sitemap
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SpannerSource: The Spanner source for importing
// data
type GoogleCloudDiscoveryengineV1SpannerSource struct {
	// DatabaseId: Required. The database ID of the source Spanner table.
	DatabaseId string `json:"databaseId,omitempty"`
	// EnableDataBoost: Whether to apply data boost on Spanner export. Enabling
	// this option will incur additional cost. More info can be found here
	// (https://cloud.google.com/spanner/docs/databoost/databoost-overview#billing_and_quotas).
	EnableDataBoost bool `json:"enableDataBoost,omitempty"`
	// InstanceId: Required. The instance ID of the source Spanner table.
	InstanceId string `json:"instanceId,omitempty"`
	// ProjectId: The project ID that contains the Spanner source. Has a length
	// limit of 128 characters. If not specified, inherits the project ID from the
	// parent request.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Required. The table name of the Spanner database that needs to be
	// imported.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatabaseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatabaseId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SpannerSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SpannerSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1StreamAssistRequest: Request for the
// AssistantService.StreamAssist method.
type GoogleCloudDiscoveryengineV1StreamAssistRequest struct {
	// GenerationSpec: Optional. Specification of the generation configuration for
	// the request.
	GenerationSpec *GoogleCloudDiscoveryengineV1StreamAssistRequestGenerationSpec `json:"generationSpec,omitempty"`
	// Query: Optional. Current user query. Empty query is only supported if
	// `file_ids` are provided. In this case, the answer will be generated based on
	// those context files.
	Query *GoogleCloudDiscoveryengineV1Query `json:"query,omitempty"`
	// Session: Optional. The session to use for the request. If specified, the
	// assistant has access to the session history, and the query and the answer
	// are stored there. If `-` is specified as the session ID, or it is left
	// empty, then a new session is created with an automatically generated ID.
	// Format:
	// `projects/{project}/locations/{location}/collections/{collection}/engines/{en
	// gine}/sessions/{session}`
	Session string `json:"session,omitempty"`
	// ToolsSpec: Optional. Specification of tools that are used to serve the
	// request.
	ToolsSpec *GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpec `json:"toolsSpec,omitempty"`
	// UserMetadata: Optional. Information about the user initiating the query.
	UserMetadata *GoogleCloudDiscoveryengineV1AssistUserMetadata `json:"userMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenerationSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenerationSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1StreamAssistRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1StreamAssistRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1StreamAssistRequestGenerationSpec: Assistant
// generation specification for the request. This allows to override the
// default generation configuration at the engine level.
type GoogleCloudDiscoveryengineV1StreamAssistRequestGenerationSpec struct {
	// ModelId: Optional. The Vertex AI model_id used for the generative model. If
	// not set, the default Assistant model will be used.
	ModelId string `json:"modelId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1StreamAssistRequestGenerationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1StreamAssistRequestGenerationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpec: Specification of
// tools that are used to serve the request.
type GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpec struct {
	// ImageGenerationSpec: Optional. Specification of the image generation tool.
	ImageGenerationSpec *GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecImageGenerationSpec `json:"imageGenerationSpec,omitempty"`
	// VertexAiSearchSpec: Optional. Specification of the Vertex AI Search tool.
	VertexAiSearchSpec *GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecVertexAiSearchSpec `json:"vertexAiSearchSpec,omitempty"`
	// VideoGenerationSpec: Optional. Specification of the video generation tool.
	VideoGenerationSpec *GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecVideoGenerationSpec `json:"videoGenerationSpec,omitempty"`
	// WebGroundingSpec: Optional. Specification of the web grounding tool. If
	// field is present, enables grounding with web search. Works only if
	// Assistant.web_grounding_type is WEB_GROUNDING_TYPE_GOOGLE_SEARCH or
	// WEB_GROUNDING_TYPE_ENTERPRISE_WEB_SEARCH.
	WebGroundingSpec *GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecWebGroundingSpec `json:"webGroundingSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageGenerationSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageGenerationSpec") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecImageGenerationSpec:
// Specification of the image generation tool.
type GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecImageGenerationSpec struct {
}

// GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecVertexAiSearchSpec:
// Specification of the Vertex AI Search tool.
type GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecVertexAiSearchSpec struct {
	// DataStoreSpecs: Optional. Specs defining DataStores to filter on in a search
	// call and configurations for those data stores. This is only considered for
	// Engines with multiple data stores.
	DataStoreSpecs []*GoogleCloudDiscoveryengineV1SearchRequestDataStoreSpec `json:"dataStoreSpecs,omitempty"`
	// Filter: Optional. The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the documents being
	// filtered. Filter expression is case-sensitive. If this field is
	// unrecognizable, an `INVALID_ARGUMENT` is returned. Filtering in Vertex AI
	// Search is done by mapping the LHS filter key to a key property defined in
	// the Vertex AI Search backend -- this mapping is defined by the customer in
	// their schema. For example a media customer might have a field 'name' in
	// their schema. In this case the filter would look like this: filter -->
	// name:'ANY("king kong")' For more information about filtering including
	// syntax and filter operators, see Filter
	// (https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStoreSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStoreSpecs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecVertexAiSearchSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecVertexAiSearchSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecVideoGenerationSpec:
// Specification of the video generation tool.
type GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecVideoGenerationSpec struct {
}

// GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecWebGroundingSpec:
// Specification of the web grounding tool.
type GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecWebGroundingSpec struct {
}

// GoogleCloudDiscoveryengineV1StreamAssistResponse: Response for the
// AssistantService.StreamAssist method.
type GoogleCloudDiscoveryengineV1StreamAssistResponse struct {
	// Answer: Assist answer resource object containing parts of the assistant's
	// final answer for the user's query. Not present if the current response
	// doesn't add anything to previously sent AssistAnswer.replies. Observe
	// AssistAnswer.state to see if more parts are to be expected. While the state
	// is `IN_PROGRESS`, the AssistAnswer.replies field in each response will
	// contain replies (reply fragments) to be appended to the ones received in
	// previous responses. AssistAnswer.name won't be filled. If the state is
	// `SUCCEEDED`, `FAILED` or `SKIPPED`, the response is the last response and
	// AssistAnswer.name will have a value.
	Answer *GoogleCloudDiscoveryengineV1AssistAnswer `json:"answer,omitempty"`
	// AssistToken: A global unique ID that identifies the current pair of request
	// and stream of responses. Used for feedback and support.
	AssistToken string `json:"assistToken,omitempty"`
	// SessionInfo: Session information. Only included in the final
	// StreamAssistResponse of the response stream.
	SessionInfo *GoogleCloudDiscoveryengineV1StreamAssistResponseSessionInfo `json:"sessionInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1StreamAssistResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1StreamAssistResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1StreamAssistResponseSessionInfo: Information
// about the session.
type GoogleCloudDiscoveryengineV1StreamAssistResponseSessionInfo struct {
	// Session: Name of the newly generated or continued session. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/engines/{en
	// gine}/sessions/{session}`.
	Session string `json:"session,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Session") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Session") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1StreamAssistResponseSessionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1StreamAssistResponseSessionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SuggestionDenyListEntry: Suggestion deny list
// entry identifying the phrase to block from suggestions and the applied
// operation for the phrase.
type GoogleCloudDiscoveryengineV1SuggestionDenyListEntry struct {
	// BlockPhrase: Required. Phrase to block from suggestions served. Can be
	// maximum 125 characters.
	BlockPhrase string `json:"blockPhrase,omitempty"`
	// MatchOperator: Required. The match operator to apply for this phrase.
	// Whether to block the exact phrase, or block any suggestions containing this
	// phrase.
	//
	// Possible values:
	//   "MATCH_OPERATOR_UNSPECIFIED" - Default value. Should not be used
	//   "EXACT_MATCH" - If the suggestion is an exact match to the block_phrase,
	// then block it.
	//   "CONTAINS" - If the suggestion contains the block_phrase, then block it.
	MatchOperator string `json:"matchOperator,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlockPhrase") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockPhrase") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SuggestionDenyListEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SuggestionDenyListEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1TargetSite: A target site for the
// SiteSearchEngine.
type GoogleCloudDiscoveryengineV1TargetSite struct {
	// ExactMatch: Immutable. If set to false, a uri_pattern is generated to
	// include all pages whose address contains the provided_uri_pattern. If set to
	// true, an uri_pattern is generated to try to be an exact match of the
	// provided_uri_pattern or just the specific page if the provided_uri_pattern
	// is a specific one. provided_uri_pattern is always normalized to generate the
	// URI pattern to be used by the search engine.
	ExactMatch bool `json:"exactMatch,omitempty"`
	// FailureReason: Output only. Failure reason.
	FailureReason *GoogleCloudDiscoveryengineV1TargetSiteFailureReason `json:"failureReason,omitempty"`
	// GeneratedUriPattern: Output only. This is system-generated based on the
	// provided_uri_pattern.
	GeneratedUriPattern string `json:"generatedUriPattern,omitempty"`
	// IndexingStatus: Output only. Indexing status.
	//
	// Possible values:
	//   "INDEXING_STATUS_UNSPECIFIED" - Defaults to SUCCEEDED.
	//   "PENDING" - The target site is in the update queue and will be picked up
	// by indexing pipeline.
	//   "FAILED" - The target site fails to be indexed.
	//   "SUCCEEDED" - The target site has been indexed.
	//   "DELETING" - The previously indexed target site has been marked to be
	// deleted. This is a transitioning state which will resulted in either: 1.
	// target site deleted if unindexing is successful; 2. state reverts to
	// SUCCEEDED if the unindexing fails.
	//   "CANCELLABLE" - The target site change is pending but cancellable.
	//   "CANCELLED" - The target site change is cancelled.
	IndexingStatus string `json:"indexingStatus,omitempty"`
	// Name: Output only. The fully qualified resource name of the target site.
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/siteSearchEngine/targetSites/{target_site}` The
	// `target_site_id` is system-generated.
	Name string `json:"name,omitempty"`
	// ProvidedUriPattern: Required. Input only. The user provided URI pattern from
	// which the `generated_uri_pattern` is generated.
	ProvidedUriPattern string `json:"providedUriPattern,omitempty"`
	// RootDomainUri: Output only. Root domain of the provided_uri_pattern.
	RootDomainUri string `json:"rootDomainUri,omitempty"`
	// SiteVerificationInfo: Output only. Site ownership and validity verification
	// status.
	SiteVerificationInfo *GoogleCloudDiscoveryengineV1SiteVerificationInfo `json:"siteVerificationInfo,omitempty"`
	// Type: The type of the target site, e.g., whether the site is to be included
	// or excluded.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - This value is unused. In this case, server behavior
	// defaults to Type.INCLUDE.
	//   "INCLUDE" - Include the target site.
	//   "EXCLUDE" - Exclude the target site.
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. The target site's last updated time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ExactMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExactMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1TargetSite) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1TargetSite
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1TargetSiteFailureReason: Site search indexing
// failure reasons.
type GoogleCloudDiscoveryengineV1TargetSiteFailureReason struct {
	// QuotaFailure: Failed due to insufficient quota.
	QuotaFailure *GoogleCloudDiscoveryengineV1TargetSiteFailureReasonQuotaFailure `json:"quotaFailure,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QuotaFailure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuotaFailure") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1TargetSiteFailureReason) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1TargetSiteFailureReason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1TargetSiteFailureReasonQuotaFailure: Failed due
// to insufficient quota.
type GoogleCloudDiscoveryengineV1TargetSiteFailureReasonQuotaFailure struct {
	// TotalRequiredQuota: This number is an estimation on how much total quota
	// this project needs to successfully complete indexing.
	TotalRequiredQuota int64 `json:"totalRequiredQuota,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "TotalRequiredQuota") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TotalRequiredQuota") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1TargetSiteFailureReasonQuotaFailure) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1TargetSiteFailureReasonQuotaFailure
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Tenant: Tenant information for a connector
// source. This includes some of the same information stored in the Credential
// message, but is limited to only what is needed to provide a list of
// accessible tenants to the user.
type GoogleCloudDiscoveryengineV1Tenant struct {
	// DisplayName: Optional display name for the tenant, e.g. "My Slack Team".
	DisplayName string `json:"displayName,omitempty"`
	// Id: The tenant's instance ID. Examples: Jira
	// ("8594f221-9797-5f78-1fa4-485e198d7cd0"), Slack ("T123456").
	Id string `json:"id,omitempty"`
	// Uri: The URI of the tenant, if applicable. For example, the URI of a Jira
	// instance is https://my-jira-instance.atlassian.net, and a Slack tenant does
	// not have a URI.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Tenant) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Tenant
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1TextInput: Defines text input.
type GoogleCloudDiscoveryengineV1TextInput struct {
	// Context: Conversation context of the input.
	Context *GoogleCloudDiscoveryengineV1ConversationContext `json:"context,omitempty"`
	// Input: Text input.
	Input string `json:"input,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Context") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Context") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1TextInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1TextInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1TrainCustomModelMetadata: Metadata related to
// the progress of the TrainCustomModel operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1TrainCustomModelMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1TrainCustomModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1TrainCustomModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1TrainCustomModelRequest: Request message for
// SearchTuningService.TrainCustomModel method.
type GoogleCloudDiscoveryengineV1TrainCustomModelRequest struct {
	// ErrorConfig: The desired location of errors incurred during the data
	// ingestion and training.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`
	// GcsTrainingInput: Cloud Storage training input.
	GcsTrainingInput *GoogleCloudDiscoveryengineV1TrainCustomModelRequestGcsTrainingInput `json:"gcsTrainingInput,omitempty"`
	// ModelId: If not provided, a UUID will be generated.
	ModelId string `json:"modelId,omitempty"`
	// ModelType: Model to be trained. Supported values are: * **search-tuning**:
	// Fine tuning the search system based on data provided.
	ModelType string `json:"modelType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1TrainCustomModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1TrainCustomModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1TrainCustomModelRequestGcsTrainingInput: Cloud
// Storage training data input.
type GoogleCloudDiscoveryengineV1TrainCustomModelRequestGcsTrainingInput struct {
	// CorpusDataPath: The Cloud Storage corpus data which could be associated in
	// train data. The data path format is `gs:///`. A newline delimited
	// jsonl/ndjson file. For search-tuning model, each line should have the _id,
	// title and text. Example: `{"_id": "doc1", title: "relevant doc", "text":
	// "relevant text"}`
	CorpusDataPath string `json:"corpusDataPath,omitempty"`
	// QueryDataPath: The gcs query data which could be associated in train data.
	// The data path format is `gs:///`. A newline delimited jsonl/ndjson file. For
	// search-tuning model, each line should have the _id and text. Example:
	// {"_id": "query1", "text": "example query"}
	QueryDataPath string `json:"queryDataPath,omitempty"`
	// TestDataPath: Cloud Storage test data. Same format as train_data_path. If
	// not provided, a random 80/20 train/test split will be performed on
	// train_data_path.
	TestDataPath string `json:"testDataPath,omitempty"`
	// TrainDataPath: Cloud Storage training data path whose format should be
	// `gs:///`. The file should be in tsv format. Each line should have the doc_id
	// and query_id and score (number). For search-tuning model, it should have the
	// query-id corpus-id score as tsv file header. The score should be a number in
	// `[0, inf+)`. The larger the number is, the more relevant the pair is.
	// Example: * `query-id\tcorpus-id\tscore` * `query1\tdoc1\t1`
	TrainDataPath string `json:"trainDataPath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CorpusDataPath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorpusDataPath") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1TrainCustomModelRequestGcsTrainingInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1TrainCustomModelRequestGcsTrainingInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1TrainCustomModelResponse: Response of the
// TrainCustomModelRequest. This message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1TrainCustomModelResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors in the request
	// if set.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the data.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// Metrics: The metrics of the trained model.
	Metrics map[string]float64 `json:"metrics,omitempty"`
	// ModelName: Fully qualified name of the CustomTuningModel.
	ModelName string `json:"modelName,omitempty"`
	// ModelStatus: The trained model status. Possible values are: * **bad-data**:
	// The training data quality is bad. * **no-improvement**: Tuning didn't
	// improve performance. Won't deploy. * **in-progress**: Model training job
	// creation is in progress. * **training**: Model is actively training. *
	// **evaluating**: The model is evaluating trained metrics. * **indexing**: The
	// model trained metrics are indexing. * **ready**: The model is ready for
	// serving.
	ModelStatus string `json:"modelStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1TrainCustomModelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1TrainCustomModelResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1TransactionInfo: A transaction represents the
// entire purchase transaction.
type GoogleCloudDiscoveryengineV1TransactionInfo struct {
	// Cost: All the costs associated with the products. These can be manufacturing
	// costs, shipping expenses not borne by the end user, or any other costs, such
	// that: * Profit = value - tax - cost
	Cost float64 `json:"cost,omitempty"`
	// Currency: Required. Currency code. Use three-character ISO-4217 code.
	Currency string `json:"currency,omitempty"`
	// DiscountValue: The total discount(s) value applied to this transaction. This
	// figure should be excluded from TransactionInfo.value For example, if a user
	// paid TransactionInfo.value amount, then nominal (pre-discount) value of the
	// transaction is the sum of TransactionInfo.value and
	// TransactionInfo.discount_value This means that profit is calculated the same
	// way, regardless of the discount value, and that
	// TransactionInfo.discount_value can be larger than TransactionInfo.value: *
	// Profit = value - tax - cost
	DiscountValue float64 `json:"discountValue,omitempty"`
	// Tax: All the taxes associated with the transaction.
	Tax float64 `json:"tax,omitempty"`
	// TransactionId: The transaction ID with a length limit of 128 characters.
	TransactionId string `json:"transactionId,omitempty"`
	// Value: Required. Total non-zero value associated with the transaction. This
	// value may include shipping, tax, or other adjustments to the total value
	// that you want to include.
	Value float64 `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cost") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1TransactionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1TransactionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1TransactionInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1TransactionInfo
	var s1 struct {
		Cost          gensupport.JSONFloat64 `json:"cost"`
		DiscountValue gensupport.JSONFloat64 `json:"discountValue"`
		Tax           gensupport.JSONFloat64 `json:"tax"`
		Value         gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Cost = float64(s1.Cost)
	s.DiscountValue = float64(s1.DiscountValue)
	s.Tax = float64(s1.Tax)
	s.Value = float64(s1.Value)
	return nil
}

// GoogleCloudDiscoveryengineV1UpdateCmekConfigMetadata: Metadata related to
// the progress of the CmekConfigService.UpdateCmekConfig operation. This will
// be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1UpdateCmekConfigMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1UpdateCmekConfigMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1UpdateCmekConfigMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1UpdateSchemaMetadata: Metadata for UpdateSchema
// LRO.
type GoogleCloudDiscoveryengineV1UpdateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1UpdateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1UpdateSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1UpdateTargetSiteMetadata: Metadata related to
// the progress of the SiteSearchEngineService.UpdateTargetSite operation. This
// will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1UpdateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1UpdateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1UpdateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1UserEvent: UserEvent captures all metadata
// information Discovery Engine API needs to know about how end users interact
// with your website.
type GoogleCloudDiscoveryengineV1UserEvent struct {
	// Attributes: Extra user event features to include in the recommendation
	// model. These attributes must NOT contain data that needs to be parsed or
	// processed further, e.g. JSON or other encodings. If you provide custom
	// attributes for ingested user events, also include them in the user events
	// that you associate with prediction requests. Custom attribute formatting
	// must be consistent between imported events and events provided with
	// prediction requests. This lets the Discovery Engine API use those custom
	// attributes when training models and serving predictions, which helps improve
	// recommendation quality. This field needs to pass all below criteria,
	// otherwise an `INVALID_ARGUMENT` error is returned: * The key must be a UTF-8
	// encoded string with a length limit of 5,000 characters. * For text
	// attributes, at most 400 values are allowed. Empty values are not allowed.
	// Each value must be a UTF-8 encoded string with a length limit of 256
	// characters. * For number attributes, at most 400 values are allowed. For
	// product recommendations, an example of extra user information is
	// `traffic_channel`, which is how a user arrives at the site. Users can arrive
	// at the site by coming to the site directly, coming through Google search, or
	// in other ways.
	Attributes map[string]GoogleCloudDiscoveryengineV1CustomAttribute `json:"attributes,omitempty"`
	// AttributionToken: Token to attribute an API response to user action(s) to
	// trigger the event. Highly recommended for user events that are the result of
	// RecommendationService.Recommend. This field enables accurate attribution of
	// recommendation model performance. The value must be one of: *
	// RecommendResponse.attribution_token for events that are the result of
	// RecommendationService.Recommend. * SearchResponse.attribution_token for
	// events that are the result of SearchService.Search. This token enables us to
	// accurately attribute page view or conversion completion back to the event
	// and the particular predict response containing this clicked/purchased
	// product. If user clicks on product K in the recommendation results, pass
	// RecommendResponse.attribution_token as a URL parameter to product K's page.
	// When recording events on product K's page, log the
	// RecommendResponse.attribution_token to this field.
	AttributionToken string `json:"attributionToken,omitempty"`
	// CompletionInfo: CompletionService.CompleteQuery details related to the
	// event. This field should be set for `search` event when autocomplete
	// function is enabled and the user clicks a suggestion for search.
	CompletionInfo *GoogleCloudDiscoveryengineV1CompletionInfo `json:"completionInfo,omitempty"`
	// ConversionType: Optional. Conversion type. Required if UserEvent.event_type
	// is `conversion`. This is a customer-defined conversion name in lowercase
	// letters or numbers separated by "-", such as "watch", "good-visit" etc. Do
	// not set the field if UserEvent.event_type is not `conversion`. This mixes
	// the custom conversion event with predefined events like `search`,
	// `view-item` etc.
	ConversionType string `json:"conversionType,omitempty"`
	// DataStore: The DataStore resource full name, of the form
	// `projects/{project}/locations/{location}/collections/{collection_id}/dataStor
	// es/{data_store_id}`. Optional. Only required for user events whose data
	// store can't by determined by UserEvent.engine or UserEvent.documents. If
	// data store is set in the parent of write/import/collect user event requests,
	// this field can be omitted.
	DataStore string `json:"dataStore,omitempty"`
	// DirectUserRequest: Should set to true if the request is made directly from
	// the end user, in which case the UserEvent.user_info.user_agent can be
	// populated from the HTTP request. This flag should be set only if the API
	// request is made directly from the end user such as a mobile app (and not if
	// a gateway or a server is processing and pushing the user events). This
	// should not be set when using the JavaScript tag in
	// UserEventService.CollectUserEvent.
	DirectUserRequest bool `json:"directUserRequest,omitempty"`
	// Documents: List of Documents associated with this user event. This field is
	// optional except for the following event types: * `view-item` * `add-to-cart`
	// * `purchase` * `media-play` * `media-complete` In a `search` event, this
	// field represents the documents returned to the end user on the current page
	// (the end user may have not finished browsing the whole page yet). When a new
	// page is returned to the end user, after pagination/filtering/ordering even
	// for the same query, a new `search` event with different UserEvent.documents
	// is desired.
	Documents []*GoogleCloudDiscoveryengineV1DocumentInfo `json:"documents,omitempty"`
	// Engine: The Engine resource name, in the form of
	// `projects/{project}/locations/{location}/collections/{collection_id}/engines/
	// {engine_id}`. Optional. Only required for Engine produced user events. For
	// example, user events from blended search.
	Engine string `json:"engine,omitempty"`
	// EventTime: Only required for UserEventService.ImportUserEvents method.
	// Timestamp of when the user event happened.
	EventTime string `json:"eventTime,omitempty"`
	// EventType: Required. User event type. Allowed values are: Generic values: *
	// `search`: Search for Documents. * `view-item`: Detailed page view of a
	// Document. * `view-item-list`: View of a panel or ordered list of Documents.
	// * `view-home-page`: View of the home page. * `view-category-page`: View of a
	// category page, e.g. Home > Men > Jeans Retail-related values: *
	// `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping *
	// `purchase`: Purchase an item(s) Media-related values: * `media-play`:
	// Start/resume watching a video, playing a song, etc. * `media-complete`:
	// Finished or stopped midway through a video, song, etc. Custom conversion
	// value: * `conversion`: Customer defined conversion event.
	EventType string `json:"eventType,omitempty"`
	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the documents being
	// filtered. One example is for `search` events, the associated SearchRequest
	// may contain a filter expression in SearchRequest.filter conforming to
	// https://google.aip.dev/160#filtering. Similarly, for `view-item-list` events
	// that are generated from a RecommendRequest, this field may be populated
	// directly from RecommendRequest.filter conforming to
	// https://google.aip.dev/160#filtering. The value must be a UTF-8 encoded
	// string with a length limit of 1,000 characters. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	Filter string `json:"filter,omitempty"`
	// MediaInfo: Media-specific info.
	MediaInfo *GoogleCloudDiscoveryengineV1MediaInfo `json:"mediaInfo,omitempty"`
	// PageInfo: Page metadata such as categories and other critical information
	// for certain event types such as `view-category-page`.
	PageInfo *GoogleCloudDiscoveryengineV1PageInfo `json:"pageInfo,omitempty"`
	// Panel: Panel metadata associated with this user event.
	Panel *GoogleCloudDiscoveryengineV1PanelInfo `json:"panel,omitempty"`
	// Panels: Optional. List of panels associated with this event. Used for
	// page-level impression data.
	Panels []*GoogleCloudDiscoveryengineV1PanelInfo `json:"panels,omitempty"`
	// PromotionIds: The promotion IDs if this is an event associated with
	// promotions. Currently, this field is restricted to at most one ID.
	PromotionIds []string `json:"promotionIds,omitempty"`
	// SearchInfo: SearchService.Search details related to the event. This field
	// should be set for `search` event.
	SearchInfo *GoogleCloudDiscoveryengineV1SearchInfo `json:"searchInfo,omitempty"`
	// SessionId: A unique identifier for tracking a visitor session with a length
	// limit of 128 bytes. A session is an aggregation of an end user behavior in a
	// time span. A general guideline to populate the session_id: 1. If user has no
	// activity for 30 min, a new session_id should be assigned. 2. The session_id
	// should be unique across users, suggest use uuid or add
	// UserEvent.user_pseudo_id as prefix.
	SessionId string `json:"sessionId,omitempty"`
	// TagIds: A list of identifiers for the independent experiment groups this
	// user event belongs to. This is used to distinguish between user events
	// associated with different experiment setups.
	TagIds []string `json:"tagIds,omitempty"`
	// TransactionInfo: The transaction metadata (if any) associated with this user
	// event.
	TransactionInfo *GoogleCloudDiscoveryengineV1TransactionInfo `json:"transactionInfo,omitempty"`
	// UserInfo: Information about the end user.
	UserInfo *GoogleCloudDiscoveryengineV1UserInfo `json:"userInfo,omitempty"`
	// UserPseudoId: Required. A unique identifier for tracking visitors. For
	// example, this could be implemented with an HTTP cookie, which should be able
	// to uniquely identify a visitor on a single device. This unique identifier
	// should not change if the visitor log in/out of the website. Do not set the
	// field to the same fixed ID for different users. This mixes the event history
	// of those users together, which results in degraded model quality. The field
	// must be a UTF-8 encoded string with a length limit of 128 characters.
	// Otherwise, an `INVALID_ARGUMENT` error is returned. The field should not
	// contain PII or user-data. We recommend to use Google Analytics Client ID
	// (https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
	// for this field.
	UserPseudoId string `json:"userPseudoId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1UserEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1UserEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1UserInfo: Information of an end user.
type GoogleCloudDiscoveryengineV1UserInfo struct {
	// TimeZone: Optional. IANA time zone, e.g. Europe/Budapest.
	TimeZone string `json:"timeZone,omitempty"`
	// UserAgent: User agent as included in the HTTP header. The field must be a
	// UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an
	// `INVALID_ARGUMENT` error is returned. This should not be set when using the
	// client side event reporting with GTM or JavaScript tag in
	// UserEventService.CollectUserEvent or if UserEvent.direct_user_request is
	// set.
	UserAgent string `json:"userAgent,omitempty"`
	// UserId: Highly recommended for logged-in users. Unique identifier for
	// logged-in user, such as a user name. Don't set for anonymous users. Always
	// use a hashed value for this ID. Don't set the field to the same fixed ID for
	// different users. This mixes the event history of those users together, which
	// results in degraded model quality. The field must be a UTF-8 encoded string
	// with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT`
	// error is returned.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TimeZone") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TimeZone") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1UserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1UserInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1UserLicense: User License information assigned
// by the admin.
type GoogleCloudDiscoveryengineV1UserLicense struct {
	// CreateTime: Output only. User created timestamp.
	CreateTime string `json:"createTime,omitempty"`
	// LastLoginTime: Output only. User last logged in time. If the user has not
	// logged in yet, this field will be empty.
	LastLoginTime string `json:"lastLoginTime,omitempty"`
	// LicenseAssignmentState: Output only. License assignment state of the user.
	// If the user is assigned with a license config, the user login will be
	// assigned with the license; If the user's license assignment state is
	// unassigned or unspecified, no license config will be associated to the user;
	//
	// Possible values:
	//   "LICENSE_ASSIGNMENT_STATE_UNSPECIFIED" - Default value.
	//   "ASSIGNED" - License assigned to the user.
	//   "UNASSIGNED" - No license assigned to the user. Deprecated, translated to
	// NO_LICENSE.
	//   "NO_LICENSE" - No license assigned to the user.
	//   "NO_LICENSE_ATTEMPTED_LOGIN" - User attempted to login but no license
	// assigned to the user. This state is only used for no user first time login
	// attempt but cannot get license assigned. Users already logged in but cannot
	// get license assigned will be assigned NO_LICENSE state(License could be
	// unassigned by admin).
	//   "BLOCKED" - User is blocked from assigning a license.
	LicenseAssignmentState string `json:"licenseAssignmentState,omitempty"`
	// LicenseConfig: Optional. The full resource name of the
	// Subscription(LicenseConfig) assigned to the user.
	LicenseConfig string `json:"licenseConfig,omitempty"`
	// UpdateTime: Output only. User update timestamp.
	UpdateTime string `json:"updateTime,omitempty"`
	// UserPrincipal: Required. Immutable. The user principal of the User, could be
	// email address or other prinical identifier. This field is immutable. Admin
	// assign licenses based on the user principal.
	UserPrincipal string `json:"userPrincipal,omitempty"`
	// UserProfile: Optional. The user profile. We user user full name(First name +
	// Last name) as user profile.
	UserProfile string `json:"userProfile,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1UserLicense) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1UserLicense
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1UserStore: Configures metadata that is used for
// End User entities.
type GoogleCloudDiscoveryengineV1UserStore struct {
	// DefaultLicenseConfig: Optional. The default subscription LicenseConfig for
	// the UserStore, if UserStore.enable_license_auto_register is true, new users
	// will automatically register under the default subscription. If default
	// LicenseConfig doesn't have remaining license seats left, new users will not
	// be assigned with license and will be blocked for Vertex AI Search features.
	// This is used if `license_assignment_tier_rules` is not configured.
	DefaultLicenseConfig string `json:"defaultLicenseConfig,omitempty"`
	// DisplayName: The display name of the User Store.
	DisplayName string `json:"displayName,omitempty"`
	// EnableExpiredLicenseAutoUpdate: Optional. Whether to enable license auto
	// update for users in this User Store. If true, users with expired licenses
	// will automatically be updated to use the default license config as long as
	// the default license config has seats left.
	EnableExpiredLicenseAutoUpdate bool `json:"enableExpiredLicenseAutoUpdate,omitempty"`
	// EnableLicenseAutoRegister: Optional. Whether to enable license auto register
	// for users in this User Store. If true, new users will automatically register
	// under the default license config as long as the default license config has
	// seats left.
	EnableLicenseAutoRegister bool `json:"enableLicenseAutoRegister,omitempty"`
	// Name: Immutable. The full resource name of the User Store, in the format of
	// `projects/{project}/locations/{location}/userStores/{user_store}`. This
	// field must be a UTF-8 encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DefaultLicenseConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultLicenseConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1UserStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1UserStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1WorkspaceConfig: Config to store data store type
// configuration for workspace data
type GoogleCloudDiscoveryengineV1WorkspaceConfig struct {
	// DasherCustomerId: Obfuscated Dasher customer ID.
	DasherCustomerId string `json:"dasherCustomerId,omitempty"`
	// SuperAdminEmailAddress: Optional. The super admin email address for the
	// workspace that will be used for access token generation. For now we only use
	// it for Native Google Drive connector data ingestion.
	SuperAdminEmailAddress string `json:"superAdminEmailAddress,omitempty"`
	// SuperAdminServiceAccount: Optional. The super admin service account for the
	// workspace that will be used for access token generation. For now we only use
	// it for Native Google Drive connector data ingestion.
	SuperAdminServiceAccount string `json:"superAdminServiceAccount,omitempty"`
	// Type: The Google Workspace data source.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Defaults to an unspecified Workspace type.
	//   "GOOGLE_DRIVE" - Workspace Data Store contains Drive data
	//   "GOOGLE_MAIL" - Workspace Data Store contains Mail data
	//   "GOOGLE_SITES" - Workspace Data Store contains Sites data
	//   "GOOGLE_CALENDAR" - Workspace Data Store contains Calendar data
	//   "GOOGLE_CHAT" - Workspace Data Store contains Chat data
	//   "GOOGLE_GROUPS" - Workspace Data Store contains Groups data
	//   "GOOGLE_KEEP" - Workspace Data Store contains Keep data
	//   "GOOGLE_PEOPLE" - Workspace Data Store contains People data
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DasherCustomerId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DasherCustomerId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1WorkspaceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1WorkspaceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAclConfig: Access Control Configuration.
type GoogleCloudDiscoveryengineV1alphaAclConfig struct {
	// IdpConfig: Identity provider config.
	IdpConfig *GoogleCloudDiscoveryengineV1alphaIdpConfig `json:"idpConfig,omitempty"`
	// Name: Immutable. The full resource name of the acl configuration. Format:
	// `projects/{project}/locations/{location}/aclConfig`. This field must be a
	// UTF-8 encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IdpConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdpConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAclConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAclConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaActionConfig: Informations to support
// actions on the connector.
type GoogleCloudDiscoveryengineV1alphaActionConfig struct {
	// ActionParams: Optional. Action parameters in structured json format.
	ActionParams googleapi.RawMessage `json:"actionParams,omitempty"`
	// IsActionConfigured: Output only. The connector contains the necessary
	// parameters and is configured to support actions.
	IsActionConfigured bool `json:"isActionConfigured,omitempty"`
	// JsonActionParams: Optional. Action parameters in json string format.
	JsonActionParams string `json:"jsonActionParams,omitempty"`
	// ServiceName: Optional. The Service Directory resource name
	// (projects/*/locations/*/namespaces/*/services/*) representing a VPC network
	// endpoint used to connect to the data source's `instance_uri`, defined in
	// DataConnector.params. Required when VPC Service Controls are enabled.
	ServiceName string `json:"serviceName,omitempty"`
	// UseStaticSecrets: Optional. Whether to use static secrets for the connector.
	// If true, the secrets provided in the action_params will be ignored.
	UseStaticSecrets bool `json:"useStaticSecrets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionParams") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionParams") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaActionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaActionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAdvancedSiteSearchConfig: Configuration
// data for advance site search.
type GoogleCloudDiscoveryengineV1alphaAdvancedSiteSearchConfig struct {
	// DisableAutomaticRefresh: If set true, automatic refresh is disabled for the
	// DataStore.
	DisableAutomaticRefresh bool `json:"disableAutomaticRefresh,omitempty"`
	// DisableInitialIndex: If set true, initial indexing is disabled for the
	// DataStore.
	DisableInitialIndex bool `json:"disableInitialIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisableAutomaticRefresh") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisableAutomaticRefresh") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAdvancedSiteSearchConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAdvancedSiteSearchConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAlertPolicyConfig: The connector level
// alert config.
type GoogleCloudDiscoveryengineV1alphaAlertPolicyConfig struct {
	// AlertEnrollments: Optional. The enrollment states of each alert.
	AlertEnrollments []*GoogleCloudDiscoveryengineV1alphaAlertPolicyConfigAlertEnrollment `json:"alertEnrollments,omitempty"`
	// AlertPolicyName: Immutable. The fully qualified resource name of the
	// AlertPolicy.
	AlertPolicyName string `json:"alertPolicyName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlertEnrollments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlertEnrollments") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAlertPolicyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAlertPolicyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAlertPolicyConfigAlertEnrollment: The alert
// enrollment status.
type GoogleCloudDiscoveryengineV1alphaAlertPolicyConfigAlertEnrollment struct {
	// AlertId: Immutable. The id of an alert.
	AlertId string `json:"alertId,omitempty"`
	// EnrollState: Required. The enrollment status of a customer.
	//
	// Possible values:
	//   "ENROLL_STATES_UNSPECIFIED" - Default value. Used for customers who have
	// not responded to the alert policy.
	//   "ENROLLED" - Customer is enrolled in this policy.
	//   "DECLINED" - Customer declined this policy.
	EnrollState string `json:"enrollState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlertId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlertId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAlertPolicyConfigAlertEnrollment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAlertPolicyConfigAlertEnrollment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAlertPolicyResourceConfig: The resource
// level alert config. Used in: * UserLicense * EngineUserData The
// AlertPolicyConfig in data connector is of same usage. No easy way to
// migrate.
type GoogleCloudDiscoveryengineV1alphaAlertPolicyResourceConfig struct {
	// AlertEnrollments: Optional. The enrollment state of each alert.
	AlertEnrollments []*GoogleCloudDiscoveryengineV1alphaAlertPolicyResourceConfigAlertEnrollment `json:"alertEnrollments,omitempty"`
	// AlertPolicy: Immutable. The fully qualified resource name of the
	// AlertPolicy.
	AlertPolicy string `json:"alertPolicy,omitempty"`
	// ContactDetails: Optional. The contact details for each alert policy.
	ContactDetails []*GoogleCloudDiscoveryengineV1alphaContactDetails `json:"contactDetails,omitempty"`
	// LanguageCode: Optional. The language code used for notifications
	LanguageCode string `json:"languageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlertEnrollments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlertEnrollments") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAlertPolicyResourceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAlertPolicyResourceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAlertPolicyResourceConfigAlertEnrollment:
// The alert enrollment status.
type GoogleCloudDiscoveryengineV1alphaAlertPolicyResourceConfigAlertEnrollment struct {
	// AlertId: Immutable. The id of an alert.
	AlertId string `json:"alertId,omitempty"`
	// EnrollState: Required. The enrollment status of a customer.
	//
	// Possible values:
	//   "ENROLL_STATE_UNSPECIFIED" - Default value. Used for customers who have
	// not responded to the alert policy.
	//   "ENROLLED" - Customer is enrolled in this policy.
	//   "DECLINED" - Customer declined this policy.
	EnrollState string `json:"enrollState,omitempty"`
	// NotificationParams: Optional. Parameters used to instantiate a notification.
	// Used for notifications that are triggered when registered. Not stored. *
	// Gemini Business welcome emails. * Gemini Business user invitation emails.
	NotificationParams map[string]string `json:"notificationParams,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlertId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlertId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAlertPolicyResourceConfigAlertEnrollment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAlertPolicyResourceConfigAlertEnrollment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswer: Defines an answer.
type GoogleCloudDiscoveryengineV1alphaAnswer struct {
	// AnswerSkippedReasons: Additional answer-skipped reasons. This provides the
	// reason for ignored cases. If nothing is skipped, this field is not set.
	//
	// Possible values:
	//   "ANSWER_SKIPPED_REASON_UNSPECIFIED" - Default value. The answer skipped
	// reason is not specified.
	//   "ADVERSARIAL_QUERY_IGNORED" - The adversarial query ignored case.
	//   "NON_ANSWER_SEEKING_QUERY_IGNORED" - The non-answer seeking query ignored
	// case Google skips the answer if the query is chit chat.
	//   "OUT_OF_DOMAIN_QUERY_IGNORED" - The out-of-domain query ignored case.
	// Google skips the answer if there are no high-relevance search results.
	//   "POTENTIAL_POLICY_VIOLATION" - The potential policy violation case. Google
	// skips the answer if there is a potential policy violation detected. This
	// includes content that may be violent or toxic.
	//   "NO_RELEVANT_CONTENT" - The no relevant content case. Google skips the
	// answer if there is no relevant content in the retrieved search results.
	//   "JAIL_BREAKING_QUERY_IGNORED" - The jail-breaking query ignored case. For
	// example, "Reply in the tone of a competing company's CEO". Google skips the
	// answer if the query is classified as a jail-breaking query.
	//   "CUSTOMER_POLICY_VIOLATION" - The customer policy violation case. Google
	// skips the summary if there is a customer policy violation detected. The
	// policy is defined by the customer.
	//   "NON_ANSWER_SEEKING_QUERY_IGNORED_V2" - The non-answer seeking query
	// ignored case. Google skips the answer if the query doesn't have clear
	// intent.
	//   "LOW_GROUNDED_ANSWER" - The low-grounded answer case. Google skips the
	// answer if a well grounded answer was unable to be generated.
	//   "USER_DEFINED_CLASSIFICATION_QUERY_IGNORED" - The user defined query
	// classification ignored case. Google skips the answer if the query is
	// classified as a user defined query classification.
	//   "UNHELPFUL_ANSWER" - The unhelpful answer case. Google skips the answer if
	// the answer is not helpful. This can be due to a variety of factors,
	// including but not limited to: the query is not answerable, the answer is not
	// relevant to the query, or the answer is not well-formatted.
	AnswerSkippedReasons []string `json:"answerSkippedReasons,omitempty"`
	// AnswerText: The textual answer.
	AnswerText string `json:"answerText,omitempty"`
	// BlobAttachments: List of blob attachments in the answer.
	BlobAttachments []*GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachment `json:"blobAttachments,omitempty"`
	// Citations: Citations.
	Citations []*GoogleCloudDiscoveryengineV1alphaAnswerCitation `json:"citations,omitempty"`
	// CompleteTime: Output only. Answer completed timestamp.
	CompleteTime string `json:"completeTime,omitempty"`
	// CreateTime: Output only. Answer creation timestamp.
	CreateTime string `json:"createTime,omitempty"`
	// GroundingScore: A score in the range of [0, 1] describing how grounded the
	// answer is by the reference chunks.
	GroundingScore float64 `json:"groundingScore,omitempty"`
	// GroundingSupports: Optional. Grounding supports.
	GroundingSupports []*GoogleCloudDiscoveryengineV1alphaAnswerGroundingSupport `json:"groundingSupports,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/{project}/locations/global/collections/{collection}/engines/{engine
	// }/sessions/*/answers/*`
	Name string `json:"name,omitempty"`
	// QueryUnderstandingInfo: Query understanding information.
	QueryUnderstandingInfo *GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfo `json:"queryUnderstandingInfo,omitempty"`
	// References: References.
	References []*GoogleCloudDiscoveryengineV1alphaAnswerReference `json:"references,omitempty"`
	// RelatedQuestions: Suggested related questions.
	RelatedQuestions []string `json:"relatedQuestions,omitempty"`
	// SafetyRatings: Optional. Safety ratings.
	SafetyRatings []*GoogleCloudDiscoveryengineV1alphaSafetyRating `json:"safetyRatings,omitempty"`
	// State: The state of the answer generation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown.
	//   "IN_PROGRESS" - Answer generation is currently in progress.
	//   "FAILED" - Answer generation currently failed.
	//   "SUCCEEDED" - Answer generation has succeeded.
	//   "STREAMING" - Answer generation is currently in progress.
	State string `json:"state,omitempty"`
	// Steps: Answer generation steps.
	Steps []*GoogleCloudDiscoveryengineV1alphaAnswerStep `json:"steps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerSkippedReasons") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerSkippedReasons") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswer
	var s1 struct {
		GroundingScore gensupport.JSONFloat64 `json:"groundingScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.GroundingScore = float64(s1.GroundingScore)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachment: Stores binarydata
// attached to text answer, e.g. image, video, audio, etc.
type GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachment struct {
	// AttributionType: Output only. The attribution type of the blob.
	//
	// Possible values:
	//   "ATTRIBUTION_TYPE_UNSPECIFIED" - Unspecified attribution type.
	//   "CORPUS" - The attachment data is from the corpus.
	//   "GENERATED" - The attachment data is generated by the model through code
	// generation.
	AttributionType string `json:"attributionType,omitempty"`
	// Data: Output only. The mime type and data of the blob.
	Data *GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachmentBlob `json:"data,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributionType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributionType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachmentBlob: The media type
// and data of the blob.
type GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachmentBlob struct {
	// Data: Output only. Raw bytes.
	Data string `json:"data,omitempty"`
	// MimeType: Output only. The media type (MIME type) of the generated or
	// retrieved data.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Data") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Data") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachmentBlob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachmentBlob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerCitation: Citation info for a
// segment.
type GoogleCloudDiscoveryengineV1alphaAnswerCitation struct {
	// EndIndex: End of the attributed segment, exclusive. Measured in bytes (UTF-8
	// unicode). If there are multi-byte characters,such as non-ASCII characters,
	// the index measurement is longer than the string length.
	EndIndex int64 `json:"endIndex,omitempty,string"`
	// Sources: Citation sources for the attributed segment.
	Sources []*GoogleCloudDiscoveryengineV1alphaAnswerCitationSource `json:"sources,omitempty"`
	// StartIndex: Index indicates the start of the segment, measured in bytes
	// (UTF-8 unicode). If there are multi-byte characters,such as non-ASCII
	// characters, the index measurement is longer than the string length.
	StartIndex int64 `json:"startIndex,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerCitation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerCitation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerCitationSource: Citation source.
type GoogleCloudDiscoveryengineV1alphaAnswerCitationSource struct {
	// ReferenceId: ID of the citation source.
	ReferenceId string `json:"referenceId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReferenceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReferenceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerCitationSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerCitationSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerGroundingSupport: Grounding support
// for a claim in `answer_text`.
type GoogleCloudDiscoveryengineV1alphaAnswerGroundingSupport struct {
	// EndIndex: Required. End of the claim, exclusive.
	EndIndex int64 `json:"endIndex,omitempty,string"`
	// GroundingCheckRequired: Indicates that this claim required grounding check.
	// When the system decided this claim didn't require attribution/grounding
	// check, this field is set to false. In that case, no grounding check was done
	// for the claim and therefore `grounding_score`, `sources` is not returned.
	GroundingCheckRequired bool `json:"groundingCheckRequired,omitempty"`
	// GroundingScore: A score in the range of [0, 1] describing how grounded is a
	// specific claim by the references. Higher value means that the claim is
	// better supported by the reference chunks.
	GroundingScore float64 `json:"groundingScore,omitempty"`
	// Sources: Optional. Citation sources for the claim.
	Sources []*GoogleCloudDiscoveryengineV1alphaAnswerCitationSource `json:"sources,omitempty"`
	// StartIndex: Required. Index indicates the start of the claim, measured in
	// bytes (UTF-8 unicode).
	StartIndex int64 `json:"startIndex,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerGroundingSupport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerGroundingSupport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaAnswerGroundingSupport) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerGroundingSupport
	var s1 struct {
		GroundingScore gensupport.JSONFloat64 `json:"groundingScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.GroundingScore = float64(s1.GroundingScore)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfo: Query
// understanding information.
type GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfo struct {
	// QueryClassificationInfo: Query classification information.
	QueryClassificationInfo []*GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfoQueryClassificationInfo `json:"queryClassificationInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryClassificationInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryClassificationInfo") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfoQueryClassificat
// ionInfo: Query classification information.
type GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfoQueryClassificationInfo struct {
	// Positive: Classification output.
	Positive bool `json:"positive,omitempty"`
	// Type: Query classification type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified query classification type.
	//   "ADVERSARIAL_QUERY" - Adversarial query classification type.
	//   "NON_ANSWER_SEEKING_QUERY" - Non-answer-seeking query classification type,
	// for chit chat.
	//   "JAIL_BREAKING_QUERY" - Jail-breaking query classification type.
	//   "NON_ANSWER_SEEKING_QUERY_V2" - Non-answer-seeking query classification
	// type, for no clear intent.
	//   "USER_DEFINED_CLASSIFICATION_QUERY" - User defined query classification
	// type.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Positive") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Positive") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfoQueryClassificationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfoQueryClassificationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerReference: Reference.
type GoogleCloudDiscoveryengineV1alphaAnswerReference struct {
	// ChunkInfo: Chunk information.
	ChunkInfo *GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo `json:"chunkInfo,omitempty"`
	// StructuredDocumentInfo: Structured document information.
	StructuredDocumentInfo *GoogleCloudDiscoveryengineV1alphaAnswerReferenceStructuredDocumentInfo `json:"structuredDocumentInfo,omitempty"`
	// UnstructuredDocumentInfo: Unstructured document information.
	UnstructuredDocumentInfo *GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfo `json:"unstructuredDocumentInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo: Chunk
// information.
type GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo struct {
	// BlobAttachmentIndexes: Output only. Stores indexes of blobattachments linked
	// to this chunk.
	BlobAttachmentIndexes googleapi.Int64s `json:"blobAttachmentIndexes,omitempty"`
	// Chunk: Chunk resource name.
	Chunk string `json:"chunk,omitempty"`
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// DocumentMetadata: Document metadata.
	DocumentMetadata *GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfoDocumentMetadata `json:"documentMetadata,omitempty"`
	// RelevanceScore: The relevance of the chunk for a given query. Values range
	// from 0.0 (completely irrelevant) to 1.0 (completely relevant). This value is
	// for informational purpose only. It may change for the same query and chunk
	// at any time due to a model retraining or change in implementation.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlobAttachmentIndexes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobAttachmentIndexes") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo
	var s1 struct {
		RelevanceScore gensupport.JSONFloat64 `json:"relevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelevanceScore = float64(s1.RelevanceScore)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfoDocumentMetadata:
// Document metadata.
type GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfoDocumentMetadata struct {
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// StructData: The structured JSON metadata for the document. It is populated
	// from the struct data from the Chunk in search result.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfoDocumentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfoDocumentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerReferenceStructuredDocumentInfo:
// Structured search information.
type GoogleCloudDiscoveryengineV1alphaAnswerReferenceStructuredDocumentInfo struct {
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// StructData: Structured search data.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Output only. The title of the document.
	Title string `json:"title,omitempty"`
	// Uri: Output only. The URI of the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerReferenceStructuredDocumentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReferenceStructuredDocumentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfo:
// Unstructured document information.
type GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfo struct {
	// ChunkContents: List of cited chunk contents derived from document content.
	ChunkContents []*GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunkContent `json:"chunkContents,omitempty"`
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// StructData: The structured JSON metadata for the document. It is populated
	// from the struct data from the Chunk in search result.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkContents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunk
// Content: Chunk content.
type GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunkContent struct {
	// BlobAttachmentIndexes: Output only. Stores indexes of blobattachments linked
	// to this chunk.
	BlobAttachmentIndexes googleapi.Int64s `json:"blobAttachmentIndexes,omitempty"`
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// RelevanceScore: The relevance of the chunk for a given query. Values range
	// from 0.0 (completely irrelevant) to 1.0 (completely relevant). This value is
	// for informational purpose only. It may change for the same query and chunk
	// at any time due to a model retraining or change in implementation.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlobAttachmentIndexes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobAttachmentIndexes") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunkContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunkContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunkContent) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunkContent
	var s1 struct {
		RelevanceScore gensupport.JSONFloat64 `json:"relevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelevanceScore = float64(s1.RelevanceScore)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaAnswerStep: Step information.
type GoogleCloudDiscoveryengineV1alphaAnswerStep struct {
	// Actions: Actions.
	Actions []*GoogleCloudDiscoveryengineV1alphaAnswerStepAction `json:"actions,omitempty"`
	// Description: The description of the step.
	Description string `json:"description,omitempty"`
	// State: The state of the step.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown.
	//   "IN_PROGRESS" - Step is currently in progress.
	//   "FAILED" - Step currently failed.
	//   "SUCCEEDED" - Step has succeeded.
	State string `json:"state,omitempty"`
	// Thought: The thought of the step.
	Thought string `json:"thought,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStep) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStep
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerStepAction: Action.
type GoogleCloudDiscoveryengineV1alphaAnswerStepAction struct {
	// Observation: Observation.
	Observation *GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservation `json:"observation,omitempty"`
	// SearchAction: Search action.
	SearchAction *GoogleCloudDiscoveryengineV1alphaAnswerStepActionSearchAction `json:"searchAction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Observation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Observation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStepAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservation: Observation.
type GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservation struct {
	// SearchResults: Search results observed by the search action, it can be
	// snippets info or chunk info, depending on the citation type set by the user.
	SearchResults []*GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResult `json:"searchResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchResults") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResult struct {
	// ChunkInfo: If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
	// populate chunk info.
	ChunkInfo []*GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo `json:"chunkInfo,omitempty"`
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// SnippetInfo: If citation_type is DOCUMENT_LEVEL_CITATION, populate document
	// level snippets.
	SnippetInfo []*GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultSnippetInfo `json:"snippetInfo,omitempty"`
	// StructData: Data representation. The structured JSON data for the document.
	// It's populated from the struct data from the Document, or the Chunk in
	// search result.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunk
// Info: Chunk information.
type GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo struct {
	// Chunk: Chunk resource name.
	Chunk string `json:"chunk,omitempty"`
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// RelevanceScore: The relevance of the chunk for a given query. Values range
	// from 0.0 (completely irrelevant) to 1.0 (completely relevant). This value is
	// for informational purpose only. It may change for the same query and chunk
	// at any time due to a model retraining or change in implementation.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo
	var s1 struct {
		RelevanceScore gensupport.JSONFloat64 `json:"relevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelevanceScore = float64(s1.RelevanceScore)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultSnipp
// etInfo: Snippet information.
type GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultSnippetInfo struct {
	// Snippet: Snippet content.
	Snippet string `json:"snippet,omitempty"`
	// SnippetStatus: Status of the snippet defined by the search team.
	SnippetStatus string `json:"snippetStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Snippet") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Snippet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultSnippetInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultSnippetInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerStepActionSearchAction: Search
// action.
type GoogleCloudDiscoveryengineV1alphaAnswerStepActionSearchAction struct {
	// Query: The query to search.
	Query string `json:"query,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Query") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Query") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStepActionSearchAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepActionSearchAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAssistAnswer: AssistAnswer resource, main
// part of AssistResponse.
type GoogleCloudDiscoveryengineV1alphaAssistAnswer struct {
	// AssistSkippedReasons: Reasons for not answering the assist call.
	//
	// Possible values:
	//   "ASSIST_SKIPPED_REASON_UNSPECIFIED" - Default value. Skip reason is not
	// specified.
	//   "NON_ASSIST_SEEKING_QUERY_IGNORED" - The assistant ignored the query,
	// because it did not appear to be answer-seeking.
	//   "CUSTOMER_POLICY_VIOLATION" - The assistant ignored the query or refused
	// to answer because of a customer policy violation (e.g., the query or the
	// answer contained a banned phrase).
	AssistSkippedReasons []string `json:"assistSkippedReasons,omitempty"`
	// CustomerPolicyEnforcementResult: Optional. The field contains information
	// about the various policy checks' results like the banned phrases or the
	// Model Armor checks. This field is populated only if the assist call was
	// skipped due to a policy violation.
	CustomerPolicyEnforcementResult *GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResult `json:"customerPolicyEnforcementResult,omitempty"`
	// Name: Immutable. Identifier. Resource name of the `AssistAnswer`. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/engines/{en
	// gine}/sessions/{session}/assistAnswers/{assist_answer}` This field must be a
	// UTF-8 encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// Replies: Replies of the assistant.
	Replies []*GoogleCloudDiscoveryengineV1alphaAssistAnswerReply `json:"replies,omitempty"`
	// State: State of the answer generation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown.
	//   "IN_PROGRESS" - Assist operation is currently in progress.
	//   "FAILED" - Assist operation has failed.
	//   "SUCCEEDED" - Assist operation has succeeded.
	//   "SKIPPED" - Assist operation has been skipped.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssistSkippedReasons") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssistSkippedReasons") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAssistAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAssistAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResult:
//
//	Customer policy enforcement results. Contains the results of the various
//
// policy checks, like the banned phrases or the Model Armor checks.
type GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResult struct {
	// PolicyResults: Customer policy enforcement results. Populated only if the
	// assist call was skipped due to a policy violation. It contains results from
	// those filters that blocked the processing of the query.
	PolicyResults []*GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResultPolicyEnforcementResult `json:"policyResults,omitempty"`
	// Verdict: Final verdict of the customer policy enforcement. If only one
	// policy blocked the processing, the verdict is BLOCK.
	//
	// Possible values:
	//   "UNSPECIFIED" - Unknown value.
	//   "ALLOW" - There was no policy violation.
	//   "BLOCK" - Processing was blocked by the customer policy.
	Verdict string `json:"verdict,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PolicyResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PolicyResults") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResultB
// annedPhraseEnforcementResult: Customer policy enforcement result for the
// banned phrase policy.
type GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResultBannedPhraseEnforcementResult struct {
	// BannedPhrases: The banned phrases that were found in the query or the
	// answer.
	BannedPhrases []string `json:"bannedPhrases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BannedPhrases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BannedPhrases") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResultBannedPhraseEnforcementResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResultBannedPhraseEnforcementResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResultM
// odelArmorEnforcementResult: Customer policy enforcement result for the Model
// Armor policy.
type GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResultModelArmorEnforcementResult struct {
	// Error: The error returned by Model Armor if the policy enforcement failed
	// for some reason.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// ModelArmorViolation: The Model Armor violation that was found.
	ModelArmorViolation string `json:"modelArmorViolation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResultModelArmorEnforcementResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResultModelArmorEnforcementResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResultP
// olicyEnforcementResult: Customer policy enforcement result for a single
// policy type.
type GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResultPolicyEnforcementResult struct {
	// BannedPhraseEnforcementResult: The policy enforcement result for the banned
	// phrase policy.
	BannedPhraseEnforcementResult *GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResultBannedPhraseEnforcementResult `json:"bannedPhraseEnforcementResult,omitempty"`
	// ModelArmorEnforcementResult: The policy enforcement result for the Model
	// Armor policy.
	ModelArmorEnforcementResult *GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResultModelArmorEnforcementResult `json:"modelArmorEnforcementResult,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "BannedPhraseEnforcementResult") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BannedPhraseEnforcementResult")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResultPolicyEnforcementResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAssistAnswerCustomerPolicyEnforcementResultPolicyEnforcementResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAssistAnswerReply: One part of the
// multi-part response of the assist call.
type GoogleCloudDiscoveryengineV1alphaAssistAnswerReply struct {
	// GroundedContent: Possibly grounded response text or media from the
	// assistant.
	GroundedContent *GoogleCloudDiscoveryengineV1alphaAssistantGroundedContent `json:"groundedContent,omitempty"`
	// ReplyId: Output only. When set, uniquely identifies a reply within the
	// `AssistAnswer` resource. During an AssistantService.StreamAssist call,
	// multiple `Reply` messages with the same ID can occur within the response
	// stream (across multiple AssistantService.StreamAssistResponse messages).
	// These represent parts of a single `Reply` message in the final
	// `AssistAnswer` resource.
	ReplyId string `json:"replyId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GroundedContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GroundedContent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAssistAnswerReply) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAssistAnswerReply
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAssistantContent: Multi-modal content.
type GoogleCloudDiscoveryengineV1alphaAssistantContent struct {
	// CodeExecutionResult: Result of executing an ExecutableCode.
	CodeExecutionResult *GoogleCloudDiscoveryengineV1alphaAssistantContentCodeExecutionResult `json:"codeExecutionResult,omitempty"`
	// ExecutableCode: Code generated by the model that is meant to be executed.
	ExecutableCode *GoogleCloudDiscoveryengineV1alphaAssistantContentExecutableCode `json:"executableCode,omitempty"`
	// File: A file, e.g., an audio summary.
	File *GoogleCloudDiscoveryengineV1alphaAssistantContentFile `json:"file,omitempty"`
	// InlineData: Inline binary data.
	InlineData *GoogleCloudDiscoveryengineV1alphaAssistantContentBlob `json:"inlineData,omitempty"`
	// Role: The producer of the content. Can be "model" or "user".
	Role string `json:"role,omitempty"`
	// Text: Inline text.
	Text string `json:"text,omitempty"`
	// Thought: Optional. Indicates if the part is thought from the model.
	Thought bool `json:"thought,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CodeExecutionResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CodeExecutionResult") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAssistantContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAssistantContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAssistantContentBlob: Inline blob.
type GoogleCloudDiscoveryengineV1alphaAssistantContentBlob struct {
	// Data: Required. Raw bytes.
	Data string `json:"data,omitempty"`
	// MimeType: Required. The media type (MIME type) of the generated data.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Data") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Data") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAssistantContentBlob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAssistantContentBlob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAssistantContentCodeExecutionResult: Result
// of executing ExecutableCode.
type GoogleCloudDiscoveryengineV1alphaAssistantContentCodeExecutionResult struct {
	// Outcome: Required. Outcome of the code execution.
	//
	// Possible values:
	//   "OUTCOME_UNSPECIFIED" - Unspecified status. This value should not be used.
	//   "OUTCOME_OK" - Code execution completed successfully.
	//   "OUTCOME_FAILED" - Code execution finished but with a failure. `stderr`
	// should contain the reason.
	//   "OUTCOME_DEADLINE_EXCEEDED" - Code execution ran for too long, and was
	// cancelled. There may or may not be a partial output present.
	Outcome string `json:"outcome,omitempty"`
	// Output: Optional. Contains stdout when code execution is successful, stderr
	// or other description otherwise.
	Output string `json:"output,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Outcome") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Outcome") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAssistantContentCodeExecutionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAssistantContentCodeExecutionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAssistantContentExecutableCode: Code
// generated by the model that is meant to be executed by the model.
type GoogleCloudDiscoveryengineV1alphaAssistantContentExecutableCode struct {
	// Code: Required. The code content. Currently only supports Python.
	Code string `json:"code,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAssistantContentExecutableCode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAssistantContentExecutableCode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAssistantContentFile: A file, e.g., an
// audio summary.
type GoogleCloudDiscoveryengineV1alphaAssistantContentFile struct {
	// FileId: Required. The file ID.
	FileId string `json:"fileId,omitempty"`
	// MimeType: Required. The media type (MIME type) of the file.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAssistantContentFile) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAssistantContentFile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAssistantGroundedContent: A piece of
// content and possibly its grounding information. Not all content needs
// grounding. Phrases like "Of course, I will gladly search it for you." do not
// need grounding.
type GoogleCloudDiscoveryengineV1alphaAssistantGroundedContent struct {
	// CitationMetadata: Source attribution of the generated content. See also
	// https://cloud.google.com/vertex-ai/generative-ai/docs/learn/overview#citation_check
	CitationMetadata *GoogleCloudDiscoveryengineV1alphaCitationMetadata `json:"citationMetadata,omitempty"`
	// Content: The content.
	Content *GoogleCloudDiscoveryengineV1alphaAssistantContent `json:"content,omitempty"`
	// TextGroundingMetadata: Metadata for grounding based on text sources.
	TextGroundingMetadata *GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadata `json:"textGroundingMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAssistantGroundedContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAssistantGroundedContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadat
// a: Grounding details for text sources.
type GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadata struct {
	// References: References for the grounded text.
	References []*GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadataReference `json:"references,omitempty"`
	// Segments: Grounding information for parts of the text.
	Segments []*GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadataSegment `json:"segments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "References") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "References") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadat
// aReference: Referenced content and related document metadata.
type GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadataReference struct {
	// Content: Referenced text content.
	Content string `json:"content,omitempty"`
	// DocumentMetadata: Document metadata.
	DocumentMetadata *GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadataReferenceDocumentMetadata `json:"documentMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadataReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadataReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadat
// aReferenceDocumentMetadata: Document metadata.
type GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadataReferenceDocumentMetadata struct {
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// Domain: Domain name from the document URI. Note that the `uri` field may
	// contain a URL that redirects to the actual website, in which case this will
	// contain the domain name of the target site.
	Domain string `json:"domain,omitempty"`
	// MimeType: The mime type of the document.
	// https://www.iana.org/assignments/media-types/media-types.xhtml.
	MimeType string `json:"mimeType,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document. It may contain a URL that redirects to the actual
	// website.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadataReferenceDocumentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadataReferenceDocumentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadat
// aSegment: Grounding information for a segment of the text.
type GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadataSegment struct {
	// EndIndex: End of the segment, exclusive.
	EndIndex int64 `json:"endIndex,omitempty,string"`
	// GroundingScore: Score for the segment.
	GroundingScore float64 `json:"groundingScore,omitempty"`
	// ReferenceIndices: References for the segment.
	ReferenceIndices []int64 `json:"referenceIndices,omitempty"`
	// StartIndex: Zero-based index indicating the start of the segment, measured
	// in bytes of a UTF-8 string (i.e. characters encoded on multiple bytes have a
	// length of more than one).
	StartIndex int64 `json:"startIndex,omitempty,string"`
	// Text: The text segment itself.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadataSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadataSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadataSegment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAssistantGroundedContentTextGroundingMetadataSegment
	var s1 struct {
		GroundingScore gensupport.JSONFloat64 `json:"groundingScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.GroundingScore = float64(s1.GroundingScore)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaBAPConfig: The configuration for the BAP
// connector.
type GoogleCloudDiscoveryengineV1alphaBAPConfig struct {
	// EnabledActions: Optional. The actions enabled on the associated BAP
	// connection.
	EnabledActions []string `json:"enabledActions,omitempty"`
	// SupportedConnectorModes: Required. The supported connector modes for the
	// associated BAP connection.
	//
	// Possible values:
	//   "CONNECTOR_MODE_UNSPECIFIED" - Connector mode unspecified.
	//   "DATA_INGESTION" - Connector utilized for data ingestion.
	//   "ACTIONS" - Connector utilized for Actions
	//   "END_USER_AUTHENTICATION" - Connector utilized for End User
	// Authentication.
	SupportedConnectorModes []string `json:"supportedConnectorModes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnabledActions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnabledActions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaBAPConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaBAPConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSiteMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.BatchCreateTargetSites operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse: Response
// message for SiteSearchEngineService.BatchCreateTargetSites method.
type GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse struct {
	// TargetSites: TargetSites created.
	TargetSites []*GoogleCloudDiscoveryengineV1alphaTargetSite `json:"targetSites,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TargetSites") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TargetSites") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaBatchUpdateUserLicensesMetadata: Metadata
// related to the progress of the UserLicenseService.BatchUpdateUserLicenses
// operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaBatchUpdateUserLicensesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of user licenses that failed to be updated.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of user licenses successfully updated.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaBatchUpdateUserLicensesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaBatchUpdateUserLicensesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaBatchUpdateUserLicensesResponse: Response
// message for UserLicenseService.BatchUpdateUserLicenses method.
type GoogleCloudDiscoveryengineV1alphaBatchUpdateUserLicensesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// UserLicenses: UserLicenses successfully updated.
	UserLicenses []*GoogleCloudDiscoveryengineV1alphaUserLicense `json:"userLicenses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaBatchUpdateUserLicensesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaBatchUpdateUserLicensesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCitation: Source attributions for content.
type GoogleCloudDiscoveryengineV1alphaCitation struct {
	// EndIndex: Output only. End index into the content.
	EndIndex int64 `json:"endIndex,omitempty"`
	// License: Output only. License of the attribution.
	License string `json:"license,omitempty"`
	// PublicationDate: Output only. Publication date of the attribution.
	PublicationDate *GoogleTypeDate `json:"publicationDate,omitempty"`
	// StartIndex: Output only. Start index into the content.
	StartIndex int64 `json:"startIndex,omitempty"`
	// Title: Output only. Title of the attribution.
	Title string `json:"title,omitempty"`
	// Uri: Output only. Url reference of the attribution.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCitation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCitation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCitationMetadata: A collection of source
// attributions for a piece of content.
type GoogleCloudDiscoveryengineV1alphaCitationMetadata struct {
	// Citations: Output only. List of citations.
	Citations []*GoogleCloudDiscoveryengineV1alphaCitation `json:"citations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Citations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Citations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCitationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCitationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCmekConfig: Configurations used to enable
// CMEK data encryption with Cloud KMS keys.
type GoogleCloudDiscoveryengineV1alphaCmekConfig struct {
	// IsDefault: Output only. The default CmekConfig for the Customer.
	IsDefault bool `json:"isDefault,omitempty"`
	// KmsKey: Required. KMS key resource name which will be used to encrypt
	// resources
	// `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId
	// }`.
	KmsKey string `json:"kmsKey,omitempty"`
	// KmsKeyVersion: Output only. KMS key version resource name which will be used
	// to encrypt resources `/cryptoKeyVersions/{keyVersion}`.
	KmsKeyVersion string `json:"kmsKeyVersion,omitempty"`
	// LastRotationTimestampMicros: Output only. The timestamp of the last key
	// rotation.
	LastRotationTimestampMicros int64 `json:"lastRotationTimestampMicros,omitempty,string"`
	// Name: Required. The name of the CmekConfig of the form
	// `projects/{project}/locations/{location}/cmekConfig` or
	// `projects/{project}/locations/{location}/cmekConfigs/{cmek_config}`.
	Name string `json:"name,omitempty"`
	// NotebooklmState: Output only. Whether the NotebookLM Corpus is ready to be
	// used.
	//
	// Possible values:
	//   "NOTEBOOK_LM_STATE_UNSPECIFIED" - The NotebookLM state is unknown.
	//   "NOTEBOOK_LM_NOT_READY" - The NotebookLM is not ready.
	//   "NOTEBOOK_LM_READY" - The NotebookLM is ready to be used.
	//   "NOTEBOOK_LM_NOT_ENABLED" - The NotebookLM is not enabled.
	NotebooklmState string `json:"notebooklmState,omitempty"`
	// SingleRegionKeys: Optional. Single-regional CMEKs that are required for some
	// VAIS features.
	SingleRegionKeys []*GoogleCloudDiscoveryengineV1alphaSingleRegionKey `json:"singleRegionKeys,omitempty"`
	// State: Output only. The states of the CmekConfig.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The CmekConfig state is unknown.
	//   "CREATING" - The CmekConfig is creating.
	//   "ACTIVE" - The CmekConfig can be used with DataStores.
	//   "KEY_ISSUE" - The CmekConfig is unavailable, most likely due to the KMS
	// Key being revoked.
	//   "DELETING" - The CmekConfig is deleting.
	//   "DELETE_FAILED" - The CmekConfig deletion process failed.
	//   "UNUSABLE" - The CmekConfig is not usable, most likely due to some
	// internal issue.
	//   "ACTIVE_ROTATING" - The KMS key version is being rotated.
	//   "DELETED" - The KMS key is soft deleted. Some cleanup policy will
	// eventually be applied.
	//   "EXPIRED" - The KMS key is expired, meaning the key has been disabled for
	// 30+ days. The customer can call DeleteCmekConfig to change the state to
	// DELETED.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsDefault") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsDefault") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCmekConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCmekConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCollection: Collection is a container for
// configuring resources and access to a set of DataStores.
type GoogleCloudDiscoveryengineV1alphaCollection struct {
	// CreateTime: Output only. Timestamp the Collection was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DataConnector: Output only. The data connector, if present, manages the
	// connection for data stores in the Collection. To set up the connector, use
	// DataConnectorService.SetUpDataConnector method, which creates a new
	// Collection while setting up the DataConnector singleton resource. Setting up
	// connector on an existing Collection is not supported. This output only field
	// contains a subset of the DataConnector fields, including `name`,
	// `data_source`, `entities.entity_name` and `entities.data_store`. To get more
	// details about a data connector, use the
	// DataConnectorService.GetDataConnector method.
	DataConnector *GoogleCloudDiscoveryengineV1alphaDataConnector `json:"dataConnector,omitempty"`
	// DisplayName: Required. The Collection display name. This field must be a
	// UTF-8 encoded string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Immutable. The full resource name of the Collection. Format:
	// `projects/{project}/locations/{location}/collections/{collection_id}`. This
	// field must be a UTF-8 encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCollection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCollection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCondition: Defines circumstances to be
// checked before allowing a behavior
type GoogleCloudDiscoveryengineV1alphaCondition struct {
	// ActiveTimeRange: Range of time(s) specifying when condition is active.
	// Maximum of 10 time ranges.
	ActiveTimeRange []*GoogleCloudDiscoveryengineV1alphaConditionTimeRange `json:"activeTimeRange,omitempty"`
	// QueryRegex: Optional. Query regex to match the whole search query. Cannot be
	// set when Condition.query_terms is set. Only supported for Basic Site Search
	// promotion serving controls.
	QueryRegex string `json:"queryRegex,omitempty"`
	// QueryTerms: Search only A list of terms to match the query on. Cannot be set
	// when Condition.query_regex is set. Maximum of 10 query terms.
	QueryTerms []*GoogleCloudDiscoveryengineV1alphaConditionQueryTerm `json:"queryTerms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActiveTimeRange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveTimeRange") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCondition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaConditionQueryTerm: Matcher for search
// request query
type GoogleCloudDiscoveryengineV1alphaConditionQueryTerm struct {
	// FullMatch: Whether the search query needs to exactly match the query term.
	FullMatch bool `json:"fullMatch,omitempty"`
	// Value: The specific query value to match against Must be lowercase, must be
	// UTF-8. Can have at most 3 space separated terms if full_match is true.
	// Cannot be an empty string. Maximum length of 5000 characters.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FullMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FullMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaConditionQueryTerm) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaConditionQueryTerm
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaConditionTimeRange: Used for time-dependent
// conditions.
type GoogleCloudDiscoveryengineV1alphaConditionTimeRange struct {
	// EndTime: End of time range. Range is inclusive. Must be in the future.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Start of time range. Range is inclusive.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaConditionTimeRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaConditionTimeRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaConnectorRun: A data sync run of
// DataConnector. After DataConnector is successfully initialized, data syncs
// are scheduled at DataConnector.refresh_interval. A ConnectorRun represents a
// data sync either in the past or onging that the moment. //
type GoogleCloudDiscoveryengineV1alphaConnectorRun struct {
	// EndTime: Output only. The time when the connector run ended.
	EndTime string `json:"endTime,omitempty"`
	// EntityRuns: Output only. The details of the entities synced at the
	// ConnectorRun. Each ConnectorRun consists of syncing one or more entities.
	EntityRuns []*GoogleCloudDiscoveryengineV1alphaConnectorRunEntityRun `json:"entityRuns,omitempty"`
	// Errors: Contains info about errors incurred during the sync. Only exist if
	// running into an error state. Contains error code and error message. Use with
	// the `state` field.
	Errors []*GoogleRpcStatus `json:"errors,omitempty"`
	// LatestPauseTime: Output only. The time when the connector run was most
	// recently paused.
	LatestPauseTime string `json:"latestPauseTime,omitempty"`
	// Name: Output only. The full resource name of the Connector Run. Format:
	// `projects/*/locations/*/collections/*/dataConnector/connectorRuns/*`. The
	// `connector_run_id` is system-generated.
	Name string `json:"name,omitempty"`
	// StartTime: Output only. The time when the connector run started.
	StartTime string `json:"startTime,omitempty"`
	// State: Output only. The state of the sync run.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value.
	//   "RUNNING" - The data sync is ongoing.
	//   "SUCCEEDED" - The data sync is finished.
	//   "FAILED" - The data sync is failed.
	//   "OVERRUN" - Data sync has been running longer than expected and is still
	// running at the time the next run is supposed to start.
	//   "CANCELLED" - Data sync was scheduled but has been cancelled.
	//   "PENDING" - Data sync is about to start.
	//   "WARNING" - The data sync completed with non-fatal errors.
	//   "SKIPPED" - An ongoing connector run has been running longer than
	// expected, causing this run to be skipped.
	State string `json:"state,omitempty"`
	// StateUpdateTime: Timestamp at which the connector run sync state was last
	// updated.
	StateUpdateTime string `json:"stateUpdateTime,omitempty"`
	// Trigger: Output only. The trigger for this ConnectorRun.
	//
	// Possible values:
	//   "TRIGGER_UNSPECIFIED" - Default value.
	//   "SCHEDULER" - ConnectorRun triggered by scheduler if connector has
	// PERIODIC sync mode.
	//   "INITIALIZATION" - ConnectorRun auto triggered by connector
	// initialization.
	//   "RESUME" - ConnectorRun auto triggered by resuming connector.
	//   "MANUAL" - ConnectorRun triggered by user manually.
	Trigger string `json:"trigger,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaConnectorRun) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaConnectorRun
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaConnectorRunEntityRun: Represents an entity
// that was synced in this ConnectorRun.
type GoogleCloudDiscoveryengineV1alphaConnectorRunEntityRun struct {
	// DeletedRecordCount: Optional. The number of documents deleted.
	DeletedRecordCount int64 `json:"deletedRecordCount,omitempty,string"`
	// EntityName: The name of the source entity.
	EntityName string `json:"entityName,omitempty"`
	// ErrorRecordCount: Optional. The total number of documents failed at sync at
	// indexing stage.
	ErrorRecordCount int64 `json:"errorRecordCount,omitempty,string"`
	// Errors: The errors from the entity's sync run. Only exist if running into an
	// error state. Contains error code and error message.
	Errors []*GoogleRpcStatus `json:"errors,omitempty"`
	// ExtractedRecordCount: Optional. The number of documents extracted from
	// connector source, ready to be ingested to VAIS.
	ExtractedRecordCount int64 `json:"extractedRecordCount,omitempty,string"`
	// IndexedRecordCount: Optional. The number of documents indexed.
	IndexedRecordCount int64 `json:"indexedRecordCount,omitempty,string"`
	// Progress: Metadata to generate the progress bar.
	Progress *GoogleCloudDiscoveryengineV1alphaConnectorRunEntityRunProgress `json:"progress,omitempty"`
	// ScheduledRecordCount: Optional. The number of documents scheduled to be
	// crawled/extracted from connector source. This only applies to third party
	// connectors.
	ScheduledRecordCount int64 `json:"scheduledRecordCount,omitempty,string"`
	// SourceApiRequestCount: Optional. The number of requests sent to 3p API.
	SourceApiRequestCount int64 `json:"sourceApiRequestCount,omitempty,string"`
	// State: The state of the entity's sync run.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value.
	//   "RUNNING" - The data sync is ongoing.
	//   "SUCCEEDED" - The data sync is finished.
	//   "FAILED" - The data sync is failed.
	//   "OVERRUN" - Data sync has been running longer than expected and is still
	// running at the time the next run is supposed to start.
	//   "CANCELLED" - Data sync was scheduled but has been cancelled.
	//   "PENDING" - Data sync is about to start.
	//   "WARNING" - The data sync completed with non-fatal errors.
	//   "SKIPPED" - An ongoing connector run has been running longer than
	// expected, causing this run to be skipped.
	State string `json:"state,omitempty"`
	// StateUpdateTime: Timestamp at which the entity sync state was last updated.
	StateUpdateTime string `json:"stateUpdateTime,omitempty"`
	// StatsUpdateTime: The timestamp for either extracted_documents_count,
	// indexed_documents_count and error_documents_count was last updated.
	StatsUpdateTime string `json:"statsUpdateTime,omitempty"`
	// SyncType: Sync type of this run.
	//
	// Possible values:
	//   "SYNC_TYPE_UNSPECIFIED" - Sync type unspecified.
	//   "FULL" - Sync triggers full sync of all documents.
	//   "INCREMENTAL" - Incremental sync of updated documents.
	//   "REALTIME" - Realtime sync.
	//   "SCALA_SYNC" - Scala sync.
	SyncType string `json:"syncType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeletedRecordCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeletedRecordCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaConnectorRunEntityRun) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaConnectorRunEntityRun
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaConnectorRunEntityRunProgress: Represents
// the progress of a sync run.
type GoogleCloudDiscoveryengineV1alphaConnectorRunEntityRunProgress struct {
	// CurrentCount: The current progress.
	CurrentCount int64 `json:"currentCount,omitempty,string"`
	// Percentile: Derived. The percentile of the progress.current_count /
	// total_count. The value is between [0, 1.0] inclusive.
	Percentile float64 `json:"percentile,omitempty"`
	// TotalCount: The total.
	TotalCount int64 `json:"totalCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CurrentCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaConnectorRunEntityRunProgress) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaConnectorRunEntityRunProgress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaConnectorRunEntityRunProgress) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaConnectorRunEntityRunProgress
	var s1 struct {
		Percentile gensupport.JSONFloat64 `json:"percentile"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Percentile = float64(s1.Percentile)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaContactDetails: The contact info stored in
// resource level. If both project level and resource level is populated, the
// resource level contact info will override the project level contact info.
type GoogleCloudDiscoveryengineV1alphaContactDetails struct {
	// EmailAddress: Optional. The email address of the contact.
	EmailAddress string `json:"emailAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EmailAddress") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EmailAddress") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaContactDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaContactDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaControl: Defines a conditioned behavior to
// employ during serving. Must be attached to a ServingConfig to be considered
// at serving time. Permitted actions dependent on `SolutionType`.
type GoogleCloudDiscoveryengineV1alphaControl struct {
	// AssociatedServingConfigIds: Output only. List of all ServingConfig IDs this
	// control is attached to. May take up to 10 minutes to update after changes.
	AssociatedServingConfigIds []string `json:"associatedServingConfigIds,omitempty"`
	// BoostAction: Defines a boost-type control
	BoostAction *GoogleCloudDiscoveryengineV1alphaControlBoostAction `json:"boostAction,omitempty"`
	// Conditions: Determines when the associated action will trigger. Omit to
	// always apply the action. Currently only a single condition may be specified.
	// Otherwise an INVALID ARGUMENT error is thrown.
	Conditions []*GoogleCloudDiscoveryengineV1alphaCondition `json:"conditions,omitempty"`
	// DisplayName: Required. Human readable name. The identifier used in UI views.
	// Must be UTF-8 encoded string. Length limit is 128 characters. Otherwise an
	// INVALID ARGUMENT error is thrown.
	DisplayName string `json:"displayName,omitempty"`
	// FilterAction: Defines a filter-type control Currently not supported by
	// Recommendation
	FilterAction *GoogleCloudDiscoveryengineV1alphaControlFilterAction `json:"filterAction,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/*/locations/global/dataStore/*/controls/*`
	Name string `json:"name,omitempty"`
	// PromoteAction: Promote certain links based on predefined trigger queries.
	PromoteAction *GoogleCloudDiscoveryengineV1alphaControlPromoteAction `json:"promoteAction,omitempty"`
	// RedirectAction: Defines a redirect-type control.
	RedirectAction *GoogleCloudDiscoveryengineV1alphaControlRedirectAction `json:"redirectAction,omitempty"`
	// SolutionType: Required. Immutable. What solution the control belongs to.
	// Must be compatible with vertical of resource. Otherwise an INVALID ARGUMENT
	// error is thrown.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionType string `json:"solutionType,omitempty"`
	// SynonymsAction: Treats a group of terms as synonyms of one another.
	SynonymsAction *GoogleCloudDiscoveryengineV1alphaControlSynonymsAction `json:"synonymsAction,omitempty"`
	// UseCases: Specifies the use case for the control. Affects what condition
	// fields can be set. Only applies to SOLUTION_TYPE_SEARCH. Currently only
	// allow one use case per control. Must be set when solution_type is
	// SolutionType.SOLUTION_TYPE_SEARCH.
	//
	// Possible values:
	//   "SEARCH_USE_CASE_UNSPECIFIED" - Value used when unset. Will not occur in
	// CSS.
	//   "SEARCH_USE_CASE_SEARCH" - Search use case. Expects the traffic has a
	// non-empty query.
	//   "SEARCH_USE_CASE_BROWSE" - Browse use case. Expects the traffic has an
	// empty query.
	UseCases []string `json:"useCases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssociatedServingConfigIds")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssociatedServingConfigIds") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaControl) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControl
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaControlBoostAction: Adjusts order of
// products in returned list.
type GoogleCloudDiscoveryengineV1alphaControlBoostAction struct {
	// Boost: Strength of the boost, which should be in [-1, 1]. Negative boost
	// means demotion. Default is 0.0 (No-op).
	Boost float64 `json:"boost,omitempty"`
	// DataStore: Required. Specifies which data store's documents can be boosted
	// by this control. Full data store name e.g.
	// projects/123/locations/global/collections/default_collection/dataStores/defau
	// lt_data_store
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Required. Specifies which products to apply the boost to. If no
	// filter is provided all products will be boosted (No-op). Syntax
	// documentation: https://cloud.google.com/retail/docs/filter-and-order Maximum
	// length is 5000 characters. Otherwise an INVALID ARGUMENT error is thrown.
	Filter string `json:"filter,omitempty"`
	// FixedBoost: Optional. Strength of the boost, which should be in [-1, 1].
	// Negative boost means demotion. Default is 0.0 (No-op).
	FixedBoost float64 `json:"fixedBoost,omitempty"`
	// InterpolationBoostSpec: Optional. Complex specification for custom ranking
	// based on customer defined attribute value.
	InterpolationBoostSpec *GoogleCloudDiscoveryengineV1alphaControlBoostActionInterpolationBoostSpec `json:"interpolationBoostSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaControlBoostAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlBoostAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaControlBoostAction) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlBoostAction
	var s1 struct {
		Boost      gensupport.JSONFloat64 `json:"boost"`
		FixedBoost gensupport.JSONFloat64 `json:"fixedBoost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	s.FixedBoost = float64(s1.FixedBoost)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaControlBoostActionInterpolationBoostSpec:
// Specification for custom ranking based on customer specified attribute
// value. It provides more controls for customized ranking than the simple
// (condition, boost) combination above.
type GoogleCloudDiscoveryengineV1alphaControlBoostActionInterpolationBoostSpec struct {
	// AttributeType: Optional. The attribute type to be used to determine the
	// boost amount. The attribute value can be derived from the field value of the
	// specified field_name. In the case of numerical it is straightforward i.e.
	// attribute_value = numerical_field_value. In the case of freshness however,
	// attribute_value = (time.now() - datetime_field_value).
	//
	// Possible values:
	//   "ATTRIBUTE_TYPE_UNSPECIFIED" - Unspecified AttributeType.
	//   "NUMERICAL" - The value of the numerical field will be used to dynamically
	// update the boost amount. In this case, the attribute_value (the x value) of
	// the control point will be the actual value of the numerical field for which
	// the boost_amount is specified.
	//   "FRESHNESS" - For the freshness use case the attribute value will be the
	// duration between the current time and the date in the datetime field
	// specified. The value must be formatted as an XSD `dayTimeDuration` value (a
	// restricted subset of an ISO 8601 duration value). The pattern for this is:
	// `nDnM]`. For example, `5D`, `3DT12H30M`, `T24H`.
	AttributeType string `json:"attributeType,omitempty"`
	// ControlPoints: Optional. The control points used to define the curve. The
	// monotonic function (defined through the interpolation_type above) passes
	// through the control points listed here.
	ControlPoints []*GoogleCloudDiscoveryengineV1alphaControlBoostActionInterpolationBoostSpecControlPoint `json:"controlPoints,omitempty"`
	// FieldName: Optional. The name of the field whose value will be used to
	// determine the boost amount.
	FieldName string `json:"fieldName,omitempty"`
	// InterpolationType: Optional. The interpolation type to be applied to connect
	// the control points listed below.
	//
	// Possible values:
	//   "INTERPOLATION_TYPE_UNSPECIFIED" - Interpolation type is unspecified. In
	// this case, it defaults to Linear.
	//   "LINEAR" - Piecewise linear interpolation will be applied.
	InterpolationType string `json:"interpolationType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaControlBoostActionInterpolationBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlBoostActionInterpolationBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaControlBoostActionInterpolationBoostSpecCont
// rolPoint: The control points used to define the curve. The curve defined
// through these control points can only be monotonically increasing or
// decreasing(constant values are acceptable).
type GoogleCloudDiscoveryengineV1alphaControlBoostActionInterpolationBoostSpecControlPoint struct {
	// AttributeValue: Optional. Can be one of: 1. The numerical field value. 2.
	// The duration spec for freshness: The value must be formatted as an XSD
	// `dayTimeDuration` value (a restricted subset of an ISO 8601 duration value).
	// The pattern for this is: `nDnM]`.
	AttributeValue string `json:"attributeValue,omitempty"`
	// BoostAmount: Optional. The value between -1 to 1 by which to boost the score
	// if the attribute_value evaluates to the value specified above.
	BoostAmount float64 `json:"boostAmount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeValue") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaControlBoostActionInterpolationBoostSpecControlPoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlBoostActionInterpolationBoostSpecControlPoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaControlBoostActionInterpolationBoostSpecControlPoint) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlBoostActionInterpolationBoostSpecControlPoint
	var s1 struct {
		BoostAmount gensupport.JSONFloat64 `json:"boostAmount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BoostAmount = float64(s1.BoostAmount)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaControlFilterAction: Specified which
// products may be included in results. Uses same filter as boost.
type GoogleCloudDiscoveryengineV1alphaControlFilterAction struct {
	// DataStore: Required. Specifies which data store's documents can be filtered
	// by this control. Full data store name e.g.
	// projects/123/locations/global/collections/default_collection/dataStores/defau
	// lt_data_store
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Required. A filter to apply on the matching condition results.
	// Required Syntax documentation:
	// https://cloud.google.com/retail/docs/filter-and-order Maximum length is 5000
	// characters. Otherwise an INVALID ARGUMENT error is thrown.
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaControlFilterAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlFilterAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaControlPromoteAction: Promote certain links
// based on some trigger queries. Example: Promote shoe store link when
// searching for `shoe` keyword. The link can be outside of associated data
// store.
type GoogleCloudDiscoveryengineV1alphaControlPromoteAction struct {
	// DataStore: Required. Data store with which this promotion is attached to.
	DataStore string `json:"dataStore,omitempty"`
	// SearchLinkPromotion: Required. Promotion attached to this action.
	SearchLinkPromotion *GoogleCloudDiscoveryengineV1alphaSearchLinkPromotion `json:"searchLinkPromotion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaControlPromoteAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlPromoteAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaControlRedirectAction: Redirects a shopper
// to the provided URI.
type GoogleCloudDiscoveryengineV1alphaControlRedirectAction struct {
	// RedirectUri: Required. The URI to which the shopper will be redirected.
	// Required. URI must have length equal or less than 2000 characters. Otherwise
	// an INVALID ARGUMENT error is thrown.
	RedirectUri string `json:"redirectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RedirectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RedirectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaControlRedirectAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlRedirectAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaControlSynonymsAction: Creates a set of
// terms that will act as synonyms of one another. Example: "happy" will also
// be considered as "glad", "glad" will also be considered as "happy".
type GoogleCloudDiscoveryengineV1alphaControlSynonymsAction struct {
	// Synonyms: Defines a set of synonyms. Can specify up to 100 synonyms. Must
	// specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is thrown.
	Synonyms []string `json:"synonyms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Synonyms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaControlSynonymsAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlSynonymsAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCrawlRateTimeSeries: The historical crawl
// rate timeseries data, used for monitoring.
type GoogleCloudDiscoveryengineV1alphaCrawlRateTimeSeries struct {
	// QpsTimeSeries: The QPS of the crawl rate.
	QpsTimeSeries *GoogleMonitoringV3TimeSeries `json:"qpsTimeSeries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QpsTimeSeries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QpsTimeSeries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCrawlRateTimeSeries) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCrawlRateTimeSeries
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCreateDataStoreMetadata: Metadata related
// to the progress of the DataStoreService.CreateDataStore operation. This will
// be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaCreateDataStoreMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCreateDataStoreMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCreateDataStoreMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCreateEngineMetadata: Metadata related to
// the progress of the EngineService.CreateEngine operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaCreateEngineMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCreateEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCreateEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCreateEvaluationMetadata: Metadata for
// EvaluationService.CreateEvaluation method.
type GoogleCloudDiscoveryengineV1alphaCreateEvaluationMetadata struct {
}

// GoogleCloudDiscoveryengineV1alphaCreateSchemaMetadata: Metadata for Create
// Schema LRO.
type GoogleCloudDiscoveryengineV1alphaCreateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCreateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCreateSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCreateSitemapMetadata: Metadata related to
// the progress of the SiteSearchEngineService.CreateSitemap operation. This
// will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaCreateSitemapMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCreateSitemapMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCreateSitemapMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCreateTargetSiteMetadata: Metadata related
// to the progress of the SiteSearchEngineService.CreateTargetSite operation.
// This will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaCreateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCreateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCreateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCustomFineTuningSpec: Defines custom fine
// tuning spec.
type GoogleCloudDiscoveryengineV1alphaCustomFineTuningSpec struct {
	// EnableSearchAdaptor: Whether or not to enable and include custom fine tuned
	// search adaptor model.
	EnableSearchAdaptor bool `json:"enableSearchAdaptor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableSearchAdaptor") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableSearchAdaptor") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCustomFineTuningSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCustomFineTuningSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDataConnector: Manages the connection to
// external data sources for all data stores grouped under a Collection. It's a
// singleton resource of Collection. The initialization is only supported
// through DataConnectorService.SetUpDataConnector method, which will create a
// new Collection and initialize its DataConnector.
type GoogleCloudDiscoveryengineV1alphaDataConnector struct {
	// AclEnabled: Optional. Whether the connector will be created with an ACL
	// config. Currently this field only affects Cloud Storage and BigQuery
	// connectors.
	AclEnabled bool `json:"aclEnabled,omitempty"`
	// ActionConfig: Optional. Action configurations to make the connector support
	// actions.
	ActionConfig *GoogleCloudDiscoveryengineV1alphaActionConfig `json:"actionConfig,omitempty"`
	// ActionState: Output only. State of the action connector. This reflects
	// whether the action connector is initializing, active or has encountered
	// errors.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value.
	//   "CREATING" - The connector is being set up.
	//   "ACTIVE" - The connector is successfully set up and awaiting next sync
	// run.
	//   "FAILED" - The connector is in error. The error details can be found in
	// DataConnector.errors. If the error is unfixable, the DataConnector can be
	// deleted by [CollectionService.DeleteCollection] API.
	//   "RUNNING" - The connector is actively syncing records from the data
	// source.
	//   "WARNING" - The connector has completed a sync run, but encountered
	// non-fatal errors.
	//   "INITIALIZATION_FAILED" - Connector initialization failed. Potential
	// causes include runtime errors or issues in the asynchronous pipeline,
	// preventing the request from reaching downstream services (except for some
	// connector types).
	//   "UPDATING" - Connector is in the process of an update.
	ActionState string `json:"actionState,omitempty"`
	// AlertPolicyConfigs: Optional. The connector level alert config.
	AlertPolicyConfigs []*GoogleCloudDiscoveryengineV1alphaAlertPolicyConfig `json:"alertPolicyConfigs,omitempty"`
	// AutoRunDisabled: Optional. Indicates whether the connector is disabled for
	// auto run. It can be used to pause periodical and real time sync. Update:
	// with the introduction of incremental_sync_disabled, auto_run_disabled is
	// used to pause/disable only full syncs
	AutoRunDisabled bool `json:"autoRunDisabled,omitempty"`
	// BapConfig: Optional. The configuration for establishing a BAP connection.
	BapConfig *GoogleCloudDiscoveryengineV1alphaBAPConfig `json:"bapConfig,omitempty"`
	// BlockingReasons: Output only. User actions that must be completed before the
	// connector can start syncing data.
	//
	// Possible values:
	//   "BLOCKING_REASON_UNSPECIFIED" - Default value.
	//   "ALLOWLIST_STATIC_IP" - Connector requires customer to allowlist static
	// IPs.
	//   "ALLOWLIST_IN_SERVICE_ATTACHMENT" - Connector requires customer to
	// allowlist our project in their service attachment.
	//   "ALLOWLIST_SERVICE_ACCOUNT" - Connector requires customer to allowlist
	// service account in their project.
	BlockingReasons []string `json:"blockingReasons,omitempty"`
	// ConnectorModes: Optional. The modes enabled for this connector. Default
	// state is CONNECTOR_MODE_UNSPECIFIED.
	//
	// Possible values:
	//   "CONNECTOR_MODE_UNSPECIFIED" - Connector mode unspecified.
	//   "DATA_INGESTION" - Connector utilized for data ingestion.
	//   "ACTIONS" - Connector utilized for actions.
	//   "FEDERATED" - Connector utilized for federated search.
	//   "EUA" - Connector utilized for End User Authentication.
	//   "FEDERATED_AND_EUA" - Hybrid connector utilized for federated search and
	// End User Authentication.
	ConnectorModes []string `json:"connectorModes,omitempty"`
	// ConnectorType: Output only. The type of connector. Each source can only map
	// to one type. For example, salesforce, confluence and jira have THIRD_PARTY
	// connector type. It is not mutable once set by system.
	//
	// Possible values:
	//   "CONNECTOR_TYPE_UNSPECIFIED" - Default value.
	//   "THIRD_PARTY" - Third party connector to connector to third party
	// application.
	//   "GCP_FHIR" - Data connector connects between FHIR store and VAIS
	// datastore.
	//   "BIG_QUERY" - Big query connector.
	//   "GCS" - Google Cloud Storage connector.
	//   "GOOGLE_MAIL" - Gmail connector.
	//   "GOOGLE_CALENDAR" - Google Calendar connector.
	//   "GOOGLE_DRIVE" - Google Drive connector.
	//   "NATIVE_CLOUD_IDENTITY" - Native Cloud Identity connector for people
	// search powered by People API.
	//   "THIRD_PARTY_FEDERATED" - Federated connector, it is a third party
	// connector that doesn't ingestion data, and search is powered by third party
	// application's API.
	//   "THIRD_PARTY_EUA" - Connector utilized for End User Authentication
	// features.
	//   "GCNV" - Google Cloud NetApp Volumes connector.
	ConnectorType string `json:"connectorType,omitempty"`
	// CreateEuaSaas: Optional. Whether the END USER AUTHENTICATION connector is
	// created in SaaS.
	CreateEuaSaas bool `json:"createEuaSaas,omitempty"`
	// CreateTime: Output only. Timestamp the DataConnector was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DataSource: Required. The name of the data source. Supported values:
	// `salesforce`, `jira`, `confluence`, `bigquery`.
	DataSource string `json:"dataSource,omitempty"`
	// DestinationConfigs: Optional. Any target destinations used to connect to
	// third-party services.
	DestinationConfigs []*GoogleCloudDiscoveryengineV1alphaDestinationConfig `json:"destinationConfigs,omitempty"`
	// EndUserConfig: Optional. Any params and credentials used specifically for
	// EUA connectors.
	EndUserConfig *GoogleCloudDiscoveryengineV1alphaDataConnectorEndUserConfig `json:"endUserConfig,omitempty"`
	// Entities: List of entities from the connected data source to ingest.
	Entities []*GoogleCloudDiscoveryengineV1alphaDataConnectorSourceEntity `json:"entities,omitempty"`
	// Errors: Output only. The errors from initialization or from the latest
	// connector run.
	Errors []*GoogleRpcStatus `json:"errors,omitempty"`
	// FederatedConfig: Optional. Any params and credentials used specifically for
	// hybrid connectors supporting FEDERATED mode. This field should only be set
	// if the connector is a hybrid connector and we want to enable FEDERATED mode.
	FederatedConfig *GoogleCloudDiscoveryengineV1alphaDataConnectorFederatedConfig `json:"federatedConfig,omitempty"`
	// HybridIngestionDisabled: Optional. If the connector is a hybrid connector,
	// determines whether ingestion is enabled and appropriate resources are
	// provisioned during connector creation. If the connector is not a hybrid
	// connector, this field is ignored.
	HybridIngestionDisabled bool `json:"hybridIngestionDisabled,omitempty"`
	// IdentityRefreshInterval: The refresh interval to sync the Access Control
	// List information for the documents ingested by this connector. If not set,
	// the access control list will be refreshed at the default interval of 30
	// minutes. The identity refresh interval can be at least 30 minutes and at
	// most 7 days.
	IdentityRefreshInterval string `json:"identityRefreshInterval,omitempty"`
	// IdentityScheduleConfig: The configuration for the identity data
	// synchronization runs. This contains the refresh interval to sync the Access
	// Control List information for the documents ingested by this connector.
	IdentityScheduleConfig *GoogleCloudDiscoveryengineV1alphaIdentityScheduleConfig `json:"identityScheduleConfig,omitempty"`
	// IncrementalRefreshInterval: Optional. The refresh interval specifically for
	// incremental data syncs. If unset, incremental syncs will use the default
	// from env, set to 3hrs. The minimum is 30 minutes and maximum is 7 days.
	// Applicable to only 3P connectors. When the refresh interval is set to the
	// same value as the incremental refresh interval, incremental sync will be
	// disabled.
	IncrementalRefreshInterval string `json:"incrementalRefreshInterval,omitempty"`
	// IncrementalSyncDisabled: Optional. Indicates whether incremental syncs are
	// paused for this connector. This is independent of auto_run_disabled.
	// Applicable to only 3P connectors. When the refresh interval is set to the
	// same value as the incremental refresh interval, incremental sync will be
	// disabled, i.e. set to true.
	IncrementalSyncDisabled bool `json:"incrementalSyncDisabled,omitempty"`
	// JsonParams: Required data connector parameters in json string format.
	JsonParams string `json:"jsonParams,omitempty"`
	// KmsKeyName: Input only. The KMS key to be used to protect the DataStores
	// managed by this connector. Must be set for requests that need to comply with
	// CMEK Org Policy protections. If this field is set and processed
	// successfully, the DataStores created by this connector will be protected by
	// the KMS key.
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// LastSyncTime: Output only. For periodic connectors only, the last time a
	// data sync was completed.
	LastSyncTime string `json:"lastSyncTime,omitempty"`
	// LatestPauseTime: Output only. The most recent timestamp when this
	// DataConnector was paused, affecting all functionalities such as data
	// synchronization. Pausing a connector has the following effects: - All
	// functionalities, including data synchronization, are halted. - Any ongoing
	// data synchronization job will be canceled. - No future data synchronization
	// runs will be scheduled nor can be triggered.
	LatestPauseTime string `json:"latestPauseTime,omitempty"`
	// Name: Output only. The full resource name of the Data Connector. Format:
	// `projects/*/locations/*/collections/*/dataConnector`.
	Name string `json:"name,omitempty"`
	// NextSyncTime: Defines the scheduled time for the next data synchronization.
	// This field requires hour , minute, and time_zone from the IANA Time Zone
	// Database (https://www.iana.org/time-zones). This is utilized when the data
	// connector has a refresh interval greater than 1 day. When the hours or
	// minutes are not specified, we will assume a sync time of 0:00. The user must
	// provide a time zone to avoid ambiguity.
	NextSyncTime *GoogleTypeDateTime `json:"nextSyncTime,omitempty"`
	// Params: Required data connector parameters in structured json format.
	Params googleapi.RawMessage `json:"params,omitempty"`
	// PrivateConnectivityProjectId: Output only. The tenant project ID associated
	// with private connectivity connectors. This project must be allowlisted by in
	// order for the connector to function.
	PrivateConnectivityProjectId string `json:"privateConnectivityProjectId,omitempty"`
	// RealtimeState: Output only. real-time sync state
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value.
	//   "CREATING" - The connector is being set up.
	//   "ACTIVE" - The connector is successfully set up and awaiting next sync
	// run.
	//   "FAILED" - The connector is in error. The error details can be found in
	// DataConnector.errors. If the error is unfixable, the DataConnector can be
	// deleted by [CollectionService.DeleteCollection] API.
	//   "RUNNING" - The connector is actively syncing records from the data
	// source.
	//   "WARNING" - The connector has completed a sync run, but encountered
	// non-fatal errors.
	//   "INITIALIZATION_FAILED" - Connector initialization failed. Potential
	// causes include runtime errors or issues in the asynchronous pipeline,
	// preventing the request from reaching downstream services (except for some
	// connector types).
	//   "UPDATING" - Connector is in the process of an update.
	RealtimeState string `json:"realtimeState,omitempty"`
	// RealtimeSyncConfig: Optional. The configuration for realtime sync.
	RealtimeSyncConfig *GoogleCloudDiscoveryengineV1alphaDataConnectorRealtimeSyncConfig `json:"realtimeSyncConfig,omitempty"`
	// RefreshInterval: Required. The refresh interval for data sync. If duration
	// is set to 0, the data will be synced in real time. The streaming feature is
	// not supported yet. The minimum is 30 minutes and maximum is 7 days. When the
	// refresh interval is set to the same value as the incremental refresh
	// interval, incremental sync will be disabled.
	RefreshInterval string `json:"refreshInterval,omitempty"`
	// RemoveParamKeys: Optional. Specifies keys to be removed from the 'params'
	// field. This is only active when 'params' is included in the 'update_mask' in
	// an UpdateDataConnectorRequest. Deletion takes precedence if a key is both in
	// 'remove_param_keys' and present in the 'params' field of the request.
	RemoveParamKeys []string `json:"removeParamKeys,omitempty"`
	// State: Output only. State of the connector.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value.
	//   "CREATING" - The connector is being set up.
	//   "ACTIVE" - The connector is successfully set up and awaiting next sync
	// run.
	//   "FAILED" - The connector is in error. The error details can be found in
	// DataConnector.errors. If the error is unfixable, the DataConnector can be
	// deleted by [CollectionService.DeleteCollection] API.
	//   "RUNNING" - The connector is actively syncing records from the data
	// source.
	//   "WARNING" - The connector has completed a sync run, but encountered
	// non-fatal errors.
	//   "INITIALIZATION_FAILED" - Connector initialization failed. Potential
	// causes include runtime errors or issues in the asynchronous pipeline,
	// preventing the request from reaching downstream services (except for some
	// connector types).
	//   "UPDATING" - Connector is in the process of an update.
	State string `json:"state,omitempty"`
	// StaticIpAddresses: Output only. The static IP addresses used by this
	// connector.
	StaticIpAddresses []string `json:"staticIpAddresses,omitempty"`
	// StaticIpEnabled: Optional. Whether customer has enabled static IP addresses
	// for this connector.
	StaticIpEnabled bool `json:"staticIpEnabled,omitempty"`
	// SyncMode: The data synchronization mode supported by the data connector.
	//
	// Possible values:
	//   "PERIODIC" - The connector will sync data periodically based on the
	// refresh_interval. Use it with auto_run_disabled to pause the periodic sync,
	// or indicate a one-time sync.
	//   "STREAMING" - The data will be synced in real time.
	//   "UNSPECIFIED" - Connector that doesn't ingest data will have this value
	SyncMode string `json:"syncMode,omitempty"`
	// UpdateTime: Output only. Timestamp the DataConnector was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AclEnabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AclEnabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDataConnector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDataConnector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDataConnectorEndUserConfig: Any params and
// credentials used specifically for EUA connectors.
type GoogleCloudDiscoveryengineV1alphaDataConnectorEndUserConfig struct {
	// AdditionalParams: Optional. Any additional parameters needed for EUA.
	AdditionalParams googleapi.RawMessage `json:"additionalParams,omitempty"`
	// AuthParams: Optional. Any authentication parameters specific to EUA
	// connectors.
	AuthParams googleapi.RawMessage `json:"authParams,omitempty"`
	// JsonAuthParams: Optional. Any authentication parameters specific to EUA
	// connectors in json string format.
	JsonAuthParams string `json:"jsonAuthParams,omitempty"`
	// Tenant: Optional. The tenant project the connector is connected to.
	Tenant *GoogleCloudDiscoveryengineV1alphaTenant `json:"tenant,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalParams") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalParams") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDataConnectorEndUserConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDataConnectorEndUserConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDataConnectorFederatedConfig: Any params
// and credentials used specifically for hybrid connectors supporting FEDERATED
// mode.
type GoogleCloudDiscoveryengineV1alphaDataConnectorFederatedConfig struct {
	// AdditionalParams: Optional. Any additional parameters needed for FEDERATED.
	AdditionalParams googleapi.RawMessage `json:"additionalParams,omitempty"`
	// AuthParams: Optional. Any authentication parameters specific to FEDERATED
	// connectors.
	AuthParams googleapi.RawMessage `json:"authParams,omitempty"`
	// JsonAuthParams: Optional. Any authentication parameters specific to
	// FEDERATED connectors in json string format.
	JsonAuthParams string `json:"jsonAuthParams,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalParams") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalParams") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDataConnectorFederatedConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDataConnectorFederatedConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDataConnectorRealtimeSyncConfig: The
// configuration for realtime sync to store additional params for realtime
// sync.
type GoogleCloudDiscoveryengineV1alphaDataConnectorRealtimeSyncConfig struct {
	// RealtimeSyncSecret: Optional. The ID of the Secret Manager secret used for
	// webhook secret.
	RealtimeSyncSecret string `json:"realtimeSyncSecret,omitempty"`
	// StreamingError: Optional. Streaming error details.
	StreamingError *GoogleCloudDiscoveryengineV1alphaDataConnectorRealtimeSyncConfigStreamingError `json:"streamingError,omitempty"`
	// WebhookUri: Optional. Webhook url for the connector to specify additional
	// params for realtime sync.
	WebhookUri string `json:"webhookUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RealtimeSyncSecret") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RealtimeSyncSecret") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDataConnectorRealtimeSyncConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaD