// Copyright 2025 Huawei Technologies Co.,Ltd.
//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package signer

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/auth/signer/algorithm"
	"github.com/stretchr/testify/assert"
	"testing"
)

func TestGetSigner(t *testing.T) {
	cases := []struct {
		Name      string
		Algorithm algorithm.SigningAlgorithm
		Signer    IAKSKSigner
	}{
		{"HmacSHA256", algorithm.HmacSHA256, Signer{}},
		{"HmacSM3", algorithm.HmacSM3, SM3Signer{}},
		{"EcdsaP256SHA256", algorithm.EcdsaP256SHA256, P256SHA256Signer{}},
		{"SM2SM3", algorithm.SM2SM3, SM2SM3Signer{}},
	}

	for _, c := range cases {
		t.Run(c.Name, func(t *testing.T) {
			signer, err := GetSigner(c.Algorithm)
			assert.NoError(t, err)
			assert.Equal(t, c.Signer, signer)
		})
	}
}
