package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// MoveGroupResponse Response Object
type MoveGroupResponse struct {

	// 返回结果
	Result *[]MoveJobGroupResponseBodyResult `json:"result,omitempty"`

	// 返回错误信息
	Error *string `json:"error,omitempty"`

	// 返回状态信息
	Status         *string `json:"status,omitempty"`
	HttpStatusCode int     `json:"-"`
}

func (o MoveGroupResponse) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "MoveGroupResponse struct{}"
	}

	return strings.Join([]string{"MoveGroupResponse", string(data)}, " ")
}
