package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"errors"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/converter"

	"strings"
)

type UpdateNatGatewayOption struct {

	// 公网NAT网关实例的名字，长度限制为64。 公网NAT网关实例的名字仅支持数字、字母、_（下划线）、-（中划线）、中文。
	Name *string `json:"name,omitempty"`

	// 公网NAT网关的描述，长度范围小于等于255个字符，不能包含“<”和“>”。
	Description *string `json:"description,omitempty"`

	// 公网NAT网关的规格。 取值为： - 1：小型，SNAT最大连接数10000 - 2：中型，SNAT最大连接数50000 - 3：大型，SNAT最大连接数200000 - 4：超大型，SNAT最大连接数1000000 - 5：企业型，SNAT最大连接数10000000
	Spec *UpdateNatGatewayOptionSpec `json:"spec,omitempty"`

	SessionConf *SessionConfiguration `json:"session_conf,omitempty"`

	PrepaidOptions *UpdateNatGatewayOptionPrepaidOptions `json:"prepaid_options,omitempty"`
}

func (o UpdateNatGatewayOption) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "UpdateNatGatewayOption struct{}"
	}

	return strings.Join([]string{"UpdateNatGatewayOption", string(data)}, " ")
}

type UpdateNatGatewayOptionSpec struct {
	value string
}

type UpdateNatGatewayOptionSpecEnum struct {
	E_1 UpdateNatGatewayOptionSpec
	E_2 UpdateNatGatewayOptionSpec
	E_3 UpdateNatGatewayOptionSpec
	E_4 UpdateNatGatewayOptionSpec
	E_5 UpdateNatGatewayOptionSpec
}

func GetUpdateNatGatewayOptionSpecEnum() UpdateNatGatewayOptionSpecEnum {
	return UpdateNatGatewayOptionSpecEnum{
		E_1: UpdateNatGatewayOptionSpec{
			value: "1",
		},
		E_2: UpdateNatGatewayOptionSpec{
			value: "2",
		},
		E_3: UpdateNatGatewayOptionSpec{
			value: "3",
		},
		E_4: UpdateNatGatewayOptionSpec{
			value: "4",
		},
		E_5: UpdateNatGatewayOptionSpec{
			value: "5",
		},
	}
}

func (c UpdateNatGatewayOptionSpec) Value() string {
	return c.value
}

func (c UpdateNatGatewayOptionSpec) MarshalJSON() ([]byte, error) {
	return utils.Marshal(c.value)
}

func (c *UpdateNatGatewayOptionSpec) UnmarshalJSON(b []byte) error {
	myConverter := converter.StringConverterFactory("string")
	if myConverter == nil {
		return errors.New("unsupported StringConverter type: string")
	}

	interf, err := myConverter.CovertStringToInterface(strings.Trim(string(b[:]), "\""))
	if err != nil {
		return err
	}

	if val, ok := interf.(string); ok {
		c.value = val
		return nil
	} else {
		return errors.New("convert enum data to string error")
	}
}
