package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"errors"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/converter"

	"strings"
)

type Vulnerability struct {

	// 漏洞ID
	Id *string `json:"id,omitempty"`

	// 含有漏洞的软件包名称
	Package *string `json:"package,omitempty"`

	// 含有漏洞的软件包版本号
	Version *string `json:"version,omitempty"`

	// 漏洞修复的软件包版本号
	FixVersion *string `json:"fix_version,omitempty"`

	// 漏洞的严重程度，Low(低危), Medium(中危), High(高危), Critical(严重)
	Severity *VulnerabilitySeverity `json:"severity,omitempty"`

	// 漏洞的描述信息
	Description *string `json:"description,omitempty"`

	// 漏洞的相关链接信息
	Links *[]string `json:"links,omitempty"`

	// 哪些镜像层包含此漏洞
	ArtifactDigests *[]string `json:"artifact_digests,omitempty"`

	PreferredCvss *VulnerabilityPreferredCvss `json:"preferred_cvss,omitempty"`

	// 与此漏洞相关的CWE ID列表
	CweIds *[]string `json:"cwe_ids,omitempty"`
}

func (o Vulnerability) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "Vulnerability struct{}"
	}

	return strings.Join([]string{"Vulnerability", string(data)}, " ")
}

type VulnerabilitySeverity struct {
	value string
}

type VulnerabilitySeverityEnum struct {
	LOW      VulnerabilitySeverity
	MEDIUM   VulnerabilitySeverity
	HIGH     VulnerabilitySeverity
	CRITICAL VulnerabilitySeverity
}

func GetVulnerabilitySeverityEnum() VulnerabilitySeverityEnum {
	return VulnerabilitySeverityEnum{
		LOW: VulnerabilitySeverity{
			value: "Low",
		},
		MEDIUM: VulnerabilitySeverity{
			value: "Medium",
		},
		HIGH: VulnerabilitySeverity{
			value: "High",
		},
		CRITICAL: VulnerabilitySeverity{
			value: "Critical",
		},
	}
}

func (c VulnerabilitySeverity) Value() string {
	return c.value
}

func (c VulnerabilitySeverity) MarshalJSON() ([]byte, error) {
	return utils.Marshal(c.value)
}

func (c *VulnerabilitySeverity) UnmarshalJSON(b []byte) error {
	myConverter := converter.StringConverterFactory("string")
	if myConverter == nil {
		return errors.New("unsupported StringConverter type: string")
	}

	interf, err := myConverter.CovertStringToInterface(strings.Trim(string(b[:]), "\""))
	if err != nil {
		return err
	}

	if val, ok := interf.(string); ok {
		c.value = val
		return nil
	} else {
		return errors.New("convert enum data to string error")
	}
}
