// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package translate

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateParallelData = "CreateParallelData"

// CreateParallelDataRequest generates a "aws/request.Request" representing the
// client's request for the CreateParallelData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateParallelData for more information on using the CreateParallelData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateParallelDataRequest method.
//	req, resp := client.CreateParallelDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/CreateParallelData
func (c *Translate) CreateParallelDataRequest(input *CreateParallelDataInput) (req *request.Request, output *CreateParallelDataOutput) {
	op := &request.Operation{
		Name:       opCreateParallelData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateParallelDataInput{}
	}

	output = &CreateParallelDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateParallelData API operation for Amazon Translate.
//
// Creates a parallel data resource in Amazon Translate by importing an input
// file from Amazon S3. Parallel data files contain examples that show how you
// want segments of text to be translated. By adding parallel data, you can
// influence the style, tone, and word choice in your translation output.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation CreateParallelData for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     The value of the parameter is not valid. Review the value of the parameter
//     you are using to correct it, and then retry your operation.
//
//   - InvalidRequestException
//     The request that you made is not valid. Check your request to determine why
//     it's not valid and then retry the request.
//
//   - LimitExceededException
//     The specified limit has been exceeded. Review your request and retry it with
//     a quantity below the stated limit.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again.
//
//   - ConflictException
//     There was a conflict processing the request. Try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/CreateParallelData
func (c *Translate) CreateParallelData(input *CreateParallelDataInput) (*CreateParallelDataOutput, error) {
	req, out := c.CreateParallelDataRequest(input)
	return out, req.Send()
}

// CreateParallelDataWithContext is the same as CreateParallelData with the addition of
// the ability to pass a context and additional request options.
//
// See CreateParallelData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) CreateParallelDataWithContext(ctx aws.Context, input *CreateParallelDataInput, opts ...request.Option) (*CreateParallelDataOutput, error) {
	req, out := c.CreateParallelDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteParallelData = "DeleteParallelData"

// DeleteParallelDataRequest generates a "aws/request.Request" representing the
// client's request for the DeleteParallelData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteParallelData for more information on using the DeleteParallelData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteParallelDataRequest method.
//	req, resp := client.DeleteParallelDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DeleteParallelData
func (c *Translate) DeleteParallelDataRequest(input *DeleteParallelDataInput) (req *request.Request, output *DeleteParallelDataOutput) {
	op := &request.Operation{
		Name:       opDeleteParallelData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteParallelDataInput{}
	}

	output = &DeleteParallelDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteParallelData API operation for Amazon Translate.
//
// Deletes a parallel data resource in Amazon Translate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation DeleteParallelData for usage and error information.
//
// Returned Error Types:
//
//   - ConcurrentModificationException
//     Another modification is being made. That modification must complete before
//     you can make your change.
//
//   - ResourceNotFoundException
//     The resource you are looking for has not been found. Review the resource
//     you're looking for and see if a different resource will accomplish your needs
//     before retrying the revised request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DeleteParallelData
func (c *Translate) DeleteParallelData(input *DeleteParallelDataInput) (*DeleteParallelDataOutput, error) {
	req, out := c.DeleteParallelDataRequest(input)
	return out, req.Send()
}

// DeleteParallelDataWithContext is the same as DeleteParallelData with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteParallelData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) DeleteParallelDataWithContext(ctx aws.Context, input *DeleteParallelDataInput, opts ...request.Option) (*DeleteParallelDataOutput, error) {
	req, out := c.DeleteParallelDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTerminology = "DeleteTerminology"

// DeleteTerminologyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTerminology operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTerminology for more information on using the DeleteTerminology
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTerminologyRequest method.
//	req, resp := client.DeleteTerminologyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DeleteTerminology
func (c *Translate) DeleteTerminologyRequest(input *DeleteTerminologyInput) (req *request.Request, output *DeleteTerminologyOutput) {
	op := &request.Operation{
		Name:       opDeleteTerminology,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTerminologyInput{}
	}

	output = &DeleteTerminologyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTerminology API operation for Amazon Translate.
//
// A synchronous action that deletes a custom terminology.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation DeleteTerminology for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you are looking for has not been found. Review the resource
//     you're looking for and see if a different resource will accomplish your needs
//     before retrying the revised request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again.
//
//   - InvalidParameterValueException
//     The value of the parameter is not valid. Review the value of the parameter
//     you are using to correct it, and then retry your operation.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DeleteTerminology
func (c *Translate) DeleteTerminology(input *DeleteTerminologyInput) (*DeleteTerminologyOutput, error) {
	req, out := c.DeleteTerminologyRequest(input)
	return out, req.Send()
}

// DeleteTerminologyWithContext is the same as DeleteTerminology with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTerminology for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) DeleteTerminologyWithContext(ctx aws.Context, input *DeleteTerminologyInput, opts ...request.Option) (*DeleteTerminologyOutput, error) {
	req, out := c.DeleteTerminologyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTextTranslationJob = "DescribeTextTranslationJob"

// DescribeTextTranslationJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTextTranslationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTextTranslationJob for more information on using the DescribeTextTranslationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTextTranslationJobRequest method.
//	req, resp := client.DescribeTextTranslationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DescribeTextTranslationJob
func (c *Translate) DescribeTextTranslationJobRequest(input *DescribeTextTranslationJobInput) (req *request.Request, output *DescribeTextTranslationJobOutput) {
	op := &request.Operation{
		Name:       opDescribeTextTranslationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTextTranslationJobInput{}
	}

	output = &DescribeTextTranslationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTextTranslationJob API operation for Amazon Translate.
//
// Gets the properties associated with an asynchronous batch translation job
// including name, ID, status, source and target languages, input/output S3
// buckets, and so on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation DescribeTextTranslationJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you are looking for has not been found. Review the resource
//     you're looking for and see if a different resource will accomplish your needs
//     before retrying the revised request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DescribeTextTranslationJob
func (c *Translate) DescribeTextTranslationJob(input *DescribeTextTranslationJobInput) (*DescribeTextTranslationJobOutput, error) {
	req, out := c.DescribeTextTranslationJobRequest(input)
	return out, req.Send()
}

// DescribeTextTranslationJobWithContext is the same as DescribeTextTranslationJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTextTranslationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) DescribeTextTranslationJobWithContext(ctx aws.Context, input *DescribeTextTranslationJobInput, opts ...request.Option) (*DescribeTextTranslationJobOutput, error) {
	req, out := c.DescribeTextTranslationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetParallelData = "GetParallelData"

// GetParallelDataRequest generates a "aws/request.Request" representing the
// client's request for the GetParallelData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetParallelData for more information on using the GetParallelData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetParallelDataRequest method.
//	req, resp := client.GetParallelDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/GetParallelData
func (c *Translate) GetParallelDataRequest(input *GetParallelDataInput) (req *request.Request, output *GetParallelDataOutput) {
	op := &request.Operation{
		Name:       opGetParallelData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetParallelDataInput{}
	}

	output = &GetParallelDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetParallelData API operation for Amazon Translate.
//
// Provides information about a parallel data resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation GetParallelData for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you are looking for has not been found. Review the resource
//     you're looking for and see if a different resource will accomplish your needs
//     before retrying the revised request.
//
//   - InvalidParameterValueException
//     The value of the parameter is not valid. Review the value of the parameter
//     you are using to correct it, and then retry your operation.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/GetParallelData
func (c *Translate) GetParallelData(input *GetParallelDataInput) (*GetParallelDataOutput, error) {
	req, out := c.GetParallelDataRequest(input)
	return out, req.Send()
}

// GetParallelDataWithContext is the same as GetParallelData with the addition of
// the ability to pass a context and additional request options.
//
// See GetParallelData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) GetParallelDataWithContext(ctx aws.Context, input *GetParallelDataInput, opts ...request.Option) (*GetParallelDataOutput, error) {
	req, out := c.GetParallelDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTerminology = "GetTerminology"

// GetTerminologyRequest generates a "aws/request.Request" representing the
// client's request for the GetTerminology operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTerminology for more information on using the GetTerminology
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTerminologyRequest method.
//	req, resp := client.GetTerminologyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/GetTerminology
func (c *Translate) GetTerminologyRequest(input *GetTerminologyInput) (req *request.Request, output *GetTerminologyOutput) {
	op := &request.Operation{
		Name:       opGetTerminology,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTerminologyInput{}
	}

	output = &GetTerminologyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTerminology API operation for Amazon Translate.
//
// Retrieves a custom terminology.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation GetTerminology for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you are looking for has not been found. Review the resource
//     you're looking for and see if a different resource will accomplish your needs
//     before retrying the revised request.
//
//   - InvalidParameterValueException
//     The value of the parameter is not valid. Review the value of the parameter
//     you are using to correct it, and then retry your operation.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/GetTerminology
func (c *Translate) GetTerminology(input *GetTerminologyInput) (*GetTerminologyOutput, error) {
	req, out := c.GetTerminologyRequest(input)
	return out, req.Send()
}

// GetTerminologyWithContext is the same as GetTerminology with the addition of
// the ability to pass a context and additional request options.
//
// See GetTerminology for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) GetTerminologyWithContext(ctx aws.Context, input *GetTerminologyInput, opts ...request.Option) (*GetTerminologyOutput, error) {
	req, out := c.GetTerminologyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportTerminology = "ImportTerminology"

// ImportTerminologyRequest generates a "aws/request.Request" representing the
// client's request for the ImportTerminology operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportTerminology for more information on using the ImportTerminology
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportTerminologyRequest method.
//	req, resp := client.ImportTerminologyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ImportTerminology
func (c *Translate) ImportTerminologyRequest(input *ImportTerminologyInput) (req *request.Request, output *ImportTerminologyOutput) {
	op := &request.Operation{
		Name:       opImportTerminology,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportTerminologyInput{}
	}

	output = &ImportTerminologyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportTerminology API operation for Amazon Translate.
//
// Creates or updates a custom terminology, depending on whether one already
// exists for the given terminology name. Importing a terminology with the same
// name as an existing one will merge the terminologies based on the chosen
// merge strategy. The only supported merge strategy is OVERWRITE, where the
// imported terminology overwrites the existing terminology of the same name.
//
// If you import a terminology that overwrites an existing one, the new terminology
// takes up to 10 minutes to fully propagate. After that, translations have
// access to the new terminology.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation ImportTerminology for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     The value of the parameter is not valid. Review the value of the parameter
//     you are using to correct it, and then retry your operation.
//
//   - LimitExceededException
//     The specified limit has been exceeded. Review your request and retry it with
//     a quantity below the stated limit.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ImportTerminology
func (c *Translate) ImportTerminology(input *ImportTerminologyInput) (*ImportTerminologyOutput, error) {
	req, out := c.ImportTerminologyRequest(input)
	return out, req.Send()
}

// ImportTerminologyWithContext is the same as ImportTerminology with the addition of
// the ability to pass a context and additional request options.
//
// See ImportTerminology for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) ImportTerminologyWithContext(ctx aws.Context, input *ImportTerminologyInput, opts ...request.Option) (*ImportTerminologyOutput, error) {
	req, out := c.ImportTerminologyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLanguages = "ListLanguages"

// ListLanguagesRequest generates a "aws/request.Request" representing the
// client's request for the ListLanguages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLanguages for more information on using the ListLanguages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLanguagesRequest method.
//	req, resp := client.ListLanguagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListLanguages
func (c *Translate) ListLanguagesRequest(input *ListLanguagesInput) (req *request.Request, output *ListLanguagesOutput) {
	op := &request.Operation{
		Name:       opListLanguages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLanguagesInput{}
	}

	output = &ListLanguagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLanguages API operation for Amazon Translate.
//
// Provides a list of languages (RFC-5646 codes and names) that Amazon Translate
// supports.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation ListLanguages for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     The value of the parameter is not valid. Review the value of the parameter
//     you are using to correct it, and then retry your operation.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again.
//
//   - UnsupportedDisplayLanguageCodeException
//     Requested display language code is not supported.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListLanguages
func (c *Translate) ListLanguages(input *ListLanguagesInput) (*ListLanguagesOutput, error) {
	req, out := c.ListLanguagesRequest(input)
	return out, req.Send()
}

// ListLanguagesWithContext is the same as ListLanguages with the addition of
// the ability to pass a context and additional request options.
//
// See ListLanguages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) ListLanguagesWithContext(ctx aws.Context, input *ListLanguagesInput, opts ...request.Option) (*ListLanguagesOutput, error) {
	req, out := c.ListLanguagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLanguagesPages iterates over the pages of a ListLanguages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLanguages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLanguages operation.
//	pageNum := 0
//	err := client.ListLanguagesPages(params,
//	    func(page *translate.ListLanguagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Translate) ListLanguagesPages(input *ListLanguagesInput, fn func(*ListLanguagesOutput, bool) bool) error {
	return c.ListLanguagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLanguagesPagesWithContext same as ListLanguagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) ListLanguagesPagesWithContext(ctx aws.Context, input *ListLanguagesInput, fn func(*ListLanguagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLanguagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLanguagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLanguagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListParallelData = "ListParallelData"

// ListParallelDataRequest generates a "aws/request.Request" representing the
// client's request for the ListParallelData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListParallelData for more information on using the ListParallelData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListParallelDataRequest method.
//	req, resp := client.ListParallelDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListParallelData
func (c *Translate) ListParallelDataRequest(input *ListParallelDataInput) (req *request.Request, output *ListParallelDataOutput) {
	op := &request.Operation{
		Name:       opListParallelData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListParallelDataInput{}
	}

	output = &ListParallelDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListParallelData API operation for Amazon Translate.
//
// Provides a list of your parallel data resources in Amazon Translate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation ListParallelData for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     The value of the parameter is not valid. Review the value of the parameter
//     you are using to correct it, and then retry your operation.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListParallelData
func (c *Translate) ListParallelData(input *ListParallelDataInput) (*ListParallelDataOutput, error) {
	req, out := c.ListParallelDataRequest(input)
	return out, req.Send()
}

// ListParallelDataWithContext is the same as ListParallelData with the addition of
// the ability to pass a context and additional request options.
//
// See ListParallelData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) ListParallelDataWithContext(ctx aws.Context, input *ListParallelDataInput, opts ...request.Option) (*ListParallelDataOutput, error) {
	req, out := c.ListParallelDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListParallelDataPages iterates over the pages of a ListParallelData operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListParallelData method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListParallelData operation.
//	pageNum := 0
//	err := client.ListParallelDataPages(params,
//	    func(page *translate.ListParallelDataOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Translate) ListParallelDataPages(input *ListParallelDataInput, fn func(*ListParallelDataOutput, bool) bool) error {
	return c.ListParallelDataPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListParallelDataPagesWithContext same as ListParallelDataPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) ListParallelDataPagesWithContext(ctx aws.Context, input *ListParallelDataInput, fn func(*ListParallelDataOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListParallelDataInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListParallelDataRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListParallelDataOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTerminologies = "ListTerminologies"

// ListTerminologiesRequest generates a "aws/request.Request" representing the
// client's request for the ListTerminologies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTerminologies for more information on using the ListTerminologies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTerminologiesRequest method.
//	req, resp := client.ListTerminologiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTerminologies
func (c *Translate) ListTerminologiesRequest(input *ListTerminologiesInput) (req *request.Request, output *ListTerminologiesOutput) {
	op := &request.Operation{
		Name:       opListTerminologies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTerminologiesInput{}
	}

	output = &ListTerminologiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTerminologies API operation for Amazon Translate.
//
// Provides a list of custom terminologies associated with your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation ListTerminologies for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     The value of the parameter is not valid. Review the value of the parameter
//     you are using to correct it, and then retry your operation.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTerminologies
func (c *Translate) ListTerminologies(input *ListTerminologiesInput) (*ListTerminologiesOutput, error) {
	req, out := c.ListTerminologiesRequest(input)
	return out, req.Send()
}

// ListTerminologiesWithContext is the same as ListTerminologies with the addition of
// the ability to pass a context and additional request options.
//
// See ListTerminologies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) ListTerminologiesWithContext(ctx aws.Context, input *ListTerminologiesInput, opts ...request.Option) (*ListTerminologiesOutput, error) {
	req, out := c.ListTerminologiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTerminologiesPages iterates over the pages of a ListTerminologies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTerminologies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTerminologies operation.
//	pageNum := 0
//	err := client.ListTerminologiesPages(params,
//	    func(page *translate.ListTerminologiesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Translate) ListTerminologiesPages(input *ListTerminologiesInput, fn func(*ListTerminologiesOutput, bool) bool) error {
	return c.ListTerminologiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTerminologiesPagesWithContext same as ListTerminologiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) ListTerminologiesPagesWithContext(ctx aws.Context, input *ListTerminologiesInput, fn func(*ListTerminologiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTerminologiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTerminologiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTerminologiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTextTranslationJobs = "ListTextTranslationJobs"

// ListTextTranslationJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListTextTranslationJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTextTranslationJobs for more information on using the ListTextTranslationJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTextTranslationJobsRequest method.
//	req, resp := client.ListTextTranslationJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTextTranslationJobs
func (c *Translate) ListTextTranslationJobsRequest(input *ListTextTranslationJobsInput) (req *request.Request, output *ListTextTranslationJobsOutput) {
	op := &request.Operation{
		Name:       opListTextTranslationJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTextTranslationJobsInput{}
	}

	output = &ListTextTranslationJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTextTranslationJobs API operation for Amazon Translate.
//
// Gets a list of the batch translation jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation ListTextTranslationJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is not valid. Check your request to determine why
//     it's not valid and then retry the request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again.
//
//   - InvalidFilterException
//     The filter specified for the operation is not valid. Specify a different
//     filter.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTextTranslationJobs
func (c *Translate) ListTextTranslationJobs(input *ListTextTranslationJobsInput) (*ListTextTranslationJobsOutput, error) {
	req, out := c.ListTextTranslationJobsRequest(input)
	return out, req.Send()
}

// ListTextTranslationJobsWithContext is the same as ListTextTranslationJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListTextTranslationJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) ListTextTranslationJobsWithContext(ctx aws.Context, input *ListTextTranslationJobsInput, opts ...request.Option) (*ListTextTranslationJobsOutput, error) {
	req, out := c.ListTextTranslationJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTextTranslationJobsPages iterates over the pages of a ListTextTranslationJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTextTranslationJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTextTranslationJobs operation.
//	pageNum := 0
//	err := client.ListTextTranslationJobsPages(params,
//	    func(page *translate.ListTextTranslationJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Translate) ListTextTranslationJobsPages(input *ListTextTranslationJobsInput, fn func(*ListTextTranslationJobsOutput, bool) bool) error {
	return c.ListTextTranslationJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTextTranslationJobsPagesWithContext same as ListTextTranslationJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) ListTextTranslationJobsPagesWithContext(ctx aws.Context, input *ListTextTranslationJobsInput, fn func(*ListTextTranslationJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTextTranslationJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTextTranslationJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTextTranslationJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartTextTranslationJob = "StartTextTranslationJob"

// StartTextTranslationJobRequest generates a "aws/request.Request" representing the
// client's request for the StartTextTranslationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTextTranslationJob for more information on using the StartTextTranslationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartTextTranslationJobRequest method.
//	req, resp := client.StartTextTranslationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/StartTextTranslationJob
func (c *Translate) StartTextTranslationJobRequest(input *StartTextTranslationJobInput) (req *request.Request, output *StartTextTranslationJobOutput) {
	op := &request.Operation{
		Name:       opStartTextTranslationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTextTranslationJobInput{}
	}

	output = &StartTextTranslationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTextTranslationJob API operation for Amazon Translate.
//
// Starts an asynchronous batch translation job. Batch translation jobs can
// be used to translate large volumes of text across multiple documents at once.
// For more information, see async.
//
// Batch translation jobs can be described with the DescribeTextTranslationJob
// operation, listed with the ListTextTranslationJobs operation, and stopped
// with the StopTextTranslationJob operation.
//
// Amazon Translate does not support batch translation of multiple source languages
// at once.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation StartTextTranslationJob for usage and error information.
//
// Returned Error Types:
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again.
//
//   - UnsupportedLanguagePairException
//     Amazon Translate does not support translation from the language of the source
//     text into the requested target language. For more information, see how-to-error-msg.
//
//   - InvalidRequestException
//     The request that you made is not valid. Check your request to determine why
//     it's not valid and then retry the request.
//
//   - ResourceNotFoundException
//     The resource you are looking for has not been found. Review the resource
//     you're looking for and see if a different resource will accomplish your needs
//     before retrying the revised request.
//
//   - InvalidParameterValueException
//     The value of the parameter is not valid. Review the value of the parameter
//     you are using to correct it, and then retry your operation.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/StartTextTranslationJob
func (c *Translate) StartTextTranslationJob(input *StartTextTranslationJobInput) (*StartTextTranslationJobOutput, error) {
	req, out := c.StartTextTranslationJobRequest(input)
	return out, req.Send()
}

// StartTextTranslationJobWithContext is the same as StartTextTranslationJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartTextTranslationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) StartTextTranslationJobWithContext(ctx aws.Context, input *StartTextTranslationJobInput, opts ...request.Option) (*StartTextTranslationJobOutput, error) {
	req, out := c.StartTextTranslationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopTextTranslationJob = "StopTextTranslationJob"

// StopTextTranslationJobRequest generates a "aws/request.Request" representing the
// client's request for the StopTextTranslationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopTextTranslationJob for more information on using the StopTextTranslationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopTextTranslationJobRequest method.
//	req, resp := client.StopTextTranslationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/StopTextTranslationJob
func (c *Translate) StopTextTranslationJobRequest(input *StopTextTranslationJobInput) (req *request.Request, output *StopTextTranslationJobOutput) {
	op := &request.Operation{
		Name:       opStopTextTranslationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopTextTranslationJobInput{}
	}

	output = &StopTextTranslationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopTextTranslationJob API operation for Amazon Translate.
//
// Stops an asynchronous batch translation job that is in progress.
//
// If the job's state is IN_PROGRESS, the job will be marked for termination
// and put into the STOP_REQUESTED state. If the job completes before it can
// be stopped, it is put into the COMPLETED state. Otherwise, the job is put
// into the STOPPED state.
//
// Asynchronous batch translation jobs are started with the StartTextTranslationJob
// operation. You can use the DescribeTextTranslationJob or ListTextTranslationJobs
// operations to get a batch translation job's JobId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation StopTextTranslationJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you are looking for has not been found. Review the resource
//     you're looking for and see if a different resource will accomplish your needs
//     before retrying the revised request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/StopTextTranslationJob
func (c *Translate) StopTextTranslationJob(input *StopTextTranslationJobInput) (*StopTextTranslationJobOutput, error) {
	req, out := c.StopTextTranslationJobRequest(input)
	return out, req.Send()
}

// StopTextTranslationJobWithContext is the same as StopTextTranslationJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopTextTranslationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) StopTextTranslationJobWithContext(ctx aws.Context, input *StopTextTranslationJobInput, opts ...request.Option) (*StopTextTranslationJobOutput, error) {
	req, out := c.StopTextTranslationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opText = "TranslateText"

// TextRequest generates a "aws/request.Request" representing the
// client's request for the Text operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Text for more information on using the Text
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TextRequest method.
//	req, resp := client.TextRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/Text
func (c *Translate) TextRequest(input *TextInput) (req *request.Request, output *TextOutput) {
	op := &request.Operation{
		Name:       opText,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TextInput{}
	}

	output = &TextOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Text API operation for Amazon Translate.
//
// Translates input text from the source language to the target language. For
// a list of available languages and language codes, see what-is-languages.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation Text for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is not valid. Check your request to determine why
//     it's not valid and then retry the request.
//
//   - TextSizeLimitExceededException
//     The size of the text you submitted exceeds the size limit. Reduce the size
//     of the text or use a smaller document and then retry your request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again.
//
//   - UnsupportedLanguagePairException
//     Amazon Translate does not support translation from the language of the source
//     text into the requested target language. For more information, see how-to-error-msg.
//
//   - DetectedLanguageLowConfidenceException
//     The confidence that Amazon Comprehend accurately detected the source language
//     is low. If a low confidence level is acceptable for your application, you
//     can use the language in the exception to call Amazon Translate again. For
//     more information, see the DetectDominantLanguage (https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectDominantLanguage.html)
//     operation in the Amazon Comprehend Developer Guide.
//
//   - ResourceNotFoundException
//     The resource you are looking for has not been found. Review the resource
//     you're looking for and see if a different resource will accomplish your needs
//     before retrying the revised request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ServiceUnavailableException
//     The Amazon Translate service is temporarily unavailable. Wait a bit and then
//     retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/Text
func (c *Translate) Text(input *TextInput) (*TextOutput, error) {
	req, out := c.TextRequest(input)
	return out, req.Send()
}

// TextWithContext is the same as Text with the addition of
// the ability to pass a context and additional request options.
//
// See Text for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) TextWithContext(ctx aws.Context, input *TextInput, opts ...request.Option) (*TextOutput, error) {
	req, out := c.TextRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateParallelData = "UpdateParallelData"

// UpdateParallelDataRequest generates a "aws/request.Request" representing the
// client's request for the UpdateParallelData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateParallelData for more information on using the UpdateParallelData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateParallelDataRequest method.
//	req, resp := client.UpdateParallelDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/UpdateParallelData
func (c *Translate) UpdateParallelDataRequest(input *UpdateParallelDataInput) (req *request.Request, output *UpdateParallelDataOutput) {
	op := &request.Operation{
		Name:       opUpdateParallelData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateParallelDataInput{}
	}

	output = &UpdateParallelDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateParallelData API operation for Amazon Translate.
//
// Updates a previously created parallel data resource by importing a new input
// file from Amazon S3.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation UpdateParallelData for usage and error information.
//
// Returned Error Types:
//
//   - ConcurrentModificationException
//     Another modification is being made. That modification must complete before
//     you can make your change.
//
//   - InvalidParameterValueException
//     The value of the parameter is not valid. Review the value of the parameter
//     you are using to correct it, and then retry your operation.
//
//   - InvalidRequestException
//     The request that you made is not valid. Check your request to determine why
//     it's not valid and then retry the request.
//
//   - LimitExceededException
//     The specified limit has been exceeded. Review your request and retry it with
//     a quantity below the stated limit.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again.
//
//   - ConflictException
//     There was a conflict processing the request. Try your request again.
//
//   - ResourceNotFoundException
//     The resource you are looking for has not been found. Review the resource
//     you're looking for and see if a different resource will accomplish your needs
//     before retrying the revised request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/UpdateParallelData
func (c *Translate) UpdateParallelData(input *UpdateParallelDataInput) (*UpdateParallelDataOutput, error) {
	req, out := c.UpdateParallelDataRequest(input)
	return out, req.Send()
}

// UpdateParallelDataWithContext is the same as UpdateParallelData with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateParallelData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) UpdateParallelDataWithContext(ctx aws.Context, input *UpdateParallelDataInput, opts ...request.Option) (*UpdateParallelDataOutput, error) {
	req, out := c.UpdateParallelDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The custom terminology applied to the input text by Amazon Translate for
// the translated text response. This is optional in the response and will only
// be present if you specified terminology input in the request. Currently,
// only one terminology can be applied per TranslateText request.
type AppliedTerminology struct {
	_ struct{} `type:"structure"`

	// The name of the custom terminology applied to the input text by Amazon Translate
	// for the translated text response.
	Name *string `min:"1" type:"string"`

	// The specific terms of the custom terminology applied to the input text by
	// Amazon Translate for the translated text response. A maximum of 250 terms
	// will be returned, and the specific terms applied will be the first 250 terms
	// in the source text.
	Terms []*Term `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppliedTerminology) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppliedTerminology) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AppliedTerminology) SetName(v string) *AppliedTerminology {
	s.Name = &v
	return s
}

// SetTerms sets the Terms field's value.
func (s *AppliedTerminology) SetTerms(v []*Term) *AppliedTerminology {
	s.Terms = v
	return s
}

// Another modification is being made. That modification must complete before
// you can make your change.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There was a conflict processing the request. Try your request again.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateParallelDataInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. This token is automatically generated
	// when you use Amazon Translate through an AWS SDK.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A custom description for the parallel data resource in Amazon Translate.
	Description *string `type:"string"`

	// The encryption key used to encrypt this object.
	EncryptionKey *EncryptionKey `type:"structure"`

	// A custom name for the parallel data resource in Amazon Translate. You must
	// assign a name that is unique in the account and region.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies the format and S3 location of the parallel data input file.
	//
	// ParallelDataConfig is a required field
	ParallelDataConfig *ParallelDataConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParallelDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParallelDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateParallelDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateParallelDataInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ParallelDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ParallelDataConfig"))
	}
	if s.EncryptionKey != nil {
		if err := s.EncryptionKey.Validate(); err != nil {
			invalidParams.AddNested("EncryptionKey", err.(request.ErrInvalidParams))
		}
	}
	if s.ParallelDataConfig != nil {
		if err := s.ParallelDataConfig.Validate(); err != nil {
			invalidParams.AddNested("ParallelDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateParallelDataInput) SetClientToken(v string) *CreateParallelDataInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateParallelDataInput) SetDescription(v string) *CreateParallelDataInput {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *CreateParallelDataInput) SetEncryptionKey(v *EncryptionKey) *CreateParallelDataInput {
	s.EncryptionKey = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateParallelDataInput) SetName(v string) *CreateParallelDataInput {
	s.Name = &v
	return s
}

// SetParallelDataConfig sets the ParallelDataConfig field's value.
func (s *CreateParallelDataInput) SetParallelDataConfig(v *ParallelDataConfig) *CreateParallelDataInput {
	s.ParallelDataConfig = v
	return s
}

type CreateParallelDataOutput struct {
	_ struct{} `type:"structure"`

	// The custom name that you assigned to the parallel data resource.
	Name *string `min:"1" type:"string"`

	// The status of the parallel data resource. When the resource is ready for
	// you to use, the status is ACTIVE.
	Status *string `type:"string" enum:"ParallelDataStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParallelDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParallelDataOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CreateParallelDataOutput) SetName(v string) *CreateParallelDataOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateParallelDataOutput) SetStatus(v string) *CreateParallelDataOutput {
	s.Status = &v
	return s
}

type DeleteParallelDataInput struct {
	_ struct{} `type:"structure"`

	// The name of the parallel data resource that is being deleted.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteParallelDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteParallelDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteParallelDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteParallelDataInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteParallelDataInput) SetName(v string) *DeleteParallelDataInput {
	s.Name = &v
	return s
}

type DeleteParallelDataOutput struct {
	_ struct{} `type:"structure"`

	// The name of the parallel data resource that is being deleted.
	Name *string `min:"1" type:"string"`

	// The status of the parallel data deletion.
	Status *string `type:"string" enum:"ParallelDataStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteParallelDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteParallelDataOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DeleteParallelDataOutput) SetName(v string) *DeleteParallelDataOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteParallelDataOutput) SetStatus(v string) *DeleteParallelDataOutput {
	s.Status = &v
	return s
}

type DeleteTerminologyInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom terminology being deleted.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTerminologyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTerminologyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTerminologyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTerminologyInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteTerminologyInput) SetName(v string) *DeleteTerminologyInput {
	s.Name = &v
	return s
}

type DeleteTerminologyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTerminologyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTerminologyOutput) GoString() string {
	return s.String()
}

type DescribeTextTranslationJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Translate generated for the job. The StartTextTranslationJob
	// operation returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTextTranslationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTextTranslationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTextTranslationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTextTranslationJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeTextTranslationJobInput) SetJobId(v string) *DescribeTextTranslationJobInput {
	s.JobId = &v
	return s
}

type DescribeTextTranslationJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with an asynchronous batch
	// translation job.
	TextTranslationJobProperties *TextTranslationJobProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTextTranslationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTextTranslationJobOutput) GoString() string {
	return s.String()
}

// SetTextTranslationJobProperties sets the TextTranslationJobProperties field's value.
func (s *DescribeTextTranslationJobOutput) SetTextTranslationJobProperties(v *TextTranslationJobProperties) *DescribeTextTranslationJobOutput {
	s.TextTranslationJobProperties = v
	return s
}

// The confidence that Amazon Comprehend accurately detected the source language
// is low. If a low confidence level is acceptable for your application, you
// can use the language in the exception to call Amazon Translate again. For
// more information, see the DetectDominantLanguage (https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectDominantLanguage.html)
// operation in the Amazon Comprehend Developer Guide.
type DetectedLanguageLowConfidenceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The language code of the auto-detected language from Amazon Comprehend.
	DetectedLanguageCode *string `min:"2" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectedLanguageLowConfidenceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectedLanguageLowConfidenceException) GoString() string {
	return s.String()
}

func newErrorDetectedLanguageLowConfidenceException(v protocol.ResponseMetadata) error {
	return &DetectedLanguageLowConfidenceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DetectedLanguageLowConfidenceException) Code() string {
	return "DetectedLanguageLowConfidenceException"
}

// Message returns the exception's message.
func (s *DetectedLanguageLowConfidenceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DetectedLanguageLowConfidenceException) OrigErr() error {
	return nil
}

func (s *DetectedLanguageLowConfidenceException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DetectedLanguageLowConfidenceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DetectedLanguageLowConfidenceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The encryption key used to encrypt this object.
type EncryptionKey struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the encryption key being used to encrypt
	// this object.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The type of encryption key used by Amazon Translate to encrypt this object.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"EncryptionKeyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionKey) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionKey) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionKey"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *EncryptionKey) SetId(v string) *EncryptionKey {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *EncryptionKey) SetType(v string) *EncryptionKey {
	s.Type = &v
	return s
}

type GetParallelDataInput struct {
	_ struct{} `type:"structure"`

	// The name of the parallel data resource that is being retrieved.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParallelDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParallelDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetParallelDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetParallelDataInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetParallelDataInput) SetName(v string) *GetParallelDataInput {
	s.Name = &v
	return s
}

type GetParallelDataOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location of a file that provides any errors or warnings that
	// were produced by your input file. This file was created when Amazon Translate
	// attempted to create a parallel data resource. The location is returned as
	// a presigned URL to that has a 30-minute expiration.
	AuxiliaryDataLocation *ParallelDataDataLocation `type:"structure"`

	// The Amazon S3 location of the most recent parallel data input file that was
	// successfully imported into Amazon Translate. The location is returned as
	// a presigned URL that has a 30-minute expiration.
	//
	// Amazon Translate doesn't scan all input files for the risk of CSV injection
	// attacks.
	//
	// CSV injection occurs when a .csv or .tsv file is altered so that a record
	// contains malicious code. The record begins with a special character, such
	// as =, +, -, or @. When the file is opened in a spreadsheet program, the program
	// might interpret the record as a formula and run the code within it.
	//
	// Before you download an input file from Amazon S3, ensure that you recognize
	// the file and trust its creator.
	DataLocation *ParallelDataDataLocation `type:"structure"`

	// The Amazon S3 location of a file that provides any errors or warnings that
	// were produced by your input file. This file was created when Amazon Translate
	// attempted to update a parallel data resource. The location is returned as
	// a presigned URL to that has a 30-minute expiration.
	LatestUpdateAttemptAuxiliaryDataLocation *ParallelDataDataLocation `type:"structure"`

	// The properties of the parallel data resource that is being retrieved.
	ParallelDataProperties *ParallelDataProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParallelDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParallelDataOutput) GoString() string {
	return s.String()
}

// SetAuxiliaryDataLocation sets the AuxiliaryDataLocation field's value.
func (s *GetParallelDataOutput) SetAuxiliaryDataLocation(v *ParallelDataDataLocation) *GetParallelDataOutput {
	s.AuxiliaryDataLocation = v
	return s
}

// SetDataLocation sets the DataLocation field's value.
func (s *GetParallelDataOutput) SetDataLocation(v *ParallelDataDataLocation) *GetParallelDataOutput {
	s.DataLocation = v
	return s
}

// SetLatestUpdateAttemptAuxiliaryDataLocation sets the LatestUpdateAttemptAuxiliaryDataLocation field's value.
func (s *GetParallelDataOutput) SetLatestUpdateAttemptAuxiliaryDataLocation(v *ParallelDataDataLocation) *GetParallelDataOutput {
	s.LatestUpdateAttemptAuxiliaryDataLocation = v
	return s
}

// SetParallelDataProperties sets the ParallelDataProperties field's value.
func (s *GetParallelDataOutput) SetParallelDataProperties(v *ParallelDataProperties) *GetParallelDataOutput {
	s.ParallelDataProperties = v
	return s
}

type GetTerminologyInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom terminology being retrieved.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The data format of the custom terminology being retrieved.
	//
	// If you don't specify this parameter, Amazon Translate returns a file with
	// the same format as the file that was imported to create the terminology.
	//
	// If you specify this parameter when you retrieve a multi-directional terminology
	// resource, you must specify the same format as the input file that was imported
	// to create it. Otherwise, Amazon Translate throws an error.
	TerminologyDataFormat *string `type:"string" enum:"TerminologyDataFormat"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTerminologyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTerminologyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTerminologyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTerminologyInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetTerminologyInput) SetName(v string) *GetTerminologyInput {
	s.Name = &v
	return s
}

// SetTerminologyDataFormat sets the TerminologyDataFormat field's value.
func (s *GetTerminologyInput) SetTerminologyDataFormat(v string) *GetTerminologyInput {
	s.TerminologyDataFormat = &v
	return s
}

type GetTerminologyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location of a file that provides any errors or warnings that
	// were produced by your input file. This file was created when Amazon Translate
	// attempted to create a terminology resource. The location is returned as a
	// presigned URL to that has a 30-minute expiration.
	AuxiliaryDataLocation *TerminologyDataLocation `type:"structure"`

	// The Amazon S3 location of the most recent custom terminology input file that
	// was successfully imported into Amazon Translate. The location is returned
	// as a presigned URL that has a 30-minute expiration.
	//
	// Amazon Translate doesn't scan all input files for the risk of CSV injection
	// attacks.
	//
	// CSV injection occurs when a .csv or .tsv file is altered so that a record
	// contains malicious code. The record begins with a special character, such
	// as =, +, -, or @. When the file is opened in a spreadsheet program, the program
	// might interpret the record as a formula and run the code within it.
	//
	// Before you download an input file from Amazon S3, ensure that you recognize
	// the file and trust its creator.
	TerminologyDataLocation *TerminologyDataLocation `type:"structure"`

	// The properties of the custom terminology being retrieved.
	TerminologyProperties *TerminologyProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTerminologyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTerminologyOutput) GoString() string {
	return s.String()
}

// SetAuxiliaryDataLocation sets the AuxiliaryDataLocation field's value.
func (s *GetTerminologyOutput) SetAuxiliaryDataLocation(v *TerminologyDataLocation) *GetTerminologyOutput {
	s.AuxiliaryDataLocation = v
	return s
}

// SetTerminologyDataLocation sets the TerminologyDataLocation field's value.
func (s *GetTerminologyOutput) SetTerminologyDataLocation(v *TerminologyDataLocation) *GetTerminologyOutput {
	s.TerminologyDataLocation = v
	return s
}

// SetTerminologyProperties sets the TerminologyProperties field's value.
func (s *GetTerminologyOutput) SetTerminologyProperties(v *TerminologyProperties) *GetTerminologyOutput {
	s.TerminologyProperties = v
	return s
}

type ImportTerminologyInput struct {
	_ struct{} `type:"structure"`

	// The description of the custom terminology being imported.
	Description *string `type:"string"`

	// The encryption key for the custom terminology being imported.
	EncryptionKey *EncryptionKey `type:"structure"`

	// The merge strategy of the custom terminology being imported. Currently, only
	// the OVERWRITE merge strategy is supported. In this case, the imported terminology
	// will overwrite an existing terminology of the same name.
	//
	// MergeStrategy is a required field
	MergeStrategy *string `type:"string" required:"true" enum:"MergeStrategy"`

	// The name of the custom terminology being imported.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The terminology data for the custom terminology being imported.
	//
	// TerminologyData is a required field
	TerminologyData *TerminologyData `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportTerminologyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportTerminologyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportTerminologyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportTerminologyInput"}
	if s.MergeStrategy == nil {
		invalidParams.Add(request.NewErrParamRequired("MergeStrategy"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TerminologyData == nil {
		invalidParams.Add(request.NewErrParamRequired("TerminologyData"))
	}
	if s.EncryptionKey != nil {
		if err := s.EncryptionKey.Validate(); err != nil {
			invalidParams.AddNested("EncryptionKey", err.(request.ErrInvalidParams))
		}
	}
	if s.TerminologyData != nil {
		if err := s.TerminologyData.Validate(); err != nil {
			invalidParams.AddNested("TerminologyData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ImportTerminologyInput) SetDescription(v string) *ImportTerminologyInput {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *ImportTerminologyInput) SetEncryptionKey(v *EncryptionKey) *ImportTerminologyInput {
	s.EncryptionKey = v
	return s
}

// SetMergeStrategy sets the MergeStrategy field's value.
func (s *ImportTerminologyInput) SetMergeStrategy(v string) *ImportTerminologyInput {
	s.MergeStrategy = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImportTerminologyInput) SetName(v string) *ImportTerminologyInput {
	s.Name = &v
	return s
}

// SetTerminologyData sets the TerminologyData field's value.
func (s *ImportTerminologyInput) SetTerminologyData(v *TerminologyData) *ImportTerminologyInput {
	s.TerminologyData = v
	return s
}

type ImportTerminologyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location of a file that provides any errors or warnings that
	// were produced by your input file. This file was created when Amazon Translate
	// attempted to create a terminology resource. The location is returned as a
	// presigned URL to that has a 30 minute expiration.
	AuxiliaryDataLocation *TerminologyDataLocation `type:"structure"`

	// The properties of the custom terminology being imported.
	TerminologyProperties *TerminologyProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportTerminologyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportTerminologyOutput) GoString() string {
	return s.String()
}

// SetAuxiliaryDataLocation sets the AuxiliaryDataLocation field's value.
func (s *ImportTerminologyOutput) SetAuxiliaryDataLocation(v *TerminologyDataLocation) *ImportTerminologyOutput {
	s.AuxiliaryDataLocation = v
	return s
}

// SetTerminologyProperties sets the TerminologyProperties field's value.
func (s *ImportTerminologyOutput) SetTerminologyProperties(v *TerminologyProperties) *ImportTerminologyOutput {
	s.TerminologyProperties = v
	return s
}

// The input configuration properties for requesting a batch translation job.
type InputDataConfig struct {
	_ struct{} `type:"structure"`

	// Describes the format of the data that you submit to Amazon Translate as input.
	// You can specify one of the following multipurpose internet mail extension
	// (MIME) types:
	//
	//    * text/html: The input data consists of one or more HTML files. Amazon
	//    Translate translates only the text that resides in the html element in
	//    each file.
	//
	//    * text/plain: The input data consists of one or more unformatted text
	//    files. Amazon Translate translates every character in this type of input.
	//
	//    * application/vnd.openxmlformats-officedocument.wordprocessingml.document:
	//    The input data consists of one or more Word documents (.docx).
	//
	//    * application/vnd.openxmlformats-officedocument.presentationml.presentation:
	//    The input data consists of one or more PowerPoint Presentation files (.pptx).
	//
	//    * application/vnd.openxmlformats-officedocument.spreadsheetml.sheet: The
	//    input data consists of one or more Excel Workbook files (.xlsx).
	//
	//    * application/x-xliff+xml: The input data consists of one or more XML
	//    Localization Interchange File Format (XLIFF) files (.xlf). Amazon Translate
	//    supports only XLIFF version 1.2.
	//
	// If you structure your input data as HTML, ensure that you set this parameter
	// to text/html. By doing so, you cut costs by limiting the translation to the
	// contents of the html element in each file. Otherwise, if you set this parameter
	// to text/plain, your costs will cover the translation of every character.
	//
	// ContentType is a required field
	ContentType *string `type:"string" required:"true"`

	// The URI of the AWS S3 folder that contains the input files. Amazon Translate
	// translates all the files in the folder. The folder must be in the same Region
	// as the API endpoint you are calling.
	//
	// The URI can also point to a single input document, or it can provide the
	// prefix for a collection of input documents. For example. if you use the URI
	// S3://bucketName/prefix and the prefix is a single file, Amazon Translate
	// uses that files as input. If more than one file begins with the prefix, Amazon
	// Translate uses all of them as input.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputDataConfig"}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentType sets the ContentType field's value.
func (s *InputDataConfig) SetContentType(v string) *InputDataConfig {
	s.ContentType = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *InputDataConfig) SetS3Uri(v string) *InputDataConfig {
	s.S3Uri = &v
	return s
}

// An internal server error occurred. Retry your request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The filter specified for the operation is not valid. Specify a different
// filter.
type InvalidFilterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidFilterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidFilterException) GoString() string {
	return s.String()
}

func newErrorInvalidFilterException(v protocol.ResponseMetadata) error {
	return &InvalidFilterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidFilterException) Code() string {
	return "InvalidFilterException"
}

// Message returns the exception's message.
func (s *InvalidFilterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidFilterException) OrigErr() error {
	return nil
}

func (s *InvalidFilterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidFilterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidFilterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The value of the parameter is not valid. Review the value of the parameter
// you are using to correct it, and then retry your operation.
type InvalidParameterValueException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterValueException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterValueException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterValueException(v protocol.ResponseMetadata) error {
	return &InvalidParameterValueException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterValueException) Code() string {
	return "InvalidParameterValueException"
}

// Message returns the exception's message.
func (s *InvalidParameterValueException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterValueException) OrigErr() error {
	return nil
}

func (s *InvalidParameterValueException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterValueException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterValueException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request that you made is not valid. Check your request to determine why
// it's not valid and then retry the request.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The number of documents successfully and unsuccessfully processed during
// a translation job.
type JobDetails struct {
	_ struct{} `type:"structure"`

	// The number of documents that could not be processed during a translation
	// job.
	DocumentsWithErrorsCount *int64 `type:"integer"`

	// The number of documents used as input in a translation job.
	InputDocumentsCount *int64 `type:"integer"`

	// The number of documents successfully processed during a translation job.
	TranslatedDocumentsCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDetails) GoString() string {
	return s.String()
}

// SetDocumentsWithErrorsCount sets the DocumentsWithErrorsCount field's value.
func (s *JobDetails) SetDocumentsWithErrorsCount(v int64) *JobDetails {
	s.DocumentsWithErrorsCount = &v
	return s
}

// SetInputDocumentsCount sets the InputDocumentsCount field's value.
func (s *JobDetails) SetInputDocumentsCount(v int64) *JobDetails {
	s.InputDocumentsCount = &v
	return s
}

// SetTranslatedDocumentsCount sets the TranslatedDocumentsCount field's value.
func (s *JobDetails) SetTranslatedDocumentsCount(v int64) *JobDetails {
	s.TranslatedDocumentsCount = &v
	return s
}

// A supported language.
type Language struct {
	_ struct{} `type:"structure"`

	// Language code for the supported language.
	//
	// LanguageCode is a required field
	LanguageCode *string `min:"2" type:"string" required:"true"`

	// Language name of the supported language.
	//
	// LanguageName is a required field
	LanguageName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Language) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Language) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *Language) SetLanguageCode(v string) *Language {
	s.LanguageCode = &v
	return s
}

// SetLanguageName sets the LanguageName field's value.
func (s *Language) SetLanguageName(v string) *Language {
	s.LanguageName = &v
	return s
}

// The specified limit has been exceeded. Review your request and retry it with
// a quantity below the stated limit.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListLanguagesInput struct {
	_ struct{} `type:"structure"`

	// The language code for the language to use to display the language names in
	// the response. The language code is en by default.
	DisplayLanguageCode *string `type:"string" enum:"DisplayLanguageCode"`

	// The maximum number of results to return in each response.
	MaxResults *int64 `min:"1" type:"integer"`

	// Include the NextToken value to fetch the next group of supported languages.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLanguagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLanguagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLanguagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLanguagesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayLanguageCode sets the DisplayLanguageCode field's value.
func (s *ListLanguagesInput) SetDisplayLanguageCode(v string) *ListLanguagesInput {
	s.DisplayLanguageCode = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLanguagesInput) SetMaxResults(v int64) *ListLanguagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLanguagesInput) SetNextToken(v string) *ListLanguagesInput {
	s.NextToken = &v
	return s
}

type ListLanguagesOutput struct {
	_ struct{} `type:"structure"`

	// The language code passed in with the request.
	DisplayLanguageCode *string `type:"string" enum:"DisplayLanguageCode"`

	// The list of supported languages.
	Languages []*Language `type:"list"`

	// If the response does not include all remaining results, use the NextToken
	// in the next request to fetch the next group of supported languages.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLanguagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLanguagesOutput) GoString() string {
	return s.String()
}

// SetDisplayLanguageCode sets the DisplayLanguageCode field's value.
func (s *ListLanguagesOutput) SetDisplayLanguageCode(v string) *ListLanguagesOutput {
	s.DisplayLanguageCode = &v
	return s
}

// SetLanguages sets the Languages field's value.
func (s *ListLanguagesOutput) SetLanguages(v []*Language) *ListLanguagesOutput {
	s.Languages = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLanguagesOutput) SetNextToken(v string) *ListLanguagesOutput {
	s.NextToken = &v
	return s
}

type ListParallelDataInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of parallel data resources returned for each request.
	MaxResults *int64 `min:"1" type:"integer"`

	// A string that specifies the next page of results to return in a paginated
	// response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParallelDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParallelDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListParallelDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListParallelDataInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListParallelDataInput) SetMaxResults(v int64) *ListParallelDataInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListParallelDataInput) SetNextToken(v string) *ListParallelDataInput {
	s.NextToken = &v
	return s
}

type ListParallelDataOutput struct {
	_ struct{} `type:"structure"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`

	// The properties of the parallel data resources returned by this request.
	ParallelDataPropertiesList []*ParallelDataProperties `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParallelDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParallelDataOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListParallelDataOutput) SetNextToken(v string) *ListParallelDataOutput {
	s.NextToken = &v
	return s
}

// SetParallelDataPropertiesList sets the ParallelDataPropertiesList field's value.
func (s *ListParallelDataOutput) SetParallelDataPropertiesList(v []*ParallelDataProperties) *ListParallelDataOutput {
	s.ParallelDataPropertiesList = v
	return s
}

type ListTerminologiesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of custom terminologies returned per list request.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the request to ListTerminologies was truncated, include
	// the NextToken to fetch the next group of custom terminologies.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTerminologiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTerminologiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTerminologiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTerminologiesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTerminologiesInput) SetMaxResults(v int64) *ListTerminologiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTerminologiesInput) SetNextToken(v string) *ListTerminologiesInput {
	s.NextToken = &v
	return s
}

type ListTerminologiesOutput struct {
	_ struct{} `type:"structure"`

	// If the response to the ListTerminologies was truncated, the NextToken fetches
	// the next group of custom terminologies.
	NextToken *string `type:"string"`

	// The properties list of the custom terminologies returned on the list request.
	TerminologyPropertiesList []*TerminologyProperties `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTerminologiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTerminologiesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTerminologiesOutput) SetNextToken(v string) *ListTerminologiesOutput {
	s.NextToken = &v
	return s
}

// SetTerminologyPropertiesList sets the TerminologyPropertiesList field's value.
func (s *ListTerminologiesOutput) SetTerminologyPropertiesList(v []*TerminologyProperties) *ListTerminologiesOutput {
	s.TerminologyPropertiesList = v
	return s
}

type ListTextTranslationJobsInput struct {
	_ struct{} `type:"structure"`

	// The parameters that specify which batch translation jobs to retrieve. Filters
	// include job name, job status, and submission time. You can only set one filter
	// at a time.
	Filter *TextTranslationJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default value is
	// 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTextTranslationJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTextTranslationJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTextTranslationJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTextTranslationJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListTextTranslationJobsInput) SetFilter(v *TextTranslationJobFilter) *ListTextTranslationJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTextTranslationJobsInput) SetMaxResults(v int64) *ListTextTranslationJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTextTranslationJobsInput) SetNextToken(v string) *ListTextTranslationJobsInput {
	s.NextToken = &v
	return s
}

type ListTextTranslationJobsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `type:"string"`

	// A list containing the properties of each job that is returned.
	TextTranslationJobPropertiesList []*TextTranslationJobProperties `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTextTranslationJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTextTranslationJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTextTranslationJobsOutput) SetNextToken(v string) *ListTextTranslationJobsOutput {
	s.NextToken = &v
	return s
}

// SetTextTranslationJobPropertiesList sets the TextTranslationJobPropertiesList field's value.
func (s *ListTextTranslationJobsOutput) SetTextTranslationJobPropertiesList(v []*TextTranslationJobProperties) *ListTextTranslationJobsOutput {
	s.TextTranslationJobPropertiesList = v
	return s
}

// The output configuration properties for a batch translation job.
type OutputDataConfig struct {
	_ struct{} `type:"structure"`

	// The encryption key used to encrypt this object.
	EncryptionKey *EncryptionKey `type:"structure"`

	// The URI of the S3 folder that contains a translation job's output file. The
	// folder must be in the same Region as the API endpoint that you are calling.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputDataConfig"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}
	if s.EncryptionKey != nil {
		if err := s.EncryptionKey.Validate(); err != nil {
			invalidParams.AddNested("EncryptionKey", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *OutputDataConfig) SetEncryptionKey(v *EncryptionKey) *OutputDataConfig {
	s.EncryptionKey = v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *OutputDataConfig) SetS3Uri(v string) *OutputDataConfig {
	s.S3Uri = &v
	return s
}

// Specifies the format and S3 location of the parallel data input file.
type ParallelDataConfig struct {
	_ struct{} `type:"structure"`

	// The format of the parallel data input file.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"ParallelDataFormat"`

	// The URI of the Amazon S3 folder that contains the parallel data input file.
	// The folder must be in the same Region as the API endpoint you are calling.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParallelDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParallelDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParallelDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParallelDataConfig"}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFormat sets the Format field's value.
func (s *ParallelDataConfig) SetFormat(v string) *ParallelDataConfig {
	s.Format = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *ParallelDataConfig) SetS3Uri(v string) *ParallelDataConfig {
	s.S3Uri = &v
	return s
}

// The location of the most recent parallel data input file that was successfully
// imported into Amazon Translate.
type ParallelDataDataLocation struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location of the parallel data input file. The location is returned
	// as a presigned URL to that has a 30-minute expiration.
	//
	// Amazon Translate doesn't scan all input files for the risk of CSV injection
	// attacks.
	//
	// CSV injection occurs when a .csv or .tsv file is altered so that a record
	// contains malicious code. The record begins with a special character, such
	// as =, +, -, or @. When the file is opened in a spreadsheet program, the program
	// might interpret the record as a formula and run the code within it.
	//
	// Before you download an input file from Amazon S3, ensure that you recognize
	// the file and trust its creator.
	//
	// Location is a required field
	Location *string `type:"string" required:"true"`

	// Describes the repository that contains the parallel data input file.
	//
	// RepositoryType is a required field
	RepositoryType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParallelDataDataLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParallelDataDataLocation) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *ParallelDataDataLocation) SetLocation(v string) *ParallelDataDataLocation {
	s.Location = &v
	return s
}

// SetRepositoryType sets the RepositoryType field's value.
func (s *ParallelDataDataLocation) SetRepositoryType(v string) *ParallelDataDataLocation {
	s.RepositoryType = &v
	return s
}

// The properties of a parallel data resource.
type ParallelDataProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the parallel data resource.
	Arn *string `min:"1" type:"string"`

	// The time at which the parallel data resource was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description assigned to the parallel data resource.
	Description *string `type:"string"`

	// The encryption key used to encrypt this object.
	EncryptionKey *EncryptionKey `type:"structure"`

	// The number of records unsuccessfully imported from the parallel data input
	// file.
	FailedRecordCount *int64 `type:"long"`

	// The number of UTF-8 characters that Amazon Translate imported from the parallel
	// data input file. This number includes only the characters in your translation
	// examples. It does not include characters that are used to format your file.
	// For example, if you provided a Translation Memory Exchange (.tmx) file, this
	// number does not include the tags.
	ImportedDataSize *int64 `type:"long"`

	// The number of records successfully imported from the parallel data input
	// file.
	ImportedRecordCount *int64 `type:"long"`

	// The time at which the parallel data resource was last updated.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The time that the most recent update was attempted.
	LatestUpdateAttemptAt *time.Time `type:"timestamp"`

	// The status of the most recent update attempt for the parallel data resource.
	LatestUpdateAttemptStatus *string `type:"string" enum:"ParallelDataStatus"`

	// Additional information from Amazon Translate about the parallel data resource.
	Message *string `type:"string"`

	// The custom name assigned to the parallel data resource.
	Name *string `min:"1" type:"string"`

	// Specifies the format and S3 location of the parallel data input file.
	ParallelDataConfig *ParallelDataConfig `type:"structure"`

	// The number of items in the input file that Amazon Translate skipped when
	// you created or updated the parallel data resource. For example, Amazon Translate
	// skips empty records, empty target texts, and empty lines.
	SkippedRecordCount *int64 `type:"long"`

	// The source language of the translations in the parallel data file.
	SourceLanguageCode *string `min:"2" type:"string"`

	// The status of the parallel data resource. When the parallel data is ready
	// for you to use, the status is ACTIVE.
	Status *string `type:"string" enum:"ParallelDataStatus"`

	// The language codes for the target languages available in the parallel data
	// file. All possible target languages are returned as an array.
	TargetLanguageCodes []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParallelDataProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParallelDataProperties) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ParallelDataProperties) SetArn(v string) *ParallelDataProperties {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ParallelDataProperties) SetCreatedAt(v time.Time) *ParallelDataProperties {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ParallelDataProperties) SetDescription(v string) *ParallelDataProperties {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *ParallelDataProperties) SetEncryptionKey(v *EncryptionKey) *ParallelDataProperties {
	s.EncryptionKey = v
	return s
}

// SetFailedRecordCount sets the FailedRecordCount field's value.
func (s *ParallelDataProperties) SetFailedRecordCount(v int64) *ParallelDataProperties {
	s.FailedRecordCount = &v
	return s
}

// SetImportedDataSize sets the ImportedDataSize field's value.
func (s *ParallelDataProperties) SetImportedDataSize(v int64) *ParallelDataProperties {
	s.ImportedDataSize = &v
	return s
}

// SetImportedRecordCount sets the ImportedRecordCount field's value.
func (s *ParallelDataProperties) SetImportedRecordCount(v int64) *ParallelDataProperties {
	s.ImportedRecordCount = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ParallelDataProperties) SetLastUpdatedAt(v time.Time) *ParallelDataProperties {
	s.LastUpdatedAt = &v
	return s
}

// SetLatestUpdateAttemptAt sets the LatestUpdateAttemptAt field's value.
func (s *ParallelDataProperties) SetLatestUpdateAttemptAt(v time.Time) *ParallelDataProperties {
	s.LatestUpdateAttemptAt = &v
	return s
}

// SetLatestUpdateAttemptStatus sets the LatestUpdateAttemptStatus field's value.
func (s *ParallelDataProperties) SetLatestUpdateAttemptStatus(v string) *ParallelDataProperties {
	s.LatestUpdateAttemptStatus = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ParallelDataProperties) SetMessage(v string) *ParallelDataProperties {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ParallelDataProperties) SetName(v string) *ParallelDataProperties {
	s.Name = &v
	return s
}

// SetParallelDataConfig sets the ParallelDataConfig field's value.
func (s *ParallelDataProperties) SetParallelDataConfig(v *ParallelDataConfig) *ParallelDataProperties {
	s.ParallelDataConfig = v
	return s
}

// SetSkippedRecordCount sets the SkippedRecordCount field's value.
func (s *ParallelDataProperties) SetSkippedRecordCount(v int64) *ParallelDataProperties {
	s.SkippedRecordCount = &v
	return s
}

// SetSourceLanguageCode sets the SourceLanguageCode field's value.
func (s *ParallelDataProperties) SetSourceLanguageCode(v string) *ParallelDataProperties {
	s.SourceLanguageCode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ParallelDataProperties) SetStatus(v string) *ParallelDataProperties {
	s.Status = &v
	return s
}

// SetTargetLanguageCodes sets the TargetLanguageCodes field's value.
func (s *ParallelDataProperties) SetTargetLanguageCodes(v []*string) *ParallelDataProperties {
	s.TargetLanguageCodes = v
	return s
}

// The resource you are looking for has not been found. Review the resource
// you're looking for and see if a different resource will accomplish your needs
// before retrying the revised request.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Amazon Translate service is temporarily unavailable. Wait a bit and then
// retry your request.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartTextTranslationJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. This token is generated for you when
	// using the Amazon Translate SDK.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM)
	// role that grants Amazon Translate read access to your input data. For more
	// information, see identity-and-access-management.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the format and location of the input documents for the translation
	// job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The name of the batch translation job to be performed.
	JobName *string `min:"1" type:"string"`

	// Specifies the S3 folder to which your job output will be saved.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// The name of a parallel data resource to add to the translation job. This
	// resource consists of examples that show how you want segments of text to
	// be translated. When you add parallel data to a translation job, you create
	// an Active Custom Translation job.
	//
	// This parameter accepts only one parallel data resource.
	//
	// Active Custom Translation jobs are priced at a higher rate than other jobs
	// that don't use parallel data. For more information, see Amazon Translate
	// pricing (http://aws.amazon.com/translate/pricing/).
	//
	// For a list of available parallel data resources, use the ListParallelData
	// operation.
	//
	// For more information, see customizing-translations-parallel-data.
	ParallelDataNames []*string `type:"list"`

	// Settings to configure your translation output, including the option to mask
	// profane words and phrases. StartTextTranslationJob does not support the formality
	// setting.
	Settings *TranslationSettings `type:"structure"`

	// The language code of the input language. For a list of language codes, see
	// what-is-languages.
	//
	// Amazon Translate does not automatically detect a source language during batch
	// translation jobs.
	//
	// SourceLanguageCode is a required field
	SourceLanguageCode *string `min:"2" type:"string" required:"true"`

	// The language code of the output language.
	//
	// TargetLanguageCodes is a required field
	TargetLanguageCodes []*string `min:"1" type:"list" required:"true"`

	// The name of a custom terminology resource to add to the translation job.
	// This resource lists examples source terms and the desired translation for
	// each term.
	//
	// This parameter accepts only one custom terminology resource.
	//
	// For a list of available custom terminology resources, use the ListTerminologies
	// operation.
	//
	// For more information, see how-custom-terminology.
	TerminologyNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTextTranslationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTextTranslationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTextTranslationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTextTranslationJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.SourceLanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLanguageCode"))
	}
	if s.SourceLanguageCode != nil && len(*s.SourceLanguageCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLanguageCode", 2))
	}
	if s.TargetLanguageCodes == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetLanguageCodes"))
	}
	if s.TargetLanguageCodes != nil && len(s.TargetLanguageCodes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetLanguageCodes", 1))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartTextTranslationJobInput) SetClientToken(v string) *StartTextTranslationJobInput {
	s.ClientToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartTextTranslationJobInput) SetDataAccessRoleArn(v string) *StartTextTranslationJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartTextTranslationJobInput) SetInputDataConfig(v *InputDataConfig) *StartTextTranslationJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartTextTranslationJobInput) SetJobName(v string) *StartTextTranslationJobInput {
	s.JobName = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartTextTranslationJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartTextTranslationJobInput {
	s.OutputDataConfig = v
	return s
}

// SetParallelDataNames sets the ParallelDataNames field's value.
func (s *StartTextTranslationJobInput) SetParallelDataNames(v []*string) *StartTextTranslationJobInput {
	s.ParallelDataNames = v
	return s
}

// SetSettings sets the Settings field's value.
func (s *StartTextTranslationJobInput) SetSettings(v *TranslationSettings) *StartTextTranslationJobInput {
	s.Settings = v
	return s
}

// SetSourceLanguageCode sets the SourceLanguageCode field's value.
func (s *StartTextTranslationJobInput) SetSourceLanguageCode(v string) *StartTextTranslationJobInput {
	s.SourceLanguageCode = &v
	return s
}

// SetTargetLanguageCodes sets the TargetLanguageCodes field's value.
func (s *StartTextTranslationJobInput) SetTargetLanguageCodes(v []*string) *StartTextTranslationJobInput {
	s.TargetLanguageCodes = v
	return s
}

// SetTerminologyNames sets the TerminologyNames field's value.
func (s *StartTextTranslationJobInput) SetTerminologyNames(v []*string) *StartTextTranslationJobInput {
	s.TerminologyNames = v
	return s
}

type StartTextTranslationJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of a job, use this
	// ID with the DescribeTextTranslationJob operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job. Possible values include:
	//
	//    * SUBMITTED - The job has been received and is queued for processing.
	//
	//    * IN_PROGRESS - Amazon Translate is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * COMPLETED_WITH_ERROR - The job was completed with errors. The errors
	//    can be analyzed in the job's output.
	//
	//    * FAILED - The job did not complete. To get details, use the DescribeTextTranslationJob
	//    operation.
	//
	//    * STOP_REQUESTED - The user who started the job has requested that it
	//    be stopped.
	//
	//    * STOPPED - The job has been stopped.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTextTranslationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTextTranslationJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartTextTranslationJobOutput) SetJobId(v string) *StartTextTranslationJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartTextTranslationJobOutput) SetJobStatus(v string) *StartTextTranslationJobOutput {
	s.JobStatus = &v
	return s
}

type StopTextTranslationJobInput struct {
	_ struct{} `type:"structure"`

	// The job ID of the job to be stopped.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTextTranslationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTextTranslationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopTextTranslationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopTextTranslationJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopTextTranslationJobInput) SetJobId(v string) *StopTextTranslationJobInput {
	s.JobId = &v
	return s
}

type StopTextTranslationJobOutput struct {
	_ struct{} `type:"structure"`

	// The job ID of the stopped batch translation job.
	JobId *string `min:"1" type:"string"`

	// The status of the designated job. Upon successful completion, the job's status
	// will be STOPPED.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTextTranslationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTextTranslationJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopTextTranslationJobOutput) SetJobId(v string) *StopTextTranslationJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StopTextTranslationJobOutput) SetJobStatus(v string) *StopTextTranslationJobOutput {
	s.JobStatus = &v
	return s
}

// The term being translated by the custom terminology.
type Term struct {
	_ struct{} `type:"structure"`

	// The source text of the term being translated by the custom terminology.
	SourceText *string `type:"string"`

	// The target text of the term being translated by the custom terminology.
	TargetText *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Term) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Term) GoString() string {
	return s.String()
}

// SetSourceText sets the SourceText field's value.
func (s *Term) SetSourceText(v string) *Term {
	s.SourceText = &v
	return s
}

// SetTargetText sets the TargetText field's value.
func (s *Term) SetTargetText(v string) *Term {
	s.TargetText = &v
	return s
}

// The data associated with the custom terminology. For information about the
// custom terminology file, see Creating a Custom Terminology (https://docs.aws.amazon.com/translate/latest/dg/creating-custom-terminology.html).
type TerminologyData struct {
	_ struct{} `type:"structure"`

	// The directionality of your terminology resource indicates whether it has
	// one source language (uni-directional) or multiple (multi-directional).
	//
	// UNI
	//
	// The terminology resource has one source language (for example, the first
	// column in a CSV file), and all of its other languages are target languages.
	//
	// MULTI
	//
	// Any language in the terminology resource can be the source language or a
	// target language. A single multi-directional terminology resource can be used
	// for jobs that translate different language pairs. For example, if the terminology
	// contains English and Spanish terms, it can be used for jobs that translate
	// English to Spanish and Spanish to English.
	//
	// When you create a custom terminology resource without specifying the directionality,
	// it behaves as uni-directional terminology, although this parameter will have
	// a null value.
	Directionality *string `type:"string" enum:"Directionality"`

	// The file containing the custom terminology data. Your version of the AWS
	// SDK performs a Base64-encoding on this field before sending a request to
	// the AWS service. Users of the SDK should not perform Base64-encoding themselves.
	//
	// File is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TerminologyData's
	// String and GoString methods.
	//
	// File is automatically base64 encoded/decoded by the SDK.
	//
	// File is a required field
	File []byte `type:"blob" required:"true" sensitive:"true"`

	// The data format of the custom terminology.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"TerminologyDataFormat"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminologyData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminologyData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminologyData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminologyData"}
	if s.File == nil {
		invalidParams.Add(request.NewErrParamRequired("File"))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectionality sets the Directionality field's value.
func (s *TerminologyData) SetDirectionality(v string) *TerminologyData {
	s.Directionality = &v
	return s
}

// SetFile sets the File field's value.
func (s *TerminologyData) SetFile(v []byte) *TerminologyData {
	s.File = v
	return s
}

// SetFormat sets the Format field's value.
func (s *TerminologyData) SetFormat(v string) *TerminologyData {
	s.Format = &v
	return s
}

// The location of the custom terminology data.
type TerminologyDataLocation struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location of the most recent custom terminology input file that
	// was successfully imported into Amazon Translate. The location is returned
	// as a presigned URL that has a 30-minute expiration .
	//
	// Amazon Translate doesn't scan all input files for the risk of CSV injection
	// attacks.
	//
	// CSV injection occurs when a .csv or .tsv file is altered so that a record
	// contains malicious code. The record begins with a special character, such
	// as =, +, -, or @. When the file is opened in a spreadsheet program, the program
	// might interpret the record as a formula and run the code within it.
	//
	// Before you download an input file from Amazon S3, ensure that you recognize
	// the file and trust its creator.
	//
	// Location is a required field
	Location *string `type:"string" required:"true"`

	// The repository type for the custom terminology data.
	//
	// RepositoryType is a required field
	RepositoryType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminologyDataLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminologyDataLocation) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *TerminologyDataLocation) SetLocation(v string) *TerminologyDataLocation {
	s.Location = &v
	return s
}

// SetRepositoryType sets the RepositoryType field's value.
func (s *TerminologyDataLocation) SetRepositoryType(v string) *TerminologyDataLocation {
	s.RepositoryType = &v
	return s
}

// The properties of the custom terminology.
type TerminologyProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the custom terminology.
	Arn *string `min:"1" type:"string"`

	// The time at which the custom terminology was created, based on the timestamp.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the custom terminology properties.
	Description *string `type:"string"`

	// The directionality of your terminology resource indicates whether it has
	// one source language (uni-directional) or multiple (multi-directional).
	//
	// UNI
	//
	// The terminology resource has one source language (the first column in a CSV
	// file), and all of its other languages are target languages.
	//
	// MULTI
	//
	// Any language in the terminology resource can be the source language.
	Directionality *string `type:"string" enum:"Directionality"`

	// The encryption key for the custom terminology.
	EncryptionKey *EncryptionKey `type:"structure"`

	// The format of the custom terminology input file.
	Format *string `type:"string" enum:"TerminologyDataFormat"`

	// The time at which the custom terminology was last update, based on the timestamp.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// Additional information from Amazon Translate about the terminology resource.
	Message *string `type:"string"`

	// The name of the custom terminology.
	Name *string `min:"1" type:"string"`

	// The size of the file used when importing a custom terminology.
	SizeBytes *int64 `type:"integer"`

	// The number of terms in the input file that Amazon Translate skipped when
	// you created or updated the terminology resource.
	SkippedTermCount *int64 `type:"integer"`

	// The language code for the source text of the translation request for which
	// the custom terminology is being used.
	SourceLanguageCode *string `min:"2" type:"string"`

	// The language codes for the target languages available with the custom terminology
	// resource. All possible target languages are returned in array.
	TargetLanguageCodes []*string `type:"list"`

	// The number of terms included in the custom terminology.
	TermCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminologyProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminologyProperties) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *TerminologyProperties) SetArn(v string) *TerminologyProperties {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *TerminologyProperties) SetCreatedAt(v time.Time) *TerminologyProperties {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TerminologyProperties) SetDescription(v string) *TerminologyProperties {
	s.Description = &v
	return s
}

// SetDirectionality sets the Directionality field's value.
func (s *TerminologyProperties) SetDirectionality(v string) *TerminologyProperties {
	s.Directionality = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *TerminologyProperties) SetEncryptionKey(v *EncryptionKey) *TerminologyProperties {
	s.EncryptionKey = v
	return s
}

// SetFormat sets the Format field's value.
func (s *TerminologyProperties) SetFormat(v string) *TerminologyProperties {
	s.Format = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *TerminologyProperties) SetLastUpdatedAt(v time.Time) *TerminologyProperties {
	s.LastUpdatedAt = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *TerminologyProperties) SetMessage(v string) *TerminologyProperties {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *TerminologyProperties) SetName(v string) *TerminologyProperties {
	s.Name = &v
	return s
}

// SetSizeBytes sets the SizeBytes field's value.
func (s *TerminologyProperties) SetSizeBytes(v int64) *TerminologyProperties {
	s.SizeBytes = &v
	return s
}

// SetSkippedTermCount sets the SkippedTermCount field's value.
func (s *TerminologyProperties) SetSkippedTermCount(v int64) *TerminologyProperties {
	s.SkippedTermCount = &v
	return s
}

// SetSourceLanguageCode sets the SourceLanguageCode field's value.
func (s *TerminologyProperties) SetSourceLanguageCode(v string) *TerminologyProperties {
	s.SourceLanguageCode = &v
	return s
}

// SetTargetLanguageCodes sets the TargetLanguageCodes field's value.
func (s *TerminologyProperties) SetTargetLanguageCodes(v []*string) *TerminologyProperties {
	s.TargetLanguageCodes = v
	return s
}

// SetTermCount sets the TermCount field's value.
func (s *TerminologyProperties) SetTermCount(v int64) *TerminologyProperties {
	s.TermCount = &v
	return s
}

type TextInput struct {
	_ struct{} `type:"structure"`

	// Settings to configure your translation output, including the option to set
	// the formality level of the output text and the option to mask profane words
	// and phrases.
	Settings *TranslationSettings `type:"structure"`

	// The language code for the language of the source text. The language must
	// be a language supported by Amazon Translate. For a list of language codes,
	// see what-is-languages.
	//
	// To have Amazon Translate determine the source language of your text, you
	// can specify auto in the SourceLanguageCode field. If you specify auto, Amazon
	// Translate will call Amazon Comprehend (https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html)
	// to determine the source language.
	//
	// If you specify auto, you must send the TranslateText request in a region
	// that supports Amazon Comprehend. Otherwise, the request returns an error
	// indicating that autodetect is not supported.
	//
	// SourceLanguageCode is a required field
	SourceLanguageCode *string `min:"2" type:"string" required:"true"`

	// The language code requested for the language of the target text. The language
	// must be a language supported by Amazon Translate.
	//
	// TargetLanguageCode is a required field
	TargetLanguageCode *string `min:"2" type:"string" required:"true"`

	// The name of the terminology list file to be used in the TranslateText request.
	// You can use 1 terminology list at most in a TranslateText request. Terminology
	// lists can contain a maximum of 256 terms.
	TerminologyNames []*string `type:"list"`

	// The text to translate. The text string can be a maximum of 5,000 bytes long.
	// Depending on your character set, this may be fewer than 5,000 characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TextInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TextInput"}
	if s.SourceLanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLanguageCode"))
	}
	if s.SourceLanguageCode != nil && len(*s.SourceLanguageCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLanguageCode", 2))
	}
	if s.TargetLanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetLanguageCode"))
	}
	if s.TargetLanguageCode != nil && len(*s.TargetLanguageCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("TargetLanguageCode", 2))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSettings sets the Settings field's value.
func (s *TextInput) SetSettings(v *TranslationSettings) *TextInput {
	s.Settings = v
	return s
}

// SetSourceLanguageCode sets the SourceLanguageCode field's value.
func (s *TextInput) SetSourceLanguageCode(v string) *TextInput {
	s.SourceLanguageCode = &v
	return s
}

// SetTargetLanguageCode sets the TargetLanguageCode field's value.
func (s *TextInput) SetTargetLanguageCode(v string) *TextInput {
	s.TargetLanguageCode = &v
	return s
}

// SetTerminologyNames sets the TerminologyNames field's value.
func (s *TextInput) SetTerminologyNames(v []*string) *TextInput {
	s.TerminologyNames = v
	return s
}

// SetText sets the Text field's value.
func (s *TextInput) SetText(v string) *TextInput {
	s.Text = &v
	return s
}

type TextOutput struct {
	_ struct{} `type:"structure"`

	// Settings that configure the translation output.
	AppliedSettings *TranslationSettings `type:"structure"`

	// The names of the custom terminologies applied to the input text by Amazon
	// Translate for the translated text response.
	AppliedTerminologies []*AppliedTerminology `type:"list"`

	// The language code for the language of the source text.
	//
	// SourceLanguageCode is a required field
	SourceLanguageCode *string `min:"2" type:"string" required:"true"`

	// The language code for the language of the target text.
	//
	// TargetLanguageCode is a required field
	TargetLanguageCode *string `min:"2" type:"string" required:"true"`

	// The translated text.
	//
	// TranslatedText is a required field
	TranslatedText *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextOutput) GoString() string {
	return s.String()
}

// SetAppliedSettings sets the AppliedSettings field's value.
func (s *TextOutput) SetAppliedSettings(v *TranslationSettings) *TextOutput {
	s.AppliedSettings = v
	return s
}

// SetAppliedTerminologies sets the AppliedTerminologies field's value.
func (s *TextOutput) SetAppliedTerminologies(v []*AppliedTerminology) *TextOutput {
	s.AppliedTerminologies = v
	return s
}

// SetSourceLanguageCode sets the SourceLanguageCode field's value.
func (s *TextOutput) SetSourceLanguageCode(v string) *TextOutput {
	s.SourceLanguageCode = &v
	return s
}

// SetTargetLanguageCode sets the TargetLanguageCode field's value.
func (s *TextOutput) SetTargetLanguageCode(v string) *TextOutput {
	s.TargetLanguageCode = &v
	return s
}

// SetTranslatedText sets the TranslatedText field's value.
func (s *TextOutput) SetTranslatedText(v string) *TextOutput {
	s.TranslatedText = &v
	return s
}

// The size of the text you submitted exceeds the size limit. Reduce the size
// of the text or use a smaller document and then retry your request.
type TextSizeLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextSizeLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextSizeLimitExceededException) GoString() string {
	return s.String()
}

func newErrorTextSizeLimitExceededException(v protocol.ResponseMetadata) error {
	return &TextSizeLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TextSizeLimitExceededException) Code() string {
	return "TextSizeLimitExceededException"
}

// Message returns the exception's message.
func (s *TextSizeLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TextSizeLimitExceededException) OrigErr() error {
	return nil
}

func (s *TextSizeLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TextSizeLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TextSizeLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information for filtering a list of translation jobs. For more information,
// see ListTextTranslationJobs.
type TextTranslationJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters the list of jobs by name.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based by job status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing and returns only the jobs submitted after the specified time.
	// Jobs are returned in descending order, newest to oldest.
	SubmittedAfterTime *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing and returns only the jobs submitted before the specified time.
	// Jobs are returned in ascending order, oldest to newest.
	SubmittedBeforeTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextTranslationJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextTranslationJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TextTranslationJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TextTranslationJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *TextTranslationJobFilter) SetJobName(v string) *TextTranslationJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *TextTranslationJobFilter) SetJobStatus(v string) *TextTranslationJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmittedAfterTime sets the SubmittedAfterTime field's value.
func (s *TextTranslationJobFilter) SetSubmittedAfterTime(v time.Time) *TextTranslationJobFilter {
	s.SubmittedAfterTime = &v
	return s
}

// SetSubmittedBeforeTime sets the SubmittedBeforeTime field's value.
func (s *TextTranslationJobFilter) SetSubmittedBeforeTime(v time.Time) *TextTranslationJobFilter {
	s.SubmittedBeforeTime = &v
	return s
}

// Provides information about a translation job.
type TextTranslationJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM)
	// role that granted Amazon Translate read access to the job's input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time at which the translation job ended.
	EndTime *time.Time `type:"timestamp"`

	// The input configuration properties that were specified when the job was requested.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The number of documents successfully and unsuccessfully processed during
	// the translation job.
	JobDetails *JobDetails `type:"structure"`

	// The ID of the translation job.
	JobId *string `min:"1" type:"string"`

	// The user-defined name of the translation job.
	JobName *string `min:"1" type:"string"`

	// The status of the translation job.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// An explanation of any errors that may have occurred during the translation
	// job.
	Message *string `type:"string"`

	// The output configuration properties that were specified when the job was
	// requested.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// A list containing the names of the parallel data resources applied to the
	// translation job.
	ParallelDataNames []*string `type:"list"`

	// Settings that configure the translation output.
	Settings *TranslationSettings `type:"structure"`

	// The language code of the language of the source text. The language must be
	// a language supported by Amazon Translate.
	SourceLanguageCode *string `min:"2" type:"string"`

	// The time at which the translation job was submitted.
	SubmittedTime *time.Time `type:"timestamp"`

	// The language code of the language of the target text. The language must be
	// a language supported by Amazon Translate.
	TargetLanguageCodes []*string `min:"1" type:"list"`

	// A list containing the names of the terminologies applied to a translation
	// job. Only one terminology can be applied per StartTextTranslationJob request
	// at this time.
	TerminologyNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextTranslationJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextTranslationJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *TextTranslationJobProperties) SetDataAccessRoleArn(v string) *TextTranslationJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *TextTranslationJobProperties) SetEndTime(v time.Time) *TextTranslationJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *TextTranslationJobProperties) SetInputDataConfig(v *InputDataConfig) *TextTranslationJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobDetails sets the JobDetails field's value.
func (s *TextTranslationJobProperties) SetJobDetails(v *JobDetails) *TextTranslationJobProperties {
	s.JobDetails = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *TextTranslationJobProperties) SetJobId(v string) *TextTranslationJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *TextTranslationJobProperties) SetJobName(v string) *TextTranslationJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *TextTranslationJobProperties) SetJobStatus(v string) *TextTranslationJobProperties {
	s.JobStatus = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *TextTranslationJobProperties) SetMessage(v string) *TextTranslationJobProperties {
	s.Message = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *TextTranslationJobProperties) SetOutputDataConfig(v *OutputDataConfig) *TextTranslationJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetParallelDataNames sets the ParallelDataNames field's value.
func (s *TextTranslationJobProperties) SetParallelDataNames(v []*string) *TextTranslationJobProperties {
	s.ParallelDataNames = v
	return s
}

// SetSettings sets the Settings field's value.
func (s *TextTranslationJobProperties) SetSettings(v *TranslationSettings) *TextTranslationJobProperties {
	s.Settings = v
	return s
}

// SetSourceLanguageCode sets the SourceLanguageCode field's value.
func (s *TextTranslationJobProperties) SetSourceLanguageCode(v string) *TextTranslationJobProperties {
	s.SourceLanguageCode = &v
	return s
}

// SetSubmittedTime sets the SubmittedTime field's value.
func (s *TextTranslationJobProperties) SetSubmittedTime(v time.Time) *TextTranslationJobProperties {
	s.SubmittedTime = &v
	return s
}

// SetTargetLanguageCodes sets the TargetLanguageCodes field's value.
func (s *TextTranslationJobProperties) SetTargetLanguageCodes(v []*string) *TextTranslationJobProperties {
	s.TargetLanguageCodes = v
	return s
}

// SetTerminologyNames sets the TerminologyNames field's value.
func (s *TextTranslationJobProperties) SetTerminologyNames(v []*string) *TextTranslationJobProperties {
	s.TerminologyNames = v
	return s
}

// You have made too many requests within a short period of time. Wait for a
// short time and then try your request again.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Settings that configure the translation output.
type TranslationSettings struct {
	_ struct{} `type:"structure"`

	// You can optionally specify the desired level of formality for real-time translations
	// to supported target languages. The formality setting controls the level of
	// formal language usage (also known as register (https://en.wikipedia.org/wiki/Register_(sociolinguistics)))
	// in the translation output. You can set the value to informal or formal. If
	// you don't specify a value for formality, or if the target language doesn't
	// support formality, the translation will ignore the formality setting.
	//
	// Note that asynchronous translation jobs don't support formality. If you provide
	// a value for formality, the StartTextTranslationJob API throws an exception
	// (InvalidRequestException).
	//
	// For target languages that support formality, see Supported Languages and
	// Language Codes in the Amazon Translate Developer Guide (https://docs.aws.amazon.com/translate/latest/dg/what-is.html).
	Formality *string `type:"string" enum:"Formality"`

	// Enable the profanity setting if you want Amazon Translate to mask profane
	// words and phrases in your translation output.
	//
	// To mask profane words and phrases, Amazon Translate replaces them with the
	// grawlix string “?$#@$“. This 5-character sequence is used for each profane
	// word or phrase, regardless of the length or number of words.
	//
	// Amazon Translate doesn't detect profanity in all of its supported languages.
	// For languages that support profanity detection, see Supported Languages and
	// Language Codes in the Amazon Translate Developer Guide (https://docs.aws.amazon.com/translate/latest/dg/what-is.html).
	Profanity *string `type:"string" enum:"Profanity"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranslationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranslationSettings) GoString() string {
	return s.String()
}

// SetFormality sets the Formality field's value.
func (s *TranslationSettings) SetFormality(v string) *TranslationSettings {
	s.Formality = &v
	return s
}

// SetProfanity sets the Profanity field's value.
func (s *TranslationSettings) SetProfanity(v string) *TranslationSettings {
	s.Profanity = &v
	return s
}

// Requested display language code is not supported.
type UnsupportedDisplayLanguageCodeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Language code passed in with the request.
	DisplayLanguageCode *string `min:"2" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedDisplayLanguageCodeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedDisplayLanguageCodeException) GoString() string {
	return s.String()
}

func newErrorUnsupportedDisplayLanguageCodeException(v protocol.ResponseMetadata) error {
	return &UnsupportedDisplayLanguageCodeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedDisplayLanguageCodeException) Code() string {
	return "UnsupportedDisplayLanguageCodeException"
}

// Message returns the exception's message.
func (s *UnsupportedDisplayLanguageCodeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedDisplayLanguageCodeException) OrigErr() error {
	return nil
}

func (s *UnsupportedDisplayLanguageCodeException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedDisplayLanguageCodeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedDisplayLanguageCodeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Amazon Translate does not support translation from the language of the source
// text into the requested target language. For more information, see how-to-error-msg.
type UnsupportedLanguagePairException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The language code for the language of the input text.
	SourceLanguageCode *string `min:"2" type:"string"`

	// The language code for the language of the translated text.
	TargetLanguageCode *string `min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedLanguagePairException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedLanguagePairException) GoString() string {
	return s.String()
}

func newErrorUnsupportedLanguagePairException(v protocol.ResponseMetadata) error {
	return &UnsupportedLanguagePairException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedLanguagePairException) Code() string {
	return "UnsupportedLanguagePairException"
}

// Message returns the exception's message.
func (s *UnsupportedLanguagePairException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedLanguagePairException) OrigErr() error {
	return nil
}

func (s *UnsupportedLanguagePairException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedLanguagePairException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedLanguagePairException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateParallelDataInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. This token is automatically generated
	// when you use Amazon Translate through an AWS SDK.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A custom description for the parallel data resource in Amazon Translate.
	Description *string `type:"string"`

	// The name of the parallel data resource being updated.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies the format and S3 location of the parallel data input file.
	//
	// ParallelDataConfig is a required field
	ParallelDataConfig *ParallelDataConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateParallelDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateParallelDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateParallelDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateParallelDataInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ParallelDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ParallelDataConfig"))
	}
	if s.ParallelDataConfig != nil {
		if err := s.ParallelDataConfig.Validate(); err != nil {
			invalidParams.AddNested("ParallelDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateParallelDataInput) SetClientToken(v string) *UpdateParallelDataInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateParallelDataInput) SetDescription(v string) *UpdateParallelDataInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateParallelDataInput) SetName(v string) *UpdateParallelDataInput {
	s.Name = &v
	return s
}

// SetParallelDataConfig sets the ParallelDataConfig field's value.
func (s *UpdateParallelDataInput) SetParallelDataConfig(v *ParallelDataConfig) *UpdateParallelDataInput {
	s.ParallelDataConfig = v
	return s
}

type UpdateParallelDataOutput struct {
	_ struct{} `type:"structure"`

	// The time that the most recent update was attempted.
	LatestUpdateAttemptAt *time.Time `type:"timestamp"`

	// The status of the parallel data update attempt. When the updated parallel
	// data resource is ready for you to use, the status is ACTIVE.
	LatestUpdateAttemptStatus *string `type:"string" enum:"ParallelDataStatus"`

	// The name of the parallel data resource being updated.
	Name *string `min:"1" type:"string"`

	// The status of the parallel data resource that you are attempting to update.
	// Your update request is accepted only if this status is either ACTIVE or FAILED.
	Status *string `type:"string" enum:"ParallelDataStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateParallelDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateParallelDataOutput) GoString() string {
	return s.String()
}

// SetLatestUpdateAttemptAt sets the LatestUpdateAttemptAt field's value.
func (s *UpdateParallelDataOutput) SetLatestUpdateAttemptAt(v time.Time) *UpdateParallelDataOutput {
	s.LatestUpdateAttemptAt = &v
	return s
}

// SetLatestUpdateAttemptStatus sets the LatestUpdateAttemptStatus field's value.
func (s *UpdateParallelDataOutput) SetLatestUpdateAttemptStatus(v string) *UpdateParallelDataOutput {
	s.LatestUpdateAttemptStatus = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateParallelDataOutput) SetName(v string) *UpdateParallelDataOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateParallelDataOutput) SetStatus(v string) *UpdateParallelDataOutput {
	s.Status = &v
	return s
}

const (
	// DirectionalityUni is a Directionality enum value
	DirectionalityUni = "UNI"

	// DirectionalityMulti is a Directionality enum value
	DirectionalityMulti = "MULTI"
)

// Directionality_Values returns all elements of the Directionality enum
func Directionality_Values() []string {
	return []string{
		DirectionalityUni,
		DirectionalityMulti,
	}
}

const (
	// DisplayLanguageCodeDe is a DisplayLanguageCode enum value
	DisplayLanguageCodeDe = "de"

	// DisplayLanguageCodeEn is a DisplayLanguageCode enum value
	DisplayLanguageCodeEn = "en"

	// DisplayLanguageCodeEs is a DisplayLanguageCode enum value
	DisplayLanguageCodeEs = "es"

	// DisplayLanguageCodeFr is a DisplayLanguageCode enum value
	DisplayLanguageCodeFr = "fr"

	// DisplayLanguageCodeIt is a DisplayLanguageCode enum value
	DisplayLanguageCodeIt = "it"

	// DisplayLanguageCodeJa is a DisplayLanguageCode enum value
	DisplayLanguageCodeJa = "ja"

	// DisplayLanguageCodeKo is a DisplayLanguageCode enum value
	DisplayLanguageCodeKo = "ko"

	// DisplayLanguageCodePt is a DisplayLanguageCode enum value
	DisplayLanguageCodePt = "pt"

	// DisplayLanguageCodeZh is a DisplayLanguageCode enum value
	DisplayLanguageCodeZh = "zh"

	// DisplayLanguageCodeZhTw is a DisplayLanguageCode enum value
	DisplayLanguageCodeZhTw = "zh-TW"
)

// DisplayLanguageCode_Values returns all elements of the DisplayLanguageCode enum
func DisplayLanguageCode_Values() []string {
	return []string{
		DisplayLanguageCodeDe,
		DisplayLanguageCodeEn,
		DisplayLanguageCodeEs,
		DisplayLanguageCodeFr,
		DisplayLanguageCodeIt,
		DisplayLanguageCodeJa,
		DisplayLanguageCodeKo,
		DisplayLanguageCodePt,
		DisplayLanguageCodeZh,
		DisplayLanguageCodeZhTw,
	}
}

const (
	// EncryptionKeyTypeKms is a EncryptionKeyType enum value
	EncryptionKeyTypeKms = "KMS"
)

// EncryptionKeyType_Values returns all elements of the EncryptionKeyType enum
func EncryptionKeyType_Values() []string {
	return []string{
		EncryptionKeyTypeKms,
	}
}

const (
	// FormalityFormal is a Formality enum value
	FormalityFormal = "FORMAL"

	// FormalityInformal is a Formality enum value
	FormalityInformal = "INFORMAL"
)

// Formality_Values returns all elements of the Formality enum
func Formality_Values() []string {
	return []string{
		FormalityFormal,
		FormalityInformal,
	}
}

const (
	// JobStatusSubmitted is a JobStatus enum value
	JobStatusSubmitted = "SUBMITTED"

	// JobStatusInProgress is a JobStatus enum value
	JobStatusInProgress = "IN_PROGRESS"

	// JobStatusCompleted is a JobStatus enum value
	JobStatusCompleted = "COMPLETED"

	// JobStatusCompletedWithError is a JobStatus enum value
	JobStatusCompletedWithError = "COMPLETED_WITH_ERROR"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"

	// JobStatusStopRequested is a JobStatus enum value
	JobStatusStopRequested = "STOP_REQUESTED"

	// JobStatusStopped is a JobStatus enum value
	JobStatusStopped = "STOPPED"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusSubmitted,
		JobStatusInProgress,
		JobStatusCompleted,
		JobStatusCompletedWithError,
		JobStatusFailed,
		JobStatusStopRequested,
		JobStatusStopped,
	}
}

const (
	// MergeStrategyOverwrite is a MergeStrategy enum value
	MergeStrategyOverwrite = "OVERWRITE"
)

// MergeStrategy_Values returns all elements of the MergeStrategy enum
func MergeStrategy_Values() []string {
	return []string{
		MergeStrategyOverwrite,
	}
}

const (
	// ParallelDataFormatTsv is a ParallelDataFormat enum value
	ParallelDataFormatTsv = "TSV"

	// ParallelDataFormatCsv is a ParallelDataFormat enum value
	ParallelDataFormatCsv = "CSV"

	// ParallelDataFormatTmx is a ParallelDataFormat enum value
	ParallelDataFormatTmx = "TMX"
)

// ParallelDataFormat_Values returns all elements of the ParallelDataFormat enum
func ParallelDataFormat_Values() []string {
	return []string{
		ParallelDataFormatTsv,
		ParallelDataFormatCsv,
		ParallelDataFormatTmx,
	}
}

const (
	// ParallelDataStatusCreating is a ParallelDataStatus enum value
	ParallelDataStatusCreating = "CREATING"

	// ParallelDataStatusUpdating is a ParallelDataStatus enum value
	ParallelDataStatusUpdating = "UPDATING"

	// ParallelDataStatusActive is a ParallelDataStatus enum value
	ParallelDataStatusActive = "ACTIVE"

	// ParallelDataStatusDeleting is a ParallelDataStatus enum value
	ParallelDataStatusDeleting = "DELETING"

	// ParallelDataStatusFailed is a ParallelDataStatus enum value
	ParallelDataStatusFailed = "FAILED"
)

// ParallelDataStatus_Values returns all elements of the ParallelDataStatus enum
func ParallelDataStatus_Values() []string {
	return []string{
		ParallelDataStatusCreating,
		ParallelDataStatusUpdating,
		ParallelDataStatusActive,
		ParallelDataStatusDeleting,
		ParallelDataStatusFailed,
	}
}

const (
	// ProfanityMask is a Profanity enum value
	ProfanityMask = "MASK"
)

// Profanity_Values returns all elements of the Profanity enum
func Profanity_Values() []string {
	return []string{
		ProfanityMask,
	}
}

const (
	// TerminologyDataFormatCsv is a TerminologyDataFormat enum value
	TerminologyDataFormatCsv = "CSV"

	// TerminologyDataFormatTmx is a TerminologyDataFormat enum value
	TerminologyDataFormatTmx = "TMX"

	// TerminologyDataFormatTsv is a TerminologyDataFormat enum value
	TerminologyDataFormatTsv = "TSV"
)

// TerminologyDataFormat_Values returns all elements of the TerminologyDataFormat enum
func TerminologyDataFormat_Values() []string {
	return []string{
		TerminologyDataFormatCsv,
		TerminologyDataFormatTmx,
		TerminologyDataFormatTsv,
	}
}
