// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectorlogs "go.opentelemetry.io/proto/slim/otlp/collector/logs/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyExportLogsServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewExportLogsServiceRequest()
				CopyExportLogsServiceRequest(dest, src)
				assert.Equal(t, src, dest)
				CopyExportLogsServiceRequest(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyExportLogsServiceRequestSlice(t *testing.T) {
	src := []ExportLogsServiceRequest{}
	dest := []ExportLogsServiceRequest{}
	// Test CopyTo empty
	dest = CopyExportLogsServiceRequestSlice(dest, src)
	assert.Equal(t, []ExportLogsServiceRequest{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportLogsServiceRequestSlice()
	dest = CopyExportLogsServiceRequestSlice(dest, src)
	assert.Equal(t, GenTestExportLogsServiceRequestSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportLogsServiceRequestSlice(dest, src)
	assert.Equal(t, GenTestExportLogsServiceRequestSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportLogsServiceRequestSlice(dest, []ExportLogsServiceRequest{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportLogsServiceRequestSlice(dest, src)
	assert.Equal(t, GenTestExportLogsServiceRequestSlice(), dest)
}

func TestCopyExportLogsServiceRequestPtrSlice(t *testing.T) {
	src := []*ExportLogsServiceRequest{}
	dest := []*ExportLogsServiceRequest{}
	// Test CopyTo empty
	dest = CopyExportLogsServiceRequestPtrSlice(dest, src)
	assert.Equal(t, []*ExportLogsServiceRequest{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportLogsServiceRequestPtrSlice()
	dest = CopyExportLogsServiceRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestExportLogsServiceRequestPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportLogsServiceRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestExportLogsServiceRequestPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportLogsServiceRequestPtrSlice(dest, []*ExportLogsServiceRequest{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportLogsServiceRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestExportLogsServiceRequestPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONExportLogsServiceRequestUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewExportLogsServiceRequest()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewExportLogsServiceRequest(), dest)
}

func TestMarshalAndUnmarshalJSONExportLogsServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewExportLogsServiceRequest()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteExportLogsServiceRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoExportLogsServiceRequestFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportLogsServiceRequest() {
		t.Run(name, func(t *testing.T) {
			dest := NewExportLogsServiceRequest()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoExportLogsServiceRequestUnknown(t *testing.T) {
	dest := NewExportLogsServiceRequest()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewExportLogsServiceRequest(), dest)
}

func TestMarshalAndUnmarshalProtoExportLogsServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewExportLogsServiceRequest()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteExportLogsServiceRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportLogsServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsServiceRequest() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectorlogs.ExportLogsServiceRequest{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewExportLogsServiceRequest()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportLogsServiceRequest() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                {0x02},
		"ResourceLogs/wrong_wire_type": {0xc},
		"ResourceLogs/missing_value":   {0xa},
	}
}

func genTestEncodingValuesExportLogsServiceRequest() map[string]*ExportLogsServiceRequest {
	return map[string]*ExportLogsServiceRequest{
		"empty":             NewExportLogsServiceRequest(),
		"ResourceLogs/test": {ResourceLogs: []*ResourceLogs{{}, GenTestResourceLogs()}},
	}
}
