// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ResourceProfiles is a collection of profiles from a Resource.
type ResourceProfiles struct {
	Resource      Resource
	ScopeProfiles []*ScopeProfiles
	SchemaUrl     string
}

var (
	protoPoolResourceProfiles = sync.Pool{
		New: func() any {
			return &ResourceProfiles{}
		},
	}
)

func NewResourceProfiles() *ResourceProfiles {
	if !UseProtoPooling.IsEnabled() {
		return &ResourceProfiles{}
	}
	return protoPoolResourceProfiles.Get().(*ResourceProfiles)
}

func DeleteResourceProfiles(orig *ResourceProfiles, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteResource(&orig.Resource, false)
	for i := range orig.ScopeProfiles {
		DeleteScopeProfiles(orig.ScopeProfiles[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolResourceProfiles.Put(orig)
	}
}

func CopyResourceProfiles(dest, src *ResourceProfiles) *ResourceProfiles {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewResourceProfiles()
	}
	CopyResource(&dest.Resource, &src.Resource)

	dest.ScopeProfiles = CopyScopeProfilesPtrSlice(dest.ScopeProfiles, src.ScopeProfiles)

	dest.SchemaUrl = src.SchemaUrl

	return dest
}

func CopyResourceProfilesSlice(dest, src []ResourceProfiles) []ResourceProfiles {
	var newDest []ResourceProfiles
	if cap(dest) < len(src) {
		newDest = make([]ResourceProfiles, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteResourceProfiles(&dest[i], false)
		}
	}
	for i := range src {
		CopyResourceProfiles(&newDest[i], &src[i])
	}
	return newDest
}

func CopyResourceProfilesPtrSlice(dest, src []*ResourceProfiles) []*ResourceProfiles {
	var newDest []*ResourceProfiles
	if cap(dest) < len(src) {
		newDest = make([]*ResourceProfiles, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewResourceProfiles()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteResourceProfiles(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewResourceProfiles()
		}
	}
	for i := range src {
		CopyResourceProfiles(newDest[i], src[i])
	}
	return newDest
}

func (orig *ResourceProfiles) Reset() {
	*orig = ResourceProfiles{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ResourceProfiles) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("resource")
	orig.Resource.MarshalJSON(dest)
	if len(orig.ScopeProfiles) > 0 {
		dest.WriteObjectField("scopeProfiles")
		dest.WriteArrayStart()
		orig.ScopeProfiles[0].MarshalJSON(dest)
		for i := 1; i < len(orig.ScopeProfiles); i++ {
			dest.WriteMore()
			orig.ScopeProfiles[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.SchemaUrl != "" {
		dest.WriteObjectField("schemaUrl")
		dest.WriteString(orig.SchemaUrl)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ResourceProfiles) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "resource":

			orig.Resource.UnmarshalJSON(iter)
		case "scopeProfiles", "scope_profiles":
			for iter.ReadArray() {
				orig.ScopeProfiles = append(orig.ScopeProfiles, NewScopeProfiles())
				orig.ScopeProfiles[len(orig.ScopeProfiles)-1].UnmarshalJSON(iter)
			}

		case "schemaUrl", "schema_url":
			orig.SchemaUrl = iter.ReadString()
		default:
			iter.Skip()
		}
	}
}

func (orig *ResourceProfiles) SizeProto() int {
	var n int
	var l int
	_ = l
	l = orig.Resource.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.ScopeProfiles {
		l = orig.ScopeProfiles[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *ResourceProfiles) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = orig.Resource.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	for i := len(orig.ScopeProfiles) - 1; i >= 0; i-- {
		l = orig.ScopeProfiles[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.SchemaUrl)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	return len(buf) - pos
}

func (orig *ResourceProfiles) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.Resource.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ScopeProfiles", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.ScopeProfiles = append(orig.ScopeProfiles, NewScopeProfiles())
			err = orig.ScopeProfiles[len(orig.ScopeProfiles)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.SchemaUrl = string(buf[startPos:pos])
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestResourceProfiles() *ResourceProfiles {
	orig := NewResourceProfiles()
	orig.Resource = *GenTestResource()
	orig.ScopeProfiles = []*ScopeProfiles{{}, GenTestScopeProfiles()}
	orig.SchemaUrl = "test_schemaurl"
	return orig
}

func GenTestResourceProfilesPtrSlice() []*ResourceProfiles {
	orig := make([]*ResourceProfiles, 5)
	orig[0] = NewResourceProfiles()
	orig[1] = GenTestResourceProfiles()
	orig[2] = NewResourceProfiles()
	orig[3] = GenTestResourceProfiles()
	orig[4] = NewResourceProfiles()
	return orig
}

func GenTestResourceProfilesSlice() []ResourceProfiles {
	orig := make([]ResourceProfiles, 5)
	orig[1] = *GenTestResourceProfiles()
	orig[3] = *GenTestResourceProfiles()
	return orig
}
