// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
)

func TestHistogram_MoveTo(t *testing.T) {
	ms := generateTestHistogram()
	dest := NewHistogram()
	ms.MoveTo(dest)
	assert.Equal(t, NewHistogram(), ms)
	assert.Equal(t, generateTestHistogram(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestHistogram(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newHistogram(internal.NewHistogram(), sharedState)) })
	assert.Panics(t, func() { newHistogram(internal.NewHistogram(), sharedState).MoveTo(dest) })
}

func TestHistogram_CopyTo(t *testing.T) {
	ms := NewHistogram()
	orig := NewHistogram()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestHistogram()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newHistogram(internal.NewHistogram(), sharedState)) })
}

func TestHistogram_DataPoints(t *testing.T) {
	ms := NewHistogram()
	assert.Equal(t, NewHistogramDataPointSlice(), ms.DataPoints())
	ms.orig.DataPoints = internal.GenTestHistogramDataPointPtrSlice()
	assert.Equal(t, generateTestHistogramDataPointSlice(), ms.DataPoints())
}

func TestHistogram_AggregationTemporality(t *testing.T) {
	ms := NewHistogram()
	assert.Equal(t, AggregationTemporality(internal.AggregationTemporality(0)), ms.AggregationTemporality())
	testValAggregationTemporality := AggregationTemporality(internal.AggregationTemporality(1))
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.Equal(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func generateTestHistogram() Histogram {
	return newHistogram(internal.GenTestHistogram(), internal.NewState())
}
