// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// Profile are an implementation of the pprofextended data model.

type Profile struct {
	SampleType             ValueType
	Samples                []*Sample
	TimeUnixNano           uint64
	DurationNano           uint64
	PeriodType             ValueType
	Period                 int64
	ProfileId              ProfileID
	DroppedAttributesCount uint32
	OriginalPayloadFormat  string
	OriginalPayload        []byte
	AttributeIndices       []int32
}

var (
	protoPoolProfile = sync.Pool{
		New: func() any {
			return &Profile{}
		},
	}
)

func NewProfile() *Profile {
	if !UseProtoPooling.IsEnabled() {
		return &Profile{}
	}
	return protoPoolProfile.Get().(*Profile)
}

func DeleteProfile(orig *Profile, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteValueType(&orig.SampleType, false)
	for i := range orig.Samples {
		DeleteSample(orig.Samples[i], true)
	}
	DeleteValueType(&orig.PeriodType, false)
	DeleteProfileID(&orig.ProfileId, false)

	orig.Reset()
	if nullable {
		protoPoolProfile.Put(orig)
	}
}

func CopyProfile(dest, src *Profile) *Profile {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewProfile()
	}
	CopyValueType(&dest.SampleType, &src.SampleType)

	dest.Samples = CopySamplePtrSlice(dest.Samples, src.Samples)

	dest.TimeUnixNano = src.TimeUnixNano

	dest.DurationNano = src.DurationNano

	CopyValueType(&dest.PeriodType, &src.PeriodType)

	dest.Period = src.Period

	CopyProfileID(&dest.ProfileId, &src.ProfileId)

	dest.DroppedAttributesCount = src.DroppedAttributesCount

	dest.OriginalPayloadFormat = src.OriginalPayloadFormat

	dest.OriginalPayload = src.OriginalPayload

	dest.AttributeIndices = append(dest.AttributeIndices[:0], src.AttributeIndices...)

	return dest
}

func CopyProfileSlice(dest, src []Profile) []Profile {
	var newDest []Profile
	if cap(dest) < len(src) {
		newDest = make([]Profile, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteProfile(&dest[i], false)
		}
	}
	for i := range src {
		CopyProfile(&newDest[i], &src[i])
	}
	return newDest
}

func CopyProfilePtrSlice(dest, src []*Profile) []*Profile {
	var newDest []*Profile
	if cap(dest) < len(src) {
		newDest = make([]*Profile, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewProfile()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteProfile(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewProfile()
		}
	}
	for i := range src {
		CopyProfile(newDest[i], src[i])
	}
	return newDest
}

func (orig *Profile) Reset() {
	*orig = Profile{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *Profile) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("sampleType")
	orig.SampleType.MarshalJSON(dest)
	if len(orig.Samples) > 0 {
		dest.WriteObjectField("samples")
		dest.WriteArrayStart()
		orig.Samples[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Samples); i++ {
			dest.WriteMore()
			orig.Samples[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.TimeUnixNano != uint64(0) {
		dest.WriteObjectField("timeUnixNano")
		dest.WriteUint64(orig.TimeUnixNano)
	}
	if orig.DurationNano != uint64(0) {
		dest.WriteObjectField("durationNano")
		dest.WriteUint64(orig.DurationNano)
	}
	dest.WriteObjectField("periodType")
	orig.PeriodType.MarshalJSON(dest)
	if orig.Period != int64(0) {
		dest.WriteObjectField("period")
		dest.WriteInt64(orig.Period)
	}
	if !orig.ProfileId.IsEmpty() {
		dest.WriteObjectField("profileId")
		orig.ProfileId.MarshalJSON(dest)
	}
	if orig.DroppedAttributesCount != uint32(0) {
		dest.WriteObjectField("droppedAttributesCount")
		dest.WriteUint32(orig.DroppedAttributesCount)
	}
	if orig.OriginalPayloadFormat != "" {
		dest.WriteObjectField("originalPayloadFormat")
		dest.WriteString(orig.OriginalPayloadFormat)
	}

	if len(orig.OriginalPayload) > 0 {
		dest.WriteObjectField("originalPayload")
		dest.WriteBytes(orig.OriginalPayload)
	}
	if len(orig.AttributeIndices) > 0 {
		dest.WriteObjectField("attributeIndices")
		dest.WriteArrayStart()
		dest.WriteInt32(orig.AttributeIndices[0])
		for i := 1; i < len(orig.AttributeIndices); i++ {
			dest.WriteMore()
			dest.WriteInt32(orig.AttributeIndices[i])
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *Profile) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "sampleType", "sample_type":

			orig.SampleType.UnmarshalJSON(iter)
		case "samples":
			for iter.ReadArray() {
				orig.Samples = append(orig.Samples, NewSample())
				orig.Samples[len(orig.Samples)-1].UnmarshalJSON(iter)
			}

		case "timeUnixNano", "time_unix_nano":
			orig.TimeUnixNano = iter.ReadUint64()
		case "durationNano", "duration_nano":
			orig.DurationNano = iter.ReadUint64()
		case "periodType", "period_type":

			orig.PeriodType.UnmarshalJSON(iter)
		case "period":
			orig.Period = iter.ReadInt64()
		case "profileId", "profile_id":

			orig.ProfileId.UnmarshalJSON(iter)
		case "droppedAttributesCount", "dropped_attributes_count":
			orig.DroppedAttributesCount = iter.ReadUint32()
		case "originalPayloadFormat", "original_payload_format":
			orig.OriginalPayloadFormat = iter.ReadString()
		case "originalPayload", "original_payload":
			orig.OriginalPayload = iter.ReadBytes()
		case "attributeIndices", "attribute_indices":
			for iter.ReadArray() {
				orig.AttributeIndices = append(orig.AttributeIndices, iter.ReadInt32())
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *Profile) SizeProto() int {
	var n int
	var l int
	_ = l
	l = orig.SampleType.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.Samples {
		l = orig.Samples[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.TimeUnixNano != 0 {
		n += 9
	}
	if orig.DurationNano != 0 {
		n += 1 + proto.Sov(uint64(orig.DurationNano))
	}
	l = orig.PeriodType.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	if orig.Period != 0 {
		n += 1 + proto.Sov(uint64(orig.Period))
	}
	l = orig.ProfileId.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	if orig.DroppedAttributesCount != 0 {
		n += 1 + proto.Sov(uint64(orig.DroppedAttributesCount))
	}
	l = len(orig.OriginalPayloadFormat)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.OriginalPayload)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if len(orig.AttributeIndices) > 0 {
		l = 0
		for _, e := range orig.AttributeIndices {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *Profile) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = orig.SampleType.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	for i := len(orig.Samples) - 1; i >= 0; i-- {
		l = orig.Samples[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	if orig.TimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.TimeUnixNano))
		pos--
		buf[pos] = 0x19
	}
	if orig.DurationNano != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DurationNano))
		pos--
		buf[pos] = 0x20
	}
	l = orig.PeriodType.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x2a

	if orig.Period != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Period))
		pos--
		buf[pos] = 0x30
	}
	l = orig.ProfileId.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x3a

	if orig.DroppedAttributesCount != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DroppedAttributesCount))
		pos--
		buf[pos] = 0x40
	}
	l = len(orig.OriginalPayloadFormat)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.OriginalPayloadFormat)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x4a
	}
	l = len(orig.OriginalPayload)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.OriginalPayload)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x52
	}
	l = len(orig.AttributeIndices)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.AttributeIndices[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x5a
	}
	return len(buf) - pos
}

func (orig *Profile) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SampleType", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.SampleType.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Samples", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Samples = append(orig.Samples, NewSample())
			err = orig.Samples[len(orig.Samples)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.TimeUnixNano = uint64(num)

		case 4:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field DurationNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.DurationNano = uint64(num)

		case 5:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field PeriodType", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.PeriodType.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 6:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Period", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.Period = int64(num)

		case 7:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ProfileId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.ProfileId.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 8:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.DroppedAttributesCount = uint32(num)

		case 9:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalPayloadFormat", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.OriginalPayloadFormat = string(buf[startPos:pos])

		case 10:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalPayload", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			if length != 0 {
				orig.OriginalPayload = make([]byte, length)
				copy(orig.OriginalPayload, buf[startPos:pos])
			}
		case 11:
			switch wireType {
			case proto.WireTypeLen:
				var length int
				length, pos, err = proto.ConsumeLen(buf, pos)
				if err != nil {
					return err
				}
				startPos := pos - length
				var num uint64
				for startPos < pos {
					num, startPos, err = proto.ConsumeVarint(buf[:pos], startPos)
					if err != nil {
						return err
					}
					orig.AttributeIndices = append(orig.AttributeIndices, int32(num))
				}
				if startPos != pos {
					return fmt.Errorf("proto: invalid field len = %d for field AttributeIndices", pos-startPos)
				}
			case proto.WireTypeVarint:
				var num uint64
				num, pos, err = proto.ConsumeVarint(buf, pos)
				if err != nil {
					return err
				}
				orig.AttributeIndices = append(orig.AttributeIndices, int32(num))
			default:
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeIndices", wireType)
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestProfile() *Profile {
	orig := NewProfile()
	orig.SampleType = *GenTestValueType()
	orig.Samples = []*Sample{{}, GenTestSample()}
	orig.TimeUnixNano = uint64(13)
	orig.DurationNano = uint64(13)
	orig.PeriodType = *GenTestValueType()
	orig.Period = int64(13)
	orig.ProfileId = *GenTestProfileID()
	orig.DroppedAttributesCount = uint32(13)
	orig.OriginalPayloadFormat = "test_originalpayloadformat"
	orig.OriginalPayload = []byte{1, 2, 3}
	orig.AttributeIndices = []int32{int32(0), int32(13)}
	return orig
}

func GenTestProfilePtrSlice() []*Profile {
	orig := make([]*Profile, 5)
	orig[0] = NewProfile()
	orig[1] = GenTestProfile()
	orig[2] = NewProfile()
	orig[3] = GenTestProfile()
	orig[4] = NewProfile()
	return orig
}

func GenTestProfileSlice() []Profile {
	orig := make([]Profile, 5)
	orig[1] = *GenTestProfile()
	orig[3] = *GenTestProfile()
	return orig
}
