/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptedServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.KeyShareEntryParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncryptedServerNameIndicationExtensionParser
extends ExtensionParser<EncryptedServerNameIndicationExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final byte[] array;

    public EncryptedServerNameIndicationExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
        this.array = array;
    }

    @Override
    public void parseExtensionMessageContent(EncryptedServerNameIndicationExtensionMessage msg) {
        boolean isParserClientMode;
        if ((Integer)msg.getExtensionLength().getValue() == 0) {
            LOGGER.debug("Received empty ESNI Extension");
            return;
        }
        boolean bl = isParserClientMode = (Integer)msg.getExtensionLength().getValue() == 16;
        if (isParserClientMode) {
            this.parseNonce(msg);
        } else {
            this.parseCipherSuite(msg);
            this.parseKeyShareEntry(msg);
            this.parseRecordDigestLength(msg);
            this.parseRecordDigest(msg);
            this.parseEncryptedSniLength(msg);
            this.parseEncryptedSni(msg);
        }
    }

    @Override
    protected EncryptedServerNameIndicationExtensionMessage createExtensionMessage() {
        return new EncryptedServerNameIndicationExtensionMessage();
    }

    private void parseNonce(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] nonce = this.parseByteArrayField(16);
        msg.setServerNonce(nonce);
        LOGGER.info("Received Nonce: " + ArrayConverter.bytesToHexString((byte[])nonce));
    }

    private void parseCipherSuite(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] cipherSuite = this.parseByteArrayField(2);
        msg.setCipherSuite(cipherSuite);
        LOGGER.debug("cipherSuite: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getCipherSuite().getValue())));
    }

    private void parseKeyShareEntry(EncryptedServerNameIndicationExtensionMessage msg) {
        KeyShareEntryParser parser = new KeyShareEntryParser(this.getPointer(), this.array);
        KeyShareEntry keyShareEntry = parser.parse();
        this.setPointer(parser.getPointer());
        msg.setKeyShareEntry(keyShareEntry);
    }

    private void parseRecordDigestLength(EncryptedServerNameIndicationExtensionMessage msg) {
        int digestLen = this.parseIntField(2);
        msg.setRecordDigestLength(digestLen);
        LOGGER.debug("recordDigestLength: " + msg.getRecordDigestLength().getValue());
    }

    private void parseRecordDigest(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] recordDigest = this.parseByteArrayField((Integer)msg.getRecordDigestLength().getValue());
        msg.setRecordDigest(recordDigest);
        LOGGER.debug("recordDigest: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getRecordDigest().getValue())));
    }

    private void parseEncryptedSniLength(EncryptedServerNameIndicationExtensionMessage msg) {
        int encryptedSniLength = this.parseIntField(2);
        msg.setEncryptedSniLength(encryptedSniLength);
        LOGGER.debug("encryptedSniLength: " + msg.getEncryptedSniLength());
    }

    private void parseEncryptedSni(EncryptedServerNameIndicationExtensionMessage msg) {
        byte[] encryptedSni = this.parseByteArrayField(msg.getEncryptedSniLength().getOriginalValue());
        msg.setEncryptedSni(encryptedSni);
        LOGGER.debug("encryptedSni: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getEncryptedSni().getValue())));
    }
}

