=begin
    
    File:	examples/ex_alpha.pl
	Author: Josiah Bryan, <jdb@wcoil.com>
	Desc: 

		This demonstrates the ability of a neural net to 
		generalize and predict what the correct result is 
		for inputs that it has never seen before.
		
		This teaches the network to classify some twenty-
		nine seperate 35-byte bitmaps, and then it inputs
		an never-before-seen bitmap and displays the 
		classification the network gives for the unknown bitmap.

=cut

	use AI::NeuralNet::Mesh;

	# Create a new network with 35 neurons in input layer and 1 output neuron
	my $net = new AI::NeuralNet::Mesh([
		{
			nodes		=>	35,
			activation	=>	linear
		},
		{
			nodes		=>	1,
			activation	=>	linear,
		}
	]);
	
	# Debug level of 4 gives JUST learn loop iteteration benchmark and comparrison data 
	# as learning progresses.
	$net->debug(4);

	my $letters = [            # All prototype inputs        
        [
        0,1,1,1,0,             # Inputs are   
        1,0,0,0,1,             #  5*7 digitalized caracters 
        1,0,0,0,1,              
        1,1,1,1,1,
        1,0,0,0,1,             # This is the alphabet of the
        1,0,0,0,1,             # HP 28S                      
        1,0,0,0,1,
        ],[0],[
        1,1,1,1,0,
        1,0,0,0,1,
        1,0,0,0,1,
        1,1,1,1,0,
        1,0,0,0,1,
        1,0,0,0,1,
        1,1,1,1,0,
        ],[1],[
        0,1,1,1,0,
        1,0,0,0,1,
        1,0,0,0,0,
        1,0,0,0,0,
        1,0,0,0,0,
        1,0,0,0,1,
        0,1,1,1,0,
        ],[2],[
        1,1,1,0,0,
        1,0,0,1,0,
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,1,0,
        1,1,1,0,0,
        ],[4],[
        1,1,1,1,1,
        1,0,0,0,0,
        1,0,0,0,0,
        1,1,1,1,0,
        1,0,0,0,0,
        1,0,0,0,0,
        1,1,1,1,1,
        ],[5],[
        1,1,1,1,1,
        1,0,0,0,0,
        1,0,0,0,0,
        1,1,1,1,0,
        1,0,0,0,0,
        1,0,0,0,0,
        1,0,0,0,0,
		],[6],[
        0,1,1,1,0,
        1,0,0,0,1,
        1,0,0,0,0,
        1,0,0,0,0,
        1,0,0,1,1,
        1,0,0,0,1,
        0,1,1,1,0,
		],[7],[
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,0,1,
        1,1,1,1,1,
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,0,1,
		],[8],[
        1,1,1,1,1,
        0,1,1,1,0,
        0,1,1,1,0,
        0,1,1,1,0,
        0,1,1,1,0,
        0,1,1,1,0,
        1,1,1,1,1,
		],[9],[
        0,0,0,0,1,
        0,0,0,0,1,
        0,0,0,0,1,
        0,0,0,0,1,
        0,0,0,0,1,
        1,0,0,0,1,
        0,1,1,1,0,
		],[10],[
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,1,0,
        1,1,1,0,0,
        1,0,0,1,0,
        1,0,0,0,1,
        1,0,0,0,1,
		],[11],[
        1,0,0,0,0,
        1,0,0,0,0,
        1,0,0,0,0,
        1,0,0,0,0,
        1,0,0,0,0,
        1,0,0,0,0,
        1,1,1,1,1,
		],[12],[
        1,0,0,0,1,
        1,1,0,1,1,
        1,0,1,0,1,
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,0,1,
		],[13],[
        1,0,0,0,1,
        1,0,0,0,1,
        1,1,0,0,1,
        1,0,1,0,1,
        1,0,0,1,1,
        1,0,0,0,1,
        1,0,0,0,1,
		],[14],[
        0,1,1,1,0,
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,0,1,
        0,1,1,1,0,
		],[15],[
        1,1,1,1,0,
        1,0,0,0,1,
        1,0,0,0,1,
        1,1,1,1,0,
        1,0,0,0,0,
        1,0,0,0,0,
        1,0,0,0,0,
		],[16],[
        0,1,1,1,0,
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,1,0,1,
        1,0,0,1,0,
        0,1,1,0,1,
		],[17],[
        1,1,1,1,0,
        1,0,0,0,1,
        1,0,0,0,1,
        1,1,1,1,0,
        1,0,1,0,0,
        1,0,0,1,0,
        1,0,0,0,1,
		],[18],[
        0,1,1,1,0,
        1,0,0,0,1,
        1,0,0,0,0,
        0,1,1,1,0,
        0,0,0,0,1,
        1,0,0,0,1,
        0,1,1,1,0,
		],[19],[
        1,1,1,1,1,
        0,0,1,0,0,
        0,0,1,0,0,
        0,0,1,0,0,
        0,0,1,0,0,
        0,0,1,0,0,
        0,0,1,0,0,
		],[20],[
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,0,1,
        0,1,1,1,0,
		],[21],[
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,0,1,
        0,1,0,1,0,
        0,0,1,0,0,
		],[22],[
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,1,0,1,
        1,0,1,0,1,
        1,1,0,1,1,
        1,0,0,0,1,
		],[23],[
        1,0,0,0,1,
        1,0,0,0,1,
        0,1,0,1,0,
        0,0,1,0,0,
        0,1,0,1,0,
        1,0,0,0,1,
        1,0,0,0,1,
		],[24],[
        1,0,0,0,1,
        1,0,0,0,1,
        0,1,0,1,0,
        0,0,1,0,0,
        0,0,1,0,0,
        0,0,1,0,0,
        0,0,1,0,0,
		],[25],[
        1,1,1,1,1,
        0,0,0,0,1,
        0,0,0,1,0,
        0,0,1,0,0,
        0,1,0,0,0,
        1,0,0,0,0,
        1,1,1,1,1,
		],[26],[
        0,0,1,0,0,
        0,1,1,1,0,
        0,1,0,1,0,
        1,1,0,1,1,
        1,1,1,1,1,
        1,1,0,1,1,
        1,0,0,0,1,
		],[27],[
        1,0,0,0,1,
        0,1,0,0,1,
        0,0,1,1,0,
        0,0,1,1,0,
        0,0,1,0,0,
        0,1,0,0,0,
        1,0,0,0,0,
		],[28],[
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,1,0,1,
        1,1,1,1,1,
        1,1,1,1,1,
        0,1,0,1,0,
        0,1,0,1,0,
        ],[29],[
        1,0,0,0,1,
        1,0,0,0,1,
        1,0,0,0,1,
        1,1,0,1,1,
        0,1,0,1,0,
        0,1,1,1,0,
        0,0,1,0,2
        ]
     ];
	
	if(!$net->load("alpha.mesh")) {
		#$net->range(0..29);
		$net->learn_set($letters);
		$net->save("alpha.mesh");
	}
			
	# Build a test map 
	my $tmp	=	[0,1,1,1,0,
				 1,0,0,0,1,
				 1,0,0,0,1,
				 1,1,1,1,1,
				 1,0,0,0,1,
				 1,0,0,0,1,
				 1,0,0,0,1];
	
	# Display test map
	print "\nTest map:\n";
	$net->join_cols($tmp,5);
	
	# Display network results
	print "Letter index matched: ",$net->run($tmp)->[0],"\n";
	
