/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.pipeline.stages;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.cloud.firestore.PipelineUtils;
import com.google.cloud.firestore.pipeline.stages.SampleOptions;
import com.google.cloud.firestore.pipeline.stages.Stage;
import com.google.common.collect.ImmutableList;
import com.google.firestore.v1.Value;
import javax.annotation.Nonnull;

public final class Sample
extends Stage {
    private final Number size;
    private final Mode mode;

    @BetaApi
    public static Sample withPercentage(double percentage) {
        return new Sample(percentage, Mode.PERCENT, new SampleOptions());
    }

    @BetaApi
    public static Sample withDocLimit(int documents) {
        return new Sample(documents, Mode.DOCUMENTS, new SampleOptions());
    }

    @BetaApi
    public Sample withOptions(@Nonnull SampleOptions options) {
        return new Sample(this.size, this.mode, options);
    }

    @InternalApi
    private Sample(Number size, Mode mode, SampleOptions options) {
        super("sample", options.options);
        this.size = size;
        this.mode = mode;
    }

    @Override
    Iterable<Value> toStageArgs() {
        return ImmutableList.of((Object)PipelineUtils.encodeValue(this.size), (Object)this.mode.value);
    }

    public static enum Mode {
        DOCUMENTS(PipelineUtils.encodeValue("documents")),
        PERCENT(PipelineUtils.encodeValue("percent"));

        public final Value value;

        private Mode(Value value) {
            this.value = value;
        }
    }
}

