/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.session.state;

import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.reports.common.TripsConfig;
import org.traccar.session.state.MotionState;

public final class MotionProcessor {
    private MotionProcessor() {
    }

    public static void updateState(MotionState state, Position last, Position position, boolean newState, TripsConfig tripsConfig) {
        boolean oldState;
        state.setEvent(null);
        if (last != null) {
            long oldTime = last.getFixTime().getTime();
            long newTime = position.getFixTime().getTime();
            if (newTime - oldTime >= tripsConfig.getMinimalNoDataDuration() && state.getMotionStreak()) {
                state.setMotionStreak(false);
                state.setMotionState(false);
                state.setMotionPositionId(0L);
                state.setMotionTime(null);
                state.setMotionDistance(0.0);
                state.setEvent(new Event("deviceStopped", last));
                return;
            }
        }
        if ((oldState = state.getMotionState()) == newState) {
            if (state.getMotionTime() != null) {
                long oldTime = state.getMotionTime().getTime();
                long newTime = position.getFixTime().getTime();
                double distance = position.getDouble("totalDistance") - state.getMotionDistance();
                Boolean ignition = null;
                if (tripsConfig.getUseIgnition() && position.hasAttribute("ignition")) {
                    ignition = position.getBoolean("ignition");
                }
                boolean generateEvent = false;
                if (newState) {
                    if (newTime - oldTime >= tripsConfig.getMinimalTripDuration() || distance >= tripsConfig.getMinimalTripDistance()) {
                        generateEvent = true;
                    }
                } else if (newTime - oldTime >= tripsConfig.getMinimalParkingDuration() || ignition != null && !ignition.booleanValue()) {
                    generateEvent = true;
                }
                if (generateEvent) {
                    String eventType = newState ? "deviceMoving" : "deviceStopped";
                    Event event = new Event(eventType, position.getDeviceId());
                    event.setPositionId(state.getMotionPositionId());
                    event.setEventTime(state.getMotionTime());
                    state.setMotionStreak(newState);
                    state.setMotionPositionId(0L);
                    state.setMotionTime(null);
                    state.setMotionDistance(0.0);
                    state.setEvent(event);
                }
            }
        } else {
            state.setMotionState(newState);
            if (state.getMotionStreak() == newState) {
                state.setMotionPositionId(0L);
                state.setMotionTime(null);
                state.setMotionDistance(0.0);
            } else {
                state.setMotionPositionId(position.getId());
                state.setMotionTime(position.getFixTime());
                state.setMotionDistance(position.getDouble("totalDistance"));
            }
        }
    }
}

