/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import java.util.Arrays;
import java.util.Objects;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.args.RawableFactory;
import redis.clients.jedis.args.StreamDeletionPolicy;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.util.SafeEncoder;

public class XAddParams
implements IParams {
    private Rawable id;
    private Long maxLen;
    private boolean approximateTrimming;
    private boolean exactTrimming;
    private boolean nomkstream;
    private String minId;
    private Long limit;
    private StreamDeletionPolicy trimMode;
    private byte[] producerId;
    private byte[] idempotentId;
    private boolean idmpAuto;

    public static XAddParams xAddParams() {
        return new XAddParams();
    }

    public XAddParams noMkStream() {
        this.nomkstream = true;
        return this;
    }

    public XAddParams id(byte[] id) {
        this.id = RawableFactory.from(id);
        return this;
    }

    public XAddParams id(String id) {
        this.id = RawableFactory.from(id);
        return this;
    }

    public XAddParams id(StreamEntryID id) {
        return this.id(id.toString());
    }

    public XAddParams id(long time, long sequence) {
        return this.id(time + "-" + sequence);
    }

    public XAddParams id(long time) {
        return this.id(time + "-*");
    }

    public XAddParams maxLen(long maxLen) {
        this.maxLen = maxLen;
        return this;
    }

    public XAddParams minId(String minId) {
        this.minId = minId;
        return this;
    }

    public XAddParams approximateTrimming() {
        this.approximateTrimming = true;
        return this;
    }

    public XAddParams exactTrimming() {
        this.exactTrimming = true;
        return this;
    }

    public XAddParams limit(long limit) {
        this.limit = limit;
        return this;
    }

    public XAddParams trimmingMode(StreamDeletionPolicy trimMode) {
        this.trimMode = trimMode;
        return this;
    }

    public XAddParams idmpAuto(byte[] producerId) {
        this.producerId = producerId;
        this.idmpAuto = true;
        this.idempotentId = null;
        return this;
    }

    public XAddParams idmpAuto(String producerId) {
        return this.idmpAuto(SafeEncoder.encode(producerId));
    }

    public XAddParams idmp(byte[] producerId, byte[] idempotentId) {
        this.producerId = producerId;
        this.idempotentId = idempotentId;
        this.idmpAuto = false;
        return this;
    }

    public XAddParams idmp(String producerId, String idempotentId) {
        return this.idmp(SafeEncoder.encode(producerId), SafeEncoder.encode(idempotentId));
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.nomkstream) {
            args.add(Protocol.Keyword.NOMKSTREAM);
        }
        if (this.trimMode != null) {
            args.add(this.trimMode);
        }
        if (this.producerId != null) {
            if (this.idmpAuto) {
                args.add(Protocol.Keyword.IDMPAUTO).add(this.producerId);
            } else if (this.idempotentId != null) {
                args.add(Protocol.Keyword.IDMP).add(this.producerId).add(this.idempotentId);
            }
        }
        if (this.maxLen != null) {
            args.add(Protocol.Keyword.MAXLEN);
            if (this.approximateTrimming) {
                args.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                args.add(Protocol.BYTES_EQUAL);
            }
            args.add(this.maxLen);
        } else if (this.minId != null) {
            args.add(Protocol.Keyword.MINID);
            if (this.approximateTrimming) {
                args.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                args.add(Protocol.BYTES_EQUAL);
            }
            args.add(this.minId);
        }
        if (this.limit != null) {
            args.add(Protocol.Keyword.LIMIT).add(this.limit);
        }
        args.add(this.id != null ? this.id : StreamEntryID.NEW_ENTRY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XAddParams that = (XAddParams)o;
        return this.approximateTrimming == that.approximateTrimming && this.exactTrimming == that.exactTrimming && this.nomkstream == that.nomkstream && this.idmpAuto == that.idmpAuto && Objects.equals(this.id, that.id) && Objects.equals(this.maxLen, that.maxLen) && Objects.equals(this.minId, that.minId) && Objects.equals(this.limit, that.limit) && this.trimMode == that.trimMode && Objects.deepEquals(this.producerId, that.producerId) && Objects.deepEquals(this.idempotentId, that.idempotentId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.maxLen, this.approximateTrimming, this.exactTrimming, this.nomkstream, this.minId, this.limit, this.trimMode, Arrays.hashCode(this.producerId), Arrays.hashCode(this.idempotentId), this.idmpAuto);
    }
}

