/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.api;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public interface Callback {
    public static final Callback NOOP = new Callback(){};

    public static Callback from(final Runnable success, final Consumer<Throwable> failure) {
        return new Callback(){

            @Override
            public void succeed() {
                success.run();
            }

            @Override
            public void fail(Throwable x) {
                failure.accept(x);
            }
        };
    }

    public static Callback from(final Callback callback, final Runnable completed) {
        return new Callback(){

            @Override
            public void succeed() {
                try {
                    callback.succeed();
                }
                finally {
                    completed.run();
                }
            }

            @Override
            public void fail(Throwable x) {
                try {
                    callback.fail(x);
                }
                finally {
                    completed.run();
                }
            }
        };
    }

    default public void succeed() {
    }

    default public void fail(Throwable x) {
    }

    default public BiConsumer<? super Void, ? super Throwable> asBiConsumer() {
        return (r, x) -> {
            if (x == null) {
                this.succeed();
            } else {
                this.fail((Throwable)x);
            }
        };
    }

    public static class Completable
    extends CompletableFuture<Void>
    implements Callback {
        public static Completable with(Consumer<Completable> consumer) {
            Completable completable = new Completable();
            consumer.accept(completable);
            return completable;
        }

        @Override
        public void succeed() {
            this.complete(null);
        }

        @Override
        public void fail(Throwable x) {
            this.completeExceptionally(x);
        }

        public Completable compose(Consumer<Completable> consumer) {
            Completable completable = new Completable();
            this.whenComplete((T r, U x) -> {
                if (x == null) {
                    consumer.accept(completable);
                } else {
                    completable.fail((Throwable)x);
                }
            });
            return completable;
        }
    }
}

