// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/maps/solar/v1/solar_service.proto

package solarpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	httpbody "google.golang.org/genproto/googleapis/api/httpbody"
	date "google.golang.org/genproto/googleapis/type/date"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	money "google.golang.org/genproto/googleapis/type/money"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// What subset of the solar information to return.
type DataLayerView int32

const (
	// Equivalent to FULL.
	DataLayerView_DATA_LAYER_VIEW_UNSPECIFIED DataLayerView = 0
	// Get the DSM only.
	DataLayerView_DSM_LAYER DataLayerView = 1
	// Get the DSM, RGB, and mask.
	DataLayerView_IMAGERY_LAYERS DataLayerView = 2
	// Get the DSM, RGB, mask, and annual flux.
	DataLayerView_IMAGERY_AND_ANNUAL_FLUX_LAYERS DataLayerView = 3
	// Get the DSM, RGB, mask, annual flux, and monthly flux.
	DataLayerView_IMAGERY_AND_ALL_FLUX_LAYERS DataLayerView = 4
	// Get all data.
	DataLayerView_FULL_LAYERS DataLayerView = 5
)

// Enum value maps for DataLayerView.
var (
	DataLayerView_name = map[int32]string{
		0: "DATA_LAYER_VIEW_UNSPECIFIED",
		1: "DSM_LAYER",
		2: "IMAGERY_LAYERS",
		3: "IMAGERY_AND_ANNUAL_FLUX_LAYERS",
		4: "IMAGERY_AND_ALL_FLUX_LAYERS",
		5: "FULL_LAYERS",
	}
	DataLayerView_value = map[string]int32{
		"DATA_LAYER_VIEW_UNSPECIFIED":    0,
		"DSM_LAYER":                      1,
		"IMAGERY_LAYERS":                 2,
		"IMAGERY_AND_ANNUAL_FLUX_LAYERS": 3,
		"IMAGERY_AND_ALL_FLUX_LAYERS":    4,
		"FULL_LAYERS":                    5,
	}
)

func (x DataLayerView) Enum() *DataLayerView {
	p := new(DataLayerView)
	*p = x
	return p
}

func (x DataLayerView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataLayerView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_solar_v1_solar_service_proto_enumTypes[0].Descriptor()
}

func (DataLayerView) Type() protoreflect.EnumType {
	return &file_google_maps_solar_v1_solar_service_proto_enumTypes[0]
}

func (x DataLayerView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataLayerView.Descriptor instead.
func (DataLayerView) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{0}
}

// The quality of the imagery used to compute some API result.
//
// Note: Regardless of imagery quality level, DSM outputs always have a
// resolution of 0.1 m/pixel, monthly flux outputs always have a resolution of
// 0.5 m/pixel, and hourly shade outputs always have a resolution of 1 m/pixel.
type ImageryQuality int32

const (
	// No quality is known.
	ImageryQuality_IMAGERY_QUALITY_UNSPECIFIED ImageryQuality = 0
	// Solar data is derived from aerial imagery captured at low-altitude and
	// processed at 0.1 m/pixel.
	ImageryQuality_HIGH ImageryQuality = 1
	// Solar data is derived from enhanced aerial imagery captured at
	// high-altitude and processed at 0.25 m/pixel.
	ImageryQuality_MEDIUM ImageryQuality = 2
	// Solar data is derived from enhanced satellite imagery processed at 0.25
	// m/pixel.
	ImageryQuality_LOW ImageryQuality = 3
	// Solar data is derived from enhanced satellite imagery processed at 0.25
	// m/pixel.
	ImageryQuality_BASE ImageryQuality = 4
)

// Enum value maps for ImageryQuality.
var (
	ImageryQuality_name = map[int32]string{
		0: "IMAGERY_QUALITY_UNSPECIFIED",
		1: "HIGH",
		2: "MEDIUM",
		3: "LOW",
		4: "BASE",
	}
	ImageryQuality_value = map[string]int32{
		"IMAGERY_QUALITY_UNSPECIFIED": 0,
		"HIGH":                        1,
		"MEDIUM":                      2,
		"LOW":                         3,
		"BASE":                        4,
	}
)

func (x ImageryQuality) Enum() *ImageryQuality {
	p := new(ImageryQuality)
	*p = x
	return p
}

func (x ImageryQuality) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImageryQuality) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_solar_v1_solar_service_proto_enumTypes[1].Descriptor()
}

func (ImageryQuality) Type() protoreflect.EnumType {
	return &file_google_maps_solar_v1_solar_service_proto_enumTypes[1]
}

func (x ImageryQuality) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImageryQuality.Descriptor instead.
func (ImageryQuality) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{1}
}

// The orientation of a solar panel. This must be interpreted relative to the
// azimuth of the roof segment that the panel is placed on.
type SolarPanelOrientation int32

const (
	// No panel orientation is known.
	SolarPanelOrientation_SOLAR_PANEL_ORIENTATION_UNSPECIFIED SolarPanelOrientation = 0
	// A `LANDSCAPE` panel has its long edge perpendicular to the
	// azimuth direction of the roof segment that it is placed on.
	SolarPanelOrientation_LANDSCAPE SolarPanelOrientation = 1
	// A `PORTRAIT` panel has its long edge parallel to the azimuth
	// direction of the roof segment that it is placed on.
	SolarPanelOrientation_PORTRAIT SolarPanelOrientation = 2
)

// Enum value maps for SolarPanelOrientation.
var (
	SolarPanelOrientation_name = map[int32]string{
		0: "SOLAR_PANEL_ORIENTATION_UNSPECIFIED",
		1: "LANDSCAPE",
		2: "PORTRAIT",
	}
	SolarPanelOrientation_value = map[string]int32{
		"SOLAR_PANEL_ORIENTATION_UNSPECIFIED": 0,
		"LANDSCAPE":                           1,
		"PORTRAIT":                            2,
	}
)

func (x SolarPanelOrientation) Enum() *SolarPanelOrientation {
	p := new(SolarPanelOrientation)
	*p = x
	return p
}

func (x SolarPanelOrientation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SolarPanelOrientation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_solar_v1_solar_service_proto_enumTypes[2].Descriptor()
}

func (SolarPanelOrientation) Type() protoreflect.EnumType {
	return &file_google_maps_solar_v1_solar_service_proto_enumTypes[2]
}

func (x SolarPanelOrientation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SolarPanelOrientation.Descriptor instead.
func (SolarPanelOrientation) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{2}
}

// Specifies pre-GA experiments that can be enabled in the API.
type Experiment int32

const (
	// No experiments are specified.
	Experiment_EXPERIMENT_UNSPECIFIED Experiment = 0
	// Expands the geographic region available for querying solar data. For more
	// information, see [Expanded
	// Coverage](https://developers.google.com/maps/documentation/solar/expanded-coverage).
	Experiment_EXPANDED_COVERAGE Experiment = 1
)

// Enum value maps for Experiment.
var (
	Experiment_name = map[int32]string{
		0: "EXPERIMENT_UNSPECIFIED",
		1: "EXPANDED_COVERAGE",
	}
	Experiment_value = map[string]int32{
		"EXPERIMENT_UNSPECIFIED": 0,
		"EXPANDED_COVERAGE":      1,
	}
)

func (x Experiment) Enum() *Experiment {
	p := new(Experiment)
	*p = x
	return p
}

func (x Experiment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Experiment) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_solar_v1_solar_service_proto_enumTypes[3].Descriptor()
}

func (Experiment) Type() protoreflect.EnumType {
	return &file_google_maps_solar_v1_solar_service_proto_enumTypes[3]
}

func (x Experiment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Experiment.Descriptor instead.
func (Experiment) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{3}
}

// Request message for `Solar.FindClosestBuildingInsights`.
type FindClosestBuildingInsightsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The longitude and latitude from which the API looks for the
	// nearest known building.
	Location *latlng.LatLng `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Optional. The minimum quality level allowed in the results. No result with
	// lower quality than this will be returned. Not specifying this is
	// equivalent to restricting to HIGH quality only.
	RequiredQuality ImageryQuality `protobuf:"varint,3,opt,name=required_quality,json=requiredQuality,proto3,enum=google.maps.solar.v1.ImageryQuality" json:"required_quality,omitempty"`
	// Optional. Whether to require exact quality of the imagery.
	// If set to false, the `required_quality` field is interpreted as the minimum
	// required quality, such that HIGH quality imagery may be returned when
	// `required_quality` is set to MEDIUM.  If set to true, `required_quality`
	// is interpreted as the exact required quality and only `MEDIUM` quality
	// imagery is returned if `required_quality` is set to `MEDIUM`.
	ExactQualityRequired bool `protobuf:"varint,4,opt,name=exact_quality_required,json=exactQualityRequired,proto3" json:"exact_quality_required,omitempty"`
	// Optional. Specifies the pre-GA features to enable.
	Experiments []Experiment `protobuf:"varint,5,rep,packed,name=experiments,proto3,enum=google.maps.solar.v1.Experiment" json:"experiments,omitempty"`
}

func (x *FindClosestBuildingInsightsRequest) Reset() {
	*x = FindClosestBuildingInsightsRequest{}
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FindClosestBuildingInsightsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindClosestBuildingInsightsRequest) ProtoMessage() {}

func (x *FindClosestBuildingInsightsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindClosestBuildingInsightsRequest.ProtoReflect.Descriptor instead.
func (*FindClosestBuildingInsightsRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{0}
}

func (x *FindClosestBuildingInsightsRequest) GetLocation() *latlng.LatLng {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *FindClosestBuildingInsightsRequest) GetRequiredQuality() ImageryQuality {
	if x != nil {
		return x.RequiredQuality
	}
	return ImageryQuality_IMAGERY_QUALITY_UNSPECIFIED
}

func (x *FindClosestBuildingInsightsRequest) GetExactQualityRequired() bool {
	if x != nil {
		return x.ExactQualityRequired
	}
	return false
}

func (x *FindClosestBuildingInsightsRequest) GetExperiments() []Experiment {
	if x != nil {
		return x.Experiments
	}
	return nil
}

// A bounding box in lat/lng coordinates.
type LatLngBox struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The southwest corner of the box.
	Sw *latlng.LatLng `protobuf:"bytes,1,opt,name=sw,proto3" json:"sw,omitempty"`
	// The northeast corner of the box.
	Ne *latlng.LatLng `protobuf:"bytes,2,opt,name=ne,proto3" json:"ne,omitempty"`
}

func (x *LatLngBox) Reset() {
	*x = LatLngBox{}
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LatLngBox) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LatLngBox) ProtoMessage() {}

func (x *LatLngBox) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LatLngBox.ProtoReflect.Descriptor instead.
func (*LatLngBox) Descriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{1}
}

func (x *LatLngBox) GetSw() *latlng.LatLng {
	if x != nil {
		return x.Sw
	}
	return nil
}

func (x *LatLngBox) GetNe() *latlng.LatLng {
	if x != nil {
		return x.Ne
	}
	return nil
}

// Response message for `Solar.FindClosestBuildingInsights`.
// Information about the location, dimensions, and solar potential of a
// building.
type BuildingInsights struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name for the building, of the format `buildings/{place_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A point near the center of the building.
	Center *latlng.LatLng `protobuf:"bytes,2,opt,name=center,proto3" json:"center,omitempty"`
	// The bounding box of the building.
	BoundingBox *LatLngBox `protobuf:"bytes,9,opt,name=bounding_box,json=boundingBox,proto3" json:"bounding_box,omitempty"`
	// Date that the underlying imagery was acquired. This is approximate.
	ImageryDate *date.Date `protobuf:"bytes,3,opt,name=imagery_date,json=imageryDate,proto3" json:"imagery_date,omitempty"`
	// When processing was completed on this imagery.
	ImageryProcessedDate *date.Date `protobuf:"bytes,11,opt,name=imagery_processed_date,json=imageryProcessedDate,proto3" json:"imagery_processed_date,omitempty"`
	// Postal code (e.g., US zip code) this building is contained by.
	PostalCode string `protobuf:"bytes,4,opt,name=postal_code,json=postalCode,proto3" json:"postal_code,omitempty"`
	// Administrative area 1 (e.g., in the US, the state) that contains this
	// building. For example, in the US, the abbreviation might be "MA" or "CA."
	AdministrativeArea string `protobuf:"bytes,5,opt,name=administrative_area,json=administrativeArea,proto3" json:"administrative_area,omitempty"`
	// Statistical area (e.g., US census tract) this building is in.
	StatisticalArea string `protobuf:"bytes,6,opt,name=statistical_area,json=statisticalArea,proto3" json:"statistical_area,omitempty"`
	// Region code for the country (or region) this building is in.
	RegionCode string `protobuf:"bytes,7,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// Solar potential of the building.
	SolarPotential *SolarPotential `protobuf:"bytes,8,opt,name=solar_potential,json=solarPotential,proto3" json:"solar_potential,omitempty"`
	// The quality of the imagery used to compute the data for this building.
	ImageryQuality ImageryQuality `protobuf:"varint,10,opt,name=imagery_quality,json=imageryQuality,proto3,enum=google.maps.solar.v1.ImageryQuality" json:"imagery_quality,omitempty"`
}

func (x *BuildingInsights) Reset() {
	*x = BuildingInsights{}
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BuildingInsights) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildingInsights) ProtoMessage() {}

func (x *BuildingInsights) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildingInsights.ProtoReflect.Descriptor instead.
func (*BuildingInsights) Descriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{2}
}

func (x *BuildingInsights) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BuildingInsights) GetCenter() *latlng.LatLng {
	if x != nil {
		return x.Center
	}
	return nil
}

func (x *BuildingInsights) GetBoundingBox() *LatLngBox {
	if x != nil {
		return x.BoundingBox
	}
	return nil
}

func (x *BuildingInsights) GetImageryDate() *date.Date {
	if x != nil {
		return x.ImageryDate
	}
	return nil
}

func (x *BuildingInsights) GetImageryProcessedDate() *date.Date {
	if x != nil {
		return x.ImageryProcessedDate
	}
	return nil
}

func (x *BuildingInsights) GetPostalCode() string {
	if x != nil {
		return x.PostalCode
	}
	return ""
}

func (x *BuildingInsights) GetAdministrativeArea() string {
	if x != nil {
		return x.AdministrativeArea
	}
	return ""
}

func (x *BuildingInsights) GetStatisticalArea() string {
	if x != nil {
		return x.StatisticalArea
	}
	return ""
}

func (x *BuildingInsights) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *BuildingInsights) GetSolarPotential() *SolarPotential {
	if x != nil {
		return x.SolarPotential
	}
	return nil
}

func (x *BuildingInsights) GetImageryQuality() ImageryQuality {
	if x != nil {
		return x.ImageryQuality
	}
	return ImageryQuality_IMAGERY_QUALITY_UNSPECIFIED
}

// Information about the solar potential of a building. A number of
// fields in this are defined in terms of "panels". The fields
// [panel_capacity_watts]
// [google.maps.solar.v1.SolarPotential.panel_capacity_watts],
// [panel_height_meters]
// [google.maps.solar.v1.SolarPotential.panel_height_meters],
// and [panel_width_meters]
// [google.maps.solar.v1.SolarPotential.panel_width_meters]
// describe the parameters of the model of panel used in these
// calculations.
type SolarPotential struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Size of the maximum array - that is, the maximum number of panels that
	// can fit on the roof.
	MaxArrayPanelsCount int32 `protobuf:"varint,1,opt,name=max_array_panels_count,json=maxArrayPanelsCount,proto3" json:"max_array_panels_count,omitempty"`
	// Capacity, in watts, of the panel used in the calculations.
	PanelCapacityWatts float32 `protobuf:"fixed32,9,opt,name=panel_capacity_watts,json=panelCapacityWatts,proto3" json:"panel_capacity_watts,omitempty"`
	// Height, in meters in portrait orientation, of the panel used in
	// the calculations.
	PanelHeightMeters float32 `protobuf:"fixed32,10,opt,name=panel_height_meters,json=panelHeightMeters,proto3" json:"panel_height_meters,omitempty"`
	// Width, in meters in portrait orientation, of the panel used in
	// the calculations.
	PanelWidthMeters float32 `protobuf:"fixed32,11,opt,name=panel_width_meters,json=panelWidthMeters,proto3" json:"panel_width_meters,omitempty"`
	// The expected lifetime, in years, of the solar panels. This is
	// used in the financial calculations.
	PanelLifetimeYears int32 `protobuf:"varint,12,opt,name=panel_lifetime_years,json=panelLifetimeYears,proto3" json:"panel_lifetime_years,omitempty"`
	// Size, in square meters, of the maximum array.
	MaxArrayAreaMeters2 float32 `protobuf:"fixed32,2,opt,name=max_array_area_meters2,json=maxArrayAreaMeters2,proto3" json:"max_array_area_meters2,omitempty"`
	// Maximum number of sunshine hours received per year, by any point
	// on the roof. Sunshine hours are a measure of the total amount of
	// insolation (energy) received per year. 1 sunshine hour = 1 kWh per kW
	// (where kW refers to kW of capacity under Standard Testing Conditions).
	MaxSunshineHoursPerYear float32 `protobuf:"fixed32,3,opt,name=max_sunshine_hours_per_year,json=maxSunshineHoursPerYear,proto3" json:"max_sunshine_hours_per_year,omitempty"`
	// Equivalent amount of CO2 produced per MWh of grid electricity. This
	// is a measure of the carbon intensity of grid electricity displaced
	// by solar electricity.
	CarbonOffsetFactorKgPerMwh float32 `protobuf:"fixed32,4,opt,name=carbon_offset_factor_kg_per_mwh,json=carbonOffsetFactorKgPerMwh,proto3" json:"carbon_offset_factor_kg_per_mwh,omitempty"`
	// Total size and sunlight quantiles for the part of the roof that
	// was assigned to some roof segment. Despite the name, this may not
	// include the entire building. See [building_stats]
	// [google.maps.solar.v1.SolarPotential.building_stats].
	WholeRoofStats *SizeAndSunshineStats `protobuf:"bytes,5,opt,name=whole_roof_stats,json=wholeRoofStats,proto3" json:"whole_roof_stats,omitempty"`
	// Size and sunlight quantiles for the entire building, including
	// parts of the roof that were not assigned to some roof segment.
	// Because the orientations of these parts are not well
	// characterised, the roof area estimate is unreliable, but the
	// ground area estimate is reliable. It may be that a more reliable
	// whole building roof area can be obtained by scaling the roof area
	// from [whole_roof_stats]
	// [google.maps.solar.v1.SolarPotential.whole_roof_stats] by
	// the ratio of the ground areas of `building_stats` and
	// `whole_roof_stats`.
	BuildingStats *SizeAndSunshineStats `protobuf:"bytes,13,opt,name=building_stats,json=buildingStats,proto3" json:"building_stats,omitempty"`
	// Size and sunlight quantiles for each roof segment.
	RoofSegmentStats []*RoofSegmentSizeAndSunshineStats `protobuf:"bytes,6,rep,name=roof_segment_stats,json=roofSegmentStats,proto3" json:"roof_segment_stats,omitempty"`
	// Each [SolarPanel] [google.maps.solar.v1.SolarPanel]
	// describes a single solar panel. They are listed in the order that
	// the panel layout algorithm placed this. This is usually, though
	// not always, in decreasing order of annual energy production.
	SolarPanels []*SolarPanel `protobuf:"bytes,14,rep,name=solar_panels,json=solarPanels,proto3" json:"solar_panels,omitempty"`
	// Each [SolarPanelConfig]
	// [google.maps.solar.v1.SolarPanelConfig] describes a
	// different arrangement of solar panels on the roof. They are in
	// order of increasing number of panels. The `SolarPanelConfig` with
	// [panels_count]
	// [google.maps.solar.v1.SolarPanelConfig.panels_count]=N is
	// based on the first N panels in the `solar_panels` list. This field is only
	// populated if at least 4 panels can fit on a roof.
	SolarPanelConfigs []*SolarPanelConfig `protobuf:"bytes,7,rep,name=solar_panel_configs,json=solarPanelConfigs,proto3" json:"solar_panel_configs,omitempty"`
	// A [FinancialAnalysis]
	// [google.maps.solar.v1.FinancialAnalysis] gives the savings
	// from going solar assuming a given monthly bill and a given
	// electricity provider. They are in order of increasing order of
	// monthly bill amount. This field will be empty for buildings in
	// areas for which the Solar API does not have enough information to
	// perform financial computations.
	FinancialAnalyses []*FinancialAnalysis `protobuf:"bytes,8,rep,name=financial_analyses,json=financialAnalyses,proto3" json:"financial_analyses,omitempty"`
}

func (x *SolarPotential) Reset() {
	*x = SolarPotential{}
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SolarPotential) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SolarPotential) ProtoMessage() {}

func (x *SolarPotential) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SolarPotential.ProtoReflect.Descriptor instead.
func (*SolarPotential) Descriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{3}
}

func (x *SolarPotential) GetMaxArrayPanelsCount() int32 {
	if x != nil {
		return x.MaxArrayPanelsCount
	}
	return 0
}

func (x *SolarPotential) GetPanelCapacityWatts() float32 {
	if x != nil {
		return x.PanelCapacityWatts
	}
	return 0
}

func (x *SolarPotential) GetPanelHeightMeters() float32 {
	if x != nil {
		return x.PanelHeightMeters
	}
	return 0
}

func (x *SolarPotential) GetPanelWidthMeters() float32 {
	if x != nil {
		return x.PanelWidthMeters
	}
	return 0
}

func (x *SolarPotential) GetPanelLifetimeYears() int32 {
	if x != nil {
		return x.PanelLifetimeYears
	}
	return 0
}

func (x *SolarPotential) GetMaxArrayAreaMeters2() float32 {
	if x != nil {
		return x.MaxArrayAreaMeters2
	}
	return 0
}

func (x *SolarPotential) GetMaxSunshineHoursPerYear() float32 {
	if x != nil {
		return x.MaxSunshineHoursPerYear
	}
	return 0
}

func (x *SolarPotential) GetCarbonOffsetFactorKgPerMwh() float32 {
	if x != nil {
		return x.CarbonOffsetFactorKgPerMwh
	}
	return 0
}

func (x *SolarPotential) GetWholeRoofStats() *SizeAndSunshineStats {
	if x != nil {
		return x.WholeRoofStats
	}
	return nil
}

func (x *SolarPotential) GetBuildingStats() *SizeAndSunshineStats {
	if x != nil {
		return x.BuildingStats
	}
	return nil
}

func (x *SolarPotential) GetRoofSegmentStats() []*RoofSegmentSizeAndSunshineStats {
	if x != nil {
		return x.RoofSegmentStats
	}
	return nil
}

func (x *SolarPotential) GetSolarPanels() []*SolarPanel {
	if x != nil {
		return x.SolarPanels
	}
	return nil
}

func (x *SolarPotential) GetSolarPanelConfigs() []*SolarPanelConfig {
	if x != nil {
		return x.SolarPanelConfigs
	}
	return nil
}

func (x *SolarPotential) GetFinancialAnalyses() []*FinancialAnalysis {
	if x != nil {
		return x.FinancialAnalyses
	}
	return nil
}

// Information about the size and sunniness quantiles of a roof segment.
type RoofSegmentSizeAndSunshineStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Angle of the roof segment relative to the theoretical ground plane.
	// 0 = parallel to the ground, 90 = perpendicular to the ground.
	PitchDegrees *float32 `protobuf:"fixed32,1,opt,name=pitch_degrees,json=pitchDegrees,proto3,oneof" json:"pitch_degrees,omitempty"`
	// Compass direction the roof segment is pointing in. 0 = North, 90 =
	// East, 180 = South. For a "flat" roof segment (`pitch_degrees` very
	// near 0), azimuth is not well defined, so for consistency, we define it
	// arbitrarily to be 0 (North).
	AzimuthDegrees *float32 `protobuf:"fixed32,2,opt,name=azimuth_degrees,json=azimuthDegrees,proto3,oneof" json:"azimuth_degrees,omitempty"`
	// Total size and sunlight quantiles for the roof segment.
	Stats *SizeAndSunshineStats `protobuf:"bytes,3,opt,name=stats,proto3" json:"stats,omitempty"`
	// A point near the center of the roof segment.
	Center *latlng.LatLng `protobuf:"bytes,4,opt,name=center,proto3" json:"center,omitempty"`
	// The bounding box of the roof segment.
	BoundingBox *LatLngBox `protobuf:"bytes,5,opt,name=bounding_box,json=boundingBox,proto3" json:"bounding_box,omitempty"`
	// The height of the roof segment plane, in meters above sea level,
	// at the point designated by `center`. Together with the pitch,
	// azimuth, and center location, this fully defines the roof segment
	// plane.
	PlaneHeightAtCenterMeters *float32 `protobuf:"fixed32,6,opt,name=plane_height_at_center_meters,json=planeHeightAtCenterMeters,proto3,oneof" json:"plane_height_at_center_meters,omitempty"`
}

func (x *RoofSegmentSizeAndSunshineStats) Reset() {
	*x = RoofSegmentSizeAndSunshineStats{}
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RoofSegmentSizeAndSunshineStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoofSegmentSizeAndSunshineStats) ProtoMessage() {}

func (x *RoofSegmentSizeAndSunshineStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoofSegmentSizeAndSunshineStats.ProtoReflect.Descriptor instead.
func (*RoofSegmentSizeAndSunshineStats) Descriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{4}
}

func (x *RoofSegmentSizeAndSunshineStats) GetPitchDegrees() float32 {
	if x != nil && x.PitchDegrees != nil {
		return *x.PitchDegrees
	}
	return 0
}

func (x *RoofSegmentSizeAndSunshineStats) GetAzimuthDegrees() float32 {
	if x != nil && x.AzimuthDegrees != nil {
		return *x.AzimuthDegrees
	}
	return 0
}

func (x *RoofSegmentSizeAndSunshineStats) GetStats() *SizeAndSunshineStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

func (x *RoofSegmentSizeAndSunshineStats) GetCenter() *latlng.LatLng {
	if x != nil {
		return x.Center
	}
	return nil
}

func (x *RoofSegmentSizeAndSunshineStats) GetBoundingBox() *LatLngBox {
	if x != nil {
		return x.BoundingBox
	}
	return nil
}

func (x *RoofSegmentSizeAndSunshineStats) GetPlaneHeightAtCenterMeters() float32 {
	if x != nil && x.PlaneHeightAtCenterMeters != nil {
		return *x.PlaneHeightAtCenterMeters
	}
	return 0
}

// Size and sunniness quantiles of a roof, or part of a roof.
type SizeAndSunshineStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The area of the roof or roof segment, in m^2. This is the roof area
	// (accounting for tilt), not the ground footprint area.
	AreaMeters2 float32 `protobuf:"fixed32,1,opt,name=area_meters2,json=areaMeters2,proto3" json:"area_meters2,omitempty"`
	// Quantiles of the pointwise sunniness across the area. If there
	// are N values here, this represents the (N-1)-iles. For example,
	// if there are 5 values, then they would be the quartiles (min,
	// 25%, 50%, 75%, max). Values are in annual kWh/kW like
	// [max_sunshine_hours_per_year]
	// [google.maps.solar.v1.SolarPotential.max_sunshine_hours_per_year].
	SunshineQuantiles []float32 `protobuf:"fixed32,2,rep,packed,name=sunshine_quantiles,json=sunshineQuantiles,proto3" json:"sunshine_quantiles,omitempty"`
	// The ground footprint area covered by the roof or roof segment, in m^2.
	GroundAreaMeters2 float32 `protobuf:"fixed32,3,opt,name=ground_area_meters2,json=groundAreaMeters2,proto3" json:"ground_area_meters2,omitempty"`
}

func (x *SizeAndSunshineStats) Reset() {
	*x = SizeAndSunshineStats{}
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SizeAndSunshineStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SizeAndSunshineStats) ProtoMessage() {}

func (x *SizeAndSunshineStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SizeAndSunshineStats.ProtoReflect.Descriptor instead.
func (*SizeAndSunshineStats) Descriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{5}
}

func (x *SizeAndSunshineStats) GetAreaMeters2() float32 {
	if x != nil {
		return x.AreaMeters2
	}
	return 0
}

func (x *SizeAndSunshineStats) GetSunshineQuantiles() []float32 {
	if x != nil {
		return x.SunshineQuantiles
	}
	return nil
}

func (x *SizeAndSunshineStats) GetGroundAreaMeters2() float32 {
	if x != nil {
		return x.GroundAreaMeters2
	}
	return 0
}

// SolarPanel describes the position, orientation, and production of a
// single solar panel. See the [panel_height_meters]
// [google.maps.solar.v1.SolarPotential.panel_height_meters],
// [panel_width_meters]
// [google.maps.solar.v1.SolarPotential.panel_width_meters],
// and [panel_capacity_watts]
// [google.maps.solar.v1.SolarPotential.panel_capacity_watts]
// fields in [SolarPotential]
// [google.maps.solar.v1.SolarPotential] for information on the
// parameters of the panel.
type SolarPanel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The centre of the panel.
	Center *latlng.LatLng `protobuf:"bytes,1,opt,name=center,proto3" json:"center,omitempty"`
	// The orientation of the panel.
	Orientation SolarPanelOrientation `protobuf:"varint,2,opt,name=orientation,proto3,enum=google.maps.solar.v1.SolarPanelOrientation" json:"orientation,omitempty"`
	// How much sunlight energy this layout captures over the course of a
	// year, in DC kWh.
	YearlyEnergyDcKwh float32 `protobuf:"fixed32,3,opt,name=yearly_energy_dc_kwh,json=yearlyEnergyDcKwh,proto3" json:"yearly_energy_dc_kwh,omitempty"`
	// Index in [roof_segment_stats]
	// [google.maps.solar.v1.SolarPotential.roof_segment_stats]
	// of the `RoofSegmentSizeAndSunshineStats` which corresponds to the
	// roof segment that this panel is placed on.
	SegmentIndex *int32 `protobuf:"varint,4,opt,name=segment_index,json=segmentIndex,proto3,oneof" json:"segment_index,omitempty"`
}

func (x *SolarPanel) Reset() {
	*x = SolarPanel{}
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SolarPanel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SolarPanel) ProtoMessage() {}

func (x *SolarPanel) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SolarPanel.ProtoReflect.Descriptor instead.
func (*SolarPanel) Descriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{6}
}

func (x *SolarPanel) GetCenter() *latlng.LatLng {
	if x != nil {
		return x.Center
	}
	return nil
}

func (x *SolarPanel) GetOrientation() SolarPanelOrientation {
	if x != nil {
		return x.Orientation
	}
	return SolarPanelOrientation_SOLAR_PANEL_ORIENTATION_UNSPECIFIED
}

func (x *SolarPanel) GetYearlyEnergyDcKwh() float32 {
	if x != nil {
		return x.YearlyEnergyDcKwh
	}
	return 0
}

func (x *SolarPanel) GetSegmentIndex() int32 {
	if x != nil && x.SegmentIndex != nil {
		return *x.SegmentIndex
	}
	return 0
}

// SolarPanelConfig describes a particular placement of solar panels
// on the roof.
type SolarPanelConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total number of panels. Note that this is redundant to (the sum
	// of) the corresponding fields in [roof_segment_summaries]
	// [google.maps.solar.v1.SolarPanelConfig.roof_segment_summaries].
	PanelsCount int32 `protobuf:"varint,1,opt,name=panels_count,json=panelsCount,proto3" json:"panels_count,omitempty"`
	// How much sunlight energy this layout captures over the course of a
	// year, in DC kWh, assuming the panels described above.
	YearlyEnergyDcKwh float32 `protobuf:"fixed32,2,opt,name=yearly_energy_dc_kwh,json=yearlyEnergyDcKwh,proto3" json:"yearly_energy_dc_kwh,omitempty"`
	// Information about the production of each roof segment that is carrying
	// at least one panel in this layout. `roof_segment_summaries[i]` describes
	// the i-th roof segment, including its size, expected production and
	// orientation.
	RoofSegmentSummaries []*RoofSegmentSummary `protobuf:"bytes,4,rep,name=roof_segment_summaries,json=roofSegmentSummaries,proto3" json:"roof_segment_summaries,omitempty"`
}

func (x *SolarPanelConfig) Reset() {
	*x = SolarPanelConfig{}
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SolarPanelConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SolarPanelConfig) ProtoMessage() {}

func (x *SolarPanelConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SolarPanelConfig.ProtoReflect.Descriptor instead.
func (*SolarPanelConfig) Descriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{7}
}

func (x *SolarPanelConfig) GetPanelsCount() int32 {
	if x != nil {
		return x.PanelsCount
	}
	return 0
}

func (x *SolarPanelConfig) GetYearlyEnergyDcKwh() float32 {
	if x != nil {
		return x.YearlyEnergyDcKwh
	}
	return 0
}

func (x *SolarPanelConfig) GetRoofSegmentSummaries() []*RoofSegmentSummary {
	if x != nil {
		return x.RoofSegmentSummaries
	}
	return nil
}

// Information about a roof segment on the building, with some number of
// panels placed on it.
type RoofSegmentSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Angle of the roof segment relative to the theoretical ground plane.
	// 0 = parallel to the ground, 90 = perpendicular to the ground.
	PitchDegrees *float32 `protobuf:"fixed32,2,opt,name=pitch_degrees,json=pitchDegrees,proto3,oneof" json:"pitch_degrees,omitempty"`
	// Compass direction the roof segment is pointing in. 0 = North, 90 =
	// East, 180 = South. For a "flat" roof segment (`pitch_degrees` very
	// near 0), azimuth is not well defined, so for consistency, we define it
	// arbitrarily to be 0 (North).
	AzimuthDegrees *float32 `protobuf:"fixed32,3,opt,name=azimuth_degrees,json=azimuthDegrees,proto3,oneof" json:"azimuth_degrees,omitempty"`
	// The total number of panels on this segment.
	PanelsCount int32 `protobuf:"varint,7,opt,name=panels_count,json=panelsCount,proto3" json:"panels_count,omitempty"`
	// How much sunlight energy this part of the layout captures over the
	// course of a year, in DC kWh, assuming the panels described above.
	YearlyEnergyDcKwh float32 `protobuf:"fixed32,8,opt,name=yearly_energy_dc_kwh,json=yearlyEnergyDcKwh,proto3" json:"yearly_energy_dc_kwh,omitempty"`
	// Index in [roof_segment_stats]
	// [google.maps.solar.v1.SolarPotential.roof_segment_stats]
	// of the corresponding `RoofSegmentSizeAndSunshineStats`.
	SegmentIndex *int32 `protobuf:"varint,9,opt,name=segment_index,json=segmentIndex,proto3,oneof" json:"segment_index,omitempty"`
}

func (x *RoofSegmentSummary) Reset() {
	*x = RoofSegmentSummary{}
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RoofSegmentSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoofSegmentSummary) ProtoMessage() {}

func (x *RoofSegmentSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoofSegmentSummary.ProtoReflect.Descriptor instead.
func (*RoofSegmentSummary) Descriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{8}
}

func (x *RoofSegmentSummary) GetPitchDegrees() float32 {
	if x != nil && x.PitchDegrees != nil {
		return *x.PitchDegrees
	}
	return 0
}

func (x *RoofSegmentSummary) GetAzimuthDegrees() float32 {
	if x != nil && x.AzimuthDegrees != nil {
		return *x.AzimuthDegrees
	}
	return 0
}

func (x *RoofSegmentSummary) GetPanelsCount() int32 {
	if x != nil {
		return x.PanelsCount
	}
	return 0
}

func (x *RoofSegmentSummary) GetYearlyEnergyDcKwh() float32 {
	if x != nil {
		return x.YearlyEnergyDcKwh
	}
	return 0
}

func (x *RoofSegmentSummary) GetSegmentIndex() int32 {
	if x != nil && x.SegmentIndex != nil {
		return *x.SegmentIndex
	}
	return 0
}

// Analysis of the cost and benefits of the optimum solar layout for a
// particular electric bill size.
type FinancialAnalysis struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The monthly electric bill this analysis assumes.
	MonthlyBill *money.Money `protobuf:"bytes,3,opt,name=monthly_bill,json=monthlyBill,proto3" json:"monthly_bill,omitempty"`
	// Whether this is the bill size selected to be the default bill for the
	// area this building is in. Exactly one `FinancialAnalysis` in
	// `BuildingSolarPotential` should have `default_bill` set.
	DefaultBill bool `protobuf:"varint,4,opt,name=default_bill,json=defaultBill,proto3" json:"default_bill,omitempty"`
	// How much electricity the house uses in an average month, based on the
	// bill size and the local electricity rates.
	AverageKwhPerMonth float32 `protobuf:"fixed32,5,opt,name=average_kwh_per_month,json=averageKwhPerMonth,proto3" json:"average_kwh_per_month,omitempty"`
	// Index in [solar_panel_configs]
	// [google.maps.solar.v1.SolarPotential.solar_panel_configs]
	// of the optimum solar layout for this bill size. This can be -1
	// indicating that there is no layout. In this case, the remaining
	// submessages will be omitted.
	PanelConfigIndex *int32 `protobuf:"varint,6,opt,name=panel_config_index,json=panelConfigIndex,proto3,oneof" json:"panel_config_index,omitempty"`
	// Financial information that applies regardless of the financing method
	// used.
	FinancialDetails *FinancialDetails `protobuf:"bytes,7,opt,name=financial_details,json=financialDetails,proto3" json:"financial_details,omitempty"`
	// Cost and benefit of leasing the solar panels.
	LeasingSavings *LeasingSavings `protobuf:"bytes,8,opt,name=leasing_savings,json=leasingSavings,proto3" json:"leasing_savings,omitempty"`
	// Cost and benefit of buying the solar panels with cash.
	CashPurchaseSavings *CashPurchaseSavings `protobuf:"bytes,9,opt,name=cash_purchase_savings,json=cashPurchaseSavings,proto3" json:"cash_purchase_savings,omitempty"`
	// Cost and benefit of buying the solar panels by financing the purchase.
	FinancedPurchaseSavings *FinancedPurchaseSavings `protobuf:"bytes,10,opt,name=financed_purchase_savings,json=financedPurchaseSavings,proto3" json:"financed_purchase_savings,omitempty"`
}

func (x *FinancialAnalysis) Reset() {
	*x = FinancialAnalysis{}
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FinancialAnalysis) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinancialAnalysis) ProtoMessage() {}

func (x *FinancialAnalysis) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinancialAnalysis.ProtoReflect.Descriptor instead.
func (*FinancialAnalysis) Descriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{9}
}

func (x *FinancialAnalysis) GetMonthlyBill() *money.Money {
	if x != nil {
		return x.MonthlyBill
	}
	return nil
}

func (x *FinancialAnalysis) GetDefaultBill() bool {
	if x != nil {
		return x.DefaultBill
	}
	return false
}

func (x *FinancialAnalysis) GetAverageKwhPerMonth() float32 {
	if x != nil {
		return x.AverageKwhPerMonth
	}
	return 0
}

func (x *FinancialAnalysis) GetPanelConfigIndex() int32 {
	if x != nil && x.PanelConfigIndex != nil {
		return *x.PanelConfigIndex
	}
	return 0
}

func (x *FinancialAnalysis) GetFinancialDetails() *FinancialDetails {
	if x != nil {
		return x.FinancialDetails
	}
	return nil
}

func (x *FinancialAnalysis) GetLeasingSavings() *LeasingSavings {
	if x != nil {
		return x.LeasingSavings
	}
	return nil
}

func (x *FinancialAnalysis) GetCashPurchaseSavings() *CashPurchaseSavings {
	if x != nil {
		return x.CashPurchaseSavings
	}
	return nil
}

func (x *FinancialAnalysis) GetFinancedPurchaseSavings() *FinancedPurchaseSavings {
	if x != nil {
		return x.FinancedPurchaseSavings
	}
	return nil
}

// Details of a financial analysis. Some of these details are already
// stored at higher levels (e.g., out of pocket cost). Total money
// amounts are over a lifetime period defined by the
// [panel_lifetime_years]
// [google.maps.solar.v1.SolarPotential.panel_lifetime_years]
// field in [SolarPotential]
// [google.maps.solar.v1.SolarPotential]. Note: The out of
// pocket cost of purchasing the panels is given in the
// [out_of_pocket_cost]
// [google.maps.solar.v1.CashPurchaseSavings.out_of_pocket_cost]
// field in [CashPurchaseSavings]
// [google.maps.solar.v1.CashPurchaseSavings].
type FinancialDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// How many AC kWh we think the solar panels will generate in their first
	// year.
	InitialAcKwhPerYear float32 `protobuf:"fixed32,1,opt,name=initial_ac_kwh_per_year,json=initialAcKwhPerYear,proto3" json:"initial_ac_kwh_per_year,omitempty"`
	// Utility bill for electricity not produced by solar, for the
	// lifetime of the panels.
	RemainingLifetimeUtilityBill *money.Money `protobuf:"bytes,2,opt,name=remaining_lifetime_utility_bill,json=remainingLifetimeUtilityBill,proto3" json:"remaining_lifetime_utility_bill,omitempty"`
	// Amount of money available from federal incentives; this applies if the
	// user buys (with or without a loan) the panels.
	FederalIncentive *money.Money `protobuf:"bytes,3,opt,name=federal_incentive,json=federalIncentive,proto3" json:"federal_incentive,omitempty"`
	// Amount of money available from state incentives; this applies if the
	// user buys (with or without a loan) the panels.
	StateIncentive *money.Money `protobuf:"bytes,4,opt,name=state_incentive,json=stateIncentive,proto3" json:"state_incentive,omitempty"`
	// Amount of money available from utility incentives; this applies if the
	// user buys (with or without a loan) the panels.
	UtilityIncentive *money.Money `protobuf:"bytes,5,opt,name=utility_incentive,json=utilityIncentive,proto3" json:"utility_incentive,omitempty"`
	// Amount of money the user will receive from Solar Renewable Energy
	// Credits over the panel lifetime; this applies if the user buys
	// (with or without a loan) the panels.
	LifetimeSrecTotal *money.Money `protobuf:"bytes,6,opt,name=lifetime_srec_total,json=lifetimeSrecTotal,proto3" json:"lifetime_srec_total,omitempty"`
	// Total cost of electricity the user would have paid over the
	// lifetime period if they didn't install solar.
	CostOfElectricityWithoutSolar *money.Money `protobuf:"bytes,7,opt,name=cost_of_electricity_without_solar,json=costOfElectricityWithoutSolar,proto3" json:"cost_of_electricity_without_solar,omitempty"`
	// Whether net metering is allowed.
	NetMeteringAllowed bool `protobuf:"varint,8,opt,name=net_metering_allowed,json=netMeteringAllowed,proto3" json:"net_metering_allowed,omitempty"`
	// Percentage (0-100) of the user's power supplied by solar.
	// Valid for the first year but approximately correct for future years.
	SolarPercentage *float32 `protobuf:"fixed32,9,opt,name=solar_percentage,json=solarPercentage,proto3,oneof" json:"solar_percentage,omitempty"`
	// The percentage (0-100) of solar electricity production we assumed was
	// exported to the grid, based on the first quarter of production. This
	// affects the calculations if net metering is not allowed.
	PercentageExportedToGrid *float32 `protobuf:"fixed32,10,opt,name=percentage_exported_to_grid,json=percentageExportedToGrid,proto3,oneof" json:"percentage_exported_to_grid,omitempty"`
}

func (x *FinancialDetails) Reset() {
	*x = FinancialDetails{}
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FinancialDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinancialDetails) ProtoMessage() {}

func (x *FinancialDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinancialDetails.ProtoReflect.Descriptor instead.
func (*FinancialDetails) Descriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{10}
}

func (x *FinancialDetails) GetInitialAcKwhPerYear() float32 {
	if x != nil {
		return x.InitialAcKwhPerYear
	}
	return 0
}

func (x *FinancialDetails) GetRemainingLifetimeUtilityBill() *money.Money {
	if x != nil {
		return x.RemainingLifetimeUtilityBill
	}
	return nil
}

func (x *FinancialDetails) GetFederalIncentive() *money.Money {
	if x != nil {
		return x.FederalIncentive
	}
	return nil
}

func (x *FinancialDetails) GetStateIncentive() *money.Money {
	if x != nil {
		return x.StateIncentive
	}
	return nil
}

func (x *FinancialDetails) GetUtilityIncentive() *money.Money {
	if x != nil {
		return x.UtilityIncentive
	}
	return nil
}

func (x *FinancialDetails) GetLifetimeSrecTotal() *money.Money {
	if x != nil {
		return x.LifetimeSrecTotal
	}
	return nil
}

func (x *FinancialDetails) GetCostOfElectricityWithoutSolar() *money.Money {
	if x != nil {
		return x.CostOfElectricityWithoutSolar
	}
	return nil
}

func (x *FinancialDetails) GetNetMeteringAllowed() bool {
	if x != nil {
		return x.NetMeteringAllowed
	}
	return false
}

func (x *FinancialDetails) GetSolarPercentage() float32 {
	if x != nil && x.SolarPercentage != nil {
		return *x.SolarPercentage
	}
	return 0
}

func (x *FinancialDetails) GetPercentageExportedToGrid() float32 {
	if x != nil && x.PercentageExportedToGrid != nil {
		return *x.PercentageExportedToGrid
	}
	return 0
}

// Financial information that's shared between different financing methods.
type SavingsOverTime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Savings in the first year after panel installation.
	SavingsYear1 *money.Money `protobuf:"bytes,1,opt,name=savings_year1,json=savingsYear1,proto3" json:"savings_year1,omitempty"`
	// Savings in the first twenty years after panel installation.
	SavingsYear20 *money.Money `protobuf:"bytes,2,opt,name=savings_year20,json=savingsYear20,proto3" json:"savings_year20,omitempty"`
	// Using the assumed discount rate, what is the present value of the
	// cumulative 20-year savings?
	PresentValueOfSavingsYear20 *money.Money `protobuf:"bytes,3,opt,name=present_value_of_savings_year20,json=presentValueOfSavingsYear20,proto3" json:"present_value_of_savings_year20,omitempty"`
	// Savings in the entire panel lifetime.
	SavingsLifetime *money.Money `protobuf:"bytes,5,opt,name=savings_lifetime,json=savingsLifetime,proto3" json:"savings_lifetime,omitempty"`
	// Using the assumed discount rate, what is the present value of the
	// cumulative lifetime savings?
	PresentValueOfSavingsLifetime *money.Money `protobuf:"bytes,6,opt,name=present_value_of_savings_lifetime,json=presentValueOfSavingsLifetime,proto3" json:"present_value_of_savings_lifetime,omitempty"`
	// Indicates whether this scenario is financially viable.  Will be false for
	// scenarios with poor financial viability (e.g., money-losing).
	FinanciallyViable bool `protobuf:"varint,4,opt,name=financially_viable,json=financiallyViable,proto3" json:"financially_viable,omitempty"`
}

func (x *SavingsOverTime) Reset() {
	*x = SavingsOverTime{}
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SavingsOverTime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SavingsOverTime) ProtoMessage() {}

func (x *SavingsOverTime) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SavingsOverTime.ProtoReflect.Descriptor instead.
func (*SavingsOverTime) Descriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{11}
}

func (x *SavingsOverTime) GetSavingsYear1() *money.Money {
	if x != nil {
		return x.SavingsYear1
	}
	return nil
}

func (x *SavingsOverTime) GetSavingsYear20() *money.Money {
	if x != nil {
		return x.SavingsYear20
	}
	return nil
}

func (x *SavingsOverTime) GetPresentValueOfSavingsYear20() *money.Money {
	if x != nil {
		return x.PresentValueOfSavingsYear20
	}
	return nil
}

func (x *SavingsOverTime) GetSavingsLifetime() *money.Money {
	if x != nil {
		return x.SavingsLifetime
	}
	return nil
}

func (x *SavingsOverTime) GetPresentValueOfSavingsLifetime() *money.Money {
	if x != nil {
		return x.PresentValueOfSavingsLifetime
	}
	return nil
}

func (x *SavingsOverTime) GetFinanciallyViable() bool {
	if x != nil {
		return x.FinanciallyViable
	}
	return false
}

// Cost and benefit of leasing a particular configuration of solar panels
// with a particular electricity usage.
type LeasingSavings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether leases are allowed in this juristiction (leases are not
	// allowed in some states). If this field is false, then the values in
	// this message should probably be ignored.
	LeasesAllowed bool `protobuf:"varint,1,opt,name=leases_allowed,json=leasesAllowed,proto3" json:"leases_allowed,omitempty"`
	// Whether leases are supported in this juristiction by the financial
	// calculation engine. If this field is false, then the values in this
	// message should probably be ignored. This is independent of
	// `leases_allowed`: in some areas leases are allowed, but under conditions
	// that aren't handled by the financial models.
	LeasesSupported bool `protobuf:"varint,2,opt,name=leases_supported,json=leasesSupported,proto3" json:"leases_supported,omitempty"`
	// Estimated annual leasing cost.
	AnnualLeasingCost *money.Money `protobuf:"bytes,3,opt,name=annual_leasing_cost,json=annualLeasingCost,proto3" json:"annual_leasing_cost,omitempty"`
	// How much is saved (or not) over the lifetime period.
	Savings *SavingsOverTime `protobuf:"bytes,4,opt,name=savings,proto3" json:"savings,omitempty"`
}

func (x *LeasingSavings) Reset() {
	*x = LeasingSavings{}
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LeasingSavings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LeasingSavings) ProtoMessage() {}

func (x *LeasingSavings) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LeasingSavings.ProtoReflect.Descriptor instead.
func (*LeasingSavings) Descriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{12}
}

func (x *LeasingSavings) GetLeasesAllowed() bool {
	if x != nil {
		return x.LeasesAllowed
	}
	return false
}

func (x *LeasingSavings) GetLeasesSupported() bool {
	if x != nil {
		return x.LeasesSupported
	}
	return false
}

func (x *LeasingSavings) GetAnnualLeasingCost() *money.Money {
	if x != nil {
		return x.AnnualLeasingCost
	}
	return nil
}

func (x *LeasingSavings) GetSavings() *SavingsOverTime {
	if x != nil {
		return x.Savings
	}
	return nil
}

// Cost and benefit of an outright purchase of a particular configuration
// of solar panels with a particular electricity usage.
type CashPurchaseSavings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Initial cost before tax incentives: the amount that must be paid
	// out-of-pocket. Contrast with `upfront_cost`, which is after tax incentives.
	OutOfPocketCost *money.Money `protobuf:"bytes,1,opt,name=out_of_pocket_cost,json=outOfPocketCost,proto3" json:"out_of_pocket_cost,omitempty"`
	// Initial cost after tax incentives: it's the amount that must be paid
	// during first year. Contrast with `out_of_pocket_cost`, which is before tax
	// incentives.
	UpfrontCost *money.Money `protobuf:"bytes,2,opt,name=upfront_cost,json=upfrontCost,proto3" json:"upfront_cost,omitempty"`
	// The value of all tax rebates.
	RebateValue *money.Money `protobuf:"bytes,3,opt,name=rebate_value,json=rebateValue,proto3" json:"rebate_value,omitempty"`
	// Number of years until payback occurs. A negative value means payback
	// never occurs within the lifetime period.
	PaybackYears *float32 `protobuf:"fixed32,4,opt,name=payback_years,json=paybackYears,proto3,oneof" json:"payback_years,omitempty"`
	// How much is saved (or not) over the lifetime period.
	Savings *SavingsOverTime `protobuf:"bytes,5,opt,name=savings,proto3" json:"savings,omitempty"`
}

func (x *CashPurchaseSavings) Reset() {
	*x = CashPurchaseSavings{}
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CashPurchaseSavings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CashPurchaseSavings) ProtoMessage() {}

func (x *CashPurchaseSavings) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CashPurchaseSavings.ProtoReflect.Descriptor instead.
func (*CashPurchaseSavings) Descriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{13}
}

func (x *CashPurchaseSavings) GetOutOfPocketCost() *money.Money {
	if x != nil {
		return x.OutOfPocketCost
	}
	return nil
}

func (x *CashPurchaseSavings) GetUpfrontCost() *money.Money {
	if x != nil {
		return x.UpfrontCost
	}
	return nil
}

func (x *CashPurchaseSavings) GetRebateValue() *money.Money {
	if x != nil {
		return x.RebateValue
	}
	return nil
}

func (x *CashPurchaseSavings) GetPaybackYears() float32 {
	if x != nil && x.PaybackYears != nil {
		return *x.PaybackYears
	}
	return 0
}

func (x *CashPurchaseSavings) GetSavings() *SavingsOverTime {
	if x != nil {
		return x.Savings
	}
	return nil
}

// Cost and benefit of using a loan to buy a particular configuration
// of solar panels with a particular electricity usage.
type FinancedPurchaseSavings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Annual loan payments.
	AnnualLoanPayment *money.Money `protobuf:"bytes,1,opt,name=annual_loan_payment,json=annualLoanPayment,proto3" json:"annual_loan_payment,omitempty"`
	// The value of all tax rebates (including Federal Investment Tax Credit
	// (ITC)).
	RebateValue *money.Money `protobuf:"bytes,2,opt,name=rebate_value,json=rebateValue,proto3" json:"rebate_value,omitempty"`
	// The interest rate on loans assumed in this set of calculations.
	LoanInterestRate float32 `protobuf:"fixed32,3,opt,name=loan_interest_rate,json=loanInterestRate,proto3" json:"loan_interest_rate,omitempty"`
	// How much is saved (or not) over the lifetime period.
	Savings *SavingsOverTime `protobuf:"bytes,4,opt,name=savings,proto3" json:"savings,omitempty"`
}

func (x *FinancedPurchaseSavings) Reset() {
	*x = FinancedPurchaseSavings{}
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FinancedPurchaseSavings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinancedPurchaseSavings) ProtoMessage() {}

func (x *FinancedPurchaseSavings) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinancedPurchaseSavings.ProtoReflect.Descriptor instead.
func (*FinancedPurchaseSavings) Descriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{14}
}

func (x *FinancedPurchaseSavings) GetAnnualLoanPayment() *money.Money {
	if x != nil {
		return x.AnnualLoanPayment
	}
	return nil
}

func (x *FinancedPurchaseSavings) GetRebateValue() *money.Money {
	if x != nil {
		return x.RebateValue
	}
	return nil
}

func (x *FinancedPurchaseSavings) GetLoanInterestRate() float32 {
	if x != nil {
		return x.LoanInterestRate
	}
	return 0
}

func (x *FinancedPurchaseSavings) GetSavings() *SavingsOverTime {
	if x != nil {
		return x.Savings
	}
	return nil
}

// Request message for `Solar.GetDataLayers`.
type GetDataLayersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The longitude and latitude for the center of the region to get
	// data for.
	Location *latlng.LatLng `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Required. The radius, in meters, defining the region surrounding that
	// centre point for which data should be returned. The limitations
	// on this value are:
	//
	//   - Any value up to 100m can always be specified.
	//   - Values over 100m can be specified, as long as
	//     `radius_meters` <= `pixel_size_meters * 1000`.
	//   - However, for values over 175m, the `DataLayerView` in the
	//     request must not include monthly flux or hourly shade.
	RadiusMeters float32 `protobuf:"fixed32,2,opt,name=radius_meters,json=radiusMeters,proto3" json:"radius_meters,omitempty"`
	// Optional. The desired subset of the data to return.
	View DataLayerView `protobuf:"varint,3,opt,name=view,proto3,enum=google.maps.solar.v1.DataLayerView" json:"view,omitempty"`
	// Optional. The minimum quality level allowed in the results. No result with
	// lower quality than this will be returned. Not specifying this is
	// equivalent to restricting to HIGH quality only.
	RequiredQuality ImageryQuality `protobuf:"varint,5,opt,name=required_quality,json=requiredQuality,proto3,enum=google.maps.solar.v1.ImageryQuality" json:"required_quality,omitempty"`
	// Optional. The minimum scale, in meters per pixel, of the data to return.
	// Values of 0.1 (the default, if this field is not set explicitly),
	// 0.25, 0.5, and 1.0 are supported. Imagery components whose normal
	// resolution is less than `pixel_size_meters` will be returned at
	// the resolution specified by `pixel_size_meters`; imagery
	// components whose normal resolution is equal to or greater than
	// `pixel_size_meters` will be returned at that normal resolution.
	PixelSizeMeters float32 `protobuf:"fixed32,6,opt,name=pixel_size_meters,json=pixelSizeMeters,proto3" json:"pixel_size_meters,omitempty"`
	// Optional. Whether to require exact quality of the imagery.
	// If set to false, the `required_quality` field is interpreted as the minimum
	// required quality, such that HIGH quality imagery may be returned when
	// `required_quality` is set to MEDIUM.  If set to true, `required_quality`
	// is interpreted as the exact required quality and only `MEDIUM` quality
	// imagery is returned if `required_quality` is set to `MEDIUM`.
	ExactQualityRequired bool `protobuf:"varint,7,opt,name=exact_quality_required,json=exactQualityRequired,proto3" json:"exact_quality_required,omitempty"`
	// Optional. Specifies the pre-GA experiments to enable.
	Experiments []Experiment `protobuf:"varint,8,rep,packed,name=experiments,proto3,enum=google.maps.solar.v1.Experiment" json:"experiments,omitempty"`
}

func (x *GetDataLayersRequest) Reset() {
	*x = GetDataLayersRequest{}
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDataLayersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataLayersRequest) ProtoMessage() {}

func (x *GetDataLayersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataLayersRequest.ProtoReflect.Descriptor instead.
func (*GetDataLayersRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{15}
}

func (x *GetDataLayersRequest) GetLocation() *latlng.LatLng {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *GetDataLayersRequest) GetRadiusMeters() float32 {
	if x != nil {
		return x.RadiusMeters
	}
	return 0
}

func (x *GetDataLayersRequest) GetView() DataLayerView {
	if x != nil {
		return x.View
	}
	return DataLayerView_DATA_LAYER_VIEW_UNSPECIFIED
}

func (x *GetDataLayersRequest) GetRequiredQuality() ImageryQuality {
	if x != nil {
		return x.RequiredQuality
	}
	return ImageryQuality_IMAGERY_QUALITY_UNSPECIFIED
}

func (x *GetDataLayersRequest) GetPixelSizeMeters() float32 {
	if x != nil {
		return x.PixelSizeMeters
	}
	return 0
}

func (x *GetDataLayersRequest) GetExactQualityRequired() bool {
	if x != nil {
		return x.ExactQualityRequired
	}
	return false
}

func (x *GetDataLayersRequest) GetExperiments() []Experiment {
	if x != nil {
		return x.Experiments
	}
	return nil
}

// Information about the solar potential of a region. The actual data
// are contained in a number of GeoTIFF files covering the requested
// region, for which this message contains URLs: Each string in the
// `DataLayers` message contains a URL from which the
// corresponding GeoTIFF can be fetched. These URLs are valid for a
// few hours after they've been generated. Most of the GeoTIFF files
// are at a resolution of 0.1m/pixel, but the monthly flux file is at
// 0.5m/pixel, and the hourly shade files are at 1m/pixel. If a
// `pixel_size_meters` value was specified in the
// `GetDataLayersRequest`, then the minimum resolution in the GeoTIFF
// files will be that value.
type DataLayers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// When the source imagery (from which all the other data are derived) in this
	// region was taken. It is necessarily somewhat approximate, as the images may
	// have been taken over more than one day.
	ImageryDate *date.Date `protobuf:"bytes,1,opt,name=imagery_date,json=imageryDate,proto3" json:"imagery_date,omitempty"`
	// When processing was completed on this imagery.
	ImageryProcessedDate *date.Date `protobuf:"bytes,2,opt,name=imagery_processed_date,json=imageryProcessedDate,proto3" json:"imagery_processed_date,omitempty"`
	// The URL for an image of the DSM (Digital Surface Model) of the region.
	// Values are in meters above EGM96 geoid (i.e., sea level). Invalid locations
	// (where we don't have data) are stored as -9999.
	DsmUrl string `protobuf:"bytes,3,opt,name=dsm_url,json=dsmUrl,proto3" json:"dsm_url,omitempty"`
	// The URL for an image of RGB data (aerial photo) of the region.
	RgbUrl string `protobuf:"bytes,4,opt,name=rgb_url,json=rgbUrl,proto3" json:"rgb_url,omitempty"`
	// The URL for the building mask image: one bit per pixel saying whether that
	// pixel is considered to be part of a rooftop or not.
	MaskUrl string `protobuf:"bytes,5,opt,name=mask_url,json=maskUrl,proto3" json:"mask_url,omitempty"`
	// The URL for the annual flux map (annual sunlight on roofs) of the region.
	// Values are kWh/kW/year. This is *unmasked flux*: flux is computed for every
	// location, not just building rooftops. Invalid locations are stored as
	// -9999: locations outside our coverage area will be invalid, and a few
	// locations inside the coverage area, where we were unable to calculate flux,
	// will also be invalid.
	AnnualFluxUrl string `protobuf:"bytes,6,opt,name=annual_flux_url,json=annualFluxUrl,proto3" json:"annual_flux_url,omitempty"`
	// The URL for the monthly flux map (sunlight on roofs, broken down by month)
	// of the region. Values are kWh/kW/year. The GeoTIFF pointed to by this URL
	// will contain twelve bands, corresponding to January...December, in order.
	MonthlyFluxUrl string `protobuf:"bytes,7,opt,name=monthly_flux_url,json=monthlyFluxUrl,proto3" json:"monthly_flux_url,omitempty"`
	// Twelve URLs for hourly shade, corresponding to January...December, in
	// order. Each GeoTIFF will contain 24 bands, corresponding to the 24 hours of
	// the day. Each pixel is a 32 bit integer, corresponding to the (up to) 31
	// days of that month; a 1 bit means that the corresponding location is able
	// to see the sun at that day, of that hour, of that month. Invalid locations
	// are stored as -9999 (since this is negative, it has bit 31 set, and no
	// valid value could have bit 31 set as that would correspond to the 32nd day
	// of the month).
	//
	// An example may be useful. If you want to know whether a point (at
	// pixel location (x, y)) saw sun at 4pm on the 22nd of June you
	// would:
	//
	// 1. fetch the sixth URL in this list (corresponding to June).
	// 1. look up the 17th channel (corresponding to 4pm).
	// 1. read the 32-bit value at (x, y).
	// 1. read bit 21 of the value (corresponding to the 22nd of the month).
	// 1. if that bit is a 1, then that spot saw the sun at 4pm 22 June.
	//
	// More formally:
	// Given `month` (1-12), `day` (1...month max; February has 28 days)
	// and `hour` (0-23), the shade/sun for that month/day/hour at a
	// position `(x, y)` is the bit
	// ```
	// (hourly_shade[month - 1])(x, y)[hour] & (1 << (day - 1))
	// ```
	// where `(x, y)` is spatial indexing, `[month - 1]` refers to
	// fetching the `month - 1`st URL (indexing from zero), `[hour]` is
	// indexing into the channels, and a final non-zero result means
	// "sunny". There are no leap days, and DST doesn't exist (all days
	// are 24 hours long; noon is always "standard time" noon).
	HourlyShadeUrls []string `protobuf:"bytes,8,rep,name=hourly_shade_urls,json=hourlyShadeUrls,proto3" json:"hourly_shade_urls,omitempty"`
	// The quality of the result's imagery.
	ImageryQuality ImageryQuality `protobuf:"varint,9,opt,name=imagery_quality,json=imageryQuality,proto3,enum=google.maps.solar.v1.ImageryQuality" json:"imagery_quality,omitempty"`
}

func (x *DataLayers) Reset() {
	*x = DataLayers{}
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataLayers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataLayers) ProtoMessage() {}

func (x *DataLayers) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataLayers.ProtoReflect.Descriptor instead.
func (*DataLayers) Descriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{16}
}

func (x *DataLayers) GetImageryDate() *date.Date {
	if x != nil {
		return x.ImageryDate
	}
	return nil
}

func (x *DataLayers) GetImageryProcessedDate() *date.Date {
	if x != nil {
		return x.ImageryProcessedDate
	}
	return nil
}

func (x *DataLayers) GetDsmUrl() string {
	if x != nil {
		return x.DsmUrl
	}
	return ""
}

func (x *DataLayers) GetRgbUrl() string {
	if x != nil {
		return x.RgbUrl
	}
	return ""
}

func (x *DataLayers) GetMaskUrl() string {
	if x != nil {
		return x.MaskUrl
	}
	return ""
}

func (x *DataLayers) GetAnnualFluxUrl() string {
	if x != nil {
		return x.AnnualFluxUrl
	}
	return ""
}

func (x *DataLayers) GetMonthlyFluxUrl() string {
	if x != nil {
		return x.MonthlyFluxUrl
	}
	return ""
}

func (x *DataLayers) GetHourlyShadeUrls() []string {
	if x != nil {
		return x.HourlyShadeUrls
	}
	return nil
}

func (x *DataLayers) GetImageryQuality() ImageryQuality {
	if x != nil {
		return x.ImageryQuality
	}
	return ImageryQuality_IMAGERY_QUALITY_UNSPECIFIED
}

// Request message for `Solar.GetGeoTiff`.
type GetGeoTiffRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the asset being requested.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *GetGeoTiffRequest) Reset() {
	*x = GetGeoTiffRequest{}
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGeoTiffRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGeoTiffRequest) ProtoMessage() {}

func (x *GetGeoTiffRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_solar_v1_solar_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGeoTiffRequest.ProtoReflect.Descriptor instead.
func (*GetGeoTiffRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_solar_v1_solar_service_proto_rawDescGZIP(), []int{17}
}

func (x *GetGeoTiffRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

var File_google_maps_solar_v1_solar_service_proto protoreflect.FileDescriptor

var file_google_maps_solar_v1_solar_service_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x73, 0x6f,
	0x6c, 0x61, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x14, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x62, 0x6f, 0x64, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6c, 0x61, 0x74, 0x6c, 0x6e, 0x67, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x65, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb4,
	0x02, 0x0a, 0x22, 0x46, 0x69, 0x6e, 0x64, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x73, 0x74, 0x42, 0x75,
	0x69, 0x6c, 0x64, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x34, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x10, 0x72,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x72, 0x79, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x12, 0x39, 0x0a, 0x16, 0x65, 0x78, 0x61, 0x63, 0x74, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x65, 0x78, 0x61, 0x63, 0x74, 0x51, 0x75, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x12, 0x47, 0x0a, 0x0b,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0e, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x55, 0x0a, 0x09, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x42,
	0x6f, 0x78, 0x12, 0x23, 0x0a, 0x02, 0x73, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74,
	0x4c, 0x6e, 0x67, 0x52, 0x02, 0x73, 0x77, 0x12, 0x23, 0x0a, 0x02, 0x6e, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52, 0x02, 0x6e, 0x65, 0x22, 0xd2, 0x04, 0x0a,
	0x10, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x06, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52, 0x06, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x12, 0x42, 0x0a, 0x0c, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x62,
	0x6f, 0x78, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x52, 0x0b, 0x62, 0x6f, 0x75, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x12, 0x34, 0x0a, 0x0c, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x72,
	0x79, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52,
	0x0b, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x72, 0x79, 0x44, 0x61, 0x74, 0x65, 0x12, 0x47, 0x0a, 0x16,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65,
	0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52,
	0x14, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65,
	0x64, 0x44, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x6f, 0x73, 0x74,
	0x61, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x69,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x61, 0x72, 0x65, 0x61, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x41, 0x72, 0x65, 0x61, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x73, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x61, 0x72, 0x65, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x41, 0x72,
	0x65, 0x61, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x64, 0x65, 0x12, 0x4d, 0x0a, 0x0f, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x5f, 0x70, 0x6f, 0x74,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x61, 0x72, 0x50, 0x6f, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x52, 0x0e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x50, 0x6f, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x12, 0x4d, 0x0a, 0x0f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x72, 0x79, 0x5f, 0x71, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x72, 0x79, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x52, 0x0e, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x72, 0x79, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x22, 0xc2, 0x07, 0x0a, 0x0e, 0x53, 0x6f, 0x6c, 0x61, 0x72, 0x50, 0x6f, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x12, 0x33, 0x0a, 0x16, 0x6d, 0x61, 0x78, 0x5f, 0x61, 0x72, 0x72, 0x61,
	0x79, 0x5f, 0x70, 0x61, 0x6e, 0x65, 0x6c, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x13, 0x6d, 0x61, 0x78, 0x41, 0x72, 0x72, 0x61, 0x79, 0x50, 0x61,
	0x6e, 0x65, 0x6c, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x70, 0x61, 0x6e,
	0x65, 0x6c, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x77, 0x61, 0x74, 0x74,
	0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x02, 0x52, 0x12, 0x70, 0x61, 0x6e, 0x65, 0x6c, 0x43, 0x61,
	0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x57, 0x61, 0x74, 0x74, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x70,
	0x61, 0x6e, 0x65, 0x6c, 0x5f, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x02, 0x52, 0x11, 0x70, 0x61, 0x6e, 0x65, 0x6c, 0x48,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x70,
	0x61, 0x6e, 0x65, 0x6c, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x02, 0x52, 0x10, 0x70, 0x61, 0x6e, 0x65, 0x6c, 0x57, 0x69,
	0x64, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x70, 0x61, 0x6e,
	0x65, 0x6c, 0x5f, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x79, 0x65, 0x61, 0x72,
	0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x70, 0x61, 0x6e, 0x65, 0x6c, 0x4c, 0x69,
	0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x59, 0x65, 0x61, 0x72, 0x73, 0x12, 0x33, 0x0a, 0x16, 0x6d,
	0x61, 0x78, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x61, 0x72, 0x65, 0x61, 0x5f, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x32, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x13, 0x6d, 0x61, 0x78,
	0x41, 0x72, 0x72, 0x61, 0x79, 0x41, 0x72, 0x65, 0x61, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x32,
	0x12, 0x3c, 0x0a, 0x1b, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x75, 0x6e, 0x73, 0x68, 0x69, 0x6e, 0x65,
	0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x79, 0x65, 0x61, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x17, 0x6d, 0x61, 0x78, 0x53, 0x75, 0x6e, 0x73, 0x68, 0x69,
	0x6e, 0x65, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x50, 0x65, 0x72, 0x59, 0x65, 0x61, 0x72, 0x12, 0x43,
	0x0a, 0x1f, 0x63, 0x61, 0x72, 0x62, 0x6f, 0x6e, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x5f,
	0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x6b, 0x67, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6d, 0x77,
	0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x1a, 0x63, 0x61, 0x72, 0x62, 0x6f, 0x6e, 0x4f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x4b, 0x67, 0x50, 0x65, 0x72,
	0x4d, 0x77, 0x68, 0x12, 0x54, 0x0a, 0x10, 0x77, 0x68, 0x6f, 0x6c, 0x65, 0x5f, 0x72, 0x6f, 0x6f,
	0x66, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x6e, 0x64, 0x53, 0x75, 0x6e, 0x73,
	0x68, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x0e, 0x77, 0x68, 0x6f, 0x6c, 0x65,
	0x52, 0x6f, 0x6f, 0x66, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x51, 0x0a, 0x0e, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x6e, 0x64,
	0x53, 0x75, 0x6e, 0x73, 0x68, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x0d, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x63, 0x0a, 0x12,
	0x72, 0x6f, 0x6f, 0x66, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x6f, 0x6f, 0x66, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x41,
	0x6e, 0x64, 0x53, 0x75, 0x6e, 0x73, 0x68, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52,
	0x10, 0x72, 0x6f, 0x6f, 0x66, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x12, 0x43, 0x0a, 0x0c, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x5f, 0x70, 0x61, 0x6e, 0x65, 0x6c,
	0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x6f, 0x6c, 0x61, 0x72, 0x50, 0x61, 0x6e, 0x65, 0x6c, 0x52, 0x0b, 0x73, 0x6f, 0x6c, 0x61, 0x72,
	0x50, 0x61, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0x56, 0x0a, 0x13, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x5f,
	0x70, 0x61, 0x6e, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x61, 0x72,
	0x50, 0x61, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x73, 0x6f, 0x6c,
	0x61, 0x72, 0x50, 0x61, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x56,
	0x0a, 0x12, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x5f, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x52, 0x11, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x22, 0xbb, 0x03, 0x0a, 0x1f, 0x52, 0x6f, 0x6f, 0x66, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x6e, 0x64, 0x53, 0x75, 0x6e,
	0x73, 0x68, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x70, 0x69,
	0x74, 0x63, 0x68, 0x5f, 0x64, 0x65, 0x67, 0x72, 0x65, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x02, 0x48, 0x00, 0x52, 0x0c, 0x70, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x67, 0x72, 0x65, 0x65,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x2c, 0x0a, 0x0f, 0x61, 0x7a, 0x69, 0x6d, 0x75, 0x74, 0x68, 0x5f,
	0x64, 0x65, 0x67, 0x72, 0x65, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x48, 0x01, 0x52,
	0x0e, 0x61, 0x7a, 0x69, 0x6d, 0x75, 0x74, 0x68, 0x44, 0x65, 0x67, 0x72, 0x65, 0x65, 0x73, 0x88,
	0x01, 0x01, 0x12, 0x40, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x6e, 0x64,
	0x53, 0x75, 0x6e, 0x73, 0x68, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x73, 0x12, 0x2b, 0x0a, 0x06, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52, 0x06, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x12, 0x42, 0x0a, 0x0c, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x6f,
	0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x61, 0x74, 0x4c, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x52, 0x0b, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x42, 0x6f, 0x78, 0x12, 0x45, 0x0a, 0x1d, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x5f, 0x68,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x61, 0x74, 0x5f, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x02, 0x48, 0x02, 0x52, 0x19,
	0x70, 0x6c, 0x61, 0x6e, 0x65, 0x48, 0x65, 0x69, 0x67, 0x68, 0x74, 0x41, 0x74, 0x43, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x88, 0x01, 0x01, 0x42, 0x10, 0x0a, 0x0e,
	0x5f, 0x70, 0x69, 0x74, 0x63, 0x68, 0x5f, 0x64, 0x65, 0x67, 0x72, 0x65, 0x65, 0x73, 0x42, 0x12,
	0x0a, 0x10, 0x5f, 0x61, 0x7a, 0x69, 0x6d, 0x75, 0x74, 0x68, 0x5f, 0x64, 0x65, 0x67, 0x72, 0x65,
	0x65, 0x73, 0x42, 0x20, 0x0a, 0x1e, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x5f, 0x68, 0x65, 0x69,
	0x67, 0x68, 0x74, 0x5f, 0x61, 0x74, 0x5f, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x22, 0x98, 0x01, 0x0a, 0x14, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x6e, 0x64,
	0x53, 0x75, 0x6e, 0x73, 0x68, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x21, 0x0a,
	0x0c, 0x61, 0x72, 0x65, 0x61, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x32, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x0b, 0x61, 0x72, 0x65, 0x61, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x32,
	0x12, 0x2d, 0x0a, 0x12, 0x73, 0x75, 0x6e, 0x73, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x71, 0x75, 0x61,
	0x6e, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x02, 0x52, 0x11, 0x73, 0x75,
	0x6e, 0x73, 0x68, 0x69, 0x6e, 0x65, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x12,
	0x2e, 0x0a, 0x13, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x61, 0x72, 0x65, 0x61, 0x5f, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x32, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x11, 0x67, 0x72,
	0x6f, 0x75, 0x6e, 0x64, 0x41, 0x72, 0x65, 0x61, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x32, 0x22,
	0xf5, 0x01, 0x0a, 0x0a, 0x53, 0x6f, 0x6c, 0x61, 0x72, 0x50, 0x61, 0x6e, 0x65, 0x6c, 0x12, 0x2b,
	0x0a, 0x06, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74,
	0x4c, 0x6e, 0x67, 0x52, 0x06, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x4d, 0x0a, 0x0b, 0x6f,
	0x72, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73,
	0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x61, 0x72, 0x50, 0x61, 0x6e,
	0x65, 0x6c, 0x4f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x6f,
	0x72, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x14, 0x79, 0x65,
	0x61, 0x72, 0x6c, 0x79, 0x5f, 0x65, 0x6e, 0x65, 0x72, 0x67, 0x79, 0x5f, 0x64, 0x63, 0x5f, 0x6b,
	0x77, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x11, 0x79, 0x65, 0x61, 0x72, 0x6c, 0x79,
	0x45, 0x6e, 0x65, 0x72, 0x67, 0x79, 0x44, 0x63, 0x4b, 0x77, 0x68, 0x12, 0x28, 0x0a, 0x0d, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x05, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x88, 0x01, 0x01, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x22, 0xc6, 0x01, 0x0a, 0x10, 0x53, 0x6f, 0x6c, 0x61,
	0x72, 0x50, 0x61, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x21, 0x0a, 0x0c,
	0x70, 0x61, 0x6e, 0x65, 0x6c, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0b, 0x70, 0x61, 0x6e, 0x65, 0x6c, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x2f, 0x0a, 0x14, 0x79, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x5f, 0x65, 0x6e, 0x65, 0x72, 0x67, 0x79,
	0x5f, 0x64, 0x63, 0x5f, 0x6b, 0x77, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x11, 0x79,
	0x65, 0x61, 0x72, 0x6c, 0x79, 0x45, 0x6e, 0x65, 0x72, 0x67, 0x79, 0x44, 0x63, 0x4b, 0x77, 0x68,
	0x12, 0x5e, 0x0a, 0x16, 0x72, 0x6f, 0x6f, 0x66, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73,
	0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6f, 0x66, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x14, 0x72, 0x6f, 0x6f, 0x66,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73,
	0x22, 0xa2, 0x02, 0x0a, 0x12, 0x52, 0x6f, 0x6f, 0x66, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x28, 0x0a, 0x0d, 0x70, 0x69, 0x74, 0x63, 0x68,
	0x5f, 0x64, 0x65, 0x67, 0x72, 0x65, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00,
	0x52, 0x0c, 0x70, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x67, 0x72, 0x65, 0x65, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x2c, 0x0a, 0x0f, 0x61, 0x7a, 0x69, 0x6d, 0x75, 0x74, 0x68, 0x5f, 0x64, 0x65, 0x67,
	0x72, 0x65, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x48, 0x01, 0x52, 0x0e, 0x61, 0x7a,
	0x69, 0x6d, 0x75, 0x74, 0x68, 0x44, 0x65, 0x67, 0x72, 0x65, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12,
	0x21, 0x0a, 0x0c, 0x70, 0x61, 0x6e, 0x65, 0x6c, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x70, 0x61, 0x6e, 0x65, 0x6c, 0x73, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x14, 0x79, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x5f, 0x65, 0x6e, 0x65,
	0x72, 0x67, 0x79, 0x5f, 0x64, 0x63, 0x5f, 0x6b, 0x77, 0x68, 0x18, 0x08, 0x20, 0x01, 0x28, 0x02,
	0x52, 0x11, 0x79, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x45, 0x6e, 0x65, 0x72, 0x67, 0x79, 0x44, 0x63,
	0x4b, 0x77, 0x68, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x48, 0x02, 0x52, 0x0c, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x88, 0x01, 0x01, 0x42, 0x10, 0x0a,
	0x0e, 0x5f, 0x70, 0x69, 0x74, 0x63, 0x68, 0x5f, 0x64, 0x65, 0x67, 0x72, 0x65, 0x65, 0x73, 0x42,
	0x12, 0x0a, 0x10, 0x5f, 0x61, 0x7a, 0x69, 0x6d, 0x75, 0x74, 0x68, 0x5f, 0x64, 0x65, 0x67, 0x72,
	0x65, 0x65, 0x73, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x22, 0xd8, 0x04, 0x0a, 0x11, 0x46, 0x69, 0x6e, 0x61, 0x6e, 0x63,
	0x69, 0x61, 0x6c, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x35, 0x0a, 0x0c, 0x6d,
	0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x5f, 0x62, 0x69, 0x6c, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x0b, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x42, 0x69,
	0x6c, 0x6c, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x62, 0x69,
	0x6c, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x42, 0x69, 0x6c, 0x6c, 0x12, 0x31, 0x0a, 0x15, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x6b, 0x77, 0x68, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x12, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x4b, 0x77, 0x68,
	0x50, 0x65, 0x72, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x12, 0x31, 0x0a, 0x12, 0x70, 0x61, 0x6e, 0x65,
	0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x10, 0x70, 0x61, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x88, 0x01, 0x01, 0x12, 0x53, 0x0a, 0x11, 0x66,
	0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69,
	0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x10,
	0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x4d, 0x0a, 0x0f, 0x6c, 0x65, 0x61, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x61, 0x76, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x65, 0x61, 0x73, 0x69, 0x6e, 0x67, 0x53, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x0e, 0x6c, 0x65, 0x61, 0x73, 0x69, 0x6e, 0x67, 0x53, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x5d, 0x0a, 0x15, 0x63, 0x61, 0x73, 0x68, 0x5f, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65,
	0x5f, 0x73, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c,
	0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x73, 0x68, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61,
	0x73, 0x65, 0x53, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x13, 0x63, 0x61, 0x73, 0x68, 0x50,
	0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x53, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x69,
	0x0a, 0x19, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x70, 0x75, 0x72, 0x63, 0x68,
	0x61, 0x73, 0x65, 0x5f, 0x73, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x64, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x53, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x17, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61,
	0x73, 0x65, 0x53, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x70, 0x61,
	0x6e, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x22, 0xdf, 0x05, 0x0a, 0x10, 0x46, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x34, 0x0a, 0x17, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c,
	0x5f, 0x61, 0x63, 0x5f, 0x6b, 0x77, 0x68, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x79, 0x65, 0x61, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x13, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x41,
	0x63, 0x4b, 0x77, 0x68, 0x50, 0x65, 0x72, 0x59, 0x65, 0x61, 0x72, 0x12, 0x59, 0x0a, 0x1f, 0x72,
	0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x62, 0x69, 0x6c, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x1c, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x4c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x55, 0x74, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x42, 0x69, 0x6c, 0x6c, 0x12, 0x3f, 0x0a, 0x11, 0x66, 0x65, 0x64, 0x65, 0x72, 0x61,
	0x6c, 0x5f, 0x69, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x69, 0x76, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x10, 0x66, 0x65, 0x64, 0x65, 0x72, 0x61, 0x6c, 0x49, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x69, 0x76, 0x65, 0x12, 0x3b, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x5f, 0x69, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x69, 0x76, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d,
	0x6f, 0x6e, 0x65, 0x79, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x69, 0x76, 0x65, 0x12, 0x3f, 0x0a, 0x11, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f,
	0x69, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x69, 0x76, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f,
	0x6e, 0x65, 0x79, 0x52, 0x10, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x69, 0x76, 0x65, 0x12, 0x42, 0x0a, 0x13, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x73, 0x72, 0x65, 0x63, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x11, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65,
	0x53, 0x72, 0x65, 0x63, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x12, 0x5c, 0x0a, 0x21, 0x63, 0x6f, 0x73,
	0x74, 0x5f, 0x6f, 0x66, 0x5f, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x72, 0x69, 0x63, 0x69, 0x74, 0x79,
	0x5f, 0x77, 0x69, 0x74, 0x68, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x1d, 0x63, 0x6f, 0x73, 0x74, 0x4f, 0x66,
	0x45, 0x6c, 0x65, 0x63, 0x74, 0x72, 0x69, 0x63, 0x69, 0x74, 0x79, 0x57, 0x69, 0x74, 0x68, 0x6f,
	0x75, 0x74, 0x53, 0x6f, 0x6c, 0x61, 0x72, 0x12, 0x30, 0x0a, 0x14, 0x6e, 0x65, 0x74, 0x5f, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x6e, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x12, 0x2e, 0x0a, 0x10, 0x73, 0x6f, 0x6c,
	0x61, 0x72, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x50, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x12, 0x42, 0x0a, 0x1b, 0x70, 0x65, 0x72,
	0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x5f, 0x74, 0x6f, 0x5f, 0x67, 0x72, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x02, 0x48, 0x01,
	0x52, 0x18, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x65, 0x64, 0x54, 0x6f, 0x47, 0x72, 0x69, 0x64, 0x88, 0x01, 0x01, 0x42, 0x13, 0x0a,
	0x11, 0x5f, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61,
	0x67, 0x65, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67,
	0x65, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x6f, 0x5f, 0x67, 0x72,
	0x69, 0x64, 0x22, 0xab, 0x03, 0x0a, 0x0f, 0x53, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x4f, 0x76,
	0x65, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x0d, 0x73, 0x61, 0x76, 0x69, 0x6e, 0x67,
	0x73, 0x5f, 0x79, 0x65, 0x61, 0x72, 0x31, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65,
	0x79, 0x52, 0x0c, 0x73, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x59, 0x65, 0x61, 0x72, 0x31, 0x12,
	0x39, 0x0a, 0x0e, 0x73, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x5f, 0x79, 0x65, 0x61, 0x72, 0x32,
	0x30, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x0d, 0x73, 0x61, 0x76,
	0x69, 0x6e, 0x67, 0x73, 0x59, 0x65, 0x61, 0x72, 0x32, 0x30, 0x12, 0x58, 0x0a, 0x1f, 0x70, 0x72,
	0x65, 0x73, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x6f, 0x66, 0x5f, 0x73,
	0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x5f, 0x79, 0x65, 0x61, 0x72, 0x32, 0x30, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x1b, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x4f, 0x66, 0x53, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x59, 0x65,
	0x61, 0x72, 0x32, 0x30, 0x12, 0x3d, 0x0a, 0x10, 0x73, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x5f,
	0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e,
	0x65, 0x79, 0x52, 0x0f, 0x73, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x4c, 0x69, 0x66, 0x65, 0x74,
	0x69, 0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x21, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x5f, 0x6f, 0x66, 0x5f, 0x73, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x5f,
	0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e,
	0x65, 0x79, 0x52, 0x1d, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x4f, 0x66, 0x53, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x4c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d,
	0x65, 0x12, 0x2d, 0x0a, 0x12, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x6c, 0x79,
	0x5f, 0x76, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x66,
	0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x6c, 0x79, 0x56, 0x69, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0xe7, 0x01, 0x0a, 0x0e, 0x4c, 0x65, 0x61, 0x73, 0x69, 0x6e, 0x67, 0x53, 0x61, 0x76, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x5f, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x73, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x73, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x53, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x64, 0x12, 0x42, 0x0a, 0x13, 0x61, 0x6e, 0x6e, 0x75, 0x61, 0x6c, 0x5f,
	0x6c, 0x65, 0x61, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x11, 0x61, 0x6e, 0x6e, 0x75, 0x61, 0x6c, 0x4c, 0x65,
	0x61, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x07, 0x73, 0x61, 0x76,
	0x69, 0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x4f, 0x76, 0x65, 0x72, 0x54, 0x69, 0x6d,
	0x65, 0x52, 0x07, 0x73, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x22, 0xc1, 0x02, 0x0a, 0x13, 0x43,
	0x61, 0x73, 0x68, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x53, 0x61, 0x76, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x3f, 0x0a, 0x12, 0x6f, 0x75, 0x74, 0x5f, 0x6f, 0x66, 0x5f, 0x70, 0x6f, 0x63,
	0x6b, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e,
	0x65, 0x79, 0x52, 0x0f, 0x6f, 0x75, 0x74, 0x4f, 0x66, 0x50, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x43,
	0x6f, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x0c, 0x75, 0x70, 0x66, 0x72, 0x6f, 0x6e, 0x74, 0x5f, 0x63,
	0x6f, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x0b, 0x75,
	0x70, 0x66, 0x72, 0x6f, 0x6e, 0x74, 0x43, 0x6f, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x0c, 0x72, 0x65,
	0x62, 0x61, 0x74, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d,
	0x6f, 0x6e, 0x65, 0x79, 0x52, 0x0b, 0x72, 0x65, 0x62, 0x61, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x28, 0x0a, 0x0d, 0x70, 0x61, 0x79, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x79, 0x65, 0x61,
	0x72, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x0c, 0x70, 0x61, 0x79, 0x62,
	0x61, 0x63, 0x6b, 0x59, 0x65, 0x61, 0x72, 0x73, 0x88, 0x01, 0x01, 0x12, 0x3f, 0x0a, 0x07, 0x73,
	0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x4f, 0x76, 0x65, 0x72, 0x54,
	0x69, 0x6d, 0x65, 0x52, 0x07, 0x73, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x10, 0x0a, 0x0e,
	0x5f, 0x70, 0x61, 0x79, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x79, 0x65, 0x61, 0x72, 0x73, 0x22, 0x83,
	0x02, 0x0a, 0x17, 0x46, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x50, 0x75, 0x72, 0x63, 0x68,
	0x61, 0x73, 0x65, 0x53, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x42, 0x0a, 0x13, 0x61, 0x6e,
	0x6e, 0x75, 0x61, 0x6c, 0x5f, 0x6c, 0x6f, 0x61, 0x6e, 0x5f, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x11, 0x61, 0x6e, 0x6e,
	0x75, 0x61, 0x6c, 0x4c, 0x6f, 0x61, 0x6e, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x35,
	0x0a, 0x0c, 0x72, 0x65, 0x62, 0x61, 0x74, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x0b, 0x72, 0x65, 0x62, 0x61, 0x74, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x6c, 0x6f, 0x61, 0x6e, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x10, 0x6c, 0x6f, 0x61, 0x6e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x52,
	0x61, 0x74, 0x65, 0x12, 0x3f, 0x0a, 0x07, 0x73, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x76, 0x69,
	0x6e, 0x67, 0x73, 0x4f, 0x76, 0x65, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x07, 0x73, 0x61, 0x76,
	0x69, 0x6e, 0x67, 0x73, 0x22, 0xbf, 0x03, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x4c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x34, 0x0a,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61,
	0x74, 0x4c, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x61, 0x64, 0x69, 0x75, 0x73, 0x5f, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x72, 0x61, 0x64, 0x69, 0x75, 0x73, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x3c, 0x0a,
	0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x56, 0x69, 0x65, 0x77,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x54, 0x0a, 0x10, 0x72,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x72, 0x79, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x12, 0x2f, 0x0a, 0x11, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x4d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x39, 0x0a, 0x16, 0x65, 0x78, 0x61, 0x63, 0x74, 0x5f, 0x71, 0x75, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x65, 0x78, 0x61, 0x63, 0x74, 0x51, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x12, 0x47, 0x0a,
	0x0b, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x08, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xa5, 0x03, 0x0a, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x4c,
	0x61, 0x79, 0x65, 0x72, 0x73, 0x12, 0x34, 0x0a, 0x0c, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x72, 0x79,
	0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x0b,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x72, 0x79, 0x44, 0x61, 0x74, 0x65, 0x12, 0x47, 0x0a, 0x16, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64,
	0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x14,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64,
	0x44, 0x61, 0x74, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x73, 0x6d, 0x5f, 0x75, 0x72, 0x6c, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x73, 0x6d, 0x55, 0x72, 0x6c, 0x12, 0x17, 0x0a,
	0x07, 0x72, 0x67, 0x62, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x72, 0x67, 0x62, 0x55, 0x72, 0x6c, 0x12, 0x19, 0x0a, 0x08, 0x6d, 0x61, 0x73, 0x6b, 0x5f, 0x75,
	0x72, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x61, 0x73, 0x6b, 0x55, 0x72,
	0x6c, 0x12, 0x26, 0x0a, 0x0f, 0x61, 0x6e, 0x6e, 0x75, 0x61, 0x6c, 0x5f, 0x66, 0x6c, 0x75, 0x78,
	0x5f, 0x75, 0x72, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x6e, 0x6e, 0x75,
	0x61, 0x6c, 0x46, 0x6c, 0x75, 0x78, 0x55, 0x72, 0x6c, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x6f, 0x6e,
	0x74, 0x68, 0x6c, 0x79, 0x5f, 0x66, 0x6c, 0x75, 0x78, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x46, 0x6c, 0x75, 0x78,
	0x55, 0x72, 0x6c, 0x12, 0x2a, 0x0a, 0x11, 0x68, 0x6f, 0x75, 0x72, 0x6c, 0x79, 0x5f, 0x73, 0x68,
	0x61, 0x64, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f,
	0x68, 0x6f, 0x75, 0x72, 0x6c, 0x79, 0x53, 0x68, 0x61, 0x64, 0x65, 0x55, 0x72, 0x6c, 0x73, 0x12,
	0x4d, 0x0a, 0x0f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x72, 0x79, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x72, 0x79, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x0e,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x72, 0x79, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x22, 0x28,
	0x0a, 0x11, 0x47, 0x65, 0x74, 0x47, 0x65, 0x6f, 0x54, 0x69, 0x66, 0x66, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x69, 0x64, 0x2a, 0xa9, 0x01, 0x0a, 0x0d, 0x44, 0x61, 0x74,
	0x61, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1f, 0x0a, 0x1b, 0x44, 0x41,
	0x54, 0x41, 0x5f, 0x4c, 0x41, 0x59, 0x45, 0x52, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x44,
	0x53, 0x4d, 0x5f, 0x4c, 0x41, 0x59, 0x45, 0x52, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4d,
	0x41, 0x47, 0x45, 0x52, 0x59, 0x5f, 0x4c, 0x41, 0x59, 0x45, 0x52, 0x53, 0x10, 0x02, 0x12, 0x22,
	0x0a, 0x1e, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x52, 0x59, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x41, 0x4e,
	0x4e, 0x55, 0x41, 0x4c, 0x5f, 0x46, 0x4c, 0x55, 0x58, 0x5f, 0x4c, 0x41, 0x59, 0x45, 0x52, 0x53,
	0x10, 0x03, 0x12, 0x1f, 0x0a, 0x1b, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x52, 0x59, 0x5f, 0x41, 0x4e,
	0x44, 0x5f, 0x41, 0x4c, 0x4c, 0x5f, 0x46, 0x4c, 0x55, 0x58, 0x5f, 0x4c, 0x41, 0x59, 0x45, 0x52,
	0x53, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x4c, 0x41, 0x59, 0x45,
	0x52, 0x53, 0x10, 0x05, 0x2a, 0x5a, 0x0a, 0x0e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x72, 0x79, 0x51,
	0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x1f, 0x0a, 0x1b, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x52,
	0x59, 0x5f, 0x51, 0x55, 0x41, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x49, 0x47, 0x48, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x02, 0x12, 0x07, 0x0a,
	0x03, 0x4c, 0x4f, 0x57, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x41, 0x53, 0x45, 0x10, 0x04,
	0x2a, 0x5d, 0x0a, 0x15, 0x53, 0x6f, 0x6c, 0x61, 0x72, 0x50, 0x61, 0x6e, 0x65, 0x6c, 0x4f, 0x72,
	0x69, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x23, 0x53, 0x4f, 0x4c,
	0x41, 0x52, 0x5f, 0x50, 0x41, 0x4e, 0x45, 0x4c, 0x5f, 0x4f, 0x52, 0x49, 0x45, 0x4e, 0x54, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4c, 0x41, 0x4e, 0x44, 0x53, 0x43, 0x41, 0x50, 0x45, 0x10,
	0x01, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x4f, 0x52, 0x54, 0x52, 0x41, 0x49, 0x54, 0x10, 0x02, 0x2a,
	0x3f, 0x0a, 0x0a, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1a, 0x0a,
	0x16, 0x45, 0x58, 0x50, 0x45, 0x52, 0x49, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x45, 0x58, 0x50,
	0x41, 0x4e, 0x44, 0x45, 0x44, 0x5f, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x41, 0x47, 0x45, 0x10, 0x01,
	0x32, 0xde, 0x03, 0x0a, 0x05, 0x53, 0x6f, 0x6c, 0x61, 0x72, 0x12, 0xa9, 0x01, 0x0a, 0x1b, 0x46,
	0x69, 0x6e, 0x64, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x73, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x69,
	0x6e, 0x67, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x73, 0x74, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x22, 0x28, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x22, 0x12, 0x20, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x69,
	0x6e, 0x67, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x3a, 0x66, 0x69, 0x6e, 0x64, 0x43,
	0x6c, 0x6f, 0x73, 0x65, 0x73, 0x74, 0x12, 0x79, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x4c,
	0x61, 0x79, 0x65, 0x72, 0x73, 0x22, 0x1a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x14, 0x12, 0x12, 0x2f,
	0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x3a, 0x67, 0x65,
	0x74, 0x12, 0x64, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x47, 0x65, 0x6f, 0x54, 0x69, 0x66, 0x66, 0x12,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f,
	0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x65, 0x6f, 0x54, 0x69, 0x66,
	0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x42, 0x6f, 0x64, 0x79, 0x22, 0x17,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x11, 0x12, 0x0f, 0x2f, 0x76, 0x31, 0x2f, 0x67, 0x65, 0x6f, 0x54,
	0x69, 0x66, 0x66, 0x3a, 0x67, 0x65, 0x74, 0x1a, 0x48, 0xca, 0x41, 0x14, 0x73, 0x6f, 0x6c, 0x61,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x42, 0xb7, 0x01, 0x0a, 0x18, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x11,
	0x53, 0x6f, 0x6c, 0x61, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x34, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x73, 0x6f,
	0x6c, 0x61, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x70,
	0x62, 0x3b, 0x73, 0x6f, 0x6c, 0x61, 0x72, 0x70, 0x62, 0xa2, 0x02, 0x07, 0x47, 0x47, 0x4d, 0x50,
	0x56, 0x31, 0x41, 0xaa, 0x02, 0x14, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x4d, 0x61, 0x70,
	0x73, 0x2e, 0x53, 0x6f, 0x6c, 0x61, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x14, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x4d, 0x61, 0x70, 0x73, 0x5c, 0x53, 0x6f, 0x6c, 0x61, 0x72, 0x5c, 0x56,
	0x31, 0xea, 0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x4d, 0x61, 0x70, 0x73,
	0x3a, 0x3a, 0x53, 0x6f, 0x6c, 0x61, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_maps_solar_v1_solar_service_proto_rawDescOnce sync.Once
	file_google_maps_solar_v1_solar_service_proto_rawDescData = file_google_maps_solar_v1_solar_service_proto_rawDesc
)

func file_google_maps_solar_v1_solar_service_proto_rawDescGZIP() []byte {
	file_google_maps_solar_v1_solar_service_proto_rawDescOnce.Do(func() {
		file_google_maps_solar_v1_solar_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_solar_v1_solar_service_proto_rawDescData)
	})
	return file_google_maps_solar_v1_solar_service_proto_rawDescData
}

var file_google_maps_solar_v1_solar_service_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_maps_solar_v1_solar_service_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_google_maps_solar_v1_solar_service_proto_goTypes = []any{
	(DataLayerView)(0),                         // 0: google.maps.solar.v1.DataLayerView
	(ImageryQuality)(0),                        // 1: google.maps.solar.v1.ImageryQuality
	(SolarPanelOrientation)(0),                 // 2: google.maps.solar.v1.SolarPanelOrientation
	(Experiment)(0),                            // 3: google.maps.solar.v1.Experiment
	(*FindClosestBuildingInsightsRequest)(nil), // 4: google.maps.solar.v1.FindClosestBuildingInsightsRequest
	(*LatLngBox)(nil),                          // 5: google.maps.solar.v1.LatLngBox
	(*BuildingInsights)(nil),                   // 6: google.maps.solar.v1.BuildingInsights
	(*SolarPotential)(nil),                     // 7: google.maps.solar.v1.SolarPotential
	(*RoofSegmentSizeAndSunshineStats)(nil),    // 8: google.maps.solar.v1.RoofSegmentSizeAndSunshineStats
	(*SizeAndSunshineStats)(nil),               // 9: google.maps.solar.v1.SizeAndSunshineStats
	(*SolarPanel)(nil),                         // 10: google.maps.solar.v1.SolarPanel
	(*SolarPanelConfig)(nil),                   // 11: google.maps.solar.v1.SolarPanelConfig
	(*RoofSegmentSummary)(nil),                 // 12: google.maps.solar.v1.RoofSegmentSummary
	(*FinancialAnalysis)(nil),                  // 13: google.maps.solar.v1.FinancialAnalysis
	(*FinancialDetails)(nil),                   // 14: google.maps.solar.v1.FinancialDetails
	(*SavingsOverTime)(nil),                    // 15: google.maps.solar.v1.SavingsOverTime
	(*LeasingSavings)(nil),                     // 16: google.maps.solar.v1.LeasingSavings
	(*CashPurchaseSavings)(nil),                // 17: google.maps.solar.v1.CashPurchaseSavings
	(*FinancedPurchaseSavings)(nil),            // 18: google.maps.solar.v1.FinancedPurchaseSavings
	(*GetDataLayersRequest)(nil),               // 19: google.maps.solar.v1.GetDataLayersRequest
	(*DataLayers)(nil),                         // 20: google.maps.solar.v1.DataLayers
	(*GetGeoTiffRequest)(nil),                  // 21: google.maps.solar.v1.GetGeoTiffRequest
	(*latlng.LatLng)(nil),                      // 22: google.type.LatLng
	(*date.Date)(nil),                          // 23: google.type.Date
	(*money.Money)(nil),                        // 24: google.type.Money
	(*httpbody.HttpBody)(nil),                  // 25: google.api.HttpBody
}
var file_google_maps_solar_v1_solar_service_proto_depIdxs = []int32{
	22, // 0: google.maps.solar.v1.FindClosestBuildingInsightsRequest.location:type_name -> google.type.LatLng
	1,  // 1: google.maps.solar.v1.FindClosestBuildingInsightsRequest.required_quality:type_name -> google.maps.solar.v1.ImageryQuality
	3,  // 2: google.maps.solar.v1.FindClosestBuildingInsightsRequest.experiments:type_name -> google.maps.solar.v1.Experiment
	22, // 3: google.maps.solar.v1.LatLngBox.sw:type_name -> google.type.LatLng
	22, // 4: google.maps.solar.v1.LatLngBox.ne:type_name -> google.type.LatLng
	22, // 5: google.maps.solar.v1.BuildingInsights.center:type_name -> google.type.LatLng
	5,  // 6: google.maps.solar.v1.BuildingInsights.bounding_box:type_name -> google.maps.solar.v1.LatLngBox
	23, // 7: google.maps.solar.v1.BuildingInsights.imagery_date:type_name -> google.type.Date
	23, // 8: google.maps.solar.v1.BuildingInsights.imagery_processed_date:type_name -> google.type.Date
	7,  // 9: google.maps.solar.v1.BuildingInsights.solar_potential:type_name -> google.maps.solar.v1.SolarPotential
	1,  // 10: google.maps.solar.v1.BuildingInsights.imagery_quality:type_name -> google.maps.solar.v1.ImageryQuality
	9,  // 11: google.maps.solar.v1.SolarPotential.whole_roof_stats:type_name -> google.maps.solar.v1.SizeAndSunshineStats
	9,  // 12: google.maps.solar.v1.SolarPotential.building_stats:type_name -> google.maps.solar.v1.SizeAndSunshineStats
	8,  // 13: google.maps.solar.v1.SolarPotential.roof_segment_stats:type_name -> google.maps.solar.v1.RoofSegmentSizeAndSunshineStats
	10, // 14: google.maps.solar.v1.SolarPotential.solar_panels:type_name -> google.maps.solar.v1.SolarPanel
	11, // 15: google.maps.solar.v1.SolarPotential.solar_panel_configs:type_name -> google.maps.solar.v1.SolarPanelConfig
	13, // 16: google.maps.solar.v1.SolarPotential.financial_analyses:type_name -> google.maps.solar.v1.FinancialAnalysis
	9,  // 17: google.maps.solar.v1.RoofSegmentSizeAndSunshineStats.stats:type_name -> google.maps.solar.v1.SizeAndSunshineStats
	22, // 18: google.maps.solar.v1.RoofSegmentSizeAndSunshineStats.center:type_name -> google.type.LatLng
	5,  // 19: google.maps.solar.v1.RoofSegmentSizeAndSunshineStats.bounding_box:type_name -> google.maps.solar.v1.LatLngBox
	22, // 20: google.maps.solar.v1.SolarPanel.center:type_name -> google.type.LatLng
	2,  // 21: google.maps.solar.v1.SolarPanel.orientation:type_name -> google.maps.solar.v1.SolarPanelOrientation
	12, // 22: google.maps.solar.v1.SolarPanelConfig.roof_segment_summaries:type_name -> google.maps.solar.v1.RoofSegmentSummary
	24, // 23: google.maps.solar.v1.FinancialAnalysis.monthly_bill:type_name -> google.type.Money
	14, // 24: google.maps.solar.v1.FinancialAnalysis.financial_details:type_name -> google.maps.solar.v1.FinancialDetails
	16, // 25: google.maps.solar.v1.FinancialAnalysis.leasing_savings:type_name -> google.maps.solar.v1.LeasingSavings
	17, // 26: google.maps.solar.v1.FinancialAnalysis.cash_purchase_savings:type_name -> google.maps.solar.v1.CashPurchaseSavings
	18, // 27: google.maps.solar.v1.FinancialAnalysis.financed_purchase_savings:type_name -> google.maps.solar.v1.FinancedPurchaseSavings
	24, // 28: google.maps.solar.v1.FinancialDetails.remaining_lifetime_utility_bill:type_name -> google.type.Money
	24, // 29: google.maps.solar.v1.FinancialDetails.federal_incentive:type_name -> google.type.Money
	24, // 30: google.maps.solar.v1.FinancialDetails.state_incentive:type_name -> google.type.Money
	24, // 31: google.maps.solar.v1.FinancialDetails.utility_incentive:type_name -> google.type.Money
	24, // 32: google.maps.solar.v1.FinancialDetails.lifetime_srec_total:type_name -> google.type.Money
	24, // 33: google.maps.solar.v1.FinancialDetails.cost_of_electricity_without_solar:type_name -> google.type.Money
	24, // 34: google.maps.solar.v1.SavingsOverTime.savings_year1:type_name -> google.type.Money
	24, // 35: google.maps.solar.v1.SavingsOverTime.savings_year20:type_name -> google.type.Money
	24, // 36: google.maps.solar.v1.SavingsOverTime.present_value_of_savings_year20:type_name -> google.type.Money
	24, // 37: google.maps.solar.v1.SavingsOverTime.savings_lifetime:type_name -> google.type.Money
	24, // 38: google.maps.solar.v1.SavingsOverTime.present_value_of_savings_lifetime:type_name -> google.type.Money
	24, // 39: google.maps.solar.v1.LeasingSavings.annual_leasing_cost:type_name -> google.type.Money
	15, // 40: google.maps.solar.v1.LeasingSavings.savings:type_name -> google.maps.solar.v1.SavingsOverTime
	24, // 41: google.maps.solar.v1.CashPurchaseSavings.out_of_pocket_cost:type_name -> google.type.Money
	24, // 42: google.maps.solar.v1.CashPurchaseSavings.upfront_cost:type_name -> google.type.Money
	24, // 43: google.maps.solar.v1.CashPurchaseSavings.rebate_value:type_name -> google.type.Money
	15, // 44: google.maps.solar.v1.CashPurchaseSavings.savings:type_name -> google.maps.solar.v1.SavingsOverTime
	24, // 45: google.maps.solar.v1.FinancedPurchaseSavings.annual_loan_payment:type_name -> google.type.Money
	24, // 46: google.maps.solar.v1.FinancedPurchaseSavings.rebate_value:type_name -> google.type.Money
	15, // 47: google.maps.solar.v1.FinancedPurchaseSavings.savings:type_name -> google.maps.solar.v1.SavingsOverTime
	22, // 48: google.maps.solar.v1.GetDataLayersRequest.location:type_name -> google.type.LatLng
	0,  // 49: google.maps.solar.v1.GetDataLayersRequest.view:type_name -> google.maps.solar.v1.DataLayerView
	1,  // 50: google.maps.solar.v1.GetDataLayersRequest.required_quality:type_name -> google.maps.solar.v1.ImageryQuality
	3,  // 51: google.maps.solar.v1.GetDataLayersRequest.experiments:type_name -> google.maps.solar.v1.Experiment
	23, // 52: google.maps.solar.v1.DataLayers.imagery_date:type_name -> google.type.Date
	23, // 53: google.maps.solar.v1.DataLayers.imagery_processed_date:type_name -> google.type.Date
	1,  // 54: google.maps.solar.v1.DataLayers.imagery_quality:type_name -> google.maps.solar.v1.ImageryQuality
	4,  // 55: google.maps.solar.v1.Solar.FindClosestBuildingInsights:input_type -> google.maps.solar.v1.FindClosestBuildingInsightsRequest
	19, // 56: google.maps.solar.v1.Solar.GetDataLayers:input_type -> google.maps.solar.v1.GetDataLayersRequest
	21, // 57: google.maps.solar.v1.Solar.GetGeoTiff:input_type -> google.maps.solar.v1.GetGeoTiffRequest
	6,  // 58: google.maps.solar.v1.Solar.FindClosestBuildingInsights:output_type -> google.maps.solar.v1.BuildingInsights
	20, // 59: google.maps.solar.v1.Solar.GetDataLayers:output_type -> google.maps.solar.v1.DataLayers
	25, // 60: google.maps.solar.v1.Solar.GetGeoTiff:output_type -> google.api.HttpBody
	58, // [58:61] is the sub-list for method output_type
	55, // [55:58] is the sub-list for method input_type
	55, // [55:55] is the sub-list for extension type_name
	55, // [55:55] is the sub-list for extension extendee
	0,  // [0:55] is the sub-list for field type_name
}

func init() { file_google_maps_solar_v1_solar_service_proto_init() }
func file_google_maps_solar_v1_solar_service_proto_init() {
	if File_google_maps_solar_v1_solar_service_proto != nil {
		return
	}
	file_google_maps_solar_v1_solar_service_proto_msgTypes[4].OneofWrappers = []any{}
	file_google_maps_solar_v1_solar_service_proto_msgTypes[6].OneofWrappers = []any{}
	file_google_maps_solar_v1_solar_service_proto_msgTypes[8].OneofWrappers = []any{}
	file_google_maps_solar_v1_solar_service_proto_msgTypes[9].OneofWrappers = []any{}
	file_google_maps_solar_v1_solar_service_proto_msgTypes[10].OneofWrappers = []any{}
	file_google_maps_solar_v1_solar_service_proto_msgTypes[13].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_solar_v1_solar_service_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_maps_solar_v1_solar_service_proto_goTypes,
		DependencyIndexes: file_google_maps_solar_v1_solar_service_proto_depIdxs,
		EnumInfos:         file_google_maps_solar_v1_solar_service_proto_enumTypes,
		MessageInfos:      file_google_maps_solar_v1_solar_service_proto_msgTypes,
	}.Build()
	File_google_maps_solar_v1_solar_service_proto = out.File
	file_google_maps_solar_v1_solar_service_proto_rawDesc = nil
	file_google_maps_solar_v1_solar_service_proto_goTypes = nil
	file_google_maps_solar_v1_solar_service_proto_depIdxs = nil
}
