// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/cx/v3beta1/changelog.proto

package cxpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Changelogs_ListChangelogs_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.Changelogs/ListChangelogs"
	Changelogs_GetChangelog_FullMethodName   = "/google.cloud.dialogflow.cx.v3beta1.Changelogs/GetChangelog"
)

// ChangelogsClient is the client API for Changelogs service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ChangelogsClient interface {
	// Returns the list of Changelogs.
	ListChangelogs(ctx context.Context, in *ListChangelogsRequest, opts ...grpc.CallOption) (*ListChangelogsResponse, error)
	// Retrieves the specified Changelog.
	GetChangelog(ctx context.Context, in *GetChangelogRequest, opts ...grpc.CallOption) (*Changelog, error)
}

type changelogsClient struct {
	cc grpc.ClientConnInterface
}

func NewChangelogsClient(cc grpc.ClientConnInterface) ChangelogsClient {
	return &changelogsClient{cc}
}

func (c *changelogsClient) ListChangelogs(ctx context.Context, in *ListChangelogsRequest, opts ...grpc.CallOption) (*ListChangelogsResponse, error) {
	out := new(ListChangelogsResponse)
	err := c.cc.Invoke(ctx, Changelogs_ListChangelogs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *changelogsClient) GetChangelog(ctx context.Context, in *GetChangelogRequest, opts ...grpc.CallOption) (*Changelog, error) {
	out := new(Changelog)
	err := c.cc.Invoke(ctx, Changelogs_GetChangelog_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ChangelogsServer is the server API for Changelogs service.
// All implementations should embed UnimplementedChangelogsServer
// for forward compatibility
type ChangelogsServer interface {
	// Returns the list of Changelogs.
	ListChangelogs(context.Context, *ListChangelogsRequest) (*ListChangelogsResponse, error)
	// Retrieves the specified Changelog.
	GetChangelog(context.Context, *GetChangelogRequest) (*Changelog, error)
}

// UnimplementedChangelogsServer should be embedded to have forward compatible implementations.
type UnimplementedChangelogsServer struct {
}

func (UnimplementedChangelogsServer) ListChangelogs(context.Context, *ListChangelogsRequest) (*ListChangelogsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListChangelogs not implemented")
}
func (UnimplementedChangelogsServer) GetChangelog(context.Context, *GetChangelogRequest) (*Changelog, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetChangelog not implemented")
}

// UnsafeChangelogsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ChangelogsServer will
// result in compilation errors.
type UnsafeChangelogsServer interface {
	mustEmbedUnimplementedChangelogsServer()
}

func RegisterChangelogsServer(s grpc.ServiceRegistrar, srv ChangelogsServer) {
	s.RegisterService(&Changelogs_ServiceDesc, srv)
}

func _Changelogs_ListChangelogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListChangelogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChangelogsServer).ListChangelogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Changelogs_ListChangelogs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChangelogsServer).ListChangelogs(ctx, req.(*ListChangelogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Changelogs_GetChangelog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetChangelogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChangelogsServer).GetChangelog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Changelogs_GetChangelog_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChangelogsServer).GetChangelog(ctx, req.(*GetChangelogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Changelogs_ServiceDesc is the grpc.ServiceDesc for Changelogs service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Changelogs_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.Changelogs",
	HandlerType: (*ChangelogsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListChangelogs",
			Handler:    _Changelogs_ListChangelogs_Handler,
		},
		{
			MethodName: "GetChangelog",
			Handler:    _Changelogs_GetChangelog_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/changelog.proto",
}
