//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetwork

import "time"

// AADAuthenticationParameters - AAD Vpn authentication type related parameters.
type AADAuthenticationParameters struct {
	// AAD Vpn authentication parameter AAD audience.
	AADAudience *string `json:"aadAudience,omitempty"`

	// AAD Vpn authentication parameter AAD issuer.
	AADIssuer *string `json:"aadIssuer,omitempty"`

	// AAD Vpn authentication parameter AAD tenant.
	AADTenant *string `json:"aadTenant,omitempty"`
}

// ActiveBaseSecurityAdminRuleClassification provides polymorphic access to related types.
// Call the interface's GetActiveBaseSecurityAdminRule() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ActiveBaseSecurityAdminRule, *ActiveDefaultSecurityAdminRule, *ActiveSecurityAdminRule
type ActiveBaseSecurityAdminRuleClassification interface {
	// GetActiveBaseSecurityAdminRule returns the ActiveBaseSecurityAdminRule content of the underlying type.
	GetActiveBaseSecurityAdminRule() *ActiveBaseSecurityAdminRule
}

// ActiveBaseSecurityAdminRule - Network base admin rule.
type ActiveBaseSecurityAdminRule struct {
	// REQUIRED; Whether the rule is custom or default.
	Kind *EffectiveAdminRuleKind `json:"kind,omitempty"`

	// Deployment time string.
	CommitTime *time.Time `json:"commitTime,omitempty"`

	// A description of the security admin configuration.
	ConfigurationDescription *string `json:"configurationDescription,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Deployment region.
	Region *string `json:"region,omitempty"`

	// Groups for rule collection
	RuleCollectionAppliesToGroups []*ManagerSecurityGroupItem `json:"ruleCollectionAppliesToGroups,omitempty"`

	// A description of the rule collection.
	RuleCollectionDescription *string `json:"ruleCollectionDescription,omitempty"`

	// Effective configuration groups.
	RuleGroups []*ConfigurationGroup `json:"ruleGroups,omitempty"`
}

// GetActiveBaseSecurityAdminRule implements the ActiveBaseSecurityAdminRuleClassification interface for type ActiveBaseSecurityAdminRule.
func (a *ActiveBaseSecurityAdminRule) GetActiveBaseSecurityAdminRule() *ActiveBaseSecurityAdminRule {
	return a
}

// ActiveConfigurationParameter - Effective Virtual Networks Parameter.
type ActiveConfigurationParameter struct {
	// List of regions.
	Regions []*string `json:"regions,omitempty"`

	// When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current
	// request) to retrieve the next page of data.
	SkipToken *string `json:"skipToken,omitempty"`
}

// ActiveConnectivityConfiguration - Active connectivity configuration.
type ActiveConnectivityConfiguration struct {
	// Deployment time string.
	CommitTime *time.Time `json:"commitTime,omitempty"`

	// Effective configuration groups.
	ConfigurationGroups []*ConfigurationGroup `json:"configurationGroups,omitempty"`

	// Connectivity configuration ID.
	ID *string `json:"id,omitempty"`

	// Properties of a network manager connectivity configuration
	Properties *ConnectivityConfigurationProperties `json:"properties,omitempty"`

	// Deployment region.
	Region *string `json:"region,omitempty"`
}

// ActiveConnectivityConfigurationsListResult - Result of the request to list active connectivity configurations. It contains
// a list of active connectivity configurations and a skiptoken to get the next set of results.
type ActiveConnectivityConfigurationsListResult struct {
	// When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current
	// request) to retrieve the next page of data.
	SkipToken *string `json:"skipToken,omitempty"`

	// Gets a page of active connectivity configurations.
	Value []*ActiveConnectivityConfiguration `json:"value,omitempty"`
}

// ActiveDefaultSecurityAdminRule - Network default admin rule.
type ActiveDefaultSecurityAdminRule struct {
	// REQUIRED; Whether the rule is custom or default.
	Kind *EffectiveAdminRuleKind `json:"kind,omitempty"`

	// Deployment time string.
	CommitTime *time.Time `json:"commitTime,omitempty"`

	// A description of the security admin configuration.
	ConfigurationDescription *string `json:"configurationDescription,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Indicates the properties of the default security admin rule
	Properties *DefaultAdminPropertiesFormat `json:"properties,omitempty"`

	// Deployment region.
	Region *string `json:"region,omitempty"`

	// Groups for rule collection
	RuleCollectionAppliesToGroups []*ManagerSecurityGroupItem `json:"ruleCollectionAppliesToGroups,omitempty"`

	// A description of the rule collection.
	RuleCollectionDescription *string `json:"ruleCollectionDescription,omitempty"`

	// Effective configuration groups.
	RuleGroups []*ConfigurationGroup `json:"ruleGroups,omitempty"`
}

// GetActiveBaseSecurityAdminRule implements the ActiveBaseSecurityAdminRuleClassification interface for type ActiveDefaultSecurityAdminRule.
func (a *ActiveDefaultSecurityAdminRule) GetActiveBaseSecurityAdminRule() *ActiveBaseSecurityAdminRule {
	return &ActiveBaseSecurityAdminRule{
		ID:                            a.ID,
		CommitTime:                    a.CommitTime,
		Region:                        a.Region,
		ConfigurationDescription:      a.ConfigurationDescription,
		RuleCollectionDescription:     a.RuleCollectionDescription,
		RuleCollectionAppliesToGroups: a.RuleCollectionAppliesToGroups,
		RuleGroups:                    a.RuleGroups,
		Kind:                          a.Kind,
	}
}

// ActiveSecurityAdminRule - Network admin rule.
type ActiveSecurityAdminRule struct {
	// REQUIRED; Whether the rule is custom or default.
	Kind *EffectiveAdminRuleKind `json:"kind,omitempty"`

	// Deployment time string.
	CommitTime *time.Time `json:"commitTime,omitempty"`

	// A description of the security admin configuration.
	ConfigurationDescription *string `json:"configurationDescription,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Indicates the properties of the security admin rule
	Properties *AdminPropertiesFormat `json:"properties,omitempty"`

	// Deployment region.
	Region *string `json:"region,omitempty"`

	// Groups for rule collection
	RuleCollectionAppliesToGroups []*ManagerSecurityGroupItem `json:"ruleCollectionAppliesToGroups,omitempty"`

	// A description of the rule collection.
	RuleCollectionDescription *string `json:"ruleCollectionDescription,omitempty"`

	// Effective configuration groups.
	RuleGroups []*ConfigurationGroup `json:"ruleGroups,omitempty"`
}

// GetActiveBaseSecurityAdminRule implements the ActiveBaseSecurityAdminRuleClassification interface for type ActiveSecurityAdminRule.
func (a *ActiveSecurityAdminRule) GetActiveBaseSecurityAdminRule() *ActiveBaseSecurityAdminRule {
	return &ActiveBaseSecurityAdminRule{
		ID:                            a.ID,
		CommitTime:                    a.CommitTime,
		Region:                        a.Region,
		ConfigurationDescription:      a.ConfigurationDescription,
		RuleCollectionDescription:     a.RuleCollectionDescription,
		RuleCollectionAppliesToGroups: a.RuleCollectionAppliesToGroups,
		RuleGroups:                    a.RuleGroups,
		Kind:                          a.Kind,
	}
}

// ActiveSecurityAdminRulesListResult - Result of the request to list active security admin rules. It contains a list of active
// security admin rules and a skiptoken to get the next set of results.
type ActiveSecurityAdminRulesListResult struct {
	// When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current
	// request) to retrieve the next page of data.
	SkipToken *string `json:"skipToken,omitempty"`

	// Gets a page of active security admin rules.
	Value []ActiveBaseSecurityAdminRuleClassification `json:"value,omitempty"`
}

// AddressPrefixItem - Address prefix item.
type AddressPrefixItem struct {
	// Address prefix.
	AddressPrefix *string `json:"addressPrefix,omitempty"`

	// Address prefix type.
	AddressPrefixType *AddressPrefixType `json:"addressPrefixType,omitempty"`
}

// AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.
type AddressSpace struct {
	// A list of address blocks reserved for this virtual network in CIDR notation.
	AddressPrefixes []*string `json:"addressPrefixes,omitempty"`
}

// AdminPropertiesFormat - Security admin rule resource.
type AdminPropertiesFormat struct {
	// REQUIRED; Indicates the access allowed for this particular rule
	Access *SecurityConfigurationRuleAccess `json:"access,omitempty"`

	// REQUIRED; Indicates if the traffic matched against the rule in inbound or outbound.
	Direction *SecurityConfigurationRuleDirection `json:"direction,omitempty"`

	// REQUIRED; The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule
	// in the collection. The lower the priority number, the higher the priority of the rule.
	Priority *int32 `json:"priority,omitempty"`

	// REQUIRED; Network protocol this rule applies to.
	Protocol *SecurityConfigurationRuleProtocol `json:"protocol,omitempty"`

	// A description for this rule. Restricted to 140 chars.
	Description *string `json:"description,omitempty"`

	// The destination port ranges.
	DestinationPortRanges []*string `json:"destinationPortRanges,omitempty"`

	// The destination address prefixes. CIDR or destination IP ranges.
	Destinations []*AddressPrefixItem `json:"destinations,omitempty"`

	// The source port ranges.
	SourcePortRanges []*string `json:"sourcePortRanges,omitempty"`

	// The CIDR or source IP ranges.
	Sources []*AddressPrefixItem `json:"sources,omitempty"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// AdminRule - Network admin rule.
type AdminRule struct {
	// REQUIRED; Whether the rule is custom or default.
	Kind *AdminRuleKind `json:"kind,omitempty"`

	// Indicates the properties of the security admin rule
	Properties *AdminPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetBaseAdminRule implements the BaseAdminRuleClassification interface for type AdminRule.
func (a *AdminRule) GetBaseAdminRule() *BaseAdminRule {
	return &BaseAdminRule{
		Kind:       a.Kind,
		SystemData: a.SystemData,
		ID:         a.ID,
		Name:       a.Name,
		Type:       a.Type,
		Etag:       a.Etag,
	}
}

// AdminRuleCollection - Defines the admin rule collection.
type AdminRuleCollection struct {
	// Indicates the properties for the network manager admin rule collection.
	Properties *AdminRuleCollectionPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AdminRuleCollectionListResult - Security admin configuration rule collection list result.
type AdminRuleCollectionListResult struct {
	// Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of network manager security admin configuration rule collections
	Value []*AdminRuleCollection `json:"value,omitempty"`
}

// AdminRuleCollectionPropertiesFormat - Defines the admin rule collection properties.
type AdminRuleCollectionPropertiesFormat struct {
	// REQUIRED; Groups for configuration
	AppliesToGroups []*ManagerSecurityGroupItem `json:"appliesToGroups,omitempty"`

	// A description of the admin rule collection.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// AdminRuleCollectionsClientBeginDeleteOptions contains the optional parameters for the AdminRuleCollectionsClient.BeginDelete
// method.
type AdminRuleCollectionsClientBeginDeleteOptions struct {
	// Deletes the resource even if it is part of a deployed configuration. If the configuration has been deployed, the service
	// will do a cleanup deployment in the background, prior to the delete.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AdminRuleCollectionsClientCreateOrUpdateOptions contains the optional parameters for the AdminRuleCollectionsClient.CreateOrUpdate
// method.
type AdminRuleCollectionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AdminRuleCollectionsClientGetOptions contains the optional parameters for the AdminRuleCollectionsClient.Get method.
type AdminRuleCollectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AdminRuleCollectionsClientListOptions contains the optional parameters for the AdminRuleCollectionsClient.List method.
type AdminRuleCollectionsClientListOptions struct {
	// SkipToken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skipToken parameter that
	// specifies a starting point to use for subsequent calls.
	SkipToken *string
	// An optional query parameter which specifies the maximum number of records to be returned by the server.
	Top *int32
}

// AdminRuleListResult - security configuration admin rule list result.
type AdminRuleListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of admin rules
	Value []BaseAdminRuleClassification `json:"value,omitempty"`
}

// AdminRulesClientBeginDeleteOptions contains the optional parameters for the AdminRulesClient.BeginDelete method.
type AdminRulesClientBeginDeleteOptions struct {
	// Deletes the resource even if it is part of a deployed configuration. If the configuration has been deployed, the service
	// will do a cleanup deployment in the background, prior to the delete.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AdminRulesClientCreateOrUpdateOptions contains the optional parameters for the AdminRulesClient.CreateOrUpdate method.
type AdminRulesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AdminRulesClientGetOptions contains the optional parameters for the AdminRulesClient.Get method.
type AdminRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// AdminRulesClientListOptions contains the optional parameters for the AdminRulesClient.List method.
type AdminRulesClientListOptions struct {
	// SkipToken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skipToken parameter that
	// specifies a starting point to use for subsequent calls.
	SkipToken *string
	// An optional query parameter which specifies the maximum number of records to be returned by the server.
	Top *int32
}

// ApplicationGateway - Application gateway resource.
type ApplicationGateway struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The identity of the application gateway, if configured.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the application gateway.
	Properties *ApplicationGatewayPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// A list of availability zones denoting where the resource needs to come from.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayAuthenticationCertificate - Authentication certificates of an application gateway.
type ApplicationGatewayAuthenticationCertificate struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the authentication certificate that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway authentication certificate.
	Properties *ApplicationGatewayAuthenticationCertificatePropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayAuthenticationCertificatePropertiesFormat - Authentication certificates properties of an application
// gateway.
type ApplicationGatewayAuthenticationCertificatePropertiesFormat struct {
	// Certificate public data.
	Data *string `json:"data,omitempty"`

	// READ-ONLY; The provisioning state of the authentication certificate resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayAutoscaleConfiguration - Application Gateway autoscale configuration.
type ApplicationGatewayAutoscaleConfiguration struct {
	// REQUIRED; Lower bound on number of Application Gateway capacity.
	MinCapacity *int32 `json:"minCapacity,omitempty"`

	// Upper bound on number of Application Gateway capacity.
	MaxCapacity *int32 `json:"maxCapacity,omitempty"`
}

// ApplicationGatewayAvailableSSLOptions - Response for ApplicationGatewayAvailableSslOptions API service call.
type ApplicationGatewayAvailableSSLOptions struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the application gateway available SSL options.
	Properties *ApplicationGatewayAvailableSSLOptionsPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayAvailableSSLOptionsPropertiesFormat - Properties of ApplicationGatewayAvailableSslOptions.
type ApplicationGatewayAvailableSSLOptionsPropertiesFormat struct {
	// List of available Ssl cipher suites.
	AvailableCipherSuites []*ApplicationGatewaySSLCipherSuite `json:"availableCipherSuites,omitempty"`

	// List of available Ssl protocols.
	AvailableProtocols []*ApplicationGatewaySSLProtocol `json:"availableProtocols,omitempty"`

	// Name of the Ssl predefined policy applied by default to application gateway.
	DefaultPolicy *ApplicationGatewaySSLPolicyName `json:"defaultPolicy,omitempty"`

	// List of available Ssl predefined policy.
	PredefinedPolicies []*SubResource `json:"predefinedPolicies,omitempty"`
}

// ApplicationGatewayAvailableSSLPredefinedPolicies - Response for ApplicationGatewayAvailableSslOptions API service call.
type ApplicationGatewayAvailableSSLPredefinedPolicies struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of available Ssl predefined policy.
	Value []*ApplicationGatewaySSLPredefinedPolicy `json:"value,omitempty"`
}

// ApplicationGatewayAvailableWafRuleSetsResult - Response for ApplicationGatewayAvailableWafRuleSets API service call.
type ApplicationGatewayAvailableWafRuleSetsResult struct {
	// The list of application gateway rule sets.
	Value []*ApplicationGatewayFirewallRuleSet `json:"value,omitempty"`
}

// ApplicationGatewayBackendAddress - Backend address of an application gateway.
type ApplicationGatewayBackendAddress struct {
	// Fully qualified domain name (FQDN).
	Fqdn *string `json:"fqdn,omitempty"`

	// IP address.
	IPAddress *string `json:"ipAddress,omitempty"`
}

// ApplicationGatewayBackendAddressPool - Backend Address Pool of an application gateway.
type ApplicationGatewayBackendAddressPool struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the backend address pool that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway backend address pool.
	Properties *ApplicationGatewayBackendAddressPoolPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayBackendAddressPoolPropertiesFormat - Properties of Backend Address Pool of an application gateway.
type ApplicationGatewayBackendAddressPoolPropertiesFormat struct {
	// Backend addresses.
	BackendAddresses []*ApplicationGatewayBackendAddress `json:"backendAddresses,omitempty"`

	// READ-ONLY; Collection of references to IPs defined in network interfaces.
	BackendIPConfigurations []*InterfaceIPConfiguration `json:"backendIPConfigurations,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the backend address pool resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayBackendHTTPSettings - Backend address pool settings of an application gateway.
type ApplicationGatewayBackendHTTPSettings struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the backend http settings that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway backend HTTP settings.
	Properties *ApplicationGatewayBackendHTTPSettingsPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayBackendHTTPSettingsPropertiesFormat - Properties of Backend address pool settings of an application gateway.
type ApplicationGatewayBackendHTTPSettingsPropertiesFormat struct {
	// Cookie name to use for the affinity cookie.
	AffinityCookieName *string `json:"affinityCookieName,omitempty"`

	// Array of references to application gateway authentication certificates.
	AuthenticationCertificates []*SubResource `json:"authenticationCertificates,omitempty"`

	// Connection draining of the backend http settings resource.
	ConnectionDraining *ApplicationGatewayConnectionDraining `json:"connectionDraining,omitempty"`

	// Cookie based affinity.
	CookieBasedAffinity *ApplicationGatewayCookieBasedAffinity `json:"cookieBasedAffinity,omitempty"`

	// Host header to be sent to the backend servers.
	HostName *string `json:"hostName,omitempty"`

	// Path which should be used as a prefix for all HTTP requests. Null means no path will be prefixed. Default value is null.
	Path *string `json:"path,omitempty"`

	// Whether to pick host header should be picked from the host name of the backend server. Default value is false.
	PickHostNameFromBackendAddress *bool `json:"pickHostNameFromBackendAddress,omitempty"`

	// The destination port on the backend.
	Port *int32 `json:"port,omitempty"`

	// Probe resource of an application gateway.
	Probe *SubResource `json:"probe,omitempty"`

	// Whether the probe is enabled. Default value is false.
	ProbeEnabled *bool `json:"probeEnabled,omitempty"`

	// The protocol used to communicate with the backend.
	Protocol *ApplicationGatewayProtocol `json:"protocol,omitempty"`

	// Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout.
	// Acceptable values are from 1 second to 86400 seconds.
	RequestTimeout *int32 `json:"requestTimeout,omitempty"`

	// Array of references to application gateway trusted root certificates.
	TrustedRootCertificates []*SubResource `json:"trustedRootCertificates,omitempty"`

	// READ-ONLY; The provisioning state of the backend HTTP settings resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayBackendHealth - Response for ApplicationGatewayBackendHealth API service call.
type ApplicationGatewayBackendHealth struct {
	// A list of ApplicationGatewayBackendHealthPool resources.
	BackendAddressPools []*ApplicationGatewayBackendHealthPool `json:"backendAddressPools,omitempty"`
}

// ApplicationGatewayBackendHealthHTTPSettings - Application gateway BackendHealthHttp settings.
type ApplicationGatewayBackendHealthHTTPSettings struct {
	// Reference to an ApplicationGatewayBackendHttpSettings resource.
	BackendHTTPSettings *ApplicationGatewayBackendHTTPSettings `json:"backendHttpSettings,omitempty"`

	// List of ApplicationGatewayBackendHealthServer resources.
	Servers []*ApplicationGatewayBackendHealthServer `json:"servers,omitempty"`
}

// ApplicationGatewayBackendHealthOnDemand - Result of on demand test probe.
type ApplicationGatewayBackendHealthOnDemand struct {
	// Reference to an ApplicationGatewayBackendAddressPool resource.
	BackendAddressPool *ApplicationGatewayBackendAddressPool `json:"backendAddressPool,omitempty"`

	// Application gateway BackendHealthHttp settings.
	BackendHealthHTTPSettings *ApplicationGatewayBackendHealthHTTPSettings `json:"backendHealthHttpSettings,omitempty"`
}

// ApplicationGatewayBackendHealthPool - Application gateway BackendHealth pool.
type ApplicationGatewayBackendHealthPool struct {
	// Reference to an ApplicationGatewayBackendAddressPool resource.
	BackendAddressPool *ApplicationGatewayBackendAddressPool `json:"backendAddressPool,omitempty"`

	// List of ApplicationGatewayBackendHealthHttpSettings resources.
	BackendHTTPSettingsCollection []*ApplicationGatewayBackendHealthHTTPSettings `json:"backendHttpSettingsCollection,omitempty"`
}

// ApplicationGatewayBackendHealthServer - Application gateway backendhealth http settings.
type ApplicationGatewayBackendHealthServer struct {
	// IP address or FQDN of backend server.
	Address *string `json:"address,omitempty"`

	// Health of backend server.
	Health *ApplicationGatewayBackendHealthServerHealth `json:"health,omitempty"`

	// Health Probe Log.
	HealthProbeLog *string `json:"healthProbeLog,omitempty"`

	// Reference to IP configuration of backend server.
	IPConfiguration *InterfaceIPConfiguration `json:"ipConfiguration,omitempty"`
}

// ApplicationGatewayBackendSettings - Backend address pool settings of an application gateway.
type ApplicationGatewayBackendSettings struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the backend settings that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway backend settings.
	Properties *ApplicationGatewayBackendSettingsPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayBackendSettingsPropertiesFormat - Properties of Backend address pool settings of an application gateway.
type ApplicationGatewayBackendSettingsPropertiesFormat struct {
	// Server name indication to be sent to the backend servers for Tls protocol.
	HostName *string `json:"hostName,omitempty"`

	// Whether to pick server name indication from the host name of the backend server for Tls protocol. Default value is false.
	PickHostNameFromBackendAddress *bool `json:"pickHostNameFromBackendAddress,omitempty"`

	// The destination port on the backend.
	Port *int32 `json:"port,omitempty"`

	// Probe resource of an application gateway.
	Probe *SubResource `json:"probe,omitempty"`

	// The protocol used to communicate with the backend.
	Protocol *ApplicationGatewayProtocol `json:"protocol,omitempty"`

	// Connection timeout in seconds. Application Gateway will fail the request if response is not received within ConnectionTimeout.
	// Acceptable values are from 1 second to 86400 seconds.
	Timeout *int32 `json:"timeout,omitempty"`

	// Array of references to application gateway trusted root certificates.
	TrustedRootCertificates []*SubResource `json:"trustedRootCertificates,omitempty"`

	// READ-ONLY; The provisioning state of the backend HTTP settings resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayClientAuthConfiguration - Application gateway client authentication configuration.
type ApplicationGatewayClientAuthConfiguration struct {
	// Verify client certificate issuer name on the application gateway.
	VerifyClientCertIssuerDN *bool `json:"verifyClientCertIssuerDN,omitempty"`
}

// ApplicationGatewayConnectionDraining - Connection draining allows open connections to a backend server to be active for
// a specified time after the backend server got removed from the configuration.
type ApplicationGatewayConnectionDraining struct {
	// REQUIRED; The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds.
	DrainTimeoutInSec *int32 `json:"drainTimeoutInSec,omitempty"`

	// REQUIRED; Whether connection draining is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
}

// ApplicationGatewayCustomError - Customer error of an application gateway.
type ApplicationGatewayCustomError struct {
	// Error page URL of the application gateway customer error.
	CustomErrorPageURL *string `json:"customErrorPageUrl,omitempty"`

	// Status code of the application gateway customer error.
	StatusCode *ApplicationGatewayCustomErrorStatusCode `json:"statusCode,omitempty"`
}

// ApplicationGatewayFirewallDisabledRuleGroup - Allows to disable rules within a rule group or an entire rule group.
type ApplicationGatewayFirewallDisabledRuleGroup struct {
	// REQUIRED; The name of the rule group that will be disabled.
	RuleGroupName *string `json:"ruleGroupName,omitempty"`

	// The list of rules that will be disabled. If null, all rules of the rule group will be disabled.
	Rules []*int32 `json:"rules,omitempty"`
}

// ApplicationGatewayFirewallExclusion - Allow to exclude some variable satisfy the condition for the WAF check.
type ApplicationGatewayFirewallExclusion struct {
	// REQUIRED; The variable to be excluded.
	MatchVariable *string `json:"matchVariable,omitempty"`

	// REQUIRED; When matchVariable is a collection, operator used to specify which elements in the collection this exclusion
	// applies to.
	Selector *string `json:"selector,omitempty"`

	// REQUIRED; When matchVariable is a collection, operate on the selector to specify which elements in the collection this
	// exclusion applies to.
	SelectorMatchOperator *string `json:"selectorMatchOperator,omitempty"`
}

// ApplicationGatewayFirewallRule - A web application firewall rule.
type ApplicationGatewayFirewallRule struct {
	// REQUIRED; The identifier of the web application firewall rule.
	RuleID *int32 `json:"ruleId,omitempty"`

	// The description of the web application firewall rule.
	Description *string `json:"description,omitempty"`
}

// ApplicationGatewayFirewallRuleGroup - A web application firewall rule group.
type ApplicationGatewayFirewallRuleGroup struct {
	// REQUIRED; The name of the web application firewall rule group.
	RuleGroupName *string `json:"ruleGroupName,omitempty"`

	// REQUIRED; The rules of the web application firewall rule group.
	Rules []*ApplicationGatewayFirewallRule `json:"rules,omitempty"`

	// The description of the web application firewall rule group.
	Description *string `json:"description,omitempty"`
}

// ApplicationGatewayFirewallRuleSet - A web application firewall rule set.
type ApplicationGatewayFirewallRuleSet struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the application gateway firewall rule set.
	Properties *ApplicationGatewayFirewallRuleSetPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayFirewallRuleSetPropertiesFormat - Properties of the web application firewall rule set.
type ApplicationGatewayFirewallRuleSetPropertiesFormat struct {
	// REQUIRED; The rule groups of the web application firewall rule set.
	RuleGroups []*ApplicationGatewayFirewallRuleGroup `json:"ruleGroups,omitempty"`

	// REQUIRED; The type of the web application firewall rule set.
	RuleSetType *string `json:"ruleSetType,omitempty"`

	// REQUIRED; The version of the web application firewall rule set type.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty"`

	// READ-ONLY; The provisioning state of the web application firewall rule set.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayFrontendIPConfiguration - Frontend IP configuration of an application gateway.
type ApplicationGatewayFrontendIPConfiguration struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the frontend IP configuration that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway frontend IP configuration.
	Properties *ApplicationGatewayFrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayFrontendIPConfigurationPropertiesFormat - Properties of Frontend IP configuration of an application gateway.
type ApplicationGatewayFrontendIPConfigurationPropertiesFormat struct {
	// PrivateIPAddress of the network interface IP Configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`

	// The private IP address allocation method.
	PrivateIPAllocationMethod *IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`

	// Reference to the application gateway private link configuration.
	PrivateLinkConfiguration *SubResource `json:"privateLinkConfiguration,omitempty"`

	// Reference to the PublicIP resource.
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`

	// Reference to the subnet resource.
	Subnet *SubResource `json:"subnet,omitempty"`

	// READ-ONLY; The provisioning state of the frontend IP configuration resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayFrontendPort - Frontend port of an application gateway.
type ApplicationGatewayFrontendPort struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the frontend port that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway frontend port.
	Properties *ApplicationGatewayFrontendPortPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayFrontendPortPropertiesFormat - Properties of Frontend port of an application gateway.
type ApplicationGatewayFrontendPortPropertiesFormat struct {
	// Frontend port.
	Port *int32 `json:"port,omitempty"`

	// READ-ONLY; The provisioning state of the frontend port resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayGlobalConfiguration - Application Gateway global configuration.
type ApplicationGatewayGlobalConfiguration struct {
	// Enable request buffering.
	EnableRequestBuffering *bool `json:"enableRequestBuffering,omitempty"`

	// Enable response buffering.
	EnableResponseBuffering *bool `json:"enableResponseBuffering,omitempty"`
}

// ApplicationGatewayHTTPListener - Http listener of an application gateway.
type ApplicationGatewayHTTPListener struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the HTTP listener that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway HTTP listener.
	Properties *ApplicationGatewayHTTPListenerPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayHTTPListenerPropertiesFormat - Properties of HTTP listener of an application gateway.
type ApplicationGatewayHTTPListenerPropertiesFormat struct {
	// Custom error configurations of the HTTP listener.
	CustomErrorConfigurations []*ApplicationGatewayCustomError `json:"customErrorConfigurations,omitempty"`

	// Reference to the FirewallPolicy resource.
	FirewallPolicy *SubResource `json:"firewallPolicy,omitempty"`

	// Frontend IP configuration resource of an application gateway.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`

	// Frontend port resource of an application gateway.
	FrontendPort *SubResource `json:"frontendPort,omitempty"`

	// Host name of HTTP listener.
	HostName *string `json:"hostName,omitempty"`

	// List of Host names for HTTP Listener that allows special wildcard characters as well.
	HostNames []*string `json:"hostNames,omitempty"`

	// Protocol of the HTTP listener.
	Protocol *ApplicationGatewayProtocol `json:"protocol,omitempty"`

	// Applicable only if protocol is https. Enables SNI for multi-hosting.
	RequireServerNameIndication *bool `json:"requireServerNameIndication,omitempty"`

	// SSL certificate resource of an application gateway.
	SSLCertificate *SubResource `json:"sslCertificate,omitempty"`

	// SSL profile resource of the application gateway.
	SSLProfile *SubResource `json:"sslProfile,omitempty"`

	// READ-ONLY; The provisioning state of the HTTP listener resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayHeaderConfiguration - Header configuration of the Actions set in Application Gateway.
type ApplicationGatewayHeaderConfiguration struct {
	// Header name of the header configuration.
	HeaderName *string `json:"headerName,omitempty"`

	// Header value of the header configuration.
	HeaderValue *string `json:"headerValue,omitempty"`
}

// ApplicationGatewayIPConfiguration - IP configuration of an application gateway. Currently 1 public and 1 private IP configuration
// is allowed.
type ApplicationGatewayIPConfiguration struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the IP configuration that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway IP configuration.
	Properties *ApplicationGatewayIPConfigurationPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayIPConfigurationPropertiesFormat - Properties of IP configuration of an application gateway.
type ApplicationGatewayIPConfigurationPropertiesFormat struct {
	// Reference to the subnet resource. A subnet from where application gateway gets its private address.
	Subnet *SubResource `json:"subnet,omitempty"`

	// READ-ONLY; The provisioning state of the application gateway IP configuration resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayListResult - Response for ListApplicationGateways API service call.
type ApplicationGatewayListResult struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of an application gateways in a resource group.
	Value []*ApplicationGateway `json:"value,omitempty"`
}

// ApplicationGatewayListener - Listener of an application gateway.
type ApplicationGatewayListener struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the listener that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway listener.
	Properties *ApplicationGatewayListenerPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayListenerPropertiesFormat - Properties of listener of an application gateway.
type ApplicationGatewayListenerPropertiesFormat struct {
	// Frontend IP configuration resource of an application gateway.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`

	// Frontend port resource of an application gateway.
	FrontendPort *SubResource `json:"frontendPort,omitempty"`

	// Protocol of the listener.
	Protocol *ApplicationGatewayProtocol `json:"protocol,omitempty"`

	// SSL certificate resource of an application gateway.
	SSLCertificate *SubResource `json:"sslCertificate,omitempty"`

	// SSL profile resource of the application gateway.
	SSLProfile *SubResource `json:"sslProfile,omitempty"`

	// READ-ONLY; The provisioning state of the listener resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayLoadDistributionPolicy - Load Distribution Policy of an application gateway.
type ApplicationGatewayLoadDistributionPolicy struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the load distribution policy that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway load distribution policy.
	Properties *ApplicationGatewayLoadDistributionPolicyPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayLoadDistributionPolicyPropertiesFormat - Properties of Load Distribution Policy of an application gateway.
type ApplicationGatewayLoadDistributionPolicyPropertiesFormat struct {
	// Load Distribution Targets resource of an application gateway.
	LoadDistributionAlgorithm *ApplicationGatewayLoadDistributionAlgorithm `json:"loadDistributionAlgorithm,omitempty"`

	// Load Distribution Targets resource of an application gateway.
	LoadDistributionTargets []*ApplicationGatewayLoadDistributionTarget `json:"loadDistributionTargets,omitempty"`

	// READ-ONLY; The provisioning state of the Load Distribution Policy resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayLoadDistributionTarget - Load Distribution Target of an application gateway.
type ApplicationGatewayLoadDistributionTarget struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the load distribution policy that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway load distribution target.
	Properties *ApplicationGatewayLoadDistributionTargetPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

type ApplicationGatewayLoadDistributionTargetPropertiesFormat struct {
	// Backend address pool resource of the application gateway.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`

	// Weight per server. Range between 1 and 100.
	WeightPerServer *int32 `json:"weightPerServer,omitempty"`
}

// ApplicationGatewayOnDemandProbe - Details of on demand test probe request.
type ApplicationGatewayOnDemandProbe struct {
	// Reference to backend pool of application gateway to which probe request will be sent.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`

	// Reference to backend http setting of application gateway to be used for test probe.
	BackendHTTPSettings *SubResource `json:"backendHttpSettings,omitempty"`

	// Host name to send the probe to.
	Host *string `json:"host,omitempty"`

	// Criterion for classifying a healthy probe response.
	Match *ApplicationGatewayProbeHealthResponseMatch `json:"match,omitempty"`

	// Relative path of probe. Valid path starts from '/'. Probe is sent to ://:.
	Path *string `json:"path,omitempty"`

	// Whether the host header should be picked from the backend http settings. Default value is false.
	PickHostNameFromBackendHTTPSettings *bool `json:"pickHostNameFromBackendHttpSettings,omitempty"`

	// The protocol used for the probe.
	Protocol *ApplicationGatewayProtocol `json:"protocol,omitempty"`

	// The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable
	// values are from 1 second to 86400 seconds.
	Timeout *int32 `json:"timeout,omitempty"`
}

// ApplicationGatewayPathRule - Path rule of URL path map of an application gateway.
type ApplicationGatewayPathRule struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the path rule that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway path rule.
	Properties *ApplicationGatewayPathRulePropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayPathRulePropertiesFormat - Properties of path rule of an application gateway.
type ApplicationGatewayPathRulePropertiesFormat struct {
	// Backend address pool resource of URL path map path rule.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`

	// Backend http settings resource of URL path map path rule.
	BackendHTTPSettings *SubResource `json:"backendHttpSettings,omitempty"`

	// Reference to the FirewallPolicy resource.
	FirewallPolicy *SubResource `json:"firewallPolicy,omitempty"`

	// Load Distribution Policy resource of URL path map path rule.
	LoadDistributionPolicy *SubResource `json:"loadDistributionPolicy,omitempty"`

	// Path rules of URL path map.
	Paths []*string `json:"paths,omitempty"`

	// Redirect configuration resource of URL path map path rule.
	RedirectConfiguration *SubResource `json:"redirectConfiguration,omitempty"`

	// Rewrite rule set resource of URL path map path rule.
	RewriteRuleSet *SubResource `json:"rewriteRuleSet,omitempty"`

	// READ-ONLY; The provisioning state of the path rule resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayPrivateEndpointConnection - Private Endpoint connection on an application gateway.
type ApplicationGatewayPrivateEndpointConnection struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the private endpoint connection on an application gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway private endpoint connection.
	Properties *ApplicationGatewayPrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayPrivateEndpointConnectionListResult - Response for ListApplicationGatewayPrivateEndpointConnection API
// service call. Gets all private endpoint connections for an application gateway.
type ApplicationGatewayPrivateEndpointConnectionListResult struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of private endpoint connections on an application gateway.
	Value []*ApplicationGatewayPrivateEndpointConnection `json:"value,omitempty"`
}

// ApplicationGatewayPrivateEndpointConnectionProperties - Properties of Private Link Resource of an application gateway.
type ApplicationGatewayPrivateEndpointConnectionProperties struct {
	// A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// READ-ONLY; The consumer link id.
	LinkIdentifier *string `json:"linkIdentifier,omitempty" azure:"ro"`

	// READ-ONLY; The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the application gateway private endpoint connection resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayPrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the ApplicationGatewayPrivateEndpointConnectionsClient.BeginDelete
// method.
type ApplicationGatewayPrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationGatewayPrivateEndpointConnectionsClientBeginUpdateOptions contains the optional parameters for the ApplicationGatewayPrivateEndpointConnectionsClient.BeginUpdate
// method.
type ApplicationGatewayPrivateEndpointConnectionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationGatewayPrivateEndpointConnectionsClientGetOptions contains the optional parameters for the ApplicationGatewayPrivateEndpointConnectionsClient.Get
// method.
type ApplicationGatewayPrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGatewayPrivateEndpointConnectionsClientListOptions contains the optional parameters for the ApplicationGatewayPrivateEndpointConnectionsClient.List
// method.
type ApplicationGatewayPrivateEndpointConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGatewayPrivateLinkConfiguration - Private Link Configuration on an application gateway.
type ApplicationGatewayPrivateLinkConfiguration struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the private link configuration that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway private link configuration.
	Properties *ApplicationGatewayPrivateLinkConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayPrivateLinkConfigurationProperties - Properties of private link configuration on an application gateway.
type ApplicationGatewayPrivateLinkConfigurationProperties struct {
	// An array of application gateway private link ip configurations.
	IPConfigurations []*ApplicationGatewayPrivateLinkIPConfiguration `json:"ipConfigurations,omitempty"`

	// READ-ONLY; The provisioning state of the application gateway private link configuration.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayPrivateLinkIPConfiguration - The application gateway private link ip configuration.
type ApplicationGatewayPrivateLinkIPConfiguration struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of application gateway private link ip configuration.
	Name *string `json:"name,omitempty"`

	// Properties of an application gateway private link ip configuration.
	Properties *ApplicationGatewayPrivateLinkIPConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayPrivateLinkIPConfigurationProperties - Properties of an application gateway private link IP configuration.
type ApplicationGatewayPrivateLinkIPConfigurationProperties struct {
	// Whether the ip configuration is primary or not.
	Primary *bool `json:"primary,omitempty"`

	// The private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`

	// The private IP address allocation method.
	PrivateIPAllocationMethod *IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`

	// Reference to the subnet resource.
	Subnet *SubResource `json:"subnet,omitempty"`

	// READ-ONLY; The provisioning state of the application gateway private link IP configuration.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayPrivateLinkResource - PrivateLink Resource of an application gateway.
type ApplicationGatewayPrivateLinkResource struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the private link resource that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway private link resource.
	Properties *ApplicationGatewayPrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayPrivateLinkResourceListResult - Response for ListApplicationGatewayPrivateLinkResources API service call.
// Gets all private link resources for an application gateway.
type ApplicationGatewayPrivateLinkResourceListResult struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of private link resources of an application gateway.
	Value []*ApplicationGatewayPrivateLinkResource `json:"value,omitempty"`
}

// ApplicationGatewayPrivateLinkResourceProperties - Properties of a private link resource.
type ApplicationGatewayPrivateLinkResourceProperties struct {
	// Required DNS zone names of the the private link resource.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; Group identifier of private link resource.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; Required member names of private link resource.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// ApplicationGatewayPrivateLinkResourcesClientListOptions contains the optional parameters for the ApplicationGatewayPrivateLinkResourcesClient.List
// method.
type ApplicationGatewayPrivateLinkResourcesClientListOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGatewayProbe - Probe of the application gateway.
type ApplicationGatewayProbe struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the probe that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway probe.
	Properties *ApplicationGatewayProbePropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayProbeHealthResponseMatch - Application gateway probe health response match.
type ApplicationGatewayProbeHealthResponseMatch struct {
	// Body that must be contained in the health response. Default value is empty.
	Body *string `json:"body,omitempty"`

	// Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
	StatusCodes []*string `json:"statusCodes,omitempty"`
}

// ApplicationGatewayProbePropertiesFormat - Properties of probe of an application gateway.
type ApplicationGatewayProbePropertiesFormat struct {
	// Host name to send the probe to.
	Host *string `json:"host,omitempty"`

	// The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1
	// second to 86400 seconds.
	Interval *int32 `json:"interval,omitempty"`

	// Criterion for classifying a healthy probe response.
	Match *ApplicationGatewayProbeHealthResponseMatch `json:"match,omitempty"`

	// Minimum number of servers that are always marked healthy. Default value is 0.
	MinServers *int32 `json:"minServers,omitempty"`

	// Relative path of probe. Valid path starts from '/'. Probe is sent to ://:.
	Path *string `json:"path,omitempty"`

	// Whether the host header should be picked from the backend http settings. Default value is false.
	PickHostNameFromBackendHTTPSettings *bool `json:"pickHostNameFromBackendHttpSettings,omitempty"`

	// Whether the server name indication should be picked from the backend settings for Tls protocol. Default value is false.
	PickHostNameFromBackendSettings *bool `json:"pickHostNameFromBackendSettings,omitempty"`

	// Custom port which will be used for probing the backend servers. The valid value ranges from 1 to 65535. In case not set,
	// port from http settings will be used. This property is valid for Standardv2 and
	// WAFv2 only.
	Port *int32 `json:"port,omitempty"`

	// The protocol used for the probe.
	Protocol *ApplicationGatewayProtocol `json:"protocol,omitempty"`

	// The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable
	// values are from 1 second to 86400 seconds.
	Timeout *int32 `json:"timeout,omitempty"`

	// The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold.
	// Acceptable values are from 1 second to 20.
	UnhealthyThreshold *int32 `json:"unhealthyThreshold,omitempty"`

	// READ-ONLY; The provisioning state of the probe resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayPropertiesFormat - Properties of the application gateway.
type ApplicationGatewayPropertiesFormat struct {
	// Authentication certificates of the application gateway resource. For default limits, see Application Gateway limits
	// [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	AuthenticationCertificates []*ApplicationGatewayAuthenticationCertificate `json:"authenticationCertificates,omitempty"`

	// Autoscale Configuration.
	AutoscaleConfiguration *ApplicationGatewayAutoscaleConfiguration `json:"autoscaleConfiguration,omitempty"`

	// Backend address pool of the application gateway resource. For default limits, see Application Gateway limits
	// [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	BackendAddressPools []*ApplicationGatewayBackendAddressPool `json:"backendAddressPools,omitempty"`

	// Backend http settings of the application gateway resource. For default limits, see Application Gateway limits
	// [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	BackendHTTPSettingsCollection []*ApplicationGatewayBackendHTTPSettings `json:"backendHttpSettingsCollection,omitempty"`

	// Backend settings of the application gateway resource. For default limits, see Application Gateway limits [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits]
	// .
	BackendSettingsCollection []*ApplicationGatewayBackendSettings `json:"backendSettingsCollection,omitempty"`

	// Custom error configurations of the application gateway resource.
	CustomErrorConfigurations []*ApplicationGatewayCustomError `json:"customErrorConfigurations,omitempty"`

	// Whether FIPS is enabled on the application gateway resource.
	EnableFips *bool `json:"enableFips,omitempty"`

	// Whether HTTP2 is enabled on the application gateway resource.
	EnableHTTP2 *bool `json:"enableHttp2,omitempty"`

	// Reference to the FirewallPolicy resource.
	FirewallPolicy *SubResource `json:"firewallPolicy,omitempty"`

	// If true, associates a firewall policy with an application gateway regardless whether the policy differs from the WAF Config.
	ForceFirewallPolicyAssociation *bool `json:"forceFirewallPolicyAssociation,omitempty"`

	// Frontend IP addresses of the application gateway resource. For default limits, see Application Gateway limits
	// [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	FrontendIPConfigurations []*ApplicationGatewayFrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`

	// Frontend ports of the application gateway resource. For default limits, see Application Gateway limits [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	FrontendPorts []*ApplicationGatewayFrontendPort `json:"frontendPorts,omitempty"`

	// Subnets of the application gateway resource. For default limits, see Application Gateway limits [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	GatewayIPConfigurations []*ApplicationGatewayIPConfiguration `json:"gatewayIPConfigurations,omitempty"`

	// Global Configuration.
	GlobalConfiguration *ApplicationGatewayGlobalConfiguration `json:"globalConfiguration,omitempty"`

	// Http listeners of the application gateway resource. For default limits, see Application Gateway limits [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	HTTPListeners []*ApplicationGatewayHTTPListener `json:"httpListeners,omitempty"`

	// Listeners of the application gateway resource. For default limits, see Application Gateway limits [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	Listeners []*ApplicationGatewayListener `json:"listeners,omitempty"`

	// Load distribution policies of the application gateway resource.
	LoadDistributionPolicies []*ApplicationGatewayLoadDistributionPolicy `json:"loadDistributionPolicies,omitempty"`

	// PrivateLink configurations on application gateway.
	PrivateLinkConfigurations []*ApplicationGatewayPrivateLinkConfiguration `json:"privateLinkConfigurations,omitempty"`

	// Probes of the application gateway resource.
	Probes []*ApplicationGatewayProbe `json:"probes,omitempty"`

	// Redirect configurations of the application gateway resource. For default limits, see Application Gateway limits
	// [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	RedirectConfigurations []*ApplicationGatewayRedirectConfiguration `json:"redirectConfigurations,omitempty"`

	// Request routing rules of the application gateway resource.
	RequestRoutingRules []*ApplicationGatewayRequestRoutingRule `json:"requestRoutingRules,omitempty"`

	// Rewrite rules for the application gateway resource.
	RewriteRuleSets []*ApplicationGatewayRewriteRuleSet `json:"rewriteRuleSets,omitempty"`

	// Routing rules of the application gateway resource.
	RoutingRules []*ApplicationGatewayRoutingRule `json:"routingRules,omitempty"`

	// SKU of the application gateway resource.
	SKU *ApplicationGatewaySKU `json:"sku,omitempty"`

	// SSL certificates of the application gateway resource. For default limits, see Application Gateway limits [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits]
	// .
	SSLCertificates []*ApplicationGatewaySSLCertificate `json:"sslCertificates,omitempty"`

	// SSL policy of the application gateway resource.
	SSLPolicy *ApplicationGatewaySSLPolicy `json:"sslPolicy,omitempty"`

	// SSL profiles of the application gateway resource. For default limits, see Application Gateway limits [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	SSLProfiles []*ApplicationGatewaySSLProfile `json:"sslProfiles,omitempty"`

	// Trusted client certificates of the application gateway resource. For default limits, see Application Gateway limits
	// [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	TrustedClientCertificates []*ApplicationGatewayTrustedClientCertificate `json:"trustedClientCertificates,omitempty"`

	// Trusted Root certificates of the application gateway resource. For default limits, see Application Gateway limits
	// [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	TrustedRootCertificates []*ApplicationGatewayTrustedRootCertificate `json:"trustedRootCertificates,omitempty"`

	// URL path map of the application gateway resource. For default limits, see Application Gateway limits [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	URLPathMaps []*ApplicationGatewayURLPathMap `json:"urlPathMaps,omitempty"`

	// Web application firewall configuration.
	WebApplicationFirewallConfiguration *ApplicationGatewayWebApplicationFirewallConfiguration `json:"webApplicationFirewallConfiguration,omitempty"`

	// READ-ONLY; Operational state of the application gateway resource.
	OperationalState *ApplicationGatewayOperationalState `json:"operationalState,omitempty" azure:"ro"`

	// READ-ONLY; Private Endpoint connections on application gateway.
	PrivateEndpointConnections []*ApplicationGatewayPrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the application gateway resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the application gateway resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`
}

// ApplicationGatewayRedirectConfiguration - Redirect configuration of an application gateway.
type ApplicationGatewayRedirectConfiguration struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the redirect configuration that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway redirect configuration.
	Properties *ApplicationGatewayRedirectConfigurationPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayRedirectConfigurationPropertiesFormat - Properties of redirect configuration of the application gateway.
type ApplicationGatewayRedirectConfigurationPropertiesFormat struct {
	// Include path in the redirected url.
	IncludePath *bool `json:"includePath,omitempty"`

	// Include query string in the redirected url.
	IncludeQueryString *bool `json:"includeQueryString,omitempty"`

	// Path rules specifying redirect configuration.
	PathRules []*SubResource `json:"pathRules,omitempty"`

	// HTTP redirection type.
	RedirectType *ApplicationGatewayRedirectType `json:"redirectType,omitempty"`

	// Request routing specifying redirect configuration.
	RequestRoutingRules []*SubResource `json:"requestRoutingRules,omitempty"`

	// Reference to a listener to redirect the request to.
	TargetListener *SubResource `json:"targetListener,omitempty"`

	// Url to redirect the request to.
	TargetURL *string `json:"targetUrl,omitempty"`

	// Url path maps specifying default redirect configuration.
	URLPathMaps []*SubResource `json:"urlPathMaps,omitempty"`
}

// ApplicationGatewayRequestRoutingRule - Request routing rule of an application gateway.
type ApplicationGatewayRequestRoutingRule struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the request routing rule that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway request routing rule.
	Properties *ApplicationGatewayRequestRoutingRulePropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayRequestRoutingRulePropertiesFormat - Properties of request routing rule of the application gateway.
type ApplicationGatewayRequestRoutingRulePropertiesFormat struct {
	// Backend address pool resource of the application gateway.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`

	// Backend http settings resource of the application gateway.
	BackendHTTPSettings *SubResource `json:"backendHttpSettings,omitempty"`

	// Http listener resource of the application gateway.
	HTTPListener *SubResource `json:"httpListener,omitempty"`

	// Load Distribution Policy resource of the application gateway.
	LoadDistributionPolicy *SubResource `json:"loadDistributionPolicy,omitempty"`

	// Priority of the request routing rule.
	Priority *int32 `json:"priority,omitempty"`

	// Redirect configuration resource of the application gateway.
	RedirectConfiguration *SubResource `json:"redirectConfiguration,omitempty"`

	// Rewrite Rule Set resource in Basic rule of the application gateway.
	RewriteRuleSet *SubResource `json:"rewriteRuleSet,omitempty"`

	// Rule type.
	RuleType *ApplicationGatewayRequestRoutingRuleType `json:"ruleType,omitempty"`

	// URL path map resource of the application gateway.
	URLPathMap *SubResource `json:"urlPathMap,omitempty"`

	// READ-ONLY; The provisioning state of the request routing rule resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayRewriteRule - Rewrite rule of an application gateway.
type ApplicationGatewayRewriteRule struct {
	// Set of actions to be done as part of the rewrite Rule.
	ActionSet *ApplicationGatewayRewriteRuleActionSet `json:"actionSet,omitempty"`

	// Conditions based on which the action set execution will be evaluated.
	Conditions []*ApplicationGatewayRewriteRuleCondition `json:"conditions,omitempty"`

	// Name of the rewrite rule that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Rule Sequence of the rewrite rule that determines the order of execution of a particular rule in a RewriteRuleSet.
	RuleSequence *int32 `json:"ruleSequence,omitempty"`
}

// ApplicationGatewayRewriteRuleActionSet - Set of actions in the Rewrite Rule in Application Gateway.
type ApplicationGatewayRewriteRuleActionSet struct {
	// Request Header Actions in the Action Set.
	RequestHeaderConfigurations []*ApplicationGatewayHeaderConfiguration `json:"requestHeaderConfigurations,omitempty"`

	// Response Header Actions in the Action Set.
	ResponseHeaderConfigurations []*ApplicationGatewayHeaderConfiguration `json:"responseHeaderConfigurations,omitempty"`

	// Url Configuration Action in the Action Set.
	URLConfiguration *ApplicationGatewayURLConfiguration `json:"urlConfiguration,omitempty"`
}

// ApplicationGatewayRewriteRuleCondition - Set of conditions in the Rewrite Rule in Application Gateway.
type ApplicationGatewayRewriteRuleCondition struct {
	// Setting this parameter to truth value with force the pattern to do a case in-sensitive comparison.
	IgnoreCase *bool `json:"ignoreCase,omitempty"`

	// Setting this value as truth will force to check the negation of the condition given by the user.
	Negate *bool `json:"negate,omitempty"`

	// The pattern, either fixed string or regular expression, that evaluates the truthfulness of the condition.
	Pattern *string `json:"pattern,omitempty"`

	// The condition parameter of the RewriteRuleCondition.
	Variable *string `json:"variable,omitempty"`
}

// ApplicationGatewayRewriteRuleSet - Rewrite rule set of an application gateway.
type ApplicationGatewayRewriteRuleSet struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the rewrite rule set that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway rewrite rule set.
	Properties *ApplicationGatewayRewriteRuleSetPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// ApplicationGatewayRewriteRuleSetPropertiesFormat - Properties of rewrite rule set of the application gateway.
type ApplicationGatewayRewriteRuleSetPropertiesFormat struct {
	// Rewrite rules in the rewrite rule set.
	RewriteRules []*ApplicationGatewayRewriteRule `json:"rewriteRules,omitempty"`

	// READ-ONLY; The provisioning state of the rewrite rule set resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayRoutingRule - Routing rule of an application gateway.
type ApplicationGatewayRoutingRule struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the routing rule that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway routing rule.
	Properties *ApplicationGatewayRoutingRulePropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayRoutingRulePropertiesFormat - Properties of routing rule of the application gateway.
type ApplicationGatewayRoutingRulePropertiesFormat struct {
	// REQUIRED; Priority of the routing rule.
	Priority *int32 `json:"priority,omitempty"`

	// Backend address pool resource of the application gateway.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`

	// Backend settings resource of the application gateway.
	BackendSettings *SubResource `json:"backendSettings,omitempty"`

	// Listener resource of the application gateway.
	Listener *SubResource `json:"listener,omitempty"`

	// Rule type.
	RuleType *ApplicationGatewayRequestRoutingRuleType `json:"ruleType,omitempty"`

	// READ-ONLY; The provisioning state of the request routing rule resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewaySKU - SKU of an application gateway.
type ApplicationGatewaySKU struct {
	// Capacity (instance count) of an application gateway.
	Capacity *int32 `json:"capacity,omitempty"`

	// Name of an application gateway SKU.
	Name *ApplicationGatewaySKUName `json:"name,omitempty"`

	// Tier of an application gateway.
	Tier *ApplicationGatewayTier `json:"tier,omitempty"`
}

// ApplicationGatewaySSLCertificate - SSL certificates of an application gateway.
type ApplicationGatewaySSLCertificate struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the SSL certificate that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway SSL certificate.
	Properties *ApplicationGatewaySSLCertificatePropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewaySSLCertificatePropertiesFormat - Properties of SSL certificates of an application gateway.
type ApplicationGatewaySSLCertificatePropertiesFormat struct {
	// Base-64 encoded pfx certificate. Only applicable in PUT Request.
	Data *string `json:"data,omitempty"`

	// Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
	KeyVaultSecretID *string `json:"keyVaultSecretId,omitempty"`

	// Password for the pfx file specified in data. Only applicable in PUT request.
	Password *string `json:"password,omitempty"`

	// READ-ONLY; The provisioning state of the SSL certificate resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Base-64 encoded Public cert data corresponding to pfx specified in data. Only applicable in GET request.
	PublicCertData *string `json:"publicCertData,omitempty" azure:"ro"`
}

// ApplicationGatewaySSLPolicy - Application Gateway Ssl policy.
type ApplicationGatewaySSLPolicy struct {
	// Ssl cipher suites to be enabled in the specified order to application gateway.
	CipherSuites []*ApplicationGatewaySSLCipherSuite `json:"cipherSuites,omitempty"`

	// Ssl protocols to be disabled on application gateway.
	DisabledSSLProtocols []*ApplicationGatewaySSLProtocol `json:"disabledSslProtocols,omitempty"`

	// Minimum version of Ssl protocol to be supported on application gateway.
	MinProtocolVersion *ApplicationGatewaySSLProtocol `json:"minProtocolVersion,omitempty"`

	// Name of Ssl predefined policy.
	PolicyName *ApplicationGatewaySSLPolicyName `json:"policyName,omitempty"`

	// Type of Ssl Policy.
	PolicyType *ApplicationGatewaySSLPolicyType `json:"policyType,omitempty"`
}

// ApplicationGatewaySSLPredefinedPolicy - An Ssl predefined policy.
type ApplicationGatewaySSLPredefinedPolicy struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the Ssl predefined policy.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway SSL predefined policy.
	Properties *ApplicationGatewaySSLPredefinedPolicyPropertiesFormat `json:"properties,omitempty"`
}

// ApplicationGatewaySSLPredefinedPolicyPropertiesFormat - Properties of ApplicationGatewaySslPredefinedPolicy.
type ApplicationGatewaySSLPredefinedPolicyPropertiesFormat struct {
	// Ssl cipher suites to be enabled in the specified order for application gateway.
	CipherSuites []*ApplicationGatewaySSLCipherSuite `json:"cipherSuites,omitempty"`

	// Minimum version of Ssl protocol to be supported on application gateway.
	MinProtocolVersion *ApplicationGatewaySSLProtocol `json:"minProtocolVersion,omitempty"`
}

// ApplicationGatewaySSLProfile - SSL profile of an application gateway.
type ApplicationGatewaySSLProfile struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the SSL profile that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway SSL profile.
	Properties *ApplicationGatewaySSLProfilePropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewaySSLProfilePropertiesFormat - Properties of SSL profile of an application gateway.
type ApplicationGatewaySSLProfilePropertiesFormat struct {
	// Client authentication configuration of the application gateway resource.
	ClientAuthConfiguration *ApplicationGatewayClientAuthConfiguration `json:"clientAuthConfiguration,omitempty"`

	// SSL policy of the application gateway resource.
	SSLPolicy *ApplicationGatewaySSLPolicy `json:"sslPolicy,omitempty"`

	// Array of references to application gateway trusted client certificates.
	TrustedClientCertificates []*SubResource `json:"trustedClientCertificates,omitempty"`

	// READ-ONLY; The provisioning state of the HTTP listener resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayTrustedClientCertificate - Trusted client certificates of an application gateway.
type ApplicationGatewayTrustedClientCertificate struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the trusted client certificate that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway trusted client certificate.
	Properties *ApplicationGatewayTrustedClientCertificatePropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayTrustedClientCertificatePropertiesFormat - Trusted client certificates properties of an application gateway.
type ApplicationGatewayTrustedClientCertificatePropertiesFormat struct {
	// Certificate public data.
	Data *string `json:"data,omitempty"`

	// READ-ONLY; Distinguished name of client certificate issuer.
	ClientCertIssuerDN *string `json:"clientCertIssuerDN,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the trusted client certificate resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Validated certificate data.
	ValidatedCertData *string `json:"validatedCertData,omitempty" azure:"ro"`
}

// ApplicationGatewayTrustedRootCertificate - Trusted Root certificates of an application gateway.
type ApplicationGatewayTrustedRootCertificate struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the trusted root certificate that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway trusted root certificate.
	Properties *ApplicationGatewayTrustedRootCertificatePropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayTrustedRootCertificatePropertiesFormat - Trusted Root certificates properties of an application gateway.
type ApplicationGatewayTrustedRootCertificatePropertiesFormat struct {
	// Certificate public data.
	Data *string `json:"data,omitempty"`

	// Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
	KeyVaultSecretID *string `json:"keyVaultSecretId,omitempty"`

	// READ-ONLY; The provisioning state of the trusted root certificate resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayURLConfiguration - Url configuration of the Actions set in Application Gateway.
type ApplicationGatewayURLConfiguration struct {
	// Url path which user has provided for url rewrite. Null means no path will be updated. Default value is null.
	ModifiedPath *string `json:"modifiedPath,omitempty"`

	// Query string which user has provided for url rewrite. Null means no query string will be updated. Default value is null.
	ModifiedQueryString *string `json:"modifiedQueryString,omitempty"`

	// If set as true, it will re-evaluate the url path map provided in path based request routing rules using modified path.
	// Default value is false.
	Reroute *bool `json:"reroute,omitempty"`
}

// ApplicationGatewayURLPathMap - UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.
type ApplicationGatewayURLPathMap struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the URL path map that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of the application gateway URL path map.
	Properties *ApplicationGatewayURLPathMapPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationGatewayURLPathMapPropertiesFormat - Properties of UrlPathMap of the application gateway.
type ApplicationGatewayURLPathMapPropertiesFormat struct {
	// Default backend address pool resource of URL path map.
	DefaultBackendAddressPool *SubResource `json:"defaultBackendAddressPool,omitempty"`

	// Default backend http settings resource of URL path map.
	DefaultBackendHTTPSettings *SubResource `json:"defaultBackendHttpSettings,omitempty"`

	// Default Load Distribution Policy resource of URL path map.
	DefaultLoadDistributionPolicy *SubResource `json:"defaultLoadDistributionPolicy,omitempty"`

	// Default redirect configuration resource of URL path map.
	DefaultRedirectConfiguration *SubResource `json:"defaultRedirectConfiguration,omitempty"`

	// Default Rewrite rule set resource of URL path map.
	DefaultRewriteRuleSet *SubResource `json:"defaultRewriteRuleSet,omitempty"`

	// Path rule of URL path map resource.
	PathRules []*ApplicationGatewayPathRule `json:"pathRules,omitempty"`

	// READ-ONLY; The provisioning state of the URL path map resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationGatewayWebApplicationFirewallConfiguration - Application gateway web application firewall configuration.
type ApplicationGatewayWebApplicationFirewallConfiguration struct {
	// REQUIRED; Whether the web application firewall is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`

	// REQUIRED; Web application firewall mode.
	FirewallMode *ApplicationGatewayFirewallMode `json:"firewallMode,omitempty"`

	// REQUIRED; The type of the web application firewall rule set. Possible values are: 'OWASP'.
	RuleSetType *string `json:"ruleSetType,omitempty"`

	// REQUIRED; The version of the rule set type.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty"`

	// The disabled rule groups.
	DisabledRuleGroups []*ApplicationGatewayFirewallDisabledRuleGroup `json:"disabledRuleGroups,omitempty"`

	// The exclusion list.
	Exclusions []*ApplicationGatewayFirewallExclusion `json:"exclusions,omitempty"`

	// Maximum file upload size in Mb for WAF.
	FileUploadLimitInMb *int32 `json:"fileUploadLimitInMb,omitempty"`

	// Maximum request body size for WAF.
	MaxRequestBodySize *int32 `json:"maxRequestBodySize,omitempty"`

	// Maximum request body size in Kb for WAF.
	MaxRequestBodySizeInKb *int32 `json:"maxRequestBodySizeInKb,omitempty"`

	// Whether allow WAF to check request Body.
	RequestBodyCheck *bool `json:"requestBodyCheck,omitempty"`
}

// ApplicationGatewaysClientBeginBackendHealthOnDemandOptions contains the optional parameters for the ApplicationGatewaysClient.BeginBackendHealthOnDemand
// method.
type ApplicationGatewaysClientBeginBackendHealthOnDemandOptions struct {
	// Expands BackendAddressPool and BackendHttpSettings referenced in backend health.
	Expand *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationGatewaysClientBeginBackendHealthOptions contains the optional parameters for the ApplicationGatewaysClient.BeginBackendHealth
// method.
type ApplicationGatewaysClientBeginBackendHealthOptions struct {
	// Expands BackendAddressPool and BackendHttpSettings referenced in backend health.
	Expand *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationGatewaysClientBeginCreateOrUpdateOptions contains the optional parameters for the ApplicationGatewaysClient.BeginCreateOrUpdate
// method.
type ApplicationGatewaysClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationGatewaysClientBeginDeleteOptions contains the optional parameters for the ApplicationGatewaysClient.BeginDelete
// method.
type ApplicationGatewaysClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationGatewaysClientBeginStartOptions contains the optional parameters for the ApplicationGatewaysClient.BeginStart
// method.
type ApplicationGatewaysClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationGatewaysClientBeginStopOptions contains the optional parameters for the ApplicationGatewaysClient.BeginStop
// method.
type ApplicationGatewaysClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationGatewaysClientGetOptions contains the optional parameters for the ApplicationGatewaysClient.Get method.
type ApplicationGatewaysClientGetOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGatewaysClientGetSSLPredefinedPolicyOptions contains the optional parameters for the ApplicationGatewaysClient.GetSSLPredefinedPolicy
// method.
type ApplicationGatewaysClientGetSSLPredefinedPolicyOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGatewaysClientListAllOptions contains the optional parameters for the ApplicationGatewaysClient.ListAll method.
type ApplicationGatewaysClientListAllOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGatewaysClientListAvailableRequestHeadersOptions contains the optional parameters for the ApplicationGatewaysClient.ListAvailableRequestHeaders
// method.
type ApplicationGatewaysClientListAvailableRequestHeadersOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGatewaysClientListAvailableResponseHeadersOptions contains the optional parameters for the ApplicationGatewaysClient.ListAvailableResponseHeaders
// method.
type ApplicationGatewaysClientListAvailableResponseHeadersOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGatewaysClientListAvailableSSLOptionsOptions contains the optional parameters for the ApplicationGatewaysClient.ListAvailableSSLOptions
// method.
type ApplicationGatewaysClientListAvailableSSLOptionsOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGatewaysClientListAvailableSSLPredefinedPoliciesOptions contains the optional parameters for the ApplicationGatewaysClient.ListAvailableSSLPredefinedPolicies
// method.
type ApplicationGatewaysClientListAvailableSSLPredefinedPoliciesOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGatewaysClientListAvailableServerVariablesOptions contains the optional parameters for the ApplicationGatewaysClient.ListAvailableServerVariables
// method.
type ApplicationGatewaysClientListAvailableServerVariablesOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGatewaysClientListAvailableWafRuleSetsOptions contains the optional parameters for the ApplicationGatewaysClient.ListAvailableWafRuleSets
// method.
type ApplicationGatewaysClientListAvailableWafRuleSetsOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGatewaysClientListOptions contains the optional parameters for the ApplicationGatewaysClient.List method.
type ApplicationGatewaysClientListOptions struct {
	// placeholder for future optional parameters
}

// ApplicationGatewaysClientUpdateTagsOptions contains the optional parameters for the ApplicationGatewaysClient.UpdateTags
// method.
type ApplicationGatewaysClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// ApplicationRule - Rule of type application.
type ApplicationRule struct {
	// REQUIRED; Rule Type.
	RuleType *FirewallPolicyRuleType `json:"ruleType,omitempty"`

	// Description of the rule.
	Description *string `json:"description,omitempty"`

	// List of destination IP addresses or Service Tags.
	DestinationAddresses []*string `json:"destinationAddresses,omitempty"`

	// List of FQDN Tags for this rule.
	FqdnTags []*string `json:"fqdnTags,omitempty"`

	// Name of the rule.
	Name *string `json:"name,omitempty"`

	// Array of Application Protocols.
	Protocols []*FirewallPolicyRuleApplicationProtocol `json:"protocols,omitempty"`

	// List of source IP addresses for this rule.
	SourceAddresses []*string `json:"sourceAddresses,omitempty"`

	// List of source IpGroups for this rule.
	SourceIPGroups []*string `json:"sourceIpGroups,omitempty"`

	// List of FQDNs for this rule.
	TargetFqdns []*string `json:"targetFqdns,omitempty"`

	// List of Urls for this rule condition.
	TargetUrls []*string `json:"targetUrls,omitempty"`

	// Terminate TLS connections for this rule.
	TerminateTLS *bool `json:"terminateTLS,omitempty"`

	// List of destination azure web categories.
	WebCategories []*string `json:"webCategories,omitempty"`
}

// GetFirewallPolicyRule implements the FirewallPolicyRuleClassification interface for type ApplicationRule.
func (a *ApplicationRule) GetFirewallPolicyRule() *FirewallPolicyRule {
	return &FirewallPolicyRule{
		Name:        a.Name,
		Description: a.Description,
		RuleType:    a.RuleType,
	}
}

// ApplicationSecurityGroup - An application security group in a resource group.
type ApplicationSecurityGroup struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the application security group.
	Properties *ApplicationSecurityGroupPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationSecurityGroupListResult - A list of application security groups.
type ApplicationSecurityGroupListResult struct {
	// A list of application security groups.
	Value []*ApplicationSecurityGroup `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ApplicationSecurityGroupPropertiesFormat - Application security group properties.
type ApplicationSecurityGroupPropertiesFormat struct {
	// READ-ONLY; The provisioning state of the application security group resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the application security group resource. It uniquely identifies a resource, even
	// if the user changes its name or migrate the resource across subscriptions or resource
	// groups.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`
}

// ApplicationSecurityGroupsClientBeginCreateOrUpdateOptions contains the optional parameters for the ApplicationSecurityGroupsClient.BeginCreateOrUpdate
// method.
type ApplicationSecurityGroupsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationSecurityGroupsClientBeginDeleteOptions contains the optional parameters for the ApplicationSecurityGroupsClient.BeginDelete
// method.
type ApplicationSecurityGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationSecurityGroupsClientGetOptions contains the optional parameters for the ApplicationSecurityGroupsClient.Get
// method.
type ApplicationSecurityGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ApplicationSecurityGroupsClientListAllOptions contains the optional parameters for the ApplicationSecurityGroupsClient.ListAll
// method.
type ApplicationSecurityGroupsClientListAllOptions struct {
	// placeholder for future optional parameters
}

// ApplicationSecurityGroupsClientListOptions contains the optional parameters for the ApplicationSecurityGroupsClient.List
// method.
type ApplicationSecurityGroupsClientListOptions struct {
	// placeholder for future optional parameters
}

// ApplicationSecurityGroupsClientUpdateTagsOptions contains the optional parameters for the ApplicationSecurityGroupsClient.UpdateTags
// method.
type ApplicationSecurityGroupsClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationListResult - Response for ListAuthorizations API service call retrieves all authorizations that belongs to
// an ExpressRouteCircuit.
type AuthorizationListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The authorizations in an ExpressRoute Circuit.
	Value []*ExpressRouteCircuitAuthorization `json:"value,omitempty"`
}

// AuthorizationPropertiesFormat - Properties of ExpressRouteCircuitAuthorization.
type AuthorizationPropertiesFormat struct {
	// The authorization key.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`

	// The authorization use status.
	AuthorizationUseStatus *AuthorizationUseStatus `json:"authorizationUseStatus,omitempty"`

	// READ-ONLY; The provisioning state of the authorization resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// AutoApprovedPrivateLinkService - The information of an AutoApprovedPrivateLinkService.
type AutoApprovedPrivateLinkService struct {
	// The id of the private link service resource.
	PrivateLinkService *string `json:"privateLinkService,omitempty"`
}

// AutoApprovedPrivateLinkServicesResult - An array of private link service id that can be linked to a private end point with
// auto approved.
type AutoApprovedPrivateLinkServicesResult struct {
	// An array of auto approved private link service.
	Value []*AutoApprovedPrivateLinkService `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// Availability of the metric.
type Availability struct {
	// Duration of the availability blob.
	BlobDuration *string `json:"blobDuration,omitempty"`

	// The retention of the availability.
	Retention *string `json:"retention,omitempty"`

	// The time grain of the availability.
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// AvailableDelegation - The serviceName of an AvailableDelegation indicates a possible delegation for a subnet.
type AvailableDelegation struct {
	// The actions permitted to the service upon delegation.
	Actions []*string `json:"actions,omitempty"`

	// A unique identifier of the AvailableDelegation resource.
	ID *string `json:"id,omitempty"`

	// The name of the AvailableDelegation resource.
	Name *string `json:"name,omitempty"`

	// The name of the service and resource.
	ServiceName *string `json:"serviceName,omitempty"`

	// Resource type.
	Type *string `json:"type,omitempty"`
}

// AvailableDelegationsClientListOptions contains the optional parameters for the AvailableDelegationsClient.List method.
type AvailableDelegationsClientListOptions struct {
	// placeholder for future optional parameters
}

// AvailableDelegationsResult - An array of available delegations.
type AvailableDelegationsResult struct {
	// An array of available delegations.
	Value []*AvailableDelegation `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AvailableEndpointServicesClientListOptions contains the optional parameters for the AvailableEndpointServicesClient.List
// method.
type AvailableEndpointServicesClientListOptions struct {
	// placeholder for future optional parameters
}

// AvailablePrivateEndpointType - The information of an AvailablePrivateEndpointType.
type AvailablePrivateEndpointType struct {
	// Display name of the resource.
	DisplayName *string `json:"displayName,omitempty"`

	// A unique identifier of the AvailablePrivateEndpoint Type resource.
	ID *string `json:"id,omitempty"`

	// The name of the service and resource.
	Name *string `json:"name,omitempty"`

	// The name of the service and resource.
	ResourceName *string `json:"resourceName,omitempty"`

	// Resource type.
	Type *string `json:"type,omitempty"`
}

// AvailablePrivateEndpointTypesClientListByResourceGroupOptions contains the optional parameters for the AvailablePrivateEndpointTypesClient.ListByResourceGroup
// method.
type AvailablePrivateEndpointTypesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AvailablePrivateEndpointTypesClientListOptions contains the optional parameters for the AvailablePrivateEndpointTypesClient.List
// method.
type AvailablePrivateEndpointTypesClientListOptions struct {
	// placeholder for future optional parameters
}

// AvailablePrivateEndpointTypesResult - An array of available PrivateEndpoint types.
type AvailablePrivateEndpointTypesResult struct {
	// An array of available privateEndpoint type.
	Value []*AvailablePrivateEndpointType `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AvailableProvidersList - List of available countries with details.
type AvailableProvidersList struct {
	// REQUIRED; List of available countries.
	Countries []*AvailableProvidersListCountry `json:"countries,omitempty"`
}

// AvailableProvidersListCity - City or town details.
type AvailableProvidersListCity struct {
	// The city or town name.
	CityName *string `json:"cityName,omitempty"`

	// A list of Internet service providers.
	Providers []*string `json:"providers,omitempty"`
}

// AvailableProvidersListCountry - Country details.
type AvailableProvidersListCountry struct {
	// The country name.
	CountryName *string `json:"countryName,omitempty"`

	// A list of Internet service providers.
	Providers []*string `json:"providers,omitempty"`

	// List of available states in the country.
	States []*AvailableProvidersListState `json:"states,omitempty"`
}

// AvailableProvidersListParameters - Constraints that determine the list of available Internet service providers.
type AvailableProvidersListParameters struct {
	// A list of Azure regions.
	AzureLocations []*string `json:"azureLocations,omitempty"`

	// The city or town for available providers list.
	City *string `json:"city,omitempty"`

	// The country for available providers list.
	Country *string `json:"country,omitempty"`

	// The state for available providers list.
	State *string `json:"state,omitempty"`
}

// AvailableProvidersListState - State details.
type AvailableProvidersListState struct {
	// List of available cities or towns in the state.
	Cities []*AvailableProvidersListCity `json:"cities,omitempty"`

	// A list of Internet service providers.
	Providers []*string `json:"providers,omitempty"`

	// The state name.
	StateName *string `json:"stateName,omitempty"`
}

// AvailableResourceGroupDelegationsClientListOptions contains the optional parameters for the AvailableResourceGroupDelegationsClient.List
// method.
type AvailableResourceGroupDelegationsClientListOptions struct {
	// placeholder for future optional parameters
}

// AvailableServiceAlias - The available service alias.
type AvailableServiceAlias struct {
	// The ID of the service alias.
	ID *string `json:"id,omitempty"`

	// The name of the service alias.
	Name *string `json:"name,omitempty"`

	// The resource name of the service alias.
	ResourceName *string `json:"resourceName,omitempty"`

	// The type of the resource.
	Type *string `json:"type,omitempty"`
}

// AvailableServiceAliasesClientListByResourceGroupOptions contains the optional parameters for the AvailableServiceAliasesClient.ListByResourceGroup
// method.
type AvailableServiceAliasesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AvailableServiceAliasesClientListOptions contains the optional parameters for the AvailableServiceAliasesClient.List method.
type AvailableServiceAliasesClientListOptions struct {
	// placeholder for future optional parameters
}

// AvailableServiceAliasesResult - An array of available service aliases.
type AvailableServiceAliasesResult struct {
	// An array of available service aliases.
	Value []*AvailableServiceAlias `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AzureAsyncOperationResult - The response body contains the status of the specified asynchronous operation, indicating whether
// it has succeeded, is in progress, or has failed. Note that this status is distinct from the HTTP
// status code returned for the Get Operation Status operation itself. If the asynchronous operation succeeded, the response
// body includes the HTTP status code for the successful request. If the
// asynchronous operation failed, the response body includes the HTTP status code for the failed request and error information
// regarding the failure.
type AzureAsyncOperationResult struct {
	// Details of the error occurred during specified asynchronous operation.
	Error *Error `json:"error,omitempty"`

	// Status of the Azure async operation.
	Status *NetworkOperationStatus `json:"status,omitempty"`
}

// AzureFirewall - Azure Firewall resource.
type AzureFirewall struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the azure firewall.
	Properties *AzureFirewallPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// A list of availability zones denoting where the resource needs to come from.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AzureFirewallApplicationRule - Properties of an application rule.
type AzureFirewallApplicationRule struct {
	// Description of the rule.
	Description *string `json:"description,omitempty"`

	// List of FQDN Tags for this rule.
	FqdnTags []*string `json:"fqdnTags,omitempty"`

	// Name of the application rule.
	Name *string `json:"name,omitempty"`

	// Array of ApplicationRuleProtocols.
	Protocols []*AzureFirewallApplicationRuleProtocol `json:"protocols,omitempty"`

	// List of source IP addresses for this rule.
	SourceAddresses []*string `json:"sourceAddresses,omitempty"`

	// List of source IpGroups for this rule.
	SourceIPGroups []*string `json:"sourceIpGroups,omitempty"`

	// List of FQDNs for this rule.
	TargetFqdns []*string `json:"targetFqdns,omitempty"`
}

// AzureFirewallApplicationRuleCollection - Application rule collection resource.
type AzureFirewallApplicationRuleCollection struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the azure firewall application rule collection.
	Properties *AzureFirewallApplicationRuleCollectionPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// AzureFirewallApplicationRuleCollectionPropertiesFormat - Properties of the application rule collection.
type AzureFirewallApplicationRuleCollectionPropertiesFormat struct {
	// The action type of a rule collection.
	Action *AzureFirewallRCAction `json:"action,omitempty"`

	// Priority of the application rule collection resource.
	Priority *int32 `json:"priority,omitempty"`

	// Collection of rules used by a application rule collection.
	Rules []*AzureFirewallApplicationRule `json:"rules,omitempty"`

	// READ-ONLY; The provisioning state of the application rule collection resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// AzureFirewallApplicationRuleProtocol - Properties of the application rule protocol.
type AzureFirewallApplicationRuleProtocol struct {
	// Port number for the protocol, cannot be greater than 64000. This field is optional.
	Port *int32 `json:"port,omitempty"`

	// Protocol type.
	ProtocolType *AzureFirewallApplicationRuleProtocolType `json:"protocolType,omitempty"`
}

// AzureFirewallFqdnTag - Azure Firewall FQDN Tag Resource.
type AzureFirewallFqdnTag struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the azure firewall FQDN tag.
	Properties *AzureFirewallFqdnTagPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AzureFirewallFqdnTagListResult - Response for ListAzureFirewallFqdnTags API service call.
type AzureFirewallFqdnTagListResult struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Azure Firewall FQDN Tags in a resource group.
	Value []*AzureFirewallFqdnTag `json:"value,omitempty"`
}

// AzureFirewallFqdnTagPropertiesFormat - Azure Firewall FQDN Tag Properties.
type AzureFirewallFqdnTagPropertiesFormat struct {
	// READ-ONLY; The name of this FQDN Tag.
	FqdnTagName *string `json:"fqdnTagName,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the Azure firewall FQDN tag resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// AzureFirewallFqdnTagsClientListAllOptions contains the optional parameters for the AzureFirewallFqdnTagsClient.ListAll
// method.
type AzureFirewallFqdnTagsClientListAllOptions struct {
	// placeholder for future optional parameters
}

// AzureFirewallIPConfiguration - IP configuration of an Azure Firewall.
type AzureFirewallIPConfiguration struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the azure firewall IP configuration.
	Properties *AzureFirewallIPConfigurationPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AzureFirewallIPConfigurationPropertiesFormat - Properties of IP configuration of an Azure Firewall.
type AzureFirewallIPConfigurationPropertiesFormat struct {
	// Reference to the PublicIP resource. This field is a mandatory input if subnet is not null.
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`

	// Reference to the subnet resource. This resource must be named 'AzureFirewallSubnet' or 'AzureFirewallManagementSubnet'.
	Subnet *SubResource `json:"subnet,omitempty"`

	// READ-ONLY; The Firewall Internal Load Balancer IP to be used as the next hop in User Defined Routes.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the Azure firewall IP configuration resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// AzureFirewallIPGroups - IpGroups associated with azure firewall.
type AzureFirewallIPGroups struct {
	// READ-ONLY; The iteration number.
	ChangeNumber *string `json:"changeNumber,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// AzureFirewallListResult - Response for ListAzureFirewalls API service call.
type AzureFirewallListResult struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Azure Firewalls in a resource group.
	Value []*AzureFirewall `json:"value,omitempty"`
}

// AzureFirewallNatRCAction - AzureFirewall NAT Rule Collection Action.
type AzureFirewallNatRCAction struct {
	// The type of action.
	Type *AzureFirewallNatRCActionType `json:"type,omitempty"`
}

// AzureFirewallNatRule - Properties of a NAT rule.
type AzureFirewallNatRule struct {
	// Description of the rule.
	Description *string `json:"description,omitempty"`

	// List of destination IP addresses for this rule. Supports IP ranges, prefixes, and service tags.
	DestinationAddresses []*string `json:"destinationAddresses,omitempty"`

	// List of destination ports.
	DestinationPorts []*string `json:"destinationPorts,omitempty"`

	// Name of the NAT rule.
	Name *string `json:"name,omitempty"`

	// Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
	Protocols []*AzureFirewallNetworkRuleProtocol `json:"protocols,omitempty"`

	// List of source IP addresses for this rule.
	SourceAddresses []*string `json:"sourceAddresses,omitempty"`

	// List of source IpGroups for this rule.
	SourceIPGroups []*string `json:"sourceIpGroups,omitempty"`

	// The translated address for this NAT rule.
	TranslatedAddress *string `json:"translatedAddress,omitempty"`

	// The translated FQDN for this NAT rule.
	TranslatedFqdn *string `json:"translatedFqdn,omitempty"`

	// The translated port for this NAT rule.
	TranslatedPort *string `json:"translatedPort,omitempty"`
}

// AzureFirewallNatRuleCollection - NAT rule collection resource.
type AzureFirewallNatRuleCollection struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the azure firewall NAT rule collection.
	Properties *AzureFirewallNatRuleCollectionProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// AzureFirewallNatRuleCollectionProperties - Properties of the NAT rule collection.
type AzureFirewallNatRuleCollectionProperties struct {
	// The action type of a NAT rule collection.
	Action *AzureFirewallNatRCAction `json:"action,omitempty"`

	// Priority of the NAT rule collection resource.
	Priority *int32 `json:"priority,omitempty"`

	// Collection of rules used by a NAT rule collection.
	Rules []*AzureFirewallNatRule `json:"rules,omitempty"`

	// READ-ONLY; The provisioning state of the NAT rule collection resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// AzureFirewallNetworkRule - Properties of the network rule.
type AzureFirewallNetworkRule struct {
	// Description of the rule.
	Description *string `json:"description,omitempty"`

	// List of destination IP addresses.
	DestinationAddresses []*string `json:"destinationAddresses,omitempty"`

	// List of destination FQDNs.
	DestinationFqdns []*string `json:"destinationFqdns,omitempty"`

	// List of destination IpGroups for this rule.
	DestinationIPGroups []*string `json:"destinationIpGroups,omitempty"`

	// List of destination ports.
	DestinationPorts []*string `json:"destinationPorts,omitempty"`

	// Name of the network rule.
	Name *string `json:"name,omitempty"`

	// Array of AzureFirewallNetworkRuleProtocols.
	Protocols []*AzureFirewallNetworkRuleProtocol `json:"protocols,omitempty"`

	// List of source IP addresses for this rule.
	SourceAddresses []*string `json:"sourceAddresses,omitempty"`

	// List of source IpGroups for this rule.
	SourceIPGroups []*string `json:"sourceIpGroups,omitempty"`
}

// AzureFirewallNetworkRuleCollection - Network rule collection resource.
type AzureFirewallNetworkRuleCollection struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the azure firewall network rule collection.
	Properties *AzureFirewallNetworkRuleCollectionPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// AzureFirewallNetworkRuleCollectionPropertiesFormat - Properties of the network rule collection.
type AzureFirewallNetworkRuleCollectionPropertiesFormat struct {
	// The action type of a rule collection.
	Action *AzureFirewallRCAction `json:"action,omitempty"`

	// Priority of the network rule collection resource.
	Priority *int32 `json:"priority,omitempty"`

	// Collection of rules used by a network rule collection.
	Rules []*AzureFirewallNetworkRule `json:"rules,omitempty"`

	// READ-ONLY; The provisioning state of the network rule collection resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// AzureFirewallPropertiesFormat - Properties of the Azure Firewall.
type AzureFirewallPropertiesFormat struct {
	// The additional properties used to further config this azure firewall.
	AdditionalProperties map[string]*string `json:"additionalProperties,omitempty"`

	// Collection of application rule collections used by Azure Firewall.
	ApplicationRuleCollections []*AzureFirewallApplicationRuleCollection `json:"applicationRuleCollections,omitempty"`

	// The firewallPolicy associated with this azure firewall.
	FirewallPolicy *SubResource `json:"firewallPolicy,omitempty"`

	// IP addresses associated with AzureFirewall.
	HubIPAddresses *HubIPAddresses `json:"hubIPAddresses,omitempty"`

	// IP configuration of the Azure Firewall resource.
	IPConfigurations []*AzureFirewallIPConfiguration `json:"ipConfigurations,omitempty"`

	// IP configuration of the Azure Firewall used for management traffic.
	ManagementIPConfiguration *AzureFirewallIPConfiguration `json:"managementIpConfiguration,omitempty"`

	// Collection of NAT rule collections used by Azure Firewall.
	NatRuleCollections []*AzureFirewallNatRuleCollection `json:"natRuleCollections,omitempty"`

	// Collection of network rule collections used by Azure Firewall.
	NetworkRuleCollections []*AzureFirewallNetworkRuleCollection `json:"networkRuleCollections,omitempty"`

	// The Azure Firewall Resource SKU.
	SKU *AzureFirewallSKU `json:"sku,omitempty"`

	// The operation mode for Threat Intelligence.
	ThreatIntelMode *AzureFirewallThreatIntelMode `json:"threatIntelMode,omitempty"`

	// The virtualHub to which the firewall belongs.
	VirtualHub *SubResource `json:"virtualHub,omitempty"`

	// READ-ONLY; IpGroups associated with AzureFirewall.
	IPGroups []*AzureFirewallIPGroups `json:"ipGroups,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the Azure firewall resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// AzureFirewallPublicIPAddress - Public IP Address associated with azure firewall.
type AzureFirewallPublicIPAddress struct {
	// Public IP Address value.
	Address *string `json:"address,omitempty"`
}

// AzureFirewallRCAction - Properties of the AzureFirewallRCAction.
type AzureFirewallRCAction struct {
	// The type of action.
	Type *AzureFirewallRCActionType `json:"type,omitempty"`
}

// AzureFirewallSKU - SKU of an Azure Firewall.
type AzureFirewallSKU struct {
	// Name of an Azure Firewall SKU.
	Name *AzureFirewallSKUName `json:"name,omitempty"`

	// Tier of an Azure Firewall.
	Tier *AzureFirewallSKUTier `json:"tier,omitempty"`
}

// AzureFirewallsClientBeginCreateOrUpdateOptions contains the optional parameters for the AzureFirewallsClient.BeginCreateOrUpdate
// method.
type AzureFirewallsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AzureFirewallsClientBeginDeleteOptions contains the optional parameters for the AzureFirewallsClient.BeginDelete method.
type AzureFirewallsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AzureFirewallsClientBeginListLearnedPrefixesOptions contains the optional parameters for the AzureFirewallsClient.BeginListLearnedPrefixes
// method.
type AzureFirewallsClientBeginListLearnedPrefixesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AzureFirewallsClientBeginUpdateTagsOptions contains the optional parameters for the AzureFirewallsClient.BeginUpdateTags
// method.
type AzureFirewallsClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AzureFirewallsClientGetOptions contains the optional parameters for the AzureFirewallsClient.Get method.
type AzureFirewallsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AzureFirewallsClientListAllOptions contains the optional parameters for the AzureFirewallsClient.ListAll method.
type AzureFirewallsClientListAllOptions struct {
	// placeholder for future optional parameters
}

// AzureFirewallsClientListOptions contains the optional parameters for the AzureFirewallsClient.List method.
type AzureFirewallsClientListOptions struct {
	// placeholder for future optional parameters
}

// AzureReachabilityReport - Azure reachability report details.
type AzureReachabilityReport struct {
	// REQUIRED; The aggregation level of Azure reachability report. Can be Country, State or City.
	AggregationLevel *string `json:"aggregationLevel,omitempty"`

	// REQUIRED; Parameters that define a geographic location.
	ProviderLocation *AzureReachabilityReportLocation `json:"providerLocation,omitempty"`

	// REQUIRED; List of Azure reachability report items.
	ReachabilityReport []*AzureReachabilityReportItem `json:"reachabilityReport,omitempty"`
}

// AzureReachabilityReportItem - Azure reachability report details for a given provider location.
type AzureReachabilityReportItem struct {
	// The Azure region.
	AzureLocation *string `json:"azureLocation,omitempty"`

	// List of latency details for each of the time series.
	Latencies []*AzureReachabilityReportLatencyInfo `json:"latencies,omitempty"`

	// The Internet service provider.
	Provider *string `json:"provider,omitempty"`
}

// AzureReachabilityReportLatencyInfo - Details on latency for a time series.
type AzureReachabilityReportLatencyInfo struct {
	// The relative latency score between 1 and 100, higher values indicating a faster connection.
	Score *int32 `json:"score,omitempty"`

	// The time stamp.
	TimeStamp *time.Time `json:"timeStamp,omitempty"`
}

// AzureReachabilityReportLocation - Parameters that define a geographic location.
type AzureReachabilityReportLocation struct {
	// REQUIRED; The name of the country.
	Country *string `json:"country,omitempty"`

	// The name of the city or town.
	City *string `json:"city,omitempty"`

	// The name of the state.
	State *string `json:"state,omitempty"`
}

// AzureReachabilityReportParameters - Geographic and time constraints for Azure reachability report.
type AzureReachabilityReportParameters struct {
	// REQUIRED; The end time for the Azure reachability report.
	EndTime *time.Time `json:"endTime,omitempty"`

	// REQUIRED; Parameters that define a geographic location.
	ProviderLocation *AzureReachabilityReportLocation `json:"providerLocation,omitempty"`

	// REQUIRED; The start time for the Azure reachability report.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Optional Azure regions to scope the query to.
	AzureLocations []*string `json:"azureLocations,omitempty"`

	// List of Internet service providers.
	Providers []*string `json:"providers,omitempty"`
}

// AzureWebCategory - Azure Web Category Resource.
type AzureWebCategory struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Properties of the Azure Web Category.
	Properties *AzureWebCategoryPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AzureWebCategoryListResult - Response for ListAzureWebCategories API service call.
type AzureWebCategoryListResult struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Azure Web Categories for a given Subscription.
	Value []*AzureWebCategory `json:"value,omitempty"`
}

// AzureWebCategoryPropertiesFormat - Azure Web Category Properties.
type AzureWebCategoryPropertiesFormat struct {
	// READ-ONLY; The name of the group that the category belongs to.
	Group *string `json:"group,omitempty" azure:"ro"`
}

// BGPCommunity - Contains bgp community information offered in Service Community resources.
type BGPCommunity struct {
	// The name of the bgp community. e.g. Skype.
	CommunityName *string `json:"communityName,omitempty"`

	// The prefixes that the bgp community contains.
	CommunityPrefixes []*string `json:"communityPrefixes,omitempty"`

	// The value of the bgp community. For more information: https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
	CommunityValue *string `json:"communityValue,omitempty"`

	// Customer is authorized to use bgp community or not.
	IsAuthorizedToUse *bool `json:"isAuthorizedToUse,omitempty"`

	// The service group of the bgp community contains.
	ServiceGroup *string `json:"serviceGroup,omitempty"`

	// The region which the service support. e.g. For O365, region is Global.
	ServiceSupportedRegion *string `json:"serviceSupportedRegion,omitempty"`
}

// BackendAddressInboundNatRulePortMappings - The response for a QueryInboundNatRulePortMapping API.
type BackendAddressInboundNatRulePortMappings struct {
	// Collection of inbound NAT rule port mappings.
	InboundNatRulePortMappings []*InboundNatRulePortMapping `json:"inboundNatRulePortMappings,omitempty"`
}

// BackendAddressPool - Pool of backend IP addresses.
type BackendAddressPool struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can
	// be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of load balancer backend address pool.
	Properties *BackendAddressPoolPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackendAddressPoolPropertiesFormat - Properties of the backend address pool.
type BackendAddressPoolPropertiesFormat struct {
	// Amount of seconds Load Balancer waits for before sending RESET to client and backend address.
	DrainPeriodInSeconds *int32 `json:"drainPeriodInSeconds,omitempty"`

	// An array of backend addresses.
	LoadBalancerBackendAddresses []*LoadBalancerBackendAddress `json:"loadBalancerBackendAddresses,omitempty"`

	// The location of the backend address pool.
	Location *string `json:"location,omitempty"`

	// An array of gateway load balancer tunnel interfaces.
	TunnelInterfaces []*GatewayLoadBalancerTunnelInterface `json:"tunnelInterfaces,omitempty"`

	// READ-ONLY; An array of references to IP addresses defined in network interfaces.
	BackendIPConfigurations []*InterfaceIPConfiguration `json:"backendIPConfigurations,omitempty" azure:"ro"`

	// READ-ONLY; An array of references to inbound NAT rules that use this backend address pool.
	InboundNatRules []*SubResource `json:"inboundNatRules,omitempty" azure:"ro"`

	// READ-ONLY; An array of references to load balancing rules that use this backend address pool.
	LoadBalancingRules []*SubResource `json:"loadBalancingRules,omitempty" azure:"ro"`

	// READ-ONLY; A reference to an outbound rule that uses this backend address pool.
	OutboundRule *SubResource `json:"outboundRule,omitempty" azure:"ro"`

	// READ-ONLY; An array of references to outbound rules that use this backend address pool.
	OutboundRules []*SubResource `json:"outboundRules,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the backend address pool resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// BaseAdminRuleClassification provides polymorphic access to related types.
// Call the interface's GetBaseAdminRule() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AdminRule, *BaseAdminRule, *DefaultAdminRule
type BaseAdminRuleClassification interface {
	// GetBaseAdminRule returns the BaseAdminRule content of the underlying type.
	GetBaseAdminRule() *BaseAdminRule
}

// BaseAdminRule - Network base admin rule.
type BaseAdminRule struct {
	// REQUIRED; Whether the rule is custom or default.
	Kind *AdminRuleKind `json:"kind,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetBaseAdminRule implements the BaseAdminRuleClassification interface for type BaseAdminRule.
func (b *BaseAdminRule) GetBaseAdminRule() *BaseAdminRule { return b }

// BastionActiveSession - The session detail for a target.
type BastionActiveSession struct {
	// READ-ONLY; The protocol used to connect to the target.
	Protocol *BastionConnectProtocol `json:"protocol,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; Duration in mins the session has been active.
	SessionDurationInMins *float32 `json:"sessionDurationInMins,omitempty" azure:"ro"`

	// READ-ONLY; A unique id for the session.
	SessionID *string `json:"sessionId,omitempty" azure:"ro"`

	// READ-ONLY; The time when the session started.
	StartTime interface{} `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The host name of the target.
	TargetHostName *string `json:"targetHostName,omitempty" azure:"ro"`

	// READ-ONLY; The IP Address of the target.
	TargetIPAddress *string `json:"targetIpAddress,omitempty" azure:"ro"`

	// READ-ONLY; The resource group of the target.
	TargetResourceGroup *string `json:"targetResourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; The resource id of the target.
	TargetResourceID *string `json:"targetResourceId,omitempty" azure:"ro"`

	// READ-ONLY; The subscription id for the target virtual machine.
	TargetSubscriptionID *string `json:"targetSubscriptionId,omitempty" azure:"ro"`

	// READ-ONLY; The user name who is active on this session.
	UserName *string `json:"userName,omitempty" azure:"ro"`
}

// BastionActiveSessionListResult - Response for GetActiveSessions.
type BastionActiveSessionListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of active sessions on the bastion.
	Value []*BastionActiveSession `json:"value,omitempty"`
}

// BastionHost - Bastion Host resource.
type BastionHost struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Represents the bastion host resource.
	Properties *BastionHostPropertiesFormat `json:"properties,omitempty"`

	// The sku of this Bastion Host.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BastionHostIPConfiguration - IP configuration of an Bastion Host.
type BastionHostIPConfiguration struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Represents the ip configuration associated with the resource.
	Properties *BastionHostIPConfigurationPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Ip configuration type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BastionHostIPConfigurationPropertiesFormat - Properties of IP configuration of an Bastion Host.
type BastionHostIPConfigurationPropertiesFormat struct {
	// REQUIRED; Reference of the PublicIP resource.
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`

	// REQUIRED; Reference of the subnet resource.
	Subnet *SubResource `json:"subnet,omitempty"`

	// Private IP allocation method.
	PrivateIPAllocationMethod *IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`

	// READ-ONLY; The provisioning state of the bastion host IP configuration resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// BastionHostListResult - Response for ListBastionHosts API service call.
type BastionHostListResult struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Bastion Hosts in a resource group.
	Value []*BastionHost `json:"value,omitempty"`
}

// BastionHostPropertiesFormat - Properties of the Bastion Host.
type BastionHostPropertiesFormat struct {
	// FQDN for the endpoint on which bastion host is accessible.
	DNSName *string `json:"dnsName,omitempty"`

	// Enable/Disable Copy/Paste feature of the Bastion Host resource.
	DisableCopyPaste *bool `json:"disableCopyPaste,omitempty"`

	// Enable/Disable File Copy feature of the Bastion Host resource.
	EnableFileCopy *bool `json:"enableFileCopy,omitempty"`

	// Enable/Disable IP Connect feature of the Bastion Host resource.
	EnableIPConnect *bool `json:"enableIpConnect,omitempty"`

	// Enable/Disable Shareable Link of the Bastion Host resource.
	EnableShareableLink *bool `json:"enableShareableLink,omitempty"`

	// Enable/Disable Tunneling feature of the Bastion Host resource.
	EnableTunneling *bool `json:"enableTunneling,omitempty"`

	// IP configuration of the Bastion Host resource.
	IPConfigurations []*BastionHostIPConfiguration `json:"ipConfigurations,omitempty"`

	// The scale units for the Bastion Host resource.
	ScaleUnits *int32 `json:"scaleUnits,omitempty"`

	// READ-ONLY; The provisioning state of the bastion host resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// BastionHostsClientBeginCreateOrUpdateOptions contains the optional parameters for the BastionHostsClient.BeginCreateOrUpdate
// method.
type BastionHostsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BastionHostsClientBeginDeleteOptions contains the optional parameters for the BastionHostsClient.BeginDelete method.
type BastionHostsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BastionHostsClientBeginUpdateTagsOptions contains the optional parameters for the BastionHostsClient.BeginUpdateTags method.
type BastionHostsClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BastionHostsClientGetOptions contains the optional parameters for the BastionHostsClient.Get method.
type BastionHostsClientGetOptions struct {
	// placeholder for future optional parameters
}

// BastionHostsClientListByResourceGroupOptions contains the optional parameters for the BastionHostsClient.ListByResourceGroup
// method.
type BastionHostsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// BastionHostsClientListOptions contains the optional parameters for the BastionHostsClient.List method.
type BastionHostsClientListOptions struct {
	// placeholder for future optional parameters
}

// BastionSessionDeleteResult - Response for DisconnectActiveSessions.
type BastionSessionDeleteResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of sessions with their corresponding state.
	Value []*BastionSessionState `json:"value,omitempty"`
}

// BastionSessionState - The session state detail for a target.
type BastionSessionState struct {
	// READ-ONLY; Used for extra information.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; A unique id for the session.
	SessionID *string `json:"sessionId,omitempty" azure:"ro"`

	// READ-ONLY; The state of the session. Disconnected/Failed/NotFound.
	State *string `json:"state,omitempty" azure:"ro"`
}

// BastionShareableLink - Bastion Shareable Link.
type BastionShareableLink struct {
	// REQUIRED; Reference of the virtual machine resource.
	VM *VM `json:"vm,omitempty"`

	// READ-ONLY; The unique Bastion Shareable Link to the virtual machine.
	Bsl *string `json:"bsl,omitempty" azure:"ro"`

	// READ-ONLY; The time when the link was created.
	CreatedAt *string `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; Optional field indicating the warning or error message related to the vm in case of partial failure.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// BastionShareableLinkListRequest - Post request for all the Bastion Shareable Link endpoints.
type BastionShareableLinkListRequest struct {
	// List of VM references.
	VMs []*BastionShareableLink `json:"vms,omitempty"`
}

// BastionShareableLinkListResult - Response for all the Bastion Shareable Link endpoints.
type BastionShareableLinkListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Bastion Shareable Links for the request.
	Value []*BastionShareableLink `json:"value,omitempty"`
}

// BgpConnection - Virtual Appliance Site resource.
type BgpConnection struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the connection.
	Name *string `json:"name,omitempty"`

	// The properties of the Bgp connections.
	Properties *BgpConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Connection type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BgpConnectionProperties - Properties of the bgp connection.
type BgpConnectionProperties struct {
	// The reference to the HubVirtualNetworkConnection resource.
	HubVirtualNetworkConnection *SubResource `json:"hubVirtualNetworkConnection,omitempty"`

	// Peer ASN.
	PeerAsn *int64 `json:"peerAsn,omitempty"`

	// Peer IP.
	PeerIP *string `json:"peerIp,omitempty"`

	// READ-ONLY; The current state of the VirtualHub to Peer.
	ConnectionState *HubBgpConnectionStatus `json:"connectionState,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// BgpPeerStatus - BGP peer status details.
type BgpPeerStatus struct {
	// READ-ONLY; The autonomous system number of the remote BGP peer.
	Asn *int64 `json:"asn,omitempty" azure:"ro"`

	// READ-ONLY; For how long the peering has been up.
	ConnectedDuration *string `json:"connectedDuration,omitempty" azure:"ro"`

	// READ-ONLY; The virtual network gateway's local address.
	LocalAddress *string `json:"localAddress,omitempty" azure:"ro"`

	// READ-ONLY; The number of BGP messages received.
	MessagesReceived *int64 `json:"messagesReceived,omitempty" azure:"ro"`

	// READ-ONLY; The number of BGP messages sent.
	MessagesSent *int64 `json:"messagesSent,omitempty" azure:"ro"`

	// READ-ONLY; The remote BGP peer.
	Neighbor *string `json:"neighbor,omitempty" azure:"ro"`

	// READ-ONLY; The number of routes learned from this peer.
	RoutesReceived *int64 `json:"routesReceived,omitempty" azure:"ro"`

	// READ-ONLY; The BGP peer state.
	State *BgpPeerState `json:"state,omitempty" azure:"ro"`
}

// BgpPeerStatusListResult - Response for list BGP peer status API service call.
type BgpPeerStatusListResult struct {
	// List of BGP peers.
	Value []*BgpPeerStatus `json:"value,omitempty"`
}

// BgpServiceCommunitiesClientListOptions contains the optional parameters for the BgpServiceCommunitiesClient.List method.
type BgpServiceCommunitiesClientListOptions struct {
	// placeholder for future optional parameters
}

// BgpServiceCommunity - Service Community Properties.
type BgpServiceCommunity struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the BGP service community.
	Properties *BgpServiceCommunityPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BgpServiceCommunityListResult - Response for the ListServiceCommunity API service call.
type BgpServiceCommunityListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of service community resources.
	Value []*BgpServiceCommunity `json:"value,omitempty"`
}

// BgpServiceCommunityPropertiesFormat - Properties of Service Community.
type BgpServiceCommunityPropertiesFormat struct {
	// A list of bgp communities.
	BgpCommunities []*BGPCommunity `json:"bgpCommunities,omitempty"`

	// The name of the bgp community. e.g. Skype.
	ServiceName *string `json:"serviceName,omitempty"`
}

// BgpSettings - BGP settings details.
type BgpSettings struct {
	// The BGP speaker's ASN.
	Asn *int64 `json:"asn,omitempty"`

	// The BGP peering address and BGP identifier of this BGP speaker.
	BgpPeeringAddress *string `json:"bgpPeeringAddress,omitempty"`

	// BGP peering address with IP configuration ID for virtual network gateway.
	BgpPeeringAddresses []*IPConfigurationBgpPeeringAddress `json:"bgpPeeringAddresses,omitempty"`

	// The weight added to routes learned from this BGP speaker.
	PeerWeight *int32 `json:"peerWeight,omitempty"`
}

// BreakOutCategoryPolicies - Network Virtual Appliance Sku Properties.
type BreakOutCategoryPolicies struct {
	// Flag to control breakout of o365 allow category.
	Allow *bool `json:"allow,omitempty"`

	// Flag to control breakout of o365 default category.
	Default *bool `json:"default,omitempty"`

	// Flag to control breakout of o365 optimize category.
	Optimize *bool `json:"optimize,omitempty"`
}

// CheckPrivateLinkServiceVisibilityRequest - Request body of the CheckPrivateLinkServiceVisibility API service call.
type CheckPrivateLinkServiceVisibilityRequest struct {
	// The alias of the private link service.
	PrivateLinkServiceAlias *string `json:"privateLinkServiceAlias,omitempty"`
}

// ChildResource - Proxy resource representation.
type ChildResource struct {
	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CloudError - An error response from the service.
type CloudError struct {
	// Cloud error body.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody - An error response from the service.
type CloudErrorBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A list of additional details about the error.
	Details []*CloudErrorBody `json:"details,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`

	// The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
}

type Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// ConfigurationDiagnosticParameters - Parameters to get network configuration diagnostic.
type ConfigurationDiagnosticParameters struct {
	// REQUIRED; List of network configuration diagnostic profiles.
	Profiles []*ConfigurationDiagnosticProfile `json:"profiles,omitempty"`

	// REQUIRED; The ID of the target resource to perform network configuration diagnostic. Valid options are VM, NetworkInterface,
	// VMSS/NetworkInterface and Application Gateway.
	TargetResourceID *string `json:"targetResourceId,omitempty"`

	// Verbosity level.
	VerbosityLevel *VerbosityLevel `json:"verbosityLevel,omitempty"`
}

// ConfigurationDiagnosticProfile - Parameters to compare with network configuration.
type ConfigurationDiagnosticProfile struct {
	// REQUIRED; Traffic destination. Accepted values are: '*', IP Address/CIDR, Service Tag.
	Destination *string `json:"destination,omitempty"`

	// REQUIRED; Traffic destination port. Accepted values are '*' and a single port in the range (0 - 65535).
	DestinationPort *string `json:"destinationPort,omitempty"`

	// REQUIRED; The direction of the traffic.
	Direction *Direction `json:"direction,omitempty"`

	// REQUIRED; Protocol to be verified on. Accepted values are '*', TCP, UDP.
	Protocol *string `json:"protocol,omitempty"`

	// REQUIRED; Traffic source. Accepted values are '*', IP Address/CIDR, Service Tag.
	Source *string `json:"source,omitempty"`
}

// ConfigurationDiagnosticResponse - Results of network configuration diagnostic on the target resource.
type ConfigurationDiagnosticResponse struct {
	// READ-ONLY; List of network configuration diagnostic results.
	Results []*ConfigurationDiagnosticResult `json:"results,omitempty" azure:"ro"`
}

// ConfigurationDiagnosticResult - Network configuration diagnostic result corresponded to provided traffic query.
type ConfigurationDiagnosticResult struct {
	// Network security group result.
	NetworkSecurityGroupResult *SecurityGroupResult `json:"networkSecurityGroupResult,omitempty"`

	// Network configuration diagnostic profile.
	Profile *ConfigurationDiagnosticProfile `json:"profile,omitempty"`
}

// ConfigurationGroup - The network configuration group resource
type ConfigurationGroup struct {
	// Network group ID.
	ID *string `json:"id,omitempty"`

	// The network configuration group properties
	Properties *GroupProperties `json:"properties,omitempty"`
}

// ConfigurationPolicyGroupsClientBeginCreateOrUpdateOptions contains the optional parameters for the ConfigurationPolicyGroupsClient.BeginCreateOrUpdate
// method.
type ConfigurationPolicyGroupsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConfigurationPolicyGroupsClientBeginDeleteOptions contains the optional parameters for the ConfigurationPolicyGroupsClient.BeginDelete
// method.
type ConfigurationPolicyGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConfigurationPolicyGroupsClientGetOptions contains the optional parameters for the ConfigurationPolicyGroupsClient.Get
// method.
type ConfigurationPolicyGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationPolicyGroupsClientListByVPNServerConfigurationOptions contains the optional parameters for the ConfigurationPolicyGroupsClient.ListByVPNServerConfiguration
// method.
type ConfigurationPolicyGroupsClientListByVPNServerConfigurationOptions struct {
	// placeholder for future optional parameters
}

// ConnectionMonitor - Parameters that define the operation to create a connection monitor.
type ConnectionMonitor struct {
	// REQUIRED; Properties of the connection monitor.
	Properties *ConnectionMonitorParameters `json:"properties,omitempty"`

	// Connection monitor location.
	Location *string `json:"location,omitempty"`

	// Connection monitor tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ConnectionMonitorDestination - Describes the destination of connection monitor.
type ConnectionMonitorDestination struct {
	// Address of the connection monitor destination (IP or domain name).
	Address *string `json:"address,omitempty"`

	// The destination port used by connection monitor.
	Port *int32 `json:"port,omitempty"`

	// The ID of the resource used as the destination by connection monitor.
	ResourceID *string `json:"resourceId,omitempty"`
}

// ConnectionMonitorEndpoint - Describes the connection monitor endpoint.
type ConnectionMonitorEndpoint struct {
	// REQUIRED; The name of the connection monitor endpoint.
	Name *string `json:"name,omitempty"`

	// Address of the connection monitor endpoint (IP or domain name).
	Address *string `json:"address,omitempty"`

	// Test coverage for the endpoint.
	CoverageLevel *CoverageLevel `json:"coverageLevel,omitempty"`

	// Filter for sub-items within the endpoint.
	Filter *ConnectionMonitorEndpointFilter `json:"filter,omitempty"`

	// Resource ID of the connection monitor endpoint.
	ResourceID *string `json:"resourceId,omitempty"`

	// Endpoint scope.
	Scope *ConnectionMonitorEndpointScope `json:"scope,omitempty"`

	// The endpoint type.
	Type *EndpointType `json:"type,omitempty"`
}

// ConnectionMonitorEndpointFilter - Describes the connection monitor endpoint filter.
type ConnectionMonitorEndpointFilter struct {
	// List of items in the filter.
	Items []*ConnectionMonitorEndpointFilterItem `json:"items,omitempty"`

	// The behavior of the endpoint filter. Currently only 'Include' is supported.
	Type *ConnectionMonitorEndpointFilterType `json:"type,omitempty"`
}

// ConnectionMonitorEndpointFilterItem - Describes the connection monitor endpoint filter item.
type ConnectionMonitorEndpointFilterItem struct {
	// The address of the filter item.
	Address *string `json:"address,omitempty"`

	// The type of item included in the filter. Currently only 'AgentAddress' is supported.
	Type *ConnectionMonitorEndpointFilterItemType `json:"type,omitempty"`
}

// ConnectionMonitorEndpointScope - Describes the connection monitor endpoint scope.
type ConnectionMonitorEndpointScope struct {
	// List of items which needs to be excluded from the endpoint scope.
	Exclude []*ConnectionMonitorEndpointScopeItem `json:"exclude,omitempty"`

	// List of items which needs to be included to the endpoint scope.
	Include []*ConnectionMonitorEndpointScopeItem `json:"include,omitempty"`
}

// ConnectionMonitorEndpointScopeItem - Describes the connection monitor endpoint scope item.
type ConnectionMonitorEndpointScopeItem struct {
	// The address of the endpoint item. Supported types are IPv4/IPv6 subnet mask or IPv4/IPv6 IP address.
	Address *string `json:"address,omitempty"`
}

// ConnectionMonitorHTTPConfiguration - Describes the HTTP configuration.
type ConnectionMonitorHTTPConfiguration struct {
	// The HTTP method to use.
	Method *HTTPConfigurationMethod `json:"method,omitempty"`

	// The path component of the URI. For instance, "/dir1/dir2".
	Path *string `json:"path,omitempty"`

	// The port to connect to.
	Port *int32 `json:"port,omitempty"`

	// Value indicating whether HTTPS is preferred over HTTP in cases where the choice is not explicit.
	PreferHTTPS *bool `json:"preferHTTPS,omitempty"`

	// The HTTP headers to transmit with the request.
	RequestHeaders []*HTTPHeader `json:"requestHeaders,omitempty"`

	// HTTP status codes to consider successful. For instance, "2xx,301-304,418".
	ValidStatusCodeRanges []*string `json:"validStatusCodeRanges,omitempty"`
}

// ConnectionMonitorIcmpConfiguration - Describes the ICMP configuration.
type ConnectionMonitorIcmpConfiguration struct {
	// Value indicating whether path evaluation with trace route should be disabled.
	DisableTraceRoute *bool `json:"disableTraceRoute,omitempty"`
}

// ConnectionMonitorListResult - List of connection monitors.
type ConnectionMonitorListResult struct {
	// Information about connection monitors.
	Value []*ConnectionMonitorResult `json:"value,omitempty"`
}

// ConnectionMonitorOutput - Describes a connection monitor output destination.
type ConnectionMonitorOutput struct {
	// Connection monitor output destination type. Currently, only "Workspace" is supported.
	Type *OutputType `json:"type,omitempty"`

	// Describes the settings for producing output into a log analytics workspace.
	WorkspaceSettings *ConnectionMonitorWorkspaceSettings `json:"workspaceSettings,omitempty"`
}

// ConnectionMonitorParameters - Parameters that define the operation to create a connection monitor.
type ConnectionMonitorParameters struct {
	// Determines if the connection monitor will start automatically once created.
	AutoStart *bool `json:"autoStart,omitempty"`

	// Describes the destination of connection monitor.
	Destination *ConnectionMonitorDestination `json:"destination,omitempty"`

	// List of connection monitor endpoints.
	Endpoints []*ConnectionMonitorEndpoint `json:"endpoints,omitempty"`

	// Monitoring interval in seconds.
	MonitoringIntervalInSeconds *int32 `json:"monitoringIntervalInSeconds,omitempty"`

	// Optional notes to be associated with the connection monitor.
	Notes *string `json:"notes,omitempty"`

	// List of connection monitor outputs.
	Outputs []*ConnectionMonitorOutput `json:"outputs,omitempty"`

	// Describes the source of connection monitor.
	Source *ConnectionMonitorSource `json:"source,omitempty"`

	// List of connection monitor test configurations.
	TestConfigurations []*ConnectionMonitorTestConfiguration `json:"testConfigurations,omitempty"`

	// List of connection monitor test groups.
	TestGroups []*ConnectionMonitorTestGroup `json:"testGroups,omitempty"`
}

// ConnectionMonitorQueryResult - List of connection states snapshots.
type ConnectionMonitorQueryResult struct {
	// Status of connection monitor source.
	SourceStatus *ConnectionMonitorSourceStatus `json:"sourceStatus,omitempty"`

	// Information about connection states.
	States []*ConnectionStateSnapshot `json:"states,omitempty"`
}

// ConnectionMonitorResult - Information about the connection monitor.
type ConnectionMonitorResult struct {
	// Connection monitor location.
	Location *string `json:"location,omitempty"`

	// Properties of the connection monitor result.
	Properties *ConnectionMonitorResultProperties `json:"properties,omitempty"`

	// Connection monitor tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; ID of the connection monitor.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the connection monitor.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Connection monitor type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConnectionMonitorResultProperties - Describes the properties of a connection monitor.
type ConnectionMonitorResultProperties struct {
	// Determines if the connection monitor will start automatically once created.
	AutoStart *bool `json:"autoStart,omitempty"`

	// Describes the destination of connection monitor.
	Destination *ConnectionMonitorDestination `json:"destination,omitempty"`

	// List of connection monitor endpoints.
	Endpoints []*ConnectionMonitorEndpoint `json:"endpoints,omitempty"`

	// Monitoring interval in seconds.
	MonitoringIntervalInSeconds *int32 `json:"monitoringIntervalInSeconds,omitempty"`

	// Optional notes to be associated with the connection monitor.
	Notes *string `json:"notes,omitempty"`

	// List of connection monitor outputs.
	Outputs []*ConnectionMonitorOutput `json:"outputs,omitempty"`

	// Describes the source of connection monitor.
	Source *ConnectionMonitorSource `json:"source,omitempty"`

	// List of connection monitor test configurations.
	TestConfigurations []*ConnectionMonitorTestConfiguration `json:"testConfigurations,omitempty"`

	// List of connection monitor test groups.
	TestGroups []*ConnectionMonitorTestGroup `json:"testGroups,omitempty"`

	// READ-ONLY; Type of connection monitor.
	ConnectionMonitorType *ConnectionMonitorType `json:"connectionMonitorType,omitempty" azure:"ro"`

	// READ-ONLY; The monitoring status of the connection monitor.
	MonitoringStatus *string `json:"monitoringStatus,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the connection monitor.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The date and time when the connection monitor was started.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`
}

// ConnectionMonitorSource - Describes the source of connection monitor.
type ConnectionMonitorSource struct {
	// REQUIRED; The ID of the resource used as the source by connection monitor.
	ResourceID *string `json:"resourceId,omitempty"`

	// The source port used by connection monitor.
	Port *int32 `json:"port,omitempty"`
}

// ConnectionMonitorSuccessThreshold - Describes the threshold for declaring a test successful.
type ConnectionMonitorSuccessThreshold struct {
	// The maximum percentage of failed checks permitted for a test to evaluate as successful.
	ChecksFailedPercent *int32 `json:"checksFailedPercent,omitempty"`

	// The maximum round-trip time in milliseconds permitted for a test to evaluate as successful.
	RoundTripTimeMs *float32 `json:"roundTripTimeMs,omitempty"`
}

// ConnectionMonitorTCPConfiguration - Describes the TCP configuration.
type ConnectionMonitorTCPConfiguration struct {
	// Destination port behavior.
	DestinationPortBehavior *DestinationPortBehavior `json:"destinationPortBehavior,omitempty"`

	// Value indicating whether path evaluation with trace route should be disabled.
	DisableTraceRoute *bool `json:"disableTraceRoute,omitempty"`

	// The port to connect to.
	Port *int32 `json:"port,omitempty"`
}

// ConnectionMonitorTestConfiguration - Describes a connection monitor test configuration.
type ConnectionMonitorTestConfiguration struct {
	// REQUIRED; The name of the connection monitor test configuration.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The protocol to use in test evaluation.
	Protocol *ConnectionMonitorTestConfigurationProtocol `json:"protocol,omitempty"`

	// The parameters used to perform test evaluation over HTTP.
	HTTPConfiguration *ConnectionMonitorHTTPConfiguration `json:"httpConfiguration,omitempty"`

	// The parameters used to perform test evaluation over ICMP.
	IcmpConfiguration *ConnectionMonitorIcmpConfiguration `json:"icmpConfiguration,omitempty"`

	// The preferred IP version to use in test evaluation. The connection monitor may choose to use a different version depending
	// on other parameters.
	PreferredIPVersion *PreferredIPVersion `json:"preferredIPVersion,omitempty"`

	// The threshold for declaring a test successful.
	SuccessThreshold *ConnectionMonitorSuccessThreshold `json:"successThreshold,omitempty"`

	// The parameters used to perform test evaluation over TCP.
	TCPConfiguration *ConnectionMonitorTCPConfiguration `json:"tcpConfiguration,omitempty"`

	// The frequency of test evaluation, in seconds.
	TestFrequencySec *int32 `json:"testFrequencySec,omitempty"`
}

// ConnectionMonitorTestGroup - Describes the connection monitor test group.
type ConnectionMonitorTestGroup struct {
	// REQUIRED; List of destination endpoint names.
	Destinations []*string `json:"destinations,omitempty"`

	// REQUIRED; The name of the connection monitor test group.
	Name *string `json:"name,omitempty"`

	// REQUIRED; List of source endpoint names.
	Sources []*string `json:"sources,omitempty"`

	// REQUIRED; List of test configuration names.
	TestConfigurations []*string `json:"testConfigurations,omitempty"`

	// Value indicating whether test group is disabled.
	Disable *bool `json:"disable,omitempty"`
}

// ConnectionMonitorWorkspaceSettings - Describes the settings for producing output into a log analytics workspace.
type ConnectionMonitorWorkspaceSettings struct {
	// Log analytics workspace resource ID.
	WorkspaceResourceID *string `json:"workspaceResourceId,omitempty"`
}

// ConnectionMonitorsClientBeginCreateOrUpdateOptions contains the optional parameters for the ConnectionMonitorsClient.BeginCreateOrUpdate
// method.
type ConnectionMonitorsClientBeginCreateOrUpdateOptions struct {
	// Value indicating whether connection monitor V1 should be migrated to V2 format.
	Migrate *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConnectionMonitorsClientBeginDeleteOptions contains the optional parameters for the ConnectionMonitorsClient.BeginDelete
// method.
type ConnectionMonitorsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConnectionMonitorsClientBeginQueryOptions contains the optional parameters for the ConnectionMonitorsClient.BeginQuery
// method.
type ConnectionMonitorsClientBeginQueryOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConnectionMonitorsClientBeginStartOptions contains the optional parameters for the ConnectionMonitorsClient.BeginStart
// method.
type ConnectionMonitorsClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConnectionMonitorsClientBeginStopOptions contains the optional parameters for the ConnectionMonitorsClient.BeginStop method.
type ConnectionMonitorsClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConnectionMonitorsClientGetOptions contains the optional parameters for the ConnectionMonitorsClient.Get method.
type ConnectionMonitorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConnectionMonitorsClientListOptions contains the optional parameters for the ConnectionMonitorsClient.List method.
type ConnectionMonitorsClientListOptions struct {
	// placeholder for future optional parameters
}

// ConnectionMonitorsClientUpdateTagsOptions contains the optional parameters for the ConnectionMonitorsClient.UpdateTags
// method.
type ConnectionMonitorsClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// ConnectionResetSharedKey - The virtual network connection reset shared key.
type ConnectionResetSharedKey struct {
	// REQUIRED; The virtual network connection reset shared key length, should between 1 and 128.
	KeyLength *int32 `json:"keyLength,omitempty"`
}

// ConnectionSharedKey - Response for GetConnectionSharedKey API service call.
type ConnectionSharedKey struct {
	// REQUIRED; The virtual network connection shared key value.
	Value *string `json:"value,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`
}

// ConnectionStateSnapshot - Connection state snapshot.
type ConnectionStateSnapshot struct {
	// Average latency in ms.
	AvgLatencyInMs *int64 `json:"avgLatencyInMs,omitempty"`

	// The connection state.
	ConnectionState *ConnectionState `json:"connectionState,omitempty"`

	// The end time of the connection snapshot.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Connectivity analysis evaluation state.
	EvaluationState *EvaluationState `json:"evaluationState,omitempty"`

	// Maximum latency in ms.
	MaxLatencyInMs *int64 `json:"maxLatencyInMs,omitempty"`

	// Minimum latency in ms.
	MinLatencyInMs *int64 `json:"minLatencyInMs,omitempty"`

	// The number of failed probes.
	ProbesFailed *int64 `json:"probesFailed,omitempty"`

	// The number of sent probes.
	ProbesSent *int64 `json:"probesSent,omitempty"`

	// The start time of the connection snapshot.
	StartTime *time.Time `json:"startTime,omitempty"`

	// READ-ONLY; List of hops between the source and the destination.
	Hops []*ConnectivityHop `json:"hops,omitempty" azure:"ro"`
}

// ConnectivityConfiguration - The network manager connectivity configuration resource
type ConnectivityConfiguration struct {
	// Properties of a network manager connectivity configuration
	Properties *ConnectivityConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConnectivityConfigurationListResult - Result of the request to list network manager connectivity configurations. It contains
// a list of configurations and a link to get the next set of results.
type ConnectivityConfigurationListResult struct {
	// Gets the URL to get the next page of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets a page of Connectivity Configurations
	Value []*ConnectivityConfiguration `json:"value,omitempty"`
}

// ConnectivityConfigurationProperties - Properties of network manager connectivity configuration
type ConnectivityConfigurationProperties struct {
	// REQUIRED; Groups for configuration
	AppliesToGroups []*ConnectivityGroupItem `json:"appliesToGroups,omitempty"`

	// REQUIRED; Connectivity topology type.
	ConnectivityTopology *ConnectivityTopology `json:"connectivityTopology,omitempty"`

	// Flag if need to remove current existing peerings.
	DeleteExistingPeering *DeleteExistingPeering `json:"deleteExistingPeering,omitempty"`

	// A description of the connectivity configuration.
	Description *string `json:"description,omitempty"`

	// List of hubItems
	Hubs []*Hub `json:"hubs,omitempty"`

	// Flag if global mesh is supported.
	IsGlobal *IsGlobal `json:"isGlobal,omitempty"`

	// READ-ONLY; The provisioning state of the connectivity configuration resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ConnectivityConfigurationsClientBeginDeleteOptions contains the optional parameters for the ConnectivityConfigurationsClient.BeginDelete
// method.
type ConnectivityConfigurationsClientBeginDeleteOptions struct {
	// Deletes the resource even if it is part of a deployed configuration. If the configuration has been deployed, the service
	// will do a cleanup deployment in the background, prior to the delete.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConnectivityConfigurationsClientCreateOrUpdateOptions contains the optional parameters for the ConnectivityConfigurationsClient.CreateOrUpdate
// method.
type ConnectivityConfigurationsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConnectivityConfigurationsClientGetOptions contains the optional parameters for the ConnectivityConfigurationsClient.Get
// method.
type ConnectivityConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConnectivityConfigurationsClientListOptions contains the optional parameters for the ConnectivityConfigurationsClient.List
// method.
type ConnectivityConfigurationsClientListOptions struct {
	// SkipToken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skipToken parameter that
	// specifies a starting point to use for subsequent calls.
	SkipToken *string
	// An optional query parameter which specifies the maximum number of records to be returned by the server.
	Top *int32
}

// ConnectivityDestination - Parameters that define destination of connection.
type ConnectivityDestination struct {
	// The IP address or URI the resource to which a connection attempt will be made.
	Address *string `json:"address,omitempty"`

	// Port on which check connectivity will be performed.
	Port *int32 `json:"port,omitempty"`

	// The ID of the resource to which a connection attempt will be made.
	ResourceID *string `json:"resourceId,omitempty"`
}

// ConnectivityGroupItem - Connectivity group item.
type ConnectivityGroupItem struct {
	// REQUIRED; Group connectivity type.
	GroupConnectivity *GroupConnectivity `json:"groupConnectivity,omitempty"`

	// REQUIRED; Network group Id.
	NetworkGroupID *string `json:"networkGroupId,omitempty"`

	// Flag if global is supported.
	IsGlobal *IsGlobal `json:"isGlobal,omitempty"`

	// Flag if need to use hub gateway.
	UseHubGateway *UseHubGateway `json:"useHubGateway,omitempty"`
}

// ConnectivityHop - Information about a hop between the source and the destination.
type ConnectivityHop struct {
	// READ-ONLY; The IP address of the hop.
	Address *string `json:"address,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the hop.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; List of issues.
	Issues []*ConnectivityIssue `json:"issues,omitempty" azure:"ro"`

	// READ-ONLY; List of hop links.
	Links []*HopLink `json:"links,omitempty" azure:"ro"`

	// READ-ONLY; List of next hop identifiers.
	NextHopIDs []*string `json:"nextHopIds,omitempty" azure:"ro"`

	// READ-ONLY; List of previous hop identifiers.
	PreviousHopIDs []*string `json:"previousHopIds,omitempty" azure:"ro"`

	// READ-ONLY; List of previous hop links.
	PreviousLinks []*HopLink `json:"previousLinks,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the resource corresponding to this hop.
	ResourceID *string `json:"resourceId,omitempty" azure:"ro"`

	// READ-ONLY; The type of the hop.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConnectivityInformation - Information on the connectivity status.
type ConnectivityInformation struct {
	// READ-ONLY; Average latency in milliseconds.
	AvgLatencyInMs *int32 `json:"avgLatencyInMs,omitempty" azure:"ro"`

	// READ-ONLY; The connection status.
	ConnectionStatus *ConnectionStatus `json:"connectionStatus,omitempty" azure:"ro"`

	// READ-ONLY; List of hops between the source and the destination.
	Hops []*ConnectivityHop `json:"hops,omitempty" azure:"ro"`

	// READ-ONLY; Maximum latency in milliseconds.
	MaxLatencyInMs *int32 `json:"maxLatencyInMs,omitempty" azure:"ro"`

	// READ-ONLY; Minimum latency in milliseconds.
	MinLatencyInMs *int32 `json:"minLatencyInMs,omitempty" azure:"ro"`

	// READ-ONLY; Number of failed probes.
	ProbesFailed *int32 `json:"probesFailed,omitempty" azure:"ro"`

	// READ-ONLY; Total number of probes sent.
	ProbesSent *int32 `json:"probesSent,omitempty" azure:"ro"`
}

// ConnectivityIssue - Information about an issue encountered in the process of checking for connectivity.
type ConnectivityIssue struct {
	// READ-ONLY; Provides additional context on the issue.
	Context []map[string]*string `json:"context,omitempty" azure:"ro"`

	// READ-ONLY; The origin of the issue.
	Origin *Origin `json:"origin,omitempty" azure:"ro"`

	// READ-ONLY; The severity of the issue.
	Severity *Severity `json:"severity,omitempty" azure:"ro"`

	// READ-ONLY; The type of issue.
	Type *IssueType `json:"type,omitempty" azure:"ro"`
}

// ConnectivityParameters - Parameters that determine how the connectivity check will be performed.
type ConnectivityParameters struct {
	// REQUIRED; The destination of connection.
	Destination *ConnectivityDestination `json:"destination,omitempty"`

	// REQUIRED; The source of the connection.
	Source *ConnectivitySource `json:"source,omitempty"`

	// Preferred IP version of the connection.
	PreferredIPVersion *IPVersion `json:"preferredIPVersion,omitempty"`

	// Network protocol.
	Protocol *Protocol `json:"protocol,omitempty"`

	// Configuration of the protocol.
	ProtocolConfiguration *ProtocolConfiguration `json:"protocolConfiguration,omitempty"`
}

// ConnectivitySource - Parameters that define the source of the connection.
type ConnectivitySource struct {
	// REQUIRED; The ID of the resource from which a connectivity check will be initiated.
	ResourceID *string `json:"resourceId,omitempty"`

	// The source port from which a connectivity check will be performed.
	Port *int32 `json:"port,omitempty"`
}

// Container - Reference to container resource in remote resource provider.
type Container struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`
}

// ContainerNetworkInterface - Container network interface child resource.
type ContainerNetworkInterface struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Container network interface properties.
	Properties *ContainerNetworkInterfacePropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Sub Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ContainerNetworkInterfaceConfiguration - Container network interface configuration child resource.
type ContainerNetworkInterfaceConfiguration struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Container network interface configuration properties.
	Properties *ContainerNetworkInterfaceConfigurationPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Sub Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ContainerNetworkInterfaceConfigurationPropertiesFormat - Container network interface configuration properties.
type ContainerNetworkInterfaceConfigurationPropertiesFormat struct {
	// A list of container network interfaces created from this container network interface configuration.
	ContainerNetworkInterfaces []*SubResource `json:"containerNetworkInterfaces,omitempty"`

	// A list of ip configurations of the container network interface configuration.
	IPConfigurations []*IPConfigurationProfile `json:"ipConfigurations,omitempty"`

	// READ-ONLY; The provisioning state of the container network interface configuration resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ContainerNetworkInterfaceIPConfiguration - The ip configuration for a container network interface.
type ContainerNetworkInterfaceIPConfiguration struct {
	// The name of the resource. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the container network interface IP configuration.
	Properties *ContainerNetworkInterfaceIPConfigurationPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Sub Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ContainerNetworkInterfaceIPConfigurationPropertiesFormat - Properties of the container network interface IP configuration.
type ContainerNetworkInterfaceIPConfigurationPropertiesFormat struct {
	// READ-ONLY; The provisioning state of the container network interface IP configuration resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ContainerNetworkInterfacePropertiesFormat - Properties of container network interface.
type ContainerNetworkInterfacePropertiesFormat struct {
	// Reference to the container to which this container network interface is attached.
	Container *Container `json:"container,omitempty"`

	// READ-ONLY; Container network interface configuration from which this container network interface is created.
	ContainerNetworkInterfaceConfiguration *ContainerNetworkInterfaceConfiguration `json:"containerNetworkInterfaceConfiguration,omitempty" azure:"ro"`

	// READ-ONLY; Reference to the ip configuration on this container nic.
	IPConfigurations []*ContainerNetworkInterfaceIPConfiguration `json:"ipConfigurations,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the container network interface resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// CrossTenantScopes - Cross tenant scopes.
type CrossTenantScopes struct {
	// READ-ONLY; List of management groups.
	ManagementGroups []*string `json:"managementGroups,omitempty" azure:"ro"`

	// READ-ONLY; List of subscriptions.
	Subscriptions []*string `json:"subscriptions,omitempty" azure:"ro"`

	// READ-ONLY; Tenant ID.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// CustomDNSConfigPropertiesFormat - Contains custom Dns resolution configuration from customer.
type CustomDNSConfigPropertiesFormat struct {
	// Fqdn that resolves to private endpoint ip address.
	Fqdn *string `json:"fqdn,omitempty"`

	// A list of private ip addresses of the private endpoint.
	IPAddresses []*string `json:"ipAddresses,omitempty"`
}

// CustomIPPrefix - Custom IP prefix resource.
type CustomIPPrefix struct {
	// The extended location of the custom IP prefix.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Custom IP prefix properties.
	Properties *CustomIPPrefixPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// A list of availability zones denoting the IP allocated for the resource needs to come from.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CustomIPPrefixListResult - Response for ListCustomIpPrefixes API service call.
type CustomIPPrefixListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of Custom IP prefixes that exists in a resource group.
	Value []*CustomIPPrefix `json:"value,omitempty"`
}

// CustomIPPrefixPropertiesFormat - Custom IP prefix properties.
type CustomIPPrefixPropertiesFormat struct {
	// Authorization message for WAN validation.
	AuthorizationMessage *string `json:"authorizationMessage,omitempty"`

	// The prefix range in CIDR notation. Should include the start address and the prefix length.
	Cidr *string `json:"cidr,omitempty"`

	// The commissioned state of the Custom IP Prefix.
	CommissionedState *CommissionedState `json:"commissionedState,omitempty"`

	// The Parent CustomIpPrefix for IPv6 /64 CustomIpPrefix.
	CustomIPPrefixParent *SubResource `json:"customIpPrefixParent,omitempty"`

	// Whether to Advertise the range to Internet.
	NoInternetAdvertise *bool `json:"noInternetAdvertise,omitempty"`

	// Signed message for WAN validation.
	SignedMessage *string `json:"signedMessage,omitempty"`

	// READ-ONLY; The list of all Children for IPv6 /48 CustomIpPrefix.
	ChildCustomIPPrefixes []*SubResource `json:"childCustomIpPrefixes,omitempty" azure:"ro"`

	// READ-ONLY; The reason why resource is in failed state.
	FailedReason *string `json:"failedReason,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the custom IP prefix resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The list of all referenced PublicIpPrefixes.
	PublicIPPrefixes []*SubResource `json:"publicIpPrefixes,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the custom IP prefix resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`
}

// CustomIPPrefixesClientBeginCreateOrUpdateOptions contains the optional parameters for the CustomIPPrefixesClient.BeginCreateOrUpdate
// method.
type CustomIPPrefixesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CustomIPPrefixesClientBeginDeleteOptions contains the optional parameters for the CustomIPPrefixesClient.BeginDelete method.
type CustomIPPrefixesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CustomIPPrefixesClientGetOptions contains the optional parameters for the CustomIPPrefixesClient.Get method.
type CustomIPPrefixesClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// CustomIPPrefixesClientListAllOptions contains the optional parameters for the CustomIPPrefixesClient.ListAll method.
type CustomIPPrefixesClientListAllOptions struct {
	// placeholder for future optional parameters
}

// CustomIPPrefixesClientListOptions contains the optional parameters for the CustomIPPrefixesClient.List method.
type CustomIPPrefixesClientListOptions struct {
	// placeholder for future optional parameters
}

// CustomIPPrefixesClientUpdateTagsOptions contains the optional parameters for the CustomIPPrefixesClient.UpdateTags method.
type CustomIPPrefixesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// DNSNameAvailabilityResult - Response for the CheckDnsNameAvailability API service call.
type DNSNameAvailabilityResult struct {
	// Domain availability (True/False).
	Available *bool `json:"available,omitempty"`
}

// DNSSettings - DNS Proxy Settings in Firewall Policy.
type DNSSettings struct {
	// Enable DNS Proxy on Firewalls attached to the Firewall Policy.
	EnableProxy *bool `json:"enableProxy,omitempty"`

	// FQDNs in Network Rules are supported when set to true.
	RequireProxyForNetworkRules *bool `json:"requireProxyForNetworkRules,omitempty"`

	// List of Custom DNS Servers.
	Servers []*string `json:"servers,omitempty"`
}

// DdosCustomPoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the DdosCustomPoliciesClient.BeginCreateOrUpdate
// method.
type DdosCustomPoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DdosCustomPoliciesClientBeginDeleteOptions contains the optional parameters for the DdosCustomPoliciesClient.BeginDelete
// method.
type DdosCustomPoliciesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DdosCustomPoliciesClientGetOptions contains the optional parameters for the DdosCustomPoliciesClient.Get method.
type DdosCustomPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DdosCustomPoliciesClientUpdateTagsOptions contains the optional parameters for the DdosCustomPoliciesClient.UpdateTags
// method.
type DdosCustomPoliciesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// DdosCustomPolicy - A DDoS custom policy in a resource group.
type DdosCustomPolicy struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the DDoS custom policy.
	Properties *DdosCustomPolicyPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DdosCustomPolicyPropertiesFormat - DDoS custom policy properties.
type DdosCustomPolicyPropertiesFormat struct {
	// The protocol-specific DDoS policy customization parameters.
	ProtocolCustomSettings []*ProtocolCustomSettingsFormat `json:"protocolCustomSettings,omitempty"`

	// READ-ONLY; The provisioning state of the DDoS custom policy resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The list of public IPs associated with the DDoS custom policy resource. This list is read-only.
	PublicIPAddresses []*SubResource `json:"publicIPAddresses,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the DDoS custom policy resource. It uniquely identifies the resource, even if
	// the user changes its name or migrate the resource across subscriptions or resource groups.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`
}

// DdosProtectionPlan - A DDoS protection plan in a resource group.
type DdosProtectionPlan struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the DDoS protection plan.
	Properties *DdosProtectionPlanPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DdosProtectionPlanListResult - A list of DDoS protection plans.
type DdosProtectionPlanListResult struct {
	// A list of DDoS protection plans.
	Value []*DdosProtectionPlan `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DdosProtectionPlanPropertiesFormat - DDoS protection plan properties.
type DdosProtectionPlanPropertiesFormat struct {
	// READ-ONLY; The provisioning state of the DDoS protection plan resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the DDoS protection plan resource. It uniquely identifies the resource, even if
	// the user changes its name or migrate the resource across subscriptions or resource groups.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`

	// READ-ONLY; The list of virtual networks associated with the DDoS protection plan resource. This list is read-only.
	VirtualNetworks []*SubResource `json:"virtualNetworks,omitempty" azure:"ro"`
}

// DdosProtectionPlansClientBeginCreateOrUpdateOptions contains the optional parameters for the DdosProtectionPlansClient.BeginCreateOrUpdate
// method.
type DdosProtectionPlansClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DdosProtectionPlansClientBeginDeleteOptions contains the optional parameters for the DdosProtectionPlansClient.BeginDelete
// method.
type DdosProtectionPlansClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DdosProtectionPlansClientGetOptions contains the optional parameters for the DdosProtectionPlansClient.Get method.
type DdosProtectionPlansClientGetOptions struct {
	// placeholder for future optional parameters
}

// DdosProtectionPlansClientListByResourceGroupOptions contains the optional parameters for the DdosProtectionPlansClient.ListByResourceGroup
// method.
type DdosProtectionPlansClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// DdosProtectionPlansClientListOptions contains the optional parameters for the DdosProtectionPlansClient.List method.
type DdosProtectionPlansClientListOptions struct {
	// placeholder for future optional parameters
}

// DdosProtectionPlansClientUpdateTagsOptions contains the optional parameters for the DdosProtectionPlansClient.UpdateTags
// method.
type DdosProtectionPlansClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// DdosSettings - Contains the DDoS protection settings of the public IP.
type DdosSettings struct {
	// The DDoS custom policy associated with the public IP.
	DdosCustomPolicy *SubResource `json:"ddosCustomPolicy,omitempty"`

	// Enables DDoS protection on the public IP.
	ProtectedIP *bool `json:"protectedIP,omitempty"`

	// The DDoS protection policy customizability of the public IP. Only standard coverage will have the ability to be customized.
	ProtectionCoverage *DdosSettingsProtectionCoverage `json:"protectionCoverage,omitempty"`
}

// DefaultAdminPropertiesFormat - Security default admin rule resource.
type DefaultAdminPropertiesFormat struct {
	// Default rule flag.
	Flag *string `json:"flag,omitempty"`

	// READ-ONLY; Indicates the access allowed for this particular rule
	Access *SecurityConfigurationRuleAccess `json:"access,omitempty" azure:"ro"`

	// READ-ONLY; A description for this rule. Restricted to 140 chars.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The destination port ranges.
	DestinationPortRanges []*string `json:"destinationPortRanges,omitempty" azure:"ro"`

	// READ-ONLY; The destination address prefixes. CIDR or destination IP ranges.
	Destinations []*AddressPrefixItem `json:"destinations,omitempty" azure:"ro"`

	// READ-ONLY; Indicates if the traffic matched against the rule in inbound or outbound.
	Direction *SecurityConfigurationRuleDirection `json:"direction,omitempty" azure:"ro"`

	// READ-ONLY; The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule
	// in the collection. The lower the priority number, the higher the priority of the rule.
	Priority *int32 `json:"priority,omitempty" azure:"ro"`

	// READ-ONLY; Network protocol this rule applies to.
	Protocol *SecurityConfigurationRuleProtocol `json:"protocol,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The source port ranges.
	SourcePortRanges []*string `json:"sourcePortRanges,omitempty" azure:"ro"`

	// READ-ONLY; The CIDR or source IP ranges.
	Sources []*AddressPrefixItem `json:"sources,omitempty" azure:"ro"`
}

// DefaultAdminRule - Network default admin rule.
type DefaultAdminRule struct {
	// REQUIRED; Whether the rule is custom or default.
	Kind *AdminRuleKind `json:"kind,omitempty"`

	// Indicates the properties of the security admin rule
	Properties *DefaultAdminPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetBaseAdminRule implements the BaseAdminRuleClassification interface for type DefaultAdminRule.
func (d *DefaultAdminRule) GetBaseAdminRule() *BaseAdminRule {
	return &BaseAdminRule{
		Kind:       d.Kind,
		SystemData: d.SystemData,
		ID:         d.ID,
		Name:       d.Name,
		Type:       d.Type,
		Etag:       d.Etag,
	}
}

// DefaultSecurityRulesClientGetOptions contains the optional parameters for the DefaultSecurityRulesClient.Get method.
type DefaultSecurityRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DefaultSecurityRulesClientListOptions contains the optional parameters for the DefaultSecurityRulesClient.List method.
type DefaultSecurityRulesClientListOptions struct {
	// placeholder for future optional parameters
}

// Delegation - Details the service to which the subnet is delegated.
type Delegation struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a subnet. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the subnet.
	Properties *ServiceDelegationPropertiesFormat `json:"properties,omitempty"`

	// Resource type.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// DeviceProperties - List of properties of the device.
type DeviceProperties struct {
	// Model of the device.
	DeviceModel *string `json:"deviceModel,omitempty"`

	// Name of the device Vendor.
	DeviceVendor *string `json:"deviceVendor,omitempty"`

	// Link speed.
	LinkSpeedInMbps *int32 `json:"linkSpeedInMbps,omitempty"`
}

// DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for
// a subnet overrides VNET DHCP options.
type DhcpOptions struct {
	// The list of DNS servers IP addresses.
	DNSServers []*string `json:"dnsServers,omitempty"`
}

// Dimension of the metric.
type Dimension struct {
	// The display name of the dimension.
	DisplayName *string `json:"displayName,omitempty"`

	// The internal name of the dimension.
	InternalName *string `json:"internalName,omitempty"`

	// The name of the dimension.
	Name *string `json:"name,omitempty"`
}

// DscpConfiguration - Differentiated Services Code Point configuration for any given network interface
type DscpConfiguration struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the network interface.
	Properties *DscpConfigurationPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DscpConfigurationClientBeginCreateOrUpdateOptions contains the optional parameters for the DscpConfigurationClient.BeginCreateOrUpdate
// method.
type DscpConfigurationClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DscpConfigurationClientBeginDeleteOptions contains the optional parameters for the DscpConfigurationClient.BeginDelete
// method.
type DscpConfigurationClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DscpConfigurationClientGetOptions contains the optional parameters for the DscpConfigurationClient.Get method.
type DscpConfigurationClientGetOptions struct {
	// placeholder for future optional parameters
}

// DscpConfigurationClientListAllOptions contains the optional parameters for the DscpConfigurationClient.ListAll method.
type DscpConfigurationClientListAllOptions struct {
	// placeholder for future optional parameters
}

// DscpConfigurationClientListOptions contains the optional parameters for the DscpConfigurationClient.List method.
type DscpConfigurationClientListOptions struct {
	// placeholder for future optional parameters
}

// DscpConfigurationListResult - Response for the DscpConfigurationList API service call.
type DscpConfigurationListResult struct {
	// A list of dscp configurations in a resource group.
	Value []*DscpConfiguration `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DscpConfigurationPropertiesFormat - Differentiated Services Code Point configuration properties.
type DscpConfigurationPropertiesFormat struct {
	// Destination IP ranges.
	DestinationIPRanges []*QosIPRange `json:"destinationIpRanges,omitempty"`

	// Destination port ranges.
	DestinationPortRanges []*QosPortRange `json:"destinationPortRanges,omitempty"`

	// List of markings to be used in the configuration.
	Markings []*int32 `json:"markings,omitempty"`

	// RNM supported protocol types.
	Protocol *ProtocolType `json:"protocol,omitempty"`

	// QoS object definitions
	QosDefinitionCollection []*QosDefinition `json:"qosDefinitionCollection,omitempty"`

	// Source IP ranges.
	SourceIPRanges []*QosIPRange `json:"sourceIpRanges,omitempty"`

	// Sources port ranges.
	SourcePortRanges []*QosPortRange `json:"sourcePortRanges,omitempty"`

	// READ-ONLY; Associated Network Interfaces to the DSCP Configuration.
	AssociatedNetworkInterfaces []*Interface `json:"associatedNetworkInterfaces,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the DSCP Configuration resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Qos Collection ID generated by RNM.
	QosCollectionID *string `json:"qosCollectionId,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the DSCP Configuration resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`
}

// EffectiveBaseSecurityAdminRuleClassification provides polymorphic access to related types.
// Call the interface's GetEffectiveBaseSecurityAdminRule() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *EffectiveBaseSecurityAdminRule, *EffectiveDefaultSecurityAdminRule, *EffectiveSecurityAdminRule
type EffectiveBaseSecurityAdminRuleClassification interface {
	// GetEffectiveBaseSecurityAdminRule returns the EffectiveBaseSecurityAdminRule content of the underlying type.
	GetEffectiveBaseSecurityAdminRule() *EffectiveBaseSecurityAdminRule
}

// EffectiveBaseSecurityAdminRule - Network base admin rule.
type EffectiveBaseSecurityAdminRule struct {
	// REQUIRED; Whether the rule is custom or default.
	Kind *EffectiveAdminRuleKind `json:"kind,omitempty"`

	// A description of the security admin configuration.
	ConfigurationDescription *string `json:"configurationDescription,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Groups for rule collection
	RuleCollectionAppliesToGroups []*ManagerSecurityGroupItem `json:"ruleCollectionAppliesToGroups,omitempty"`

	// A description of the rule collection.
	RuleCollectionDescription *string `json:"ruleCollectionDescription,omitempty"`

	// Effective configuration groups.
	RuleGroups []*ConfigurationGroup `json:"ruleGroups,omitempty"`
}

// GetEffectiveBaseSecurityAdminRule implements the EffectiveBaseSecurityAdminRuleClassification interface for type EffectiveBaseSecurityAdminRule.
func (e *EffectiveBaseSecurityAdminRule) GetEffectiveBaseSecurityAdminRule() *EffectiveBaseSecurityAdminRule {
	return e
}

// EffectiveConnectivityConfiguration - The network manager effective connectivity configuration
type EffectiveConnectivityConfiguration struct {
	// Effective configuration groups.
	ConfigurationGroups []*ConfigurationGroup `json:"configurationGroups,omitempty"`

	// Connectivity configuration ID.
	ID *string `json:"id,omitempty"`

	// Properties of a network manager connectivity configuration
	Properties *ConnectivityConfigurationProperties `json:"properties,omitempty"`
}

// EffectiveDefaultSecurityAdminRule - Network default admin rule.
type EffectiveDefaultSecurityAdminRule struct {
	// REQUIRED; Whether the rule is custom or default.
	Kind *EffectiveAdminRuleKind `json:"kind,omitempty"`

	// A description of the security admin configuration.
	ConfigurationDescription *string `json:"configurationDescription,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Indicates the properties of the default security admin rule
	Properties *DefaultAdminPropertiesFormat `json:"properties,omitempty"`

	// Groups for rule collection
	RuleCollectionAppliesToGroups []*ManagerSecurityGroupItem `json:"ruleCollectionAppliesToGroups,omitempty"`

	// A description of the rule collection.
	RuleCollectionDescription *string `json:"ruleCollectionDescription,omitempty"`

	// Effective configuration groups.
	RuleGroups []*ConfigurationGroup `json:"ruleGroups,omitempty"`
}

// GetEffectiveBaseSecurityAdminRule implements the EffectiveBaseSecurityAdminRuleClassification interface for type EffectiveDefaultSecurityAdminRule.
func (e *EffectiveDefaultSecurityAdminRule) GetEffectiveBaseSecurityAdminRule() *EffectiveBaseSecurityAdminRule {
	return &EffectiveBaseSecurityAdminRule{
		ID:                            e.ID,
		ConfigurationDescription:      e.ConfigurationDescription,
		RuleCollectionDescription:     e.RuleCollectionDescription,
		RuleCollectionAppliesToGroups: e.RuleCollectionAppliesToGroups,
		RuleGroups:                    e.RuleGroups,
		Kind:                          e.Kind,
	}
}

// EffectiveNetworkSecurityGroup - Effective network security group.
type EffectiveNetworkSecurityGroup struct {
	// Associated resources.
	Association *EffectiveNetworkSecurityGroupAssociation `json:"association,omitempty"`

	// A collection of effective security rules.
	EffectiveSecurityRules []*EffectiveNetworkSecurityRule `json:"effectiveSecurityRules,omitempty"`

	// The ID of network security group that is applied.
	NetworkSecurityGroup *SubResource `json:"networkSecurityGroup,omitempty"`

	// Mapping of tags to list of IP Addresses included within the tag.
	TagMap *string `json:"tagMap,omitempty"`
}

// EffectiveNetworkSecurityGroupAssociation - The effective network security group association.
type EffectiveNetworkSecurityGroupAssociation struct {
	// The ID of the network interface if assigned.
	NetworkInterface *SubResource `json:"networkInterface,omitempty"`

	// The ID of the Azure network manager if assigned.
	NetworkManager *SubResource `json:"networkManager,omitempty"`

	// The ID of the subnet if assigned.
	Subnet *SubResource `json:"subnet,omitempty"`
}

// EffectiveNetworkSecurityGroupListResult - Response for list effective network security groups API service call.
type EffectiveNetworkSecurityGroupListResult struct {
	// A list of effective network security groups.
	Value []*EffectiveNetworkSecurityGroup `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// EffectiveNetworkSecurityRule - Effective network security rules.
type EffectiveNetworkSecurityRule struct {
	// Whether network traffic is allowed or denied.
	Access *SecurityRuleAccess `json:"access,omitempty"`

	// The destination address prefix.
	DestinationAddressPrefix *string `json:"destinationAddressPrefix,omitempty"`

	// The destination address prefixes. Expected values include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer,
	// Internet), System Tags, and the asterisk (*).
	DestinationAddressPrefixes []*string `json:"destinationAddressPrefixes,omitempty"`

	// The destination port or range.
	DestinationPortRange *string `json:"destinationPortRange,omitempty"`

	// The destination port ranges. Expected values include a single integer between 0 and 65535, a range using '-' as separator
	// (e.g. 100-400), or an asterisk (*).
	DestinationPortRanges []*string `json:"destinationPortRanges,omitempty"`

	// The direction of the rule.
	Direction *SecurityRuleDirection `json:"direction,omitempty"`

	// Expanded destination address prefix.
	ExpandedDestinationAddressPrefix []*string `json:"expandedDestinationAddressPrefix,omitempty"`

	// The expanded source address prefix.
	ExpandedSourceAddressPrefix []*string `json:"expandedSourceAddressPrefix,omitempty"`

	// The name of the security rule specified by the user (if created by the user).
	Name *string `json:"name,omitempty"`

	// The priority of the rule.
	Priority *int32 `json:"priority,omitempty"`

	// The network protocol this rule applies to.
	Protocol *EffectiveSecurityRuleProtocol `json:"protocol,omitempty"`

	// The source address prefix.
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`

	// The source address prefixes. Expected values include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet),
	// System Tags, and the asterisk (*).
	SourceAddressPrefixes []*string `json:"sourceAddressPrefixes,omitempty"`

	// The source port or range.
	SourcePortRange *string `json:"sourcePortRange,omitempty"`

	// The source port ranges. Expected values include a single integer between 0 and 65535, a range using '-' as separator (e.g.
	// 100-400), or an asterisk (*).
	SourcePortRanges []*string `json:"sourcePortRanges,omitempty"`
}

// EffectiveRoute - Effective Route.
type EffectiveRoute struct {
	// The address prefixes of the effective routes in CIDR notation.
	AddressPrefix []*string `json:"addressPrefix,omitempty"`

	// If true, on-premises routes are not propagated to the network interfaces in the subnet.
	DisableBgpRoutePropagation *bool `json:"disableBgpRoutePropagation,omitempty"`

	// The name of the user defined route. This is optional.
	Name *string `json:"name,omitempty"`

	// The IP address of the next hop of the effective route.
	NextHopIPAddress []*string `json:"nextHopIpAddress,omitempty"`

	// The type of Azure hop the packet should be sent to.
	NextHopType *RouteNextHopType `json:"nextHopType,omitempty"`

	// Who created the route.
	Source *EffectiveRouteSource `json:"source,omitempty"`

	// The value of effective route.
	State *EffectiveRouteState `json:"state,omitempty"`
}

// EffectiveRouteListResult - Response for list effective route API service call.
type EffectiveRouteListResult struct {
	// A list of effective routes.
	Value []*EffectiveRoute `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// EffectiveRoutesParameters - The parameters specifying the resource whose effective routes are being requested.
type EffectiveRoutesParameters struct {
	// The resource whose effective routes are being requested.
	ResourceID *string `json:"resourceId,omitempty"`

	// The type of the specified resource like RouteTable, ExpressRouteConnection, HubVirtualNetworkConnection, VpnConnection
	// and P2SConnection.
	VirtualWanResourceType *string `json:"virtualWanResourceType,omitempty"`
}

// EffectiveSecurityAdminRule - Network admin rule.
type EffectiveSecurityAdminRule struct {
	// REQUIRED; Whether the rule is custom or default.
	Kind *EffectiveAdminRuleKind `json:"kind,omitempty"`

	// A description of the security admin configuration.
	ConfigurationDescription *string `json:"configurationDescription,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Indicates the properties of the security admin rule
	Properties *AdminPropertiesFormat `json:"properties,omitempty"`

	// Groups for rule collection
	RuleCollectionAppliesToGroups []*ManagerSecurityGroupItem `json:"ruleCollectionAppliesToGroups,omitempty"`

	// A description of the rule collection.
	RuleCollectionDescription *string `json:"ruleCollectionDescription,omitempty"`

	// Effective configuration groups.
	RuleGroups []*ConfigurationGroup `json:"ruleGroups,omitempty"`
}

// GetEffectiveBaseSecurityAdminRule implements the EffectiveBaseSecurityAdminRuleClassification interface for type EffectiveSecurityAdminRule.
func (e *EffectiveSecurityAdminRule) GetEffectiveBaseSecurityAdminRule() *EffectiveBaseSecurityAdminRule {
	return &EffectiveBaseSecurityAdminRule{
		ID:                            e.ID,
		ConfigurationDescription:      e.ConfigurationDescription,
		RuleCollectionDescription:     e.RuleCollectionDescription,
		RuleCollectionAppliesToGroups: e.RuleCollectionAppliesToGroups,
		RuleGroups:                    e.RuleGroups,
		Kind:                          e.Kind,
	}
}

// EndpointServiceResult - Endpoint service.
type EndpointServiceResult struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// READ-ONLY; Name of the endpoint service.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the endpoint service.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EndpointServicesListResult - Response for the ListAvailableEndpointServices API service call.
type EndpointServicesListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of available endpoint services in a region.
	Value []*EndpointServiceResult `json:"value,omitempty"`
}

// Error - Common error representation.
type Error struct {
	// Error code.
	Code *string `json:"code,omitempty"`

	// Error details.
	Details []*ErrorDetails `json:"details,omitempty"`

	// Inner error message.
	InnerError *string `json:"innerError,omitempty"`

	// Error message.
	Message *string `json:"message,omitempty"`

	// Error target.
	Target *string `json:"target,omitempty"`
}

// ErrorDetails - Common error details representation.
type ErrorDetails struct {
	// Error code.
	Code *string `json:"code,omitempty"`

	// Error message.
	Message *string `json:"message,omitempty"`

	// Error target.
	Target *string `json:"target,omitempty"`
}

// ErrorResponse - The error object.
type ErrorResponse struct {
	// The error details object.
	Error *ErrorDetails `json:"error,omitempty"`
}

// EvaluatedNetworkSecurityGroup - Results of network security group evaluation.
type EvaluatedNetworkSecurityGroup struct {
	// Resource ID of nic or subnet to which network security group is applied.
	AppliedTo *string `json:"appliedTo,omitempty"`

	// Matched network security rule.
	MatchedRule *MatchedRule `json:"matchedRule,omitempty"`

	// Network security group ID.
	NetworkSecurityGroupID *string `json:"networkSecurityGroupId,omitempty"`

	// READ-ONLY; List of network security rules evaluation results.
	RulesEvaluationResult []*SecurityRulesEvaluationResult `json:"rulesEvaluationResult,omitempty" azure:"ro"`
}

// ExclusionManagedRule - Defines a managed rule to use for exclusion.
type ExclusionManagedRule struct {
	// REQUIRED; Identifier for the managed rule.
	RuleID *string `json:"ruleId,omitempty"`
}

// ExclusionManagedRuleGroup - Defines a managed rule group to use for exclusion.
type ExclusionManagedRuleGroup struct {
	// REQUIRED; The managed rule group for exclusion.
	RuleGroupName *string `json:"ruleGroupName,omitempty"`

	// List of rules that will be excluded. If none specified, all rules in the group will be excluded.
	Rules []*ExclusionManagedRule `json:"rules,omitempty"`
}

// ExclusionManagedRuleSet - Defines a managed rule set for Exclusions.
type ExclusionManagedRuleSet struct {
	// REQUIRED; Defines the rule set type to use.
	RuleSetType *string `json:"ruleSetType,omitempty"`

	// REQUIRED; Defines the version of the rule set to use.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty"`

	// Defines the rule groups to apply to the rule set.
	RuleGroups []*ExclusionManagedRuleGroup `json:"ruleGroups,omitempty"`
}

// ExplicitProxySettings - Explicit Proxy Settings in Firewall Policy.
type ExplicitProxySettings struct {
	// When set to true, explicit proxy mode is enabled.
	EnableExplicitProxy *bool `json:"enableExplicitProxy,omitempty"`

	// When set to true, pac file port and url needs to be provided.
	EnablePacFile *bool `json:"enablePacFile,omitempty"`

	// Port number for explicit proxy http protocol, cannot be greater than 64000.
	HTTPPort *int32 `json:"httpPort,omitempty"`

	// Port number for explicit proxy https protocol, cannot be greater than 64000.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`

	// SAS URL for PAC file.
	PacFile *string `json:"pacFile,omitempty"`

	// Port number for firewall to serve PAC file.
	PacFilePort *int32 `json:"pacFilePort,omitempty"`
}

// ExpressRouteCircuit resource.
type ExpressRouteCircuit struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the express route circuit.
	Properties *ExpressRouteCircuitPropertiesFormat `json:"properties,omitempty"`

	// The SKU.
	SKU *ExpressRouteCircuitSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExpressRouteCircuitArpTable - The ARP table associated with the ExpressRouteCircuit.
type ExpressRouteCircuitArpTable struct {
	// Entry age in minutes.
	Age *int32 `json:"age,omitempty"`

	// The IP address.
	IPAddress *string `json:"ipAddress,omitempty"`

	// Interface address.
	Interface *string `json:"interface,omitempty"`

	// The MAC address.
	MacAddress *string `json:"macAddress,omitempty"`
}

// ExpressRouteCircuitAuthorization - Authorization in an ExpressRouteCircuit resource.
type ExpressRouteCircuitAuthorization struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the express route circuit authorization.
	Properties *AuthorizationPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExpressRouteCircuitAuthorizationsClientBeginCreateOrUpdateOptions contains the optional parameters for the ExpressRouteCircuitAuthorizationsClient.BeginCreateOrUpdate
// method.
type ExpressRouteCircuitAuthorizationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteCircuitAuthorizationsClientBeginDeleteOptions contains the optional parameters for the ExpressRouteCircuitAuthorizationsClient.BeginDelete
// method.
type ExpressRouteCircuitAuthorizationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteCircuitAuthorizationsClientGetOptions contains the optional parameters for the ExpressRouteCircuitAuthorizationsClient.Get
// method.
type ExpressRouteCircuitAuthorizationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteCircuitAuthorizationsClientListOptions contains the optional parameters for the ExpressRouteCircuitAuthorizationsClient.List
// method.
type ExpressRouteCircuitAuthorizationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteCircuitConnection - Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.
type ExpressRouteCircuitConnection struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the express route circuit connection.
	Properties *ExpressRouteCircuitConnectionPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExpressRouteCircuitConnectionListResult - Response for ListConnections API service call retrieves all global reach connections
// that belongs to a Private Peering for an ExpressRouteCircuit.
type ExpressRouteCircuitConnectionListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The global reach connection associated with Private Peering in an ExpressRoute Circuit.
	Value []*ExpressRouteCircuitConnection `json:"value,omitempty"`
}

// ExpressRouteCircuitConnectionPropertiesFormat - Properties of the express route circuit connection.
type ExpressRouteCircuitConnectionPropertiesFormat struct {
	// /29 IP address space to carve out Customer addresses for tunnels.
	AddressPrefix *string `json:"addressPrefix,omitempty"`

	// The authorization key.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`

	// Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection.
	ExpressRouteCircuitPeering *SubResource `json:"expressRouteCircuitPeering,omitempty"`

	// IPv6 Address PrefixProperties of the express route circuit connection.
	IPv6CircuitConnectionConfig *IPv6CircuitConnectionConfig `json:"ipv6CircuitConnectionConfig,omitempty"`

	// Reference to Express Route Circuit Private Peering Resource of the peered circuit.
	PeerExpressRouteCircuitPeering *SubResource `json:"peerExpressRouteCircuitPeering,omitempty"`

	// READ-ONLY; Express Route Circuit connection state.
	CircuitConnectionStatus *CircuitConnectionStatus `json:"circuitConnectionStatus,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the express route circuit connection resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ExpressRouteCircuitConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the ExpressRouteCircuitConnectionsClient.BeginCreateOrUpdate
// method.
type ExpressRouteCircuitConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteCircuitConnectionsClientBeginDeleteOptions contains the optional parameters for the ExpressRouteCircuitConnectionsClient.BeginDelete
// method.
type ExpressRouteCircuitConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteCircuitConnectionsClientGetOptions contains the optional parameters for the ExpressRouteCircuitConnectionsClient.Get
// method.
type ExpressRouteCircuitConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteCircuitConnectionsClientListOptions contains the optional parameters for the ExpressRouteCircuitConnectionsClient.List
// method.
type ExpressRouteCircuitConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteCircuitListResult - Response for ListExpressRouteCircuit API service call.
type ExpressRouteCircuitListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of ExpressRouteCircuits in a resource group.
	Value []*ExpressRouteCircuit `json:"value,omitempty"`
}

// ExpressRouteCircuitPeering - Peering in an ExpressRouteCircuit resource.
type ExpressRouteCircuitPeering struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the express route circuit peering.
	Properties *ExpressRouteCircuitPeeringPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExpressRouteCircuitPeeringConfig - Specifies the peering configuration.
type ExpressRouteCircuitPeeringConfig struct {
	// The communities of bgp peering. Specified for microsoft peering.
	AdvertisedCommunities []*string `json:"advertisedCommunities,omitempty"`

	// The reference to AdvertisedPublicPrefixes.
	AdvertisedPublicPrefixes []*string `json:"advertisedPublicPrefixes,omitempty"`

	// The CustomerASN of the peering.
	CustomerASN *int32 `json:"customerASN,omitempty"`

	// The legacy mode of the peering.
	LegacyMode *int32 `json:"legacyMode,omitempty"`

	// The RoutingRegistryName of the configuration.
	RoutingRegistryName *string `json:"routingRegistryName,omitempty"`

	// READ-ONLY; The advertised public prefix state of the Peering resource.
	AdvertisedPublicPrefixesState *ExpressRouteCircuitPeeringAdvertisedPublicPrefixState `json:"advertisedPublicPrefixesState,omitempty" azure:"ro"`
}

// ExpressRouteCircuitPeeringID - ExpressRoute circuit peering identifier.
type ExpressRouteCircuitPeeringID struct {
	// The ID of the ExpressRoute circuit peering.
	ID *string `json:"id,omitempty"`
}

// ExpressRouteCircuitPeeringListResult - Response for ListPeering API service call retrieves all peerings that belong to
// an ExpressRouteCircuit.
type ExpressRouteCircuitPeeringListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The peerings in an express route circuit.
	Value []*ExpressRouteCircuitPeering `json:"value,omitempty"`
}

// ExpressRouteCircuitPeeringPropertiesFormat - Properties of the express route circuit peering.
type ExpressRouteCircuitPeeringPropertiesFormat struct {
	// The Azure ASN.
	AzureASN *int32 `json:"azureASN,omitempty"`

	// The list of circuit connections associated with Azure Private Peering for this circuit.
	Connections []*ExpressRouteCircuitConnection `json:"connections,omitempty"`

	// The ExpressRoute connection.
	ExpressRouteConnection *ExpressRouteConnectionID `json:"expressRouteConnection,omitempty"`

	// The GatewayManager Etag.
	GatewayManagerEtag *string `json:"gatewayManagerEtag,omitempty"`

	// The IPv6 peering configuration.
	IPv6PeeringConfig *IPv6ExpressRouteCircuitPeeringConfig `json:"ipv6PeeringConfig,omitempty"`

	// The Microsoft peering configuration.
	MicrosoftPeeringConfig *ExpressRouteCircuitPeeringConfig `json:"microsoftPeeringConfig,omitempty"`

	// The peer ASN.
	PeerASN *int64 `json:"peerASN,omitempty"`

	// The peering type.
	PeeringType *ExpressRoutePeeringType `json:"peeringType,omitempty"`

	// The primary port.
	PrimaryAzurePort *string `json:"primaryAzurePort,omitempty"`

	// The primary address prefix.
	PrimaryPeerAddressPrefix *string `json:"primaryPeerAddressPrefix,omitempty"`

	// The reference to the RouteFilter resource.
	RouteFilter *SubResource `json:"routeFilter,omitempty"`

	// The secondary port.
	SecondaryAzurePort *string `json:"secondaryAzurePort,omitempty"`

	// The secondary address prefix.
	SecondaryPeerAddressPrefix *string `json:"secondaryPeerAddressPrefix,omitempty"`

	// The shared key.
	SharedKey *string `json:"sharedKey,omitempty"`

	// The peering state.
	State *ExpressRoutePeeringState `json:"state,omitempty"`

	// The peering stats of express route circuit.
	Stats *ExpressRouteCircuitStats `json:"stats,omitempty"`

	// The VLAN ID.
	VlanID *int32 `json:"vlanId,omitempty"`

	// READ-ONLY; Who was the last to modify the peering.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty" azure:"ro"`

	// READ-ONLY; The list of peered circuit connections associated with Azure Private Peering for this circuit.
	PeeredConnections []*PeerExpressRouteCircuitConnection `json:"peeredConnections,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the express route circuit peering resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ExpressRouteCircuitPeeringsClientBeginCreateOrUpdateOptions contains the optional parameters for the ExpressRouteCircuitPeeringsClient.BeginCreateOrUpdate
// method.
type ExpressRouteCircuitPeeringsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteCircuitPeeringsClientBeginDeleteOptions contains the optional parameters for the ExpressRouteCircuitPeeringsClient.BeginDelete
// method.
type ExpressRouteCircuitPeeringsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteCircuitPeeringsClientGetOptions contains the optional parameters for the ExpressRouteCircuitPeeringsClient.Get
// method.
type ExpressRouteCircuitPeeringsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteCircuitPeeringsClientListOptions contains the optional parameters for the ExpressRouteCircuitPeeringsClient.List
// method.
type ExpressRouteCircuitPeeringsClientListOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteCircuitPropertiesFormat - Properties of ExpressRouteCircuit.
type ExpressRouteCircuitPropertiesFormat struct {
	// Allow classic operations.
	AllowClassicOperations *bool `json:"allowClassicOperations,omitempty"`

	// The authorizationKey.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`

	// The list of authorizations.
	Authorizations []*ExpressRouteCircuitAuthorization `json:"authorizations,omitempty"`

	// The bandwidth of the circuit when the circuit is provisioned on an ExpressRoutePort resource.
	BandwidthInGbps *float32 `json:"bandwidthInGbps,omitempty"`

	// The CircuitProvisioningState state of the resource.
	CircuitProvisioningState *string `json:"circuitProvisioningState,omitempty"`

	// The reference to the ExpressRoutePort resource when the circuit is provisioned on an ExpressRoutePort resource.
	ExpressRoutePort *SubResource `json:"expressRoutePort,omitempty"`

	// The GatewayManager Etag.
	GatewayManagerEtag *string `json:"gatewayManagerEtag,omitempty"`

	// Flag denoting global reach status.
	GlobalReachEnabled *bool `json:"globalReachEnabled,omitempty"`

	// The list of peerings.
	Peerings []*ExpressRouteCircuitPeering `json:"peerings,omitempty"`

	// The ServiceKey.
	ServiceKey *string `json:"serviceKey,omitempty"`

	// The ServiceProviderNotes.
	ServiceProviderNotes *string `json:"serviceProviderNotes,omitempty"`

	// The ServiceProviderProperties.
	ServiceProviderProperties *ExpressRouteCircuitServiceProviderProperties `json:"serviceProviderProperties,omitempty"`

	// The ServiceProviderProvisioningState state of the resource.
	ServiceProviderProvisioningState *ServiceProviderProvisioningState `json:"serviceProviderProvisioningState,omitempty"`

	// READ-ONLY; The provisioning state of the express route circuit resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The identifier of the circuit traffic. Outer tag for QinQ encapsulation.
	Stag *int32 `json:"stag,omitempty" azure:"ro"`
}

// ExpressRouteCircuitReference - Reference to an express route circuit.
type ExpressRouteCircuitReference struct {
	// Corresponding Express Route Circuit Id.
	ID *string `json:"id,omitempty"`
}

// ExpressRouteCircuitRoutesTable - The routes table associated with the ExpressRouteCircuit.
type ExpressRouteCircuitRoutesTable struct {
	// Local preference value as set with the set local-preference route-map configuration command.
	LocPrf *string `json:"locPrf,omitempty"`

	// IP address of a network entity.
	Network *string `json:"network,omitempty"`

	// NextHop address.
	NextHop *string `json:"nextHop,omitempty"`

	// Autonomous system paths to the destination network.
	Path *string `json:"path,omitempty"`

	// Route Weight.
	Weight *int32 `json:"weight,omitempty"`
}

// ExpressRouteCircuitRoutesTableSummary - The routes table associated with the ExpressRouteCircuit.
type ExpressRouteCircuitRoutesTableSummary struct {
	// Autonomous system number.
	As *int32 `json:"as,omitempty"`

	// IP address of the neighbor.
	Neighbor *string `json:"neighbor,omitempty"`

	// Current state of the BGP session, and the number of prefixes that have been received from a neighbor or peer group.
	StatePfxRcd *string `json:"statePfxRcd,omitempty"`

	// The length of time that the BGP session has been in the Established state, or the current status if not in the Established
	// state.
	UpDown *string `json:"upDown,omitempty"`

	// BGP version number spoken to the neighbor.
	V *int32 `json:"v,omitempty"`
}

// ExpressRouteCircuitSKU - Contains SKU in an ExpressRouteCircuit.
type ExpressRouteCircuitSKU struct {
	// The family of the SKU.
	Family *ExpressRouteCircuitSKUFamily `json:"family,omitempty"`

	// The name of the SKU.
	Name *string `json:"name,omitempty"`

	// The tier of the SKU.
	Tier *ExpressRouteCircuitSKUTier `json:"tier,omitempty"`
}

// ExpressRouteCircuitServiceProviderProperties - Contains ServiceProviderProperties in an ExpressRouteCircuit.
type ExpressRouteCircuitServiceProviderProperties struct {
	// The BandwidthInMbps.
	BandwidthInMbps *int32 `json:"bandwidthInMbps,omitempty"`

	// The peering location.
	PeeringLocation *string `json:"peeringLocation,omitempty"`

	// The serviceProviderName.
	ServiceProviderName *string `json:"serviceProviderName,omitempty"`
}

// ExpressRouteCircuitStats - Contains stats associated with the peering.
type ExpressRouteCircuitStats struct {
	// The Primary BytesIn of the peering.
	PrimarybytesIn *int64 `json:"primarybytesIn,omitempty"`

	// The primary BytesOut of the peering.
	PrimarybytesOut *int64 `json:"primarybytesOut,omitempty"`

	// The secondary BytesIn of the peering.
	SecondarybytesIn *int64 `json:"secondarybytesIn,omitempty"`

	// The secondary BytesOut of the peering.
	SecondarybytesOut *int64 `json:"secondarybytesOut,omitempty"`
}

// ExpressRouteCircuitsArpTableListResult - Response for ListArpTable associated with the Express Route Circuits API.
type ExpressRouteCircuitsArpTableListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of the ARP tables.
	Value []*ExpressRouteCircuitArpTable `json:"value,omitempty"`
}

// ExpressRouteCircuitsClientBeginCreateOrUpdateOptions contains the optional parameters for the ExpressRouteCircuitsClient.BeginCreateOrUpdate
// method.
type ExpressRouteCircuitsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteCircuitsClientBeginDeleteOptions contains the optional parameters for the ExpressRouteCircuitsClient.BeginDelete
// method.
type ExpressRouteCircuitsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteCircuitsClientBeginListArpTableOptions contains the optional parameters for the ExpressRouteCircuitsClient.BeginListArpTable
// method.
type ExpressRouteCircuitsClientBeginListArpTableOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteCircuitsClientBeginListRoutesTableOptions contains the optional parameters for the ExpressRouteCircuitsClient.BeginListRoutesTable
// method.
type ExpressRouteCircuitsClientBeginListRoutesTableOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteCircuitsClientBeginListRoutesTableSummaryOptions contains the optional parameters for the ExpressRouteCircuitsClient.BeginListRoutesTableSummary
// method.
type ExpressRouteCircuitsClientBeginListRoutesTableSummaryOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteCircuitsClientGetOptions contains the optional parameters for the ExpressRouteCircuitsClient.Get method.
type ExpressRouteCircuitsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteCircuitsClientGetPeeringStatsOptions contains the optional parameters for the ExpressRouteCircuitsClient.GetPeeringStats
// method.
type ExpressRouteCircuitsClientGetPeeringStatsOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteCircuitsClientGetStatsOptions contains the optional parameters for the ExpressRouteCircuitsClient.GetStats
// method.
type ExpressRouteCircuitsClientGetStatsOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteCircuitsClientListAllOptions contains the optional parameters for the ExpressRouteCircuitsClient.ListAll method.
type ExpressRouteCircuitsClientListAllOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteCircuitsClientListOptions contains the optional parameters for the ExpressRouteCircuitsClient.List method.
type ExpressRouteCircuitsClientListOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteCircuitsClientUpdateTagsOptions contains the optional parameters for the ExpressRouteCircuitsClient.UpdateTags
// method.
type ExpressRouteCircuitsClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteCircuitsRoutesTableListResult - Response for ListRoutesTable associated with the Express Route Circuits API.
type ExpressRouteCircuitsRoutesTableListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of routes table.
	Value []*ExpressRouteCircuitRoutesTable `json:"value,omitempty"`
}

// ExpressRouteCircuitsRoutesTableSummaryListResult - Response for ListRoutesTable associated with the Express Route Circuits
// API.
type ExpressRouteCircuitsRoutesTableSummaryListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of the routes table.
	Value []*ExpressRouteCircuitRoutesTableSummary `json:"value,omitempty"`
}

// ExpressRouteConnection resource.
type ExpressRouteConnection struct {
	// REQUIRED; The name of the resource.
	Name *string `json:"name,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Properties of the express route connection.
	Properties *ExpressRouteConnectionProperties `json:"properties,omitempty"`
}

// ExpressRouteConnectionID - The ID of the ExpressRouteConnection.
type ExpressRouteConnectionID struct {
	// READ-ONLY; The ID of the ExpressRouteConnection.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// ExpressRouteConnectionList - ExpressRouteConnection list.
type ExpressRouteConnectionList struct {
	// The list of ExpressRoute connections.
	Value []*ExpressRouteConnection `json:"value,omitempty"`
}

// ExpressRouteConnectionProperties - Properties of the ExpressRouteConnection subresource.
type ExpressRouteConnectionProperties struct {
	// REQUIRED; The ExpressRoute circuit peering.
	ExpressRouteCircuitPeering *ExpressRouteCircuitPeeringID `json:"expressRouteCircuitPeering,omitempty"`

	// Authorization key to establish the connection.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`

	// Enable internet security.
	EnableInternetSecurity *bool `json:"enableInternetSecurity,omitempty"`

	// Enable FastPath to vWan Firewall hub.
	ExpressRouteGatewayBypass *bool `json:"expressRouteGatewayBypass,omitempty"`

	// The Routing Configuration indicating the associated and propagated route tables on this connection.
	RoutingConfiguration *RoutingConfiguration `json:"routingConfiguration,omitempty"`

	// The routing weight associated to the connection.
	RoutingWeight *int32 `json:"routingWeight,omitempty"`

	// READ-ONLY; The provisioning state of the express route connection resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ExpressRouteConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the ExpressRouteConnectionsClient.BeginCreateOrUpdate
// method.
type ExpressRouteConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteConnectionsClientBeginDeleteOptions contains the optional parameters for the ExpressRouteConnectionsClient.BeginDelete
// method.
type ExpressRouteConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteConnectionsClientGetOptions contains the optional parameters for the ExpressRouteConnectionsClient.Get method.
type ExpressRouteConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteConnectionsClientListOptions contains the optional parameters for the ExpressRouteConnectionsClient.List method.
type ExpressRouteConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteCrossConnection resource.
type ExpressRouteCrossConnection struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the express route cross connection.
	Properties *ExpressRouteCrossConnectionProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExpressRouteCrossConnectionListResult - Response for ListExpressRouteCrossConnection API service call.
type ExpressRouteCrossConnectionListResult struct {
	// A list of ExpressRouteCrossConnection resources.
	Value []*ExpressRouteCrossConnection `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ExpressRouteCrossConnectionPeering - Peering in an ExpressRoute Cross Connection resource.
type ExpressRouteCrossConnectionPeering struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the express route cross connection peering.
	Properties *ExpressRouteCrossConnectionPeeringProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// ExpressRouteCrossConnectionPeeringList - Response for ListPeering API service call retrieves all peerings that belong to
// an ExpressRouteCrossConnection.
type ExpressRouteCrossConnectionPeeringList struct {
	// The peerings in an express route cross connection.
	Value []*ExpressRouteCrossConnectionPeering `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ExpressRouteCrossConnectionPeeringProperties - Properties of express route cross connection peering.
type ExpressRouteCrossConnectionPeeringProperties struct {
	// The GatewayManager Etag.
	GatewayManagerEtag *string `json:"gatewayManagerEtag,omitempty"`

	// The IPv6 peering configuration.
	IPv6PeeringConfig *IPv6ExpressRouteCircuitPeeringConfig `json:"ipv6PeeringConfig,omitempty"`

	// The Microsoft peering configuration.
	MicrosoftPeeringConfig *ExpressRouteCircuitPeeringConfig `json:"microsoftPeeringConfig,omitempty"`

	// The peer ASN.
	PeerASN *int64 `json:"peerASN,omitempty"`

	// The peering type.
	PeeringType *ExpressRoutePeeringType `json:"peeringType,omitempty"`

	// The primary address prefix.
	PrimaryPeerAddressPrefix *string `json:"primaryPeerAddressPrefix,omitempty"`

	// The secondary address prefix.
	SecondaryPeerAddressPrefix *string `json:"secondaryPeerAddressPrefix,omitempty"`

	// The shared key.
	SharedKey *string `json:"sharedKey,omitempty"`

	// The peering state.
	State *ExpressRoutePeeringState `json:"state,omitempty"`

	// The VLAN ID.
	VlanID *int32 `json:"vlanId,omitempty"`

	// READ-ONLY; The Azure ASN.
	AzureASN *int32 `json:"azureASN,omitempty" azure:"ro"`

	// READ-ONLY; Who was the last to modify the peering.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty" azure:"ro"`

	// READ-ONLY; The primary port.
	PrimaryAzurePort *string `json:"primaryAzurePort,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the express route cross connection peering resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The secondary port.
	SecondaryAzurePort *string `json:"secondaryAzurePort,omitempty" azure:"ro"`
}

// ExpressRouteCrossConnectionPeeringsClientBeginCreateOrUpdateOptions contains the optional parameters for the ExpressRouteCrossConnectionPeeringsClient.BeginCreateOrUpdate
// method.
type ExpressRouteCrossConnectionPeeringsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteCrossConnectionPeeringsClientBeginDeleteOptions contains the optional parameters for the ExpressRouteCrossConnectionPeeringsClient.BeginDelete
// method.
type ExpressRouteCrossConnectionPeeringsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteCrossConnectionPeeringsClientGetOptions contains the optional parameters for the ExpressRouteCrossConnectionPeeringsClient.Get
// method.
type ExpressRouteCrossConnectionPeeringsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteCrossConnectionPeeringsClientListOptions contains the optional parameters for the ExpressRouteCrossConnectionPeeringsClient.List
// method.
type ExpressRouteCrossConnectionPeeringsClientListOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteCrossConnectionProperties - Properties of ExpressRouteCrossConnection.
type ExpressRouteCrossConnectionProperties struct {
	// The ExpressRouteCircuit.
	ExpressRouteCircuit *ExpressRouteCircuitReference `json:"expressRouteCircuit,omitempty"`

	// The list of peerings.
	Peerings []*ExpressRouteCrossConnectionPeering `json:"peerings,omitempty"`

	// Additional read only notes set by the connectivity provider.
	ServiceProviderNotes *string `json:"serviceProviderNotes,omitempty"`

	// The provisioning state of the circuit in the connectivity provider system.
	ServiceProviderProvisioningState *ServiceProviderProvisioningState `json:"serviceProviderProvisioningState,omitempty"`

	// READ-ONLY; The circuit bandwidth In Mbps.
	BandwidthInMbps *int32 `json:"bandwidthInMbps,omitempty" azure:"ro"`

	// READ-ONLY; The peering location of the ExpressRoute circuit.
	PeeringLocation *string `json:"peeringLocation,omitempty" azure:"ro"`

	// READ-ONLY; The name of the primary port.
	PrimaryAzurePort *string `json:"primaryAzurePort,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the express route cross connection resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The identifier of the circuit traffic.
	STag *int32 `json:"sTag,omitempty" azure:"ro"`

	// READ-ONLY; The name of the secondary port.
	SecondaryAzurePort *string `json:"secondaryAzurePort,omitempty" azure:"ro"`
}

// ExpressRouteCrossConnectionRoutesTableSummary - The routes table associated with the ExpressRouteCircuit.
type ExpressRouteCrossConnectionRoutesTableSummary struct {
	// Autonomous system number.
	Asn *int32 `json:"asn,omitempty"`

	// IP address of Neighbor router.
	Neighbor *string `json:"neighbor,omitempty"`

	// Current state of the BGP session, and the number of prefixes that have been received from a neighbor or peer group.
	StateOrPrefixesReceived *string `json:"stateOrPrefixesReceived,omitempty"`

	// The length of time that the BGP session has been in the Established state, or the current status if not in the Established
	// state.
	UpDown *string `json:"upDown,omitempty"`
}

// ExpressRouteCrossConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the ExpressRouteCrossConnectionsClient.BeginCreateOrUpdate
// method.
type ExpressRouteCrossConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteCrossConnectionsClientBeginListArpTableOptions contains the optional parameters for the ExpressRouteCrossConnectionsClient.BeginListArpTable
// method.
type ExpressRouteCrossConnectionsClientBeginListArpTableOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteCrossConnectionsClientBeginListRoutesTableOptions contains the optional parameters for the ExpressRouteCrossConnectionsClient.BeginListRoutesTable
// method.
type ExpressRouteCrossConnectionsClientBeginListRoutesTableOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteCrossConnectionsClientBeginListRoutesTableSummaryOptions contains the optional parameters for the ExpressRouteCrossConnectionsClient.BeginListRoutesTableSummary
// method.
type ExpressRouteCrossConnectionsClientBeginListRoutesTableSummaryOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteCrossConnectionsClientGetOptions contains the optional parameters for the ExpressRouteCrossConnectionsClient.Get
// method.
type ExpressRouteCrossConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteCrossConnectionsClientListByResourceGroupOptions contains the optional parameters for the ExpressRouteCrossConnectionsClient.ListByResourceGroup
// method.
type ExpressRouteCrossConnectionsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteCrossConnectionsClientListOptions contains the optional parameters for the ExpressRouteCrossConnectionsClient.List
// method.
type ExpressRouteCrossConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteCrossConnectionsClientUpdateTagsOptions contains the optional parameters for the ExpressRouteCrossConnectionsClient.UpdateTags
// method.
type ExpressRouteCrossConnectionsClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteCrossConnectionsRoutesTableSummaryListResult - Response for ListRoutesTable associated with the Express Route
// Cross Connections.
type ExpressRouteCrossConnectionsRoutesTableSummaryListResult struct {
	// A list of the routes table.
	Value []*ExpressRouteCrossConnectionRoutesTableSummary `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ExpressRouteGateway - ExpressRoute gateway resource.
type ExpressRouteGateway struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the express route gateway.
	Properties *ExpressRouteGatewayProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExpressRouteGatewayList - List of ExpressRoute gateways.
type ExpressRouteGatewayList struct {
	// List of ExpressRoute gateways.
	Value []*ExpressRouteGateway `json:"value,omitempty"`
}

// ExpressRouteGatewayProperties - ExpressRoute gateway resource properties.
type ExpressRouteGatewayProperties struct {
	// REQUIRED; The Virtual Hub where the ExpressRoute gateway is or will be deployed.
	VirtualHub *VirtualHubID `json:"virtualHub,omitempty"`

	// Configuration for auto scaling.
	AutoScaleConfiguration *ExpressRouteGatewayPropertiesAutoScaleConfiguration `json:"autoScaleConfiguration,omitempty"`

	// List of ExpressRoute connections to the ExpressRoute gateway.
	ExpressRouteConnections []*ExpressRouteConnection `json:"expressRouteConnections,omitempty"`

	// READ-ONLY; The provisioning state of the express route gateway resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ExpressRouteGatewayPropertiesAutoScaleConfiguration - Configuration for auto scaling.
type ExpressRouteGatewayPropertiesAutoScaleConfiguration struct {
	// Minimum and maximum number of scale units to deploy.
	Bounds *ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds `json:"bounds,omitempty"`
}

// ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds - Minimum and maximum number of scale units to deploy.
type ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds struct {
	// Maximum number of scale units deployed for ExpressRoute gateway.
	Max *int32 `json:"max,omitempty"`

	// Minimum number of scale units deployed for ExpressRoute gateway.
	Min *int32 `json:"min,omitempty"`
}

// ExpressRouteGatewaysClientBeginCreateOrUpdateOptions contains the optional parameters for the ExpressRouteGatewaysClient.BeginCreateOrUpdate
// method.
type ExpressRouteGatewaysClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteGatewaysClientBeginDeleteOptions contains the optional parameters for the ExpressRouteGatewaysClient.BeginDelete
// method.
type ExpressRouteGatewaysClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteGatewaysClientBeginUpdateTagsOptions contains the optional parameters for the ExpressRouteGatewaysClient.BeginUpdateTags
// method.
type ExpressRouteGatewaysClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRouteGatewaysClientGetOptions contains the optional parameters for the ExpressRouteGatewaysClient.Get method.
type ExpressRouteGatewaysClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteGatewaysClientListByResourceGroupOptions contains the optional parameters for the ExpressRouteGatewaysClient.ListByResourceGroup
// method.
type ExpressRouteGatewaysClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteGatewaysClientListBySubscriptionOptions contains the optional parameters for the ExpressRouteGatewaysClient.ListBySubscription
// method.
type ExpressRouteGatewaysClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteLink child resource definition.
type ExpressRouteLink struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of child port resource that is unique among child port resources of the parent.
	Name *string `json:"name,omitempty"`

	// ExpressRouteLink properties.
	Properties *ExpressRouteLinkPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// ExpressRouteLinkListResult - Response for ListExpressRouteLinks API service call.
type ExpressRouteLinkListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of ExpressRouteLink sub-resources.
	Value []*ExpressRouteLink `json:"value,omitempty"`
}

// ExpressRouteLinkMacSecConfig - ExpressRouteLink Mac Security Configuration.
type ExpressRouteLinkMacSecConfig struct {
	// Keyvault Secret Identifier URL containing Mac security CAK key.
	CakSecretIdentifier *string `json:"cakSecretIdentifier,omitempty"`

	// Mac security cipher.
	Cipher *ExpressRouteLinkMacSecCipher `json:"cipher,omitempty"`

	// Keyvault Secret Identifier URL containing Mac security CKN key.
	CknSecretIdentifier *string `json:"cknSecretIdentifier,omitempty"`

	// Sci mode enabled/disabled.
	SciState *ExpressRouteLinkMacSecSciState `json:"sciState,omitempty"`
}

// ExpressRouteLinkPropertiesFormat - Properties specific to ExpressRouteLink resources.
type ExpressRouteLinkPropertiesFormat struct {
	// Administrative state of the physical port.
	AdminState *ExpressRouteLinkAdminState `json:"adminState,omitempty"`

	// MacSec configuration.
	MacSecConfig *ExpressRouteLinkMacSecConfig `json:"macSecConfig,omitempty"`

	// READ-ONLY; Physical fiber port type.
	ConnectorType *ExpressRouteLinkConnectorType `json:"connectorType,omitempty" azure:"ro"`

	// READ-ONLY; Name of Azure router interface.
	InterfaceName *string `json:"interfaceName,omitempty" azure:"ro"`

	// READ-ONLY; Mapping between physical port to patch panel port.
	PatchPanelID *string `json:"patchPanelId,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the express route link resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Mapping of physical patch panel to rack.
	RackID *string `json:"rackId,omitempty" azure:"ro"`

	// READ-ONLY; Name of Azure router associated with physical port.
	RouterName *string `json:"routerName,omitempty" azure:"ro"`
}

// ExpressRouteLinksClientGetOptions contains the optional parameters for the ExpressRouteLinksClient.Get method.
type ExpressRouteLinksClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteLinksClientListOptions contains the optional parameters for the ExpressRouteLinksClient.List method.
type ExpressRouteLinksClientListOptions struct {
	// placeholder for future optional parameters
}

// ExpressRoutePort resource definition.
type ExpressRoutePort struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The identity of ExpressRoutePort, if configured.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// ExpressRoutePort properties.
	Properties *ExpressRoutePortPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExpressRoutePortAuthorization - ExpressRoutePort Authorization resource definition.
type ExpressRoutePortAuthorization struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// ExpressRoutePort properties.
	Properties *ExpressRoutePortAuthorizationPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExpressRoutePortAuthorizationListResult - Response for ListExpressRoutePortAuthorizations API service call.
type ExpressRoutePortAuthorizationListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The authorizations in an ExpressRoute Port.
	Value []*ExpressRoutePortAuthorization `json:"value,omitempty"`
}

// ExpressRoutePortAuthorizationPropertiesFormat - Properties of ExpressRoutePort Authorization.
type ExpressRoutePortAuthorizationPropertiesFormat struct {
	// READ-ONLY; The authorization key.
	AuthorizationKey *string `json:"authorizationKey,omitempty" azure:"ro"`

	// READ-ONLY; The authorization use status.
	AuthorizationUseStatus *ExpressRoutePortAuthorizationUseStatus `json:"authorizationUseStatus,omitempty" azure:"ro"`

	// READ-ONLY; The reference to the ExpressRoute circuit resource using the authorization.
	CircuitResourceURI *string `json:"circuitResourceUri,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the authorization resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ExpressRoutePortAuthorizationsClientBeginCreateOrUpdateOptions contains the optional parameters for the ExpressRoutePortAuthorizationsClient.BeginCreateOrUpdate
// method.
type ExpressRoutePortAuthorizationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRoutePortAuthorizationsClientBeginDeleteOptions contains the optional parameters for the ExpressRoutePortAuthorizationsClient.BeginDelete
// method.
type ExpressRoutePortAuthorizationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRoutePortAuthorizationsClientGetOptions contains the optional parameters for the ExpressRoutePortAuthorizationsClient.Get
// method.
type ExpressRoutePortAuthorizationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExpressRoutePortAuthorizationsClientListOptions contains the optional parameters for the ExpressRoutePortAuthorizationsClient.List
// method.
type ExpressRoutePortAuthorizationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ExpressRoutePortListResult - Response for ListExpressRoutePorts API service call.
type ExpressRoutePortListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of ExpressRoutePort resources.
	Value []*ExpressRoutePort `json:"value,omitempty"`
}

// ExpressRoutePortPropertiesFormat - Properties specific to ExpressRoutePort resources.
type ExpressRoutePortPropertiesFormat struct {
	// Bandwidth of procured ports in Gbps.
	BandwidthInGbps *int32 `json:"bandwidthInGbps,omitempty"`

	// Encapsulation method on physical ports.
	Encapsulation *ExpressRoutePortsEncapsulation `json:"encapsulation,omitempty"`

	// The set of physical links of the ExpressRoutePort resource.
	Links []*ExpressRouteLink `json:"links,omitempty"`

	// The name of the peering location that the ExpressRoutePort is mapped to physically.
	PeeringLocation *string `json:"peeringLocation,omitempty"`

	// READ-ONLY; Date of the physical port allocation to be used in Letter of Authorization.
	AllocationDate *string `json:"allocationDate,omitempty" azure:"ro"`

	// READ-ONLY; Reference the ExpressRoute circuit(s) that are provisioned on this ExpressRoutePort resource.
	Circuits []*SubResource `json:"circuits,omitempty" azure:"ro"`

	// READ-ONLY; Ether type of the physical port.
	EtherType *string `json:"etherType,omitempty" azure:"ro"`

	// READ-ONLY; Maximum transmission unit of the physical port pair(s).
	Mtu *string `json:"mtu,omitempty" azure:"ro"`

	// READ-ONLY; Aggregate Gbps of associated circuit bandwidths.
	ProvisionedBandwidthInGbps *float32 `json:"provisionedBandwidthInGbps,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the express route port resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the express route port resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`
}

// ExpressRoutePortsClientBeginCreateOrUpdateOptions contains the optional parameters for the ExpressRoutePortsClient.BeginCreateOrUpdate
// method.
type ExpressRoutePortsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRoutePortsClientBeginDeleteOptions contains the optional parameters for the ExpressRoutePortsClient.BeginDelete
// method.
type ExpressRoutePortsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExpressRoutePortsClientGenerateLOAOptions contains the optional parameters for the ExpressRoutePortsClient.GenerateLOA
// method.
type ExpressRoutePortsClientGenerateLOAOptions struct {
	// placeholder for future optional parameters
}

// ExpressRoutePortsClientGetOptions contains the optional parameters for the ExpressRoutePortsClient.Get method.
type ExpressRoutePortsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExpressRoutePortsClientListByResourceGroupOptions contains the optional parameters for the ExpressRoutePortsClient.ListByResourceGroup
// method.
type ExpressRoutePortsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ExpressRoutePortsClientListOptions contains the optional parameters for the ExpressRoutePortsClient.List method.
type ExpressRoutePortsClientListOptions struct {
	// placeholder for future optional parameters
}

// ExpressRoutePortsClientUpdateTagsOptions contains the optional parameters for the ExpressRoutePortsClient.UpdateTags method.
type ExpressRoutePortsClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// ExpressRoutePortsLocation - Definition of the ExpressRoutePorts peering location resource.
type ExpressRoutePortsLocation struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// ExpressRoutePort peering location properties.
	Properties *ExpressRoutePortsLocationPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExpressRoutePortsLocationBandwidths - Real-time inventory of available ExpressRoute port bandwidths.
type ExpressRoutePortsLocationBandwidths struct {
	// READ-ONLY; Bandwidth descriptive name.
	OfferName *string `json:"offerName,omitempty" azure:"ro"`

	// READ-ONLY; Bandwidth value in Gbps.
	ValueInGbps *int32 `json:"valueInGbps,omitempty" azure:"ro"`
}

// ExpressRoutePortsLocationListResult - Response for ListExpressRoutePortsLocations API service call.
type ExpressRoutePortsLocationListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of all ExpressRoutePort peering locations.
	Value []*ExpressRoutePortsLocation `json:"value,omitempty"`
}

// ExpressRoutePortsLocationPropertiesFormat - Properties specific to ExpressRoutePorts peering location resources.
type ExpressRoutePortsLocationPropertiesFormat struct {
	// The inventory of available ExpressRoutePort bandwidths.
	AvailableBandwidths []*ExpressRoutePortsLocationBandwidths `json:"availableBandwidths,omitempty"`

	// READ-ONLY; Address of peering location.
	Address *string `json:"address,omitempty" azure:"ro"`

	// READ-ONLY; Contact details of peering locations.
	Contact *string `json:"contact,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the express route port location resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ExpressRoutePortsLocationsClientGetOptions contains the optional parameters for the ExpressRoutePortsLocationsClient.Get
// method.
type ExpressRoutePortsLocationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExpressRoutePortsLocationsClientListOptions contains the optional parameters for the ExpressRoutePortsLocationsClient.List
// method.
type ExpressRoutePortsLocationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ExpressRouteProviderPort resource.
type ExpressRouteProviderPort struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the express route Service Provider Port.
	Properties *ExpressRouteProviderPortProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExpressRouteProviderPortListResult - Response for ListExpressRouteProviderPort API service call.
type ExpressRouteProviderPortListResult struct {
	// A list of ExpressRouteProviderPort resources.
	Value []*ExpressRouteProviderPort `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ExpressRouteProviderPortProperties - Properties of ExpressRouteProviderPort.
type ExpressRouteProviderPortProperties struct {
	// Overprovisioning factor for the port pair.
	OverprovisionFactor *int32 `json:"overprovisionFactor,omitempty"`

	// The peering location of the port pair.
	PeeringLocation *string `json:"peeringLocation,omitempty"`

	// Bandwidth of the port in Mbps
	PortBandwidthInMbps *int32 `json:"portBandwidthInMbps,omitempty"`

	// Remaining Bandwidth of the port in Mbps
	RemainingBandwidthInMbps *int32 `json:"remainingBandwidthInMbps,omitempty"`

	// Used Bandwidth of the port in Mbps
	UsedBandwidthInMbps *int32 `json:"usedBandwidthInMbps,omitempty"`

	// READ-ONLY; The name of the port pair.
	PortPairDescriptor *string `json:"portPairDescriptor,omitempty" azure:"ro"`

	// READ-ONLY; The name of the primary port.
	PrimaryAzurePort *string `json:"primaryAzurePort,omitempty" azure:"ro"`

	// READ-ONLY; The name of the secondary port.
	SecondaryAzurePort *string `json:"secondaryAzurePort,omitempty" azure:"ro"`
}

// ExpressRouteProviderPortsLocationClientListOptions contains the optional parameters for the ExpressRouteProviderPortsLocationClient.List
// method.
type ExpressRouteProviderPortsLocationClientListOptions struct {
	// The filter to apply on the operation. For example, you can use $filter=location eq '{state}'.
	Filter *string
}

// ExpressRouteServiceProvider - A ExpressRouteResourceProvider object.
type ExpressRouteServiceProvider struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the express route service provider.
	Properties *ExpressRouteServiceProviderPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExpressRouteServiceProviderBandwidthsOffered - Contains bandwidths offered in ExpressRouteServiceProvider resources.
type ExpressRouteServiceProviderBandwidthsOffered struct {
	// The OfferName.
	OfferName *string `json:"offerName,omitempty"`

	// The ValueInMbps.
	ValueInMbps *int32 `json:"valueInMbps,omitempty"`
}

// ExpressRouteServiceProviderListResult - Response for the ListExpressRouteServiceProvider API service call.
type ExpressRouteServiceProviderListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of ExpressRouteResourceProvider resources.
	Value []*ExpressRouteServiceProvider `json:"value,omitempty"`
}

// ExpressRouteServiceProviderPropertiesFormat - Properties of ExpressRouteServiceProvider.
type ExpressRouteServiceProviderPropertiesFormat struct {
	// A list of bandwidths offered.
	BandwidthsOffered []*ExpressRouteServiceProviderBandwidthsOffered `json:"bandwidthsOffered,omitempty"`

	// A list of peering locations.
	PeeringLocations []*string `json:"peeringLocations,omitempty"`

	// READ-ONLY; The provisioning state of the express route service provider resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ExpressRouteServiceProvidersClientListOptions contains the optional parameters for the ExpressRouteServiceProvidersClient.List
// method.
type ExpressRouteServiceProvidersClientListOptions struct {
	// placeholder for future optional parameters
}

// ExtendedLocation complex type.
type ExtendedLocation struct {
	// The name of the extended location.
	Name *string `json:"name,omitempty"`

	// The type of the extended location.
	Type *ExtendedLocationTypes `json:"type,omitempty"`
}

// FilterItems - Will contain the filter name and values to operate on
type FilterItems struct {
	// The name of the field we would like to filter
	Field *string `json:"field,omitempty"`

	// List of values to filter the current field by
	Values []*string `json:"values,omitempty"`
}

// FirewallPoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the FirewallPoliciesClient.BeginCreateOrUpdate
// method.
type FirewallPoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FirewallPoliciesClientBeginDeleteOptions contains the optional parameters for the FirewallPoliciesClient.BeginDelete method.
type FirewallPoliciesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FirewallPoliciesClientGetOptions contains the optional parameters for the FirewallPoliciesClient.Get method.
type FirewallPoliciesClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// FirewallPoliciesClientListAllOptions contains the optional parameters for the FirewallPoliciesClient.ListAll method.
type FirewallPoliciesClientListAllOptions struct {
	// placeholder for future optional parameters
}

// FirewallPoliciesClientListOptions contains the optional parameters for the FirewallPoliciesClient.List method.
type FirewallPoliciesClientListOptions struct {
	// placeholder for future optional parameters
}

// FirewallPoliciesClientUpdateTagsOptions contains the optional parameters for the FirewallPoliciesClient.UpdateTags method.
type FirewallPoliciesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// FirewallPolicy Resource.
type FirewallPolicy struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The identity of the firewall policy.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the firewall policy.
	Properties *FirewallPolicyPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FirewallPolicyCertificateAuthority - Trusted Root certificates properties for tls.
type FirewallPolicyCertificateAuthority struct {
	// Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
	KeyVaultSecretID *string `json:"keyVaultSecretId,omitempty"`

	// Name of the CA certificate.
	Name *string `json:"name,omitempty"`
}

// FirewallPolicyFilterRuleCollection - Firewall Policy Filter Rule Collection.
type FirewallPolicyFilterRuleCollection struct {
	// REQUIRED; The type of the rule collection.
	RuleCollectionType *FirewallPolicyRuleCollectionType `json:"ruleCollectionType,omitempty"`

	// The action type of a Filter rule collection.
	Action *FirewallPolicyFilterRuleCollectionAction `json:"action,omitempty"`

	// The name of the rule collection.
	Name *string `json:"name,omitempty"`

	// Priority of the Firewall Policy Rule Collection resource.
	Priority *int32 `json:"priority,omitempty"`

	// List of rules included in a rule collection.
	Rules []FirewallPolicyRuleClassification `json:"rules,omitempty"`
}

// GetFirewallPolicyRuleCollection implements the FirewallPolicyRuleCollectionClassification interface for type FirewallPolicyFilterRuleCollection.
func (f *FirewallPolicyFilterRuleCollection) GetFirewallPolicyRuleCollection() *FirewallPolicyRuleCollection {
	return &FirewallPolicyRuleCollection{
		RuleCollectionType: f.RuleCollectionType,
		Name:               f.Name,
		Priority:           f.Priority,
	}
}

// FirewallPolicyFilterRuleCollectionAction - Properties of the FirewallPolicyFilterRuleCollectionAction.
type FirewallPolicyFilterRuleCollectionAction struct {
	// The type of action.
	Type *FirewallPolicyFilterRuleCollectionActionType `json:"type,omitempty"`
}

// FirewallPolicyIdpsSignaturesClientListOptions contains the optional parameters for the FirewallPolicyIdpsSignaturesClient.List
// method.
type FirewallPolicyIdpsSignaturesClientListOptions struct {
	// placeholder for future optional parameters
}

// FirewallPolicyIdpsSignaturesFilterValuesClientListOptions contains the optional parameters for the FirewallPolicyIdpsSignaturesFilterValuesClient.List
// method.
type FirewallPolicyIdpsSignaturesFilterValuesClientListOptions struct {
	// placeholder for future optional parameters
}

// FirewallPolicyIdpsSignaturesOverridesClientGetOptions contains the optional parameters for the FirewallPolicyIdpsSignaturesOverridesClient.Get
// method.
type FirewallPolicyIdpsSignaturesOverridesClientGetOptions struct {
	// placeholder for future optional parameters
}

// FirewallPolicyIdpsSignaturesOverridesClientListOptions contains the optional parameters for the FirewallPolicyIdpsSignaturesOverridesClient.List
// method.
type FirewallPolicyIdpsSignaturesOverridesClientListOptions struct {
	// placeholder for future optional parameters
}

// FirewallPolicyIdpsSignaturesOverridesClientPatchOptions contains the optional parameters for the FirewallPolicyIdpsSignaturesOverridesClient.Patch
// method.
type FirewallPolicyIdpsSignaturesOverridesClientPatchOptions struct {
	// placeholder for future optional parameters
}

// FirewallPolicyIdpsSignaturesOverridesClientPutOptions contains the optional parameters for the FirewallPolicyIdpsSignaturesOverridesClient.Put
// method.
type FirewallPolicyIdpsSignaturesOverridesClientPutOptions struct {
	// placeholder for future optional parameters
}

// FirewallPolicyInsights - Firewall Policy Insights.
type FirewallPolicyInsights struct {
	// A flag to indicate if the insights are enabled on the policy.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// Workspaces needed to configure the Firewall Policy Insights.
	LogAnalyticsResources *FirewallPolicyLogAnalyticsResources `json:"logAnalyticsResources,omitempty"`

	// Number of days the insights should be enabled on the policy.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
}

// FirewallPolicyIntrusionDetection - Configuration for intrusion detection mode and rules.
type FirewallPolicyIntrusionDetection struct {
	// Intrusion detection configuration properties.
	Configuration *FirewallPolicyIntrusionDetectionConfiguration `json:"configuration,omitempty"`

	// Intrusion detection general state.
	Mode *FirewallPolicyIntrusionDetectionStateType `json:"mode,omitempty"`
}

// FirewallPolicyIntrusionDetectionBypassTrafficSpecifications - Intrusion detection bypass traffic specification.
type FirewallPolicyIntrusionDetectionBypassTrafficSpecifications struct {
	// Description of the bypass traffic rule.
	Description *string `json:"description,omitempty"`

	// List of destination IP addresses or ranges for this rule.
	DestinationAddresses []*string `json:"destinationAddresses,omitempty"`

	// List of destination IpGroups for this rule.
	DestinationIPGroups []*string `json:"destinationIpGroups,omitempty"`

	// List of destination ports or ranges.
	DestinationPorts []*string `json:"destinationPorts,omitempty"`

	// Name of the bypass traffic rule.
	Name *string `json:"name,omitempty"`

	// The rule bypass protocol.
	Protocol *FirewallPolicyIntrusionDetectionProtocol `json:"protocol,omitempty"`

	// List of source IP addresses or ranges for this rule.
	SourceAddresses []*string `json:"sourceAddresses,omitempty"`

	// List of source IpGroups for this rule.
	SourceIPGroups []*string `json:"sourceIpGroups,omitempty"`
}

// FirewallPolicyIntrusionDetectionConfiguration - The operation for configuring intrusion detection.
type FirewallPolicyIntrusionDetectionConfiguration struct {
	// List of rules for traffic to bypass.
	BypassTrafficSettings []*FirewallPolicyIntrusionDetectionBypassTrafficSpecifications `json:"bypassTrafficSettings,omitempty"`

	// IDPS Private IP address ranges are used to identify traffic direction (i.e. inbound, outbound, etc.). By default, only
	// ranges defined by IANA RFC 1918 are considered private IP addresses. To modify
	// default ranges, specify your Private IP address ranges with this property
	PrivateRanges []*string `json:"privateRanges,omitempty"`

	// List of specific signatures states.
	SignatureOverrides []*FirewallPolicyIntrusionDetectionSignatureSpecification `json:"signatureOverrides,omitempty"`
}

// FirewallPolicyIntrusionDetectionSignatureSpecification - Intrusion detection signatures specification states.
type FirewallPolicyIntrusionDetectionSignatureSpecification struct {
	// Signature id.
	ID *string `json:"id,omitempty"`

	// The signature state.
	Mode *FirewallPolicyIntrusionDetectionStateType `json:"mode,omitempty"`
}

// FirewallPolicyListResult - Response for ListFirewallPolicies API service call.
type FirewallPolicyListResult struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Firewall Policies in a resource group.
	Value []*FirewallPolicy `json:"value,omitempty"`
}

// FirewallPolicyLogAnalyticsResources - Log Analytics Resources for Firewall Policy Insights.
type FirewallPolicyLogAnalyticsResources struct {
	// The default workspace Id for Firewall Policy Insights.
	DefaultWorkspaceID *SubResource `json:"defaultWorkspaceId,omitempty"`

	// List of workspaces for Firewall Policy Insights.
	Workspaces []*FirewallPolicyLogAnalyticsWorkspace `json:"workspaces,omitempty"`
}

// FirewallPolicyLogAnalyticsWorkspace - Log Analytics Workspace for Firewall Policy Insights.
type FirewallPolicyLogAnalyticsWorkspace struct {
	// Region to configure the Workspace.
	Region *string `json:"region,omitempty"`

	// The workspace Id for Firewall Policy Insights.
	WorkspaceID *SubResource `json:"workspaceId,omitempty"`
}

// FirewallPolicyNatRuleCollection - Firewall Policy NAT Rule Collection.
type FirewallPolicyNatRuleCollection struct {
	// REQUIRED; The type of the rule collection.
	RuleCollectionType *FirewallPolicyRuleCollectionType `json:"ruleCollectionType,omitempty"`

	// The action type of a Nat rule collection.
	Action *FirewallPolicyNatRuleCollectionAction `json:"action,omitempty"`

	// The name of the rule collection.
	Name *string `json:"name,omitempty"`

	// Priority of the Firewall Policy Rule Collection resource.
	Priority *int32 `json:"priority,omitempty"`

	// List of rules included in a rule collection.
	Rules []FirewallPolicyRuleClassification `json:"rules,omitempty"`
}

// GetFirewallPolicyRuleCollection implements the FirewallPolicyRuleCollectionClassification interface for type FirewallPolicyNatRuleCollection.
func (f *FirewallPolicyNatRuleCollection) GetFirewallPolicyRuleCollection() *FirewallPolicyRuleCollection {
	return &FirewallPolicyRuleCollection{
		RuleCollectionType: f.RuleCollectionType,
		Name:               f.Name,
		Priority:           f.Priority,
	}
}

// FirewallPolicyNatRuleCollectionAction - Properties of the FirewallPolicyNatRuleCollectionAction.
type FirewallPolicyNatRuleCollectionAction struct {
	// The type of action.
	Type *FirewallPolicyNatRuleCollectionActionType `json:"type,omitempty"`
}

// FirewallPolicyPropertiesFormat - Firewall Policy definition.
type FirewallPolicyPropertiesFormat struct {
	// The parent firewall policy from which rules are inherited.
	BasePolicy *SubResource `json:"basePolicy,omitempty"`

	// DNS Proxy Settings definition.
	DNSSettings *DNSSettings `json:"dnsSettings,omitempty"`

	// Explicit Proxy Settings definition.
	ExplicitProxySettings *ExplicitProxySettings `json:"explicitProxySettings,omitempty"`

	// Insights on Firewall Policy.
	Insights *FirewallPolicyInsights `json:"insights,omitempty"`

	// The configuration for Intrusion detection.
	IntrusionDetection *FirewallPolicyIntrusionDetection `json:"intrusionDetection,omitempty"`

	// The Firewall Policy SKU.
	SKU *FirewallPolicySKU `json:"sku,omitempty"`

	// SQL Settings definition.
	SQL *FirewallPolicySQL `json:"sql,omitempty"`

	// The private IP addresses/IP ranges to which traffic will not be SNAT.
	Snat *FirewallPolicySNAT `json:"snat,omitempty"`

	// The operation mode for Threat Intelligence.
	ThreatIntelMode *AzureFirewallThreatIntelMode `json:"threatIntelMode,omitempty"`

	// ThreatIntel Whitelist for Firewall Policy.
	ThreatIntelWhitelist *FirewallPolicyThreatIntelWhitelist `json:"threatIntelWhitelist,omitempty"`

	// TLS Configuration definition.
	TransportSecurity *FirewallPolicyTransportSecurity `json:"transportSecurity,omitempty"`

	// READ-ONLY; List of references to Child Firewall Policies.
	ChildPolicies []*SubResource `json:"childPolicies,omitempty" azure:"ro"`

	// READ-ONLY; List of references to Azure Firewalls that this Firewall Policy is associated with.
	Firewalls []*SubResource `json:"firewalls,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the firewall policy resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; List of references to FirewallPolicyRuleCollectionGroups.
	RuleCollectionGroups []*SubResource `json:"ruleCollectionGroups,omitempty" azure:"ro"`
}

// FirewallPolicyRuleClassification provides polymorphic access to related types.
// Call the interface's GetFirewallPolicyRule() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ApplicationRule, *FirewallPolicyRule, *NatRule, *Rule
type FirewallPolicyRuleClassification interface {
	// GetFirewallPolicyRule returns the FirewallPolicyRule content of the underlying type.
	GetFirewallPolicyRule() *FirewallPolicyRule
}

// FirewallPolicyRule - Properties of a rule.
type FirewallPolicyRule struct {
	// REQUIRED; Rule Type.
	RuleType *FirewallPolicyRuleType `json:"ruleType,omitempty"`

	// Description of the rule.
	Description *string `json:"description,omitempty"`

	// Name of the rule.
	Name *string `json:"name,omitempty"`
}

// GetFirewallPolicyRule implements the FirewallPolicyRuleClassification interface for type FirewallPolicyRule.
func (f *FirewallPolicyRule) GetFirewallPolicyRule() *FirewallPolicyRule { return f }

// FirewallPolicyRuleApplicationProtocol - Properties of the application rule protocol.
type FirewallPolicyRuleApplicationProtocol struct {
	// Port number for the protocol, cannot be greater than 64000.
	Port *int32 `json:"port,omitempty"`

	// Protocol type.
	ProtocolType *FirewallPolicyRuleApplicationProtocolType `json:"protocolType,omitempty"`
}

// FirewallPolicyRuleCollectionClassification provides polymorphic access to related types.
// Call the interface's GetFirewallPolicyRuleCollection() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *FirewallPolicyFilterRuleCollection, *FirewallPolicyNatRuleCollection, *FirewallPolicyRuleCollection
type FirewallPolicyRuleCollectionClassification interface {
	// GetFirewallPolicyRuleCollection returns the FirewallPolicyRuleCollection content of the underlying type.
	GetFirewallPolicyRuleCollection() *FirewallPolicyRuleCollection
}

// FirewallPolicyRuleCollection - Properties of the rule collection.
type FirewallPolicyRuleCollection struct {
	// REQUIRED; The type of the rule collection.
	RuleCollectionType *FirewallPolicyRuleCollectionType `json:"ruleCollectionType,omitempty"`

	// The name of the rule collection.
	Name *string `json:"name,omitempty"`

	// Priority of the Firewall Policy Rule Collection resource.
	Priority *int32 `json:"priority,omitempty"`
}

// GetFirewallPolicyRuleCollection implements the FirewallPolicyRuleCollectionClassification interface for type FirewallPolicyRuleCollection.
func (f *FirewallPolicyRuleCollection) GetFirewallPolicyRuleCollection() *FirewallPolicyRuleCollection {
	return f
}

// FirewallPolicyRuleCollectionGroup - Rule Collection Group resource.
type FirewallPolicyRuleCollectionGroup struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// The properties of the firewall policy rule collection group.
	Properties *FirewallPolicyRuleCollectionGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Rule Group type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FirewallPolicyRuleCollectionGroupListResult - Response for ListFirewallPolicyRuleCollectionGroups API service call.
type FirewallPolicyRuleCollectionGroupListResult struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of FirewallPolicyRuleCollectionGroups in a FirewallPolicy.
	Value []*FirewallPolicyRuleCollectionGroup `json:"value,omitempty"`
}

// FirewallPolicyRuleCollectionGroupProperties - Properties of the rule collection group.
type FirewallPolicyRuleCollectionGroupProperties struct {
	// Priority of the Firewall Policy Rule Collection Group resource.
	Priority *int32 `json:"priority,omitempty"`

	// Group of Firewall Policy rule collections.
	RuleCollections []FirewallPolicyRuleCollectionClassification `json:"ruleCollections,omitempty"`

	// READ-ONLY; The provisioning state of the firewall policy rule collection group resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// FirewallPolicyRuleCollectionGroupsClientBeginCreateOrUpdateOptions contains the optional parameters for the FirewallPolicyRuleCollectionGroupsClient.BeginCreateOrUpdate
// method.
type FirewallPolicyRuleCollectionGroupsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FirewallPolicyRuleCollectionGroupsClientBeginDeleteOptions contains the optional parameters for the FirewallPolicyRuleCollectionGroupsClient.BeginDelete
// method.
type FirewallPolicyRuleCollectionGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FirewallPolicyRuleCollectionGroupsClientGetOptions contains the optional parameters for the FirewallPolicyRuleCollectionGroupsClient.Get
// method.
type FirewallPolicyRuleCollectionGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// FirewallPolicyRuleCollectionGroupsClientListOptions contains the optional parameters for the FirewallPolicyRuleCollectionGroupsClient.List
// method.
type FirewallPolicyRuleCollectionGroupsClientListOptions struct {
	// placeholder for future optional parameters
}

// FirewallPolicySKU - SKU of Firewall policy.
type FirewallPolicySKU struct {
	// Tier of Firewall Policy.
	Tier *FirewallPolicySKUTier `json:"tier,omitempty"`
}

// FirewallPolicySNAT - The private IP addresses/IP ranges to which traffic will not be SNAT.
type FirewallPolicySNAT struct {
	// The operation mode for automatically learning private ranges to not be SNAT
	AutoLearnPrivateRanges *AutoLearnPrivateRangesMode `json:"autoLearnPrivateRanges,omitempty"`

	// List of private IP addresses/IP address ranges to not be SNAT.
	PrivateRanges []*string `json:"privateRanges,omitempty"`
}

// FirewallPolicySQL - SQL Settings in Firewall Policy.
type FirewallPolicySQL struct {
	// A flag to indicate if SQL Redirect traffic filtering is enabled. Turning on the flag requires no rule using port 11000-11999.
	AllowSQLRedirect *bool `json:"allowSqlRedirect,omitempty"`
}

// FirewallPolicyThreatIntelWhitelist - ThreatIntel Whitelist for Firewall Policy.
type FirewallPolicyThreatIntelWhitelist struct {
	// List of FQDNs for the ThreatIntel Whitelist.
	Fqdns []*string `json:"fqdns,omitempty"`

	// List of IP addresses for the ThreatIntel Whitelist.
	IPAddresses []*string `json:"ipAddresses,omitempty"`
}

// FirewallPolicyTransportSecurity - Configuration needed to perform TLS termination & initiation.
type FirewallPolicyTransportSecurity struct {
	// The CA used for intermediate CA generation.
	CertificateAuthority *FirewallPolicyCertificateAuthority `json:"certificateAuthority,omitempty"`
}

// FlowLog - A flow log resource.
type FlowLog struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the flow log.
	Properties *FlowLogPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FlowLogFormatParameters - Parameters that define the flow log format.
type FlowLogFormatParameters struct {
	// The file type of flow log.
	Type *FlowLogFormatType `json:"type,omitempty"`

	// The version (revision) of the flow log.
	Version *int32 `json:"version,omitempty"`
}

// FlowLogInformation - Information on the configuration of flow log and traffic analytics (optional) .
type FlowLogInformation struct {
	// REQUIRED; Properties of the flow log.
	Properties *FlowLogProperties `json:"properties,omitempty"`

	// REQUIRED; The ID of the resource to configure for flow log and traffic analytics (optional) .
	TargetResourceID *string `json:"targetResourceId,omitempty"`

	// Parameters that define the configuration of traffic analytics.
	FlowAnalyticsConfiguration *TrafficAnalyticsProperties `json:"flowAnalyticsConfiguration,omitempty"`
}

// FlowLogListResult - List of flow logs.
type FlowLogListResult struct {
	// Information about flow log resource.
	Value []*FlowLog `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// FlowLogProperties - Parameters that define the configuration of flow log.
type FlowLogProperties struct {
	// REQUIRED; Flag to enable/disable flow logging.
	Enabled *bool `json:"enabled,omitempty"`

	// REQUIRED; ID of the storage account which is used to store the flow log.
	StorageID *string `json:"storageId,omitempty"`

	// Parameters that define the flow log format.
	Format *FlowLogFormatParameters `json:"format,omitempty"`

	// Parameters that define the retention policy for flow log.
	RetentionPolicy *RetentionPolicyParameters `json:"retentionPolicy,omitempty"`
}

// FlowLogPropertiesFormat - Parameters that define the configuration of flow log.
type FlowLogPropertiesFormat struct {
	// REQUIRED; ID of the storage account which is used to store the flow log.
	StorageID *string `json:"storageId,omitempty"`

	// REQUIRED; ID of network security group to which flow log will be applied.
	TargetResourceID *string `json:"targetResourceId,omitempty"`

	// Flag to enable/disable flow logging.
	Enabled *bool `json:"enabled,omitempty"`

	// Parameters that define the configuration of traffic analytics.
	FlowAnalyticsConfiguration *TrafficAnalyticsProperties `json:"flowAnalyticsConfiguration,omitempty"`

	// Parameters that define the flow log format.
	Format *FlowLogFormatParameters `json:"format,omitempty"`

	// Parameters that define the retention policy for flow log.
	RetentionPolicy *RetentionPolicyParameters `json:"retentionPolicy,omitempty"`

	// READ-ONLY; The provisioning state of the flow log.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Guid of network security group to which flow log will be applied.
	TargetResourceGUID *string `json:"targetResourceGuid,omitempty" azure:"ro"`
}

// FlowLogStatusParameters - Parameters that define a resource to query flow log and traffic analytics (optional) status.
type FlowLogStatusParameters struct {
	// REQUIRED; The target resource where getting the flow log and traffic analytics (optional) status.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// FlowLogsClientBeginCreateOrUpdateOptions contains the optional parameters for the FlowLogsClient.BeginCreateOrUpdate method.
type FlowLogsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FlowLogsClientBeginDeleteOptions contains the optional parameters for the FlowLogsClient.BeginDelete method.
type FlowLogsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FlowLogsClientGetOptions contains the optional parameters for the FlowLogsClient.Get method.
type FlowLogsClientGetOptions struct {
	// placeholder for future optional parameters
}

// FlowLogsClientListOptions contains the optional parameters for the FlowLogsClient.List method.
type FlowLogsClientListOptions struct {
	// placeholder for future optional parameters
}

// FlowLogsClientUpdateTagsOptions contains the optional parameters for the FlowLogsClient.UpdateTags method.
type FlowLogsClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// FrontendIPConfiguration - Frontend IP address of the load balancer.
type FrontendIPConfiguration struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name
	// can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the load balancer probe.
	Properties *FrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`

	// A list of availability zones denoting the IP allocated for the resource needs to come from.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FrontendIPConfigurationPropertiesFormat - Properties of Frontend IP Configuration of the load balancer.
type FrontendIPConfigurationPropertiesFormat struct {
	// The reference to gateway load balancer frontend IP.
	GatewayLoadBalancer *SubResource `json:"gatewayLoadBalancer,omitempty"`

	// The private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`

	// Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
	PrivateIPAddressVersion *IPVersion `json:"privateIPAddressVersion,omitempty"`

	// The Private IP allocation method.
	PrivateIPAllocationMethod *IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`

	// The reference to the Public IP resource.
	PublicIPAddress *PublicIPAddress `json:"publicIPAddress,omitempty"`

	// The reference to the Public IP Prefix resource.
	PublicIPPrefix *SubResource `json:"publicIPPrefix,omitempty"`

	// The reference to the subnet resource.
	Subnet *Subnet `json:"subnet,omitempty"`

	// READ-ONLY; An array of references to inbound pools that use this frontend IP.
	InboundNatPools []*SubResource `json:"inboundNatPools,omitempty" azure:"ro"`

	// READ-ONLY; An array of references to inbound rules that use this frontend IP.
	InboundNatRules []*SubResource `json:"inboundNatRules,omitempty" azure:"ro"`

	// READ-ONLY; An array of references to load balancing rules that use this frontend IP.
	LoadBalancingRules []*SubResource `json:"loadBalancingRules,omitempty" azure:"ro"`

	// READ-ONLY; An array of references to outbound rules that use this frontend IP.
	OutboundRules []*SubResource `json:"outboundRules,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the frontend IP configuration resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GatewayCustomBgpIPAddressIPConfiguration - GatewayCustomBgpIpAddressIpConfiguration for a virtual network gateway connection.
type GatewayCustomBgpIPAddressIPConfiguration struct {
	// REQUIRED; The custom BgpPeeringAddress which belongs to IpconfigurationId.
	CustomBgpIPAddress *string `json:"customBgpIpAddress,omitempty"`

	// REQUIRED; The IpconfigurationId of ipconfiguration which belongs to gateway.
	IPConfigurationID *string `json:"ipConfigurationId,omitempty"`
}

// GatewayLoadBalancerTunnelInterface - Gateway load balancer tunnel interface of a load balancer backend address pool.
type GatewayLoadBalancerTunnelInterface struct {
	// Identifier of gateway load balancer tunnel interface.
	Identifier *int32 `json:"identifier,omitempty"`

	// Port of gateway load balancer tunnel interface.
	Port *int32 `json:"port,omitempty"`

	// Protocol of gateway load balancer tunnel interface.
	Protocol *GatewayLoadBalancerTunnelProtocol `json:"protocol,omitempty"`

	// Traffic type of gateway load balancer tunnel interface.
	Type *GatewayLoadBalancerTunnelInterfaceType `json:"type,omitempty"`
}

// GatewayRoute - Gateway routing details.
type GatewayRoute struct {
	// READ-ONLY; The route's AS path sequence.
	AsPath *string `json:"asPath,omitempty" azure:"ro"`

	// READ-ONLY; The gateway's local address.
	LocalAddress *string `json:"localAddress,omitempty" azure:"ro"`

	// READ-ONLY; The route's network prefix.
	Network *string `json:"network,omitempty" azure:"ro"`

	// READ-ONLY; The route's next hop.
	NextHop *string `json:"nextHop,omitempty" azure:"ro"`

	// READ-ONLY; The source this route was learned from.
	Origin *string `json:"origin,omitempty" azure:"ro"`

	// READ-ONLY; The peer this route was learned from.
	SourcePeer *string `json:"sourcePeer,omitempty" azure:"ro"`

	// READ-ONLY; The route's weight.
	Weight *int32 `json:"weight,omitempty" azure:"ro"`
}

// GatewayRouteListResult - List of virtual network gateway routes.
type GatewayRouteListResult struct {
	// List of gateway routes.
	Value []*GatewayRoute `json:"value,omitempty"`
}

// GenerateExpressRoutePortsLOARequest - The customer name to be printed on a letter of authorization.
type GenerateExpressRoutePortsLOARequest struct {
	// REQUIRED; The customer name.
	CustomerName *string `json:"customerName,omitempty"`
}

// GenerateExpressRoutePortsLOAResult - Response for GenerateExpressRoutePortsLOA API service call.
type GenerateExpressRoutePortsLOAResult struct {
	// The content as a base64 encoded string.
	EncodedContent *string `json:"encodedContent,omitempty"`
}

// GetVPNSitesConfigurationRequest - List of Vpn-Sites.
type GetVPNSitesConfigurationRequest struct {
	// REQUIRED; The sas-url to download the configurations for vpn-sites.
	OutputBlobSasURL *string `json:"outputBlobSasUrl,omitempty"`

	// List of resource-ids of the vpn-sites for which config is to be downloaded.
	VPNSites []*string `json:"vpnSites,omitempty"`
}

// Group - The network group resource
type Group struct {
	// The Network Group properties
	Properties *GroupProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GroupListResult - Result of the request to list NetworkGroup. It contains a list of groups and a URL link to get the next
// set of results.
type GroupListResult struct {
	// Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets a page of NetworkGroup
	Value []*Group `json:"value,omitempty"`
}

// GroupProperties - Properties of network group
type GroupProperties struct {
	// A description of the network group.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; The provisioning state of the scope assignment resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GroupsClientBeginDeleteOptions contains the optional parameters for the GroupsClient.BeginDelete method.
type GroupsClientBeginDeleteOptions struct {
	// Deletes the resource even if it is part of a deployed configuration. If the configuration has been deployed, the service
	// will do a cleanup deployment in the background, prior to the delete.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GroupsClientCreateOrUpdateOptions contains the optional parameters for the GroupsClient.CreateOrUpdate method.
type GroupsClientCreateOrUpdateOptions struct {
	// The ETag of the transformation. Omit this value to always overwrite the current resource. Specify the last-seen ETag value
	// to prevent accidentally overwriting concurrent changes.
	IfMatch *string
}

// GroupsClientGetOptions contains the optional parameters for the GroupsClient.Get method.
type GroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// GroupsClientListOptions contains the optional parameters for the GroupsClient.List method.
type GroupsClientListOptions struct {
	// SkipToken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skipToken parameter that
	// specifies a starting point to use for subsequent calls.
	SkipToken *string
	// An optional query parameter which specifies the maximum number of records to be returned by the server.
	Top *int32
}

// HTTPConfiguration - HTTP configuration of the connectivity check.
type HTTPConfiguration struct {
	// List of HTTP headers.
	Headers []*HTTPHeader `json:"headers,omitempty"`

	// HTTP method.
	Method *HTTPMethod `json:"method,omitempty"`

	// Valid status codes.
	ValidStatusCodes []*int32 `json:"validStatusCodes,omitempty"`
}

// HTTPHeader - The HTTP header.
type HTTPHeader struct {
	// The name in HTTP header.
	Name *string `json:"name,omitempty"`

	// The value in HTTP header.
	Value *string `json:"value,omitempty"`
}

// HopLink - Hop link.
type HopLink struct {
	// Hop link properties.
	Properties *HopLinkProperties `json:"properties,omitempty"`

	// READ-ONLY; Provides additional context on links.
	Context map[string]*string `json:"context,omitempty" azure:"ro"`

	// READ-ONLY; List of issues.
	Issues []*ConnectivityIssue `json:"issues,omitempty" azure:"ro"`

	// READ-ONLY; Link type.
	LinkType *string `json:"linkType,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the next hop.
	NextHopID *string `json:"nextHopId,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ResourceID *string `json:"resourceId,omitempty" azure:"ro"`
}

// HopLinkProperties - Hop link properties.
type HopLinkProperties struct {
	// READ-ONLY; Average roundtrip time in milliseconds.
	RoundTripTimeAvg *int64 `json:"roundTripTimeAvg,omitempty" azure:"ro"`

	// READ-ONLY; Maximum roundtrip time in milliseconds.
	RoundTripTimeMax *int64 `json:"roundTripTimeMax,omitempty" azure:"ro"`

	// READ-ONLY; Minimum roundtrip time in milliseconds.
	RoundTripTimeMin *int64 `json:"roundTripTimeMin,omitempty" azure:"ro"`
}

// Hub Item.
type Hub struct {
	// Resource Id.
	ResourceID *string `json:"resourceId,omitempty"`

	// Resource Type.
	ResourceType *string `json:"resourceType,omitempty"`
}

// HubIPAddresses - IP addresses associated with azure firewall.
type HubIPAddresses struct {
	// Private IP Address associated with azure firewall.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`

	// Public IP addresses associated with azure firewall.
	PublicIPs *HubPublicIPAddresses `json:"publicIPs,omitempty"`
}

// HubIPConfiguration - IpConfigurations.
type HubIPConfiguration struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the Ip Configuration.
	Name *string `json:"name,omitempty"`

	// The properties of the Virtual Hub IPConfigurations.
	Properties *HubIPConfigurationPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Ipconfiguration type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HubIPConfigurationPropertiesFormat - Properties of IP configuration.
type HubIPConfigurationPropertiesFormat struct {
	// The private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`

	// The private IP address allocation method.
	PrivateIPAllocationMethod *IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`

	// The reference to the public IP resource.
	PublicIPAddress *PublicIPAddress `json:"publicIPAddress,omitempty"`

	// The reference to the subnet resource.
	Subnet *Subnet `json:"subnet,omitempty"`

	// READ-ONLY; The provisioning state of the IP configuration resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// HubPublicIPAddresses - Public IP addresses associated with azure firewall.
type HubPublicIPAddresses struct {
	// The list of Public IP addresses associated with azure firewall or IP addresses to be retained.
	Addresses []*AzureFirewallPublicIPAddress `json:"addresses,omitempty"`

	// The number of Public IP addresses associated with azure firewall.
	Count *int32 `json:"count,omitempty"`
}

// HubRoute - RouteTable route.
type HubRoute struct {
	// REQUIRED; The type of destinations (eg: CIDR, ResourceId, Service).
	DestinationType *string `json:"destinationType,omitempty"`

	// REQUIRED; List of all destinations.
	Destinations []*string `json:"destinations,omitempty"`

	// REQUIRED; The name of the Route that is unique within a RouteTable. This name can be used to access this route.
	Name *string `json:"name,omitempty"`

	// REQUIRED; NextHop resource ID.
	NextHop *string `json:"nextHop,omitempty"`

	// REQUIRED; The type of next hop (eg: ResourceId).
	NextHopType *string `json:"nextHopType,omitempty"`
}

// HubRouteTable - RouteTable resource in a virtual hub.
type HubRouteTable struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the RouteTable resource.
	Properties *HubRouteTableProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HubRouteTableProperties - Parameters for RouteTable.
type HubRouteTableProperties struct {
	// List of labels associated with this route table.
	Labels []*string `json:"labels,omitempty"`

	// List of all routes.
	Routes []*HubRoute `json:"routes,omitempty"`

	// READ-ONLY; List of all connections associated with this route table.
	AssociatedConnections []*string `json:"associatedConnections,omitempty" azure:"ro"`

	// READ-ONLY; List of all connections that advertise to this route table.
	PropagatingConnections []*string `json:"propagatingConnections,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the RouteTable resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// HubRouteTablesClientBeginCreateOrUpdateOptions contains the optional parameters for the HubRouteTablesClient.BeginCreateOrUpdate
// method.
type HubRouteTablesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// HubRouteTablesClientBeginDeleteOptions contains the optional parameters for the HubRouteTablesClient.BeginDelete method.
type HubRouteTablesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// HubRouteTablesClientGetOptions contains the optional parameters for the HubRouteTablesClient.Get method.
type HubRouteTablesClientGetOptions struct {
	// placeholder for future optional parameters
}

// HubRouteTablesClientListOptions contains the optional parameters for the HubRouteTablesClient.List method.
type HubRouteTablesClientListOptions struct {
	// placeholder for future optional parameters
}

// HubVirtualNetworkConnection Resource.
type HubVirtualNetworkConnection struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the hub virtual network connection.
	Properties *HubVirtualNetworkConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// HubVirtualNetworkConnectionProperties - Parameters for HubVirtualNetworkConnection.
type HubVirtualNetworkConnectionProperties struct {
	// Deprecated: VirtualHub to RemoteVnet transit to enabled or not.
	AllowHubToRemoteVnetTransit *bool `json:"allowHubToRemoteVnetTransit,omitempty"`

	// Deprecated: Allow RemoteVnet to use Virtual Hub's gateways.
	AllowRemoteVnetToUseHubVnetGateways *bool `json:"allowRemoteVnetToUseHubVnetGateways,omitempty"`

	// Enable internet security.
	EnableInternetSecurity *bool `json:"enableInternetSecurity,omitempty"`

	// Reference to the remote virtual network.
	RemoteVirtualNetwork *SubResource `json:"remoteVirtualNetwork,omitempty"`

	// The Routing Configuration indicating the associated and propagated route tables on this connection.
	RoutingConfiguration *RoutingConfiguration `json:"routingConfiguration,omitempty"`

	// READ-ONLY; The provisioning state of the hub virtual network connection resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// HubVirtualNetworkConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the HubVirtualNetworkConnectionsClient.BeginCreateOrUpdate
// method.
type HubVirtualNetworkConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// HubVirtualNetworkConnectionsClientBeginDeleteOptions contains the optional parameters for the HubVirtualNetworkConnectionsClient.BeginDelete
// method.
type HubVirtualNetworkConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// HubVirtualNetworkConnectionsClientGetOptions contains the optional parameters for the HubVirtualNetworkConnectionsClient.Get
// method.
type HubVirtualNetworkConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// HubVirtualNetworkConnectionsClientListOptions contains the optional parameters for the HubVirtualNetworkConnectionsClient.List
// method.
type HubVirtualNetworkConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// IDPSQueryObject - Will describe the query to run against the IDPS signatures DB
type IDPSQueryObject struct {
	// Contain all filters names and values
	Filters []*FilterItems `json:"filters,omitempty"`

	// Column to sort response by
	OrderBy *OrderBy `json:"orderBy,omitempty"`

	// The number of the results to return in each page
	ResultsPerPage *int32 `json:"resultsPerPage,omitempty"`

	// Search term in all columns
	Search *string `json:"search,omitempty"`

	// The number of records matching the filter to skip
	Skip *int32 `json:"skip,omitempty"`
}

// IPAddressAvailabilityResult - Response for CheckIPAddressAvailability API service call.
type IPAddressAvailabilityResult struct {
	// Private IP address availability.
	Available *bool `json:"available,omitempty"`

	// Contains other available private IP addresses if the asked for address is taken.
	AvailableIPAddresses []*string `json:"availableIPAddresses,omitempty"`

	// Private IP address platform reserved.
	IsPlatformReserved *bool `json:"isPlatformReserved,omitempty"`
}

// IPAllocation - IpAllocation resource.
type IPAllocation struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the IpAllocation.
	Properties *IPAllocationPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IPAllocationListResult - Response for the ListIpAllocations API service call.
type IPAllocationListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of IpAllocation resources.
	Value []*IPAllocation `json:"value,omitempty"`
}

// IPAllocationPropertiesFormat - Properties of the IpAllocation.
type IPAllocationPropertiesFormat struct {
	// IpAllocation tags.
	AllocationTags map[string]*string `json:"allocationTags,omitempty"`

	// The IPAM allocation ID.
	IpamAllocationID *string `json:"ipamAllocationId,omitempty"`

	// The address prefix for the IpAllocation.
	Prefix *string `json:"prefix,omitempty"`

	// The address prefix length for the IpAllocation.
	PrefixLength *int32 `json:"prefixLength,omitempty"`

	// The address prefix Type for the IpAllocation.
	PrefixType *IPVersion `json:"prefixType,omitempty"`

	// The type for the IpAllocation.
	Type *IPAllocationType `json:"type,omitempty"`

	// READ-ONLY; The Subnet that using the prefix of this IpAllocation resource.
	Subnet *SubResource `json:"subnet,omitempty" azure:"ro"`

	// READ-ONLY; The VirtualNetwork that using the prefix of this IpAllocation resource.
	VirtualNetwork *SubResource `json:"virtualNetwork,omitempty" azure:"ro"`
}

// IPAllocationsClientBeginCreateOrUpdateOptions contains the optional parameters for the IPAllocationsClient.BeginCreateOrUpdate
// method.
type IPAllocationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IPAllocationsClientBeginDeleteOptions contains the optional parameters for the IPAllocationsClient.BeginDelete method.
type IPAllocationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IPAllocationsClientGetOptions contains the optional parameters for the IPAllocationsClient.Get method.
type IPAllocationsClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// IPAllocationsClientListByResourceGroupOptions contains the optional parameters for the IPAllocationsClient.ListByResourceGroup
// method.
type IPAllocationsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// IPAllocationsClientListOptions contains the optional parameters for the IPAllocationsClient.List method.
type IPAllocationsClientListOptions struct {
	// placeholder for future optional parameters
}

// IPAllocationsClientUpdateTagsOptions contains the optional parameters for the IPAllocationsClient.UpdateTags method.
type IPAllocationsClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// IPConfiguration - IP configuration.
type IPConfiguration struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the IP configuration.
	Properties *IPConfigurationPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// IPConfigurationBgpPeeringAddress - Properties of IPConfigurationBgpPeeringAddress.
type IPConfigurationBgpPeeringAddress struct {
	// The list of custom BGP peering addresses which belong to IP configuration.
	CustomBgpIPAddresses []*string `json:"customBgpIpAddresses,omitempty"`

	// The ID of IP configuration which belongs to gateway.
	IPConfigurationID *string `json:"ipconfigurationId,omitempty"`

	// READ-ONLY; The list of default BGP peering addresses which belong to IP configuration.
	DefaultBgpIPAddresses []*string `json:"defaultBgpIpAddresses,omitempty" azure:"ro"`

	// READ-ONLY; The list of tunnel public IP addresses which belong to IP configuration.
	TunnelIPAddresses []*string `json:"tunnelIpAddresses,omitempty" azure:"ro"`
}

// IPConfigurationProfile - IP configuration profile child resource.
type IPConfigurationProfile struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the IP configuration profile.
	Properties *IPConfigurationProfilePropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Sub Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IPConfigurationProfilePropertiesFormat - IP configuration profile properties.
type IPConfigurationProfilePropertiesFormat struct {
	// The reference to the subnet resource to create a container network interface ip configuration.
	Subnet *Subnet `json:"subnet,omitempty"`

	// READ-ONLY; The provisioning state of the IP configuration profile resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// IPConfigurationPropertiesFormat - Properties of IP configuration.
type IPConfigurationPropertiesFormat struct {
	// The private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`

	// The private IP address allocation method.
	PrivateIPAllocationMethod *IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`

	// The reference to the public IP resource.
	PublicIPAddress *PublicIPAddress `json:"publicIPAddress,omitempty"`

	// The reference to the subnet resource.
	Subnet *Subnet `json:"subnet,omitempty"`

	// READ-ONLY; The provisioning state of the IP configuration resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// IPGroup - The IpGroups resource information.
type IPGroup struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the IpGroups.
	Properties *IPGroupPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IPGroupListResult - Response for the ListIpGroups API service call.
type IPGroupListResult struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of IpGroups information resources.
	Value []*IPGroup `json:"value,omitempty"`
}

// IPGroupPropertiesFormat - The IpGroups property information.
type IPGroupPropertiesFormat struct {
	// IpAddresses/IpAddressPrefixes in the IpGroups resource.
	IPAddresses []*string `json:"ipAddresses,omitempty"`

	// READ-ONLY; List of references to Firewall Policies resources that this IpGroups is associated with.
	FirewallPolicies []*SubResource `json:"firewallPolicies,omitempty" azure:"ro"`

	// READ-ONLY; List of references to Firewall resources that this IpGroups is associated with.
	Firewalls []*SubResource `json:"firewalls,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the IpGroups resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// IPGroupsClientBeginCreateOrUpdateOptions contains the optional parameters for the IPGroupsClient.BeginCreateOrUpdate method.
type IPGroupsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IPGroupsClientBeginDeleteOptions contains the optional parameters for the IPGroupsClient.BeginDelete method.
type IPGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IPGroupsClientGetOptions contains the optional parameters for the IPGroupsClient.Get method.
type IPGroupsClientGetOptions struct {
	// Expands resourceIds (of Firewalls/Network Security Groups etc.) back referenced by the IpGroups resource.
	Expand *string
}

// IPGroupsClientListByResourceGroupOptions contains the optional parameters for the IPGroupsClient.ListByResourceGroup method.
type IPGroupsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// IPGroupsClientListOptions contains the optional parameters for the IPGroupsClient.List method.
type IPGroupsClientListOptions struct {
	// placeholder for future optional parameters
}

// IPGroupsClientUpdateGroupsOptions contains the optional parameters for the IPGroupsClient.UpdateGroups method.
type IPGroupsClientUpdateGroupsOptions struct {
	// placeholder for future optional parameters
}

// IPPrefixesList - List of SNAT IP Prefixes learnt by firewall to not SNAT
type IPPrefixesList struct {
	// IP Prefix value.
	IPPrefixes []*string `json:"ipPrefixes,omitempty"`
}

// IPSecPolicy - An IPSec Policy configuration for a virtual network gateway connection.
type IPSecPolicy struct {
	// REQUIRED; The DH Group used in IKE Phase 1 for initial SA.
	DhGroup *DhGroup `json:"dhGroup,omitempty"`

	// REQUIRED; The IPSec encryption algorithm (IKE phase 1).
	IPSecEncryption *IPSecEncryption `json:"ipsecEncryption,omitempty"`

	// REQUIRED; The IPSec integrity algorithm (IKE phase 1).
	IPSecIntegrity *IPSecIntegrity `json:"ipsecIntegrity,omitempty"`

	// REQUIRED; The IKE encryption algorithm (IKE phase 2).
	IkeEncryption *IkeEncryption `json:"ikeEncryption,omitempty"`

	// REQUIRED; The IKE integrity algorithm (IKE phase 2).
	IkeIntegrity *IkeIntegrity `json:"ikeIntegrity,omitempty"`

	// REQUIRED; The Pfs Group used in IKE Phase 2 for new child SA.
	PfsGroup *PfsGroup `json:"pfsGroup,omitempty"`

	// REQUIRED; The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for a site to site VPN
	// tunnel.
	SaDataSizeKilobytes *int32 `json:"saDataSizeKilobytes,omitempty"`

	// REQUIRED; The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for a site to site
	// VPN tunnel.
	SaLifeTimeSeconds *int32 `json:"saLifeTimeSeconds,omitempty"`
}

// IPTag - Contains the IpTag associated with the object.
type IPTag struct {
	// The IP tag type. Example: FirstPartyUsage.
	IPTagType *string `json:"ipTagType,omitempty"`

	// The value of the IP tag associated with the public IP. Example: SQL.
	Tag *string `json:"tag,omitempty"`
}

// IPv6CircuitConnectionConfig - IPv6 Circuit Connection properties for global reach.
type IPv6CircuitConnectionConfig struct {
	// /125 IP address space to carve out customer addresses for global reach.
	AddressPrefix *string `json:"addressPrefix,omitempty"`

	// READ-ONLY; Express Route Circuit connection state.
	CircuitConnectionStatus *CircuitConnectionStatus `json:"circuitConnectionStatus,omitempty" azure:"ro"`
}

// IPv6ExpressRouteCircuitPeeringConfig - Contains IPv6 peering config.
type IPv6ExpressRouteCircuitPeeringConfig struct {
	// The Microsoft peering configuration.
	MicrosoftPeeringConfig *ExpressRouteCircuitPeeringConfig `json:"microsoftPeeringConfig,omitempty"`

	// The primary address prefix.
	PrimaryPeerAddressPrefix *string `json:"primaryPeerAddressPrefix,omitempty"`

	// The reference to the RouteFilter resource.
	RouteFilter *SubResource `json:"routeFilter,omitempty"`

	// The secondary address prefix.
	SecondaryPeerAddressPrefix *string `json:"secondaryPeerAddressPrefix,omitempty"`

	// The state of peering.
	State *ExpressRouteCircuitPeeringState `json:"state,omitempty"`
}

// InboundNatPool - Inbound NAT pool of the load balancer.
type InboundNatPool struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within the set of inbound NAT pools used by the load balancer. This name can be
	// used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of load balancer inbound nat pool.
	Properties *InboundNatPoolPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InboundNatPoolPropertiesFormat - Properties of Inbound NAT pool.
type InboundNatPoolPropertiesFormat struct {
	// REQUIRED; The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
	BackendPort *int32 `json:"backendPort,omitempty"`

	// REQUIRED; The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated
	// with a load balancer. Acceptable values range between 1 and 65535.
	FrontendPortRangeEnd *int32 `json:"frontendPortRangeEnd,omitempty"`

	// REQUIRED; The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated
	// with a load balancer. Acceptable values range between 1 and 65534.
	FrontendPortRangeStart *int32 `json:"frontendPortRangeStart,omitempty"`

	// REQUIRED; The reference to the transport protocol used by the inbound NAT pool.
	Protocol *TransportProtocol `json:"protocol,omitempty"`

	// Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability
	// Group. This setting is required when using the SQL AlwaysOn Availability Groups
	// in SQL server. This setting can't be changed after you create the endpoint.
	EnableFloatingIP *bool `json:"enableFloatingIP,omitempty"`

	// Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used
	// when the protocol is set to TCP.
	EnableTCPReset *bool `json:"enableTcpReset,omitempty"`

	// A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`

	// The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes.
	// This element is only used when the protocol is set to TCP.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// READ-ONLY; The provisioning state of the inbound NAT pool resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// InboundNatRule - Inbound NAT rule of the load balancer.
type InboundNatRule struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be
	// used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of load balancer inbound NAT rule.
	Properties *InboundNatRulePropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InboundNatRuleListResult - Response for ListInboundNatRule API service call.
type InboundNatRuleListResult struct {
	// A list of inbound NAT rules in a load balancer.
	Value []*InboundNatRule `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// InboundNatRulePortMapping - Individual port mappings for inbound NAT rule created for backend pool.
type InboundNatRulePortMapping struct {
	// READ-ONLY; Backend port.
	BackendPort *int32 `json:"backendPort,omitempty" azure:"ro"`

	// READ-ONLY; Frontend port.
	FrontendPort *int32 `json:"frontendPort,omitempty" azure:"ro"`

	// READ-ONLY; Name of inbound NAT rule.
	InboundNatRuleName *string `json:"inboundNatRuleName,omitempty" azure:"ro"`

	// READ-ONLY; The reference to the transport protocol used by the inbound NAT rule.
	Protocol *TransportProtocol `json:"protocol,omitempty" azure:"ro"`
}

// InboundNatRulePropertiesFormat - Properties of the inbound NAT rule.
type InboundNatRulePropertiesFormat struct {
	// A reference to backendAddressPool resource.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`

	// The port used for the internal endpoint. Acceptable values range from 1 to 65535.
	BackendPort *int32 `json:"backendPort,omitempty"`

	// Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability
	// Group. This setting is required when using the SQL AlwaysOn Availability Groups
	// in SQL server. This setting can't be changed after you create the endpoint.
	EnableFloatingIP *bool `json:"enableFloatingIP,omitempty"`

	// Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used
	// when the protocol is set to TCP.
	EnableTCPReset *bool `json:"enableTcpReset,omitempty"`

	// A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`

	// The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values
	// range from 1 to 65534.
	FrontendPort *int32 `json:"frontendPort,omitempty"`

	// The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart.
	// Individual inbound NAT rule port mappings will be created for each
	// backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
	FrontendPortRangeEnd *int32 `json:"frontendPortRangeEnd,omitempty"`

	// The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd.
	// Individual inbound NAT rule port mappings will be created for each
	// backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
	FrontendPortRangeStart *int32 `json:"frontendPortRangeStart,omitempty"`

	// The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes.
	// This element is only used when the protocol is set to TCP.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// The reference to the transport protocol used by the load balancing rule.
	Protocol *TransportProtocol `json:"protocol,omitempty"`

	// READ-ONLY; A reference to a private IP address defined on a network interface of a VM. Traffic sent to the frontend port
	// of each of the frontend IP configurations is forwarded to the backend IP.
	BackendIPConfiguration *InterfaceIPConfiguration `json:"backendIPConfiguration,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the inbound NAT rule resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// InboundNatRulesClientBeginCreateOrUpdateOptions contains the optional parameters for the InboundNatRulesClient.BeginCreateOrUpdate
// method.
type InboundNatRulesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InboundNatRulesClientBeginDeleteOptions contains the optional parameters for the InboundNatRulesClient.BeginDelete method.
type InboundNatRulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InboundNatRulesClientGetOptions contains the optional parameters for the InboundNatRulesClient.Get method.
type InboundNatRulesClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// InboundNatRulesClientListOptions contains the optional parameters for the InboundNatRulesClient.List method.
type InboundNatRulesClientListOptions struct {
	// placeholder for future optional parameters
}

// InboundSecurityRule - NVA Inbound Security Rule resource.
type InboundSecurityRule struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of security rule collection.
	Name *string `json:"name,omitempty"`

	// The properties of the Inbound Security Rules.
	Properties *InboundSecurityRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; NVA inbound security rule type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InboundSecurityRuleClientBeginCreateOrUpdateOptions contains the optional parameters for the InboundSecurityRuleClient.BeginCreateOrUpdate
// method.
type InboundSecurityRuleClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InboundSecurityRuleProperties - Properties of the Inbound Security Rules resource.
type InboundSecurityRuleProperties struct {
	// List of allowed rules.
	Rules []*InboundSecurityRules `json:"rules,omitempty"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// InboundSecurityRules - Properties of the Inbound Security Rules resource.
type InboundSecurityRules struct {
	// NVA port ranges to be opened up. One needs to provide specific ports.
	DestinationPortRange *int32 `json:"destinationPortRange,omitempty"`

	// Protocol. This should be either TCP or UDP.
	Protocol *InboundSecurityRulesProtocol `json:"protocol,omitempty"`

	// The CIDR or source IP range. Only /30, /31 and /32 Ip ranges are allowed.
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`
}

// IntentPolicy - Network Intent Policy resource.
type IntentPolicy struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IntentPolicyConfiguration - Details of NetworkIntentPolicyConfiguration for PrepareNetworkPoliciesRequest.
type IntentPolicyConfiguration struct {
	// The name of the Network Intent Policy for storing in target subscription.
	NetworkIntentPolicyName *string `json:"networkIntentPolicyName,omitempty"`

	// Source network intent policy.
	SourceNetworkIntentPolicy *IntentPolicy `json:"sourceNetworkIntentPolicy,omitempty"`
}

// Interface - A network interface in a resource group.
type Interface struct {
	// The extended location of the network interface.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the network interface.
	Properties *InterfacePropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InterfaceAssociation - Network interface and its custom security rules.
type InterfaceAssociation struct {
	// Collection of custom security rules.
	SecurityRules []*SecurityRule `json:"securityRules,omitempty"`

	// READ-ONLY; Network interface ID.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// InterfaceDNSSettings - DNS settings of a network interface.
type InterfaceDNSSettings struct {
	// List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS'
	// value cannot be combined with other IPs, it must be the only value in dnsServers
	// collection.
	DNSServers []*string `json:"dnsServers,omitempty"`

	// Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.
	InternalDNSNameLabel *string `json:"internalDnsNameLabel,omitempty"`

	// READ-ONLY; If the VM that uses this NIC is part of an Availability Set, then this list will have the union of all DNS servers
	// from all NICs that are part of the Availability Set. This property is what is
	// configured on each of those VMs.
	AppliedDNSServers []*string `json:"appliedDnsServers,omitempty" azure:"ro"`

	// READ-ONLY; Even if internalDnsNameLabel is not specified, a DNS entry is created for the primary NIC of the VM. This DNS
	// name can be constructed by concatenating the VM name with the value of
	// internalDomainNameSuffix.
	InternalDomainNameSuffix *string `json:"internalDomainNameSuffix,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified DNS name supporting internal communications between VMs in the same virtual network.
	InternalFqdn *string `json:"internalFqdn,omitempty" azure:"ro"`
}

// InterfaceIPConfiguration - IPConfiguration in a network interface.
type InterfaceIPConfiguration struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Network interface IP configuration properties.
	Properties *InterfaceIPConfigurationPropertiesFormat `json:"properties,omitempty"`

	// Resource type.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// InterfaceIPConfigurationListResult - Response for list ip configurations API service call.
type InterfaceIPConfigurationListResult struct {
	// A list of ip configurations.
	Value []*InterfaceIPConfiguration `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// InterfaceIPConfigurationPrivateLinkConnectionProperties - PrivateLinkConnection properties for the network interface.
type InterfaceIPConfigurationPrivateLinkConnectionProperties struct {
	// READ-ONLY; List of FQDNs for current private link connection.
	Fqdns []*string `json:"fqdns,omitempty" azure:"ro"`

	// READ-ONLY; The group ID for current private link connection.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The required member name for current private link connection.
	RequiredMemberName *string `json:"requiredMemberName,omitempty" azure:"ro"`
}

// InterfaceIPConfigurationPropertiesFormat - Properties of IP configuration.
type InterfaceIPConfigurationPropertiesFormat struct {
	// The reference to ApplicationGatewayBackendAddressPool resource.
	ApplicationGatewayBackendAddressPools []*ApplicationGatewayBackendAddressPool `json:"applicationGatewayBackendAddressPools,omitempty"`

	// Application security groups in which the IP configuration is included.
	ApplicationSecurityGroups []*ApplicationSecurityGroup `json:"applicationSecurityGroups,omitempty"`

	// The reference to gateway load balancer frontend IP.
	GatewayLoadBalancer *SubResource `json:"gatewayLoadBalancer,omitempty"`

	// The reference to LoadBalancerBackendAddressPool resource.
	LoadBalancerBackendAddressPools []*BackendAddressPool `json:"loadBalancerBackendAddressPools,omitempty"`

	// A list of references of LoadBalancerInboundNatRules.
	LoadBalancerInboundNatRules []*InboundNatRule `json:"loadBalancerInboundNatRules,omitempty"`

	// Whether this is a primary customer address on the network interface.
	Primary *bool `json:"primary,omitempty"`

	// Private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`

	// Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
	PrivateIPAddressVersion *IPVersion `json:"privateIPAddressVersion,omitempty"`

	// The private IP address allocation method.
	PrivateIPAllocationMethod *IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`

	// Public IP address bound to the IP configuration.
	PublicIPAddress *PublicIPAddress `json:"publicIPAddress,omitempty"`

	// Subnet bound to the IP configuration.
	Subnet *Subnet `json:"subnet,omitempty"`

	// The reference to Virtual Network Taps.
	VirtualNetworkTaps []*VirtualNetworkTap `json:"virtualNetworkTaps,omitempty"`

	// READ-ONLY; PrivateLinkConnection properties for the network interface.
	PrivateLinkConnectionProperties *InterfaceIPConfigurationPrivateLinkConnectionProperties `json:"privateLinkConnectionProperties,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the network interface IP configuration.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// InterfaceIPConfigurationsClientGetOptions contains the optional parameters for the InterfaceIPConfigurationsClient.Get
// method.
type InterfaceIPConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// InterfaceIPConfigurationsClientListOptions contains the optional parameters for the InterfaceIPConfigurationsClient.List
// method.
type InterfaceIPConfigurationsClientListOptions struct {
	// placeholder for future optional parameters
}

// InterfaceListResult - Response for the ListNetworkInterface API service call.
type InterfaceListResult struct {
	// A list of network interfaces in a resource group.
	Value []*Interface `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// InterfaceLoadBalancerListResult - Response for list ip configurations API service call.
type InterfaceLoadBalancerListResult struct {
	// A list of load balancers.
	Value []*LoadBalancer `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// InterfaceLoadBalancersClientListOptions contains the optional parameters for the InterfaceLoadBalancersClient.List method.
type InterfaceLoadBalancersClientListOptions struct {
	// placeholder for future optional parameters
}

// InterfacePropertiesFormat - NetworkInterface properties.
type InterfacePropertiesFormat struct {
	// Auxiliary mode of Network Interface resource.
	AuxiliaryMode *NetworkInterfaceAuxiliaryMode `json:"auxiliaryMode,omitempty"`

	// The DNS settings in network interface.
	DNSSettings *InterfaceDNSSettings `json:"dnsSettings,omitempty"`

	// If the network interface is configured for accelerated networking. Not applicable to VM sizes which require accelerated
	// networking.
	EnableAcceleratedNetworking *bool `json:"enableAcceleratedNetworking,omitempty"`

	// Indicates whether IP forwarding is enabled on this network interface.
	EnableIPForwarding *bool `json:"enableIPForwarding,omitempty"`

	// A list of IPConfigurations of the network interface.
	IPConfigurations []*InterfaceIPConfiguration `json:"ipConfigurations,omitempty"`

	// Migration phase of Network Interface resource.
	MigrationPhase *NetworkInterfaceMigrationPhase `json:"migrationPhase,omitempty"`

	// The reference to the NetworkSecurityGroup resource.
	NetworkSecurityGroup *SecurityGroup `json:"networkSecurityGroup,omitempty"`

	// Type of Network Interface resource.
	NicType *NetworkInterfaceNicType `json:"nicType,omitempty"`

	// Privatelinkservice of the network interface resource.
	PrivateLinkService *PrivateLinkService `json:"privateLinkService,omitempty"`

	// WorkloadType of the NetworkInterface for BareMetal resources
	WorkloadType *string `json:"workloadType,omitempty"`

	// READ-ONLY; A reference to the dscp configuration to which the network interface is linked.
	DscpConfiguration *SubResource `json:"dscpConfiguration,omitempty" azure:"ro"`

	// READ-ONLY; A list of references to linked BareMetal resources.
	HostedWorkloads []*string `json:"hostedWorkloads,omitempty" azure:"ro"`

	// READ-ONLY; The MAC address of the network interface.
	MacAddress *string `json:"macAddress,omitempty" azure:"ro"`

	// READ-ONLY; Whether this is a primary network interface on a virtual machine.
	Primary *bool `json:"primary,omitempty" azure:"ro"`

	// READ-ONLY; A reference to the private endpoint to which the network interface is linked.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the network interface resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the network interface resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`

	// READ-ONLY; A list of TapConfigurations of the network interface.
	TapConfigurations []*InterfaceTapConfiguration `json:"tapConfigurations,omitempty" azure:"ro"`

	// READ-ONLY; The reference to a virtual machine.
	VirtualMachine *SubResource `json:"virtualMachine,omitempty" azure:"ro"`

	// READ-ONLY; Whether the virtual machine this nic is attached to supports encryption.
	VnetEncryptionSupported *bool `json:"vnetEncryptionSupported,omitempty" azure:"ro"`
}

// InterfaceTapConfiguration - Tap configuration in a Network Interface.
type InterfaceTapConfiguration struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the Virtual Network Tap configuration.
	Properties *InterfaceTapConfigurationPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Sub Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InterfaceTapConfigurationListResult - Response for list tap configurations API service call.
type InterfaceTapConfigurationListResult struct {
	// A list of tap configurations.
	Value []*InterfaceTapConfiguration `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// InterfaceTapConfigurationPropertiesFormat - Properties of Virtual Network Tap configuration.
type InterfaceTapConfigurationPropertiesFormat struct {
	// The reference to the Virtual Network Tap resource.
	VirtualNetworkTap *VirtualNetworkTap `json:"virtualNetworkTap,omitempty"`

	// READ-ONLY; The provisioning state of the network interface tap configuration resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// InterfaceTapConfigurationsClientBeginCreateOrUpdateOptions contains the optional parameters for the InterfaceTapConfigurationsClient.BeginCreateOrUpdate
// method.
type InterfaceTapConfigurationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InterfaceTapConfigurationsClientBeginDeleteOptions contains the optional parameters for the InterfaceTapConfigurationsClient.BeginDelete
// method.
type InterfaceTapConfigurationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InterfaceTapConfigurationsClientGetOptions contains the optional parameters for the InterfaceTapConfigurationsClient.Get
// method.
type InterfaceTapConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// InterfaceTapConfigurationsClientListOptions contains the optional parameters for the InterfaceTapConfigurationsClient.List
// method.
type InterfaceTapConfigurationsClientListOptions struct {
	// placeholder for future optional parameters
}

// InterfacesClientBeginCreateOrUpdateOptions contains the optional parameters for the InterfacesClient.BeginCreateOrUpdate
// method.
type InterfacesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InterfacesClientBeginDeleteOptions contains the optional parameters for the InterfacesClient.BeginDelete method.
type InterfacesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InterfacesClientBeginGetEffectiveRouteTableOptions contains the optional parameters for the InterfacesClient.BeginGetEffectiveRouteTable
// method.
type InterfacesClientBeginGetEffectiveRouteTableOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InterfacesClientBeginListEffectiveNetworkSecurityGroupsOptions contains the optional parameters for the InterfacesClient.BeginListEffectiveNetworkSecurityGroups
// method.
type InterfacesClientBeginListEffectiveNetworkSecurityGroupsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InterfacesClientGetCloudServiceNetworkInterfaceOptions contains the optional parameters for the InterfacesClient.GetCloudServiceNetworkInterface
// method.
type InterfacesClientGetCloudServiceNetworkInterfaceOptions struct {
	// Expands referenced resources.
	Expand *string
}

// InterfacesClientGetOptions contains the optional parameters for the InterfacesClient.Get method.
type InterfacesClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// InterfacesClientGetVirtualMachineScaleSetIPConfigurationOptions contains the optional parameters for the InterfacesClient.GetVirtualMachineScaleSetIPConfiguration
// method.
type InterfacesClientGetVirtualMachineScaleSetIPConfigurationOptions struct {
	// Expands referenced resources.
	Expand *string
}

// InterfacesClientGetVirtualMachineScaleSetNetworkInterfaceOptions contains the optional parameters for the InterfacesClient.GetVirtualMachineScaleSetNetworkInterface
// method.
type InterfacesClientGetVirtualMachineScaleSetNetworkInterfaceOptions struct {
	// Expands referenced resources.
	Expand *string
}

// InterfacesClientListAllOptions contains the optional parameters for the InterfacesClient.ListAll method.
type InterfacesClientListAllOptions struct {
	// placeholder for future optional parameters
}

// InterfacesClientListCloudServiceNetworkInterfacesOptions contains the optional parameters for the InterfacesClient.ListCloudServiceNetworkInterfaces
// method.
type InterfacesClientListCloudServiceNetworkInterfacesOptions struct {
	// placeholder for future optional parameters
}

// InterfacesClientListCloudServiceRoleInstanceNetworkInterfacesOptions contains the optional parameters for the InterfacesClient.ListCloudServiceRoleInstanceNetworkInterfaces
// method.
type InterfacesClientListCloudServiceRoleInstanceNetworkInterfacesOptions struct {
	// placeholder for future optional parameters
}

// InterfacesClientListOptions contains the optional parameters for the InterfacesClient.List method.
type InterfacesClientListOptions struct {
	// placeholder for future optional parameters
}

// InterfacesClientListVirtualMachineScaleSetIPConfigurationsOptions contains the optional parameters for the InterfacesClient.ListVirtualMachineScaleSetIPConfigurations
// method.
type InterfacesClientListVirtualMachineScaleSetIPConfigurationsOptions struct {
	// Expands referenced resources.
	Expand *string
}

// InterfacesClientListVirtualMachineScaleSetNetworkInterfacesOptions contains the optional parameters for the InterfacesClient.ListVirtualMachineScaleSetNetworkInterfaces
// method.
type InterfacesClientListVirtualMachineScaleSetNetworkInterfacesOptions struct {
	// placeholder for future optional parameters
}

// InterfacesClientListVirtualMachineScaleSetVMNetworkInterfacesOptions contains the optional parameters for the InterfacesClient.ListVirtualMachineScaleSetVMNetworkInterfaces
// method.
type InterfacesClientListVirtualMachineScaleSetVMNetworkInterfacesOptions struct {
	// placeholder for future optional parameters
}

// InterfacesClientUpdateTagsOptions contains the optional parameters for the InterfacesClient.UpdateTags method.
type InterfacesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// ListHubRouteTablesResult - List of RouteTables and a URL nextLink to get the next set of results.
type ListHubRouteTablesResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of RouteTables.
	Value []*HubRouteTable `json:"value,omitempty"`
}

// ListHubVirtualNetworkConnectionsResult - List of HubVirtualNetworkConnections and a URL nextLink to get the next set of
// results.
type ListHubVirtualNetworkConnectionsResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of HubVirtualNetworkConnections.
	Value []*HubVirtualNetworkConnection `json:"value,omitempty"`
}

// ListP2SVPNGatewaysResult - Result of the request to list P2SVpnGateways. It contains a list of P2SVpnGateways and a URL
// nextLink to get the next set of results.
type ListP2SVPNGatewaysResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of P2SVpnGateways.
	Value []*P2SVPNGateway `json:"value,omitempty"`
}

// ListRoutingIntentResult - List of the routing intent result and a URL nextLink to get the next set of results.
type ListRoutingIntentResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of RoutingIntent resource.
	Value []*RoutingIntent `json:"value,omitempty"`
}

// ListVPNConnectionsResult - Result of the request to list all vpn connections to a virtual wan vpn gateway. It contains
// a list of Vpn Connections and a URL nextLink to get the next set of results.
type ListVPNConnectionsResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Vpn Connections.
	Value []*VPNConnection `json:"value,omitempty"`
}

// ListVPNGatewayNatRulesResult - Result of the request to list all nat rules to a virtual wan vpn gateway. It contains a
// list of Nat rules and a URL nextLink to get the next set of results.
type ListVPNGatewayNatRulesResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Nat Rules.
	Value []*VPNGatewayNatRule `json:"value,omitempty"`
}

// ListVPNGatewaysResult - Result of the request to list VpnGateways. It contains a list of VpnGateways and a URL nextLink
// to get the next set of results.
type ListVPNGatewaysResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of VpnGateways.
	Value []*VPNGateway `json:"value,omitempty"`
}

// ListVPNServerConfigurationPolicyGroupsResult - Result of the request to list VpnServerConfigurationPolicyGroups. It contains
// a list of VpnServerConfigurationPolicyGroups and a URL nextLink to get the next set of results.
type ListVPNServerConfigurationPolicyGroupsResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of VpnServerConfigurationPolicyGroups.
	Value []*VPNServerConfigurationPolicyGroup `json:"value,omitempty"`
}

// ListVPNServerConfigurationsResult - Result of the request to list all VpnServerConfigurations. It contains a list of VpnServerConfigurations
// and a URL nextLink to get the next set of results.
type ListVPNServerConfigurationsResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of VpnServerConfigurations.
	Value []*VPNServerConfiguration `json:"value,omitempty"`
}

// ListVPNSiteLinkConnectionsResult - Result of the request to list all vpn connections to a virtual wan vpn gateway. It contains
// a list of Vpn Connections and a URL nextLink to get the next set of results.
type ListVPNSiteLinkConnectionsResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of VpnSiteLinkConnections.
	Value []*VPNSiteLinkConnection `json:"value,omitempty"`
}

// ListVPNSiteLinksResult - Result of the request to list VpnSiteLinks. It contains a list of VpnSiteLinks and a URL nextLink
// to get the next set of results.
type ListVPNSiteLinksResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of VpnSitesLinks.
	Value []*VPNSiteLink `json:"value,omitempty"`
}

// ListVPNSitesResult - Result of the request to list VpnSites. It contains a list of VpnSites and a URL nextLink to get the
// next set of results.
type ListVPNSitesResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of VpnSites.
	Value []*VPNSite `json:"value,omitempty"`
}

// ListVirtualHubBgpConnectionResults - VirtualHubBgpConnections list.
type ListVirtualHubBgpConnectionResults struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of VirtualHubBgpConnections.
	Value []*BgpConnection `json:"value,omitempty"`
}

// ListVirtualHubIPConfigurationResults - VirtualHubIpConfigurations list.
type ListVirtualHubIPConfigurationResults struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of VirtualHubIpConfigurations.
	Value []*HubIPConfiguration `json:"value,omitempty"`
}

// ListVirtualHubRouteTableV2SResult - List of VirtualHubRouteTableV2s and a URL nextLink to get the next set of results.
type ListVirtualHubRouteTableV2SResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of VirtualHubRouteTableV2s.
	Value []*VirtualHubRouteTableV2 `json:"value,omitempty"`
}

// ListVirtualHubsResult - Result of the request to list VirtualHubs. It contains a list of VirtualHubs and a URL nextLink
// to get the next set of results.
type ListVirtualHubsResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of VirtualHubs.
	Value []*VirtualHub `json:"value,omitempty"`
}

// ListVirtualNetworkGatewayNatRulesResult - Result of the request to list all nat rules to a virtual network gateway. It
// contains a list of Nat rules and a URL nextLink to get the next set of results.
type ListVirtualNetworkGatewayNatRulesResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Nat Rules.
	Value []*VirtualNetworkGatewayNatRule `json:"value,omitempty"`
}

// ListVirtualWANsResult - Result of the request to list VirtualWANs. It contains a list of VirtualWANs and a URL nextLink
// to get the next set of results.
type ListVirtualWANsResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of VirtualWANs.
	Value []*VirtualWAN `json:"value,omitempty"`
}

// LoadBalancer resource.
type LoadBalancer struct {
	// The extended location of the load balancer.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of load balancer.
	Properties *LoadBalancerPropertiesFormat `json:"properties,omitempty"`

	// The load balancer SKU.
	SKU *LoadBalancerSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LoadBalancerBackendAddress - Load balancer backend addresses.
type LoadBalancerBackendAddress struct {
	// Name of the backend address.
	Name *string `json:"name,omitempty"`

	// Properties of load balancer backend address pool.
	Properties *LoadBalancerBackendAddressPropertiesFormat `json:"properties,omitempty"`
}

// LoadBalancerBackendAddressPoolListResult - Response for ListBackendAddressPool API service call.
type LoadBalancerBackendAddressPoolListResult struct {
	// A list of backend address pools in a load balancer.
	Value []*BackendAddressPool `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// LoadBalancerBackendAddressPoolsClientBeginCreateOrUpdateOptions contains the optional parameters for the LoadBalancerBackendAddressPoolsClient.BeginCreateOrUpdate
// method.
type LoadBalancerBackendAddressPoolsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LoadBalancerBackendAddressPoolsClientBeginDeleteOptions contains the optional parameters for the LoadBalancerBackendAddressPoolsClient.BeginDelete
// method.
type LoadBalancerBackendAddressPoolsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LoadBalancerBackendAddressPoolsClientGetOptions contains the optional parameters for the LoadBalancerBackendAddressPoolsClient.Get
// method.
type LoadBalancerBackendAddressPoolsClientGetOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerBackendAddressPoolsClientListOptions contains the optional parameters for the LoadBalancerBackendAddressPoolsClient.List
// method.
type LoadBalancerBackendAddressPoolsClientListOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerBackendAddressPropertiesFormat - Properties of the load balancer backend addresses.
type LoadBalancerBackendAddressPropertiesFormat struct {
	// A list of administrative states which once set can override health probe so that Load Balancer will always forward new
	// connections to backend, or deny new connections and reset existing connections.
	AdminState *LoadBalancerBackendAddressAdminState `json:"adminState,omitempty"`

	// IP Address belonging to the referenced virtual network.
	IPAddress *string `json:"ipAddress,omitempty"`

	// Reference to the frontend ip address configuration defined in regional loadbalancer.
	LoadBalancerFrontendIPConfiguration *SubResource `json:"loadBalancerFrontendIPConfiguration,omitempty"`

	// Reference to an existing subnet.
	Subnet *SubResource `json:"subnet,omitempty"`

	// Reference to an existing virtual network.
	VirtualNetwork *SubResource `json:"virtualNetwork,omitempty"`

	// READ-ONLY; Collection of inbound NAT rule port mappings.
	InboundNatRulesPortMapping []*NatRulePortMapping `json:"inboundNatRulesPortMapping,omitempty" azure:"ro"`

	// READ-ONLY; Reference to IP address defined in network interfaces.
	NetworkInterfaceIPConfiguration *SubResource `json:"networkInterfaceIPConfiguration,omitempty" azure:"ro"`
}

// LoadBalancerFrontendIPConfigurationListResult - Response for ListFrontendIPConfiguration API service call.
type LoadBalancerFrontendIPConfigurationListResult struct {
	// A list of frontend IP configurations in a load balancer.
	Value []*FrontendIPConfiguration `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// LoadBalancerFrontendIPConfigurationsClientGetOptions contains the optional parameters for the LoadBalancerFrontendIPConfigurationsClient.Get
// method.
type LoadBalancerFrontendIPConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerFrontendIPConfigurationsClientListOptions contains the optional parameters for the LoadBalancerFrontendIPConfigurationsClient.List
// method.
type LoadBalancerFrontendIPConfigurationsClientListOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerListResult - Response for ListLoadBalancers API service call.
type LoadBalancerListResult struct {
	// A list of load balancers in a resource group.
	Value []*LoadBalancer `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// LoadBalancerLoadBalancingRuleListResult - Response for ListLoadBalancingRule API service call.
type LoadBalancerLoadBalancingRuleListResult struct {
	// A list of load balancing rules in a load balancer.
	Value []*LoadBalancingRule `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// LoadBalancerLoadBalancingRulesClientGetOptions contains the optional parameters for the LoadBalancerLoadBalancingRulesClient.Get
// method.
type LoadBalancerLoadBalancingRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerLoadBalancingRulesClientListOptions contains the optional parameters for the LoadBalancerLoadBalancingRulesClient.List
// method.
type LoadBalancerLoadBalancingRulesClientListOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerNetworkInterfacesClientListOptions contains the optional parameters for the LoadBalancerNetworkInterfacesClient.List
// method.
type LoadBalancerNetworkInterfacesClientListOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerOutboundRuleListResult - Response for ListOutboundRule API service call.
type LoadBalancerOutboundRuleListResult struct {
	// A list of outbound rules in a load balancer.
	Value []*OutboundRule `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// LoadBalancerOutboundRulesClientGetOptions contains the optional parameters for the LoadBalancerOutboundRulesClient.Get
// method.
type LoadBalancerOutboundRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerOutboundRulesClientListOptions contains the optional parameters for the LoadBalancerOutboundRulesClient.List
// method.
type LoadBalancerOutboundRulesClientListOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerProbeListResult - Response for ListProbe API service call.
type LoadBalancerProbeListResult struct {
	// A list of probes in a load balancer.
	Value []*Probe `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// LoadBalancerProbesClientGetOptions contains the optional parameters for the LoadBalancerProbesClient.Get method.
type LoadBalancerProbesClientGetOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerProbesClientListOptions contains the optional parameters for the LoadBalancerProbesClient.List method.
type LoadBalancerProbesClientListOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerPropertiesFormat - Properties of the load balancer.
type LoadBalancerPropertiesFormat struct {
	// Collection of backend address pools used by a load balancer.
	BackendAddressPools []*BackendAddressPool `json:"backendAddressPools,omitempty"`

	// Object representing the frontend IPs to be used for the load balancer.
	FrontendIPConfigurations []*FrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`

	// Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound
	// NAT rules are created automatically for each NIC associated with the Load
	// Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive
	// with defining inbound NAT rules. Inbound NAT pools are referenced from virtual
	// machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They
	// have to reference individual inbound NAT rules.
	InboundNatPools []*InboundNatPool `json:"inboundNatPools,omitempty"`

	// Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive
	// with defining an inbound NAT pool. Inbound NAT pools are referenced from
	// virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool.
	// They have to reference individual inbound NAT rules.
	InboundNatRules []*InboundNatRule `json:"inboundNatRules,omitempty"`

	// Object collection representing the load balancing rules Gets the provisioning.
	LoadBalancingRules []*LoadBalancingRule `json:"loadBalancingRules,omitempty"`

	// The outbound rules.
	OutboundRules []*OutboundRule `json:"outboundRules,omitempty"`

	// Collection of probe objects used in the load balancer.
	Probes []*Probe `json:"probes,omitempty"`

	// READ-ONLY; The provisioning state of the load balancer resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the load balancer resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`
}

// LoadBalancerSKU - SKU of a load balancer.
type LoadBalancerSKU struct {
	// Name of a load balancer SKU.
	Name *LoadBalancerSKUName `json:"name,omitempty"`

	// Tier of a load balancer SKU.
	Tier *LoadBalancerSKUTier `json:"tier,omitempty"`
}

// LoadBalancerVipSwapRequest - The request for a VIP swap.
type LoadBalancerVipSwapRequest struct {
	// A list of frontend IP configuration resources that should swap VIPs.
	FrontendIPConfigurations []*LoadBalancerVipSwapRequestFrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`
}

// LoadBalancerVipSwapRequestFrontendIPConfiguration - VIP swap request's frontend IP configuration object.
type LoadBalancerVipSwapRequestFrontendIPConfiguration struct {
	// The ID of frontend IP configuration resource.
	ID *string `json:"id,omitempty"`

	// The properties of VIP swap request's frontend IP configuration object.
	Properties *LoadBalancerVipSwapRequestFrontendIPConfigurationProperties `json:"properties,omitempty"`
}

// LoadBalancerVipSwapRequestFrontendIPConfigurationProperties - The properties of VIP swap request's frontend IP configuration
// object.
type LoadBalancerVipSwapRequestFrontendIPConfigurationProperties struct {
	// A reference to public IP address resource.
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`
}

// LoadBalancersClientBeginCreateOrUpdateOptions contains the optional parameters for the LoadBalancersClient.BeginCreateOrUpdate
// method.
type LoadBalancersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LoadBalancersClientBeginDeleteOptions contains the optional parameters for the LoadBalancersClient.BeginDelete method.
type LoadBalancersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LoadBalancersClientBeginListInboundNatRulePortMappingsOptions contains the optional parameters for the LoadBalancersClient.BeginListInboundNatRulePortMappings
// method.
type LoadBalancersClientBeginListInboundNatRulePortMappingsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LoadBalancersClientBeginSwapPublicIPAddressesOptions contains the optional parameters for the LoadBalancersClient.BeginSwapPublicIPAddresses
// method.
type LoadBalancersClientBeginSwapPublicIPAddressesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LoadBalancersClientGetOptions contains the optional parameters for the LoadBalancersClient.Get method.
type LoadBalancersClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// LoadBalancersClientListAllOptions contains the optional parameters for the LoadBalancersClient.ListAll method.
type LoadBalancersClientListAllOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancersClientListOptions contains the optional parameters for the LoadBalancersClient.List method.
type LoadBalancersClientListOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancersClientUpdateTagsOptions contains the optional parameters for the LoadBalancersClient.UpdateTags method.
type LoadBalancersClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancingRule - A load balancing rule for a load balancer.
type LoadBalancingRule struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within the set of load balancing rules used by the load balancer. This name can
	// be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of load balancer load balancing rule.
	Properties *LoadBalancingRulePropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LoadBalancingRulePropertiesFormat - Properties of the load balancer.
type LoadBalancingRulePropertiesFormat struct {
	// REQUIRED; The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable
	// values are between 0 and 65534. Note that value 0 enables "Any Port".
	FrontendPort *int32 `json:"frontendPort,omitempty"`

	// REQUIRED; The reference to the transport protocol used by the load balancing rule.
	Protocol *TransportProtocol `json:"protocol,omitempty"`

	// A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`

	// An array of references to pool of DIPs.
	BackendAddressPools []*SubResource `json:"backendAddressPools,omitempty"`

	// The port used for internal connections on the endpoint. Acceptable values are between 0 and 65535. Note that value 0 enables
	// "Any Port".
	BackendPort *int32 `json:"backendPort,omitempty"`

	// Configures SNAT for the VMs in the backend pool to use the publicIP address specified in the frontend of the load balancing
	// rule.
	DisableOutboundSnat *bool `json:"disableOutboundSnat,omitempty"`

	// Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability
	// Group. This setting is required when using the SQL AlwaysOn Availability Groups
	// in SQL server. This setting can't be changed after you create the endpoint.
	EnableFloatingIP *bool `json:"enableFloatingIP,omitempty"`

	// Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used
	// when the protocol is set to TCP.
	EnableTCPReset *bool `json:"enableTcpReset,omitempty"`

	// A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`

	// The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes.
	// This element is only used when the protocol is set to TCP.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// The load distribution policy for this rule.
	LoadDistribution *LoadDistribution `json:"loadDistribution,omitempty"`

	// The reference to the load balancer probe used by the load balancing rule.
	Probe *SubResource `json:"probe,omitempty"`

	// READ-ONLY; The provisioning state of the load balancing rule resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// LocalNetworkGateway - A common class for general resource information.
type LocalNetworkGateway struct {
	// REQUIRED; Properties of the local network gateway.
	Properties *LocalNetworkGatewayPropertiesFormat `json:"properties,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LocalNetworkGatewayListResult - Response for ListLocalNetworkGateways API service call.
type LocalNetworkGatewayListResult struct {
	// A list of local network gateways that exists in a resource group.
	Value []*LocalNetworkGateway `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// LocalNetworkGatewayPropertiesFormat - LocalNetworkGateway properties.
type LocalNetworkGatewayPropertiesFormat struct {
	// Local network gateway's BGP speaker settings.
	BgpSettings *BgpSettings `json:"bgpSettings,omitempty"`

	// FQDN of local network gateway.
	Fqdn *string `json:"fqdn,omitempty"`

	// IP address of local network gateway.
	GatewayIPAddress *string `json:"gatewayIpAddress,omitempty"`

	// Local network site address space.
	LocalNetworkAddressSpace *AddressSpace `json:"localNetworkAddressSpace,omitempty"`

	// READ-ONLY; The provisioning state of the local network gateway resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the local network gateway resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`
}

// LocalNetworkGatewaysClientBeginCreateOrUpdateOptions contains the optional parameters for the LocalNetworkGatewaysClient.BeginCreateOrUpdate
// method.
type LocalNetworkGatewaysClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LocalNetworkGatewaysClientBeginDeleteOptions contains the optional parameters for the LocalNetworkGatewaysClient.BeginDelete
// method.
type LocalNetworkGatewaysClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LocalNetworkGatewaysClientGetOptions contains the optional parameters for the LocalNetworkGatewaysClient.Get method.
type LocalNetworkGatewaysClientGetOptions struct {
	// placeholder for future optional parameters
}

// LocalNetworkGatewaysClientListOptions contains the optional parameters for the LocalNetworkGatewaysClient.List method.
type LocalNetworkGatewaysClientListOptions struct {
	// placeholder for future optional parameters
}

// LocalNetworkGatewaysClientUpdateTagsOptions contains the optional parameters for the LocalNetworkGatewaysClient.UpdateTags
// method.
type LocalNetworkGatewaysClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// LogSpecification - Description of logging specification.
type LogSpecification struct {
	// Duration of the blob.
	BlobDuration *string `json:"blobDuration,omitempty"`

	// The display name of the specification.
	DisplayName *string `json:"displayName,omitempty"`

	// The name of the specification.
	Name *string `json:"name,omitempty"`
}

// ManagedRuleGroupOverride - Defines a managed rule group override setting.
type ManagedRuleGroupOverride struct {
	// REQUIRED; The managed rule group to override.
	RuleGroupName *string `json:"ruleGroupName,omitempty"`

	// List of rules that will be disabled. If none specified, all rules in the group will be disabled.
	Rules []*ManagedRuleOverride `json:"rules,omitempty"`
}

// ManagedRuleOverride - Defines a managed rule group override setting.
type ManagedRuleOverride struct {
	// REQUIRED; Identifier for the managed rule.
	RuleID *string `json:"ruleId,omitempty"`

	// The state of the managed rule. Defaults to Disabled if not specified.
	State *ManagedRuleEnabledState `json:"state,omitempty"`
}

// ManagedRuleSet - Defines a managed rule set.
type ManagedRuleSet struct {
	// REQUIRED; Defines the rule set type to use.
	RuleSetType *string `json:"ruleSetType,omitempty"`

	// REQUIRED; Defines the version of the rule set to use.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty"`

	// Defines the rule group overrides to apply to the rule set.
	RuleGroupOverrides []*ManagedRuleGroupOverride `json:"ruleGroupOverrides,omitempty"`
}

// ManagedRulesDefinition - Allow to exclude some variable satisfy the condition for the WAF check.
type ManagedRulesDefinition struct {
	// REQUIRED; The managed rule sets that are associated with the policy.
	ManagedRuleSets []*ManagedRuleSet `json:"managedRuleSets,omitempty"`

	// The Exclusions that are applied on the policy.
	Exclusions []*OwaspCrsExclusionEntry `json:"exclusions,omitempty"`
}

// ManagedServiceIdentity - Identity for the resource.
type ManagedServiceIdentity struct {
	// The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created
	// identity and a set of user assigned identities. The type 'None' will remove any
	// identities from the virtual machine.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The list of user identities associated with resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal id of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant id of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ManagementClientBeginDeleteBastionShareableLinkOptions contains the optional parameters for the ManagementClient.BeginDeleteBastionShareableLink
// method.
type ManagementClientBeginDeleteBastionShareableLinkOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagementClientBeginGeneratevirtualwanvpnserverconfigurationvpnprofileOptions contains the optional parameters for the
// ManagementClient.BeginGeneratevirtualwanvpnserverconfigurationvpnprofile method.
type ManagementClientBeginGeneratevirtualwanvpnserverconfigurationvpnprofileOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagementClientBeginGetActiveSessionsOptions contains the optional parameters for the ManagementClient.BeginGetActiveSessions
// method.
type ManagementClientBeginGetActiveSessionsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagementClientBeginPutBastionShareableLinkOptions contains the optional parameters for the ManagementClient.BeginPutBastionShareableLink
// method.
type ManagementClientBeginPutBastionShareableLinkOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagementClientCheckDNSNameAvailabilityOptions contains the optional parameters for the ManagementClient.CheckDNSNameAvailability
// method.
type ManagementClientCheckDNSNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ManagementClientDisconnectActiveSessionsOptions contains the optional parameters for the ManagementClient.DisconnectActiveSessions
// method.
type ManagementClientDisconnectActiveSessionsOptions struct {
	// placeholder for future optional parameters
}

// ManagementClientExpressRouteProviderPortOptions contains the optional parameters for the ManagementClient.ExpressRouteProviderPort
// method.
type ManagementClientExpressRouteProviderPortOptions struct {
	// placeholder for future optional parameters
}

// ManagementClientGetBastionShareableLinkOptions contains the optional parameters for the ManagementClient.GetBastionShareableLink
// method.
type ManagementClientGetBastionShareableLinkOptions struct {
	// placeholder for future optional parameters
}

// ManagementClientListActiveConnectivityConfigurationsOptions contains the optional parameters for the ManagementClient.ListActiveConnectivityConfigurations
// method.
type ManagementClientListActiveConnectivityConfigurationsOptions struct {
	// placeholder for future optional parameters
}

// ManagementClientListActiveSecurityAdminRulesOptions contains the optional parameters for the ManagementClient.ListActiveSecurityAdminRules
// method.
type ManagementClientListActiveSecurityAdminRulesOptions struct {
	// placeholder for future optional parameters
}

// ManagementClientListNetworkManagerEffectiveConnectivityConfigurationsOptions contains the optional parameters for the ManagementClient.ListNetworkManagerEffectiveConnectivityConfigurations
// method.
type ManagementClientListNetworkManagerEffectiveConnectivityConfigurationsOptions struct {
	// placeholder for future optional parameters
}

// ManagementClientListNetworkManagerEffectiveSecurityAdminRulesOptions contains the optional parameters for the ManagementClient.ListNetworkManagerEffectiveSecurityAdminRules
// method.
type ManagementClientListNetworkManagerEffectiveSecurityAdminRulesOptions struct {
	// placeholder for future optional parameters
}

// ManagementClientSupportedSecurityProvidersOptions contains the optional parameters for the ManagementClient.SupportedSecurityProviders
// method.
type ManagementClientSupportedSecurityProvidersOptions struct {
	// placeholder for future optional parameters
}

// ManagementGroupNetworkManagerConnectionsClientCreateOrUpdateOptions contains the optional parameters for the ManagementGroupNetworkManagerConnectionsClient.CreateOrUpdate
// method.
type ManagementGroupNetworkManagerConnectionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ManagementGroupNetworkManagerConnectionsClientDeleteOptions contains the optional parameters for the ManagementGroupNetworkManagerConnectionsClient.Delete
// method.
type ManagementGroupNetworkManagerConnectionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ManagementGroupNetworkManagerConnectionsClientGetOptions contains the optional parameters for the ManagementGroupNetworkManagerConnectionsClient.Get
// method.
type ManagementGroupNetworkManagerConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagementGroupNetworkManagerConnectionsClientListOptions contains the optional parameters for the ManagementGroupNetworkManagerConnectionsClient.List
// method.
type ManagementGroupNetworkManagerConnectionsClientListOptions struct {
	// SkipToken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skipToken parameter that
	// specifies a starting point to use for subsequent calls.
	SkipToken *string
	// An optional query parameter which specifies the maximum number of records to be returned by the server.
	Top *int32
}

// Manager - The Managed Network resource
type Manager struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// The network manager properties
	Properties *ManagerProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagerCommit - Network Manager Commit.
type ManagerCommit struct {
	// REQUIRED; Commit Type.
	CommitType *ConfigurationType `json:"commitType,omitempty"`

	// REQUIRED; List of target locations.
	TargetLocations []*string `json:"targetLocations,omitempty"`

	// List of configuration ids.
	ConfigurationIDs []*string `json:"configurationIds,omitempty"`

	// READ-ONLY; Commit Id.
	CommitID *string `json:"commitId,omitempty" azure:"ro"`
}

// ManagerCommitsClientBeginPostOptions contains the optional parameters for the ManagerCommitsClient.BeginPost method.
type ManagerCommitsClientBeginPostOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagerConnection - The Network Manager Connection resource
type ManagerConnection struct {
	// The scope connection properties
	Properties *ManagerConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagerConnectionListResult - List of network manager connections.
type ManagerConnectionListResult struct {
	// Gets the URL to get the next page of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of network manager connections.
	Value []*ManagerConnection `json:"value,omitempty"`
}

// ManagerConnectionProperties - Information about the network manager connection.
type ManagerConnectionProperties struct {
	// A description of the network manager connection.
	Description *string `json:"description,omitempty"`

	// Network Manager Id.
	NetworkManagerID *string `json:"networkManagerId,omitempty"`

	// READ-ONLY; Connection state.
	ConnectionState *ScopeConnectionState `json:"connectionState,omitempty" azure:"ro"`
}

// ManagerDeploymentStatus - Network Manager Deployment Status.
type ManagerDeploymentStatus struct {
	// Commit Time.
	CommitTime *time.Time `json:"commitTime,omitempty"`

	// List of configuration ids.
	ConfigurationIDs []*string `json:"configurationIds,omitempty"`

	// Deployment Status.
	DeploymentStatus *DeploymentStatus `json:"deploymentStatus,omitempty"`

	// Configuration Deployment Type.
	DeploymentType *ConfigurationType `json:"deploymentType,omitempty"`

	// Error Message.
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// Region Name.
	Region *string `json:"region,omitempty"`
}

// ManagerDeploymentStatusClientListOptions contains the optional parameters for the ManagerDeploymentStatusClient.List method.
type ManagerDeploymentStatusClientListOptions struct {
	// placeholder for future optional parameters
}

// ManagerDeploymentStatusListResult - A list of Network Manager Deployment Status
type ManagerDeploymentStatusListResult struct {
	// When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current
	// request) to retrieve the next page of data.
	SkipToken *string `json:"skipToken,omitempty"`

	// Gets a page of Network Manager Deployment Status
	Value []*ManagerDeploymentStatus `json:"value,omitempty"`
}

// ManagerDeploymentStatusParameter - Network Manager Deployment Status Parameter.
type ManagerDeploymentStatusParameter struct {
	// List of deployment types.
	DeploymentTypes []*ConfigurationType `json:"deploymentTypes,omitempty"`

	// List of locations.
	Regions []*string `json:"regions,omitempty"`

	// Continuation token for pagination, capturing the next page size and offset, as well as the context of the query.
	SkipToken *string `json:"skipToken,omitempty"`
}

// ManagerEffectiveConnectivityConfigurationListResult - Result of the request to list networkManagerEffectiveConnectivityConfiguration.
// It contains a list of groups and a skiptoken to get the next set of results.
type ManagerEffectiveConnectivityConfigurationListResult struct {
	// When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current
	// request) to retrieve the next page of data.
	SkipToken *string `json:"skipToken,omitempty"`

	// Gets a page of NetworkManagerEffectiveConnectivityConfiguration
	Value []*EffectiveConnectivityConfiguration `json:"value,omitempty"`
}

// ManagerEffectiveSecurityAdminRulesListResult - Result of the request to list networkManagerEffectiveSecurityAdminRules.
// It contains a list of groups and a skiptoken to get the next set of results.
type ManagerEffectiveSecurityAdminRulesListResult struct {
	// When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current
	// request) to retrieve the next page of data.
	SkipToken *string `json:"skipToken,omitempty"`

	// Gets a page of NetworkManagerEffectiveSecurityAdminRules
	Value []EffectiveBaseSecurityAdminRuleClassification `json:"value,omitempty"`
}

// ManagerListResult - Result of the request to list NetworkManager. It contains a list of network managers and a URL link
// to get the next set of results.
type ManagerListResult struct {
	// Gets the URL to get the next page of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets a page of NetworkManager
	Value []*Manager `json:"value,omitempty"`
}

// ManagerProperties - Properties of Managed Network
type ManagerProperties struct {
	// REQUIRED; Scope Access.
	NetworkManagerScopeAccesses []*ConfigurationType `json:"networkManagerScopeAccesses,omitempty"`

	// REQUIRED; Scope of Network Manager.
	NetworkManagerScopes *ManagerPropertiesNetworkManagerScopes `json:"networkManagerScopes,omitempty"`

	// A description of the network manager.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; The provisioning state of the network manager resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ManagerPropertiesNetworkManagerScopes - Scope of Network Manager.
type ManagerPropertiesNetworkManagerScopes struct {
	// List of management groups.
	ManagementGroups []*string `json:"managementGroups,omitempty"`

	// List of subscriptions.
	Subscriptions []*string `json:"subscriptions,omitempty"`

	// READ-ONLY; List of cross tenant scopes.
	CrossTenantScopes []*CrossTenantScopes `json:"crossTenantScopes,omitempty" azure:"ro"`
}

// ManagerSecurityGroupItem - Network manager security group item.
type ManagerSecurityGroupItem struct {
	// REQUIRED; Network manager group Id.
	NetworkGroupID *string `json:"networkGroupId,omitempty"`
}

// ManagersClientBeginDeleteOptions contains the optional parameters for the ManagersClient.BeginDelete method.
type ManagersClientBeginDeleteOptions struct {
	// Deletes the resource even if it is part of a deployed configuration. If the configuration has been deployed, the service
	// will do a cleanup deployment in the background, prior to the delete.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagersClientCreateOrUpdateOptions contains the optional parameters for the ManagersClient.CreateOrUpdate method.
type ManagersClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientGetOptions contains the optional parameters for the ManagersClient.Get method.
type ManagersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagersClientListBySubscriptionOptions contains the optional parameters for the ManagersClient.ListBySubscription method.
type ManagersClientListBySubscriptionOptions struct {
	// SkipToken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skipToken parameter that
	// specifies a starting point to use for subsequent calls.
	SkipToken *string
	// An optional query parameter which specifies the maximum number of records to be returned by the server.
	Top *int32
}

// ManagersClientListOptions contains the optional parameters for the ManagersClient.List method.
type ManagersClientListOptions struct {
	// SkipToken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skipToken parameter that
	// specifies a starting point to use for subsequent calls.
	SkipToken *string
	// An optional query parameter which specifies the maximum number of records to be returned by the server.
	Top *int32
}

// ManagersClientPatchOptions contains the optional parameters for the ManagersClient.Patch method.
type ManagersClientPatchOptions struct {
	// placeholder for future optional parameters
}

// MatchCondition - Define match conditions.
type MatchCondition struct {
	// REQUIRED; Match value.
	MatchValues []*string `json:"matchValues,omitempty"`

	// REQUIRED; List of match variables.
	MatchVariables []*MatchVariable `json:"matchVariables,omitempty"`

	// REQUIRED; The operator to be matched.
	Operator *WebApplicationFirewallOperator `json:"operator,omitempty"`

	// Whether this is negate condition or not.
	NegationConditon *bool `json:"negationConditon,omitempty"`

	// List of transforms.
	Transforms []*WebApplicationFirewallTransform `json:"transforms,omitempty"`
}

// MatchVariable - Define match variables.
type MatchVariable struct {
	// REQUIRED; Match Variable.
	VariableName *WebApplicationFirewallMatchVariable `json:"variableName,omitempty"`

	// The selector of match variable.
	Selector *string `json:"selector,omitempty"`
}

// MatchedRule - Matched rule.
type MatchedRule struct {
	// The network traffic is allowed or denied. Possible values are 'Allow' and 'Deny'.
	Action *string `json:"action,omitempty"`

	// Name of the matched network security rule.
	RuleName *string `json:"ruleName,omitempty"`
}

// MetricSpecification - Description of metrics specification.
type MetricSpecification struct {
	// The aggregation type.
	AggregationType *string `json:"aggregationType,omitempty"`

	// List of availability.
	Availabilities []*Availability `json:"availabilities,omitempty"`

	// List of dimensions.
	Dimensions []*Dimension `json:"dimensions,omitempty"`

	// The description of the metric.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// The display name of the metric.
	DisplayName *string `json:"displayName,omitempty"`

	// Whether regional MDM account enabled.
	EnableRegionalMdmAccount *bool `json:"enableRegionalMdmAccount,omitempty"`

	// Whether gaps would be filled with zeros.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`

	// Whether the metric is internal.
	IsInternal *bool `json:"isInternal,omitempty"`

	// Pattern for the filter of the metric.
	MetricFilterPattern *string `json:"metricFilterPattern,omitempty"`

	// The name of the metric.
	Name *string `json:"name,omitempty"`

	// The resource Id dimension name override.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`

	// The source MDM account.
	SourceMdmAccount *string `json:"sourceMdmAccount,omitempty"`

	// The source MDM namespace.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`

	// Units the metric to be displayed in.
	Unit *string `json:"unit,omitempty"`
}

// NatGateway - Nat Gateway resource.
type NatGateway struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Nat Gateway properties.
	Properties *NatGatewayPropertiesFormat `json:"properties,omitempty"`

	// The nat gateway SKU.
	SKU *NatGatewaySKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// A list of availability zones denoting the zone in which Nat Gateway should be deployed.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NatGatewayListResult - Response for ListNatGateways API service call.
type NatGatewayListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of Nat Gateways that exists in a resource group.
	Value []*NatGateway `json:"value,omitempty"`
}

// NatGatewayPropertiesFormat - Nat Gateway properties.
type NatGatewayPropertiesFormat struct {
	// The idle timeout of the nat gateway.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// An array of public ip addresses associated with the nat gateway resource.
	PublicIPAddresses []*SubResource `json:"publicIpAddresses,omitempty"`

	// An array of public ip prefixes associated with the nat gateway resource.
	PublicIPPrefixes []*SubResource `json:"publicIpPrefixes,omitempty"`

	// READ-ONLY; The provisioning state of the NAT gateway resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the NAT gateway resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`

	// READ-ONLY; An array of references to the subnets using this nat gateway resource.
	Subnets []*SubResource `json:"subnets,omitempty" azure:"ro"`
}

// NatGatewaySKU - SKU of nat gateway.
type NatGatewaySKU struct {
	// Name of Nat Gateway SKU.
	Name *NatGatewaySKUName `json:"name,omitempty"`
}

// NatGatewaysClientBeginCreateOrUpdateOptions contains the optional parameters for the NatGatewaysClient.BeginCreateOrUpdate
// method.
type NatGatewaysClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NatGatewaysClientBeginDeleteOptions contains the optional parameters for the NatGatewaysClient.BeginDelete method.
type NatGatewaysClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NatGatewaysClientGetOptions contains the optional parameters for the NatGatewaysClient.Get method.
type NatGatewaysClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// NatGatewaysClientListAllOptions contains the optional parameters for the NatGatewaysClient.ListAll method.
type NatGatewaysClientListAllOptions struct {
	// placeholder for future optional parameters
}

// NatGatewaysClientListOptions contains the optional parameters for the NatGatewaysClient.List method.
type NatGatewaysClientListOptions struct {
	// placeholder for future optional parameters
}

// NatGatewaysClientUpdateTagsOptions contains the optional parameters for the NatGatewaysClient.UpdateTags method.
type NatGatewaysClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// NatRule - Rule of type nat.
type NatRule struct {
	// REQUIRED; Rule Type.
	RuleType *FirewallPolicyRuleType `json:"ruleType,omitempty"`

	// Description of the rule.
	Description *string `json:"description,omitempty"`

	// List of destination IP addresses or Service Tags.
	DestinationAddresses []*string `json:"destinationAddresses,omitempty"`

	// List of destination ports.
	DestinationPorts []*string `json:"destinationPorts,omitempty"`

	// Array of FirewallPolicyRuleNetworkProtocols.
	IPProtocols []*FirewallPolicyRuleNetworkProtocol `json:"ipProtocols,omitempty"`

	// Name of the rule.
	Name *string `json:"name,omitempty"`

	// List of source IP addresses for this rule.
	SourceAddresses []*string `json:"sourceAddresses,omitempty"`

	// List of source IpGroups for this rule.
	SourceIPGroups []*string `json:"sourceIpGroups,omitempty"`

	// The translated address for this NAT rule.
	TranslatedAddress *string `json:"translatedAddress,omitempty"`

	// The translated FQDN for this NAT rule.
	TranslatedFqdn *string `json:"translatedFqdn,omitempty"`

	// The translated port for this NAT rule.
	TranslatedPort *string `json:"translatedPort,omitempty"`
}

// GetFirewallPolicyRule implements the FirewallPolicyRuleClassification interface for type NatRule.
func (n *NatRule) GetFirewallPolicyRule() *FirewallPolicyRule {
	return &FirewallPolicyRule{
		Name:        n.Name,
		Description: n.Description,
		RuleType:    n.RuleType,
	}
}

// NatRulePortMapping - Individual port mappings for inbound NAT rule created for backend pool.
type NatRulePortMapping struct {
	// Backend port.
	BackendPort *int32 `json:"backendPort,omitempty"`

	// Frontend port.
	FrontendPort *int32 `json:"frontendPort,omitempty"`

	// Name of inbound NAT rule.
	InboundNatRuleName *string `json:"inboundNatRuleName,omitempty"`
}

// NatRulesClientBeginCreateOrUpdateOptions contains the optional parameters for the NatRulesClient.BeginCreateOrUpdate method.
type NatRulesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NatRulesClientBeginDeleteOptions contains the optional parameters for the NatRulesClient.BeginDelete method.
type NatRulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NatRulesClientGetOptions contains the optional parameters for the NatRulesClient.Get method.
type NatRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// NatRulesClientListByVPNGatewayOptions contains the optional parameters for the NatRulesClient.ListByVPNGateway method.
type NatRulesClientListByVPNGatewayOptions struct {
	// placeholder for future optional parameters
}

// NextHopParameters - Parameters that define the source and destination endpoint.
type NextHopParameters struct {
	// REQUIRED; The destination IP address.
	DestinationIPAddress *string `json:"destinationIPAddress,omitempty"`

	// REQUIRED; The source IP address.
	SourceIPAddress *string `json:"sourceIPAddress,omitempty"`

	// REQUIRED; The resource identifier of the target resource against which the action is to be performed.
	TargetResourceID *string `json:"targetResourceId,omitempty"`

	// The NIC ID. (If VM has multiple NICs and IP forwarding is enabled on any of the nics, then this parameter must be specified.
	// Otherwise optional).
	TargetNicResourceID *string `json:"targetNicResourceId,omitempty"`
}

// NextHopResult - The information about next hop from the specified VM.
type NextHopResult struct {
	// Next hop IP Address.
	NextHopIPAddress *string `json:"nextHopIpAddress,omitempty"`

	// Next hop type.
	NextHopType *NextHopType `json:"nextHopType,omitempty"`

	// The resource identifier for the route table associated with the route being returned. If the route being returned does
	// not correspond to any user created routes then this field will be the string
	// 'System Route'.
	RouteTableID *string `json:"routeTableId,omitempty"`
}

// O365BreakOutCategoryPolicies - Office365 breakout categories.
type O365BreakOutCategoryPolicies struct {
	// Flag to control allow category.
	Allow *bool `json:"allow,omitempty"`

	// Flag to control default category.
	Default *bool `json:"default,omitempty"`

	// Flag to control optimize category.
	Optimize *bool `json:"optimize,omitempty"`
}

// O365PolicyProperties - The Office365 breakout policy.
type O365PolicyProperties struct {
	// Office365 breakout categories.
	BreakOutCategories *O365BreakOutCategoryPolicies `json:"breakOutCategories,omitempty"`
}

// Office365PolicyProperties - Network Virtual Appliance Sku Properties.
type Office365PolicyProperties struct {
	// Office 365 breakout categories.
	BreakOutCategories *BreakOutCategoryPolicies `json:"breakOutCategories,omitempty"`
}

// Operation - Network REST API operation definition.
type Operation struct {
	// Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`

	// Origin of the operation.
	Origin *string `json:"origin,omitempty"`

	// Operation properties format.
	Properties *OperationPropertiesFormat `json:"properties,omitempty"`
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// Description of the operation.
	Description *string `json:"description,omitempty"`

	// Type of the operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft Network.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list Network operations. It contains a list of operations and a URL link
// to get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Network operations supported by the Network resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationPropertiesFormat - Description of operation properties format.
type OperationPropertiesFormat struct {
	// Specification of the service.
	ServiceSpecification *OperationPropertiesFormatServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationPropertiesFormatServiceSpecification - Specification of the service.
type OperationPropertiesFormatServiceSpecification struct {
	// Operation log specification.
	LogSpecifications []*LogSpecification `json:"logSpecifications,omitempty"`

	// Operation service specification.
	MetricSpecifications []*MetricSpecification `json:"metricSpecifications,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OrderBy - Describes a column to sort
type OrderBy struct {
	// Describes the actual column name to sort by
	Field *string `json:"field,omitempty"`

	// Describes if results should be in ascending/descending order
	Order *FirewallPolicyIDPSQuerySortOrder `json:"order,omitempty"`
}

// OutboundRule - Outbound rule of the load balancer.
type OutboundRule struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within the set of outbound rules used by the load balancer. This name can be used
	// to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of load balancer outbound rule.
	Properties *OutboundRulePropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OutboundRulePropertiesFormat - Outbound rule of the load balancer.
type OutboundRulePropertiesFormat struct {
	// REQUIRED; A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`

	// REQUIRED; The Frontend IP addresses of the load balancer.
	FrontendIPConfigurations []*SubResource `json:"frontendIPConfigurations,omitempty"`

	// REQUIRED; The protocol for the outbound rule in load balancer.
	Protocol *LoadBalancerOutboundRuleProtocol `json:"protocol,omitempty"`

	// The number of outbound ports to be used for NAT.
	AllocatedOutboundPorts *int32 `json:"allocatedOutboundPorts,omitempty"`

	// Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used
	// when the protocol is set to TCP.
	EnableTCPReset *bool `json:"enableTcpReset,omitempty"`

	// The timeout for the TCP idle connection.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// READ-ONLY; The provisioning state of the outbound rule resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// OwaspCrsExclusionEntry - Allow to exclude some variable satisfy the condition for the WAF check.
type OwaspCrsExclusionEntry struct {
	// REQUIRED; The variable to be excluded.
	MatchVariable *OwaspCrsExclusionEntryMatchVariable `json:"matchVariable,omitempty"`

	// REQUIRED; When matchVariable is a collection, operator used to specify which elements in the collection this exclusion
	// applies to.
	Selector *string `json:"selector,omitempty"`

	// REQUIRED; When matchVariable is a collection, operate on the selector to specify which elements in the collection this
	// exclusion applies to.
	SelectorMatchOperator *OwaspCrsExclusionEntrySelectorMatchOperator `json:"selectorMatchOperator,omitempty"`

	// The managed rule sets that are associated with the exclusion.
	ExclusionManagedRuleSets []*ExclusionManagedRuleSet `json:"exclusionManagedRuleSets,omitempty"`
}

// P2SConnectionConfiguration Resource.
type P2SConnectionConfiguration struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the P2S connection configuration.
	Properties *P2SConnectionConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// P2SConnectionConfigurationProperties - Parameters for P2SConnectionConfiguration.
type P2SConnectionConfigurationProperties struct {
	// Flag indicating whether the enable internet security flag is turned on for the P2S Connections or not.
	EnableInternetSecurity *bool `json:"enableInternetSecurity,omitempty"`

	// The Routing Configuration indicating the associated and propagated route tables on this connection.
	RoutingConfiguration *RoutingConfiguration `json:"routingConfiguration,omitempty"`

	// The reference to the address space resource which represents Address space for P2S VpnClient.
	VPNClientAddressPool *AddressSpace `json:"vpnClientAddressPool,omitempty"`

	// READ-ONLY; List of Configuration Policy Groups that this P2SConnectionConfiguration is attached to.
	ConfigurationPolicyGroupAssociations []*SubResource `json:"configurationPolicyGroupAssociations,omitempty" azure:"ro"`

	// READ-ONLY; List of previous Configuration Policy Groups that this P2SConnectionConfiguration was attached to.
	PreviousConfigurationPolicyGroupAssociations []*VPNServerConfigurationPolicyGroup `json:"previousConfigurationPolicyGroupAssociations,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the P2SConnectionConfiguration resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// P2SVPNConnectionHealth - P2S Vpn connection detailed health written to sas url.
type P2SVPNConnectionHealth struct {
	// Returned sas url of the blob to which the p2s vpn connection detailed health will be written.
	SasURL *string `json:"sasUrl,omitempty"`
}

// P2SVPNConnectionHealthRequest - List of P2S Vpn connection health request.
type P2SVPNConnectionHealthRequest struct {
	// The sas-url to download the P2S Vpn connection health detail.
	OutputBlobSasURL *string `json:"outputBlobSasUrl,omitempty"`

	// The list of p2s vpn user names whose p2s vpn connection detailed health to retrieve for.
	VPNUserNamesFilter []*string `json:"vpnUserNamesFilter,omitempty"`
}

// P2SVPNConnectionRequest - List of p2s vpn connections to be disconnected.
type P2SVPNConnectionRequest struct {
	// List of p2s vpn connection Ids.
	VPNConnectionIDs []*string `json:"vpnConnectionIds,omitempty"`
}

// P2SVPNGateway - P2SVpnGateway Resource.
type P2SVPNGateway struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the P2SVpnGateway.
	Properties *P2SVPNGatewayProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// P2SVPNGatewayProperties - Parameters for P2SVpnGateway.
type P2SVPNGatewayProperties struct {
	// List of all customer specified DNS servers IP addresses.
	CustomDNSServers []*string `json:"customDnsServers,omitempty"`

	// Enable Routing Preference property for the Public IP Interface of the P2SVpnGateway.
	IsRoutingPreferenceInternet *bool `json:"isRoutingPreferenceInternet,omitempty"`

	// List of all p2s connection configurations of the gateway.
	P2SConnectionConfigurations []*P2SConnectionConfiguration `json:"p2SConnectionConfigurations,omitempty"`

	// The scale unit for this p2s vpn gateway.
	VPNGatewayScaleUnit *int32 `json:"vpnGatewayScaleUnit,omitempty"`

	// The VpnServerConfiguration to which the p2sVpnGateway is attached to.
	VPNServerConfiguration *SubResource `json:"vpnServerConfiguration,omitempty"`

	// The VirtualHub to which the gateway belongs.
	VirtualHub *SubResource `json:"virtualHub,omitempty"`

	// READ-ONLY; The provisioning state of the P2S VPN gateway resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; All P2S VPN clients' connection health status.
	VPNClientConnectionHealth *VPNClientConnectionHealth `json:"vpnClientConnectionHealth,omitempty" azure:"ro"`
}

// P2SVPNGatewaysClientBeginCreateOrUpdateOptions contains the optional parameters for the P2SVPNGatewaysClient.BeginCreateOrUpdate
// method.
type P2SVPNGatewaysClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// P2SVPNGatewaysClientBeginDeleteOptions contains the optional parameters for the P2SVPNGatewaysClient.BeginDelete method.
type P2SVPNGatewaysClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// P2SVPNGatewaysClientBeginDisconnectP2SVPNConnectionsOptions contains the optional parameters for the P2SVPNGatewaysClient.BeginDisconnectP2SVPNConnections
// method.
type P2SVPNGatewaysClientBeginDisconnectP2SVPNConnectionsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// P2SVPNGatewaysClientBeginGenerateVPNProfileOptions contains the optional parameters for the P2SVPNGatewaysClient.BeginGenerateVPNProfile
// method.
type P2SVPNGatewaysClientBeginGenerateVPNProfileOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// P2SVPNGatewaysClientBeginGetP2SVPNConnectionHealthDetailedOptions contains the optional parameters for the P2SVPNGatewaysClient.BeginGetP2SVPNConnectionHealthDetailed
// method.
type P2SVPNGatewaysClientBeginGetP2SVPNConnectionHealthDetailedOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// P2SVPNGatewaysClientBeginGetP2SVPNConnectionHealthOptions contains the optional parameters for the P2SVPNGatewaysClient.BeginGetP2SVPNConnectionHealth
// method.
type P2SVPNGatewaysClientBeginGetP2SVPNConnectionHealthOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// P2SVPNGatewaysClientBeginResetOptions contains the optional parameters for the P2SVPNGatewaysClient.BeginReset method.
type P2SVPNGatewaysClientBeginResetOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// P2SVPNGatewaysClientBeginUpdateTagsOptions contains the optional parameters for the P2SVPNGatewaysClient.BeginUpdateTags
// method.
type P2SVPNGatewaysClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// P2SVPNGatewaysClientGetOptions contains the optional parameters for the P2SVPNGatewaysClient.Get method.
type P2SVPNGatewaysClientGetOptions struct {
	// placeholder for future optional parameters
}

// P2SVPNGatewaysClientListByResourceGroupOptions contains the optional parameters for the P2SVPNGatewaysClient.ListByResourceGroup
// method.
type P2SVPNGatewaysClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// P2SVPNGatewaysClientListOptions contains the optional parameters for the P2SVPNGatewaysClient.List method.
type P2SVPNGatewaysClientListOptions struct {
	// placeholder for future optional parameters
}

// P2SVPNProfileParameters - Vpn Client Parameters for package generation.
type P2SVPNProfileParameters struct {
	// VPN client authentication method.
	AuthenticationMethod *AuthenticationMethod `json:"authenticationMethod,omitempty"`
}

// PacketCapture - Parameters that define the create packet capture operation.
type PacketCapture struct {
	// REQUIRED; Properties of the packet capture.
	Properties *PacketCaptureParameters `json:"properties,omitempty"`
}

// PacketCaptureFilter - Filter that is applied to packet capture request. Multiple filters can be applied.
type PacketCaptureFilter struct {
	// Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range.
	// "127.0.0.1;127.0.0.5"? for multiple entries. Multiple ranges not currently
	// supported. Mixing ranges with multiple entries not currently supported. Default = null.
	LocalIPAddress *string `json:"localIPAddress,omitempty"`

	// Local port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple
	// ranges not currently supported. Mixing ranges with multiple entries not
	// currently supported. Default = null.
	LocalPort *string `json:"localPort,omitempty"`

	// Protocol to be filtered on.
	Protocol *PcProtocol `json:"protocol,omitempty"`

	// Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range.
	// "127.0.0.1;127.0.0.5;" for multiple entries. Multiple ranges not currently
	// supported. Mixing ranges with multiple entries not currently supported. Default = null.
	RemoteIPAddress *string `json:"remoteIPAddress,omitempty"`

	// Remote port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries.
	// Multiple ranges not currently supported. Mixing ranges with multiple entries not
	// currently supported. Default = null.
	RemotePort *string `json:"remotePort,omitempty"`
}

// PacketCaptureListResult - List of packet capture sessions.
type PacketCaptureListResult struct {
	// Information about packet capture sessions.
	Value []*PacketCaptureResult `json:"value,omitempty"`
}

// PacketCaptureMachineScope - A list of AzureVMSS instances which can be included or excluded to run packet capture. If both
// included and excluded are empty, then the packet capture will run on all instances of AzureVMSS.
type PacketCaptureMachineScope struct {
	// List of AzureVMSS instances which has to be excluded from the AzureVMSS from running packet capture.
	Exclude []*string `json:"exclude,omitempty"`

	// List of AzureVMSS instances to run packet capture on.
	Include []*string `json:"include,omitempty"`
}

// PacketCaptureParameters - Parameters that define the create packet capture operation.
type PacketCaptureParameters struct {
	// REQUIRED; The storage location for a packet capture session.
	StorageLocation *PacketCaptureStorageLocation `json:"storageLocation,omitempty"`

	// REQUIRED; The ID of the targeted resource, only AzureVM and AzureVMSS as target type are currently supported.
	Target *string `json:"target,omitempty"`

	// Number of bytes captured per packet, the remaining bytes are truncated.
	BytesToCapturePerPacket *int64 `json:"bytesToCapturePerPacket,omitempty"`

	// A list of packet capture filters.
	Filters []*PacketCaptureFilter `json:"filters,omitempty"`

	// A list of AzureVMSS instances which can be included or excluded to run packet capture. If both included and excluded are
	// empty, then the packet capture will run on all instances of AzureVMSS.
	Scope *PacketCaptureMachineScope `json:"scope,omitempty"`

	// Target type of the resource provided.
	TargetType *PacketCaptureTargetType `json:"targetType,omitempty"`

	// Maximum duration of the capture session in seconds.
	TimeLimitInSeconds *int32 `json:"timeLimitInSeconds,omitempty"`

	// Maximum size of the capture output.
	TotalBytesPerSession *int64 `json:"totalBytesPerSession,omitempty"`
}

// PacketCaptureQueryStatusResult - Status of packet capture session.
type PacketCaptureQueryStatusResult struct {
	// The start time of the packet capture session.
	CaptureStartTime *time.Time `json:"captureStartTime,omitempty"`

	// The ID of the packet capture resource.
	ID *string `json:"id,omitempty"`

	// The name of the packet capture resource.
	Name *string `json:"name,omitempty"`

	// List of errors of packet capture session.
	PacketCaptureError []*PcError `json:"packetCaptureError,omitempty"`

	// The status of the packet capture session.
	PacketCaptureStatus *PcStatus `json:"packetCaptureStatus,omitempty"`

	// The reason the current packet capture session was stopped.
	StopReason *string `json:"stopReason,omitempty"`
}

// PacketCaptureResult - Information about packet capture session.
type PacketCaptureResult struct {
	// Properties of the packet capture result.
	Properties *PacketCaptureResultProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; ID of the packet capture operation.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the packet capture session.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// PacketCaptureResultProperties - The properties of a packet capture session.
type PacketCaptureResultProperties struct {
	// REQUIRED; The storage location for a packet capture session.
	StorageLocation *PacketCaptureStorageLocation `json:"storageLocation,omitempty"`

	// REQUIRED; The ID of the targeted resource, only AzureVM and AzureVMSS as target type are currently supported.
	Target *string `json:"target,omitempty"`

	// Number of bytes captured per packet, the remaining bytes are truncated.
	BytesToCapturePerPacket *int64 `json:"bytesToCapturePerPacket,omitempty"`

	// A list of packet capture filters.
	Filters []*PacketCaptureFilter `json:"filters,omitempty"`

	// A list of AzureVMSS instances which can be included or excluded to run packet capture. If both included and excluded are
	// empty, then the packet capture will run on all instances of AzureVMSS.
	Scope *PacketCaptureMachineScope `json:"scope,omitempty"`

	// Target type of the resource provided.
	TargetType *PacketCaptureTargetType `json:"targetType,omitempty"`

	// Maximum duration of the capture session in seconds.
	TimeLimitInSeconds *int32 `json:"timeLimitInSeconds,omitempty"`

	// Maximum size of the capture output.
	TotalBytesPerSession *int64 `json:"totalBytesPerSession,omitempty"`

	// READ-ONLY; The provisioning state of the packet capture session.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PacketCaptureStorageLocation - The storage location for a packet capture session.
type PacketCaptureStorageLocation struct {
	// A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it
	// must start with /var/captures. Required if no storage ID is provided, otherwise
	// optional.
	FilePath *string `json:"filePath,omitempty"`

	// The ID of the storage account to save the packet capture session. Required if no local file path is provided.
	StorageID *string `json:"storageId,omitempty"`

	// The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet
	// capture.
	StoragePath *string `json:"storagePath,omitempty"`
}

// PacketCapturesClientBeginCreateOptions contains the optional parameters for the PacketCapturesClient.BeginCreate method.
type PacketCapturesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PacketCapturesClientBeginDeleteOptions contains the optional parameters for the PacketCapturesClient.BeginDelete method.
type PacketCapturesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PacketCapturesClientBeginGetStatusOptions contains the optional parameters for the PacketCapturesClient.BeginGetStatus
// method.
type PacketCapturesClientBeginGetStatusOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PacketCapturesClientBeginStopOptions contains the optional parameters for the PacketCapturesClient.BeginStop method.
type PacketCapturesClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PacketCapturesClientGetOptions contains the optional parameters for the PacketCapturesClient.Get method.
type PacketCapturesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PacketCapturesClientListOptions contains the optional parameters for the PacketCapturesClient.List method.
type PacketCapturesClientListOptions struct {
	// placeholder for future optional parameters
}

// PatchObject - Object for patch operations.
type PatchObject struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// PatchRouteFilter - Route Filter Resource.
type PatchRouteFilter struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Properties of the route filter.
	Properties *RouteFilterPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PatchRouteFilterRule - Route Filter Rule Resource.
type PatchRouteFilterRule struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Properties of the route filter rule.
	Properties *RouteFilterRulePropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// PeerExpressRouteCircuitConnection - Peer Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.
type PeerExpressRouteCircuitConnection struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the peer express route circuit connection.
	Properties *PeerExpressRouteCircuitConnectionPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PeerExpressRouteCircuitConnectionListResult - Response for ListPeeredConnections API service call retrieves all global
// reach peer circuit connections that belongs to a Private Peering for an ExpressRouteCircuit.
type PeerExpressRouteCircuitConnectionListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The global reach peer circuit connection associated with Private Peering in an ExpressRoute Circuit.
	Value []*PeerExpressRouteCircuitConnection `json:"value,omitempty"`
}

// PeerExpressRouteCircuitConnectionPropertiesFormat - Properties of the peer express route circuit connection.
type PeerExpressRouteCircuitConnectionPropertiesFormat struct {
	// /29 IP address space to carve out Customer addresses for tunnels.
	AddressPrefix *string `json:"addressPrefix,omitempty"`

	// The resource guid of the authorization used for the express route circuit connection.
	AuthResourceGUID *string `json:"authResourceGuid,omitempty"`

	// The name of the express route circuit connection resource.
	ConnectionName *string `json:"connectionName,omitempty"`

	// Reference to Express Route Circuit Private Peering Resource of the circuit.
	ExpressRouteCircuitPeering *SubResource `json:"expressRouteCircuitPeering,omitempty"`

	// Reference to Express Route Circuit Private Peering Resource of the peered circuit.
	PeerExpressRouteCircuitPeering *SubResource `json:"peerExpressRouteCircuitPeering,omitempty"`

	// READ-ONLY; Express Route Circuit connection state.
	CircuitConnectionStatus *CircuitConnectionStatus `json:"circuitConnectionStatus,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the peer express route circuit connection resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PeerExpressRouteCircuitConnectionsClientGetOptions contains the optional parameters for the PeerExpressRouteCircuitConnectionsClient.Get
// method.
type PeerExpressRouteCircuitConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PeerExpressRouteCircuitConnectionsClientListOptions contains the optional parameters for the PeerExpressRouteCircuitConnectionsClient.List
// method.
type PeerExpressRouteCircuitConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PeerRoute - Peer routing details.
type PeerRoute struct {
	// READ-ONLY; The route's AS path sequence.
	AsPath *string `json:"asPath,omitempty" azure:"ro"`

	// READ-ONLY; The peer's local address.
	LocalAddress *string `json:"localAddress,omitempty" azure:"ro"`

	// READ-ONLY; The route's network prefix.
	Network *string `json:"network,omitempty" azure:"ro"`

	// READ-ONLY; The route's next hop.
	NextHop *string `json:"nextHop,omitempty" azure:"ro"`

	// READ-ONLY; The source this route was learned from.
	Origin *string `json:"origin,omitempty" azure:"ro"`

	// READ-ONLY; The peer this route was learned from.
	SourcePeer *string `json:"sourcePeer,omitempty" azure:"ro"`

	// READ-ONLY; The route's weight.
	Weight *int32 `json:"weight,omitempty" azure:"ro"`
}

// PeerRouteList - List of virtual router peer routes.
type PeerRouteList struct {
	// List of peer routes.
	Value []*PeerRoute `json:"value,omitempty"`
}

// PolicySettings - Defines contents of a web application firewall global configuration.
type PolicySettings struct {
	// Maximum file upload size in Mb for WAF.
	FileUploadLimitInMb *int32 `json:"fileUploadLimitInMb,omitempty"`

	// Maximum request body size in Kb for WAF.
	MaxRequestBodySizeInKb *int32 `json:"maxRequestBodySizeInKb,omitempty"`

	// The mode of the policy.
	Mode *WebApplicationFirewallMode `json:"mode,omitempty"`

	// Whether to allow WAF to check request Body.
	RequestBodyCheck *bool `json:"requestBodyCheck,omitempty"`

	// The state of the policy.
	State *WebApplicationFirewallEnabledState `json:"state,omitempty"`
}

// PrepareNetworkPoliciesRequest - Details of PrepareNetworkPolicies for Subnet.
type PrepareNetworkPoliciesRequest struct {
	// A list of NetworkIntentPolicyConfiguration.
	NetworkIntentPolicyConfigurations []*IntentPolicyConfiguration `json:"networkIntentPolicyConfigurations,omitempty"`

	// The name of the service for which subnet is being prepared for.
	ServiceName *string `json:"serviceName,omitempty"`
}

// PrivateDNSZoneConfig - PrivateDnsZoneConfig resource.
type PrivateDNSZoneConfig struct {
	// Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the private dns zone configuration.
	Properties *PrivateDNSZonePropertiesFormat `json:"properties,omitempty"`
}

// PrivateDNSZoneGroup - Private dns zone group resource.
type PrivateDNSZoneGroup struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the private dns zone group.
	Properties *PrivateDNSZoneGroupPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// PrivateDNSZoneGroupListResult - Response for the ListPrivateDnsZoneGroups API service call.
type PrivateDNSZoneGroupListResult struct {
	// A list of private dns zone group resources in a private endpoint.
	Value []*PrivateDNSZoneGroup `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PrivateDNSZoneGroupPropertiesFormat - Properties of the private dns zone group.
type PrivateDNSZoneGroupPropertiesFormat struct {
	// A collection of private dns zone configurations of the private dns zone group.
	PrivateDNSZoneConfigs []*PrivateDNSZoneConfig `json:"privateDnsZoneConfigs,omitempty"`

	// READ-ONLY; The provisioning state of the private dns zone group resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateDNSZoneGroupsClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateDNSZoneGroupsClient.BeginCreateOrUpdate
// method.
type PrivateDNSZoneGroupsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateDNSZoneGroupsClientBeginDeleteOptions contains the optional parameters for the PrivateDNSZoneGroupsClient.BeginDelete
// method.
type PrivateDNSZoneGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateDNSZoneGroupsClientGetOptions contains the optional parameters for the PrivateDNSZoneGroupsClient.Get method.
type PrivateDNSZoneGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateDNSZoneGroupsClientListOptions contains the optional parameters for the PrivateDNSZoneGroupsClient.List method.
type PrivateDNSZoneGroupsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateDNSZonePropertiesFormat - Properties of the private dns zone configuration resource.
type PrivateDNSZonePropertiesFormat struct {
	// The resource id of the private dns zone.
	PrivateDNSZoneID *string `json:"privateDnsZoneId,omitempty"`

	// READ-ONLY; A collection of information regarding a recordSet, holding information to identify private resources.
	RecordSets []*RecordSet `json:"recordSets,omitempty" azure:"ro"`
}

// PrivateEndpoint - Private endpoint resource.
type PrivateEndpoint struct {
	// The extended location of the load balancer.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the private endpoint.
	Properties *PrivateEndpointProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnection resource.
type PrivateEndpointConnection struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the private end point connection.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - Response for the ListPrivateEndpointConnection API service call.
type PrivateEndpointConnectionListResult struct {
	// A list of PrivateEndpointConnection resources for a specific private link service.
	Value []*PrivateEndpointConnection `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// READ-ONLY; The consumer link id.
	LinkIdentifier *string `json:"linkIdentifier,omitempty" azure:"ro"`

	// READ-ONLY; The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointIPConfiguration - An IP Configuration of the private endpoint.
type PrivateEndpointIPConfiguration struct {
	// The name of the resource that is unique within a resource group.
	Name *string `json:"name,omitempty"`

	// Properties of private endpoint IP configurations.
	Properties *PrivateEndpointIPConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointIPConfigurationProperties - Properties of an IP Configuration of the private endpoint.
type PrivateEndpointIPConfigurationProperties struct {
	// The ID of a group obtained from the remote resource that this private endpoint should connect to.
	GroupID *string `json:"groupId,omitempty"`

	// The member name of a group obtained from the remote resource that this private endpoint should connect to.
	MemberName *string `json:"memberName,omitempty"`

	// A private ip address obtained from the private endpoint's subnet.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
}

// PrivateEndpointListResult - Response for the ListPrivateEndpoints API service call.
type PrivateEndpointListResult struct {
	// A list of private endpoint resources in a resource group.
	Value []*PrivateEndpoint `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PrivateEndpointProperties - Properties of the private endpoint.
type PrivateEndpointProperties struct {
	// Application security groups in which the private endpoint IP configuration is included.
	ApplicationSecurityGroups []*ApplicationSecurityGroup `json:"applicationSecurityGroups,omitempty"`

	// An array of custom dns configurations.
	CustomDNSConfigs []*CustomDNSConfigPropertiesFormat `json:"customDnsConfigs,omitempty"`

	// The custom name of the network interface attached to the private endpoint.
	CustomNetworkInterfaceName *string `json:"customNetworkInterfaceName,omitempty"`

	// A list of IP configurations of the private endpoint. This will be used to map to the First Party Service's endpoints.
	IPConfigurations []*PrivateEndpointIPConfiguration `json:"ipConfigurations,omitempty"`

	// A grouping of information about the connection to the remote resource. Used when the network admin does not have access
	// to approve connections to the remote resource.
	ManualPrivateLinkServiceConnections []*PrivateLinkServiceConnection `json:"manualPrivateLinkServiceConnections,omitempty"`

	// A grouping of information about the connection to the remote resource.
	PrivateLinkServiceConnections []*PrivateLinkServiceConnection `json:"privateLinkServiceConnections,omitempty"`

	// The ID of the subnet from which the private IP will be allocated.
	Subnet *Subnet `json:"subnet,omitempty"`

	// READ-ONLY; An array of references to the network interfaces created for this private endpoint.
	NetworkInterfaces []*Interface `json:"networkInterfaces,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the private endpoint resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointsClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointsClient.BeginCreateOrUpdate
// method.
type PrivateEndpointsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointsClient.BeginDelete method.
type PrivateEndpointsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointsClientGetOptions contains the optional parameters for the PrivateEndpointsClient.Get method.
type PrivateEndpointsClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// PrivateEndpointsClientListBySubscriptionOptions contains the optional parameters for the PrivateEndpointsClient.ListBySubscription
// method.
type PrivateEndpointsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointsClientListOptions contains the optional parameters for the PrivateEndpointsClient.List method.
type PrivateEndpointsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkService - Private link service resource.
type PrivateLinkService struct {
	// The extended location of the load balancer.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the private link service.
	Properties *PrivateLinkServiceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkServiceConnection resource.
type PrivateLinkServiceConnection struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the private link service connection.
	Properties *PrivateLinkServiceConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkServiceConnectionProperties - Properties of the PrivateLinkServiceConnection.
type PrivateLinkServiceConnectionProperties struct {
	// The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to.
	GroupIDs []*string `json:"groupIds,omitempty"`

	// A collection of read-only information about the state of the connection to the remote resource.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The resource id of private link service.
	PrivateLinkServiceID *string `json:"privateLinkServiceId,omitempty"`

	// A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars.
	RequestMessage *string `json:"requestMessage,omitempty"`

	// READ-ONLY; The provisioning state of the private link service connection resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *string `json:"status,omitempty"`
}

// PrivateLinkServiceIPConfiguration - The private link service ip configuration.
type PrivateLinkServiceIPConfiguration struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of private link service ip configuration.
	Name *string `json:"name,omitempty"`

	// Properties of the private link service ip configuration.
	Properties *PrivateLinkServiceIPConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkServiceIPConfigurationProperties - Properties of private link service IP configuration.
type PrivateLinkServiceIPConfigurationProperties struct {
	// Whether the ip configuration is primary or not.
	Primary *bool `json:"primary,omitempty"`

	// The private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`

	// Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
	PrivateIPAddressVersion *IPVersion `json:"privateIPAddressVersion,omitempty"`

	// The private IP address allocation method.
	PrivateIPAllocationMethod *IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`

	// The reference to the subnet resource.
	Subnet *Subnet `json:"subnet,omitempty"`

	// READ-ONLY; The provisioning state of the private link service IP configuration resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateLinkServiceListResult - Response for the ListPrivateLinkService API service call.
type PrivateLinkServiceListResult struct {
	// A list of PrivateLinkService resources in a resource group.
	Value []*PrivateLinkService `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PrivateLinkServiceProperties - Properties of the private link service.
type PrivateLinkServiceProperties struct {
	// The auto-approval list of the private link service.
	AutoApproval *PrivateLinkServicePropertiesAutoApproval `json:"autoApproval,omitempty"`

	// Whether the private link service is enabled for proxy protocol or not.
	EnableProxyProtocol *bool `json:"enableProxyProtocol,omitempty"`

	// The list of Fqdn.
	Fqdns []*string `json:"fqdns,omitempty"`

	// An array of private link service IP configurations.
	IPConfigurations []*PrivateLinkServiceIPConfiguration `json:"ipConfigurations,omitempty"`

	// An array of references to the load balancer IP configurations.
	LoadBalancerFrontendIPConfigurations []*FrontendIPConfiguration `json:"loadBalancerFrontendIpConfigurations,omitempty"`

	// The visibility list of the private link service.
	Visibility *PrivateLinkServicePropertiesVisibility `json:"visibility,omitempty"`

	// READ-ONLY; The alias of the private link service.
	Alias *string `json:"alias,omitempty" azure:"ro"`

	// READ-ONLY; An array of references to the network interfaces created for this private link service.
	NetworkInterfaces []*Interface `json:"networkInterfaces,omitempty" azure:"ro"`

	// READ-ONLY; An array of list about connections to the private endpoint.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the private link service resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateLinkServicePropertiesAutoApproval - The auto-approval list of the private link service.
type PrivateLinkServicePropertiesAutoApproval struct {
	// The list of subscriptions.
	Subscriptions []*string `json:"subscriptions,omitempty"`
}

// PrivateLinkServicePropertiesVisibility - The visibility list of the private link service.
type PrivateLinkServicePropertiesVisibility struct {
	// The list of subscriptions.
	Subscriptions []*string `json:"subscriptions,omitempty"`
}

// PrivateLinkServiceVisibility - Response for the CheckPrivateLinkServiceVisibility API service call.
type PrivateLinkServiceVisibility struct {
	// Private Link Service Visibility (True/False).
	Visible *bool `json:"visible,omitempty"`
}

// PrivateLinkServicesClientBeginCheckPrivateLinkServiceVisibilityByResourceGroupOptions contains the optional parameters
// for the PrivateLinkServicesClient.BeginCheckPrivateLinkServiceVisibilityByResourceGroup method.
type PrivateLinkServicesClientBeginCheckPrivateLinkServiceVisibilityByResourceGroupOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesClientBeginCheckPrivateLinkServiceVisibilityOptions contains the optional parameters for the PrivateLinkServicesClient.BeginCheckPrivateLinkServiceVisibility
// method.
type PrivateLinkServicesClientBeginCheckPrivateLinkServiceVisibilityOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateLinkServicesClient.BeginCreateOrUpdate
// method.
type PrivateLinkServicesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesClientBeginDeleteOptions contains the optional parameters for the PrivateLinkServicesClient.BeginDelete
// method.
type PrivateLinkServicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesClientBeginDeletePrivateEndpointConnectionOptions contains the optional parameters for the PrivateLinkServicesClient.BeginDeletePrivateEndpointConnection
// method.
type PrivateLinkServicesClientBeginDeletePrivateEndpointConnectionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkServicesClientGetOptions contains the optional parameters for the PrivateLinkServicesClient.Get method.
type PrivateLinkServicesClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// PrivateLinkServicesClientGetPrivateEndpointConnectionOptions contains the optional parameters for the PrivateLinkServicesClient.GetPrivateEndpointConnection
// method.
type PrivateLinkServicesClientGetPrivateEndpointConnectionOptions struct {
	// Expands referenced resources.
	Expand *string
}

// PrivateLinkServicesClientListAutoApprovedPrivateLinkServicesByResourceGroupOptions contains the optional parameters for
// the PrivateLinkServicesClient.ListAutoApprovedPrivateLinkServicesByResourceGroup method.
type PrivateLinkServicesClientListAutoApprovedPrivateLinkServicesByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesClientListAutoApprovedPrivateLinkServicesOptions contains the optional parameters for the PrivateLinkServicesClient.ListAutoApprovedPrivateLinkServices
// method.
type PrivateLinkServicesClientListAutoApprovedPrivateLinkServicesOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesClientListBySubscriptionOptions contains the optional parameters for the PrivateLinkServicesClient.ListBySubscription
// method.
type PrivateLinkServicesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesClientListOptions contains the optional parameters for the PrivateLinkServicesClient.List method.
type PrivateLinkServicesClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesClientListPrivateEndpointConnectionsOptions contains the optional parameters for the PrivateLinkServicesClient.ListPrivateEndpointConnections
// method.
type PrivateLinkServicesClientListPrivateEndpointConnectionsOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServicesClientUpdatePrivateEndpointConnectionOptions contains the optional parameters for the PrivateLinkServicesClient.UpdatePrivateEndpointConnection
// method.
type PrivateLinkServicesClientUpdatePrivateEndpointConnectionOptions struct {
	// placeholder for future optional parameters
}

// Probe - A load balancer probe.
type Probe struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within the set of probes used by the load balancer. This name can be used to access
	// the resource.
	Name *string `json:"name,omitempty"`

	// Properties of load balancer probe.
	Properties *ProbePropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProbePropertiesFormat - Load balancer probe resource.
type ProbePropertiesFormat struct {
	// REQUIRED; The port for communicating the probe. Possible values range from 1 to 65535, inclusive.
	Port *int32 `json:"port,omitempty"`

	// REQUIRED; The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful.
	// If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required
	// for the probe to be successful.
	Protocol *ProbeProtocol `json:"protocol,omitempty"`

	// The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly
	// less than half the allocated timeout period (in seconds) which allows two full
	// probes before taking the instance out of rotation. The default value is 15, the minimum value is 5.
	IntervalInSeconds *int32 `json:"intervalInSeconds,omitempty"`

	// The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint.
	// This values allows endpoints to be taken out of rotation faster or slower than
	// the typical times used in Azure.
	NumberOfProbes *int32 `json:"numberOfProbes,omitempty"`

	// The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is
	// not allowed. There is no default value.
	RequestPath *string `json:"requestPath,omitempty"`

	// READ-ONLY; The load balancer rules that use this probe.
	LoadBalancingRules []*SubResource `json:"loadBalancingRules,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the probe resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// Profile - Network profile resource.
type Profile struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Network profile properties.
	Properties *ProfilePropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProfileListResult - Response for ListNetworkProfiles API service call.
type ProfileListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of network profiles that exist in a resource group.
	Value []*Profile `json:"value,omitempty"`
}

// ProfilePropertiesFormat - Network profile properties.
type ProfilePropertiesFormat struct {
	// List of chid container network interface configurations.
	ContainerNetworkInterfaceConfigurations []*ContainerNetworkInterfaceConfiguration `json:"containerNetworkInterfaceConfigurations,omitempty"`

	// READ-ONLY; List of child container network interfaces.
	ContainerNetworkInterfaces []*ContainerNetworkInterface `json:"containerNetworkInterfaces,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the network profile resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the network profile resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`
}

// ProfilesClientBeginDeleteOptions contains the optional parameters for the ProfilesClient.BeginDelete method.
type ProfilesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ProfilesClientCreateOrUpdateOptions contains the optional parameters for the ProfilesClient.CreateOrUpdate method.
type ProfilesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProfilesClientGetOptions contains the optional parameters for the ProfilesClient.Get method.
type ProfilesClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// ProfilesClientListAllOptions contains the optional parameters for the ProfilesClient.ListAll method.
type ProfilesClientListAllOptions struct {
	// placeholder for future optional parameters
}

// ProfilesClientListOptions contains the optional parameters for the ProfilesClient.List method.
type ProfilesClientListOptions struct {
	// placeholder for future optional parameters
}

// ProfilesClientUpdateTagsOptions contains the optional parameters for the ProfilesClient.UpdateTags method.
type ProfilesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// PropagatedRouteTable - The list of RouteTables to advertise the routes to.
type PropagatedRouteTable struct {
	// The list of resource ids of all the RouteTables.
	IDs []*SubResource `json:"ids,omitempty"`

	// The list of labels.
	Labels []*string `json:"labels,omitempty"`
}

// ProtocolConfiguration - Configuration of the protocol.
type ProtocolConfiguration struct {
	// HTTP configuration of the connectivity check.
	HTTPConfiguration *HTTPConfiguration `json:"HTTPConfiguration,omitempty"`
}

// ProtocolCustomSettingsFormat - DDoS custom policy properties.
type ProtocolCustomSettingsFormat struct {
	// The protocol for which the DDoS protection policy is being customized.
	Protocol *DdosCustomPolicyProtocol `json:"protocol,omitempty"`

	// The customized DDoS protection source rate.
	SourceRateOverride *string `json:"sourceRateOverride,omitempty"`

	// The customized DDoS protection trigger rate.
	TriggerRateOverride *string `json:"triggerRateOverride,omitempty"`

	// The customized DDoS protection trigger rate sensitivity degrees. High: Trigger rate set with most sensitivity w.r.t. normal
	// traffic. Default: Trigger rate set with moderate sensitivity w.r.t. normal
	// traffic. Low: Trigger rate set with less sensitivity w.r.t. normal traffic. Relaxed: Trigger rate set with least sensitivity
	// w.r.t. normal traffic.
	TriggerSensitivityOverride *DdosCustomPolicyTriggerSensitivityOverride `json:"triggerSensitivityOverride,omitempty"`
}

// PublicIPAddress - Public IP address resource.
type PublicIPAddress struct {
	// The extended location of the public ip address.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Public IP address properties.
	Properties *PublicIPAddressPropertiesFormat `json:"properties,omitempty"`

	// The public IP address SKU.
	SKU *PublicIPAddressSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// A list of availability zones denoting the IP allocated for the resource needs to come from.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PublicIPAddressDNSSettings - Contains FQDN of the DNS record associated with the public IP address.
type PublicIPAddressDNSSettings struct {
	// The domain name label. The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified
	// domain name associated with the public IP address. If a domain name label is
	// specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
	DomainNameLabel *string `json:"domainNameLabel,omitempty"`

	// The Fully Qualified Domain Name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel
	// and the regionalized DNS zone.
	Fqdn *string `json:"fqdn,omitempty"`

	// The reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn
	// is specified, then a PTR DNS record is created pointing from the IP address in
	// the in-addr.arpa domain to the reverse FQDN.
	ReverseFqdn *string `json:"reverseFqdn,omitempty"`
}

// PublicIPAddressListResult - Response for ListPublicIpAddresses API service call.
type PublicIPAddressListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of public IP addresses that exists in a resource group.
	Value []*PublicIPAddress `json:"value,omitempty"`
}

// PublicIPAddressPropertiesFormat - Public IP address properties.
type PublicIPAddressPropertiesFormat struct {
	// The FQDN of the DNS record associated with the public IP address.
	DNSSettings *PublicIPAddressDNSSettings `json:"dnsSettings,omitempty"`

	// The DDoS protection custom policy associated with the public IP address.
	DdosSettings *DdosSettings `json:"ddosSettings,omitempty"`

	// Specify what happens to the public IP address when the VM using it is deleted
	DeleteOption *DeleteOptions `json:"deleteOption,omitempty"`

	// The IP address associated with the public IP address resource.
	IPAddress *string `json:"ipAddress,omitempty"`

	// The list of tags associated with the public IP address.
	IPTags []*IPTag `json:"ipTags,omitempty"`

	// The idle timeout of the public IP address.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// The linked public IP address of the public IP address resource.
	LinkedPublicIPAddress *PublicIPAddress `json:"linkedPublicIPAddress,omitempty"`

	// Migration phase of Public IP Address.
	MigrationPhase *PublicIPAddressMigrationPhase `json:"migrationPhase,omitempty"`

	// The NatGateway for the Public IP address.
	NatGateway *NatGateway `json:"natGateway,omitempty"`

	// The public IP address version.
	PublicIPAddressVersion *IPVersion `json:"publicIPAddressVersion,omitempty"`

	// The public IP address allocation method.
	PublicIPAllocationMethod *IPAllocationMethod `json:"publicIPAllocationMethod,omitempty"`

	// The Public IP Prefix this Public IP Address should be allocated from.
	PublicIPPrefix *SubResource `json:"publicIPPrefix,omitempty"`

	// The service public IP address of the public IP address resource.
	ServicePublicIPAddress *PublicIPAddress `json:"servicePublicIPAddress,omitempty"`

	// READ-ONLY; The IP configuration associated with the public IP address.
	IPConfiguration *IPConfiguration `json:"ipConfiguration,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the public IP address resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the public IP address resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`
}

// PublicIPAddressSKU - SKU of a public IP address.
type PublicIPAddressSKU struct {
	// Name of a public IP address SKU.
	Name *PublicIPAddressSKUName `json:"name,omitempty"`

	// Tier of a public IP address SKU.
	Tier *PublicIPAddressSKUTier `json:"tier,omitempty"`
}

// PublicIPAddressesClientBeginCreateOrUpdateOptions contains the optional parameters for the PublicIPAddressesClient.BeginCreateOrUpdate
// method.
type PublicIPAddressesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PublicIPAddressesClientBeginDeleteOptions contains the optional parameters for the PublicIPAddressesClient.BeginDelete
// method.
type PublicIPAddressesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PublicIPAddressesClientGetCloudServicePublicIPAddressOptions contains the optional parameters for the PublicIPAddressesClient.GetCloudServicePublicIPAddress
// method.
type PublicIPAddressesClientGetCloudServicePublicIPAddressOptions struct {
	// Expands referenced resources.
	Expand *string
}

// PublicIPAddressesClientGetOptions contains the optional parameters for the PublicIPAddressesClient.Get method.
type PublicIPAddressesClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// PublicIPAddressesClientGetVirtualMachineScaleSetPublicIPAddressOptions contains the optional parameters for the PublicIPAddressesClient.GetVirtualMachineScaleSetPublicIPAddress
// method.
type PublicIPAddressesClientGetVirtualMachineScaleSetPublicIPAddressOptions struct {
	// Expands referenced resources.
	Expand *string
}

// PublicIPAddressesClientListAllOptions contains the optional parameters for the PublicIPAddressesClient.ListAll method.
type PublicIPAddressesClientListAllOptions struct {
	// placeholder for future optional parameters
}

// PublicIPAddressesClientListCloudServicePublicIPAddressesOptions contains the optional parameters for the PublicIPAddressesClient.ListCloudServicePublicIPAddresses
// method.
type PublicIPAddressesClientListCloudServicePublicIPAddressesOptions struct {
	// placeholder for future optional parameters
}

// PublicIPAddressesClientListCloudServiceRoleInstancePublicIPAddressesOptions contains the optional parameters for the PublicIPAddressesClient.ListCloudServiceRoleInstancePublicIPAddresses
// method.
type PublicIPAddressesClientListCloudServiceRoleInstancePublicIPAddressesOptions struct {
	// placeholder for future optional parameters
}

// PublicIPAddressesClientListOptions contains the optional parameters for the PublicIPAddressesClient.List method.
type PublicIPAddressesClientListOptions struct {
	// placeholder for future optional parameters
}

// PublicIPAddressesClientListVirtualMachineScaleSetPublicIPAddressesOptions contains the optional parameters for the PublicIPAddressesClient.ListVirtualMachineScaleSetPublicIPAddresses
// method.
type PublicIPAddressesClientListVirtualMachineScaleSetPublicIPAddressesOptions struct {
	// placeholder for future optional parameters
}

// PublicIPAddressesClientListVirtualMachineScaleSetVMPublicIPAddressesOptions contains the optional parameters for the PublicIPAddressesClient.ListVirtualMachineScaleSetVMPublicIPAddresses
// method.
type PublicIPAddressesClientListVirtualMachineScaleSetVMPublicIPAddressesOptions struct {
	// placeholder for future optional parameters
}

// PublicIPAddressesClientUpdateTagsOptions contains the optional parameters for the PublicIPAddressesClient.UpdateTags method.
type PublicIPAddressesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// PublicIPPrefix - Public IP prefix resource.
type PublicIPPrefix struct {
	// The extended location of the public ip address.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Public IP prefix properties.
	Properties *PublicIPPrefixPropertiesFormat `json:"properties,omitempty"`

	// The public IP prefix SKU.
	SKU *PublicIPPrefixSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// A list of availability zones denoting the IP allocated for the resource needs to come from.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PublicIPPrefixListResult - Response for ListPublicIpPrefixes API service call.
type PublicIPPrefixListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of public IP prefixes that exists in a resource group.
	Value []*PublicIPPrefix `json:"value,omitempty"`
}

// PublicIPPrefixPropertiesFormat - Public IP prefix properties.
type PublicIPPrefixPropertiesFormat struct {
	// The customIpPrefix that this prefix is associated with.
	CustomIPPrefix *SubResource `json:"customIPPrefix,omitempty"`

	// The list of tags associated with the public IP prefix.
	IPTags []*IPTag `json:"ipTags,omitempty"`

	// NatGateway of Public IP Prefix.
	NatGateway *NatGateway `json:"natGateway,omitempty"`

	// The Length of the Public IP Prefix.
	PrefixLength *int32 `json:"prefixLength,omitempty"`

	// The public IP address version.
	PublicIPAddressVersion *IPVersion `json:"publicIPAddressVersion,omitempty"`

	// READ-ONLY; The allocated Prefix.
	IPPrefix *string `json:"ipPrefix,omitempty" azure:"ro"`

	// READ-ONLY; The reference to load balancer frontend IP configuration associated with the public IP prefix.
	LoadBalancerFrontendIPConfiguration *SubResource `json:"loadBalancerFrontendIpConfiguration,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the public IP prefix resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The list of all referenced PublicIPAddresses.
	PublicIPAddresses []*ReferencedPublicIPAddress `json:"publicIPAddresses,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the public IP prefix resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`
}

// PublicIPPrefixSKU - SKU of a public IP prefix.
type PublicIPPrefixSKU struct {
	// Name of a public IP prefix SKU.
	Name *PublicIPPrefixSKUName `json:"name,omitempty"`

	// Tier of a public IP prefix SKU.
	Tier *PublicIPPrefixSKUTier `json:"tier,omitempty"`
}

// PublicIPPrefixesClientBeginCreateOrUpdateOptions contains the optional parameters for the PublicIPPrefixesClient.BeginCreateOrUpdate
// method.
type PublicIPPrefixesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PublicIPPrefixesClientBeginDeleteOptions contains the optional parameters for the PublicIPPrefixesClient.BeginDelete method.
type PublicIPPrefixesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PublicIPPrefixesClientGetOptions contains the optional parameters for the PublicIPPrefixesClient.Get method.
type PublicIPPrefixesClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// PublicIPPrefixesClientListAllOptions contains the optional parameters for the PublicIPPrefixesClient.ListAll method.
type PublicIPPrefixesClientListAllOptions struct {
	// placeholder for future optional parameters
}

// PublicIPPrefixesClientListOptions contains the optional parameters for the PublicIPPrefixesClient.List method.
type PublicIPPrefixesClientListOptions struct {
	// placeholder for future optional parameters
}

// PublicIPPrefixesClientUpdateTagsOptions contains the optional parameters for the PublicIPPrefixesClient.UpdateTags method.
type PublicIPPrefixesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// QosDefinition - Quality of Service defines the traffic configuration between endpoints. Mandatory to have one marking.
type QosDefinition struct {
	// Destination IP ranges.
	DestinationIPRanges []*QosIPRange `json:"destinationIpRanges,omitempty"`

	// Destination port ranges.
	DestinationPortRanges []*QosPortRange `json:"destinationPortRanges,omitempty"`

	// List of markings to be used in the configuration.
	Markings []*int32 `json:"markings,omitempty"`

	// RNM supported protocol types.
	Protocol *ProtocolType `json:"protocol,omitempty"`

	// Source IP ranges.
	SourceIPRanges []*QosIPRange `json:"sourceIpRanges,omitempty"`

	// Sources port ranges.
	SourcePortRanges []*QosPortRange `json:"sourcePortRanges,omitempty"`
}

// QosIPRange - Qos Traffic Profiler IP Range properties.
type QosIPRange struct {
	// End IP Address.
	EndIP *string `json:"endIP,omitempty"`

	// Start IP Address.
	StartIP *string `json:"startIP,omitempty"`
}

// QosPortRange - Qos Traffic Profiler Port range properties.
type QosPortRange struct {
	// Qos Port Range end.
	End *int32 `json:"end,omitempty"`

	// Qos Port Range start.
	Start *int32 `json:"start,omitempty"`
}

// QueryInboundNatRulePortMappingRequest - The request for a QueryInboundNatRulePortMapping API. Either IpConfiguration or
// IpAddress should be set
type QueryInboundNatRulePortMappingRequest struct {
	// IP address set in load balancer backend address.
	IPAddress *string `json:"ipAddress,omitempty"`

	// NetworkInterfaceIPConfiguration set in load balancer backend address.
	IPConfiguration *SubResource `json:"ipConfiguration,omitempty"`
}

// QueryRequestOptions - Query Request Options
type QueryRequestOptions struct {
	// When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current
	// request) to retrieve the next page of data.
	SkipToken *string `json:"skipToken,omitempty"`
}

// QueryResults - Query result
type QueryResults struct {
	// Number of total records matching the query.
	MatchingRecordsCount *int64 `json:"matchingRecordsCount,omitempty"`

	// Array containing the results of the query
	Signatures []*SingleQueryResult `json:"signatures,omitempty"`
}

// QueryTroubleshootingParameters - Parameters that define the resource to query the troubleshooting result.
type QueryTroubleshootingParameters struct {
	// REQUIRED; The target resource ID to query the troubleshooting result.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// RadiusServer - Radius Server Settings.
type RadiusServer struct {
	// REQUIRED; The address of this radius server.
	RadiusServerAddress *string `json:"radiusServerAddress,omitempty"`

	// The initial score assigned to this radius server.
	RadiusServerScore *int64 `json:"radiusServerScore,omitempty"`

	// The secret used for this radius server.
	RadiusServerSecret *string `json:"radiusServerSecret,omitempty"`
}

// RecordSet - A collective group of information about the record set information.
type RecordSet struct {
	// Fqdn that resolves to private endpoint ip address.
	Fqdn *string `json:"fqdn,omitempty"`

	// The private ip address of the private endpoint.
	IPAddresses []*string `json:"ipAddresses,omitempty"`

	// Recordset name.
	RecordSetName *string `json:"recordSetName,omitempty"`

	// Resource record type.
	RecordType *string `json:"recordType,omitempty"`

	// Recordset time to live.
	TTL *int32 `json:"ttl,omitempty"`

	// READ-ONLY; The provisioning state of the recordset.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ReferencedPublicIPAddress - Reference to a public IP address.
type ReferencedPublicIPAddress struct {
	// The PublicIPAddress Reference.
	ID *string `json:"id,omitempty"`
}

// Resource - Common resource representation.
type Resource struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceNavigationLink resource.
type ResourceNavigationLink struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Resource navigation link properties format.
	Properties *ResourceNavigationLinkFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceNavigationLinkFormat - Properties of ResourceNavigationLink.
type ResourceNavigationLinkFormat struct {
	// Link to the external resource.
	Link *string `json:"link,omitempty"`

	// Resource type of the linked resource.
	LinkedResourceType *string `json:"linkedResourceType,omitempty"`

	// READ-ONLY; The provisioning state of the resource navigation link resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ResourceNavigationLinksClientListOptions contains the optional parameters for the ResourceNavigationLinksClient.List method.
type ResourceNavigationLinksClientListOptions struct {
	// placeholder for future optional parameters
}

// ResourceNavigationLinksListResult - Response for ResourceNavigationLinks_List operation.
type ResourceNavigationLinksListResult struct {
	// The resource navigation links in a subnet.
	Value []*ResourceNavigationLink `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ResourceSet - The base resource set for visibility and auto-approval.
type ResourceSet struct {
	// The list of subscriptions.
	Subscriptions []*string `json:"subscriptions,omitempty"`
}

// RetentionPolicyParameters - Parameters that define the retention policy for flow log.
type RetentionPolicyParameters struct {
	// Number of days to retain flow log records.
	Days *int32 `json:"days,omitempty"`

	// Flag to enable/disable retention.
	Enabled *bool `json:"enabled,omitempty"`
}

// Route resource.
type Route struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the route.
	Properties *RoutePropertiesFormat `json:"properties,omitempty"`

	// The type of the resource.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// RouteFilter - Route Filter Resource.
type RouteFilter struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the route filter.
	Properties *RouteFilterPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RouteFilterListResult - Response for the ListRouteFilters API service call.
type RouteFilterListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of route filters in a resource group.
	Value []*RouteFilter `json:"value,omitempty"`
}

// RouteFilterPropertiesFormat - Route Filter Resource.
type RouteFilterPropertiesFormat struct {
	// Collection of RouteFilterRules contained within a route filter.
	Rules []*RouteFilterRule `json:"rules,omitempty"`

	// READ-ONLY; A collection of references to express route circuit ipv6 peerings.
	IPv6Peerings []*ExpressRouteCircuitPeering `json:"ipv6Peerings,omitempty" azure:"ro"`

	// READ-ONLY; A collection of references to express route circuit peerings.
	Peerings []*ExpressRouteCircuitPeering `json:"peerings,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the route filter resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// RouteFilterRule - Route Filter Rule Resource.
type RouteFilterRule struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the route filter rule.
	Properties *RouteFilterRulePropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// RouteFilterRuleListResult - Response for the ListRouteFilterRules API service call.
type RouteFilterRuleListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of RouteFilterRules in a resource group.
	Value []*RouteFilterRule `json:"value,omitempty"`
}

// RouteFilterRulePropertiesFormat - Route Filter Rule Resource.
type RouteFilterRulePropertiesFormat struct {
	// REQUIRED; The access type of the rule.
	Access *Access `json:"access,omitempty"`

	// REQUIRED; The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020'].
	Communities []*string `json:"communities,omitempty"`

	// REQUIRED; The rule type of the rule.
	RouteFilterRuleType *RouteFilterRuleType `json:"routeFilterRuleType,omitempty"`

	// READ-ONLY; The provisioning state of the route filter rule resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// RouteFilterRulesClientBeginCreateOrUpdateOptions contains the optional parameters for the RouteFilterRulesClient.BeginCreateOrUpdate
// method.
type RouteFilterRulesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RouteFilterRulesClientBeginDeleteOptions contains the optional parameters for the RouteFilterRulesClient.BeginDelete method.
type RouteFilterRulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RouteFilterRulesClientGetOptions contains the optional parameters for the RouteFilterRulesClient.Get method.
type RouteFilterRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// RouteFilterRulesClientListByRouteFilterOptions contains the optional parameters for the RouteFilterRulesClient.ListByRouteFilter
// method.
type RouteFilterRulesClientListByRouteFilterOptions struct {
	// placeholder for future optional parameters
}

// RouteFiltersClientBeginCreateOrUpdateOptions contains the optional parameters for the RouteFiltersClient.BeginCreateOrUpdate
// method.
type RouteFiltersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RouteFiltersClientBeginDeleteOptions contains the optional parameters for the RouteFiltersClient.BeginDelete method.
type RouteFiltersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RouteFiltersClientGetOptions contains the optional parameters for the RouteFiltersClient.Get method.
type RouteFiltersClientGetOptions struct {
	// Expands referenced express route bgp peering resources.
	Expand *string
}

// RouteFiltersClientListByResourceGroupOptions contains the optional parameters for the RouteFiltersClient.ListByResourceGroup
// method.
type RouteFiltersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// RouteFiltersClientListOptions contains the optional parameters for the RouteFiltersClient.List method.
type RouteFiltersClientListOptions struct {
	// placeholder for future optional parameters
}

// RouteFiltersClientUpdateTagsOptions contains the optional parameters for the RouteFiltersClient.UpdateTags method.
type RouteFiltersClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// RouteListResult - Response for the ListRoute API service call.
type RouteListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of routes in a resource group.
	Value []*Route `json:"value,omitempty"`
}

// RoutePropertiesFormat - Route resource.
type RoutePropertiesFormat struct {
	// REQUIRED; The type of Azure hop the packet should be sent to.
	NextHopType *RouteNextHopType `json:"nextHopType,omitempty"`

	// The destination CIDR to which the route applies.
	AddressPrefix *string `json:"addressPrefix,omitempty"`

	// A value indicating whether this route overrides overlapping BGP routes regardless of LPM.
	HasBgpOverride *bool `json:"hasBgpOverride,omitempty"`

	// The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
	NextHopIPAddress *string `json:"nextHopIpAddress,omitempty"`

	// READ-ONLY; The provisioning state of the route resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// RouteTable - Route table resource.
type RouteTable struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the route table.
	Properties *RouteTablePropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RouteTableListResult - Response for the ListRouteTable API service call.
type RouteTableListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of route tables in a resource group.
	Value []*RouteTable `json:"value,omitempty"`
}

// RouteTablePropertiesFormat - Route Table resource.
type RouteTablePropertiesFormat struct {
	// Whether to disable the routes learned by BGP on that route table. True means disable.
	DisableBgpRoutePropagation *bool `json:"disableBgpRoutePropagation,omitempty"`

	// Collection of routes contained within a route table.
	Routes []*Route `json:"routes,omitempty"`

	// READ-ONLY; The provisioning state of the route table resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the route table.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`

	// READ-ONLY; A collection of references to subnets.
	Subnets []*Subnet `json:"subnets,omitempty" azure:"ro"`
}

// RouteTablesClientBeginCreateOrUpdateOptions contains the optional parameters for the RouteTablesClient.BeginCreateOrUpdate
// method.
type RouteTablesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RouteTablesClientBeginDeleteOptions contains the optional parameters for the RouteTablesClient.BeginDelete method.
type RouteTablesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RouteTablesClientGetOptions contains the optional parameters for the RouteTablesClient.Get method.
type RouteTablesClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// RouteTablesClientListAllOptions contains the optional parameters for the RouteTablesClient.ListAll method.
type RouteTablesClientListAllOptions struct {
	// placeholder for future optional parameters
}

// RouteTablesClientListOptions contains the optional parameters for the RouteTablesClient.List method.
type RouteTablesClientListOptions struct {
	// placeholder for future optional parameters
}

// RouteTablesClientUpdateTagsOptions contains the optional parameters for the RouteTablesClient.UpdateTags method.
type RouteTablesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// RoutesClientBeginCreateOrUpdateOptions contains the optional parameters for the RoutesClient.BeginCreateOrUpdate method.
type RoutesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RoutesClientBeginDeleteOptions contains the optional parameters for the RoutesClient.BeginDelete method.
type RoutesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RoutesClientGetOptions contains the optional parameters for the RoutesClient.Get method.
type RoutesClientGetOptions struct {
	// placeholder for future optional parameters
}

// RoutesClientListOptions contains the optional parameters for the RoutesClient.List method.
type RoutesClientListOptions struct {
	// placeholder for future optional parameters
}

// RoutingConfiguration - Routing Configuration indicating the associated and propagated route tables for this connection.
type RoutingConfiguration struct {
	// The resource id RouteTable associated with this RoutingConfiguration.
	AssociatedRouteTable *SubResource `json:"associatedRouteTable,omitempty"`

	// The list of RouteTables to advertise the routes to.
	PropagatedRouteTables *PropagatedRouteTable `json:"propagatedRouteTables,omitempty"`

	// List of routes that control routing from VirtualHub into a virtual network connection.
	VnetRoutes *VnetRoute `json:"vnetRoutes,omitempty"`
}

// RoutingIntent - The routing intent child resource of a Virtual hub.
type RoutingIntent struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the RoutingIntent resource.
	Properties *RoutingIntentProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RoutingIntentClientBeginCreateOrUpdateOptions contains the optional parameters for the RoutingIntentClient.BeginCreateOrUpdate
// method.
type RoutingIntentClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RoutingIntentClientBeginDeleteOptions contains the optional parameters for the RoutingIntentClient.BeginDelete method.
type RoutingIntentClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RoutingIntentClientGetOptions contains the optional parameters for the RoutingIntentClient.Get method.
type RoutingIntentClientGetOptions struct {
	// placeholder for future optional parameters
}

// RoutingIntentClientListOptions contains the optional parameters for the RoutingIntentClient.List method.
type RoutingIntentClientListOptions struct {
	// placeholder for future optional parameters
}

// RoutingIntentProperties - The properties of a RoutingIntent resource.
type RoutingIntentProperties struct {
	// List of routing policies.
	RoutingPolicies []*RoutingPolicy `json:"routingPolicies,omitempty"`

	// READ-ONLY; The provisioning state of the RoutingIntent resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// RoutingPolicy - The routing policy object used in a RoutingIntent resource.
type RoutingPolicy struct {
	// REQUIRED; List of all destinations which this routing policy is applicable to (for example: Internet, PrivateTraffic).
	Destinations []*string `json:"destinations,omitempty"`

	// REQUIRED; The unique name for the routing policy.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The next hop resource id on which this routing policy is applicable to.
	NextHop *string `json:"nextHop,omitempty"`
}

// Rule of type network.
type Rule struct {
	// REQUIRED; Rule Type.
	RuleType *FirewallPolicyRuleType `json:"ruleType,omitempty"`

	// Description of the rule.
	Description *string `json:"description,omitempty"`

	// List of destination IP addresses or Service Tags.
	DestinationAddresses []*string `json:"destinationAddresses,omitempty"`

	// List of destination FQDNs.
	DestinationFqdns []*string `json:"destinationFqdns,omitempty"`

	// List of destination IpGroups for this rule.
	DestinationIPGroups []*string `json:"destinationIpGroups,omitempty"`

	// List of destination ports.
	DestinationPorts []*string `json:"destinationPorts,omitempty"`

	// Array of FirewallPolicyRuleNetworkProtocols.
	IPProtocols []*FirewallPolicyRuleNetworkProtocol `json:"ipProtocols,omitempty"`

	// Name of the rule.
	Name *string `json:"name,omitempty"`

	// List of source IP addresses for this rule.
	SourceAddresses []*string `json:"sourceAddresses,omitempty"`

	// List of source IpGroups for this rule.
	SourceIPGroups []*string `json:"sourceIpGroups,omitempty"`
}

// GetFirewallPolicyRule implements the FirewallPolicyRuleClassification interface for type Rule.
func (r *Rule) GetFirewallPolicyRule() *FirewallPolicyRule {
	return &FirewallPolicyRule{
		Name:        r.Name,
		Description: r.Description,
		RuleType:    r.RuleType,
	}
}

// SKU - The sku of this Bastion Host.
type SKU struct {
	// The name of this Bastion Host.
	Name *BastionHostSKUName `json:"name,omitempty"`
}

// ScopeConnection - The Scope Connections resource
type ScopeConnection struct {
	// The scope connection properties
	Properties *ScopeConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ScopeConnectionListResult - List of scope connections.
type ScopeConnectionListResult struct {
	// Gets the URL to get the next page of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of scope connections.
	Value []*ScopeConnection `json:"value,omitempty"`
}

// ScopeConnectionProperties - Scope connection.
type ScopeConnectionProperties struct {
	// A description of the scope connection.
	Description *string `json:"description,omitempty"`

	// Resource ID.
	ResourceID *string `json:"resourceId,omitempty"`

	// Tenant ID.
	TenantID *string `json:"tenantId,omitempty"`

	// READ-ONLY; Connection State
	ConnectionState *ScopeConnectionState `json:"connectionState,omitempty" azure:"ro"`
}

// ScopeConnectionsClientCreateOrUpdateOptions contains the optional parameters for the ScopeConnectionsClient.CreateOrUpdate
// method.
type ScopeConnectionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ScopeConnectionsClientDeleteOptions contains the optional parameters for the ScopeConnectionsClient.Delete method.
type ScopeConnectionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ScopeConnectionsClientGetOptions contains the optional parameters for the ScopeConnectionsClient.Get method.
type ScopeConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ScopeConnectionsClientListOptions contains the optional parameters for the ScopeConnectionsClient.List method.
type ScopeConnectionsClientListOptions struct {
	// SkipToken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skipToken parameter that
	// specifies a starting point to use for subsequent calls.
	SkipToken *string
	// An optional query parameter which specifies the maximum number of records to be returned by the server.
	Top *int32
}

// SecurityAdminConfiguration - Defines the security admin configuration
type SecurityAdminConfiguration struct {
	// Indicates the properties for the network manager security admin configuration.
	Properties *SecurityAdminConfigurationPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SecurityAdminConfigurationListResult - A list of network manager security admin configurations
type SecurityAdminConfigurationListResult struct {
	// Gets the URL to get the next page of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets a page of security admin configurations
	Value []*SecurityAdminConfiguration `json:"value,omitempty"`
}

// SecurityAdminConfigurationPropertiesFormat - Defines the security admin configuration properties.
type SecurityAdminConfigurationPropertiesFormat struct {
	// Enum list of network intent policy based services.
	ApplyOnNetworkIntentPolicyBasedServices []*NetworkIntentPolicyBasedService `json:"applyOnNetworkIntentPolicyBasedServices,omitempty"`

	// A description of the security configuration.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// SecurityAdminConfigurationsClientBeginDeleteOptions contains the optional parameters for the SecurityAdminConfigurationsClient.BeginDelete
// method.
type SecurityAdminConfigurationsClientBeginDeleteOptions struct {
	// Deletes the resource even if it is part of a deployed configuration. If the configuration has been deployed, the service
	// will do a cleanup deployment in the background, prior to the delete.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SecurityAdminConfigurationsClientCreateOrUpdateOptions contains the optional parameters for the SecurityAdminConfigurationsClient.CreateOrUpdate
// method.
type SecurityAdminConfigurationsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SecurityAdminConfigurationsClientGetOptions contains the optional parameters for the SecurityAdminConfigurationsClient.Get
// method.
type SecurityAdminConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SecurityAdminConfigurationsClientListOptions contains the optional parameters for the SecurityAdminConfigurationsClient.List
// method.
type SecurityAdminConfigurationsClientListOptions struct {
	// SkipToken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skipToken parameter that
	// specifies a starting point to use for subsequent calls.
	SkipToken *string
	// An optional query parameter which specifies the maximum number of records to be returned by the server.
	Top *int32
}

// SecurityGroup - NetworkSecurityGroup resource.
type SecurityGroup struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the network security group.
	Properties *SecurityGroupPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SecurityGroupListResult - Response for ListNetworkSecurityGroups API service call.
type SecurityGroupListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of NetworkSecurityGroup resources.
	Value []*SecurityGroup `json:"value,omitempty"`
}

// SecurityGroupNetworkInterface - Network interface and all its associated security rules.
type SecurityGroupNetworkInterface struct {
	// ID of the network interface.
	ID *string `json:"id,omitempty"`

	// All security rules associated with the network interface.
	SecurityRuleAssociations *SecurityRuleAssociations `json:"securityRuleAssociations,omitempty"`
}

// SecurityGroupPropertiesFormat - Network Security Group resource.
type SecurityGroupPropertiesFormat struct {
	// When enabled, flows created from Network Security Group connections will be re-evaluated when rules are updates. Initial
	// enablement will trigger re-evaluation.
	FlushConnection *bool `json:"flushConnection,omitempty"`

	// A collection of security rules of the network security group.
	SecurityRules []*SecurityRule `json:"securityRules,omitempty"`

	// READ-ONLY; The default security rules of network security group.
	DefaultSecurityRules []*SecurityRule `json:"defaultSecurityRules,omitempty" azure:"ro"`

	// READ-ONLY; A collection of references to flow log resources.
	FlowLogs []*FlowLog `json:"flowLogs,omitempty" azure:"ro"`

	// READ-ONLY; A collection of references to network interfaces.
	NetworkInterfaces []*Interface `json:"networkInterfaces,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the network security group resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the network security group resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`

	// READ-ONLY; A collection of references to subnets.
	Subnets []*Subnet `json:"subnets,omitempty" azure:"ro"`
}

// SecurityGroupResult - Network configuration diagnostic result corresponded provided traffic query.
type SecurityGroupResult struct {
	// The network traffic is allowed or denied.
	SecurityRuleAccessResult *SecurityRuleAccess `json:"securityRuleAccessResult,omitempty"`

	// READ-ONLY; List of results network security groups diagnostic.
	EvaluatedNetworkSecurityGroups []*EvaluatedNetworkSecurityGroup `json:"evaluatedNetworkSecurityGroups,omitempty" azure:"ro"`
}

// SecurityGroupViewParameters - Parameters that define the VM to check security groups for.
type SecurityGroupViewParameters struct {
	// REQUIRED; ID of the target VM.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// SecurityGroupViewResult - The information about security rules applied to the specified VM.
type SecurityGroupViewResult struct {
	// List of network interfaces on the specified VM.
	NetworkInterfaces []*SecurityGroupNetworkInterface `json:"networkInterfaces,omitempty"`
}

// SecurityGroupsClientBeginCreateOrUpdateOptions contains the optional parameters for the SecurityGroupsClient.BeginCreateOrUpdate
// method.
type SecurityGroupsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SecurityGroupsClientBeginDeleteOptions contains the optional parameters for the SecurityGroupsClient.BeginDelete method.
type SecurityGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SecurityGroupsClientGetOptions contains the optional parameters for the SecurityGroupsClient.Get method.
type SecurityGroupsClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// SecurityGroupsClientListAllOptions contains the optional parameters for the SecurityGroupsClient.ListAll method.
type SecurityGroupsClientListAllOptions struct {
	// placeholder for future optional parameters
}

// SecurityGroupsClientListOptions contains the optional parameters for the SecurityGroupsClient.List method.
type SecurityGroupsClientListOptions struct {
	// placeholder for future optional parameters
}

// SecurityGroupsClientUpdateTagsOptions contains the optional parameters for the SecurityGroupsClient.UpdateTags method.
type SecurityGroupsClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// SecurityPartnerProvider - Security Partner Provider resource.
type SecurityPartnerProvider struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the Security Partner Provider.
	Properties *SecurityPartnerProviderPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SecurityPartnerProviderListResult - Response for ListSecurityPartnerProviders API service call.
type SecurityPartnerProviderListResult struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Security Partner Providers in a resource group.
	Value []*SecurityPartnerProvider `json:"value,omitempty"`
}

// SecurityPartnerProviderPropertiesFormat - Properties of the Security Partner Provider.
type SecurityPartnerProviderPropertiesFormat struct {
	// The security provider name.
	SecurityProviderName *SecurityProviderName `json:"securityProviderName,omitempty"`

	// The virtualHub to which the Security Partner Provider belongs.
	VirtualHub *SubResource `json:"virtualHub,omitempty"`

	// READ-ONLY; The connection status with the Security Partner Provider.
	ConnectionStatus *SecurityPartnerProviderConnectionStatus `json:"connectionStatus,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the Security Partner Provider resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// SecurityPartnerProvidersClientBeginCreateOrUpdateOptions contains the optional parameters for the SecurityPartnerProvidersClient.BeginCreateOrUpdate
// method.
type SecurityPartnerProvidersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SecurityPartnerProvidersClientBeginDeleteOptions contains the optional parameters for the SecurityPartnerProvidersClient.BeginDelete
// method.
type SecurityPartnerProvidersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SecurityPartnerProvidersClientGetOptions contains the optional parameters for the SecurityPartnerProvidersClient.Get method.
type SecurityPartnerProvidersClientGetOptions struct {
	// placeholder for future optional parameters
}

// SecurityPartnerProvidersClientListByResourceGroupOptions contains the optional parameters for the SecurityPartnerProvidersClient.ListByResourceGroup
// method.
type SecurityPartnerProvidersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// SecurityPartnerProvidersClientListOptions contains the optional parameters for the SecurityPartnerProvidersClient.List
// method.
type SecurityPartnerProvidersClientListOptions struct {
	// placeholder for future optional parameters
}

// SecurityPartnerProvidersClientUpdateTagsOptions contains the optional parameters for the SecurityPartnerProvidersClient.UpdateTags
// method.
type SecurityPartnerProvidersClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// SecurityRule - Network security rule.
type SecurityRule struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the security rule.
	Properties *SecurityRulePropertiesFormat `json:"properties,omitempty"`

	// The type of the resource.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// SecurityRuleAssociations - All security rules associated with the network interface.
type SecurityRuleAssociations struct {
	// Collection of default security rules of the network security group.
	DefaultSecurityRules []*SecurityRule `json:"defaultSecurityRules,omitempty"`

	// Collection of effective security rules.
	EffectiveSecurityRules []*EffectiveNetworkSecurityRule `json:"effectiveSecurityRules,omitempty"`

	// Network interface and it's custom security rules.
	NetworkInterfaceAssociation *InterfaceAssociation `json:"networkInterfaceAssociation,omitempty"`

	// Subnet and it's custom security rules.
	SubnetAssociation *SubnetAssociation `json:"subnetAssociation,omitempty"`
}

// SecurityRuleListResult - Response for ListSecurityRule API service call. Retrieves all security rules that belongs to a
// network security group.
type SecurityRuleListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The security rules in a network security group.
	Value []*SecurityRule `json:"value,omitempty"`
}

// SecurityRulePropertiesFormat - Security rule resource.
type SecurityRulePropertiesFormat struct {
	// REQUIRED; The network traffic is allowed or denied.
	Access *SecurityRuleAccess `json:"access,omitempty"`

	// REQUIRED; The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
	Direction *SecurityRuleDirection `json:"direction,omitempty"`

	// REQUIRED; Network protocol this rule applies to.
	Protocol *SecurityRuleProtocol `json:"protocol,omitempty"`

	// A description for this rule. Restricted to 140 chars.
	Description *string `json:"description,omitempty"`

	// The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default
	// tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also
	// be used.
	DestinationAddressPrefix *string `json:"destinationAddressPrefix,omitempty"`

	// The destination address prefixes. CIDR or destination IP ranges.
	DestinationAddressPrefixes []*string `json:"destinationAddressPrefixes,omitempty"`

	// The application security group specified as destination.
	DestinationApplicationSecurityGroups []*ApplicationSecurityGroup `json:"destinationApplicationSecurityGroups,omitempty"`

	// The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
	DestinationPortRange *string `json:"destinationPortRange,omitempty"`

	// The destination port ranges.
	DestinationPortRanges []*string `json:"destinationPortRanges,omitempty"`

	// The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the
	// collection. The lower the priority number, the higher the priority of the rule.
	Priority *int32 `json:"priority,omitempty"`

	// The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork',
	// 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress
	// rule, specifies where network traffic originates from.
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`

	// The CIDR or source IP ranges.
	SourceAddressPrefixes []*string `json:"sourceAddressPrefixes,omitempty"`

	// The application security group specified as source.
	SourceApplicationSecurityGroups []*ApplicationSecurityGroup `json:"sourceApplicationSecurityGroups,omitempty"`

	// The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
	SourcePortRange *string `json:"sourcePortRange,omitempty"`

	// The source port ranges.
	SourcePortRanges []*string `json:"sourcePortRanges,omitempty"`

	// READ-ONLY; The provisioning state of the security rule resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// SecurityRulesClientBeginCreateOrUpdateOptions contains the optional parameters for the SecurityRulesClient.BeginCreateOrUpdate
// method.
type SecurityRulesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SecurityRulesClientBeginDeleteOptions contains the optional parameters for the SecurityRulesClient.BeginDelete method.
type SecurityRulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SecurityRulesClientGetOptions contains the optional parameters for the SecurityRulesClient.Get method.
type SecurityRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SecurityRulesClientListOptions contains the optional parameters for the SecurityRulesClient.List method.
type SecurityRulesClientListOptions struct {
	// placeholder for future optional parameters
}

// SecurityRulesEvaluationResult - Network security rules evaluation result.
type SecurityRulesEvaluationResult struct {
	// Value indicating whether destination is matched.
	DestinationMatched *bool `json:"destinationMatched,omitempty"`

	// Value indicating whether destination port is matched.
	DestinationPortMatched *bool `json:"destinationPortMatched,omitempty"`

	// Name of the network security rule.
	Name *string `json:"name,omitempty"`

	// Value indicating whether protocol is matched.
	ProtocolMatched *bool `json:"protocolMatched,omitempty"`

	// Value indicating whether source is matched.
	SourceMatched *bool `json:"sourceMatched,omitempty"`

	// Value indicating whether source port is matched.
	SourcePortMatched *bool `json:"sourcePortMatched,omitempty"`
}

// ServiceAssociationLink resource.
type ServiceAssociationLink struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Resource navigation link properties format.
	Properties *ServiceAssociationLinkPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceAssociationLinkPropertiesFormat - Properties of ServiceAssociationLink.
type ServiceAssociationLinkPropertiesFormat struct {
	// If true, the resource can be deleted.
	AllowDelete *bool `json:"allowDelete,omitempty"`

	// Link to the external resource.
	Link *string `json:"link,omitempty"`

	// Resource type of the linked resource.
	LinkedResourceType *string `json:"linkedResourceType,omitempty"`

	// A list of locations.
	Locations []*string `json:"locations,omitempty"`

	// READ-ONLY; The provisioning state of the service association link resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ServiceAssociationLinksClientListOptions contains the optional parameters for the ServiceAssociationLinksClient.List method.
type ServiceAssociationLinksClientListOptions struct {
	// placeholder for future optional parameters
}

// ServiceAssociationLinksListResult - Response for ServiceAssociationLinks_List operation.
type ServiceAssociationLinksListResult struct {
	// The service association links in a subnet.
	Value []*ServiceAssociationLink `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ServiceDelegationPropertiesFormat - Properties of a service delegation.
type ServiceDelegationPropertiesFormat struct {
	// The name of the service to whom the subnet should be delegated (e.g. Microsoft.Sql/servers).
	ServiceName *string `json:"serviceName,omitempty"`

	// READ-ONLY; The actions permitted to the service upon delegation.
	Actions []*string `json:"actions,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the service delegation resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ServiceEndpointPoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the ServiceEndpointPoliciesClient.BeginCreateOrUpdate
// method.
type ServiceEndpointPoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceEndpointPoliciesClientBeginDeleteOptions contains the optional parameters for the ServiceEndpointPoliciesClient.BeginDelete
// method.
type ServiceEndpointPoliciesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceEndpointPoliciesClientGetOptions contains the optional parameters for the ServiceEndpointPoliciesClient.Get method.
type ServiceEndpointPoliciesClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// ServiceEndpointPoliciesClientListByResourceGroupOptions contains the optional parameters for the ServiceEndpointPoliciesClient.ListByResourceGroup
// method.
type ServiceEndpointPoliciesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ServiceEndpointPoliciesClientListOptions contains the optional parameters for the ServiceEndpointPoliciesClient.List method.
type ServiceEndpointPoliciesClientListOptions struct {
	// placeholder for future optional parameters
}

// ServiceEndpointPoliciesClientUpdateTagsOptions contains the optional parameters for the ServiceEndpointPoliciesClient.UpdateTags
// method.
type ServiceEndpointPoliciesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// ServiceEndpointPolicy - Service End point policy resource.
type ServiceEndpointPolicy struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the service end point policy.
	Properties *ServiceEndpointPolicyPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Kind of service endpoint policy. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceEndpointPolicyDefinition - Service Endpoint policy definitions.
type ServiceEndpointPolicyDefinition struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the service endpoint policy definition.
	Properties *ServiceEndpointPolicyDefinitionPropertiesFormat `json:"properties,omitempty"`

	// The type of the resource.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// ServiceEndpointPolicyDefinitionListResult - Response for ListServiceEndpointPolicyDefinition API service call. Retrieves
// all service endpoint policy definition that belongs to a service endpoint policy.
type ServiceEndpointPolicyDefinitionListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The service endpoint policy definition in a service endpoint policy.
	Value []*ServiceEndpointPolicyDefinition `json:"value,omitempty"`
}

// ServiceEndpointPolicyDefinitionPropertiesFormat - Service Endpoint policy definition resource.
type ServiceEndpointPolicyDefinitionPropertiesFormat struct {
	// A description for this rule. Restricted to 140 chars.
	Description *string `json:"description,omitempty"`

	// Service endpoint name.
	Service *string `json:"service,omitempty"`

	// A list of service resources.
	ServiceResources []*string `json:"serviceResources,omitempty"`

	// READ-ONLY; The provisioning state of the service endpoint policy definition resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ServiceEndpointPolicyDefinitionsClientBeginCreateOrUpdateOptions contains the optional parameters for the ServiceEndpointPolicyDefinitionsClient.BeginCreateOrUpdate
// method.
type ServiceEndpointPolicyDefinitionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceEndpointPolicyDefinitionsClientBeginDeleteOptions contains the optional parameters for the ServiceEndpointPolicyDefinitionsClient.BeginDelete
// method.
type ServiceEndpointPolicyDefinitionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceEndpointPolicyDefinitionsClientGetOptions contains the optional parameters for the ServiceEndpointPolicyDefinitionsClient.Get
// method.
type ServiceEndpointPolicyDefinitionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServiceEndpointPolicyDefinitionsClientListByResourceGroupOptions contains the optional parameters for the ServiceEndpointPolicyDefinitionsClient.ListByResourceGroup
// method.
type ServiceEndpointPolicyDefinitionsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ServiceEndpointPolicyListResult - Response for ListServiceEndpointPolicies API service call.
type ServiceEndpointPolicyListResult struct {
	// A list of ServiceEndpointPolicy resources.
	Value []*ServiceEndpointPolicy `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ServiceEndpointPolicyPropertiesFormat - Service Endpoint Policy resource.
type ServiceEndpointPolicyPropertiesFormat struct {
	// A collection of contextual service endpoint policy.
	ContextualServiceEndpointPolicies []*string `json:"contextualServiceEndpointPolicies,omitempty"`

	// The alias indicating if the policy belongs to a service
	ServiceAlias *string `json:"serviceAlias,omitempty"`

	// A collection of service endpoint policy definitions of the service endpoint policy.
	ServiceEndpointPolicyDefinitions []*ServiceEndpointPolicyDefinition `json:"serviceEndpointPolicyDefinitions,omitempty"`

	// READ-ONLY; The provisioning state of the service endpoint policy resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the service endpoint policy resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`

	// READ-ONLY; A collection of references to subnets.
	Subnets []*Subnet `json:"subnets,omitempty" azure:"ro"`
}

// ServiceEndpointPropertiesFormat - The service endpoint properties.
type ServiceEndpointPropertiesFormat struct {
	// A list of locations.
	Locations []*string `json:"locations,omitempty"`

	// The type of the endpoint service.
	Service *string `json:"service,omitempty"`

	// READ-ONLY; The provisioning state of the service endpoint resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ServiceTagInformation - The service tag information.
type ServiceTagInformation struct {
	// READ-ONLY; The ID of service tag.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of service tag.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Properties of the service tag information.
	Properties *ServiceTagInformationPropertiesFormat `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The iteration number of service tag object for region.
	ServiceTagChangeNumber *string `json:"serviceTagChangeNumber,omitempty" azure:"ro"`
}

// ServiceTagInformationClientListOptions contains the optional parameters for the ServiceTagInformationClient.List method.
type ServiceTagInformationClientListOptions struct {
	// Do not return address prefixes for the tag(s).
	NoAddressPrefixes *bool
	// Return tag information for a particular tag.
	TagName *string
}

// ServiceTagInformationListResult - Response for Get ServiceTagInformation API service call. Retrieves the list of service
// tag information resources.
type ServiceTagInformationListResult struct {
	// The list of service tag information resources.
	Value []*ServiceTagInformation `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ServiceTagInformationPropertiesFormat - Properties of the service tag information.
type ServiceTagInformationPropertiesFormat struct {
	// READ-ONLY; The list of IP address prefixes.
	AddressPrefixes []*string `json:"addressPrefixes,omitempty" azure:"ro"`

	// READ-ONLY; The iteration number of service tag.
	ChangeNumber *string `json:"changeNumber,omitempty" azure:"ro"`

	// READ-ONLY; The region of service tag.
	Region *string `json:"region,omitempty" azure:"ro"`

	// READ-ONLY; The state of the service tag.
	State *string `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; The name of system service.
	SystemService *string `json:"systemService,omitempty" azure:"ro"`
}

// ServiceTagsClientListOptions contains the optional parameters for the ServiceTagsClient.List method.
type ServiceTagsClientListOptions struct {
	// placeholder for future optional parameters
}

// ServiceTagsListResult - Response for the ListServiceTags API service call.
type ServiceTagsListResult struct {
	// READ-ONLY; The iteration number.
	ChangeNumber *string `json:"changeNumber,omitempty" azure:"ro"`

	// READ-ONLY; The name of the cloud.
	Cloud *string `json:"cloud,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the cloud.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the cloud.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The URL to get next page of service tag information resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The azure resource type.
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; The list of service tag information resources.
	Values []*ServiceTagInformation `json:"values,omitempty" azure:"ro"`
}

// SessionIDs - List of session IDs.
type SessionIDs struct {
	// List of session IDs.
	SessionIDs []*string `json:"sessionIds,omitempty"`
}

// SignatureOverridesFilterValuesQuery - Describes the filter values possibles for a given column
type SignatureOverridesFilterValuesQuery struct {
	// Describes the name of the column which values will be returned
	FilterName *string `json:"filterName,omitempty"`
}

// SignatureOverridesFilterValuesResponse - Describes the list of all possible values for a specific filter value
type SignatureOverridesFilterValuesResponse struct {
	// Describes the possible values
	FilterValues []*string `json:"filterValues,omitempty"`
}

// SignaturesOverrides - Contains all specific policy signatures overrides for the IDPS
type SignaturesOverrides struct {
	// Will contain the resource id of the signature override resource
	ID *string `json:"id,omitempty"`

	// Contains the name of the resource (default)
	Name *string `json:"name,omitempty"`

	// Will contain the properties of the resource (the actual signature overrides)
	Properties *SignaturesOverridesProperties `json:"properties,omitempty"`

	// Will contain the type of the resource: Microsoft.Network/firewallPolicies/intrusionDetectionSignaturesOverrides
	Type *string `json:"type,omitempty"`
}

// SignaturesOverridesList - Describes an object containing an array with a single item
type SignaturesOverridesList struct {
	// Describes a list consisting exactly one item describing the policy's signature override status
	Value []*SignaturesOverrides `json:"value,omitempty"`
}

// SignaturesOverridesProperties - Will contain the properties of the resource (the actual signature overrides)
type SignaturesOverridesProperties struct {
	// Dictionary of
	Signatures map[string]*string `json:"signatures,omitempty"`
}

type SingleQueryResult struct {
	// Describes what is the signature enforces
	Description *string `json:"description,omitempty"`

	// Describes the list of destination ports related to this signature
	DestinationPorts []*string `json:"destinationPorts,omitempty"`

	// Describes in which direction signature is being enforced: 0 - Inbound, 1 - OutBound, 2 - Bidirectional
	Direction *FirewallPolicyIDPSSignatureDirection `json:"direction,omitempty"`

	// Describes the groups the signature belongs to
	Group *string `json:"group,omitempty"`

	// Describes if this override is inherited from base policy or not
	InheritedFromParentPolicy *bool `json:"inheritedFromParentPolicy,omitempty"`

	// Describes the last updated time of the signature (provided from 3rd party vendor)
	LastUpdated *string `json:"lastUpdated,omitempty"`

	// The current mode enforced, 0 - Disabled, 1 - Alert, 2 -Deny
	Mode *FirewallPolicyIDPSSignatureMode `json:"mode,omitempty"`

	// Describes the protocol the signatures is being enforced in
	Protocol *string `json:"protocol,omitempty"`

	// Describes the severity of signature: 1 - Low, 2 - Medium, 3 - High
	Severity *FirewallPolicyIDPSSignatureSeverity `json:"severity,omitempty"`

	// The ID of the signature
	SignatureID *int32 `json:"signatureId,omitempty"`

	// Describes the list of source ports related to this signature
	SourcePorts []*string `json:"sourcePorts,omitempty"`
}

// StaticMember Item.
type StaticMember struct {
	// The Static Member properties
	Properties *StaticMemberProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StaticMemberListResult - Result of the request to list StaticMember. It contains a list of groups and a URL link to get
// the next set of results.
type StaticMemberListResult struct {
	// Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets a page of StaticMember
	Value []*StaticMember `json:"value,omitempty"`
}

// StaticMemberProperties - Properties of static member.
type StaticMemberProperties struct {
	// Resource Id.
	ResourceID *string `json:"resourceId,omitempty"`

	// READ-ONLY; The provisioning state of the scope assignment resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Resource region.
	Region *string `json:"region,omitempty" azure:"ro"`
}

// StaticMembersClientCreateOrUpdateOptions contains the optional parameters for the StaticMembersClient.CreateOrUpdate method.
type StaticMembersClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// StaticMembersClientDeleteOptions contains the optional parameters for the StaticMembersClient.Delete method.
type StaticMembersClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// StaticMembersClientGetOptions contains the optional parameters for the StaticMembersClient.Get method.
type StaticMembersClientGetOptions struct {
	// placeholder for future optional parameters
}

// StaticMembersClientListOptions contains the optional parameters for the StaticMembersClient.List method.
type StaticMembersClientListOptions struct {
	// SkipToken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skipToken parameter that
	// specifies a starting point to use for subsequent calls.
	SkipToken *string
	// An optional query parameter which specifies the maximum number of records to be returned by the server.
	Top *int32
}

// StaticRoute - List of all Static Routes.
type StaticRoute struct {
	// List of all address prefixes.
	AddressPrefixes []*string `json:"addressPrefixes,omitempty"`

	// The name of the StaticRoute that is unique within a VnetRoute.
	Name *string `json:"name,omitempty"`

	// The ip address of the next hop.
	NextHopIPAddress *string `json:"nextHopIpAddress,omitempty"`
}

// SubResource - Reference to another subresource.
type SubResource struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`
}

// Subnet in a virtual network resource.
type Subnet struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the subnet.
	Properties *SubnetPropertiesFormat `json:"properties,omitempty"`

	// Resource type.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// SubnetAssociation - Subnet and it's custom security rules.
type SubnetAssociation struct {
	// Collection of custom security rules.
	SecurityRules []*SecurityRule `json:"securityRules,omitempty"`

	// READ-ONLY; Subnet ID.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// SubnetListResult - Response for ListSubnets API service callRetrieves all subnet that belongs to a virtual network.
type SubnetListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The subnets in a virtual network.
	Value []*Subnet `json:"value,omitempty"`
}

// SubnetPropertiesFormat - Properties of the subnet.
type SubnetPropertiesFormat struct {
	// The address prefix for the subnet.
	AddressPrefix *string `json:"addressPrefix,omitempty"`

	// List of address prefixes for the subnet.
	AddressPrefixes []*string `json:"addressPrefixes,omitempty"`

	// Application gateway IP configurations of virtual network resource.
	ApplicationGatewayIPConfigurations []*ApplicationGatewayIPConfiguration `json:"applicationGatewayIpConfigurations,omitempty"`

	// An array of references to the delegations on the subnet.
	Delegations []*Delegation `json:"delegations,omitempty"`

	// Array of IpAllocation which reference this subnet.
	IPAllocations []*SubResource `json:"ipAllocations,omitempty"`

	// Nat gateway associated with this subnet.
	NatGateway *SubResource `json:"natGateway,omitempty"`

	// The reference to the NetworkSecurityGroup resource.
	NetworkSecurityGroup *SecurityGroup `json:"networkSecurityGroup,omitempty"`

	// Enable or Disable apply network policies on private end point in the subnet.
	PrivateEndpointNetworkPolicies *VirtualNetworkPrivateEndpointNetworkPolicies `json:"privateEndpointNetworkPolicies,omitempty"`

	// Enable or Disable apply network policies on private link service in the subnet.
	PrivateLinkServiceNetworkPolicies *VirtualNetworkPrivateLinkServiceNetworkPolicies `json:"privateLinkServiceNetworkPolicies,omitempty"`

	// The reference to the RouteTable resource.
	RouteTable *RouteTable `json:"routeTable,omitempty"`

	// An array of service endpoint policies.
	ServiceEndpointPolicies []*ServiceEndpointPolicy `json:"serviceEndpointPolicies,omitempty"`

	// An array of service endpoints.
	ServiceEndpoints []*ServiceEndpointPropertiesFormat `json:"serviceEndpoints,omitempty"`

	// READ-ONLY; Array of IP configuration profiles which reference this subnet.
	IPConfigurationProfiles []*IPConfigurationProfile `json:"ipConfigurationProfiles,omitempty" azure:"ro"`

	// READ-ONLY; An array of references to the network interface IP configurations using subnet.
	IPConfigurations []*IPConfiguration `json:"ipConfigurations,omitempty" azure:"ro"`

	// READ-ONLY; An array of references to private endpoints.
	PrivateEndpoints []*PrivateEndpoint `json:"privateEndpoints,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the subnet resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; A read-only string identifying the intention of use for this subnet based on delegations and other user-defined
	// properties.
	Purpose *string `json:"purpose,omitempty" azure:"ro"`

	// READ-ONLY; An array of references to the external resources using subnet.
	ResourceNavigationLinks []*ResourceNavigationLink `json:"resourceNavigationLinks,omitempty" azure:"ro"`

	// READ-ONLY; An array of references to services injecting into this subnet.
	ServiceAssociationLinks []*ServiceAssociationLink `json:"serviceAssociationLinks,omitempty" azure:"ro"`
}

// SubnetsClientBeginCreateOrUpdateOptions contains the optional parameters for the SubnetsClient.BeginCreateOrUpdate method.
type SubnetsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SubnetsClientBeginDeleteOptions contains the optional parameters for the SubnetsClient.BeginDelete method.
type SubnetsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SubnetsClientBeginPrepareNetworkPoliciesOptions contains the optional parameters for the SubnetsClient.BeginPrepareNetworkPolicies
// method.
type SubnetsClientBeginPrepareNetworkPoliciesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SubnetsClientBeginUnprepareNetworkPoliciesOptions contains the optional parameters for the SubnetsClient.BeginUnprepareNetworkPolicies
// method.
type SubnetsClientBeginUnprepareNetworkPoliciesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SubnetsClientGetOptions contains the optional parameters for the SubnetsClient.Get method.
type SubnetsClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// SubnetsClientListOptions contains the optional parameters for the SubnetsClient.List method.
type SubnetsClientListOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionNetworkManagerConnectionsClientCreateOrUpdateOptions contains the optional parameters for the SubscriptionNetworkManagerConnectionsClient.CreateOrUpdate
// method.
type SubscriptionNetworkManagerConnectionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionNetworkManagerConnectionsClientDeleteOptions contains the optional parameters for the SubscriptionNetworkManagerConnectionsClient.Delete
// method.
type SubscriptionNetworkManagerConnectionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionNetworkManagerConnectionsClientGetOptions contains the optional parameters for the SubscriptionNetworkManagerConnectionsClient.Get
// method.
type SubscriptionNetworkManagerConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionNetworkManagerConnectionsClientListOptions contains the optional parameters for the SubscriptionNetworkManagerConnectionsClient.List
// method.
type SubscriptionNetworkManagerConnectionsClientListOptions struct {
	// SkipToken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skipToken parameter that
	// specifies a starting point to use for subsequent calls.
	SkipToken *string
	// An optional query parameter which specifies the maximum number of records to be returned by the server.
	Top *int32
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// Topology of the specified resource group.
type Topology struct {
	// A list of topology resources.
	Resources []*TopologyResource `json:"resources,omitempty"`

	// READ-ONLY; The datetime when the topology was initially created for the resource group.
	CreatedDateTime *time.Time `json:"createdDateTime,omitempty" azure:"ro"`

	// READ-ONLY; GUID representing the operation id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The datetime when the topology was last modified.
	LastModified *time.Time `json:"lastModified,omitempty" azure:"ro"`
}

// TopologyAssociation - Resources that have an association with the parent resource.
type TopologyAssociation struct {
	// The association type of the child resource to the parent resource.
	AssociationType *AssociationType `json:"associationType,omitempty"`

	// The name of the resource that is associated with the parent resource.
	Name *string `json:"name,omitempty"`

	// The ID of the resource that is associated with the parent resource.
	ResourceID *string `json:"resourceId,omitempty"`
}

// TopologyParameters - Parameters that define the representation of topology.
type TopologyParameters struct {
	// The name of the target resource group to perform topology on.
	TargetResourceGroupName *string `json:"targetResourceGroupName,omitempty"`

	// The reference to the Subnet resource.
	TargetSubnet *SubResource `json:"targetSubnet,omitempty"`

	// The reference to the Virtual Network resource.
	TargetVirtualNetwork *SubResource `json:"targetVirtualNetwork,omitempty"`
}

// TopologyResource - The network resource topology information for the given resource group.
type TopologyResource struct {
	// Holds the associations the resource has with other resources in the resource group.
	Associations []*TopologyAssociation `json:"associations,omitempty"`

	// ID of the resource.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Name of the resource.
	Name *string `json:"name,omitempty"`
}

// TrafficAnalyticsConfigurationProperties - Parameters that define the configuration of traffic analytics.
type TrafficAnalyticsConfigurationProperties struct {
	// Flag to enable/disable traffic analytics.
	Enabled *bool `json:"enabled,omitempty"`

	// The interval in minutes which would decide how frequently TA service should do flow analytics.
	TrafficAnalyticsInterval *int32 `json:"trafficAnalyticsInterval,omitempty"`

	// The resource guid of the attached workspace.
	WorkspaceID *string `json:"workspaceId,omitempty"`

	// The location of the attached workspace.
	WorkspaceRegion *string `json:"workspaceRegion,omitempty"`

	// Resource Id of the attached workspace.
	WorkspaceResourceID *string `json:"workspaceResourceId,omitempty"`
}

// TrafficAnalyticsProperties - Parameters that define the configuration of traffic analytics.
type TrafficAnalyticsProperties struct {
	// Parameters that define the configuration of traffic analytics.
	NetworkWatcherFlowAnalyticsConfiguration *TrafficAnalyticsConfigurationProperties `json:"networkWatcherFlowAnalyticsConfiguration,omitempty"`
}

// TrafficSelectorPolicy - An traffic selector policy for a virtual network gateway connection.
type TrafficSelectorPolicy struct {
	// REQUIRED; A collection of local address spaces in CIDR format.
	LocalAddressRanges []*string `json:"localAddressRanges,omitempty"`

	// REQUIRED; A collection of remote address spaces in CIDR format.
	RemoteAddressRanges []*string `json:"remoteAddressRanges,omitempty"`
}

// TroubleshootingDetails - Information gained from troubleshooting of specified resource.
type TroubleshootingDetails struct {
	// Details on troubleshooting results.
	Detail *string `json:"detail,omitempty"`

	// The id of the get troubleshoot operation.
	ID *string `json:"id,omitempty"`

	// Reason type of failure.
	ReasonType *string `json:"reasonType,omitempty"`

	// List of recommended actions.
	RecommendedActions []*TroubleshootingRecommendedActions `json:"recommendedActions,omitempty"`

	// A summary of troubleshooting.
	Summary *string `json:"summary,omitempty"`
}

// TroubleshootingParameters - Parameters that define the resource to troubleshoot.
type TroubleshootingParameters struct {
	// REQUIRED; Properties of the troubleshooting resource.
	Properties *TroubleshootingProperties `json:"properties,omitempty"`

	// REQUIRED; The target resource to troubleshoot.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// TroubleshootingProperties - Storage location provided for troubleshoot.
type TroubleshootingProperties struct {
	// REQUIRED; The ID for the storage account to save the troubleshoot result.
	StorageID *string `json:"storageId,omitempty"`

	// REQUIRED; The path to the blob to save the troubleshoot result in.
	StoragePath *string `json:"storagePath,omitempty"`
}

// TroubleshootingRecommendedActions - Recommended actions based on discovered issues.
type TroubleshootingRecommendedActions struct {
	// ID of the recommended action.
	ActionID *string `json:"actionId,omitempty"`

	// Description of recommended actions.
	ActionText *string `json:"actionText,omitempty"`

	// The uri linking to a documentation for the recommended troubleshooting actions.
	ActionURI *string `json:"actionUri,omitempty"`

	// The information from the URI for the recommended troubleshooting actions.
	ActionURIText *string `json:"actionUriText,omitempty"`
}

// TroubleshootingResult - Troubleshooting information gained from specified resource.
type TroubleshootingResult struct {
	// The result code of the troubleshooting.
	Code *string `json:"code,omitempty"`

	// The end time of the troubleshooting.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Information from troubleshooting.
	Results []*TroubleshootingDetails `json:"results,omitempty"`

	// The start time of the troubleshooting.
	StartTime *time.Time `json:"startTime,omitempty"`
}

// TunnelConnectionHealth - VirtualNetworkGatewayConnection properties.
type TunnelConnectionHealth struct {
	// READ-ONLY; Virtual Network Gateway connection status.
	ConnectionStatus *VirtualNetworkGatewayConnectionStatus `json:"connectionStatus,omitempty" azure:"ro"`

	// READ-ONLY; The Egress Bytes Transferred in this connection.
	EgressBytesTransferred *int64 `json:"egressBytesTransferred,omitempty" azure:"ro"`

	// READ-ONLY; The Ingress Bytes Transferred in this connection.
	IngressBytesTransferred *int64 `json:"ingressBytesTransferred,omitempty" azure:"ro"`

	// READ-ONLY; The time at which connection was established in Utc format.
	LastConnectionEstablishedUTCTime *string `json:"lastConnectionEstablishedUtcTime,omitempty" azure:"ro"`

	// READ-ONLY; Tunnel name.
	Tunnel *string `json:"tunnel,omitempty" azure:"ro"`
}

// UnprepareNetworkPoliciesRequest - Details of UnprepareNetworkPolicies for Subnet.
type UnprepareNetworkPoliciesRequest struct {
	// The name of the service for which subnet is being unprepared for.
	ServiceName *string `json:"serviceName,omitempty"`
}

// Usage - The network resource usage.
type Usage struct {
	// REQUIRED; The current value of the usage.
	CurrentValue *int64 `json:"currentValue,omitempty"`

	// REQUIRED; The limit of usage.
	Limit *int64 `json:"limit,omitempty"`

	// REQUIRED; The name of the type of usage.
	Name *UsageName `json:"name,omitempty"`

	// REQUIRED; An enum describing the unit of measurement.
	Unit *UsageUnit `json:"unit,omitempty"`

	// READ-ONLY; Resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// UsageName - The usage names.
type UsageName struct {
	// A localized string describing the resource name.
	LocalizedValue *string `json:"localizedValue,omitempty"`

	// A string describing the resource name.
	Value *string `json:"value,omitempty"`
}

// UsagesClientListOptions contains the optional parameters for the UsagesClient.List method.
type UsagesClientListOptions struct {
	// placeholder for future optional parameters
}

// UsagesListResult - The list usages operation response.
type UsagesListResult struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The list network resource usages.
	Value []*Usage `json:"value,omitempty"`
}

// VM - Describes a Virtual Machine.
type VM struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VPNClientConfiguration - VpnClientConfiguration for P2S client.
type VPNClientConfiguration struct {
	// The AADAudience property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
	AADAudience *string `json:"aadAudience,omitempty"`

	// The AADIssuer property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
	AADIssuer *string `json:"aadIssuer,omitempty"`

	// The AADTenant property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
	AADTenant *string `json:"aadTenant,omitempty"`

	// The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
	RadiusServerAddress *string `json:"radiusServerAddress,omitempty"`

	// The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
	RadiusServerSecret *string `json:"radiusServerSecret,omitempty"`

	// The radiusServers property for multiple radius server configuration.
	RadiusServers []*RadiusServer `json:"radiusServers,omitempty"`

	// VPN authentication types for the virtual network gateway..
	VPNAuthenticationTypes []*VPNAuthenticationType `json:"vpnAuthenticationTypes,omitempty"`

	// The reference to the address space resource which represents Address space for P2S VpnClient.
	VPNClientAddressPool *AddressSpace `json:"vpnClientAddressPool,omitempty"`

	// VpnClientIpsecPolicies for virtual network gateway P2S client.
	VPNClientIPSecPolicies []*IPSecPolicy `json:"vpnClientIpsecPolicies,omitempty"`

	// VpnClientProtocols for Virtual network gateway.
	VPNClientProtocols []*VPNClientProtocol `json:"vpnClientProtocols,omitempty"`

	// VpnClientRevokedCertificate for Virtual network gateway.
	VPNClientRevokedCertificates []*VPNClientRevokedCertificate `json:"vpnClientRevokedCertificates,omitempty"`

	// VpnClientRootCertificate for virtual network gateway.
	VPNClientRootCertificates []*VPNClientRootCertificate `json:"vpnClientRootCertificates,omitempty"`
}

// VPNClientConnectionHealth - VpnClientConnectionHealth properties.
type VPNClientConnectionHealth struct {
	// List of allocated ip addresses to the connected p2s vpn clients.
	AllocatedIPAddresses []*string `json:"allocatedIpAddresses,omitempty"`

	// The total of p2s vpn clients connected at this time to this P2SVpnGateway.
	VPNClientConnectionsCount *int32 `json:"vpnClientConnectionsCount,omitempty"`

	// READ-ONLY; Total of the Egress Bytes Transferred in this connection.
	TotalEgressBytesTransferred *int64 `json:"totalEgressBytesTransferred,omitempty" azure:"ro"`

	// READ-ONLY; Total of the Ingress Bytes Transferred in this P2S Vpn connection.
	TotalIngressBytesTransferred *int64 `json:"totalIngressBytesTransferred,omitempty" azure:"ro"`
}

// VPNClientConnectionHealthDetail - VPN client connection health detail.
type VPNClientConnectionHealthDetail struct {
	// READ-ONLY; The egress bytes per second.
	EgressBytesTransferred *int64 `json:"egressBytesTransferred,omitempty" azure:"ro"`

	// READ-ONLY; The egress packets per second.
	EgressPacketsTransferred *int64 `json:"egressPacketsTransferred,omitempty" azure:"ro"`

	// READ-ONLY; The ingress bytes per second.
	IngressBytesTransferred *int64 `json:"ingressBytesTransferred,omitempty" azure:"ro"`

	// READ-ONLY; The ingress packets per second.
	IngressPacketsTransferred *int64 `json:"ingressPacketsTransferred,omitempty" azure:"ro"`

	// READ-ONLY; The max band width.
	MaxBandwidth *int64 `json:"maxBandwidth,omitempty" azure:"ro"`

	// READ-ONLY; The max packets transferred per second.
	MaxPacketsPerSecond *int64 `json:"maxPacketsPerSecond,omitempty" azure:"ro"`

	// READ-ONLY; The assigned private Ip of a connected vpn client.
	PrivateIPAddress *string `json:"privateIpAddress,omitempty" azure:"ro"`

	// READ-ONLY; The public Ip of a connected vpn client.
	PublicIPAddress *string `json:"publicIpAddress,omitempty" azure:"ro"`

	// READ-ONLY; The duration time of a connected vpn client.
	VPNConnectionDuration *int64 `json:"vpnConnectionDuration,omitempty" azure:"ro"`

	// READ-ONLY; The vpn client Id.
	VPNConnectionID *string `json:"vpnConnectionId,omitempty" azure:"ro"`

	// READ-ONLY; The start time of a connected vpn client.
	VPNConnectionTime *string `json:"vpnConnectionTime,omitempty" azure:"ro"`

	// READ-ONLY; The user name of a connected vpn client.
	VPNUserName *string `json:"vpnUserName,omitempty" azure:"ro"`
}

// VPNClientConnectionHealthDetailListResult - List of virtual network gateway vpn client connection health.
type VPNClientConnectionHealthDetailListResult struct {
	// List of vpn client connection health.
	Value []*VPNClientConnectionHealthDetail `json:"value,omitempty"`
}

// VPNClientIPsecParameters - An IPSec parameters for a virtual network gateway P2S connection.
type VPNClientIPsecParameters struct {
	// REQUIRED; The DH Group used in IKE Phase 1 for initial SA.
	DhGroup *DhGroup `json:"dhGroup,omitempty"`

	// REQUIRED; The IPSec encryption algorithm (IKE phase 1).
	IPSecEncryption *IPSecEncryption `json:"ipsecEncryption,omitempty"`

	// REQUIRED; The IPSec integrity algorithm (IKE phase 1).
	IPSecIntegrity *IPSecIntegrity `json:"ipsecIntegrity,omitempty"`

	// REQUIRED; The IKE encryption algorithm (IKE phase 2).
	IkeEncryption *IkeEncryption `json:"ikeEncryption,omitempty"`

	// REQUIRED; The IKE integrity algorithm (IKE phase 2).
	IkeIntegrity *IkeIntegrity `json:"ikeIntegrity,omitempty"`

	// REQUIRED; The Pfs Group used in IKE Phase 2 for new child SA.
	PfsGroup *PfsGroup `json:"pfsGroup,omitempty"`

	// REQUIRED; The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for P2S client..
	SaDataSizeKilobytes *int32 `json:"saDataSizeKilobytes,omitempty"`

	// REQUIRED; The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for P2S client.
	SaLifeTimeSeconds *int32 `json:"saLifeTimeSeconds,omitempty"`
}

// VPNClientParameters - Vpn Client Parameters for package generation.
type VPNClientParameters struct {
	// VPN client authentication method.
	AuthenticationMethod *AuthenticationMethod `json:"authenticationMethod,omitempty"`

	// A list of client root certificates public certificate data encoded as Base-64 strings. Optional parameter for external
	// radius based authentication with EAPTLS.
	ClientRootCertificates []*string `json:"clientRootCertificates,omitempty"`

	// VPN client Processor Architecture.
	ProcessorArchitecture *ProcessorArchitecture `json:"processorArchitecture,omitempty"`

	// The public certificate data for the radius server authentication certificate as a Base-64 encoded string. Required only
	// if external radius authentication has been configured with EAPTLS
	// authentication.
	RadiusServerAuthCertificate *string `json:"radiusServerAuthCertificate,omitempty"`
}

// VPNClientRevokedCertificate - VPN client revoked certificate of virtual network gateway.
type VPNClientRevokedCertificate struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the vpn client revoked certificate.
	Properties *VPNClientRevokedCertificatePropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// VPNClientRevokedCertificatePropertiesFormat - Properties of the revoked VPN client certificate of virtual network gateway.
type VPNClientRevokedCertificatePropertiesFormat struct {
	// The revoked VPN client certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`

	// READ-ONLY; The provisioning state of the VPN client revoked certificate resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// VPNClientRootCertificate - VPN client root certificate of virtual network gateway.
type VPNClientRootCertificate struct {
	// REQUIRED; Properties of the vpn client root certificate.
	Properties *VPNClientRootCertificatePropertiesFormat `json:"properties,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// VPNClientRootCertificatePropertiesFormat - Properties of SSL certificates of application gateway.
type VPNClientRootCertificatePropertiesFormat struct {
	// REQUIRED; The certificate public data.
	PublicCertData *string `json:"publicCertData,omitempty"`

	// READ-ONLY; The provisioning state of the VPN client root certificate resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// VPNConnection - VpnConnection Resource.
type VPNConnection struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the VPN connection.
	Properties *VPNConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// VPNConnectionPacketCaptureStartParameters - Vpn Connection packet capture parameters supplied to start packet capture on
// gateway connection.
type VPNConnectionPacketCaptureStartParameters struct {
	// Start Packet capture parameters on vpn connection.
	FilterData *string `json:"filterData,omitempty"`

	// List of site link connection names.
	LinkConnectionNames []*string `json:"linkConnectionNames,omitempty"`
}

// VPNConnectionPacketCaptureStopParameters - Vpn Connection packet capture parameters supplied to stop packet capture on
// gateway connection.
type VPNConnectionPacketCaptureStopParameters struct {
	// List of site link connection names.
	LinkConnectionNames []*string `json:"linkConnectionNames,omitempty"`

	// SAS url for packet capture on vpn connection.
	SasURL *string `json:"sasUrl,omitempty"`
}

// VPNConnectionProperties - Parameters for VpnConnection.
type VPNConnectionProperties struct {
	// Expected bandwidth in MBPS.
	ConnectionBandwidth *int32 `json:"connectionBandwidth,omitempty"`

	// DPD timeout in seconds for vpn connection.
	DpdTimeoutSeconds *int32 `json:"dpdTimeoutSeconds,omitempty"`

	// EnableBgp flag.
	EnableBgp *bool `json:"enableBgp,omitempty"`

	// Enable internet security.
	EnableInternetSecurity *bool `json:"enableInternetSecurity,omitempty"`

	// EnableBgp flag.
	EnableRateLimiting *bool `json:"enableRateLimiting,omitempty"`

	// The IPSec Policies to be considered by this connection.
	IPSecPolicies []*IPSecPolicy `json:"ipsecPolicies,omitempty"`

	// Id of the connected vpn site.
	RemoteVPNSite *SubResource `json:"remoteVpnSite,omitempty"`

	// The Routing Configuration indicating the associated and propagated route tables on this connection.
	RoutingConfiguration *RoutingConfiguration `json:"routingConfiguration,omitempty"`

	// Routing weight for vpn connection.
	RoutingWeight *int32 `json:"routingWeight,omitempty"`

	// SharedKey for the vpn connection.
	SharedKey *string `json:"sharedKey,omitempty"`

	// The Traffic Selector Policies to be considered by this connection.
	TrafficSelectorPolicies []*TrafficSelectorPolicy `json:"trafficSelectorPolicies,omitempty"`

	// Use local azure ip to initiate connection.
	UseLocalAzureIPAddress *bool `json:"useLocalAzureIpAddress,omitempty"`

	// Enable policy-based traffic selectors.
	UsePolicyBasedTrafficSelectors *bool `json:"usePolicyBasedTrafficSelectors,omitempty"`

	// Connection protocol used for this connection.
	VPNConnectionProtocolType *VirtualNetworkGatewayConnectionProtocol `json:"vpnConnectionProtocolType,omitempty"`

	// List of all vpn site link connections to the gateway.
	VPNLinkConnections []*VPNSiteLinkConnection `json:"vpnLinkConnections,omitempty"`

	// READ-ONLY; The connection status.
	ConnectionStatus *VPNConnectionStatus `json:"connectionStatus,omitempty" azure:"ro"`

	// READ-ONLY; Egress bytes transferred.
	EgressBytesTransferred *int64 `json:"egressBytesTransferred,omitempty" azure:"ro"`

	// READ-ONLY; Ingress bytes transferred.
	IngressBytesTransferred *int64 `json:"ingressBytesTransferred,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the VPN connection resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// VPNConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the VPNConnectionsClient.BeginCreateOrUpdate
// method.
type VPNConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VPNConnectionsClientBeginDeleteOptions contains the optional parameters for the VPNConnectionsClient.BeginDelete method.
type VPNConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VPNConnectionsClientBeginStartPacketCaptureOptions contains the optional parameters for the VPNConnectionsClient.BeginStartPacketCapture
// method.
type VPNConnectionsClientBeginStartPacketCaptureOptions struct {
	// Vpn Connection packet capture parameters supplied to start packet capture on gateway connection.
	Parameters *VPNConnectionPacketCaptureStartParameters
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VPNConnectionsClientBeginStopPacketCaptureOptions contains the optional parameters for the VPNConnectionsClient.BeginStopPacketCapture
// method.
type VPNConnectionsClientBeginStopPacketCaptureOptions struct {
	// Vpn Connection packet capture parameters supplied to stop packet capture on gateway connection.
	Parameters *VPNConnectionPacketCaptureStopParameters
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VPNConnectionsClientGetOptions contains the optional parameters for the VPNConnectionsClient.Get method.
type VPNConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VPNConnectionsClientListByVPNGatewayOptions contains the optional parameters for the VPNConnectionsClient.ListByVPNGateway
// method.
type VPNConnectionsClientListByVPNGatewayOptions struct {
	// placeholder for future optional parameters
}

// VPNDeviceScriptParameters - Vpn device configuration script generation parameters.
type VPNDeviceScriptParameters struct {
	// The device family for the vpn device.
	DeviceFamily *string `json:"deviceFamily,omitempty"`

	// The firmware version for the vpn device.
	FirmwareVersion *string `json:"firmwareVersion,omitempty"`

	// The vendor for the vpn device.
	Vendor *string `json:"vendor,omitempty"`
}

// VPNGateway - VpnGateway Resource.
type VPNGateway struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the VPN gateway.
	Properties *VPNGatewayProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VPNGatewayIPConfiguration - IP Configuration of a VPN Gateway Resource.
type VPNGatewayIPConfiguration struct {
	// The identifier of the IP configuration for a VPN Gateway.
	ID *string `json:"id,omitempty"`

	// The private IP address of this IP configuration.
	PrivateIPAddress *string `json:"privateIpAddress,omitempty"`

	// The public IP address of this IP configuration.
	PublicIPAddress *string `json:"publicIpAddress,omitempty"`
}

// VPNGatewayNatRule - VpnGatewayNatRule Resource.
type VPNGatewayNatRule struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the VpnGateway NAT rule.
	Properties *VPNGatewayNatRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VPNGatewayNatRuleProperties - Parameters for VpnGatewayNatRule.
type VPNGatewayNatRuleProperties struct {
	// The private IP address external mapping for NAT.
	ExternalMappings []*VPNNatRuleMapping `json:"externalMappings,omitempty"`

	// The IP Configuration ID this NAT rule applies to.
	IPConfigurationID *string `json:"ipConfigurationId,omitempty"`

	// The private IP address internal mapping for NAT.
	InternalMappings []*VPNNatRuleMapping `json:"internalMappings,omitempty"`

	// The Source NAT direction of a VPN NAT.
	Mode *VPNNatRuleMode `json:"mode,omitempty"`

	// The type of NAT rule for VPN NAT.
	Type *VPNNatRuleType `json:"type,omitempty"`

	// READ-ONLY; List of egress VpnSiteLinkConnections.
	EgressVPNSiteLinkConnections []*SubResource `json:"egressVpnSiteLinkConnections,omitempty" azure:"ro"`

	// READ-ONLY; List of ingress VpnSiteLinkConnections.
	IngressVPNSiteLinkConnections []*SubResource `json:"ingressVpnSiteLinkConnections,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the NAT Rule resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// VPNGatewayPacketCaptureStartParameters - Start packet capture parameters.
type VPNGatewayPacketCaptureStartParameters struct {
	// Start Packet capture parameters on vpn gateway.
	FilterData *string `json:"filterData,omitempty"`
}

// VPNGatewayPacketCaptureStopParameters - Stop packet capture parameters.
type VPNGatewayPacketCaptureStopParameters struct {
	// SAS url for packet capture on vpn gateway.
	SasURL *string `json:"sasUrl,omitempty"`
}

// VPNGatewayProperties - Parameters for VpnGateway.
type VPNGatewayProperties struct {
	// Local network gateway's BGP speaker settings.
	BgpSettings *BgpSettings `json:"bgpSettings,omitempty"`

	// List of all vpn connections to the gateway.
	Connections []*VPNConnection `json:"connections,omitempty"`

	// Enable BGP routes translation for NAT on this VpnGateway.
	EnableBgpRouteTranslationForNat *bool `json:"enableBgpRouteTranslationForNat,omitempty"`

	// Enable Routing Preference property for the Public IP Interface of the VpnGateway.
	IsRoutingPreferenceInternet *bool `json:"isRoutingPreferenceInternet,omitempty"`

	// List of all the nat Rules associated with the gateway.
	NatRules []*VPNGatewayNatRule `json:"natRules,omitempty"`

	// The scale unit for this vpn gateway.
	VPNGatewayScaleUnit *int32 `json:"vpnGatewayScaleUnit,omitempty"`

	// The VirtualHub to which the gateway belongs.
	VirtualHub *SubResource `json:"virtualHub,omitempty"`

	// READ-ONLY; List of all IPs configured on the gateway.
	IPConfigurations []*VPNGatewayIPConfiguration `json:"ipConfigurations,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the VPN gateway resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// VPNGatewaysClientBeginCreateOrUpdateOptions contains the optional parameters for the VPNGatewaysClient.BeginCreateOrUpdate
// method.
type VPNGatewaysClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VPNGatewaysClientBeginDeleteOptions contains the optional parameters for the VPNGatewaysClient.BeginDelete method.
type VPNGatewaysClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VPNGatewaysClientBeginResetOptions contains the optional parameters for the VPNGatewaysClient.BeginReset method.
type VPNGatewaysClientBeginResetOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VPNGatewaysClientBeginStartPacketCaptureOptions contains the optional parameters for the VPNGatewaysClient.BeginStartPacketCapture
// method.
type VPNGatewaysClientBeginStartPacketCaptureOptions struct {
	// Vpn gateway packet capture parameters supplied to start packet capture on vpn gateway.
	Parameters *VPNGatewayPacketCaptureStartParameters
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VPNGatewaysClientBeginStopPacketCaptureOptions contains the optional parameters for the VPNGatewaysClient.BeginStopPacketCapture
// method.
type VPNGatewaysClientBeginStopPacketCaptureOptions struct {
	// Vpn gateway packet capture parameters supplied to stop packet capture on vpn gateway.
	Parameters *VPNGatewayPacketCaptureStopParameters
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VPNGatewaysClientBeginUpdateTagsOptions contains the optional parameters for the VPNGatewaysClient.BeginUpdateTags method.
type VPNGatewaysClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VPNGatewaysClientGetOptions contains the optional parameters for the VPNGatewaysClient.Get method.
type VPNGatewaysClientGetOptions struct {
	// placeholder for future optional parameters
}

// VPNGatewaysClientListByResourceGroupOptions contains the optional parameters for the VPNGatewaysClient.ListByResourceGroup
// method.
type VPNGatewaysClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VPNGatewaysClientListOptions contains the optional parameters for the VPNGatewaysClient.List method.
type VPNGatewaysClientListOptions struct {
	// placeholder for future optional parameters
}

// VPNLinkBgpSettings - BGP settings details for a link.
type VPNLinkBgpSettings struct {
	// The BGP speaker's ASN.
	Asn *int64 `json:"asn,omitempty"`

	// The BGP peering address and BGP identifier of this BGP speaker.
	BgpPeeringAddress *string `json:"bgpPeeringAddress,omitempty"`
}

// VPNLinkConnectionsClientBeginGetIkeSasOptions contains the optional parameters for the VPNLinkConnectionsClient.BeginGetIkeSas
// method.
type VPNLinkConnectionsClientBeginGetIkeSasOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VPNLinkConnectionsClientBeginResetConnectionOptions contains the optional parameters for the VPNLinkConnectionsClient.BeginResetConnection
// method.
type VPNLinkConnectionsClientBeginResetConnectionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VPNLinkConnectionsClientListByVPNConnectionOptions contains the optional parameters for the VPNLinkConnectionsClient.ListByVPNConnection
// method.
type VPNLinkConnectionsClientListByVPNConnectionOptions struct {
	// placeholder for future optional parameters
}

// VPNLinkProviderProperties - List of properties of a link provider.
type VPNLinkProviderProperties struct {
	// Name of the link provider.
	LinkProviderName *string `json:"linkProviderName,omitempty"`

	// Link speed.
	LinkSpeedInMbps *int32 `json:"linkSpeedInMbps,omitempty"`
}

// VPNNatRuleMapping - Vpn NatRule mapping.
type VPNNatRuleMapping struct {
	// Address space for Vpn NatRule mapping.
	AddressSpace *string `json:"addressSpace,omitempty"`

	// Port range for Vpn NatRule mapping.
	PortRange *string `json:"portRange,omitempty"`
}

// VPNPacketCaptureStartParameters - Start packet capture parameters on virtual network gateway.
type VPNPacketCaptureStartParameters struct {
	// Start Packet capture parameters.
	FilterData *string `json:"filterData,omitempty"`
}

// VPNPacketCaptureStopParameters - Stop packet capture parameters.
type VPNPacketCaptureStopParameters struct {
	// SAS url for packet capture on virtual network gateway.
	SasURL *string `json:"sasUrl,omitempty"`
}

// VPNProfileResponse - Vpn Profile Response for package generation.
type VPNProfileResponse struct {
	// URL to the VPN profile.
	ProfileURL *string `json:"profileUrl,omitempty"`
}

// VPNServerConfigRadiusClientRootCertificate - Properties of the Radius client root certificate of VpnServerConfiguration.
type VPNServerConfigRadiusClientRootCertificate struct {
	// The certificate name.
	Name *string `json:"name,omitempty"`

	// The Radius client root certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// VPNServerConfigRadiusServerRootCertificate - Properties of Radius Server root certificate of VpnServerConfiguration.
type VPNServerConfigRadiusServerRootCertificate struct {
	// The certificate name.
	Name *string `json:"name,omitempty"`

	// The certificate public data.
	PublicCertData *string `json:"publicCertData,omitempty"`
}

// VPNServerConfigVPNClientRevokedCertificate - Properties of the revoked VPN client certificate of VpnServerConfiguration.
type VPNServerConfigVPNClientRevokedCertificate struct {
	// The certificate name.
	Name *string `json:"name,omitempty"`

	// The revoked VPN client certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// VPNServerConfigVPNClientRootCertificate - Properties of VPN client root certificate of VpnServerConfiguration.
type VPNServerConfigVPNClientRootCertificate struct {
	// The certificate name.
	Name *string `json:"name,omitempty"`

	// The certificate public data.
	PublicCertData *string `json:"publicCertData,omitempty"`
}

// VPNServerConfiguration - VpnServerConfiguration Resource.
type VPNServerConfiguration struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the P2SVpnServer configuration.
	Properties *VPNServerConfigurationProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VPNServerConfigurationPolicyGroup - VpnServerConfigurationPolicyGroup Resource.
type VPNServerConfigurationPolicyGroup struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the VpnServerConfigurationPolicyGroup.
	Properties *VPNServerConfigurationPolicyGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VPNServerConfigurationPolicyGroupMember - VpnServerConfiguration PolicyGroup member
type VPNServerConfigurationPolicyGroupMember struct {
	// The Vpn Policy member attribute type.
	AttributeType *VPNPolicyMemberAttributeType `json:"attributeType,omitempty"`

	// The value of Attribute used for this VpnServerConfigurationPolicyGroupMember.
	AttributeValue *string `json:"attributeValue,omitempty"`

	// Name of the VpnServerConfigurationPolicyGroupMember.
	Name *string `json:"name,omitempty"`
}

// VPNServerConfigurationPolicyGroupProperties - Parameters for VpnServerConfigurationPolicyGroup.
type VPNServerConfigurationPolicyGroupProperties struct {
	// Shows if this is a Default VpnServerConfigurationPolicyGroup or not.
	IsDefault *bool `json:"isDefault,omitempty"`

	// Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
	PolicyMembers []*VPNServerConfigurationPolicyGroupMember `json:"policyMembers,omitempty"`

	// Priority for VpnServerConfigurationPolicyGroup.
	Priority *int32 `json:"priority,omitempty"`

	// READ-ONLY; List of references to P2SConnectionConfigurations.
	P2SConnectionConfigurations []*SubResource `json:"p2SConnectionConfigurations,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the VpnServerConfigurationPolicyGroup resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// VPNServerConfigurationProperties - Parameters for VpnServerConfiguration.
type VPNServerConfigurationProperties struct {
	// The set of aad vpn authentication parameters.
	AADAuthenticationParameters *AADAuthenticationParameters `json:"aadAuthenticationParameters,omitempty"`

	// List of all VpnServerConfigurationPolicyGroups.
	ConfigurationPolicyGroups []*VPNServerConfigurationPolicyGroup `json:"configurationPolicyGroups,omitempty"`

	// The name of the VpnServerConfiguration that is unique within a resource group.
	Name *string `json:"name,omitempty"`

	// Radius client root certificate of VpnServerConfiguration.
	RadiusClientRootCertificates []*VPNServerConfigRadiusClientRootCertificate `json:"radiusClientRootCertificates,omitempty"`

	// The radius server address property of the VpnServerConfiguration resource for point to site client connection.
	RadiusServerAddress *string `json:"radiusServerAddress,omitempty"`

	// Radius Server root certificate of VpnServerConfiguration.
	RadiusServerRootCertificates []*VPNServerConfigRadiusServerRootCertificate `json:"radiusServerRootCertificates,omitempty"`

	// The radius secret property of the VpnServerConfiguration resource for point to site client connection.
	RadiusServerSecret *string `json:"radiusServerSecret,omitempty"`

	// Multiple Radius Server configuration for VpnServerConfiguration.
	RadiusServers []*RadiusServer `json:"radiusServers,omitempty"`

	// VPN authentication types for the VpnServerConfiguration.
	VPNAuthenticationTypes []*VPNAuthenticationType `json:"vpnAuthenticationTypes,omitempty"`

	// VpnClientIpsecPolicies for VpnServerConfiguration.
	VPNClientIPSecPolicies []*IPSecPolicy `json:"vpnClientIpsecPolicies,omitempty"`

	// VPN client revoked certificate of VpnServerConfiguration.
	VPNClientRevokedCertificates []*VPNServerConfigVPNClientRevokedCertificate `json:"vpnClientRevokedCertificates,omitempty"`

	// VPN client root certificate of VpnServerConfiguration.
	VPNClientRootCertificates []*VPNServerConfigVPNClientRootCertificate `json:"vpnClientRootCertificates,omitempty"`

	// VPN protocols for the VpnServerConfiguration.
	VPNProtocols []*VPNGatewayTunnelingProtocol `json:"vpnProtocols,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; List of references to P2SVpnGateways.
	P2SVPNGateways []*P2SVPNGateway `json:"p2SVpnGateways,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the VpnServerConfiguration resource. Possible values are: 'Updating', 'Deleting',
	// and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// VPNServerConfigurationsAssociatedWithVirtualWanClientBeginListOptions contains the optional parameters for the VPNServerConfigurationsAssociatedWithVirtualWanClient.BeginList
// method.
type VPNServerConfigurationsAssociatedWithVirtualWanClientBeginListOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VPNServerConfigurationsClientBeginCreateOrUpdateOptions contains the optional parameters for the VPNServerConfigurationsClient.BeginCreateOrUpdate
// method.
type VPNServerConfigurationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VPNServerConfigurationsClientBeginDeleteOptions contains the optional parameters for the VPNServerConfigurationsClient.BeginDelete
// method.
type VPNServerConfigurationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VPNServerConfigurationsClientGetOptions contains the optional parameters for the VPNServerConfigurationsClient.Get method.
type VPNServerConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VPNServerConfigurationsClientListByResourceGroupOptions contains the optional parameters for the VPNServerConfigurationsClient.ListByResourceGroup
// method.
type VPNServerConfigurationsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VPNServerConfigurationsClientListOptions contains the optional parameters for the VPNServerConfigurationsClient.List method.
type VPNServerConfigurationsClientListOptions struct {
	// placeholder for future optional parameters
}

// VPNServerConfigurationsClientUpdateTagsOptions contains the optional parameters for the VPNServerConfigurationsClient.UpdateTags
// method.
type VPNServerConfigurationsClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// VPNServerConfigurationsResponse - VpnServerConfigurations list associated with VirtualWan Response.
type VPNServerConfigurationsResponse struct {
	// List of VpnServerConfigurations associated with VirtualWan.
	VPNServerConfigurationResourceIDs []*string `json:"vpnServerConfigurationResourceIds,omitempty"`
}

// VPNSite - VpnSite Resource.
type VPNSite struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the VPN site.
	Properties *VPNSiteProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VPNSiteID - VpnSite Resource.
type VPNSiteID struct {
	// READ-ONLY; The resource-uri of the vpn-site for which config is to be fetched.
	VPNSite *string `json:"vpnSite,omitempty" azure:"ro"`
}

// VPNSiteLink - VpnSiteLink Resource.
type VPNSiteLink struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the VPN site link.
	Properties *VPNSiteLinkProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VPNSiteLinkConnection - VpnSiteLinkConnection Resource.
type VPNSiteLinkConnection struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the VPN site link connection.
	Properties *VPNSiteLinkConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VPNSiteLinkConnectionProperties - Parameters for VpnConnection.
type VPNSiteLinkConnectionProperties struct {
	// Expected bandwidth in MBPS.
	ConnectionBandwidth *int32 `json:"connectionBandwidth,omitempty"`

	// List of egress NatRules.
	EgressNatRules []*SubResource `json:"egressNatRules,omitempty"`

	// EnableBgp flag.
	EnableBgp *bool `json:"enableBgp,omitempty"`

	// EnableBgp flag.
	EnableRateLimiting *bool `json:"enableRateLimiting,omitempty"`

	// The IPSec Policies to be considered by this connection.
	IPSecPolicies []*IPSecPolicy `json:"ipsecPolicies,omitempty"`

	// List of ingress NatRules.
	IngressNatRules []*SubResource `json:"ingressNatRules,omitempty"`

	// Routing weight for vpn connection.
	RoutingWeight *int32 `json:"routingWeight,omitempty"`

	// SharedKey for the vpn connection.
	SharedKey *string `json:"sharedKey,omitempty"`

	// Use local azure ip to initiate connection.
	UseLocalAzureIPAddress *bool `json:"useLocalAzureIpAddress,omitempty"`

	// Enable policy-based traffic selectors.
	UsePolicyBasedTrafficSelectors *bool `json:"usePolicyBasedTrafficSelectors,omitempty"`

	// Connection protocol used for this connection.
	VPNConnectionProtocolType *VirtualNetworkGatewayConnectionProtocol `json:"vpnConnectionProtocolType,omitempty"`

	// vpnGatewayCustomBgpAddresses used by this connection.
	VPNGatewayCustomBgpAddresses []*GatewayCustomBgpIPAddressIPConfiguration `json:"vpnGatewayCustomBgpAddresses,omitempty"`

	// Vpn link connection mode.
	VPNLinkConnectionMode *VPNLinkConnectionMode `json:"vpnLinkConnectionMode,omitempty"`

	// Id of the connected vpn site link.
	VPNSiteLink *SubResource `json:"vpnSiteLink,omitempty"`

	// READ-ONLY; The connection status.
	ConnectionStatus *VPNConnectionStatus `json:"connectionStatus,omitempty" azure:"ro"`

	// READ-ONLY; Egress bytes transferred.
	EgressBytesTransferred *int64 `json:"egressBytesTransferred,omitempty" azure:"ro"`

	// READ-ONLY; Ingress bytes transferred.
	IngressBytesTransferred *int64 `json:"ingressBytesTransferred,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the VPN site link connection resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// VPNSiteLinkConnectionsClientGetOptions contains the optional parameters for the VPNSiteLinkConnectionsClient.Get method.
type VPNSiteLinkConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VPNSiteLinkProperties - Parameters for VpnSite.
type VPNSiteLinkProperties struct {
	// The set of bgp properties.
	BgpProperties *VPNLinkBgpSettings `json:"bgpProperties,omitempty"`

	// FQDN of vpn-site-link.
	Fqdn *string `json:"fqdn,omitempty"`

	// The ip-address for the vpn-site-link.
	IPAddress *string `json:"ipAddress,omitempty"`

	// The link provider properties.
	LinkProperties *VPNLinkProviderProperties `json:"linkProperties,omitempty"`

	// READ-ONLY; The provisioning state of the VPN site link resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// VPNSiteLinksClientGetOptions contains the optional parameters for the VPNSiteLinksClient.Get method.
type VPNSiteLinksClientGetOptions struct {
	// placeholder for future optional parameters
}

// VPNSiteLinksClientListByVPNSiteOptions contains the optional parameters for the VPNSiteLinksClient.ListByVPNSite method.
type VPNSiteLinksClientListByVPNSiteOptions struct {
	// placeholder for future optional parameters
}

// VPNSiteProperties - Parameters for VpnSite.
type VPNSiteProperties struct {
	// The AddressSpace that contains an array of IP address ranges.
	AddressSpace *AddressSpace `json:"addressSpace,omitempty"`

	// The set of bgp properties.
	BgpProperties *BgpSettings `json:"bgpProperties,omitempty"`

	// The device properties.
	DeviceProperties *DeviceProperties `json:"deviceProperties,omitempty"`

	// The ip-address for the vpn-site.
	IPAddress *string `json:"ipAddress,omitempty"`

	// IsSecuritySite flag.
	IsSecuritySite *bool `json:"isSecuritySite,omitempty"`

	// Office365 Policy.
	O365Policy *O365PolicyProperties `json:"o365Policy,omitempty"`

	// The key for vpn-site that can be used for connections.
	SiteKey *string `json:"siteKey,omitempty"`

	// List of all vpn site links.
	VPNSiteLinks []*VPNSiteLink `json:"vpnSiteLinks,omitempty"`

	// The VirtualWAN to which the vpnSite belongs.
	VirtualWan *SubResource `json:"virtualWan,omitempty"`

	// READ-ONLY; The provisioning state of the VPN site resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// VPNSitesClientBeginCreateOrUpdateOptions contains the optional parameters for the VPNSitesClient.BeginCreateOrUpdate method.
type VPNSitesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VPNSitesClientBeginDeleteOptions contains the optional parameters for the VPNSitesClient.BeginDelete method.
type VPNSitesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VPNSitesClientGetOptions contains the optional parameters for the VPNSitesClient.Get method.
type VPNSitesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VPNSitesClientListByResourceGroupOptions contains the optional parameters for the VPNSitesClient.ListByResourceGroup method.
type VPNSitesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VPNSitesClientListOptions contains the optional parameters for the VPNSitesClient.List method.
type VPNSitesClientListOptions struct {
	// placeholder for future optional parameters
}

// VPNSitesClientUpdateTagsOptions contains the optional parameters for the VPNSitesClient.UpdateTags method.
type VPNSitesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// VPNSitesConfigurationClientBeginDownloadOptions contains the optional parameters for the VPNSitesConfigurationClient.BeginDownload
// method.
type VPNSitesConfigurationClientBeginDownloadOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VerificationIPFlowParameters - Parameters that define the IP flow to be verified.
type VerificationIPFlowParameters struct {
	// REQUIRED; The direction of the packet represented as a 5-tuple.
	Direction *Direction `json:"direction,omitempty"`

	// REQUIRED; The local IP address. Acceptable values are valid IPv4 addresses.
	LocalIPAddress *string `json:"localIPAddress,omitempty"`

	// REQUIRED; The local port. Acceptable values are a single integer in the range (0-65535). Support for * for the source port,
	// which depends on the direction.
	LocalPort *string `json:"localPort,omitempty"`

	// REQUIRED; Protocol to be verified on.
	Protocol *IPFlowProtocol `json:"protocol,omitempty"`

	// REQUIRED; The remote IP address. Acceptable values are valid IPv4 addresses.
	RemoteIPAddress *string `json:"remoteIPAddress,omitempty"`

	// REQUIRED; The remote port. Acceptable values are a single integer in the range (0-65535). Support for * for the source
	// port, which depends on the direction.
	RemotePort *string `json:"remotePort,omitempty"`

	// REQUIRED; The ID of the target resource to perform next-hop on.
	TargetResourceID *string `json:"targetResourceId,omitempty"`

	// The NIC ID. (If VM has multiple NICs and IP forwarding is enabled on any of them, then this parameter must be specified.
	// Otherwise optional).
	TargetNicResourceID *string `json:"targetNicResourceId,omitempty"`
}

// VerificationIPFlowResult - Results of IP flow verification on the target resource.
type VerificationIPFlowResult struct {
	// Indicates whether the traffic is allowed or denied.
	Access *Access `json:"access,omitempty"`

	// Name of the rule. If input is not matched against any security rule, it is not displayed.
	RuleName *string `json:"ruleName,omitempty"`
}

// VirtualAppliance - NetworkVirtualAppliance Resource.
type VirtualAppliance struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The service principal that has read access to cloud-init and config blob.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the Network Virtual Appliance.
	Properties *VirtualAppliancePropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualApplianceListResult - Response for ListNetworkVirtualAppliances API service call.
type VirtualApplianceListResult struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Network Virtual Appliances.
	Value []*VirtualAppliance `json:"value,omitempty"`
}

// VirtualApplianceNicProperties - Network Virtual Appliance NIC properties.
type VirtualApplianceNicProperties struct {
	// READ-ONLY; NIC name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Private IP address.
	PrivateIPAddress *string `json:"privateIpAddress,omitempty" azure:"ro"`

	// READ-ONLY; Public IP address.
	PublicIPAddress *string `json:"publicIpAddress,omitempty" azure:"ro"`
}

// VirtualAppliancePropertiesFormat - Network Virtual Appliance definition.
type VirtualAppliancePropertiesFormat struct {
	// BootStrapConfigurationBlobs storage URLs.
	BootStrapConfigurationBlobs []*string `json:"bootStrapConfigurationBlobs,omitempty"`

	// CloudInitConfiguration string in plain text.
	CloudInitConfiguration *string `json:"cloudInitConfiguration,omitempty"`

	// CloudInitConfigurationBlob storage URLs.
	CloudInitConfigurationBlobs []*string `json:"cloudInitConfigurationBlobs,omitempty"`

	// Network Virtual Appliance SKU.
	NvaSKU *VirtualApplianceSKUProperties `json:"nvaSku,omitempty"`

	// Public key for SSH login.
	SSHPublicKey *string `json:"sshPublicKey,omitempty"`

	// VirtualAppliance ASN.
	VirtualApplianceAsn *int64 `json:"virtualApplianceAsn,omitempty"`

	// The Virtual Hub where Network Virtual Appliance is being deployed.
	VirtualHub *SubResource `json:"virtualHub,omitempty"`

	// READ-ONLY; Address Prefix.
	AddressPrefix *string `json:"addressPrefix,omitempty" azure:"ro"`

	// READ-ONLY; List of references to InboundSecurityRules.
	InboundSecurityRules []*SubResource `json:"inboundSecurityRules,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; List of Virtual Appliance Network Interfaces.
	VirtualApplianceNics []*VirtualApplianceNicProperties `json:"virtualApplianceNics,omitempty" azure:"ro"`

	// READ-ONLY; List of references to VirtualApplianceSite.
	VirtualApplianceSites []*SubResource `json:"virtualApplianceSites,omitempty" azure:"ro"`
}

// VirtualApplianceSKU - Definition of the NetworkVirtualApplianceSkus resource.
type VirtualApplianceSKU struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// NetworkVirtualApplianceSku properties.
	Properties *VirtualApplianceSKUPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualApplianceSKUInstances - List of available Sku and instances.
type VirtualApplianceSKUInstances struct {
	// READ-ONLY; Instance Count.
	InstanceCount *int32 `json:"instanceCount,omitempty" azure:"ro"`

	// READ-ONLY; Scale Unit.
	ScaleUnit *string `json:"scaleUnit,omitempty" azure:"ro"`
}

// VirtualApplianceSKUListResult - Response for ListNetworkVirtualApplianceSkus API service call.
type VirtualApplianceSKUListResult struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Network Virtual Appliance Skus that are available.
	Value []*VirtualApplianceSKU `json:"value,omitempty"`
}

// VirtualApplianceSKUProperties - Network Virtual Appliance Sku Properties.
type VirtualApplianceSKUProperties struct {
	// Virtual Appliance Scale Unit.
	BundledScaleUnit *string `json:"bundledScaleUnit,omitempty"`

	// Virtual Appliance Version.
	MarketPlaceVersion *string `json:"marketPlaceVersion,omitempty"`

	// Virtual Appliance Vendor.
	Vendor *string `json:"vendor,omitempty"`
}

// VirtualApplianceSKUPropertiesFormat - Properties specific to NetworkVirtualApplianceSkus.
type VirtualApplianceSKUPropertiesFormat struct {
	// The list of scale units available.
	AvailableScaleUnits []*VirtualApplianceSKUInstances `json:"availableScaleUnits,omitempty"`

	// READ-ONLY; Available Network Virtual Appliance versions.
	AvailableVersions []*string `json:"availableVersions,omitempty" azure:"ro"`

	// READ-ONLY; Network Virtual Appliance Sku vendor.
	Vendor *string `json:"vendor,omitempty" azure:"ro"`
}

// VirtualApplianceSKUsClientGetOptions contains the optional parameters for the VirtualApplianceSKUsClient.Get method.
type VirtualApplianceSKUsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualApplianceSKUsClientListOptions contains the optional parameters for the VirtualApplianceSKUsClient.List method.
type VirtualApplianceSKUsClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualApplianceSite - Virtual Appliance Site resource.
type VirtualApplianceSite struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the virtual appliance site.
	Name *string `json:"name,omitempty"`

	// The properties of the Virtual Appliance Sites.
	Properties *VirtualApplianceSiteProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Site type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualApplianceSiteListResult - Response for ListNetworkVirtualApplianceSites API service call.
type VirtualApplianceSiteListResult struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Network Virtual Appliance sites.
	Value []*VirtualApplianceSite `json:"value,omitempty"`
}

// VirtualApplianceSiteProperties - Properties of the rule group.
type VirtualApplianceSiteProperties struct {
	// Address Prefix.
	AddressPrefix *string `json:"addressPrefix,omitempty"`

	// Office 365 Policy.
	O365Policy *Office365PolicyProperties `json:"o365Policy,omitempty"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// VirtualApplianceSitesClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualApplianceSitesClient.BeginCreateOrUpdate
// method.
type VirtualApplianceSitesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualApplianceSitesClientBeginDeleteOptions contains the optional parameters for the VirtualApplianceSitesClient.BeginDelete
// method.
type VirtualApplianceSitesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualApplianceSitesClientGetOptions contains the optional parameters for the VirtualApplianceSitesClient.Get method.
type VirtualApplianceSitesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualApplianceSitesClientListOptions contains the optional parameters for the VirtualApplianceSitesClient.List method.
type VirtualApplianceSitesClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualAppliancesClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualAppliancesClient.BeginCreateOrUpdate
// method.
type VirtualAppliancesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualAppliancesClientBeginDeleteOptions contains the optional parameters for the VirtualAppliancesClient.BeginDelete
// method.
type VirtualAppliancesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualAppliancesClientGetOptions contains the optional parameters for the VirtualAppliancesClient.Get method.
type VirtualAppliancesClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// VirtualAppliancesClientListByResourceGroupOptions contains the optional parameters for the VirtualAppliancesClient.ListByResourceGroup
// method.
type VirtualAppliancesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VirtualAppliancesClientListOptions contains the optional parameters for the VirtualAppliancesClient.List method.
type VirtualAppliancesClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualAppliancesClientUpdateTagsOptions contains the optional parameters for the VirtualAppliancesClient.UpdateTags method.
type VirtualAppliancesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// VirtualHub Resource.
type VirtualHub struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the virtual hub.
	Properties *VirtualHubProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Kind of service virtual hub. This is metadata used for the Azure portal experience for Route Server.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualHubBgpConnectionClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualHubBgpConnectionClient.BeginCreateOrUpdate
// method.
type VirtualHubBgpConnectionClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualHubBgpConnectionClientBeginDeleteOptions contains the optional parameters for the VirtualHubBgpConnectionClient.BeginDelete
// method.
type VirtualHubBgpConnectionClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualHubBgpConnectionClientGetOptions contains the optional parameters for the VirtualHubBgpConnectionClient.Get method.
type VirtualHubBgpConnectionClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualHubBgpConnectionsClientBeginListAdvertisedRoutesOptions contains the optional parameters for the VirtualHubBgpConnectionsClient.BeginListAdvertisedRoutes
// method.
type VirtualHubBgpConnectionsClientBeginListAdvertisedRoutesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualHubBgpConnectionsClientBeginListLearnedRoutesOptions contains the optional parameters for the VirtualHubBgpConnectionsClient.BeginListLearnedRoutes
// method.
type VirtualHubBgpConnectionsClientBeginListLearnedRoutesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualHubBgpConnectionsClientListOptions contains the optional parameters for the VirtualHubBgpConnectionsClient.List
// method.
type VirtualHubBgpConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualHubEffectiveRoute - The effective route configured on the virtual hub or specified resource.
type VirtualHubEffectiveRoute struct {
	// The list of address prefixes.
	AddressPrefixes []*string `json:"addressPrefixes,omitempty"`

	// The ASPath of this route.
	AsPath *string `json:"asPath,omitempty"`

	// The type of the next hop.
	NextHopType *string `json:"nextHopType,omitempty"`

	// The list of next hops.
	NextHops []*string `json:"nextHops,omitempty"`

	// The origin of this route.
	RouteOrigin *string `json:"routeOrigin,omitempty"`
}

// VirtualHubEffectiveRouteList - EffectiveRoutes List.
type VirtualHubEffectiveRouteList struct {
	// The list of effective routes configured on the virtual hub or the specified resource.
	Value []*VirtualHubEffectiveRoute `json:"value,omitempty"`
}

// VirtualHubID - Virtual Hub identifier.
type VirtualHubID struct {
	// The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be deployed. The Virtual Hub resource and
	// the ExpressRoute gateway resource reside in the same subscription.
	ID *string `json:"id,omitempty"`
}

// VirtualHubIPConfigurationClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualHubIPConfigurationClient.BeginCreateOrUpdate
// method.
type VirtualHubIPConfigurationClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualHubIPConfigurationClientBeginDeleteOptions contains the optional parameters for the VirtualHubIPConfigurationClient.BeginDelete
// method.
type VirtualHubIPConfigurationClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualHubIPConfigurationClientGetOptions contains the optional parameters for the VirtualHubIPConfigurationClient.Get
// method.
type VirtualHubIPConfigurationClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualHubIPConfigurationClientListOptions contains the optional parameters for the VirtualHubIPConfigurationClient.List
// method.
type VirtualHubIPConfigurationClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualHubProperties - Parameters for VirtualHub.
type VirtualHubProperties struct {
	// Address-prefix for this VirtualHub.
	AddressPrefix *string `json:"addressPrefix,omitempty"`

	// Flag to control transit for VirtualRouter hub.
	AllowBranchToBranchTraffic *bool `json:"allowBranchToBranchTraffic,omitempty"`

	// The azureFirewall associated with this VirtualHub.
	AzureFirewall *SubResource `json:"azureFirewall,omitempty"`

	// The expressRouteGateway associated with this VirtualHub.
	ExpressRouteGateway *SubResource `json:"expressRouteGateway,omitempty"`

	// The hubRoutingPreference of this VirtualHub.
	HubRoutingPreference *HubRoutingPreference `json:"hubRoutingPreference,omitempty"`

	// The P2SVpnGateway associated with this VirtualHub.
	P2SVPNGateway *SubResource `json:"p2SVpnGateway,omitempty"`

	// The preferred gateway to route on-prem traffic
	PreferredRoutingGateway *PreferredRoutingGateway `json:"preferredRoutingGateway,omitempty"`

	// The routeTable associated with this virtual hub.
	RouteTable *VirtualHubRouteTable `json:"routeTable,omitempty"`

	// The sku of this VirtualHub.
	SKU *string `json:"sku,omitempty"`

	// The securityPartnerProvider associated with this VirtualHub.
	SecurityPartnerProvider *SubResource `json:"securityPartnerProvider,omitempty"`

	// The Security Provider name.
	SecurityProviderName *string `json:"securityProviderName,omitempty"`

	// The VpnGateway associated with this VirtualHub.
	VPNGateway *SubResource `json:"vpnGateway,omitempty"`

	// List of all virtual hub route table v2s associated with this VirtualHub.
	VirtualHubRouteTableV2S []*VirtualHubRouteTableV2 `json:"virtualHubRouteTableV2s,omitempty"`

	// VirtualRouter ASN.
	VirtualRouterAsn *int64 `json:"virtualRouterAsn,omitempty"`

	// The VirtualHub Router autoscale configuration.
	VirtualRouterAutoScaleConfiguration *VirtualRouterAutoScaleConfiguration `json:"virtualRouterAutoScaleConfiguration,omitempty"`

	// VirtualRouter IPs.
	VirtualRouterIPs []*string `json:"virtualRouterIps,omitempty"`

	// The VirtualWAN to which the VirtualHub belongs.
	VirtualWan *SubResource `json:"virtualWan,omitempty"`

	// READ-ONLY; List of references to Bgp Connections.
	BgpConnections []*SubResource `json:"bgpConnections,omitempty" azure:"ro"`

	// READ-ONLY; List of references to IpConfigurations.
	IPConfigurations []*SubResource `json:"ipConfigurations,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the virtual hub resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The routing state.
	RoutingState *RoutingState `json:"routingState,omitempty" azure:"ro"`
}

// VirtualHubRoute - VirtualHub route.
type VirtualHubRoute struct {
	// List of all addressPrefixes.
	AddressPrefixes []*string `json:"addressPrefixes,omitempty"`

	// NextHop ip address.
	NextHopIPAddress *string `json:"nextHopIpAddress,omitempty"`
}

// VirtualHubRouteTable - VirtualHub route table.
type VirtualHubRouteTable struct {
	// List of all routes.
	Routes []*VirtualHubRoute `json:"routes,omitempty"`
}

// VirtualHubRouteTableV2 Resource.
type VirtualHubRouteTableV2 struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the virtual hub route table v2.
	Properties *VirtualHubRouteTableV2Properties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// VirtualHubRouteTableV2Properties - Parameters for VirtualHubRouteTableV2.
type VirtualHubRouteTableV2Properties struct {
	// List of all connections attached to this route table v2.
	AttachedConnections []*string `json:"attachedConnections,omitempty"`

	// List of all routes.
	Routes []*VirtualHubRouteV2 `json:"routes,omitempty"`

	// READ-ONLY; The provisioning state of the virtual hub route table v2 resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// VirtualHubRouteTableV2SClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualHubRouteTableV2SClient.BeginCreateOrUpdate
// method.
type VirtualHubRouteTableV2SClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualHubRouteTableV2SClientBeginDeleteOptions contains the optional parameters for the VirtualHubRouteTableV2SClient.BeginDelete
// method.
type VirtualHubRouteTableV2SClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualHubRouteTableV2SClientGetOptions contains the optional parameters for the VirtualHubRouteTableV2SClient.Get method.
type VirtualHubRouteTableV2SClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualHubRouteTableV2SClientListOptions contains the optional parameters for the VirtualHubRouteTableV2SClient.List method.
type VirtualHubRouteTableV2SClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualHubRouteV2 - VirtualHubRouteTableV2 route.
type VirtualHubRouteV2 struct {
	// The type of destinations.
	DestinationType *string `json:"destinationType,omitempty"`

	// List of all destinations.
	Destinations []*string `json:"destinations,omitempty"`

	// The type of next hops.
	NextHopType *string `json:"nextHopType,omitempty"`

	// NextHops ip address.
	NextHops []*string `json:"nextHops,omitempty"`
}

// VirtualHubsClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualHubsClient.BeginCreateOrUpdate
// method.
type VirtualHubsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualHubsClientBeginDeleteOptions contains the optional parameters for the VirtualHubsClient.BeginDelete method.
type VirtualHubsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualHubsClientBeginGetEffectiveVirtualHubRoutesOptions contains the optional parameters for the VirtualHubsClient.BeginGetEffectiveVirtualHubRoutes
// method.
type VirtualHubsClientBeginGetEffectiveVirtualHubRoutesOptions struct {
	// Parameters supplied to get the effective routes for a specific resource.
	EffectiveRoutesParameters *EffectiveRoutesParameters
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualHubsClientGetOptions contains the optional parameters for the VirtualHubsClient.Get method.
type VirtualHubsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualHubsClientListByResourceGroupOptions contains the optional parameters for the VirtualHubsClient.ListByResourceGroup
// method.
type VirtualHubsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VirtualHubsClientListOptions contains the optional parameters for the VirtualHubsClient.List method.
type VirtualHubsClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualHubsClientUpdateTagsOptions contains the optional parameters for the VirtualHubsClient.UpdateTags method.
type VirtualHubsClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetwork - Virtual Network resource.
type VirtualNetwork struct {
	// The extended location of the virtual network.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the virtual network.
	Properties *VirtualNetworkPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworkBgpCommunities - Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this
// VNET.
type VirtualNetworkBgpCommunities struct {
	// REQUIRED; The BGP community associated with the virtual network.
	VirtualNetworkCommunity *string `json:"virtualNetworkCommunity,omitempty"`

	// READ-ONLY; The BGP community associated with the region of the virtual network.
	RegionalCommunity *string `json:"regionalCommunity,omitempty" azure:"ro"`
}

// VirtualNetworkConnectionGatewayReference - A reference to VirtualNetworkGateway or LocalNetworkGateway resource.
type VirtualNetworkConnectionGatewayReference struct {
	// REQUIRED; The ID of VirtualNetworkGateway or LocalNetworkGateway resource.
	ID *string `json:"id,omitempty"`
}

// VirtualNetworkEncryption - Indicates if encryption is enabled on virtual network and if VM without encryption is allowed
// in encrypted VNet.
type VirtualNetworkEncryption struct {
	// REQUIRED; Indicates if encryption is enabled on the virtual network.
	Enabled *bool `json:"enabled,omitempty"`

	// If the encrypted VNet allows VM that does not support encryption
	Enforcement *VirtualNetworkEncryptionEnforcement `json:"enforcement,omitempty"`
}

// VirtualNetworkGateway - A common class for general resource information.
type VirtualNetworkGateway struct {
	// REQUIRED; Properties of the virtual network gateway.
	Properties *VirtualNetworkGatewayPropertiesFormat `json:"properties,omitempty"`

	// The extended location of type local virtual network gateway.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayConnection - A common class for general resource information.
type VirtualNetworkGatewayConnection struct {
	// REQUIRED; Properties of the virtual network gateway connection.
	Properties *VirtualNetworkGatewayConnectionPropertiesFormat `json:"properties,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayConnectionListEntity - A common class for general resource information.
type VirtualNetworkGatewayConnectionListEntity struct {
	// REQUIRED; Properties of the virtual network gateway connection.
	Properties *VirtualNetworkGatewayConnectionListEntityPropertiesFormat `json:"properties,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayConnectionListEntityPropertiesFormat - VirtualNetworkGatewayConnection properties.
type VirtualNetworkGatewayConnectionListEntityPropertiesFormat struct {
	// REQUIRED; Gateway connection type.
	ConnectionType *VirtualNetworkGatewayConnectionType `json:"connectionType,omitempty"`

	// REQUIRED; The reference to virtual network gateway resource.
	VirtualNetworkGateway1 *VirtualNetworkConnectionGatewayReference `json:"virtualNetworkGateway1,omitempty"`

	// The authorizationKey.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`

	// The connection mode for this connection.
	ConnectionMode *VirtualNetworkGatewayConnectionMode `json:"connectionMode,omitempty"`

	// Connection protocol used for this connection.
	ConnectionProtocol *VirtualNetworkGatewayConnectionProtocol `json:"connectionProtocol,omitempty"`

	// EnableBgp flag.
	EnableBgp *bool `json:"enableBgp,omitempty"`

	// Bypass ExpressRoute Gateway for data forwarding.
	ExpressRouteGatewayBypass *bool `json:"expressRouteGatewayBypass,omitempty"`

	// GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
	GatewayCustomBgpIPAddresses []*GatewayCustomBgpIPAddressIPConfiguration `json:"gatewayCustomBgpIpAddresses,omitempty"`

	// The IPSec Policies to be considered by this connection.
	IPSecPolicies []*IPSecPolicy `json:"ipsecPolicies,omitempty"`

	// The reference to local network gateway resource.
	LocalNetworkGateway2 *VirtualNetworkConnectionGatewayReference `json:"localNetworkGateway2,omitempty"`

	// The reference to peerings resource.
	Peer *SubResource `json:"peer,omitempty"`

	// The routing weight.
	RoutingWeight *int32 `json:"routingWeight,omitempty"`

	// The IPSec shared key.
	SharedKey *string `json:"sharedKey,omitempty"`

	// The Traffic Selector Policies to be considered by this connection.
	TrafficSelectorPolicies []*TrafficSelectorPolicy `json:"trafficSelectorPolicies,omitempty"`

	// Enable policy-based traffic selectors.
	UsePolicyBasedTrafficSelectors *bool `json:"usePolicyBasedTrafficSelectors,omitempty"`

	// The reference to virtual network gateway resource.
	VirtualNetworkGateway2 *VirtualNetworkConnectionGatewayReference `json:"virtualNetworkGateway2,omitempty"`

	// READ-ONLY; Virtual Network Gateway connection status.
	ConnectionStatus *VirtualNetworkGatewayConnectionStatus `json:"connectionStatus,omitempty" azure:"ro"`

	// READ-ONLY; The egress bytes transferred in this connection.
	EgressBytesTransferred *int64 `json:"egressBytesTransferred,omitempty" azure:"ro"`

	// READ-ONLY; The ingress bytes transferred in this connection.
	IngressBytesTransferred *int64 `json:"ingressBytesTransferred,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the virtual network gateway connection resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the virtual network gateway connection resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`

	// READ-ONLY; Collection of all tunnels' connection health status.
	TunnelConnectionStatus []*TunnelConnectionHealth `json:"tunnelConnectionStatus,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayConnectionListResult - Response for the ListVirtualNetworkGatewayConnections API service call.
type VirtualNetworkGatewayConnectionListResult struct {
	// A list of VirtualNetworkGatewayConnection resources that exists in a resource group.
	Value []*VirtualNetworkGatewayConnection `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayConnectionPropertiesFormat - VirtualNetworkGatewayConnection properties.
type VirtualNetworkGatewayConnectionPropertiesFormat struct {
	// REQUIRED; Gateway connection type.
	ConnectionType *VirtualNetworkGatewayConnectionType `json:"connectionType,omitempty"`

	// REQUIRED; The reference to virtual network gateway resource.
	VirtualNetworkGateway1 *VirtualNetworkGateway `json:"virtualNetworkGateway1,omitempty"`

	// The authorizationKey.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`

	// The connection mode for this connection.
	ConnectionMode *VirtualNetworkGatewayConnectionMode `json:"connectionMode,omitempty"`

	// Connection protocol used for this connection.
	ConnectionProtocol *VirtualNetworkGatewayConnectionProtocol `json:"connectionProtocol,omitempty"`

	// The dead peer detection timeout of this connection in seconds.
	DpdTimeoutSeconds *int32 `json:"dpdTimeoutSeconds,omitempty"`

	// List of egress NatRules.
	EgressNatRules []*SubResource `json:"egressNatRules,omitempty"`

	// EnableBgp flag.
	EnableBgp *bool `json:"enableBgp,omitempty"`

	// Bypass ExpressRoute Gateway for data forwarding.
	ExpressRouteGatewayBypass *bool `json:"expressRouteGatewayBypass,omitempty"`

	// GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
	GatewayCustomBgpIPAddresses []*GatewayCustomBgpIPAddressIPConfiguration `json:"gatewayCustomBgpIpAddresses,omitempty"`

	// The IPSec Policies to be considered by this connection.
	IPSecPolicies []*IPSecPolicy `json:"ipsecPolicies,omitempty"`

	// List of ingress NatRules.
	IngressNatRules []*SubResource `json:"ingressNatRules,omitempty"`

	// The reference to local network gateway resource.
	LocalNetworkGateway2 *LocalNetworkGateway `json:"localNetworkGateway2,omitempty"`

	// The reference to peerings resource.
	Peer *SubResource `json:"peer,omitempty"`

	// The routing weight.
	RoutingWeight *int32 `json:"routingWeight,omitempty"`

	// The IPSec shared key.
	SharedKey *string `json:"sharedKey,omitempty"`

	// The Traffic Selector Policies to be considered by this connection.
	TrafficSelectorPolicies []*TrafficSelectorPolicy `json:"trafficSelectorPolicies,omitempty"`

	// Use private local Azure IP for the connection.
	UseLocalAzureIPAddress *bool `json:"useLocalAzureIpAddress,omitempty"`

	// Enable policy-based traffic selectors.
	UsePolicyBasedTrafficSelectors *bool `json:"usePolicyBasedTrafficSelectors,omitempty"`

	// The reference to virtual network gateway resource.
	VirtualNetworkGateway2 *VirtualNetworkGateway `json:"virtualNetworkGateway2,omitempty"`

	// READ-ONLY; Virtual Network Gateway connection status.
	ConnectionStatus *VirtualNetworkGatewayConnectionStatus `json:"connectionStatus,omitempty" azure:"ro"`

	// READ-ONLY; The egress bytes transferred in this connection.
	EgressBytesTransferred *int64 `json:"egressBytesTransferred,omitempty" azure:"ro"`

	// READ-ONLY; The ingress bytes transferred in this connection.
	IngressBytesTransferred *int64 `json:"ingressBytesTransferred,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the virtual network gateway connection resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the virtual network gateway connection resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`

	// READ-ONLY; Collection of all tunnels' connection health status.
	TunnelConnectionStatus []*TunnelConnectionHealth `json:"tunnelConnectionStatus,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.BeginCreateOrUpdate
// method.
type VirtualNetworkGatewayConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewayConnectionsClientBeginDeleteOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.BeginDelete
// method.
type VirtualNetworkGatewayConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewayConnectionsClientBeginGetIkeSasOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.BeginGetIkeSas
// method.
type VirtualNetworkGatewayConnectionsClientBeginGetIkeSasOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewayConnectionsClientBeginResetConnectionOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.BeginResetConnection
// method.
type VirtualNetworkGatewayConnectionsClientBeginResetConnectionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewayConnectionsClientBeginResetSharedKeyOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.BeginResetSharedKey
// method.
type VirtualNetworkGatewayConnectionsClientBeginResetSharedKeyOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewayConnectionsClientBeginSetSharedKeyOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.BeginSetSharedKey
// method.
type VirtualNetworkGatewayConnectionsClientBeginSetSharedKeyOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewayConnectionsClientBeginStartPacketCaptureOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.BeginStartPacketCapture
// method.
type VirtualNetworkGatewayConnectionsClientBeginStartPacketCaptureOptions struct {
	// Virtual network gateway packet capture parameters supplied to start packet capture on gateway connection.
	Parameters *VPNPacketCaptureStartParameters
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewayConnectionsClientBeginStopPacketCaptureOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.BeginStopPacketCapture
// method.
type VirtualNetworkGatewayConnectionsClientBeginStopPacketCaptureOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewayConnectionsClientBeginUpdateTagsOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.BeginUpdateTags
// method.
type VirtualNetworkGatewayConnectionsClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewayConnectionsClientGetOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.Get
// method.
type VirtualNetworkGatewayConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkGatewayConnectionsClientGetSharedKeyOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.GetSharedKey
// method.
type VirtualNetworkGatewayConnectionsClientGetSharedKeyOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkGatewayConnectionsClientListOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.List
// method.
type VirtualNetworkGatewayConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkGatewayIPConfiguration - IP configuration for virtual network gateway.
type VirtualNetworkGatewayIPConfiguration struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the virtual network gateway ip configuration.
	Properties *VirtualNetworkGatewayIPConfigurationPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayIPConfigurationPropertiesFormat - Properties of VirtualNetworkGatewayIPConfiguration.
type VirtualNetworkGatewayIPConfigurationPropertiesFormat struct {
	// The private IP address allocation method.
	PrivateIPAllocationMethod *IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`

	// The reference to the public IP resource.
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`

	// The reference to the subnet resource.
	Subnet *SubResource `json:"subnet,omitempty"`

	// READ-ONLY; Private IP Address for this gateway.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the virtual network gateway IP configuration resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayListConnectionsResult - Response for the VirtualNetworkGatewayListConnections API service call.
type VirtualNetworkGatewayListConnectionsResult struct {
	// A list of VirtualNetworkGatewayConnection resources that exists in a resource group.
	Value []*VirtualNetworkGatewayConnectionListEntity `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayListResult - Response for the ListVirtualNetworkGateways API service call.
type VirtualNetworkGatewayListResult struct {
	// A list of VirtualNetworkGateway resources that exists in a resource group.
	Value []*VirtualNetworkGateway `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayNatRule Resource.
type VirtualNetworkGatewayNatRule struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the Virtual Network Gateway NAT rule.
	Properties *VirtualNetworkGatewayNatRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayNatRuleProperties - Parameters for VirtualNetworkGatewayNatRule.
type VirtualNetworkGatewayNatRuleProperties struct {
	// The private IP address external mapping for NAT.
	ExternalMappings []*VPNNatRuleMapping `json:"externalMappings,omitempty"`

	// The IP Configuration ID this NAT rule applies to.
	IPConfigurationID *string `json:"ipConfigurationId,omitempty"`

	// The private IP address internal mapping for NAT.
	InternalMappings []*VPNNatRuleMapping `json:"internalMappings,omitempty"`

	// The Source NAT direction of a VPN NAT.
	Mode *VPNNatRuleMode `json:"mode,omitempty"`

	// The type of NAT rule for VPN NAT.
	Type *VPNNatRuleType `json:"type,omitempty"`

	// READ-ONLY; The provisioning state of the NAT Rule resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayNatRulesClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualNetworkGatewayNatRulesClient.BeginCreateOrUpdate
// method.
type VirtualNetworkGatewayNatRulesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewayNatRulesClientBeginDeleteOptions contains the optional parameters for the VirtualNetworkGatewayNatRulesClient.BeginDelete
// method.
type VirtualNetworkGatewayNatRulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewayNatRulesClientGetOptions contains the optional parameters for the VirtualNetworkGatewayNatRulesClient.Get
// method.
type VirtualNetworkGatewayNatRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkGatewayNatRulesClientListByVirtualNetworkGatewayOptions contains the optional parameters for the VirtualNetworkGatewayNatRulesClient.ListByVirtualNetworkGateway
// method.
type VirtualNetworkGatewayNatRulesClientListByVirtualNetworkGatewayOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkGatewayPropertiesFormat - VirtualNetworkGateway properties.
type VirtualNetworkGatewayPropertiesFormat struct {
	// ActiveActive flag.
	Active *bool `json:"activeActive,omitempty"`

	// Virtual network gateway's BGP speaker settings.
	BgpSettings *BgpSettings `json:"bgpSettings,omitempty"`

	// The reference to the address space resource which represents the custom routes address space specified by the customer
	// for virtual network gateway and VpnClient.
	CustomRoutes *AddressSpace `json:"customRoutes,omitempty"`

	// disableIPSecReplayProtection flag.
	DisableIPSecReplayProtection *bool `json:"disableIPSecReplayProtection,omitempty"`

	// Whether BGP is enabled for this virtual network gateway or not.
	EnableBgp *bool `json:"enableBgp,omitempty"`

	// EnableBgpRouteTranslationForNat flag.
	EnableBgpRouteTranslationForNat *bool `json:"enableBgpRouteTranslationForNat,omitempty"`

	// Whether dns forwarding is enabled or not.
	EnableDNSForwarding *bool `json:"enableDnsForwarding,omitempty"`

	// Whether private IP needs to be enabled on this gateway for connections or not.
	EnablePrivateIPAddress *bool `json:"enablePrivateIpAddress,omitempty"`

	// The reference to the LocalNetworkGateway resource which represents local network site having default routes. Assign Null
	// value in case of removing existing default site setting.
	GatewayDefaultSite *SubResource `json:"gatewayDefaultSite,omitempty"`

	// The type of this virtual network gateway.
	GatewayType *VirtualNetworkGatewayType `json:"gatewayType,omitempty"`

	// IP configurations for virtual network gateway.
	IPConfigurations []*VirtualNetworkGatewayIPConfiguration `json:"ipConfigurations,omitempty"`

	// NatRules for virtual network gateway.
	NatRules []*VirtualNetworkGatewayNatRule `json:"natRules,omitempty"`

	// The reference to the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
	SKU *VirtualNetworkGatewaySKU `json:"sku,omitempty"`

	// Customer vnet resource id. VirtualNetworkGateway of type local gateway is associated with the customer vnet.
	VNetExtendedLocationResourceID *string `json:"vNetExtendedLocationResourceId,omitempty"`

	// The reference to the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
	VPNClientConfiguration *VPNClientConfiguration `json:"vpnClientConfiguration,omitempty"`

	// The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN.
	VPNGatewayGeneration *VPNGatewayGeneration `json:"vpnGatewayGeneration,omitempty"`

	// The type of this virtual network gateway.
	VPNType *VPNType `json:"vpnType,omitempty"`

	// READ-ONLY; The IP address allocated by the gateway to which dns requests can be sent.
	InboundDNSForwardingEndpoint *string `json:"inboundDnsForwardingEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the virtual network gateway resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the virtual network gateway resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`
}

// VirtualNetworkGatewaySKU - VirtualNetworkGatewaySku details.
type VirtualNetworkGatewaySKU struct {
	// Gateway SKU name.
	Name *VirtualNetworkGatewaySKUName `json:"name,omitempty"`

	// Gateway SKU tier.
	Tier *VirtualNetworkGatewaySKUTier `json:"tier,omitempty"`

	// READ-ONLY; The capacity.
	Capacity *int32 `json:"capacity,omitempty" azure:"ro"`
}

// VirtualNetworkGatewaysClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginCreateOrUpdate
// method.
type VirtualNetworkGatewaysClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginDeleteOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginDelete
// method.
type VirtualNetworkGatewaysClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginDisconnectVirtualNetworkGatewayVPNConnectionsOptions contains the optional parameters
// for the VirtualNetworkGatewaysClient.BeginDisconnectVirtualNetworkGatewayVPNConnections method.
type VirtualNetworkGatewaysClientBeginDisconnectVirtualNetworkGatewayVPNConnectionsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginGenerateVPNProfileOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginGenerateVPNProfile
// method.
type VirtualNetworkGatewaysClientBeginGenerateVPNProfileOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginGeneratevpnclientpackageOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginGeneratevpnclientpackage
// method.
type VirtualNetworkGatewaysClientBeginGeneratevpnclientpackageOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginGetAdvertisedRoutesOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginGetAdvertisedRoutes
// method.
type VirtualNetworkGatewaysClientBeginGetAdvertisedRoutesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginGetBgpPeerStatusOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginGetBgpPeerStatus
// method.
type VirtualNetworkGatewaysClientBeginGetBgpPeerStatusOptions struct {
	// The IP address of the peer to retrieve the status of.
	Peer *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginGetLearnedRoutesOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginGetLearnedRoutes
// method.
type VirtualNetworkGatewaysClientBeginGetLearnedRoutesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginGetVPNProfilePackageURLOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginGetVPNProfilePackageURL
// method.
type VirtualNetworkGatewaysClientBeginGetVPNProfilePackageURLOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginGetVpnclientConnectionHealthOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginGetVpnclientConnectionHealth
// method.
type VirtualNetworkGatewaysClientBeginGetVpnclientConnectionHealthOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginGetVpnclientIPSecParametersOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginGetVpnclientIPSecParameters
// method.
type VirtualNetworkGatewaysClientBeginGetVpnclientIPSecParametersOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginResetOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginReset
// method.
type VirtualNetworkGatewaysClientBeginResetOptions struct {
	// Virtual network gateway vip address supplied to the begin reset of the active-active feature enabled gateway.
	GatewayVip *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginResetVPNClientSharedKeyOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginResetVPNClientSharedKey
// method.
type VirtualNetworkGatewaysClientBeginResetVPNClientSharedKeyOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginSetVpnclientIPSecParametersOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginSetVpnclientIPSecParameters
// method.
type VirtualNetworkGatewaysClientBeginSetVpnclientIPSecParametersOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginStartPacketCaptureOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginStartPacketCapture
// method.
type VirtualNetworkGatewaysClientBeginStartPacketCaptureOptions struct {
	// Virtual network gateway packet capture parameters supplied to start packet capture on gateway.
	Parameters *VPNPacketCaptureStartParameters
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginStopPacketCaptureOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginStopPacketCapture
// method.
type VirtualNetworkGatewaysClientBeginStopPacketCaptureOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginUpdateTagsOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginUpdateTags
// method.
type VirtualNetworkGatewaysClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientGetOptions contains the optional parameters for the VirtualNetworkGatewaysClient.Get method.
type VirtualNetworkGatewaysClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkGatewaysClientListConnectionsOptions contains the optional parameters for the VirtualNetworkGatewaysClient.ListConnections
// method.
type VirtualNetworkGatewaysClientListConnectionsOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkGatewaysClientListOptions contains the optional parameters for the VirtualNetworkGatewaysClient.List method.
type VirtualNetworkGatewaysClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkGatewaysClientSupportedVPNDevicesOptions contains the optional parameters for the VirtualNetworkGatewaysClient.SupportedVPNDevices
// method.
type VirtualNetworkGatewaysClientSupportedVPNDevicesOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkGatewaysClientVPNDeviceConfigurationScriptOptions contains the optional parameters for the VirtualNetworkGatewaysClient.VPNDeviceConfigurationScript
// method.
type VirtualNetworkGatewaysClientVPNDeviceConfigurationScriptOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkListResult - Response for the ListVirtualNetworks API service call.
type VirtualNetworkListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of VirtualNetwork resources in a resource group.
	Value []*VirtualNetwork `json:"value,omitempty"`
}

// VirtualNetworkListUsageResult - Response for the virtual networks GetUsage API service call.
type VirtualNetworkListUsageResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; VirtualNetwork usage stats.
	Value []*VirtualNetworkUsage `json:"value,omitempty" azure:"ro"`
}

// VirtualNetworkPeering - Peerings in a virtual network resource.
type VirtualNetworkPeering struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the virtual network peering.
	Properties *VirtualNetworkPeeringPropertiesFormat `json:"properties,omitempty"`

	// Resource type.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// VirtualNetworkPeeringListResult - Response for ListSubnets API service call. Retrieves all subnets that belong to a virtual
// network.
type VirtualNetworkPeeringListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The peerings in a virtual network.
	Value []*VirtualNetworkPeering `json:"value,omitempty"`
}

// VirtualNetworkPeeringPropertiesFormat - Properties of the virtual network peering.
type VirtualNetworkPeeringPropertiesFormat struct {
	// Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network.
	AllowForwardedTraffic *bool `json:"allowForwardedTraffic,omitempty"`

	// If gateway links can be used in remote virtual networking to link to this virtual network.
	AllowGatewayTransit *bool `json:"allowGatewayTransit,omitempty"`

	// Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space.
	AllowVirtualNetworkAccess *bool `json:"allowVirtualNetworkAccess,omitempty"`

	// If we need to verify the provisioning state of the remote gateway.
	DoNotVerifyRemoteGateways *bool `json:"doNotVerifyRemoteGateways,omitempty"`

	// The status of the virtual network peering.
	PeeringState *VirtualNetworkPeeringState `json:"peeringState,omitempty"`

	// The peering sync status of the virtual network peering.
	PeeringSyncLevel *VirtualNetworkPeeringLevel `json:"peeringSyncLevel,omitempty"`

	// The reference to the address space peered with the remote virtual network.
	RemoteAddressSpace *AddressSpace `json:"remoteAddressSpace,omitempty"`

	// The reference to the remote virtual network's Bgp Communities.
	RemoteBgpCommunities *VirtualNetworkBgpCommunities `json:"remoteBgpCommunities,omitempty"`

	// The reference to the remote virtual network. The remote virtual network can be in the same or different region (preview).
	// See here to register for the preview and learn more
	// (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
	RemoteVirtualNetwork *SubResource `json:"remoteVirtualNetwork,omitempty"`

	// The reference to the current address space of the remote virtual network.
	RemoteVirtualNetworkAddressSpace *AddressSpace `json:"remoteVirtualNetworkAddressSpace,omitempty"`

	// If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering
	// is also true, virtual network will use gateways of remote virtual network
	// for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a
	// gateway.
	UseRemoteGateways *bool `json:"useRemoteGateways,omitempty"`

	// READ-ONLY; The provisioning state of the virtual network peering resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The reference to the remote virtual network's encryption
	RemoteVirtualNetworkEncryption *VirtualNetworkEncryption `json:"remoteVirtualNetworkEncryption,omitempty" azure:"ro"`

	// READ-ONLY; The resourceGuid property of the Virtual Network peering resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`
}

// VirtualNetworkPeeringsClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualNetworkPeeringsClient.BeginCreateOrUpdate
// method.
type VirtualNetworkPeeringsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
	// Parameter indicates the intention to sync the peering with the current address space on the remote vNet after it's updated.
	SyncRemoteAddressSpace *SyncRemoteAddressSpace
}

// VirtualNetworkPeeringsClientBeginDeleteOptions contains the optional parameters for the VirtualNetworkPeeringsClient.BeginDelete
// method.
type VirtualNetworkPeeringsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkPeeringsClientGetOptions contains the optional parameters for the VirtualNetworkPeeringsClient.Get method.
type VirtualNetworkPeeringsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkPeeringsClientListOptions contains the optional parameters for the VirtualNetworkPeeringsClient.List method.
type VirtualNetworkPeeringsClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkPropertiesFormat - Properties of the virtual network.
type VirtualNetworkPropertiesFormat struct {
	// The AddressSpace that contains an array of IP address ranges that can be used by subnets.
	AddressSpace *AddressSpace `json:"addressSpace,omitempty"`

	// Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET.
	BgpCommunities *VirtualNetworkBgpCommunities `json:"bgpCommunities,omitempty"`

	// The DDoS protection plan associated with the virtual network.
	DdosProtectionPlan *SubResource `json:"ddosProtectionPlan,omitempty"`

	// The dhcpOptions that contains an array of DNS servers available to VMs deployed in the virtual network.
	DhcpOptions *DhcpOptions `json:"dhcpOptions,omitempty"`

	// Indicates if DDoS protection is enabled for all the protected resources in the virtual network. It requires a DDoS protection
	// plan associated with the resource.
	EnableDdosProtection *bool `json:"enableDdosProtection,omitempty"`

	// Indicates if VM protection is enabled for all the subnets in the virtual network.
	EnableVMProtection *bool `json:"enableVmProtection,omitempty"`

	// Indicates if encryption is enabled on virtual network and if VM without encryption is allowed in encrypted VNet.
	Encryption *VirtualNetworkEncryption `json:"encryption,omitempty"`

	// The FlowTimeout value (in minutes) for the Virtual Network
	FlowTimeoutInMinutes *int32 `json:"flowTimeoutInMinutes,omitempty"`

	// Array of IpAllocation which reference this VNET.
	IPAllocations []*SubResource `json:"ipAllocations,omitempty"`

	// A list of subnets in a Virtual Network.
	Subnets []*Subnet `json:"subnets,omitempty"`

	// A list of peerings in a Virtual Network.
	VirtualNetworkPeerings []*VirtualNetworkPeering `json:"virtualNetworkPeerings,omitempty"`

	// READ-ONLY; The provisioning state of the virtual network resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resourceGuid property of the Virtual Network resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`
}

// VirtualNetworkTap - Virtual Network Tap resource.
type VirtualNetworkTap struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Virtual Network Tap Properties.
	Properties *VirtualNetworkTapPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworkTapListResult - Response for ListVirtualNetworkTap API service call.
type VirtualNetworkTapListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of VirtualNetworkTaps in a resource group.
	Value []*VirtualNetworkTap `json:"value,omitempty"`
}

// VirtualNetworkTapPropertiesFormat - Virtual Network Tap properties.
type VirtualNetworkTapPropertiesFormat struct {
	// The reference to the private IP address on the internal Load Balancer that will receive the tap.
	DestinationLoadBalancerFrontEndIPConfiguration *FrontendIPConfiguration `json:"destinationLoadBalancerFrontEndIPConfiguration,omitempty"`

	// The reference to the private IP Address of the collector nic that will receive the tap.
	DestinationNetworkInterfaceIPConfiguration *InterfaceIPConfiguration `json:"destinationNetworkInterfaceIPConfiguration,omitempty"`

	// The VXLAN destination port that will receive the tapped traffic.
	DestinationPort *int32 `json:"destinationPort,omitempty"`

	// READ-ONLY; Specifies the list of resource IDs for the network interface IP configuration that needs to be tapped.
	NetworkInterfaceTapConfigurations []*InterfaceTapConfiguration `json:"networkInterfaceTapConfigurations,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the virtual network tap resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the virtual network tap resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`
}

// VirtualNetworkTapsClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualNetworkTapsClient.BeginCreateOrUpdate
// method.
type VirtualNetworkTapsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkTapsClientBeginDeleteOptions contains the optional parameters for the VirtualNetworkTapsClient.BeginDelete
// method.
type VirtualNetworkTapsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkTapsClientGetOptions contains the optional parameters for the VirtualNetworkTapsClient.Get method.
type VirtualNetworkTapsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkTapsClientListAllOptions contains the optional parameters for the VirtualNetworkTapsClient.ListAll method.
type VirtualNetworkTapsClientListAllOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkTapsClientListByResourceGroupOptions contains the optional parameters for the VirtualNetworkTapsClient.ListByResourceGroup
// method.
type VirtualNetworkTapsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkTapsClientUpdateTagsOptions contains the optional parameters for the VirtualNetworkTapsClient.UpdateTags
// method.
type VirtualNetworkTapsClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkUsage - Usage details for subnet.
type VirtualNetworkUsage struct {
	// READ-ONLY; Indicates number of IPs used from the Subnet.
	CurrentValue *float64 `json:"currentValue,omitempty" azure:"ro"`

	// READ-ONLY; Subnet identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Indicates the size of the subnet.
	Limit *float64 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; The name containing common and localized value for usage.
	Name *VirtualNetworkUsageName `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Usage units. Returns 'Count'.
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// VirtualNetworkUsageName - Usage strings container.
type VirtualNetworkUsageName struct {
	// READ-ONLY; Localized subnet size and usage string.
	LocalizedValue *string `json:"localizedValue,omitempty" azure:"ro"`

	// READ-ONLY; Subnet size and usage string.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// VirtualNetworksClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualNetworksClient.BeginCreateOrUpdate
// method.
type VirtualNetworksClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworksClientBeginDeleteOptions contains the optional parameters for the VirtualNetworksClient.BeginDelete method.
type VirtualNetworksClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworksClientCheckIPAddressAvailabilityOptions contains the optional parameters for the VirtualNetworksClient.CheckIPAddressAvailability
// method.
type VirtualNetworksClientCheckIPAddressAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworksClientGetOptions contains the optional parameters for the VirtualNetworksClient.Get method.
type VirtualNetworksClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// VirtualNetworksClientListAllOptions contains the optional parameters for the VirtualNetworksClient.ListAll method.
type VirtualNetworksClientListAllOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworksClientListOptions contains the optional parameters for the VirtualNetworksClient.List method.
type VirtualNetworksClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworksClientListUsageOptions contains the optional parameters for the VirtualNetworksClient.ListUsage method.
type VirtualNetworksClientListUsageOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworksClientUpdateTagsOptions contains the optional parameters for the VirtualNetworksClient.UpdateTags method.
type VirtualNetworksClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// VirtualRouter Resource.
type VirtualRouter struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the Virtual Router.
	Properties *VirtualRouterPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualRouterAutoScaleConfiguration - The VirtualHub Router autoscale configuration.
type VirtualRouterAutoScaleConfiguration struct {
	// The minimum number of scale units for VirtualHub Router.
	MinCapacity *int32 `json:"minCapacity,omitempty"`
}

// VirtualRouterListResult - Response for ListVirtualRouters API service call.
type VirtualRouterListResult struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Virtual Routers.
	Value []*VirtualRouter `json:"value,omitempty"`
}

// VirtualRouterPeering - Virtual Router Peering resource.
type VirtualRouterPeering struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the virtual router peering that is unique within a virtual router.
	Name *string `json:"name,omitempty"`

	// The properties of the Virtual Router Peering.
	Properties *VirtualRouterPeeringProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Peering type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualRouterPeeringListResult - Response for ListVirtualRouterPeerings API service call.
type VirtualRouterPeeringListResult struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// List of VirtualRouterPeerings in a VirtualRouter.
	Value []*VirtualRouterPeering `json:"value,omitempty"`
}

// VirtualRouterPeeringProperties - Properties of the rule group.
type VirtualRouterPeeringProperties struct {
	// Peer ASN.
	PeerAsn *int64 `json:"peerAsn,omitempty"`

	// Peer IP.
	PeerIP *string `json:"peerIp,omitempty"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// VirtualRouterPeeringsClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualRouterPeeringsClient.BeginCreateOrUpdate
// method.
type VirtualRouterPeeringsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualRouterPeeringsClientBeginDeleteOptions contains the optional parameters for the VirtualRouterPeeringsClient.BeginDelete
// method.
type VirtualRouterPeeringsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualRouterPeeringsClientGetOptions contains the optional parameters for the VirtualRouterPeeringsClient.Get method.
type VirtualRouterPeeringsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualRouterPeeringsClientListOptions contains the optional parameters for the VirtualRouterPeeringsClient.List method.
type VirtualRouterPeeringsClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualRouterPropertiesFormat - Virtual Router definition.
type VirtualRouterPropertiesFormat struct {
	// The Gateway on which VirtualRouter is hosted.
	HostedGateway *SubResource `json:"hostedGateway,omitempty"`

	// The Subnet on which VirtualRouter is hosted.
	HostedSubnet *SubResource `json:"hostedSubnet,omitempty"`

	// VirtualRouter ASN.
	VirtualRouterAsn *int64 `json:"virtualRouterAsn,omitempty"`

	// VirtualRouter IPs.
	VirtualRouterIPs []*string `json:"virtualRouterIps,omitempty"`

	// READ-ONLY; List of references to VirtualRouterPeerings.
	Peerings []*SubResource `json:"peerings,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// VirtualRoutersClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualRoutersClient.BeginCreateOrUpdate
// method.
type VirtualRoutersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualRoutersClientBeginDeleteOptions contains the optional parameters for the VirtualRoutersClient.BeginDelete method.
type VirtualRoutersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualRoutersClientGetOptions contains the optional parameters for the VirtualRoutersClient.Get method.
type VirtualRoutersClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// VirtualRoutersClientListByResourceGroupOptions contains the optional parameters for the VirtualRoutersClient.ListByResourceGroup
// method.
type VirtualRoutersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VirtualRoutersClientListOptions contains the optional parameters for the VirtualRoutersClient.List method.
type VirtualRoutersClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualWAN Resource.
type VirtualWAN struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the virtual WAN.
	Properties *VirtualWanProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualWanProperties - Parameters for VirtualWAN.
type VirtualWanProperties struct {
	// True if branch to branch traffic is allowed.
	AllowBranchToBranchTraffic *bool `json:"allowBranchToBranchTraffic,omitempty"`

	// True if Vnet to Vnet traffic is allowed.
	AllowVnetToVnetTraffic *bool `json:"allowVnetToVnetTraffic,omitempty"`

	// Vpn encryption to be disabled or not.
	DisableVPNEncryption *bool `json:"disableVpnEncryption,omitempty"`

	// The type of the VirtualWAN.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; The office local breakout category.
	Office365LocalBreakoutCategory *OfficeTrafficCategory `json:"office365LocalBreakoutCategory,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the virtual WAN resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; List of VpnSites in the VirtualWAN.
	VPNSites []*SubResource `json:"vpnSites,omitempty" azure:"ro"`

	// READ-ONLY; List of VirtualHubs in the VirtualWAN.
	VirtualHubs []*SubResource `json:"virtualHubs,omitempty" azure:"ro"`
}

// VirtualWanSecurityProvider - Collection of SecurityProviders.
type VirtualWanSecurityProvider struct {
	// Name of the security provider.
	Name *string `json:"name,omitempty"`

	// Url of the security provider.
	URL *string `json:"url,omitempty"`

	// READ-ONLY; Name of the security provider.
	Type *VirtualWanSecurityProviderType `json:"type,omitempty" azure:"ro"`
}

// VirtualWanSecurityProviders - Collection of SecurityProviders.
type VirtualWanSecurityProviders struct {
	// List of VirtualWAN security providers.
	SupportedProviders []*VirtualWanSecurityProvider `json:"supportedProviders,omitempty"`
}

// VirtualWanVPNProfileParameters - Virtual Wan Vpn profile parameters Vpn profile generation.
type VirtualWanVPNProfileParameters struct {
	// VPN client authentication method.
	AuthenticationMethod *AuthenticationMethod `json:"authenticationMethod,omitempty"`

	// VpnServerConfiguration partial resource uri with which VirtualWan is associated to.
	VPNServerConfigurationResourceID *string `json:"vpnServerConfigurationResourceId,omitempty"`
}

// VirtualWansClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualWansClient.BeginCreateOrUpdate
// method.
type VirtualWansClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualWansClientBeginDeleteOptions contains the optional parameters for the VirtualWansClient.BeginDelete method.
type VirtualWansClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualWansClientGetOptions contains the optional parameters for the VirtualWansClient.Get method.
type VirtualWansClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualWansClientListByResourceGroupOptions contains the optional parameters for the VirtualWansClient.ListByResourceGroup
// method.
type VirtualWansClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VirtualWansClientListOptions contains the optional parameters for the VirtualWansClient.List method.
type VirtualWansClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualWansClientUpdateTagsOptions contains the optional parameters for the VirtualWansClient.UpdateTags method.
type VirtualWansClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// VnetRoute - List of routes that control routing from VirtualHub into a virtual network connection.
type VnetRoute struct {
	// List of all Static Routes.
	StaticRoutes []*StaticRoute `json:"staticRoutes,omitempty"`

	// READ-ONLY; The list of references to HubBgpConnection objects.
	BgpConnections []*SubResource `json:"bgpConnections,omitempty" azure:"ro"`
}

// Watcher - Network watcher in a resource group.
type Watcher struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the network watcher.
	Properties *WatcherPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WatcherListResult - Response for ListNetworkWatchers API service call.
type WatcherListResult struct {
	// List of network watcher resources.
	Value []*Watcher `json:"value,omitempty"`
}

// WatcherPropertiesFormat - The network watcher properties.
type WatcherPropertiesFormat struct {
	// READ-ONLY; The provisioning state of the network watcher resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// WatchersClientBeginCheckConnectivityOptions contains the optional parameters for the WatchersClient.BeginCheckConnectivity
// method.
type WatchersClientBeginCheckConnectivityOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WatchersClientBeginDeleteOptions contains the optional parameters for the WatchersClient.BeginDelete method.
type WatchersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WatchersClientBeginGetAzureReachabilityReportOptions contains the optional parameters for the WatchersClient.BeginGetAzureReachabilityReport
// method.
type WatchersClientBeginGetAzureReachabilityReportOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WatchersClientBeginGetFlowLogStatusOptions contains the optional parameters for the WatchersClient.BeginGetFlowLogStatus
// method.
type WatchersClientBeginGetFlowLogStatusOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WatchersClientBeginGetNetworkConfigurationDiagnosticOptions contains the optional parameters for the WatchersClient.BeginGetNetworkConfigurationDiagnostic
// method.
type WatchersClientBeginGetNetworkConfigurationDiagnosticOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WatchersClientBeginGetNextHopOptions contains the optional parameters for the WatchersClient.BeginGetNextHop method.
type WatchersClientBeginGetNextHopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WatchersClientBeginGetTroubleshootingOptions contains the optional parameters for the WatchersClient.BeginGetTroubleshooting
// method.
type WatchersClientBeginGetTroubleshootingOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WatchersClientBeginGetTroubleshootingResultOptions contains the optional parameters for the WatchersClient.BeginGetTroubleshootingResult
// method.
type WatchersClientBeginGetTroubleshootingResultOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WatchersClientBeginGetVMSecurityRulesOptions contains the optional parameters for the WatchersClient.BeginGetVMSecurityRules
// method.
type WatchersClientBeginGetVMSecurityRulesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WatchersClientBeginListAvailableProvidersOptions contains the optional parameters for the WatchersClient.BeginListAvailableProviders
// method.
type WatchersClientBeginListAvailableProvidersOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WatchersClientBeginSetFlowLogConfigurationOptions contains the optional parameters for the WatchersClient.BeginSetFlowLogConfiguration
// method.
type WatchersClientBeginSetFlowLogConfigurationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WatchersClientBeginVerifyIPFlowOptions contains the optional parameters for the WatchersClient.BeginVerifyIPFlow method.
type WatchersClientBeginVerifyIPFlowOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WatchersClientCreateOrUpdateOptions contains the optional parameters for the WatchersClient.CreateOrUpdate method.
type WatchersClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// WatchersClientGetOptions contains the optional parameters for the WatchersClient.Get method.
type WatchersClientGetOptions struct {
	// placeholder for future optional parameters
}

// WatchersClientGetTopologyOptions contains the optional parameters for the WatchersClient.GetTopology method.
type WatchersClientGetTopologyOptions struct {
	// placeholder for future optional parameters
}

// WatchersClientListAllOptions contains the optional parameters for the WatchersClient.ListAll method.
type WatchersClientListAllOptions struct {
	// placeholder for future optional parameters
}

// WatchersClientListOptions contains the optional parameters for the WatchersClient.List method.
type WatchersClientListOptions struct {
	// placeholder for future optional parameters
}

// WatchersClientUpdateTagsOptions contains the optional parameters for the WatchersClient.UpdateTags method.
type WatchersClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// WebApplicationFirewallCustomRule - Defines contents of a web application rule.
type WebApplicationFirewallCustomRule struct {
	// REQUIRED; Type of Actions.
	Action *WebApplicationFirewallAction `json:"action,omitempty"`

	// REQUIRED; List of match conditions.
	MatchConditions []*MatchCondition `json:"matchConditions,omitempty"`

	// REQUIRED; Priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
	Priority *int32 `json:"priority,omitempty"`

	// REQUIRED; The rule type.
	RuleType *WebApplicationFirewallRuleType `json:"ruleType,omitempty"`

	// The name of the resource that is unique within a policy. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// WebApplicationFirewallPoliciesClientBeginDeleteOptions contains the optional parameters for the WebApplicationFirewallPoliciesClient.BeginDelete
// method.
type WebApplicationFirewallPoliciesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebApplicationFirewallPoliciesClientCreateOrUpdateOptions contains the optional parameters for the WebApplicationFirewallPoliciesClient.CreateOrUpdate
// method.
type WebApplicationFirewallPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// WebApplicationFirewallPoliciesClientGetOptions contains the optional parameters for the WebApplicationFirewallPoliciesClient.Get
// method.
type WebApplicationFirewallPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// WebApplicationFirewallPoliciesClientListAllOptions contains the optional parameters for the WebApplicationFirewallPoliciesClient.ListAll
// method.
type WebApplicationFirewallPoliciesClientListAllOptions struct {
	// placeholder for future optional parameters
}

// WebApplicationFirewallPoliciesClientListOptions contains the optional parameters for the WebApplicationFirewallPoliciesClient.List
// method.
type WebApplicationFirewallPoliciesClientListOptions struct {
	// placeholder for future optional parameters
}

// WebApplicationFirewallPolicy - Defines web application firewall policy.
type WebApplicationFirewallPolicy struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the web application firewall policy.
	Properties *WebApplicationFirewallPolicyPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WebApplicationFirewallPolicyListResult - Result of the request to list WebApplicationFirewallPolicies. It contains a list
// of WebApplicationFirewallPolicy objects and a URL link to get the next set of results.
type WebApplicationFirewallPolicyListResult struct {
	// READ-ONLY; URL to get the next set of WebApplicationFirewallPolicy objects if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of WebApplicationFirewallPolicies within a resource group.
	Value []*WebApplicationFirewallPolicy `json:"value,omitempty" azure:"ro"`
}

// WebApplicationFirewallPolicyPropertiesFormat - Defines web application firewall policy properties.
type WebApplicationFirewallPolicyPropertiesFormat struct {
	// REQUIRED; Describes the managedRules structure.
	ManagedRules *ManagedRulesDefinition `json:"managedRules,omitempty"`

	// The custom rules inside the policy.
	CustomRules []*WebApplicationFirewallCustomRule `json:"customRules,omitempty"`

	// The PolicySettings for policy.
	PolicySettings *PolicySettings `json:"policySettings,omitempty"`

	// READ-ONLY; A collection of references to application gateways.
	ApplicationGateways []*ApplicationGateway `json:"applicationGateways,omitempty" azure:"ro"`

	// READ-ONLY; A collection of references to application gateway http listeners.
	HTTPListeners []*SubResource `json:"httpListeners,omitempty" azure:"ro"`

	// READ-ONLY; A collection of references to application gateway path rules.
	PathBasedRules []*SubResource `json:"pathBasedRules,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the web application firewall policy resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Resource status of the policy.
	ResourceState *WebApplicationFirewallPolicyResourceState `json:"resourceState,omitempty" azure:"ro"`
}

// WebCategoriesClientGetOptions contains the optional parameters for the WebCategoriesClient.Get method.
type WebCategoriesClientGetOptions struct {
	// Expands resourceIds back referenced by the azureWebCategory resource.
	Expand *string
}

// WebCategoriesClientListBySubscriptionOptions contains the optional parameters for the WebCategoriesClient.ListBySubscription
// method.
type WebCategoriesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}
