// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/networkconnectivity/v1/data_transfer.proto

package networkconnectivitypb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DataTransferService_ListMulticloudDataTransferConfigs_FullMethodName           = "/google.cloud.networkconnectivity.v1.DataTransferService/ListMulticloudDataTransferConfigs"
	DataTransferService_GetMulticloudDataTransferConfig_FullMethodName             = "/google.cloud.networkconnectivity.v1.DataTransferService/GetMulticloudDataTransferConfig"
	DataTransferService_CreateMulticloudDataTransferConfig_FullMethodName          = "/google.cloud.networkconnectivity.v1.DataTransferService/CreateMulticloudDataTransferConfig"
	DataTransferService_UpdateMulticloudDataTransferConfig_FullMethodName          = "/google.cloud.networkconnectivity.v1.DataTransferService/UpdateMulticloudDataTransferConfig"
	DataTransferService_DeleteMulticloudDataTransferConfig_FullMethodName          = "/google.cloud.networkconnectivity.v1.DataTransferService/DeleteMulticloudDataTransferConfig"
	DataTransferService_ListDestinations_FullMethodName                            = "/google.cloud.networkconnectivity.v1.DataTransferService/ListDestinations"
	DataTransferService_GetDestination_FullMethodName                              = "/google.cloud.networkconnectivity.v1.DataTransferService/GetDestination"
	DataTransferService_CreateDestination_FullMethodName                           = "/google.cloud.networkconnectivity.v1.DataTransferService/CreateDestination"
	DataTransferService_UpdateDestination_FullMethodName                           = "/google.cloud.networkconnectivity.v1.DataTransferService/UpdateDestination"
	DataTransferService_DeleteDestination_FullMethodName                           = "/google.cloud.networkconnectivity.v1.DataTransferService/DeleteDestination"
	DataTransferService_GetMulticloudDataTransferSupportedService_FullMethodName   = "/google.cloud.networkconnectivity.v1.DataTransferService/GetMulticloudDataTransferSupportedService"
	DataTransferService_ListMulticloudDataTransferSupportedServices_FullMethodName = "/google.cloud.networkconnectivity.v1.DataTransferService/ListMulticloudDataTransferSupportedServices"
)

// DataTransferServiceClient is the client API for DataTransferService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DataTransferServiceClient interface {
	// Lists the `MulticloudDataTransferConfig` resources in a specified project
	// and location.
	ListMulticloudDataTransferConfigs(ctx context.Context, in *ListMulticloudDataTransferConfigsRequest, opts ...grpc.CallOption) (*ListMulticloudDataTransferConfigsResponse, error)
	// Gets the details of a `MulticloudDataTransferConfig` resource.
	GetMulticloudDataTransferConfig(ctx context.Context, in *GetMulticloudDataTransferConfigRequest, opts ...grpc.CallOption) (*MulticloudDataTransferConfig, error)
	// Creates a `MulticloudDataTransferConfig` resource in a specified project
	// and location.
	CreateMulticloudDataTransferConfig(ctx context.Context, in *CreateMulticloudDataTransferConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a `MulticloudDataTransferConfig` resource in a specified project
	// and location.
	UpdateMulticloudDataTransferConfig(ctx context.Context, in *UpdateMulticloudDataTransferConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a `MulticloudDataTransferConfig` resource.
	DeleteMulticloudDataTransferConfig(ctx context.Context, in *DeleteMulticloudDataTransferConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the `Destination` resources in a specified project and location.
	ListDestinations(ctx context.Context, in *ListDestinationsRequest, opts ...grpc.CallOption) (*ListDestinationsResponse, error)
	// Gets the details of a `Destination` resource.
	GetDestination(ctx context.Context, in *GetDestinationRequest, opts ...grpc.CallOption) (*Destination, error)
	// Creates a `Destination` resource in a specified project and location.
	CreateDestination(ctx context.Context, in *CreateDestinationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a `Destination` resource in a specified project and location.
	UpdateDestination(ctx context.Context, in *UpdateDestinationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a `Destination` resource.
	DeleteDestination(ctx context.Context, in *DeleteDestinationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the details of a service that is supported for Data Transfer
	// Essentials.
	GetMulticloudDataTransferSupportedService(ctx context.Context, in *GetMulticloudDataTransferSupportedServiceRequest, opts ...grpc.CallOption) (*MulticloudDataTransferSupportedService, error)
	// Lists the services in the project for a region that are supported for
	// Data Transfer Essentials.
	ListMulticloudDataTransferSupportedServices(ctx context.Context, in *ListMulticloudDataTransferSupportedServicesRequest, opts ...grpc.CallOption) (*ListMulticloudDataTransferSupportedServicesResponse, error)
}

type dataTransferServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDataTransferServiceClient(cc grpc.ClientConnInterface) DataTransferServiceClient {
	return &dataTransferServiceClient{cc}
}

func (c *dataTransferServiceClient) ListMulticloudDataTransferConfigs(ctx context.Context, in *ListMulticloudDataTransferConfigsRequest, opts ...grpc.CallOption) (*ListMulticloudDataTransferConfigsResponse, error) {
	out := new(ListMulticloudDataTransferConfigsResponse)
	err := c.cc.Invoke(ctx, DataTransferService_ListMulticloudDataTransferConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) GetMulticloudDataTransferConfig(ctx context.Context, in *GetMulticloudDataTransferConfigRequest, opts ...grpc.CallOption) (*MulticloudDataTransferConfig, error) {
	out := new(MulticloudDataTransferConfig)
	err := c.cc.Invoke(ctx, DataTransferService_GetMulticloudDataTransferConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) CreateMulticloudDataTransferConfig(ctx context.Context, in *CreateMulticloudDataTransferConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataTransferService_CreateMulticloudDataTransferConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) UpdateMulticloudDataTransferConfig(ctx context.Context, in *UpdateMulticloudDataTransferConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataTransferService_UpdateMulticloudDataTransferConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) DeleteMulticloudDataTransferConfig(ctx context.Context, in *DeleteMulticloudDataTransferConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataTransferService_DeleteMulticloudDataTransferConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ListDestinations(ctx context.Context, in *ListDestinationsRequest, opts ...grpc.CallOption) (*ListDestinationsResponse, error) {
	out := new(ListDestinationsResponse)
	err := c.cc.Invoke(ctx, DataTransferService_ListDestinations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) GetDestination(ctx context.Context, in *GetDestinationRequest, opts ...grpc.CallOption) (*Destination, error) {
	out := new(Destination)
	err := c.cc.Invoke(ctx, DataTransferService_GetDestination_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) CreateDestination(ctx context.Context, in *CreateDestinationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataTransferService_CreateDestination_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) UpdateDestination(ctx context.Context, in *UpdateDestinationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataTransferService_UpdateDestination_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) DeleteDestination(ctx context.Context, in *DeleteDestinationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataTransferService_DeleteDestination_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) GetMulticloudDataTransferSupportedService(ctx context.Context, in *GetMulticloudDataTransferSupportedServiceRequest, opts ...grpc.CallOption) (*MulticloudDataTransferSupportedService, error) {
	out := new(MulticloudDataTransferSupportedService)
	err := c.cc.Invoke(ctx, DataTransferService_GetMulticloudDataTransferSupportedService_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ListMulticloudDataTransferSupportedServices(ctx context.Context, in *ListMulticloudDataTransferSupportedServicesRequest, opts ...grpc.CallOption) (*ListMulticloudDataTransferSupportedServicesResponse, error) {
	out := new(ListMulticloudDataTransferSupportedServicesResponse)
	err := c.cc.Invoke(ctx, DataTransferService_ListMulticloudDataTransferSupportedServices_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataTransferServiceServer is the server API for DataTransferService service.
// All implementations should embed UnimplementedDataTransferServiceServer
// for forward compatibility
type DataTransferServiceServer interface {
	// Lists the `MulticloudDataTransferConfig` resources in a specified project
	// and location.
	ListMulticloudDataTransferConfigs(context.Context, *ListMulticloudDataTransferConfigsRequest) (*ListMulticloudDataTransferConfigsResponse, error)
	// Gets the details of a `MulticloudDataTransferConfig` resource.
	GetMulticloudDataTransferConfig(context.Context, *GetMulticloudDataTransferConfigRequest) (*MulticloudDataTransferConfig, error)
	// Creates a `MulticloudDataTransferConfig` resource in a specified project
	// and location.
	CreateMulticloudDataTransferConfig(context.Context, *CreateMulticloudDataTransferConfigRequest) (*longrunningpb.Operation, error)
	// Updates a `MulticloudDataTransferConfig` resource in a specified project
	// and location.
	UpdateMulticloudDataTransferConfig(context.Context, *UpdateMulticloudDataTransferConfigRequest) (*longrunningpb.Operation, error)
	// Deletes a `MulticloudDataTransferConfig` resource.
	DeleteMulticloudDataTransferConfig(context.Context, *DeleteMulticloudDataTransferConfigRequest) (*longrunningpb.Operation, error)
	// Lists the `Destination` resources in a specified project and location.
	ListDestinations(context.Context, *ListDestinationsRequest) (*ListDestinationsResponse, error)
	// Gets the details of a `Destination` resource.
	GetDestination(context.Context, *GetDestinationRequest) (*Destination, error)
	// Creates a `Destination` resource in a specified project and location.
	CreateDestination(context.Context, *CreateDestinationRequest) (*longrunningpb.Operation, error)
	// Updates a `Destination` resource in a specified project and location.
	UpdateDestination(context.Context, *UpdateDestinationRequest) (*longrunningpb.Operation, error)
	// Deletes a `Destination` resource.
	DeleteDestination(context.Context, *DeleteDestinationRequest) (*longrunningpb.Operation, error)
	// Gets the details of a service that is supported for Data Transfer
	// Essentials.
	GetMulticloudDataTransferSupportedService(context.Context, *GetMulticloudDataTransferSupportedServiceRequest) (*MulticloudDataTransferSupportedService, error)
	// Lists the services in the project for a region that are supported for
	// Data Transfer Essentials.
	ListMulticloudDataTransferSupportedServices(context.Context, *ListMulticloudDataTransferSupportedServicesRequest) (*ListMulticloudDataTransferSupportedServicesResponse, error)
}

// UnimplementedDataTransferServiceServer should be embedded to have forward compatible implementations.
type UnimplementedDataTransferServiceServer struct {
}

func (UnimplementedDataTransferServiceServer) ListMulticloudDataTransferConfigs(context.Context, *ListMulticloudDataTransferConfigsRequest) (*ListMulticloudDataTransferConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMulticloudDataTransferConfigs not implemented")
}
func (UnimplementedDataTransferServiceServer) GetMulticloudDataTransferConfig(context.Context, *GetMulticloudDataTransferConfigRequest) (*MulticloudDataTransferConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMulticloudDataTransferConfig not implemented")
}
func (UnimplementedDataTransferServiceServer) CreateMulticloudDataTransferConfig(context.Context, *CreateMulticloudDataTransferConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMulticloudDataTransferConfig not implemented")
}
func (UnimplementedDataTransferServiceServer) UpdateMulticloudDataTransferConfig(context.Context, *UpdateMulticloudDataTransferConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMulticloudDataTransferConfig not implemented")
}
func (UnimplementedDataTransferServiceServer) DeleteMulticloudDataTransferConfig(context.Context, *DeleteMulticloudDataTransferConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMulticloudDataTransferConfig not implemented")
}
func (UnimplementedDataTransferServiceServer) ListDestinations(context.Context, *ListDestinationsRequest) (*ListDestinationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDestinations not implemented")
}
func (UnimplementedDataTransferServiceServer) GetDestination(context.Context, *GetDestinationRequest) (*Destination, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDestination not implemented")
}
func (UnimplementedDataTransferServiceServer) CreateDestination(context.Context, *CreateDestinationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDestination not implemented")
}
func (UnimplementedDataTransferServiceServer) UpdateDestination(context.Context, *UpdateDestinationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDestination not implemented")
}
func (UnimplementedDataTransferServiceServer) DeleteDestination(context.Context, *DeleteDestinationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDestination not implemented")
}
func (UnimplementedDataTransferServiceServer) GetMulticloudDataTransferSupportedService(context.Context, *GetMulticloudDataTransferSupportedServiceRequest) (*MulticloudDataTransferSupportedService, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMulticloudDataTransferSupportedService not implemented")
}
func (UnimplementedDataTransferServiceServer) ListMulticloudDataTransferSupportedServices(context.Context, *ListMulticloudDataTransferSupportedServicesRequest) (*ListMulticloudDataTransferSupportedServicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMulticloudDataTransferSupportedServices not implemented")
}

// UnsafeDataTransferServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DataTransferServiceServer will
// result in compilation errors.
type UnsafeDataTransferServiceServer interface {
	mustEmbedUnimplementedDataTransferServiceServer()
}

func RegisterDataTransferServiceServer(s grpc.ServiceRegistrar, srv DataTransferServiceServer) {
	s.RegisterService(&DataTransferService_ServiceDesc, srv)
}

func _DataTransferService_ListMulticloudDataTransferConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMulticloudDataTransferConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ListMulticloudDataTransferConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_ListMulticloudDataTransferConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ListMulticloudDataTransferConfigs(ctx, req.(*ListMulticloudDataTransferConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_GetMulticloudDataTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMulticloudDataTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).GetMulticloudDataTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_GetMulticloudDataTransferConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).GetMulticloudDataTransferConfig(ctx, req.(*GetMulticloudDataTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_CreateMulticloudDataTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMulticloudDataTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).CreateMulticloudDataTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_CreateMulticloudDataTransferConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).CreateMulticloudDataTransferConfig(ctx, req.(*CreateMulticloudDataTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_UpdateMulticloudDataTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMulticloudDataTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).UpdateMulticloudDataTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_UpdateMulticloudDataTransferConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).UpdateMulticloudDataTransferConfig(ctx, req.(*UpdateMulticloudDataTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_DeleteMulticloudDataTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMulticloudDataTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).DeleteMulticloudDataTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_DeleteMulticloudDataTransferConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).DeleteMulticloudDataTransferConfig(ctx, req.(*DeleteMulticloudDataTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ListDestinations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDestinationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ListDestinations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_ListDestinations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ListDestinations(ctx, req.(*ListDestinationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_GetDestination_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDestinationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).GetDestination(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_GetDestination_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).GetDestination(ctx, req.(*GetDestinationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_CreateDestination_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDestinationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).CreateDestination(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_CreateDestination_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).CreateDestination(ctx, req.(*CreateDestinationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_UpdateDestination_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDestinationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).UpdateDestination(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_UpdateDestination_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).UpdateDestination(ctx, req.(*UpdateDestinationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_DeleteDestination_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDestinationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).DeleteDestination(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_DeleteDestination_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).DeleteDestination(ctx, req.(*DeleteDestinationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_GetMulticloudDataTransferSupportedService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMulticloudDataTransferSupportedServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).GetMulticloudDataTransferSupportedService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_GetMulticloudDataTransferSupportedService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).GetMulticloudDataTransferSupportedService(ctx, req.(*GetMulticloudDataTransferSupportedServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ListMulticloudDataTransferSupportedServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMulticloudDataTransferSupportedServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ListMulticloudDataTransferSupportedServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTransferService_ListMulticloudDataTransferSupportedServices_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ListMulticloudDataTransferSupportedServices(ctx, req.(*ListMulticloudDataTransferSupportedServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DataTransferService_ServiceDesc is the grpc.ServiceDesc for DataTransferService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DataTransferService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.networkconnectivity.v1.DataTransferService",
	HandlerType: (*DataTransferServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListMulticloudDataTransferConfigs",
			Handler:    _DataTransferService_ListMulticloudDataTransferConfigs_Handler,
		},
		{
			MethodName: "GetMulticloudDataTransferConfig",
			Handler:    _DataTransferService_GetMulticloudDataTransferConfig_Handler,
		},
		{
			MethodName: "CreateMulticloudDataTransferConfig",
			Handler:    _DataTransferService_CreateMulticloudDataTransferConfig_Handler,
		},
		{
			MethodName: "UpdateMulticloudDataTransferConfig",
			Handler:    _DataTransferService_UpdateMulticloudDataTransferConfig_Handler,
		},
		{
			MethodName: "DeleteMulticloudDataTransferConfig",
			Handler:    _DataTransferService_DeleteMulticloudDataTransferConfig_Handler,
		},
		{
			MethodName: "ListDestinations",
			Handler:    _DataTransferService_ListDestinations_Handler,
		},
		{
			MethodName: "GetDestination",
			Handler:    _DataTransferService_GetDestination_Handler,
		},
		{
			MethodName: "CreateDestination",
			Handler:    _DataTransferService_CreateDestination_Handler,
		},
		{
			MethodName: "UpdateDestination",
			Handler:    _DataTransferService_UpdateDestination_Handler,
		},
		{
			MethodName: "DeleteDestination",
			Handler:    _DataTransferService_DeleteDestination_Handler,
		},
		{
			MethodName: "GetMulticloudDataTransferSupportedService",
			Handler:    _DataTransferService_GetMulticloudDataTransferSupportedService_Handler,
		},
		{
			MethodName: "ListMulticloudDataTransferSupportedServices",
			Handler:    _DataTransferService_ListMulticloudDataTransferSupportedServices_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/networkconnectivity/v1/data_transfer.proto",
}
