// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package release

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// NewListReleasesParams creates a new ListReleasesParams object
//
// There are no default values defined in the spec.
func NewListReleasesParams() ListReleasesParams {

	return ListReleasesParams{}
}

// ListReleasesParams contains all the bound params for the list releases operation
// typically these are obtained from a http.Request
//
// swagger:parameters ListReleases
type ListReleasesParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*Current Release
	  In: query
	*/
	Current *string
	/*filter releases
	  In: query
	*/
	Filter *string
	/*repo name
	  Required: true
	  In: query
	*/
	Repo string
	/*search content
	  In: query
	*/
	Search *string
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewListReleasesParams() beforehand.
func (o *ListReleasesParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	qCurrent, qhkCurrent, _ := qs.GetOK("current")
	if err := o.bindCurrent(qCurrent, qhkCurrent, route.Formats); err != nil {
		res = append(res, err)
	}

	qFilter, qhkFilter, _ := qs.GetOK("filter")
	if err := o.bindFilter(qFilter, qhkFilter, route.Formats); err != nil {
		res = append(res, err)
	}

	qRepo, qhkRepo, _ := qs.GetOK("repo")
	if err := o.bindRepo(qRepo, qhkRepo, route.Formats); err != nil {
		res = append(res, err)
	}

	qSearch, qhkSearch, _ := qs.GetOK("search")
	if err := o.bindSearch(qSearch, qhkSearch, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindCurrent binds and validates parameter Current from query.
func (o *ListReleasesParams) bindCurrent(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}
	o.Current = &raw

	return nil
}

// bindFilter binds and validates parameter Filter from query.
func (o *ListReleasesParams) bindFilter(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}
	o.Filter = &raw

	return nil
}

// bindRepo binds and validates parameter Repo from query.
func (o *ListReleasesParams) bindRepo(rawData []string, hasKey bool, formats strfmt.Registry) error {
	if !hasKey {
		return errors.Required("repo", "query", rawData)
	}
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// AllowEmptyValue: false

	if err := validate.RequiredString("repo", "query", raw); err != nil {
		return err
	}
	o.Repo = raw

	return nil
}

// bindSearch binds and validates parameter Search from query.
func (o *ListReleasesParams) bindSearch(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}
	o.Search = &raw

	return nil
}
