// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package system

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/minio/console/models"
)

// DashboardWidgetDetailsOKCode is the HTTP code returned for type DashboardWidgetDetailsOK
const DashboardWidgetDetailsOKCode int = 200

/*
DashboardWidgetDetailsOK A successful response.

swagger:response dashboardWidgetDetailsOK
*/
type DashboardWidgetDetailsOK struct {

	/*
	  In: Body
	*/
	Payload *models.WidgetDetails `json:"body,omitempty"`
}

// NewDashboardWidgetDetailsOK creates DashboardWidgetDetailsOK with default headers values
func NewDashboardWidgetDetailsOK() *DashboardWidgetDetailsOK {

	return &DashboardWidgetDetailsOK{}
}

// WithPayload adds the payload to the dashboard widget details o k response
func (o *DashboardWidgetDetailsOK) WithPayload(payload *models.WidgetDetails) *DashboardWidgetDetailsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the dashboard widget details o k response
func (o *DashboardWidgetDetailsOK) SetPayload(payload *models.WidgetDetails) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DashboardWidgetDetailsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DashboardWidgetDetailsDefault Generic error response.

swagger:response dashboardWidgetDetailsDefault
*/
type DashboardWidgetDetailsDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.APIError `json:"body,omitempty"`
}

// NewDashboardWidgetDetailsDefault creates DashboardWidgetDetailsDefault with default headers values
func NewDashboardWidgetDetailsDefault(code int) *DashboardWidgetDetailsDefault {
	if code <= 0 {
		code = 500
	}

	return &DashboardWidgetDetailsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the dashboard widget details default response
func (o *DashboardWidgetDetailsDefault) WithStatusCode(code int) *DashboardWidgetDetailsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the dashboard widget details default response
func (o *DashboardWidgetDetailsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the dashboard widget details default response
func (o *DashboardWidgetDetailsDefault) WithPayload(payload *models.APIError) *DashboardWidgetDetailsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the dashboard widget details default response
func (o *DashboardWidgetDetailsDefault) SetPayload(payload *models.APIError) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DashboardWidgetDetailsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
