// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudtrail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudtrail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Updates the specified dashboard.
//
// To set a refresh schedule, CloudTrail must be granted permissions to run the
// StartDashboardRefresh operation to refresh the dashboard on your behalf. To
// provide permissions, run the PutResourcePolicy operation to attach a
// resource-based policy to the dashboard. For more information, see [Resource-based policy example for a dashboard]in the
// CloudTrail User Guide.
//
// CloudTrail runs queries to populate the dashboard's widgets during a manual or
// scheduled refresh. CloudTrail must be granted permissions to run the StartQuery
// operation on your behalf. To provide permissions, run the PutResourcePolicy
// operation to attach a resource-based policy to each event data store. For more
// information, see [Example: Allow CloudTrail to run queries to populate a dashboard]in the CloudTrail User Guide.
//
// [Example: Allow CloudTrail to run queries to populate a dashboard]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-eds-dashboard
// [Resource-based policy example for a dashboard]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-dashboards
func (c *Client) UpdateDashboard(ctx context.Context, params *UpdateDashboardInput, optFns ...func(*Options)) (*UpdateDashboardOutput, error) {
	if params == nil {
		params = &UpdateDashboardInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDashboard", params, optFns, c.addOperationUpdateDashboardMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDashboardOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateDashboardInput struct {

	//  The name or ARN of the dashboard.
	//
	// This member is required.
	DashboardId *string

	//  The refresh schedule configuration for the dashboard.
	RefreshSchedule *types.RefreshSchedule

	//  Specifies whether termination protection is enabled for the dashboard. If
	// termination protection is enabled, you cannot delete the dashboard until
	// termination protection is disabled.
	TerminationProtectionEnabled *bool

	//  An array of widgets for the dashboard. A custom dashboard can have a maximum
	// of 10 widgets.
	//
	// To add new widgets, pass in an array that includes the existing widgets along
	// with any new widgets. Run the GetDashboard operation to get the list of widgets
	// for the dashboard.
	//
	// To remove widgets, pass in an array that includes the existing widgets minus
	// the widgets you want removed.
	Widgets []types.RequestWidget

	noSmithyDocumentSerde
}

type UpdateDashboardOutput struct {

	//  The timestamp that shows when the dashboard was created.
	CreatedTimestamp *time.Time

	//  The ARN for the dashboard.
	DashboardArn *string

	//  The name for the dashboard.
	Name *string

	//  The refresh schedule for the dashboard, if configured.
	RefreshSchedule *types.RefreshSchedule

	//  Indicates whether termination protection is enabled for the dashboard.
	TerminationProtectionEnabled *bool

	//  The type of dashboard.
	Type types.DashboardType

	//  The timestamp that shows when the dashboard was updated.
	UpdatedTimestamp *time.Time

	//  An array of widgets for the dashboard.
	Widgets []types.Widget

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDashboardMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateDashboard{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateDashboard{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateDashboard"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateDashboardValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDashboard(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDashboard(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateDashboard",
	}
}
