//go:build go1.22

// Package hueapi provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/oapi-codegen/oapi-codegen/v2 version v2.4.1 DO NOT EDIT.
package hueapi

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strings"
	"time"

	"github.com/oapi-codegen/runtime"
	strictnethttp "github.com/oapi-codegen/runtime/strictmiddleware/nethttp"
)

const (
	HueApplicationKeyScopes = "HueApplicationKey.Scopes"
)

// Defines values for BridgeGetType.
const (
	BridgeGetTypeBridge BridgeGetType = "bridge"
)

// Defines values for BridgeHomeGetType.
const (
	BridgeHomeGetTypeBridgeHome BridgeHomeGetType = "bridge_home"
)

// Defines values for BridgePutType.
const (
	BridgePutTypeBridge BridgePutType = "bridge"
)

// Defines values for ColorTemperatureDeltaAction.
const (
	ColorTemperatureDeltaActionDown ColorTemperatureDeltaAction = "down"
	ColorTemperatureDeltaActionStop ColorTemperatureDeltaAction = "stop"
	ColorTemperatureDeltaActionUp   ColorTemperatureDeltaAction = "up"
)

// Defines values for DeviceGetType.
const (
	DeviceGetTypeDevice DeviceGetType = "device"
)

// Defines values for DeviceGetUsertestStatus.
const (
	DeviceGetUsertestStatusChanging DeviceGetUsertestStatus = "changing"
	DeviceGetUsertestStatusSet      DeviceGetUsertestStatus = "set"
)

// Defines values for DevicePowerGetPowerStateBatteryState.
const (
	DevicePowerGetPowerStateBatteryStateCritical DevicePowerGetPowerStateBatteryState = "critical"
	DevicePowerGetPowerStateBatteryStateLow      DevicePowerGetPowerStateBatteryState = "low"
	DevicePowerGetPowerStateBatteryStateNormal   DevicePowerGetPowerStateBatteryState = "normal"
)

// Defines values for DevicePutIdentifyAction.
const (
	Identify DevicePutIdentifyAction = "identify"
)

// Defines values for DevicePutType.
const (
	DevicePutTypeDevice DevicePutType = "device"
)

// Defines values for DimmingDeltaAction.
const (
	DimmingDeltaActionDown DimmingDeltaAction = "down"
	DimmingDeltaActionStop DimmingDeltaAction = "stop"
	DimmingDeltaActionUp   DimmingDeltaAction = "up"
)

// Defines values for GroupedLightPutType.
const (
	GroupedLightPutTypeGroupedLight GroupedLightPutType = "grouped_light"
)

// Defines values for LightArchetype.
const (
	LightArchetypeBollard           LightArchetype = "bollard"
	LightArchetypeCandleBulb        LightArchetype = "candle_bulb"
	LightArchetypeCeilingHorizontal LightArchetype = "ceiling_horizontal"
	LightArchetypeCeilingRound      LightArchetype = "ceiling_round"
	LightArchetypeCeilingSquare     LightArchetype = "ceiling_square"
	LightArchetypeCeilingTube       LightArchetype = "ceiling_tube"
	LightArchetypeChristmasTree     LightArchetype = "christmas_tree"
	LightArchetypeClassicBulb       LightArchetype = "classic_bulb"
	LightArchetypeDoubleSpot        LightArchetype = "double_spot"
	LightArchetypeEdisonBulb        LightArchetype = "edison_bulb"
	LightArchetypeEllipseBulb       LightArchetype = "ellipse_bulb"
	LightArchetypeFlexibleLamp      LightArchetype = "flexible_lamp"
	LightArchetypeFloodBulb         LightArchetype = "flood_bulb"
	LightArchetypeFloorLantern      LightArchetype = "floor_lantern"
	LightArchetypeFloorShade        LightArchetype = "floor_shade"
	LightArchetypeGroundSpot        LightArchetype = "ground_spot"
	LightArchetypeHueBloom          LightArchetype = "hue_bloom"
	LightArchetypeHueCentris        LightArchetype = "hue_centris"
	LightArchetypeHueGo             LightArchetype = "hue_go"
	LightArchetypeHueIris           LightArchetype = "hue_iris"
	LightArchetypeHueLightstrip     LightArchetype = "hue_lightstrip"
	LightArchetypeHueLightstripPc   LightArchetype = "hue_lightstrip_pc"
	LightArchetypeHueLightstripTv   LightArchetype = "hue_lightstrip_tv"
	LightArchetypeHuePlay           LightArchetype = "hue_play"
	LightArchetypeHueSigne          LightArchetype = "hue_signe"
	LightArchetypeHueTube           LightArchetype = "hue_tube"
	LightArchetypeLargeGlobeBulb    LightArchetype = "large_globe_bulb"
	LightArchetypeLusterBulb        LightArchetype = "luster_bulb"
	LightArchetypePendantLong       LightArchetype = "pendant_long"
	LightArchetypePendantRound      LightArchetype = "pendant_round"
	LightArchetypePendantSpot       LightArchetype = "pendant_spot"
	LightArchetypePlug              LightArchetype = "plug"
	LightArchetypeRecessedCeiling   LightArchetype = "recessed_ceiling"
	LightArchetypeRecessedFloor     LightArchetype = "recessed_floor"
	LightArchetypeSingleSpot        LightArchetype = "single_spot"
	LightArchetypeSmallGlobeBulb    LightArchetype = "small_globe_bulb"
	LightArchetypeSpotBulb          LightArchetype = "spot_bulb"
	LightArchetypeStringLight       LightArchetype = "string_light"
	LightArchetypeSultanBulb        LightArchetype = "sultan_bulb"
	LightArchetypeTableShade        LightArchetype = "table_shade"
	LightArchetypeTableWash         LightArchetype = "table_wash"
	LightArchetypeTriangleBulb      LightArchetype = "triangle_bulb"
	LightArchetypeUnknownArchetype  LightArchetype = "unknown_archetype"
	LightArchetypeVintageBulb       LightArchetype = "vintage_bulb"
	LightArchetypeVintageCandleBulb LightArchetype = "vintage_candle_bulb"
	LightArchetypeWallLantern       LightArchetype = "wall_lantern"
	LightArchetypeWallShade         LightArchetype = "wall_shade"
	LightArchetypeWallSpot          LightArchetype = "wall_spot"
	LightArchetypeWallWasher        LightArchetype = "wall_washer"
)

// Defines values for LightGetColorGamutType.
const (
	LightGetColorGamutTypeA     LightGetColorGamutType = "A"
	LightGetColorGamutTypeB     LightGetColorGamutType = "B"
	LightGetColorGamutTypeC     LightGetColorGamutType = "C"
	LightGetColorGamutTypeOther LightGetColorGamutType = "other"
)

// Defines values for LightGetMode.
const (
	LightGetModeNormal    LightGetMode = "normal"
	LightGetModeStreaming LightGetMode = "streaming"
)

// Defines values for LightGetPowerupDimmingColorMode.
const (
	LightGetPowerupDimmingColorModeColor            LightGetPowerupDimmingColorMode = "color"
	LightGetPowerupDimmingColorModeColorTemperature LightGetPowerupDimmingColorMode = "color_temperature"
	LightGetPowerupDimmingColorModePrevious         LightGetPowerupDimmingColorMode = "previous"
)

// Defines values for LightGetPowerupDimmingMode.
const (
	LightGetPowerupDimmingModeDimming  LightGetPowerupDimmingMode = "dimming"
	LightGetPowerupDimmingModePrevious LightGetPowerupDimmingMode = "previous"
)

// Defines values for LightGetPowerupOnMode.
const (
	LightGetPowerupOnModeOn       LightGetPowerupOnMode = "on"
	LightGetPowerupOnModePrevious LightGetPowerupOnMode = "previous"
	LightGetPowerupOnModeToggle   LightGetPowerupOnMode = "toggle"
)

// Defines values for LightGetPowerupPreset.
const (
	LightGetPowerupPresetCustom      LightGetPowerupPreset = "custom"
	LightGetPowerupPresetLastOnState LightGetPowerupPreset = "last_on_state"
	LightGetPowerupPresetPowerfail   LightGetPowerupPreset = "powerfail"
	LightGetPowerupPresetSafety      LightGetPowerupPreset = "safety"
)

// Defines values for LightPutMode.
const (
	Normal    LightPutMode = "normal"
	Streaming LightPutMode = "streaming"
)

// Defines values for MotionGetSensitivityStatus.
const (
	MotionGetSensitivityStatusChanging MotionGetSensitivityStatus = "changing"
	MotionGetSensitivityStatusSet      MotionGetSensitivityStatus = "set"
)

// Defines values for PowerupDimmingColorMode.
const (
	PowerupDimmingColorModeColor            PowerupDimmingColorMode = "color"
	PowerupDimmingColorModeColorTemperature PowerupDimmingColorMode = "color_temperature"
	PowerupDimmingColorModePrevious         PowerupDimmingColorMode = "previous"
)

// Defines values for PowerupDimmingMode.
const (
	PowerupDimmingModeDimming  PowerupDimmingMode = "dimming"
	PowerupDimmingModePrevious PowerupDimmingMode = "previous"
)

// Defines values for PowerupOnMode.
const (
	PowerupOnModeOn       PowerupOnMode = "on"
	PowerupOnModePrevious PowerupOnMode = "previous"
	PowerupOnModeToggle   PowerupOnMode = "toggle"
)

// Defines values for PowerupPreset.
const (
	PowerupPresetCustom      PowerupPreset = "custom"
	PowerupPresetLastOnState PowerupPreset = "last_on_state"
	PowerupPresetPowerfail   PowerupPreset = "powerfail"
	PowerupPresetSafety      PowerupPreset = "safety"
)

// Defines values for ProductArchetype.
const (
	ProductArchetypeBollard           ProductArchetype = "bollard"
	ProductArchetypeBridgeV2          ProductArchetype = "bridge_v2"
	ProductArchetypeCandleBulb        ProductArchetype = "candle_bulb"
	ProductArchetypeCeilingHorizontal ProductArchetype = "ceiling_horizontal"
	ProductArchetypeCeilingRound      ProductArchetype = "ceiling_round"
	ProductArchetypeCeilingSquare     ProductArchetype = "ceiling_square"
	ProductArchetypeCeilingTube       ProductArchetype = "ceiling_tube"
	ProductArchetypeChristmasTree     ProductArchetype = "christmas_tree"
	ProductArchetypeClassicBulb       ProductArchetype = "classic_bulb"
	ProductArchetypeDoubleSpot        ProductArchetype = "double_spot"
	ProductArchetypeEdisonBulb        ProductArchetype = "edison_bulb"
	ProductArchetypeEllipseBulb       ProductArchetype = "ellipse_bulb"
	ProductArchetypeFlexibleLamp      ProductArchetype = "flexible_lamp"
	ProductArchetypeFloodBulb         ProductArchetype = "flood_bulb"
	ProductArchetypeFloorLantern      ProductArchetype = "floor_lantern"
	ProductArchetypeFloorShade        ProductArchetype = "floor_shade"
	ProductArchetypeGroundSpot        ProductArchetype = "ground_spot"
	ProductArchetypeHueBloom          ProductArchetype = "hue_bloom"
	ProductArchetypeHueCentris        ProductArchetype = "hue_centris"
	ProductArchetypeHueGo             ProductArchetype = "hue_go"
	ProductArchetypeHueIris           ProductArchetype = "hue_iris"
	ProductArchetypeHueLightstrip     ProductArchetype = "hue_lightstrip"
	ProductArchetypeHueLightstripPc   ProductArchetype = "hue_lightstrip_pc"
	ProductArchetypeHueLightstripTv   ProductArchetype = "hue_lightstrip_tv"
	ProductArchetypeHuePlay           ProductArchetype = "hue_play"
	ProductArchetypeHueSigne          ProductArchetype = "hue_signe"
	ProductArchetypeHueTube           ProductArchetype = "hue_tube"
	ProductArchetypeLargeGlobeBulb    ProductArchetype = "large_globe_bulb"
	ProductArchetypeLusterBulb        ProductArchetype = "luster_bulb"
	ProductArchetypePendantLong       ProductArchetype = "pendant_long"
	ProductArchetypePendantRound      ProductArchetype = "pendant_round"
	ProductArchetypePendantSpot       ProductArchetype = "pendant_spot"
	ProductArchetypePlug              ProductArchetype = "plug"
	ProductArchetypeRecessedCeiling   ProductArchetype = "recessed_ceiling"
	ProductArchetypeRecessedFloor     ProductArchetype = "recessed_floor"
	ProductArchetypeSingleSpot        ProductArchetype = "single_spot"
	ProductArchetypeSmallGlobeBulb    ProductArchetype = "small_globe_bulb"
	ProductArchetypeSpotBulb          ProductArchetype = "spot_bulb"
	ProductArchetypeStringLight       ProductArchetype = "string_light"
	ProductArchetypeSultanBulb        ProductArchetype = "sultan_bulb"
	ProductArchetypeTableShade        ProductArchetype = "table_shade"
	ProductArchetypeTableWash         ProductArchetype = "table_wash"
	ProductArchetypeTriangleBulb      ProductArchetype = "triangle_bulb"
	ProductArchetypeUnknownArchetype  ProductArchetype = "unknown_archetype"
	ProductArchetypeVintageBulb       ProductArchetype = "vintage_bulb"
	ProductArchetypeVintageCandleBulb ProductArchetype = "vintage_candle_bulb"
	ProductArchetypeWallLantern       ProductArchetype = "wall_lantern"
	ProductArchetypeWallShade         ProductArchetype = "wall_shade"
	ProductArchetypeWallSpot          ProductArchetype = "wall_spot"
	ProductArchetypeWallWasher        ProductArchetype = "wall_washer"
)

// Defines values for ResourceGetType.
const (
	ResourceGetTypeAuthV1                     ResourceGetType = "auth_v1"
	ResourceGetTypeBehaviorInstance           ResourceGetType = "behavior_instance"
	ResourceGetTypeBehaviorScript             ResourceGetType = "behavior_script"
	ResourceGetTypeBridge                     ResourceGetType = "bridge"
	ResourceGetTypeBridgeHome                 ResourceGetType = "bridge_home"
	ResourceGetTypeButton                     ResourceGetType = "button"
	ResourceGetTypeCameraMotion               ResourceGetType = "camera_motion"
	ResourceGetTypeContact                    ResourceGetType = "contact"
	ResourceGetTypeDevice                     ResourceGetType = "device"
	ResourceGetTypeDevicePower                ResourceGetType = "device_power"
	ResourceGetTypeEntertainment              ResourceGetType = "entertainment"
	ResourceGetTypeEntertainmentConfiguration ResourceGetType = "entertainment_configuration"
	ResourceGetTypeGeofence                   ResourceGetType = "geofence"
	ResourceGetTypeGeofenceClient             ResourceGetType = "geofence_client"
	ResourceGetTypeGeolocation                ResourceGetType = "geolocation"
	ResourceGetTypeGroupedLight               ResourceGetType = "grouped_light"
	ResourceGetTypeHomekit                    ResourceGetType = "homekit"
	ResourceGetTypeLight                      ResourceGetType = "light"
	ResourceGetTypeLightLevel                 ResourceGetType = "light_level"
	ResourceGetTypeMatter                     ResourceGetType = "matter"
	ResourceGetTypeMatterFabric               ResourceGetType = "matter_fabric"
	ResourceGetTypeMotion                     ResourceGetType = "motion"
	ResourceGetTypePublicImage                ResourceGetType = "public_image"
	ResourceGetTypeRelativeRotary             ResourceGetType = "relative_rotary"
	ResourceGetTypeRoom                       ResourceGetType = "room"
	ResourceGetTypeScene                      ResourceGetType = "scene"
	ResourceGetTypeSmartScene                 ResourceGetType = "smart_scene"
	ResourceGetTypeTamper                     ResourceGetType = "tamper"
	ResourceGetTypeTemperature                ResourceGetType = "temperature"
	ResourceGetTypeZgpConnectivity            ResourceGetType = "zgp_connectivity"
	ResourceGetTypeZigbeeBridgeConnectivity   ResourceGetType = "zigbee_bridge_connectivity"
	ResourceGetTypeZigbeeConnectivity         ResourceGetType = "zigbee_connectivity"
	ResourceGetTypeZigbeeDeviceDiscovery      ResourceGetType = "zigbee_device_discovery"
	ResourceGetTypeZone                       ResourceGetType = "zone"
)

// Defines values for ResourceIdentifierRtype.
const (
	ResourceIdentifierRtypeAuthV1                     ResourceIdentifierRtype = "auth_v1"
	ResourceIdentifierRtypeBehaviorInstance           ResourceIdentifierRtype = "behavior_instance"
	ResourceIdentifierRtypeBehaviorScript             ResourceIdentifierRtype = "behavior_script"
	ResourceIdentifierRtypeBridge                     ResourceIdentifierRtype = "bridge"
	ResourceIdentifierRtypeBridgeHome                 ResourceIdentifierRtype = "bridge_home"
	ResourceIdentifierRtypeButton                     ResourceIdentifierRtype = "button"
	ResourceIdentifierRtypeCameraMotion               ResourceIdentifierRtype = "camera_motion"
	ResourceIdentifierRtypeContact                    ResourceIdentifierRtype = "contact"
	ResourceIdentifierRtypeDevice                     ResourceIdentifierRtype = "device"
	ResourceIdentifierRtypeDevicePower                ResourceIdentifierRtype = "device_power"
	ResourceIdentifierRtypeEntertainment              ResourceIdentifierRtype = "entertainment"
	ResourceIdentifierRtypeEntertainmentConfiguration ResourceIdentifierRtype = "entertainment_configuration"
	ResourceIdentifierRtypeGeofence                   ResourceIdentifierRtype = "geofence"
	ResourceIdentifierRtypeGeofenceClient             ResourceIdentifierRtype = "geofence_client"
	ResourceIdentifierRtypeGeolocation                ResourceIdentifierRtype = "geolocation"
	ResourceIdentifierRtypeGroupedLight               ResourceIdentifierRtype = "grouped_light"
	ResourceIdentifierRtypeHomekit                    ResourceIdentifierRtype = "homekit"
	ResourceIdentifierRtypeLight                      ResourceIdentifierRtype = "light"
	ResourceIdentifierRtypeLightLevel                 ResourceIdentifierRtype = "light_level"
	ResourceIdentifierRtypeMatter                     ResourceIdentifierRtype = "matter"
	ResourceIdentifierRtypeMatterFabric               ResourceIdentifierRtype = "matter_fabric"
	ResourceIdentifierRtypeMotion                     ResourceIdentifierRtype = "motion"
	ResourceIdentifierRtypePublicImage                ResourceIdentifierRtype = "public_image"
	ResourceIdentifierRtypeRelativeRotary             ResourceIdentifierRtype = "relative_rotary"
	ResourceIdentifierRtypeRoom                       ResourceIdentifierRtype = "room"
	ResourceIdentifierRtypeScene                      ResourceIdentifierRtype = "scene"
	ResourceIdentifierRtypeSmartScene                 ResourceIdentifierRtype = "smart_scene"
	ResourceIdentifierRtypeTamper                     ResourceIdentifierRtype = "tamper"
	ResourceIdentifierRtypeTemperature                ResourceIdentifierRtype = "temperature"
	ResourceIdentifierRtypeZgpConnectivity            ResourceIdentifierRtype = "zgp_connectivity"
	ResourceIdentifierRtypeZigbeeBridgeConnectivity   ResourceIdentifierRtype = "zigbee_bridge_connectivity"
	ResourceIdentifierRtypeZigbeeConnectivity         ResourceIdentifierRtype = "zigbee_connectivity"
	ResourceIdentifierRtypeZigbeeDeviceDiscovery      ResourceIdentifierRtype = "zigbee_device_discovery"
	ResourceIdentifierRtypeZone                       ResourceIdentifierRtype = "zone"
)

// Defines values for RoomArchetype.
const (
	RoomArchetypeAttic       RoomArchetype = "attic"
	RoomArchetypeBalcony     RoomArchetype = "balcony"
	RoomArchetypeBarbecue    RoomArchetype = "barbecue"
	RoomArchetypeBathroom    RoomArchetype = "bathroom"
	RoomArchetypeBedroom     RoomArchetype = "bedroom"
	RoomArchetypeCarport     RoomArchetype = "carport"
	RoomArchetypeCloset      RoomArchetype = "closet"
	RoomArchetypeComputer    RoomArchetype = "computer"
	RoomArchetypeDining      RoomArchetype = "dining"
	RoomArchetypeDownstairs  RoomArchetype = "downstairs"
	RoomArchetypeDriveway    RoomArchetype = "driveway"
	RoomArchetypeFrontDoor   RoomArchetype = "front_door"
	RoomArchetypeGarage      RoomArchetype = "garage"
	RoomArchetypeGarden      RoomArchetype = "garden"
	RoomArchetypeGuestRoom   RoomArchetype = "guest_room"
	RoomArchetypeGym         RoomArchetype = "gym"
	RoomArchetypeHallway     RoomArchetype = "hallway"
	RoomArchetypeHome        RoomArchetype = "home"
	RoomArchetypeKidsBedroom RoomArchetype = "kids_bedroom"
	RoomArchetypeKitchen     RoomArchetype = "kitchen"
	RoomArchetypeLaundryRoom RoomArchetype = "laundry_room"
	RoomArchetypeLivingRoom  RoomArchetype = "living_room"
	RoomArchetypeLounge      RoomArchetype = "lounge"
	RoomArchetypeManCave     RoomArchetype = "man_cave"
	RoomArchetypeMusic       RoomArchetype = "music"
	RoomArchetypeNursery     RoomArchetype = "nursery"
	RoomArchetypeOffice      RoomArchetype = "office"
	RoomArchetypeOther       RoomArchetype = "other"
	RoomArchetypePool        RoomArchetype = "pool"
	RoomArchetypePorch       RoomArchetype = "porch"
	RoomArchetypeReading     RoomArchetype = "reading"
	RoomArchetypeRecreation  RoomArchetype = "recreation"
	RoomArchetypeStaircase   RoomArchetype = "staircase"
	RoomArchetypeStorage     RoomArchetype = "storage"
	RoomArchetypeStudio      RoomArchetype = "studio"
	RoomArchetypeTerrace     RoomArchetype = "terrace"
	RoomArchetypeToilet      RoomArchetype = "toilet"
	RoomArchetypeTopFloor    RoomArchetype = "top_floor"
	RoomArchetypeTv          RoomArchetype = "tv"
	RoomArchetypeUpstairs    RoomArchetype = "upstairs"
)

// Defines values for SceneGetStatusActive.
const (
	SceneGetStatusActiveDynamicPalette SceneGetStatusActive = "dynamic_palette"
	SceneGetStatusActiveInactive       SceneGetStatusActive = "inactive"
	SceneGetStatusActiveStatic         SceneGetStatusActive = "static"
)

// Defines values for SceneGetType.
const (
	SceneGetTypeScene SceneGetType = "scene"
)

// Defines values for ScenePostType.
const (
	ScenePostTypeScene ScenePostType = "scene"
)

// Defines values for ScenePutType.
const (
	Scene ScenePutType = "scene"
)

// Defines values for SceneRecallAction.
const (
	SceneRecallActionActive         SceneRecallAction = "active"
	SceneRecallActionDynamicPalette SceneRecallAction = "dynamic_palette"
	SceneRecallActionStatic         SceneRecallAction = "static"
)

// Defines values for SignalingSignal.
const (
	SignalingSignalAlternating SignalingSignal = "alternating"
	SignalingSignalNoSignal    SignalingSignal = "no_signal"
	SignalingSignalOnOff       SignalingSignal = "on_off"
	SignalingSignalOnOffColor  SignalingSignal = "on_off_color"
)

// Defines values for SmartSceneGetState.
const (
	Active   SmartSceneGetState = "active"
	Inactive SmartSceneGetState = "inactive"
)

// Defines values for SmartSceneGetType.
const (
	SmartSceneGetTypeSmartScene SmartSceneGetType = "smart_scene"
)

// Defines values for SmartSceneOptionalRecallAction.
const (
	SmartSceneOptionalRecallActionActivate   SmartSceneOptionalRecallAction = "activate"
	SmartSceneOptionalRecallActionDeactivate SmartSceneOptionalRecallAction = "deactivate"
)

// Defines values for SmartScenePostType.
const (
	SmartScenePostTypeSmartScene SmartScenePostType = "smart_scene"
)

// Defines values for SmartScenePutType.
const (
	SmartScene SmartScenePutType = "smart_scene"
)

// Defines values for SmartSceneRecallAction.
const (
	SmartSceneRecallActionActivate   SmartSceneRecallAction = "activate"
	SmartSceneRecallActionDeactivate SmartSceneRecallAction = "deactivate"
)

// Defines values for SmartSceneTimeslotGetStartTimeKind.
const (
	Sunset SmartSceneTimeslotGetStartTimeKind = "sunset"
	Time   SmartSceneTimeslotGetStartTimeKind = "time"
)

// Defines values for SupportedDynamicStatus.
const (
	DynamicPalette SupportedDynamicStatus = "dynamic_palette"
	None           SupportedDynamicStatus = "none"
)

// Defines values for SupportedEffects.
const (
	SupportedEffectsCandle   SupportedEffects = "candle"
	SupportedEffectsFire     SupportedEffects = "fire"
	SupportedEffectsGlisten  SupportedEffects = "glisten"
	SupportedEffectsNoEffect SupportedEffects = "no_effect"
	SupportedEffectsOpal     SupportedEffects = "opal"
	SupportedEffectsPrism    SupportedEffects = "prism"
	SupportedEffectsSparkle  SupportedEffects = "sparkle"
)

// Defines values for SupportedGradientMode.
const (
	InterpolatedPalette         SupportedGradientMode = "interpolated_palette"
	InterpolatedPaletteMirrored SupportedGradientMode = "interpolated_palette_mirrored"
	RandomPixelated             SupportedGradientMode = "random_pixelated"
)

// Defines values for SupportedSignals.
const (
	SupportedSignalsAlternating SupportedSignals = "alternating"
	SupportedSignalsNoSignal    SupportedSignals = "no_signal"
	SupportedSignalsOnOff       SupportedSignals = "on_off"
	SupportedSignalsOnOffColor  SupportedSignals = "on_off_color"
)

// Defines values for SupportedTimedEffects.
const (
	SupportedTimedEffectsNoEffect SupportedTimedEffects = "no_effect"
	SupportedTimedEffectsSunrise  SupportedTimedEffects = "sunrise"
)

// Defines values for TemperaturePutType.
const (
	Temperature TemperaturePutType = "temperature"
)

// Defines values for Weekday.
const (
	Friday    Weekday = "friday"
	Monday    Weekday = "monday"
	Saturday  Weekday = "saturday"
	Sunday    Weekday = "sunday"
	Thursday  Weekday = "thursday"
	Tuesday   Weekday = "tuesday"
	Wednesday Weekday = "wednesday"
)

// ActionGet defines model for ActionGet.
type ActionGet struct {
	// Action The action to be executed on recall
	Action *struct {
		Color            *Color            `json:"color,omitempty"`
		ColorTemperature *ColorTemperature `json:"color_temperature,omitempty"`
		Dimming          *Dimming          `json:"dimming,omitempty"`

		// Effects Basic feature containing effect properties.
		Effects *struct {
			Effect *SupportedEffects `json:"effect,omitempty"`
		} `json:"effects,omitempty"`

		// Gradient Basic feature containing gradient properties.
		Gradient *Gradient `json:"gradient,omitempty"`
		On       *On       `json:"on,omitempty"`
	} `json:"action,omitempty"`

	// Id Unique identifier representing a specific resource instance
	Id *string `json:"id,omitempty"`

	// IdV1 Clip v1 resource identifier
	IdV1   *string             `json:"id_v1,omitempty"`
	Owner  *ResourceIdentifier `json:"owner,omitempty"`
	Target *ResourceIdentifier `json:"target,omitempty"`

	// Type Type of the supported resources
	Type *string `json:"type,omitempty"`
}

// ActionPost defines model for ActionPost.
type ActionPost struct {
	// Action The action to be executed on recall
	Action struct {
		Color            *Color `json:"color,omitempty"`
		ColorTemperature *struct {
			// Mirek color temperature in mirek or null when the light color is not in the ct spectrum
			Mirek *Mirek `json:"mirek,omitempty"`
		} `json:"color_temperature,omitempty"`
		Dimming  *Dimming  `json:"dimming,omitempty"`
		Dynamics *Dynamics `json:"dynamics,omitempty"`

		// Effects Basic feature containing effect properties.
		Effects *struct {
			Effect *SupportedEffects `json:"effect,omitempty"`
		} `json:"effects,omitempty"`

		// Gradient Basic feature containing gradient properties.
		Gradient *Gradient `json:"gradient,omitempty"`
		On       *On       `json:"on,omitempty"`
	} `json:"action"`
	Target ResourceIdentifier `json:"target"`
}

// Alert Joined alert control
type Alert struct {
	Action *string `json:"action,omitempty"`
}

// ApiResponse defines model for ApiResponse.
type ApiResponse struct {
	Data   *[]map[string]interface{} `json:"data,omitempty"`
	Errors *[]Error                  `json:"errors,omitempty"`
}

// BridgeGet defines model for BridgeGet.
type BridgeGet struct {
	// BridgeId Unique identifier of the bridge as printed on the device. Lower case (shouldn't it be upper case?)
	BridgeId *string `json:"bridge_id,omitempty"`

	// Id Unique identifier representing a specific resource instance
	Id *string `json:"id,omitempty"`

	// IdV1 Clip v1 resource identifier
	IdV1     *string             `json:"id_v1,omitempty"`
	Owner    *ResourceIdentifier `json:"owner,omitempty"`
	TimeZone *struct {
		// TimeZone Time zone where the user's home is located (as Olson ID).
		TimeZone *string `json:"time_zone,omitempty"`
	} `json:"time_zone,omitempty"`
	Type *BridgeGetType `json:"type,omitempty"`
}

// BridgeGetType defines model for BridgeGet.Type.
type BridgeGetType string

// BridgeHomeGet defines model for BridgeHomeGet.
type BridgeHomeGet struct {
	// Children Child devices/services to group by the derived group.
	Children *[]ResourceIdentifier `json:"children,omitempty"`

	// Id Unique identifier representing a specific resource instance
	Id *string `json:"id,omitempty"`

	// IdV1 Clip v1 resource identifier
	IdV1 *string `json:"id_v1,omitempty"`

	// Services References all services aggregating control and state of children in the group.
	// This includes all services grouped in the group hierarchy given by child relation.
	// This includes all services of a device grouped in the group hierarchy given by child relation.
	// Aggregation is per service type, ie every service type which can be grouped has a corresponding definition
	// of grouped type Supported types: – grouped_light
	Services *[]ResourceIdentifier `json:"services,omitempty"`
	Type     *BridgeHomeGetType    `json:"type,omitempty"`
}

// BridgeHomeGetType defines model for BridgeHomeGet.Type.
type BridgeHomeGetType string

// BridgePut defines model for BridgePut.
type BridgePut struct {
	Type *BridgePutType `json:"type,omitempty"`
}

// BridgePutType defines model for BridgePut.Type.
type BridgePutType string

// Brightness Brightness percentage. value cannot be 0, writing 0 changes it to lowest possible brightness
type Brightness = float32

// Color defines model for Color.
type Color struct {
	// Xy CIE XY gamut position
	Xy *GamutPosition `json:"xy,omitempty"`
}

// ColorPaletteGet defines model for ColorPaletteGet.
type ColorPaletteGet struct {
	Color   *Color   `json:"color,omitempty"`
	Dimming *Dimming `json:"dimming,omitempty"`
}

// ColorTemperature defines model for ColorTemperature.
type ColorTemperature struct {
	// Mirek color temperature in mirek or null when the light color is not in the ct spectrum
	Mirek *Mirek `json:"mirek,omitempty"`
}

// ColorTemperatureDelta defines model for ColorTemperatureDelta.
type ColorTemperatureDelta struct {
	Action *ColorTemperatureDeltaAction `json:"action,omitempty"`

	// MirekDelta Mirek delta to current mirek. Clip at mirek_minimum and mirek_maximum of mirek_schema.
	MirekDelta *int `json:"mirek_delta,omitempty"`
}

// ColorTemperatureDeltaAction defines model for ColorTemperatureDelta.Action.
type ColorTemperatureDeltaAction string

// ColorTemperaturePalettePost defines model for ColorTemperaturePalettePost.
type ColorTemperaturePalettePost struct {
	ColorTemperature *struct {
		// Mirek color temperature in mirek or null when the light color is not in the ct spectrum
		Mirek *Mirek `json:"mirek,omitempty"`
	} `json:"color_temperature,omitempty"`
	Dimming *Dimming `json:"dimming,omitempty"`
}

// DayTimeslotsGet defines model for DayTimeslotsGet.
type DayTimeslotsGet struct {
	Recurrence []Weekday               `json:"recurrence"`
	Timeslots  []SmartSceneTimeslotGet `json:"timeslots"`
}

// DeviceGet defines model for DeviceGet.
type DeviceGet struct {
	// Id Unique identifier representing a specific resource instance
	Id *string `json:"id,omitempty"`

	// IdV1 Clip v1 resource identifier
	IdV1     *string `json:"id_v1,omitempty"`
	Metadata *struct {
		// Archetype The default archetype given by manufacturer. Can be changed by user.
		Archetype *ProductArchetype `json:"archetype,omitempty"`

		// Name Human readable name of a resource
		Name *string `json:"name,omitempty"`
	} `json:"metadata,omitempty"`
	Owner       *ResourceIdentifier `json:"owner,omitempty"`
	ProductData *ProductData        `json:"product_data,omitempty"`

	// Services References all services providing control and state of the device.
	Services *[]ResourceIdentifier `json:"services,omitempty"`
	Type     *DeviceGetType        `json:"type,omitempty"`
	Usertest *struct {
		Status *DeviceGetUsertestStatus `json:"status,omitempty"`

		// Usertest Activates or extends user usertest mode of device for 120 seconds.
		// `false` deactivates usertest mode.
		// In usertest mode, devices report changes in state faster and indicate state changes on device LED (if applicable)
		Usertest *bool `json:"usertest,omitempty"`
	} `json:"usertest,omitempty"`
}

// DeviceGetType defines model for DeviceGet.Type.
type DeviceGetType string

// DeviceGetUsertestStatus defines model for DeviceGet.Usertest.Status.
type DeviceGetUsertestStatus string

// DevicePowerGet defines model for DevicePowerGet.
type DevicePowerGet struct {
	// Id Unique identifier representing a specific resource instance
	Id *string `json:"id,omitempty"`

	// IdV1 Clip v1 resource identifier
	IdV1       *string             `json:"id_v1,omitempty"`
	Owner      *ResourceIdentifier `json:"owner,omitempty"`
	PowerState *struct {
		// BatteryLevel The current battery state in percent, only for battery powered devices.
		BatteryLevel *int `json:"battery_level,omitempty"`

		// BatteryState Status of the power source of a device, only for battery powered devices.
		//
		// - `normal` – battery level is sufficient
		// - `low` – battery level low, some features (e.g. software update) might stop working, please change battery soon
		// - `critical` – battery level critical, device can fail any moment
		BatteryState *DevicePowerGetPowerStateBatteryState `json:"battery_state,omitempty"`
	} `json:"power_state,omitempty"`

	// Type Type of the supported resources
	Type *string `json:"type,omitempty"`
}

// DevicePowerGetPowerStateBatteryState Status of the power source of a device, only for battery powered devices.
//
// - `normal` – battery level is sufficient
// - `low` – battery level low, some features (e.g. software update) might stop working, please change battery soon
// - `critical` – battery level critical, device can fail any moment
type DevicePowerGetPowerStateBatteryState string

// DevicePut defines model for DevicePut.
type DevicePut struct {
	Identify *struct {
		// Action Triggers a visual identification sequence, current implemented as (which can change in the future):
		// Bridge performs Zigbee LED identification cycles for 5 seconds Lights perform one breathe cycle Sensors
		// perform LED identification cycles for 15 seconds
		Action *DevicePutIdentifyAction `json:"action,omitempty"`
	} `json:"identify,omitempty"`
	Metadata *struct {
		// Archetype The default archetype given by manufacturer. Can be changed by user.
		Archetype *ProductArchetype `json:"archetype,omitempty"`

		// Name Human readable name of a resource
		Name *string `json:"name,omitempty"`
	} `json:"metadata,omitempty"`
	Type     *DevicePutType `json:"type,omitempty"`
	Usertest *struct {
		// Usertest Activates or extends user usertest mode of device for 120 seconds.
		// `false` deactivates usertest mode. In usertest mode, devices report changes in state faster and indicate
		// state changes on device LED (if applicable)
		Usertest *bool `json:"usertest,omitempty"`
	} `json:"usertest,omitempty"`
}

// DevicePutIdentifyAction Triggers a visual identification sequence, current implemented as (which can change in the future):
// Bridge performs Zigbee LED identification cycles for 5 seconds Lights perform one breathe cycle Sensors
// perform LED identification cycles for 15 seconds
type DevicePutIdentifyAction string

// DevicePutType defines model for DevicePut.Type.
type DevicePutType string

// Dimming defines model for Dimming.
type Dimming struct {
	// Brightness Brightness percentage. value cannot be 0, writing 0 changes it to lowest possible brightness
	Brightness *Brightness `json:"brightness,omitempty"`
}

// DimmingDelta defines model for DimmingDelta.
type DimmingDelta struct {
	Action *DimmingDeltaAction `json:"action,omitempty"`

	// BrightnessDelta Brightness percentage of full-scale increase delta to current dimlevel. Clip at Max-level or Min-level.
	BrightnessDelta *float32 `json:"brightness_delta,omitempty"`
}

// DimmingDeltaAction defines model for DimmingDelta.Action.
type DimmingDeltaAction string

// Dynamics defines model for Dynamics.
type Dynamics struct {
	// Duration Duration of a light transition or timed effects in ms.
	Duration *int `json:"duration,omitempty"`
}

// Effects Basic feature containing effect properties.
type Effects struct {
	Effect *SupportedEffects `json:"effect,omitempty"`
}

// Error defines model for Error.
type Error struct {
	// Description a human-readable explanation specific to this occurrence of the problem.
	Description *string `json:"description,omitempty"`
}

// ErrorResponse defines model for ErrorResponse.
type ErrorResponse struct {
	Errors *[]Error `json:"errors,omitempty"`
}

// GamutPosition CIE XY gamut position
type GamutPosition struct {
	// X X position in color gamut
	X *float32 `json:"x,omitempty"`

	// Y y position in color gamut
	Y *float32 `json:"y,omitempty"`
}

// Gradient Basic feature containing gradient properties.
type Gradient struct {
	// Mode Mode in which the points are currently being deployed. If not provided during PUT/POST it will be defaulted to interpolated_palette
	Mode *SupportedGradientMode `json:"mode,omitempty"`

	// Points Collection of gradients points. For control of the gradient points through a PUT a minimum of 2 points need to be provided.
	Points *[]Color `json:"points,omitempty"`
}

// GroupedLightGet defines model for GroupedLightGet.
type GroupedLightGet struct {
	// Alert Joined alert control
	Alert *struct {
		ActionValues *[]string `json:"action_values,omitempty"`
	} `json:"alert,omitempty"`
	Dimming *Dimming `json:"dimming,omitempty"`

	// Id Unique identifier representing a specific resource instance
	Id *string `json:"id,omitempty"`

	// IdV1 Clip v1 resource identifier
	IdV1  *string             `json:"id_v1,omitempty"`
	On    *On                 `json:"on,omitempty"`
	Owner *ResourceIdentifier `json:"owner,omitempty"`

	// Signaling Feature containing basic signaling properties.
	Signaling *struct {
		// SignalValues Signals that the light supports.
		SignalValues *[]SupportedSignals `json:"signal_values,omitempty"`
	} `json:"signaling,omitempty"`

	// Type Type of the supported resources
	Type *string `json:"type,omitempty"`
}

// GroupedLightPut defines model for GroupedLightPut.
type GroupedLightPut struct {
	// Alert Joined alert control
	Alert                 *Alert                 `json:"alert,omitempty"`
	Color                 *Color                 `json:"color,omitempty"`
	ColorTemperature      *ColorTemperature      `json:"color_temperature,omitempty"`
	ColorTemperatureDelta *ColorTemperatureDelta `json:"color_temperature_delta,omitempty"`
	Dimming               *Dimming               `json:"dimming,omitempty"`
	DimmingDelta          *DimmingDelta          `json:"dimming_delta,omitempty"`
	Dynamics              *Dynamics              `json:"dynamics,omitempty"`
	On                    *On                    `json:"on,omitempty"`

	// Signaling Feature containing basic signaling properties.
	Signaling *Signaling `json:"signaling,omitempty"`

	// Type Type of the supported resources (always `grouped_light` here)
	Type *GroupedLightPutType `json:"type,omitempty"`
}

// GroupedLightPutType Type of the supported resources (always `grouped_light` here)
type GroupedLightPutType string

// LightArchetype Light archetype
type LightArchetype string

// LightDynamics defines model for LightDynamics.
type LightDynamics struct {
	// Duration Duration of a light transition or timed effects in ms.
	Duration *int `json:"duration,omitempty"`

	// Speed Speed of dynamic palette or effect.
	// The speed is valid for the dynamic palette if the status is `dynamic_palette` or for the corresponding effect listed in status.
	// In case of status `none`, the speed is not valid.
	Speed *float32 `json:"speed,omitempty"`
}

// LightGet defines model for LightGet.
type LightGet struct {
	// Alert TODO
	Alert *map[string]interface{} `json:"alert,omitempty"`
	Color *struct {
		// Gamut Color gamut of color bulb. Some bulbs do not properly return the Gamut information. In this case this is not present.
		Gamut *struct {
			// Blue CIE XY gamut position
			Blue *GamutPosition `json:"blue,omitempty"`

			// Green CIE XY gamut position
			Green *GamutPosition `json:"green,omitempty"`

			// Red CIE XY gamut position
			Red *GamutPosition `json:"red,omitempty"`
		} `json:"gamut,omitempty"`

		// GamutType The gammut types supported by hue – A Gamut of early Philips color-only products – B Limited gamut of first Hue color products – C Richer color gamut of Hue white and color ambiance products – other Color gamut of non-hue products with non-hue gamuts resp w/o gamut
		GamutType *LightGetColorGamutType `json:"gamut_type,omitempty"`

		// Xy CIE XY gamut position
		Xy *GamutPosition `json:"xy,omitempty"`
	} `json:"color,omitempty"`
	ColorTemperature *struct {
		// Mirek color temperature in mirek or null when the light color is not in the ct spectrum
		Mirek       *int `json:"mirek,omitempty"`
		MirekSchema *struct {
			// MirekMaximum maximum color temperature this light supports
			MirekMaximum *int `json:"mirek_maximum,omitempty"`

			// MirekMinimum minimum color temperature this light supports
			MirekMinimum *int `json:"mirek_minimum,omitempty"`
		} `json:"mirek_schema,omitempty"`

		// MirekValid Indication whether the value presented in mirek is valid
		MirekValid *bool `json:"mirek_valid,omitempty"`
	} `json:"color_temperature,omitempty"`
	Dimming *struct {
		// Brightness Brightness percentage. value cannot be 0, writing 0 changes it to lowest possible brightness
		Brightness *Brightness `json:"brightness,omitempty"`

		// MinDimLevel Percentage of the maximum lumen the device outputs on minimum brightness
		MinDimLevel *float32 `json:"min_dim_level,omitempty"`
	} `json:"dimming,omitempty"`
	Dynamics *struct {
		// Speed speed of dynamic palette or effect. The speed is valid for the dynamic palette if the status is dynamic_palette or for the corresponding effect listed in status. In case of status none, the speed is not valid
		Speed *float32 `json:"speed,omitempty"`

		// SpeedValid Indicates whether the value presented in speed is valid
		SpeedValid *bool `json:"speed_valid,omitempty"`

		// Status Current status of the lamp with dynamics.
		Status *SupportedDynamicStatus `json:"status,omitempty"`

		// StatusValues Statuses in which a lamp could be when playing dynamics.
		StatusValues *[]SupportedDynamicStatus `json:"status_values,omitempty"`
	} `json:"dynamics,omitempty"`

	// Effects Basic feature containing effect properties.
	Effects *struct {
		Effect *SupportedEffects `json:"effect,omitempty"`

		// EffectValues Possible status values in which a light could be when playing an effect.
		EffectValues *[]SupportedEffects `json:"effect_values,omitempty"`
		Status       *SupportedEffects   `json:"status,omitempty"`

		// StatusValues Possible status values in which a light could be when playing an effect.
		StatusValues *[]SupportedEffects `json:"status_values,omitempty"`
	} `json:"effects,omitempty"`
	Gradient *struct {
		// Mode Mode in which the points are currently being deployed. If not provided during PUT/POST it will be defaulted to interpolated_palette
		Mode *SupportedGradientMode `json:"mode,omitempty"`

		// ModeValues Modes a gradient device can deploy the gradient palette of colors
		ModeValues *[]SupportedGradientMode `json:"mode_values,omitempty"`

		// PixelCount Number of pixels in the device
		PixelCount *int `json:"pixel_count,omitempty"`

		// Points Collection of gradients points. For control of the gradient points through a PUT a minimum of 2 points need to be provided.
		Points *[]Color `json:"points,omitempty"`

		// PointsCapable Number of color points that gradient lamp is capable of showing with gradience.
		PointsCapable *int `json:"points_capable,omitempty"`
	} `json:"gradient,omitempty"`

	// Id Unique identifier representing a specific resource instance
	Id *string `json:"id,omitempty"`

	// IdV1 Clip v1 resource identifier
	IdV1 *string `json:"id_v1,omitempty"`

	// Metadata Deprecated, use metadata on device level
	Metadata *struct {
		// Archetype Light archetype
		Archetype *LightArchetype `json:"archetype,omitempty"`

		// FixedMired A fixed mired value of the white lamp
		FixedMired *int `json:"fixed_mired,omitempty"`

		// Name Human readable name of a resource
		Name *string `json:"name,omitempty"`
	} `json:"metadata,omitempty"`
	Mode  *LightGetMode       `json:"mode,omitempty"`
	On    *On                 `json:"on,omitempty"`
	Owner *ResourceIdentifier `json:"owner,omitempty"`

	// Powerup Feature containing properties to configure powerup behaviour of a lightsource.
	Powerup *struct {
		// Configured Indicates if the shown values have been configured in the lightsource.
		Configured *bool `json:"configured,omitempty"`
		Dimming    *struct {
			Color *struct {
				ColorTemperature *struct {
					Color *Color `json:"color,omitempty"`

					// Mirek color temperature in mirek or null when the light color is not in the ct spectrum
					Mirek *Mirek `json:"mirek,omitempty"`
				} `json:"color_temperature,omitempty"`

				// Mode State to activate after powerup. Availability of “color_temperature” and “color” modes depend on the capabilities of the lamp. Colortemperature will set the colortemperature to the specified value after power up. When setting color_temperature, the color_temperature property must be included Color will set the color tot he specified value after power up. When setting color mode, the color property must be included Previous will set color to the state it was in before powering off.
				Mode *LightGetPowerupDimmingColorMode `json:"mode,omitempty"`
			} `json:"color,omitempty"`
			Dimming *Dimming `json:"dimming,omitempty"`

			// Mode Dimming will set the brightness to the specified value after power up.
			// When setting mode “dimming”, the dimming property must be included.
			// Previous will set brightness to the state it was in before powering off.
			Mode *LightGetPowerupDimmingMode `json:"mode,omitempty"`
		} `json:"dimming,omitempty"`
		On *struct {
			// Mode State to activate after powerup.
			// On will use the value specified in the “on” property.
			// When setting mode “on”, the on property must be included.
			// Toggle will alternate between on and off on each subsequent power toggle.
			// Previous will return to the state it was in before powering off.
			Mode *LightGetPowerupOnMode `json:"mode,omitempty"`
			On   *On                    `json:"on,omitempty"`
		} `json:"on,omitempty"`

		// Preset When setting the custom preset the additional properties can be set. For all other presets, no other properties can be included.
		Preset *LightGetPowerupPreset `json:"preset,omitempty"`
	} `json:"powerup,omitempty"`

	// Signaling Feature containing signaling properties.
	Signaling *struct {
		// Colors Colors that were provided for the active effect.
		Colors *[]Color `json:"colors,omitempty"`

		// EstimatedEnd Timestamp indicating when the active signal is expected to end. Value is not set if there is no_signal
		EstimatedEnd *int                `json:"estimated_end,omitempty"`
		SignalValues *[]SupportedSignals `json:"signal_values,omitempty"`
	} `json:"signaling,omitempty"`

	// TimedEffects Basic feature containing timed effect properties.
	TimedEffects *struct {
		// Duration Duration is mandatory when timed effect is set except for no_effect. Resolution decreases for a larger duration. e.g Effects with duration smaller than a minute will be rounded to a resolution of 1s, while effects with duration larger than an hour will be arounded up to a resolution of 300s. Duration has a max of 21600000 ms.
		Duration *int `json:"duration,omitempty"`

		// Effect Current status values the light is in regarding timed effects
		Effect *SupportedTimedEffects `json:"effect,omitempty"`

		// EffectValues Possible timed effect values you can set in a light
		EffectValues *[]SupportedTimedEffects `json:"effect_values,omitempty"`

		// Status Current status values the light is in regarding timed effects
		Status *SupportedTimedEffects `json:"status,omitempty"`

		// StatusValues Possible status values in which a light could be when playing a timed effect.
		StatusValues *[]SupportedTimedEffects `json:"status_values,omitempty"`
	} `json:"timed_effects,omitempty"`

	// Type Type of the supported resources
	Type *string `json:"type,omitempty"`
}

// LightGetColorGamutType The gammut types supported by hue – A Gamut of early Philips color-only products – B Limited gamut of first Hue color products – C Richer color gamut of Hue white and color ambiance products – other Color gamut of non-hue products with non-hue gamuts resp w/o gamut
type LightGetColorGamutType string

// LightGetMode defines model for LightGet.Mode.
type LightGetMode string

// LightGetPowerupDimmingColorMode State to activate after powerup. Availability of “color_temperature” and “color” modes depend on the capabilities of the lamp. Colortemperature will set the colortemperature to the specified value after power up. When setting color_temperature, the color_temperature property must be included Color will set the color tot he specified value after power up. When setting color mode, the color property must be included Previous will set color to the state it was in before powering off.
type LightGetPowerupDimmingColorMode string

// LightGetPowerupDimmingMode Dimming will set the brightness to the specified value after power up.
// When setting mode “dimming”, the dimming property must be included.
// Previous will set brightness to the state it was in before powering off.
type LightGetPowerupDimmingMode string

// LightGetPowerupOnMode State to activate after powerup.
// On will use the value specified in the “on” property.
// When setting mode “on”, the on property must be included.
// Toggle will alternate between on and off on each subsequent power toggle.
// Previous will return to the state it was in before powering off.
type LightGetPowerupOnMode string

// LightGetPowerupPreset When setting the custom preset the additional properties can be set. For all other presets, no other properties can be included.
type LightGetPowerupPreset string

// LightLevelGet defines model for LightLevelGet.
type LightLevelGet struct {
	// Enabled true when sensor is activated, false when deactivated
	Enabled *bool `json:"enabled,omitempty"`

	// Id Unique identifier representing a specific resource instance
	Id *string `json:"id,omitempty"`

	// IdV1 Clip v1 resource identifier
	IdV1  *string `json:"id_v1,omitempty"`
	Light *struct {
		// LightLevel Deprecated. Moved to light_level_report/light_level
		LightLevel       *int `json:"light_level,omitempty"`
		LightLevelReport *struct {
			// Changed last time the value of this property is changed.
			Changed *time.Time `json:"changed,omitempty"`

			// LightLevel Light level in 10000*log10(lux) +1 measured by sensor.
			// Logarithmic scale used because the human eye adjusts to light levels and small changes at low
			// lux levels are more noticeable than at high lux levels.
			// This allows use of linear scale configuration sliders.
			LightLevel *int `json:"light_level,omitempty"`
		} `json:"light_level_report,omitempty"`

		// LightLevelValid Deprecated. Indication whether the value presented in light_level is valid
		LightLevelValid *bool `json:"light_level_valid,omitempty"`
	} `json:"light,omitempty"`
	Owner *ResourceIdentifier `json:"owner,omitempty"`

	// Type Type of the supported resources
	Type *string `json:"type,omitempty"`
}

// LightLevelPut defines model for LightLevelPut.
type LightLevelPut struct {
	// Enabled true when sensor is activated, false when deactivated
	Enabled *bool `json:"enabled,omitempty"`

	// Type Type of the supported resources (always `light_level` here)
	Type *string `json:"type,omitempty"`
}

// LightPut defines model for LightPut.
type LightPut struct {
	// Alert Joined alert control
	Alert                 *Alert                 `json:"alert,omitempty"`
	Color                 *Color                 `json:"color,omitempty"`
	ColorTemperature      *ColorTemperature      `json:"color_temperature,omitempty"`
	ColorTemperatureDelta *ColorTemperatureDelta `json:"color_temperature_delta,omitempty"`
	Dimming               *Dimming               `json:"dimming,omitempty"`
	DimmingDelta          *DimmingDelta          `json:"dimming_delta,omitempty"`
	Dynamics              *LightDynamics         `json:"dynamics,omitempty"`

	// Effects Basic feature containing effect properties.
	Effects *Effects `json:"effects,omitempty"`

	// Gradient Basic feature containing gradient properties.
	Gradient *Gradient     `json:"gradient,omitempty"`
	Mode     *LightPutMode `json:"mode,omitempty"`
	On       *On           `json:"on,omitempty"`

	// Powerup Feature containing properties to configure powerup behaviour of a lightsource.
	Powerup *Powerup `json:"powerup,omitempty"`

	// Signaling Feature containing basic signaling properties.
	Signaling *Signaling `json:"signaling,omitempty"`

	// TimedEffects Basic feature containing timed effect properties.
	TimedEffects *struct {
		// Duration Duration is mandatory when timed effect is set except for no_effect. Resolution decreases for a larger duration. e.g Effects with duration smaller than a minute will be rounded to a resolution of 1s, while effects with duration larger than an hour will be arounded up to a resolution of 300s. Duration has a max of 21600000 ms.
		Duration *int `json:"duration,omitempty"`

		// Effect Current status values the light is in regarding timed effects
		Effect *SupportedTimedEffects `json:"effect,omitempty"`
	} `json:"timed_effects,omitempty"`

	// Type Type of the supported resources (always `light` here)
	Type *string `json:"type,omitempty"`
}

// LightPutMode defines model for LightPut.Mode.
type LightPutMode string

// Mirek color temperature in mirek or null when the light color is not in the ct spectrum
type Mirek = int

// MotionGet defines model for MotionGet.
type MotionGet struct {
	// Enabled ture when the sensor is activated, false when deactivated
	Enabled *bool `json:"enabled,omitempty"`

	// Id Unique identifier representing a specific resource instance
	Id *string `json:"id,omitempty"`

	// IdV1 Clip v1 resource identifier
	IdV1   *string `json:"id_v1,omitempty"`
	Motion *struct {
		// Motion Deprecated. Moved to motion_report/motion.
		Motion       *bool `json:"motion,omitempty"`
		MotionReport *struct {
			// Changed last time the value of this property is changed
			Changed *string `json:"changed,omitempty"`

			// Motion true if motion is detected
			Motion *bool `json:"motion,omitempty"`
		} `json:"motion_report,omitempty"`

		// MotionValid Deprecated. Motion is valid when motion_report property is present, invalid when absent.
		MotionValid *bool `json:"motion_valid,omitempty"`
	} `json:"motion,omitempty"`
	Owner       *ResourceIdentifier `json:"owner,omitempty"`
	Sensitivity *struct {
		// Sensitivity Sensitivity of the sensor. Value in the range 0 to sensitivity_max
		Sensitivity *int `json:"sensitivity,omitempty"`

		// SensitivityMax Maximum value of the sensitivity configuration attribute.
		SensitivityMax *int                        `json:"sensitivity_max,omitempty"`
		Status         *MotionGetSensitivityStatus `json:"status,omitempty"`
	} `json:"sensitivity,omitempty"`

	// Type Type of the supported resources
	Type *string `json:"type,omitempty"`
}

// MotionGetSensitivityStatus defines model for MotionGet.Sensitivity.Status.
type MotionGetSensitivityStatus string

// MotionPut defines model for MotionPut.
type MotionPut struct {
	// Enabled true when the sensor is activated, false when deactivated
	Enabled     *bool `json:"enabled,omitempty"`
	Sensitivity *struct {
		// Sensitivity Sensitivity of the sensor. Value in the range 0 to sensitivity_max.
		Sensitivity *int `json:"sensitivity,omitempty"`
	} `json:"sensitivity,omitempty"`

	// Type Type of the supported resources (always `motion` here)
	Type *string `json:"type,omitempty"`
}

// On defines model for On.
type On struct {
	// On On/Off state of the light on=true, off=false
	On *bool `json:"on,omitempty"`
}

// Powerup Feature containing properties to configure powerup behaviour of a lightsource.
type Powerup struct {
	// Configured Indicates if the shown values have been configured in the lightsource.
	Configured *bool `json:"configured,omitempty"`
	Dimming    *struct {
		Color *struct {
			ColorTemperature *struct {
				Color *Color `json:"color,omitempty"`

				// Mirek color temperature in mirek or null when the light color is not in the ct spectrum
				Mirek *Mirek `json:"mirek,omitempty"`
			} `json:"color_temperature,omitempty"`

			// Mode State to activate after powerup. Availability of “color_temperature” and “color” modes depend on the capabilities of the lamp. Colortemperature will set the colortemperature to the specified value after power up. When setting color_temperature, the color_temperature property must be included Color will set the color tot he specified value after power up. When setting color mode, the color property must be included Previous will set color to the state it was in before powering off.
			Mode *PowerupDimmingColorMode `json:"mode,omitempty"`
		} `json:"color,omitempty"`

		// Dimming Brightness percentage. value cannot be 0, writing 0 changes it to lowest possible brightness
		Dimming *Brightness `json:"dimming,omitempty"`

		// Mode Dimming will set the brightness to the specified value after power up.
		// When setting mode “dimming”, the dimming property must be included.
		// Previous will set brightness to the state it was in before powering off.
		Mode *PowerupDimmingMode `json:"mode,omitempty"`
	} `json:"dimming,omitempty"`
	On *struct {
		// Mode State to activate after powerup.
		// On will use the value specified in the “on” property.
		// When setting mode “on”, the on property must be included.
		// Toggle will alternate between on and off on each subsequent power toggle.
		// Previous will return to the state it was in before powering off.
		Mode *PowerupOnMode `json:"mode,omitempty"`
		On   *On            `json:"on,omitempty"`
	} `json:"on,omitempty"`

	// Preset When setting the custom preset the additional properties can be set. For all other presets, no other properties can be included.
	Preset *PowerupPreset `json:"preset,omitempty"`
}

// PowerupDimmingColorMode State to activate after powerup. Availability of “color_temperature” and “color” modes depend on the capabilities of the lamp. Colortemperature will set the colortemperature to the specified value after power up. When setting color_temperature, the color_temperature property must be included Color will set the color tot he specified value after power up. When setting color mode, the color property must be included Previous will set color to the state it was in before powering off.
type PowerupDimmingColorMode string

// PowerupDimmingMode Dimming will set the brightness to the specified value after power up.
// When setting mode “dimming”, the dimming property must be included.
// Previous will set brightness to the state it was in before powering off.
type PowerupDimmingMode string

// PowerupOnMode State to activate after powerup.
// On will use the value specified in the “on” property.
// When setting mode “on”, the on property must be included.
// Toggle will alternate between on and off on each subsequent power toggle.
// Previous will return to the state it was in before powering off.
type PowerupOnMode string

// PowerupPreset When setting the custom preset the additional properties can be set. For all other presets, no other properties can be included.
type PowerupPreset string

// ProductArchetype The default archetype given by manufacturer. Can be changed by user.
type ProductArchetype string

// ProductData defines model for ProductData.
type ProductData struct {
	// Certified This device is Hue certified
	Certified *bool `json:"certified,omitempty"`

	// HardwarePlatformType Hardware type; identified by Manufacturer code and ImageType
	HardwarePlatformType *string `json:"hardware_platform_type,omitempty"`

	// ManufacturerName Name of device manufacturer
	ManufacturerName *string `json:"manufacturer_name,omitempty"`

	// ModelId Unique identification of device model
	ModelId *string `json:"model_id,omitempty"`

	// ProductArchetype The default archetype given by manufacturer. Can be changed by user.
	ProductArchetype *ProductArchetype `json:"product_archetype,omitempty"`

	// ProductName Name of the product
	ProductName *string `json:"product_name,omitempty"`

	// SoftwareVersion Software version of the product
	SoftwareVersion *string `json:"software_version,omitempty"`
}

// Resource Common resource properties
type Resource struct {
	// Id Unique identifier representing a specific resource instance
	Id *string `json:"id,omitempty"`

	// IdV1 Clip v1 resource identifier
	IdV1 *string `json:"id_v1,omitempty"`

	// Type Type of the supported resources
	Type *string `json:"type,omitempty"`
}

// ResourceGet defines model for ResourceGet.
type ResourceGet struct {
	// Id Unique identifier representing a specific resource instance
	Id *string `json:"id,omitempty"`

	// IdV1 Clip v1 resource identifier
	IdV1  *string             `json:"id_v1,omitempty"`
	Owner *ResourceIdentifier `json:"owner,omitempty"`

	// Type Type of the supported resources
	Type *ResourceGetType `json:"type,omitempty"`
}

// ResourceGetType Type of the supported resources
type ResourceGetType string

// ResourceIdentifier defines model for ResourceIdentifier.
type ResourceIdentifier struct {
	// Rid The unique id of the referenced resource
	Rid *string `json:"rid,omitempty"`

	// Rtype The type of the referenced resource
	Rtype *ResourceIdentifierRtype `json:"rtype,omitempty"`
}

// ResourceIdentifierRtype The type of the referenced resource
type ResourceIdentifierRtype string

// ResourceOwned defines model for ResourceOwned.
type ResourceOwned struct {
	// Id Unique identifier representing a specific resource instance
	Id *string `json:"id,omitempty"`

	// IdV1 Clip v1 resource identifier
	IdV1  *string             `json:"id_v1,omitempty"`
	Owner *ResourceIdentifier `json:"owner,omitempty"`

	// Type Type of the supported resources
	Type *string `json:"type,omitempty"`
}

// RoomArchetype Possible archetypes of a room
type RoomArchetype string

// RoomGet defines model for RoomGet.
type RoomGet struct {
	// Children Child devices/services to group by the derived group
	Children *[]ResourceIdentifier `json:"children,omitempty"`

	// Id Unique identifier representing a specific resource instance
	Id *string `json:"id,omitempty"`

	// IdV1 Clip v1 resource identifier
	IdV1 *string `json:"id_v1,omitempty"`

	// Metadata configuration object for a room
	Metadata *struct {
		// Archetype Possible archetypes of a room
		Archetype *RoomArchetype `json:"archetype,omitempty"`

		// Name Human readable name of a resource
		Name *string `json:"name,omitempty"`
	} `json:"metadata,omitempty"`

	// Services References all services aggregating control and state of children in the group.
	// This includes all services grouped in the group hierarchy given by child relation.
	// This includes all services of a device grouped in the group hierarchy given by child relation.
	// Aggregation is per service type, ie every service type which can be grouped has a corresponding definition of
	// grouped type.
	// Supported types: – grouped_light
	Services *[]ResourceIdentifier `json:"services,omitempty"`

	// Type Type of the supported resources
	Type *string `json:"type,omitempty"`
}

// RoomPut defines model for RoomPut.
type RoomPut struct {
	// Children Child devices/services to group by the derived group
	Children *[]ResourceIdentifier `json:"children,omitempty"`

	// Metadata configuration object for a room
	Metadata *struct {
		// Archetype Possible archetypes of a room
		Archetype *RoomArchetype `json:"archetype,omitempty"`

		// Name Human readable name of a resource
		Name *string `json:"name,omitempty"`
	} `json:"metadata,omitempty"`

	// Type Type of the supported resources (always `room` here)
	Type *string `json:"type,omitempty"`
}

// SceneGet defines model for SceneGet.
type SceneGet struct {
	// Actions List of actions to be executed synchronously on recall
	Actions *[]ActionGet `json:"actions,omitempty"`

	// AutoDynamic Indicates whether to automatically start the scene dynamically on active recall
	AutoDynamic *bool               `json:"auto_dynamic,omitempty"`
	Group       *ResourceIdentifier `json:"group,omitempty"`

	// Id Unique identifier representing a specific resource instance
	Id *string `json:"id,omitempty"`

	// IdV1 Clip v1 resource identifier
	IdV1     *string             `json:"id_v1,omitempty"`
	Metadata *SceneMetadata      `json:"metadata,omitempty"`
	Owner    *ResourceIdentifier `json:"owner,omitempty"`

	// Palette Group of colors that describe the palette of colors to be used when playing dynamics
	Palette *ScenePalette `json:"palette,omitempty"`

	// Speed Speed of dynamic palette for this scene
	Speed  *float32 `json:"speed,omitempty"`
	Status *struct {
		Active *SceneGetStatusActive `json:"active,omitempty"`
	} `json:"status,omitempty"`
	Type *SceneGetType `json:"type,omitempty"`
}

// SceneGetStatusActive defines model for SceneGet.Status.Active.
type SceneGetStatusActive string

// SceneGetType defines model for SceneGet.Type.
type SceneGetType string

// SceneMetadata defines model for SceneMetadata.
type SceneMetadata struct {
	// Appdata Application specific data. Free format string.
	Appdata *string             `json:"appdata,omitempty"`
	Image   *ResourceIdentifier `json:"image,omitempty"`

	// Name Human readable name of a resource
	Name *string `json:"name,omitempty"`
}

// ScenePalette Group of colors that describe the palette of colors to be used when playing dynamics
type ScenePalette struct {
	Color            *[]ColorPaletteGet             `json:"color,omitempty"`
	ColorTemperature *[]ColorTemperaturePalettePost `json:"color_temperature,omitempty"`
	Dimming          *[]Dimming                     `json:"dimming,omitempty"`
	Effects          *[]struct {
		Effect *SupportedEffects `json:"effect,omitempty"`
	} `json:"effects,omitempty"`
}

// ScenePost defines model for ScenePost.
type ScenePost struct {
	// Actions List of actions to be executed synchronously on recall
	Actions []ActionPost `json:"actions"`

	// AutoDynamic Indicates whether to automatically start the scene dynamically on active recall
	AutoDynamic *bool              `json:"auto_dynamic,omitempty"`
	Group       ResourceIdentifier `json:"group"`
	Metadata    SceneMetadata      `json:"metadata"`

	// Palette Group of colors that describe the palette of colors to be used when playing dynamics
	Palette *ScenePalette `json:"palette,omitempty"`

	// Speed Speed of dynamic palette for this scene
	Speed *float32       `json:"speed,omitempty"`
	Type  *ScenePostType `json:"type,omitempty"`
}

// ScenePostType defines model for ScenePost.Type.
type ScenePostType string

// ScenePut defines model for ScenePut.
type ScenePut struct {
	// Actions List of actions to be executed synchronously on recall
	Actions *[]ActionPost `json:"actions,omitempty"`

	// AutoDynamic Indicates whether to automatically start the scene dynamically on active recall
	AutoDynamic *bool          `json:"auto_dynamic,omitempty"`
	Metadata    *SceneMetadata `json:"metadata,omitempty"`

	// Palette Group of colors that describe the palette of colors to be used when playing dynamics
	Palette *ScenePalette `json:"palette,omitempty"`
	Recall  *SceneRecall  `json:"recall,omitempty"`

	// Speed Speed of dynamic palette for this scene
	Speed *float32      `json:"speed,omitempty"`
	Type  *ScenePutType `json:"type,omitempty"`
}

// ScenePutType defines model for ScenePut.Type.
type ScenePutType string

// SceneRecall defines model for SceneRecall.
type SceneRecall struct {
	// Action When writing active, the actions in the scene are executed on the target. dynamic_palette starts dynamic scene with colors in the Palette object.
	Action  *SceneRecallAction `json:"action,omitempty"`
	Dimming *Dimming           `json:"dimming,omitempty"`

	// Duration Transition to the scene within the timeframe given by duration
	Duration *int `json:"duration,omitempty"`
}

// SceneRecallAction When writing active, the actions in the scene are executed on the target. dynamic_palette starts dynamic scene with colors in the Palette object.
type SceneRecallAction string

// Signaling Feature containing basic signaling properties.
type Signaling struct {
	// Color List of colors to apply to the signal (not supported by all signals)
	Color *[]Color `json:"color,omitempty"`

	// Duration Duration has a max of 65534000 ms and a stepsize of 1 second.
	// Values inbetween steps will be rounded.
	// Duration is ignored for `no_signal`.
	Duration *int `json:"duration,omitempty"`

	// Signal - `no_signal`: No signal is active. Write “no_signal” to stop active signal.
	// - `on_off`: Toggles between max brightness and Off in fixed color.
	// - `on_off_color`: Toggles between off and max brightness with color provided.
	// - `alternating`: Alternates between 2 provided colors.
	Signal *SignalingSignal `json:"signal,omitempty"`
}

// SignalingSignal - `no_signal`: No signal is active. Write “no_signal” to stop active signal.
// - `on_off`: Toggles between max brightness and Off in fixed color.
// - `on_off_color`: Toggles between off and max brightness with color provided.
// - `alternating`: Alternates between 2 provided colors.
type SignalingSignal string

// SmartSceneGet defines model for SmartSceneGet.
type SmartSceneGet struct {
	// ActiveTimeslot the active time slot in execution
	ActiveTimeslot *struct {
		TimeslotId int     `json:"timeslot_id"`
		Weekday    Weekday `json:"weekday"`
	} `json:"active_timeslot,omitempty"`
	Group ResourceIdentifier `json:"group"`

	// Id Unique identifier representing a specific resource instance
	Id *string `json:"id,omitempty"`

	// IdV1 Clip v1 resource identifier
	IdV1     *string                     `json:"id_v1,omitempty"`
	Metadata SmartSceneMetadataWithImage `json:"metadata"`

	// State the current state of the smart scene. The default state is inactive if no recall is provided
	State SmartSceneGetState `json:"state"`

	// TransitionDuration duration of the transition from on one timeslot's scene to the other (defaults to 60000ms)
	TransitionDuration int                `json:"transition_duration"`
	Type               *SmartSceneGetType `json:"type,omitempty"`

	// WeekTimeslots information on what is the light state for every timeslot of the day
	WeekTimeslots []DayTimeslotsGet `json:"week_timeslots"`
}

// SmartSceneGetState the current state of the smart scene. The default state is inactive if no recall is provided
type SmartSceneGetState string

// SmartSceneGetType defines model for SmartSceneGet.Type.
type SmartSceneGetType string

// SmartSceneMetadata defines model for SmartSceneMetadata.
type SmartSceneMetadata struct {
	// Appdata Application specific data. Free format string.
	Appdata *string `json:"appdata,omitempty"`

	// Name Human readable name of a resource
	Name *string `json:"name,omitempty"`
}

// SmartSceneMetadataWithImage defines model for SmartSceneMetadataWithImage.
type SmartSceneMetadataWithImage struct {
	// Appdata Application specific data. Free format string.
	Appdata *string             `json:"appdata,omitempty"`
	Image   *ResourceIdentifier `json:"image,omitempty"`

	// Name Human readable name of a resource
	Name *string `json:"name,omitempty"`
}

// SmartSceneOptionalRecall defines model for SmartSceneOptionalRecall.
type SmartSceneOptionalRecall struct {
	// Action Activate will start the smart (24h) scene; deactivate will stop it
	Action *SmartSceneOptionalRecallAction `json:"action,omitempty"`
}

// SmartSceneOptionalRecallAction Activate will start the smart (24h) scene; deactivate will stop it
type SmartSceneOptionalRecallAction string

// SmartScenePost defines model for SmartScenePost.
type SmartScenePost struct {
	Group    ResourceIdentifier          `json:"group"`
	Metadata SmartSceneMetadataWithImage `json:"metadata"`
	Recall   *SmartSceneRecall           `json:"recall,omitempty"`

	// TransitionDuration duration of the transition from on one timeslot's scene to the other (defaults to 60000ms)
	TransitionDuration *int                `json:"transition_duration,omitempty"`
	Type               *SmartScenePostType `json:"type,omitempty"`

	// WeekTimeslots information on what is the light state for every timeslot of the day
	WeekTimeslots []DayTimeslotsGet `json:"week_timeslots"`
}

// SmartScenePostType defines model for SmartScenePost.Type.
type SmartScenePostType string

// SmartScenePut defines model for SmartScenePut.
type SmartScenePut struct {
	Metadata *SmartSceneMetadata       `json:"metadata,omitempty"`
	Recall   *SmartSceneOptionalRecall `json:"recall,omitempty"`

	// TransitionDuration duration of the transition from on one timeslot's scene to the other (defaults to 60000ms)
	TransitionDuration *int               `json:"transition_duration,omitempty"`
	Type               *SmartScenePutType `json:"type,omitempty"`

	// WeekTimeslots information on what is the light state for every timeslot of the day
	WeekTimeslots *[]DayTimeslotsGet `json:"week_timeslots,omitempty"`
}

// SmartScenePutType defines model for SmartScenePut.Type.
type SmartScenePutType string

// SmartSceneRecall defines model for SmartSceneRecall.
type SmartSceneRecall struct {
	// Action Activate will start the smart (24h) scene; deactivate will stop it
	Action SmartSceneRecallAction `json:"action"`
}

// SmartSceneRecallAction Activate will start the smart (24h) scene; deactivate will stop it
type SmartSceneRecallAction string

// SmartSceneTimeslotGet defines model for SmartSceneTimeslotGet.
type SmartSceneTimeslotGet struct {
	StartTime struct {
		Kind SmartSceneTimeslotGetStartTimeKind `json:"kind"`

		// Time this property is only used when property “kind” is “time”
		Time *struct {
			Hour   *int `json:"hour,omitempty"`
			Minute *int `json:"minute,omitempty"`
			Second *int `json:"second,omitempty"`
		} `json:"time,omitempty"`
	} `json:"start_time"`
	Target ResourceIdentifier `json:"target"`
}

// SmartSceneTimeslotGetStartTimeKind defines model for SmartSceneTimeslotGet.StartTime.Kind.
type SmartSceneTimeslotGetStartTimeKind string

// SupportedDynamicStatus Current status of the lamp with dynamics.
type SupportedDynamicStatus string

// SupportedEffects defines model for SupportedEffects.
type SupportedEffects string

// SupportedGradientMode Mode in which the points are currently being deployed. If not provided during PUT/POST it will be defaulted to interpolated_palette
type SupportedGradientMode string

// SupportedSignals Indicates which signal is currently active.
type SupportedSignals string

// SupportedTimedEffects Current status values the light is in regarding timed effects
type SupportedTimedEffects string

// TemperatureGet defines model for TemperatureGet.
type TemperatureGet struct {
	// Enabled `true` when sensor is activated, `false` when deactivated
	Enabled *bool `json:"enabled,omitempty"`

	// Id Unique identifier representing a specific resource instance
	Id *string `json:"id,omitempty"`

	// IdV1 Clip v1 resource identifier
	IdV1        *string             `json:"id_v1,omitempty"`
	Owner       *ResourceIdentifier `json:"owner,omitempty"`
	Temperature *struct {
		// Temperature Deprecated. Moved to Temperature_report/temperature
		Temperature       *float32 `json:"temperature,omitempty"`
		TemperatureReport *struct {
			// Changed last time the value of this property is changed.
			Changed *time.Time `json:"changed,omitempty"`

			// Temperature Temperature in 1.00 degrees Celsius
			Temperature *float32 `json:"temperature,omitempty"`
		} `json:"temperature_report,omitempty"`

		// TemperatureValid Deprecated. Indication whether the value presented in temperature is valid
		TemperatureValid *bool `json:"temperature_valid,omitempty"`
	} `json:"temperature,omitempty"`

	// Type Type of the supported resources
	Type *string `json:"type,omitempty"`
}

// TemperaturePut defines model for TemperaturePut.
type TemperaturePut struct {
	// Enabled true when sensor is activated, false when deactivated
	Enabled *bool `json:"enabled,omitempty"`

	// Type Type of the supported resources (always `temperature` here)
	Type *TemperaturePutType `json:"type,omitempty"`
}

// TemperaturePutType Type of the supported resources (always `temperature` here)
type TemperaturePutType string

// Weekday defines model for Weekday.
type Weekday string

// Response defines model for response.
type Response = []struct {
	Error *struct {
		Address     *string `json:"address,omitempty"`
		Description *string `json:"description,omitempty"`
		Type        *int    `json:"type,omitempty"`
	} `json:"error,omitempty"`
	Success *struct {
		Clientkey *string `json:"clientkey,omitempty"`
		Username  *string `json:"username,omitempty"`
	} `json:"success,omitempty"`
}

// Conflict defines model for Conflict.
type Conflict = ErrorResponse

// Forbidden defines model for Forbidden.
type Forbidden = ErrorResponse

// InsufficientStorage defines model for InsufficientStorage.
type InsufficientStorage = ErrorResponse

// InternalServerError defines model for InternalServerError.
type InternalServerError = ErrorResponse

// MethodNotAllowed defines model for MethodNotAllowed.
type MethodNotAllowed = ErrorResponse

// NotAcceptable defines model for NotAcceptable.
type NotAcceptable = ErrorResponse

// NotFound defines model for NotFound.
type NotFound = ErrorResponse

// ServiceUnavailable defines model for ServiceUnavailable.
type ServiceUnavailable = ErrorResponse

// TooManyRequests defines model for TooManyRequests.
type TooManyRequests = ErrorResponse

// Unauthorized defines model for Unauthorized.
type Unauthorized = ErrorResponse

// AuthenticateJSONBody defines parameters for Authenticate.
type AuthenticateJSONBody struct {
	Devicetype        *string `json:"devicetype,omitempty"`
	Generateclientkey *bool   `json:"generateclientkey,omitempty"`
}

// AuthenticateJSONRequestBody defines body for Authenticate for application/json ContentType.
type AuthenticateJSONRequestBody AuthenticateJSONBody

// UpdateBridgeJSONRequestBody defines body for UpdateBridge for application/json ContentType.
type UpdateBridgeJSONRequestBody = BridgePut

// UpdateDeviceJSONRequestBody defines body for UpdateDevice for application/json ContentType.
type UpdateDeviceJSONRequestBody = DevicePut

// UpdateGroupedLightJSONRequestBody defines body for UpdateGroupedLight for application/json ContentType.
type UpdateGroupedLightJSONRequestBody = GroupedLightPut

// UpdateLightJSONRequestBody defines body for UpdateLight for application/json ContentType.
type UpdateLightJSONRequestBody = LightPut

// UpdateLightLevelJSONRequestBody defines body for UpdateLightLevel for application/json ContentType.
type UpdateLightLevelJSONRequestBody = LightLevelPut

// UpdateMotionSensorJSONRequestBody defines body for UpdateMotionSensor for application/json ContentType.
type UpdateMotionSensorJSONRequestBody = MotionPut

// CreateRoomJSONRequestBody defines body for CreateRoom for application/json ContentType.
type CreateRoomJSONRequestBody = RoomPut

// UpdateRoomJSONRequestBody defines body for UpdateRoom for application/json ContentType.
type UpdateRoomJSONRequestBody = RoomPut

// CreateSceneJSONRequestBody defines body for CreateScene for application/json ContentType.
type CreateSceneJSONRequestBody = ScenePost

// UpdateSceneJSONRequestBody defines body for UpdateScene for application/json ContentType.
type UpdateSceneJSONRequestBody = ScenePut

// CreateSmartSceneJSONRequestBody defines body for CreateSmartScene for application/json ContentType.
type CreateSmartSceneJSONRequestBody = SmartScenePost

// UpdateSmartSceneJSONRequestBody defines body for UpdateSmartScene for application/json ContentType.
type UpdateSmartSceneJSONRequestBody = SmartScenePut

// UpdateTemperatureJSONRequestBody defines body for UpdateTemperature for application/json ContentType.
type UpdateTemperatureJSONRequestBody = TemperaturePut

// CreateZoneJSONRequestBody defines body for CreateZone for application/json ContentType.
type CreateZoneJSONRequestBody = RoomPut

// UpdateZoneJSONRequestBody defines body for UpdateZone for application/json ContentType.
type UpdateZoneJSONRequestBody = RoomPut

// RequestEditorFn  is the function signature for the RequestEditor callback function
type RequestEditorFn func(ctx context.Context, req *http.Request) error

// Doer performs HTTP requests.
//
// The standard http.Client implements this interface.
type HttpRequestDoer interface {
	Do(req *http.Request) (*http.Response, error)
}

// Client which conforms to the OpenAPI3 specification for this service.
type Client struct {
	// The endpoint of the server conforming to this interface, with scheme,
	// https://api.deepmap.com for example. This can contain a path relative
	// to the server, such as https://api.deepmap.com/dev-test, and all the
	// paths in the swagger spec will be appended to the server.
	Server string

	// Doer for performing requests, typically a *http.Client with any
	// customized settings, such as certificate chains.
	Client HttpRequestDoer

	// A list of callbacks for modifying requests which are generated before sending over
	// the network.
	RequestEditors []RequestEditorFn
}

// ClientOption allows setting custom parameters during construction
type ClientOption func(*Client) error

// Creates a new Client, with reasonable defaults
func NewClient(server string, opts ...ClientOption) (*Client, error) {
	// create a client with sane default values
	client := Client{
		Server: server,
	}
	// mutate client and add all optional params
	for _, o := range opts {
		if err := o(&client); err != nil {
			return nil, err
		}
	}
	// ensure the server URL always has a trailing slash
	if !strings.HasSuffix(client.Server, "/") {
		client.Server += "/"
	}
	// create httpClient, if not already present
	if client.Client == nil {
		client.Client = &http.Client{}
	}
	return &client, nil
}

// WithHTTPClient allows overriding the default Doer, which is
// automatically created using http.Client. This is useful for tests.
func WithHTTPClient(doer HttpRequestDoer) ClientOption {
	return func(c *Client) error {
		c.Client = doer
		return nil
	}
}

// WithRequestEditorFn allows setting up a callback function, which will be
// called right before sending the request. This can be used to mutate the request.
func WithRequestEditorFn(fn RequestEditorFn) ClientOption {
	return func(c *Client) error {
		c.RequestEditors = append(c.RequestEditors, fn)
		return nil
	}
}

// The interface specification for the client above.
type ClientInterface interface {
	// AuthenticateWithBody request with any body
	AuthenticateWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	Authenticate(ctx context.Context, body AuthenticateJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetResources request
	GetResources(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetBridges request
	GetBridges(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetBridge request
	GetBridge(ctx context.Context, bridgeId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateBridgeWithBody request with any body
	UpdateBridgeWithBody(ctx context.Context, bridgeId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateBridge(ctx context.Context, bridgeId string, body UpdateBridgeJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetBridgeHomes request
	GetBridgeHomes(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetBridgeHome request
	GetBridgeHome(ctx context.Context, bridgeHomeId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDevices request
	GetDevices(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDevice request
	DeleteDevice(ctx context.Context, deviceId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDevice request
	GetDevice(ctx context.Context, deviceId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateDeviceWithBody request with any body
	UpdateDeviceWithBody(ctx context.Context, deviceId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateDevice(ctx context.Context, deviceId string, body UpdateDeviceJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDevicePowers request
	GetDevicePowers(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDevicePower request
	GetDevicePower(ctx context.Context, deviceId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetGroupedLights request
	GetGroupedLights(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetGroupedLight request
	GetGroupedLight(ctx context.Context, groupedLightId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateGroupedLightWithBody request with any body
	UpdateGroupedLightWithBody(ctx context.Context, groupedLightId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateGroupedLight(ctx context.Context, groupedLightId string, body UpdateGroupedLightJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetLights request
	GetLights(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetLight request
	GetLight(ctx context.Context, lightId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateLightWithBody request with any body
	UpdateLightWithBody(ctx context.Context, lightId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateLight(ctx context.Context, lightId string, body UpdateLightJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetLightLevels request
	GetLightLevels(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetLightLevel request
	GetLightLevel(ctx context.Context, lightId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateLightLevelWithBody request with any body
	UpdateLightLevelWithBody(ctx context.Context, lightId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateLightLevel(ctx context.Context, lightId string, body UpdateLightLevelJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetMotionSensors request
	GetMotionSensors(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetMotionSensor request
	GetMotionSensor(ctx context.Context, motionId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateMotionSensorWithBody request with any body
	UpdateMotionSensorWithBody(ctx context.Context, motionId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateMotionSensor(ctx context.Context, motionId string, body UpdateMotionSensorJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetRooms request
	GetRooms(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateRoomWithBody request with any body
	CreateRoomWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateRoom(ctx context.Context, body CreateRoomJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteRoom request
	DeleteRoom(ctx context.Context, roomId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetRoom request
	GetRoom(ctx context.Context, roomId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateRoomWithBody request with any body
	UpdateRoomWithBody(ctx context.Context, roomId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateRoom(ctx context.Context, roomId string, body UpdateRoomJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetScenes request
	GetScenes(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateSceneWithBody request with any body
	CreateSceneWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateScene(ctx context.Context, body CreateSceneJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteScene request
	DeleteScene(ctx context.Context, sceneId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetScene request
	GetScene(ctx context.Context, sceneId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateSceneWithBody request with any body
	UpdateSceneWithBody(ctx context.Context, sceneId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateScene(ctx context.Context, sceneId string, body UpdateSceneJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetSmartScenes request
	GetSmartScenes(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateSmartSceneWithBody request with any body
	CreateSmartSceneWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateSmartScene(ctx context.Context, body CreateSmartSceneJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteSmartScene request
	DeleteSmartScene(ctx context.Context, sceneId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetSmartScene request
	GetSmartScene(ctx context.Context, sceneId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateSmartSceneWithBody request with any body
	UpdateSmartSceneWithBody(ctx context.Context, sceneId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateSmartScene(ctx context.Context, sceneId string, body UpdateSmartSceneJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetTemperatures request
	GetTemperatures(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetTemperature request
	GetTemperature(ctx context.Context, temperatureId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateTemperatureWithBody request with any body
	UpdateTemperatureWithBody(ctx context.Context, temperatureId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateTemperature(ctx context.Context, temperatureId string, body UpdateTemperatureJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetZones request
	GetZones(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateZoneWithBody request with any body
	CreateZoneWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateZone(ctx context.Context, body CreateZoneJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteZone request
	DeleteZone(ctx context.Context, zoneId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetZone request
	GetZone(ctx context.Context, zoneId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateZoneWithBody request with any body
	UpdateZoneWithBody(ctx context.Context, zoneId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateZone(ctx context.Context, zoneId string, body UpdateZoneJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)
}

func (c *Client) AuthenticateWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewAuthenticateRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) Authenticate(ctx context.Context, body AuthenticateJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewAuthenticateRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetResources(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetResourcesRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetBridges(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetBridgesRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetBridge(ctx context.Context, bridgeId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetBridgeRequest(c.Server, bridgeId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateBridgeWithBody(ctx context.Context, bridgeId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateBridgeRequestWithBody(c.Server, bridgeId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateBridge(ctx context.Context, bridgeId string, body UpdateBridgeJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateBridgeRequest(c.Server, bridgeId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetBridgeHomes(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetBridgeHomesRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetBridgeHome(ctx context.Context, bridgeHomeId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetBridgeHomeRequest(c.Server, bridgeHomeId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDevices(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDevicesRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDevice(ctx context.Context, deviceId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDeviceRequest(c.Server, deviceId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDevice(ctx context.Context, deviceId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDeviceRequest(c.Server, deviceId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDeviceWithBody(ctx context.Context, deviceId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDeviceRequestWithBody(c.Server, deviceId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDevice(ctx context.Context, deviceId string, body UpdateDeviceJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDeviceRequest(c.Server, deviceId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDevicePowers(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDevicePowersRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDevicePower(ctx context.Context, deviceId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDevicePowerRequest(c.Server, deviceId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetGroupedLights(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetGroupedLightsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetGroupedLight(ctx context.Context, groupedLightId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetGroupedLightRequest(c.Server, groupedLightId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateGroupedLightWithBody(ctx context.Context, groupedLightId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateGroupedLightRequestWithBody(c.Server, groupedLightId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateGroupedLight(ctx context.Context, groupedLightId string, body UpdateGroupedLightJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateGroupedLightRequest(c.Server, groupedLightId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetLights(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetLightsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetLight(ctx context.Context, lightId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetLightRequest(c.Server, lightId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateLightWithBody(ctx context.Context, lightId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateLightRequestWithBody(c.Server, lightId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateLight(ctx context.Context, lightId string, body UpdateLightJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateLightRequest(c.Server, lightId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetLightLevels(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetLightLevelsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetLightLevel(ctx context.Context, lightId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetLightLevelRequest(c.Server, lightId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateLightLevelWithBody(ctx context.Context, lightId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateLightLevelRequestWithBody(c.Server, lightId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateLightLevel(ctx context.Context, lightId string, body UpdateLightLevelJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateLightLevelRequest(c.Server, lightId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetMotionSensors(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetMotionSensorsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetMotionSensor(ctx context.Context, motionId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetMotionSensorRequest(c.Server, motionId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateMotionSensorWithBody(ctx context.Context, motionId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateMotionSensorRequestWithBody(c.Server, motionId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateMotionSensor(ctx context.Context, motionId string, body UpdateMotionSensorJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateMotionSensorRequest(c.Server, motionId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetRooms(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetRoomsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateRoomWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateRoomRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateRoom(ctx context.Context, body CreateRoomJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateRoomRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteRoom(ctx context.Context, roomId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteRoomRequest(c.Server, roomId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetRoom(ctx context.Context, roomId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetRoomRequest(c.Server, roomId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateRoomWithBody(ctx context.Context, roomId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateRoomRequestWithBody(c.Server, roomId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateRoom(ctx context.Context, roomId string, body UpdateRoomJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateRoomRequest(c.Server, roomId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetScenes(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetScenesRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateSceneWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateSceneRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateScene(ctx context.Context, body CreateSceneJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateSceneRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteScene(ctx context.Context, sceneId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteSceneRequest(c.Server, sceneId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetScene(ctx context.Context, sceneId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetSceneRequest(c.Server, sceneId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateSceneWithBody(ctx context.Context, sceneId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateSceneRequestWithBody(c.Server, sceneId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateScene(ctx context.Context, sceneId string, body UpdateSceneJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateSceneRequest(c.Server, sceneId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetSmartScenes(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetSmartScenesRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateSmartSceneWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateSmartSceneRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateSmartScene(ctx context.Context, body CreateSmartSceneJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateSmartSceneRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteSmartScene(ctx context.Context, sceneId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteSmartSceneRequest(c.Server, sceneId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetSmartScene(ctx context.Context, sceneId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetSmartSceneRequest(c.Server, sceneId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateSmartSceneWithBody(ctx context.Context, sceneId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateSmartSceneRequestWithBody(c.Server, sceneId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateSmartScene(ctx context.Context, sceneId string, body UpdateSmartSceneJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateSmartSceneRequest(c.Server, sceneId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetTemperatures(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetTemperaturesRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetTemperature(ctx context.Context, temperatureId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetTemperatureRequest(c.Server, temperatureId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateTemperatureWithBody(ctx context.Context, temperatureId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateTemperatureRequestWithBody(c.Server, temperatureId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateTemperature(ctx context.Context, temperatureId string, body UpdateTemperatureJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateTemperatureRequest(c.Server, temperatureId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetZones(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetZonesRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateZoneWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateZoneRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateZone(ctx context.Context, body CreateZoneJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateZoneRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteZone(ctx context.Context, zoneId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteZoneRequest(c.Server, zoneId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetZone(ctx context.Context, zoneId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetZoneRequest(c.Server, zoneId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateZoneWithBody(ctx context.Context, zoneId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateZoneRequestWithBody(c.Server, zoneId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateZone(ctx context.Context, zoneId string, body UpdateZoneJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateZoneRequest(c.Server, zoneId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

// NewAuthenticateRequest calls the generic Authenticate builder with application/json body
func NewAuthenticateRequest(server string, body AuthenticateJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewAuthenticateRequestWithBody(server, "application/json", bodyReader)
}

// NewAuthenticateRequestWithBody generates requests for Authenticate with any type of body
func NewAuthenticateRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewGetResourcesRequest generates requests for GetResources
func NewGetResourcesRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetBridgesRequest generates requests for GetBridges
func NewGetBridgesRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/bridge")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetBridgeRequest generates requests for GetBridge
func NewGetBridgeRequest(server string, bridgeId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "bridgeId", runtime.ParamLocationPath, bridgeId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/bridge/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateBridgeRequest calls the generic UpdateBridge builder with application/json body
func NewUpdateBridgeRequest(server string, bridgeId string, body UpdateBridgeJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateBridgeRequestWithBody(server, bridgeId, "application/json", bodyReader)
}

// NewUpdateBridgeRequestWithBody generates requests for UpdateBridge with any type of body
func NewUpdateBridgeRequestWithBody(server string, bridgeId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "bridgeId", runtime.ParamLocationPath, bridgeId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/bridge/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewGetBridgeHomesRequest generates requests for GetBridgeHomes
func NewGetBridgeHomesRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/bridge_home")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetBridgeHomeRequest generates requests for GetBridgeHome
func NewGetBridgeHomeRequest(server string, bridgeHomeId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "bridgeHomeId", runtime.ParamLocationPath, bridgeHomeId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/bridge_home/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDevicesRequest generates requests for GetDevices
func NewGetDevicesRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/device")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewDeleteDeviceRequest generates requests for DeleteDevice
func NewDeleteDeviceRequest(server string, deviceId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "deviceId", runtime.ParamLocationPath, deviceId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/device/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDeviceRequest generates requests for GetDevice
func NewGetDeviceRequest(server string, deviceId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "deviceId", runtime.ParamLocationPath, deviceId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/device/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateDeviceRequest calls the generic UpdateDevice builder with application/json body
func NewUpdateDeviceRequest(server string, deviceId string, body UpdateDeviceJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateDeviceRequestWithBody(server, deviceId, "application/json", bodyReader)
}

// NewUpdateDeviceRequestWithBody generates requests for UpdateDevice with any type of body
func NewUpdateDeviceRequestWithBody(server string, deviceId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "deviceId", runtime.ParamLocationPath, deviceId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/device/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewGetDevicePowersRequest generates requests for GetDevicePowers
func NewGetDevicePowersRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/device_power")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDevicePowerRequest generates requests for GetDevicePower
func NewGetDevicePowerRequest(server string, deviceId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "deviceId", runtime.ParamLocationPath, deviceId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/device_power/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetGroupedLightsRequest generates requests for GetGroupedLights
func NewGetGroupedLightsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/grouped_light")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetGroupedLightRequest generates requests for GetGroupedLight
func NewGetGroupedLightRequest(server string, groupedLightId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "groupedLightId", runtime.ParamLocationPath, groupedLightId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/grouped_light/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateGroupedLightRequest calls the generic UpdateGroupedLight builder with application/json body
func NewUpdateGroupedLightRequest(server string, groupedLightId string, body UpdateGroupedLightJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateGroupedLightRequestWithBody(server, groupedLightId, "application/json", bodyReader)
}

// NewUpdateGroupedLightRequestWithBody generates requests for UpdateGroupedLight with any type of body
func NewUpdateGroupedLightRequestWithBody(server string, groupedLightId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "groupedLightId", runtime.ParamLocationPath, groupedLightId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/grouped_light/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewGetLightsRequest generates requests for GetLights
func NewGetLightsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/light")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetLightRequest generates requests for GetLight
func NewGetLightRequest(server string, lightId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "lightId", runtime.ParamLocationPath, lightId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/light/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateLightRequest calls the generic UpdateLight builder with application/json body
func NewUpdateLightRequest(server string, lightId string, body UpdateLightJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateLightRequestWithBody(server, lightId, "application/json", bodyReader)
}

// NewUpdateLightRequestWithBody generates requests for UpdateLight with any type of body
func NewUpdateLightRequestWithBody(server string, lightId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "lightId", runtime.ParamLocationPath, lightId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/light/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewGetLightLevelsRequest generates requests for GetLightLevels
func NewGetLightLevelsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/light_level")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetLightLevelRequest generates requests for GetLightLevel
func NewGetLightLevelRequest(server string, lightId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "lightId", runtime.ParamLocationPath, lightId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/light_level/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateLightLevelRequest calls the generic UpdateLightLevel builder with application/json body
func NewUpdateLightLevelRequest(server string, lightId string, body UpdateLightLevelJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateLightLevelRequestWithBody(server, lightId, "application/json", bodyReader)
}

// NewUpdateLightLevelRequestWithBody generates requests for UpdateLightLevel with any type of body
func NewUpdateLightLevelRequestWithBody(server string, lightId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "lightId", runtime.ParamLocationPath, lightId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/light_level/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewGetMotionSensorsRequest generates requests for GetMotionSensors
func NewGetMotionSensorsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/motion")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetMotionSensorRequest generates requests for GetMotionSensor
func NewGetMotionSensorRequest(server string, motionId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "motionId", runtime.ParamLocationPath, motionId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/motion/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateMotionSensorRequest calls the generic UpdateMotionSensor builder with application/json body
func NewUpdateMotionSensorRequest(server string, motionId string, body UpdateMotionSensorJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateMotionSensorRequestWithBody(server, motionId, "application/json", bodyReader)
}

// NewUpdateMotionSensorRequestWithBody generates requests for UpdateMotionSensor with any type of body
func NewUpdateMotionSensorRequestWithBody(server string, motionId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "motionId", runtime.ParamLocationPath, motionId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/motion/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewGetRoomsRequest generates requests for GetRooms
func NewGetRoomsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/room")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateRoomRequest calls the generic CreateRoom builder with application/json body
func NewCreateRoomRequest(server string, body CreateRoomJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateRoomRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateRoomRequestWithBody generates requests for CreateRoom with any type of body
func NewCreateRoomRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/room")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteRoomRequest generates requests for DeleteRoom
func NewDeleteRoomRequest(server string, roomId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "roomId", runtime.ParamLocationPath, roomId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/room/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetRoomRequest generates requests for GetRoom
func NewGetRoomRequest(server string, roomId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "roomId", runtime.ParamLocationPath, roomId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/room/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateRoomRequest calls the generic UpdateRoom builder with application/json body
func NewUpdateRoomRequest(server string, roomId string, body UpdateRoomJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateRoomRequestWithBody(server, roomId, "application/json", bodyReader)
}

// NewUpdateRoomRequestWithBody generates requests for UpdateRoom with any type of body
func NewUpdateRoomRequestWithBody(server string, roomId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "roomId", runtime.ParamLocationPath, roomId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/room/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewGetScenesRequest generates requests for GetScenes
func NewGetScenesRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/scene")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateSceneRequest calls the generic CreateScene builder with application/json body
func NewCreateSceneRequest(server string, body CreateSceneJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateSceneRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateSceneRequestWithBody generates requests for CreateScene with any type of body
func NewCreateSceneRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/scene")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteSceneRequest generates requests for DeleteScene
func NewDeleteSceneRequest(server string, sceneId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "sceneId", runtime.ParamLocationPath, sceneId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/scene/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSceneRequest generates requests for GetScene
func NewGetSceneRequest(server string, sceneId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "sceneId", runtime.ParamLocationPath, sceneId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/scene/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateSceneRequest calls the generic UpdateScene builder with application/json body
func NewUpdateSceneRequest(server string, sceneId string, body UpdateSceneJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateSceneRequestWithBody(server, sceneId, "application/json", bodyReader)
}

// NewUpdateSceneRequestWithBody generates requests for UpdateScene with any type of body
func NewUpdateSceneRequestWithBody(server string, sceneId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "sceneId", runtime.ParamLocationPath, sceneId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/scene/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewGetSmartScenesRequest generates requests for GetSmartScenes
func NewGetSmartScenesRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/smart_scene")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateSmartSceneRequest calls the generic CreateSmartScene builder with application/json body
func NewCreateSmartSceneRequest(server string, body CreateSmartSceneJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateSmartSceneRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateSmartSceneRequestWithBody generates requests for CreateSmartScene with any type of body
func NewCreateSmartSceneRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/smart_scene")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteSmartSceneRequest generates requests for DeleteSmartScene
func NewDeleteSmartSceneRequest(server string, sceneId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "sceneId", runtime.ParamLocationPath, sceneId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/smart_scene/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSmartSceneRequest generates requests for GetSmartScene
func NewGetSmartSceneRequest(server string, sceneId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "sceneId", runtime.ParamLocationPath, sceneId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/smart_scene/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateSmartSceneRequest calls the generic UpdateSmartScene builder with application/json body
func NewUpdateSmartSceneRequest(server string, sceneId string, body UpdateSmartSceneJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateSmartSceneRequestWithBody(server, sceneId, "application/json", bodyReader)
}

// NewUpdateSmartSceneRequestWithBody generates requests for UpdateSmartScene with any type of body
func NewUpdateSmartSceneRequestWithBody(server string, sceneId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "sceneId", runtime.ParamLocationPath, sceneId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/smart_scene/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewGetTemperaturesRequest generates requests for GetTemperatures
func NewGetTemperaturesRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/temperature")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetTemperatureRequest generates requests for GetTemperature
func NewGetTemperatureRequest(server string, temperatureId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "temperatureId", runtime.ParamLocationPath, temperatureId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/temperature/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateTemperatureRequest calls the generic UpdateTemperature builder with application/json body
func NewUpdateTemperatureRequest(server string, temperatureId string, body UpdateTemperatureJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateTemperatureRequestWithBody(server, temperatureId, "application/json", bodyReader)
}

// NewUpdateTemperatureRequestWithBody generates requests for UpdateTemperature with any type of body
func NewUpdateTemperatureRequestWithBody(server string, temperatureId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "temperatureId", runtime.ParamLocationPath, temperatureId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/temperature/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewGetZonesRequest generates requests for GetZones
func NewGetZonesRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/zone")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateZoneRequest calls the generic CreateZone builder with application/json body
func NewCreateZoneRequest(server string, body CreateZoneJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateZoneRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateZoneRequestWithBody generates requests for CreateZone with any type of body
func NewCreateZoneRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/zone")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteZoneRequest generates requests for DeleteZone
func NewDeleteZoneRequest(server string, zoneId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "zoneId", runtime.ParamLocationPath, zoneId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/zone/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetZoneRequest generates requests for GetZone
func NewGetZoneRequest(server string, zoneId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "zoneId", runtime.ParamLocationPath, zoneId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/zone/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateZoneRequest calls the generic UpdateZone builder with application/json body
func NewUpdateZoneRequest(server string, zoneId string, body UpdateZoneJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateZoneRequestWithBody(server, zoneId, "application/json", bodyReader)
}

// NewUpdateZoneRequestWithBody generates requests for UpdateZone with any type of body
func NewUpdateZoneRequestWithBody(server string, zoneId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "zoneId", runtime.ParamLocationPath, zoneId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/clip/v2/resource/zone/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

func (c *Client) applyEditors(ctx context.Context, req *http.Request, additionalEditors []RequestEditorFn) error {
	for _, r := range c.RequestEditors {
		if err := r(ctx, req); err != nil {
			return err
		}
	}
	for _, r := range additionalEditors {
		if err := r(ctx, req); err != nil {
			return err
		}
	}
	return nil
}

// ClientWithResponses builds on ClientInterface to offer response payloads
type ClientWithResponses struct {
	ClientInterface
}

// NewClientWithResponses creates a new ClientWithResponses, which wraps
// Client with return type handling
func NewClientWithResponses(server string, opts ...ClientOption) (*ClientWithResponses, error) {
	client, err := NewClient(server, opts...)
	if err != nil {
		return nil, err
	}
	return &ClientWithResponses{client}, nil
}

// WithBaseURL overrides the baseURL.
func WithBaseURL(baseURL string) ClientOption {
	return func(c *Client) error {
		newBaseURL, err := url.Parse(baseURL)
		if err != nil {
			return err
		}
		c.Server = newBaseURL.String()
		return nil
	}
}

// ClientWithResponsesInterface is the interface specification for the client with responses above.
type ClientWithResponsesInterface interface {
	// AuthenticateWithBodyWithResponse request with any body
	AuthenticateWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*AuthenticateResponse, error)

	AuthenticateWithResponse(ctx context.Context, body AuthenticateJSONRequestBody, reqEditors ...RequestEditorFn) (*AuthenticateResponse, error)

	// GetResourcesWithResponse request
	GetResourcesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetResourcesResponse, error)

	// GetBridgesWithResponse request
	GetBridgesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetBridgesResponse, error)

	// GetBridgeWithResponse request
	GetBridgeWithResponse(ctx context.Context, bridgeId string, reqEditors ...RequestEditorFn) (*GetBridgeResponse, error)

	// UpdateBridgeWithBodyWithResponse request with any body
	UpdateBridgeWithBodyWithResponse(ctx context.Context, bridgeId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateBridgeResponse, error)

	UpdateBridgeWithResponse(ctx context.Context, bridgeId string, body UpdateBridgeJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateBridgeResponse, error)

	// GetBridgeHomesWithResponse request
	GetBridgeHomesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetBridgeHomesResponse, error)

	// GetBridgeHomeWithResponse request
	GetBridgeHomeWithResponse(ctx context.Context, bridgeHomeId string, reqEditors ...RequestEditorFn) (*GetBridgeHomeResponse, error)

	// GetDevicesWithResponse request
	GetDevicesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetDevicesResponse, error)

	// DeleteDeviceWithResponse request
	DeleteDeviceWithResponse(ctx context.Context, deviceId string, reqEditors ...RequestEditorFn) (*DeleteDeviceResponse, error)

	// GetDeviceWithResponse request
	GetDeviceWithResponse(ctx context.Context, deviceId string, reqEditors ...RequestEditorFn) (*GetDeviceResponse, error)

	// UpdateDeviceWithBodyWithResponse request with any body
	UpdateDeviceWithBodyWithResponse(ctx context.Context, deviceId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDeviceResponse, error)

	UpdateDeviceWithResponse(ctx context.Context, deviceId string, body UpdateDeviceJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDeviceResponse, error)

	// GetDevicePowersWithResponse request
	GetDevicePowersWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetDevicePowersResponse, error)

	// GetDevicePowerWithResponse request
	GetDevicePowerWithResponse(ctx context.Context, deviceId string, reqEditors ...RequestEditorFn) (*GetDevicePowerResponse, error)

	// GetGroupedLightsWithResponse request
	GetGroupedLightsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetGroupedLightsResponse, error)

	// GetGroupedLightWithResponse request
	GetGroupedLightWithResponse(ctx context.Context, groupedLightId string, reqEditors ...RequestEditorFn) (*GetGroupedLightResponse, error)

	// UpdateGroupedLightWithBodyWithResponse request with any body
	UpdateGroupedLightWithBodyWithResponse(ctx context.Context, groupedLightId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateGroupedLightResponse, error)

	UpdateGroupedLightWithResponse(ctx context.Context, groupedLightId string, body UpdateGroupedLightJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateGroupedLightResponse, error)

	// GetLightsWithResponse request
	GetLightsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetLightsResponse, error)

	// GetLightWithResponse request
	GetLightWithResponse(ctx context.Context, lightId string, reqEditors ...RequestEditorFn) (*GetLightResponse, error)

	// UpdateLightWithBodyWithResponse request with any body
	UpdateLightWithBodyWithResponse(ctx context.Context, lightId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateLightResponse, error)

	UpdateLightWithResponse(ctx context.Context, lightId string, body UpdateLightJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateLightResponse, error)

	// GetLightLevelsWithResponse request
	GetLightLevelsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetLightLevelsResponse, error)

	// GetLightLevelWithResponse request
	GetLightLevelWithResponse(ctx context.Context, lightId string, reqEditors ...RequestEditorFn) (*GetLightLevelResponse, error)

	// UpdateLightLevelWithBodyWithResponse request with any body
	UpdateLightLevelWithBodyWithResponse(ctx context.Context, lightId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateLightLevelResponse, error)

	UpdateLightLevelWithResponse(ctx context.Context, lightId string, body UpdateLightLevelJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateLightLevelResponse, error)

	// GetMotionSensorsWithResponse request
	GetMotionSensorsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetMotionSensorsResponse, error)

	// GetMotionSensorWithResponse request
	GetMotionSensorWithResponse(ctx context.Context, motionId string, reqEditors ...RequestEditorFn) (*GetMotionSensorResponse, error)

	// UpdateMotionSensorWithBodyWithResponse request with any body
	UpdateMotionSensorWithBodyWithResponse(ctx context.Context, motionId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateMotionSensorResponse, error)

	UpdateMotionSensorWithResponse(ctx context.Context, motionId string, body UpdateMotionSensorJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateMotionSensorResponse, error)

	// GetRoomsWithResponse request
	GetRoomsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetRoomsResponse, error)

	// CreateRoomWithBodyWithResponse request with any body
	CreateRoomWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateRoomResponse, error)

	CreateRoomWithResponse(ctx context.Context, body CreateRoomJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateRoomResponse, error)

	// DeleteRoomWithResponse request
	DeleteRoomWithResponse(ctx context.Context, roomId string, reqEditors ...RequestEditorFn) (*DeleteRoomResponse, error)

	// GetRoomWithResponse request
	GetRoomWithResponse(ctx context.Context, roomId string, reqEditors ...RequestEditorFn) (*GetRoomResponse, error)

	// UpdateRoomWithBodyWithResponse request with any body
	UpdateRoomWithBodyWithResponse(ctx context.Context, roomId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateRoomResponse, error)

	UpdateRoomWithResponse(ctx context.Context, roomId string, body UpdateRoomJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateRoomResponse, error)

	// GetScenesWithResponse request
	GetScenesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetScenesResponse, error)

	// CreateSceneWithBodyWithResponse request with any body
	CreateSceneWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateSceneResponse, error)

	CreateSceneWithResponse(ctx context.Context, body CreateSceneJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateSceneResponse, error)

	// DeleteSceneWithResponse request
	DeleteSceneWithResponse(ctx context.Context, sceneId string, reqEditors ...RequestEditorFn) (*DeleteSceneResponse, error)

	// GetSceneWithResponse request
	GetSceneWithResponse(ctx context.Context, sceneId string, reqEditors ...RequestEditorFn) (*GetSceneResponse, error)

	// UpdateSceneWithBodyWithResponse request with any body
	UpdateSceneWithBodyWithResponse(ctx context.Context, sceneId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateSceneResponse, error)

	UpdateSceneWithResponse(ctx context.Context, sceneId string, body UpdateSceneJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateSceneResponse, error)

	// GetSmartScenesWithResponse request
	GetSmartScenesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetSmartScenesResponse, error)

	// CreateSmartSceneWithBodyWithResponse request with any body
	CreateSmartSceneWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateSmartSceneResponse, error)

	CreateSmartSceneWithResponse(ctx context.Context, body CreateSmartSceneJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateSmartSceneResponse, error)

	// DeleteSmartSceneWithResponse request
	DeleteSmartSceneWithResponse(ctx context.Context, sceneId string, reqEditors ...RequestEditorFn) (*DeleteSmartSceneResponse, error)

	// GetSmartSceneWithResponse request
	GetSmartSceneWithResponse(ctx context.Context, sceneId string, reqEditors ...RequestEditorFn) (*GetSmartSceneResponse, error)

	// UpdateSmartSceneWithBodyWithResponse request with any body
	UpdateSmartSceneWithBodyWithResponse(ctx context.Context, sceneId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateSmartSceneResponse, error)

	UpdateSmartSceneWithResponse(ctx context.Context, sceneId string, body UpdateSmartSceneJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateSmartSceneResponse, error)

	// GetTemperaturesWithResponse request
	GetTemperaturesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetTemperaturesResponse, error)

	// GetTemperatureWithResponse request
	GetTemperatureWithResponse(ctx context.Context, temperatureId string, reqEditors ...RequestEditorFn) (*GetTemperatureResponse, error)

	// UpdateTemperatureWithBodyWithResponse request with any body
	UpdateTemperatureWithBodyWithResponse(ctx context.Context, temperatureId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateTemperatureResponse, error)

	UpdateTemperatureWithResponse(ctx context.Context, temperatureId string, body UpdateTemperatureJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateTemperatureResponse, error)

	// GetZonesWithResponse request
	GetZonesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetZonesResponse, error)

	// CreateZoneWithBodyWithResponse request with any body
	CreateZoneWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateZoneResponse, error)

	CreateZoneWithResponse(ctx context.Context, body CreateZoneJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateZoneResponse, error)

	// DeleteZoneWithResponse request
	DeleteZoneWithResponse(ctx context.Context, zoneId string, reqEditors ...RequestEditorFn) (*DeleteZoneResponse, error)

	// GetZoneWithResponse request
	GetZoneWithResponse(ctx context.Context, zoneId string, reqEditors ...RequestEditorFn) (*GetZoneResponse, error)

	// UpdateZoneWithBodyWithResponse request with any body
	UpdateZoneWithBodyWithResponse(ctx context.Context, zoneId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateZoneResponse, error)

	UpdateZoneWithResponse(ctx context.Context, zoneId string, body UpdateZoneJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateZoneResponse, error)
}

type AuthenticateResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Response
	JSON401      *Unauthorized
}

// Status returns HTTPResponse.Status
func (r AuthenticateResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r AuthenticateResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetResourcesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceGet `json:"data,omitempty"`
		Errors *[]Error       `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetResourcesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetResourcesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetBridgesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]BridgeGet `json:"data,omitempty"`
		Errors *[]Error     `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetBridgesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetBridgesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetBridgeResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]BridgeGet `json:"data,omitempty"`
		Errors *[]Error     `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetBridgeResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetBridgeResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateBridgeResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r UpdateBridgeResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateBridgeResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetBridgeHomesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]BridgeHomeGet `json:"data,omitempty"`
		Errors *[]Error         `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetBridgeHomesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetBridgeHomesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetBridgeHomeResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]BridgeHomeGet `json:"data,omitempty"`
		Errors *[]Error         `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetBridgeHomeResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetBridgeHomeResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDevicesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]DeviceGet `json:"data,omitempty"`
		Errors *[]Error     `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetDevicesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDevicesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDeviceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r DeleteDeviceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDeviceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDeviceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]DeviceGet `json:"data,omitempty"`
		Errors *[]Error     `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetDeviceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDeviceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateDeviceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r UpdateDeviceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateDeviceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDevicePowersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]DevicePowerGet `json:"data,omitempty"`
		Errors *[]Error          `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetDevicePowersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDevicePowersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDevicePowerResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]DevicePowerGet `json:"data,omitempty"`
		Errors *[]Error          `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetDevicePowerResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDevicePowerResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetGroupedLightsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]GroupedLightGet `json:"data,omitempty"`
		Errors *[]Error           `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetGroupedLightsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetGroupedLightsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetGroupedLightResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]GroupedLightGet `json:"data,omitempty"`
		Errors *[]Error           `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetGroupedLightResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetGroupedLightResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateGroupedLightResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r UpdateGroupedLightResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateGroupedLightResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetLightsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]LightGet `json:"data,omitempty"`
		Errors *[]Error    `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetLightsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetLightsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetLightResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]LightGet `json:"data,omitempty"`
		Errors *[]Error    `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetLightResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetLightResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateLightResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r UpdateLightResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateLightResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetLightLevelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]LightLevelGet `json:"data,omitempty"`
		Errors *[]Error         `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetLightLevelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetLightLevelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetLightLevelResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]LightLevelGet `json:"data,omitempty"`
		Errors *[]Error         `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetLightLevelResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetLightLevelResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateLightLevelResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r UpdateLightLevelResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateLightLevelResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetMotionSensorsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]MotionGet `json:"data,omitempty"`
		Errors *[]Error     `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetMotionSensorsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetMotionSensorsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetMotionSensorResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]MotionGet `json:"data,omitempty"`
		Errors *[]Error     `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetMotionSensorResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetMotionSensorResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateMotionSensorResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r UpdateMotionSensorResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateMotionSensorResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetRoomsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]RoomGet `json:"data,omitempty"`
		Errors *[]Error   `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetRoomsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetRoomsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateRoomResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r CreateRoomResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateRoomResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteRoomResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r DeleteRoomResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteRoomResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetRoomResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]RoomGet `json:"data,omitempty"`
		Errors *[]Error   `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetRoomResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetRoomResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateRoomResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r UpdateRoomResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateRoomResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetScenesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]SceneGet `json:"data,omitempty"`
		Errors *[]Error    `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetScenesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetScenesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateSceneResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r CreateSceneResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateSceneResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteSceneResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r DeleteSceneResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteSceneResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSceneResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]SceneGet `json:"data,omitempty"`
		Errors *[]Error    `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetSceneResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSceneResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateSceneResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r UpdateSceneResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateSceneResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSmartScenesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]SmartSceneGet `json:"data,omitempty"`
		Errors *[]Error         `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetSmartScenesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSmartScenesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateSmartSceneResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r CreateSmartSceneResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateSmartSceneResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteSmartSceneResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r DeleteSmartSceneResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteSmartSceneResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSmartSceneResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]SmartSceneGet `json:"data,omitempty"`
		Errors *[]Error         `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetSmartSceneResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSmartSceneResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateSmartSceneResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r UpdateSmartSceneResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateSmartSceneResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetTemperaturesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]TemperatureGet `json:"data,omitempty"`
		Errors *[]Error          `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetTemperaturesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetTemperaturesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetTemperatureResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]TemperatureGet `json:"data,omitempty"`
		Errors *[]Error          `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetTemperatureResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetTemperatureResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateTemperatureResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r UpdateTemperatureResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateTemperatureResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetZonesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]RoomGet `json:"data,omitempty"`
		Errors *[]Error   `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetZonesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetZonesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateZoneResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r CreateZoneResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateZoneResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteZoneResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r DeleteZoneResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteZoneResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetZoneResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]RoomGet `json:"data,omitempty"`
		Errors *[]Error   `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r GetZoneResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetZoneResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateZoneResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Data   *[]ResourceIdentifier `json:"data,omitempty"`
		Errors *[]Error              `json:"errors,omitempty"`
	}
	JSON401 *Unauthorized
	JSON403 *Forbidden
	JSON404 *NotFound
	JSON405 *MethodNotAllowed
	JSON406 *NotAcceptable
	JSON409 *Conflict
	JSON429 *TooManyRequests
	JSON500 *InternalServerError
	JSON503 *ServiceUnavailable
	JSON507 *InsufficientStorage
}

// Status returns HTTPResponse.Status
func (r UpdateZoneResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateZoneResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// AuthenticateWithBodyWithResponse request with arbitrary body returning *AuthenticateResponse
func (c *ClientWithResponses) AuthenticateWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*AuthenticateResponse, error) {
	rsp, err := c.AuthenticateWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseAuthenticateResponse(rsp)
}

func (c *ClientWithResponses) AuthenticateWithResponse(ctx context.Context, body AuthenticateJSONRequestBody, reqEditors ...RequestEditorFn) (*AuthenticateResponse, error) {
	rsp, err := c.Authenticate(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseAuthenticateResponse(rsp)
}

// GetResourcesWithResponse request returning *GetResourcesResponse
func (c *ClientWithResponses) GetResourcesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetResourcesResponse, error) {
	rsp, err := c.GetResources(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetResourcesResponse(rsp)
}

// GetBridgesWithResponse request returning *GetBridgesResponse
func (c *ClientWithResponses) GetBridgesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetBridgesResponse, error) {
	rsp, err := c.GetBridges(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetBridgesResponse(rsp)
}

// GetBridgeWithResponse request returning *GetBridgeResponse
func (c *ClientWithResponses) GetBridgeWithResponse(ctx context.Context, bridgeId string, reqEditors ...RequestEditorFn) (*GetBridgeResponse, error) {
	rsp, err := c.GetBridge(ctx, bridgeId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetBridgeResponse(rsp)
}

// UpdateBridgeWithBodyWithResponse request with arbitrary body returning *UpdateBridgeResponse
func (c *ClientWithResponses) UpdateBridgeWithBodyWithResponse(ctx context.Context, bridgeId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateBridgeResponse, error) {
	rsp, err := c.UpdateBridgeWithBody(ctx, bridgeId, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateBridgeResponse(rsp)
}

func (c *ClientWithResponses) UpdateBridgeWithResponse(ctx context.Context, bridgeId string, body UpdateBridgeJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateBridgeResponse, error) {
	rsp, err := c.UpdateBridge(ctx, bridgeId, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateBridgeResponse(rsp)
}

// GetBridgeHomesWithResponse request returning *GetBridgeHomesResponse
func (c *ClientWithResponses) GetBridgeHomesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetBridgeHomesResponse, error) {
	rsp, err := c.GetBridgeHomes(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetBridgeHomesResponse(rsp)
}

// GetBridgeHomeWithResponse request returning *GetBridgeHomeResponse
func (c *ClientWithResponses) GetBridgeHomeWithResponse(ctx context.Context, bridgeHomeId string, reqEditors ...RequestEditorFn) (*GetBridgeHomeResponse, error) {
	rsp, err := c.GetBridgeHome(ctx, bridgeHomeId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetBridgeHomeResponse(rsp)
}

// GetDevicesWithResponse request returning *GetDevicesResponse
func (c *ClientWithResponses) GetDevicesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetDevicesResponse, error) {
	rsp, err := c.GetDevices(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDevicesResponse(rsp)
}

// DeleteDeviceWithResponse request returning *DeleteDeviceResponse
func (c *ClientWithResponses) DeleteDeviceWithResponse(ctx context.Context, deviceId string, reqEditors ...RequestEditorFn) (*DeleteDeviceResponse, error) {
	rsp, err := c.DeleteDevice(ctx, deviceId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDeviceResponse(rsp)
}

// GetDeviceWithResponse request returning *GetDeviceResponse
func (c *ClientWithResponses) GetDeviceWithResponse(ctx context.Context, deviceId string, reqEditors ...RequestEditorFn) (*GetDeviceResponse, error) {
	rsp, err := c.GetDevice(ctx, deviceId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDeviceResponse(rsp)
}

// UpdateDeviceWithBodyWithResponse request with arbitrary body returning *UpdateDeviceResponse
func (c *ClientWithResponses) UpdateDeviceWithBodyWithResponse(ctx context.Context, deviceId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDeviceResponse, error) {
	rsp, err := c.UpdateDeviceWithBody(ctx, deviceId, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDeviceResponse(rsp)
}

func (c *ClientWithResponses) UpdateDeviceWithResponse(ctx context.Context, deviceId string, body UpdateDeviceJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDeviceResponse, error) {
	rsp, err := c.UpdateDevice(ctx, deviceId, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDeviceResponse(rsp)
}

// GetDevicePowersWithResponse request returning *GetDevicePowersResponse
func (c *ClientWithResponses) GetDevicePowersWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetDevicePowersResponse, error) {
	rsp, err := c.GetDevicePowers(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDevicePowersResponse(rsp)
}

// GetDevicePowerWithResponse request returning *GetDevicePowerResponse
func (c *ClientWithResponses) GetDevicePowerWithResponse(ctx context.Context, deviceId string, reqEditors ...RequestEditorFn) (*GetDevicePowerResponse, error) {
	rsp, err := c.GetDevicePower(ctx, deviceId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDevicePowerResponse(rsp)
}

// GetGroupedLightsWithResponse request returning *GetGroupedLightsResponse
func (c *ClientWithResponses) GetGroupedLightsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetGroupedLightsResponse, error) {
	rsp, err := c.GetGroupedLights(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetGroupedLightsResponse(rsp)
}

// GetGroupedLightWithResponse request returning *GetGroupedLightResponse
func (c *ClientWithResponses) GetGroupedLightWithResponse(ctx context.Context, groupedLightId string, reqEditors ...RequestEditorFn) (*GetGroupedLightResponse, error) {
	rsp, err := c.GetGroupedLight(ctx, groupedLightId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetGroupedLightResponse(rsp)
}

// UpdateGroupedLightWithBodyWithResponse request with arbitrary body returning *UpdateGroupedLightResponse
func (c *ClientWithResponses) UpdateGroupedLightWithBodyWithResponse(ctx context.Context, groupedLightId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateGroupedLightResponse, error) {
	rsp, err := c.UpdateGroupedLightWithBody(ctx, groupedLightId, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateGroupedLightResponse(rsp)
}

func (c *ClientWithResponses) UpdateGroupedLightWithResponse(ctx context.Context, groupedLightId string, body UpdateGroupedLightJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateGroupedLightResponse, error) {
	rsp, err := c.UpdateGroupedLight(ctx, groupedLightId, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateGroupedLightResponse(rsp)
}

// GetLightsWithResponse request returning *GetLightsResponse
func (c *ClientWithResponses) GetLightsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetLightsResponse, error) {
	rsp, err := c.GetLights(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetLightsResponse(rsp)
}

// GetLightWithResponse request returning *GetLightResponse
func (c *ClientWithResponses) GetLightWithResponse(ctx context.Context, lightId string, reqEditors ...RequestEditorFn) (*GetLightResponse, error) {
	rsp, err := c.GetLight(ctx, lightId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetLightResponse(rsp)
}

// UpdateLightWithBodyWithResponse request with arbitrary body returning *UpdateLightResponse
func (c *ClientWithResponses) UpdateLightWithBodyWithResponse(ctx context.Context, lightId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateLightResponse, error) {
	rsp, err := c.UpdateLightWithBody(ctx, lightId, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateLightResponse(rsp)
}

func (c *ClientWithResponses) UpdateLightWithResponse(ctx context.Context, lightId string, body UpdateLightJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateLightResponse, error) {
	rsp, err := c.UpdateLight(ctx, lightId, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateLightResponse(rsp)
}

// GetLightLevelsWithResponse request returning *GetLightLevelsResponse
func (c *ClientWithResponses) GetLightLevelsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetLightLevelsResponse, error) {
	rsp, err := c.GetLightLevels(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetLightLevelsResponse(rsp)
}

// GetLightLevelWithResponse request returning *GetLightLevelResponse
func (c *ClientWithResponses) GetLightLevelWithResponse(ctx context.Context, lightId string, reqEditors ...RequestEditorFn) (*GetLightLevelResponse, error) {
	rsp, err := c.GetLightLevel(ctx, lightId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetLightLevelResponse(rsp)
}

// UpdateLightLevelWithBodyWithResponse request with arbitrary body returning *UpdateLightLevelResponse
func (c *ClientWithResponses) UpdateLightLevelWithBodyWithResponse(ctx context.Context, lightId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateLightLevelResponse, error) {
	rsp, err := c.UpdateLightLevelWithBody(ctx, lightId, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateLightLevelResponse(rsp)
}

func (c *ClientWithResponses) UpdateLightLevelWithResponse(ctx context.Context, lightId string, body UpdateLightLevelJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateLightLevelResponse, error) {
	rsp, err := c.UpdateLightLevel(ctx, lightId, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateLightLevelResponse(rsp)
}

// GetMotionSensorsWithResponse request returning *GetMotionSensorsResponse
func (c *ClientWithResponses) GetMotionSensorsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetMotionSensorsResponse, error) {
	rsp, err := c.GetMotionSensors(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetMotionSensorsResponse(rsp)
}

// GetMotionSensorWithResponse request returning *GetMotionSensorResponse
func (c *ClientWithResponses) GetMotionSensorWithResponse(ctx context.Context, motionId string, reqEditors ...RequestEditorFn) (*GetMotionSensorResponse, error) {
	rsp, err := c.GetMotionSensor(ctx, motionId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetMotionSensorResponse(rsp)
}

// UpdateMotionSensorWithBodyWithResponse request with arbitrary body returning *UpdateMotionSensorResponse
func (c *ClientWithResponses) UpdateMotionSensorWithBodyWithResponse(ctx context.Context, motionId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateMotionSensorResponse, error) {
	rsp, err := c.UpdateMotionSensorWithBody(ctx, motionId, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateMotionSensorResponse(rsp)
}

func (c *ClientWithResponses) UpdateMotionSensorWithResponse(ctx context.Context, motionId string, body UpdateMotionSensorJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateMotionSensorResponse, error) {
	rsp, err := c.UpdateMotionSensor(ctx, motionId, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateMotionSensorResponse(rsp)
}

// GetRoomsWithResponse request returning *GetRoomsResponse
func (c *ClientWithResponses) GetRoomsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetRoomsResponse, error) {
	rsp, err := c.GetRooms(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetRoomsResponse(rsp)
}

// CreateRoomWithBodyWithResponse request with arbitrary body returning *CreateRoomResponse
func (c *ClientWithResponses) CreateRoomWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateRoomResponse, error) {
	rsp, err := c.CreateRoomWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateRoomResponse(rsp)
}

func (c *ClientWithResponses) CreateRoomWithResponse(ctx context.Context, body CreateRoomJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateRoomResponse, error) {
	rsp, err := c.CreateRoom(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateRoomResponse(rsp)
}

// DeleteRoomWithResponse request returning *DeleteRoomResponse
func (c *ClientWithResponses) DeleteRoomWithResponse(ctx context.Context, roomId string, reqEditors ...RequestEditorFn) (*DeleteRoomResponse, error) {
	rsp, err := c.DeleteRoom(ctx, roomId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteRoomResponse(rsp)
}

// GetRoomWithResponse request returning *GetRoomResponse
func (c *ClientWithResponses) GetRoomWithResponse(ctx context.Context, roomId string, reqEditors ...RequestEditorFn) (*GetRoomResponse, error) {
	rsp, err := c.GetRoom(ctx, roomId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetRoomResponse(rsp)
}

// UpdateRoomWithBodyWithResponse request with arbitrary body returning *UpdateRoomResponse
func (c *ClientWithResponses) UpdateRoomWithBodyWithResponse(ctx context.Context, roomId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateRoomResponse, error) {
	rsp, err := c.UpdateRoomWithBody(ctx, roomId, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateRoomResponse(rsp)
}

func (c *ClientWithResponses) UpdateRoomWithResponse(ctx context.Context, roomId string, body UpdateRoomJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateRoomResponse, error) {
	rsp, err := c.UpdateRoom(ctx, roomId, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateRoomResponse(rsp)
}

// GetScenesWithResponse request returning *GetScenesResponse
func (c *ClientWithResponses) GetScenesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetScenesResponse, error) {
	rsp, err := c.GetScenes(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetScenesResponse(rsp)
}

// CreateSceneWithBodyWithResponse request with arbitrary body returning *CreateSceneResponse
func (c *ClientWithResponses) CreateSceneWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateSceneResponse, error) {
	rsp, err := c.CreateSceneWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateSceneResponse(rsp)
}

func (c *ClientWithResponses) CreateSceneWithResponse(ctx context.Context, body CreateSceneJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateSceneResponse, error) {
	rsp, err := c.CreateScene(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateSceneResponse(rsp)
}

// DeleteSceneWithResponse request returning *DeleteSceneResponse
func (c *ClientWithResponses) DeleteSceneWithResponse(ctx context.Context, sceneId string, reqEditors ...RequestEditorFn) (*DeleteSceneResponse, error) {
	rsp, err := c.DeleteScene(ctx, sceneId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteSceneResponse(rsp)
}

// GetSceneWithResponse request returning *GetSceneResponse
func (c *ClientWithResponses) GetSceneWithResponse(ctx context.Context, sceneId string, reqEditors ...RequestEditorFn) (*GetSceneResponse, error) {
	rsp, err := c.GetScene(ctx, sceneId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetSceneResponse(rsp)
}

// UpdateSceneWithBodyWithResponse request with arbitrary body returning *UpdateSceneResponse
func (c *ClientWithResponses) UpdateSceneWithBodyWithResponse(ctx context.Context, sceneId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateSceneResponse, error) {
	rsp, err := c.UpdateSceneWithBody(ctx, sceneId, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateSceneResponse(rsp)
}

func (c *ClientWithResponses) UpdateSceneWithResponse(ctx context.Context, sceneId string, body UpdateSceneJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateSceneResponse, error) {
	rsp, err := c.UpdateScene(ctx, sceneId, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateSceneResponse(rsp)
}

// GetSmartScenesWithResponse request returning *GetSmartScenesResponse
func (c *ClientWithResponses) GetSmartScenesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetSmartScenesResponse, error) {
	rsp, err := c.GetSmartScenes(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetSmartScenesResponse(rsp)
}

// CreateSmartSceneWithBodyWithResponse request with arbitrary body returning *CreateSmartSceneResponse
func (c *ClientWithResponses) CreateSmartSceneWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateSmartSceneResponse, error) {
	rsp, err := c.CreateSmartSceneWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateSmartSceneResponse(rsp)
}

func (c *ClientWithResponses) CreateSmartSceneWithResponse(ctx context.Context, body CreateSmartSceneJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateSmartSceneResponse, error) {
	rsp, err := c.CreateSmartScene(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateSmartSceneResponse(rsp)
}

// DeleteSmartSceneWithResponse request returning *DeleteSmartSceneResponse
func (c *ClientWithResponses) DeleteSmartSceneWithResponse(ctx context.Context, sceneId string, reqEditors ...RequestEditorFn) (*DeleteSmartSceneResponse, error) {
	rsp, err := c.DeleteSmartScene(ctx, sceneId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteSmartSceneResponse(rsp)
}

// GetSmartSceneWithResponse request returning *GetSmartSceneResponse
func (c *ClientWithResponses) GetSmartSceneWithResponse(ctx context.Context, sceneId string, reqEditors ...RequestEditorFn) (*GetSmartSceneResponse, error) {
	rsp, err := c.GetSmartScene(ctx, sceneId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetSmartSceneResponse(rsp)
}

// UpdateSmartSceneWithBodyWithResponse request with arbitrary body returning *UpdateSmartSceneResponse
func (c *ClientWithResponses) UpdateSmartSceneWithBodyWithResponse(ctx context.Context, sceneId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateSmartSceneResponse, error) {
	rsp, err := c.UpdateSmartSceneWithBody(ctx, sceneId, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateSmartSceneResponse(rsp)
}

func (c *ClientWithResponses) UpdateSmartSceneWithResponse(ctx context.Context, sceneId string, body UpdateSmartSceneJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateSmartSceneResponse, error) {
	rsp, err := c.UpdateSmartScene(ctx, sceneId, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateSmartSceneResponse(rsp)
}

// GetTemperaturesWithResponse request returning *GetTemperaturesResponse
func (c *ClientWithResponses) GetTemperaturesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetTemperaturesResponse, error) {
	rsp, err := c.GetTemperatures(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetTemperaturesResponse(rsp)
}

// GetTemperatureWithResponse request returning *GetTemperatureResponse
func (c *ClientWithResponses) GetTemperatureWithResponse(ctx context.Context, temperatureId string, reqEditors ...RequestEditorFn) (*GetTemperatureResponse, error) {
	rsp, err := c.GetTemperature(ctx, temperatureId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetTemperatureResponse(rsp)
}

// UpdateTemperatureWithBodyWithResponse request with arbitrary body returning *UpdateTemperatureResponse
func (c *ClientWithResponses) UpdateTemperatureWithBodyWithResponse(ctx context.Context, temperatureId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateTemperatureResponse, error) {
	rsp, err := c.UpdateTemperatureWithBody(ctx, temperatureId, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateTemperatureResponse(rsp)
}

func (c *ClientWithResponses) UpdateTemperatureWithResponse(ctx context.Context, temperatureId string, body UpdateTemperatureJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateTemperatureResponse, error) {
	rsp, err := c.UpdateTemperature(ctx, temperatureId, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateTemperatureResponse(rsp)
}

// GetZonesWithResponse request returning *GetZonesResponse
func (c *ClientWithResponses) GetZonesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetZonesResponse, error) {
	rsp, err := c.GetZones(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetZonesResponse(rsp)
}

// CreateZoneWithBodyWithResponse request with arbitrary body returning *CreateZoneResponse
func (c *ClientWithResponses) CreateZoneWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateZoneResponse, error) {
	rsp, err := c.CreateZoneWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateZoneResponse(rsp)
}

func (c *ClientWithResponses) CreateZoneWithResponse(ctx context.Context, body CreateZoneJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateZoneResponse, error) {
	rsp, err := c.CreateZone(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateZoneResponse(rsp)
}

// DeleteZoneWithResponse request returning *DeleteZoneResponse
func (c *ClientWithResponses) DeleteZoneWithResponse(ctx context.Context, zoneId string, reqEditors ...RequestEditorFn) (*DeleteZoneResponse, error) {
	rsp, err := c.DeleteZone(ctx, zoneId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteZoneResponse(rsp)
}

// GetZoneWithResponse request returning *GetZoneResponse
func (c *ClientWithResponses) GetZoneWithResponse(ctx context.Context, zoneId string, reqEditors ...RequestEditorFn) (*GetZoneResponse, error) {
	rsp, err := c.GetZone(ctx, zoneId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetZoneResponse(rsp)
}

// UpdateZoneWithBodyWithResponse request with arbitrary body returning *UpdateZoneResponse
func (c *ClientWithResponses) UpdateZoneWithBodyWithResponse(ctx context.Context, zoneId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateZoneResponse, error) {
	rsp, err := c.UpdateZoneWithBody(ctx, zoneId, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateZoneResponse(rsp)
}

func (c *ClientWithResponses) UpdateZoneWithResponse(ctx context.Context, zoneId string, body UpdateZoneJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateZoneResponse, error) {
	rsp, err := c.UpdateZone(ctx, zoneId, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateZoneResponse(rsp)
}

// ParseAuthenticateResponse parses an HTTP response from a AuthenticateWithResponse call
func ParseAuthenticateResponse(rsp *http.Response) (*AuthenticateResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &AuthenticateResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Response
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	}

	return response, nil
}

// ParseGetResourcesResponse parses an HTTP response from a GetResourcesWithResponse call
func ParseGetResourcesResponse(rsp *http.Response) (*GetResourcesResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetResourcesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceGet `json:"data,omitempty"`
			Errors *[]Error       `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetBridgesResponse parses an HTTP response from a GetBridgesWithResponse call
func ParseGetBridgesResponse(rsp *http.Response) (*GetBridgesResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetBridgesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]BridgeGet `json:"data,omitempty"`
			Errors *[]Error     `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetBridgeResponse parses an HTTP response from a GetBridgeWithResponse call
func ParseGetBridgeResponse(rsp *http.Response) (*GetBridgeResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetBridgeResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]BridgeGet `json:"data,omitempty"`
			Errors *[]Error     `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseUpdateBridgeResponse parses an HTTP response from a UpdateBridgeWithResponse call
func ParseUpdateBridgeResponse(rsp *http.Response) (*UpdateBridgeResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateBridgeResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetBridgeHomesResponse parses an HTTP response from a GetBridgeHomesWithResponse call
func ParseGetBridgeHomesResponse(rsp *http.Response) (*GetBridgeHomesResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetBridgeHomesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]BridgeHomeGet `json:"data,omitempty"`
			Errors *[]Error         `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetBridgeHomeResponse parses an HTTP response from a GetBridgeHomeWithResponse call
func ParseGetBridgeHomeResponse(rsp *http.Response) (*GetBridgeHomeResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetBridgeHomeResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]BridgeHomeGet `json:"data,omitempty"`
			Errors *[]Error         `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetDevicesResponse parses an HTTP response from a GetDevicesWithResponse call
func ParseGetDevicesResponse(rsp *http.Response) (*GetDevicesResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDevicesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]DeviceGet `json:"data,omitempty"`
			Errors *[]Error     `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseDeleteDeviceResponse parses an HTTP response from a DeleteDeviceWithResponse call
func ParseDeleteDeviceResponse(rsp *http.Response) (*DeleteDeviceResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteDeviceResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetDeviceResponse parses an HTTP response from a GetDeviceWithResponse call
func ParseGetDeviceResponse(rsp *http.Response) (*GetDeviceResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDeviceResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]DeviceGet `json:"data,omitempty"`
			Errors *[]Error     `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseUpdateDeviceResponse parses an HTTP response from a UpdateDeviceWithResponse call
func ParseUpdateDeviceResponse(rsp *http.Response) (*UpdateDeviceResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateDeviceResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetDevicePowersResponse parses an HTTP response from a GetDevicePowersWithResponse call
func ParseGetDevicePowersResponse(rsp *http.Response) (*GetDevicePowersResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDevicePowersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]DevicePowerGet `json:"data,omitempty"`
			Errors *[]Error          `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetDevicePowerResponse parses an HTTP response from a GetDevicePowerWithResponse call
func ParseGetDevicePowerResponse(rsp *http.Response) (*GetDevicePowerResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDevicePowerResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]DevicePowerGet `json:"data,omitempty"`
			Errors *[]Error          `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetGroupedLightsResponse parses an HTTP response from a GetGroupedLightsWithResponse call
func ParseGetGroupedLightsResponse(rsp *http.Response) (*GetGroupedLightsResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetGroupedLightsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]GroupedLightGet `json:"data,omitempty"`
			Errors *[]Error           `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetGroupedLightResponse parses an HTTP response from a GetGroupedLightWithResponse call
func ParseGetGroupedLightResponse(rsp *http.Response) (*GetGroupedLightResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetGroupedLightResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]GroupedLightGet `json:"data,omitempty"`
			Errors *[]Error           `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseUpdateGroupedLightResponse parses an HTTP response from a UpdateGroupedLightWithResponse call
func ParseUpdateGroupedLightResponse(rsp *http.Response) (*UpdateGroupedLightResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateGroupedLightResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetLightsResponse parses an HTTP response from a GetLightsWithResponse call
func ParseGetLightsResponse(rsp *http.Response) (*GetLightsResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetLightsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]LightGet `json:"data,omitempty"`
			Errors *[]Error    `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetLightResponse parses an HTTP response from a GetLightWithResponse call
func ParseGetLightResponse(rsp *http.Response) (*GetLightResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetLightResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]LightGet `json:"data,omitempty"`
			Errors *[]Error    `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseUpdateLightResponse parses an HTTP response from a UpdateLightWithResponse call
func ParseUpdateLightResponse(rsp *http.Response) (*UpdateLightResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateLightResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetLightLevelsResponse parses an HTTP response from a GetLightLevelsWithResponse call
func ParseGetLightLevelsResponse(rsp *http.Response) (*GetLightLevelsResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetLightLevelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]LightLevelGet `json:"data,omitempty"`
			Errors *[]Error         `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetLightLevelResponse parses an HTTP response from a GetLightLevelWithResponse call
func ParseGetLightLevelResponse(rsp *http.Response) (*GetLightLevelResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetLightLevelResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]LightLevelGet `json:"data,omitempty"`
			Errors *[]Error         `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseUpdateLightLevelResponse parses an HTTP response from a UpdateLightLevelWithResponse call
func ParseUpdateLightLevelResponse(rsp *http.Response) (*UpdateLightLevelResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateLightLevelResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetMotionSensorsResponse parses an HTTP response from a GetMotionSensorsWithResponse call
func ParseGetMotionSensorsResponse(rsp *http.Response) (*GetMotionSensorsResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetMotionSensorsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]MotionGet `json:"data,omitempty"`
			Errors *[]Error     `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetMotionSensorResponse parses an HTTP response from a GetMotionSensorWithResponse call
func ParseGetMotionSensorResponse(rsp *http.Response) (*GetMotionSensorResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetMotionSensorResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]MotionGet `json:"data,omitempty"`
			Errors *[]Error     `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseUpdateMotionSensorResponse parses an HTTP response from a UpdateMotionSensorWithResponse call
func ParseUpdateMotionSensorResponse(rsp *http.Response) (*UpdateMotionSensorResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateMotionSensorResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetRoomsResponse parses an HTTP response from a GetRoomsWithResponse call
func ParseGetRoomsResponse(rsp *http.Response) (*GetRoomsResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetRoomsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]RoomGet `json:"data,omitempty"`
			Errors *[]Error   `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseCreateRoomResponse parses an HTTP response from a CreateRoomWithResponse call
func ParseCreateRoomResponse(rsp *http.Response) (*CreateRoomResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateRoomResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseDeleteRoomResponse parses an HTTP response from a DeleteRoomWithResponse call
func ParseDeleteRoomResponse(rsp *http.Response) (*DeleteRoomResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteRoomResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetRoomResponse parses an HTTP response from a GetRoomWithResponse call
func ParseGetRoomResponse(rsp *http.Response) (*GetRoomResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetRoomResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]RoomGet `json:"data,omitempty"`
			Errors *[]Error   `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseUpdateRoomResponse parses an HTTP response from a UpdateRoomWithResponse call
func ParseUpdateRoomResponse(rsp *http.Response) (*UpdateRoomResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateRoomResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetScenesResponse parses an HTTP response from a GetScenesWithResponse call
func ParseGetScenesResponse(rsp *http.Response) (*GetScenesResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetScenesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]SceneGet `json:"data,omitempty"`
			Errors *[]Error    `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseCreateSceneResponse parses an HTTP response from a CreateSceneWithResponse call
func ParseCreateSceneResponse(rsp *http.Response) (*CreateSceneResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateSceneResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseDeleteSceneResponse parses an HTTP response from a DeleteSceneWithResponse call
func ParseDeleteSceneResponse(rsp *http.Response) (*DeleteSceneResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteSceneResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetSceneResponse parses an HTTP response from a GetSceneWithResponse call
func ParseGetSceneResponse(rsp *http.Response) (*GetSceneResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetSceneResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]SceneGet `json:"data,omitempty"`
			Errors *[]Error    `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseUpdateSceneResponse parses an HTTP response from a UpdateSceneWithResponse call
func ParseUpdateSceneResponse(rsp *http.Response) (*UpdateSceneResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateSceneResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetSmartScenesResponse parses an HTTP response from a GetSmartScenesWithResponse call
func ParseGetSmartScenesResponse(rsp *http.Response) (*GetSmartScenesResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetSmartScenesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]SmartSceneGet `json:"data,omitempty"`
			Errors *[]Error         `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseCreateSmartSceneResponse parses an HTTP response from a CreateSmartSceneWithResponse call
func ParseCreateSmartSceneResponse(rsp *http.Response) (*CreateSmartSceneResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateSmartSceneResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseDeleteSmartSceneResponse parses an HTTP response from a DeleteSmartSceneWithResponse call
func ParseDeleteSmartSceneResponse(rsp *http.Response) (*DeleteSmartSceneResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteSmartSceneResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetSmartSceneResponse parses an HTTP response from a GetSmartSceneWithResponse call
func ParseGetSmartSceneResponse(rsp *http.Response) (*GetSmartSceneResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetSmartSceneResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]SmartSceneGet `json:"data,omitempty"`
			Errors *[]Error         `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseUpdateSmartSceneResponse parses an HTTP response from a UpdateSmartSceneWithResponse call
func ParseUpdateSmartSceneResponse(rsp *http.Response) (*UpdateSmartSceneResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateSmartSceneResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetTemperaturesResponse parses an HTTP response from a GetTemperaturesWithResponse call
func ParseGetTemperaturesResponse(rsp *http.Response) (*GetTemperaturesResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetTemperaturesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]TemperatureGet `json:"data,omitempty"`
			Errors *[]Error          `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetTemperatureResponse parses an HTTP response from a GetTemperatureWithResponse call
func ParseGetTemperatureResponse(rsp *http.Response) (*GetTemperatureResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetTemperatureResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]TemperatureGet `json:"data,omitempty"`
			Errors *[]Error          `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseUpdateTemperatureResponse parses an HTTP response from a UpdateTemperatureWithResponse call
func ParseUpdateTemperatureResponse(rsp *http.Response) (*UpdateTemperatureResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateTemperatureResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetZonesResponse parses an HTTP response from a GetZonesWithResponse call
func ParseGetZonesResponse(rsp *http.Response) (*GetZonesResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetZonesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]RoomGet `json:"data,omitempty"`
			Errors *[]Error   `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseCreateZoneResponse parses an HTTP response from a CreateZoneWithResponse call
func ParseCreateZoneResponse(rsp *http.Response) (*CreateZoneResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateZoneResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseDeleteZoneResponse parses an HTTP response from a DeleteZoneWithResponse call
func ParseDeleteZoneResponse(rsp *http.Response) (*DeleteZoneResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteZoneResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseGetZoneResponse parses an HTTP response from a GetZoneWithResponse call
func ParseGetZoneResponse(rsp *http.Response) (*GetZoneResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetZoneResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]RoomGet `json:"data,omitempty"`
			Errors *[]Error   `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ParseUpdateZoneResponse parses an HTTP response from a UpdateZoneWithResponse call
func ParseUpdateZoneResponse(rsp *http.Response) (*UpdateZoneResponse, error) {
	bodyBytes, err := io.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateZoneResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Data   *[]ResourceIdentifier `json:"data,omitempty"`
			Errors *[]Error              `json:"errors,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Unauthorized
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Forbidden
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest NotFound
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 405:
		var dest MethodNotAllowed
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON405 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 406:
		var dest NotAcceptable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON406 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 409:
		var dest Conflict
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON409 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 429:
		var dest TooManyRequests
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON429 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 500:
		var dest InternalServerError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON500 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest ServiceUnavailable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 507:
		var dest InsufficientStorage
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON507 = &dest

	}

	return response, nil
}

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Authenticate
	// (POST /api)
	Authenticate(w http.ResponseWriter, r *http.Request)
	// List resources
	// (GET /clip/v2/resource)
	GetResources(w http.ResponseWriter, r *http.Request)
	// List bridges
	// (GET /clip/v2/resource/bridge)
	GetBridges(w http.ResponseWriter, r *http.Request)
	// Get bridge
	// (GET /clip/v2/resource/bridge/{bridgeId})
	GetBridge(w http.ResponseWriter, r *http.Request, bridgeId string)
	// Update bridge
	// (PUT /clip/v2/resource/bridge/{bridgeId})
	UpdateBridge(w http.ResponseWriter, r *http.Request, bridgeId string)
	// List bridge homes.
	// (GET /clip/v2/resource/bridge_home)
	GetBridgeHomes(w http.ResponseWriter, r *http.Request)
	// Get bridge home.
	// (GET /clip/v2/resource/bridge_home/{bridgeHomeId})
	GetBridgeHome(w http.ResponseWriter, r *http.Request, bridgeHomeId string)
	// List devices
	// (GET /clip/v2/resource/device)
	GetDevices(w http.ResponseWriter, r *http.Request)
	// Delete Device
	// (DELETE /clip/v2/resource/device/{deviceId})
	DeleteDevice(w http.ResponseWriter, r *http.Request, deviceId string)
	// Get device
	// (GET /clip/v2/resource/device/{deviceId})
	GetDevice(w http.ResponseWriter, r *http.Request, deviceId string)
	// Update device
	// (PUT /clip/v2/resource/device/{deviceId})
	UpdateDevice(w http.ResponseWriter, r *http.Request, deviceId string)
	// List device powers
	// (GET /clip/v2/resource/device_power)
	GetDevicePowers(w http.ResponseWriter, r *http.Request)
	// Get device power
	// (GET /clip/v2/resource/device_power/{deviceId})
	GetDevicePower(w http.ResponseWriter, r *http.Request, deviceId string)
	// List grouped lights
	// (GET /clip/v2/resource/grouped_light)
	GetGroupedLights(w http.ResponseWriter, r *http.Request)
	// Get grouped light
	// (GET /clip/v2/resource/grouped_light/{groupedLightId})
	GetGroupedLight(w http.ResponseWriter, r *http.Request, groupedLightId string)
	// Update grouped light
	// (PUT /clip/v2/resource/grouped_light/{groupedLightId})
	UpdateGroupedLight(w http.ResponseWriter, r *http.Request, groupedLightId string)
	// List lights.
	// (GET /clip/v2/resource/light)
	GetLights(w http.ResponseWriter, r *http.Request)
	// Get light
	// (GET /clip/v2/resource/light/{lightId})
	GetLight(w http.ResponseWriter, r *http.Request, lightId string)
	// Update light
	// (PUT /clip/v2/resource/light/{lightId})
	UpdateLight(w http.ResponseWriter, r *http.Request, lightId string)
	// List light levels.
	// (GET /clip/v2/resource/light_level)
	GetLightLevels(w http.ResponseWriter, r *http.Request)
	// Get light
	// (GET /clip/v2/resource/light_level/{lightId})
	GetLightLevel(w http.ResponseWriter, r *http.Request, lightId string)
	// Update light
	// (PUT /clip/v2/resource/light_level/{lightId})
	UpdateLightLevel(w http.ResponseWriter, r *http.Request, lightId string)
	// List motion sensors.
	// (GET /clip/v2/resource/motion)
	GetMotionSensors(w http.ResponseWriter, r *http.Request)
	// Get motion sensor.
	// (GET /clip/v2/resource/motion/{motionId})
	GetMotionSensor(w http.ResponseWriter, r *http.Request, motionId string)
	// Update Motion Sensor
	// (PUT /clip/v2/resource/motion/{motionId})
	UpdateMotionSensor(w http.ResponseWriter, r *http.Request, motionId string)
	// List rooms
	// (GET /clip/v2/resource/room)
	GetRooms(w http.ResponseWriter, r *http.Request)
	// Create room
	// (POST /clip/v2/resource/room)
	CreateRoom(w http.ResponseWriter, r *http.Request)
	// Delete room
	// (DELETE /clip/v2/resource/room/{roomId})
	DeleteRoom(w http.ResponseWriter, r *http.Request, roomId string)
	// Get room.
	// (GET /clip/v2/resource/room/{roomId})
	GetRoom(w http.ResponseWriter, r *http.Request, roomId string)
	// Update room
	// (PUT /clip/v2/resource/room/{roomId})
	UpdateRoom(w http.ResponseWriter, r *http.Request, roomId string)
	// List scenes
	// (GET /clip/v2/resource/scene)
	GetScenes(w http.ResponseWriter, r *http.Request)
	// Create a new scene
	// (POST /clip/v2/resource/scene)
	CreateScene(w http.ResponseWriter, r *http.Request)
	// Delete a scene
	// (DELETE /clip/v2/resource/scene/{sceneId})
	DeleteScene(w http.ResponseWriter, r *http.Request, sceneId string)
	// Get a scene
	// (GET /clip/v2/resource/scene/{sceneId})
	GetScene(w http.ResponseWriter, r *http.Request, sceneId string)
	// Update a scene
	// (PUT /clip/v2/resource/scene/{sceneId})
	UpdateScene(w http.ResponseWriter, r *http.Request, sceneId string)
	// List smart scenes
	// (GET /clip/v2/resource/smart_scene)
	GetSmartScenes(w http.ResponseWriter, r *http.Request)
	// Create a new smart scene
	// (POST /clip/v2/resource/smart_scene)
	CreateSmartScene(w http.ResponseWriter, r *http.Request)
	// Delete a smart scene
	// (DELETE /clip/v2/resource/smart_scene/{sceneId})
	DeleteSmartScene(w http.ResponseWriter, r *http.Request, sceneId string)
	// Get a smart scene
	// (GET /clip/v2/resource/smart_scene/{sceneId})
	GetSmartScene(w http.ResponseWriter, r *http.Request, sceneId string)
	// Update a smart scene
	// (PUT /clip/v2/resource/smart_scene/{sceneId})
	UpdateSmartScene(w http.ResponseWriter, r *http.Request, sceneId string)
	// List temperatures
	// (GET /clip/v2/resource/temperature)
	GetTemperatures(w http.ResponseWriter, r *http.Request)
	// Get temperature sensor information
	// (GET /clip/v2/resource/temperature/{temperatureId})
	GetTemperature(w http.ResponseWriter, r *http.Request, temperatureId string)
	// Update temperature sensor
	// (PUT /clip/v2/resource/temperature/{temperatureId})
	UpdateTemperature(w http.ResponseWriter, r *http.Request, temperatureId string)
	// List zones
	// (GET /clip/v2/resource/zone)
	GetZones(w http.ResponseWriter, r *http.Request)
	// Create zone
	// (POST /clip/v2/resource/zone)
	CreateZone(w http.ResponseWriter, r *http.Request)
	// Delete Zone
	// (DELETE /clip/v2/resource/zone/{zoneId})
	DeleteZone(w http.ResponseWriter, r *http.Request, zoneId string)
	// Get Zone.
	// (GET /clip/v2/resource/zone/{zoneId})
	GetZone(w http.ResponseWriter, r *http.Request, zoneId string)
	// Update Zone
	// (PUT /clip/v2/resource/zone/{zoneId})
	UpdateZone(w http.ResponseWriter, r *http.Request, zoneId string)
}

// ServerInterfaceWrapper converts contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler            ServerInterface
	HandlerMiddlewares []MiddlewareFunc
	ErrorHandlerFunc   func(w http.ResponseWriter, r *http.Request, err error)
}

type MiddlewareFunc func(http.Handler) http.Handler

// Authenticate operation middleware
func (siw *ServerInterfaceWrapper) Authenticate(w http.ResponseWriter, r *http.Request) {

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.Authenticate(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetResources operation middleware
func (siw *ServerInterfaceWrapper) GetResources(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetResources(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetBridges operation middleware
func (siw *ServerInterfaceWrapper) GetBridges(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetBridges(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetBridge operation middleware
func (siw *ServerInterfaceWrapper) GetBridge(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "bridgeId" -------------
	var bridgeId string

	err = runtime.BindStyledParameterWithOptions("simple", "bridgeId", r.PathValue("bridgeId"), &bridgeId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "bridgeId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetBridge(w, r, bridgeId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// UpdateBridge operation middleware
func (siw *ServerInterfaceWrapper) UpdateBridge(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "bridgeId" -------------
	var bridgeId string

	err = runtime.BindStyledParameterWithOptions("simple", "bridgeId", r.PathValue("bridgeId"), &bridgeId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "bridgeId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.UpdateBridge(w, r, bridgeId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetBridgeHomes operation middleware
func (siw *ServerInterfaceWrapper) GetBridgeHomes(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetBridgeHomes(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetBridgeHome operation middleware
func (siw *ServerInterfaceWrapper) GetBridgeHome(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "bridgeHomeId" -------------
	var bridgeHomeId string

	err = runtime.BindStyledParameterWithOptions("simple", "bridgeHomeId", r.PathValue("bridgeHomeId"), &bridgeHomeId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "bridgeHomeId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetBridgeHome(w, r, bridgeHomeId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetDevices operation middleware
func (siw *ServerInterfaceWrapper) GetDevices(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetDevices(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// DeleteDevice operation middleware
func (siw *ServerInterfaceWrapper) DeleteDevice(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "deviceId" -------------
	var deviceId string

	err = runtime.BindStyledParameterWithOptions("simple", "deviceId", r.PathValue("deviceId"), &deviceId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "deviceId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.DeleteDevice(w, r, deviceId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetDevice operation middleware
func (siw *ServerInterfaceWrapper) GetDevice(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "deviceId" -------------
	var deviceId string

	err = runtime.BindStyledParameterWithOptions("simple", "deviceId", r.PathValue("deviceId"), &deviceId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "deviceId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetDevice(w, r, deviceId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// UpdateDevice operation middleware
func (siw *ServerInterfaceWrapper) UpdateDevice(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "deviceId" -------------
	var deviceId string

	err = runtime.BindStyledParameterWithOptions("simple", "deviceId", r.PathValue("deviceId"), &deviceId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "deviceId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.UpdateDevice(w, r, deviceId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetDevicePowers operation middleware
func (siw *ServerInterfaceWrapper) GetDevicePowers(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetDevicePowers(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetDevicePower operation middleware
func (siw *ServerInterfaceWrapper) GetDevicePower(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "deviceId" -------------
	var deviceId string

	err = runtime.BindStyledParameterWithOptions("simple", "deviceId", r.PathValue("deviceId"), &deviceId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "deviceId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetDevicePower(w, r, deviceId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetGroupedLights operation middleware
func (siw *ServerInterfaceWrapper) GetGroupedLights(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetGroupedLights(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetGroupedLight operation middleware
func (siw *ServerInterfaceWrapper) GetGroupedLight(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "groupedLightId" -------------
	var groupedLightId string

	err = runtime.BindStyledParameterWithOptions("simple", "groupedLightId", r.PathValue("groupedLightId"), &groupedLightId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "groupedLightId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetGroupedLight(w, r, groupedLightId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// UpdateGroupedLight operation middleware
func (siw *ServerInterfaceWrapper) UpdateGroupedLight(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "groupedLightId" -------------
	var groupedLightId string

	err = runtime.BindStyledParameterWithOptions("simple", "groupedLightId", r.PathValue("groupedLightId"), &groupedLightId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "groupedLightId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.UpdateGroupedLight(w, r, groupedLightId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetLights operation middleware
func (siw *ServerInterfaceWrapper) GetLights(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetLights(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetLight operation middleware
func (siw *ServerInterfaceWrapper) GetLight(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "lightId" -------------
	var lightId string

	err = runtime.BindStyledParameterWithOptions("simple", "lightId", r.PathValue("lightId"), &lightId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "lightId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetLight(w, r, lightId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// UpdateLight operation middleware
func (siw *ServerInterfaceWrapper) UpdateLight(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "lightId" -------------
	var lightId string

	err = runtime.BindStyledParameterWithOptions("simple", "lightId", r.PathValue("lightId"), &lightId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "lightId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.UpdateLight(w, r, lightId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetLightLevels operation middleware
func (siw *ServerInterfaceWrapper) GetLightLevels(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetLightLevels(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetLightLevel operation middleware
func (siw *ServerInterfaceWrapper) GetLightLevel(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "lightId" -------------
	var lightId string

	err = runtime.BindStyledParameterWithOptions("simple", "lightId", r.PathValue("lightId"), &lightId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "lightId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetLightLevel(w, r, lightId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// UpdateLightLevel operation middleware
func (siw *ServerInterfaceWrapper) UpdateLightLevel(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "lightId" -------------
	var lightId string

	err = runtime.BindStyledParameterWithOptions("simple", "lightId", r.PathValue("lightId"), &lightId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "lightId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.UpdateLightLevel(w, r, lightId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetMotionSensors operation middleware
func (siw *ServerInterfaceWrapper) GetMotionSensors(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetMotionSensors(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetMotionSensor operation middleware
func (siw *ServerInterfaceWrapper) GetMotionSensor(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "motionId" -------------
	var motionId string

	err = runtime.BindStyledParameterWithOptions("simple", "motionId", r.PathValue("motionId"), &motionId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "motionId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetMotionSensor(w, r, motionId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// UpdateMotionSensor operation middleware
func (siw *ServerInterfaceWrapper) UpdateMotionSensor(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "motionId" -------------
	var motionId string

	err = runtime.BindStyledParameterWithOptions("simple", "motionId", r.PathValue("motionId"), &motionId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "motionId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.UpdateMotionSensor(w, r, motionId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetRooms operation middleware
func (siw *ServerInterfaceWrapper) GetRooms(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetRooms(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// CreateRoom operation middleware
func (siw *ServerInterfaceWrapper) CreateRoom(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.CreateRoom(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// DeleteRoom operation middleware
func (siw *ServerInterfaceWrapper) DeleteRoom(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "roomId" -------------
	var roomId string

	err = runtime.BindStyledParameterWithOptions("simple", "roomId", r.PathValue("roomId"), &roomId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "roomId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.DeleteRoom(w, r, roomId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetRoom operation middleware
func (siw *ServerInterfaceWrapper) GetRoom(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "roomId" -------------
	var roomId string

	err = runtime.BindStyledParameterWithOptions("simple", "roomId", r.PathValue("roomId"), &roomId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "roomId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetRoom(w, r, roomId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// UpdateRoom operation middleware
func (siw *ServerInterfaceWrapper) UpdateRoom(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "roomId" -------------
	var roomId string

	err = runtime.BindStyledParameterWithOptions("simple", "roomId", r.PathValue("roomId"), &roomId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "roomId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.UpdateRoom(w, r, roomId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetScenes operation middleware
func (siw *ServerInterfaceWrapper) GetScenes(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetScenes(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// CreateScene operation middleware
func (siw *ServerInterfaceWrapper) CreateScene(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.CreateScene(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// DeleteScene operation middleware
func (siw *ServerInterfaceWrapper) DeleteScene(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "sceneId" -------------
	var sceneId string

	err = runtime.BindStyledParameterWithOptions("simple", "sceneId", r.PathValue("sceneId"), &sceneId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "sceneId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.DeleteScene(w, r, sceneId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetScene operation middleware
func (siw *ServerInterfaceWrapper) GetScene(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "sceneId" -------------
	var sceneId string

	err = runtime.BindStyledParameterWithOptions("simple", "sceneId", r.PathValue("sceneId"), &sceneId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "sceneId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetScene(w, r, sceneId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// UpdateScene operation middleware
func (siw *ServerInterfaceWrapper) UpdateScene(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "sceneId" -------------
	var sceneId string

	err = runtime.BindStyledParameterWithOptions("simple", "sceneId", r.PathValue("sceneId"), &sceneId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "sceneId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.UpdateScene(w, r, sceneId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetSmartScenes operation middleware
func (siw *ServerInterfaceWrapper) GetSmartScenes(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetSmartScenes(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// CreateSmartScene operation middleware
func (siw *ServerInterfaceWrapper) CreateSmartScene(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.CreateSmartScene(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// DeleteSmartScene operation middleware
func (siw *ServerInterfaceWrapper) DeleteSmartScene(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "sceneId" -------------
	var sceneId string

	err = runtime.BindStyledParameterWithOptions("simple", "sceneId", r.PathValue("sceneId"), &sceneId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "sceneId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.DeleteSmartScene(w, r, sceneId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetSmartScene operation middleware
func (siw *ServerInterfaceWrapper) GetSmartScene(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "sceneId" -------------
	var sceneId string

	err = runtime.BindStyledParameterWithOptions("simple", "sceneId", r.PathValue("sceneId"), &sceneId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "sceneId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetSmartScene(w, r, sceneId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// UpdateSmartScene operation middleware
func (siw *ServerInterfaceWrapper) UpdateSmartScene(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "sceneId" -------------
	var sceneId string

	err = runtime.BindStyledParameterWithOptions("simple", "sceneId", r.PathValue("sceneId"), &sceneId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "sceneId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.UpdateSmartScene(w, r, sceneId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetTemperatures operation middleware
func (siw *ServerInterfaceWrapper) GetTemperatures(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetTemperatures(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetTemperature operation middleware
func (siw *ServerInterfaceWrapper) GetTemperature(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "temperatureId" -------------
	var temperatureId string

	err = runtime.BindStyledParameterWithOptions("simple", "temperatureId", r.PathValue("temperatureId"), &temperatureId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "temperatureId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetTemperature(w, r, temperatureId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// UpdateTemperature operation middleware
func (siw *ServerInterfaceWrapper) UpdateTemperature(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "temperatureId" -------------
	var temperatureId string

	err = runtime.BindStyledParameterWithOptions("simple", "temperatureId", r.PathValue("temperatureId"), &temperatureId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "temperatureId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.UpdateTemperature(w, r, temperatureId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetZones operation middleware
func (siw *ServerInterfaceWrapper) GetZones(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetZones(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// CreateZone operation middleware
func (siw *ServerInterfaceWrapper) CreateZone(w http.ResponseWriter, r *http.Request) {

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.CreateZone(w, r)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// DeleteZone operation middleware
func (siw *ServerInterfaceWrapper) DeleteZone(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "zoneId" -------------
	var zoneId string

	err = runtime.BindStyledParameterWithOptions("simple", "zoneId", r.PathValue("zoneId"), &zoneId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "zoneId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.DeleteZone(w, r, zoneId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// GetZone operation middleware
func (siw *ServerInterfaceWrapper) GetZone(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "zoneId" -------------
	var zoneId string

	err = runtime.BindStyledParameterWithOptions("simple", "zoneId", r.PathValue("zoneId"), &zoneId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "zoneId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetZone(w, r, zoneId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

// UpdateZone operation middleware
func (siw *ServerInterfaceWrapper) UpdateZone(w http.ResponseWriter, r *http.Request) {

	var err error

	// ------------- Path parameter "zoneId" -------------
	var zoneId string

	err = runtime.BindStyledParameterWithOptions("simple", "zoneId", r.PathValue("zoneId"), &zoneId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "zoneId", Err: err})
		return
	}

	ctx := r.Context()

	ctx = context.WithValue(ctx, HueApplicationKeyScopes, []string{})

	r = r.WithContext(ctx)

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.UpdateZone(w, r, zoneId)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r)
}

type UnescapedCookieParamError struct {
	ParamName string
	Err       error
}

func (e *UnescapedCookieParamError) Error() string {
	return fmt.Sprintf("error unescaping cookie parameter '%s'", e.ParamName)
}

func (e *UnescapedCookieParamError) Unwrap() error {
	return e.Err
}

type UnmarshalingParamError struct {
	ParamName string
	Err       error
}

func (e *UnmarshalingParamError) Error() string {
	return fmt.Sprintf("Error unmarshaling parameter %s as JSON: %s", e.ParamName, e.Err.Error())
}

func (e *UnmarshalingParamError) Unwrap() error {
	return e.Err
}

type RequiredParamError struct {
	ParamName string
}

func (e *RequiredParamError) Error() string {
	return fmt.Sprintf("Query argument %s is required, but not found", e.ParamName)
}

type RequiredHeaderError struct {
	ParamName string
	Err       error
}

func (e *RequiredHeaderError) Error() string {
	return fmt.Sprintf("Header parameter %s is required, but not found", e.ParamName)
}

func (e *RequiredHeaderError) Unwrap() error {
	return e.Err
}

type InvalidParamFormatError struct {
	ParamName string
	Err       error
}

func (e *InvalidParamFormatError) Error() string {
	return fmt.Sprintf("Invalid format for parameter %s: %s", e.ParamName, e.Err.Error())
}

func (e *InvalidParamFormatError) Unwrap() error {
	return e.Err
}

type TooManyValuesForParamError struct {
	ParamName string
	Count     int
}

func (e *TooManyValuesForParamError) Error() string {
	return fmt.Sprintf("Expected one value for %s, got %d", e.ParamName, e.Count)
}

// Handler creates http.Handler with routing matching OpenAPI spec.
func Handler(si ServerInterface) http.Handler {
	return HandlerWithOptions(si, StdHTTPServerOptions{})
}

// ServeMux is an abstraction of http.ServeMux.
type ServeMux interface {
	HandleFunc(pattern string, handler func(http.ResponseWriter, *http.Request))
	ServeHTTP(w http.ResponseWriter, r *http.Request)
}

type StdHTTPServerOptions struct {
	BaseURL          string
	BaseRouter       ServeMux
	Middlewares      []MiddlewareFunc
	ErrorHandlerFunc func(w http.ResponseWriter, r *http.Request, err error)
}

// HandlerFromMux creates http.Handler with routing matching OpenAPI spec based on the provided mux.
func HandlerFromMux(si ServerInterface, m ServeMux) http.Handler {
	return HandlerWithOptions(si, StdHTTPServerOptions{
		BaseRouter: m,
	})
}

func HandlerFromMuxWithBaseURL(si ServerInterface, m ServeMux, baseURL string) http.Handler {
	return HandlerWithOptions(si, StdHTTPServerOptions{
		BaseURL:    baseURL,
		BaseRouter: m,
	})
}

// HandlerWithOptions creates http.Handler with additional options
func HandlerWithOptions(si ServerInterface, options StdHTTPServerOptions) http.Handler {
	m := options.BaseRouter

	if m == nil {
		m = http.NewServeMux()
	}
	if options.ErrorHandlerFunc == nil {
		options.ErrorHandlerFunc = func(w http.ResponseWriter, r *http.Request, err error) {
			http.Error(w, err.Error(), http.StatusBadRequest)
		}
	}

	wrapper := ServerInterfaceWrapper{
		Handler:            si,
		HandlerMiddlewares: options.Middlewares,
		ErrorHandlerFunc:   options.ErrorHandlerFunc,
	}

	m.HandleFunc("POST "+options.BaseURL+"/api", wrapper.Authenticate)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource", wrapper.GetResources)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/bridge", wrapper.GetBridges)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/bridge/{bridgeId}", wrapper.GetBridge)
	m.HandleFunc("PUT "+options.BaseURL+"/clip/v2/resource/bridge/{bridgeId}", wrapper.UpdateBridge)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/bridge_home", wrapper.GetBridgeHomes)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/bridge_home/{bridgeHomeId}", wrapper.GetBridgeHome)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/device", wrapper.GetDevices)
	m.HandleFunc("DELETE "+options.BaseURL+"/clip/v2/resource/device/{deviceId}", wrapper.DeleteDevice)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/device/{deviceId}", wrapper.GetDevice)
	m.HandleFunc("PUT "+options.BaseURL+"/clip/v2/resource/device/{deviceId}", wrapper.UpdateDevice)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/device_power", wrapper.GetDevicePowers)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/device_power/{deviceId}", wrapper.GetDevicePower)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/grouped_light", wrapper.GetGroupedLights)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/grouped_light/{groupedLightId}", wrapper.GetGroupedLight)
	m.HandleFunc("PUT "+options.BaseURL+"/clip/v2/resource/grouped_light/{groupedLightId}", wrapper.UpdateGroupedLight)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/light", wrapper.GetLights)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/light/{lightId}", wrapper.GetLight)
	m.HandleFunc("PUT "+options.BaseURL+"/clip/v2/resource/light/{lightId}", wrapper.UpdateLight)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/light_level", wrapper.GetLightLevels)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/light_level/{lightId}", wrapper.GetLightLevel)
	m.HandleFunc("PUT "+options.BaseURL+"/clip/v2/resource/light_level/{lightId}", wrapper.UpdateLightLevel)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/motion", wrapper.GetMotionSensors)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/motion/{motionId}", wrapper.GetMotionSensor)
	m.HandleFunc("PUT "+options.BaseURL+"/clip/v2/resource/motion/{motionId}", wrapper.UpdateMotionSensor)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/room", wrapper.GetRooms)
	m.HandleFunc("POST "+options.BaseURL+"/clip/v2/resource/room", wrapper.CreateRoom)
	m.HandleFunc("DELETE "+options.BaseURL+"/clip/v2/resource/room/{roomId}", wrapper.DeleteRoom)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/room/{roomId}", wrapper.GetRoom)
	m.HandleFunc("PUT "+options.BaseURL+"/clip/v2/resource/room/{roomId}", wrapper.UpdateRoom)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/scene", wrapper.GetScenes)
	m.HandleFunc("POST "+options.BaseURL+"/clip/v2/resource/scene", wrapper.CreateScene)
	m.HandleFunc("DELETE "+options.BaseURL+"/clip/v2/resource/scene/{sceneId}", wrapper.DeleteScene)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/scene/{sceneId}", wrapper.GetScene)
	m.HandleFunc("PUT "+options.BaseURL+"/clip/v2/resource/scene/{sceneId}", wrapper.UpdateScene)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/smart_scene", wrapper.GetSmartScenes)
	m.HandleFunc("POST "+options.BaseURL+"/clip/v2/resource/smart_scene", wrapper.CreateSmartScene)
	m.HandleFunc("DELETE "+options.BaseURL+"/clip/v2/resource/smart_scene/{sceneId}", wrapper.DeleteSmartScene)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/smart_scene/{sceneId}", wrapper.GetSmartScene)
	m.HandleFunc("PUT "+options.BaseURL+"/clip/v2/resource/smart_scene/{sceneId}", wrapper.UpdateSmartScene)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/temperature", wrapper.GetTemperatures)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/temperature/{temperatureId}", wrapper.GetTemperature)
	m.HandleFunc("PUT "+options.BaseURL+"/clip/v2/resource/temperature/{temperatureId}", wrapper.UpdateTemperature)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/zone", wrapper.GetZones)
	m.HandleFunc("POST "+options.BaseURL+"/clip/v2/resource/zone", wrapper.CreateZone)
	m.HandleFunc("DELETE "+options.BaseURL+"/clip/v2/resource/zone/{zoneId}", wrapper.DeleteZone)
	m.HandleFunc("GET "+options.BaseURL+"/clip/v2/resource/zone/{zoneId}", wrapper.GetZone)
	m.HandleFunc("PUT "+options.BaseURL+"/clip/v2/resource/zone/{zoneId}", wrapper.UpdateZone)

	return m
}

type ConflictJSONResponse ErrorResponse

type ForbiddenJSONResponse ErrorResponse

type InsufficientStorageJSONResponse ErrorResponse

type InternalServerErrorJSONResponse ErrorResponse

type MethodNotAllowedJSONResponse ErrorResponse

type NotAcceptableJSONResponse ErrorResponse

type NotFoundJSONResponse ErrorResponse

type ServiceUnavailableJSONResponse ErrorResponse

type TooManyRequestsJSONResponse ErrorResponse

type UnauthorizedJSONResponse ErrorResponse

type AuthenticateRequestObject struct {
	Body *AuthenticateJSONRequestBody
}

type AuthenticateResponseObject interface {
	VisitAuthenticateResponse(w http.ResponseWriter) error
}

type Authenticate200JSONResponse Response

func (response Authenticate200JSONResponse) VisitAuthenticateResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type Authenticate401JSONResponse struct{ UnauthorizedJSONResponse }

func (response Authenticate401JSONResponse) VisitAuthenticateResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetResourcesRequestObject struct {
}

type GetResourcesResponseObject interface {
	VisitGetResourcesResponse(w http.ResponseWriter) error
}

type GetResources200JSONResponse struct {
	Data   *[]ResourceGet `json:"data,omitempty"`
	Errors *[]Error       `json:"errors,omitempty"`
}

func (response GetResources200JSONResponse) VisitGetResourcesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetResources401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetResources401JSONResponse) VisitGetResourcesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetResources403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetResources403JSONResponse) VisitGetResourcesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetResources404JSONResponse struct{ NotFoundJSONResponse }

func (response GetResources404JSONResponse) VisitGetResourcesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetResources405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetResources405JSONResponse) VisitGetResourcesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetResources406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetResources406JSONResponse) VisitGetResourcesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetResources409JSONResponse struct{ ConflictJSONResponse }

func (response GetResources409JSONResponse) VisitGetResourcesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetResources429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetResources429JSONResponse) VisitGetResourcesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetResources500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetResources500JSONResponse) VisitGetResourcesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetResources503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetResources503JSONResponse) VisitGetResourcesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetResources507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetResources507JSONResponse) VisitGetResourcesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgesRequestObject struct {
}

type GetBridgesResponseObject interface {
	VisitGetBridgesResponse(w http.ResponseWriter) error
}

type GetBridges200JSONResponse struct {
	Data   *[]BridgeGet `json:"data,omitempty"`
	Errors *[]Error     `json:"errors,omitempty"`
}

func (response GetBridges200JSONResponse) VisitGetBridgesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetBridges401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetBridges401JSONResponse) VisitGetBridgesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetBridges403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetBridges403JSONResponse) VisitGetBridgesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetBridges404JSONResponse struct{ NotFoundJSONResponse }

func (response GetBridges404JSONResponse) VisitGetBridgesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetBridges405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetBridges405JSONResponse) VisitGetBridgesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetBridges406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetBridges406JSONResponse) VisitGetBridgesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetBridges409JSONResponse struct{ ConflictJSONResponse }

func (response GetBridges409JSONResponse) VisitGetBridgesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetBridges429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetBridges429JSONResponse) VisitGetBridgesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetBridges500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetBridges500JSONResponse) VisitGetBridgesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetBridges503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetBridges503JSONResponse) VisitGetBridgesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetBridges507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetBridges507JSONResponse) VisitGetBridgesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeRequestObject struct {
	BridgeId string `json:"bridgeId"`
}

type GetBridgeResponseObject interface {
	VisitGetBridgeResponse(w http.ResponseWriter) error
}

type GetBridge200JSONResponse struct {
	Data   *[]BridgeGet `json:"data,omitempty"`
	Errors *[]Error     `json:"errors,omitempty"`
}

func (response GetBridge200JSONResponse) VisitGetBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetBridge401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetBridge401JSONResponse) VisitGetBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetBridge403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetBridge403JSONResponse) VisitGetBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetBridge404JSONResponse struct{ NotFoundJSONResponse }

func (response GetBridge404JSONResponse) VisitGetBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetBridge405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetBridge405JSONResponse) VisitGetBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetBridge406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetBridge406JSONResponse) VisitGetBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetBridge409JSONResponse struct{ ConflictJSONResponse }

func (response GetBridge409JSONResponse) VisitGetBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetBridge429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetBridge429JSONResponse) VisitGetBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetBridge500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetBridge500JSONResponse) VisitGetBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetBridge503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetBridge503JSONResponse) VisitGetBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetBridge507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetBridge507JSONResponse) VisitGetBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type UpdateBridgeRequestObject struct {
	BridgeId string `json:"bridgeId"`
	Body     *UpdateBridgeJSONRequestBody
}

type UpdateBridgeResponseObject interface {
	VisitUpdateBridgeResponse(w http.ResponseWriter) error
}

type UpdateBridge200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response UpdateBridge200JSONResponse) VisitUpdateBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type UpdateBridge401JSONResponse struct{ UnauthorizedJSONResponse }

func (response UpdateBridge401JSONResponse) VisitUpdateBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type UpdateBridge403JSONResponse struct{ ForbiddenJSONResponse }

func (response UpdateBridge403JSONResponse) VisitUpdateBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type UpdateBridge404JSONResponse struct{ NotFoundJSONResponse }

func (response UpdateBridge404JSONResponse) VisitUpdateBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type UpdateBridge405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response UpdateBridge405JSONResponse) VisitUpdateBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type UpdateBridge406JSONResponse struct{ NotAcceptableJSONResponse }

func (response UpdateBridge406JSONResponse) VisitUpdateBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type UpdateBridge409JSONResponse struct{ ConflictJSONResponse }

func (response UpdateBridge409JSONResponse) VisitUpdateBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type UpdateBridge429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response UpdateBridge429JSONResponse) VisitUpdateBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type UpdateBridge500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response UpdateBridge500JSONResponse) VisitUpdateBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type UpdateBridge503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response UpdateBridge503JSONResponse) VisitUpdateBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type UpdateBridge507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response UpdateBridge507JSONResponse) VisitUpdateBridgeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHomesRequestObject struct {
}

type GetBridgeHomesResponseObject interface {
	VisitGetBridgeHomesResponse(w http.ResponseWriter) error
}

type GetBridgeHomes200JSONResponse struct {
	Data   *[]BridgeHomeGet `json:"data,omitempty"`
	Errors *[]Error         `json:"errors,omitempty"`
}

func (response GetBridgeHomes200JSONResponse) VisitGetBridgeHomesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHomes401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetBridgeHomes401JSONResponse) VisitGetBridgeHomesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHomes403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetBridgeHomes403JSONResponse) VisitGetBridgeHomesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHomes404JSONResponse struct{ NotFoundJSONResponse }

func (response GetBridgeHomes404JSONResponse) VisitGetBridgeHomesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHomes405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetBridgeHomes405JSONResponse) VisitGetBridgeHomesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHomes406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetBridgeHomes406JSONResponse) VisitGetBridgeHomesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHomes409JSONResponse struct{ ConflictJSONResponse }

func (response GetBridgeHomes409JSONResponse) VisitGetBridgeHomesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHomes429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetBridgeHomes429JSONResponse) VisitGetBridgeHomesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHomes500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetBridgeHomes500JSONResponse) VisitGetBridgeHomesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHomes503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetBridgeHomes503JSONResponse) VisitGetBridgeHomesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHomes507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetBridgeHomes507JSONResponse) VisitGetBridgeHomesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHomeRequestObject struct {
	BridgeHomeId string `json:"bridgeHomeId"`
}

type GetBridgeHomeResponseObject interface {
	VisitGetBridgeHomeResponse(w http.ResponseWriter) error
}

type GetBridgeHome200JSONResponse struct {
	Data   *[]BridgeHomeGet `json:"data,omitempty"`
	Errors *[]Error         `json:"errors,omitempty"`
}

func (response GetBridgeHome200JSONResponse) VisitGetBridgeHomeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHome401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetBridgeHome401JSONResponse) VisitGetBridgeHomeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHome403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetBridgeHome403JSONResponse) VisitGetBridgeHomeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHome404JSONResponse struct{ NotFoundJSONResponse }

func (response GetBridgeHome404JSONResponse) VisitGetBridgeHomeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHome405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetBridgeHome405JSONResponse) VisitGetBridgeHomeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHome406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetBridgeHome406JSONResponse) VisitGetBridgeHomeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHome409JSONResponse struct{ ConflictJSONResponse }

func (response GetBridgeHome409JSONResponse) VisitGetBridgeHomeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHome429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetBridgeHome429JSONResponse) VisitGetBridgeHomeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHome500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetBridgeHome500JSONResponse) VisitGetBridgeHomeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHome503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetBridgeHome503JSONResponse) VisitGetBridgeHomeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetBridgeHome507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetBridgeHome507JSONResponse) VisitGetBridgeHomeResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicesRequestObject struct {
}

type GetDevicesResponseObject interface {
	VisitGetDevicesResponse(w http.ResponseWriter) error
}

type GetDevices200JSONResponse struct {
	Data   *[]DeviceGet `json:"data,omitempty"`
	Errors *[]Error     `json:"errors,omitempty"`
}

func (response GetDevices200JSONResponse) VisitGetDevicesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetDevices401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetDevices401JSONResponse) VisitGetDevicesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetDevices403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetDevices403JSONResponse) VisitGetDevicesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetDevices404JSONResponse struct{ NotFoundJSONResponse }

func (response GetDevices404JSONResponse) VisitGetDevicesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetDevices405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetDevices405JSONResponse) VisitGetDevicesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetDevices406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetDevices406JSONResponse) VisitGetDevicesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetDevices409JSONResponse struct{ ConflictJSONResponse }

func (response GetDevices409JSONResponse) VisitGetDevicesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetDevices429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetDevices429JSONResponse) VisitGetDevicesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetDevices500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetDevices500JSONResponse) VisitGetDevicesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetDevices503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetDevices503JSONResponse) VisitGetDevicesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetDevices507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetDevices507JSONResponse) VisitGetDevicesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type DeleteDeviceRequestObject struct {
	DeviceId string `json:"deviceId"`
}

type DeleteDeviceResponseObject interface {
	VisitDeleteDeviceResponse(w http.ResponseWriter) error
}

type DeleteDevice200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response DeleteDevice200JSONResponse) VisitDeleteDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type DeleteDevice401JSONResponse struct{ UnauthorizedJSONResponse }

func (response DeleteDevice401JSONResponse) VisitDeleteDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type DeleteDevice403JSONResponse struct{ ForbiddenJSONResponse }

func (response DeleteDevice403JSONResponse) VisitDeleteDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type DeleteDevice404JSONResponse struct{ NotFoundJSONResponse }

func (response DeleteDevice404JSONResponse) VisitDeleteDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type DeleteDevice405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response DeleteDevice405JSONResponse) VisitDeleteDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type DeleteDevice406JSONResponse struct{ NotAcceptableJSONResponse }

func (response DeleteDevice406JSONResponse) VisitDeleteDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type DeleteDevice409JSONResponse struct{ ConflictJSONResponse }

func (response DeleteDevice409JSONResponse) VisitDeleteDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type DeleteDevice429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response DeleteDevice429JSONResponse) VisitDeleteDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type DeleteDevice500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response DeleteDevice500JSONResponse) VisitDeleteDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type DeleteDevice503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response DeleteDevice503JSONResponse) VisitDeleteDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type DeleteDevice507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response DeleteDevice507JSONResponse) VisitDeleteDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetDeviceRequestObject struct {
	DeviceId string `json:"deviceId"`
}

type GetDeviceResponseObject interface {
	VisitGetDeviceResponse(w http.ResponseWriter) error
}

type GetDevice200JSONResponse struct {
	Data   *[]DeviceGet `json:"data,omitempty"`
	Errors *[]Error     `json:"errors,omitempty"`
}

func (response GetDevice200JSONResponse) VisitGetDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetDevice401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetDevice401JSONResponse) VisitGetDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetDevice403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetDevice403JSONResponse) VisitGetDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetDevice404JSONResponse struct{ NotFoundJSONResponse }

func (response GetDevice404JSONResponse) VisitGetDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetDevice405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetDevice405JSONResponse) VisitGetDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetDevice406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetDevice406JSONResponse) VisitGetDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetDevice409JSONResponse struct{ ConflictJSONResponse }

func (response GetDevice409JSONResponse) VisitGetDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetDevice429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetDevice429JSONResponse) VisitGetDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetDevice500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetDevice500JSONResponse) VisitGetDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetDevice503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetDevice503JSONResponse) VisitGetDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetDevice507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetDevice507JSONResponse) VisitGetDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type UpdateDeviceRequestObject struct {
	DeviceId string `json:"deviceId"`
	Body     *UpdateDeviceJSONRequestBody
}

type UpdateDeviceResponseObject interface {
	VisitUpdateDeviceResponse(w http.ResponseWriter) error
}

type UpdateDevice200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response UpdateDevice200JSONResponse) VisitUpdateDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type UpdateDevice401JSONResponse struct{ UnauthorizedJSONResponse }

func (response UpdateDevice401JSONResponse) VisitUpdateDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type UpdateDevice403JSONResponse struct{ ForbiddenJSONResponse }

func (response UpdateDevice403JSONResponse) VisitUpdateDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type UpdateDevice404JSONResponse struct{ NotFoundJSONResponse }

func (response UpdateDevice404JSONResponse) VisitUpdateDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type UpdateDevice405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response UpdateDevice405JSONResponse) VisitUpdateDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type UpdateDevice406JSONResponse struct{ NotAcceptableJSONResponse }

func (response UpdateDevice406JSONResponse) VisitUpdateDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type UpdateDevice409JSONResponse struct{ ConflictJSONResponse }

func (response UpdateDevice409JSONResponse) VisitUpdateDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type UpdateDevice429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response UpdateDevice429JSONResponse) VisitUpdateDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type UpdateDevice500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response UpdateDevice500JSONResponse) VisitUpdateDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type UpdateDevice503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response UpdateDevice503JSONResponse) VisitUpdateDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type UpdateDevice507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response UpdateDevice507JSONResponse) VisitUpdateDeviceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePowersRequestObject struct {
}

type GetDevicePowersResponseObject interface {
	VisitGetDevicePowersResponse(w http.ResponseWriter) error
}

type GetDevicePowers200JSONResponse struct {
	Data   *[]DevicePowerGet `json:"data,omitempty"`
	Errors *[]Error          `json:"errors,omitempty"`
}

func (response GetDevicePowers200JSONResponse) VisitGetDevicePowersResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePowers401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetDevicePowers401JSONResponse) VisitGetDevicePowersResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePowers403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetDevicePowers403JSONResponse) VisitGetDevicePowersResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePowers404JSONResponse struct{ NotFoundJSONResponse }

func (response GetDevicePowers404JSONResponse) VisitGetDevicePowersResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePowers405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetDevicePowers405JSONResponse) VisitGetDevicePowersResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePowers406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetDevicePowers406JSONResponse) VisitGetDevicePowersResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePowers409JSONResponse struct{ ConflictJSONResponse }

func (response GetDevicePowers409JSONResponse) VisitGetDevicePowersResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePowers429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetDevicePowers429JSONResponse) VisitGetDevicePowersResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePowers500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetDevicePowers500JSONResponse) VisitGetDevicePowersResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePowers503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetDevicePowers503JSONResponse) VisitGetDevicePowersResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePowers507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetDevicePowers507JSONResponse) VisitGetDevicePowersResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePowerRequestObject struct {
	DeviceId string `json:"deviceId"`
}

type GetDevicePowerResponseObject interface {
	VisitGetDevicePowerResponse(w http.ResponseWriter) error
}

type GetDevicePower200JSONResponse struct {
	Data   *[]DevicePowerGet `json:"data,omitempty"`
	Errors *[]Error          `json:"errors,omitempty"`
}

func (response GetDevicePower200JSONResponse) VisitGetDevicePowerResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePower401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetDevicePower401JSONResponse) VisitGetDevicePowerResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePower403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetDevicePower403JSONResponse) VisitGetDevicePowerResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePower404JSONResponse struct{ NotFoundJSONResponse }

func (response GetDevicePower404JSONResponse) VisitGetDevicePowerResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePower405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetDevicePower405JSONResponse) VisitGetDevicePowerResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePower406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetDevicePower406JSONResponse) VisitGetDevicePowerResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePower409JSONResponse struct{ ConflictJSONResponse }

func (response GetDevicePower409JSONResponse) VisitGetDevicePowerResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePower429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetDevicePower429JSONResponse) VisitGetDevicePowerResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePower500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetDevicePower500JSONResponse) VisitGetDevicePowerResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePower503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetDevicePower503JSONResponse) VisitGetDevicePowerResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetDevicePower507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetDevicePower507JSONResponse) VisitGetDevicePowerResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLightsRequestObject struct {
}

type GetGroupedLightsResponseObject interface {
	VisitGetGroupedLightsResponse(w http.ResponseWriter) error
}

type GetGroupedLights200JSONResponse struct {
	Data   *[]GroupedLightGet `json:"data,omitempty"`
	Errors *[]Error           `json:"errors,omitempty"`
}

func (response GetGroupedLights200JSONResponse) VisitGetGroupedLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLights401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetGroupedLights401JSONResponse) VisitGetGroupedLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLights403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetGroupedLights403JSONResponse) VisitGetGroupedLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLights404JSONResponse struct{ NotFoundJSONResponse }

func (response GetGroupedLights404JSONResponse) VisitGetGroupedLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLights405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetGroupedLights405JSONResponse) VisitGetGroupedLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLights406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetGroupedLights406JSONResponse) VisitGetGroupedLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLights409JSONResponse struct{ ConflictJSONResponse }

func (response GetGroupedLights409JSONResponse) VisitGetGroupedLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLights429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetGroupedLights429JSONResponse) VisitGetGroupedLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLights500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetGroupedLights500JSONResponse) VisitGetGroupedLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLights503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetGroupedLights503JSONResponse) VisitGetGroupedLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLights507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetGroupedLights507JSONResponse) VisitGetGroupedLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLightRequestObject struct {
	GroupedLightId string `json:"groupedLightId"`
}

type GetGroupedLightResponseObject interface {
	VisitGetGroupedLightResponse(w http.ResponseWriter) error
}

type GetGroupedLight200JSONResponse struct {
	Data   *[]GroupedLightGet `json:"data,omitempty"`
	Errors *[]Error           `json:"errors,omitempty"`
}

func (response GetGroupedLight200JSONResponse) VisitGetGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLight401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetGroupedLight401JSONResponse) VisitGetGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLight403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetGroupedLight403JSONResponse) VisitGetGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLight404JSONResponse struct{ NotFoundJSONResponse }

func (response GetGroupedLight404JSONResponse) VisitGetGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLight405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetGroupedLight405JSONResponse) VisitGetGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLight406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetGroupedLight406JSONResponse) VisitGetGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLight409JSONResponse struct{ ConflictJSONResponse }

func (response GetGroupedLight409JSONResponse) VisitGetGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLight429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetGroupedLight429JSONResponse) VisitGetGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLight500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetGroupedLight500JSONResponse) VisitGetGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLight503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetGroupedLight503JSONResponse) VisitGetGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetGroupedLight507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetGroupedLight507JSONResponse) VisitGetGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type UpdateGroupedLightRequestObject struct {
	GroupedLightId string `json:"groupedLightId"`
	Body           *UpdateGroupedLightJSONRequestBody
}

type UpdateGroupedLightResponseObject interface {
	VisitUpdateGroupedLightResponse(w http.ResponseWriter) error
}

type UpdateGroupedLight200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response UpdateGroupedLight200JSONResponse) VisitUpdateGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type UpdateGroupedLight401JSONResponse struct{ UnauthorizedJSONResponse }

func (response UpdateGroupedLight401JSONResponse) VisitUpdateGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type UpdateGroupedLight403JSONResponse struct{ ForbiddenJSONResponse }

func (response UpdateGroupedLight403JSONResponse) VisitUpdateGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type UpdateGroupedLight404JSONResponse struct{ NotFoundJSONResponse }

func (response UpdateGroupedLight404JSONResponse) VisitUpdateGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type UpdateGroupedLight405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response UpdateGroupedLight405JSONResponse) VisitUpdateGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type UpdateGroupedLight406JSONResponse struct{ NotAcceptableJSONResponse }

func (response UpdateGroupedLight406JSONResponse) VisitUpdateGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type UpdateGroupedLight409JSONResponse struct{ ConflictJSONResponse }

func (response UpdateGroupedLight409JSONResponse) VisitUpdateGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type UpdateGroupedLight429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response UpdateGroupedLight429JSONResponse) VisitUpdateGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type UpdateGroupedLight500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response UpdateGroupedLight500JSONResponse) VisitUpdateGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type UpdateGroupedLight503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response UpdateGroupedLight503JSONResponse) VisitUpdateGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type UpdateGroupedLight507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response UpdateGroupedLight507JSONResponse) VisitUpdateGroupedLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetLightsRequestObject struct {
}

type GetLightsResponseObject interface {
	VisitGetLightsResponse(w http.ResponseWriter) error
}

type GetLights200JSONResponse struct {
	Data   *[]LightGet `json:"data,omitempty"`
	Errors *[]Error    `json:"errors,omitempty"`
}

func (response GetLights200JSONResponse) VisitGetLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetLights401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetLights401JSONResponse) VisitGetLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetLights403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetLights403JSONResponse) VisitGetLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetLights404JSONResponse struct{ NotFoundJSONResponse }

func (response GetLights404JSONResponse) VisitGetLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetLights405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetLights405JSONResponse) VisitGetLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetLights406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetLights406JSONResponse) VisitGetLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetLights409JSONResponse struct{ ConflictJSONResponse }

func (response GetLights409JSONResponse) VisitGetLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetLights429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetLights429JSONResponse) VisitGetLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetLights500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetLights500JSONResponse) VisitGetLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetLights503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetLights503JSONResponse) VisitGetLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetLights507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetLights507JSONResponse) VisitGetLightsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetLightRequestObject struct {
	LightId string `json:"lightId"`
}

type GetLightResponseObject interface {
	VisitGetLightResponse(w http.ResponseWriter) error
}

type GetLight200JSONResponse struct {
	Data   *[]LightGet `json:"data,omitempty"`
	Errors *[]Error    `json:"errors,omitempty"`
}

func (response GetLight200JSONResponse) VisitGetLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetLight401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetLight401JSONResponse) VisitGetLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetLight403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetLight403JSONResponse) VisitGetLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetLight404JSONResponse struct{ NotFoundJSONResponse }

func (response GetLight404JSONResponse) VisitGetLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetLight405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetLight405JSONResponse) VisitGetLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetLight406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetLight406JSONResponse) VisitGetLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetLight409JSONResponse struct{ ConflictJSONResponse }

func (response GetLight409JSONResponse) VisitGetLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetLight429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetLight429JSONResponse) VisitGetLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetLight500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetLight500JSONResponse) VisitGetLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetLight503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetLight503JSONResponse) VisitGetLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetLight507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetLight507JSONResponse) VisitGetLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLightRequestObject struct {
	LightId string `json:"lightId"`
	Body    *UpdateLightJSONRequestBody
}

type UpdateLightResponseObject interface {
	VisitUpdateLightResponse(w http.ResponseWriter) error
}

type UpdateLight200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response UpdateLight200JSONResponse) VisitUpdateLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLight401JSONResponse struct{ UnauthorizedJSONResponse }

func (response UpdateLight401JSONResponse) VisitUpdateLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLight403JSONResponse struct{ ForbiddenJSONResponse }

func (response UpdateLight403JSONResponse) VisitUpdateLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLight404JSONResponse struct{ NotFoundJSONResponse }

func (response UpdateLight404JSONResponse) VisitUpdateLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLight405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response UpdateLight405JSONResponse) VisitUpdateLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLight406JSONResponse struct{ NotAcceptableJSONResponse }

func (response UpdateLight406JSONResponse) VisitUpdateLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLight409JSONResponse struct{ ConflictJSONResponse }

func (response UpdateLight409JSONResponse) VisitUpdateLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLight429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response UpdateLight429JSONResponse) VisitUpdateLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLight500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response UpdateLight500JSONResponse) VisitUpdateLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLight503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response UpdateLight503JSONResponse) VisitUpdateLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLight507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response UpdateLight507JSONResponse) VisitUpdateLightResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevelsRequestObject struct {
}

type GetLightLevelsResponseObject interface {
	VisitGetLightLevelsResponse(w http.ResponseWriter) error
}

type GetLightLevels200JSONResponse struct {
	Data   *[]LightLevelGet `json:"data,omitempty"`
	Errors *[]Error         `json:"errors,omitempty"`
}

func (response GetLightLevels200JSONResponse) VisitGetLightLevelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevels401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetLightLevels401JSONResponse) VisitGetLightLevelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevels403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetLightLevels403JSONResponse) VisitGetLightLevelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevels404JSONResponse struct{ NotFoundJSONResponse }

func (response GetLightLevels404JSONResponse) VisitGetLightLevelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevels405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetLightLevels405JSONResponse) VisitGetLightLevelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevels406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetLightLevels406JSONResponse) VisitGetLightLevelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevels409JSONResponse struct{ ConflictJSONResponse }

func (response GetLightLevels409JSONResponse) VisitGetLightLevelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevels429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetLightLevels429JSONResponse) VisitGetLightLevelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevels500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetLightLevels500JSONResponse) VisitGetLightLevelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevels503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetLightLevels503JSONResponse) VisitGetLightLevelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevels507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetLightLevels507JSONResponse) VisitGetLightLevelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevelRequestObject struct {
	LightId string `json:"lightId"`
}

type GetLightLevelResponseObject interface {
	VisitGetLightLevelResponse(w http.ResponseWriter) error
}

type GetLightLevel200JSONResponse struct {
	Data   *[]LightLevelGet `json:"data,omitempty"`
	Errors *[]Error         `json:"errors,omitempty"`
}

func (response GetLightLevel200JSONResponse) VisitGetLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevel401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetLightLevel401JSONResponse) VisitGetLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevel403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetLightLevel403JSONResponse) VisitGetLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevel404JSONResponse struct{ NotFoundJSONResponse }

func (response GetLightLevel404JSONResponse) VisitGetLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevel405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetLightLevel405JSONResponse) VisitGetLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevel406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetLightLevel406JSONResponse) VisitGetLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevel409JSONResponse struct{ ConflictJSONResponse }

func (response GetLightLevel409JSONResponse) VisitGetLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevel429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetLightLevel429JSONResponse) VisitGetLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevel500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetLightLevel500JSONResponse) VisitGetLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevel503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetLightLevel503JSONResponse) VisitGetLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetLightLevel507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetLightLevel507JSONResponse) VisitGetLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLightLevelRequestObject struct {
	LightId string `json:"lightId"`
	Body    *UpdateLightLevelJSONRequestBody
}

type UpdateLightLevelResponseObject interface {
	VisitUpdateLightLevelResponse(w http.ResponseWriter) error
}

type UpdateLightLevel200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response UpdateLightLevel200JSONResponse) VisitUpdateLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLightLevel401JSONResponse struct{ UnauthorizedJSONResponse }

func (response UpdateLightLevel401JSONResponse) VisitUpdateLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLightLevel403JSONResponse struct{ ForbiddenJSONResponse }

func (response UpdateLightLevel403JSONResponse) VisitUpdateLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLightLevel404JSONResponse struct{ NotFoundJSONResponse }

func (response UpdateLightLevel404JSONResponse) VisitUpdateLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLightLevel405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response UpdateLightLevel405JSONResponse) VisitUpdateLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLightLevel406JSONResponse struct{ NotAcceptableJSONResponse }

func (response UpdateLightLevel406JSONResponse) VisitUpdateLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLightLevel409JSONResponse struct{ ConflictJSONResponse }

func (response UpdateLightLevel409JSONResponse) VisitUpdateLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLightLevel429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response UpdateLightLevel429JSONResponse) VisitUpdateLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLightLevel500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response UpdateLightLevel500JSONResponse) VisitUpdateLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLightLevel503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response UpdateLightLevel503JSONResponse) VisitUpdateLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type UpdateLightLevel507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response UpdateLightLevel507JSONResponse) VisitUpdateLightLevelResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensorsRequestObject struct {
}

type GetMotionSensorsResponseObject interface {
	VisitGetMotionSensorsResponse(w http.ResponseWriter) error
}

type GetMotionSensors200JSONResponse struct {
	Data   *[]MotionGet `json:"data,omitempty"`
	Errors *[]Error     `json:"errors,omitempty"`
}

func (response GetMotionSensors200JSONResponse) VisitGetMotionSensorsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensors401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetMotionSensors401JSONResponse) VisitGetMotionSensorsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensors403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetMotionSensors403JSONResponse) VisitGetMotionSensorsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensors404JSONResponse struct{ NotFoundJSONResponse }

func (response GetMotionSensors404JSONResponse) VisitGetMotionSensorsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensors405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetMotionSensors405JSONResponse) VisitGetMotionSensorsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensors406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetMotionSensors406JSONResponse) VisitGetMotionSensorsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensors409JSONResponse struct{ ConflictJSONResponse }

func (response GetMotionSensors409JSONResponse) VisitGetMotionSensorsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensors429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetMotionSensors429JSONResponse) VisitGetMotionSensorsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensors500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetMotionSensors500JSONResponse) VisitGetMotionSensorsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensors503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetMotionSensors503JSONResponse) VisitGetMotionSensorsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensors507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetMotionSensors507JSONResponse) VisitGetMotionSensorsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensorRequestObject struct {
	MotionId string `json:"motionId"`
}

type GetMotionSensorResponseObject interface {
	VisitGetMotionSensorResponse(w http.ResponseWriter) error
}

type GetMotionSensor200JSONResponse struct {
	Data   *[]MotionGet `json:"data,omitempty"`
	Errors *[]Error     `json:"errors,omitempty"`
}

func (response GetMotionSensor200JSONResponse) VisitGetMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensor401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetMotionSensor401JSONResponse) VisitGetMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensor403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetMotionSensor403JSONResponse) VisitGetMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensor404JSONResponse struct{ NotFoundJSONResponse }

func (response GetMotionSensor404JSONResponse) VisitGetMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensor405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetMotionSensor405JSONResponse) VisitGetMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensor406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetMotionSensor406JSONResponse) VisitGetMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensor409JSONResponse struct{ ConflictJSONResponse }

func (response GetMotionSensor409JSONResponse) VisitGetMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensor429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetMotionSensor429JSONResponse) VisitGetMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensor500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetMotionSensor500JSONResponse) VisitGetMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensor503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetMotionSensor503JSONResponse) VisitGetMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetMotionSensor507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetMotionSensor507JSONResponse) VisitGetMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type UpdateMotionSensorRequestObject struct {
	MotionId string `json:"motionId"`
	Body     *UpdateMotionSensorJSONRequestBody
}

type UpdateMotionSensorResponseObject interface {
	VisitUpdateMotionSensorResponse(w http.ResponseWriter) error
}

type UpdateMotionSensor200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response UpdateMotionSensor200JSONResponse) VisitUpdateMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type UpdateMotionSensor401JSONResponse struct{ UnauthorizedJSONResponse }

func (response UpdateMotionSensor401JSONResponse) VisitUpdateMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type UpdateMotionSensor403JSONResponse struct{ ForbiddenJSONResponse }

func (response UpdateMotionSensor403JSONResponse) VisitUpdateMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type UpdateMotionSensor404JSONResponse struct{ NotFoundJSONResponse }

func (response UpdateMotionSensor404JSONResponse) VisitUpdateMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type UpdateMotionSensor405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response UpdateMotionSensor405JSONResponse) VisitUpdateMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type UpdateMotionSensor406JSONResponse struct{ NotAcceptableJSONResponse }

func (response UpdateMotionSensor406JSONResponse) VisitUpdateMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type UpdateMotionSensor409JSONResponse struct{ ConflictJSONResponse }

func (response UpdateMotionSensor409JSONResponse) VisitUpdateMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type UpdateMotionSensor429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response UpdateMotionSensor429JSONResponse) VisitUpdateMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type UpdateMotionSensor500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response UpdateMotionSensor500JSONResponse) VisitUpdateMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type UpdateMotionSensor503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response UpdateMotionSensor503JSONResponse) VisitUpdateMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type UpdateMotionSensor507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response UpdateMotionSensor507JSONResponse) VisitUpdateMotionSensorResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetRoomsRequestObject struct {
}

type GetRoomsResponseObject interface {
	VisitGetRoomsResponse(w http.ResponseWriter) error
}

type GetRooms200JSONResponse struct {
	Data   *[]RoomGet `json:"data,omitempty"`
	Errors *[]Error   `json:"errors,omitempty"`
}

func (response GetRooms200JSONResponse) VisitGetRoomsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetRooms401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetRooms401JSONResponse) VisitGetRoomsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetRooms403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetRooms403JSONResponse) VisitGetRoomsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetRooms404JSONResponse struct{ NotFoundJSONResponse }

func (response GetRooms404JSONResponse) VisitGetRoomsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetRooms405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetRooms405JSONResponse) VisitGetRoomsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetRooms406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetRooms406JSONResponse) VisitGetRoomsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetRooms409JSONResponse struct{ ConflictJSONResponse }

func (response GetRooms409JSONResponse) VisitGetRoomsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetRooms429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetRooms429JSONResponse) VisitGetRoomsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetRooms500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetRooms500JSONResponse) VisitGetRoomsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetRooms503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetRooms503JSONResponse) VisitGetRoomsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetRooms507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetRooms507JSONResponse) VisitGetRoomsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type CreateRoomRequestObject struct {
	Body *CreateRoomJSONRequestBody
}

type CreateRoomResponseObject interface {
	VisitCreateRoomResponse(w http.ResponseWriter) error
}

type CreateRoom200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response CreateRoom200JSONResponse) VisitCreateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type CreateRoom401JSONResponse struct{ UnauthorizedJSONResponse }

func (response CreateRoom401JSONResponse) VisitCreateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type CreateRoom403JSONResponse struct{ ForbiddenJSONResponse }

func (response CreateRoom403JSONResponse) VisitCreateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type CreateRoom404JSONResponse struct{ NotFoundJSONResponse }

func (response CreateRoom404JSONResponse) VisitCreateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type CreateRoom405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response CreateRoom405JSONResponse) VisitCreateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type CreateRoom406JSONResponse struct{ NotAcceptableJSONResponse }

func (response CreateRoom406JSONResponse) VisitCreateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type CreateRoom409JSONResponse struct{ ConflictJSONResponse }

func (response CreateRoom409JSONResponse) VisitCreateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type CreateRoom429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response CreateRoom429JSONResponse) VisitCreateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type CreateRoom500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response CreateRoom500JSONResponse) VisitCreateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type CreateRoom503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response CreateRoom503JSONResponse) VisitCreateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type CreateRoom507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response CreateRoom507JSONResponse) VisitCreateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type DeleteRoomRequestObject struct {
	RoomId string `json:"roomId"`
}

type DeleteRoomResponseObject interface {
	VisitDeleteRoomResponse(w http.ResponseWriter) error
}

type DeleteRoom200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response DeleteRoom200JSONResponse) VisitDeleteRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type DeleteRoom401JSONResponse struct{ UnauthorizedJSONResponse }

func (response DeleteRoom401JSONResponse) VisitDeleteRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type DeleteRoom403JSONResponse struct{ ForbiddenJSONResponse }

func (response DeleteRoom403JSONResponse) VisitDeleteRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type DeleteRoom404JSONResponse struct{ NotFoundJSONResponse }

func (response DeleteRoom404JSONResponse) VisitDeleteRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type DeleteRoom405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response DeleteRoom405JSONResponse) VisitDeleteRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type DeleteRoom406JSONResponse struct{ NotAcceptableJSONResponse }

func (response DeleteRoom406JSONResponse) VisitDeleteRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type DeleteRoom409JSONResponse struct{ ConflictJSONResponse }

func (response DeleteRoom409JSONResponse) VisitDeleteRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type DeleteRoom429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response DeleteRoom429JSONResponse) VisitDeleteRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type DeleteRoom500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response DeleteRoom500JSONResponse) VisitDeleteRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type DeleteRoom503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response DeleteRoom503JSONResponse) VisitDeleteRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type DeleteRoom507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response DeleteRoom507JSONResponse) VisitDeleteRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetRoomRequestObject struct {
	RoomId string `json:"roomId"`
}

type GetRoomResponseObject interface {
	VisitGetRoomResponse(w http.ResponseWriter) error
}

type GetRoom200JSONResponse struct {
	Data   *[]RoomGet `json:"data,omitempty"`
	Errors *[]Error   `json:"errors,omitempty"`
}

func (response GetRoom200JSONResponse) VisitGetRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetRoom401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetRoom401JSONResponse) VisitGetRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetRoom403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetRoom403JSONResponse) VisitGetRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetRoom404JSONResponse struct{ NotFoundJSONResponse }

func (response GetRoom404JSONResponse) VisitGetRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetRoom405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetRoom405JSONResponse) VisitGetRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetRoom406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetRoom406JSONResponse) VisitGetRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetRoom409JSONResponse struct{ ConflictJSONResponse }

func (response GetRoom409JSONResponse) VisitGetRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetRoom429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetRoom429JSONResponse) VisitGetRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetRoom500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetRoom500JSONResponse) VisitGetRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetRoom503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetRoom503JSONResponse) VisitGetRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetRoom507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetRoom507JSONResponse) VisitGetRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type UpdateRoomRequestObject struct {
	RoomId string `json:"roomId"`
	Body   *UpdateRoomJSONRequestBody
}

type UpdateRoomResponseObject interface {
	VisitUpdateRoomResponse(w http.ResponseWriter) error
}

type UpdateRoom200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response UpdateRoom200JSONResponse) VisitUpdateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type UpdateRoom401JSONResponse struct{ UnauthorizedJSONResponse }

func (response UpdateRoom401JSONResponse) VisitUpdateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type UpdateRoom403JSONResponse struct{ ForbiddenJSONResponse }

func (response UpdateRoom403JSONResponse) VisitUpdateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type UpdateRoom404JSONResponse struct{ NotFoundJSONResponse }

func (response UpdateRoom404JSONResponse) VisitUpdateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type UpdateRoom405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response UpdateRoom405JSONResponse) VisitUpdateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type UpdateRoom406JSONResponse struct{ NotAcceptableJSONResponse }

func (response UpdateRoom406JSONResponse) VisitUpdateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type UpdateRoom409JSONResponse struct{ ConflictJSONResponse }

func (response UpdateRoom409JSONResponse) VisitUpdateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type UpdateRoom429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response UpdateRoom429JSONResponse) VisitUpdateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type UpdateRoom500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response UpdateRoom500JSONResponse) VisitUpdateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type UpdateRoom503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response UpdateRoom503JSONResponse) VisitUpdateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type UpdateRoom507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response UpdateRoom507JSONResponse) VisitUpdateRoomResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetScenesRequestObject struct {
}

type GetScenesResponseObject interface {
	VisitGetScenesResponse(w http.ResponseWriter) error
}

type GetScenes200JSONResponse struct {
	Data   *[]SceneGet `json:"data,omitempty"`
	Errors *[]Error    `json:"errors,omitempty"`
}

func (response GetScenes200JSONResponse) VisitGetScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetScenes401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetScenes401JSONResponse) VisitGetScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetScenes403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetScenes403JSONResponse) VisitGetScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetScenes404JSONResponse struct{ NotFoundJSONResponse }

func (response GetScenes404JSONResponse) VisitGetScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetScenes405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetScenes405JSONResponse) VisitGetScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetScenes406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetScenes406JSONResponse) VisitGetScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetScenes409JSONResponse struct{ ConflictJSONResponse }

func (response GetScenes409JSONResponse) VisitGetScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetScenes429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetScenes429JSONResponse) VisitGetScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetScenes500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetScenes500JSONResponse) VisitGetScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetScenes503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetScenes503JSONResponse) VisitGetScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetScenes507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetScenes507JSONResponse) VisitGetScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type CreateSceneRequestObject struct {
	Body *CreateSceneJSONRequestBody
}

type CreateSceneResponseObject interface {
	VisitCreateSceneResponse(w http.ResponseWriter) error
}

type CreateScene200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response CreateScene200JSONResponse) VisitCreateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type CreateScene401JSONResponse struct{ UnauthorizedJSONResponse }

func (response CreateScene401JSONResponse) VisitCreateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type CreateScene403JSONResponse struct{ ForbiddenJSONResponse }

func (response CreateScene403JSONResponse) VisitCreateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type CreateScene404JSONResponse struct{ NotFoundJSONResponse }

func (response CreateScene404JSONResponse) VisitCreateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type CreateScene405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response CreateScene405JSONResponse) VisitCreateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type CreateScene406JSONResponse struct{ NotAcceptableJSONResponse }

func (response CreateScene406JSONResponse) VisitCreateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type CreateScene409JSONResponse struct{ ConflictJSONResponse }

func (response CreateScene409JSONResponse) VisitCreateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type CreateScene429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response CreateScene429JSONResponse) VisitCreateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type CreateScene500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response CreateScene500JSONResponse) VisitCreateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type CreateScene503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response CreateScene503JSONResponse) VisitCreateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type CreateScene507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response CreateScene507JSONResponse) VisitCreateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type DeleteSceneRequestObject struct {
	SceneId string `json:"sceneId"`
}

type DeleteSceneResponseObject interface {
	VisitDeleteSceneResponse(w http.ResponseWriter) error
}

type DeleteScene200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response DeleteScene200JSONResponse) VisitDeleteSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type DeleteScene401JSONResponse struct{ UnauthorizedJSONResponse }

func (response DeleteScene401JSONResponse) VisitDeleteSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type DeleteScene403JSONResponse struct{ ForbiddenJSONResponse }

func (response DeleteScene403JSONResponse) VisitDeleteSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type DeleteScene404JSONResponse struct{ NotFoundJSONResponse }

func (response DeleteScene404JSONResponse) VisitDeleteSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type DeleteScene405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response DeleteScene405JSONResponse) VisitDeleteSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type DeleteScene406JSONResponse struct{ NotAcceptableJSONResponse }

func (response DeleteScene406JSONResponse) VisitDeleteSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type DeleteScene409JSONResponse struct{ ConflictJSONResponse }

func (response DeleteScene409JSONResponse) VisitDeleteSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type DeleteScene429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response DeleteScene429JSONResponse) VisitDeleteSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type DeleteScene500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response DeleteScene500JSONResponse) VisitDeleteSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type DeleteScene503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response DeleteScene503JSONResponse) VisitDeleteSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type DeleteScene507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response DeleteScene507JSONResponse) VisitDeleteSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetSceneRequestObject struct {
	SceneId string `json:"sceneId"`
}

type GetSceneResponseObject interface {
	VisitGetSceneResponse(w http.ResponseWriter) error
}

type GetScene200JSONResponse struct {
	Data   *[]SceneGet `json:"data,omitempty"`
	Errors *[]Error    `json:"errors,omitempty"`
}

func (response GetScene200JSONResponse) VisitGetSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetScene401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetScene401JSONResponse) VisitGetSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetScene403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetScene403JSONResponse) VisitGetSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetScene404JSONResponse struct{ NotFoundJSONResponse }

func (response GetScene404JSONResponse) VisitGetSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetScene405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetScene405JSONResponse) VisitGetSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetScene406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetScene406JSONResponse) VisitGetSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetScene409JSONResponse struct{ ConflictJSONResponse }

func (response GetScene409JSONResponse) VisitGetSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetScene429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetScene429JSONResponse) VisitGetSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetScene500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetScene500JSONResponse) VisitGetSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetScene503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetScene503JSONResponse) VisitGetSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetScene507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetScene507JSONResponse) VisitGetSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type UpdateSceneRequestObject struct {
	SceneId string `json:"sceneId"`
	Body    *UpdateSceneJSONRequestBody
}

type UpdateSceneResponseObject interface {
	VisitUpdateSceneResponse(w http.ResponseWriter) error
}

type UpdateScene200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response UpdateScene200JSONResponse) VisitUpdateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type UpdateScene401JSONResponse struct{ UnauthorizedJSONResponse }

func (response UpdateScene401JSONResponse) VisitUpdateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type UpdateScene403JSONResponse struct{ ForbiddenJSONResponse }

func (response UpdateScene403JSONResponse) VisitUpdateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type UpdateScene404JSONResponse struct{ NotFoundJSONResponse }

func (response UpdateScene404JSONResponse) VisitUpdateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type UpdateScene405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response UpdateScene405JSONResponse) VisitUpdateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type UpdateScene406JSONResponse struct{ NotAcceptableJSONResponse }

func (response UpdateScene406JSONResponse) VisitUpdateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type UpdateScene409JSONResponse struct{ ConflictJSONResponse }

func (response UpdateScene409JSONResponse) VisitUpdateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type UpdateScene429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response UpdateScene429JSONResponse) VisitUpdateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type UpdateScene500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response UpdateScene500JSONResponse) VisitUpdateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type UpdateScene503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response UpdateScene503JSONResponse) VisitUpdateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type UpdateScene507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response UpdateScene507JSONResponse) VisitUpdateSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScenesRequestObject struct {
}

type GetSmartScenesResponseObject interface {
	VisitGetSmartScenesResponse(w http.ResponseWriter) error
}

type GetSmartScenes200JSONResponse struct {
	Data   *[]SmartSceneGet `json:"data,omitempty"`
	Errors *[]Error         `json:"errors,omitempty"`
}

func (response GetSmartScenes200JSONResponse) VisitGetSmartScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScenes401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetSmartScenes401JSONResponse) VisitGetSmartScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScenes403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetSmartScenes403JSONResponse) VisitGetSmartScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScenes404JSONResponse struct{ NotFoundJSONResponse }

func (response GetSmartScenes404JSONResponse) VisitGetSmartScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScenes405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetSmartScenes405JSONResponse) VisitGetSmartScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScenes406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetSmartScenes406JSONResponse) VisitGetSmartScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScenes409JSONResponse struct{ ConflictJSONResponse }

func (response GetSmartScenes409JSONResponse) VisitGetSmartScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScenes429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetSmartScenes429JSONResponse) VisitGetSmartScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScenes500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetSmartScenes500JSONResponse) VisitGetSmartScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScenes503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetSmartScenes503JSONResponse) VisitGetSmartScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScenes507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetSmartScenes507JSONResponse) VisitGetSmartScenesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type CreateSmartSceneRequestObject struct {
	Body *CreateSmartSceneJSONRequestBody
}

type CreateSmartSceneResponseObject interface {
	VisitCreateSmartSceneResponse(w http.ResponseWriter) error
}

type CreateSmartScene200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response CreateSmartScene200JSONResponse) VisitCreateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type CreateSmartScene401JSONResponse struct{ UnauthorizedJSONResponse }

func (response CreateSmartScene401JSONResponse) VisitCreateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type CreateSmartScene403JSONResponse struct{ ForbiddenJSONResponse }

func (response CreateSmartScene403JSONResponse) VisitCreateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type CreateSmartScene404JSONResponse struct{ NotFoundJSONResponse }

func (response CreateSmartScene404JSONResponse) VisitCreateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type CreateSmartScene405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response CreateSmartScene405JSONResponse) VisitCreateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type CreateSmartScene406JSONResponse struct{ NotAcceptableJSONResponse }

func (response CreateSmartScene406JSONResponse) VisitCreateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type CreateSmartScene409JSONResponse struct{ ConflictJSONResponse }

func (response CreateSmartScene409JSONResponse) VisitCreateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type CreateSmartScene429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response CreateSmartScene429JSONResponse) VisitCreateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type CreateSmartScene500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response CreateSmartScene500JSONResponse) VisitCreateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type CreateSmartScene503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response CreateSmartScene503JSONResponse) VisitCreateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type CreateSmartScene507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response CreateSmartScene507JSONResponse) VisitCreateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type DeleteSmartSceneRequestObject struct {
	SceneId string `json:"sceneId"`
}

type DeleteSmartSceneResponseObject interface {
	VisitDeleteSmartSceneResponse(w http.ResponseWriter) error
}

type DeleteSmartScene200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response DeleteSmartScene200JSONResponse) VisitDeleteSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type DeleteSmartScene401JSONResponse struct{ UnauthorizedJSONResponse }

func (response DeleteSmartScene401JSONResponse) VisitDeleteSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type DeleteSmartScene403JSONResponse struct{ ForbiddenJSONResponse }

func (response DeleteSmartScene403JSONResponse) VisitDeleteSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type DeleteSmartScene404JSONResponse struct{ NotFoundJSONResponse }

func (response DeleteSmartScene404JSONResponse) VisitDeleteSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type DeleteSmartScene405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response DeleteSmartScene405JSONResponse) VisitDeleteSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type DeleteSmartScene406JSONResponse struct{ NotAcceptableJSONResponse }

func (response DeleteSmartScene406JSONResponse) VisitDeleteSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type DeleteSmartScene409JSONResponse struct{ ConflictJSONResponse }

func (response DeleteSmartScene409JSONResponse) VisitDeleteSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type DeleteSmartScene429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response DeleteSmartScene429JSONResponse) VisitDeleteSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type DeleteSmartScene500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response DeleteSmartScene500JSONResponse) VisitDeleteSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type DeleteSmartScene503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response DeleteSmartScene503JSONResponse) VisitDeleteSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type DeleteSmartScene507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response DeleteSmartScene507JSONResponse) VisitDeleteSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartSceneRequestObject struct {
	SceneId string `json:"sceneId"`
}

type GetSmartSceneResponseObject interface {
	VisitGetSmartSceneResponse(w http.ResponseWriter) error
}

type GetSmartScene200JSONResponse struct {
	Data   *[]SmartSceneGet `json:"data,omitempty"`
	Errors *[]Error         `json:"errors,omitempty"`
}

func (response GetSmartScene200JSONResponse) VisitGetSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScene401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetSmartScene401JSONResponse) VisitGetSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScene403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetSmartScene403JSONResponse) VisitGetSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScene404JSONResponse struct{ NotFoundJSONResponse }

func (response GetSmartScene404JSONResponse) VisitGetSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScene405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetSmartScene405JSONResponse) VisitGetSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScene406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetSmartScene406JSONResponse) VisitGetSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScene409JSONResponse struct{ ConflictJSONResponse }

func (response GetSmartScene409JSONResponse) VisitGetSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScene429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetSmartScene429JSONResponse) VisitGetSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScene500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetSmartScene500JSONResponse) VisitGetSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScene503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetSmartScene503JSONResponse) VisitGetSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetSmartScene507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetSmartScene507JSONResponse) VisitGetSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type UpdateSmartSceneRequestObject struct {
	SceneId string `json:"sceneId"`
	Body    *UpdateSmartSceneJSONRequestBody
}

type UpdateSmartSceneResponseObject interface {
	VisitUpdateSmartSceneResponse(w http.ResponseWriter) error
}

type UpdateSmartScene200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response UpdateSmartScene200JSONResponse) VisitUpdateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type UpdateSmartScene401JSONResponse struct{ UnauthorizedJSONResponse }

func (response UpdateSmartScene401JSONResponse) VisitUpdateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type UpdateSmartScene403JSONResponse struct{ ForbiddenJSONResponse }

func (response UpdateSmartScene403JSONResponse) VisitUpdateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type UpdateSmartScene404JSONResponse struct{ NotFoundJSONResponse }

func (response UpdateSmartScene404JSONResponse) VisitUpdateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type UpdateSmartScene405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response UpdateSmartScene405JSONResponse) VisitUpdateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type UpdateSmartScene406JSONResponse struct{ NotAcceptableJSONResponse }

func (response UpdateSmartScene406JSONResponse) VisitUpdateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type UpdateSmartScene409JSONResponse struct{ ConflictJSONResponse }

func (response UpdateSmartScene409JSONResponse) VisitUpdateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type UpdateSmartScene429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response UpdateSmartScene429JSONResponse) VisitUpdateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type UpdateSmartScene500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response UpdateSmartScene500JSONResponse) VisitUpdateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type UpdateSmartScene503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response UpdateSmartScene503JSONResponse) VisitUpdateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type UpdateSmartScene507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response UpdateSmartScene507JSONResponse) VisitUpdateSmartSceneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperaturesRequestObject struct {
}

type GetTemperaturesResponseObject interface {
	VisitGetTemperaturesResponse(w http.ResponseWriter) error
}

type GetTemperatures200JSONResponse struct {
	Data   *[]TemperatureGet `json:"data,omitempty"`
	Errors *[]Error          `json:"errors,omitempty"`
}

func (response GetTemperatures200JSONResponse) VisitGetTemperaturesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperatures401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetTemperatures401JSONResponse) VisitGetTemperaturesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperatures403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetTemperatures403JSONResponse) VisitGetTemperaturesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperatures404JSONResponse struct{ NotFoundJSONResponse }

func (response GetTemperatures404JSONResponse) VisitGetTemperaturesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperatures405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetTemperatures405JSONResponse) VisitGetTemperaturesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperatures406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetTemperatures406JSONResponse) VisitGetTemperaturesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperatures409JSONResponse struct{ ConflictJSONResponse }

func (response GetTemperatures409JSONResponse) VisitGetTemperaturesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperatures429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetTemperatures429JSONResponse) VisitGetTemperaturesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperatures500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetTemperatures500JSONResponse) VisitGetTemperaturesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperatures503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetTemperatures503JSONResponse) VisitGetTemperaturesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperatures507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetTemperatures507JSONResponse) VisitGetTemperaturesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperatureRequestObject struct {
	TemperatureId string `json:"temperatureId"`
}

type GetTemperatureResponseObject interface {
	VisitGetTemperatureResponse(w http.ResponseWriter) error
}

type GetTemperature200JSONResponse struct {
	Data   *[]TemperatureGet `json:"data,omitempty"`
	Errors *[]Error          `json:"errors,omitempty"`
}

func (response GetTemperature200JSONResponse) VisitGetTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperature401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetTemperature401JSONResponse) VisitGetTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperature403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetTemperature403JSONResponse) VisitGetTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperature404JSONResponse struct{ NotFoundJSONResponse }

func (response GetTemperature404JSONResponse) VisitGetTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperature405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetTemperature405JSONResponse) VisitGetTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperature406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetTemperature406JSONResponse) VisitGetTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperature409JSONResponse struct{ ConflictJSONResponse }

func (response GetTemperature409JSONResponse) VisitGetTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperature429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetTemperature429JSONResponse) VisitGetTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperature500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetTemperature500JSONResponse) VisitGetTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperature503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetTemperature503JSONResponse) VisitGetTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetTemperature507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetTemperature507JSONResponse) VisitGetTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type UpdateTemperatureRequestObject struct {
	TemperatureId string `json:"temperatureId"`
	Body          *UpdateTemperatureJSONRequestBody
}

type UpdateTemperatureResponseObject interface {
	VisitUpdateTemperatureResponse(w http.ResponseWriter) error
}

type UpdateTemperature200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response UpdateTemperature200JSONResponse) VisitUpdateTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type UpdateTemperature401JSONResponse struct{ UnauthorizedJSONResponse }

func (response UpdateTemperature401JSONResponse) VisitUpdateTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type UpdateTemperature403JSONResponse struct{ ForbiddenJSONResponse }

func (response UpdateTemperature403JSONResponse) VisitUpdateTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type UpdateTemperature404JSONResponse struct{ NotFoundJSONResponse }

func (response UpdateTemperature404JSONResponse) VisitUpdateTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type UpdateTemperature405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response UpdateTemperature405JSONResponse) VisitUpdateTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type UpdateTemperature406JSONResponse struct{ NotAcceptableJSONResponse }

func (response UpdateTemperature406JSONResponse) VisitUpdateTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type UpdateTemperature409JSONResponse struct{ ConflictJSONResponse }

func (response UpdateTemperature409JSONResponse) VisitUpdateTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type UpdateTemperature429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response UpdateTemperature429JSONResponse) VisitUpdateTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type UpdateTemperature500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response UpdateTemperature500JSONResponse) VisitUpdateTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type UpdateTemperature503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response UpdateTemperature503JSONResponse) VisitUpdateTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type UpdateTemperature507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response UpdateTemperature507JSONResponse) VisitUpdateTemperatureResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetZonesRequestObject struct {
}

type GetZonesResponseObject interface {
	VisitGetZonesResponse(w http.ResponseWriter) error
}

type GetZones200JSONResponse struct {
	Data   *[]RoomGet `json:"data,omitempty"`
	Errors *[]Error   `json:"errors,omitempty"`
}

func (response GetZones200JSONResponse) VisitGetZonesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetZones401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetZones401JSONResponse) VisitGetZonesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetZones403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetZones403JSONResponse) VisitGetZonesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetZones404JSONResponse struct{ NotFoundJSONResponse }

func (response GetZones404JSONResponse) VisitGetZonesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetZones405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetZones405JSONResponse) VisitGetZonesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetZones406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetZones406JSONResponse) VisitGetZonesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetZones409JSONResponse struct{ ConflictJSONResponse }

func (response GetZones409JSONResponse) VisitGetZonesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetZones429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetZones429JSONResponse) VisitGetZonesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetZones500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetZones500JSONResponse) VisitGetZonesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetZones503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetZones503JSONResponse) VisitGetZonesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetZones507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetZones507JSONResponse) VisitGetZonesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type CreateZoneRequestObject struct {
	Body *CreateZoneJSONRequestBody
}

type CreateZoneResponseObject interface {
	VisitCreateZoneResponse(w http.ResponseWriter) error
}

type CreateZone200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response CreateZone200JSONResponse) VisitCreateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type CreateZone401JSONResponse struct{ UnauthorizedJSONResponse }

func (response CreateZone401JSONResponse) VisitCreateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type CreateZone403JSONResponse struct{ ForbiddenJSONResponse }

func (response CreateZone403JSONResponse) VisitCreateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type CreateZone404JSONResponse struct{ NotFoundJSONResponse }

func (response CreateZone404JSONResponse) VisitCreateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type CreateZone405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response CreateZone405JSONResponse) VisitCreateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type CreateZone406JSONResponse struct{ NotAcceptableJSONResponse }

func (response CreateZone406JSONResponse) VisitCreateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type CreateZone409JSONResponse struct{ ConflictJSONResponse }

func (response CreateZone409JSONResponse) VisitCreateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type CreateZone429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response CreateZone429JSONResponse) VisitCreateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type CreateZone500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response CreateZone500JSONResponse) VisitCreateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type CreateZone503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response CreateZone503JSONResponse) VisitCreateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type CreateZone507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response CreateZone507JSONResponse) VisitCreateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type DeleteZoneRequestObject struct {
	ZoneId string `json:"zoneId"`
}

type DeleteZoneResponseObject interface {
	VisitDeleteZoneResponse(w http.ResponseWriter) error
}

type DeleteZone200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response DeleteZone200JSONResponse) VisitDeleteZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type DeleteZone401JSONResponse struct{ UnauthorizedJSONResponse }

func (response DeleteZone401JSONResponse) VisitDeleteZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type DeleteZone403JSONResponse struct{ ForbiddenJSONResponse }

func (response DeleteZone403JSONResponse) VisitDeleteZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type DeleteZone404JSONResponse struct{ NotFoundJSONResponse }

func (response DeleteZone404JSONResponse) VisitDeleteZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type DeleteZone405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response DeleteZone405JSONResponse) VisitDeleteZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type DeleteZone406JSONResponse struct{ NotAcceptableJSONResponse }

func (response DeleteZone406JSONResponse) VisitDeleteZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type DeleteZone409JSONResponse struct{ ConflictJSONResponse }

func (response DeleteZone409JSONResponse) VisitDeleteZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type DeleteZone429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response DeleteZone429JSONResponse) VisitDeleteZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type DeleteZone500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response DeleteZone500JSONResponse) VisitDeleteZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type DeleteZone503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response DeleteZone503JSONResponse) VisitDeleteZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type DeleteZone507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response DeleteZone507JSONResponse) VisitDeleteZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type GetZoneRequestObject struct {
	ZoneId string `json:"zoneId"`
}

type GetZoneResponseObject interface {
	VisitGetZoneResponse(w http.ResponseWriter) error
}

type GetZone200JSONResponse struct {
	Data   *[]RoomGet `json:"data,omitempty"`
	Errors *[]Error   `json:"errors,omitempty"`
}

func (response GetZone200JSONResponse) VisitGetZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetZone401JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetZone401JSONResponse) VisitGetZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetZone403JSONResponse struct{ ForbiddenJSONResponse }

func (response GetZone403JSONResponse) VisitGetZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetZone404JSONResponse struct{ NotFoundJSONResponse }

func (response GetZone404JSONResponse) VisitGetZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetZone405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response GetZone405JSONResponse) VisitGetZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type GetZone406JSONResponse struct{ NotAcceptableJSONResponse }

func (response GetZone406JSONResponse) VisitGetZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type GetZone409JSONResponse struct{ ConflictJSONResponse }

func (response GetZone409JSONResponse) VisitGetZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type GetZone429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response GetZone429JSONResponse) VisitGetZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type GetZone500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetZone500JSONResponse) VisitGetZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetZone503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response GetZone503JSONResponse) VisitGetZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type GetZone507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response GetZone507JSONResponse) VisitGetZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

type UpdateZoneRequestObject struct {
	ZoneId string `json:"zoneId"`
	Body   *UpdateZoneJSONRequestBody
}

type UpdateZoneResponseObject interface {
	VisitUpdateZoneResponse(w http.ResponseWriter) error
}

type UpdateZone200JSONResponse struct {
	Data   *[]ResourceIdentifier `json:"data,omitempty"`
	Errors *[]Error              `json:"errors,omitempty"`
}

func (response UpdateZone200JSONResponse) VisitUpdateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type UpdateZone401JSONResponse struct{ UnauthorizedJSONResponse }

func (response UpdateZone401JSONResponse) VisitUpdateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type UpdateZone403JSONResponse struct{ ForbiddenJSONResponse }

func (response UpdateZone403JSONResponse) VisitUpdateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type UpdateZone404JSONResponse struct{ NotFoundJSONResponse }

func (response UpdateZone404JSONResponse) VisitUpdateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type UpdateZone405JSONResponse struct{ MethodNotAllowedJSONResponse }

func (response UpdateZone405JSONResponse) VisitUpdateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(405)

	return json.NewEncoder(w).Encode(response)
}

type UpdateZone406JSONResponse struct{ NotAcceptableJSONResponse }

func (response UpdateZone406JSONResponse) VisitUpdateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(406)

	return json.NewEncoder(w).Encode(response)
}

type UpdateZone409JSONResponse struct{ ConflictJSONResponse }

func (response UpdateZone409JSONResponse) VisitUpdateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(409)

	return json.NewEncoder(w).Encode(response)
}

type UpdateZone429JSONResponse struct{ TooManyRequestsJSONResponse }

func (response UpdateZone429JSONResponse) VisitUpdateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(429)

	return json.NewEncoder(w).Encode(response)
}

type UpdateZone500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response UpdateZone500JSONResponse) VisitUpdateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type UpdateZone503JSONResponse struct{ ServiceUnavailableJSONResponse }

func (response UpdateZone503JSONResponse) VisitUpdateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(503)

	return json.NewEncoder(w).Encode(response)
}

type UpdateZone507JSONResponse struct {
	InsufficientStorageJSONResponse
}

func (response UpdateZone507JSONResponse) VisitUpdateZoneResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(507)

	return json.NewEncoder(w).Encode(response)
}

// StrictServerInterface represents all server handlers.
type StrictServerInterface interface {
	// Authenticate
	// (POST /api)
	Authenticate(ctx context.Context, request AuthenticateRequestObject) (AuthenticateResponseObject, error)
	// List resources
	// (GET /clip/v2/resource)
	GetResources(ctx context.Context, request GetResourcesRequestObject) (GetResourcesResponseObject, error)
	// List bridges
	// (GET /clip/v2/resource/bridge)
	GetBridges(ctx context.Context, request GetBridgesRequestObject) (GetBridgesResponseObject, error)
	// Get bridge
	// (GET /clip/v2/resource/bridge/{bridgeId})
	GetBridge(ctx context.Context, request GetBridgeRequestObject) (GetBridgeResponseObject, error)
	// Update bridge
	// (PUT /clip/v2/resource/bridge/{bridgeId})
	UpdateBridge(ctx context.Context, request UpdateBridgeRequestObject) (UpdateBridgeResponseObject, error)
	// List bridge homes.
	// (GET /clip/v2/resource/bridge_home)
	GetBridgeHomes(ctx context.Context, request GetBridgeHomesRequestObject) (GetBridgeHomesResponseObject, error)
	// Get bridge home.
	// (GET /clip/v2/resource/bridge_home/{bridgeHomeId})
	GetBridgeHome(ctx context.Context, request GetBridgeHomeRequestObject) (GetBridgeHomeResponseObject, error)
	// List devices
	// (GET /clip/v2/resource/device)
	GetDevices(ctx context.Context, request GetDevicesRequestObject) (GetDevicesResponseObject, error)
	// Delete Device
	// (DELETE /clip/v2/resource/device/{deviceId})
	DeleteDevice(ctx context.Context, request DeleteDeviceRequestObject) (DeleteDeviceResponseObject, error)
	// Get device
	// (GET /clip/v2/resource/device/{deviceId})
	GetDevice(ctx context.Context, request GetDeviceRequestObject) (GetDeviceResponseObject, error)
	// Update device
	// (PUT /clip/v2/resource/device/{deviceId})
	UpdateDevice(ctx context.Context, request UpdateDeviceRequestObject) (UpdateDeviceResponseObject, error)
	// List device powers
	// (GET /clip/v2/resource/device_power)
	GetDevicePowers(ctx context.Context, request GetDevicePowersRequestObject) (GetDevicePowersResponseObject, error)
	// Get device power
	// (GET /clip/v2/resource/device_power/{deviceId})
	GetDevicePower(ctx context.Context, request GetDevicePowerRequestObject) (GetDevicePowerResponseObject, error)
	// List grouped lights
	// (GET /clip/v2/resource/grouped_light)
	GetGroupedLights(ctx context.Context, request GetGroupedLightsRequestObject) (GetGroupedLightsResponseObject, error)
	// Get grouped light
	// (GET /clip/v2/resource/grouped_light/{groupedLightId})
	GetGroupedLight(ctx context.Context, request GetGroupedLightRequestObject) (GetGroupedLightResponseObject, error)
	// Update grouped light
	// (PUT /clip/v2/resource/grouped_light/{groupedLightId})
	UpdateGroupedLight(ctx context.Context, request UpdateGroupedLightRequestObject) (UpdateGroupedLightResponseObject, error)
	// List lights.
	// (GET /clip/v2/resource/light)
	GetLights(ctx context.Context, request GetLightsRequestObject) (GetLightsResponseObject, error)
	// Get light
	// (GET /clip/v2/resource/light/{lightId})
	GetLight(ctx context.Context, request GetLightRequestObject) (GetLightResponseObject, error)
	// Update light
	// (PUT /clip/v2/resource/light/{lightId})
	UpdateLight(ctx context.Context, request UpdateLightRequestObject) (UpdateLightResponseObject, error)
	// List light levels.
	// (GET /clip/v2/resource/light_level)
	GetLightLevels(ctx context.Context, request GetLightLevelsRequestObject) (GetLightLevelsResponseObject, error)
	// Get light
	// (GET /clip/v2/resource/light_level/{lightId})
	GetLightLevel(ctx context.Context, request GetLightLevelRequestObject) (GetLightLevelResponseObject, error)
	// Update light
	// (PUT /clip/v2/resource/light_level/{lightId})
	UpdateLightLevel(ctx context.Context, request UpdateLightLevelRequestObject) (UpdateLightLevelResponseObject, error)
	// List motion sensors.
	// (GET /clip/v2/resource/motion)
	GetMotionSensors(ctx context.Context, request GetMotionSensorsRequestObject) (GetMotionSensorsResponseObject, error)
	// Get motion sensor.
	// (GET /clip/v2/resource/motion/{motionId})
	GetMotionSensor(ctx context.Context, request GetMotionSensorRequestObject) (GetMotionSensorResponseObject, error)
	// Update Motion Sensor
	// (PUT /clip/v2/resource/motion/{motionId})
	UpdateMotionSensor(ctx context.Context, request UpdateMotionSensorRequestObject) (UpdateMotionSensorResponseObject, error)
	// List rooms
	// (GET /clip/v2/resource/room)
	GetRooms(ctx context.Context, request GetRoomsRequestObject) (GetRoomsResponseObject, error)
	// Create room
	// (POST /clip/v2/resource/room)
	CreateRoom(ctx context.Context, request CreateRoomRequestObject) (CreateRoomResponseObject, error)
	// Delete room
	// (DELETE /clip/v2/resource/room/{roomId})
	DeleteRoom(ctx context.Context, request DeleteRoomRequestObject) (DeleteRoomResponseObject, error)
	// Get room.
	// (GET /clip/v2/resource/room/{roomId})
	GetRoom(ctx context.Context, request GetRoomRequestObject) (GetRoomResponseObject, error)
	// Update room
	// (PUT /clip/v2/resource/room/{roomId})
	UpdateRoom(ctx context.Context, request UpdateRoomRequestObject) (UpdateRoomResponseObject, error)
	// List scenes
	// (GET /clip/v2/resource/scene)
	GetScenes(ctx context.Context, request GetScenesRequestObject) (GetScenesResponseObject, error)
	// Create a new scene
	// (POST /clip/v2/resource/scene)
	CreateScene(ctx context.Context, request CreateSceneRequestObject) (CreateSceneResponseObject, error)
	// Delete a scene
	// (DELETE /clip/v2/resource/scene/{sceneId})
	DeleteScene(ctx context.Context, request DeleteSceneRequestObject) (DeleteSceneResponseObject, error)
	// Get a scene
	// (GET /clip/v2/resource/scene/{sceneId})
	GetScene(ctx context.Context, request GetSceneRequestObject) (GetSceneResponseObject, error)
	// Update a scene
	// (PUT /clip/v2/resource/scene/{sceneId})
	UpdateScene(ctx context.Context, request UpdateSceneRequestObject) (UpdateSceneResponseObject, error)
	// List smart scenes
	// (GET /clip/v2/resource/smart_scene)
	GetSmartScenes(ctx context.Context, request GetSmartScenesRequestObject) (GetSmartScenesResponseObject, error)
	// Create a new smart scene
	// (POST /clip/v2/resource/smart_scene)
	CreateSmartScene(ctx context.Context, request CreateSmartSceneRequestObject) (CreateSmartSceneResponseObject, error)
	// Delete a smart scene
	// (DELETE /clip/v2/resource/smart_scene/{sceneId})
	DeleteSmartScene(ctx context.Context, request DeleteSmartSceneRequestObject) (DeleteSmartSceneResponseObject, error)
	// Get a smart scene
	// (GET /clip/v2/resource/smart_scene/{sceneId})
	GetSmartScene(ctx context.Context, request GetSmartSceneRequestObject) (GetSmartSceneResponseObject, error)
	// Update a smart scene
	// (PUT /clip/v2/resource/smart_scene/{sceneId})
	UpdateSmartScene(ctx context.Context, request UpdateSmartSceneRequestObject) (UpdateSmartSceneResponseObject, error)
	// List temperatures
	// (GET /clip/v2/resource/temperature)
	GetTemperatures(ctx context.Context, request GetTemperaturesRequestObject) (GetTemperaturesResponseObject, error)
	// Get temperature sensor information
	// (GET /clip/v2/resource/temperature/{temperatureId})
	GetTemperature(ctx context.Context, request GetTemperatureRequestObject) (GetTemperatureResponseObject, error)
	// Update temperature sensor
	// (PUT /clip/v2/resource/temperature/{temperatureId})
	UpdateTemperature(ctx context.Context, request UpdateTemperatureRequestObject) (UpdateTemperatureResponseObject, error)
	// List zones
	// (GET /clip/v2/resource/zone)
	GetZones(ctx context.Context, request GetZonesRequestObject) (GetZonesResponseObject, error)
	// Create zone
	// (POST /clip/v2/resource/zone)
	CreateZone(ctx context.Context, request CreateZoneRequestObject) (CreateZoneResponseObject, error)
	// Delete Zone
	// (DELETE /clip/v2/resource/zone/{zoneId})
	DeleteZone(ctx context.Context, request DeleteZoneRequestObject) (DeleteZoneResponseObject, error)
	// Get Zone.
	// (GET /clip/v2/resource/zone/{zoneId})
	GetZone(ctx context.Context, request GetZoneRequestObject) (GetZoneResponseObject, error)
	// Update Zone
	// (PUT /clip/v2/resource/zone/{zoneId})
	UpdateZone(ctx context.Context, request UpdateZoneRequestObject) (UpdateZoneResponseObject, error)
}

type StrictHandlerFunc = strictnethttp.StrictHTTPHandlerFunc
type StrictMiddlewareFunc = strictnethttp.StrictHTTPMiddlewareFunc

type StrictHTTPServerOptions struct {
	RequestErrorHandlerFunc  func(w http.ResponseWriter, r *http.Request, err error)
	ResponseErrorHandlerFunc func(w http.ResponseWriter, r *http.Request, err error)
}

func NewStrictHandler(ssi StrictServerInterface, middlewares []StrictMiddlewareFunc) ServerInterface {
	return &strictHandler{ssi: ssi, middlewares: middlewares, options: StrictHTTPServerOptions{
		RequestErrorHandlerFunc: func(w http.ResponseWriter, r *http.Request, err error) {
			http.Error(w, err.Error(), http.StatusBadRequest)
		},
		ResponseErrorHandlerFunc: func(w http.ResponseWriter, r *http.Request, err error) {
			http.Error(w, err.Error(), http.StatusInternalServerError)
		},
	}}
}

func NewStrictHandlerWithOptions(ssi StrictServerInterface, middlewares []StrictMiddlewareFunc, options StrictHTTPServerOptions) ServerInterface {
	return &strictHandler{ssi: ssi, middlewares: middlewares, options: options}
}

type strictHandler struct {
	ssi         StrictServerInterface
	middlewares []StrictMiddlewareFunc
	options     StrictHTTPServerOptions
}

// Authenticate operation middleware
func (sh *strictHandler) Authenticate(w http.ResponseWriter, r *http.Request) {
	var request AuthenticateRequestObject

	var body AuthenticateJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.Authenticate(ctx, request.(AuthenticateRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "Authenticate")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(AuthenticateResponseObject); ok {
		if err := validResponse.VisitAuthenticateResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetResources operation middleware
func (sh *strictHandler) GetResources(w http.ResponseWriter, r *http.Request) {
	var request GetResourcesRequestObject

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetResources(ctx, request.(GetResourcesRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetResources")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetResourcesResponseObject); ok {
		if err := validResponse.VisitGetResourcesResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetBridges operation middleware
func (sh *strictHandler) GetBridges(w http.ResponseWriter, r *http.Request) {
	var request GetBridgesRequestObject

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetBridges(ctx, request.(GetBridgesRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetBridges")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetBridgesResponseObject); ok {
		if err := validResponse.VisitGetBridgesResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetBridge operation middleware
func (sh *strictHandler) GetBridge(w http.ResponseWriter, r *http.Request, bridgeId string) {
	var request GetBridgeRequestObject

	request.BridgeId = bridgeId

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetBridge(ctx, request.(GetBridgeRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetBridge")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetBridgeResponseObject); ok {
		if err := validResponse.VisitGetBridgeResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// UpdateBridge operation middleware
func (sh *strictHandler) UpdateBridge(w http.ResponseWriter, r *http.Request, bridgeId string) {
	var request UpdateBridgeRequestObject

	request.BridgeId = bridgeId

	var body UpdateBridgeJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.UpdateBridge(ctx, request.(UpdateBridgeRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "UpdateBridge")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(UpdateBridgeResponseObject); ok {
		if err := validResponse.VisitUpdateBridgeResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetBridgeHomes operation middleware
func (sh *strictHandler) GetBridgeHomes(w http.ResponseWriter, r *http.Request) {
	var request GetBridgeHomesRequestObject

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetBridgeHomes(ctx, request.(GetBridgeHomesRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetBridgeHomes")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetBridgeHomesResponseObject); ok {
		if err := validResponse.VisitGetBridgeHomesResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetBridgeHome operation middleware
func (sh *strictHandler) GetBridgeHome(w http.ResponseWriter, r *http.Request, bridgeHomeId string) {
	var request GetBridgeHomeRequestObject

	request.BridgeHomeId = bridgeHomeId

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetBridgeHome(ctx, request.(GetBridgeHomeRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetBridgeHome")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetBridgeHomeResponseObject); ok {
		if err := validResponse.VisitGetBridgeHomeResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetDevices operation middleware
func (sh *strictHandler) GetDevices(w http.ResponseWriter, r *http.Request) {
	var request GetDevicesRequestObject

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetDevices(ctx, request.(GetDevicesRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetDevices")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetDevicesResponseObject); ok {
		if err := validResponse.VisitGetDevicesResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// DeleteDevice operation middleware
func (sh *strictHandler) DeleteDevice(w http.ResponseWriter, r *http.Request, deviceId string) {
	var request DeleteDeviceRequestObject

	request.DeviceId = deviceId

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.DeleteDevice(ctx, request.(DeleteDeviceRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "DeleteDevice")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(DeleteDeviceResponseObject); ok {
		if err := validResponse.VisitDeleteDeviceResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetDevice operation middleware
func (sh *strictHandler) GetDevice(w http.ResponseWriter, r *http.Request, deviceId string) {
	var request GetDeviceRequestObject

	request.DeviceId = deviceId

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetDevice(ctx, request.(GetDeviceRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetDevice")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetDeviceResponseObject); ok {
		if err := validResponse.VisitGetDeviceResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// UpdateDevice operation middleware
func (sh *strictHandler) UpdateDevice(w http.ResponseWriter, r *http.Request, deviceId string) {
	var request UpdateDeviceRequestObject

	request.DeviceId = deviceId

	var body UpdateDeviceJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.UpdateDevice(ctx, request.(UpdateDeviceRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "UpdateDevice")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(UpdateDeviceResponseObject); ok {
		if err := validResponse.VisitUpdateDeviceResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetDevicePowers operation middleware
func (sh *strictHandler) GetDevicePowers(w http.ResponseWriter, r *http.Request) {
	var request GetDevicePowersRequestObject

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetDevicePowers(ctx, request.(GetDevicePowersRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetDevicePowers")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetDevicePowersResponseObject); ok {
		if err := validResponse.VisitGetDevicePowersResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetDevicePower operation middleware
func (sh *strictHandler) GetDevicePower(w http.ResponseWriter, r *http.Request, deviceId string) {
	var request GetDevicePowerRequestObject

	request.DeviceId = deviceId

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetDevicePower(ctx, request.(GetDevicePowerRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetDevicePower")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetDevicePowerResponseObject); ok {
		if err := validResponse.VisitGetDevicePowerResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetGroupedLights operation middleware
func (sh *strictHandler) GetGroupedLights(w http.ResponseWriter, r *http.Request) {
	var request GetGroupedLightsRequestObject

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetGroupedLights(ctx, request.(GetGroupedLightsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetGroupedLights")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetGroupedLightsResponseObject); ok {
		if err := validResponse.VisitGetGroupedLightsResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetGroupedLight operation middleware
func (sh *strictHandler) GetGroupedLight(w http.ResponseWriter, r *http.Request, groupedLightId string) {
	var request GetGroupedLightRequestObject

	request.GroupedLightId = groupedLightId

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetGroupedLight(ctx, request.(GetGroupedLightRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetGroupedLight")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetGroupedLightResponseObject); ok {
		if err := validResponse.VisitGetGroupedLightResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// UpdateGroupedLight operation middleware
func (sh *strictHandler) UpdateGroupedLight(w http.ResponseWriter, r *http.Request, groupedLightId string) {
	var request UpdateGroupedLightRequestObject

	request.GroupedLightId = groupedLightId

	var body UpdateGroupedLightJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.UpdateGroupedLight(ctx, request.(UpdateGroupedLightRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "UpdateGroupedLight")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(UpdateGroupedLightResponseObject); ok {
		if err := validResponse.VisitUpdateGroupedLightResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetLights operation middleware
func (sh *strictHandler) GetLights(w http.ResponseWriter, r *http.Request) {
	var request GetLightsRequestObject

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetLights(ctx, request.(GetLightsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetLights")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetLightsResponseObject); ok {
		if err := validResponse.VisitGetLightsResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetLight operation middleware
func (sh *strictHandler) GetLight(w http.ResponseWriter, r *http.Request, lightId string) {
	var request GetLightRequestObject

	request.LightId = lightId

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetLight(ctx, request.(GetLightRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetLight")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetLightResponseObject); ok {
		if err := validResponse.VisitGetLightResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// UpdateLight operation middleware
func (sh *strictHandler) UpdateLight(w http.ResponseWriter, r *http.Request, lightId string) {
	var request UpdateLightRequestObject

	request.LightId = lightId

	var body UpdateLightJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.UpdateLight(ctx, request.(UpdateLightRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "UpdateLight")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(UpdateLightResponseObject); ok {
		if err := validResponse.VisitUpdateLightResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetLightLevels operation middleware
func (sh *strictHandler) GetLightLevels(w http.ResponseWriter, r *http.Request) {
	var request GetLightLevelsRequestObject

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetLightLevels(ctx, request.(GetLightLevelsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetLightLevels")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetLightLevelsResponseObject); ok {
		if err := validResponse.VisitGetLightLevelsResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetLightLevel operation middleware
func (sh *strictHandler) GetLightLevel(w http.ResponseWriter, r *http.Request, lightId string) {
	var request GetLightLevelRequestObject

	request.LightId = lightId

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetLightLevel(ctx, request.(GetLightLevelRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetLightLevel")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetLightLevelResponseObject); ok {
		if err := validResponse.VisitGetLightLevelResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// UpdateLightLevel operation middleware
func (sh *strictHandler) UpdateLightLevel(w http.ResponseWriter, r *http.Request, lightId string) {
	var request UpdateLightLevelRequestObject

	request.LightId = lightId

	var body UpdateLightLevelJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.UpdateLightLevel(ctx, request.(UpdateLightLevelRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "UpdateLightLevel")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(UpdateLightLevelResponseObject); ok {
		if err := validResponse.VisitUpdateLightLevelResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetMotionSensors operation middleware
func (sh *strictHandler) GetMotionSensors(w http.ResponseWriter, r *http.Request) {
	var request GetMotionSensorsRequestObject

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetMotionSensors(ctx, request.(GetMotionSensorsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetMotionSensors")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetMotionSensorsResponseObject); ok {
		if err := validResponse.VisitGetMotionSensorsResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetMotionSensor operation middleware
func (sh *strictHandler) GetMotionSensor(w http.ResponseWriter, r *http.Request, motionId string) {
	var request GetMotionSensorRequestObject

	request.MotionId = motionId

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetMotionSensor(ctx, request.(GetMotionSensorRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetMotionSensor")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetMotionSensorResponseObject); ok {
		if err := validResponse.VisitGetMotionSensorResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// UpdateMotionSensor operation middleware
func (sh *strictHandler) UpdateMotionSensor(w http.ResponseWriter, r *http.Request, motionId string) {
	var request UpdateMotionSensorRequestObject

	request.MotionId = motionId

	var body UpdateMotionSensorJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.UpdateMotionSensor(ctx, request.(UpdateMotionSensorRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "UpdateMotionSensor")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(UpdateMotionSensorResponseObject); ok {
		if err := validResponse.VisitUpdateMotionSensorResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetRooms operation middleware
func (sh *strictHandler) GetRooms(w http.ResponseWriter, r *http.Request) {
	var request GetRoomsRequestObject

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetRooms(ctx, request.(GetRoomsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetRooms")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetRoomsResponseObject); ok {
		if err := validResponse.VisitGetRoomsResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// CreateRoom operation middleware
func (sh *strictHandler) CreateRoom(w http.ResponseWriter, r *http.Request) {
	var request CreateRoomRequestObject

	var body CreateRoomJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.CreateRoom(ctx, request.(CreateRoomRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "CreateRoom")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(CreateRoomResponseObject); ok {
		if err := validResponse.VisitCreateRoomResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// DeleteRoom operation middleware
func (sh *strictHandler) DeleteRoom(w http.ResponseWriter, r *http.Request, roomId string) {
	var request DeleteRoomRequestObject

	request.RoomId = roomId

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.DeleteRoom(ctx, request.(DeleteRoomRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "DeleteRoom")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(DeleteRoomResponseObject); ok {
		if err := validResponse.VisitDeleteRoomResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetRoom operation middleware
func (sh *strictHandler) GetRoom(w http.ResponseWriter, r *http.Request, roomId string) {
	var request GetRoomRequestObject

	request.RoomId = roomId

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetRoom(ctx, request.(GetRoomRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetRoom")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetRoomResponseObject); ok {
		if err := validResponse.VisitGetRoomResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// UpdateRoom operation middleware
func (sh *strictHandler) UpdateRoom(w http.ResponseWriter, r *http.Request, roomId string) {
	var request UpdateRoomRequestObject

	request.RoomId = roomId

	var body UpdateRoomJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.UpdateRoom(ctx, request.(UpdateRoomRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "UpdateRoom")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(UpdateRoomResponseObject); ok {
		if err := validResponse.VisitUpdateRoomResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetScenes operation middleware
func (sh *strictHandler) GetScenes(w http.ResponseWriter, r *http.Request) {
	var request GetScenesRequestObject

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetScenes(ctx, request.(GetScenesRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetScenes")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetScenesResponseObject); ok {
		if err := validResponse.VisitGetScenesResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// CreateScene operation middleware
func (sh *strictHandler) CreateScene(w http.ResponseWriter, r *http.Request) {
	var request CreateSceneRequestObject

	var body CreateSceneJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.CreateScene(ctx, request.(CreateSceneRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "CreateScene")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(CreateSceneResponseObject); ok {
		if err := validResponse.VisitCreateSceneResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// DeleteScene operation middleware
func (sh *strictHandler) DeleteScene(w http.ResponseWriter, r *http.Request, sceneId string) {
	var request DeleteSceneRequestObject

	request.SceneId = sceneId

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.DeleteScene(ctx, request.(DeleteSceneRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "DeleteScene")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(DeleteSceneResponseObject); ok {
		if err := validResponse.VisitDeleteSceneResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetScene operation middleware
func (sh *strictHandler) GetScene(w http.ResponseWriter, r *http.Request, sceneId string) {
	var request GetSceneRequestObject

	request.SceneId = sceneId

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetScene(ctx, request.(GetSceneRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetScene")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetSceneResponseObject); ok {
		if err := validResponse.VisitGetSceneResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// UpdateScene operation middleware
func (sh *strictHandler) UpdateScene(w http.ResponseWriter, r *http.Request, sceneId string) {
	var request UpdateSceneRequestObject

	request.SceneId = sceneId

	var body UpdateSceneJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.UpdateScene(ctx, request.(UpdateSceneRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "UpdateScene")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(UpdateSceneResponseObject); ok {
		if err := validResponse.VisitUpdateSceneResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetSmartScenes operation middleware
func (sh *strictHandler) GetSmartScenes(w http.ResponseWriter, r *http.Request) {
	var request GetSmartScenesRequestObject

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetSmartScenes(ctx, request.(GetSmartScenesRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetSmartScenes")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetSmartScenesResponseObject); ok {
		if err := validResponse.VisitGetSmartScenesResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// CreateSmartScene operation middleware
func (sh *strictHandler) CreateSmartScene(w http.ResponseWriter, r *http.Request) {
	var request CreateSmartSceneRequestObject

	var body CreateSmartSceneJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.CreateSmartScene(ctx, request.(CreateSmartSceneRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "CreateSmartScene")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(CreateSmartSceneResponseObject); ok {
		if err := validResponse.VisitCreateSmartSceneResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// DeleteSmartScene operation middleware
func (sh *strictHandler) DeleteSmartScene(w http.ResponseWriter, r *http.Request, sceneId string) {
	var request DeleteSmartSceneRequestObject

	request.SceneId = sceneId

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.DeleteSmartScene(ctx, request.(DeleteSmartSceneRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "DeleteSmartScene")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(DeleteSmartSceneResponseObject); ok {
		if err := validResponse.VisitDeleteSmartSceneResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetSmartScene operation middleware
func (sh *strictHandler) GetSmartScene(w http.ResponseWriter, r *http.Request, sceneId string) {
	var request GetSmartSceneRequestObject

	request.SceneId = sceneId

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetSmartScene(ctx, request.(GetSmartSceneRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetSmartScene")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetSmartSceneResponseObject); ok {
		if err := validResponse.VisitGetSmartSceneResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// UpdateSmartScene operation middleware
func (sh *strictHandler) UpdateSmartScene(w http.ResponseWriter, r *http.Request, sceneId string) {
	var request UpdateSmartSceneRequestObject

	request.SceneId = sceneId

	var body UpdateSmartSceneJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.UpdateSmartScene(ctx, request.(UpdateSmartSceneRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "UpdateSmartScene")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(UpdateSmartSceneResponseObject); ok {
		if err := validResponse.VisitUpdateSmartSceneResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetTemperatures operation middleware
func (sh *strictHandler) GetTemperatures(w http.ResponseWriter, r *http.Request) {
	var request GetTemperaturesRequestObject

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetTemperatures(ctx, request.(GetTemperaturesRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetTemperatures")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetTemperaturesResponseObject); ok {
		if err := validResponse.VisitGetTemperaturesResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetTemperature operation middleware
func (sh *strictHandler) GetTemperature(w http.ResponseWriter, r *http.Request, temperatureId string) {
	var request GetTemperatureRequestObject

	request.TemperatureId = temperatureId

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetTemperature(ctx, request.(GetTemperatureRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetTemperature")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetTemperatureResponseObject); ok {
		if err := validResponse.VisitGetTemperatureResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// UpdateTemperature operation middleware
func (sh *strictHandler) UpdateTemperature(w http.ResponseWriter, r *http.Request, temperatureId string) {
	var request UpdateTemperatureRequestObject

	request.TemperatureId = temperatureId

	var body UpdateTemperatureJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.UpdateTemperature(ctx, request.(UpdateTemperatureRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "UpdateTemperature")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(UpdateTemperatureResponseObject); ok {
		if err := validResponse.VisitUpdateTemperatureResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetZones operation middleware
func (sh *strictHandler) GetZones(w http.ResponseWriter, r *http.Request) {
	var request GetZonesRequestObject

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetZones(ctx, request.(GetZonesRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetZones")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetZonesResponseObject); ok {
		if err := validResponse.VisitGetZonesResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// CreateZone operation middleware
func (sh *strictHandler) CreateZone(w http.ResponseWriter, r *http.Request) {
	var request CreateZoneRequestObject

	var body CreateZoneJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.CreateZone(ctx, request.(CreateZoneRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "CreateZone")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(CreateZoneResponseObject); ok {
		if err := validResponse.VisitCreateZoneResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// DeleteZone operation middleware
func (sh *strictHandler) DeleteZone(w http.ResponseWriter, r *http.Request, zoneId string) {
	var request DeleteZoneRequestObject

	request.ZoneId = zoneId

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.DeleteZone(ctx, request.(DeleteZoneRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "DeleteZone")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(DeleteZoneResponseObject); ok {
		if err := validResponse.VisitDeleteZoneResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetZone operation middleware
func (sh *strictHandler) GetZone(w http.ResponseWriter, r *http.Request, zoneId string) {
	var request GetZoneRequestObject

	request.ZoneId = zoneId

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetZone(ctx, request.(GetZoneRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetZone")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetZoneResponseObject); ok {
		if err := validResponse.VisitGetZoneResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// UpdateZone operation middleware
func (sh *strictHandler) UpdateZone(w http.ResponseWriter, r *http.Request, zoneId string) {
	var request UpdateZoneRequestObject

	request.ZoneId = zoneId

	var body UpdateZoneJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.UpdateZone(ctx, request.(UpdateZoneRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "UpdateZone")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(UpdateZoneResponseObject); ok {
		if err := validResponse.VisitUpdateZoneResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}
