// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptCertificateTransfer = "AcceptCertificateTransfer"

// AcceptCertificateTransferRequest generates a "aws/request.Request" representing the
// client's request for the AcceptCertificateTransfer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptCertificateTransfer for more information on using the AcceptCertificateTransfer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptCertificateTransferRequest method.
//    req, resp := client.AcceptCertificateTransferRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) AcceptCertificateTransferRequest(input *AcceptCertificateTransferInput) (req *request.Request, output *AcceptCertificateTransferOutput) {
	op := &request.Operation{
		Name:       opAcceptCertificateTransfer,
		HTTPMethod: "PATCH",
		HTTPPath:   "/accept-certificate-transfer/{certificateId}",
	}

	if input == nil {
		input = &AcceptCertificateTransferInput{}
	}

	output = &AcceptCertificateTransferOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcceptCertificateTransfer API operation for AWS IoT.
//
// Accepts a pending certificate transfer. The default state of the certificate
// is INACTIVE.
//
// To check for pending certificate transfers, call ListCertificates to enumerate
// your certificates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation AcceptCertificateTransfer for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * TransferAlreadyCompletedException
//   You can't revert the certificate transfer because the transfer is already
//   complete.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) AcceptCertificateTransfer(input *AcceptCertificateTransferInput) (*AcceptCertificateTransferOutput, error) {
	req, out := c.AcceptCertificateTransferRequest(input)
	return out, req.Send()
}

// AcceptCertificateTransferWithContext is the same as AcceptCertificateTransfer with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptCertificateTransfer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) AcceptCertificateTransferWithContext(ctx aws.Context, input *AcceptCertificateTransferInput, opts ...request.Option) (*AcceptCertificateTransferOutput, error) {
	req, out := c.AcceptCertificateTransferRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddThingToBillingGroup = "AddThingToBillingGroup"

// AddThingToBillingGroupRequest generates a "aws/request.Request" representing the
// client's request for the AddThingToBillingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddThingToBillingGroup for more information on using the AddThingToBillingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddThingToBillingGroupRequest method.
//    req, resp := client.AddThingToBillingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) AddThingToBillingGroupRequest(input *AddThingToBillingGroupInput) (req *request.Request, output *AddThingToBillingGroupOutput) {
	op := &request.Operation{
		Name:       opAddThingToBillingGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/billing-groups/addThingToBillingGroup",
	}

	if input == nil {
		input = &AddThingToBillingGroupInput{}
	}

	output = &AddThingToBillingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddThingToBillingGroup API operation for AWS IoT.
//
// Adds a thing to a billing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation AddThingToBillingGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) AddThingToBillingGroup(input *AddThingToBillingGroupInput) (*AddThingToBillingGroupOutput, error) {
	req, out := c.AddThingToBillingGroupRequest(input)
	return out, req.Send()
}

// AddThingToBillingGroupWithContext is the same as AddThingToBillingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See AddThingToBillingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) AddThingToBillingGroupWithContext(ctx aws.Context, input *AddThingToBillingGroupInput, opts ...request.Option) (*AddThingToBillingGroupOutput, error) {
	req, out := c.AddThingToBillingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddThingToThingGroup = "AddThingToThingGroup"

// AddThingToThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the AddThingToThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddThingToThingGroup for more information on using the AddThingToThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddThingToThingGroupRequest method.
//    req, resp := client.AddThingToThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) AddThingToThingGroupRequest(input *AddThingToThingGroupInput) (req *request.Request, output *AddThingToThingGroupOutput) {
	op := &request.Operation{
		Name:       opAddThingToThingGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/thing-groups/addThingToThingGroup",
	}

	if input == nil {
		input = &AddThingToThingGroupInput{}
	}

	output = &AddThingToThingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddThingToThingGroup API operation for AWS IoT.
//
// Adds a thing to a thing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation AddThingToThingGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) AddThingToThingGroup(input *AddThingToThingGroupInput) (*AddThingToThingGroupOutput, error) {
	req, out := c.AddThingToThingGroupRequest(input)
	return out, req.Send()
}

// AddThingToThingGroupWithContext is the same as AddThingToThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See AddThingToThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) AddThingToThingGroupWithContext(ctx aws.Context, input *AddThingToThingGroupInput, opts ...request.Option) (*AddThingToThingGroupOutput, error) {
	req, out := c.AddThingToThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateTargetsWithJob = "AssociateTargetsWithJob"

// AssociateTargetsWithJobRequest generates a "aws/request.Request" representing the
// client's request for the AssociateTargetsWithJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateTargetsWithJob for more information on using the AssociateTargetsWithJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateTargetsWithJobRequest method.
//    req, resp := client.AssociateTargetsWithJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) AssociateTargetsWithJobRequest(input *AssociateTargetsWithJobInput) (req *request.Request, output *AssociateTargetsWithJobOutput) {
	op := &request.Operation{
		Name:       opAssociateTargetsWithJob,
		HTTPMethod: "POST",
		HTTPPath:   "/jobs/{jobId}/targets",
	}

	if input == nil {
		input = &AssociateTargetsWithJobInput{}
	}

	output = &AssociateTargetsWithJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateTargetsWithJob API operation for AWS IoT.
//
// Associates a group with a continuous job. The following criteria must be
// met:
//
//    * The job must have been created with the targetSelection field set to
//    "CONTINUOUS".
//
//    * The job status must currently be "IN_PROGRESS".
//
//    * The total number of targets associated with a job must not exceed 100.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation AssociateTargetsWithJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) AssociateTargetsWithJob(input *AssociateTargetsWithJobInput) (*AssociateTargetsWithJobOutput, error) {
	req, out := c.AssociateTargetsWithJobRequest(input)
	return out, req.Send()
}

// AssociateTargetsWithJobWithContext is the same as AssociateTargetsWithJob with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateTargetsWithJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) AssociateTargetsWithJobWithContext(ctx aws.Context, input *AssociateTargetsWithJobInput, opts ...request.Option) (*AssociateTargetsWithJobOutput, error) {
	req, out := c.AssociateTargetsWithJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachPolicy = "AttachPolicy"

// AttachPolicyRequest generates a "aws/request.Request" representing the
// client's request for the AttachPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachPolicy for more information on using the AttachPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachPolicyRequest method.
//    req, resp := client.AttachPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) AttachPolicyRequest(input *AttachPolicyInput) (req *request.Request, output *AttachPolicyOutput) {
	op := &request.Operation{
		Name:       opAttachPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/target-policies/{policyName}",
	}

	if input == nil {
		input = &AttachPolicyInput{}
	}

	output = &AttachPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachPolicy API operation for AWS IoT.
//
// Attaches a policy to the specified target.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation AttachPolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
func (c *IoT) AttachPolicy(input *AttachPolicyInput) (*AttachPolicyOutput, error) {
	req, out := c.AttachPolicyRequest(input)
	return out, req.Send()
}

// AttachPolicyWithContext is the same as AttachPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See AttachPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) AttachPolicyWithContext(ctx aws.Context, input *AttachPolicyInput, opts ...request.Option) (*AttachPolicyOutput, error) {
	req, out := c.AttachPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachPrincipalPolicy = "AttachPrincipalPolicy"

// AttachPrincipalPolicyRequest generates a "aws/request.Request" representing the
// client's request for the AttachPrincipalPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachPrincipalPolicy for more information on using the AttachPrincipalPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachPrincipalPolicyRequest method.
//    req, resp := client.AttachPrincipalPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Deprecated: AttachPrincipalPolicy has been deprecated
func (c *IoT) AttachPrincipalPolicyRequest(input *AttachPrincipalPolicyInput) (req *request.Request, output *AttachPrincipalPolicyOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, AttachPrincipalPolicy, has been deprecated")
	}
	op := &request.Operation{
		Name:       opAttachPrincipalPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/principal-policies/{policyName}",
	}

	if input == nil {
		input = &AttachPrincipalPolicyInput{}
	}

	output = &AttachPrincipalPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachPrincipalPolicy API operation for AWS IoT.
//
// Attaches the specified policy to the specified principal (certificate or
// other credential).
//
// Note: This API is deprecated. Please use AttachPolicy instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation AttachPrincipalPolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
//
// Deprecated: AttachPrincipalPolicy has been deprecated
func (c *IoT) AttachPrincipalPolicy(input *AttachPrincipalPolicyInput) (*AttachPrincipalPolicyOutput, error) {
	req, out := c.AttachPrincipalPolicyRequest(input)
	return out, req.Send()
}

// AttachPrincipalPolicyWithContext is the same as AttachPrincipalPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See AttachPrincipalPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: AttachPrincipalPolicyWithContext has been deprecated
func (c *IoT) AttachPrincipalPolicyWithContext(ctx aws.Context, input *AttachPrincipalPolicyInput, opts ...request.Option) (*AttachPrincipalPolicyOutput, error) {
	req, out := c.AttachPrincipalPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachSecurityProfile = "AttachSecurityProfile"

// AttachSecurityProfileRequest generates a "aws/request.Request" representing the
// client's request for the AttachSecurityProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachSecurityProfile for more information on using the AttachSecurityProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachSecurityProfileRequest method.
//    req, resp := client.AttachSecurityProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) AttachSecurityProfileRequest(input *AttachSecurityProfileInput) (req *request.Request, output *AttachSecurityProfileOutput) {
	op := &request.Operation{
		Name:       opAttachSecurityProfile,
		HTTPMethod: "PUT",
		HTTPPath:   "/security-profiles/{securityProfileName}/targets",
	}

	if input == nil {
		input = &AttachSecurityProfileInput{}
	}

	output = &AttachSecurityProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachSecurityProfile API operation for AWS IoT.
//
// Associates a Device Defender security profile with a thing group or this
// account. Each thing group or account can have up to five security profiles
// associated with it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation AttachSecurityProfile for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
//   * VersionConflictException
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) AttachSecurityProfile(input *AttachSecurityProfileInput) (*AttachSecurityProfileOutput, error) {
	req, out := c.AttachSecurityProfileRequest(input)
	return out, req.Send()
}

// AttachSecurityProfileWithContext is the same as AttachSecurityProfile with the addition of
// the ability to pass a context and additional request options.
//
// See AttachSecurityProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) AttachSecurityProfileWithContext(ctx aws.Context, input *AttachSecurityProfileInput, opts ...request.Option) (*AttachSecurityProfileOutput, error) {
	req, out := c.AttachSecurityProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachThingPrincipal = "AttachThingPrincipal"

// AttachThingPrincipalRequest generates a "aws/request.Request" representing the
// client's request for the AttachThingPrincipal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachThingPrincipal for more information on using the AttachThingPrincipal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachThingPrincipalRequest method.
//    req, resp := client.AttachThingPrincipalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) AttachThingPrincipalRequest(input *AttachThingPrincipalInput) (req *request.Request, output *AttachThingPrincipalOutput) {
	op := &request.Operation{
		Name:       opAttachThingPrincipal,
		HTTPMethod: "PUT",
		HTTPPath:   "/things/{thingName}/principals",
	}

	if input == nil {
		input = &AttachThingPrincipalInput{}
	}

	output = &AttachThingPrincipalOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachThingPrincipal API operation for AWS IoT.
//
// Attaches the specified principal to the specified thing. A principal can
// be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities
// or federated identities.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation AttachThingPrincipal for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) AttachThingPrincipal(input *AttachThingPrincipalInput) (*AttachThingPrincipalOutput, error) {
	req, out := c.AttachThingPrincipalRequest(input)
	return out, req.Send()
}

// AttachThingPrincipalWithContext is the same as AttachThingPrincipal with the addition of
// the ability to pass a context and additional request options.
//
// See AttachThingPrincipal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) AttachThingPrincipalWithContext(ctx aws.Context, input *AttachThingPrincipalInput, opts ...request.Option) (*AttachThingPrincipalOutput, error) {
	req, out := c.AttachThingPrincipalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelAuditMitigationActionsTask = "CancelAuditMitigationActionsTask"

// CancelAuditMitigationActionsTaskRequest generates a "aws/request.Request" representing the
// client's request for the CancelAuditMitigationActionsTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelAuditMitigationActionsTask for more information on using the CancelAuditMitigationActionsTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelAuditMitigationActionsTaskRequest method.
//    req, resp := client.CancelAuditMitigationActionsTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CancelAuditMitigationActionsTaskRequest(input *CancelAuditMitigationActionsTaskInput) (req *request.Request, output *CancelAuditMitigationActionsTaskOutput) {
	op := &request.Operation{
		Name:       opCancelAuditMitigationActionsTask,
		HTTPMethod: "PUT",
		HTTPPath:   "/audit/mitigationactions/tasks/{taskId}/cancel",
	}

	if input == nil {
		input = &CancelAuditMitigationActionsTaskInput{}
	}

	output = &CancelAuditMitigationActionsTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelAuditMitigationActionsTask API operation for AWS IoT.
//
// Cancels a mitigation action task that is in progress. If the task is not
// in progress, an InvalidRequestException occurs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CancelAuditMitigationActionsTask for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) CancelAuditMitigationActionsTask(input *CancelAuditMitigationActionsTaskInput) (*CancelAuditMitigationActionsTaskOutput, error) {
	req, out := c.CancelAuditMitigationActionsTaskRequest(input)
	return out, req.Send()
}

// CancelAuditMitigationActionsTaskWithContext is the same as CancelAuditMitigationActionsTask with the addition of
// the ability to pass a context and additional request options.
//
// See CancelAuditMitigationActionsTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CancelAuditMitigationActionsTaskWithContext(ctx aws.Context, input *CancelAuditMitigationActionsTaskInput, opts ...request.Option) (*CancelAuditMitigationActionsTaskOutput, error) {
	req, out := c.CancelAuditMitigationActionsTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelAuditTask = "CancelAuditTask"

// CancelAuditTaskRequest generates a "aws/request.Request" representing the
// client's request for the CancelAuditTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelAuditTask for more information on using the CancelAuditTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelAuditTaskRequest method.
//    req, resp := client.CancelAuditTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CancelAuditTaskRequest(input *CancelAuditTaskInput) (req *request.Request, output *CancelAuditTaskOutput) {
	op := &request.Operation{
		Name:       opCancelAuditTask,
		HTTPMethod: "PUT",
		HTTPPath:   "/audit/tasks/{taskId}/cancel",
	}

	if input == nil {
		input = &CancelAuditTaskInput{}
	}

	output = &CancelAuditTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelAuditTask API operation for AWS IoT.
//
// Cancels an audit that is in progress. The audit can be either scheduled or
// on-demand. If the audit is not in progress, an "InvalidRequestException"
// occurs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CancelAuditTask for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) CancelAuditTask(input *CancelAuditTaskInput) (*CancelAuditTaskOutput, error) {
	req, out := c.CancelAuditTaskRequest(input)
	return out, req.Send()
}

// CancelAuditTaskWithContext is the same as CancelAuditTask with the addition of
// the ability to pass a context and additional request options.
//
// See CancelAuditTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CancelAuditTaskWithContext(ctx aws.Context, input *CancelAuditTaskInput, opts ...request.Option) (*CancelAuditTaskOutput, error) {
	req, out := c.CancelAuditTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelCertificateTransfer = "CancelCertificateTransfer"

// CancelCertificateTransferRequest generates a "aws/request.Request" representing the
// client's request for the CancelCertificateTransfer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelCertificateTransfer for more information on using the CancelCertificateTransfer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelCertificateTransferRequest method.
//    req, resp := client.CancelCertificateTransferRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CancelCertificateTransferRequest(input *CancelCertificateTransferInput) (req *request.Request, output *CancelCertificateTransferOutput) {
	op := &request.Operation{
		Name:       opCancelCertificateTransfer,
		HTTPMethod: "PATCH",
		HTTPPath:   "/cancel-certificate-transfer/{certificateId}",
	}

	if input == nil {
		input = &CancelCertificateTransferInput{}
	}

	output = &CancelCertificateTransferOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelCertificateTransfer API operation for AWS IoT.
//
// Cancels a pending transfer for the specified certificate.
//
// Note Only the transfer source account can use this operation to cancel a
// transfer. (Transfer destinations can use RejectCertificateTransfer instead.)
// After transfer, AWS IoT returns the certificate to the source account in
// the INACTIVE state. After the destination account has accepted the transfer,
// the transfer cannot be cancelled.
//
// After a certificate transfer is cancelled, the status of the certificate
// changes from PENDING_TRANSFER to INACTIVE.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CancelCertificateTransfer for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * TransferAlreadyCompletedException
//   You can't revert the certificate transfer because the transfer is already
//   complete.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) CancelCertificateTransfer(input *CancelCertificateTransferInput) (*CancelCertificateTransferOutput, error) {
	req, out := c.CancelCertificateTransferRequest(input)
	return out, req.Send()
}

// CancelCertificateTransferWithContext is the same as CancelCertificateTransfer with the addition of
// the ability to pass a context and additional request options.
//
// See CancelCertificateTransfer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CancelCertificateTransferWithContext(ctx aws.Context, input *CancelCertificateTransferInput, opts ...request.Option) (*CancelCertificateTransferOutput, error) {
	req, out := c.CancelCertificateTransferRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelJob = "CancelJob"

// CancelJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelJob for more information on using the CancelJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelJobRequest method.
//    req, resp := client.CancelJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CancelJobRequest(input *CancelJobInput) (req *request.Request, output *CancelJobOutput) {
	op := &request.Operation{
		Name:       opCancelJob,
		HTTPMethod: "PUT",
		HTTPPath:   "/jobs/{jobId}/cancel",
	}

	if input == nil {
		input = &CancelJobInput{}
	}

	output = &CancelJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelJob API operation for AWS IoT.
//
// Cancels a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CancelJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) CancelJob(input *CancelJobInput) (*CancelJobOutput, error) {
	req, out := c.CancelJobRequest(input)
	return out, req.Send()
}

// CancelJobWithContext is the same as CancelJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CancelJobWithContext(ctx aws.Context, input *CancelJobInput, opts ...request.Option) (*CancelJobOutput, error) {
	req, out := c.CancelJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelJobExecution = "CancelJobExecution"

// CancelJobExecutionRequest generates a "aws/request.Request" representing the
// client's request for the CancelJobExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelJobExecution for more information on using the CancelJobExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelJobExecutionRequest method.
//    req, resp := client.CancelJobExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CancelJobExecutionRequest(input *CancelJobExecutionInput) (req *request.Request, output *CancelJobExecutionOutput) {
	op := &request.Operation{
		Name:       opCancelJobExecution,
		HTTPMethod: "PUT",
		HTTPPath:   "/things/{thingName}/jobs/{jobId}/cancel",
	}

	if input == nil {
		input = &CancelJobExecutionInput{}
	}

	output = &CancelJobExecutionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelJobExecution API operation for AWS IoT.
//
// Cancels the execution of a job for a given thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CancelJobExecution for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidStateTransitionException
//   An attempt was made to change to an invalid state, for example by deleting
//   a job or a job execution which is "IN_PROGRESS" without setting the force
//   parameter.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * VersionConflictException
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
func (c *IoT) CancelJobExecution(input *CancelJobExecutionInput) (*CancelJobExecutionOutput, error) {
	req, out := c.CancelJobExecutionRequest(input)
	return out, req.Send()
}

// CancelJobExecutionWithContext is the same as CancelJobExecution with the addition of
// the ability to pass a context and additional request options.
//
// See CancelJobExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CancelJobExecutionWithContext(ctx aws.Context, input *CancelJobExecutionInput, opts ...request.Option) (*CancelJobExecutionOutput, error) {
	req, out := c.CancelJobExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opClearDefaultAuthorizer = "ClearDefaultAuthorizer"

// ClearDefaultAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the ClearDefaultAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ClearDefaultAuthorizer for more information on using the ClearDefaultAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ClearDefaultAuthorizerRequest method.
//    req, resp := client.ClearDefaultAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ClearDefaultAuthorizerRequest(input *ClearDefaultAuthorizerInput) (req *request.Request, output *ClearDefaultAuthorizerOutput) {
	op := &request.Operation{
		Name:       opClearDefaultAuthorizer,
		HTTPMethod: "DELETE",
		HTTPPath:   "/default-authorizer",
	}

	if input == nil {
		input = &ClearDefaultAuthorizerInput{}
	}

	output = &ClearDefaultAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ClearDefaultAuthorizer API operation for AWS IoT.
//
// Clears the default authorizer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ClearDefaultAuthorizer for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ClearDefaultAuthorizer(input *ClearDefaultAuthorizerInput) (*ClearDefaultAuthorizerOutput, error) {
	req, out := c.ClearDefaultAuthorizerRequest(input)
	return out, req.Send()
}

// ClearDefaultAuthorizerWithContext is the same as ClearDefaultAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See ClearDefaultAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ClearDefaultAuthorizerWithContext(ctx aws.Context, input *ClearDefaultAuthorizerInput, opts ...request.Option) (*ClearDefaultAuthorizerOutput, error) {
	req, out := c.ClearDefaultAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConfirmTopicRuleDestination = "ConfirmTopicRuleDestination"

// ConfirmTopicRuleDestinationRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmTopicRuleDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfirmTopicRuleDestination for more information on using the ConfirmTopicRuleDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ConfirmTopicRuleDestinationRequest method.
//    req, resp := client.ConfirmTopicRuleDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ConfirmTopicRuleDestinationRequest(input *ConfirmTopicRuleDestinationInput) (req *request.Request, output *ConfirmTopicRuleDestinationOutput) {
	op := &request.Operation{
		Name:       opConfirmTopicRuleDestination,
		HTTPMethod: "GET",
		HTTPPath:   "/confirmdestination/{confirmationToken+}",
	}

	if input == nil {
		input = &ConfirmTopicRuleDestinationInput{}
	}

	output = &ConfirmTopicRuleDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ConfirmTopicRuleDestination API operation for AWS IoT.
//
// Confirms a topic rule destination. When you create a rule requiring a destination,
// AWS IoT sends a confirmation message to the endpoint or base address you
// specify. The message includes a token which you pass back when calling ConfirmTopicRuleDestination
// to confirm that you own or have access to the endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ConfirmTopicRuleDestination for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ConflictingResourceUpdateException
//   A conflicting resource update exception. This exception is thrown when two
//   pending updates cause a conflict.
//
func (c *IoT) ConfirmTopicRuleDestination(input *ConfirmTopicRuleDestinationInput) (*ConfirmTopicRuleDestinationOutput, error) {
	req, out := c.ConfirmTopicRuleDestinationRequest(input)
	return out, req.Send()
}

// ConfirmTopicRuleDestinationWithContext is the same as ConfirmTopicRuleDestination with the addition of
// the ability to pass a context and additional request options.
//
// See ConfirmTopicRuleDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ConfirmTopicRuleDestinationWithContext(ctx aws.Context, input *ConfirmTopicRuleDestinationInput, opts ...request.Option) (*ConfirmTopicRuleDestinationOutput, error) {
	req, out := c.ConfirmTopicRuleDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAuthorizer = "CreateAuthorizer"

// CreateAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the CreateAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAuthorizer for more information on using the CreateAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAuthorizerRequest method.
//    req, resp := client.CreateAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateAuthorizerRequest(input *CreateAuthorizerInput) (req *request.Request, output *CreateAuthorizerOutput) {
	op := &request.Operation{
		Name:       opCreateAuthorizer,
		HTTPMethod: "POST",
		HTTPPath:   "/authorizer/{authorizerName}",
	}

	if input == nil {
		input = &CreateAuthorizerInput{}
	}

	output = &CreateAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAuthorizer API operation for AWS IoT.
//
// Creates an authorizer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateAuthorizer for usage and error information.
//
// Returned Error Types:
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) CreateAuthorizer(input *CreateAuthorizerInput) (*CreateAuthorizerOutput, error) {
	req, out := c.CreateAuthorizerRequest(input)
	return out, req.Send()
}

// CreateAuthorizerWithContext is the same as CreateAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateAuthorizerWithContext(ctx aws.Context, input *CreateAuthorizerInput, opts ...request.Option) (*CreateAuthorizerOutput, error) {
	req, out := c.CreateAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBillingGroup = "CreateBillingGroup"

// CreateBillingGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateBillingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBillingGroup for more information on using the CreateBillingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBillingGroupRequest method.
//    req, resp := client.CreateBillingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateBillingGroupRequest(input *CreateBillingGroupInput) (req *request.Request, output *CreateBillingGroupOutput) {
	op := &request.Operation{
		Name:       opCreateBillingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/billing-groups/{billingGroupName}",
	}

	if input == nil {
		input = &CreateBillingGroupInput{}
	}

	output = &CreateBillingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBillingGroup API operation for AWS IoT.
//
// Creates a billing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateBillingGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) CreateBillingGroup(input *CreateBillingGroupInput) (*CreateBillingGroupOutput, error) {
	req, out := c.CreateBillingGroupRequest(input)
	return out, req.Send()
}

// CreateBillingGroupWithContext is the same as CreateBillingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBillingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateBillingGroupWithContext(ctx aws.Context, input *CreateBillingGroupInput, opts ...request.Option) (*CreateBillingGroupOutput, error) {
	req, out := c.CreateBillingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCertificateFromCsr = "CreateCertificateFromCsr"

// CreateCertificateFromCsrRequest generates a "aws/request.Request" representing the
// client's request for the CreateCertificateFromCsr operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCertificateFromCsr for more information on using the CreateCertificateFromCsr
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCertificateFromCsrRequest method.
//    req, resp := client.CreateCertificateFromCsrRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateCertificateFromCsrRequest(input *CreateCertificateFromCsrInput) (req *request.Request, output *CreateCertificateFromCsrOutput) {
	op := &request.Operation{
		Name:       opCreateCertificateFromCsr,
		HTTPMethod: "POST",
		HTTPPath:   "/certificates",
	}

	if input == nil {
		input = &CreateCertificateFromCsrInput{}
	}

	output = &CreateCertificateFromCsrOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCertificateFromCsr API operation for AWS IoT.
//
// Creates an X.509 certificate using the specified certificate signing request.
//
// Note: The CSR must include a public key that is either an RSA key with a
// length of at least 2048 bits or an ECC key from NIST P-256 or NIST P-384
// curves.
//
// Note: Reusing the same certificate signing request (CSR) results in a distinct
// certificate.
//
// You can create multiple certificates in a batch by creating a directory,
// copying multiple .csr files into that directory, and then specifying that
// directory on the command line. The following commands show how to create
// a batch of certificates given a batch of CSRs.
//
// Assuming a set of CSRs are located inside of the directory my-csr-directory:
//
// On Linux and OS X, the command is:
//
// $ ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr
// --certificate-signing-request file://my-csr-directory/{}
//
// This command lists all of the CSRs in my-csr-directory and pipes each CSR
// file name to the aws iot create-certificate-from-csr AWS CLI command to create
// a certificate for the corresponding CSR.
//
// The aws iot create-certificate-from-csr part of the command can also be run
// in parallel to speed up the certificate creation process:
//
// $ ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr
// --certificate-signing-request file://my-csr-directory/{}
//
// On Windows PowerShell, the command to create certificates for all CSRs in
// my-csr-directory is:
//
// > ls -Name my-csr-directory | %{aws iot create-certificate-from-csr --certificate-signing-request
// file://my-csr-directory/$_}
//
// On a Windows command prompt, the command to create certificates for all CSRs
// in my-csr-directory is:
//
// > forfiles /p my-csr-directory /c "cmd /c aws iot create-certificate-from-csr
// --certificate-signing-request file://@path"
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateCertificateFromCsr for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) CreateCertificateFromCsr(input *CreateCertificateFromCsrInput) (*CreateCertificateFromCsrOutput, error) {
	req, out := c.CreateCertificateFromCsrRequest(input)
	return out, req.Send()
}

// CreateCertificateFromCsrWithContext is the same as CreateCertificateFromCsr with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCertificateFromCsr for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateCertificateFromCsrWithContext(ctx aws.Context, input *CreateCertificateFromCsrInput, opts ...request.Option) (*CreateCertificateFromCsrOutput, error) {
	req, out := c.CreateCertificateFromCsrRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDimension = "CreateDimension"

// CreateDimensionRequest generates a "aws/request.Request" representing the
// client's request for the CreateDimension operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDimension for more information on using the CreateDimension
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDimensionRequest method.
//    req, resp := client.CreateDimensionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateDimensionRequest(input *CreateDimensionInput) (req *request.Request, output *CreateDimensionOutput) {
	op := &request.Operation{
		Name:       opCreateDimension,
		HTTPMethod: "POST",
		HTTPPath:   "/dimensions/{name}",
	}

	if input == nil {
		input = &CreateDimensionInput{}
	}

	output = &CreateDimensionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDimension API operation for AWS IoT.
//
// Create a dimension that you can use to limit the scope of a metric used in
// a security profile for AWS IoT Device Defender. For example, using a TOPIC_FILTER
// dimension, you can narrow down the scope of the metric only to MQTT topics
// whose name match the pattern specified in the dimension.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateDimension for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
func (c *IoT) CreateDimension(input *CreateDimensionInput) (*CreateDimensionOutput, error) {
	req, out := c.CreateDimensionRequest(input)
	return out, req.Send()
}

// CreateDimensionWithContext is the same as CreateDimension with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDimension for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateDimensionWithContext(ctx aws.Context, input *CreateDimensionInput, opts ...request.Option) (*CreateDimensionOutput, error) {
	req, out := c.CreateDimensionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomainConfiguration = "CreateDomainConfiguration"

// CreateDomainConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomainConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomainConfiguration for more information on using the CreateDomainConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDomainConfigurationRequest method.
//    req, resp := client.CreateDomainConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateDomainConfigurationRequest(input *CreateDomainConfigurationInput) (req *request.Request, output *CreateDomainConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateDomainConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/domainConfigurations/{domainConfigurationName}",
	}

	if input == nil {
		input = &CreateDomainConfigurationInput{}
	}

	output = &CreateDomainConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomainConfiguration API operation for AWS IoT.
//
// Creates a domain configuration.
//
// The domain configuration feature is in public preview and is subject to change.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateDomainConfiguration for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   A limit has been exceeded.
//
//   * CertificateValidationException
//   The certificate is invalid.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
func (c *IoT) CreateDomainConfiguration(input *CreateDomainConfigurationInput) (*CreateDomainConfigurationOutput, error) {
	req, out := c.CreateDomainConfigurationRequest(input)
	return out, req.Send()
}

// CreateDomainConfigurationWithContext is the same as CreateDomainConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomainConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateDomainConfigurationWithContext(ctx aws.Context, input *CreateDomainConfigurationInput, opts ...request.Option) (*CreateDomainConfigurationOutput, error) {
	req, out := c.CreateDomainConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDynamicThingGroup = "CreateDynamicThingGroup"

// CreateDynamicThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDynamicThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDynamicThingGroup for more information on using the CreateDynamicThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDynamicThingGroupRequest method.
//    req, resp := client.CreateDynamicThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateDynamicThingGroupRequest(input *CreateDynamicThingGroupInput) (req *request.Request, output *CreateDynamicThingGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDynamicThingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/dynamic-thing-groups/{thingGroupName}",
	}

	if input == nil {
		input = &CreateDynamicThingGroupInput{}
	}

	output = &CreateDynamicThingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDynamicThingGroup API operation for AWS IoT.
//
// Creates a dynamic thing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateDynamicThingGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidQueryException
//   The query is invalid.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
func (c *IoT) CreateDynamicThingGroup(input *CreateDynamicThingGroupInput) (*CreateDynamicThingGroupOutput, error) {
	req, out := c.CreateDynamicThingGroupRequest(input)
	return out, req.Send()
}

// CreateDynamicThingGroupWithContext is the same as CreateDynamicThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDynamicThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateDynamicThingGroupWithContext(ctx aws.Context, input *CreateDynamicThingGroupInput, opts ...request.Option) (*CreateDynamicThingGroupOutput, error) {
	req, out := c.CreateDynamicThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateJob = "CreateJob"

// CreateJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateJob for more information on using the CreateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateJobRequest method.
//    req, resp := client.CreateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateJobRequest(input *CreateJobInput) (req *request.Request, output *CreateJobOutput) {
	op := &request.Operation{
		Name:       opCreateJob,
		HTTPMethod: "PUT",
		HTTPPath:   "/jobs/{jobId}",
	}

	if input == nil {
		input = &CreateJobInput{}
	}

	output = &CreateJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateJob API operation for AWS IoT.
//
// Creates a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) CreateJob(input *CreateJobInput) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	return out, req.Send()
}

// CreateJobWithContext is the same as CreateJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateJobWithContext(ctx aws.Context, input *CreateJobInput, opts ...request.Option) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKeysAndCertificate = "CreateKeysAndCertificate"

// CreateKeysAndCertificateRequest generates a "aws/request.Request" representing the
// client's request for the CreateKeysAndCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKeysAndCertificate for more information on using the CreateKeysAndCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateKeysAndCertificateRequest method.
//    req, resp := client.CreateKeysAndCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateKeysAndCertificateRequest(input *CreateKeysAndCertificateInput) (req *request.Request, output *CreateKeysAndCertificateOutput) {
	op := &request.Operation{
		Name:       opCreateKeysAndCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/keys-and-certificate",
	}

	if input == nil {
		input = &CreateKeysAndCertificateInput{}
	}

	output = &CreateKeysAndCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKeysAndCertificate API operation for AWS IoT.
//
// Creates a 2048-bit RSA key pair and issues an X.509 certificate using the
// issued public key. You can also call CreateKeysAndCertificate over MQTT from
// a device, for more information, see Provisioning MQTT API (https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#provision-mqtt-api).
//
// Note This is the only time AWS IoT issues the private key for this certificate,
// so it is important to keep it in a secure location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateKeysAndCertificate for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) CreateKeysAndCertificate(input *CreateKeysAndCertificateInput) (*CreateKeysAndCertificateOutput, error) {
	req, out := c.CreateKeysAndCertificateRequest(input)
	return out, req.Send()
}

// CreateKeysAndCertificateWithContext is the same as CreateKeysAndCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKeysAndCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateKeysAndCertificateWithContext(ctx aws.Context, input *CreateKeysAndCertificateInput, opts ...request.Option) (*CreateKeysAndCertificateOutput, error) {
	req, out := c.CreateKeysAndCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMitigationAction = "CreateMitigationAction"

// CreateMitigationActionRequest generates a "aws/request.Request" representing the
// client's request for the CreateMitigationAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMitigationAction for more information on using the CreateMitigationAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMitigationActionRequest method.
//    req, resp := client.CreateMitigationActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateMitigationActionRequest(input *CreateMitigationActionInput) (req *request.Request, output *CreateMitigationActionOutput) {
	op := &request.Operation{
		Name:       opCreateMitigationAction,
		HTTPMethod: "POST",
		HTTPPath:   "/mitigationactions/actions/{actionName}",
	}

	if input == nil {
		input = &CreateMitigationActionInput{}
	}

	output = &CreateMitigationActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMitigationAction API operation for AWS IoT.
//
// Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask.
// Each mitigation action can apply only one type of change.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateMitigationAction for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) CreateMitigationAction(input *CreateMitigationActionInput) (*CreateMitigationActionOutput, error) {
	req, out := c.CreateMitigationActionRequest(input)
	return out, req.Send()
}

// CreateMitigationActionWithContext is the same as CreateMitigationAction with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMitigationAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateMitigationActionWithContext(ctx aws.Context, input *CreateMitigationActionInput, opts ...request.Option) (*CreateMitigationActionOutput, error) {
	req, out := c.CreateMitigationActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOTAUpdate = "CreateOTAUpdate"

// CreateOTAUpdateRequest generates a "aws/request.Request" representing the
// client's request for the CreateOTAUpdate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOTAUpdate for more information on using the CreateOTAUpdate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateOTAUpdateRequest method.
//    req, resp := client.CreateOTAUpdateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateOTAUpdateRequest(input *CreateOTAUpdateInput) (req *request.Request, output *CreateOTAUpdateOutput) {
	op := &request.Operation{
		Name:       opCreateOTAUpdate,
		HTTPMethod: "POST",
		HTTPPath:   "/otaUpdates/{otaUpdateId}",
	}

	if input == nil {
		input = &CreateOTAUpdateInput{}
	}

	output = &CreateOTAUpdateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOTAUpdate API operation for AWS IoT.
//
// Creates an AWS IoT OTAUpdate on a target group of things or groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateOTAUpdate for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) CreateOTAUpdate(input *CreateOTAUpdateInput) (*CreateOTAUpdateOutput, error) {
	req, out := c.CreateOTAUpdateRequest(input)
	return out, req.Send()
}

// CreateOTAUpdateWithContext is the same as CreateOTAUpdate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOTAUpdate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateOTAUpdateWithContext(ctx aws.Context, input *CreateOTAUpdateInput, opts ...request.Option) (*CreateOTAUpdateOutput, error) {
	req, out := c.CreateOTAUpdateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePolicy = "CreatePolicy"

// CreatePolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreatePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePolicy for more information on using the CreatePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePolicyRequest method.
//    req, resp := client.CreatePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreatePolicyRequest(input *CreatePolicyInput) (req *request.Request, output *CreatePolicyOutput) {
	op := &request.Operation{
		Name:       opCreatePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/policies/{policyName}",
	}

	if input == nil {
		input = &CreatePolicyInput{}
	}

	output = &CreatePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePolicy API operation for AWS IoT.
//
// Creates an AWS IoT policy.
//
// The created policy is the default version for the policy. This operation
// creates a policy version with a version identifier of 1 and sets 1 as the
// policy's default version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreatePolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * MalformedPolicyException
//   The policy documentation is not valid.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) CreatePolicy(input *CreatePolicyInput) (*CreatePolicyOutput, error) {
	req, out := c.CreatePolicyRequest(input)
	return out, req.Send()
}

// CreatePolicyWithContext is the same as CreatePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreatePolicyWithContext(ctx aws.Context, input *CreatePolicyInput, opts ...request.Option) (*CreatePolicyOutput, error) {
	req, out := c.CreatePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePolicyVersion = "CreatePolicyVersion"

// CreatePolicyVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreatePolicyVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePolicyVersion for more information on using the CreatePolicyVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePolicyVersionRequest method.
//    req, resp := client.CreatePolicyVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreatePolicyVersionRequest(input *CreatePolicyVersionInput) (req *request.Request, output *CreatePolicyVersionOutput) {
	op := &request.Operation{
		Name:       opCreatePolicyVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/policies/{policyName}/version",
	}

	if input == nil {
		input = &CreatePolicyVersionInput{}
	}

	output = &CreatePolicyVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePolicyVersion API operation for AWS IoT.
//
// Creates a new version of the specified AWS IoT policy. To update a policy,
// create a new policy version. A managed policy can have up to five versions.
// If the policy has five versions, you must use DeletePolicyVersion to delete
// an existing version before you create a new one.
//
// Optionally, you can set the new version as the policy's default version.
// The default version is the operative version (that is, the version that is
// in effect for the certificates to which the policy is attached).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreatePolicyVersion for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * MalformedPolicyException
//   The policy documentation is not valid.
//
//   * VersionsLimitExceededException
//   The number of policy versions exceeds the limit.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) CreatePolicyVersion(input *CreatePolicyVersionInput) (*CreatePolicyVersionOutput, error) {
	req, out := c.CreatePolicyVersionRequest(input)
	return out, req.Send()
}

// CreatePolicyVersionWithContext is the same as CreatePolicyVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePolicyVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreatePolicyVersionWithContext(ctx aws.Context, input *CreatePolicyVersionInput, opts ...request.Option) (*CreatePolicyVersionOutput, error) {
	req, out := c.CreatePolicyVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProvisioningClaim = "CreateProvisioningClaim"

// CreateProvisioningClaimRequest generates a "aws/request.Request" representing the
// client's request for the CreateProvisioningClaim operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProvisioningClaim for more information on using the CreateProvisioningClaim
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProvisioningClaimRequest method.
//    req, resp := client.CreateProvisioningClaimRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateProvisioningClaimRequest(input *CreateProvisioningClaimInput) (req *request.Request, output *CreateProvisioningClaimOutput) {
	op := &request.Operation{
		Name:       opCreateProvisioningClaim,
		HTTPMethod: "POST",
		HTTPPath:   "/provisioning-templates/{templateName}/provisioning-claim",
	}

	if input == nil {
		input = &CreateProvisioningClaimInput{}
	}

	output = &CreateProvisioningClaimOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProvisioningClaim API operation for AWS IoT.
//
// Creates a provisioning claim.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateProvisioningClaim for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) CreateProvisioningClaim(input *CreateProvisioningClaimInput) (*CreateProvisioningClaimOutput, error) {
	req, out := c.CreateProvisioningClaimRequest(input)
	return out, req.Send()
}

// CreateProvisioningClaimWithContext is the same as CreateProvisioningClaim with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProvisioningClaim for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateProvisioningClaimWithContext(ctx aws.Context, input *CreateProvisioningClaimInput, opts ...request.Option) (*CreateProvisioningClaimOutput, error) {
	req, out := c.CreateProvisioningClaimRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProvisioningTemplate = "CreateProvisioningTemplate"

// CreateProvisioningTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateProvisioningTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProvisioningTemplate for more information on using the CreateProvisioningTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProvisioningTemplateRequest method.
//    req, resp := client.CreateProvisioningTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateProvisioningTemplateRequest(input *CreateProvisioningTemplateInput) (req *request.Request, output *CreateProvisioningTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateProvisioningTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/provisioning-templates",
	}

	if input == nil {
		input = &CreateProvisioningTemplateInput{}
	}

	output = &CreateProvisioningTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProvisioningTemplate API operation for AWS IoT.
//
// Creates a fleet provisioning template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateProvisioningTemplate for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
func (c *IoT) CreateProvisioningTemplate(input *CreateProvisioningTemplateInput) (*CreateProvisioningTemplateOutput, error) {
	req, out := c.CreateProvisioningTemplateRequest(input)
	return out, req.Send()
}

// CreateProvisioningTemplateWithContext is the same as CreateProvisioningTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProvisioningTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateProvisioningTemplateWithContext(ctx aws.Context, input *CreateProvisioningTemplateInput, opts ...request.Option) (*CreateProvisioningTemplateOutput, error) {
	req, out := c.CreateProvisioningTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProvisioningTemplateVersion = "CreateProvisioningTemplateVersion"

// CreateProvisioningTemplateVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateProvisioningTemplateVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProvisioningTemplateVersion for more information on using the CreateProvisioningTemplateVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProvisioningTemplateVersionRequest method.
//    req, resp := client.CreateProvisioningTemplateVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateProvisioningTemplateVersionRequest(input *CreateProvisioningTemplateVersionInput) (req *request.Request, output *CreateProvisioningTemplateVersionOutput) {
	op := &request.Operation{
		Name:       opCreateProvisioningTemplateVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/provisioning-templates/{templateName}/versions",
	}

	if input == nil {
		input = &CreateProvisioningTemplateVersionInput{}
	}

	output = &CreateProvisioningTemplateVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProvisioningTemplateVersion API operation for AWS IoT.
//
// Creates a new version of a fleet provisioning template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateProvisioningTemplateVersion for usage and error information.
//
// Returned Error Types:
//   * VersionsLimitExceededException
//   The number of policy versions exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ConflictingResourceUpdateException
//   A conflicting resource update exception. This exception is thrown when two
//   pending updates cause a conflict.
//
func (c *IoT) CreateProvisioningTemplateVersion(input *CreateProvisioningTemplateVersionInput) (*CreateProvisioningTemplateVersionOutput, error) {
	req, out := c.CreateProvisioningTemplateVersionRequest(input)
	return out, req.Send()
}

// CreateProvisioningTemplateVersionWithContext is the same as CreateProvisioningTemplateVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProvisioningTemplateVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateProvisioningTemplateVersionWithContext(ctx aws.Context, input *CreateProvisioningTemplateVersionInput, opts ...request.Option) (*CreateProvisioningTemplateVersionOutput, error) {
	req, out := c.CreateProvisioningTemplateVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRoleAlias = "CreateRoleAlias"

// CreateRoleAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoleAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRoleAlias for more information on using the CreateRoleAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRoleAliasRequest method.
//    req, resp := client.CreateRoleAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateRoleAliasRequest(input *CreateRoleAliasInput) (req *request.Request, output *CreateRoleAliasOutput) {
	op := &request.Operation{
		Name:       opCreateRoleAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/role-aliases/{roleAlias}",
	}

	if input == nil {
		input = &CreateRoleAliasInput{}
	}

	output = &CreateRoleAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoleAlias API operation for AWS IoT.
//
// Creates a role alias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateRoleAlias for usage and error information.
//
// Returned Error Types:
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) CreateRoleAlias(input *CreateRoleAliasInput) (*CreateRoleAliasOutput, error) {
	req, out := c.CreateRoleAliasRequest(input)
	return out, req.Send()
}

// CreateRoleAliasWithContext is the same as CreateRoleAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRoleAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateRoleAliasWithContext(ctx aws.Context, input *CreateRoleAliasInput, opts ...request.Option) (*CreateRoleAliasOutput, error) {
	req, out := c.CreateRoleAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateScheduledAudit = "CreateScheduledAudit"

// CreateScheduledAuditRequest generates a "aws/request.Request" representing the
// client's request for the CreateScheduledAudit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateScheduledAudit for more information on using the CreateScheduledAudit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateScheduledAuditRequest method.
//    req, resp := client.CreateScheduledAuditRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateScheduledAuditRequest(input *CreateScheduledAuditInput) (req *request.Request, output *CreateScheduledAuditOutput) {
	op := &request.Operation{
		Name:       opCreateScheduledAudit,
		HTTPMethod: "POST",
		HTTPPath:   "/audit/scheduledaudits/{scheduledAuditName}",
	}

	if input == nil {
		input = &CreateScheduledAuditInput{}
	}

	output = &CreateScheduledAuditOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateScheduledAudit API operation for AWS IoT.
//
// Creates a scheduled audit that is run at a specified time interval.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateScheduledAudit for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
func (c *IoT) CreateScheduledAudit(input *CreateScheduledAuditInput) (*CreateScheduledAuditOutput, error) {
	req, out := c.CreateScheduledAuditRequest(input)
	return out, req.Send()
}

// CreateScheduledAuditWithContext is the same as CreateScheduledAudit with the addition of
// the ability to pass a context and additional request options.
//
// See CreateScheduledAudit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateScheduledAuditWithContext(ctx aws.Context, input *CreateScheduledAuditInput, opts ...request.Option) (*CreateScheduledAuditOutput, error) {
	req, out := c.CreateScheduledAuditRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSecurityProfile = "CreateSecurityProfile"

// CreateSecurityProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateSecurityProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSecurityProfile for more information on using the CreateSecurityProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSecurityProfileRequest method.
//    req, resp := client.CreateSecurityProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateSecurityProfileRequest(input *CreateSecurityProfileInput) (req *request.Request, output *CreateSecurityProfileOutput) {
	op := &request.Operation{
		Name:       opCreateSecurityProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/security-profiles/{securityProfileName}",
	}

	if input == nil {
		input = &CreateSecurityProfileInput{}
	}

	output = &CreateSecurityProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSecurityProfile API operation for AWS IoT.
//
// Creates a Device Defender security profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateSecurityProfile for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) CreateSecurityProfile(input *CreateSecurityProfileInput) (*CreateSecurityProfileOutput, error) {
	req, out := c.CreateSecurityProfileRequest(input)
	return out, req.Send()
}

// CreateSecurityProfileWithContext is the same as CreateSecurityProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSecurityProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateSecurityProfileWithContext(ctx aws.Context, input *CreateSecurityProfileInput, opts ...request.Option) (*CreateSecurityProfileOutput, error) {
	req, out := c.CreateSecurityProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStream = "CreateStream"

// CreateStreamRequest generates a "aws/request.Request" representing the
// client's request for the CreateStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStream for more information on using the CreateStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStreamRequest method.
//    req, resp := client.CreateStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateStreamRequest(input *CreateStreamInput) (req *request.Request, output *CreateStreamOutput) {
	op := &request.Operation{
		Name:       opCreateStream,
		HTTPMethod: "POST",
		HTTPPath:   "/streams/{streamId}",
	}

	if input == nil {
		input = &CreateStreamInput{}
	}

	output = &CreateStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStream API operation for AWS IoT.
//
// Creates a stream for delivering one or more large files in chunks over MQTT.
// A stream transports data bytes in chunks or blocks packaged as MQTT messages
// from a source like S3. You can have one or more files associated with a stream.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateStream for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) CreateStream(input *CreateStreamInput) (*CreateStreamOutput, error) {
	req, out := c.CreateStreamRequest(input)
	return out, req.Send()
}

// CreateStreamWithContext is the same as CreateStream with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateStreamWithContext(ctx aws.Context, input *CreateStreamInput, opts ...request.Option) (*CreateStreamOutput, error) {
	req, out := c.CreateStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateThing = "CreateThing"

// CreateThingRequest generates a "aws/request.Request" representing the
// client's request for the CreateThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateThing for more information on using the CreateThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateThingRequest method.
//    req, resp := client.CreateThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateThingRequest(input *CreateThingInput) (req *request.Request, output *CreateThingOutput) {
	op := &request.Operation{
		Name:       opCreateThing,
		HTTPMethod: "POST",
		HTTPPath:   "/things/{thingName}",
	}

	if input == nil {
		input = &CreateThingInput{}
	}

	output = &CreateThingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateThing API operation for AWS IoT.
//
// Creates a thing record in the registry. If this call is made multiple times
// using the same thing name and configuration, the call will succeed. If this
// call is made with the same thing name but different configuration a ResourceAlreadyExistsException
// is thrown.
//
// This is a control plane operation. See Authorization (https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html)
// for information about authorizing control plane actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateThing for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) CreateThing(input *CreateThingInput) (*CreateThingOutput, error) {
	req, out := c.CreateThingRequest(input)
	return out, req.Send()
}

// CreateThingWithContext is the same as CreateThing with the addition of
// the ability to pass a context and additional request options.
//
// See CreateThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateThingWithContext(ctx aws.Context, input *CreateThingInput, opts ...request.Option) (*CreateThingOutput, error) {
	req, out := c.CreateThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateThingGroup = "CreateThingGroup"

// CreateThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateThingGroup for more information on using the CreateThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateThingGroupRequest method.
//    req, resp := client.CreateThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateThingGroupRequest(input *CreateThingGroupInput) (req *request.Request, output *CreateThingGroupOutput) {
	op := &request.Operation{
		Name:       opCreateThingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/thing-groups/{thingGroupName}",
	}

	if input == nil {
		input = &CreateThingGroupInput{}
	}

	output = &CreateThingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateThingGroup API operation for AWS IoT.
//
// Create a thing group.
//
// This is a control plane operation. See Authorization (https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html)
// for information about authorizing control plane actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateThingGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) CreateThingGroup(input *CreateThingGroupInput) (*CreateThingGroupOutput, error) {
	req, out := c.CreateThingGroupRequest(input)
	return out, req.Send()
}

// CreateThingGroupWithContext is the same as CreateThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateThingGroupWithContext(ctx aws.Context, input *CreateThingGroupInput, opts ...request.Option) (*CreateThingGroupOutput, error) {
	req, out := c.CreateThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateThingType = "CreateThingType"

// CreateThingTypeRequest generates a "aws/request.Request" representing the
// client's request for the CreateThingType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateThingType for more information on using the CreateThingType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateThingTypeRequest method.
//    req, resp := client.CreateThingTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateThingTypeRequest(input *CreateThingTypeInput) (req *request.Request, output *CreateThingTypeOutput) {
	op := &request.Operation{
		Name:       opCreateThingType,
		HTTPMethod: "POST",
		HTTPPath:   "/thing-types/{thingTypeName}",
	}

	if input == nil {
		input = &CreateThingTypeInput{}
	}

	output = &CreateThingTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateThingType API operation for AWS IoT.
//
// Creates a new thing type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateThingType for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
func (c *IoT) CreateThingType(input *CreateThingTypeInput) (*CreateThingTypeOutput, error) {
	req, out := c.CreateThingTypeRequest(input)
	return out, req.Send()
}

// CreateThingTypeWithContext is the same as CreateThingType with the addition of
// the ability to pass a context and additional request options.
//
// See CreateThingType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateThingTypeWithContext(ctx aws.Context, input *CreateThingTypeInput, opts ...request.Option) (*CreateThingTypeOutput, error) {
	req, out := c.CreateThingTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTopicRule = "CreateTopicRule"

// CreateTopicRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateTopicRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTopicRule for more information on using the CreateTopicRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTopicRuleRequest method.
//    req, resp := client.CreateTopicRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateTopicRuleRequest(input *CreateTopicRuleInput) (req *request.Request, output *CreateTopicRuleOutput) {
	op := &request.Operation{
		Name:       opCreateTopicRule,
		HTTPMethod: "POST",
		HTTPPath:   "/rules/{ruleName}",
	}

	if input == nil {
		input = &CreateTopicRuleInput{}
	}

	output = &CreateTopicRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateTopicRule API operation for AWS IoT.
//
// Creates a rule. Creating rules is an administrator-level action. Any user
// who has permission to create rules will be able to access data processed
// by the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateTopicRule for usage and error information.
//
// Returned Error Types:
//   * SqlParseException
//   The Rule-SQL expression can't be parsed correctly.
//
//   * InternalException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * ConflictingResourceUpdateException
//   A conflicting resource update exception. This exception is thrown when two
//   pending updates cause a conflict.
//
func (c *IoT) CreateTopicRule(input *CreateTopicRuleInput) (*CreateTopicRuleOutput, error) {
	req, out := c.CreateTopicRuleRequest(input)
	return out, req.Send()
}

// CreateTopicRuleWithContext is the same as CreateTopicRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTopicRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateTopicRuleWithContext(ctx aws.Context, input *CreateTopicRuleInput, opts ...request.Option) (*CreateTopicRuleOutput, error) {
	req, out := c.CreateTopicRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTopicRuleDestination = "CreateTopicRuleDestination"

// CreateTopicRuleDestinationRequest generates a "aws/request.Request" representing the
// client's request for the CreateTopicRuleDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTopicRuleDestination for more information on using the CreateTopicRuleDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTopicRuleDestinationRequest method.
//    req, resp := client.CreateTopicRuleDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateTopicRuleDestinationRequest(input *CreateTopicRuleDestinationInput) (req *request.Request, output *CreateTopicRuleDestinationOutput) {
	op := &request.Operation{
		Name:       opCreateTopicRuleDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/destinations",
	}

	if input == nil {
		input = &CreateTopicRuleDestinationInput{}
	}

	output = &CreateTopicRuleDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTopicRuleDestination API operation for AWS IoT.
//
// Creates a topic rule destination. The destination must be confirmed prior
// to use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateTopicRuleDestination for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * ConflictingResourceUpdateException
//   A conflicting resource update exception. This exception is thrown when two
//   pending updates cause a conflict.
//
func (c *IoT) CreateTopicRuleDestination(input *CreateTopicRuleDestinationInput) (*CreateTopicRuleDestinationOutput, error) {
	req, out := c.CreateTopicRuleDestinationRequest(input)
	return out, req.Send()
}

// CreateTopicRuleDestinationWithContext is the same as CreateTopicRuleDestination with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTopicRuleDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateTopicRuleDestinationWithContext(ctx aws.Context, input *CreateTopicRuleDestinationInput, opts ...request.Option) (*CreateTopicRuleDestinationOutput, error) {
	req, out := c.CreateTopicRuleDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccountAuditConfiguration = "DeleteAccountAuditConfiguration"

// DeleteAccountAuditConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccountAuditConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccountAuditConfiguration for more information on using the DeleteAccountAuditConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAccountAuditConfigurationRequest method.
//    req, resp := client.DeleteAccountAuditConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteAccountAuditConfigurationRequest(input *DeleteAccountAuditConfigurationInput) (req *request.Request, output *DeleteAccountAuditConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteAccountAuditConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/audit/configuration",
	}

	if input == nil {
		input = &DeleteAccountAuditConfigurationInput{}
	}

	output = &DeleteAccountAuditConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAccountAuditConfiguration API operation for AWS IoT.
//
// Restores the default settings for Device Defender audits for this account.
// Any configuration data you entered is deleted and all audit checks are reset
// to disabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteAccountAuditConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DeleteAccountAuditConfiguration(input *DeleteAccountAuditConfigurationInput) (*DeleteAccountAuditConfigurationOutput, error) {
	req, out := c.DeleteAccountAuditConfigurationRequest(input)
	return out, req.Send()
}

// DeleteAccountAuditConfigurationWithContext is the same as DeleteAccountAuditConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccountAuditConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteAccountAuditConfigurationWithContext(ctx aws.Context, input *DeleteAccountAuditConfigurationInput, opts ...request.Option) (*DeleteAccountAuditConfigurationOutput, error) {
	req, out := c.DeleteAccountAuditConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAuthorizer = "DeleteAuthorizer"

// DeleteAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAuthorizer for more information on using the DeleteAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAuthorizerRequest method.
//    req, resp := client.DeleteAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteAuthorizerRequest(input *DeleteAuthorizerInput) (req *request.Request, output *DeleteAuthorizerOutput) {
	op := &request.Operation{
		Name:       opDeleteAuthorizer,
		HTTPMethod: "DELETE",
		HTTPPath:   "/authorizer/{authorizerName}",
	}

	if input == nil {
		input = &DeleteAuthorizerInput{}
	}

	output = &DeleteAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAuthorizer API operation for AWS IoT.
//
// Deletes an authorizer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteAuthorizer for usage and error information.
//
// Returned Error Types:
//   * DeleteConflictException
//   You can't delete the resource because it is attached to one or more resources.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DeleteAuthorizer(input *DeleteAuthorizerInput) (*DeleteAuthorizerOutput, error) {
	req, out := c.DeleteAuthorizerRequest(input)
	return out, req.Send()
}

// DeleteAuthorizerWithContext is the same as DeleteAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteAuthorizerWithContext(ctx aws.Context, input *DeleteAuthorizerInput, opts ...request.Option) (*DeleteAuthorizerOutput, error) {
	req, out := c.DeleteAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBillingGroup = "DeleteBillingGroup"

// DeleteBillingGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBillingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBillingGroup for more information on using the DeleteBillingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBillingGroupRequest method.
//    req, resp := client.DeleteBillingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteBillingGroupRequest(input *DeleteBillingGroupInput) (req *request.Request, output *DeleteBillingGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteBillingGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/billing-groups/{billingGroupName}",
	}

	if input == nil {
		input = &DeleteBillingGroupInput{}
	}

	output = &DeleteBillingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBillingGroup API operation for AWS IoT.
//
// Deletes the billing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteBillingGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * VersionConflictException
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DeleteBillingGroup(input *DeleteBillingGroupInput) (*DeleteBillingGroupOutput, error) {
	req, out := c.DeleteBillingGroupRequest(input)
	return out, req.Send()
}

// DeleteBillingGroupWithContext is the same as DeleteBillingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBillingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteBillingGroupWithContext(ctx aws.Context, input *DeleteBillingGroupInput, opts ...request.Option) (*DeleteBillingGroupOutput, error) {
	req, out := c.DeleteBillingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCACertificate = "DeleteCACertificate"

// DeleteCACertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCACertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCACertificate for more information on using the DeleteCACertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCACertificateRequest method.
//    req, resp := client.DeleteCACertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteCACertificateRequest(input *DeleteCACertificateInput) (req *request.Request, output *DeleteCACertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteCACertificate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/cacertificate/{caCertificateId}",
	}

	if input == nil {
		input = &DeleteCACertificateInput{}
	}

	output = &DeleteCACertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCACertificate API operation for AWS IoT.
//
// Deletes a registered CA certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteCACertificate for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * CertificateStateException
//   The certificate operation is not allowed.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) DeleteCACertificate(input *DeleteCACertificateInput) (*DeleteCACertificateOutput, error) {
	req, out := c.DeleteCACertificateRequest(input)
	return out, req.Send()
}

// DeleteCACertificateWithContext is the same as DeleteCACertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCACertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteCACertificateWithContext(ctx aws.Context, input *DeleteCACertificateInput, opts ...request.Option) (*DeleteCACertificateOutput, error) {
	req, out := c.DeleteCACertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCertificate = "DeleteCertificate"

// DeleteCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCertificate for more information on using the DeleteCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCertificateRequest method.
//    req, resp := client.DeleteCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteCertificateRequest(input *DeleteCertificateInput) (req *request.Request, output *DeleteCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteCertificate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/certificates/{certificateId}",
	}

	if input == nil {
		input = &DeleteCertificateInput{}
	}

	output = &DeleteCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCertificate API operation for AWS IoT.
//
// Deletes the specified certificate.
//
// A certificate cannot be deleted if it has a policy or IoT thing attached
// to it or if its status is set to ACTIVE. To delete a certificate, first use
// the DetachPrincipalPolicy API to detach all policies. Next, use the UpdateCertificate
// API to set the certificate to the INACTIVE status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteCertificate for usage and error information.
//
// Returned Error Types:
//   * CertificateStateException
//   The certificate operation is not allowed.
//
//   * DeleteConflictException
//   You can't delete the resource because it is attached to one or more resources.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) DeleteCertificate(input *DeleteCertificateInput) (*DeleteCertificateOutput, error) {
	req, out := c.DeleteCertificateRequest(input)
	return out, req.Send()
}

// DeleteCertificateWithContext is the same as DeleteCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteCertificateWithContext(ctx aws.Context, input *DeleteCertificateInput, opts ...request.Option) (*DeleteCertificateOutput, error) {
	req, out := c.DeleteCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDimension = "DeleteDimension"

// DeleteDimensionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDimension operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDimension for more information on using the DeleteDimension
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDimensionRequest method.
//    req, resp := client.DeleteDimensionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteDimensionRequest(input *DeleteDimensionInput) (req *request.Request, output *DeleteDimensionOutput) {
	op := &request.Operation{
		Name:       opDeleteDimension,
		HTTPMethod: "DELETE",
		HTTPPath:   "/dimensions/{name}",
	}

	if input == nil {
		input = &DeleteDimensionInput{}
	}

	output = &DeleteDimensionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDimension API operation for AWS IoT.
//
// Removes the specified dimension from your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteDimension for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
func (c *IoT) DeleteDimension(input *DeleteDimensionInput) (*DeleteDimensionOutput, error) {
	req, out := c.DeleteDimensionRequest(input)
	return out, req.Send()
}

// DeleteDimensionWithContext is the same as DeleteDimension with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDimension for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteDimensionWithContext(ctx aws.Context, input *DeleteDimensionInput, opts ...request.Option) (*DeleteDimensionOutput, error) {
	req, out := c.DeleteDimensionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomainConfiguration = "DeleteDomainConfiguration"

// DeleteDomainConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomainConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomainConfiguration for more information on using the DeleteDomainConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDomainConfigurationRequest method.
//    req, resp := client.DeleteDomainConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteDomainConfigurationRequest(input *DeleteDomainConfigurationInput) (req *request.Request, output *DeleteDomainConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteDomainConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/domainConfigurations/{domainConfigurationName}",
	}

	if input == nil {
		input = &DeleteDomainConfigurationInput{}
	}

	output = &DeleteDomainConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDomainConfiguration API operation for AWS IoT.
//
// Deletes the specified domain configuration.
//
// The domain configuration feature is in public preview and is subject to change.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteDomainConfiguration for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
func (c *IoT) DeleteDomainConfiguration(input *DeleteDomainConfigurationInput) (*DeleteDomainConfigurationOutput, error) {
	req, out := c.DeleteDomainConfigurationRequest(input)
	return out, req.Send()
}

// DeleteDomainConfigurationWithContext is the same as DeleteDomainConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomainConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteDomainConfigurationWithContext(ctx aws.Context, input *DeleteDomainConfigurationInput, opts ...request.Option) (*DeleteDomainConfigurationOutput, error) {
	req, out := c.DeleteDomainConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDynamicThingGroup = "DeleteDynamicThingGroup"

// DeleteDynamicThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDynamicThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDynamicThingGroup for more information on using the DeleteDynamicThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDynamicThingGroupRequest method.
//    req, resp := client.DeleteDynamicThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteDynamicThingGroupRequest(input *DeleteDynamicThingGroupInput) (req *request.Request, output *DeleteDynamicThingGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDynamicThingGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/dynamic-thing-groups/{thingGroupName}",
	}

	if input == nil {
		input = &DeleteDynamicThingGroupInput{}
	}

	output = &DeleteDynamicThingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDynamicThingGroup API operation for AWS IoT.
//
// Deletes a dynamic thing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteDynamicThingGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * VersionConflictException
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DeleteDynamicThingGroup(input *DeleteDynamicThingGroupInput) (*DeleteDynamicThingGroupOutput, error) {
	req, out := c.DeleteDynamicThingGroupRequest(input)
	return out, req.Send()
}

// DeleteDynamicThingGroupWithContext is the same as DeleteDynamicThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDynamicThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteDynamicThingGroupWithContext(ctx aws.Context, input *DeleteDynamicThingGroupInput, opts ...request.Option) (*DeleteDynamicThingGroupOutput, error) {
	req, out := c.DeleteDynamicThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteJob = "DeleteJob"

// DeleteJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteJob for more information on using the DeleteJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteJobRequest method.
//    req, resp := client.DeleteJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteJobRequest(input *DeleteJobInput) (req *request.Request, output *DeleteJobOutput) {
	op := &request.Operation{
		Name:       opDeleteJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/jobs/{jobId}",
	}

	if input == nil {
		input = &DeleteJobInput{}
	}

	output = &DeleteJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteJob API operation for AWS IoT.
//
// Deletes a job and its related job executions.
//
// Deleting a job may take time, depending on the number of job executions created
// for the job and various other factors. While the job is being deleted, the
// status of the job will be shown as "DELETION_IN_PROGRESS". Attempting to
// delete or cancel a job whose status is already "DELETION_IN_PROGRESS" will
// result in an error.
//
// Only 10 jobs may have status "DELETION_IN_PROGRESS" at the same time, or
// a LimitExceededException will occur.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidStateTransitionException
//   An attempt was made to change to an invalid state, for example by deleting
//   a job or a job execution which is "IN_PROGRESS" without setting the force
//   parameter.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) DeleteJob(input *DeleteJobInput) (*DeleteJobOutput, error) {
	req, out := c.DeleteJobRequest(input)
	return out, req.Send()
}

// DeleteJobWithContext is the same as DeleteJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteJobWithContext(ctx aws.Context, input *DeleteJobInput, opts ...request.Option) (*DeleteJobOutput, error) {
	req, out := c.DeleteJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteJobExecution = "DeleteJobExecution"

// DeleteJobExecutionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteJobExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteJobExecution for more information on using the DeleteJobExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteJobExecutionRequest method.
//    req, resp := client.DeleteJobExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteJobExecutionRequest(input *DeleteJobExecutionInput) (req *request.Request, output *DeleteJobExecutionOutput) {
	op := &request.Operation{
		Name:       opDeleteJobExecution,
		HTTPMethod: "DELETE",
		HTTPPath:   "/things/{thingName}/jobs/{jobId}/executionNumber/{executionNumber}",
	}

	if input == nil {
		input = &DeleteJobExecutionInput{}
	}

	output = &DeleteJobExecutionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteJobExecution API operation for AWS IoT.
//
// Deletes a job execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteJobExecution for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InvalidStateTransitionException
//   An attempt was made to change to an invalid state, for example by deleting
//   a job or a job execution which is "IN_PROGRESS" without setting the force
//   parameter.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) DeleteJobExecution(input *DeleteJobExecutionInput) (*DeleteJobExecutionOutput, error) {
	req, out := c.DeleteJobExecutionRequest(input)
	return out, req.Send()
}

// DeleteJobExecutionWithContext is the same as DeleteJobExecution with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteJobExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteJobExecutionWithContext(ctx aws.Context, input *DeleteJobExecutionInput, opts ...request.Option) (*DeleteJobExecutionOutput, error) {
	req, out := c.DeleteJobExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMitigationAction = "DeleteMitigationAction"

// DeleteMitigationActionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMitigationAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMitigationAction for more information on using the DeleteMitigationAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMitigationActionRequest method.
//    req, resp := client.DeleteMitigationActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteMitigationActionRequest(input *DeleteMitigationActionInput) (req *request.Request, output *DeleteMitigationActionOutput) {
	op := &request.Operation{
		Name:       opDeleteMitigationAction,
		HTTPMethod: "DELETE",
		HTTPPath:   "/mitigationactions/actions/{actionName}",
	}

	if input == nil {
		input = &DeleteMitigationActionInput{}
	}

	output = &DeleteMitigationActionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMitigationAction API operation for AWS IoT.
//
// Deletes a defined mitigation action from your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteMitigationAction for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DeleteMitigationAction(input *DeleteMitigationActionInput) (*DeleteMitigationActionOutput, error) {
	req, out := c.DeleteMitigationActionRequest(input)
	return out, req.Send()
}

// DeleteMitigationActionWithContext is the same as DeleteMitigationAction with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMitigationAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteMitigationActionWithContext(ctx aws.Context, input *DeleteMitigationActionInput, opts ...request.Option) (*DeleteMitigationActionOutput, error) {
	req, out := c.DeleteMitigationActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOTAUpdate = "DeleteOTAUpdate"

// DeleteOTAUpdateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOTAUpdate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOTAUpdate for more information on using the DeleteOTAUpdate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteOTAUpdateRequest method.
//    req, resp := client.DeleteOTAUpdateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteOTAUpdateRequest(input *DeleteOTAUpdateInput) (req *request.Request, output *DeleteOTAUpdateOutput) {
	op := &request.Operation{
		Name:       opDeleteOTAUpdate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/otaUpdates/{otaUpdateId}",
	}

	if input == nil {
		input = &DeleteOTAUpdateInput{}
	}

	output = &DeleteOTAUpdateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOTAUpdate API operation for AWS IoT.
//
// Delete an OTA update.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteOTAUpdate for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * VersionConflictException
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
func (c *IoT) DeleteOTAUpdate(input *DeleteOTAUpdateInput) (*DeleteOTAUpdateOutput, error) {
	req, out := c.DeleteOTAUpdateRequest(input)
	return out, req.Send()
}

// DeleteOTAUpdateWithContext is the same as DeleteOTAUpdate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOTAUpdate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteOTAUpdateWithContext(ctx aws.Context, input *DeleteOTAUpdateInput, opts ...request.Option) (*DeleteOTAUpdateOutput, error) {
	req, out := c.DeleteOTAUpdateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePolicy = "DeletePolicy"

// DeletePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeletePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePolicy for more information on using the DeletePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePolicyRequest method.
//    req, resp := client.DeletePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeletePolicyRequest(input *DeletePolicyInput) (req *request.Request, output *DeletePolicyOutput) {
	op := &request.Operation{
		Name:       opDeletePolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/policies/{policyName}",
	}

	if input == nil {
		input = &DeletePolicyInput{}
	}

	output = &DeletePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePolicy API operation for AWS IoT.
//
// Deletes the specified policy.
//
// A policy cannot be deleted if it has non-default versions or it is attached
// to any certificate.
//
// To delete a policy, use the DeletePolicyVersion API to delete all non-default
// versions of the policy; use the DetachPrincipalPolicy API to detach the policy
// from any certificate; and then use the DeletePolicy API to delete the policy.
//
// When a policy is deleted using DeletePolicy, its default version is deleted
// with it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeletePolicy for usage and error information.
//
// Returned Error Types:
//   * DeleteConflictException
//   You can't delete the resource because it is attached to one or more resources.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DeletePolicy(input *DeletePolicyInput) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	return out, req.Send()
}

// DeletePolicyWithContext is the same as DeletePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeletePolicyWithContext(ctx aws.Context, input *DeletePolicyInput, opts ...request.Option) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePolicyVersion = "DeletePolicyVersion"

// DeletePolicyVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeletePolicyVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePolicyVersion for more information on using the DeletePolicyVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePolicyVersionRequest method.
//    req, resp := client.DeletePolicyVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeletePolicyVersionRequest(input *DeletePolicyVersionInput) (req *request.Request, output *DeletePolicyVersionOutput) {
	op := &request.Operation{
		Name:       opDeletePolicyVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/policies/{policyName}/version/{policyVersionId}",
	}

	if input == nil {
		input = &DeletePolicyVersionInput{}
	}

	output = &DeletePolicyVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePolicyVersion API operation for AWS IoT.
//
// Deletes the specified version of the specified policy. You cannot delete
// the default version of a policy using this API. To delete the default version
// of a policy, use DeletePolicy. To find out which version of a policy is marked
// as the default version, use ListPolicyVersions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeletePolicyVersion for usage and error information.
//
// Returned Error Types:
//   * DeleteConflictException
//   You can't delete the resource because it is attached to one or more resources.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DeletePolicyVersion(input *DeletePolicyVersionInput) (*DeletePolicyVersionOutput, error) {
	req, out := c.DeletePolicyVersionRequest(input)
	return out, req.Send()
}

// DeletePolicyVersionWithContext is the same as DeletePolicyVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePolicyVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeletePolicyVersionWithContext(ctx aws.Context, input *DeletePolicyVersionInput, opts ...request.Option) (*DeletePolicyVersionOutput, error) {
	req, out := c.DeletePolicyVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProvisioningTemplate = "DeleteProvisioningTemplate"

// DeleteProvisioningTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProvisioningTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProvisioningTemplate for more information on using the DeleteProvisioningTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProvisioningTemplateRequest method.
//    req, resp := client.DeleteProvisioningTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteProvisioningTemplateRequest(input *DeleteProvisioningTemplateInput) (req *request.Request, output *DeleteProvisioningTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteProvisioningTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/provisioning-templates/{templateName}",
	}

	if input == nil {
		input = &DeleteProvisioningTemplateInput{}
	}

	output = &DeleteProvisioningTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProvisioningTemplate API operation for AWS IoT.
//
// Deletes a fleet provisioning template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteProvisioningTemplate for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * DeleteConflictException
//   You can't delete the resource because it is attached to one or more resources.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
func (c *IoT) DeleteProvisioningTemplate(input *DeleteProvisioningTemplateInput) (*DeleteProvisioningTemplateOutput, error) {
	req, out := c.DeleteProvisioningTemplateRequest(input)
	return out, req.Send()
}

// DeleteProvisioningTemplateWithContext is the same as DeleteProvisioningTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProvisioningTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteProvisioningTemplateWithContext(ctx aws.Context, input *DeleteProvisioningTemplateInput, opts ...request.Option) (*DeleteProvisioningTemplateOutput, error) {
	req, out := c.DeleteProvisioningTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProvisioningTemplateVersion = "DeleteProvisioningTemplateVersion"

// DeleteProvisioningTemplateVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProvisioningTemplateVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProvisioningTemplateVersion for more information on using the DeleteProvisioningTemplateVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProvisioningTemplateVersionRequest method.
//    req, resp := client.DeleteProvisioningTemplateVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteProvisioningTemplateVersionRequest(input *DeleteProvisioningTemplateVersionInput) (req *request.Request, output *DeleteProvisioningTemplateVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteProvisioningTemplateVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/provisioning-templates/{templateName}/versions/{versionId}",
	}

	if input == nil {
		input = &DeleteProvisioningTemplateVersionInput{}
	}

	output = &DeleteProvisioningTemplateVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProvisioningTemplateVersion API operation for AWS IoT.
//
// Deletes a fleet provisioning template version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteProvisioningTemplateVersion for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * DeleteConflictException
//   You can't delete the resource because it is attached to one or more resources.
//
func (c *IoT) DeleteProvisioningTemplateVersion(input *DeleteProvisioningTemplateVersionInput) (*DeleteProvisioningTemplateVersionOutput, error) {
	req, out := c.DeleteProvisioningTemplateVersionRequest(input)
	return out, req.Send()
}

// DeleteProvisioningTemplateVersionWithContext is the same as DeleteProvisioningTemplateVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProvisioningTemplateVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteProvisioningTemplateVersionWithContext(ctx aws.Context, input *DeleteProvisioningTemplateVersionInput, opts ...request.Option) (*DeleteProvisioningTemplateVersionOutput, error) {
	req, out := c.DeleteProvisioningTemplateVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRegistrationCode = "DeleteRegistrationCode"

// DeleteRegistrationCodeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRegistrationCode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRegistrationCode for more information on using the DeleteRegistrationCode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRegistrationCodeRequest method.
//    req, resp := client.DeleteRegistrationCodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteRegistrationCodeRequest(input *DeleteRegistrationCodeInput) (req *request.Request, output *DeleteRegistrationCodeOutput) {
	op := &request.Operation{
		Name:       opDeleteRegistrationCode,
		HTTPMethod: "DELETE",
		HTTPPath:   "/registrationcode",
	}

	if input == nil {
		input = &DeleteRegistrationCodeInput{}
	}

	output = &DeleteRegistrationCodeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRegistrationCode API operation for AWS IoT.
//
// Deletes a CA certificate registration code.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteRegistrationCode for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DeleteRegistrationCode(input *DeleteRegistrationCodeInput) (*DeleteRegistrationCodeOutput, error) {
	req, out := c.DeleteRegistrationCodeRequest(input)
	return out, req.Send()
}

// DeleteRegistrationCodeWithContext is the same as DeleteRegistrationCode with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRegistrationCode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteRegistrationCodeWithContext(ctx aws.Context, input *DeleteRegistrationCodeInput, opts ...request.Option) (*DeleteRegistrationCodeOutput, error) {
	req, out := c.DeleteRegistrationCodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoleAlias = "DeleteRoleAlias"

// DeleteRoleAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoleAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoleAlias for more information on using the DeleteRoleAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRoleAliasRequest method.
//    req, resp := client.DeleteRoleAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteRoleAliasRequest(input *DeleteRoleAliasInput) (req *request.Request, output *DeleteRoleAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteRoleAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/role-aliases/{roleAlias}",
	}

	if input == nil {
		input = &DeleteRoleAliasInput{}
	}

	output = &DeleteRoleAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRoleAlias API operation for AWS IoT.
//
// Deletes a role alias
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteRoleAlias for usage and error information.
//
// Returned Error Types:
//   * DeleteConflictException
//   You can't delete the resource because it is attached to one or more resources.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) DeleteRoleAlias(input *DeleteRoleAliasInput) (*DeleteRoleAliasOutput, error) {
	req, out := c.DeleteRoleAliasRequest(input)
	return out, req.Send()
}

// DeleteRoleAliasWithContext is the same as DeleteRoleAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoleAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteRoleAliasWithContext(ctx aws.Context, input *DeleteRoleAliasInput, opts ...request.Option) (*DeleteRoleAliasOutput, error) {
	req, out := c.DeleteRoleAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteScheduledAudit = "DeleteScheduledAudit"

// DeleteScheduledAuditRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScheduledAudit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteScheduledAudit for more information on using the DeleteScheduledAudit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteScheduledAuditRequest method.
//    req, resp := client.DeleteScheduledAuditRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteScheduledAuditRequest(input *DeleteScheduledAuditInput) (req *request.Request, output *DeleteScheduledAuditOutput) {
	op := &request.Operation{
		Name:       opDeleteScheduledAudit,
		HTTPMethod: "DELETE",
		HTTPPath:   "/audit/scheduledaudits/{scheduledAuditName}",
	}

	if input == nil {
		input = &DeleteScheduledAuditInput{}
	}

	output = &DeleteScheduledAuditOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteScheduledAudit API operation for AWS IoT.
//
// Deletes a scheduled audit.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteScheduledAudit for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DeleteScheduledAudit(input *DeleteScheduledAuditInput) (*DeleteScheduledAuditOutput, error) {
	req, out := c.DeleteScheduledAuditRequest(input)
	return out, req.Send()
}

// DeleteScheduledAuditWithContext is the same as DeleteScheduledAudit with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteScheduledAudit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteScheduledAuditWithContext(ctx aws.Context, input *DeleteScheduledAuditInput, opts ...request.Option) (*DeleteScheduledAuditOutput, error) {
	req, out := c.DeleteScheduledAuditRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSecurityProfile = "DeleteSecurityProfile"

// DeleteSecurityProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSecurityProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSecurityProfile for more information on using the DeleteSecurityProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSecurityProfileRequest method.
//    req, resp := client.DeleteSecurityProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteSecurityProfileRequest(input *DeleteSecurityProfileInput) (req *request.Request, output *DeleteSecurityProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteSecurityProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/security-profiles/{securityProfileName}",
	}

	if input == nil {
		input = &DeleteSecurityProfileInput{}
	}

	output = &DeleteSecurityProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSecurityProfile API operation for AWS IoT.
//
// Deletes a Device Defender security profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteSecurityProfile for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * VersionConflictException
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
func (c *IoT) DeleteSecurityProfile(input *DeleteSecurityProfileInput) (*DeleteSecurityProfileOutput, error) {
	req, out := c.DeleteSecurityProfileRequest(input)
	return out, req.Send()
}

// DeleteSecurityProfileWithContext is the same as DeleteSecurityProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSecurityProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteSecurityProfileWithContext(ctx aws.Context, input *DeleteSecurityProfileInput, opts ...request.Option) (*DeleteSecurityProfileOutput, error) {
	req, out := c.DeleteSecurityProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStream = "DeleteStream"

// DeleteStreamRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStream for more information on using the DeleteStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStreamRequest method.
//    req, resp := client.DeleteStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteStreamRequest(input *DeleteStreamInput) (req *request.Request, output *DeleteStreamOutput) {
	op := &request.Operation{
		Name:       opDeleteStream,
		HTTPMethod: "DELETE",
		HTTPPath:   "/streams/{streamId}",
	}

	if input == nil {
		input = &DeleteStreamInput{}
	}

	output = &DeleteStreamOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStream API operation for AWS IoT.
//
// Deletes a stream.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteStream for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * DeleteConflictException
//   You can't delete the resource because it is attached to one or more resources.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DeleteStream(input *DeleteStreamInput) (*DeleteStreamOutput, error) {
	req, out := c.DeleteStreamRequest(input)
	return out, req.Send()
}

// DeleteStreamWithContext is the same as DeleteStream with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteStreamWithContext(ctx aws.Context, input *DeleteStreamInput, opts ...request.Option) (*DeleteStreamOutput, error) {
	req, out := c.DeleteStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteThing = "DeleteThing"

// DeleteThingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteThing for more information on using the DeleteThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteThingRequest method.
//    req, resp := client.DeleteThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteThingRequest(input *DeleteThingInput) (req *request.Request, output *DeleteThingOutput) {
	op := &request.Operation{
		Name:       opDeleteThing,
		HTTPMethod: "DELETE",
		HTTPPath:   "/things/{thingName}",
	}

	if input == nil {
		input = &DeleteThingInput{}
	}

	output = &DeleteThingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteThing API operation for AWS IoT.
//
// Deletes the specified thing. Returns successfully with no error if the deletion
// is successful or you specify a thing that doesn't exist.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteThing for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * VersionConflictException
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DeleteThing(input *DeleteThingInput) (*DeleteThingOutput, error) {
	req, out := c.DeleteThingRequest(input)
	return out, req.Send()
}

// DeleteThingWithContext is the same as DeleteThing with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteThingWithContext(ctx aws.Context, input *DeleteThingInput, opts ...request.Option) (*DeleteThingOutput, error) {
	req, out := c.DeleteThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteThingGroup = "DeleteThingGroup"

// DeleteThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteThingGroup for more information on using the DeleteThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteThingGroupRequest method.
//    req, resp := client.DeleteThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteThingGroupRequest(input *DeleteThingGroupInput) (req *request.Request, output *DeleteThingGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteThingGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/thing-groups/{thingGroupName}",
	}

	if input == nil {
		input = &DeleteThingGroupInput{}
	}

	output = &DeleteThingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteThingGroup API operation for AWS IoT.
//
// Deletes a thing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteThingGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * VersionConflictException
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DeleteThingGroup(input *DeleteThingGroupInput) (*DeleteThingGroupOutput, error) {
	req, out := c.DeleteThingGroupRequest(input)
	return out, req.Send()
}

// DeleteThingGroupWithContext is the same as DeleteThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteThingGroupWithContext(ctx aws.Context, input *DeleteThingGroupInput, opts ...request.Option) (*DeleteThingGroupOutput, error) {
	req, out := c.DeleteThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteThingType = "DeleteThingType"

// DeleteThingTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteThingType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteThingType for more information on using the DeleteThingType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteThingTypeRequest method.
//    req, resp := client.DeleteThingTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteThingTypeRequest(input *DeleteThingTypeInput) (req *request.Request, output *DeleteThingTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteThingType,
		HTTPMethod: "DELETE",
		HTTPPath:   "/thing-types/{thingTypeName}",
	}

	if input == nil {
		input = &DeleteThingTypeInput{}
	}

	output = &DeleteThingTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteThingType API operation for AWS IoT.
//
// Deletes the specified thing type. You cannot delete a thing type if it has
// things associated with it. To delete a thing type, first mark it as deprecated
// by calling DeprecateThingType, then remove any associated things by calling
// UpdateThing to change the thing type on any associated thing, and finally
// use DeleteThingType to delete the thing type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteThingType for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DeleteThingType(input *DeleteThingTypeInput) (*DeleteThingTypeOutput, error) {
	req, out := c.DeleteThingTypeRequest(input)
	return out, req.Send()
}

// DeleteThingTypeWithContext is the same as DeleteThingType with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteThingType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteThingTypeWithContext(ctx aws.Context, input *DeleteThingTypeInput, opts ...request.Option) (*DeleteThingTypeOutput, error) {
	req, out := c.DeleteThingTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTopicRule = "DeleteTopicRule"

// DeleteTopicRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTopicRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTopicRule for more information on using the DeleteTopicRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTopicRuleRequest method.
//    req, resp := client.DeleteTopicRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteTopicRuleRequest(input *DeleteTopicRuleInput) (req *request.Request, output *DeleteTopicRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteTopicRule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/rules/{ruleName}",
	}

	if input == nil {
		input = &DeleteTopicRuleInput{}
	}

	output = &DeleteTopicRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTopicRule API operation for AWS IoT.
//
// Deletes the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteTopicRule for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ConflictingResourceUpdateException
//   A conflicting resource update exception. This exception is thrown when two
//   pending updates cause a conflict.
//
func (c *IoT) DeleteTopicRule(input *DeleteTopicRuleInput) (*DeleteTopicRuleOutput, error) {
	req, out := c.DeleteTopicRuleRequest(input)
	return out, req.Send()
}

// DeleteTopicRuleWithContext is the same as DeleteTopicRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTopicRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteTopicRuleWithContext(ctx aws.Context, input *DeleteTopicRuleInput, opts ...request.Option) (*DeleteTopicRuleOutput, error) {
	req, out := c.DeleteTopicRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTopicRuleDestination = "DeleteTopicRuleDestination"

// DeleteTopicRuleDestinationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTopicRuleDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTopicRuleDestination for more information on using the DeleteTopicRuleDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTopicRuleDestinationRequest method.
//    req, resp := client.DeleteTopicRuleDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteTopicRuleDestinationRequest(input *DeleteTopicRuleDestinationInput) (req *request.Request, output *DeleteTopicRuleDestinationOutput) {
	op := &request.Operation{
		Name:       opDeleteTopicRuleDestination,
		HTTPMethod: "DELETE",
		HTTPPath:   "/destinations/{arn+}",
	}

	if input == nil {
		input = &DeleteTopicRuleDestinationInput{}
	}

	output = &DeleteTopicRuleDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTopicRuleDestination API operation for AWS IoT.
//
// Deletes a topic rule destination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteTopicRuleDestination for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ConflictingResourceUpdateException
//   A conflicting resource update exception. This exception is thrown when two
//   pending updates cause a conflict.
//
func (c *IoT) DeleteTopicRuleDestination(input *DeleteTopicRuleDestinationInput) (*DeleteTopicRuleDestinationOutput, error) {
	req, out := c.DeleteTopicRuleDestinationRequest(input)
	return out, req.Send()
}

// DeleteTopicRuleDestinationWithContext is the same as DeleteTopicRuleDestination with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTopicRuleDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteTopicRuleDestinationWithContext(ctx aws.Context, input *DeleteTopicRuleDestinationInput, opts ...request.Option) (*DeleteTopicRuleDestinationOutput, error) {
	req, out := c.DeleteTopicRuleDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteV2LoggingLevel = "DeleteV2LoggingLevel"

// DeleteV2LoggingLevelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteV2LoggingLevel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteV2LoggingLevel for more information on using the DeleteV2LoggingLevel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteV2LoggingLevelRequest method.
//    req, resp := client.DeleteV2LoggingLevelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteV2LoggingLevelRequest(input *DeleteV2LoggingLevelInput) (req *request.Request, output *DeleteV2LoggingLevelOutput) {
	op := &request.Operation{
		Name:       opDeleteV2LoggingLevel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2LoggingLevel",
	}

	if input == nil {
		input = &DeleteV2LoggingLevelInput{}
	}

	output = &DeleteV2LoggingLevelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteV2LoggingLevel API operation for AWS IoT.
//
// Deletes a logging level.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteV2LoggingLevel for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) DeleteV2LoggingLevel(input *DeleteV2LoggingLevelInput) (*DeleteV2LoggingLevelOutput, error) {
	req, out := c.DeleteV2LoggingLevelRequest(input)
	return out, req.Send()
}

// DeleteV2LoggingLevelWithContext is the same as DeleteV2LoggingLevel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteV2LoggingLevel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteV2LoggingLevelWithContext(ctx aws.Context, input *DeleteV2LoggingLevelInput, opts ...request.Option) (*DeleteV2LoggingLevelOutput, error) {
	req, out := c.DeleteV2LoggingLevelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeprecateThingType = "DeprecateThingType"

// DeprecateThingTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeprecateThingType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeprecateThingType for more information on using the DeprecateThingType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeprecateThingTypeRequest method.
//    req, resp := client.DeprecateThingTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeprecateThingTypeRequest(input *DeprecateThingTypeInput) (req *request.Request, output *DeprecateThingTypeOutput) {
	op := &request.Operation{
		Name:       opDeprecateThingType,
		HTTPMethod: "POST",
		HTTPPath:   "/thing-types/{thingTypeName}/deprecate",
	}

	if input == nil {
		input = &DeprecateThingTypeInput{}
	}

	output = &DeprecateThingTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeprecateThingType API operation for AWS IoT.
//
// Deprecates a thing type. You can not associate new things with deprecated
// thing type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeprecateThingType for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DeprecateThingType(input *DeprecateThingTypeInput) (*DeprecateThingTypeOutput, error) {
	req, out := c.DeprecateThingTypeRequest(input)
	return out, req.Send()
}

// DeprecateThingTypeWithContext is the same as DeprecateThingType with the addition of
// the ability to pass a context and additional request options.
//
// See DeprecateThingType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeprecateThingTypeWithContext(ctx aws.Context, input *DeprecateThingTypeInput, opts ...request.Option) (*DeprecateThingTypeOutput, error) {
	req, out := c.DeprecateThingTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountAuditConfiguration = "DescribeAccountAuditConfiguration"

// DescribeAccountAuditConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountAuditConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountAuditConfiguration for more information on using the DescribeAccountAuditConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountAuditConfigurationRequest method.
//    req, resp := client.DescribeAccountAuditConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeAccountAuditConfigurationRequest(input *DescribeAccountAuditConfigurationInput) (req *request.Request, output *DescribeAccountAuditConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAuditConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/configuration",
	}

	if input == nil {
		input = &DescribeAccountAuditConfigurationInput{}
	}

	output = &DescribeAccountAuditConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountAuditConfiguration API operation for AWS IoT.
//
// Gets information about the Device Defender audit settings for this account.
// Settings include how audit notifications are sent and which audit checks
// are enabled or disabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeAccountAuditConfiguration for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DescribeAccountAuditConfiguration(input *DescribeAccountAuditConfigurationInput) (*DescribeAccountAuditConfigurationOutput, error) {
	req, out := c.DescribeAccountAuditConfigurationRequest(input)
	return out, req.Send()
}

// DescribeAccountAuditConfigurationWithContext is the same as DescribeAccountAuditConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountAuditConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeAccountAuditConfigurationWithContext(ctx aws.Context, input *DescribeAccountAuditConfigurationInput, opts ...request.Option) (*DescribeAccountAuditConfigurationOutput, error) {
	req, out := c.DescribeAccountAuditConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAuditFinding = "DescribeAuditFinding"

// DescribeAuditFindingRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAuditFinding operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAuditFinding for more information on using the DescribeAuditFinding
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAuditFindingRequest method.
//    req, resp := client.DescribeAuditFindingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeAuditFindingRequest(input *DescribeAuditFindingInput) (req *request.Request, output *DescribeAuditFindingOutput) {
	op := &request.Operation{
		Name:       opDescribeAuditFinding,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/findings/{findingId}",
	}

	if input == nil {
		input = &DescribeAuditFindingInput{}
	}

	output = &DescribeAuditFindingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAuditFinding API operation for AWS IoT.
//
// Gets information about a single audit finding. Properties include the reason
// for noncompliance, the severity of the issue, and when the audit that returned
// the finding was started.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeAuditFinding for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DescribeAuditFinding(input *DescribeAuditFindingInput) (*DescribeAuditFindingOutput, error) {
	req, out := c.DescribeAuditFindingRequest(input)
	return out, req.Send()
}

// DescribeAuditFindingWithContext is the same as DescribeAuditFinding with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAuditFinding for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeAuditFindingWithContext(ctx aws.Context, input *DescribeAuditFindingInput, opts ...request.Option) (*DescribeAuditFindingOutput, error) {
	req, out := c.DescribeAuditFindingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAuditMitigationActionsTask = "DescribeAuditMitigationActionsTask"

// DescribeAuditMitigationActionsTaskRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAuditMitigationActionsTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAuditMitigationActionsTask for more information on using the DescribeAuditMitigationActionsTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAuditMitigationActionsTaskRequest method.
//    req, resp := client.DescribeAuditMitigationActionsTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeAuditMitigationActionsTaskRequest(input *DescribeAuditMitigationActionsTaskInput) (req *request.Request, output *DescribeAuditMitigationActionsTaskOutput) {
	op := &request.Operation{
		Name:       opDescribeAuditMitigationActionsTask,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/mitigationactions/tasks/{taskId}",
	}

	if input == nil {
		input = &DescribeAuditMitigationActionsTaskInput{}
	}

	output = &DescribeAuditMitigationActionsTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAuditMitigationActionsTask API operation for AWS IoT.
//
// Gets information about an audit mitigation task that is used to apply mitigation
// actions to a set of audit findings. Properties include the actions being
// applied, the audit checks to which they're being applied, the task status,
// and aggregated task statistics.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeAuditMitigationActionsTask for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DescribeAuditMitigationActionsTask(input *DescribeAuditMitigationActionsTaskInput) (*DescribeAuditMitigationActionsTaskOutput, error) {
	req, out := c.DescribeAuditMitigationActionsTaskRequest(input)
	return out, req.Send()
}

// DescribeAuditMitigationActionsTaskWithContext is the same as DescribeAuditMitigationActionsTask with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAuditMitigationActionsTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeAuditMitigationActionsTaskWithContext(ctx aws.Context, input *DescribeAuditMitigationActionsTaskInput, opts ...request.Option) (*DescribeAuditMitigationActionsTaskOutput, error) {
	req, out := c.DescribeAuditMitigationActionsTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAuditTask = "DescribeAuditTask"

// DescribeAuditTaskRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAuditTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAuditTask for more information on using the DescribeAuditTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAuditTaskRequest method.
//    req, resp := client.DescribeAuditTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeAuditTaskRequest(input *DescribeAuditTaskInput) (req *request.Request, output *DescribeAuditTaskOutput) {
	op := &request.Operation{
		Name:       opDescribeAuditTask,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/tasks/{taskId}",
	}

	if input == nil {
		input = &DescribeAuditTaskInput{}
	}

	output = &DescribeAuditTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAuditTask API operation for AWS IoT.
//
// Gets information about a Device Defender audit.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeAuditTask for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DescribeAuditTask(input *DescribeAuditTaskInput) (*DescribeAuditTaskOutput, error) {
	req, out := c.DescribeAuditTaskRequest(input)
	return out, req.Send()
}

// DescribeAuditTaskWithContext is the same as DescribeAuditTask with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAuditTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeAuditTaskWithContext(ctx aws.Context, input *DescribeAuditTaskInput, opts ...request.Option) (*DescribeAuditTaskOutput, error) {
	req, out := c.DescribeAuditTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAuthorizer = "DescribeAuthorizer"

// DescribeAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAuthorizer for more information on using the DescribeAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAuthorizerRequest method.
//    req, resp := client.DescribeAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeAuthorizerRequest(input *DescribeAuthorizerInput) (req *request.Request, output *DescribeAuthorizerOutput) {
	op := &request.Operation{
		Name:       opDescribeAuthorizer,
		HTTPMethod: "GET",
		HTTPPath:   "/authorizer/{authorizerName}",
	}

	if input == nil {
		input = &DescribeAuthorizerInput{}
	}

	output = &DescribeAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAuthorizer API operation for AWS IoT.
//
// Describes an authorizer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeAuthorizer for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DescribeAuthorizer(input *DescribeAuthorizerInput) (*DescribeAuthorizerOutput, error) {
	req, out := c.DescribeAuthorizerRequest(input)
	return out, req.Send()
}

// DescribeAuthorizerWithContext is the same as DescribeAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeAuthorizerWithContext(ctx aws.Context, input *DescribeAuthorizerInput, opts ...request.Option) (*DescribeAuthorizerOutput, error) {
	req, out := c.DescribeAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBillingGroup = "DescribeBillingGroup"

// DescribeBillingGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBillingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBillingGroup for more information on using the DescribeBillingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBillingGroupRequest method.
//    req, resp := client.DescribeBillingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeBillingGroupRequest(input *DescribeBillingGroupInput) (req *request.Request, output *DescribeBillingGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeBillingGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/billing-groups/{billingGroupName}",
	}

	if input == nil {
		input = &DescribeBillingGroupInput{}
	}

	output = &DescribeBillingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBillingGroup API operation for AWS IoT.
//
// Returns information about a billing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeBillingGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) DescribeBillingGroup(input *DescribeBillingGroupInput) (*DescribeBillingGroupOutput, error) {
	req, out := c.DescribeBillingGroupRequest(input)
	return out, req.Send()
}

// DescribeBillingGroupWithContext is the same as DescribeBillingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBillingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeBillingGroupWithContext(ctx aws.Context, input *DescribeBillingGroupInput, opts ...request.Option) (*DescribeBillingGroupOutput, error) {
	req, out := c.DescribeBillingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCACertificate = "DescribeCACertificate"

// DescribeCACertificateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCACertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCACertificate for more information on using the DescribeCACertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCACertificateRequest method.
//    req, resp := client.DescribeCACertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeCACertificateRequest(input *DescribeCACertificateInput) (req *request.Request, output *DescribeCACertificateOutput) {
	op := &request.Operation{
		Name:       opDescribeCACertificate,
		HTTPMethod: "GET",
		HTTPPath:   "/cacertificate/{caCertificateId}",
	}

	if input == nil {
		input = &DescribeCACertificateInput{}
	}

	output = &DescribeCACertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCACertificate API operation for AWS IoT.
//
// Describes a registered CA certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeCACertificate for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) DescribeCACertificate(input *DescribeCACertificateInput) (*DescribeCACertificateOutput, error) {
	req, out := c.DescribeCACertificateRequest(input)
	return out, req.Send()
}

// DescribeCACertificateWithContext is the same as DescribeCACertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCACertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeCACertificateWithContext(ctx aws.Context, input *DescribeCACertificateInput, opts ...request.Option) (*DescribeCACertificateOutput, error) {
	req, out := c.DescribeCACertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCertificate = "DescribeCertificate"

// DescribeCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCertificate for more information on using the DescribeCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCertificateRequest method.
//    req, resp := client.DescribeCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeCertificateRequest(input *DescribeCertificateInput) (req *request.Request, output *DescribeCertificateOutput) {
	op := &request.Operation{
		Name:       opDescribeCertificate,
		HTTPMethod: "GET",
		HTTPPath:   "/certificates/{certificateId}",
	}

	if input == nil {
		input = &DescribeCertificateInput{}
	}

	output = &DescribeCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCertificate API operation for AWS IoT.
//
// Gets information about the specified certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeCertificate for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) DescribeCertificate(input *DescribeCertificateInput) (*DescribeCertificateOutput, error) {
	req, out := c.DescribeCertificateRequest(input)
	return out, req.Send()
}

// DescribeCertificateWithContext is the same as DescribeCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeCertificateWithContext(ctx aws.Context, input *DescribeCertificateInput, opts ...request.Option) (*DescribeCertificateOutput, error) {
	req, out := c.DescribeCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDefaultAuthorizer = "DescribeDefaultAuthorizer"

// DescribeDefaultAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDefaultAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDefaultAuthorizer for more information on using the DescribeDefaultAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDefaultAuthorizerRequest method.
//    req, resp := client.DescribeDefaultAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeDefaultAuthorizerRequest(input *DescribeDefaultAuthorizerInput) (req *request.Request, output *DescribeDefaultAuthorizerOutput) {
	op := &request.Operation{
		Name:       opDescribeDefaultAuthorizer,
		HTTPMethod: "GET",
		HTTPPath:   "/default-authorizer",
	}

	if input == nil {
		input = &DescribeDefaultAuthorizerInput{}
	}

	output = &DescribeDefaultAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDefaultAuthorizer API operation for AWS IoT.
//
// Describes the default authorizer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeDefaultAuthorizer for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DescribeDefaultAuthorizer(input *DescribeDefaultAuthorizerInput) (*DescribeDefaultAuthorizerOutput, error) {
	req, out := c.DescribeDefaultAuthorizerRequest(input)
	return out, req.Send()
}

// DescribeDefaultAuthorizerWithContext is the same as DescribeDefaultAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDefaultAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeDefaultAuthorizerWithContext(ctx aws.Context, input *DescribeDefaultAuthorizerInput, opts ...request.Option) (*DescribeDefaultAuthorizerOutput, error) {
	req, out := c.DescribeDefaultAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDimension = "DescribeDimension"

// DescribeDimensionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDimension operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDimension for more information on using the DescribeDimension
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDimensionRequest method.
//    req, resp := client.DescribeDimensionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeDimensionRequest(input *DescribeDimensionInput) (req *request.Request, output *DescribeDimensionOutput) {
	op := &request.Operation{
		Name:       opDescribeDimension,
		HTTPMethod: "GET",
		HTTPPath:   "/dimensions/{name}",
	}

	if input == nil {
		input = &DescribeDimensionInput{}
	}

	output = &DescribeDimensionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDimension API operation for AWS IoT.
//
// Provides details about a dimension that is defined in your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeDimension for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
func (c *IoT) DescribeDimension(input *DescribeDimensionInput) (*DescribeDimensionOutput, error) {
	req, out := c.DescribeDimensionRequest(input)
	return out, req.Send()
}

// DescribeDimensionWithContext is the same as DescribeDimension with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDimension for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeDimensionWithContext(ctx aws.Context, input *DescribeDimensionInput, opts ...request.Option) (*DescribeDimensionOutput, error) {
	req, out := c.DescribeDimensionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDomainConfiguration = "DescribeDomainConfiguration"

// DescribeDomainConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomainConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomainConfiguration for more information on using the DescribeDomainConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDomainConfigurationRequest method.
//    req, resp := client.DescribeDomainConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeDomainConfigurationRequest(input *DescribeDomainConfigurationInput) (req *request.Request, output *DescribeDomainConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeDomainConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/domainConfigurations/{domainConfigurationName}",
	}

	if input == nil {
		input = &DescribeDomainConfigurationInput{}
	}

	output = &DescribeDomainConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomainConfiguration API operation for AWS IoT.
//
// Gets summary information about a domain configuration.
//
// The domain configuration feature is in public preview and is subject to change.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeDomainConfiguration for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DescribeDomainConfiguration(input *DescribeDomainConfigurationInput) (*DescribeDomainConfigurationOutput, error) {
	req, out := c.DescribeDomainConfigurationRequest(input)
	return out, req.Send()
}

// DescribeDomainConfigurationWithContext is the same as DescribeDomainConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomainConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeDomainConfigurationWithContext(ctx aws.Context, input *DescribeDomainConfigurationInput, opts ...request.Option) (*DescribeDomainConfigurationOutput, error) {
	req, out := c.DescribeDomainConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEndpoint = "DescribeEndpoint"

// DescribeEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpoint for more information on using the DescribeEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEndpointRequest method.
//    req, resp := client.DescribeEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeEndpointRequest(input *DescribeEndpointInput) (req *request.Request, output *DescribeEndpointOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/endpoint",
	}

	if input == nil {
		input = &DescribeEndpointInput{}
	}

	output = &DescribeEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpoint API operation for AWS IoT.
//
// Returns a unique endpoint specific to the AWS account making the call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeEndpoint for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
func (c *IoT) DescribeEndpoint(input *DescribeEndpointInput) (*DescribeEndpointOutput, error) {
	req, out := c.DescribeEndpointRequest(input)
	return out, req.Send()
}

// DescribeEndpointWithContext is the same as DescribeEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeEndpointWithContext(ctx aws.Context, input *DescribeEndpointInput, opts ...request.Option) (*DescribeEndpointOutput, error) {
	req, out := c.DescribeEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEventConfigurations = "DescribeEventConfigurations"

// DescribeEventConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventConfigurations for more information on using the DescribeEventConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventConfigurationsRequest method.
//    req, resp := client.DescribeEventConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeEventConfigurationsRequest(input *DescribeEventConfigurationsInput) (req *request.Request, output *DescribeEventConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeEventConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/event-configurations",
	}

	if input == nil {
		input = &DescribeEventConfigurationsInput{}
	}

	output = &DescribeEventConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventConfigurations API operation for AWS IoT.
//
// Describes event configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeEventConfigurations for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
func (c *IoT) DescribeEventConfigurations(input *DescribeEventConfigurationsInput) (*DescribeEventConfigurationsOutput, error) {
	req, out := c.DescribeEventConfigurationsRequest(input)
	return out, req.Send()
}

// DescribeEventConfigurationsWithContext is the same as DescribeEventConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeEventConfigurationsWithContext(ctx aws.Context, input *DescribeEventConfigurationsInput, opts ...request.Option) (*DescribeEventConfigurationsOutput, error) {
	req, out := c.DescribeEventConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIndex = "DescribeIndex"

// DescribeIndexRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIndex for more information on using the DescribeIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIndexRequest method.
//    req, resp := client.DescribeIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeIndexRequest(input *DescribeIndexInput) (req *request.Request, output *DescribeIndexOutput) {
	op := &request.Operation{
		Name:       opDescribeIndex,
		HTTPMethod: "GET",
		HTTPPath:   "/indices/{indexName}",
	}

	if input == nil {
		input = &DescribeIndexInput{}
	}

	output = &DescribeIndexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIndex API operation for AWS IoT.
//
// Describes a search index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeIndex for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) DescribeIndex(input *DescribeIndexInput) (*DescribeIndexOutput, error) {
	req, out := c.DescribeIndexRequest(input)
	return out, req.Send()
}

// DescribeIndexWithContext is the same as DescribeIndex with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeIndexWithContext(ctx aws.Context, input *DescribeIndexInput, opts ...request.Option) (*DescribeIndexOutput, error) {
	req, out := c.DescribeIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJob = "DescribeJob"

// DescribeJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJob for more information on using the DescribeJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeJobRequest method.
//    req, resp := client.DescribeJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeJobRequest(input *DescribeJobInput) (req *request.Request, output *DescribeJobOutput) {
	op := &request.Operation{
		Name:       opDescribeJob,
		HTTPMethod: "GET",
		HTTPPath:   "/jobs/{jobId}",
	}

	if input == nil {
		input = &DescribeJobInput{}
	}

	output = &DescribeJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJob API operation for AWS IoT.
//
// Describes a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) DescribeJob(input *DescribeJobInput) (*DescribeJobOutput, error) {
	req, out := c.DescribeJobRequest(input)
	return out, req.Send()
}

// DescribeJobWithContext is the same as DescribeJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeJobWithContext(ctx aws.Context, input *DescribeJobInput, opts ...request.Option) (*DescribeJobOutput, error) {
	req, out := c.DescribeJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJobExecution = "DescribeJobExecution"

// DescribeJobExecutionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJobExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJobExecution for more information on using the DescribeJobExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeJobExecutionRequest method.
//    req, resp := client.DescribeJobExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeJobExecutionRequest(input *DescribeJobExecutionInput) (req *request.Request, output *DescribeJobExecutionOutput) {
	op := &request.Operation{
		Name:       opDescribeJobExecution,
		HTTPMethod: "GET",
		HTTPPath:   "/things/{thingName}/jobs/{jobId}",
	}

	if input == nil {
		input = &DescribeJobExecutionInput{}
	}

	output = &DescribeJobExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJobExecution API operation for AWS IoT.
//
// Describes a job execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeJobExecution for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) DescribeJobExecution(input *DescribeJobExecutionInput) (*DescribeJobExecutionOutput, error) {
	req, out := c.DescribeJobExecutionRequest(input)
	return out, req.Send()
}

// DescribeJobExecutionWithContext is the same as DescribeJobExecution with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJobExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeJobExecutionWithContext(ctx aws.Context, input *DescribeJobExecutionInput, opts ...request.Option) (*DescribeJobExecutionOutput, error) {
	req, out := c.DescribeJobExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMitigationAction = "DescribeMitigationAction"

// DescribeMitigationActionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMitigationAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMitigationAction for more information on using the DescribeMitigationAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMitigationActionRequest method.
//    req, resp := client.DescribeMitigationActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeMitigationActionRequest(input *DescribeMitigationActionInput) (req *request.Request, output *DescribeMitigationActionOutput) {
	op := &request.Operation{
		Name:       opDescribeMitigationAction,
		HTTPMethod: "GET",
		HTTPPath:   "/mitigationactions/actions/{actionName}",
	}

	if input == nil {
		input = &DescribeMitigationActionInput{}
	}

	output = &DescribeMitigationActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMitigationAction API operation for AWS IoT.
//
// Gets information about a mitigation action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeMitigationAction for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DescribeMitigationAction(input *DescribeMitigationActionInput) (*DescribeMitigationActionOutput, error) {
	req, out := c.DescribeMitigationActionRequest(input)
	return out, req.Send()
}

// DescribeMitigationActionWithContext is the same as DescribeMitigationAction with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMitigationAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeMitigationActionWithContext(ctx aws.Context, input *DescribeMitigationActionInput, opts ...request.Option) (*DescribeMitigationActionOutput, error) {
	req, out := c.DescribeMitigationActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProvisioningTemplate = "DescribeProvisioningTemplate"

// DescribeProvisioningTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProvisioningTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProvisioningTemplate for more information on using the DescribeProvisioningTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProvisioningTemplateRequest method.
//    req, resp := client.DescribeProvisioningTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeProvisioningTemplateRequest(input *DescribeProvisioningTemplateInput) (req *request.Request, output *DescribeProvisioningTemplateOutput) {
	op := &request.Operation{
		Name:       opDescribeProvisioningTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/provisioning-templates/{templateName}",
	}

	if input == nil {
		input = &DescribeProvisioningTemplateInput{}
	}

	output = &DescribeProvisioningTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProvisioningTemplate API operation for AWS IoT.
//
// Returns information about a fleet provisioning template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeProvisioningTemplate for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
func (c *IoT) DescribeProvisioningTemplate(input *DescribeProvisioningTemplateInput) (*DescribeProvisioningTemplateOutput, error) {
	req, out := c.DescribeProvisioningTemplateRequest(input)
	return out, req.Send()
}

// DescribeProvisioningTemplateWithContext is the same as DescribeProvisioningTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProvisioningTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeProvisioningTemplateWithContext(ctx aws.Context, input *DescribeProvisioningTemplateInput, opts ...request.Option) (*DescribeProvisioningTemplateOutput, error) {
	req, out := c.DescribeProvisioningTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProvisioningTemplateVersion = "DescribeProvisioningTemplateVersion"

// DescribeProvisioningTemplateVersionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProvisioningTemplateVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProvisioningTemplateVersion for more information on using the DescribeProvisioningTemplateVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProvisioningTemplateVersionRequest method.
//    req, resp := client.DescribeProvisioningTemplateVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeProvisioningTemplateVersionRequest(input *DescribeProvisioningTemplateVersionInput) (req *request.Request, output *DescribeProvisioningTemplateVersionOutput) {
	op := &request.Operation{
		Name:       opDescribeProvisioningTemplateVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/provisioning-templates/{templateName}/versions/{versionId}",
	}

	if input == nil {
		input = &DescribeProvisioningTemplateVersionInput{}
	}

	output = &DescribeProvisioningTemplateVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProvisioningTemplateVersion API operation for AWS IoT.
//
// Returns information about a fleet provisioning template version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeProvisioningTemplateVersion for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
func (c *IoT) DescribeProvisioningTemplateVersion(input *DescribeProvisioningTemplateVersionInput) (*DescribeProvisioningTemplateVersionOutput, error) {
	req, out := c.DescribeProvisioningTemplateVersionRequest(input)
	return out, req.Send()
}

// DescribeProvisioningTemplateVersionWithContext is the same as DescribeProvisioningTemplateVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProvisioningTemplateVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeProvisioningTemplateVersionWithContext(ctx aws.Context, input *DescribeProvisioningTemplateVersionInput, opts ...request.Option) (*DescribeProvisioningTemplateVersionOutput, error) {
	req, out := c.DescribeProvisioningTemplateVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRoleAlias = "DescribeRoleAlias"

// DescribeRoleAliasRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRoleAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRoleAlias for more information on using the DescribeRoleAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRoleAliasRequest method.
//    req, resp := client.DescribeRoleAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeRoleAliasRequest(input *DescribeRoleAliasInput) (req *request.Request, output *DescribeRoleAliasOutput) {
	op := &request.Operation{
		Name:       opDescribeRoleAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/role-aliases/{roleAlias}",
	}

	if input == nil {
		input = &DescribeRoleAliasInput{}
	}

	output = &DescribeRoleAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRoleAlias API operation for AWS IoT.
//
// Describes a role alias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeRoleAlias for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) DescribeRoleAlias(input *DescribeRoleAliasInput) (*DescribeRoleAliasOutput, error) {
	req, out := c.DescribeRoleAliasRequest(input)
	return out, req.Send()
}

// DescribeRoleAliasWithContext is the same as DescribeRoleAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRoleAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeRoleAliasWithContext(ctx aws.Context, input *DescribeRoleAliasInput, opts ...request.Option) (*DescribeRoleAliasOutput, error) {
	req, out := c.DescribeRoleAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeScheduledAudit = "DescribeScheduledAudit"

// DescribeScheduledAuditRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScheduledAudit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScheduledAudit for more information on using the DescribeScheduledAudit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScheduledAuditRequest method.
//    req, resp := client.DescribeScheduledAuditRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeScheduledAuditRequest(input *DescribeScheduledAuditInput) (req *request.Request, output *DescribeScheduledAuditOutput) {
	op := &request.Operation{
		Name:       opDescribeScheduledAudit,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/scheduledaudits/{scheduledAuditName}",
	}

	if input == nil {
		input = &DescribeScheduledAuditInput{}
	}

	output = &DescribeScheduledAuditOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScheduledAudit API operation for AWS IoT.
//
// Gets information about a scheduled audit.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeScheduledAudit for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DescribeScheduledAudit(input *DescribeScheduledAuditInput) (*DescribeScheduledAuditOutput, error) {
	req, out := c.DescribeScheduledAuditRequest(input)
	return out, req.Send()
}

// DescribeScheduledAuditWithContext is the same as DescribeScheduledAudit with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScheduledAudit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeScheduledAuditWithContext(ctx aws.Context, input *DescribeScheduledAuditInput, opts ...request.Option) (*DescribeScheduledAuditOutput, error) {
	req, out := c.DescribeScheduledAuditRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSecurityProfile = "DescribeSecurityProfile"

// DescribeSecurityProfileRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSecurityProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSecurityProfile for more information on using the DescribeSecurityProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSecurityProfileRequest method.
//    req, resp := client.DescribeSecurityProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeSecurityProfileRequest(input *DescribeSecurityProfileInput) (req *request.Request, output *DescribeSecurityProfileOutput) {
	op := &request.Operation{
		Name:       opDescribeSecurityProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/security-profiles/{securityProfileName}",
	}

	if input == nil {
		input = &DescribeSecurityProfileInput{}
	}

	output = &DescribeSecurityProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSecurityProfile API operation for AWS IoT.
//
// Gets information about a Device Defender security profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeSecurityProfile for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DescribeSecurityProfile(input *DescribeSecurityProfileInput) (*DescribeSecurityProfileOutput, error) {
	req, out := c.DescribeSecurityProfileRequest(input)
	return out, req.Send()
}

// DescribeSecurityProfileWithContext is the same as DescribeSecurityProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSecurityProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeSecurityProfileWithContext(ctx aws.Context, input *DescribeSecurityProfileInput, opts ...request.Option) (*DescribeSecurityProfileOutput, error) {
	req, out := c.DescribeSecurityProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStream = "DescribeStream"

// DescribeStreamRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStream for more information on using the DescribeStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStreamRequest method.
//    req, resp := client.DescribeStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeStreamRequest(input *DescribeStreamInput) (req *request.Request, output *DescribeStreamOutput) {
	op := &request.Operation{
		Name:       opDescribeStream,
		HTTPMethod: "GET",
		HTTPPath:   "/streams/{streamId}",
	}

	if input == nil {
		input = &DescribeStreamInput{}
	}

	output = &DescribeStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStream API operation for AWS IoT.
//
// Gets information about a stream.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeStream for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DescribeStream(input *DescribeStreamInput) (*DescribeStreamOutput, error) {
	req, out := c.DescribeStreamRequest(input)
	return out, req.Send()
}

// DescribeStreamWithContext is the same as DescribeStream with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeStreamWithContext(ctx aws.Context, input *DescribeStreamInput, opts ...request.Option) (*DescribeStreamOutput, error) {
	req, out := c.DescribeStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeThing = "DescribeThing"

// DescribeThingRequest generates a "aws/request.Request" representing the
// client's request for the DescribeThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeThing for more information on using the DescribeThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeThingRequest method.
//    req, resp := client.DescribeThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeThingRequest(input *DescribeThingInput) (req *request.Request, output *DescribeThingOutput) {
	op := &request.Operation{
		Name:       opDescribeThing,
		HTTPMethod: "GET",
		HTTPPath:   "/things/{thingName}",
	}

	if input == nil {
		input = &DescribeThingInput{}
	}

	output = &DescribeThingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeThing API operation for AWS IoT.
//
// Gets information about the specified thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeThing for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DescribeThing(input *DescribeThingInput) (*DescribeThingOutput, error) {
	req, out := c.DescribeThingRequest(input)
	return out, req.Send()
}

// DescribeThingWithContext is the same as DescribeThing with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeThingWithContext(ctx aws.Context, input *DescribeThingInput, opts ...request.Option) (*DescribeThingOutput, error) {
	req, out := c.DescribeThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeThingGroup = "DescribeThingGroup"

// DescribeThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeThingGroup for more information on using the DescribeThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeThingGroupRequest method.
//    req, resp := client.DescribeThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeThingGroupRequest(input *DescribeThingGroupInput) (req *request.Request, output *DescribeThingGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeThingGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-groups/{thingGroupName}",
	}

	if input == nil {
		input = &DescribeThingGroupInput{}
	}

	output = &DescribeThingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeThingGroup API operation for AWS IoT.
//
// Describe a thing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeThingGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) DescribeThingGroup(input *DescribeThingGroupInput) (*DescribeThingGroupOutput, error) {
	req, out := c.DescribeThingGroupRequest(input)
	return out, req.Send()
}

// DescribeThingGroupWithContext is the same as DescribeThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeThingGroupWithContext(ctx aws.Context, input *DescribeThingGroupInput, opts ...request.Option) (*DescribeThingGroupOutput, error) {
	req, out := c.DescribeThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeThingRegistrationTask = "DescribeThingRegistrationTask"

// DescribeThingRegistrationTaskRequest generates a "aws/request.Request" representing the
// client's request for the DescribeThingRegistrationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeThingRegistrationTask for more information on using the DescribeThingRegistrationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeThingRegistrationTaskRequest method.
//    req, resp := client.DescribeThingRegistrationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeThingRegistrationTaskRequest(input *DescribeThingRegistrationTaskInput) (req *request.Request, output *DescribeThingRegistrationTaskOutput) {
	op := &request.Operation{
		Name:       opDescribeThingRegistrationTask,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-registration-tasks/{taskId}",
	}

	if input == nil {
		input = &DescribeThingRegistrationTaskInput{}
	}

	output = &DescribeThingRegistrationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeThingRegistrationTask API operation for AWS IoT.
//
// Describes a bulk thing provisioning task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeThingRegistrationTask for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) DescribeThingRegistrationTask(input *DescribeThingRegistrationTaskInput) (*DescribeThingRegistrationTaskOutput, error) {
	req, out := c.DescribeThingRegistrationTaskRequest(input)
	return out, req.Send()
}

// DescribeThingRegistrationTaskWithContext is the same as DescribeThingRegistrationTask with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeThingRegistrationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeThingRegistrationTaskWithContext(ctx aws.Context, input *DescribeThingRegistrationTaskInput, opts ...request.Option) (*DescribeThingRegistrationTaskOutput, error) {
	req, out := c.DescribeThingRegistrationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeThingType = "DescribeThingType"

// DescribeThingTypeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeThingType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeThingType for more information on using the DescribeThingType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeThingTypeRequest method.
//    req, resp := client.DescribeThingTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeThingTypeRequest(input *DescribeThingTypeInput) (req *request.Request, output *DescribeThingTypeOutput) {
	op := &request.Operation{
		Name:       opDescribeThingType,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-types/{thingTypeName}",
	}

	if input == nil {
		input = &DescribeThingTypeInput{}
	}

	output = &DescribeThingTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeThingType API operation for AWS IoT.
//
// Gets information about the specified thing type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeThingType for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DescribeThingType(input *DescribeThingTypeInput) (*DescribeThingTypeOutput, error) {
	req, out := c.DescribeThingTypeRequest(input)
	return out, req.Send()
}

// DescribeThingTypeWithContext is the same as DescribeThingType with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeThingType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeThingTypeWithContext(ctx aws.Context, input *DescribeThingTypeInput, opts ...request.Option) (*DescribeThingTypeOutput, error) {
	req, out := c.DescribeThingTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachPolicy = "DetachPolicy"

// DetachPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DetachPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachPolicy for more information on using the DetachPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachPolicyRequest method.
//    req, resp := client.DetachPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DetachPolicyRequest(input *DetachPolicyInput) (req *request.Request, output *DetachPolicyOutput) {
	op := &request.Operation{
		Name:       opDetachPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/target-policies/{policyName}",
	}

	if input == nil {
		input = &DetachPolicyInput{}
	}

	output = &DetachPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachPolicy API operation for AWS IoT.
//
// Detaches a policy from the specified target.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DetachPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
func (c *IoT) DetachPolicy(input *DetachPolicyInput) (*DetachPolicyOutput, error) {
	req, out := c.DetachPolicyRequest(input)
	return out, req.Send()
}

// DetachPolicyWithContext is the same as DetachPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DetachPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DetachPolicyWithContext(ctx aws.Context, input *DetachPolicyInput, opts ...request.Option) (*DetachPolicyOutput, error) {
	req, out := c.DetachPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachPrincipalPolicy = "DetachPrincipalPolicy"

// DetachPrincipalPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DetachPrincipalPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachPrincipalPolicy for more information on using the DetachPrincipalPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachPrincipalPolicyRequest method.
//    req, resp := client.DetachPrincipalPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Deprecated: DetachPrincipalPolicy has been deprecated
func (c *IoT) DetachPrincipalPolicyRequest(input *DetachPrincipalPolicyInput) (req *request.Request, output *DetachPrincipalPolicyOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DetachPrincipalPolicy, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDetachPrincipalPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/principal-policies/{policyName}",
	}

	if input == nil {
		input = &DetachPrincipalPolicyInput{}
	}

	output = &DetachPrincipalPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachPrincipalPolicy API operation for AWS IoT.
//
// Removes the specified policy from the specified certificate.
//
// Note: This API is deprecated. Please use DetachPolicy instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DetachPrincipalPolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//
// Deprecated: DetachPrincipalPolicy has been deprecated
func (c *IoT) DetachPrincipalPolicy(input *DetachPrincipalPolicyInput) (*DetachPrincipalPolicyOutput, error) {
	req, out := c.DetachPrincipalPolicyRequest(input)
	return out, req.Send()
}

// DetachPrincipalPolicyWithContext is the same as DetachPrincipalPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DetachPrincipalPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: DetachPrincipalPolicyWithContext has been deprecated
func (c *IoT) DetachPrincipalPolicyWithContext(ctx aws.Context, input *DetachPrincipalPolicyInput, opts ...request.Option) (*DetachPrincipalPolicyOutput, error) {
	req, out := c.DetachPrincipalPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachSecurityProfile = "DetachSecurityProfile"

// DetachSecurityProfileRequest generates a "aws/request.Request" representing the
// client's request for the DetachSecurityProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachSecurityProfile for more information on using the DetachSecurityProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachSecurityProfileRequest method.
//    req, resp := client.DetachSecurityProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DetachSecurityProfileRequest(input *DetachSecurityProfileInput) (req *request.Request, output *DetachSecurityProfileOutput) {
	op := &request.Operation{
		Name:       opDetachSecurityProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/security-profiles/{securityProfileName}/targets",
	}

	if input == nil {
		input = &DetachSecurityProfileInput{}
	}

	output = &DetachSecurityProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachSecurityProfile API operation for AWS IoT.
//
// Disassociates a Device Defender security profile from a thing group or from
// this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DetachSecurityProfile for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DetachSecurityProfile(input *DetachSecurityProfileInput) (*DetachSecurityProfileOutput, error) {
	req, out := c.DetachSecurityProfileRequest(input)
	return out, req.Send()
}

// DetachSecurityProfileWithContext is the same as DetachSecurityProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DetachSecurityProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DetachSecurityProfileWithContext(ctx aws.Context, input *DetachSecurityProfileInput, opts ...request.Option) (*DetachSecurityProfileOutput, error) {
	req, out := c.DetachSecurityProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachThingPrincipal = "DetachThingPrincipal"

// DetachThingPrincipalRequest generates a "aws/request.Request" representing the
// client's request for the DetachThingPrincipal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachThingPrincipal for more information on using the DetachThingPrincipal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachThingPrincipalRequest method.
//    req, resp := client.DetachThingPrincipalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DetachThingPrincipalRequest(input *DetachThingPrincipalInput) (req *request.Request, output *DetachThingPrincipalOutput) {
	op := &request.Operation{
		Name:       opDetachThingPrincipal,
		HTTPMethod: "DELETE",
		HTTPPath:   "/things/{thingName}/principals",
	}

	if input == nil {
		input = &DetachThingPrincipalInput{}
	}

	output = &DetachThingPrincipalOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachThingPrincipal API operation for AWS IoT.
//
// Detaches the specified principal from the specified thing. A principal can
// be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities
// or federated identities.
//
// This call is asynchronous. It might take several seconds for the detachment
// to propagate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DetachThingPrincipal for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) DetachThingPrincipal(input *DetachThingPrincipalInput) (*DetachThingPrincipalOutput, error) {
	req, out := c.DetachThingPrincipalRequest(input)
	return out, req.Send()
}

// DetachThingPrincipalWithContext is the same as DetachThingPrincipal with the addition of
// the ability to pass a context and additional request options.
//
// See DetachThingPrincipal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DetachThingPrincipalWithContext(ctx aws.Context, input *DetachThingPrincipalInput, opts ...request.Option) (*DetachThingPrincipalOutput, error) {
	req, out := c.DetachThingPrincipalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableTopicRule = "DisableTopicRule"

// DisableTopicRuleRequest generates a "aws/request.Request" representing the
// client's request for the DisableTopicRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableTopicRule for more information on using the DisableTopicRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableTopicRuleRequest method.
//    req, resp := client.DisableTopicRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DisableTopicRuleRequest(input *DisableTopicRuleInput) (req *request.Request, output *DisableTopicRuleOutput) {
	op := &request.Operation{
		Name:       opDisableTopicRule,
		HTTPMethod: "POST",
		HTTPPath:   "/rules/{ruleName}/disable",
	}

	if input == nil {
		input = &DisableTopicRuleInput{}
	}

	output = &DisableTopicRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableTopicRule API operation for AWS IoT.
//
// Disables the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DisableTopicRule for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ConflictingResourceUpdateException
//   A conflicting resource update exception. This exception is thrown when two
//   pending updates cause a conflict.
//
func (c *IoT) DisableTopicRule(input *DisableTopicRuleInput) (*DisableTopicRuleOutput, error) {
	req, out := c.DisableTopicRuleRequest(input)
	return out, req.Send()
}

// DisableTopicRuleWithContext is the same as DisableTopicRule with the addition of
// the ability to pass a context and additional request options.
//
// See DisableTopicRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DisableTopicRuleWithContext(ctx aws.Context, input *DisableTopicRuleInput, opts ...request.Option) (*DisableTopicRuleOutput, error) {
	req, out := c.DisableTopicRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableTopicRule = "EnableTopicRule"

// EnableTopicRuleRequest generates a "aws/request.Request" representing the
// client's request for the EnableTopicRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableTopicRule for more information on using the EnableTopicRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableTopicRuleRequest method.
//    req, resp := client.EnableTopicRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) EnableTopicRuleRequest(input *EnableTopicRuleInput) (req *request.Request, output *EnableTopicRuleOutput) {
	op := &request.Operation{
		Name:       opEnableTopicRule,
		HTTPMethod: "POST",
		HTTPPath:   "/rules/{ruleName}/enable",
	}

	if input == nil {
		input = &EnableTopicRuleInput{}
	}

	output = &EnableTopicRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableTopicRule API operation for AWS IoT.
//
// Enables the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation EnableTopicRule for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ConflictingResourceUpdateException
//   A conflicting resource update exception. This exception is thrown when two
//   pending updates cause a conflict.
//
func (c *IoT) EnableTopicRule(input *EnableTopicRuleInput) (*EnableTopicRuleOutput, error) {
	req, out := c.EnableTopicRuleRequest(input)
	return out, req.Send()
}

// EnableTopicRuleWithContext is the same as EnableTopicRule with the addition of
// the ability to pass a context and additional request options.
//
// See EnableTopicRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) EnableTopicRuleWithContext(ctx aws.Context, input *EnableTopicRuleInput, opts ...request.Option) (*EnableTopicRuleOutput, error) {
	req, out := c.EnableTopicRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCardinality = "GetCardinality"

// GetCardinalityRequest generates a "aws/request.Request" representing the
// client's request for the GetCardinality operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCardinality for more information on using the GetCardinality
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCardinalityRequest method.
//    req, resp := client.GetCardinalityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetCardinalityRequest(input *GetCardinalityInput) (req *request.Request, output *GetCardinalityOutput) {
	op := &request.Operation{
		Name:       opGetCardinality,
		HTTPMethod: "POST",
		HTTPPath:   "/indices/cardinality",
	}

	if input == nil {
		input = &GetCardinalityInput{}
	}

	output = &GetCardinalityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCardinality API operation for AWS IoT.
//
// Returns the approximate count of unique values that match the query.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetCardinality for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidQueryException
//   The query is invalid.
//
//   * InvalidAggregationException
//   The aggregation is invalid.
//
//   * IndexNotReadyException
//   The index is not ready.
//
func (c *IoT) GetCardinality(input *GetCardinalityInput) (*GetCardinalityOutput, error) {
	req, out := c.GetCardinalityRequest(input)
	return out, req.Send()
}

// GetCardinalityWithContext is the same as GetCardinality with the addition of
// the ability to pass a context and additional request options.
//
// See GetCardinality for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetCardinalityWithContext(ctx aws.Context, input *GetCardinalityInput, opts ...request.Option) (*GetCardinalityOutput, error) {
	req, out := c.GetCardinalityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEffectivePolicies = "GetEffectivePolicies"

// GetEffectivePoliciesRequest generates a "aws/request.Request" representing the
// client's request for the GetEffectivePolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEffectivePolicies for more information on using the GetEffectivePolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEffectivePoliciesRequest method.
//    req, resp := client.GetEffectivePoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetEffectivePoliciesRequest(input *GetEffectivePoliciesInput) (req *request.Request, output *GetEffectivePoliciesOutput) {
	op := &request.Operation{
		Name:       opGetEffectivePolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/effective-policies",
	}

	if input == nil {
		input = &GetEffectivePoliciesInput{}
	}

	output = &GetEffectivePoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEffectivePolicies API operation for AWS IoT.
//
// Gets a list of the policies that have an effect on the authorization behavior
// of the specified device when it connects to the AWS IoT device gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetEffectivePolicies for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
func (c *IoT) GetEffectivePolicies(input *GetEffectivePoliciesInput) (*GetEffectivePoliciesOutput, error) {
	req, out := c.GetEffectivePoliciesRequest(input)
	return out, req.Send()
}

// GetEffectivePoliciesWithContext is the same as GetEffectivePolicies with the addition of
// the ability to pass a context and additional request options.
//
// See GetEffectivePolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetEffectivePoliciesWithContext(ctx aws.Context, input *GetEffectivePoliciesInput, opts ...request.Option) (*GetEffectivePoliciesOutput, error) {
	req, out := c.GetEffectivePoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIndexingConfiguration = "GetIndexingConfiguration"

// GetIndexingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetIndexingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIndexingConfiguration for more information on using the GetIndexingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIndexingConfigurationRequest method.
//    req, resp := client.GetIndexingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetIndexingConfigurationRequest(input *GetIndexingConfigurationInput) (req *request.Request, output *GetIndexingConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetIndexingConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/indexing/config",
	}

	if input == nil {
		input = &GetIndexingConfigurationInput{}
	}

	output = &GetIndexingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIndexingConfiguration API operation for AWS IoT.
//
// Gets the indexing configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetIndexingConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) GetIndexingConfiguration(input *GetIndexingConfigurationInput) (*GetIndexingConfigurationOutput, error) {
	req, out := c.GetIndexingConfigurationRequest(input)
	return out, req.Send()
}

// GetIndexingConfigurationWithContext is the same as GetIndexingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetIndexingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetIndexingConfigurationWithContext(ctx aws.Context, input *GetIndexingConfigurationInput, opts ...request.Option) (*GetIndexingConfigurationOutput, error) {
	req, out := c.GetIndexingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJobDocument = "GetJobDocument"

// GetJobDocumentRequest generates a "aws/request.Request" representing the
// client's request for the GetJobDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobDocument for more information on using the GetJobDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJobDocumentRequest method.
//    req, resp := client.GetJobDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetJobDocumentRequest(input *GetJobDocumentInput) (req *request.Request, output *GetJobDocumentOutput) {
	op := &request.Operation{
		Name:       opGetJobDocument,
		HTTPMethod: "GET",
		HTTPPath:   "/jobs/{jobId}/job-document",
	}

	if input == nil {
		input = &GetJobDocumentInput{}
	}

	output = &GetJobDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJobDocument API operation for AWS IoT.
//
// Gets a job document.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetJobDocument for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) GetJobDocument(input *GetJobDocumentInput) (*GetJobDocumentOutput, error) {
	req, out := c.GetJobDocumentRequest(input)
	return out, req.Send()
}

// GetJobDocumentWithContext is the same as GetJobDocument with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetJobDocumentWithContext(ctx aws.Context, input *GetJobDocumentInput, opts ...request.Option) (*GetJobDocumentOutput, error) {
	req, out := c.GetJobDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoggingOptions = "GetLoggingOptions"

// GetLoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the GetLoggingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLoggingOptions for more information on using the GetLoggingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLoggingOptionsRequest method.
//    req, resp := client.GetLoggingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetLoggingOptionsRequest(input *GetLoggingOptionsInput) (req *request.Request, output *GetLoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opGetLoggingOptions,
		HTTPMethod: "GET",
		HTTPPath:   "/loggingOptions",
	}

	if input == nil {
		input = &GetLoggingOptionsInput{}
	}

	output = &GetLoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoggingOptions API operation for AWS IoT.
//
// Gets the logging options.
//
// NOTE: use of this command is not recommended. Use GetV2LoggingOptions instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetLoggingOptions for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) GetLoggingOptions(input *GetLoggingOptionsInput) (*GetLoggingOptionsOutput, error) {
	req, out := c.GetLoggingOptionsRequest(input)
	return out, req.Send()
}

// GetLoggingOptionsWithContext is the same as GetLoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetLoggingOptionsWithContext(ctx aws.Context, input *GetLoggingOptionsInput, opts ...request.Option) (*GetLoggingOptionsOutput, error) {
	req, out := c.GetLoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOTAUpdate = "GetOTAUpdate"

// GetOTAUpdateRequest generates a "aws/request.Request" representing the
// client's request for the GetOTAUpdate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOTAUpdate for more information on using the GetOTAUpdate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOTAUpdateRequest method.
//    req, resp := client.GetOTAUpdateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetOTAUpdateRequest(input *GetOTAUpdateInput) (req *request.Request, output *GetOTAUpdateOutput) {
	op := &request.Operation{
		Name:       opGetOTAUpdate,
		HTTPMethod: "GET",
		HTTPPath:   "/otaUpdates/{otaUpdateId}",
	}

	if input == nil {
		input = &GetOTAUpdateInput{}
	}

	output = &GetOTAUpdateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOTAUpdate API operation for AWS IoT.
//
// Gets an OTA update.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetOTAUpdate for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) GetOTAUpdate(input *GetOTAUpdateInput) (*GetOTAUpdateOutput, error) {
	req, out := c.GetOTAUpdateRequest(input)
	return out, req.Send()
}

// GetOTAUpdateWithContext is the same as GetOTAUpdate with the addition of
// the ability to pass a context and additional request options.
//
// See GetOTAUpdate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetOTAUpdateWithContext(ctx aws.Context, input *GetOTAUpdateInput, opts ...request.Option) (*GetOTAUpdateOutput, error) {
	req, out := c.GetOTAUpdateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPercentiles = "GetPercentiles"

// GetPercentilesRequest generates a "aws/request.Request" representing the
// client's request for the GetPercentiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPercentiles for more information on using the GetPercentiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPercentilesRequest method.
//    req, resp := client.GetPercentilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetPercentilesRequest(input *GetPercentilesInput) (req *request.Request, output *GetPercentilesOutput) {
	op := &request.Operation{
		Name:       opGetPercentiles,
		HTTPMethod: "POST",
		HTTPPath:   "/indices/percentiles",
	}

	if input == nil {
		input = &GetPercentilesInput{}
	}

	output = &GetPercentilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPercentiles API operation for AWS IoT.
//
// Groups the aggregated values that match the query into percentile groupings.
// The default percentile groupings are: 1,5,25,50,75,95,99, although you can
// specify your own when you call GetPercentiles. This function returns a value
// for each percentile group specified (or the default percentile groupings).
// The percentile group "1" contains the aggregated field value that occurs
// in approximately one percent of the values that match the query. The percentile
// group "5" contains the aggregated field value that occurs in approximately
// five percent of the values that match the query, and so on. The result is
// an approximation, the more values that match the query, the more accurate
// the percentile values.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetPercentiles for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidQueryException
//   The query is invalid.
//
//   * InvalidAggregationException
//   The aggregation is invalid.
//
//   * IndexNotReadyException
//   The index is not ready.
//
func (c *IoT) GetPercentiles(input *GetPercentilesInput) (*GetPercentilesOutput, error) {
	req, out := c.GetPercentilesRequest(input)
	return out, req.Send()
}

// GetPercentilesWithContext is the same as GetPercentiles with the addition of
// the ability to pass a context and additional request options.
//
// See GetPercentiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetPercentilesWithContext(ctx aws.Context, input *GetPercentilesInput, opts ...request.Option) (*GetPercentilesOutput, error) {
	req, out := c.GetPercentilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPolicy for more information on using the GetPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPolicyRequest method.
//    req, resp := client.GetPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetPolicyRequest(input *GetPolicyInput) (req *request.Request, output *GetPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/policies/{policyName}",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	output = &GetPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPolicy API operation for AWS IoT.
//
// Gets information about the specified policy with the policy document of the
// default version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetPolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) GetPolicy(input *GetPolicyInput) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	return out, req.Send()
}

// GetPolicyWithContext is the same as GetPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetPolicyWithContext(ctx aws.Context, input *GetPolicyInput, opts ...request.Option) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPolicyVersion = "GetPolicyVersion"

// GetPolicyVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetPolicyVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPolicyVersion for more information on using the GetPolicyVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPolicyVersionRequest method.
//    req, resp := client.GetPolicyVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetPolicyVersionRequest(input *GetPolicyVersionInput) (req *request.Request, output *GetPolicyVersionOutput) {
	op := &request.Operation{
		Name:       opGetPolicyVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/policies/{policyName}/version/{policyVersionId}",
	}

	if input == nil {
		input = &GetPolicyVersionInput{}
	}

	output = &GetPolicyVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPolicyVersion API operation for AWS IoT.
//
// Gets information about the specified policy version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetPolicyVersion for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) GetPolicyVersion(input *GetPolicyVersionInput) (*GetPolicyVersionOutput, error) {
	req, out := c.GetPolicyVersionRequest(input)
	return out, req.Send()
}

// GetPolicyVersionWithContext is the same as GetPolicyVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetPolicyVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetPolicyVersionWithContext(ctx aws.Context, input *GetPolicyVersionInput, opts ...request.Option) (*GetPolicyVersionOutput, error) {
	req, out := c.GetPolicyVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRegistrationCode = "GetRegistrationCode"

// GetRegistrationCodeRequest generates a "aws/request.Request" representing the
// client's request for the GetRegistrationCode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRegistrationCode for more information on using the GetRegistrationCode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRegistrationCodeRequest method.
//    req, resp := client.GetRegistrationCodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetRegistrationCodeRequest(input *GetRegistrationCodeInput) (req *request.Request, output *GetRegistrationCodeOutput) {
	op := &request.Operation{
		Name:       opGetRegistrationCode,
		HTTPMethod: "GET",
		HTTPPath:   "/registrationcode",
	}

	if input == nil {
		input = &GetRegistrationCodeInput{}
	}

	output = &GetRegistrationCodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRegistrationCode API operation for AWS IoT.
//
// Gets a registration code used to register a CA certificate with AWS IoT.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetRegistrationCode for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
func (c *IoT) GetRegistrationCode(input *GetRegistrationCodeInput) (*GetRegistrationCodeOutput, error) {
	req, out := c.GetRegistrationCodeRequest(input)
	return out, req.Send()
}

// GetRegistrationCodeWithContext is the same as GetRegistrationCode with the addition of
// the ability to pass a context and additional request options.
//
// See GetRegistrationCode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetRegistrationCodeWithContext(ctx aws.Context, input *GetRegistrationCodeInput, opts ...request.Option) (*GetRegistrationCodeOutput, error) {
	req, out := c.GetRegistrationCodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStatistics = "GetStatistics"

// GetStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the GetStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStatistics for more information on using the GetStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStatisticsRequest method.
//    req, resp := client.GetStatisticsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetStatisticsRequest(input *GetStatisticsInput) (req *request.Request, output *GetStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/indices/statistics",
	}

	if input == nil {
		input = &GetStatisticsInput{}
	}

	output = &GetStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStatistics API operation for AWS IoT.
//
// Returns the count, average, sum, minimum, maximum, sum of squares, variance,
// and standard deviation for the specified aggregated field. If the aggregation
// field is of type String, only the count statistic is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetStatistics for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidQueryException
//   The query is invalid.
//
//   * InvalidAggregationException
//   The aggregation is invalid.
//
//   * IndexNotReadyException
//   The index is not ready.
//
func (c *IoT) GetStatistics(input *GetStatisticsInput) (*GetStatisticsOutput, error) {
	req, out := c.GetStatisticsRequest(input)
	return out, req.Send()
}

// GetStatisticsWithContext is the same as GetStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See GetStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetStatisticsWithContext(ctx aws.Context, input *GetStatisticsInput, opts ...request.Option) (*GetStatisticsOutput, error) {
	req, out := c.GetStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTopicRule = "GetTopicRule"

// GetTopicRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetTopicRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTopicRule for more information on using the GetTopicRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTopicRuleRequest method.
//    req, resp := client.GetTopicRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetTopicRuleRequest(input *GetTopicRuleInput) (req *request.Request, output *GetTopicRuleOutput) {
	op := &request.Operation{
		Name:       opGetTopicRule,
		HTTPMethod: "GET",
		HTTPPath:   "/rules/{ruleName}",
	}

	if input == nil {
		input = &GetTopicRuleInput{}
	}

	output = &GetTopicRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTopicRule API operation for AWS IoT.
//
// Gets information about the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetTopicRule for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
func (c *IoT) GetTopicRule(input *GetTopicRuleInput) (*GetTopicRuleOutput, error) {
	req, out := c.GetTopicRuleRequest(input)
	return out, req.Send()
}

// GetTopicRuleWithContext is the same as GetTopicRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetTopicRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetTopicRuleWithContext(ctx aws.Context, input *GetTopicRuleInput, opts ...request.Option) (*GetTopicRuleOutput, error) {
	req, out := c.GetTopicRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTopicRuleDestination = "GetTopicRuleDestination"

// GetTopicRuleDestinationRequest generates a "aws/request.Request" representing the
// client's request for the GetTopicRuleDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTopicRuleDestination for more information on using the GetTopicRuleDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTopicRuleDestinationRequest method.
//    req, resp := client.GetTopicRuleDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetTopicRuleDestinationRequest(input *GetTopicRuleDestinationInput) (req *request.Request, output *GetTopicRuleDestinationOutput) {
	op := &request.Operation{
		Name:       opGetTopicRuleDestination,
		HTTPMethod: "GET",
		HTTPPath:   "/destinations/{arn+}",
	}

	if input == nil {
		input = &GetTopicRuleDestinationInput{}
	}

	output = &GetTopicRuleDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTopicRuleDestination API operation for AWS IoT.
//
// Gets information about a topic rule destination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetTopicRuleDestination for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
func (c *IoT) GetTopicRuleDestination(input *GetTopicRuleDestinationInput) (*GetTopicRuleDestinationOutput, error) {
	req, out := c.GetTopicRuleDestinationRequest(input)
	return out, req.Send()
}

// GetTopicRuleDestinationWithContext is the same as GetTopicRuleDestination with the addition of
// the ability to pass a context and additional request options.
//
// See GetTopicRuleDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetTopicRuleDestinationWithContext(ctx aws.Context, input *GetTopicRuleDestinationInput, opts ...request.Option) (*GetTopicRuleDestinationOutput, error) {
	req, out := c.GetTopicRuleDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetV2LoggingOptions = "GetV2LoggingOptions"

// GetV2LoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the GetV2LoggingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetV2LoggingOptions for more information on using the GetV2LoggingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetV2LoggingOptionsRequest method.
//    req, resp := client.GetV2LoggingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetV2LoggingOptionsRequest(input *GetV2LoggingOptionsInput) (req *request.Request, output *GetV2LoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opGetV2LoggingOptions,
		HTTPMethod: "GET",
		HTTPPath:   "/v2LoggingOptions",
	}

	if input == nil {
		input = &GetV2LoggingOptionsInput{}
	}

	output = &GetV2LoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetV2LoggingOptions API operation for AWS IoT.
//
// Gets the fine grained logging options.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetV2LoggingOptions for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   An unexpected error has occurred.
//
//   * NotConfiguredException
//   The resource is not configured.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) GetV2LoggingOptions(input *GetV2LoggingOptionsInput) (*GetV2LoggingOptionsOutput, error) {
	req, out := c.GetV2LoggingOptionsRequest(input)
	return out, req.Send()
}

// GetV2LoggingOptionsWithContext is the same as GetV2LoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See GetV2LoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetV2LoggingOptionsWithContext(ctx aws.Context, input *GetV2LoggingOptionsInput, opts ...request.Option) (*GetV2LoggingOptionsOutput, error) {
	req, out := c.GetV2LoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListActiveViolations = "ListActiveViolations"

// ListActiveViolationsRequest generates a "aws/request.Request" representing the
// client's request for the ListActiveViolations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListActiveViolations for more information on using the ListActiveViolations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListActiveViolationsRequest method.
//    req, resp := client.ListActiveViolationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListActiveViolationsRequest(input *ListActiveViolationsInput) (req *request.Request, output *ListActiveViolationsOutput) {
	op := &request.Operation{
		Name:       opListActiveViolations,
		HTTPMethod: "GET",
		HTTPPath:   "/active-violations",
	}

	if input == nil {
		input = &ListActiveViolationsInput{}
	}

	output = &ListActiveViolationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListActiveViolations API operation for AWS IoT.
//
// Lists the active violations for a given Device Defender security profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListActiveViolations for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListActiveViolations(input *ListActiveViolationsInput) (*ListActiveViolationsOutput, error) {
	req, out := c.ListActiveViolationsRequest(input)
	return out, req.Send()
}

// ListActiveViolationsWithContext is the same as ListActiveViolations with the addition of
// the ability to pass a context and additional request options.
//
// See ListActiveViolations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListActiveViolationsWithContext(ctx aws.Context, input *ListActiveViolationsInput, opts ...request.Option) (*ListActiveViolationsOutput, error) {
	req, out := c.ListActiveViolationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAttachedPolicies = "ListAttachedPolicies"

// ListAttachedPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListAttachedPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAttachedPolicies for more information on using the ListAttachedPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAttachedPoliciesRequest method.
//    req, resp := client.ListAttachedPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListAttachedPoliciesRequest(input *ListAttachedPoliciesInput) (req *request.Request, output *ListAttachedPoliciesOutput) {
	op := &request.Operation{
		Name:       opListAttachedPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/attached-policies/{target}",
	}

	if input == nil {
		input = &ListAttachedPoliciesInput{}
	}

	output = &ListAttachedPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAttachedPolicies API operation for AWS IoT.
//
// Lists the policies attached to the specified thing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListAttachedPolicies for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
func (c *IoT) ListAttachedPolicies(input *ListAttachedPoliciesInput) (*ListAttachedPoliciesOutput, error) {
	req, out := c.ListAttachedPoliciesRequest(input)
	return out, req.Send()
}

// ListAttachedPoliciesWithContext is the same as ListAttachedPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListAttachedPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListAttachedPoliciesWithContext(ctx aws.Context, input *ListAttachedPoliciesInput, opts ...request.Option) (*ListAttachedPoliciesOutput, error) {
	req, out := c.ListAttachedPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAuditFindings = "ListAuditFindings"

// ListAuditFindingsRequest generates a "aws/request.Request" representing the
// client's request for the ListAuditFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAuditFindings for more information on using the ListAuditFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAuditFindingsRequest method.
//    req, resp := client.ListAuditFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListAuditFindingsRequest(input *ListAuditFindingsInput) (req *request.Request, output *ListAuditFindingsOutput) {
	op := &request.Operation{
		Name:       opListAuditFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/audit/findings",
	}

	if input == nil {
		input = &ListAuditFindingsInput{}
	}

	output = &ListAuditFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAuditFindings API operation for AWS IoT.
//
// Lists the findings (results) of a Device Defender audit or of the audits
// performed during a specified time period. (Findings are retained for 180
// days.)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListAuditFindings for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListAuditFindings(input *ListAuditFindingsInput) (*ListAuditFindingsOutput, error) {
	req, out := c.ListAuditFindingsRequest(input)
	return out, req.Send()
}

// ListAuditFindingsWithContext is the same as ListAuditFindings with the addition of
// the ability to pass a context and additional request options.
//
// See ListAuditFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListAuditFindingsWithContext(ctx aws.Context, input *ListAuditFindingsInput, opts ...request.Option) (*ListAuditFindingsOutput, error) {
	req, out := c.ListAuditFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAuditMitigationActionsExecutions = "ListAuditMitigationActionsExecutions"

// ListAuditMitigationActionsExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListAuditMitigationActionsExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAuditMitigationActionsExecutions for more information on using the ListAuditMitigationActionsExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAuditMitigationActionsExecutionsRequest method.
//    req, resp := client.ListAuditMitigationActionsExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListAuditMitigationActionsExecutionsRequest(input *ListAuditMitigationActionsExecutionsInput) (req *request.Request, output *ListAuditMitigationActionsExecutionsOutput) {
	op := &request.Operation{
		Name:       opListAuditMitigationActionsExecutions,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/mitigationactions/executions",
	}

	if input == nil {
		input = &ListAuditMitigationActionsExecutionsInput{}
	}

	output = &ListAuditMitigationActionsExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAuditMitigationActionsExecutions API operation for AWS IoT.
//
// Gets the status of audit mitigation action tasks that were executed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListAuditMitigationActionsExecutions for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListAuditMitigationActionsExecutions(input *ListAuditMitigationActionsExecutionsInput) (*ListAuditMitigationActionsExecutionsOutput, error) {
	req, out := c.ListAuditMitigationActionsExecutionsRequest(input)
	return out, req.Send()
}

// ListAuditMitigationActionsExecutionsWithContext is the same as ListAuditMitigationActionsExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListAuditMitigationActionsExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListAuditMitigationActionsExecutionsWithContext(ctx aws.Context, input *ListAuditMitigationActionsExecutionsInput, opts ...request.Option) (*ListAuditMitigationActionsExecutionsOutput, error) {
	req, out := c.ListAuditMitigationActionsExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAuditMitigationActionsTasks = "ListAuditMitigationActionsTasks"

// ListAuditMitigationActionsTasksRequest generates a "aws/request.Request" representing the
// client's request for the ListAuditMitigationActionsTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAuditMitigationActionsTasks for more information on using the ListAuditMitigationActionsTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAuditMitigationActionsTasksRequest method.
//    req, resp := client.ListAuditMitigationActionsTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListAuditMitigationActionsTasksRequest(input *ListAuditMitigationActionsTasksInput) (req *request.Request, output *ListAuditMitigationActionsTasksOutput) {
	op := &request.Operation{
		Name:       opListAuditMitigationActionsTasks,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/mitigationactions/tasks",
	}

	if input == nil {
		input = &ListAuditMitigationActionsTasksInput{}
	}

	output = &ListAuditMitigationActionsTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAuditMitigationActionsTasks API operation for AWS IoT.
//
// Gets a list of audit mitigation action tasks that match the specified filters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListAuditMitigationActionsTasks for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListAuditMitigationActionsTasks(input *ListAuditMitigationActionsTasksInput) (*ListAuditMitigationActionsTasksOutput, error) {
	req, out := c.ListAuditMitigationActionsTasksRequest(input)
	return out, req.Send()
}

// ListAuditMitigationActionsTasksWithContext is the same as ListAuditMitigationActionsTasks with the addition of
// the ability to pass a context and additional request options.
//
// See ListAuditMitigationActionsTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListAuditMitigationActionsTasksWithContext(ctx aws.Context, input *ListAuditMitigationActionsTasksInput, opts ...request.Option) (*ListAuditMitigationActionsTasksOutput, error) {
	req, out := c.ListAuditMitigationActionsTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAuditTasks = "ListAuditTasks"

// ListAuditTasksRequest generates a "aws/request.Request" representing the
// client's request for the ListAuditTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAuditTasks for more information on using the ListAuditTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAuditTasksRequest method.
//    req, resp := client.ListAuditTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListAuditTasksRequest(input *ListAuditTasksInput) (req *request.Request, output *ListAuditTasksOutput) {
	op := &request.Operation{
		Name:       opListAuditTasks,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/tasks",
	}

	if input == nil {
		input = &ListAuditTasksInput{}
	}

	output = &ListAuditTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAuditTasks API operation for AWS IoT.
//
// Lists the Device Defender audits that have been performed during a given
// time period.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListAuditTasks for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListAuditTasks(input *ListAuditTasksInput) (*ListAuditTasksOutput, error) {
	req, out := c.ListAuditTasksRequest(input)
	return out, req.Send()
}

// ListAuditTasksWithContext is the same as ListAuditTasks with the addition of
// the ability to pass a context and additional request options.
//
// See ListAuditTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListAuditTasksWithContext(ctx aws.Context, input *ListAuditTasksInput, opts ...request.Option) (*ListAuditTasksOutput, error) {
	req, out := c.ListAuditTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAuthorizers = "ListAuthorizers"

// ListAuthorizersRequest generates a "aws/request.Request" representing the
// client's request for the ListAuthorizers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAuthorizers for more information on using the ListAuthorizers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAuthorizersRequest method.
//    req, resp := client.ListAuthorizersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListAuthorizersRequest(input *ListAuthorizersInput) (req *request.Request, output *ListAuthorizersOutput) {
	op := &request.Operation{
		Name:       opListAuthorizers,
		HTTPMethod: "GET",
		HTTPPath:   "/authorizers/",
	}

	if input == nil {
		input = &ListAuthorizersInput{}
	}

	output = &ListAuthorizersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAuthorizers API operation for AWS IoT.
//
// Lists the authorizers registered in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListAuthorizers for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListAuthorizers(input *ListAuthorizersInput) (*ListAuthorizersOutput, error) {
	req, out := c.ListAuthorizersRequest(input)
	return out, req.Send()
}

// ListAuthorizersWithContext is the same as ListAuthorizers with the addition of
// the ability to pass a context and additional request options.
//
// See ListAuthorizers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListAuthorizersWithContext(ctx aws.Context, input *ListAuthorizersInput, opts ...request.Option) (*ListAuthorizersOutput, error) {
	req, out := c.ListAuthorizersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBillingGroups = "ListBillingGroups"

// ListBillingGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListBillingGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBillingGroups for more information on using the ListBillingGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBillingGroupsRequest method.
//    req, resp := client.ListBillingGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListBillingGroupsRequest(input *ListBillingGroupsInput) (req *request.Request, output *ListBillingGroupsOutput) {
	op := &request.Operation{
		Name:       opListBillingGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/billing-groups",
	}

	if input == nil {
		input = &ListBillingGroupsInput{}
	}

	output = &ListBillingGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBillingGroups API operation for AWS IoT.
//
// Lists the billing groups you have created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListBillingGroups for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
func (c *IoT) ListBillingGroups(input *ListBillingGroupsInput) (*ListBillingGroupsOutput, error) {
	req, out := c.ListBillingGroupsRequest(input)
	return out, req.Send()
}

// ListBillingGroupsWithContext is the same as ListBillingGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListBillingGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListBillingGroupsWithContext(ctx aws.Context, input *ListBillingGroupsInput, opts ...request.Option) (*ListBillingGroupsOutput, error) {
	req, out := c.ListBillingGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCACertificates = "ListCACertificates"

// ListCACertificatesRequest generates a "aws/request.Request" representing the
// client's request for the ListCACertificates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCACertificates for more information on using the ListCACertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCACertificatesRequest method.
//    req, resp := client.ListCACertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListCACertificatesRequest(input *ListCACertificatesInput) (req *request.Request, output *ListCACertificatesOutput) {
	op := &request.Operation{
		Name:       opListCACertificates,
		HTTPMethod: "GET",
		HTTPPath:   "/cacertificates",
	}

	if input == nil {
		input = &ListCACertificatesInput{}
	}

	output = &ListCACertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCACertificates API operation for AWS IoT.
//
// Lists the CA certificates registered for your AWS account.
//
// The results are paginated with a default page size of 25. You can use the
// returned marker to retrieve additional results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListCACertificates for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListCACertificates(input *ListCACertificatesInput) (*ListCACertificatesOutput, error) {
	req, out := c.ListCACertificatesRequest(input)
	return out, req.Send()
}

// ListCACertificatesWithContext is the same as ListCACertificates with the addition of
// the ability to pass a context and additional request options.
//
// See ListCACertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListCACertificatesWithContext(ctx aws.Context, input *ListCACertificatesInput, opts ...request.Option) (*ListCACertificatesOutput, error) {
	req, out := c.ListCACertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCertificates = "ListCertificates"

// ListCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the ListCertificates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCertificates for more information on using the ListCertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCertificatesRequest method.
//    req, resp := client.ListCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListCertificatesRequest(input *ListCertificatesInput) (req *request.Request, output *ListCertificatesOutput) {
	op := &request.Operation{
		Name:       opListCertificates,
		HTTPMethod: "GET",
		HTTPPath:   "/certificates",
	}

	if input == nil {
		input = &ListCertificatesInput{}
	}

	output = &ListCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCertificates API operation for AWS IoT.
//
// Lists the certificates registered in your AWS account.
//
// The results are paginated with a default page size of 25. You can use the
// returned marker to retrieve additional results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListCertificates for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListCertificates(input *ListCertificatesInput) (*ListCertificatesOutput, error) {
	req, out := c.ListCertificatesRequest(input)
	return out, req.Send()
}

// ListCertificatesWithContext is the same as ListCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See ListCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListCertificatesWithContext(ctx aws.Context, input *ListCertificatesInput, opts ...request.Option) (*ListCertificatesOutput, error) {
	req, out := c.ListCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCertificatesByCA = "ListCertificatesByCA"

// ListCertificatesByCARequest generates a "aws/request.Request" representing the
// client's request for the ListCertificatesByCA operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCertificatesByCA for more information on using the ListCertificatesByCA
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCertificatesByCARequest method.
//    req, resp := client.ListCertificatesByCARequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListCertificatesByCARequest(input *ListCertificatesByCAInput) (req *request.Request, output *ListCertificatesByCAOutput) {
	op := &request.Operation{
		Name:       opListCertificatesByCA,
		HTTPMethod: "GET",
		HTTPPath:   "/certificates-by-ca/{caCertificateId}",
	}

	if input == nil {
		input = &ListCertificatesByCAInput{}
	}

	output = &ListCertificatesByCAOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCertificatesByCA API operation for AWS IoT.
//
// List the device certificates signed by the specified CA certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListCertificatesByCA for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListCertificatesByCA(input *ListCertificatesByCAInput) (*ListCertificatesByCAOutput, error) {
	req, out := c.ListCertificatesByCARequest(input)
	return out, req.Send()
}

// ListCertificatesByCAWithContext is the same as ListCertificatesByCA with the addition of
// the ability to pass a context and additional request options.
//
// See ListCertificatesByCA for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListCertificatesByCAWithContext(ctx aws.Context, input *ListCertificatesByCAInput, opts ...request.Option) (*ListCertificatesByCAOutput, error) {
	req, out := c.ListCertificatesByCARequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDimensions = "ListDimensions"

// ListDimensionsRequest generates a "aws/request.Request" representing the
// client's request for the ListDimensions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDimensions for more information on using the ListDimensions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDimensionsRequest method.
//    req, resp := client.ListDimensionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListDimensionsRequest(input *ListDimensionsInput) (req *request.Request, output *ListDimensionsOutput) {
	op := &request.Operation{
		Name:       opListDimensions,
		HTTPMethod: "GET",
		HTTPPath:   "/dimensions",
	}

	if input == nil {
		input = &ListDimensionsInput{}
	}

	output = &ListDimensionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDimensions API operation for AWS IoT.
//
// List the set of dimensions that are defined for your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListDimensions for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
func (c *IoT) ListDimensions(input *ListDimensionsInput) (*ListDimensionsOutput, error) {
	req, out := c.ListDimensionsRequest(input)
	return out, req.Send()
}

// ListDimensionsWithContext is the same as ListDimensions with the addition of
// the ability to pass a context and additional request options.
//
// See ListDimensions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListDimensionsWithContext(ctx aws.Context, input *ListDimensionsInput, opts ...request.Option) (*ListDimensionsOutput, error) {
	req, out := c.ListDimensionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDomainConfigurations = "ListDomainConfigurations"

// ListDomainConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListDomainConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomainConfigurations for more information on using the ListDomainConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDomainConfigurationsRequest method.
//    req, resp := client.ListDomainConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListDomainConfigurationsRequest(input *ListDomainConfigurationsInput) (req *request.Request, output *ListDomainConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListDomainConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/domainConfigurations",
	}

	if input == nil {
		input = &ListDomainConfigurationsInput{}
	}

	output = &ListDomainConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomainConfigurations API operation for AWS IoT.
//
// Gets a list of domain configurations for the user. This list is sorted alphabetically
// by domain configuration name.
//
// The domain configuration feature is in public preview and is subject to change.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListDomainConfigurations for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListDomainConfigurations(input *ListDomainConfigurationsInput) (*ListDomainConfigurationsOutput, error) {
	req, out := c.ListDomainConfigurationsRequest(input)
	return out, req.Send()
}

// ListDomainConfigurationsWithContext is the same as ListDomainConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomainConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListDomainConfigurationsWithContext(ctx aws.Context, input *ListDomainConfigurationsInput, opts ...request.Option) (*ListDomainConfigurationsOutput, error) {
	req, out := c.ListDomainConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIndices = "ListIndices"

// ListIndicesRequest generates a "aws/request.Request" representing the
// client's request for the ListIndices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIndices for more information on using the ListIndices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIndicesRequest method.
//    req, resp := client.ListIndicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListIndicesRequest(input *ListIndicesInput) (req *request.Request, output *ListIndicesOutput) {
	op := &request.Operation{
		Name:       opListIndices,
		HTTPMethod: "GET",
		HTTPPath:   "/indices",
	}

	if input == nil {
		input = &ListIndicesInput{}
	}

	output = &ListIndicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIndices API operation for AWS IoT.
//
// Lists the search indices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListIndices for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListIndices(input *ListIndicesInput) (*ListIndicesOutput, error) {
	req, out := c.ListIndicesRequest(input)
	return out, req.Send()
}

// ListIndicesWithContext is the same as ListIndices with the addition of
// the ability to pass a context and additional request options.
//
// See ListIndices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListIndicesWithContext(ctx aws.Context, input *ListIndicesInput, opts ...request.Option) (*ListIndicesOutput, error) {
	req, out := c.ListIndicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListJobExecutionsForJob = "ListJobExecutionsForJob"

// ListJobExecutionsForJobRequest generates a "aws/request.Request" representing the
// client's request for the ListJobExecutionsForJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobExecutionsForJob for more information on using the ListJobExecutionsForJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListJobExecutionsForJobRequest method.
//    req, resp := client.ListJobExecutionsForJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListJobExecutionsForJobRequest(input *ListJobExecutionsForJobInput) (req *request.Request, output *ListJobExecutionsForJobOutput) {
	op := &request.Operation{
		Name:       opListJobExecutionsForJob,
		HTTPMethod: "GET",
		HTTPPath:   "/jobs/{jobId}/things",
	}

	if input == nil {
		input = &ListJobExecutionsForJobInput{}
	}

	output = &ListJobExecutionsForJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobExecutionsForJob API operation for AWS IoT.
//
// Lists the job executions for a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListJobExecutionsForJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) ListJobExecutionsForJob(input *ListJobExecutionsForJobInput) (*ListJobExecutionsForJobOutput, error) {
	req, out := c.ListJobExecutionsForJobRequest(input)
	return out, req.Send()
}

// ListJobExecutionsForJobWithContext is the same as ListJobExecutionsForJob with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobExecutionsForJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListJobExecutionsForJobWithContext(ctx aws.Context, input *ListJobExecutionsForJobInput, opts ...request.Option) (*ListJobExecutionsForJobOutput, error) {
	req, out := c.ListJobExecutionsForJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListJobExecutionsForThing = "ListJobExecutionsForThing"

// ListJobExecutionsForThingRequest generates a "aws/request.Request" representing the
// client's request for the ListJobExecutionsForThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobExecutionsForThing for more information on using the ListJobExecutionsForThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListJobExecutionsForThingRequest method.
//    req, resp := client.ListJobExecutionsForThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListJobExecutionsForThingRequest(input *ListJobExecutionsForThingInput) (req *request.Request, output *ListJobExecutionsForThingOutput) {
	op := &request.Operation{
		Name:       opListJobExecutionsForThing,
		HTTPMethod: "GET",
		HTTPPath:   "/things/{thingName}/jobs",
	}

	if input == nil {
		input = &ListJobExecutionsForThingInput{}
	}

	output = &ListJobExecutionsForThingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobExecutionsForThing API operation for AWS IoT.
//
// Lists the job executions for the specified thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListJobExecutionsForThing for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) ListJobExecutionsForThing(input *ListJobExecutionsForThingInput) (*ListJobExecutionsForThingOutput, error) {
	req, out := c.ListJobExecutionsForThingRequest(input)
	return out, req.Send()
}

// ListJobExecutionsForThingWithContext is the same as ListJobExecutionsForThing with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobExecutionsForThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListJobExecutionsForThingWithContext(ctx aws.Context, input *ListJobExecutionsForThingInput, opts ...request.Option) (*ListJobExecutionsForThingOutput, error) {
	req, out := c.ListJobExecutionsForThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobs for more information on using the ListJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListJobsRequest method.
//    req, resp := client.ListJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/jobs",
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	output = &ListJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobs API operation for AWS IoT.
//
// Lists jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListJobs for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	return out, req.Send()
}

// ListJobsWithContext is the same as ListJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListJobsWithContext(ctx aws.Context, input *ListJobsInput, opts ...request.Option) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMitigationActions = "ListMitigationActions"

// ListMitigationActionsRequest generates a "aws/request.Request" representing the
// client's request for the ListMitigationActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMitigationActions for more information on using the ListMitigationActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMitigationActionsRequest method.
//    req, resp := client.ListMitigationActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListMitigationActionsRequest(input *ListMitigationActionsInput) (req *request.Request, output *ListMitigationActionsOutput) {
	op := &request.Operation{
		Name:       opListMitigationActions,
		HTTPMethod: "GET",
		HTTPPath:   "/mitigationactions/actions",
	}

	if input == nil {
		input = &ListMitigationActionsInput{}
	}

	output = &ListMitigationActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMitigationActions API operation for AWS IoT.
//
// Gets a list of all mitigation actions that match the specified filter criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListMitigationActions for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListMitigationActions(input *ListMitigationActionsInput) (*ListMitigationActionsOutput, error) {
	req, out := c.ListMitigationActionsRequest(input)
	return out, req.Send()
}

// ListMitigationActionsWithContext is the same as ListMitigationActions with the addition of
// the ability to pass a context and additional request options.
//
// See ListMitigationActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListMitigationActionsWithContext(ctx aws.Context, input *ListMitigationActionsInput, opts ...request.Option) (*ListMitigationActionsOutput, error) {
	req, out := c.ListMitigationActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListOTAUpdates = "ListOTAUpdates"

// ListOTAUpdatesRequest generates a "aws/request.Request" representing the
// client's request for the ListOTAUpdates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOTAUpdates for more information on using the ListOTAUpdates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOTAUpdatesRequest method.
//    req, resp := client.ListOTAUpdatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListOTAUpdatesRequest(input *ListOTAUpdatesInput) (req *request.Request, output *ListOTAUpdatesOutput) {
	op := &request.Operation{
		Name:       opListOTAUpdates,
		HTTPMethod: "GET",
		HTTPPath:   "/otaUpdates",
	}

	if input == nil {
		input = &ListOTAUpdatesInput{}
	}

	output = &ListOTAUpdatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOTAUpdates API operation for AWS IoT.
//
// Lists OTA updates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListOTAUpdates for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) ListOTAUpdates(input *ListOTAUpdatesInput) (*ListOTAUpdatesOutput, error) {
	req, out := c.ListOTAUpdatesRequest(input)
	return out, req.Send()
}

// ListOTAUpdatesWithContext is the same as ListOTAUpdates with the addition of
// the ability to pass a context and additional request options.
//
// See ListOTAUpdates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListOTAUpdatesWithContext(ctx aws.Context, input *ListOTAUpdatesInput, opts ...request.Option) (*ListOTAUpdatesOutput, error) {
	req, out := c.ListOTAUpdatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListOutgoingCertificates = "ListOutgoingCertificates"

// ListOutgoingCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the ListOutgoingCertificates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOutgoingCertificates for more information on using the ListOutgoingCertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOutgoingCertificatesRequest method.
//    req, resp := client.ListOutgoingCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListOutgoingCertificatesRequest(input *ListOutgoingCertificatesInput) (req *request.Request, output *ListOutgoingCertificatesOutput) {
	op := &request.Operation{
		Name:       opListOutgoingCertificates,
		HTTPMethod: "GET",
		HTTPPath:   "/certificates-out-going",
	}

	if input == nil {
		input = &ListOutgoingCertificatesInput{}
	}

	output = &ListOutgoingCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOutgoingCertificates API operation for AWS IoT.
//
// Lists certificates that are being transferred but not yet accepted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListOutgoingCertificates for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListOutgoingCertificates(input *ListOutgoingCertificatesInput) (*ListOutgoingCertificatesOutput, error) {
	req, out := c.ListOutgoingCertificatesRequest(input)
	return out, req.Send()
}

// ListOutgoingCertificatesWithContext is the same as ListOutgoingCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See ListOutgoingCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListOutgoingCertificatesWithContext(ctx aws.Context, input *ListOutgoingCertificatesInput, opts ...request.Option) (*ListOutgoingCertificatesOutput, error) {
	req, out := c.ListOutgoingCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPolicies = "ListPolicies"

// ListPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPolicies for more information on using the ListPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPoliciesRequest method.
//    req, resp := client.ListPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListPoliciesRequest(input *ListPoliciesInput) (req *request.Request, output *ListPoliciesOutput) {
	op := &request.Operation{
		Name:       opListPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/policies",
	}

	if input == nil {
		input = &ListPoliciesInput{}
	}

	output = &ListPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicies API operation for AWS IoT.
//
// Lists your policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListPolicies for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListPolicies(input *ListPoliciesInput) (*ListPoliciesOutput, error) {
	req, out := c.ListPoliciesRequest(input)
	return out, req.Send()
}

// ListPoliciesWithContext is the same as ListPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListPoliciesWithContext(ctx aws.Context, input *ListPoliciesInput, opts ...request.Option) (*ListPoliciesOutput, error) {
	req, out := c.ListPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPolicyPrincipals = "ListPolicyPrincipals"

// ListPolicyPrincipalsRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicyPrincipals operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPolicyPrincipals for more information on using the ListPolicyPrincipals
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPolicyPrincipalsRequest method.
//    req, resp := client.ListPolicyPrincipalsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Deprecated: ListPolicyPrincipals has been deprecated
func (c *IoT) ListPolicyPrincipalsRequest(input *ListPolicyPrincipalsInput) (req *request.Request, output *ListPolicyPrincipalsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListPolicyPrincipals, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListPolicyPrincipals,
		HTTPMethod: "GET",
		HTTPPath:   "/policy-principals",
	}

	if input == nil {
		input = &ListPolicyPrincipalsInput{}
	}

	output = &ListPolicyPrincipalsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicyPrincipals API operation for AWS IoT.
//
// Lists the principals associated with the specified policy.
//
// Note: This API is deprecated. Please use ListTargetsForPolicy instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListPolicyPrincipals for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//
// Deprecated: ListPolicyPrincipals has been deprecated
func (c *IoT) ListPolicyPrincipals(input *ListPolicyPrincipalsInput) (*ListPolicyPrincipalsOutput, error) {
	req, out := c.ListPolicyPrincipalsRequest(input)
	return out, req.Send()
}

// ListPolicyPrincipalsWithContext is the same as ListPolicyPrincipals with the addition of
// the ability to pass a context and additional request options.
//
// See ListPolicyPrincipals for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: ListPolicyPrincipalsWithContext has been deprecated
func (c *IoT) ListPolicyPrincipalsWithContext(ctx aws.Context, input *ListPolicyPrincipalsInput, opts ...request.Option) (*ListPolicyPrincipalsOutput, error) {
	req, out := c.ListPolicyPrincipalsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPolicyVersions = "ListPolicyVersions"

// ListPolicyVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicyVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPolicyVersions for more information on using the ListPolicyVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPolicyVersionsRequest method.
//    req, resp := client.ListPolicyVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListPolicyVersionsRequest(input *ListPolicyVersionsInput) (req *request.Request, output *ListPolicyVersionsOutput) {
	op := &request.Operation{
		Name:       opListPolicyVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/policies/{policyName}/version",
	}

	if input == nil {
		input = &ListPolicyVersionsInput{}
	}

	output = &ListPolicyVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicyVersions API operation for AWS IoT.
//
// Lists the versions of the specified policy and identifies the default version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListPolicyVersions for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListPolicyVersions(input *ListPolicyVersionsInput) (*ListPolicyVersionsOutput, error) {
	req, out := c.ListPolicyVersionsRequest(input)
	return out, req.Send()
}

// ListPolicyVersionsWithContext is the same as ListPolicyVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListPolicyVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListPolicyVersionsWithContext(ctx aws.Context, input *ListPolicyVersionsInput, opts ...request.Option) (*ListPolicyVersionsOutput, error) {
	req, out := c.ListPolicyVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPrincipalPolicies = "ListPrincipalPolicies"

// ListPrincipalPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListPrincipalPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPrincipalPolicies for more information on using the ListPrincipalPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPrincipalPoliciesRequest method.
//    req, resp := client.ListPrincipalPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Deprecated: ListPrincipalPolicies has been deprecated
func (c *IoT) ListPrincipalPoliciesRequest(input *ListPrincipalPoliciesInput) (req *request.Request, output *ListPrincipalPoliciesOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListPrincipalPolicies, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListPrincipalPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/principal-policies",
	}

	if input == nil {
		input = &ListPrincipalPoliciesInput{}
	}

	output = &ListPrincipalPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPrincipalPolicies API operation for AWS IoT.
//
// Lists the policies attached to the specified principal. If you use an Cognito
// identity, the ID must be in AmazonCognito Identity format (https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetCredentialsForIdentity.html#API_GetCredentialsForIdentity_RequestSyntax).
//
// Note: This API is deprecated. Please use ListAttachedPolicies instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListPrincipalPolicies for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//
// Deprecated: ListPrincipalPolicies has been deprecated
func (c *IoT) ListPrincipalPolicies(input *ListPrincipalPoliciesInput) (*ListPrincipalPoliciesOutput, error) {
	req, out := c.ListPrincipalPoliciesRequest(input)
	return out, req.Send()
}

// ListPrincipalPoliciesWithContext is the same as ListPrincipalPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListPrincipalPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: ListPrincipalPoliciesWithContext has been deprecated
func (c *IoT) ListPrincipalPoliciesWithContext(ctx aws.Context, input *ListPrincipalPoliciesInput, opts ...request.Option) (*ListPrincipalPoliciesOutput, error) {
	req, out := c.ListPrincipalPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPrincipalThings = "ListPrincipalThings"

// ListPrincipalThingsRequest generates a "aws/request.Request" representing the
// client's request for the ListPrincipalThings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPrincipalThings for more information on using the ListPrincipalThings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPrincipalThingsRequest method.
//    req, resp := client.ListPrincipalThingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListPrincipalThingsRequest(input *ListPrincipalThingsInput) (req *request.Request, output *ListPrincipalThingsOutput) {
	op := &request.Operation{
		Name:       opListPrincipalThings,
		HTTPMethod: "GET",
		HTTPPath:   "/principals/things",
	}

	if input == nil {
		input = &ListPrincipalThingsInput{}
	}

	output = &ListPrincipalThingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPrincipalThings API operation for AWS IoT.
//
// Lists the things associated with the specified principal. A principal can
// be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities
// or federated identities.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListPrincipalThings for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) ListPrincipalThings(input *ListPrincipalThingsInput) (*ListPrincipalThingsOutput, error) {
	req, out := c.ListPrincipalThingsRequest(input)
	return out, req.Send()
}

// ListPrincipalThingsWithContext is the same as ListPrincipalThings with the addition of
// the ability to pass a context and additional request options.
//
// See ListPrincipalThings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListPrincipalThingsWithContext(ctx aws.Context, input *ListPrincipalThingsInput, opts ...request.Option) (*ListPrincipalThingsOutput, error) {
	req, out := c.ListPrincipalThingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListProvisioningTemplateVersions = "ListProvisioningTemplateVersions"

// ListProvisioningTemplateVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListProvisioningTemplateVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProvisioningTemplateVersions for more information on using the ListProvisioningTemplateVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProvisioningTemplateVersionsRequest method.
//    req, resp := client.ListProvisioningTemplateVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListProvisioningTemplateVersionsRequest(input *ListProvisioningTemplateVersionsInput) (req *request.Request, output *ListProvisioningTemplateVersionsOutput) {
	op := &request.Operation{
		Name:       opListProvisioningTemplateVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/provisioning-templates/{templateName}/versions",
	}

	if input == nil {
		input = &ListProvisioningTemplateVersionsInput{}
	}

	output = &ListProvisioningTemplateVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProvisioningTemplateVersions API operation for AWS IoT.
//
// A list of fleet provisioning template versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListProvisioningTemplateVersions for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
func (c *IoT) ListProvisioningTemplateVersions(input *ListProvisioningTemplateVersionsInput) (*ListProvisioningTemplateVersionsOutput, error) {
	req, out := c.ListProvisioningTemplateVersionsRequest(input)
	return out, req.Send()
}

// ListProvisioningTemplateVersionsWithContext is the same as ListProvisioningTemplateVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListProvisioningTemplateVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListProvisioningTemplateVersionsWithContext(ctx aws.Context, input *ListProvisioningTemplateVersionsInput, opts ...request.Option) (*ListProvisioningTemplateVersionsOutput, error) {
	req, out := c.ListProvisioningTemplateVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListProvisioningTemplates = "ListProvisioningTemplates"

// ListProvisioningTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListProvisioningTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProvisioningTemplates for more information on using the ListProvisioningTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProvisioningTemplatesRequest method.
//    req, resp := client.ListProvisioningTemplatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListProvisioningTemplatesRequest(input *ListProvisioningTemplatesInput) (req *request.Request, output *ListProvisioningTemplatesOutput) {
	op := &request.Operation{
		Name:       opListProvisioningTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/provisioning-templates",
	}

	if input == nil {
		input = &ListProvisioningTemplatesInput{}
	}

	output = &ListProvisioningTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProvisioningTemplates API operation for AWS IoT.
//
// Lists the fleet provisioning templates in your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListProvisioningTemplates for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
func (c *IoT) ListProvisioningTemplates(input *ListProvisioningTemplatesInput) (*ListProvisioningTemplatesOutput, error) {
	req, out := c.ListProvisioningTemplatesRequest(input)
	return out, req.Send()
}

// ListProvisioningTemplatesWithContext is the same as ListProvisioningTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListProvisioningTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListProvisioningTemplatesWithContext(ctx aws.Context, input *ListProvisioningTemplatesInput, opts ...request.Option) (*ListProvisioningTemplatesOutput, error) {
	req, out := c.ListProvisioningTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRoleAliases = "ListRoleAliases"

// ListRoleAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListRoleAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRoleAliases for more information on using the ListRoleAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRoleAliasesRequest method.
//    req, resp := client.ListRoleAliasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListRoleAliasesRequest(input *ListRoleAliasesInput) (req *request.Request, output *ListRoleAliasesOutput) {
	op := &request.Operation{
		Name:       opListRoleAliases,
		HTTPMethod: "GET",
		HTTPPath:   "/role-aliases",
	}

	if input == nil {
		input = &ListRoleAliasesInput{}
	}

	output = &ListRoleAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRoleAliases API operation for AWS IoT.
//
// Lists the role aliases registered in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListRoleAliases for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListRoleAliases(input *ListRoleAliasesInput) (*ListRoleAliasesOutput, error) {
	req, out := c.ListRoleAliasesRequest(input)
	return out, req.Send()
}

// ListRoleAliasesWithContext is the same as ListRoleAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListRoleAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListRoleAliasesWithContext(ctx aws.Context, input *ListRoleAliasesInput, opts ...request.Option) (*ListRoleAliasesOutput, error) {
	req, out := c.ListRoleAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListScheduledAudits = "ListScheduledAudits"

// ListScheduledAuditsRequest generates a "aws/request.Request" representing the
// client's request for the ListScheduledAudits operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListScheduledAudits for more information on using the ListScheduledAudits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListScheduledAuditsRequest method.
//    req, resp := client.ListScheduledAuditsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListScheduledAuditsRequest(input *ListScheduledAuditsInput) (req *request.Request, output *ListScheduledAuditsOutput) {
	op := &request.Operation{
		Name:       opListScheduledAudits,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/scheduledaudits",
	}

	if input == nil {
		input = &ListScheduledAuditsInput{}
	}

	output = &ListScheduledAuditsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListScheduledAudits API operation for AWS IoT.
//
// Lists all of your scheduled audits.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListScheduledAudits for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListScheduledAudits(input *ListScheduledAuditsInput) (*ListScheduledAuditsOutput, error) {
	req, out := c.ListScheduledAuditsRequest(input)
	return out, req.Send()
}

// ListScheduledAuditsWithContext is the same as ListScheduledAudits with the addition of
// the ability to pass a context and additional request options.
//
// See ListScheduledAudits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListScheduledAuditsWithContext(ctx aws.Context, input *ListScheduledAuditsInput, opts ...request.Option) (*ListScheduledAuditsOutput, error) {
	req, out := c.ListScheduledAuditsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSecurityProfiles = "ListSecurityProfiles"

// ListSecurityProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListSecurityProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSecurityProfiles for more information on using the ListSecurityProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSecurityProfilesRequest method.
//    req, resp := client.ListSecurityProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListSecurityProfilesRequest(input *ListSecurityProfilesInput) (req *request.Request, output *ListSecurityProfilesOutput) {
	op := &request.Operation{
		Name:       opListSecurityProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/security-profiles",
	}

	if input == nil {
		input = &ListSecurityProfilesInput{}
	}

	output = &ListSecurityProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSecurityProfiles API operation for AWS IoT.
//
// Lists the Device Defender security profiles you have created. You can use
// filters to list only those security profiles associated with a thing group
// or only those associated with your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListSecurityProfiles for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) ListSecurityProfiles(input *ListSecurityProfilesInput) (*ListSecurityProfilesOutput, error) {
	req, out := c.ListSecurityProfilesRequest(input)
	return out, req.Send()
}

// ListSecurityProfilesWithContext is the same as ListSecurityProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListSecurityProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListSecurityProfilesWithContext(ctx aws.Context, input *ListSecurityProfilesInput, opts ...request.Option) (*ListSecurityProfilesOutput, error) {
	req, out := c.ListSecurityProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSecurityProfilesForTarget = "ListSecurityProfilesForTarget"

// ListSecurityProfilesForTargetRequest generates a "aws/request.Request" representing the
// client's request for the ListSecurityProfilesForTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSecurityProfilesForTarget for more information on using the ListSecurityProfilesForTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSecurityProfilesForTargetRequest method.
//    req, resp := client.ListSecurityProfilesForTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListSecurityProfilesForTargetRequest(input *ListSecurityProfilesForTargetInput) (req *request.Request, output *ListSecurityProfilesForTargetOutput) {
	op := &request.Operation{
		Name:       opListSecurityProfilesForTarget,
		HTTPMethod: "GET",
		HTTPPath:   "/security-profiles-for-target",
	}

	if input == nil {
		input = &ListSecurityProfilesForTargetInput{}
	}

	output = &ListSecurityProfilesForTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSecurityProfilesForTarget API operation for AWS IoT.
//
// Lists the Device Defender security profiles attached to a target (thing group).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListSecurityProfilesForTarget for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) ListSecurityProfilesForTarget(input *ListSecurityProfilesForTargetInput) (*ListSecurityProfilesForTargetOutput, error) {
	req, out := c.ListSecurityProfilesForTargetRequest(input)
	return out, req.Send()
}

// ListSecurityProfilesForTargetWithContext is the same as ListSecurityProfilesForTarget with the addition of
// the ability to pass a context and additional request options.
//
// See ListSecurityProfilesForTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListSecurityProfilesForTargetWithContext(ctx aws.Context, input *ListSecurityProfilesForTargetInput, opts ...request.Option) (*ListSecurityProfilesForTargetOutput, error) {
	req, out := c.ListSecurityProfilesForTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListStreams = "ListStreams"

// ListStreamsRequest generates a "aws/request.Request" representing the
// client's request for the ListStreams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStreams for more information on using the ListStreams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStreamsRequest method.
//    req, resp := client.ListStreamsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListStreamsRequest(input *ListStreamsInput) (req *request.Request, output *ListStreamsOutput) {
	op := &request.Operation{
		Name:       opListStreams,
		HTTPMethod: "GET",
		HTTPPath:   "/streams",
	}

	if input == nil {
		input = &ListStreamsInput{}
	}

	output = &ListStreamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStreams API operation for AWS IoT.
//
// Lists all of the streams in your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListStreams for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListStreams(input *ListStreamsInput) (*ListStreamsOutput, error) {
	req, out := c.ListStreamsRequest(input)
	return out, req.Send()
}

// ListStreamsWithContext is the same as ListStreams with the addition of
// the ability to pass a context and additional request options.
//
// See ListStreams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListStreamsWithContext(ctx aws.Context, input *ListStreamsInput, opts ...request.Option) (*ListStreamsOutput, error) {
	req, out := c.ListStreamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS IoT.
//
// Lists the tags (metadata) you have assigned to the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
func (c *IoT) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTargetsForPolicy = "ListTargetsForPolicy"

// ListTargetsForPolicyRequest generates a "aws/request.Request" representing the
// client's request for the ListTargetsForPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTargetsForPolicy for more information on using the ListTargetsForPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTargetsForPolicyRequest method.
//    req, resp := client.ListTargetsForPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListTargetsForPolicyRequest(input *ListTargetsForPolicyInput) (req *request.Request, output *ListTargetsForPolicyOutput) {
	op := &request.Operation{
		Name:       opListTargetsForPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/policy-targets/{policyName}",
	}

	if input == nil {
		input = &ListTargetsForPolicyInput{}
	}

	output = &ListTargetsForPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTargetsForPolicy API operation for AWS IoT.
//
// List targets for the specified policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListTargetsForPolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
func (c *IoT) ListTargetsForPolicy(input *ListTargetsForPolicyInput) (*ListTargetsForPolicyOutput, error) {
	req, out := c.ListTargetsForPolicyRequest(input)
	return out, req.Send()
}

// ListTargetsForPolicyWithContext is the same as ListTargetsForPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See ListTargetsForPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListTargetsForPolicyWithContext(ctx aws.Context, input *ListTargetsForPolicyInput, opts ...request.Option) (*ListTargetsForPolicyOutput, error) {
	req, out := c.ListTargetsForPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTargetsForSecurityProfile = "ListTargetsForSecurityProfile"

// ListTargetsForSecurityProfileRequest generates a "aws/request.Request" representing the
// client's request for the ListTargetsForSecurityProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTargetsForSecurityProfile for more information on using the ListTargetsForSecurityProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTargetsForSecurityProfileRequest method.
//    req, resp := client.ListTargetsForSecurityProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListTargetsForSecurityProfileRequest(input *ListTargetsForSecurityProfileInput) (req *request.Request, output *ListTargetsForSecurityProfileOutput) {
	op := &request.Operation{
		Name:       opListTargetsForSecurityProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/security-profiles/{securityProfileName}/targets",
	}

	if input == nil {
		input = &ListTargetsForSecurityProfileInput{}
	}

	output = &ListTargetsForSecurityProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTargetsForSecurityProfile API operation for AWS IoT.
//
// Lists the targets (thing groups) associated with a given Device Defender
// security profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListTargetsForSecurityProfile for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListTargetsForSecurityProfile(input *ListTargetsForSecurityProfileInput) (*ListTargetsForSecurityProfileOutput, error) {
	req, out := c.ListTargetsForSecurityProfileRequest(input)
	return out, req.Send()
}

// ListTargetsForSecurityProfileWithContext is the same as ListTargetsForSecurityProfile with the addition of
// the ability to pass a context and additional request options.
//
// See ListTargetsForSecurityProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListTargetsForSecurityProfileWithContext(ctx aws.Context, input *ListTargetsForSecurityProfileInput, opts ...request.Option) (*ListTargetsForSecurityProfileOutput, error) {
	req, out := c.ListTargetsForSecurityProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThingGroups = "ListThingGroups"

// ListThingGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListThingGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThingGroups for more information on using the ListThingGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThingGroupsRequest method.
//    req, resp := client.ListThingGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingGroupsRequest(input *ListThingGroupsInput) (req *request.Request, output *ListThingGroupsOutput) {
	op := &request.Operation{
		Name:       opListThingGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-groups",
	}

	if input == nil {
		input = &ListThingGroupsInput{}
	}

	output = &ListThingGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThingGroups API operation for AWS IoT.
//
// List the thing groups in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThingGroups for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) ListThingGroups(input *ListThingGroupsInput) (*ListThingGroupsOutput, error) {
	req, out := c.ListThingGroupsRequest(input)
	return out, req.Send()
}

// ListThingGroupsWithContext is the same as ListThingGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListThingGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingGroupsWithContext(ctx aws.Context, input *ListThingGroupsInput, opts ...request.Option) (*ListThingGroupsOutput, error) {
	req, out := c.ListThingGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThingGroupsForThing = "ListThingGroupsForThing"

// ListThingGroupsForThingRequest generates a "aws/request.Request" representing the
// client's request for the ListThingGroupsForThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThingGroupsForThing for more information on using the ListThingGroupsForThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThingGroupsForThingRequest method.
//    req, resp := client.ListThingGroupsForThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingGroupsForThingRequest(input *ListThingGroupsForThingInput) (req *request.Request, output *ListThingGroupsForThingOutput) {
	op := &request.Operation{
		Name:       opListThingGroupsForThing,
		HTTPMethod: "GET",
		HTTPPath:   "/things/{thingName}/thing-groups",
	}

	if input == nil {
		input = &ListThingGroupsForThingInput{}
	}

	output = &ListThingGroupsForThingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThingGroupsForThing API operation for AWS IoT.
//
// List the thing groups to which the specified thing belongs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThingGroupsForThing for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) ListThingGroupsForThing(input *ListThingGroupsForThingInput) (*ListThingGroupsForThingOutput, error) {
	req, out := c.ListThingGroupsForThingRequest(input)
	return out, req.Send()
}

// ListThingGroupsForThingWithContext is the same as ListThingGroupsForThing with the addition of
// the ability to pass a context and additional request options.
//
// See ListThingGroupsForThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingGroupsForThingWithContext(ctx aws.Context, input *ListThingGroupsForThingInput, opts ...request.Option) (*ListThingGroupsForThingOutput, error) {
	req, out := c.ListThingGroupsForThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThingPrincipals = "ListThingPrincipals"

// ListThingPrincipalsRequest generates a "aws/request.Request" representing the
// client's request for the ListThingPrincipals operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThingPrincipals for more information on using the ListThingPrincipals
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThingPrincipalsRequest method.
//    req, resp := client.ListThingPrincipalsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingPrincipalsRequest(input *ListThingPrincipalsInput) (req *request.Request, output *ListThingPrincipalsOutput) {
	op := &request.Operation{
		Name:       opListThingPrincipals,
		HTTPMethod: "GET",
		HTTPPath:   "/things/{thingName}/principals",
	}

	if input == nil {
		input = &ListThingPrincipalsInput{}
	}

	output = &ListThingPrincipalsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThingPrincipals API operation for AWS IoT.
//
// Lists the principals associated with the specified thing. A principal can
// be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities
// or federated identities.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThingPrincipals for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) ListThingPrincipals(input *ListThingPrincipalsInput) (*ListThingPrincipalsOutput, error) {
	req, out := c.ListThingPrincipalsRequest(input)
	return out, req.Send()
}

// ListThingPrincipalsWithContext is the same as ListThingPrincipals with the addition of
// the ability to pass a context and additional request options.
//
// See ListThingPrincipals for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingPrincipalsWithContext(ctx aws.Context, input *ListThingPrincipalsInput, opts ...request.Option) (*ListThingPrincipalsOutput, error) {
	req, out := c.ListThingPrincipalsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThingRegistrationTaskReports = "ListThingRegistrationTaskReports"

// ListThingRegistrationTaskReportsRequest generates a "aws/request.Request" representing the
// client's request for the ListThingRegistrationTaskReports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThingRegistrationTaskReports for more information on using the ListThingRegistrationTaskReports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThingRegistrationTaskReportsRequest method.
//    req, resp := client.ListThingRegistrationTaskReportsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingRegistrationTaskReportsRequest(input *ListThingRegistrationTaskReportsInput) (req *request.Request, output *ListThingRegistrationTaskReportsOutput) {
	op := &request.Operation{
		Name:       opListThingRegistrationTaskReports,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-registration-tasks/{taskId}/reports",
	}

	if input == nil {
		input = &ListThingRegistrationTaskReportsInput{}
	}

	output = &ListThingRegistrationTaskReportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThingRegistrationTaskReports API operation for AWS IoT.
//
// Information about the thing registration tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThingRegistrationTaskReports for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListThingRegistrationTaskReports(input *ListThingRegistrationTaskReportsInput) (*ListThingRegistrationTaskReportsOutput, error) {
	req, out := c.ListThingRegistrationTaskReportsRequest(input)
	return out, req.Send()
}

// ListThingRegistrationTaskReportsWithContext is the same as ListThingRegistrationTaskReports with the addition of
// the ability to pass a context and additional request options.
//
// See ListThingRegistrationTaskReports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingRegistrationTaskReportsWithContext(ctx aws.Context, input *ListThingRegistrationTaskReportsInput, opts ...request.Option) (*ListThingRegistrationTaskReportsOutput, error) {
	req, out := c.ListThingRegistrationTaskReportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThingRegistrationTasks = "ListThingRegistrationTasks"

// ListThingRegistrationTasksRequest generates a "aws/request.Request" representing the
// client's request for the ListThingRegistrationTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThingRegistrationTasks for more information on using the ListThingRegistrationTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThingRegistrationTasksRequest method.
//    req, resp := client.ListThingRegistrationTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingRegistrationTasksRequest(input *ListThingRegistrationTasksInput) (req *request.Request, output *ListThingRegistrationTasksOutput) {
	op := &request.Operation{
		Name:       opListThingRegistrationTasks,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-registration-tasks",
	}

	if input == nil {
		input = &ListThingRegistrationTasksInput{}
	}

	output = &ListThingRegistrationTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThingRegistrationTasks API operation for AWS IoT.
//
// List bulk thing provisioning tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThingRegistrationTasks for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListThingRegistrationTasks(input *ListThingRegistrationTasksInput) (*ListThingRegistrationTasksOutput, error) {
	req, out := c.ListThingRegistrationTasksRequest(input)
	return out, req.Send()
}

// ListThingRegistrationTasksWithContext is the same as ListThingRegistrationTasks with the addition of
// the ability to pass a context and additional request options.
//
// See ListThingRegistrationTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingRegistrationTasksWithContext(ctx aws.Context, input *ListThingRegistrationTasksInput, opts ...request.Option) (*ListThingRegistrationTasksOutput, error) {
	req, out := c.ListThingRegistrationTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThingTypes = "ListThingTypes"

// ListThingTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListThingTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThingTypes for more information on using the ListThingTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThingTypesRequest method.
//    req, resp := client.ListThingTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingTypesRequest(input *ListThingTypesInput) (req *request.Request, output *ListThingTypesOutput) {
	op := &request.Operation{
		Name:       opListThingTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-types",
	}

	if input == nil {
		input = &ListThingTypesInput{}
	}

	output = &ListThingTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThingTypes API operation for AWS IoT.
//
// Lists the existing thing types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThingTypes for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListThingTypes(input *ListThingTypesInput) (*ListThingTypesOutput, error) {
	req, out := c.ListThingTypesRequest(input)
	return out, req.Send()
}

// ListThingTypesWithContext is the same as ListThingTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListThingTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingTypesWithContext(ctx aws.Context, input *ListThingTypesInput, opts ...request.Option) (*ListThingTypesOutput, error) {
	req, out := c.ListThingTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThings = "ListThings"

// ListThingsRequest generates a "aws/request.Request" representing the
// client's request for the ListThings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThings for more information on using the ListThings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThingsRequest method.
//    req, resp := client.ListThingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingsRequest(input *ListThingsInput) (req *request.Request, output *ListThingsOutput) {
	op := &request.Operation{
		Name:       opListThings,
		HTTPMethod: "GET",
		HTTPPath:   "/things",
	}

	if input == nil {
		input = &ListThingsInput{}
	}

	output = &ListThingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThings API operation for AWS IoT.
//
// Lists your things. Use the attributeName and attributeValue parameters to
// filter your things. For example, calling ListThings with attributeName=Color
// and attributeValue=Red retrieves all things in the registry that contain
// an attribute Color with the value Red.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThings for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListThings(input *ListThingsInput) (*ListThingsOutput, error) {
	req, out := c.ListThingsRequest(input)
	return out, req.Send()
}

// ListThingsWithContext is the same as ListThings with the addition of
// the ability to pass a context and additional request options.
//
// See ListThings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingsWithContext(ctx aws.Context, input *ListThingsInput, opts ...request.Option) (*ListThingsOutput, error) {
	req, out := c.ListThingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThingsInBillingGroup = "ListThingsInBillingGroup"

// ListThingsInBillingGroupRequest generates a "aws/request.Request" representing the
// client's request for the ListThingsInBillingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThingsInBillingGroup for more information on using the ListThingsInBillingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThingsInBillingGroupRequest method.
//    req, resp := client.ListThingsInBillingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingsInBillingGroupRequest(input *ListThingsInBillingGroupInput) (req *request.Request, output *ListThingsInBillingGroupOutput) {
	op := &request.Operation{
		Name:       opListThingsInBillingGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/billing-groups/{billingGroupName}/things",
	}

	if input == nil {
		input = &ListThingsInBillingGroupInput{}
	}

	output = &ListThingsInBillingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThingsInBillingGroup API operation for AWS IoT.
//
// Lists the things you have added to the given billing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThingsInBillingGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
func (c *IoT) ListThingsInBillingGroup(input *ListThingsInBillingGroupInput) (*ListThingsInBillingGroupOutput, error) {
	req, out := c.ListThingsInBillingGroupRequest(input)
	return out, req.Send()
}

// ListThingsInBillingGroupWithContext is the same as ListThingsInBillingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ListThingsInBillingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingsInBillingGroupWithContext(ctx aws.Context, input *ListThingsInBillingGroupInput, opts ...request.Option) (*ListThingsInBillingGroupOutput, error) {
	req, out := c.ListThingsInBillingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThingsInThingGroup = "ListThingsInThingGroup"

// ListThingsInThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the ListThingsInThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThingsInThingGroup for more information on using the ListThingsInThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThingsInThingGroupRequest method.
//    req, resp := client.ListThingsInThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingsInThingGroupRequest(input *ListThingsInThingGroupInput) (req *request.Request, output *ListThingsInThingGroupOutput) {
	op := &request.Operation{
		Name:       opListThingsInThingGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-groups/{thingGroupName}/things",
	}

	if input == nil {
		input = &ListThingsInThingGroupInput{}
	}

	output = &ListThingsInThingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThingsInThingGroup API operation for AWS IoT.
//
// Lists the things in the specified group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThingsInThingGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) ListThingsInThingGroup(input *ListThingsInThingGroupInput) (*ListThingsInThingGroupOutput, error) {
	req, out := c.ListThingsInThingGroupRequest(input)
	return out, req.Send()
}

// ListThingsInThingGroupWithContext is the same as ListThingsInThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ListThingsInThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingsInThingGroupWithContext(ctx aws.Context, input *ListThingsInThingGroupInput, opts ...request.Option) (*ListThingsInThingGroupOutput, error) {
	req, out := c.ListThingsInThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTopicRuleDestinations = "ListTopicRuleDestinations"

// ListTopicRuleDestinationsRequest generates a "aws/request.Request" representing the
// client's request for the ListTopicRuleDestinations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTopicRuleDestinations for more information on using the ListTopicRuleDestinations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTopicRuleDestinationsRequest method.
//    req, resp := client.ListTopicRuleDestinationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListTopicRuleDestinationsRequest(input *ListTopicRuleDestinationsInput) (req *request.Request, output *ListTopicRuleDestinationsOutput) {
	op := &request.Operation{
		Name:       opListTopicRuleDestinations,
		HTTPMethod: "GET",
		HTTPPath:   "/destinations",
	}

	if input == nil {
		input = &ListTopicRuleDestinationsInput{}
	}

	output = &ListTopicRuleDestinationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTopicRuleDestinations API operation for AWS IoT.
//
// Lists all the topic rule destinations in your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListTopicRuleDestinations for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
func (c *IoT) ListTopicRuleDestinations(input *ListTopicRuleDestinationsInput) (*ListTopicRuleDestinationsOutput, error) {
	req, out := c.ListTopicRuleDestinationsRequest(input)
	return out, req.Send()
}

// ListTopicRuleDestinationsWithContext is the same as ListTopicRuleDestinations with the addition of
// the ability to pass a context and additional request options.
//
// See ListTopicRuleDestinations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListTopicRuleDestinationsWithContext(ctx aws.Context, input *ListTopicRuleDestinationsInput, opts ...request.Option) (*ListTopicRuleDestinationsOutput, error) {
	req, out := c.ListTopicRuleDestinationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTopicRules = "ListTopicRules"

// ListTopicRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListTopicRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTopicRules for more information on using the ListTopicRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTopicRulesRequest method.
//    req, resp := client.ListTopicRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListTopicRulesRequest(input *ListTopicRulesInput) (req *request.Request, output *ListTopicRulesOutput) {
	op := &request.Operation{
		Name:       opListTopicRules,
		HTTPMethod: "GET",
		HTTPPath:   "/rules",
	}

	if input == nil {
		input = &ListTopicRulesInput{}
	}

	output = &ListTopicRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTopicRules API operation for AWS IoT.
//
// Lists the rules for the specific topic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListTopicRules for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) ListTopicRules(input *ListTopicRulesInput) (*ListTopicRulesOutput, error) {
	req, out := c.ListTopicRulesRequest(input)
	return out, req.Send()
}

// ListTopicRulesWithContext is the same as ListTopicRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListTopicRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListTopicRulesWithContext(ctx aws.Context, input *ListTopicRulesInput, opts ...request.Option) (*ListTopicRulesOutput, error) {
	req, out := c.ListTopicRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListV2LoggingLevels = "ListV2LoggingLevels"

// ListV2LoggingLevelsRequest generates a "aws/request.Request" representing the
// client's request for the ListV2LoggingLevels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListV2LoggingLevels for more information on using the ListV2LoggingLevels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListV2LoggingLevelsRequest method.
//    req, resp := client.ListV2LoggingLevelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListV2LoggingLevelsRequest(input *ListV2LoggingLevelsInput) (req *request.Request, output *ListV2LoggingLevelsOutput) {
	op := &request.Operation{
		Name:       opListV2LoggingLevels,
		HTTPMethod: "GET",
		HTTPPath:   "/v2LoggingLevel",
	}

	if input == nil {
		input = &ListV2LoggingLevelsInput{}
	}

	output = &ListV2LoggingLevelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListV2LoggingLevels API operation for AWS IoT.
//
// Lists logging levels.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListV2LoggingLevels for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   An unexpected error has occurred.
//
//   * NotConfiguredException
//   The resource is not configured.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) ListV2LoggingLevels(input *ListV2LoggingLevelsInput) (*ListV2LoggingLevelsOutput, error) {
	req, out := c.ListV2LoggingLevelsRequest(input)
	return out, req.Send()
}

// ListV2LoggingLevelsWithContext is the same as ListV2LoggingLevels with the addition of
// the ability to pass a context and additional request options.
//
// See ListV2LoggingLevels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListV2LoggingLevelsWithContext(ctx aws.Context, input *ListV2LoggingLevelsInput, opts ...request.Option) (*ListV2LoggingLevelsOutput, error) {
	req, out := c.ListV2LoggingLevelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListViolationEvents = "ListViolationEvents"

// ListViolationEventsRequest generates a "aws/request.Request" representing the
// client's request for the ListViolationEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListViolationEvents for more information on using the ListViolationEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListViolationEventsRequest method.
//    req, resp := client.ListViolationEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListViolationEventsRequest(input *ListViolationEventsInput) (req *request.Request, output *ListViolationEventsOutput) {
	op := &request.Operation{
		Name:       opListViolationEvents,
		HTTPMethod: "GET",
		HTTPPath:   "/violation-events",
	}

	if input == nil {
		input = &ListViolationEventsInput{}
	}

	output = &ListViolationEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListViolationEvents API operation for AWS IoT.
//
// Lists the Device Defender security profile violations discovered during the
// given time period. You can use filters to limit the results to those alerts
// issued for a particular security profile, behavior, or thing (device).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListViolationEvents for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ListViolationEvents(input *ListViolationEventsInput) (*ListViolationEventsOutput, error) {
	req, out := c.ListViolationEventsRequest(input)
	return out, req.Send()
}

// ListViolationEventsWithContext is the same as ListViolationEvents with the addition of
// the ability to pass a context and additional request options.
//
// See ListViolationEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListViolationEventsWithContext(ctx aws.Context, input *ListViolationEventsInput, opts ...request.Option) (*ListViolationEventsOutput, error) {
	req, out := c.ListViolationEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterCACertificate = "RegisterCACertificate"

// RegisterCACertificateRequest generates a "aws/request.Request" representing the
// client's request for the RegisterCACertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterCACertificate for more information on using the RegisterCACertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterCACertificateRequest method.
//    req, resp := client.RegisterCACertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) RegisterCACertificateRequest(input *RegisterCACertificateInput) (req *request.Request, output *RegisterCACertificateOutput) {
	op := &request.Operation{
		Name:       opRegisterCACertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/cacertificate",
	}

	if input == nil {
		input = &RegisterCACertificateInput{}
	}

	output = &RegisterCACertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterCACertificate API operation for AWS IoT.
//
// Registers a CA certificate with AWS IoT. This CA certificate can then be
// used to sign device certificates, which can be then registered with AWS IoT.
// You can register up to 10 CA certificates per AWS account that have the same
// subject field. This enables you to have up to 10 certificate authorities
// sign your device certificates. If you have more than one CA certificate registered,
// make sure you pass the CA certificate when you register your device certificates
// with the RegisterCertificate API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation RegisterCACertificate for usage and error information.
//
// Returned Error Types:
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * RegistrationCodeValidationException
//   The registration code is invalid.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * CertificateValidationException
//   The certificate is invalid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) RegisterCACertificate(input *RegisterCACertificateInput) (*RegisterCACertificateOutput, error) {
	req, out := c.RegisterCACertificateRequest(input)
	return out, req.Send()
}

// RegisterCACertificateWithContext is the same as RegisterCACertificate with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterCACertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) RegisterCACertificateWithContext(ctx aws.Context, input *RegisterCACertificateInput, opts ...request.Option) (*RegisterCACertificateOutput, error) {
	req, out := c.RegisterCACertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterCertificate = "RegisterCertificate"

// RegisterCertificateRequest generates a "aws/request.Request" representing the
// client's request for the RegisterCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterCertificate for more information on using the RegisterCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterCertificateRequest method.
//    req, resp := client.RegisterCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) RegisterCertificateRequest(input *RegisterCertificateInput) (req *request.Request, output *RegisterCertificateOutput) {
	op := &request.Operation{
		Name:       opRegisterCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/certificate/register",
	}

	if input == nil {
		input = &RegisterCertificateInput{}
	}

	output = &RegisterCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterCertificate API operation for AWS IoT.
//
// Registers a device certificate with AWS IoT. If you have more than one CA
// certificate that has the same subject field, you must specify the CA certificate
// that was used to sign the device certificate being registered.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation RegisterCertificate for usage and error information.
//
// Returned Error Types:
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * CertificateValidationException
//   The certificate is invalid.
//
//   * CertificateStateException
//   The certificate operation is not allowed.
//
//   * CertificateConflictException
//   Unable to verify the CA certificate used to sign the device certificate you
//   are attempting to register. This is happens when you have registered more
//   than one CA certificate that has the same subject field and public key.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) RegisterCertificate(input *RegisterCertificateInput) (*RegisterCertificateOutput, error) {
	req, out := c.RegisterCertificateRequest(input)
	return out, req.Send()
}

// RegisterCertificateWithContext is the same as RegisterCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) RegisterCertificateWithContext(ctx aws.Context, input *RegisterCertificateInput, opts ...request.Option) (*RegisterCertificateOutput, error) {
	req, out := c.RegisterCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterThing = "RegisterThing"

// RegisterThingRequest generates a "aws/request.Request" representing the
// client's request for the RegisterThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterThing for more information on using the RegisterThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterThingRequest method.
//    req, resp := client.RegisterThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) RegisterThingRequest(input *RegisterThingInput) (req *request.Request, output *RegisterThingOutput) {
	op := &request.Operation{
		Name:       opRegisterThing,
		HTTPMethod: "POST",
		HTTPPath:   "/things",
	}

	if input == nil {
		input = &RegisterThingInput{}
	}

	output = &RegisterThingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterThing API operation for AWS IoT.
//
// Provisions a thing in the device registry. RegisterThing calls other AWS
// IoT control plane APIs. These calls might exceed your account level AWS IoT
// Throttling Limits (https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_iot)
// and cause throttle errors. Please contact AWS Customer Support (https://console.aws.amazon.com/support/home)
// to raise your throttling limits if necessary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation RegisterThing for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * ConflictingResourceUpdateException
//   A conflicting resource update exception. This exception is thrown when two
//   pending updates cause a conflict.
//
//   * ResourceRegistrationFailureException
//   The resource registration failed.
//
func (c *IoT) RegisterThing(input *RegisterThingInput) (*RegisterThingOutput, error) {
	req, out := c.RegisterThingRequest(input)
	return out, req.Send()
}

// RegisterThingWithContext is the same as RegisterThing with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) RegisterThingWithContext(ctx aws.Context, input *RegisterThingInput, opts ...request.Option) (*RegisterThingOutput, error) {
	req, out := c.RegisterThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectCertificateTransfer = "RejectCertificateTransfer"

// RejectCertificateTransferRequest generates a "aws/request.Request" representing the
// client's request for the RejectCertificateTransfer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectCertificateTransfer for more information on using the RejectCertificateTransfer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RejectCertificateTransferRequest method.
//    req, resp := client.RejectCertificateTransferRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) RejectCertificateTransferRequest(input *RejectCertificateTransferInput) (req *request.Request, output *RejectCertificateTransferOutput) {
	op := &request.Operation{
		Name:       opRejectCertificateTransfer,
		HTTPMethod: "PATCH",
		HTTPPath:   "/reject-certificate-transfer/{certificateId}",
	}

	if input == nil {
		input = &RejectCertificateTransferInput{}
	}

	output = &RejectCertificateTransferOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RejectCertificateTransfer API operation for AWS IoT.
//
// Rejects a pending certificate transfer. After AWS IoT rejects a certificate
// transfer, the certificate status changes from PENDING_TRANSFER to INACTIVE.
//
// To check for pending certificate transfers, call ListCertificates to enumerate
// your certificates.
//
// This operation can only be called by the transfer destination. After it is
// called, the certificate will be returned to the source's account in the INACTIVE
// state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation RejectCertificateTransfer for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * TransferAlreadyCompletedException
//   You can't revert the certificate transfer because the transfer is already
//   complete.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) RejectCertificateTransfer(input *RejectCertificateTransferInput) (*RejectCertificateTransferOutput, error) {
	req, out := c.RejectCertificateTransferRequest(input)
	return out, req.Send()
}

// RejectCertificateTransferWithContext is the same as RejectCertificateTransfer with the addition of
// the ability to pass a context and additional request options.
//
// See RejectCertificateTransfer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) RejectCertificateTransferWithContext(ctx aws.Context, input *RejectCertificateTransferInput, opts ...request.Option) (*RejectCertificateTransferOutput, error) {
	req, out := c.RejectCertificateTransferRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveThingFromBillingGroup = "RemoveThingFromBillingGroup"

// RemoveThingFromBillingGroupRequest generates a "aws/request.Request" representing the
// client's request for the RemoveThingFromBillingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveThingFromBillingGroup for more information on using the RemoveThingFromBillingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveThingFromBillingGroupRequest method.
//    req, resp := client.RemoveThingFromBillingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) RemoveThingFromBillingGroupRequest(input *RemoveThingFromBillingGroupInput) (req *request.Request, output *RemoveThingFromBillingGroupOutput) {
	op := &request.Operation{
		Name:       opRemoveThingFromBillingGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/billing-groups/removeThingFromBillingGroup",
	}

	if input == nil {
		input = &RemoveThingFromBillingGroupInput{}
	}

	output = &RemoveThingFromBillingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveThingFromBillingGroup API operation for AWS IoT.
//
// Removes the given thing from the billing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation RemoveThingFromBillingGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) RemoveThingFromBillingGroup(input *RemoveThingFromBillingGroupInput) (*RemoveThingFromBillingGroupOutput, error) {
	req, out := c.RemoveThingFromBillingGroupRequest(input)
	return out, req.Send()
}

// RemoveThingFromBillingGroupWithContext is the same as RemoveThingFromBillingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveThingFromBillingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) RemoveThingFromBillingGroupWithContext(ctx aws.Context, input *RemoveThingFromBillingGroupInput, opts ...request.Option) (*RemoveThingFromBillingGroupOutput, error) {
	req, out := c.RemoveThingFromBillingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveThingFromThingGroup = "RemoveThingFromThingGroup"

// RemoveThingFromThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the RemoveThingFromThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveThingFromThingGroup for more information on using the RemoveThingFromThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveThingFromThingGroupRequest method.
//    req, resp := client.RemoveThingFromThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) RemoveThingFromThingGroupRequest(input *RemoveThingFromThingGroupInput) (req *request.Request, output *RemoveThingFromThingGroupOutput) {
	op := &request.Operation{
		Name:       opRemoveThingFromThingGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/thing-groups/removeThingFromThingGroup",
	}

	if input == nil {
		input = &RemoveThingFromThingGroupInput{}
	}

	output = &RemoveThingFromThingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveThingFromThingGroup API operation for AWS IoT.
//
// Remove the specified thing from the specified group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation RemoveThingFromThingGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) RemoveThingFromThingGroup(input *RemoveThingFromThingGroupInput) (*RemoveThingFromThingGroupOutput, error) {
	req, out := c.RemoveThingFromThingGroupRequest(input)
	return out, req.Send()
}

// RemoveThingFromThingGroupWithContext is the same as RemoveThingFromThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveThingFromThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) RemoveThingFromThingGroupWithContext(ctx aws.Context, input *RemoveThingFromThingGroupInput, opts ...request.Option) (*RemoveThingFromThingGroupOutput, error) {
	req, out := c.RemoveThingFromThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReplaceTopicRule = "ReplaceTopicRule"

// ReplaceTopicRuleRequest generates a "aws/request.Request" representing the
// client's request for the ReplaceTopicRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReplaceTopicRule for more information on using the ReplaceTopicRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ReplaceTopicRuleRequest method.
//    req, resp := client.ReplaceTopicRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ReplaceTopicRuleRequest(input *ReplaceTopicRuleInput) (req *request.Request, output *ReplaceTopicRuleOutput) {
	op := &request.Operation{
		Name:       opReplaceTopicRule,
		HTTPMethod: "PATCH",
		HTTPPath:   "/rules/{ruleName}",
	}

	if input == nil {
		input = &ReplaceTopicRuleInput{}
	}

	output = &ReplaceTopicRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ReplaceTopicRule API operation for AWS IoT.
//
// Replaces the rule. You must specify all parameters for the new rule. Creating
// rules is an administrator-level action. Any user who has permission to create
// rules will be able to access data processed by the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ReplaceTopicRule for usage and error information.
//
// Returned Error Types:
//   * SqlParseException
//   The Rule-SQL expression can't be parsed correctly.
//
//   * InternalException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ConflictingResourceUpdateException
//   A conflicting resource update exception. This exception is thrown when two
//   pending updates cause a conflict.
//
func (c *IoT) ReplaceTopicRule(input *ReplaceTopicRuleInput) (*ReplaceTopicRuleOutput, error) {
	req, out := c.ReplaceTopicRuleRequest(input)
	return out, req.Send()
}

// ReplaceTopicRuleWithContext is the same as ReplaceTopicRule with the addition of
// the ability to pass a context and additional request options.
//
// See ReplaceTopicRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ReplaceTopicRuleWithContext(ctx aws.Context, input *ReplaceTopicRuleInput, opts ...request.Option) (*ReplaceTopicRuleOutput, error) {
	req, out := c.ReplaceTopicRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchIndex = "SearchIndex"

// SearchIndexRequest generates a "aws/request.Request" representing the
// client's request for the SearchIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchIndex for more information on using the SearchIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchIndexRequest method.
//    req, resp := client.SearchIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) SearchIndexRequest(input *SearchIndexInput) (req *request.Request, output *SearchIndexOutput) {
	op := &request.Operation{
		Name:       opSearchIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/indices/search",
	}

	if input == nil {
		input = &SearchIndexInput{}
	}

	output = &SearchIndexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchIndex API operation for AWS IoT.
//
// The query search index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation SearchIndex for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidQueryException
//   The query is invalid.
//
//   * IndexNotReadyException
//   The index is not ready.
//
func (c *IoT) SearchIndex(input *SearchIndexInput) (*SearchIndexOutput, error) {
	req, out := c.SearchIndexRequest(input)
	return out, req.Send()
}

// SearchIndexWithContext is the same as SearchIndex with the addition of
// the ability to pass a context and additional request options.
//
// See SearchIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) SearchIndexWithContext(ctx aws.Context, input *SearchIndexInput, opts ...request.Option) (*SearchIndexOutput, error) {
	req, out := c.SearchIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetDefaultAuthorizer = "SetDefaultAuthorizer"

// SetDefaultAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the SetDefaultAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetDefaultAuthorizer for more information on using the SetDefaultAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetDefaultAuthorizerRequest method.
//    req, resp := client.SetDefaultAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) SetDefaultAuthorizerRequest(input *SetDefaultAuthorizerInput) (req *request.Request, output *SetDefaultAuthorizerOutput) {
	op := &request.Operation{
		Name:       opSetDefaultAuthorizer,
		HTTPMethod: "POST",
		HTTPPath:   "/default-authorizer",
	}

	if input == nil {
		input = &SetDefaultAuthorizerInput{}
	}

	output = &SetDefaultAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetDefaultAuthorizer API operation for AWS IoT.
//
// Sets the default authorizer. This will be used if a websocket connection
// is made without specifying an authorizer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation SetDefaultAuthorizer for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
func (c *IoT) SetDefaultAuthorizer(input *SetDefaultAuthorizerInput) (*SetDefaultAuthorizerOutput, error) {
	req, out := c.SetDefaultAuthorizerRequest(input)
	return out, req.Send()
}

// SetDefaultAuthorizerWithContext is the same as SetDefaultAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See SetDefaultAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) SetDefaultAuthorizerWithContext(ctx aws.Context, input *SetDefaultAuthorizerInput, opts ...request.Option) (*SetDefaultAuthorizerOutput, error) {
	req, out := c.SetDefaultAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetDefaultPolicyVersion = "SetDefaultPolicyVersion"

// SetDefaultPolicyVersionRequest generates a "aws/request.Request" representing the
// client's request for the SetDefaultPolicyVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetDefaultPolicyVersion for more information on using the SetDefaultPolicyVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetDefaultPolicyVersionRequest method.
//    req, resp := client.SetDefaultPolicyVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) SetDefaultPolicyVersionRequest(input *SetDefaultPolicyVersionInput) (req *request.Request, output *SetDefaultPolicyVersionOutput) {
	op := &request.Operation{
		Name:       opSetDefaultPolicyVersion,
		HTTPMethod: "PATCH",
		HTTPPath:   "/policies/{policyName}/version/{policyVersionId}",
	}

	if input == nil {
		input = &SetDefaultPolicyVersionInput{}
	}

	output = &SetDefaultPolicyVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetDefaultPolicyVersion API operation for AWS IoT.
//
// Sets the specified version of the specified policy as the policy's default
// (operative) version. This action affects all certificates to which the policy
// is attached. To list the principals the policy is attached to, use the ListPrincipalPolicy
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation SetDefaultPolicyVersion for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) SetDefaultPolicyVersion(input *SetDefaultPolicyVersionInput) (*SetDefaultPolicyVersionOutput, error) {
	req, out := c.SetDefaultPolicyVersionRequest(input)
	return out, req.Send()
}

// SetDefaultPolicyVersionWithContext is the same as SetDefaultPolicyVersion with the addition of
// the ability to pass a context and additional request options.
//
// See SetDefaultPolicyVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) SetDefaultPolicyVersionWithContext(ctx aws.Context, input *SetDefaultPolicyVersionInput, opts ...request.Option) (*SetDefaultPolicyVersionOutput, error) {
	req, out := c.SetDefaultPolicyVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetLoggingOptions = "SetLoggingOptions"

// SetLoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the SetLoggingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetLoggingOptions for more information on using the SetLoggingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetLoggingOptionsRequest method.
//    req, resp := client.SetLoggingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) SetLoggingOptionsRequest(input *SetLoggingOptionsInput) (req *request.Request, output *SetLoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opSetLoggingOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/loggingOptions",
	}

	if input == nil {
		input = &SetLoggingOptionsInput{}
	}

	output = &SetLoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetLoggingOptions API operation for AWS IoT.
//
// Sets the logging options.
//
// NOTE: use of this command is not recommended. Use SetV2LoggingOptions instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation SetLoggingOptions for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) SetLoggingOptions(input *SetLoggingOptionsInput) (*SetLoggingOptionsOutput, error) {
	req, out := c.SetLoggingOptionsRequest(input)
	return out, req.Send()
}

// SetLoggingOptionsWithContext is the same as SetLoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See SetLoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) SetLoggingOptionsWithContext(ctx aws.Context, input *SetLoggingOptionsInput, opts ...request.Option) (*SetLoggingOptionsOutput, error) {
	req, out := c.SetLoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetV2LoggingLevel = "SetV2LoggingLevel"

// SetV2LoggingLevelRequest generates a "aws/request.Request" representing the
// client's request for the SetV2LoggingLevel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetV2LoggingLevel for more information on using the SetV2LoggingLevel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetV2LoggingLevelRequest method.
//    req, resp := client.SetV2LoggingLevelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) SetV2LoggingLevelRequest(input *SetV2LoggingLevelInput) (req *request.Request, output *SetV2LoggingLevelOutput) {
	op := &request.Operation{
		Name:       opSetV2LoggingLevel,
		HTTPMethod: "POST",
		HTTPPath:   "/v2LoggingLevel",
	}

	if input == nil {
		input = &SetV2LoggingLevelInput{}
	}

	output = &SetV2LoggingLevelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetV2LoggingLevel API operation for AWS IoT.
//
// Sets the logging level.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation SetV2LoggingLevel for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   An unexpected error has occurred.
//
//   * NotConfiguredException
//   The resource is not configured.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) SetV2LoggingLevel(input *SetV2LoggingLevelInput) (*SetV2LoggingLevelOutput, error) {
	req, out := c.SetV2LoggingLevelRequest(input)
	return out, req.Send()
}

// SetV2LoggingLevelWithContext is the same as SetV2LoggingLevel with the addition of
// the ability to pass a context and additional request options.
//
// See SetV2LoggingLevel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) SetV2LoggingLevelWithContext(ctx aws.Context, input *SetV2LoggingLevelInput, opts ...request.Option) (*SetV2LoggingLevelOutput, error) {
	req, out := c.SetV2LoggingLevelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetV2LoggingOptions = "SetV2LoggingOptions"

// SetV2LoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the SetV2LoggingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetV2LoggingOptions for more information on using the SetV2LoggingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetV2LoggingOptionsRequest method.
//    req, resp := client.SetV2LoggingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) SetV2LoggingOptionsRequest(input *SetV2LoggingOptionsInput) (req *request.Request, output *SetV2LoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opSetV2LoggingOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/v2LoggingOptions",
	}

	if input == nil {
		input = &SetV2LoggingOptionsInput{}
	}

	output = &SetV2LoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetV2LoggingOptions API operation for AWS IoT.
//
// Sets the logging options for the V2 logging service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation SetV2LoggingOptions for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) SetV2LoggingOptions(input *SetV2LoggingOptionsInput) (*SetV2LoggingOptionsOutput, error) {
	req, out := c.SetV2LoggingOptionsRequest(input)
	return out, req.Send()
}

// SetV2LoggingOptionsWithContext is the same as SetV2LoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See SetV2LoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) SetV2LoggingOptionsWithContext(ctx aws.Context, input *SetV2LoggingOptionsInput, opts ...request.Option) (*SetV2LoggingOptionsOutput, error) {
	req, out := c.SetV2LoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartAuditMitigationActionsTask = "StartAuditMitigationActionsTask"

// StartAuditMitigationActionsTaskRequest generates a "aws/request.Request" representing the
// client's request for the StartAuditMitigationActionsTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartAuditMitigationActionsTask for more information on using the StartAuditMitigationActionsTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartAuditMitigationActionsTaskRequest method.
//    req, resp := client.StartAuditMitigationActionsTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) StartAuditMitigationActionsTaskRequest(input *StartAuditMitigationActionsTaskInput) (req *request.Request, output *StartAuditMitigationActionsTaskOutput) {
	op := &request.Operation{
		Name:       opStartAuditMitigationActionsTask,
		HTTPMethod: "POST",
		HTTPPath:   "/audit/mitigationactions/tasks/{taskId}",
	}

	if input == nil {
		input = &StartAuditMitigationActionsTaskInput{}
	}

	output = &StartAuditMitigationActionsTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartAuditMitigationActionsTask API operation for AWS IoT.
//
// Starts a task that applies a set of mitigation actions to the specified target.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation StartAuditMitigationActionsTask for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * TaskAlreadyExistsException
//   This exception occurs if you attempt to start a task with the same task-id
//   as an existing task but with a different clientRequestToken.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) StartAuditMitigationActionsTask(input *StartAuditMitigationActionsTaskInput) (*StartAuditMitigationActionsTaskOutput, error) {
	req, out := c.StartAuditMitigationActionsTaskRequest(input)
	return out, req.Send()
}

// StartAuditMitigationActionsTaskWithContext is the same as StartAuditMitigationActionsTask with the addition of
// the ability to pass a context and additional request options.
//
// See StartAuditMitigationActionsTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) StartAuditMitigationActionsTaskWithContext(ctx aws.Context, input *StartAuditMitigationActionsTaskInput, opts ...request.Option) (*StartAuditMitigationActionsTaskOutput, error) {
	req, out := c.StartAuditMitigationActionsTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartOnDemandAuditTask = "StartOnDemandAuditTask"

// StartOnDemandAuditTaskRequest generates a "aws/request.Request" representing the
// client's request for the StartOnDemandAuditTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartOnDemandAuditTask for more information on using the StartOnDemandAuditTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartOnDemandAuditTaskRequest method.
//    req, resp := client.StartOnDemandAuditTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) StartOnDemandAuditTaskRequest(input *StartOnDemandAuditTaskInput) (req *request.Request, output *StartOnDemandAuditTaskOutput) {
	op := &request.Operation{
		Name:       opStartOnDemandAuditTask,
		HTTPMethod: "POST",
		HTTPPath:   "/audit/tasks",
	}

	if input == nil {
		input = &StartOnDemandAuditTaskInput{}
	}

	output = &StartOnDemandAuditTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartOnDemandAuditTask API operation for AWS IoT.
//
// Starts an on-demand Device Defender audit.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation StartOnDemandAuditTask for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
func (c *IoT) StartOnDemandAuditTask(input *StartOnDemandAuditTaskInput) (*StartOnDemandAuditTaskOutput, error) {
	req, out := c.StartOnDemandAuditTaskRequest(input)
	return out, req.Send()
}

// StartOnDemandAuditTaskWithContext is the same as StartOnDemandAuditTask with the addition of
// the ability to pass a context and additional request options.
//
// See StartOnDemandAuditTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) StartOnDemandAuditTaskWithContext(ctx aws.Context, input *StartOnDemandAuditTaskInput, opts ...request.Option) (*StartOnDemandAuditTaskOutput, error) {
	req, out := c.StartOnDemandAuditTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartThingRegistrationTask = "StartThingRegistrationTask"

// StartThingRegistrationTaskRequest generates a "aws/request.Request" representing the
// client's request for the StartThingRegistrationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartThingRegistrationTask for more information on using the StartThingRegistrationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartThingRegistrationTaskRequest method.
//    req, resp := client.StartThingRegistrationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) StartThingRegistrationTaskRequest(input *StartThingRegistrationTaskInput) (req *request.Request, output *StartThingRegistrationTaskOutput) {
	op := &request.Operation{
		Name:       opStartThingRegistrationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/thing-registration-tasks",
	}

	if input == nil {
		input = &StartThingRegistrationTaskInput{}
	}

	output = &StartThingRegistrationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartThingRegistrationTask API operation for AWS IoT.
//
// Creates a bulk thing provisioning task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation StartThingRegistrationTask for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) StartThingRegistrationTask(input *StartThingRegistrationTaskInput) (*StartThingRegistrationTaskOutput, error) {
	req, out := c.StartThingRegistrationTaskRequest(input)
	return out, req.Send()
}

// StartThingRegistrationTaskWithContext is the same as StartThingRegistrationTask with the addition of
// the ability to pass a context and additional request options.
//
// See StartThingRegistrationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) StartThingRegistrationTaskWithContext(ctx aws.Context, input *StartThingRegistrationTaskInput, opts ...request.Option) (*StartThingRegistrationTaskOutput, error) {
	req, out := c.StartThingRegistrationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopThingRegistrationTask = "StopThingRegistrationTask"

// StopThingRegistrationTaskRequest generates a "aws/request.Request" representing the
// client's request for the StopThingRegistrationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopThingRegistrationTask for more information on using the StopThingRegistrationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopThingRegistrationTaskRequest method.
//    req, resp := client.StopThingRegistrationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) StopThingRegistrationTaskRequest(input *StopThingRegistrationTaskInput) (req *request.Request, output *StopThingRegistrationTaskOutput) {
	op := &request.Operation{
		Name:       opStopThingRegistrationTask,
		HTTPMethod: "PUT",
		HTTPPath:   "/thing-registration-tasks/{taskId}/cancel",
	}

	if input == nil {
		input = &StopThingRegistrationTaskInput{}
	}

	output = &StopThingRegistrationTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopThingRegistrationTask API operation for AWS IoT.
//
// Cancels a bulk thing provisioning task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation StopThingRegistrationTask for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) StopThingRegistrationTask(input *StopThingRegistrationTaskInput) (*StopThingRegistrationTaskOutput, error) {
	req, out := c.StopThingRegistrationTaskRequest(input)
	return out, req.Send()
}

// StopThingRegistrationTaskWithContext is the same as StopThingRegistrationTask with the addition of
// the ability to pass a context and additional request options.
//
// See StopThingRegistrationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) StopThingRegistrationTaskWithContext(ctx aws.Context, input *StopThingRegistrationTaskInput, opts ...request.Option) (*StopThingRegistrationTaskOutput, error) {
	req, out := c.StopThingRegistrationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS IoT.
//
// Adds to or modifies the tags of the given resource. Tags are metadata which
// can be used to manage a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
func (c *IoT) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestAuthorization = "TestAuthorization"

// TestAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the TestAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestAuthorization for more information on using the TestAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TestAuthorizationRequest method.
//    req, resp := client.TestAuthorizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) TestAuthorizationRequest(input *TestAuthorizationInput) (req *request.Request, output *TestAuthorizationOutput) {
	op := &request.Operation{
		Name:       opTestAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/test-authorization",
	}

	if input == nil {
		input = &TestAuthorizationInput{}
	}

	output = &TestAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestAuthorization API operation for AWS IoT.
//
// Tests if a specified principal is authorized to perform an AWS IoT action
// on a specified resource. Use this to test and debug the authorization behavior
// of devices that connect to the AWS IoT device gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation TestAuthorization for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
func (c *IoT) TestAuthorization(input *TestAuthorizationInput) (*TestAuthorizationOutput, error) {
	req, out := c.TestAuthorizationRequest(input)
	return out, req.Send()
}

// TestAuthorizationWithContext is the same as TestAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See TestAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) TestAuthorizationWithContext(ctx aws.Context, input *TestAuthorizationInput, opts ...request.Option) (*TestAuthorizationOutput, error) {
	req, out := c.TestAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestInvokeAuthorizer = "TestInvokeAuthorizer"

// TestInvokeAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the TestInvokeAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestInvokeAuthorizer for more information on using the TestInvokeAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TestInvokeAuthorizerRequest method.
//    req, resp := client.TestInvokeAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) TestInvokeAuthorizerRequest(input *TestInvokeAuthorizerInput) (req *request.Request, output *TestInvokeAuthorizerOutput) {
	op := &request.Operation{
		Name:       opTestInvokeAuthorizer,
		HTTPMethod: "POST",
		HTTPPath:   "/authorizer/{authorizerName}/test",
	}

	if input == nil {
		input = &TestInvokeAuthorizerInput{}
	}

	output = &TestInvokeAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestInvokeAuthorizer API operation for AWS IoT.
//
// Tests a custom authorization behavior by invoking a specified custom authorizer.
// Use this to test and debug the custom authorization behavior of devices that
// connect to the AWS IoT device gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation TestInvokeAuthorizer for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidResponseException
//   The response is invalid.
//
func (c *IoT) TestInvokeAuthorizer(input *TestInvokeAuthorizerInput) (*TestInvokeAuthorizerOutput, error) {
	req, out := c.TestInvokeAuthorizerRequest(input)
	return out, req.Send()
}

// TestInvokeAuthorizerWithContext is the same as TestInvokeAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See TestInvokeAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) TestInvokeAuthorizerWithContext(ctx aws.Context, input *TestInvokeAuthorizerInput, opts ...request.Option) (*TestInvokeAuthorizerOutput, error) {
	req, out := c.TestInvokeAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTransferCertificate = "TransferCertificate"

// TransferCertificateRequest generates a "aws/request.Request" representing the
// client's request for the TransferCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TransferCertificate for more information on using the TransferCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TransferCertificateRequest method.
//    req, resp := client.TransferCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) TransferCertificateRequest(input *TransferCertificateInput) (req *request.Request, output *TransferCertificateOutput) {
	op := &request.Operation{
		Name:       opTransferCertificate,
		HTTPMethod: "PATCH",
		HTTPPath:   "/transfer-certificate/{certificateId}",
	}

	if input == nil {
		input = &TransferCertificateInput{}
	}

	output = &TransferCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TransferCertificate API operation for AWS IoT.
//
// Transfers the specified certificate to the specified AWS account.
//
// You can cancel the transfer until it is acknowledged by the recipient.
//
// No notification is sent to the transfer destination's account. It is up to
// the caller to notify the transfer target.
//
// The certificate being transferred must not be in the ACTIVE state. You can
// use the UpdateCertificate API to deactivate it.
//
// The certificate must not have any policies attached to it. You can use the
// DetachPrincipalPolicy API to detach them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation TransferCertificate for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * CertificateStateException
//   The certificate operation is not allowed.
//
//   * TransferConflictException
//   You can't transfer the certificate because authorization policies are still
//   attached.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) TransferCertificate(input *TransferCertificateInput) (*TransferCertificateOutput, error) {
	req, out := c.TransferCertificateRequest(input)
	return out, req.Send()
}

// TransferCertificateWithContext is the same as TransferCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See TransferCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) TransferCertificateWithContext(ctx aws.Context, input *TransferCertificateInput, opts ...request.Option) (*TransferCertificateOutput, error) {
	req, out := c.TransferCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/untag",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS IoT.
//
// Removes the given tags (metadata) from the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
func (c *IoT) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccountAuditConfiguration = "UpdateAccountAuditConfiguration"

// UpdateAccountAuditConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccountAuditConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccountAuditConfiguration for more information on using the UpdateAccountAuditConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAccountAuditConfigurationRequest method.
//    req, resp := client.UpdateAccountAuditConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateAccountAuditConfigurationRequest(input *UpdateAccountAuditConfigurationInput) (req *request.Request, output *UpdateAccountAuditConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateAccountAuditConfiguration,
		HTTPMethod: "PATCH",
		HTTPPath:   "/audit/configuration",
	}

	if input == nil {
		input = &UpdateAccountAuditConfigurationInput{}
	}

	output = &UpdateAccountAuditConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateAccountAuditConfiguration API operation for AWS IoT.
//
// Configures or reconfigures the Device Defender audit settings for this account.
// Settings include how audit notifications are sent and which audit checks
// are enabled or disabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateAccountAuditConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) UpdateAccountAuditConfiguration(input *UpdateAccountAuditConfigurationInput) (*UpdateAccountAuditConfigurationOutput, error) {
	req, out := c.UpdateAccountAuditConfigurationRequest(input)
	return out, req.Send()
}

// UpdateAccountAuditConfigurationWithContext is the same as UpdateAccountAuditConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccountAuditConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateAccountAuditConfigurationWithContext(ctx aws.Context, input *UpdateAccountAuditConfigurationInput, opts ...request.Option) (*UpdateAccountAuditConfigurationOutput, error) {
	req, out := c.UpdateAccountAuditConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAuthorizer = "UpdateAuthorizer"

// UpdateAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAuthorizer for more information on using the UpdateAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAuthorizerRequest method.
//    req, resp := client.UpdateAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateAuthorizerRequest(input *UpdateAuthorizerInput) (req *request.Request, output *UpdateAuthorizerOutput) {
	op := &request.Operation{
		Name:       opUpdateAuthorizer,
		HTTPMethod: "PUT",
		HTTPPath:   "/authorizer/{authorizerName}",
	}

	if input == nil {
		input = &UpdateAuthorizerInput{}
	}

	output = &UpdateAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAuthorizer API operation for AWS IoT.
//
// Updates an authorizer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateAuthorizer for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) UpdateAuthorizer(input *UpdateAuthorizerInput) (*UpdateAuthorizerOutput, error) {
	req, out := c.UpdateAuthorizerRequest(input)
	return out, req.Send()
}

// UpdateAuthorizerWithContext is the same as UpdateAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateAuthorizerWithContext(ctx aws.Context, input *UpdateAuthorizerInput, opts ...request.Option) (*UpdateAuthorizerOutput, error) {
	req, out := c.UpdateAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBillingGroup = "UpdateBillingGroup"

// UpdateBillingGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBillingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBillingGroup for more information on using the UpdateBillingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBillingGroupRequest method.
//    req, resp := client.UpdateBillingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateBillingGroupRequest(input *UpdateBillingGroupInput) (req *request.Request, output *UpdateBillingGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateBillingGroup,
		HTTPMethod: "PATCH",
		HTTPPath:   "/billing-groups/{billingGroupName}",
	}

	if input == nil {
		input = &UpdateBillingGroupInput{}
	}

	output = &UpdateBillingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBillingGroup API operation for AWS IoT.
//
// Updates information about the billing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateBillingGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * VersionConflictException
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) UpdateBillingGroup(input *UpdateBillingGroupInput) (*UpdateBillingGroupOutput, error) {
	req, out := c.UpdateBillingGroupRequest(input)
	return out, req.Send()
}

// UpdateBillingGroupWithContext is the same as UpdateBillingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBillingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateBillingGroupWithContext(ctx aws.Context, input *UpdateBillingGroupInput, opts ...request.Option) (*UpdateBillingGroupOutput, error) {
	req, out := c.UpdateBillingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCACertificate = "UpdateCACertificate"

// UpdateCACertificateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCACertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCACertificate for more information on using the UpdateCACertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCACertificateRequest method.
//    req, resp := client.UpdateCACertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateCACertificateRequest(input *UpdateCACertificateInput) (req *request.Request, output *UpdateCACertificateOutput) {
	op := &request.Operation{
		Name:       opUpdateCACertificate,
		HTTPMethod: "PUT",
		HTTPPath:   "/cacertificate/{caCertificateId}",
	}

	if input == nil {
		input = &UpdateCACertificateInput{}
	}

	output = &UpdateCACertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCACertificate API operation for AWS IoT.
//
// Updates a registered CA certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateCACertificate for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) UpdateCACertificate(input *UpdateCACertificateInput) (*UpdateCACertificateOutput, error) {
	req, out := c.UpdateCACertificateRequest(input)
	return out, req.Send()
}

// UpdateCACertificateWithContext is the same as UpdateCACertificate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCACertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateCACertificateWithContext(ctx aws.Context, input *UpdateCACertificateInput, opts ...request.Option) (*UpdateCACertificateOutput, error) {
	req, out := c.UpdateCACertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCertificate = "UpdateCertificate"

// UpdateCertificateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCertificate for more information on using the UpdateCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCertificateRequest method.
//    req, resp := client.UpdateCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateCertificateRequest(input *UpdateCertificateInput) (req *request.Request, output *UpdateCertificateOutput) {
	op := &request.Operation{
		Name:       opUpdateCertificate,
		HTTPMethod: "PUT",
		HTTPPath:   "/certificates/{certificateId}",
	}

	if input == nil {
		input = &UpdateCertificateInput{}
	}

	output = &UpdateCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCertificate API operation for AWS IoT.
//
// Updates the status of the specified certificate. This operation is idempotent.
//
// Moving a certificate from the ACTIVE state (including REVOKED) will not disconnect
// currently connected devices, but these devices will be unable to reconnect.
//
// The ACTIVE state is required to authenticate devices connecting to AWS IoT
// using a certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateCertificate for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * CertificateStateException
//   The certificate operation is not allowed.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) UpdateCertificate(input *UpdateCertificateInput) (*UpdateCertificateOutput, error) {
	req, out := c.UpdateCertificateRequest(input)
	return out, req.Send()
}

// UpdateCertificateWithContext is the same as UpdateCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateCertificateWithContext(ctx aws.Context, input *UpdateCertificateInput, opts ...request.Option) (*UpdateCertificateOutput, error) {
	req, out := c.UpdateCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDimension = "UpdateDimension"

// UpdateDimensionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDimension operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDimension for more information on using the UpdateDimension
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDimensionRequest method.
//    req, resp := client.UpdateDimensionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateDimensionRequest(input *UpdateDimensionInput) (req *request.Request, output *UpdateDimensionOutput) {
	op := &request.Operation{
		Name:       opUpdateDimension,
		HTTPMethod: "PATCH",
		HTTPPath:   "/dimensions/{name}",
	}

	if input == nil {
		input = &UpdateDimensionInput{}
	}

	output = &UpdateDimensionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDimension API operation for AWS IoT.
//
// Updates the definition for a dimension. You cannot change the type of a dimension
// after it is created (you can delete it and re-create it).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateDimension for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
func (c *IoT) UpdateDimension(input *UpdateDimensionInput) (*UpdateDimensionOutput, error) {
	req, out := c.UpdateDimensionRequest(input)
	return out, req.Send()
}

// UpdateDimensionWithContext is the same as UpdateDimension with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDimension for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateDimensionWithContext(ctx aws.Context, input *UpdateDimensionInput, opts ...request.Option) (*UpdateDimensionOutput, error) {
	req, out := c.UpdateDimensionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDomainConfiguration = "UpdateDomainConfiguration"

// UpdateDomainConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDomainConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDomainConfiguration for more information on using the UpdateDomainConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDomainConfigurationRequest method.
//    req, resp := client.UpdateDomainConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateDomainConfigurationRequest(input *UpdateDomainConfigurationInput) (req *request.Request, output *UpdateDomainConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateDomainConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/domainConfigurations/{domainConfigurationName}",
	}

	if input == nil {
		input = &UpdateDomainConfigurationInput{}
	}

	output = &UpdateDomainConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDomainConfiguration API operation for AWS IoT.
//
// Updates values stored in the domain configuration. Domain configurations
// for default endpoints can't be updated.
//
// The domain configuration feature is in public preview and is subject to change.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateDomainConfiguration for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * CertificateValidationException
//   The certificate is invalid.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) UpdateDomainConfiguration(input *UpdateDomainConfigurationInput) (*UpdateDomainConfigurationOutput, error) {
	req, out := c.UpdateDomainConfigurationRequest(input)
	return out, req.Send()
}

// UpdateDomainConfigurationWithContext is the same as UpdateDomainConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDomainConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateDomainConfigurationWithContext(ctx aws.Context, input *UpdateDomainConfigurationInput, opts ...request.Option) (*UpdateDomainConfigurationOutput, error) {
	req, out := c.UpdateDomainConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDynamicThingGroup = "UpdateDynamicThingGroup"

// UpdateDynamicThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDynamicThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDynamicThingGroup for more information on using the UpdateDynamicThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDynamicThingGroupRequest method.
//    req, resp := client.UpdateDynamicThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateDynamicThingGroupRequest(input *UpdateDynamicThingGroupInput) (req *request.Request, output *UpdateDynamicThingGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateDynamicThingGroup,
		HTTPMethod: "PATCH",
		HTTPPath:   "/dynamic-thing-groups/{thingGroupName}",
	}

	if input == nil {
		input = &UpdateDynamicThingGroupInput{}
	}

	output = &UpdateDynamicThingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDynamicThingGroup API operation for AWS IoT.
//
// Updates a dynamic thing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateDynamicThingGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * VersionConflictException
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidQueryException
//   The query is invalid.
//
func (c *IoT) UpdateDynamicThingGroup(input *UpdateDynamicThingGroupInput) (*UpdateDynamicThingGroupOutput, error) {
	req, out := c.UpdateDynamicThingGroupRequest(input)
	return out, req.Send()
}

// UpdateDynamicThingGroupWithContext is the same as UpdateDynamicThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDynamicThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateDynamicThingGroupWithContext(ctx aws.Context, input *UpdateDynamicThingGroupInput, opts ...request.Option) (*UpdateDynamicThingGroupOutput, error) {
	req, out := c.UpdateDynamicThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEventConfigurations = "UpdateEventConfigurations"

// UpdateEventConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEventConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEventConfigurations for more information on using the UpdateEventConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEventConfigurationsRequest method.
//    req, resp := client.UpdateEventConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateEventConfigurationsRequest(input *UpdateEventConfigurationsInput) (req *request.Request, output *UpdateEventConfigurationsOutput) {
	op := &request.Operation{
		Name:       opUpdateEventConfigurations,
		HTTPMethod: "PATCH",
		HTTPPath:   "/event-configurations",
	}

	if input == nil {
		input = &UpdateEventConfigurationsInput{}
	}

	output = &UpdateEventConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateEventConfigurations API operation for AWS IoT.
//
// Updates the event configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateEventConfigurations for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
func (c *IoT) UpdateEventConfigurations(input *UpdateEventConfigurationsInput) (*UpdateEventConfigurationsOutput, error) {
	req, out := c.UpdateEventConfigurationsRequest(input)
	return out, req.Send()
}

// UpdateEventConfigurationsWithContext is the same as UpdateEventConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEventConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateEventConfigurationsWithContext(ctx aws.Context, input *UpdateEventConfigurationsInput, opts ...request.Option) (*UpdateEventConfigurationsOutput, error) {
	req, out := c.UpdateEventConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIndexingConfiguration = "UpdateIndexingConfiguration"

// UpdateIndexingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIndexingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIndexingConfiguration for more information on using the UpdateIndexingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIndexingConfigurationRequest method.
//    req, resp := client.UpdateIndexingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateIndexingConfigurationRequest(input *UpdateIndexingConfigurationInput) (req *request.Request, output *UpdateIndexingConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateIndexingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/indexing/config",
	}

	if input == nil {
		input = &UpdateIndexingConfigurationInput{}
	}

	output = &UpdateIndexingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateIndexingConfiguration API operation for AWS IoT.
//
// Updates the search configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateIndexingConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) UpdateIndexingConfiguration(input *UpdateIndexingConfigurationInput) (*UpdateIndexingConfigurationOutput, error) {
	req, out := c.UpdateIndexingConfigurationRequest(input)
	return out, req.Send()
}

// UpdateIndexingConfigurationWithContext is the same as UpdateIndexingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIndexingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateIndexingConfigurationWithContext(ctx aws.Context, input *UpdateIndexingConfigurationInput, opts ...request.Option) (*UpdateIndexingConfigurationOutput, error) {
	req, out := c.UpdateIndexingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateJob = "UpdateJob"

// UpdateJobRequest generates a "aws/request.Request" representing the
// client's request for the UpdateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateJob for more information on using the UpdateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateJobRequest method.
//    req, resp := client.UpdateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateJobRequest(input *UpdateJobInput) (req *request.Request, output *UpdateJobOutput) {
	op := &request.Operation{
		Name:       opUpdateJob,
		HTTPMethod: "PATCH",
		HTTPPath:   "/jobs/{jobId}",
	}

	if input == nil {
		input = &UpdateJobInput{}
	}

	output = &UpdateJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateJob API operation for AWS IoT.
//
// Updates supported fields of the specified job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
func (c *IoT) UpdateJob(input *UpdateJobInput) (*UpdateJobOutput, error) {
	req, out := c.UpdateJobRequest(input)
	return out, req.Send()
}

// UpdateJobWithContext is the same as UpdateJob with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateJobWithContext(ctx aws.Context, input *UpdateJobInput, opts ...request.Option) (*UpdateJobOutput, error) {
	req, out := c.UpdateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMitigationAction = "UpdateMitigationAction"

// UpdateMitigationActionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMitigationAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMitigationAction for more information on using the UpdateMitigationAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMitigationActionRequest method.
//    req, resp := client.UpdateMitigationActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateMitigationActionRequest(input *UpdateMitigationActionInput) (req *request.Request, output *UpdateMitigationActionOutput) {
	op := &request.Operation{
		Name:       opUpdateMitigationAction,
		HTTPMethod: "PATCH",
		HTTPPath:   "/mitigationactions/actions/{actionName}",
	}

	if input == nil {
		input = &UpdateMitigationActionInput{}
	}

	output = &UpdateMitigationActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMitigationAction API operation for AWS IoT.
//
// Updates the definition for the specified mitigation action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateMitigationAction for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) UpdateMitigationAction(input *UpdateMitigationActionInput) (*UpdateMitigationActionOutput, error) {
	req, out := c.UpdateMitigationActionRequest(input)
	return out, req.Send()
}

// UpdateMitigationActionWithContext is the same as UpdateMitigationAction with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMitigationAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateMitigationActionWithContext(ctx aws.Context, input *UpdateMitigationActionInput, opts ...request.Option) (*UpdateMitigationActionOutput, error) {
	req, out := c.UpdateMitigationActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProvisioningTemplate = "UpdateProvisioningTemplate"

// UpdateProvisioningTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProvisioningTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProvisioningTemplate for more information on using the UpdateProvisioningTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateProvisioningTemplateRequest method.
//    req, resp := client.UpdateProvisioningTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateProvisioningTemplateRequest(input *UpdateProvisioningTemplateInput) (req *request.Request, output *UpdateProvisioningTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateProvisioningTemplate,
		HTTPMethod: "PATCH",
		HTTPPath:   "/provisioning-templates/{templateName}",
	}

	if input == nil {
		input = &UpdateProvisioningTemplateInput{}
	}

	output = &UpdateProvisioningTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateProvisioningTemplate API operation for AWS IoT.
//
// Updates a fleet provisioning template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateProvisioningTemplate for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ConflictingResourceUpdateException
//   A conflicting resource update exception. This exception is thrown when two
//   pending updates cause a conflict.
//
func (c *IoT) UpdateProvisioningTemplate(input *UpdateProvisioningTemplateInput) (*UpdateProvisioningTemplateOutput, error) {
	req, out := c.UpdateProvisioningTemplateRequest(input)
	return out, req.Send()
}

// UpdateProvisioningTemplateWithContext is the same as UpdateProvisioningTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProvisioningTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateProvisioningTemplateWithContext(ctx aws.Context, input *UpdateProvisioningTemplateInput, opts ...request.Option) (*UpdateProvisioningTemplateOutput, error) {
	req, out := c.UpdateProvisioningTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoleAlias = "UpdateRoleAlias"

// UpdateRoleAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoleAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoleAlias for more information on using the UpdateRoleAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRoleAliasRequest method.
//    req, resp := client.UpdateRoleAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateRoleAliasRequest(input *UpdateRoleAliasInput) (req *request.Request, output *UpdateRoleAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateRoleAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/role-aliases/{roleAlias}",
	}

	if input == nil {
		input = &UpdateRoleAliasInput{}
	}

	output = &UpdateRoleAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRoleAlias API operation for AWS IoT.
//
// Updates a role alias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateRoleAlias for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) UpdateRoleAlias(input *UpdateRoleAliasInput) (*UpdateRoleAliasOutput, error) {
	req, out := c.UpdateRoleAliasRequest(input)
	return out, req.Send()
}

// UpdateRoleAliasWithContext is the same as UpdateRoleAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoleAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateRoleAliasWithContext(ctx aws.Context, input *UpdateRoleAliasInput, opts ...request.Option) (*UpdateRoleAliasOutput, error) {
	req, out := c.UpdateRoleAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateScheduledAudit = "UpdateScheduledAudit"

// UpdateScheduledAuditRequest generates a "aws/request.Request" representing the
// client's request for the UpdateScheduledAudit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateScheduledAudit for more information on using the UpdateScheduledAudit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateScheduledAuditRequest method.
//    req, resp := client.UpdateScheduledAuditRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateScheduledAuditRequest(input *UpdateScheduledAuditInput) (req *request.Request, output *UpdateScheduledAuditOutput) {
	op := &request.Operation{
		Name:       opUpdateScheduledAudit,
		HTTPMethod: "PATCH",
		HTTPPath:   "/audit/scheduledaudits/{scheduledAuditName}",
	}

	if input == nil {
		input = &UpdateScheduledAuditInput{}
	}

	output = &UpdateScheduledAuditOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateScheduledAudit API operation for AWS IoT.
//
// Updates a scheduled audit, including which checks are performed and how often
// the audit takes place.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateScheduledAudit for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) UpdateScheduledAudit(input *UpdateScheduledAuditInput) (*UpdateScheduledAuditOutput, error) {
	req, out := c.UpdateScheduledAuditRequest(input)
	return out, req.Send()
}

// UpdateScheduledAuditWithContext is the same as UpdateScheduledAudit with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateScheduledAudit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateScheduledAuditWithContext(ctx aws.Context, input *UpdateScheduledAuditInput, opts ...request.Option) (*UpdateScheduledAuditOutput, error) {
	req, out := c.UpdateScheduledAuditRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSecurityProfile = "UpdateSecurityProfile"

// UpdateSecurityProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSecurityProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSecurityProfile for more information on using the UpdateSecurityProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSecurityProfileRequest method.
//    req, resp := client.UpdateSecurityProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateSecurityProfileRequest(input *UpdateSecurityProfileInput) (req *request.Request, output *UpdateSecurityProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateSecurityProfile,
		HTTPMethod: "PATCH",
		HTTPPath:   "/security-profiles/{securityProfileName}",
	}

	if input == nil {
		input = &UpdateSecurityProfileInput{}
	}

	output = &UpdateSecurityProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSecurityProfile API operation for AWS IoT.
//
// Updates a Device Defender security profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateSecurityProfile for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * VersionConflictException
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) UpdateSecurityProfile(input *UpdateSecurityProfileInput) (*UpdateSecurityProfileOutput, error) {
	req, out := c.UpdateSecurityProfileRequest(input)
	return out, req.Send()
}

// UpdateSecurityProfileWithContext is the same as UpdateSecurityProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSecurityProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateSecurityProfileWithContext(ctx aws.Context, input *UpdateSecurityProfileInput, opts ...request.Option) (*UpdateSecurityProfileOutput, error) {
	req, out := c.UpdateSecurityProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStream = "UpdateStream"

// UpdateStreamRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStream for more information on using the UpdateStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStreamRequest method.
//    req, resp := client.UpdateStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateStreamRequest(input *UpdateStreamInput) (req *request.Request, output *UpdateStreamOutput) {
	op := &request.Operation{
		Name:       opUpdateStream,
		HTTPMethod: "PUT",
		HTTPPath:   "/streams/{streamId}",
	}

	if input == nil {
		input = &UpdateStreamInput{}
	}

	output = &UpdateStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStream API operation for AWS IoT.
//
// Updates an existing stream. The stream version will be incremented by one.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateStream for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) UpdateStream(input *UpdateStreamInput) (*UpdateStreamOutput, error) {
	req, out := c.UpdateStreamRequest(input)
	return out, req.Send()
}

// UpdateStreamWithContext is the same as UpdateStream with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateStreamWithContext(ctx aws.Context, input *UpdateStreamInput, opts ...request.Option) (*UpdateStreamOutput, error) {
	req, out := c.UpdateStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateThing = "UpdateThing"

// UpdateThingRequest generates a "aws/request.Request" representing the
// client's request for the UpdateThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateThing for more information on using the UpdateThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateThingRequest method.
//    req, resp := client.UpdateThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateThingRequest(input *UpdateThingInput) (req *request.Request, output *UpdateThingOutput) {
	op := &request.Operation{
		Name:       opUpdateThing,
		HTTPMethod: "PATCH",
		HTTPPath:   "/things/{thingName}",
	}

	if input == nil {
		input = &UpdateThingInput{}
	}

	output = &UpdateThingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateThing API operation for AWS IoT.
//
// Updates the data for a thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateThing for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * VersionConflictException
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) UpdateThing(input *UpdateThingInput) (*UpdateThingOutput, error) {
	req, out := c.UpdateThingRequest(input)
	return out, req.Send()
}

// UpdateThingWithContext is the same as UpdateThing with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateThingWithContext(ctx aws.Context, input *UpdateThingInput, opts ...request.Option) (*UpdateThingOutput, error) {
	req, out := c.UpdateThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateThingGroup = "UpdateThingGroup"

// UpdateThingGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateThingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateThingGroup for more information on using the UpdateThingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateThingGroupRequest method.
//    req, resp := client.UpdateThingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateThingGroupRequest(input *UpdateThingGroupInput) (req *request.Request, output *UpdateThingGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateThingGroup,
		HTTPMethod: "PATCH",
		HTTPPath:   "/thing-groups/{thingGroupName}",
	}

	if input == nil {
		input = &UpdateThingGroupInput{}
	}

	output = &UpdateThingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateThingGroup API operation for AWS IoT.
//
// Update a thing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateThingGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * VersionConflictException
//   An exception thrown when the version of an entity specified with the expectedVersion
//   parameter does not match the latest version in the system.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) UpdateThingGroup(input *UpdateThingGroupInput) (*UpdateThingGroupOutput, error) {
	req, out := c.UpdateThingGroupRequest(input)
	return out, req.Send()
}

// UpdateThingGroupWithContext is the same as UpdateThingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateThingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateThingGroupWithContext(ctx aws.Context, input *UpdateThingGroupInput, opts ...request.Option) (*UpdateThingGroupOutput, error) {
	req, out := c.UpdateThingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateThingGroupsForThing = "UpdateThingGroupsForThing"

// UpdateThingGroupsForThingRequest generates a "aws/request.Request" representing the
// client's request for the UpdateThingGroupsForThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateThingGroupsForThing for more information on using the UpdateThingGroupsForThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateThingGroupsForThingRequest method.
//    req, resp := client.UpdateThingGroupsForThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateThingGroupsForThingRequest(input *UpdateThingGroupsForThingInput) (req *request.Request, output *UpdateThingGroupsForThingOutput) {
	op := &request.Operation{
		Name:       opUpdateThingGroupsForThing,
		HTTPMethod: "PUT",
		HTTPPath:   "/thing-groups/updateThingGroupsForThing",
	}

	if input == nil {
		input = &UpdateThingGroupsForThingInput{}
	}

	output = &UpdateThingGroupsForThingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateThingGroupsForThing API operation for AWS IoT.
//
// Updates the groups to which the thing belongs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateThingGroupsForThing for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
func (c *IoT) UpdateThingGroupsForThing(input *UpdateThingGroupsForThingInput) (*UpdateThingGroupsForThingOutput, error) {
	req, out := c.UpdateThingGroupsForThingRequest(input)
	return out, req.Send()
}

// UpdateThingGroupsForThingWithContext is the same as UpdateThingGroupsForThing with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateThingGroupsForThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateThingGroupsForThingWithContext(ctx aws.Context, input *UpdateThingGroupsForThingInput, opts ...request.Option) (*UpdateThingGroupsForThingOutput, error) {
	req, out := c.UpdateThingGroupsForThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTopicRuleDestination = "UpdateTopicRuleDestination"

// UpdateTopicRuleDestinationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTopicRuleDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTopicRuleDestination for more information on using the UpdateTopicRuleDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTopicRuleDestinationRequest method.
//    req, resp := client.UpdateTopicRuleDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateTopicRuleDestinationRequest(input *UpdateTopicRuleDestinationInput) (req *request.Request, output *UpdateTopicRuleDestinationOutput) {
	op := &request.Operation{
		Name:       opUpdateTopicRuleDestination,
		HTTPMethod: "PATCH",
		HTTPPath:   "/destinations",
	}

	if input == nil {
		input = &UpdateTopicRuleDestinationInput{}
	}

	output = &UpdateTopicRuleDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateTopicRuleDestination API operation for AWS IoT.
//
// Updates a topic rule destination. You use this to change the status, endpoint
// URL, or confirmation URL of the destination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateTopicRuleDestination for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ServiceUnavailableException
//   The service is temporarily unavailable.
//
//   * UnauthorizedException
//   You are not authorized to perform this operation.
//
//   * ConflictingResourceUpdateException
//   A conflicting resource update exception. This exception is thrown when two
//   pending updates cause a conflict.
//
func (c *IoT) UpdateTopicRuleDestination(input *UpdateTopicRuleDestinationInput) (*UpdateTopicRuleDestinationOutput, error) {
	req, out := c.UpdateTopicRuleDestinationRequest(input)
	return out, req.Send()
}

// UpdateTopicRuleDestinationWithContext is the same as UpdateTopicRuleDestination with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTopicRuleDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateTopicRuleDestinationWithContext(ctx aws.Context, input *UpdateTopicRuleDestinationInput, opts ...request.Option) (*UpdateTopicRuleDestinationOutput, error) {
	req, out := c.UpdateTopicRuleDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opValidateSecurityProfileBehaviors = "ValidateSecurityProfileBehaviors"

// ValidateSecurityProfileBehaviorsRequest generates a "aws/request.Request" representing the
// client's request for the ValidateSecurityProfileBehaviors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ValidateSecurityProfileBehaviors for more information on using the ValidateSecurityProfileBehaviors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ValidateSecurityProfileBehaviorsRequest method.
//    req, resp := client.ValidateSecurityProfileBehaviorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ValidateSecurityProfileBehaviorsRequest(input *ValidateSecurityProfileBehaviorsInput) (req *request.Request, output *ValidateSecurityProfileBehaviorsOutput) {
	op := &request.Operation{
		Name:       opValidateSecurityProfileBehaviors,
		HTTPMethod: "POST",
		HTTPPath:   "/security-profile-behaviors/validate",
	}

	if input == nil {
		input = &ValidateSecurityProfileBehaviorsInput{}
	}

	output = &ValidateSecurityProfileBehaviorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ValidateSecurityProfileBehaviors API operation for AWS IoT.
//
// Validates a Device Defender security profile behaviors specification.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ValidateSecurityProfileBehaviors for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
func (c *IoT) ValidateSecurityProfileBehaviors(input *ValidateSecurityProfileBehaviorsInput) (*ValidateSecurityProfileBehaviorsOutput, error) {
	req, out := c.ValidateSecurityProfileBehaviorsRequest(input)
	return out, req.Send()
}

// ValidateSecurityProfileBehaviorsWithContext is the same as ValidateSecurityProfileBehaviors with the addition of
// the ability to pass a context and additional request options.
//
// See ValidateSecurityProfileBehaviors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ValidateSecurityProfileBehaviorsWithContext(ctx aws.Context, input *ValidateSecurityProfileBehaviorsInput, opts ...request.Option) (*ValidateSecurityProfileBehaviorsOutput, error) {
	req, out := c.ValidateSecurityProfileBehaviorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Details of abort criteria to abort the job.
type AbortConfig struct {
	_ struct{} `type:"structure"`

	// The list of abort criteria to define rules to abort the job.
	//
	// CriteriaList is a required field
	CriteriaList []*AbortCriteria `locationName:"criteriaList" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s AbortConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AbortConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AbortConfig"}
	if s.CriteriaList == nil {
		invalidParams.Add(request.NewErrParamRequired("CriteriaList"))
	}
	if s.CriteriaList != nil && len(s.CriteriaList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CriteriaList", 1))
	}
	if s.CriteriaList != nil {
		for i, v := range s.CriteriaList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CriteriaList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCriteriaList sets the CriteriaList field's value.
func (s *AbortConfig) SetCriteriaList(v []*AbortCriteria) *AbortConfig {
	s.CriteriaList = v
	return s
}

// Details of abort criteria to define rules to abort the job.
type AbortCriteria struct {
	_ struct{} `type:"structure"`

	// The type of abort action to initiate a job abort.
	//
	// Action is a required field
	Action *string `locationName:"action" type:"string" required:"true" enum:"AbortAction"`

	// The type of job execution failure to define a rule to initiate a job abort.
	//
	// FailureType is a required field
	FailureType *string `locationName:"failureType" type:"string" required:"true" enum:"JobExecutionFailureType"`

	// Minimum number of executed things before evaluating an abort rule.
	//
	// MinNumberOfExecutedThings is a required field
	MinNumberOfExecutedThings *int64 `locationName:"minNumberOfExecutedThings" min:"1" type:"integer" required:"true"`

	// The threshold as a percentage of the total number of executed things that
	// will initiate a job abort.
	//
	// AWS IoT supports up to two digits after the decimal (for example, 10.9 and
	// 10.99, but not 10.999).
	//
	// ThresholdPercentage is a required field
	ThresholdPercentage *float64 `locationName:"thresholdPercentage" type:"double" required:"true"`
}

// String returns the string representation
func (s AbortCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AbortCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AbortCriteria"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.FailureType == nil {
		invalidParams.Add(request.NewErrParamRequired("FailureType"))
	}
	if s.MinNumberOfExecutedThings == nil {
		invalidParams.Add(request.NewErrParamRequired("MinNumberOfExecutedThings"))
	}
	if s.MinNumberOfExecutedThings != nil && *s.MinNumberOfExecutedThings < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinNumberOfExecutedThings", 1))
	}
	if s.ThresholdPercentage == nil {
		invalidParams.Add(request.NewErrParamRequired("ThresholdPercentage"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *AbortCriteria) SetAction(v string) *AbortCriteria {
	s.Action = &v
	return s
}

// SetFailureType sets the FailureType field's value.
func (s *AbortCriteria) SetFailureType(v string) *AbortCriteria {
	s.FailureType = &v
	return s
}

// SetMinNumberOfExecutedThings sets the MinNumberOfExecutedThings field's value.
func (s *AbortCriteria) SetMinNumberOfExecutedThings(v int64) *AbortCriteria {
	s.MinNumberOfExecutedThings = &v
	return s
}

// SetThresholdPercentage sets the ThresholdPercentage field's value.
func (s *AbortCriteria) SetThresholdPercentage(v float64) *AbortCriteria {
	s.ThresholdPercentage = &v
	return s
}

// The input for the AcceptCertificateTransfer operation.
type AcceptCertificateTransferInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate. (The last part of the certificate ARN contains
	// the certificate ID.)
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`

	// Specifies whether the certificate is active.
	SetAsActive *bool `location:"querystring" locationName:"setAsActive" type:"boolean"`
}

// String returns the string representation
func (s AcceptCertificateTransferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptCertificateTransferInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptCertificateTransferInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptCertificateTransferInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *AcceptCertificateTransferInput) SetCertificateId(v string) *AcceptCertificateTransferInput {
	s.CertificateId = &v
	return s
}

// SetSetAsActive sets the SetAsActive field's value.
func (s *AcceptCertificateTransferInput) SetSetAsActive(v bool) *AcceptCertificateTransferInput {
	s.SetAsActive = &v
	return s
}

type AcceptCertificateTransferOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AcceptCertificateTransferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptCertificateTransferOutput) GoString() string {
	return s.String()
}

// Describes the actions associated with a rule.
type Action struct {
	_ struct{} `type:"structure"`

	// Change the state of a CloudWatch alarm.
	CloudwatchAlarm *CloudwatchAlarmAction `locationName:"cloudwatchAlarm" type:"structure"`

	// Send data to CloudWatch Logs.
	CloudwatchLogs *CloudwatchLogsAction `locationName:"cloudwatchLogs" type:"structure"`

	// Capture a CloudWatch metric.
	CloudwatchMetric *CloudwatchMetricAction `locationName:"cloudwatchMetric" type:"structure"`

	// Write to a DynamoDB table.
	DynamoDB *DynamoDBAction `locationName:"dynamoDB" type:"structure"`

	// Write to a DynamoDB table. This is a new version of the DynamoDB action.
	// It allows you to write each attribute in an MQTT message payload into a separate
	// DynamoDB column.
	DynamoDBv2 *DynamoDBv2Action `locationName:"dynamoDBv2" type:"structure"`

	// Write data to an Amazon Elasticsearch Service domain.
	Elasticsearch *ElasticsearchAction `locationName:"elasticsearch" type:"structure"`

	// Write to an Amazon Kinesis Firehose stream.
	Firehose *FirehoseAction `locationName:"firehose" type:"structure"`

	// Send data to an HTTPS endpoint.
	Http *HttpAction `locationName:"http" type:"structure"`

	// Sends message data to an AWS IoT Analytics channel.
	IotAnalytics *IotAnalyticsAction `locationName:"iotAnalytics" type:"structure"`

	// Sends an input to an AWS IoT Events detector.
	IotEvents *IotEventsAction `locationName:"iotEvents" type:"structure"`

	// Sends data from the MQTT message that triggered the rule to AWS IoT SiteWise
	// asset properties.
	IotSiteWise *IotSiteWiseAction `locationName:"iotSiteWise" type:"structure"`

	// Write data to an Amazon Kinesis stream.
	Kinesis *KinesisAction `locationName:"kinesis" type:"structure"`

	// Invoke a Lambda function.
	Lambda *LambdaAction `locationName:"lambda" type:"structure"`

	// Publish to another MQTT topic.
	Republish *RepublishAction `locationName:"republish" type:"structure"`

	// Write to an Amazon S3 bucket.
	S3 *S3Action `locationName:"s3" type:"structure"`

	// Send a message to a Salesforce IoT Cloud Input Stream.
	Salesforce *SalesforceAction `locationName:"salesforce" type:"structure"`

	// Publish to an Amazon SNS topic.
	Sns *SnsAction `locationName:"sns" type:"structure"`

	// Publish to an Amazon SQS queue.
	Sqs *SqsAction `locationName:"sqs" type:"structure"`

	// Starts execution of a Step Functions state machine.
	StepFunctions *StepFunctionsAction `locationName:"stepFunctions" type:"structure"`
}

// String returns the string representation
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Action) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Action) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Action"}
	if s.CloudwatchAlarm != nil {
		if err := s.CloudwatchAlarm.Validate(); err != nil {
			invalidParams.AddNested("CloudwatchAlarm", err.(request.ErrInvalidParams))
		}
	}
	if s.CloudwatchLogs != nil {
		if err := s.CloudwatchLogs.Validate(); err != nil {
			invalidParams.AddNested("CloudwatchLogs", err.(request.ErrInvalidParams))
		}
	}
	if s.CloudwatchMetric != nil {
		if err := s.CloudwatchMetric.Validate(); err != nil {
			invalidParams.AddNested("CloudwatchMetric", err.(request.ErrInvalidParams))
		}
	}
	if s.DynamoDB != nil {
		if err := s.DynamoDB.Validate(); err != nil {
			invalidParams.AddNested("DynamoDB", err.(request.ErrInvalidParams))
		}
	}
	if s.DynamoDBv2 != nil {
		if err := s.DynamoDBv2.Validate(); err != nil {
			invalidParams.AddNested("DynamoDBv2", err.(request.ErrInvalidParams))
		}
	}
	if s.Elasticsearch != nil {
		if err := s.Elasticsearch.Validate(); err != nil {
			invalidParams.AddNested("Elasticsearch", err.(request.ErrInvalidParams))
		}
	}
	if s.Firehose != nil {
		if err := s.Firehose.Validate(); err != nil {
			invalidParams.AddNested("Firehose", err.(request.ErrInvalidParams))
		}
	}
	if s.Http != nil {
		if err := s.Http.Validate(); err != nil {
			invalidParams.AddNested("Http", err.(request.ErrInvalidParams))
		}
	}
	if s.IotEvents != nil {
		if err := s.IotEvents.Validate(); err != nil {
			invalidParams.AddNested("IotEvents", err.(request.ErrInvalidParams))
		}
	}
	if s.IotSiteWise != nil {
		if err := s.IotSiteWise.Validate(); err != nil {
			invalidParams.AddNested("IotSiteWise", err.(request.ErrInvalidParams))
		}
	}
	if s.Kinesis != nil {
		if err := s.Kinesis.Validate(); err != nil {
			invalidParams.AddNested("Kinesis", err.(request.ErrInvalidParams))
		}
	}
	if s.Lambda != nil {
		if err := s.Lambda.Validate(); err != nil {
			invalidParams.AddNested("Lambda", err.(request.ErrInvalidParams))
		}
	}
	if s.Republish != nil {
		if err := s.Republish.Validate(); err != nil {
			invalidParams.AddNested("Republish", err.(request.ErrInvalidParams))
		}
	}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}
	if s.Salesforce != nil {
		if err := s.Salesforce.Validate(); err != nil {
			invalidParams.AddNested("Salesforce", err.(request.ErrInvalidParams))
		}
	}
	if s.Sns != nil {
		if err := s.Sns.Validate(); err != nil {
			invalidParams.AddNested("Sns", err.(request.ErrInvalidParams))
		}
	}
	if s.Sqs != nil {
		if err := s.Sqs.Validate(); err != nil {
			invalidParams.AddNested("Sqs", err.(request.ErrInvalidParams))
		}
	}
	if s.StepFunctions != nil {
		if err := s.StepFunctions.Validate(); err != nil {
			invalidParams.AddNested("StepFunctions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudwatchAlarm sets the CloudwatchAlarm field's value.
func (s *Action) SetCloudwatchAlarm(v *CloudwatchAlarmAction) *Action {
	s.CloudwatchAlarm = v
	return s
}

// SetCloudwatchLogs sets the CloudwatchLogs field's value.
func (s *Action) SetCloudwatchLogs(v *CloudwatchLogsAction) *Action {
	s.CloudwatchLogs = v
	return s
}

// SetCloudwatchMetric sets the CloudwatchMetric field's value.
func (s *Action) SetCloudwatchMetric(v *CloudwatchMetricAction) *Action {
	s.CloudwatchMetric = v
	return s
}

// SetDynamoDB sets the DynamoDB field's value.
func (s *Action) SetDynamoDB(v *DynamoDBAction) *Action {
	s.DynamoDB = v
	return s
}

// SetDynamoDBv2 sets the DynamoDBv2 field's value.
func (s *Action) SetDynamoDBv2(v *DynamoDBv2Action) *Action {
	s.DynamoDBv2 = v
	return s
}

// SetElasticsearch sets the Elasticsearch field's value.
func (s *Action) SetElasticsearch(v *ElasticsearchAction) *Action {
	s.Elasticsearch = v
	return s
}

// SetFirehose sets the Firehose field's value.
func (s *Action) SetFirehose(v *FirehoseAction) *Action {
	s.Firehose = v
	return s
}

// SetHttp sets the Http field's value.
func (s *Action) SetHttp(v *HttpAction) *Action {
	s.Http = v
	return s
}

// SetIotAnalytics sets the IotAnalytics field's value.
func (s *Action) SetIotAnalytics(v *IotAnalyticsAction) *Action {
	s.IotAnalytics = v
	return s
}

// SetIotEvents sets the IotEvents field's value.
func (s *Action) SetIotEvents(v *IotEventsAction) *Action {
	s.IotEvents = v
	return s
}

// SetIotSiteWise sets the IotSiteWise field's value.
func (s *Action) SetIotSiteWise(v *IotSiteWiseAction) *Action {
	s.IotSiteWise = v
	return s
}

// SetKinesis sets the Kinesis field's value.
func (s *Action) SetKinesis(v *KinesisAction) *Action {
	s.Kinesis = v
	return s
}

// SetLambda sets the Lambda field's value.
func (s *Action) SetLambda(v *LambdaAction) *Action {
	s.Lambda = v
	return s
}

// SetRepublish sets the Republish field's value.
func (s *Action) SetRepublish(v *RepublishAction) *Action {
	s.Republish = v
	return s
}

// SetS3 sets the S3 field's value.
func (s *Action) SetS3(v *S3Action) *Action {
	s.S3 = v
	return s
}

// SetSalesforce sets the Salesforce field's value.
func (s *Action) SetSalesforce(v *SalesforceAction) *Action {
	s.Salesforce = v
	return s
}

// SetSns sets the Sns field's value.
func (s *Action) SetSns(v *SnsAction) *Action {
	s.Sns = v
	return s
}

// SetSqs sets the Sqs field's value.
func (s *Action) SetSqs(v *SqsAction) *Action {
	s.Sqs = v
	return s
}

// SetStepFunctions sets the StepFunctions field's value.
func (s *Action) SetStepFunctions(v *StepFunctionsAction) *Action {
	s.StepFunctions = v
	return s
}

// Information about an active Device Defender security profile behavior violation.
type ActiveViolation struct {
	_ struct{} `type:"structure"`

	// The behavior which is being violated.
	Behavior *Behavior `locationName:"behavior" type:"structure"`

	// The time the most recent violation occurred.
	LastViolationTime *time.Time `locationName:"lastViolationTime" type:"timestamp"`

	// The value of the metric (the measurement) which caused the most recent violation.
	LastViolationValue *MetricValue `locationName:"lastViolationValue" type:"structure"`

	// The security profile whose behavior is in violation.
	SecurityProfileName *string `locationName:"securityProfileName" min:"1" type:"string"`

	// The name of the thing responsible for the active violation.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`

	// The ID of the active violation.
	ViolationId *string `locationName:"violationId" min:"1" type:"string"`

	// The time the violation started.
	ViolationStartTime *time.Time `locationName:"violationStartTime" type:"timestamp"`
}

// String returns the string representation
func (s ActiveViolation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActiveViolation) GoString() string {
	return s.String()
}

// SetBehavior sets the Behavior field's value.
func (s *ActiveViolation) SetBehavior(v *Behavior) *ActiveViolation {
	s.Behavior = v
	return s
}

// SetLastViolationTime sets the LastViolationTime field's value.
func (s *ActiveViolation) SetLastViolationTime(v time.Time) *ActiveViolation {
	s.LastViolationTime = &v
	return s
}

// SetLastViolationValue sets the LastViolationValue field's value.
func (s *ActiveViolation) SetLastViolationValue(v *MetricValue) *ActiveViolation {
	s.LastViolationValue = v
	return s
}

// SetSecurityProfileName sets the SecurityProfileName field's value.
func (s *ActiveViolation) SetSecurityProfileName(v string) *ActiveViolation {
	s.SecurityProfileName = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *ActiveViolation) SetThingName(v string) *ActiveViolation {
	s.ThingName = &v
	return s
}

// SetViolationId sets the ViolationId field's value.
func (s *ActiveViolation) SetViolationId(v string) *ActiveViolation {
	s.ViolationId = &v
	return s
}

// SetViolationStartTime sets the ViolationStartTime field's value.
func (s *ActiveViolation) SetViolationStartTime(v time.Time) *ActiveViolation {
	s.ViolationStartTime = &v
	return s
}

type AddThingToBillingGroupInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the billing group.
	BillingGroupArn *string `locationName:"billingGroupArn" type:"string"`

	// The name of the billing group.
	BillingGroupName *string `locationName:"billingGroupName" min:"1" type:"string"`

	// The ARN of the thing to be added to the billing group.
	ThingArn *string `locationName:"thingArn" type:"string"`

	// The name of the thing to be added to the billing group.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation
func (s AddThingToBillingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddThingToBillingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddThingToBillingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddThingToBillingGroupInput"}
	if s.BillingGroupName != nil && len(*s.BillingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BillingGroupName", 1))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingGroupArn sets the BillingGroupArn field's value.
func (s *AddThingToBillingGroupInput) SetBillingGroupArn(v string) *AddThingToBillingGroupInput {
	s.BillingGroupArn = &v
	return s
}

// SetBillingGroupName sets the BillingGroupName field's value.
func (s *AddThingToBillingGroupInput) SetBillingGroupName(v string) *AddThingToBillingGroupInput {
	s.BillingGroupName = &v
	return s
}

// SetThingArn sets the ThingArn field's value.
func (s *AddThingToBillingGroupInput) SetThingArn(v string) *AddThingToBillingGroupInput {
	s.ThingArn = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *AddThingToBillingGroupInput) SetThingName(v string) *AddThingToBillingGroupInput {
	s.ThingName = &v
	return s
}

type AddThingToBillingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddThingToBillingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddThingToBillingGroupOutput) GoString() string {
	return s.String()
}

type AddThingToThingGroupInput struct {
	_ struct{} `type:"structure"`

	// Override dynamic thing groups with static thing groups when 10-group limit
	// is reached. If a thing belongs to 10 thing groups, and one or more of those
	// groups are dynamic thing groups, adding a thing to a static group removes
	// the thing from the last dynamic group.
	OverrideDynamicGroups *bool `locationName:"overrideDynamicGroups" type:"boolean"`

	// The ARN of the thing to add to a group.
	ThingArn *string `locationName:"thingArn" type:"string"`

	// The ARN of the group to which you are adding a thing.
	ThingGroupArn *string `locationName:"thingGroupArn" type:"string"`

	// The name of the group to which you are adding a thing.
	ThingGroupName *string `locationName:"thingGroupName" min:"1" type:"string"`

	// The name of the thing to add to a group.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation
func (s AddThingToThingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddThingToThingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddThingToThingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddThingToThingGroupInput"}
	if s.ThingGroupName != nil && len(*s.ThingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingGroupName", 1))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOverrideDynamicGroups sets the OverrideDynamicGroups field's value.
func (s *AddThingToThingGroupInput) SetOverrideDynamicGroups(v bool) *AddThingToThingGroupInput {
	s.OverrideDynamicGroups = &v
	return s
}

// SetThingArn sets the ThingArn field's value.
func (s *AddThingToThingGroupInput) SetThingArn(v string) *AddThingToThingGroupInput {
	s.ThingArn = &v
	return s
}

// SetThingGroupArn sets the ThingGroupArn field's value.
func (s *AddThingToThingGroupInput) SetThingGroupArn(v string) *AddThingToThingGroupInput {
	s.ThingGroupArn = &v
	return s
}

// SetThingGroupName sets the ThingGroupName field's value.
func (s *AddThingToThingGroupInput) SetThingGroupName(v string) *AddThingToThingGroupInput {
	s.ThingGroupName = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *AddThingToThingGroupInput) SetThingName(v string) *AddThingToThingGroupInput {
	s.ThingName = &v
	return s
}

type AddThingToThingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddThingToThingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddThingToThingGroupOutput) GoString() string {
	return s.String()
}

// Parameters used when defining a mitigation action that move a set of things
// to a thing group.
type AddThingsToThingGroupParams struct {
	_ struct{} `type:"structure"`

	// Specifies if this mitigation action can move the things that triggered the
	// mitigation action even if they are part of one or more dynamic things groups.
	OverrideDynamicGroups *bool `locationName:"overrideDynamicGroups" type:"boolean"`

	// The list of groups to which you want to add the things that triggered the
	// mitigation action. You can add a thing to a maximum of 10 groups, but you
	// cannot add a thing to more than one group in the same hierarchy.
	//
	// ThingGroupNames is a required field
	ThingGroupNames []*string `locationName:"thingGroupNames" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s AddThingsToThingGroupParams) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddThingsToThingGroupParams) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddThingsToThingGroupParams) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddThingsToThingGroupParams"}
	if s.ThingGroupNames == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingGroupNames"))
	}
	if s.ThingGroupNames != nil && len(s.ThingGroupNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingGroupNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOverrideDynamicGroups sets the OverrideDynamicGroups field's value.
func (s *AddThingsToThingGroupParams) SetOverrideDynamicGroups(v bool) *AddThingsToThingGroupParams {
	s.OverrideDynamicGroups = &v
	return s
}

// SetThingGroupNames sets the ThingGroupNames field's value.
func (s *AddThingsToThingGroupParams) SetThingGroupNames(v []*string) *AddThingsToThingGroupParams {
	s.ThingGroupNames = v
	return s
}

// A structure containing the alert target ARN and the role ARN.
type AlertTarget struct {
	_ struct{} `type:"structure"`

	// The ARN of the notification target to which alerts are sent.
	//
	// AlertTargetArn is a required field
	AlertTargetArn *string `locationName:"alertTargetArn" type:"string" required:"true"`

	// The ARN of the role that grants permission to send alerts to the notification
	// target.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s AlertTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlertTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlertTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AlertTarget"}
	if s.AlertTargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AlertTargetArn"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlertTargetArn sets the AlertTargetArn field's value.
func (s *AlertTarget) SetAlertTargetArn(v string) *AlertTarget {
	s.AlertTargetArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AlertTarget) SetRoleArn(v string) *AlertTarget {
	s.RoleArn = &v
	return s
}

// Contains information that allowed the authorization.
type Allowed struct {
	_ struct{} `type:"structure"`

	// A list of policies that allowed the authentication.
	Policies []*Policy `locationName:"policies" type:"list"`
}

// String returns the string representation
func (s Allowed) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Allowed) GoString() string {
	return s.String()
}

// SetPolicies sets the Policies field's value.
func (s *Allowed) SetPolicies(v []*Policy) *Allowed {
	s.Policies = v
	return s
}

// An asset property timestamp entry containing the following information.
type AssetPropertyTimestamp struct {
	_ struct{} `type:"structure"`

	// Optional. A string that contains the nanosecond time offset. Accepts substitution
	// templates.
	OffsetInNanos *string `locationName:"offsetInNanos" type:"string"`

	// A string that contains the time in seconds since epoch. Accepts substitution
	// templates.
	//
	// TimeInSeconds is a required field
	TimeInSeconds *string `locationName:"timeInSeconds" type:"string" required:"true"`
}

// String returns the string representation
func (s AssetPropertyTimestamp) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssetPropertyTimestamp) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetPropertyTimestamp) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetPropertyTimestamp"}
	if s.TimeInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeInSeconds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOffsetInNanos sets the OffsetInNanos field's value.
func (s *AssetPropertyTimestamp) SetOffsetInNanos(v string) *AssetPropertyTimestamp {
	s.OffsetInNanos = &v
	return s
}

// SetTimeInSeconds sets the TimeInSeconds field's value.
func (s *AssetPropertyTimestamp) SetTimeInSeconds(v string) *AssetPropertyTimestamp {
	s.TimeInSeconds = &v
	return s
}

// An asset property value entry containing the following information.
type AssetPropertyValue struct {
	_ struct{} `type:"structure"`

	// Optional. A string that describes the quality of the value. Accepts substitution
	// templates. Must be GOOD, BAD, or UNCERTAIN.
	Quality *string `locationName:"quality" type:"string"`

	// The asset property value timestamp.
	//
	// Timestamp is a required field
	Timestamp *AssetPropertyTimestamp `locationName:"timestamp" type:"structure" required:"true"`

	// The value of the asset property.
	//
	// Value is a required field
	Value *AssetPropertyVariant `locationName:"value" type:"structure" required:"true"`
}

// String returns the string representation
func (s AssetPropertyValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssetPropertyValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetPropertyValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetPropertyValue"}
	if s.Timestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("Timestamp"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Timestamp != nil {
		if err := s.Timestamp.Validate(); err != nil {
			invalidParams.AddNested("Timestamp", err.(request.ErrInvalidParams))
		}
	}
	if s.Value != nil {
		if err := s.Value.Validate(); err != nil {
			invalidParams.AddNested("Value", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQuality sets the Quality field's value.
func (s *AssetPropertyValue) SetQuality(v string) *AssetPropertyValue {
	s.Quality = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *AssetPropertyValue) SetTimestamp(v *AssetPropertyTimestamp) *AssetPropertyValue {
	s.Timestamp = v
	return s
}

// SetValue sets the Value field's value.
func (s *AssetPropertyValue) SetValue(v *AssetPropertyVariant) *AssetPropertyValue {
	s.Value = v
	return s
}

// Contains an asset property value (of a single type).
type AssetPropertyVariant struct {
	_ struct{} `type:"structure"`

	// Optional. A string that contains the boolean value (true or false) of the
	// value entry. Accepts substitution templates.
	BooleanValue *string `locationName:"booleanValue" type:"string"`

	// Optional. A string that contains the double value of the value entry. Accepts
	// substitution templates.
	DoubleValue *string `locationName:"doubleValue" type:"string"`

	// Optional. A string that contains the integer value of the value entry. Accepts
	// substitution templates.
	IntegerValue *string `locationName:"integerValue" type:"string"`

	// Optional. The string value of the value entry. Accepts substitution templates.
	StringValue *string `locationName:"stringValue" min:"1" type:"string"`
}

// String returns the string representation
func (s AssetPropertyVariant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssetPropertyVariant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetPropertyVariant) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetPropertyVariant"}
	if s.StringValue != nil && len(*s.StringValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StringValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBooleanValue sets the BooleanValue field's value.
func (s *AssetPropertyVariant) SetBooleanValue(v string) *AssetPropertyVariant {
	s.BooleanValue = &v
	return s
}

// SetDoubleValue sets the DoubleValue field's value.
func (s *AssetPropertyVariant) SetDoubleValue(v string) *AssetPropertyVariant {
	s.DoubleValue = &v
	return s
}

// SetIntegerValue sets the IntegerValue field's value.
func (s *AssetPropertyVariant) SetIntegerValue(v string) *AssetPropertyVariant {
	s.IntegerValue = &v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *AssetPropertyVariant) SetStringValue(v string) *AssetPropertyVariant {
	s.StringValue = &v
	return s
}

type AssociateTargetsWithJobInput struct {
	_ struct{} `type:"structure"`

	// An optional comment string describing why the job was associated with the
	// targets.
	Comment *string `locationName:"comment" type:"string"`

	// The unique identifier you assigned to this job when it was created.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" min:"1" type:"string" required:"true"`

	// A list of thing group ARNs that define the targets of the job.
	//
	// Targets is a required field
	Targets []*string `locationName:"targets" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s AssociateTargetsWithJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateTargetsWithJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateTargetsWithJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateTargetsWithJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil && len(s.Targets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Targets", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *AssociateTargetsWithJobInput) SetComment(v string) *AssociateTargetsWithJobInput {
	s.Comment = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *AssociateTargetsWithJobInput) SetJobId(v string) *AssociateTargetsWithJobInput {
	s.JobId = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *AssociateTargetsWithJobInput) SetTargets(v []*string) *AssociateTargetsWithJobInput {
	s.Targets = v
	return s
}

type AssociateTargetsWithJobOutput struct {
	_ struct{} `type:"structure"`

	// A short text description of the job.
	Description *string `locationName:"description" type:"string"`

	// An ARN identifying the job.
	JobArn *string `locationName:"jobArn" type:"string"`

	// The unique identifier you assigned to this job when it was created.
	JobId *string `locationName:"jobId" min:"1" type:"string"`
}

// String returns the string representation
func (s AssociateTargetsWithJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateTargetsWithJobOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *AssociateTargetsWithJobOutput) SetDescription(v string) *AssociateTargetsWithJobOutput {
	s.Description = &v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *AssociateTargetsWithJobOutput) SetJobArn(v string) *AssociateTargetsWithJobOutput {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *AssociateTargetsWithJobOutput) SetJobId(v string) *AssociateTargetsWithJobOutput {
	s.JobId = &v
	return s
}

type AttachPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy to attach.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The identity (https://docs.aws.amazon.com/iot/latest/developerguide/iot-security-identity.html)
	// to which the policy is attached.
	//
	// Target is a required field
	Target *string `locationName:"target" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachPolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *AttachPolicyInput) SetPolicyName(v string) *AttachPolicyInput {
	s.PolicyName = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *AttachPolicyInput) SetTarget(v string) *AttachPolicyInput {
	s.Target = &v
	return s
}

type AttachPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachPolicyOutput) GoString() string {
	return s.String()
}

// The input for the AttachPrincipalPolicy operation.
type AttachPrincipalPolicyInput struct {
	_ struct{} `type:"structure"`

	// The policy name.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The principal, which can be a certificate ARN (as returned from the CreateCertificate
	// operation) or an Amazon Cognito ID.
	//
	// Principal is a required field
	Principal *string `location:"header" locationName:"x-amzn-iot-principal" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachPrincipalPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachPrincipalPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachPrincipalPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachPrincipalPolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *AttachPrincipalPolicyInput) SetPolicyName(v string) *AttachPrincipalPolicyInput {
	s.PolicyName = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *AttachPrincipalPolicyInput) SetPrincipal(v string) *AttachPrincipalPolicyInput {
	s.Principal = &v
	return s
}

type AttachPrincipalPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachPrincipalPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachPrincipalPolicyOutput) GoString() string {
	return s.String()
}

type AttachSecurityProfileInput struct {
	_ struct{} `type:"structure"`

	// The security profile that is attached.
	//
	// SecurityProfileName is a required field
	SecurityProfileName *string `location:"uri" locationName:"securityProfileName" min:"1" type:"string" required:"true"`

	// The ARN of the target (thing group) to which the security profile is attached.
	//
	// SecurityProfileTargetArn is a required field
	SecurityProfileTargetArn *string `location:"querystring" locationName:"securityProfileTargetArn" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachSecurityProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachSecurityProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachSecurityProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachSecurityProfileInput"}
	if s.SecurityProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityProfileName"))
	}
	if s.SecurityProfileName != nil && len(*s.SecurityProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityProfileName", 1))
	}
	if s.SecurityProfileTargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityProfileTargetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityProfileName sets the SecurityProfileName field's value.
func (s *AttachSecurityProfileInput) SetSecurityProfileName(v string) *AttachSecurityProfileInput {
	s.SecurityProfileName = &v
	return s
}

// SetSecurityProfileTargetArn sets the SecurityProfileTargetArn field's value.
func (s *AttachSecurityProfileInput) SetSecurityProfileTargetArn(v string) *AttachSecurityProfileInput {
	s.SecurityProfileTargetArn = &v
	return s
}

type AttachSecurityProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachSecurityProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachSecurityProfileOutput) GoString() string {
	return s.String()
}

// The input for the AttachThingPrincipal operation.
type AttachThingPrincipalInput struct {
	_ struct{} `type:"structure"`

	// The principal, which can be a certificate ARN (as returned from the CreateCertificate
	// operation) or an Amazon Cognito ID.
	//
	// Principal is a required field
	Principal *string `location:"header" locationName:"x-amzn-principal" type:"string" required:"true"`

	// The name of the thing.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachThingPrincipalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachThingPrincipalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachThingPrincipalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachThingPrincipalInput"}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrincipal sets the Principal field's value.
func (s *AttachThingPrincipalInput) SetPrincipal(v string) *AttachThingPrincipalInput {
	s.Principal = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *AttachThingPrincipalInput) SetThingName(v string) *AttachThingPrincipalInput {
	s.ThingName = &v
	return s
}

// The output from the AttachThingPrincipal operation.
type AttachThingPrincipalOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachThingPrincipalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachThingPrincipalOutput) GoString() string {
	return s.String()
}

// The attribute payload.
type AttributePayload struct {
	_ struct{} `type:"structure"`

	// A JSON string containing up to three key-value pair in JSON format. For example:
	//
	// {\"attributes\":{\"string1\":\"string2\"}}
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// Specifies whether the list of attributes provided in the AttributePayload
	// is merged with the attributes stored in the registry, instead of overwriting
	// them.
	//
	// To remove an attribute, call UpdateThing with an empty attribute value.
	//
	// The merge attribute is only valid when calling UpdateThing or UpdateThingGroup.
	Merge *bool `locationName:"merge" type:"boolean"`
}

// String returns the string representation
func (s AttributePayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributePayload) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *AttributePayload) SetAttributes(v map[string]*string) *AttributePayload {
	s.Attributes = v
	return s
}

// SetMerge sets the Merge field's value.
func (s *AttributePayload) SetMerge(v bool) *AttributePayload {
	s.Merge = &v
	return s
}

// Which audit checks are enabled and disabled for this account.
type AuditCheckConfiguration struct {
	_ struct{} `type:"structure"`

	// True if this audit check is enabled for this account.
	Enabled *bool `locationName:"enabled" type:"boolean"`
}

// String returns the string representation
func (s AuditCheckConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuditCheckConfiguration) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AuditCheckConfiguration) SetEnabled(v bool) *AuditCheckConfiguration {
	s.Enabled = &v
	return s
}

// Information about the audit check.
type AuditCheckDetails struct {
	_ struct{} `type:"structure"`

	// True if the check is complete and found all resources compliant.
	CheckCompliant *bool `locationName:"checkCompliant" type:"boolean"`

	// The completion status of this check. One of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION",
	// "CANCELED", "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
	CheckRunStatus *string `locationName:"checkRunStatus" type:"string" enum:"AuditCheckRunStatus"`

	// The code of any error encountered when this check is performed during this
	// audit. One of "INSUFFICIENT_PERMISSIONS" or "AUDIT_CHECK_DISABLED".
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// The message associated with any error encountered when this check is performed
	// during this audit.
	Message *string `locationName:"message" type:"string"`

	// The number of resources that were found noncompliant during the check.
	NonCompliantResourcesCount *int64 `locationName:"nonCompliantResourcesCount" type:"long"`

	// The number of resources on which the check was performed.
	TotalResourcesCount *int64 `locationName:"totalResourcesCount" type:"long"`
}

// String returns the string representation
func (s AuditCheckDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuditCheckDetails) GoString() string {
	return s.String()
}

// SetCheckCompliant sets the CheckCompliant field's value.
func (s *AuditCheckDetails) SetCheckCompliant(v bool) *AuditCheckDetails {
	s.CheckCompliant = &v
	return s
}

// SetCheckRunStatus sets the CheckRunStatus field's value.
func (s *AuditCheckDetails) SetCheckRunStatus(v string) *AuditCheckDetails {
	s.CheckRunStatus = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *AuditCheckDetails) SetErrorCode(v string) *AuditCheckDetails {
	s.ErrorCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AuditCheckDetails) SetMessage(v string) *AuditCheckDetails {
	s.Message = &v
	return s
}

// SetNonCompliantResourcesCount sets the NonCompliantResourcesCount field's value.
func (s *AuditCheckDetails) SetNonCompliantResourcesCount(v int64) *AuditCheckDetails {
	s.NonCompliantResourcesCount = &v
	return s
}

// SetTotalResourcesCount sets the TotalResourcesCount field's value.
func (s *AuditCheckDetails) SetTotalResourcesCount(v int64) *AuditCheckDetails {
	s.TotalResourcesCount = &v
	return s
}

// The findings (results) of the audit.
type AuditFinding struct {
	_ struct{} `type:"structure"`

	// The audit check that generated this result.
	CheckName *string `locationName:"checkName" type:"string"`

	// A unique identifier for this set of audit findings. This identifier is used
	// to apply mitigation tasks to one or more sets of findings.
	FindingId *string `locationName:"findingId" min:"1" type:"string"`

	// The time the result (finding) was discovered.
	FindingTime *time.Time `locationName:"findingTime" type:"timestamp"`

	// The resource that was found to be noncompliant with the audit check.
	NonCompliantResource *NonCompliantResource `locationName:"nonCompliantResource" type:"structure"`

	// The reason the resource was noncompliant.
	ReasonForNonCompliance *string `locationName:"reasonForNonCompliance" type:"string"`

	// A code that indicates the reason that the resource was noncompliant.
	ReasonForNonComplianceCode *string `locationName:"reasonForNonComplianceCode" type:"string"`

	// The list of related resources.
	RelatedResources []*RelatedResource `locationName:"relatedResources" type:"list"`

	// The severity of the result (finding).
	Severity *string `locationName:"severity" type:"string" enum:"AuditFindingSeverity"`

	// The ID of the audit that generated this result (finding).
	TaskId *string `locationName:"taskId" min:"1" type:"string"`

	// The time the audit started.
	TaskStartTime *time.Time `locationName:"taskStartTime" type:"timestamp"`
}

// String returns the string representation
func (s AuditFinding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuditFinding) GoString() string {
	return s.String()
}

// SetCheckName sets the CheckName field's value.
func (s *AuditFinding) SetCheckName(v string) *AuditFinding {
	s.CheckName = &v
	return s
}

// SetFindingId sets the FindingId field's value.
func (s *AuditFinding) SetFindingId(v string) *AuditFinding {
	s.FindingId = &v
	return s
}

// SetFindingTime sets the FindingTime field's value.
func (s *AuditFinding) SetFindingTime(v time.Time) *AuditFinding {
	s.FindingTime = &v
	return s
}

// SetNonCompliantResource sets the NonCompliantResource field's value.
func (s *AuditFinding) SetNonCompliantResource(v *NonCompliantResource) *AuditFinding {
	s.NonCompliantResource = v
	return s
}

// SetReasonForNonCompliance sets the ReasonForNonCompliance field's value.
func (s *AuditFinding) SetReasonForNonCompliance(v string) *AuditFinding {
	s.ReasonForNonCompliance = &v
	return s
}

// SetReasonForNonComplianceCode sets the ReasonForNonComplianceCode field's value.
func (s *AuditFinding) SetReasonForNonComplianceCode(v string) *AuditFinding {
	s.ReasonForNonComplianceCode = &v
	return s
}

// SetRelatedResources sets the RelatedResources field's value.
func (s *AuditFinding) SetRelatedResources(v []*RelatedResource) *AuditFinding {
	s.RelatedResources = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *AuditFinding) SetSeverity(v string) *AuditFinding {
	s.Severity = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *AuditFinding) SetTaskId(v string) *AuditFinding {
	s.TaskId = &v
	return s
}

// SetTaskStartTime sets the TaskStartTime field's value.
func (s *AuditFinding) SetTaskStartTime(v time.Time) *AuditFinding {
	s.TaskStartTime = &v
	return s
}

// Returned by ListAuditMitigationActionsTask, this object contains information
// that describes a mitigation action that has been started.
type AuditMitigationActionExecutionMetadata struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the mitigation action being applied by the task.
	ActionId *string `locationName:"actionId" type:"string"`

	// The friendly name of the mitigation action being applied by the task.
	ActionName *string `locationName:"actionName" type:"string"`

	// The date and time when the task was completed or canceled. Blank if the task
	// is still running.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// If an error occurred, the code that indicates which type of error occurred.
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// The unique identifier for the findings to which the task and associated mitigation
	// action are applied.
	FindingId *string `locationName:"findingId" min:"1" type:"string"`

	// If an error occurred, a message that describes the error.
	Message *string `locationName:"message" type:"string"`

	// The date and time when the task was started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The current status of the task being executed.
	Status *string `locationName:"status" type:"string" enum:"AuditMitigationActionsExecutionStatus"`

	// The unique identifier for the task that applies the mitigation action.
	TaskId *string `locationName:"taskId" min:"1" type:"string"`
}

// String returns the string representation
func (s AuditMitigationActionExecutionMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuditMitigationActionExecutionMetadata) GoString() string {
	return s.String()
}

// SetActionId sets the ActionId field's value.
func (s *AuditMitigationActionExecutionMetadata) SetActionId(v string) *AuditMitigationActionExecutionMetadata {
	s.ActionId = &v
	return s
}

// SetActionName sets the ActionName field's value.
func (s *AuditMitigationActionExecutionMetadata) SetActionName(v string) *AuditMitigationActionExecutionMetadata {
	s.ActionName = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *AuditMitigationActionExecutionMetadata) SetEndTime(v time.Time) *AuditMitigationActionExecutionMetadata {
	s.EndTime = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *AuditMitigationActionExecutionMetadata) SetErrorCode(v string) *AuditMitigationActionExecutionMetadata {
	s.ErrorCode = &v
	return s
}

// SetFindingId sets the FindingId field's value.
func (s *AuditMitigationActionExecutionMetadata) SetFindingId(v string) *AuditMitigationActionExecutionMetadata {
	s.FindingId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AuditMitigationActionExecutionMetadata) SetMessage(v string) *AuditMitigationActionExecutionMetadata {
	s.Message = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AuditMitigationActionExecutionMetadata) SetStartTime(v time.Time) *AuditMitigationActionExecutionMetadata {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AuditMitigationActionExecutionMetadata) SetStatus(v string) *AuditMitigationActionExecutionMetadata {
	s.Status = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *AuditMitigationActionExecutionMetadata) SetTaskId(v string) *AuditMitigationActionExecutionMetadata {
	s.TaskId = &v
	return s
}

// Information about an audit mitigation actions task that is returned by ListAuditMitigationActionsTasks.
type AuditMitigationActionsTaskMetadata struct {
	_ struct{} `type:"structure"`

	// The time at which the audit mitigation actions task was started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The unique identifier for the task.
	TaskId *string `locationName:"taskId" min:"1" type:"string"`

	// The current state of the audit mitigation actions task.
	TaskStatus *string `locationName:"taskStatus" type:"string" enum:"AuditMitigationActionsTaskStatus"`
}

// String returns the string representation
func (s AuditMitigationActionsTaskMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuditMitigationActionsTaskMetadata) GoString() string {
	return s.String()
}

// SetStartTime sets the StartTime field's value.
func (s *AuditMitigationActionsTaskMetadata) SetStartTime(v time.Time) *AuditMitigationActionsTaskMetadata {
	s.StartTime = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *AuditMitigationActionsTaskMetadata) SetTaskId(v string) *AuditMitigationActionsTaskMetadata {
	s.TaskId = &v
	return s
}

// SetTaskStatus sets the TaskStatus field's value.
func (s *AuditMitigationActionsTaskMetadata) SetTaskStatus(v string) *AuditMitigationActionsTaskMetadata {
	s.TaskStatus = &v
	return s
}

// Used in MitigationActionParams, this information identifies the target findings
// to which the mitigation actions are applied. Only one entry appears.
type AuditMitigationActionsTaskTarget struct {
	_ struct{} `type:"structure"`

	// Specifies a filter in the form of an audit check and set of reason codes
	// that identify the findings from the audit to which the audit mitigation actions
	// task apply.
	AuditCheckToReasonCodeFilter map[string][]*string `locationName:"auditCheckToReasonCodeFilter" type:"map"`

	// If the task will apply a mitigation action to findings from a specific audit,
	// this value uniquely identifies the audit.
	AuditTaskId *string `locationName:"auditTaskId" min:"1" type:"string"`

	// If the task will apply a mitigation action to one or more listed findings,
	// this value uniquely identifies those findings.
	FindingIds []*string `locationName:"findingIds" min:"1" type:"list"`
}

// String returns the string representation
func (s AuditMitigationActionsTaskTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuditMitigationActionsTaskTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuditMitigationActionsTaskTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuditMitigationActionsTaskTarget"}
	if s.AuditTaskId != nil && len(*s.AuditTaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuditTaskId", 1))
	}
	if s.FindingIds != nil && len(s.FindingIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FindingIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuditCheckToReasonCodeFilter sets the AuditCheckToReasonCodeFilter field's value.
func (s *AuditMitigationActionsTaskTarget) SetAuditCheckToReasonCodeFilter(v map[string][]*string) *AuditMitigationActionsTaskTarget {
	s.AuditCheckToReasonCodeFilter = v
	return s
}

// SetAuditTaskId sets the AuditTaskId field's value.
func (s *AuditMitigationActionsTaskTarget) SetAuditTaskId(v string) *AuditMitigationActionsTaskTarget {
	s.AuditTaskId = &v
	return s
}

// SetFindingIds sets the FindingIds field's value.
func (s *AuditMitigationActionsTaskTarget) SetFindingIds(v []*string) *AuditMitigationActionsTaskTarget {
	s.FindingIds = v
	return s
}

// Information about the targets to which audit notifications are sent.
type AuditNotificationTarget struct {
	_ struct{} `type:"structure"`

	// True if notifications to the target are enabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The ARN of the role that grants permission to send notifications to the target.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`

	// The ARN of the target (SNS topic) to which audit notifications are sent.
	TargetArn *string `locationName:"targetArn" type:"string"`
}

// String returns the string representation
func (s AuditNotificationTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuditNotificationTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuditNotificationTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuditNotificationTarget"}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *AuditNotificationTarget) SetEnabled(v bool) *AuditNotificationTarget {
	s.Enabled = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AuditNotificationTarget) SetRoleArn(v string) *AuditNotificationTarget {
	s.RoleArn = &v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *AuditNotificationTarget) SetTargetArn(v string) *AuditNotificationTarget {
	s.TargetArn = &v
	return s
}

// The audits that were performed.
type AuditTaskMetadata struct {
	_ struct{} `type:"structure"`

	// The ID of this audit.
	TaskId *string `locationName:"taskId" min:"1" type:"string"`

	// The status of this audit. One of "IN_PROGRESS", "COMPLETED", "FAILED", or
	// "CANCELED".
	TaskStatus *string `locationName:"taskStatus" type:"string" enum:"AuditTaskStatus"`

	// The type of this audit. One of "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".
	TaskType *string `locationName:"taskType" type:"string" enum:"AuditTaskType"`
}

// String returns the string representation
func (s AuditTaskMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuditTaskMetadata) GoString() string {
	return s.String()
}

// SetTaskId sets the TaskId field's value.
func (s *AuditTaskMetadata) SetTaskId(v string) *AuditTaskMetadata {
	s.TaskId = &v
	return s
}

// SetTaskStatus sets the TaskStatus field's value.
func (s *AuditTaskMetadata) SetTaskStatus(v string) *AuditTaskMetadata {
	s.TaskStatus = &v
	return s
}

// SetTaskType sets the TaskType field's value.
func (s *AuditTaskMetadata) SetTaskType(v string) *AuditTaskMetadata {
	s.TaskType = &v
	return s
}

// A collection of authorization information.
type AuthInfo struct {
	_ struct{} `type:"structure"`

	// The type of action for which the principal is being authorized.
	ActionType *string `locationName:"actionType" type:"string" enum:"ActionType"`

	// The resources for which the principal is being authorized to perform the
	// specified action.
	Resources []*string `locationName:"resources" type:"list"`
}

// String returns the string representation
func (s AuthInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthInfo) GoString() string {
	return s.String()
}

// SetActionType sets the ActionType field's value.
func (s *AuthInfo) SetActionType(v string) *AuthInfo {
	s.ActionType = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *AuthInfo) SetResources(v []*string) *AuthInfo {
	s.Resources = v
	return s
}

// The authorizer result.
type AuthResult struct {
	_ struct{} `type:"structure"`

	// The policies and statements that allowed the specified action.
	Allowed *Allowed `locationName:"allowed" type:"structure"`

	// The final authorization decision of this scenario. Multiple statements are
	// taken into account when determining the authorization decision. An explicit
	// deny statement can override multiple allow statements.
	AuthDecision *string `locationName:"authDecision" type:"string" enum:"AuthDecision"`

	// Authorization information.
	AuthInfo *AuthInfo `locationName:"authInfo" type:"structure"`

	// The policies and statements that denied the specified action.
	Denied *Denied `locationName:"denied" type:"structure"`

	// Contains any missing context values found while evaluating policy.
	MissingContextValues []*string `locationName:"missingContextValues" type:"list"`
}

// String returns the string representation
func (s AuthResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthResult) GoString() string {
	return s.String()
}

// SetAllowed sets the Allowed field's value.
func (s *AuthResult) SetAllowed(v *Allowed) *AuthResult {
	s.Allowed = v
	return s
}

// SetAuthDecision sets the AuthDecision field's value.
func (s *AuthResult) SetAuthDecision(v string) *AuthResult {
	s.AuthDecision = &v
	return s
}

// SetAuthInfo sets the AuthInfo field's value.
func (s *AuthResult) SetAuthInfo(v *AuthInfo) *AuthResult {
	s.AuthInfo = v
	return s
}

// SetDenied sets the Denied field's value.
func (s *AuthResult) SetDenied(v *Denied) *AuthResult {
	s.Denied = v
	return s
}

// SetMissingContextValues sets the MissingContextValues field's value.
func (s *AuthResult) SetMissingContextValues(v []*string) *AuthResult {
	s.MissingContextValues = v
	return s
}

// An object that specifies the authorization service for a domain.
type AuthorizerConfig struct {
	_ struct{} `type:"structure"`

	// A Boolean that specifies whether the domain configuration's authorization
	// service can be overridden.
	AllowAuthorizerOverride *bool `locationName:"allowAuthorizerOverride" type:"boolean"`

	// The name of the authorization service for a domain configuration.
	DefaultAuthorizerName *string `locationName:"defaultAuthorizerName" min:"1" type:"string"`
}

// String returns the string representation
func (s AuthorizerConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizerConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizerConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthorizerConfig"}
	if s.DefaultAuthorizerName != nil && len(*s.DefaultAuthorizerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultAuthorizerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowAuthorizerOverride sets the AllowAuthorizerOverride field's value.
func (s *AuthorizerConfig) SetAllowAuthorizerOverride(v bool) *AuthorizerConfig {
	s.AllowAuthorizerOverride = &v
	return s
}

// SetDefaultAuthorizerName sets the DefaultAuthorizerName field's value.
func (s *AuthorizerConfig) SetDefaultAuthorizerName(v string) *AuthorizerConfig {
	s.DefaultAuthorizerName = &v
	return s
}

// The authorizer description.
type AuthorizerDescription struct {
	_ struct{} `type:"structure"`

	// The authorizer ARN.
	AuthorizerArn *string `locationName:"authorizerArn" type:"string"`

	// The authorizer's Lambda function ARN.
	AuthorizerFunctionArn *string `locationName:"authorizerFunctionArn" type:"string"`

	// The authorizer name.
	AuthorizerName *string `locationName:"authorizerName" min:"1" type:"string"`

	// The UNIX timestamp of when the authorizer was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The UNIX timestamp of when the authorizer was last updated.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp"`

	// Specifies whether AWS IoT validates the token signature in an authorization
	// request.
	SigningDisabled *bool `locationName:"signingDisabled" type:"boolean"`

	// The status of the authorizer.
	Status *string `locationName:"status" type:"string" enum:"AuthorizerStatus"`

	// The key used to extract the token from the HTTP headers.
	TokenKeyName *string `locationName:"tokenKeyName" min:"1" type:"string"`

	// The public keys used to validate the token signature returned by your custom
	// authentication service.
	TokenSigningPublicKeys map[string]*string `locationName:"tokenSigningPublicKeys" type:"map"`
}

// String returns the string representation
func (s AuthorizerDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizerDescription) GoString() string {
	return s.String()
}

// SetAuthorizerArn sets the AuthorizerArn field's value.
func (s *AuthorizerDescription) SetAuthorizerArn(v string) *AuthorizerDescription {
	s.AuthorizerArn = &v
	return s
}

// SetAuthorizerFunctionArn sets the AuthorizerFunctionArn field's value.
func (s *AuthorizerDescription) SetAuthorizerFunctionArn(v string) *AuthorizerDescription {
	s.AuthorizerFunctionArn = &v
	return s
}

// SetAuthorizerName sets the AuthorizerName field's value.
func (s *AuthorizerDescription) SetAuthorizerName(v string) *AuthorizerDescription {
	s.AuthorizerName = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *AuthorizerDescription) SetCreationDate(v time.Time) *AuthorizerDescription {
	s.CreationDate = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *AuthorizerDescription) SetLastModifiedDate(v time.Time) *AuthorizerDescription {
	s.LastModifiedDate = &v
	return s
}

// SetSigningDisabled sets the SigningDisabled field's value.
func (s *AuthorizerDescription) SetSigningDisabled(v bool) *AuthorizerDescription {
	s.SigningDisabled = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AuthorizerDescription) SetStatus(v string) *AuthorizerDescription {
	s.Status = &v
	return s
}

// SetTokenKeyName sets the TokenKeyName field's value.
func (s *AuthorizerDescription) SetTokenKeyName(v string) *AuthorizerDescription {
	s.TokenKeyName = &v
	return s
}

// SetTokenSigningPublicKeys sets the TokenSigningPublicKeys field's value.
func (s *AuthorizerDescription) SetTokenSigningPublicKeys(v map[string]*string) *AuthorizerDescription {
	s.TokenSigningPublicKeys = v
	return s
}

// The authorizer summary.
type AuthorizerSummary struct {
	_ struct{} `type:"structure"`

	// The authorizer ARN.
	AuthorizerArn *string `locationName:"authorizerArn" type:"string"`

	// The authorizer name.
	AuthorizerName *string `locationName:"authorizerName" min:"1" type:"string"`
}

// String returns the string representation
func (s AuthorizerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizerSummary) GoString() string {
	return s.String()
}

// SetAuthorizerArn sets the AuthorizerArn field's value.
func (s *AuthorizerSummary) SetAuthorizerArn(v string) *AuthorizerSummary {
	s.AuthorizerArn = &v
	return s
}

// SetAuthorizerName sets the AuthorizerName field's value.
func (s *AuthorizerSummary) SetAuthorizerName(v string) *AuthorizerSummary {
	s.AuthorizerName = &v
	return s
}

// Configuration for the rollout of OTA updates.
type AwsJobExecutionsRolloutConfig struct {
	_ struct{} `type:"structure"`

	// The maximum number of OTA update job executions started per minute.
	MaximumPerMinute *int64 `locationName:"maximumPerMinute" min:"1" type:"integer"`
}

// String returns the string representation
func (s AwsJobExecutionsRolloutConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsJobExecutionsRolloutConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsJobExecutionsRolloutConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsJobExecutionsRolloutConfig"}
	if s.MaximumPerMinute != nil && *s.MaximumPerMinute < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumPerMinute", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaximumPerMinute sets the MaximumPerMinute field's value.
func (s *AwsJobExecutionsRolloutConfig) SetMaximumPerMinute(v int64) *AwsJobExecutionsRolloutConfig {
	s.MaximumPerMinute = &v
	return s
}

// Configuration information for pre-signed URLs. Valid when protocols contains
// HTTP.
type AwsJobPresignedUrlConfig struct {
	_ struct{} `type:"structure"`

	// How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600,
	// the default value is 1800 seconds. Pre-signed URLs are generated when a request
	// for the job document is received.
	ExpiresInSec *int64 `locationName:"expiresInSec" type:"long"`
}

// String returns the string representation
func (s AwsJobPresignedUrlConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsJobPresignedUrlConfig) GoString() string {
	return s.String()
}

// SetExpiresInSec sets the ExpiresInSec field's value.
func (s *AwsJobPresignedUrlConfig) SetExpiresInSec(v int64) *AwsJobPresignedUrlConfig {
	s.ExpiresInSec = &v
	return s
}

// A Device Defender security profile behavior.
type Behavior struct {
	_ struct{} `type:"structure"`

	// The criteria that determine if a device is behaving normally in regard to
	// the metric.
	Criteria *BehaviorCriteria `locationName:"criteria" type:"structure"`

	// What is measured by the behavior.
	Metric *string `locationName:"metric" type:"string"`

	// The dimension for a metric in your behavior. For example, using a TOPIC_FILTER
	// dimension, you can narrow down the scope of the metric only to MQTT topics
	// whose name match the pattern specified in the dimension.
	MetricDimension *MetricDimension `locationName:"metricDimension" type:"structure"`

	// The name you have given to the behavior.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Behavior) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Behavior) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Behavior) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Behavior"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Criteria != nil {
		if err := s.Criteria.Validate(); err != nil {
			invalidParams.AddNested("Criteria", err.(request.ErrInvalidParams))
		}
	}
	if s.MetricDimension != nil {
		if err := s.MetricDimension.Validate(); err != nil {
			invalidParams.AddNested("MetricDimension", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCriteria sets the Criteria field's value.
func (s *Behavior) SetCriteria(v *BehaviorCriteria) *Behavior {
	s.Criteria = v
	return s
}

// SetMetric sets the Metric field's value.
func (s *Behavior) SetMetric(v string) *Behavior {
	s.Metric = &v
	return s
}

// SetMetricDimension sets the MetricDimension field's value.
func (s *Behavior) SetMetricDimension(v *MetricDimension) *Behavior {
	s.MetricDimension = v
	return s
}

// SetName sets the Name field's value.
func (s *Behavior) SetName(v string) *Behavior {
	s.Name = &v
	return s
}

// The criteria by which the behavior is determined to be normal.
type BehaviorCriteria struct {
	_ struct{} `type:"structure"`

	// The operator that relates the thing measured (metric) to the criteria (containing
	// a value or statisticalThreshold).
	ComparisonOperator *string `locationName:"comparisonOperator" type:"string" enum:"ComparisonOperator"`

	// If a device is in violation of the behavior for the specified number of consecutive
	// datapoints, an alarm occurs. If not specified, the default is 1.
	ConsecutiveDatapointsToAlarm *int64 `locationName:"consecutiveDatapointsToAlarm" min:"1" type:"integer"`

	// If an alarm has occurred and the offending device is no longer in violation
	// of the behavior for the specified number of consecutive datapoints, the alarm
	// is cleared. If not specified, the default is 1.
	ConsecutiveDatapointsToClear *int64 `locationName:"consecutiveDatapointsToClear" min:"1" type:"integer"`

	// Use this to specify the time duration over which the behavior is evaluated,
	// for those criteria which have a time dimension (for example, NUM_MESSAGES_SENT).
	// For a statisticalThreshhold metric comparison, measurements from all devices
	// are accumulated over this time duration before being used to calculate percentiles,
	// and later, measurements from an individual device are also accumulated over
	// this time duration before being given a percentile rank.
	DurationSeconds *int64 `locationName:"durationSeconds" type:"integer"`

	// A statistical ranking (percentile) which indicates a threshold value by which
	// a behavior is determined to be in compliance or in violation of the behavior.
	StatisticalThreshold *StatisticalThreshold `locationName:"statisticalThreshold" type:"structure"`

	// The value to be compared with the metric.
	Value *MetricValue `locationName:"value" type:"structure"`
}

// String returns the string representation
func (s BehaviorCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BehaviorCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BehaviorCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BehaviorCriteria"}
	if s.ConsecutiveDatapointsToAlarm != nil && *s.ConsecutiveDatapointsToAlarm < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ConsecutiveDatapointsToAlarm", 1))
	}
	if s.ConsecutiveDatapointsToClear != nil && *s.ConsecutiveDatapointsToClear < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ConsecutiveDatapointsToClear", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *BehaviorCriteria) SetComparisonOperator(v string) *BehaviorCriteria {
	s.ComparisonOperator = &v
	return s
}

// SetConsecutiveDatapointsToAlarm sets the ConsecutiveDatapointsToAlarm field's value.
func (s *BehaviorCriteria) SetConsecutiveDatapointsToAlarm(v int64) *BehaviorCriteria {
	s.ConsecutiveDatapointsToAlarm = &v
	return s
}

// SetConsecutiveDatapointsToClear sets the ConsecutiveDatapointsToClear field's value.
func (s *BehaviorCriteria) SetConsecutiveDatapointsToClear(v int64) *BehaviorCriteria {
	s.ConsecutiveDatapointsToClear = &v
	return s
}

// SetDurationSeconds sets the DurationSeconds field's value.
func (s *BehaviorCriteria) SetDurationSeconds(v int64) *BehaviorCriteria {
	s.DurationSeconds = &v
	return s
}

// SetStatisticalThreshold sets the StatisticalThreshold field's value.
func (s *BehaviorCriteria) SetStatisticalThreshold(v *StatisticalThreshold) *BehaviorCriteria {
	s.StatisticalThreshold = v
	return s
}

// SetValue sets the Value field's value.
func (s *BehaviorCriteria) SetValue(v *MetricValue) *BehaviorCriteria {
	s.Value = v
	return s
}

// Additional information about the billing group.
type BillingGroupMetadata struct {
	_ struct{} `type:"structure"`

	// The date the billing group was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`
}

// String returns the string representation
func (s BillingGroupMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BillingGroupMetadata) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *BillingGroupMetadata) SetCreationDate(v time.Time) *BillingGroupMetadata {
	s.CreationDate = &v
	return s
}

// The properties of a billing group.
type BillingGroupProperties struct {
	_ struct{} `type:"structure"`

	// The description of the billing group.
	BillingGroupDescription *string `locationName:"billingGroupDescription" type:"string"`
}

// String returns the string representation
func (s BillingGroupProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BillingGroupProperties) GoString() string {
	return s.String()
}

// SetBillingGroupDescription sets the BillingGroupDescription field's value.
func (s *BillingGroupProperties) SetBillingGroupDescription(v string) *BillingGroupProperties {
	s.BillingGroupDescription = &v
	return s
}

// A CA certificate.
type CACertificate struct {
	_ struct{} `type:"structure"`

	// The ARN of the CA certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the CA certificate.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The date the CA certificate was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The status of the CA certificate.
	//
	// The status value REGISTER_INACTIVE is deprecated and should not be used.
	Status *string `locationName:"status" type:"string" enum:"CACertificateStatus"`
}

// String returns the string representation
func (s CACertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CACertificate) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CACertificate) SetCertificateArn(v string) *CACertificate {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *CACertificate) SetCertificateId(v string) *CACertificate {
	s.CertificateId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CACertificate) SetCreationDate(v time.Time) *CACertificate {
	s.CreationDate = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CACertificate) SetStatus(v string) *CACertificate {
	s.Status = &v
	return s
}

// Describes a CA certificate.
type CACertificateDescription struct {
	_ struct{} `type:"structure"`

	// Whether the CA certificate configured for auto registration of device certificates.
	// Valid values are "ENABLE" and "DISABLE"
	AutoRegistrationStatus *string `locationName:"autoRegistrationStatus" type:"string" enum:"AutoRegistrationStatus"`

	// The CA certificate ARN.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The CA certificate ID.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The CA certificate data, in PEM format.
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string"`

	// The date the CA certificate was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The customer version of the CA certificate.
	CustomerVersion *int64 `locationName:"customerVersion" min:"1" type:"integer"`

	// The generation ID of the CA certificate.
	GenerationId *string `locationName:"generationId" type:"string"`

	// The date the CA certificate was last modified.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp"`

	// The owner of the CA certificate.
	OwnedBy *string `locationName:"ownedBy" min:"12" type:"string"`

	// The status of a CA certificate.
	Status *string `locationName:"status" type:"string" enum:"CACertificateStatus"`

	// When the CA certificate is valid.
	Validity *CertificateValidity `locationName:"validity" type:"structure"`
}

// String returns the string representation
func (s CACertificateDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CACertificateDescription) GoString() string {
	return s.String()
}

// SetAutoRegistrationStatus sets the AutoRegistrationStatus field's value.
func (s *CACertificateDescription) SetAutoRegistrationStatus(v string) *CACertificateDescription {
	s.AutoRegistrationStatus = &v
	return s
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CACertificateDescription) SetCertificateArn(v string) *CACertificateDescription {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *CACertificateDescription) SetCertificateId(v string) *CACertificateDescription {
	s.CertificateId = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *CACertificateDescription) SetCertificatePem(v string) *CACertificateDescription {
	s.CertificatePem = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CACertificateDescription) SetCreationDate(v time.Time) *CACertificateDescription {
	s.CreationDate = &v
	return s
}

// SetCustomerVersion sets the CustomerVersion field's value.
func (s *CACertificateDescription) SetCustomerVersion(v int64) *CACertificateDescription {
	s.CustomerVersion = &v
	return s
}

// SetGenerationId sets the GenerationId field's value.
func (s *CACertificateDescription) SetGenerationId(v string) *CACertificateDescription {
	s.GenerationId = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *CACertificateDescription) SetLastModifiedDate(v time.Time) *CACertificateDescription {
	s.LastModifiedDate = &v
	return s
}

// SetOwnedBy sets the OwnedBy field's value.
func (s *CACertificateDescription) SetOwnedBy(v string) *CACertificateDescription {
	s.OwnedBy = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CACertificateDescription) SetStatus(v string) *CACertificateDescription {
	s.Status = &v
	return s
}

// SetValidity sets the Validity field's value.
func (s *CACertificateDescription) SetValidity(v *CertificateValidity) *CACertificateDescription {
	s.Validity = v
	return s
}

type CancelAuditMitigationActionsTaskInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the task that you want to cancel.
	//
	// TaskId is a required field
	TaskId *string `location:"uri" locationName:"taskId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelAuditMitigationActionsTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelAuditMitigationActionsTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelAuditMitigationActionsTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelAuditMitigationActionsTaskInput"}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskId sets the TaskId field's value.
func (s *CancelAuditMitigationActionsTaskInput) SetTaskId(v string) *CancelAuditMitigationActionsTaskInput {
	s.TaskId = &v
	return s
}

type CancelAuditMitigationActionsTaskOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelAuditMitigationActionsTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelAuditMitigationActionsTaskOutput) GoString() string {
	return s.String()
}

type CancelAuditTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the audit you want to cancel. You can only cancel an audit that
	// is "IN_PROGRESS".
	//
	// TaskId is a required field
	TaskId *string `location:"uri" locationName:"taskId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelAuditTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelAuditTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelAuditTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelAuditTaskInput"}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskId sets the TaskId field's value.
func (s *CancelAuditTaskInput) SetTaskId(v string) *CancelAuditTaskInput {
	s.TaskId = &v
	return s
}

type CancelAuditTaskOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelAuditTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelAuditTaskOutput) GoString() string {
	return s.String()
}

// The input for the CancelCertificateTransfer operation.
type CancelCertificateTransferInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate. (The last part of the certificate ARN contains
	// the certificate ID.)
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelCertificateTransferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelCertificateTransferInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelCertificateTransferInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelCertificateTransferInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *CancelCertificateTransferInput) SetCertificateId(v string) *CancelCertificateTransferInput {
	s.CertificateId = &v
	return s
}

type CancelCertificateTransferOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelCertificateTransferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelCertificateTransferOutput) GoString() string {
	return s.String()
}

type CancelJobExecutionInput struct {
	_ struct{} `type:"structure"`

	// (Optional) The expected current version of the job execution. Each time you
	// update the job execution, its version is incremented. If the version of the
	// job execution stored in Jobs does not match, the update is rejected with
	// a VersionMismatch error, and an ErrorResponse that contains the current job
	// execution status data is returned. (This makes it unnecessary to perform
	// a separate DescribeJobExecution request in order to obtain the job execution
	// status data.)
	ExpectedVersion *int64 `locationName:"expectedVersion" type:"long"`

	// (Optional) If true the job execution will be canceled if it has status IN_PROGRESS
	// or QUEUED, otherwise the job execution will be canceled only if it has status
	// QUEUED. If you attempt to cancel a job execution that is IN_PROGRESS, and
	// you do not set force to true, then an InvalidStateTransitionException will
	// be thrown. The default is false.
	//
	// Canceling a job execution which is "IN_PROGRESS", will cause the device to
	// be unable to update the job execution status. Use caution and ensure that
	// the device is able to recover to a valid state.
	Force *bool `location:"querystring" locationName:"force" type:"boolean"`

	// The ID of the job to be canceled.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" min:"1" type:"string" required:"true"`

	// A collection of name/value pairs that describe the status of the job execution.
	// If not specified, the statusDetails are unchanged. You can specify at most
	// 10 name/value pairs.
	StatusDetails map[string]*string `locationName:"statusDetails" type:"map"`

	// The name of the thing whose execution of the job will be canceled.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelJobExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelJobExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelJobExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelJobExecutionInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpectedVersion sets the ExpectedVersion field's value.
func (s *CancelJobExecutionInput) SetExpectedVersion(v int64) *CancelJobExecutionInput {
	s.ExpectedVersion = &v
	return s
}

// SetForce sets the Force field's value.
func (s *CancelJobExecutionInput) SetForce(v bool) *CancelJobExecutionInput {
	s.Force = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CancelJobExecutionInput) SetJobId(v string) *CancelJobExecutionInput {
	s.JobId = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *CancelJobExecutionInput) SetStatusDetails(v map[string]*string) *CancelJobExecutionInput {
	s.StatusDetails = v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *CancelJobExecutionInput) SetThingName(v string) *CancelJobExecutionInput {
	s.ThingName = &v
	return s
}

type CancelJobExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelJobExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelJobExecutionOutput) GoString() string {
	return s.String()
}

type CancelJobInput struct {
	_ struct{} `type:"structure"`

	// An optional comment string describing why the job was canceled.
	Comment *string `locationName:"comment" type:"string"`

	// (Optional) If true job executions with status "IN_PROGRESS" and "QUEUED"
	// are canceled, otherwise only job executions with status "QUEUED" are canceled.
	// The default is false.
	//
	// Canceling a job which is "IN_PROGRESS", will cause a device which is executing
	// the job to be unable to update the job execution status. Use caution and
	// ensure that each device executing a job which is canceled is able to recover
	// to a valid state.
	Force *bool `location:"querystring" locationName:"force" type:"boolean"`

	// The unique identifier you assigned to this job when it was created.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" min:"1" type:"string" required:"true"`

	// (Optional)A reason code string that explains why the job was canceled.
	ReasonCode *string `locationName:"reasonCode" type:"string"`
}

// String returns the string representation
func (s CancelJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *CancelJobInput) SetComment(v string) *CancelJobInput {
	s.Comment = &v
	return s
}

// SetForce sets the Force field's value.
func (s *CancelJobInput) SetForce(v bool) *CancelJobInput {
	s.Force = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CancelJobInput) SetJobId(v string) *CancelJobInput {
	s.JobId = &v
	return s
}

// SetReasonCode sets the ReasonCode field's value.
func (s *CancelJobInput) SetReasonCode(v string) *CancelJobInput {
	s.ReasonCode = &v
	return s
}

type CancelJobOutput struct {
	_ struct{} `type:"structure"`

	// A short text description of the job.
	Description *string `locationName:"description" type:"string"`

	// The job ARN.
	JobArn *string `locationName:"jobArn" type:"string"`

	// The unique identifier you assigned to this job when it was created.
	JobId *string `locationName:"jobId" min:"1" type:"string"`
}

// String returns the string representation
func (s CancelJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelJobOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CancelJobOutput) SetDescription(v string) *CancelJobOutput {
	s.Description = &v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *CancelJobOutput) SetJobArn(v string) *CancelJobOutput {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CancelJobOutput) SetJobId(v string) *CancelJobOutput {
	s.JobId = &v
	return s
}

// Information about a certificate.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the certificate. (The last part of the certificate ARN contains
	// the certificate ID.)
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The date and time the certificate was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The status of the certificate.
	//
	// The status value REGISTER_INACTIVE is deprecated and should not be used.
	Status *string `locationName:"status" type:"string" enum:"CertificateStatus"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Certificate) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *Certificate) SetCertificateArn(v string) *Certificate {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *Certificate) SetCertificateId(v string) *Certificate {
	s.CertificateId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *Certificate) SetCreationDate(v time.Time) *Certificate {
	s.CreationDate = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Certificate) SetStatus(v string) *Certificate {
	s.Status = &v
	return s
}

// Unable to verify the CA certificate used to sign the device certificate you
// are attempting to register. This is happens when you have registered more
// than one CA certificate that has the same subject field and public key.
type CertificateConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s CertificateConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateConflictException) GoString() string {
	return s.String()
}

func newErrorCertificateConflictException(v protocol.ResponseMetadata) error {
	return &CertificateConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CertificateConflictException) Code() string {
	return "CertificateConflictException"
}

// Message returns the exception's message.
func (s *CertificateConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CertificateConflictException) OrigErr() error {
	return nil
}

func (s *CertificateConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CertificateConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CertificateConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a certificate.
type CertificateDescription struct {
	_ struct{} `type:"structure"`

	// The certificate ID of the CA certificate used to sign this certificate.
	CaCertificateId *string `locationName:"caCertificateId" min:"64" type:"string"`

	// The ARN of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the certificate.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The certificate data, in PEM format.
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string"`

	// The date and time the certificate was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The customer version of the certificate.
	CustomerVersion *int64 `locationName:"customerVersion" min:"1" type:"integer"`

	// The generation ID of the certificate.
	GenerationId *string `locationName:"generationId" type:"string"`

	// The date and time the certificate was last modified.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp"`

	// The ID of the AWS account that owns the certificate.
	OwnedBy *string `locationName:"ownedBy" min:"12" type:"string"`

	// The ID of the AWS account of the previous owner of the certificate.
	PreviousOwnedBy *string `locationName:"previousOwnedBy" min:"12" type:"string"`

	// The status of the certificate.
	Status *string `locationName:"status" type:"string" enum:"CertificateStatus"`

	// The transfer data.
	TransferData *TransferData `locationName:"transferData" type:"structure"`

	// When the certificate is valid.
	Validity *CertificateValidity `locationName:"validity" type:"structure"`
}

// String returns the string representation
func (s CertificateDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateDescription) GoString() string {
	return s.String()
}

// SetCaCertificateId sets the CaCertificateId field's value.
func (s *CertificateDescription) SetCaCertificateId(v string) *CertificateDescription {
	s.CaCertificateId = &v
	return s
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CertificateDescription) SetCertificateArn(v string) *CertificateDescription {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *CertificateDescription) SetCertificateId(v string) *CertificateDescription {
	s.CertificateId = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *CertificateDescription) SetCertificatePem(v string) *CertificateDescription {
	s.CertificatePem = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CertificateDescription) SetCreationDate(v time.Time) *CertificateDescription {
	s.CreationDate = &v
	return s
}

// SetCustomerVersion sets the CustomerVersion field's value.
func (s *CertificateDescription) SetCustomerVersion(v int64) *CertificateDescription {
	s.CustomerVersion = &v
	return s
}

// SetGenerationId sets the GenerationId field's value.
func (s *CertificateDescription) SetGenerationId(v string) *CertificateDescription {
	s.GenerationId = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *CertificateDescription) SetLastModifiedDate(v time.Time) *CertificateDescription {
	s.LastModifiedDate = &v
	return s
}

// SetOwnedBy sets the OwnedBy field's value.
func (s *CertificateDescription) SetOwnedBy(v string) *CertificateDescription {
	s.OwnedBy = &v
	return s
}

// SetPreviousOwnedBy sets the PreviousOwnedBy field's value.
func (s *CertificateDescription) SetPreviousOwnedBy(v string) *CertificateDescription {
	s.PreviousOwnedBy = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CertificateDescription) SetStatus(v string) *CertificateDescription {
	s.Status = &v
	return s
}

// SetTransferData sets the TransferData field's value.
func (s *CertificateDescription) SetTransferData(v *TransferData) *CertificateDescription {
	s.TransferData = v
	return s
}

// SetValidity sets the Validity field's value.
func (s *CertificateDescription) SetValidity(v *CertificateValidity) *CertificateDescription {
	s.Validity = v
	return s
}

// The certificate operation is not allowed.
type CertificateStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s CertificateStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateStateException) GoString() string {
	return s.String()
}

func newErrorCertificateStateException(v protocol.ResponseMetadata) error {
	return &CertificateStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CertificateStateException) Code() string {
	return "CertificateStateException"
}

// Message returns the exception's message.
func (s *CertificateStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CertificateStateException) OrigErr() error {
	return nil
}

func (s *CertificateStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CertificateStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CertificateStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The certificate is invalid.
type CertificateValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Additional information about the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s CertificateValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateValidationException) GoString() string {
	return s.String()
}

func newErrorCertificateValidationException(v protocol.ResponseMetadata) error {
	return &CertificateValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CertificateValidationException) Code() string {
	return "CertificateValidationException"
}

// Message returns the exception's message.
func (s *CertificateValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CertificateValidationException) OrigErr() error {
	return nil
}

func (s *CertificateValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CertificateValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CertificateValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// When the certificate is valid.
type CertificateValidity struct {
	_ struct{} `type:"structure"`

	// The certificate is not valid after this date.
	NotAfter *time.Time `locationName:"notAfter" type:"timestamp"`

	// The certificate is not valid before this date.
	NotBefore *time.Time `locationName:"notBefore" type:"timestamp"`
}

// String returns the string representation
func (s CertificateValidity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateValidity) GoString() string {
	return s.String()
}

// SetNotAfter sets the NotAfter field's value.
func (s *CertificateValidity) SetNotAfter(v time.Time) *CertificateValidity {
	s.NotAfter = &v
	return s
}

// SetNotBefore sets the NotBefore field's value.
func (s *CertificateValidity) SetNotBefore(v time.Time) *CertificateValidity {
	s.NotBefore = &v
	return s
}

type ClearDefaultAuthorizerInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ClearDefaultAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClearDefaultAuthorizerInput) GoString() string {
	return s.String()
}

type ClearDefaultAuthorizerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ClearDefaultAuthorizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClearDefaultAuthorizerOutput) GoString() string {
	return s.String()
}

// Describes an action that updates a CloudWatch alarm.
type CloudwatchAlarmAction struct {
	_ struct{} `type:"structure"`

	// The CloudWatch alarm name.
	//
	// AlarmName is a required field
	AlarmName *string `locationName:"alarmName" type:"string" required:"true"`

	// The IAM role that allows access to the CloudWatch alarm.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The reason for the alarm change.
	//
	// StateReason is a required field
	StateReason *string `locationName:"stateReason" type:"string" required:"true"`

	// The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
	//
	// StateValue is a required field
	StateValue *string `locationName:"stateValue" type:"string" required:"true"`
}

// String returns the string representation
func (s CloudwatchAlarmAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudwatchAlarmAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudwatchAlarmAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudwatchAlarmAction"}
	if s.AlarmName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmName"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.StateReason == nil {
		invalidParams.Add(request.NewErrParamRequired("StateReason"))
	}
	if s.StateValue == nil {
		invalidParams.Add(request.NewErrParamRequired("StateValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmName sets the AlarmName field's value.
func (s *CloudwatchAlarmAction) SetAlarmName(v string) *CloudwatchAlarmAction {
	s.AlarmName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CloudwatchAlarmAction) SetRoleArn(v string) *CloudwatchAlarmAction {
	s.RoleArn = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *CloudwatchAlarmAction) SetStateReason(v string) *CloudwatchAlarmAction {
	s.StateReason = &v
	return s
}

// SetStateValue sets the StateValue field's value.
func (s *CloudwatchAlarmAction) SetStateValue(v string) *CloudwatchAlarmAction {
	s.StateValue = &v
	return s
}

// Describes an action that sends data to CloudWatch Logs.
type CloudwatchLogsAction struct {
	_ struct{} `type:"structure"`

	// The CloudWatch log group to which the action sends data.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" type:"string" required:"true"`

	// The IAM role that allows access to the CloudWatch log.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s CloudwatchLogsAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudwatchLogsAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudwatchLogsAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudwatchLogsAction"}
	if s.LogGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("LogGroupName"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *CloudwatchLogsAction) SetLogGroupName(v string) *CloudwatchLogsAction {
	s.LogGroupName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CloudwatchLogsAction) SetRoleArn(v string) *CloudwatchLogsAction {
	s.RoleArn = &v
	return s
}

// Describes an action that captures a CloudWatch metric.
type CloudwatchMetricAction struct {
	_ struct{} `type:"structure"`

	// The CloudWatch metric name.
	//
	// MetricName is a required field
	MetricName *string `locationName:"metricName" type:"string" required:"true"`

	// The CloudWatch metric namespace name.
	//
	// MetricNamespace is a required field
	MetricNamespace *string `locationName:"metricNamespace" type:"string" required:"true"`

	// An optional Unix timestamp (https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp).
	MetricTimestamp *string `locationName:"metricTimestamp" type:"string"`

	// The metric unit (https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit)
	// supported by CloudWatch.
	//
	// MetricUnit is a required field
	MetricUnit *string `locationName:"metricUnit" type:"string" required:"true"`

	// The CloudWatch metric value.
	//
	// MetricValue is a required field
	MetricValue *string `locationName:"metricValue" type:"string" required:"true"`

	// The IAM role that allows access to the CloudWatch metric.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s CloudwatchMetricAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudwatchMetricAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudwatchMetricAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudwatchMetricAction"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricNamespace"))
	}
	if s.MetricUnit == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricUnit"))
	}
	if s.MetricValue == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricValue"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricName sets the MetricName field's value.
func (s *CloudwatchMetricAction) SetMetricName(v string) *CloudwatchMetricAction {
	s.MetricName = &v
	return s
}

// SetMetricNamespace sets the MetricNamespace field's value.
func (s *CloudwatchMetricAction) SetMetricNamespace(v string) *CloudwatchMetricAction {
	s.MetricNamespace = &v
	return s
}

// SetMetricTimestamp sets the MetricTimestamp field's value.
func (s *CloudwatchMetricAction) SetMetricTimestamp(v string) *CloudwatchMetricAction {
	s.MetricTimestamp = &v
	return s
}

// SetMetricUnit sets the MetricUnit field's value.
func (s *CloudwatchMetricAction) SetMetricUnit(v string) *CloudwatchMetricAction {
	s.MetricUnit = &v
	return s
}

// SetMetricValue sets the MetricValue field's value.
func (s *CloudwatchMetricAction) SetMetricValue(v string) *CloudwatchMetricAction {
	s.MetricValue = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CloudwatchMetricAction) SetRoleArn(v string) *CloudwatchMetricAction {
	s.RoleArn = &v
	return s
}

// Describes the method to use when code signing a file.
type CodeSigning struct {
	_ struct{} `type:"structure"`

	// The ID of the AWSSignerJob which was created to sign the file.
	AwsSignerJobId *string `locationName:"awsSignerJobId" type:"string"`

	// A custom method for code signing a file.
	CustomCodeSigning *CustomCodeSigning `locationName:"customCodeSigning" type:"structure"`

	// Describes the code-signing job.
	StartSigningJobParameter *StartSigningJobParameter `locationName:"startSigningJobParameter" type:"structure"`
}

// String returns the string representation
func (s CodeSigning) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeSigning) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeSigning) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeSigning"}
	if s.StartSigningJobParameter != nil {
		if err := s.StartSigningJobParameter.Validate(); err != nil {
			invalidParams.AddNested("StartSigningJobParameter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsSignerJobId sets the AwsSignerJobId field's value.
func (s *CodeSigning) SetAwsSignerJobId(v string) *CodeSigning {
	s.AwsSignerJobId = &v
	return s
}

// SetCustomCodeSigning sets the CustomCodeSigning field's value.
func (s *CodeSigning) SetCustomCodeSigning(v *CustomCodeSigning) *CodeSigning {
	s.CustomCodeSigning = v
	return s
}

// SetStartSigningJobParameter sets the StartSigningJobParameter field's value.
func (s *CodeSigning) SetStartSigningJobParameter(v *StartSigningJobParameter) *CodeSigning {
	s.StartSigningJobParameter = v
	return s
}

// Describes the certificate chain being used when code signing a file.
type CodeSigningCertificateChain struct {
	_ struct{} `type:"structure"`

	// The name of the certificate.
	CertificateName *string `locationName:"certificateName" type:"string"`

	// A base64 encoded binary representation of the code signing certificate chain.
	InlineDocument *string `locationName:"inlineDocument" type:"string"`
}

// String returns the string representation
func (s CodeSigningCertificateChain) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeSigningCertificateChain) GoString() string {
	return s.String()
}

// SetCertificateName sets the CertificateName field's value.
func (s *CodeSigningCertificateChain) SetCertificateName(v string) *CodeSigningCertificateChain {
	s.CertificateName = &v
	return s
}

// SetInlineDocument sets the InlineDocument field's value.
func (s *CodeSigningCertificateChain) SetInlineDocument(v string) *CodeSigningCertificateChain {
	s.InlineDocument = &v
	return s
}

// Describes the signature for a file.
type CodeSigningSignature struct {
	_ struct{} `type:"structure"`

	// A base64 encoded binary representation of the code signing signature.
	//
	// InlineDocument is automatically base64 encoded/decoded by the SDK.
	InlineDocument []byte `locationName:"inlineDocument" type:"blob"`
}

// String returns the string representation
func (s CodeSigningSignature) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeSigningSignature) GoString() string {
	return s.String()
}

// SetInlineDocument sets the InlineDocument field's value.
func (s *CodeSigningSignature) SetInlineDocument(v []byte) *CodeSigningSignature {
	s.InlineDocument = v
	return s
}

// Configuration.
type Configuration struct {
	_ struct{} `type:"structure"`

	// True to enable the configuration.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Configuration) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *Configuration) SetEnabled(v bool) *Configuration {
	s.Enabled = &v
	return s
}

type ConfirmTopicRuleDestinationInput struct {
	_ struct{} `type:"structure"`

	// The token used to confirm ownership or access to the topic rule confirmation
	// URL.
	//
	// ConfirmationToken is a required field
	ConfirmationToken *string `location:"uri" locationName:"confirmationToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ConfirmTopicRuleDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmTopicRuleDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmTopicRuleDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmTopicRuleDestinationInput"}
	if s.ConfirmationToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfirmationToken"))
	}
	if s.ConfirmationToken != nil && len(*s.ConfirmationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfirmationToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfirmationToken sets the ConfirmationToken field's value.
func (s *ConfirmTopicRuleDestinationInput) SetConfirmationToken(v string) *ConfirmTopicRuleDestinationInput {
	s.ConfirmationToken = &v
	return s
}

type ConfirmTopicRuleDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ConfirmTopicRuleDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmTopicRuleDestinationOutput) GoString() string {
	return s.String()
}

// A conflicting resource update exception. This exception is thrown when two
// pending updates cause a conflict.
type ConflictingResourceUpdateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConflictingResourceUpdateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictingResourceUpdateException) GoString() string {
	return s.String()
}

func newErrorConflictingResourceUpdateException(v protocol.ResponseMetadata) error {
	return &ConflictingResourceUpdateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictingResourceUpdateException) Code() string {
	return "ConflictingResourceUpdateException"
}

// Message returns the exception's message.
func (s *ConflictingResourceUpdateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictingResourceUpdateException) OrigErr() error {
	return nil
}

func (s *ConflictingResourceUpdateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictingResourceUpdateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictingResourceUpdateException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAuthorizerInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the authorizer's Lambda function.
	//
	// AuthorizerFunctionArn is a required field
	AuthorizerFunctionArn *string `locationName:"authorizerFunctionArn" type:"string" required:"true"`

	// The authorizer name.
	//
	// AuthorizerName is a required field
	AuthorizerName *string `location:"uri" locationName:"authorizerName" min:"1" type:"string" required:"true"`

	// Specifies whether AWS IoT validates the token signature in an authorization
	// request.
	SigningDisabled *bool `locationName:"signingDisabled" type:"boolean"`

	// The status of the create authorizer request.
	Status *string `locationName:"status" type:"string" enum:"AuthorizerStatus"`

	// The name of the token key used to extract the token from the HTTP headers.
	TokenKeyName *string `locationName:"tokenKeyName" min:"1" type:"string"`

	// The public keys used to verify the digital signature returned by your custom
	// authentication service.
	TokenSigningPublicKeys map[string]*string `locationName:"tokenSigningPublicKeys" type:"map"`
}

// String returns the string representation
func (s CreateAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAuthorizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAuthorizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAuthorizerInput"}
	if s.AuthorizerFunctionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizerFunctionArn"))
	}
	if s.AuthorizerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizerName"))
	}
	if s.AuthorizerName != nil && len(*s.AuthorizerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizerName", 1))
	}
	if s.TokenKeyName != nil && len(*s.TokenKeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TokenKeyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizerFunctionArn sets the AuthorizerFunctionArn field's value.
func (s *CreateAuthorizerInput) SetAuthorizerFunctionArn(v string) *CreateAuthorizerInput {
	s.AuthorizerFunctionArn = &v
	return s
}

// SetAuthorizerName sets the AuthorizerName field's value.
func (s *CreateAuthorizerInput) SetAuthorizerName(v string) *CreateAuthorizerInput {
	s.AuthorizerName = &v
	return s
}

// SetSigningDisabled sets the SigningDisabled field's value.
func (s *CreateAuthorizerInput) SetSigningDisabled(v bool) *CreateAuthorizerInput {
	s.SigningDisabled = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateAuthorizerInput) SetStatus(v string) *CreateAuthorizerInput {
	s.Status = &v
	return s
}

// SetTokenKeyName sets the TokenKeyName field's value.
func (s *CreateAuthorizerInput) SetTokenKeyName(v string) *CreateAuthorizerInput {
	s.TokenKeyName = &v
	return s
}

// SetTokenSigningPublicKeys sets the TokenSigningPublicKeys field's value.
func (s *CreateAuthorizerInput) SetTokenSigningPublicKeys(v map[string]*string) *CreateAuthorizerInput {
	s.TokenSigningPublicKeys = v
	return s
}

type CreateAuthorizerOutput struct {
	_ struct{} `type:"structure"`

	// The authorizer ARN.
	AuthorizerArn *string `locationName:"authorizerArn" type:"string"`

	// The authorizer's name.
	AuthorizerName *string `locationName:"authorizerName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateAuthorizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAuthorizerOutput) GoString() string {
	return s.String()
}

// SetAuthorizerArn sets the AuthorizerArn field's value.
func (s *CreateAuthorizerOutput) SetAuthorizerArn(v string) *CreateAuthorizerOutput {
	s.AuthorizerArn = &v
	return s
}

// SetAuthorizerName sets the AuthorizerName field's value.
func (s *CreateAuthorizerOutput) SetAuthorizerName(v string) *CreateAuthorizerOutput {
	s.AuthorizerName = &v
	return s
}

type CreateBillingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name you wish to give to the billing group.
	//
	// BillingGroupName is a required field
	BillingGroupName *string `location:"uri" locationName:"billingGroupName" min:"1" type:"string" required:"true"`

	// The properties of the billing group.
	BillingGroupProperties *BillingGroupProperties `locationName:"billingGroupProperties" type:"structure"`

	// Metadata which can be used to manage the billing group.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateBillingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBillingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBillingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBillingGroupInput"}
	if s.BillingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("BillingGroupName"))
	}
	if s.BillingGroupName != nil && len(*s.BillingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BillingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingGroupName sets the BillingGroupName field's value.
func (s *CreateBillingGroupInput) SetBillingGroupName(v string) *CreateBillingGroupInput {
	s.BillingGroupName = &v
	return s
}

// SetBillingGroupProperties sets the BillingGroupProperties field's value.
func (s *CreateBillingGroupInput) SetBillingGroupProperties(v *BillingGroupProperties) *CreateBillingGroupInput {
	s.BillingGroupProperties = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBillingGroupInput) SetTags(v []*Tag) *CreateBillingGroupInput {
	s.Tags = v
	return s
}

type CreateBillingGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the billing group.
	BillingGroupArn *string `locationName:"billingGroupArn" type:"string"`

	// The ID of the billing group.
	BillingGroupId *string `locationName:"billingGroupId" min:"1" type:"string"`

	// The name you gave to the billing group.
	BillingGroupName *string `locationName:"billingGroupName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateBillingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBillingGroupOutput) GoString() string {
	return s.String()
}

// SetBillingGroupArn sets the BillingGroupArn field's value.
func (s *CreateBillingGroupOutput) SetBillingGroupArn(v string) *CreateBillingGroupOutput {
	s.BillingGroupArn = &v
	return s
}

// SetBillingGroupId sets the BillingGroupId field's value.
func (s *CreateBillingGroupOutput) SetBillingGroupId(v string) *CreateBillingGroupOutput {
	s.BillingGroupId = &v
	return s
}

// SetBillingGroupName sets the BillingGroupName field's value.
func (s *CreateBillingGroupOutput) SetBillingGroupName(v string) *CreateBillingGroupOutput {
	s.BillingGroupName = &v
	return s
}

// The input for the CreateCertificateFromCsr operation.
type CreateCertificateFromCsrInput struct {
	_ struct{} `type:"structure"`

	// The certificate signing request (CSR).
	//
	// CertificateSigningRequest is a required field
	CertificateSigningRequest *string `locationName:"certificateSigningRequest" min:"1" type:"string" required:"true"`

	// Specifies whether the certificate is active.
	SetAsActive *bool `location:"querystring" locationName:"setAsActive" type:"boolean"`
}

// String returns the string representation
func (s CreateCertificateFromCsrInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCertificateFromCsrInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCertificateFromCsrInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCertificateFromCsrInput"}
	if s.CertificateSigningRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateSigningRequest"))
	}
	if s.CertificateSigningRequest != nil && len(*s.CertificateSigningRequest) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateSigningRequest", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateSigningRequest sets the CertificateSigningRequest field's value.
func (s *CreateCertificateFromCsrInput) SetCertificateSigningRequest(v string) *CreateCertificateFromCsrInput {
	s.CertificateSigningRequest = &v
	return s
}

// SetSetAsActive sets the SetAsActive field's value.
func (s *CreateCertificateFromCsrInput) SetSetAsActive(v bool) *CreateCertificateFromCsrInput {
	s.SetAsActive = &v
	return s
}

// The output from the CreateCertificateFromCsr operation.
type CreateCertificateFromCsrOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificate. You can use the ARN as
	// a principal for policy operations.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the certificate. Certificate management operations only take a
	// certificateId.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The certificate data, in PEM format.
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateCertificateFromCsrOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCertificateFromCsrOutput) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CreateCertificateFromCsrOutput) SetCertificateArn(v string) *CreateCertificateFromCsrOutput {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *CreateCertificateFromCsrOutput) SetCertificateId(v string) *CreateCertificateFromCsrOutput {
	s.CertificateId = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *CreateCertificateFromCsrOutput) SetCertificatePem(v string) *CreateCertificateFromCsrOutput {
	s.CertificatePem = &v
	return s
}

type CreateDimensionInput struct {
	_ struct{} `type:"structure"`

	// Each dimension must have a unique client request token. If you try to create
	// a new dimension with the same token as a dimension that already exists, an
	// exception occurs. If you omit this value, AWS SDKs will automatically generate
	// a unique client request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// A unique identifier for the dimension. Choose something that describes the
	// type and value to make it easy to remember what it does.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// Specifies the value or list of values for the dimension. For TOPIC_FILTER
	// dimensions, this is a pattern used to match the MQTT topic (for example,
	// "admin/#").
	//
	// StringValues is a required field
	StringValues []*string `locationName:"stringValues" min:"1" type:"list" required:"true"`

	// Metadata that can be used to manage the dimension.
	Tags []*Tag `locationName:"tags" type:"list"`

	// Specifies the type of dimension. Supported types: TOPIC_FILTER.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"DimensionType"`
}

// String returns the string representation
func (s CreateDimensionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDimensionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDimensionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDimensionInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.StringValues == nil {
		invalidParams.Add(request.NewErrParamRequired("StringValues"))
	}
	if s.StringValues != nil && len(s.StringValues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StringValues", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateDimensionInput) SetClientRequestToken(v string) *CreateDimensionInput {
	s.ClientRequestToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDimensionInput) SetName(v string) *CreateDimensionInput {
	s.Name = &v
	return s
}

// SetStringValues sets the StringValues field's value.
func (s *CreateDimensionInput) SetStringValues(v []*string) *CreateDimensionInput {
	s.StringValues = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDimensionInput) SetTags(v []*Tag) *CreateDimensionInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateDimensionInput) SetType(v string) *CreateDimensionInput {
	s.Type = &v
	return s
}

type CreateDimensionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon resource name) of the created dimension.
	Arn *string `locationName:"arn" type:"string"`

	// A unique identifier for the dimension.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateDimensionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDimensionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDimensionOutput) SetArn(v string) *CreateDimensionOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDimensionOutput) SetName(v string) *CreateDimensionOutput {
	s.Name = &v
	return s
}

type CreateDomainConfigurationInput struct {
	_ struct{} `type:"structure"`

	// An object that specifies the authorization service for a domain.
	AuthorizerConfig *AuthorizerConfig `locationName:"authorizerConfig" type:"structure"`

	// The name of the domain configuration. This value must be unique to a region.
	//
	// DomainConfigurationName is a required field
	DomainConfigurationName *string `location:"uri" locationName:"domainConfigurationName" min:"1" type:"string" required:"true"`

	// The name of the domain.
	DomainName *string `locationName:"domainName" min:"1" type:"string"`

	// The ARNs of the certificates that AWS IoT passes to the device during the
	// TLS handshake. Currently you can specify only one certificate ARN. This value
	// is not required for AWS-managed domains.
	ServerCertificateArns []*string `locationName:"serverCertificateArns" type:"list"`

	// The type of service delivered by the endpoint.
	ServiceType *string `locationName:"serviceType" type:"string" enum:"ServiceType"`

	// The certificate used to validate the server certificate and prove domain
	// name ownership. This certificate must be signed by a public certificate authority.
	// This value is not required for AWS-managed domains.
	ValidationCertificateArn *string `locationName:"validationCertificateArn" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateDomainConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainConfigurationInput"}
	if s.DomainConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainConfigurationName"))
	}
	if s.DomainConfigurationName != nil && len(*s.DomainConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainConfigurationName", 1))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ValidationCertificateArn != nil && len(*s.ValidationCertificateArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValidationCertificateArn", 1))
	}
	if s.AuthorizerConfig != nil {
		if err := s.AuthorizerConfig.Validate(); err != nil {
			invalidParams.AddNested("AuthorizerConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizerConfig sets the AuthorizerConfig field's value.
func (s *CreateDomainConfigurationInput) SetAuthorizerConfig(v *AuthorizerConfig) *CreateDomainConfigurationInput {
	s.AuthorizerConfig = v
	return s
}

// SetDomainConfigurationName sets the DomainConfigurationName field's value.
func (s *CreateDomainConfigurationInput) SetDomainConfigurationName(v string) *CreateDomainConfigurationInput {
	s.DomainConfigurationName = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateDomainConfigurationInput) SetDomainName(v string) *CreateDomainConfigurationInput {
	s.DomainName = &v
	return s
}

// SetServerCertificateArns sets the ServerCertificateArns field's value.
func (s *CreateDomainConfigurationInput) SetServerCertificateArns(v []*string) *CreateDomainConfigurationInput {
	s.ServerCertificateArns = v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *CreateDomainConfigurationInput) SetServiceType(v string) *CreateDomainConfigurationInput {
	s.ServiceType = &v
	return s
}

// SetValidationCertificateArn sets the ValidationCertificateArn field's value.
func (s *CreateDomainConfigurationInput) SetValidationCertificateArn(v string) *CreateDomainConfigurationInput {
	s.ValidationCertificateArn = &v
	return s
}

type CreateDomainConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the domain configuration.
	DomainConfigurationArn *string `locationName:"domainConfigurationArn" type:"string"`

	// The name of the domain configuration.
	DomainConfigurationName *string `locationName:"domainConfigurationName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateDomainConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainConfigurationOutput) GoString() string {
	return s.String()
}

// SetDomainConfigurationArn sets the DomainConfigurationArn field's value.
func (s *CreateDomainConfigurationOutput) SetDomainConfigurationArn(v string) *CreateDomainConfigurationOutput {
	s.DomainConfigurationArn = &v
	return s
}

// SetDomainConfigurationName sets the DomainConfigurationName field's value.
func (s *CreateDomainConfigurationOutput) SetDomainConfigurationName(v string) *CreateDomainConfigurationOutput {
	s.DomainConfigurationName = &v
	return s
}

type CreateDynamicThingGroupInput struct {
	_ struct{} `type:"structure"`

	// The dynamic thing group index name.
	//
	// Currently one index is supported: "AWS_Things".
	IndexName *string `locationName:"indexName" min:"1" type:"string"`

	// The dynamic thing group search query string.
	//
	// See Query Syntax (https://docs.aws.amazon.com/iot/latest/developerguide/query-syntax.html)
	// for information about query string syntax.
	//
	// QueryString is a required field
	QueryString *string `locationName:"queryString" min:"1" type:"string" required:"true"`

	// The dynamic thing group query version.
	//
	// Currently one query version is supported: "2017-09-30". If not specified,
	// the query version defaults to this value.
	QueryVersion *string `locationName:"queryVersion" type:"string"`

	// Metadata which can be used to manage the dynamic thing group.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The dynamic thing group name to create.
	//
	// ThingGroupName is a required field
	ThingGroupName *string `location:"uri" locationName:"thingGroupName" min:"1" type:"string" required:"true"`

	// The dynamic thing group properties.
	ThingGroupProperties *ThingGroupProperties `locationName:"thingGroupProperties" type:"structure"`
}

// String returns the string representation
func (s CreateDynamicThingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDynamicThingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDynamicThingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDynamicThingGroupInput"}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}
	if s.QueryString == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryString"))
	}
	if s.QueryString != nil && len(*s.QueryString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryString", 1))
	}
	if s.ThingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingGroupName"))
	}
	if s.ThingGroupName != nil && len(*s.ThingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *CreateDynamicThingGroupInput) SetIndexName(v string) *CreateDynamicThingGroupInput {
	s.IndexName = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *CreateDynamicThingGroupInput) SetQueryString(v string) *CreateDynamicThingGroupInput {
	s.QueryString = &v
	return s
}

// SetQueryVersion sets the QueryVersion field's value.
func (s *CreateDynamicThingGroupInput) SetQueryVersion(v string) *CreateDynamicThingGroupInput {
	s.QueryVersion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDynamicThingGroupInput) SetTags(v []*Tag) *CreateDynamicThingGroupInput {
	s.Tags = v
	return s
}

// SetThingGroupName sets the ThingGroupName field's value.
func (s *CreateDynamicThingGroupInput) SetThingGroupName(v string) *CreateDynamicThingGroupInput {
	s.ThingGroupName = &v
	return s
}

// SetThingGroupProperties sets the ThingGroupProperties field's value.
func (s *CreateDynamicThingGroupInput) SetThingGroupProperties(v *ThingGroupProperties) *CreateDynamicThingGroupInput {
	s.ThingGroupProperties = v
	return s
}

type CreateDynamicThingGroupOutput struct {
	_ struct{} `type:"structure"`

	// The dynamic thing group index name.
	IndexName *string `locationName:"indexName" min:"1" type:"string"`

	// The dynamic thing group search query string.
	QueryString *string `locationName:"queryString" min:"1" type:"string"`

	// The dynamic thing group query version.
	QueryVersion *string `locationName:"queryVersion" type:"string"`

	// The dynamic thing group ARN.
	ThingGroupArn *string `locationName:"thingGroupArn" type:"string"`

	// The dynamic thing group ID.
	ThingGroupId *string `locationName:"thingGroupId" min:"1" type:"string"`

	// The dynamic thing group name.
	ThingGroupName *string `locationName:"thingGroupName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateDynamicThingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDynamicThingGroupOutput) GoString() string {
	return s.String()
}

// SetIndexName sets the IndexName field's value.
func (s *CreateDynamicThingGroupOutput) SetIndexName(v string) *CreateDynamicThingGroupOutput {
	s.IndexName = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *CreateDynamicThingGroupOutput) SetQueryString(v string) *CreateDynamicThingGroupOutput {
	s.QueryString = &v
	return s
}

// SetQueryVersion sets the QueryVersion field's value.
func (s *CreateDynamicThingGroupOutput) SetQueryVersion(v string) *CreateDynamicThingGroupOutput {
	s.QueryVersion = &v
	return s
}

// SetThingGroupArn sets the ThingGroupArn field's value.
func (s *CreateDynamicThingGroupOutput) SetThingGroupArn(v string) *CreateDynamicThingGroupOutput {
	s.ThingGroupArn = &v
	return s
}

// SetThingGroupId sets the ThingGroupId field's value.
func (s *CreateDynamicThingGroupOutput) SetThingGroupId(v string) *CreateDynamicThingGroupOutput {
	s.ThingGroupId = &v
	return s
}

// SetThingGroupName sets the ThingGroupName field's value.
func (s *CreateDynamicThingGroupOutput) SetThingGroupName(v string) *CreateDynamicThingGroupOutput {
	s.ThingGroupName = &v
	return s
}

type CreateJobInput struct {
	_ struct{} `type:"structure"`

	// Allows you to create criteria to abort a job.
	AbortConfig *AbortConfig `locationName:"abortConfig" type:"structure"`

	// A short text description of the job.
	Description *string `locationName:"description" type:"string"`

	// The job document.
	//
	// If the job document resides in an S3 bucket, you must use a placeholder link
	// when specifying the document.
	//
	// The placeholder link is of the following form:
	//
	// ${aws:iot:s3-presigned-url:https://s3.amazonaws.com/bucket/key}
	//
	// where bucket is your bucket name and key is the object in the bucket to which
	// you are linking.
	Document *string `locationName:"document" type:"string"`

	// An S3 link to the job document.
	DocumentSource *string `locationName:"documentSource" min:"1" type:"string"`

	// Allows you to create a staged rollout of the job.
	JobExecutionsRolloutConfig *JobExecutionsRolloutConfig `locationName:"jobExecutionsRolloutConfig" type:"structure"`

	// A job identifier which must be unique for your AWS account. We recommend
	// using a UUID. Alpha-numeric characters, "-" and "_" are valid for use here.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" min:"1" type:"string" required:"true"`

	// Configuration information for pre-signed S3 URLs.
	PresignedUrlConfig *PresignedUrlConfig `locationName:"presignedUrlConfig" type:"structure"`

	// Metadata which can be used to manage the job.
	Tags []*Tag `locationName:"tags" type:"list"`

	// Specifies whether the job will continue to run (CONTINUOUS), or will be complete
	// after all those things specified as targets have completed the job (SNAPSHOT).
	// If continuous, the job may also be run on a thing when a change is detected
	// in a target. For example, a job will run on a thing when the thing is added
	// to a target group, even after the job was completed by all things originally
	// in the group.
	TargetSelection *string `locationName:"targetSelection" type:"string" enum:"TargetSelection"`

	// A list of things and thing groups to which the job should be sent.
	//
	// Targets is a required field
	Targets []*string `locationName:"targets" min:"1" type:"list" required:"true"`

	// Specifies the amount of time each device has to finish its execution of the
	// job. The timer is started when the job execution status is set to IN_PROGRESS.
	// If the job execution status is not set to another terminal state before the
	// time expires, it will be automatically set to TIMED_OUT.
	TimeoutConfig *TimeoutConfig `locationName:"timeoutConfig" type:"structure"`
}

// String returns the string representation
func (s CreateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJobInput"}
	if s.DocumentSource != nil && len(*s.DocumentSource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentSource", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil && len(s.Targets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Targets", 1))
	}
	if s.AbortConfig != nil {
		if err := s.AbortConfig.Validate(); err != nil {
			invalidParams.AddNested("AbortConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.JobExecutionsRolloutConfig != nil {
		if err := s.JobExecutionsRolloutConfig.Validate(); err != nil {
			invalidParams.AddNested("JobExecutionsRolloutConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.PresignedUrlConfig != nil {
		if err := s.PresignedUrlConfig.Validate(); err != nil {
			invalidParams.AddNested("PresignedUrlConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAbortConfig sets the AbortConfig field's value.
func (s *CreateJobInput) SetAbortConfig(v *AbortConfig) *CreateJobInput {
	s.AbortConfig = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateJobInput) SetDescription(v string) *CreateJobInput {
	s.Description = &v
	return s
}

// SetDocument sets the Document field's value.
func (s *CreateJobInput) SetDocument(v string) *CreateJobInput {
	s.Document = &v
	return s
}

// SetDocumentSource sets the DocumentSource field's value.
func (s *CreateJobInput) SetDocumentSource(v string) *CreateJobInput {
	s.DocumentSource = &v
	return s
}

// SetJobExecutionsRolloutConfig sets the JobExecutionsRolloutConfig field's value.
func (s *CreateJobInput) SetJobExecutionsRolloutConfig(v *JobExecutionsRolloutConfig) *CreateJobInput {
	s.JobExecutionsRolloutConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CreateJobInput) SetJobId(v string) *CreateJobInput {
	s.JobId = &v
	return s
}

// SetPresignedUrlConfig sets the PresignedUrlConfig field's value.
func (s *CreateJobInput) SetPresignedUrlConfig(v *PresignedUrlConfig) *CreateJobInput {
	s.PresignedUrlConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateJobInput) SetTags(v []*Tag) *CreateJobInput {
	s.Tags = v
	return s
}

// SetTargetSelection sets the TargetSelection field's value.
func (s *CreateJobInput) SetTargetSelection(v string) *CreateJobInput {
	s.TargetSelection = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *CreateJobInput) SetTargets(v []*string) *CreateJobInput {
	s.Targets = v
	return s
}

// SetTimeoutConfig sets the TimeoutConfig field's value.
func (s *CreateJobInput) SetTimeoutConfig(v *TimeoutConfig) *CreateJobInput {
	s.TimeoutConfig = v
	return s
}

type CreateJobOutput struct {
	_ struct{} `type:"structure"`

	// The job description.
	Description *string `locationName:"description" type:"string"`

	// The job ARN.
	JobArn *string `locationName:"jobArn" type:"string"`

	// The unique identifier you assigned to this job.
	JobId *string `locationName:"jobId" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CreateJobOutput) SetDescription(v string) *CreateJobOutput {
	s.Description = &v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *CreateJobOutput) SetJobArn(v string) *CreateJobOutput {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CreateJobOutput) SetJobId(v string) *CreateJobOutput {
	s.JobId = &v
	return s
}

// The input for the CreateKeysAndCertificate operation.
type CreateKeysAndCertificateInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the certificate is active.
	SetAsActive *bool `location:"querystring" locationName:"setAsActive" type:"boolean"`
}

// String returns the string representation
func (s CreateKeysAndCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeysAndCertificateInput) GoString() string {
	return s.String()
}

// SetSetAsActive sets the SetAsActive field's value.
func (s *CreateKeysAndCertificateInput) SetSetAsActive(v bool) *CreateKeysAndCertificateInput {
	s.SetAsActive = &v
	return s
}

// The output of the CreateKeysAndCertificate operation.
type CreateKeysAndCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the certificate. AWS IoT issues a default subject name for the
	// certificate (for example, AWS IoT Certificate).
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The certificate data, in PEM format.
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string"`

	// The generated key pair.
	KeyPair *KeyPair `locationName:"keyPair" type:"structure"`
}

// String returns the string representation
func (s CreateKeysAndCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeysAndCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CreateKeysAndCertificateOutput) SetCertificateArn(v string) *CreateKeysAndCertificateOutput {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *CreateKeysAndCertificateOutput) SetCertificateId(v string) *CreateKeysAndCertificateOutput {
	s.CertificateId = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *CreateKeysAndCertificateOutput) SetCertificatePem(v string) *CreateKeysAndCertificateOutput {
	s.CertificatePem = &v
	return s
}

// SetKeyPair sets the KeyPair field's value.
func (s *CreateKeysAndCertificateOutput) SetKeyPair(v *KeyPair) *CreateKeysAndCertificateOutput {
	s.KeyPair = v
	return s
}

type CreateMitigationActionInput struct {
	_ struct{} `type:"structure"`

	// A friendly name for the action. Choose a friendly name that accurately describes
	// the action (for example, EnableLoggingAction).
	//
	// ActionName is a required field
	ActionName *string `location:"uri" locationName:"actionName" type:"string" required:"true"`

	// Defines the type of action and the parameters for that action.
	//
	// ActionParams is a required field
	ActionParams *MitigationActionParams `locationName:"actionParams" type:"structure" required:"true"`

	// The ARN of the IAM role that is used to apply the mitigation action.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// Metadata that can be used to manage the mitigation action.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateMitigationActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMitigationActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMitigationActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMitigationActionInput"}
	if s.ActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionName"))
	}
	if s.ActionName != nil && len(*s.ActionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionName", 1))
	}
	if s.ActionParams == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionParams"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.ActionParams != nil {
		if err := s.ActionParams.Validate(); err != nil {
			invalidParams.AddNested("ActionParams", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionName sets the ActionName field's value.
func (s *CreateMitigationActionInput) SetActionName(v string) *CreateMitigationActionInput {
	s.ActionName = &v
	return s
}

// SetActionParams sets the ActionParams field's value.
func (s *CreateMitigationActionInput) SetActionParams(v *MitigationActionParams) *CreateMitigationActionInput {
	s.ActionParams = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateMitigationActionInput) SetRoleArn(v string) *CreateMitigationActionInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMitigationActionInput) SetTags(v []*Tag) *CreateMitigationActionInput {
	s.Tags = v
	return s
}

type CreateMitigationActionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN for the new mitigation action.
	ActionArn *string `locationName:"actionArn" type:"string"`

	// A unique identifier for the new mitigation action.
	ActionId *string `locationName:"actionId" type:"string"`
}

// String returns the string representation
func (s CreateMitigationActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMitigationActionOutput) GoString() string {
	return s.String()
}

// SetActionArn sets the ActionArn field's value.
func (s *CreateMitigationActionOutput) SetActionArn(v string) *CreateMitigationActionOutput {
	s.ActionArn = &v
	return s
}

// SetActionId sets the ActionId field's value.
func (s *CreateMitigationActionOutput) SetActionId(v string) *CreateMitigationActionOutput {
	s.ActionId = &v
	return s
}

type CreateOTAUpdateInput struct {
	_ struct{} `type:"structure"`

	// A list of additional OTA update parameters which are name-value pairs.
	AdditionalParameters map[string]*string `locationName:"additionalParameters" type:"map"`

	// Configuration for the rollout of OTA updates.
	AwsJobExecutionsRolloutConfig *AwsJobExecutionsRolloutConfig `locationName:"awsJobExecutionsRolloutConfig" type:"structure"`

	// Configuration information for pre-signed URLs.
	AwsJobPresignedUrlConfig *AwsJobPresignedUrlConfig `locationName:"awsJobPresignedUrlConfig" type:"structure"`

	// The description of the OTA update.
	Description *string `locationName:"description" type:"string"`

	// The files to be streamed by the OTA update.
	//
	// Files is a required field
	Files []*OTAUpdateFile `locationName:"files" min:"1" type:"list" required:"true"`

	// The ID of the OTA update to be created.
	//
	// OtaUpdateId is a required field
	OtaUpdateId *string `location:"uri" locationName:"otaUpdateId" min:"1" type:"string" required:"true"`

	// The protocol used to transfer the OTA update image. Valid values are [HTTP],
	// [MQTT], [HTTP, MQTT]. When both HTTP and MQTT are specified, the target device
	// can choose the protocol.
	Protocols []*string `locationName:"protocols" min:"1" type:"list"`

	// The IAM role that allows access to the AWS IoT Jobs service.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// Metadata which can be used to manage updates.
	Tags []*Tag `locationName:"tags" type:"list"`

	// Specifies whether the update will continue to run (CONTINUOUS), or will be
	// complete after all the things specified as targets have completed the update
	// (SNAPSHOT). If continuous, the update may also be run on a thing when a change
	// is detected in a target. For example, an update will run on a thing when
	// the thing is added to a target group, even after the update was completed
	// by all things originally in the group. Valid values: CONTINUOUS | SNAPSHOT.
	TargetSelection *string `locationName:"targetSelection" type:"string" enum:"TargetSelection"`

	// The targeted devices to receive OTA updates.
	//
	// Targets is a required field
	Targets []*string `locationName:"targets" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateOTAUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOTAUpdateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOTAUpdateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOTAUpdateInput"}
	if s.Files == nil {
		invalidParams.Add(request.NewErrParamRequired("Files"))
	}
	if s.Files != nil && len(s.Files) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Files", 1))
	}
	if s.OtaUpdateId == nil {
		invalidParams.Add(request.NewErrParamRequired("OtaUpdateId"))
	}
	if s.OtaUpdateId != nil && len(*s.OtaUpdateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OtaUpdateId", 1))
	}
	if s.Protocols != nil && len(s.Protocols) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Protocols", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil && len(s.Targets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Targets", 1))
	}
	if s.AwsJobExecutionsRolloutConfig != nil {
		if err := s.AwsJobExecutionsRolloutConfig.Validate(); err != nil {
			invalidParams.AddNested("AwsJobExecutionsRolloutConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Files != nil {
		for i, v := range s.Files {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Files", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalParameters sets the AdditionalParameters field's value.
func (s *CreateOTAUpdateInput) SetAdditionalParameters(v map[string]*string) *CreateOTAUpdateInput {
	s.AdditionalParameters = v
	return s
}

// SetAwsJobExecutionsRolloutConfig sets the AwsJobExecutionsRolloutConfig field's value.
func (s *CreateOTAUpdateInput) SetAwsJobExecutionsRolloutConfig(v *AwsJobExecutionsRolloutConfig) *CreateOTAUpdateInput {
	s.AwsJobExecutionsRolloutConfig = v
	return s
}

// SetAwsJobPresignedUrlConfig sets the AwsJobPresignedUrlConfig field's value.
func (s *CreateOTAUpdateInput) SetAwsJobPresignedUrlConfig(v *AwsJobPresignedUrlConfig) *CreateOTAUpdateInput {
	s.AwsJobPresignedUrlConfig = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateOTAUpdateInput) SetDescription(v string) *CreateOTAUpdateInput {
	s.Description = &v
	return s
}

// SetFiles sets the Files field's value.
func (s *CreateOTAUpdateInput) SetFiles(v []*OTAUpdateFile) *CreateOTAUpdateInput {
	s.Files = v
	return s
}

// SetOtaUpdateId sets the OtaUpdateId field's value.
func (s *CreateOTAUpdateInput) SetOtaUpdateId(v string) *CreateOTAUpdateInput {
	s.OtaUpdateId = &v
	return s
}

// SetProtocols sets the Protocols field's value.
func (s *CreateOTAUpdateInput) SetProtocols(v []*string) *CreateOTAUpdateInput {
	s.Protocols = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateOTAUpdateInput) SetRoleArn(v string) *CreateOTAUpdateInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateOTAUpdateInput) SetTags(v []*Tag) *CreateOTAUpdateInput {
	s.Tags = v
	return s
}

// SetTargetSelection sets the TargetSelection field's value.
func (s *CreateOTAUpdateInput) SetTargetSelection(v string) *CreateOTAUpdateInput {
	s.TargetSelection = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *CreateOTAUpdateInput) SetTargets(v []*string) *CreateOTAUpdateInput {
	s.Targets = v
	return s
}

type CreateOTAUpdateOutput struct {
	_ struct{} `type:"structure"`

	// The AWS IoT job ARN associated with the OTA update.
	AwsIotJobArn *string `locationName:"awsIotJobArn" type:"string"`

	// The AWS IoT job ID associated with the OTA update.
	AwsIotJobId *string `locationName:"awsIotJobId" type:"string"`

	// The OTA update ARN.
	OtaUpdateArn *string `locationName:"otaUpdateArn" type:"string"`

	// The OTA update ID.
	OtaUpdateId *string `locationName:"otaUpdateId" min:"1" type:"string"`

	// The OTA update status.
	OtaUpdateStatus *string `locationName:"otaUpdateStatus" type:"string" enum:"OTAUpdateStatus"`
}

// String returns the string representation
func (s CreateOTAUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOTAUpdateOutput) GoString() string {
	return s.String()
}

// SetAwsIotJobArn sets the AwsIotJobArn field's value.
func (s *CreateOTAUpdateOutput) SetAwsIotJobArn(v string) *CreateOTAUpdateOutput {
	s.AwsIotJobArn = &v
	return s
}

// SetAwsIotJobId sets the AwsIotJobId field's value.
func (s *CreateOTAUpdateOutput) SetAwsIotJobId(v string) *CreateOTAUpdateOutput {
	s.AwsIotJobId = &v
	return s
}

// SetOtaUpdateArn sets the OtaUpdateArn field's value.
func (s *CreateOTAUpdateOutput) SetOtaUpdateArn(v string) *CreateOTAUpdateOutput {
	s.OtaUpdateArn = &v
	return s
}

// SetOtaUpdateId sets the OtaUpdateId field's value.
func (s *CreateOTAUpdateOutput) SetOtaUpdateId(v string) *CreateOTAUpdateOutput {
	s.OtaUpdateId = &v
	return s
}

// SetOtaUpdateStatus sets the OtaUpdateStatus field's value.
func (s *CreateOTAUpdateOutput) SetOtaUpdateStatus(v string) *CreateOTAUpdateOutput {
	s.OtaUpdateStatus = &v
	return s
}

// The input for the CreatePolicy operation.
type CreatePolicyInput struct {
	_ struct{} `type:"structure"`

	// The JSON document that describes the policy. policyDocument must have a minimum
	// length of 1, with a maximum length of 2048, excluding whitespace.
	//
	// PolicyDocument is a required field
	PolicyDocument *string `locationName:"policyDocument" type:"string" required:"true"`

	// The policy name.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePolicyInput"}
	if s.PolicyDocument == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyDocument"))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *CreatePolicyInput) SetPolicyDocument(v string) *CreatePolicyInput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *CreatePolicyInput) SetPolicyName(v string) *CreatePolicyInput {
	s.PolicyName = &v
	return s
}

// The output from the CreatePolicy operation.
type CreatePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy ARN.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The JSON document that describes the policy.
	PolicyDocument *string `locationName:"policyDocument" type:"string"`

	// The policy name.
	PolicyName *string `locationName:"policyName" min:"1" type:"string"`

	// The policy version ID.
	PolicyVersionId *string `locationName:"policyVersionId" type:"string"`
}

// String returns the string representation
func (s CreatePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *CreatePolicyOutput) SetPolicyArn(v string) *CreatePolicyOutput {
	s.PolicyArn = &v
	return s
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *CreatePolicyOutput) SetPolicyDocument(v string) *CreatePolicyOutput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *CreatePolicyOutput) SetPolicyName(v string) *CreatePolicyOutput {
	s.PolicyName = &v
	return s
}

// SetPolicyVersionId sets the PolicyVersionId field's value.
func (s *CreatePolicyOutput) SetPolicyVersionId(v string) *CreatePolicyOutput {
	s.PolicyVersionId = &v
	return s
}

// The input for the CreatePolicyVersion operation.
type CreatePolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The JSON document that describes the policy. Minimum length of 1. Maximum
	// length of 2048, excluding whitespace.
	//
	// PolicyDocument is a required field
	PolicyDocument *string `locationName:"policyDocument" type:"string" required:"true"`

	// The policy name.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// Specifies whether the policy version is set as the default. When this parameter
	// is true, the new policy version becomes the operative version (that is, the
	// version that is in effect for the certificates to which the policy is attached).
	SetAsDefault *bool `location:"querystring" locationName:"setAsDefault" type:"boolean"`
}

// String returns the string representation
func (s CreatePolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePolicyVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePolicyVersionInput"}
	if s.PolicyDocument == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyDocument"))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *CreatePolicyVersionInput) SetPolicyDocument(v string) *CreatePolicyVersionInput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *CreatePolicyVersionInput) SetPolicyName(v string) *CreatePolicyVersionInput {
	s.PolicyName = &v
	return s
}

// SetSetAsDefault sets the SetAsDefault field's value.
func (s *CreatePolicyVersionInput) SetSetAsDefault(v bool) *CreatePolicyVersionInput {
	s.SetAsDefault = &v
	return s
}

// The output of the CreatePolicyVersion operation.
type CreatePolicyVersionOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the policy version is the default.
	IsDefaultVersion *bool `locationName:"isDefaultVersion" type:"boolean"`

	// The policy ARN.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The JSON document that describes the policy.
	PolicyDocument *string `locationName:"policyDocument" type:"string"`

	// The policy version ID.
	PolicyVersionId *string `locationName:"policyVersionId" type:"string"`
}

// String returns the string representation
func (s CreatePolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyVersionOutput) GoString() string {
	return s.String()
}

// SetIsDefaultVersion sets the IsDefaultVersion field's value.
func (s *CreatePolicyVersionOutput) SetIsDefaultVersion(v bool) *CreatePolicyVersionOutput {
	s.IsDefaultVersion = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *CreatePolicyVersionOutput) SetPolicyArn(v string) *CreatePolicyVersionOutput {
	s.PolicyArn = &v
	return s
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *CreatePolicyVersionOutput) SetPolicyDocument(v string) *CreatePolicyVersionOutput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyVersionId sets the PolicyVersionId field's value.
func (s *CreatePolicyVersionOutput) SetPolicyVersionId(v string) *CreatePolicyVersionOutput {
	s.PolicyVersionId = &v
	return s
}

type CreateProvisioningClaimInput struct {
	_ struct{} `type:"structure"`

	// The name of the provisioning template to use.
	//
	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateProvisioningClaimInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProvisioningClaimInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProvisioningClaimInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProvisioningClaimInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateProvisioningClaimInput) SetTemplateName(v string) *CreateProvisioningClaimInput {
	s.TemplateName = &v
	return s
}

type CreateProvisioningClaimOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The provisioning claim certificate.
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string"`

	// The provisioning claim expiration time.
	Expiration *time.Time `locationName:"expiration" type:"timestamp"`

	// The provisioning claim key pair.
	KeyPair *KeyPair `locationName:"keyPair" type:"structure"`
}

// String returns the string representation
func (s CreateProvisioningClaimOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProvisioningClaimOutput) GoString() string {
	return s.String()
}

// SetCertificateId sets the CertificateId field's value.
func (s *CreateProvisioningClaimOutput) SetCertificateId(v string) *CreateProvisioningClaimOutput {
	s.CertificateId = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *CreateProvisioningClaimOutput) SetCertificatePem(v string) *CreateProvisioningClaimOutput {
	s.CertificatePem = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *CreateProvisioningClaimOutput) SetExpiration(v time.Time) *CreateProvisioningClaimOutput {
	s.Expiration = &v
	return s
}

// SetKeyPair sets the KeyPair field's value.
func (s *CreateProvisioningClaimOutput) SetKeyPair(v *KeyPair) *CreateProvisioningClaimOutput {
	s.KeyPair = v
	return s
}

type CreateProvisioningTemplateInput struct {
	_ struct{} `type:"structure"`

	// The description of the fleet provisioning template.
	Description *string `locationName:"description" type:"string"`

	// True to enable the fleet provisioning template, otherwise false.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The role ARN for the role associated with the fleet provisioning template.
	// This IoT role grants permission to provision a device.
	//
	// ProvisioningRoleArn is a required field
	ProvisioningRoleArn *string `locationName:"provisioningRoleArn" min:"20" type:"string" required:"true"`

	// Metadata which can be used to manage the fleet provisioning template.
	//
	// For URI Request parameters use format: ...key1=value1&key2=value2...
	//
	// For the CLI command-line parameter use format: &&tags "key1=value1&key2=value2..."
	//
	// For the cli-input-json file use format: "tags": "key1=value1&key2=value2..."
	Tags []*Tag `locationName:"tags" type:"list"`

	// The JSON formatted contents of the fleet provisioning template.
	//
	// TemplateBody is a required field
	TemplateBody *string `locationName:"templateBody" type:"string" required:"true"`

	// The name of the fleet provisioning template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateProvisioningTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProvisioningTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProvisioningTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProvisioningTemplateInput"}
	if s.ProvisioningRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisioningRoleArn"))
	}
	if s.ProvisioningRoleArn != nil && len(*s.ProvisioningRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisioningRoleArn", 20))
	}
	if s.TemplateBody == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateBody"))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateProvisioningTemplateInput) SetDescription(v string) *CreateProvisioningTemplateInput {
	s.Description = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *CreateProvisioningTemplateInput) SetEnabled(v bool) *CreateProvisioningTemplateInput {
	s.Enabled = &v
	return s
}

// SetProvisioningRoleArn sets the ProvisioningRoleArn field's value.
func (s *CreateProvisioningTemplateInput) SetProvisioningRoleArn(v string) *CreateProvisioningTemplateInput {
	s.ProvisioningRoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProvisioningTemplateInput) SetTags(v []*Tag) *CreateProvisioningTemplateInput {
	s.Tags = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *CreateProvisioningTemplateInput) SetTemplateBody(v string) *CreateProvisioningTemplateInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateProvisioningTemplateInput) SetTemplateName(v string) *CreateProvisioningTemplateInput {
	s.TemplateName = &v
	return s
}

type CreateProvisioningTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The default version of the fleet provisioning template.
	DefaultVersionId *int64 `locationName:"defaultVersionId" type:"integer"`

	// The ARN that identifies the provisioning template.
	TemplateArn *string `locationName:"templateArn" type:"string"`

	// The name of the fleet provisioning template.
	TemplateName *string `locationName:"templateName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateProvisioningTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProvisioningTemplateOutput) GoString() string {
	return s.String()
}

// SetDefaultVersionId sets the DefaultVersionId field's value.
func (s *CreateProvisioningTemplateOutput) SetDefaultVersionId(v int64) *CreateProvisioningTemplateOutput {
	s.DefaultVersionId = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *CreateProvisioningTemplateOutput) SetTemplateArn(v string) *CreateProvisioningTemplateOutput {
	s.TemplateArn = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateProvisioningTemplateOutput) SetTemplateName(v string) *CreateProvisioningTemplateOutput {
	s.TemplateName = &v
	return s
}

type CreateProvisioningTemplateVersionInput struct {
	_ struct{} `type:"structure"`

	// Sets a fleet provision template version as the default version.
	SetAsDefault *bool `location:"querystring" locationName:"setAsDefault" type:"boolean"`

	// The JSON formatted contents of the fleet provisioning template.
	//
	// TemplateBody is a required field
	TemplateBody *string `locationName:"templateBody" type:"string" required:"true"`

	// The name of the fleet provisioning template.
	//
	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateProvisioningTemplateVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProvisioningTemplateVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProvisioningTemplateVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProvisioningTemplateVersionInput"}
	if s.TemplateBody == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateBody"))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSetAsDefault sets the SetAsDefault field's value.
func (s *CreateProvisioningTemplateVersionInput) SetSetAsDefault(v bool) *CreateProvisioningTemplateVersionInput {
	s.SetAsDefault = &v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *CreateProvisioningTemplateVersionInput) SetTemplateBody(v string) *CreateProvisioningTemplateVersionInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateProvisioningTemplateVersionInput) SetTemplateName(v string) *CreateProvisioningTemplateVersionInput {
	s.TemplateName = &v
	return s
}

type CreateProvisioningTemplateVersionOutput struct {
	_ struct{} `type:"structure"`

	// True if the fleet provisioning template version is the default version, otherwise
	// false.
	IsDefaultVersion *bool `locationName:"isDefaultVersion" type:"boolean"`

	// The ARN that identifies the provisioning template.
	TemplateArn *string `locationName:"templateArn" type:"string"`

	// The name of the fleet provisioning template.
	TemplateName *string `locationName:"templateName" min:"1" type:"string"`

	// The version of the fleet provisioning template.
	VersionId *int64 `locationName:"versionId" type:"integer"`
}

// String returns the string representation
func (s CreateProvisioningTemplateVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProvisioningTemplateVersionOutput) GoString() string {
	return s.String()
}

// SetIsDefaultVersion sets the IsDefaultVersion field's value.
func (s *CreateProvisioningTemplateVersionOutput) SetIsDefaultVersion(v bool) *CreateProvisioningTemplateVersionOutput {
	s.IsDefaultVersion = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *CreateProvisioningTemplateVersionOutput) SetTemplateArn(v string) *CreateProvisioningTemplateVersionOutput {
	s.TemplateArn = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateProvisioningTemplateVersionOutput) SetTemplateName(v string) *CreateProvisioningTemplateVersionOutput {
	s.TemplateName = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *CreateProvisioningTemplateVersionOutput) SetVersionId(v int64) *CreateProvisioningTemplateVersionOutput {
	s.VersionId = &v
	return s
}

type CreateRoleAliasInput struct {
	_ struct{} `type:"structure"`

	// How long (in seconds) the credentials will be valid.
	CredentialDurationSeconds *int64 `locationName:"credentialDurationSeconds" min:"900" type:"integer"`

	// The role alias that points to a role ARN. This allows you to change the role
	// without having to update the device.
	//
	// RoleAlias is a required field
	RoleAlias *string `location:"uri" locationName:"roleAlias" min:"1" type:"string" required:"true"`

	// The role ARN.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRoleAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRoleAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRoleAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRoleAliasInput"}
	if s.CredentialDurationSeconds != nil && *s.CredentialDurationSeconds < 900 {
		invalidParams.Add(request.NewErrParamMinValue("CredentialDurationSeconds", 900))
	}
	if s.RoleAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleAlias"))
	}
	if s.RoleAlias != nil && len(*s.RoleAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleAlias", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCredentialDurationSeconds sets the CredentialDurationSeconds field's value.
func (s *CreateRoleAliasInput) SetCredentialDurationSeconds(v int64) *CreateRoleAliasInput {
	s.CredentialDurationSeconds = &v
	return s
}

// SetRoleAlias sets the RoleAlias field's value.
func (s *CreateRoleAliasInput) SetRoleAlias(v string) *CreateRoleAliasInput {
	s.RoleAlias = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateRoleAliasInput) SetRoleArn(v string) *CreateRoleAliasInput {
	s.RoleArn = &v
	return s
}

type CreateRoleAliasOutput struct {
	_ struct{} `type:"structure"`

	// The role alias.
	RoleAlias *string `locationName:"roleAlias" min:"1" type:"string"`

	// The role alias ARN.
	RoleAliasArn *string `locationName:"roleAliasArn" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateRoleAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRoleAliasOutput) GoString() string {
	return s.String()
}

// SetRoleAlias sets the RoleAlias field's value.
func (s *CreateRoleAliasOutput) SetRoleAlias(v string) *CreateRoleAliasOutput {
	s.RoleAlias = &v
	return s
}

// SetRoleAliasArn sets the RoleAliasArn field's value.
func (s *CreateRoleAliasOutput) SetRoleAliasArn(v string) *CreateRoleAliasOutput {
	s.RoleAliasArn = &v
	return s
}

type CreateScheduledAuditInput struct {
	_ struct{} `type:"structure"`

	// The day of the month on which the scheduled audit takes place. Can be "1"
	// through "31" or "LAST". This field is required if the "frequency" parameter
	// is set to "MONTHLY". If days 29-31 are specified, and the month does not
	// have that many days, the audit takes place on the "LAST" day of the month.
	DayOfMonth *string `locationName:"dayOfMonth" type:"string"`

	// The day of the week on which the scheduled audit takes place. Can be one
	// of "SUN", "MON", "TUE", "WED", "THU", "FRI", or "SAT". This field is required
	// if the "frequency" parameter is set to "WEEKLY" or "BIWEEKLY".
	DayOfWeek *string `locationName:"dayOfWeek" type:"string" enum:"DayOfWeek"`

	// How often the scheduled audit takes place. Can be one of "DAILY", "WEEKLY",
	// "BIWEEKLY" or "MONTHLY". The start time of each audit is determined by the
	// system.
	//
	// Frequency is a required field
	Frequency *string `locationName:"frequency" type:"string" required:"true" enum:"AuditFrequency"`

	// The name you want to give to the scheduled audit. (Max. 128 chars)
	//
	// ScheduledAuditName is a required field
	ScheduledAuditName *string `location:"uri" locationName:"scheduledAuditName" min:"1" type:"string" required:"true"`

	// Metadata that can be used to manage the scheduled audit.
	Tags []*Tag `locationName:"tags" type:"list"`

	// Which checks are performed during the scheduled audit. Checks must be enabled
	// for your account. (Use DescribeAccountAuditConfiguration to see the list
	// of all checks, including those that are enabled or use UpdateAccountAuditConfiguration
	// to select which checks are enabled.)
	//
	// TargetCheckNames is a required field
	TargetCheckNames []*string `locationName:"targetCheckNames" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateScheduledAuditInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateScheduledAuditInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateScheduledAuditInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateScheduledAuditInput"}
	if s.Frequency == nil {
		invalidParams.Add(request.NewErrParamRequired("Frequency"))
	}
	if s.ScheduledAuditName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledAuditName"))
	}
	if s.ScheduledAuditName != nil && len(*s.ScheduledAuditName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledAuditName", 1))
	}
	if s.TargetCheckNames == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetCheckNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDayOfMonth sets the DayOfMonth field's value.
func (s *CreateScheduledAuditInput) SetDayOfMonth(v string) *CreateScheduledAuditInput {
	s.DayOfMonth = &v
	return s
}

// SetDayOfWeek sets the DayOfWeek field's value.
func (s *CreateScheduledAuditInput) SetDayOfWeek(v string) *CreateScheduledAuditInput {
	s.DayOfWeek = &v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *CreateScheduledAuditInput) SetFrequency(v string) *CreateScheduledAuditInput {
	s.Frequency = &v
	return s
}

// SetScheduledAuditName sets the ScheduledAuditName field's value.
func (s *CreateScheduledAuditInput) SetScheduledAuditName(v string) *CreateScheduledAuditInput {
	s.ScheduledAuditName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateScheduledAuditInput) SetTags(v []*Tag) *CreateScheduledAuditInput {
	s.Tags = v
	return s
}

// SetTargetCheckNames sets the TargetCheckNames field's value.
func (s *CreateScheduledAuditInput) SetTargetCheckNames(v []*string) *CreateScheduledAuditInput {
	s.TargetCheckNames = v
	return s
}

type CreateScheduledAuditOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the scheduled audit.
	ScheduledAuditArn *string `locationName:"scheduledAuditArn" type:"string"`
}

// String returns the string representation
func (s CreateScheduledAuditOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateScheduledAuditOutput) GoString() string {
	return s.String()
}

// SetScheduledAuditArn sets the ScheduledAuditArn field's value.
func (s *CreateScheduledAuditOutput) SetScheduledAuditArn(v string) *CreateScheduledAuditOutput {
	s.ScheduledAuditArn = &v
	return s
}

type CreateSecurityProfileInput struct {
	_ struct{} `type:"structure"`

	// A list of metrics whose data is retained (stored). By default, data is retained
	// for any metric used in the profile's behaviors, but it is also retained for
	// any metric specified here.
	//
	// Note: This API field is deprecated. Please use CreateSecurityProfileRequest$additionalMetricsToRetainV2
	// instead.
	//
	// Deprecated: Use additionalMetricsToRetainV2.
	AdditionalMetricsToRetain []*string `locationName:"additionalMetricsToRetain" deprecated:"true" type:"list"`

	// A list of metrics whose data is retained (stored). By default, data is retained
	// for any metric used in the profile's behaviors, but it is also retained for
	// any metric specified here.
	AdditionalMetricsToRetainV2 []*MetricToRetain `locationName:"additionalMetricsToRetainV2" type:"list"`

	// Specifies the destinations to which alerts are sent. (Alerts are always sent
	// to the console.) Alerts are generated when a device (thing) violates a behavior.
	AlertTargets map[string]*AlertTarget `locationName:"alertTargets" type:"map"`

	// Specifies the behaviors that, when violated by a device (thing), cause an
	// alert.
	Behaviors []*Behavior `locationName:"behaviors" type:"list"`

	// A description of the security profile.
	SecurityProfileDescription *string `locationName:"securityProfileDescription" type:"string"`

	// The name you are giving to the security profile.
	//
	// SecurityProfileName is a required field
	SecurityProfileName *string `location:"uri" locationName:"securityProfileName" min:"1" type:"string" required:"true"`

	// Metadata that can be used to manage the security profile.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateSecurityProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSecurityProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSecurityProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSecurityProfileInput"}
	if s.SecurityProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityProfileName"))
	}
	if s.SecurityProfileName != nil && len(*s.SecurityProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityProfileName", 1))
	}
	if s.AdditionalMetricsToRetainV2 != nil {
		for i, v := range s.AdditionalMetricsToRetainV2 {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AdditionalMetricsToRetainV2", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.AlertTargets != nil {
		for i, v := range s.AlertTargets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AlertTargets", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Behaviors != nil {
		for i, v := range s.Behaviors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Behaviors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalMetricsToRetain sets the AdditionalMetricsToRetain field's value.
func (s *CreateSecurityProfileInput) SetAdditionalMetricsToRetain(v []*string) *CreateSecurityProfileInput {
	s.AdditionalMetricsToRetain = v
	return s
}

// SetAdditionalMetricsToRetainV2 sets the AdditionalMetricsToRetainV2 field's value.
func (s *CreateSecurityProfileInput) SetAdditionalMetricsToRetainV2(v []*MetricToRetain) *CreateSecurityProfileInput {
	s.AdditionalMetricsToRetainV2 = v
	return s
}

// SetAlertTargets sets the AlertTargets field's value.
func (s *CreateSecurityProfileInput) SetAlertTargets(v map[string]*AlertTarget) *CreateSecurityProfileInput {
	s.AlertTargets = v
	return s
}

// SetBehaviors sets the Behaviors field's value.
func (s *CreateSecurityProfileInput) SetBehaviors(v []*Behavior) *CreateSecurityProfileInput {
	s.Behaviors = v
	return s
}

// SetSecurityProfileDescription sets the SecurityProfileDescription field's value.
func (s *CreateSecurityProfileInput) SetSecurityProfileDescription(v string) *CreateSecurityProfileInput {
	s.SecurityProfileDescription = &v
	return s
}

// SetSecurityProfileName sets the SecurityProfileName field's value.
func (s *CreateSecurityProfileInput) SetSecurityProfileName(v string) *CreateSecurityProfileInput {
	s.SecurityProfileName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSecurityProfileInput) SetTags(v []*Tag) *CreateSecurityProfileInput {
	s.Tags = v
	return s
}

type CreateSecurityProfileOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the security profile.
	SecurityProfileArn *string `locationName:"securityProfileArn" type:"string"`

	// The name you gave to the security profile.
	SecurityProfileName *string `locationName:"securityProfileName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateSecurityProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSecurityProfileOutput) GoString() string {
	return s.String()
}

// SetSecurityProfileArn sets the SecurityProfileArn field's value.
func (s *CreateSecurityProfileOutput) SetSecurityProfileArn(v string) *CreateSecurityProfileOutput {
	s.SecurityProfileArn = &v
	return s
}

// SetSecurityProfileName sets the SecurityProfileName field's value.
func (s *CreateSecurityProfileOutput) SetSecurityProfileName(v string) *CreateSecurityProfileOutput {
	s.SecurityProfileName = &v
	return s
}

type CreateStreamInput struct {
	_ struct{} `type:"structure"`

	// A description of the stream.
	Description *string `locationName:"description" type:"string"`

	// The files to stream.
	//
	// Files is a required field
	Files []*StreamFile `locationName:"files" min:"1" type:"list" required:"true"`

	// An IAM role that allows the IoT service principal assumes to access your
	// S3 files.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The stream ID.
	//
	// StreamId is a required field
	StreamId *string `location:"uri" locationName:"streamId" min:"1" type:"string" required:"true"`

	// Metadata which can be used to manage streams.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStreamInput"}
	if s.Files == nil {
		invalidParams.Add(request.NewErrParamRequired("Files"))
	}
	if s.Files != nil && len(s.Files) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Files", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.StreamId == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamId"))
	}
	if s.StreamId != nil && len(*s.StreamId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamId", 1))
	}
	if s.Files != nil {
		for i, v := range s.Files {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Files", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateStreamInput) SetDescription(v string) *CreateStreamInput {
	s.Description = &v
	return s
}

// SetFiles sets the Files field's value.
func (s *CreateStreamInput) SetFiles(v []*StreamFile) *CreateStreamInput {
	s.Files = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateStreamInput) SetRoleArn(v string) *CreateStreamInput {
	s.RoleArn = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *CreateStreamInput) SetStreamId(v string) *CreateStreamInput {
	s.StreamId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStreamInput) SetTags(v []*Tag) *CreateStreamInput {
	s.Tags = v
	return s
}

type CreateStreamOutput struct {
	_ struct{} `type:"structure"`

	// A description of the stream.
	Description *string `locationName:"description" type:"string"`

	// The stream ARN.
	StreamArn *string `locationName:"streamArn" type:"string"`

	// The stream ID.
	StreamId *string `locationName:"streamId" min:"1" type:"string"`

	// The version of the stream.
	StreamVersion *int64 `locationName:"streamVersion" type:"integer"`
}

// String returns the string representation
func (s CreateStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CreateStreamOutput) SetDescription(v string) *CreateStreamOutput {
	s.Description = &v
	return s
}

// SetStreamArn sets the StreamArn field's value.
func (s *CreateStreamOutput) SetStreamArn(v string) *CreateStreamOutput {
	s.StreamArn = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *CreateStreamOutput) SetStreamId(v string) *CreateStreamOutput {
	s.StreamId = &v
	return s
}

// SetStreamVersion sets the StreamVersion field's value.
func (s *CreateStreamOutput) SetStreamVersion(v int64) *CreateStreamOutput {
	s.StreamVersion = &v
	return s
}

type CreateThingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the parent thing group.
	ParentGroupName *string `locationName:"parentGroupName" min:"1" type:"string"`

	// Metadata which can be used to manage the thing group.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The thing group name to create.
	//
	// ThingGroupName is a required field
	ThingGroupName *string `location:"uri" locationName:"thingGroupName" min:"1" type:"string" required:"true"`

	// The thing group properties.
	ThingGroupProperties *ThingGroupProperties `locationName:"thingGroupProperties" type:"structure"`
}

// String returns the string representation
func (s CreateThingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateThingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateThingGroupInput"}
	if s.ParentGroupName != nil && len(*s.ParentGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParentGroupName", 1))
	}
	if s.ThingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingGroupName"))
	}
	if s.ThingGroupName != nil && len(*s.ThingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParentGroupName sets the ParentGroupName field's value.
func (s *CreateThingGroupInput) SetParentGroupName(v string) *CreateThingGroupInput {
	s.ParentGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateThingGroupInput) SetTags(v []*Tag) *CreateThingGroupInput {
	s.Tags = v
	return s
}

// SetThingGroupName sets the ThingGroupName field's value.
func (s *CreateThingGroupInput) SetThingGroupName(v string) *CreateThingGroupInput {
	s.ThingGroupName = &v
	return s
}

// SetThingGroupProperties sets the ThingGroupProperties field's value.
func (s *CreateThingGroupInput) SetThingGroupProperties(v *ThingGroupProperties) *CreateThingGroupInput {
	s.ThingGroupProperties = v
	return s
}

type CreateThingGroupOutput struct {
	_ struct{} `type:"structure"`

	// The thing group ARN.
	ThingGroupArn *string `locationName:"thingGroupArn" type:"string"`

	// The thing group ID.
	ThingGroupId *string `locationName:"thingGroupId" min:"1" type:"string"`

	// The thing group name.
	ThingGroupName *string `locationName:"thingGroupName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateThingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThingGroupOutput) GoString() string {
	return s.String()
}

// SetThingGroupArn sets the ThingGroupArn field's value.
func (s *CreateThingGroupOutput) SetThingGroupArn(v string) *CreateThingGroupOutput {
	s.ThingGroupArn = &v
	return s
}

// SetThingGroupId sets the ThingGroupId field's value.
func (s *CreateThingGroupOutput) SetThingGroupId(v string) *CreateThingGroupOutput {
	s.ThingGroupId = &v
	return s
}

// SetThingGroupName sets the ThingGroupName field's value.
func (s *CreateThingGroupOutput) SetThingGroupName(v string) *CreateThingGroupOutput {
	s.ThingGroupName = &v
	return s
}

// The input for the CreateThing operation.
type CreateThingInput struct {
	_ struct{} `type:"structure"`

	// The attribute payload, which consists of up to three name/value pairs in
	// a JSON document. For example:
	//
	// {\"attributes\":{\"string1\":\"string2\"}}
	AttributePayload *AttributePayload `locationName:"attributePayload" type:"structure"`

	// The name of the billing group the thing will be added to.
	BillingGroupName *string `locationName:"billingGroupName" min:"1" type:"string"`

	// The name of the thing to create.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`

	// The name of the thing type associated with the new thing.
	ThingTypeName *string `locationName:"thingTypeName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateThingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateThingInput"}
	if s.BillingGroupName != nil && len(*s.BillingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BillingGroupName", 1))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}
	if s.ThingTypeName != nil && len(*s.ThingTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributePayload sets the AttributePayload field's value.
func (s *CreateThingInput) SetAttributePayload(v *AttributePayload) *CreateThingInput {
	s.AttributePayload = v
	return s
}

// SetBillingGroupName sets the BillingGroupName field's value.
func (s *CreateThingInput) SetBillingGroupName(v string) *CreateThingInput {
	s.BillingGroupName = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *CreateThingInput) SetThingName(v string) *CreateThingInput {
	s.ThingName = &v
	return s
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *CreateThingInput) SetThingTypeName(v string) *CreateThingInput {
	s.ThingTypeName = &v
	return s
}

// The output of the CreateThing operation.
type CreateThingOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the new thing.
	ThingArn *string `locationName:"thingArn" type:"string"`

	// The thing ID.
	ThingId *string `locationName:"thingId" type:"string"`

	// The name of the new thing.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThingOutput) GoString() string {
	return s.String()
}

// SetThingArn sets the ThingArn field's value.
func (s *CreateThingOutput) SetThingArn(v string) *CreateThingOutput {
	s.ThingArn = &v
	return s
}

// SetThingId sets the ThingId field's value.
func (s *CreateThingOutput) SetThingId(v string) *CreateThingOutput {
	s.ThingId = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *CreateThingOutput) SetThingName(v string) *CreateThingOutput {
	s.ThingName = &v
	return s
}

// The input for the CreateThingType operation.
type CreateThingTypeInput struct {
	_ struct{} `type:"structure"`

	// Metadata which can be used to manage the thing type.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The name of the thing type.
	//
	// ThingTypeName is a required field
	ThingTypeName *string `location:"uri" locationName:"thingTypeName" min:"1" type:"string" required:"true"`

	// The ThingTypeProperties for the thing type to create. It contains information
	// about the new thing type including a description, and a list of searchable
	// thing attribute names.
	ThingTypeProperties *ThingTypeProperties `locationName:"thingTypeProperties" type:"structure"`
}

// String returns the string representation
func (s CreateThingTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThingTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateThingTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateThingTypeInput"}
	if s.ThingTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingTypeName"))
	}
	if s.ThingTypeName != nil && len(*s.ThingTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTags sets the Tags field's value.
func (s *CreateThingTypeInput) SetTags(v []*Tag) *CreateThingTypeInput {
	s.Tags = v
	return s
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *CreateThingTypeInput) SetThingTypeName(v string) *CreateThingTypeInput {
	s.ThingTypeName = &v
	return s
}

// SetThingTypeProperties sets the ThingTypeProperties field's value.
func (s *CreateThingTypeInput) SetThingTypeProperties(v *ThingTypeProperties) *CreateThingTypeInput {
	s.ThingTypeProperties = v
	return s
}

// The output of the CreateThingType operation.
type CreateThingTypeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the thing type.
	ThingTypeArn *string `locationName:"thingTypeArn" type:"string"`

	// The thing type ID.
	ThingTypeId *string `locationName:"thingTypeId" type:"string"`

	// The name of the thing type.
	ThingTypeName *string `locationName:"thingTypeName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateThingTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThingTypeOutput) GoString() string {
	return s.String()
}

// SetThingTypeArn sets the ThingTypeArn field's value.
func (s *CreateThingTypeOutput) SetThingTypeArn(v string) *CreateThingTypeOutput {
	s.ThingTypeArn = &v
	return s
}

// SetThingTypeId sets the ThingTypeId field's value.
func (s *CreateThingTypeOutput) SetThingTypeId(v string) *CreateThingTypeOutput {
	s.ThingTypeId = &v
	return s
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *CreateThingTypeOutput) SetThingTypeName(v string) *CreateThingTypeOutput {
	s.ThingTypeName = &v
	return s
}

type CreateTopicRuleDestinationInput struct {
	_ struct{} `type:"structure"`

	// The topic rule destination configuration.
	//
	// DestinationConfiguration is a required field
	DestinationConfiguration *TopicRuleDestinationConfiguration `locationName:"destinationConfiguration" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTopicRuleDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTopicRuleDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTopicRuleDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTopicRuleDestinationInput"}
	if s.DestinationConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationConfiguration"))
	}
	if s.DestinationConfiguration != nil {
		if err := s.DestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationConfiguration sets the DestinationConfiguration field's value.
func (s *CreateTopicRuleDestinationInput) SetDestinationConfiguration(v *TopicRuleDestinationConfiguration) *CreateTopicRuleDestinationInput {
	s.DestinationConfiguration = v
	return s
}

type CreateTopicRuleDestinationOutput struct {
	_ struct{} `type:"structure"`

	// The topic rule destination.
	TopicRuleDestination *TopicRuleDestination `locationName:"topicRuleDestination" type:"structure"`
}

// String returns the string representation
func (s CreateTopicRuleDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTopicRuleDestinationOutput) GoString() string {
	return s.String()
}

// SetTopicRuleDestination sets the TopicRuleDestination field's value.
func (s *CreateTopicRuleDestinationOutput) SetTopicRuleDestination(v *TopicRuleDestination) *CreateTopicRuleDestinationOutput {
	s.TopicRuleDestination = v
	return s
}

// The input for the CreateTopicRule operation.
type CreateTopicRuleInput struct {
	_ struct{} `type:"structure" payload:"TopicRulePayload"`

	// The name of the rule.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`

	// Metadata which can be used to manage the topic rule.
	//
	// For URI Request parameters use format: ...key1=value1&key2=value2...
	//
	// For the CLI command-line parameter use format: --tags "key1=value1&key2=value2..."
	//
	// For the cli-input-json file use format: "tags": "key1=value1&key2=value2..."
	Tags *string `location:"header" locationName:"x-amz-tagging" type:"string"`

	// The rule payload.
	//
	// TopicRulePayload is a required field
	TopicRulePayload *TopicRulePayload `locationName:"topicRulePayload" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTopicRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTopicRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTopicRuleInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}
	if s.TopicRulePayload == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicRulePayload"))
	}
	if s.TopicRulePayload != nil {
		if err := s.TopicRulePayload.Validate(); err != nil {
			invalidParams.AddNested("TopicRulePayload", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleName sets the RuleName field's value.
func (s *CreateTopicRuleInput) SetRuleName(v string) *CreateTopicRuleInput {
	s.RuleName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTopicRuleInput) SetTags(v string) *CreateTopicRuleInput {
	s.Tags = &v
	return s
}

// SetTopicRulePayload sets the TopicRulePayload field's value.
func (s *CreateTopicRuleInput) SetTopicRulePayload(v *TopicRulePayload) *CreateTopicRuleInput {
	s.TopicRulePayload = v
	return s
}

type CreateTopicRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTopicRuleOutput) GoString() string {
	return s.String()
}

// Describes a custom method used to code sign a file.
type CustomCodeSigning struct {
	_ struct{} `type:"structure"`

	// The certificate chain.
	CertificateChain *CodeSigningCertificateChain `locationName:"certificateChain" type:"structure"`

	// The hash algorithm used to code sign the file.
	HashAlgorithm *string `locationName:"hashAlgorithm" type:"string"`

	// The signature for the file.
	Signature *CodeSigningSignature `locationName:"signature" type:"structure"`

	// The signature algorithm used to code sign the file.
	SignatureAlgorithm *string `locationName:"signatureAlgorithm" type:"string"`
}

// String returns the string representation
func (s CustomCodeSigning) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomCodeSigning) GoString() string {
	return s.String()
}

// SetCertificateChain sets the CertificateChain field's value.
func (s *CustomCodeSigning) SetCertificateChain(v *CodeSigningCertificateChain) *CustomCodeSigning {
	s.CertificateChain = v
	return s
}

// SetHashAlgorithm sets the HashAlgorithm field's value.
func (s *CustomCodeSigning) SetHashAlgorithm(v string) *CustomCodeSigning {
	s.HashAlgorithm = &v
	return s
}

// SetSignature sets the Signature field's value.
func (s *CustomCodeSigning) SetSignature(v *CodeSigningSignature) *CustomCodeSigning {
	s.Signature = v
	return s
}

// SetSignatureAlgorithm sets the SignatureAlgorithm field's value.
func (s *CustomCodeSigning) SetSignatureAlgorithm(v string) *CustomCodeSigning {
	s.SignatureAlgorithm = &v
	return s
}

type DeleteAccountAuditConfigurationInput struct {
	_ struct{} `type:"structure"`

	// If true, all scheduled audits are deleted.
	DeleteScheduledAudits *bool `location:"querystring" locationName:"deleteScheduledAudits" type:"boolean"`
}

// String returns the string representation
func (s DeleteAccountAuditConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccountAuditConfigurationInput) GoString() string {
	return s.String()
}

// SetDeleteScheduledAudits sets the DeleteScheduledAudits field's value.
func (s *DeleteAccountAuditConfigurationInput) SetDeleteScheduledAudits(v bool) *DeleteAccountAuditConfigurationInput {
	s.DeleteScheduledAudits = &v
	return s
}

type DeleteAccountAuditConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccountAuditConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccountAuditConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteAuthorizerInput struct {
	_ struct{} `type:"structure"`

	// The name of the authorizer to delete.
	//
	// AuthorizerName is a required field
	AuthorizerName *string `location:"uri" locationName:"authorizerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAuthorizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAuthorizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAuthorizerInput"}
	if s.AuthorizerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizerName"))
	}
	if s.AuthorizerName != nil && len(*s.AuthorizerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizerName sets the AuthorizerName field's value.
func (s *DeleteAuthorizerInput) SetAuthorizerName(v string) *DeleteAuthorizerInput {
	s.AuthorizerName = &v
	return s
}

type DeleteAuthorizerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAuthorizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAuthorizerOutput) GoString() string {
	return s.String()
}

type DeleteBillingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the billing group.
	//
	// BillingGroupName is a required field
	BillingGroupName *string `location:"uri" locationName:"billingGroupName" min:"1" type:"string" required:"true"`

	// The expected version of the billing group. If the version of the billing
	// group does not match the expected version specified in the request, the DeleteBillingGroup
	// request is rejected with a VersionConflictException.
	ExpectedVersion *int64 `location:"querystring" locationName:"expectedVersion" type:"long"`
}

// String returns the string representation
func (s DeleteBillingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBillingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBillingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBillingGroupInput"}
	if s.BillingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("BillingGroupName"))
	}
	if s.BillingGroupName != nil && len(*s.BillingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BillingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingGroupName sets the BillingGroupName field's value.
func (s *DeleteBillingGroupInput) SetBillingGroupName(v string) *DeleteBillingGroupInput {
	s.BillingGroupName = &v
	return s
}

// SetExpectedVersion sets the ExpectedVersion field's value.
func (s *DeleteBillingGroupInput) SetExpectedVersion(v int64) *DeleteBillingGroupInput {
	s.ExpectedVersion = &v
	return s
}

type DeleteBillingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBillingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBillingGroupOutput) GoString() string {
	return s.String()
}

// Input for the DeleteCACertificate operation.
type DeleteCACertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate to delete. (The last part of the certificate ARN
	// contains the certificate ID.)
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"caCertificateId" min:"64" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCACertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCACertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCACertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCACertificateInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *DeleteCACertificateInput) SetCertificateId(v string) *DeleteCACertificateInput {
	s.CertificateId = &v
	return s
}

// The output for the DeleteCACertificate operation.
type DeleteCACertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCACertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCACertificateOutput) GoString() string {
	return s.String()
}

// The input for the DeleteCertificate operation.
type DeleteCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate. (The last part of the certificate ARN contains
	// the certificate ID.)
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`

	// Forces the deletion of a certificate if it is inactive and is not attached
	// to an IoT thing.
	ForceDelete *bool `location:"querystring" locationName:"forceDelete" type:"boolean"`
}

// String returns the string representation
func (s DeleteCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCertificateInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *DeleteCertificateInput) SetCertificateId(v string) *DeleteCertificateInput {
	s.CertificateId = &v
	return s
}

// SetForceDelete sets the ForceDelete field's value.
func (s *DeleteCertificateInput) SetForceDelete(v bool) *DeleteCertificateInput {
	s.ForceDelete = &v
	return s
}

type DeleteCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateOutput) GoString() string {
	return s.String()
}

// You can't delete the resource because it is attached to one or more resources.
type DeleteConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s DeleteConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConflictException) GoString() string {
	return s.String()
}

func newErrorDeleteConflictException(v protocol.ResponseMetadata) error {
	return &DeleteConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DeleteConflictException) Code() string {
	return "DeleteConflictException"
}

// Message returns the exception's message.
func (s *DeleteConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DeleteConflictException) OrigErr() error {
	return nil
}

func (s *DeleteConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DeleteConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DeleteConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeleteDimensionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the dimension that you want to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDimensionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDimensionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDimensionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDimensionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteDimensionInput) SetName(v string) *DeleteDimensionInput {
	s.Name = &v
	return s
}

type DeleteDimensionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDimensionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDimensionOutput) GoString() string {
	return s.String()
}

type DeleteDomainConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain configuration to be deleted.
	//
	// DomainConfigurationName is a required field
	DomainConfigurationName *string `location:"uri" locationName:"domainConfigurationName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDomainConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainConfigurationInput"}
	if s.DomainConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainConfigurationName"))
	}
	if s.DomainConfigurationName != nil && len(*s.DomainConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainConfigurationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainConfigurationName sets the DomainConfigurationName field's value.
func (s *DeleteDomainConfigurationInput) SetDomainConfigurationName(v string) *DeleteDomainConfigurationInput {
	s.DomainConfigurationName = &v
	return s
}

type DeleteDomainConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDomainConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteDynamicThingGroupInput struct {
	_ struct{} `type:"structure"`

	// The expected version of the dynamic thing group to delete.
	ExpectedVersion *int64 `location:"querystring" locationName:"expectedVersion" type:"long"`

	// The name of the dynamic thing group to delete.
	//
	// ThingGroupName is a required field
	ThingGroupName *string `location:"uri" locationName:"thingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDynamicThingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDynamicThingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDynamicThingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDynamicThingGroupInput"}
	if s.ThingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingGroupName"))
	}
	if s.ThingGroupName != nil && len(*s.ThingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpectedVersion sets the ExpectedVersion field's value.
func (s *DeleteDynamicThingGroupInput) SetExpectedVersion(v int64) *DeleteDynamicThingGroupInput {
	s.ExpectedVersion = &v
	return s
}

// SetThingGroupName sets the ThingGroupName field's value.
func (s *DeleteDynamicThingGroupInput) SetThingGroupName(v string) *DeleteDynamicThingGroupInput {
	s.ThingGroupName = &v
	return s
}

type DeleteDynamicThingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDynamicThingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDynamicThingGroupOutput) GoString() string {
	return s.String()
}

type DeleteJobExecutionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the job execution to be deleted. The executionNumber refers to
	// the execution of a particular job on a particular device.
	//
	// Note that once a job execution is deleted, the executionNumber may be reused
	// by IoT, so be sure you get and use the correct value here.
	//
	// ExecutionNumber is a required field
	ExecutionNumber *int64 `location:"uri" locationName:"executionNumber" type:"long" required:"true"`

	// (Optional) When true, you can delete a job execution which is "IN_PROGRESS".
	// Otherwise, you can only delete a job execution which is in a terminal state
	// ("SUCCEEDED", "FAILED", "REJECTED", "REMOVED" or "CANCELED") or an exception
	// will occur. The default is false.
	//
	// Deleting a job execution which is "IN_PROGRESS", will cause the device to
	// be unable to access job information or update the job execution status. Use
	// caution and ensure that the device is able to recover to a valid state.
	Force *bool `location:"querystring" locationName:"force" type:"boolean"`

	// The ID of the job whose execution on a particular device will be deleted.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" min:"1" type:"string" required:"true"`

	// The name of the thing whose job execution will be deleted.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteJobExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJobExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteJobExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteJobExecutionInput"}
	if s.ExecutionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionNumber"))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExecutionNumber sets the ExecutionNumber field's value.
func (s *DeleteJobExecutionInput) SetExecutionNumber(v int64) *DeleteJobExecutionInput {
	s.ExecutionNumber = &v
	return s
}

// SetForce sets the Force field's value.
func (s *DeleteJobExecutionInput) SetForce(v bool) *DeleteJobExecutionInput {
	s.Force = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DeleteJobExecutionInput) SetJobId(v string) *DeleteJobExecutionInput {
	s.JobId = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *DeleteJobExecutionInput) SetThingName(v string) *DeleteJobExecutionInput {
	s.ThingName = &v
	return s
}

type DeleteJobExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteJobExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJobExecutionOutput) GoString() string {
	return s.String()
}

type DeleteJobInput struct {
	_ struct{} `type:"structure"`

	// (Optional) When true, you can delete a job which is "IN_PROGRESS". Otherwise,
	// you can only delete a job which is in a terminal state ("COMPLETED" or "CANCELED")
	// or an exception will occur. The default is false.
	//
	// Deleting a job which is "IN_PROGRESS", will cause a device which is executing
	// the job to be unable to access job information or update the job execution
	// status. Use caution and ensure that each device executing a job which is
	// deleted is able to recover to a valid state.
	Force *bool `location:"querystring" locationName:"force" type:"boolean"`

	// The ID of the job to be deleted.
	//
	// After a job deletion is completed, you may reuse this jobId when you create
	// a new job. However, this is not recommended, and you must ensure that your
	// devices are not using the jobId to refer to the deleted job.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForce sets the Force field's value.
func (s *DeleteJobInput) SetForce(v bool) *DeleteJobInput {
	s.Force = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DeleteJobInput) SetJobId(v string) *DeleteJobInput {
	s.JobId = &v
	return s
}

type DeleteJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJobOutput) GoString() string {
	return s.String()
}

type DeleteMitigationActionInput struct {
	_ struct{} `type:"structure"`

	// The name of the mitigation action that you want to delete.
	//
	// ActionName is a required field
	ActionName *string `location:"uri" locationName:"actionName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMitigationActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMitigationActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMitigationActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMitigationActionInput"}
	if s.ActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionName"))
	}
	if s.ActionName != nil && len(*s.ActionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionName sets the ActionName field's value.
func (s *DeleteMitigationActionInput) SetActionName(v string) *DeleteMitigationActionInput {
	s.ActionName = &v
	return s
}

type DeleteMitigationActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMitigationActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMitigationActionOutput) GoString() string {
	return s.String()
}

type DeleteOTAUpdateInput struct {
	_ struct{} `type:"structure"`

	// Specifies if the stream associated with an OTA update should be deleted when
	// the OTA update is deleted.
	DeleteStream *bool `location:"querystring" locationName:"deleteStream" type:"boolean"`

	// Specifies if the AWS Job associated with the OTA update should be deleted
	// with the OTA update is deleted.
	ForceDeleteAWSJob *bool `location:"querystring" locationName:"forceDeleteAWSJob" type:"boolean"`

	// The OTA update ID to delete.
	//
	// OtaUpdateId is a required field
	OtaUpdateId *string `location:"uri" locationName:"otaUpdateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteOTAUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOTAUpdateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOTAUpdateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOTAUpdateInput"}
	if s.OtaUpdateId == nil {
		invalidParams.Add(request.NewErrParamRequired("OtaUpdateId"))
	}
	if s.OtaUpdateId != nil && len(*s.OtaUpdateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OtaUpdateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeleteStream sets the DeleteStream field's value.
func (s *DeleteOTAUpdateInput) SetDeleteStream(v bool) *DeleteOTAUpdateInput {
	s.DeleteStream = &v
	return s
}

// SetForceDeleteAWSJob sets the ForceDeleteAWSJob field's value.
func (s *DeleteOTAUpdateInput) SetForceDeleteAWSJob(v bool) *DeleteOTAUpdateInput {
	s.ForceDeleteAWSJob = &v
	return s
}

// SetOtaUpdateId sets the OtaUpdateId field's value.
func (s *DeleteOTAUpdateInput) SetOtaUpdateId(v string) *DeleteOTAUpdateInput {
	s.OtaUpdateId = &v
	return s
}

type DeleteOTAUpdateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOTAUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOTAUpdateOutput) GoString() string {
	return s.String()
}

// The input for the DeletePolicy operation.
type DeletePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy to delete.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *DeletePolicyInput) SetPolicyName(v string) *DeletePolicyInput {
	s.PolicyName = &v
	return s
}

type DeletePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyOutput) GoString() string {
	return s.String()
}

// The input for the DeletePolicyVersion operation.
type DeletePolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The policy version ID.
	//
	// PolicyVersionId is a required field
	PolicyVersionId *string `location:"uri" locationName:"policyVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePolicyVersionInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.PolicyVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyVersionId"))
	}
	if s.PolicyVersionId != nil && len(*s.PolicyVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *DeletePolicyVersionInput) SetPolicyName(v string) *DeletePolicyVersionInput {
	s.PolicyName = &v
	return s
}

// SetPolicyVersionId sets the PolicyVersionId field's value.
func (s *DeletePolicyVersionInput) SetPolicyVersionId(v string) *DeletePolicyVersionInput {
	s.PolicyVersionId = &v
	return s
}

type DeletePolicyVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyVersionOutput) GoString() string {
	return s.String()
}

type DeleteProvisioningTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet provision template to delete.
	//
	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProvisioningTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProvisioningTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProvisioningTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProvisioningTemplateInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *DeleteProvisioningTemplateInput) SetTemplateName(v string) *DeleteProvisioningTemplateInput {
	s.TemplateName = &v
	return s
}

type DeleteProvisioningTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProvisioningTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProvisioningTemplateOutput) GoString() string {
	return s.String()
}

type DeleteProvisioningTemplateVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet provisioning template version to delete.
	//
	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"templateName" min:"1" type:"string" required:"true"`

	// The fleet provisioning template version ID to delete.
	//
	// VersionId is a required field
	VersionId *int64 `location:"uri" locationName:"versionId" type:"integer" required:"true"`
}

// String returns the string representation
func (s DeleteProvisioningTemplateVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProvisioningTemplateVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProvisioningTemplateVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProvisioningTemplateVersionInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.VersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *DeleteProvisioningTemplateVersionInput) SetTemplateName(v string) *DeleteProvisioningTemplateVersionInput {
	s.TemplateName = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteProvisioningTemplateVersionInput) SetVersionId(v int64) *DeleteProvisioningTemplateVersionInput {
	s.VersionId = &v
	return s
}

type DeleteProvisioningTemplateVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProvisioningTemplateVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProvisioningTemplateVersionOutput) GoString() string {
	return s.String()
}

// The input for the DeleteRegistrationCode operation.
type DeleteRegistrationCodeInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRegistrationCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRegistrationCodeInput) GoString() string {
	return s.String()
}

// The output for the DeleteRegistrationCode operation.
type DeleteRegistrationCodeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRegistrationCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRegistrationCodeOutput) GoString() string {
	return s.String()
}

type DeleteRoleAliasInput struct {
	_ struct{} `type:"structure"`

	// The role alias to delete.
	//
	// RoleAlias is a required field
	RoleAlias *string `location:"uri" locationName:"roleAlias" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRoleAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRoleAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRoleAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRoleAliasInput"}
	if s.RoleAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleAlias"))
	}
	if s.RoleAlias != nil && len(*s.RoleAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleAlias", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleAlias sets the RoleAlias field's value.
func (s *DeleteRoleAliasInput) SetRoleAlias(v string) *DeleteRoleAliasInput {
	s.RoleAlias = &v
	return s
}

type DeleteRoleAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRoleAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRoleAliasOutput) GoString() string {
	return s.String()
}

type DeleteScheduledAuditInput struct {
	_ struct{} `type:"structure"`

	// The name of the scheduled audit you want to delete.
	//
	// ScheduledAuditName is a required field
	ScheduledAuditName *string `location:"uri" locationName:"scheduledAuditName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteScheduledAuditInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScheduledAuditInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScheduledAuditInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScheduledAuditInput"}
	if s.ScheduledAuditName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledAuditName"))
	}
	if s.ScheduledAuditName != nil && len(*s.ScheduledAuditName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledAuditName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduledAuditName sets the ScheduledAuditName field's value.
func (s *DeleteScheduledAuditInput) SetScheduledAuditName(v string) *DeleteScheduledAuditInput {
	s.ScheduledAuditName = &v
	return s
}

type DeleteScheduledAuditOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteScheduledAuditOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScheduledAuditOutput) GoString() string {
	return s.String()
}

type DeleteSecurityProfileInput struct {
	_ struct{} `type:"structure"`

	// The expected version of the security profile. A new version is generated
	// whenever the security profile is updated. If you specify a value that is
	// different from the actual version, a VersionConflictException is thrown.
	ExpectedVersion *int64 `location:"querystring" locationName:"expectedVersion" type:"long"`

	// The name of the security profile to be deleted.
	//
	// SecurityProfileName is a required field
	SecurityProfileName *string `location:"uri" locationName:"securityProfileName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSecurityProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSecurityProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSecurityProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSecurityProfileInput"}
	if s.SecurityProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityProfileName"))
	}
	if s.SecurityProfileName != nil && len(*s.SecurityProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityProfileName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpectedVersion sets the ExpectedVersion field's value.
func (s *DeleteSecurityProfileInput) SetExpectedVersion(v int64) *DeleteSecurityProfileInput {
	s.ExpectedVersion = &v
	return s
}

// SetSecurityProfileName sets the SecurityProfileName field's value.
func (s *DeleteSecurityProfileInput) SetSecurityProfileName(v string) *DeleteSecurityProfileInput {
	s.SecurityProfileName = &v
	return s
}

type DeleteSecurityProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSecurityProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSecurityProfileOutput) GoString() string {
	return s.String()
}

type DeleteStreamInput struct {
	_ struct{} `type:"structure"`

	// The stream ID.
	//
	// StreamId is a required field
	StreamId *string `location:"uri" locationName:"streamId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStreamInput"}
	if s.StreamId == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamId"))
	}
	if s.StreamId != nil && len(*s.StreamId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamId sets the StreamId field's value.
func (s *DeleteStreamInput) SetStreamId(v string) *DeleteStreamInput {
	s.StreamId = &v
	return s
}

type DeleteStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStreamOutput) GoString() string {
	return s.String()
}

type DeleteThingGroupInput struct {
	_ struct{} `type:"structure"`

	// The expected version of the thing group to delete.
	ExpectedVersion *int64 `location:"querystring" locationName:"expectedVersion" type:"long"`

	// The name of the thing group to delete.
	//
	// ThingGroupName is a required field
	ThingGroupName *string `location:"uri" locationName:"thingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteThingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteThingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteThingGroupInput"}
	if s.ThingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingGroupName"))
	}
	if s.ThingGroupName != nil && len(*s.ThingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpectedVersion sets the ExpectedVersion field's value.
func (s *DeleteThingGroupInput) SetExpectedVersion(v int64) *DeleteThingGroupInput {
	s.ExpectedVersion = &v
	return s
}

// SetThingGroupName sets the ThingGroupName field's value.
func (s *DeleteThingGroupInput) SetThingGroupName(v string) *DeleteThingGroupInput {
	s.ThingGroupName = &v
	return s
}

type DeleteThingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteThingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThingGroupOutput) GoString() string {
	return s.String()
}

// The input for the DeleteThing operation.
type DeleteThingInput struct {
	_ struct{} `type:"structure"`

	// The expected version of the thing record in the registry. If the version
	// of the record in the registry does not match the expected version specified
	// in the request, the DeleteThing request is rejected with a VersionConflictException.
	ExpectedVersion *int64 `location:"querystring" locationName:"expectedVersion" type:"long"`

	// The name of the thing to delete.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteThingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteThingInput"}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpectedVersion sets the ExpectedVersion field's value.
func (s *DeleteThingInput) SetExpectedVersion(v int64) *DeleteThingInput {
	s.ExpectedVersion = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *DeleteThingInput) SetThingName(v string) *DeleteThingInput {
	s.ThingName = &v
	return s
}

// The output of the DeleteThing operation.
type DeleteThingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThingOutput) GoString() string {
	return s.String()
}

// The input for the DeleteThingType operation.
type DeleteThingTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the thing type.
	//
	// ThingTypeName is a required field
	ThingTypeName *string `location:"uri" locationName:"thingTypeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteThingTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThingTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteThingTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteThingTypeInput"}
	if s.ThingTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingTypeName"))
	}
	if s.ThingTypeName != nil && len(*s.ThingTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *DeleteThingTypeInput) SetThingTypeName(v string) *DeleteThingTypeInput {
	s.ThingTypeName = &v
	return s
}

// The output for the DeleteThingType operation.
type DeleteThingTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteThingTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThingTypeOutput) GoString() string {
	return s.String()
}

type DeleteTopicRuleDestinationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the topic rule destination to delete.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTopicRuleDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTopicRuleDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTopicRuleDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTopicRuleDestinationInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteTopicRuleDestinationInput) SetArn(v string) *DeleteTopicRuleDestinationInput {
	s.Arn = &v
	return s
}

type DeleteTopicRuleDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTopicRuleDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTopicRuleDestinationOutput) GoString() string {
	return s.String()
}

// The input for the DeleteTopicRule operation.
type DeleteTopicRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTopicRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTopicRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTopicRuleInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleName sets the RuleName field's value.
func (s *DeleteTopicRuleInput) SetRuleName(v string) *DeleteTopicRuleInput {
	s.RuleName = &v
	return s
}

type DeleteTopicRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTopicRuleOutput) GoString() string {
	return s.String()
}

type DeleteV2LoggingLevelInput struct {
	_ struct{} `type:"structure"`

	// The name of the resource for which you are configuring logging.
	//
	// TargetName is a required field
	TargetName *string `location:"querystring" locationName:"targetName" type:"string" required:"true"`

	// The type of resource for which you are configuring logging. Must be THING_Group.
	//
	// TargetType is a required field
	TargetType *string `location:"querystring" locationName:"targetType" type:"string" required:"true" enum:"LogTargetType"`
}

// String returns the string representation
func (s DeleteV2LoggingLevelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteV2LoggingLevelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteV2LoggingLevelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteV2LoggingLevelInput"}
	if s.TargetName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetName"))
	}
	if s.TargetType == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetName sets the TargetName field's value.
func (s *DeleteV2LoggingLevelInput) SetTargetName(v string) *DeleteV2LoggingLevelInput {
	s.TargetName = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *DeleteV2LoggingLevelInput) SetTargetType(v string) *DeleteV2LoggingLevelInput {
	s.TargetType = &v
	return s
}

type DeleteV2LoggingLevelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteV2LoggingLevelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteV2LoggingLevelOutput) GoString() string {
	return s.String()
}

// Contains information that denied the authorization.
type Denied struct {
	_ struct{} `type:"structure"`

	// Information that explicitly denies the authorization.
	ExplicitDeny *ExplicitDeny `locationName:"explicitDeny" type:"structure"`

	// Information that implicitly denies the authorization. When a policy doesn't
	// explicitly deny or allow an action on a resource it is considered an implicit
	// deny.
	ImplicitDeny *ImplicitDeny `locationName:"implicitDeny" type:"structure"`
}

// String returns the string representation
func (s Denied) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Denied) GoString() string {
	return s.String()
}

// SetExplicitDeny sets the ExplicitDeny field's value.
func (s *Denied) SetExplicitDeny(v *ExplicitDeny) *Denied {
	s.ExplicitDeny = v
	return s
}

// SetImplicitDeny sets the ImplicitDeny field's value.
func (s *Denied) SetImplicitDeny(v *ImplicitDeny) *Denied {
	s.ImplicitDeny = v
	return s
}

// The input for the DeprecateThingType operation.
type DeprecateThingTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the thing type to deprecate.
	//
	// ThingTypeName is a required field
	ThingTypeName *string `location:"uri" locationName:"thingTypeName" min:"1" type:"string" required:"true"`

	// Whether to undeprecate a deprecated thing type. If true, the thing type will
	// not be deprecated anymore and you can associate it with things.
	UndoDeprecate *bool `locationName:"undoDeprecate" type:"boolean"`
}

// String returns the string representation
func (s DeprecateThingTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateThingTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeprecateThingTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeprecateThingTypeInput"}
	if s.ThingTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingTypeName"))
	}
	if s.ThingTypeName != nil && len(*s.ThingTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *DeprecateThingTypeInput) SetThingTypeName(v string) *DeprecateThingTypeInput {
	s.ThingTypeName = &v
	return s
}

// SetUndoDeprecate sets the UndoDeprecate field's value.
func (s *DeprecateThingTypeInput) SetUndoDeprecate(v bool) *DeprecateThingTypeInput {
	s.UndoDeprecate = &v
	return s
}

// The output for the DeprecateThingType operation.
type DeprecateThingTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeprecateThingTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateThingTypeOutput) GoString() string {
	return s.String()
}

type DescribeAccountAuditConfigurationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountAuditConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAuditConfigurationInput) GoString() string {
	return s.String()
}

type DescribeAccountAuditConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Which audit checks are enabled and disabled for this account.
	AuditCheckConfigurations map[string]*AuditCheckConfiguration `locationName:"auditCheckConfigurations" type:"map"`

	// Information about the targets to which audit notifications are sent for this
	// account.
	AuditNotificationTargetConfigurations map[string]*AuditNotificationTarget `locationName:"auditNotificationTargetConfigurations" type:"map"`

	// The ARN of the role that grants permission to AWS IoT to access information
	// about your devices, policies, certificates, and other items as required when
	// performing an audit.
	//
	// On the first call to UpdateAccountAuditConfiguration, this parameter is required.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`
}

// String returns the string representation
func (s DescribeAccountAuditConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAuditConfigurationOutput) GoString() string {
	return s.String()
}

// SetAuditCheckConfigurations sets the AuditCheckConfigurations field's value.
func (s *DescribeAccountAuditConfigurationOutput) SetAuditCheckConfigurations(v map[string]*AuditCheckConfiguration) *DescribeAccountAuditConfigurationOutput {
	s.AuditCheckConfigurations = v
	return s
}

// SetAuditNotificationTargetConfigurations sets the AuditNotificationTargetConfigurations field's value.
func (s *DescribeAccountAuditConfigurationOutput) SetAuditNotificationTargetConfigurations(v map[string]*AuditNotificationTarget) *DescribeAccountAuditConfigurationOutput {
	s.AuditNotificationTargetConfigurations = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeAccountAuditConfigurationOutput) SetRoleArn(v string) *DescribeAccountAuditConfigurationOutput {
	s.RoleArn = &v
	return s
}

type DescribeAuditFindingInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for a single audit finding. You can use this identifier
	// to apply mitigation actions to the finding.
	//
	// FindingId is a required field
	FindingId *string `location:"uri" locationName:"findingId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAuditFindingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAuditFindingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAuditFindingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAuditFindingInput"}
	if s.FindingId == nil {
		invalidParams.Add(request.NewErrParamRequired("FindingId"))
	}
	if s.FindingId != nil && len(*s.FindingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FindingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFindingId sets the FindingId field's value.
func (s *DescribeAuditFindingInput) SetFindingId(v string) *DescribeAuditFindingInput {
	s.FindingId = &v
	return s
}

type DescribeAuditFindingOutput struct {
	_ struct{} `type:"structure"`

	// The findings (results) of the audit.
	Finding *AuditFinding `locationName:"finding" type:"structure"`
}

// String returns the string representation
func (s DescribeAuditFindingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAuditFindingOutput) GoString() string {
	return s.String()
}

// SetFinding sets the Finding field's value.
func (s *DescribeAuditFindingOutput) SetFinding(v *AuditFinding) *DescribeAuditFindingOutput {
	s.Finding = v
	return s
}

type DescribeAuditMitigationActionsTaskInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the audit mitigation task.
	//
	// TaskId is a required field
	TaskId *string `location:"uri" locationName:"taskId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAuditMitigationActionsTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAuditMitigationActionsTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAuditMitigationActionsTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAuditMitigationActionsTaskInput"}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskId sets the TaskId field's value.
func (s *DescribeAuditMitigationActionsTaskInput) SetTaskId(v string) *DescribeAuditMitigationActionsTaskInput {
	s.TaskId = &v
	return s
}

type DescribeAuditMitigationActionsTaskOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the mitigation actions and their parameters that are applied as
	// part of this task.
	ActionsDefinition []*MitigationAction `locationName:"actionsDefinition" type:"list"`

	// Specifies the mitigation actions that should be applied to specific audit
	// checks.
	AuditCheckToActionsMapping map[string][]*string `locationName:"auditCheckToActionsMapping" type:"map"`

	// The date and time when the task was completed or canceled.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The date and time when the task was started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// Identifies the findings to which the mitigation actions are applied. This
	// can be by audit checks, by audit task, or a set of findings.
	Target *AuditMitigationActionsTaskTarget `locationName:"target" type:"structure"`

	// Aggregate counts of the results when the mitigation tasks were applied to
	// the findings for this audit mitigation actions task.
	TaskStatistics map[string]*TaskStatisticsForAuditCheck `locationName:"taskStatistics" type:"map"`

	// The current status of the task.
	TaskStatus *string `locationName:"taskStatus" type:"string" enum:"AuditMitigationActionsTaskStatus"`
}

// String returns the string representation
func (s DescribeAuditMitigationActionsTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAuditMitigationActionsTaskOutput) GoString() string {
	return s.String()
}

// SetActionsDefinition sets the ActionsDefinition field's value.
func (s *DescribeAuditMitigationActionsTaskOutput) SetActionsDefinition(v []*MitigationAction) *DescribeAuditMitigationActionsTaskOutput {
	s.ActionsDefinition = v
	return s
}

// SetAuditCheckToActionsMapping sets the AuditCheckToActionsMapping field's value.
func (s *DescribeAuditMitigationActionsTaskOutput) SetAuditCheckToActionsMapping(v map[string][]*string) *DescribeAuditMitigationActionsTaskOutput {
	s.AuditCheckToActionsMapping = v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeAuditMitigationActionsTaskOutput) SetEndTime(v time.Time) *DescribeAuditMitigationActionsTaskOutput {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeAuditMitigationActionsTaskOutput) SetStartTime(v time.Time) *DescribeAuditMitigationActionsTaskOutput {
	s.StartTime = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *DescribeAuditMitigationActionsTaskOutput) SetTarget(v *AuditMitigationActionsTaskTarget) *DescribeAuditMitigationActionsTaskOutput {
	s.Target = v
	return s
}

// SetTaskStatistics sets the TaskStatistics field's value.
func (s *DescribeAuditMitigationActionsTaskOutput) SetTaskStatistics(v map[string]*TaskStatisticsForAuditCheck) *DescribeAuditMitigationActionsTaskOutput {
	s.TaskStatistics = v
	return s
}

// SetTaskStatus sets the TaskStatus field's value.
func (s *DescribeAuditMitigationActionsTaskOutput) SetTaskStatus(v string) *DescribeAuditMitigationActionsTaskOutput {
	s.TaskStatus = &v
	return s
}

type DescribeAuditTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the audit whose information you want to get.
	//
	// TaskId is a required field
	TaskId *string `location:"uri" locationName:"taskId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAuditTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAuditTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAuditTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAuditTaskInput"}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskId sets the TaskId field's value.
func (s *DescribeAuditTaskInput) SetTaskId(v string) *DescribeAuditTaskInput {
	s.TaskId = &v
	return s
}

type DescribeAuditTaskOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about each check performed during this audit.
	AuditDetails map[string]*AuditCheckDetails `locationName:"auditDetails" type:"map"`

	// The name of the scheduled audit (only if the audit was a scheduled audit).
	ScheduledAuditName *string `locationName:"scheduledAuditName" min:"1" type:"string"`

	// The time the audit started.
	TaskStartTime *time.Time `locationName:"taskStartTime" type:"timestamp"`

	// Statistical information about the audit.
	TaskStatistics *TaskStatistics `locationName:"taskStatistics" type:"structure"`

	// The status of the audit: one of "IN_PROGRESS", "COMPLETED", "FAILED", or
	// "CANCELED".
	TaskStatus *string `locationName:"taskStatus" type:"string" enum:"AuditTaskStatus"`

	// The type of audit: "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".
	TaskType *string `locationName:"taskType" type:"string" enum:"AuditTaskType"`
}

// String returns the string representation
func (s DescribeAuditTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAuditTaskOutput) GoString() string {
	return s.String()
}

// SetAuditDetails sets the AuditDetails field's value.
func (s *DescribeAuditTaskOutput) SetAuditDetails(v map[string]*AuditCheckDetails) *DescribeAuditTaskOutput {
	s.AuditDetails = v
	return s
}

// SetScheduledAuditName sets the ScheduledAuditName field's value.
func (s *DescribeAuditTaskOutput) SetScheduledAuditName(v string) *DescribeAuditTaskOutput {
	s.ScheduledAuditName = &v
	return s
}

// SetTaskStartTime sets the TaskStartTime field's value.
func (s *DescribeAuditTaskOutput) SetTaskStartTime(v time.Time) *DescribeAuditTaskOutput {
	s.TaskStartTime = &v
	return s
}

// SetTaskStatistics sets the TaskStatistics field's value.
func (s *DescribeAuditTaskOutput) SetTaskStatistics(v *TaskStatistics) *DescribeAuditTaskOutput {
	s.TaskStatistics = v
	return s
}

// SetTaskStatus sets the TaskStatus field's value.
func (s *DescribeAuditTaskOutput) SetTaskStatus(v string) *DescribeAuditTaskOutput {
	s.TaskStatus = &v
	return s
}

// SetTaskType sets the TaskType field's value.
func (s *DescribeAuditTaskOutput) SetTaskType(v string) *DescribeAuditTaskOutput {
	s.TaskType = &v
	return s
}

type DescribeAuthorizerInput struct {
	_ struct{} `type:"structure"`

	// The name of the authorizer to describe.
	//
	// AuthorizerName is a required field
	AuthorizerName *string `location:"uri" locationName:"authorizerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAuthorizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAuthorizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAuthorizerInput"}
	if s.AuthorizerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizerName"))
	}
	if s.AuthorizerName != nil && len(*s.AuthorizerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizerName sets the AuthorizerName field's value.
func (s *DescribeAuthorizerInput) SetAuthorizerName(v string) *DescribeAuthorizerInput {
	s.AuthorizerName = &v
	return s
}

type DescribeAuthorizerOutput struct {
	_ struct{} `type:"structure"`

	// The authorizer description.
	AuthorizerDescription *AuthorizerDescription `locationName:"authorizerDescription" type:"structure"`
}

// String returns the string representation
func (s DescribeAuthorizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAuthorizerOutput) GoString() string {
	return s.String()
}

// SetAuthorizerDescription sets the AuthorizerDescription field's value.
func (s *DescribeAuthorizerOutput) SetAuthorizerDescription(v *AuthorizerDescription) *DescribeAuthorizerOutput {
	s.AuthorizerDescription = v
	return s
}

type DescribeBillingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the billing group.
	//
	// BillingGroupName is a required field
	BillingGroupName *string `location:"uri" locationName:"billingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeBillingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBillingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBillingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBillingGroupInput"}
	if s.BillingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("BillingGroupName"))
	}
	if s.BillingGroupName != nil && len(*s.BillingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BillingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingGroupName sets the BillingGroupName field's value.
func (s *DescribeBillingGroupInput) SetBillingGroupName(v string) *DescribeBillingGroupInput {
	s.BillingGroupName = &v
	return s
}

type DescribeBillingGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the billing group.
	BillingGroupArn *string `locationName:"billingGroupArn" type:"string"`

	// The ID of the billing group.
	BillingGroupId *string `locationName:"billingGroupId" min:"1" type:"string"`

	// Additional information about the billing group.
	BillingGroupMetadata *BillingGroupMetadata `locationName:"billingGroupMetadata" type:"structure"`

	// The name of the billing group.
	BillingGroupName *string `locationName:"billingGroupName" min:"1" type:"string"`

	// The properties of the billing group.
	BillingGroupProperties *BillingGroupProperties `locationName:"billingGroupProperties" type:"structure"`

	// The version of the billing group.
	Version *int64 `locationName:"version" type:"long"`
}

// String returns the string representation
func (s DescribeBillingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBillingGroupOutput) GoString() string {
	return s.String()
}

// SetBillingGroupArn sets the BillingGroupArn field's value.
func (s *DescribeBillingGroupOutput) SetBillingGroupArn(v string) *DescribeBillingGroupOutput {
	s.BillingGroupArn = &v
	return s
}

// SetBillingGroupId sets the BillingGroupId field's value.
func (s *DescribeBillingGroupOutput) SetBillingGroupId(v string) *DescribeBillingGroupOutput {
	s.BillingGroupId = &v
	return s
}

// SetBillingGroupMetadata sets the BillingGroupMetadata field's value.
func (s *DescribeBillingGroupOutput) SetBillingGroupMetadata(v *BillingGroupMetadata) *DescribeBillingGroupOutput {
	s.BillingGroupMetadata = v
	return s
}

// SetBillingGroupName sets the BillingGroupName field's value.
func (s *DescribeBillingGroupOutput) SetBillingGroupName(v string) *DescribeBillingGroupOutput {
	s.BillingGroupName = &v
	return s
}

// SetBillingGroupProperties sets the BillingGroupProperties field's value.
func (s *DescribeBillingGroupOutput) SetBillingGroupProperties(v *BillingGroupProperties) *DescribeBillingGroupOutput {
	s.BillingGroupProperties = v
	return s
}

// SetVersion sets the Version field's value.
func (s *DescribeBillingGroupOutput) SetVersion(v int64) *DescribeBillingGroupOutput {
	s.Version = &v
	return s
}

// The input for the DescribeCACertificate operation.
type DescribeCACertificateInput struct {
	_ struct{} `type:"structure"`

	// The CA certificate identifier.
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"caCertificateId" min:"64" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCACertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCACertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCACertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCACertificateInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *DescribeCACertificateInput) SetCertificateId(v string) *DescribeCACertificateInput {
	s.CertificateId = &v
	return s
}

// The output from the DescribeCACertificate operation.
type DescribeCACertificateOutput struct {
	_ struct{} `type:"structure"`

	// The CA certificate description.
	CertificateDescription *CACertificateDescription `locationName:"certificateDescription" type:"structure"`

	// Information about the registration configuration.
	RegistrationConfig *RegistrationConfig `locationName:"registrationConfig" type:"structure"`
}

// String returns the string representation
func (s DescribeCACertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCACertificateOutput) GoString() string {
	return s.String()
}

// SetCertificateDescription sets the CertificateDescription field's value.
func (s *DescribeCACertificateOutput) SetCertificateDescription(v *CACertificateDescription) *DescribeCACertificateOutput {
	s.CertificateDescription = v
	return s
}

// SetRegistrationConfig sets the RegistrationConfig field's value.
func (s *DescribeCACertificateOutput) SetRegistrationConfig(v *RegistrationConfig) *DescribeCACertificateOutput {
	s.RegistrationConfig = v
	return s
}

// The input for the DescribeCertificate operation.
type DescribeCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate. (The last part of the certificate ARN contains
	// the certificate ID.)
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCertificateInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *DescribeCertificateInput) SetCertificateId(v string) *DescribeCertificateInput {
	s.CertificateId = &v
	return s
}

// The output of the DescribeCertificate operation.
type DescribeCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The description of the certificate.
	CertificateDescription *CertificateDescription `locationName:"certificateDescription" type:"structure"`
}

// String returns the string representation
func (s DescribeCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificateDescription sets the CertificateDescription field's value.
func (s *DescribeCertificateOutput) SetCertificateDescription(v *CertificateDescription) *DescribeCertificateOutput {
	s.CertificateDescription = v
	return s
}

type DescribeDefaultAuthorizerInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeDefaultAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDefaultAuthorizerInput) GoString() string {
	return s.String()
}

type DescribeDefaultAuthorizerOutput struct {
	_ struct{} `type:"structure"`

	// The default authorizer's description.
	AuthorizerDescription *AuthorizerDescription `locationName:"authorizerDescription" type:"structure"`
}

// String returns the string representation
func (s DescribeDefaultAuthorizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDefaultAuthorizerOutput) GoString() string {
	return s.String()
}

// SetAuthorizerDescription sets the AuthorizerDescription field's value.
func (s *DescribeDefaultAuthorizerOutput) SetAuthorizerDescription(v *AuthorizerDescription) *DescribeDefaultAuthorizerOutput {
	s.AuthorizerDescription = v
	return s
}

type DescribeDimensionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the dimension.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDimensionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDimensionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDimensionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDimensionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeDimensionInput) SetName(v string) *DescribeDimensionInput {
	s.Name = &v
	return s
}

type DescribeDimensionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon resource name) for the dimension.
	Arn *string `locationName:"arn" type:"string"`

	// The date the dimension was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The date the dimension was last modified.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp"`

	// The unique identifier for the dimension.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The value or list of values used to scope the dimension. For example, for
	// topic filters, this is the pattern used to match the MQTT topic name.
	StringValues []*string `locationName:"stringValues" min:"1" type:"list"`

	// The type of the dimension.
	Type *string `locationName:"type" type:"string" enum:"DimensionType"`
}

// String returns the string representation
func (s DescribeDimensionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDimensionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeDimensionOutput) SetArn(v string) *DescribeDimensionOutput {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *DescribeDimensionOutput) SetCreationDate(v time.Time) *DescribeDimensionOutput {
	s.CreationDate = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *DescribeDimensionOutput) SetLastModifiedDate(v time.Time) *DescribeDimensionOutput {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeDimensionOutput) SetName(v string) *DescribeDimensionOutput {
	s.Name = &v
	return s
}

// SetStringValues sets the StringValues field's value.
func (s *DescribeDimensionOutput) SetStringValues(v []*string) *DescribeDimensionOutput {
	s.StringValues = v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeDimensionOutput) SetType(v string) *DescribeDimensionOutput {
	s.Type = &v
	return s
}

type DescribeDomainConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain configuration.
	//
	// DomainConfigurationName is a required field
	DomainConfigurationName *string `location:"uri" locationName:"domainConfigurationName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDomainConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDomainConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainConfigurationInput"}
	if s.DomainConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainConfigurationName"))
	}
	if s.DomainConfigurationName != nil && len(*s.DomainConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainConfigurationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainConfigurationName sets the DomainConfigurationName field's value.
func (s *DescribeDomainConfigurationInput) SetDomainConfigurationName(v string) *DescribeDomainConfigurationInput {
	s.DomainConfigurationName = &v
	return s
}

type DescribeDomainConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// An object that specifies the authorization service for a domain.
	AuthorizerConfig *AuthorizerConfig `locationName:"authorizerConfig" type:"structure"`

	// The ARN of the domain configuration.
	DomainConfigurationArn *string `locationName:"domainConfigurationArn" type:"string"`

	// The name of the domain configuration.
	DomainConfigurationName *string `locationName:"domainConfigurationName" min:"1" type:"string"`

	// A Boolean value that specifies the current state of the domain configuration.
	DomainConfigurationStatus *string `locationName:"domainConfigurationStatus" type:"string" enum:"DomainConfigurationStatus"`

	// The name of the domain.
	DomainName *string `locationName:"domainName" min:"1" type:"string"`

	// The type of the domain.
	DomainType *string `locationName:"domainType" type:"string" enum:"DomainType"`

	// A list containing summary information about the server certificate included
	// in the domain configuration.
	ServerCertificates []*ServerCertificateSummary `locationName:"serverCertificates" type:"list"`

	// The type of service delivered by the endpoint.
	ServiceType *string `locationName:"serviceType" type:"string" enum:"ServiceType"`
}

// String returns the string representation
func (s DescribeDomainConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDomainConfigurationOutput) GoString() string {
	return s.String()
}

// SetAuthorizerConfig sets the AuthorizerConfig field's value.
func (s *DescribeDomainConfigurationOutput) SetAuthorizerConfig(v *AuthorizerConfig) *DescribeDomainConfigurationOutput {
	s.AuthorizerConfig = v
	return s
}

// SetDomainConfigurationArn sets the DomainConfigurationArn field's value.
func (s *DescribeDomainConfigurationOutput) SetDomainConfigurationArn(v string) *DescribeDomainConfigurationOutput {
	s.DomainConfigurationArn = &v
	return s
}

// SetDomainConfigurationName sets the DomainConfigurationName field's value.
func (s *DescribeDomainConfigurationOutput) SetDomainConfigurationName(v string) *DescribeDomainConfigurationOutput {
	s.DomainConfigurationName = &v
	return s
}

// SetDomainConfigurationStatus sets the DomainConfigurationStatus field's value.
func (s *DescribeDomainConfigurationOutput) SetDomainConfigurationStatus(v string) *DescribeDomainConfigurationOutput {
	s.DomainConfigurationStatus = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeDomainConfigurationOutput) SetDomainName(v string) *DescribeDomainConfigurationOutput {
	s.DomainName = &v
	return s
}

// SetDomainType sets the DomainType field's value.
func (s *DescribeDomainConfigurationOutput) SetDomainType(v string) *DescribeDomainConfigurationOutput {
	s.DomainType = &v
	return s
}

// SetServerCertificates sets the ServerCertificates field's value.
func (s *DescribeDomainConfigurationOutput) SetServerCertificates(v []*ServerCertificateSummary) *DescribeDomainConfigurationOutput {
	s.ServerCertificates = v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *DescribeDomainConfigurationOutput) SetServiceType(v string) *DescribeDomainConfigurationOutput {
	s.ServiceType = &v
	return s
}

// The input for the DescribeEndpoint operation.
type DescribeEndpointInput struct {
	_ struct{} `type:"structure"`

	// The endpoint type. Valid endpoint types include:
	//
	//    * iot:Data - Returns a VeriSign signed data endpoint.
	//
	//    * iot:Data-ATS - Returns an ATS signed data endpoint.
	//
	//    * iot:CredentialProvider - Returns an AWS IoT credentials provider API
	//    endpoint.
	//
	//    * iot:Jobs - Returns an AWS IoT device management Jobs API endpoint.
	//
	// We strongly recommend that customers use the newer iot:Data-ATS endpoint
	// type to avoid issues related to the widespread distrust of Symantec certificate
	// authorities.
	EndpointType *string `location:"querystring" locationName:"endpointType" type:"string"`
}

// String returns the string representation
func (s DescribeEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointInput) GoString() string {
	return s.String()
}

// SetEndpointType sets the EndpointType field's value.
func (s *DescribeEndpointInput) SetEndpointType(v string) *DescribeEndpointInput {
	s.EndpointType = &v
	return s
}

// The output from the DescribeEndpoint operation.
type DescribeEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint. The format of the endpoint is as follows: identifier.iot.region.amazonaws.com.
	EndpointAddress *string `locationName:"endpointAddress" type:"string"`
}

// String returns the string representation
func (s DescribeEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointAddress sets the EndpointAddress field's value.
func (s *DescribeEndpointOutput) SetEndpointAddress(v string) *DescribeEndpointOutput {
	s.EndpointAddress = &v
	return s
}

type DescribeEventConfigurationsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeEventConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventConfigurationsInput) GoString() string {
	return s.String()
}

type DescribeEventConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The creation date of the event configuration.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The event configurations.
	EventConfigurations map[string]*Configuration `locationName:"eventConfigurations" type:"map"`

	// The date the event configurations were last modified.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp"`
}

// String returns the string representa