// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package marketplacecatalog

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opCancelChangeSet = "CancelChangeSet"

// CancelChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the CancelChangeSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelChangeSet for more information on using the CancelChangeSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelChangeSetRequest method.
//    req, resp := client.CancelChangeSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/CancelChangeSet
func (c *MarketplaceCatalog) CancelChangeSetRequest(input *CancelChangeSetInput) (req *request.Request, output *CancelChangeSetOutput) {
	op := &request.Operation{
		Name:       opCancelChangeSet,
		HTTPMethod: "PATCH",
		HTTPPath:   "/CancelChangeSet",
	}

	if input == nil {
		input = &CancelChangeSetInput{}
	}

	output = &CancelChangeSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelChangeSet API operation for AWS Marketplace Catalog Service.
//
// Used to cancel an open change request. Must be sent before the status of
// the request changes to APPLYING, the final stage of completing your change
// request. You can describe a change during the 60-day request history retention
// period for API calls.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Catalog Service's
// API operation CancelChangeSet for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   There was an internal service exception.
//
//   * AccessDeniedException
//   Access is denied.
//
//   * ValidationException
//   An error occurred during validation.
//
//   * ResourceNotFoundException
//   The specified resource wasn't found.
//
//   * ResourceInUseException
//   The resource is currently in use.
//
//   * ThrottlingException
//   Too many requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/CancelChangeSet
func (c *MarketplaceCatalog) CancelChangeSet(input *CancelChangeSetInput) (*CancelChangeSetOutput, error) {
	req, out := c.CancelChangeSetRequest(input)
	return out, req.Send()
}

// CancelChangeSetWithContext is the same as CancelChangeSet with the addition of
// the ability to pass a context and additional request options.
//
// See CancelChangeSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) CancelChangeSetWithContext(ctx aws.Context, input *CancelChangeSetInput, opts ...request.Option) (*CancelChangeSetOutput, error) {
	req, out := c.CancelChangeSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChangeSet = "DescribeChangeSet"

// DescribeChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChangeSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChangeSet for more information on using the DescribeChangeSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeChangeSetRequest method.
//    req, resp := client.DescribeChangeSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DescribeChangeSet
func (c *MarketplaceCatalog) DescribeChangeSetRequest(input *DescribeChangeSetInput) (req *request.Request, output *DescribeChangeSetOutput) {
	op := &request.Operation{
		Name:       opDescribeChangeSet,
		HTTPMethod: "GET",
		HTTPPath:   "/DescribeChangeSet",
	}

	if input == nil {
		input = &DescribeChangeSetInput{}
	}

	output = &DescribeChangeSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChangeSet API operation for AWS Marketplace Catalog Service.
//
// Provides information about a given change set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Catalog Service's
// API operation DescribeChangeSet for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   There was an internal service exception.
//
//   * AccessDeniedException
//   Access is denied.
//
//   * ValidationException
//   An error occurred during validation.
//
//   * ResourceNotFoundException
//   The specified resource wasn't found.
//
//   * ThrottlingException
//   Too many requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DescribeChangeSet
func (c *MarketplaceCatalog) DescribeChangeSet(input *DescribeChangeSetInput) (*DescribeChangeSetOutput, error) {
	req, out := c.DescribeChangeSetRequest(input)
	return out, req.Send()
}

// DescribeChangeSetWithContext is the same as DescribeChangeSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChangeSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) DescribeChangeSetWithContext(ctx aws.Context, input *DescribeChangeSetInput, opts ...request.Option) (*DescribeChangeSetOutput, error) {
	req, out := c.DescribeChangeSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEntity = "DescribeEntity"

// DescribeEntityRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEntity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEntity for more information on using the DescribeEntity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEntityRequest method.
//    req, resp := client.DescribeEntityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DescribeEntity
func (c *MarketplaceCatalog) DescribeEntityRequest(input *DescribeEntityInput) (req *request.Request, output *DescribeEntityOutput) {
	op := &request.Operation{
		Name:       opDescribeEntity,
		HTTPMethod: "GET",
		HTTPPath:   "/DescribeEntity",
	}

	if input == nil {
		input = &DescribeEntityInput{}
	}

	output = &DescribeEntityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEntity API operation for AWS Marketplace Catalog Service.
//
// Returns the metadata and content of the entity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Catalog Service's
// API operation DescribeEntity for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   There was an internal service exception.
//
//   * AccessDeniedException
//   Access is denied.
//
//   * ValidationException
//   An error occurred during validation.
//
//   * ResourceNotSupportedException
//   Currently, the specified resource is not supported.
//
//   * ResourceNotFoundException
//   The specified resource wasn't found.
//
//   * ThrottlingException
//   Too many requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DescribeEntity
func (c *MarketplaceCatalog) DescribeEntity(input *DescribeEntityInput) (*DescribeEntityOutput, error) {
	req, out := c.DescribeEntityRequest(input)
	return out, req.Send()
}

// DescribeEntityWithContext is the same as DescribeEntity with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEntity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) DescribeEntityWithContext(ctx aws.Context, input *DescribeEntityInput, opts ...request.Option) (*DescribeEntityOutput, error) {
	req, out := c.DescribeEntityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListChangeSets = "ListChangeSets"

// ListChangeSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListChangeSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChangeSets for more information on using the ListChangeSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListChangeSetsRequest method.
//    req, resp := client.ListChangeSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListChangeSets
func (c *MarketplaceCatalog) ListChangeSetsRequest(input *ListChangeSetsInput) (req *request.Request, output *ListChangeSetsOutput) {
	op := &request.Operation{
		Name:       opListChangeSets,
		HTTPMethod: "POST",
		HTTPPath:   "/ListChangeSets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChangeSetsInput{}
	}

	output = &ListChangeSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChangeSets API operation for AWS Marketplace Catalog Service.
//
// Returns the list of change sets owned by the account being used to make the
// call. You can filter this list by providing any combination of entityId,
// ChangeSetName, and status. If you provide more than one filter, the API operation
// applies a logical AND between the filters.
//
// You can describe a change during the 60-day request history retention period
// for API calls.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Catalog Service's
// API operation ListChangeSets for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   There was an internal service exception.
//
//   * AccessDeniedException
//   Access is denied.
//
//   * ValidationException
//   An error occurred during validation.
//
//   * ThrottlingException
//   Too many requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListChangeSets
func (c *MarketplaceCatalog) ListChangeSets(input *ListChangeSetsInput) (*ListChangeSetsOutput, error) {
	req, out := c.ListChangeSetsRequest(input)
	return out, req.Send()
}

// ListChangeSetsWithContext is the same as ListChangeSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListChangeSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) ListChangeSetsWithContext(ctx aws.Context, input *ListChangeSetsInput, opts ...request.Option) (*ListChangeSetsOutput, error) {
	req, out := c.ListChangeSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChangeSetsPages iterates over the pages of a ListChangeSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChangeSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListChangeSets operation.
//    pageNum := 0
//    err := client.ListChangeSetsPages(params,
//        func(page *marketplacecatalog.ListChangeSetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MarketplaceCatalog) ListChangeSetsPages(input *ListChangeSetsInput, fn func(*ListChangeSetsOutput, bool) bool) error {
	return c.ListChangeSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChangeSetsPagesWithContext same as ListChangeSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) ListChangeSetsPagesWithContext(ctx aws.Context, input *ListChangeSetsInput, fn func(*ListChangeSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChangeSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChangeSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChangeSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEntities = "ListEntities"

// ListEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the ListEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEntities for more information on using the ListEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEntitiesRequest method.
//    req, resp := client.ListEntitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListEntities
func (c *MarketplaceCatalog) ListEntitiesRequest(input *ListEntitiesInput) (req *request.Request, output *ListEntitiesOutput) {
	op := &request.Operation{
		Name:       opListEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/ListEntities",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEntitiesInput{}
	}

	output = &ListEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEntities API operation for AWS Marketplace Catalog Service.
//
// Provides the list of entities of a given type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Catalog Service's
// API operation ListEntities for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   There was an internal service exception.
//
//   * AccessDeniedException
//   Access is denied.
//
//   * ValidationException
//   An error occurred during validation.
//
//   * ResourceNotFoundException
//   The specified resource wasn't found.
//
//   * ThrottlingException
//   Too many requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListEntities
func (c *MarketplaceCatalog) ListEntities(input *ListEntitiesInput) (*ListEntitiesOutput, error) {
	req, out := c.ListEntitiesRequest(input)
	return out, req.Send()
}

// ListEntitiesWithContext is the same as ListEntities with the addition of
// the ability to pass a context and additional request options.
//
// See ListEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) ListEntitiesWithContext(ctx aws.Context, input *ListEntitiesInput, opts ...request.Option) (*ListEntitiesOutput, error) {
	req, out := c.ListEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEntitiesPages iterates over the pages of a ListEntities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEntities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEntities operation.
//    pageNum := 0
//    err := client.ListEntitiesPages(params,
//        func(page *marketplacecatalog.ListEntitiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MarketplaceCatalog) ListEntitiesPages(input *ListEntitiesInput, fn func(*ListEntitiesOutput, bool) bool) error {
	return c.ListEntitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEntitiesPagesWithContext same as ListEntitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) ListEntitiesPagesWithContext(ctx aws.Context, input *ListEntitiesInput, fn func(*ListEntitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEntitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEntitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEntitiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartChangeSet = "StartChangeSet"

// StartChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the StartChangeSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartChangeSet for more information on using the StartChangeSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartChangeSetRequest method.
//    req, resp := client.StartChangeSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/StartChangeSet
func (c *MarketplaceCatalog) StartChangeSetRequest(input *StartChangeSetInput) (req *request.Request, output *StartChangeSetOutput) {
	op := &request.Operation{
		Name:       opStartChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/StartChangeSet",
	}

	if input == nil {
		input = &StartChangeSetInput{}
	}

	output = &StartChangeSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartChangeSet API operation for AWS Marketplace Catalog Service.
//
// This operation allows you to request changes in your entities.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Catalog Service's
// API operation StartChangeSet for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   There was an internal service exception.
//
//   * AccessDeniedException
//   Access is denied.
//
//   * ValidationException
//   An error occurred during validation.
//
//   * ResourceNotFoundException
//   The specified resource wasn't found.
//
//   * ResourceInUseException
//   The resource is currently in use.
//
//   * ThrottlingException
//   Too many requests.
//
//   * ServiceQuotaExceededException
//   The maximum number of open requests per account has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/StartChangeSet
func (c *MarketplaceCatalog) StartChangeSet(input *StartChangeSetInput) (*StartChangeSetOutput, error) {
	req, out := c.StartChangeSetRequest(input)
	return out, req.Send()
}

// StartChangeSetWithContext is the same as StartChangeSet with the addition of
// the ability to pass a context and additional request options.
//
// See StartChangeSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) StartChangeSetWithContext(ctx aws.Context, input *StartChangeSetInput, opts ...request.Option) (*StartChangeSetOutput, error) {
	req, out := c.StartChangeSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Access is denied.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CancelChangeSetInput struct {
	_ struct{} `type:"structure"`

	// Required. The catalog related to the request. Fixed value: AWSMarketplace.
	//
	// Catalog is a required field
	Catalog *string `location:"querystring" locationName:"catalog" min:"1" type:"string" required:"true"`

	// Required. The unique identifier of the StartChangeSet request that you want
	// to cancel.
	//
	// ChangeSetId is a required field
	ChangeSetId *string `location:"querystring" locationName:"changeSetId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelChangeSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelChangeSetInput"}
	if s.Catalog == nil {
		invalidParams.Add(request.NewErrParamRequired("Catalog"))
	}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Catalog", 1))
	}
	if s.ChangeSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeSetId"))
	}
	if s.ChangeSetId != nil && len(*s.ChangeSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalog sets the Catalog field's value.
func (s *CancelChangeSetInput) SetCatalog(v string) *CancelChangeSetInput {
	s.Catalog = &v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *CancelChangeSetInput) SetChangeSetId(v string) *CancelChangeSetInput {
	s.ChangeSetId = &v
	return s
}

type CancelChangeSetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN associated with the change set referenced in this request.
	ChangeSetArn *string `min:"1" type:"string"`

	// The unique identifier for the change set referenced in this request.
	ChangeSetId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CancelChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelChangeSetOutput) GoString() string {
	return s.String()
}

// SetChangeSetArn sets the ChangeSetArn field's value.
func (s *CancelChangeSetOutput) SetChangeSetArn(v string) *CancelChangeSetOutput {
	s.ChangeSetArn = &v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *CancelChangeSetOutput) SetChangeSetId(v string) *CancelChangeSetOutput {
	s.ChangeSetId = &v
	return s
}

// An object that contains the ChangeType, Details, and Entity.
type Change struct {
	_ struct{} `type:"structure"`

	// Change types are single string values that describe your intention for the
	// change. Each change type is unique for each EntityType provided in the change's
	// scope.
	//
	// ChangeType is a required field
	ChangeType *string `min:"1" type:"string" required:"true"`

	// This object contains details specific to the change type of the requested
	// change.
	//
	// Details is a required field
	Details *string `min:"2" type:"string" required:"true"`

	// The entity to be changed.
	//
	// Entity is a required field
	Entity *Entity `type:"structure" required:"true"`
}

// String returns the string representation
func (s Change) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Change) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Change) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Change"}
	if s.ChangeType == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeType"))
	}
	if s.ChangeType != nil && len(*s.ChangeType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeType", 1))
	}
	if s.Details == nil {
		invalidParams.Add(request.NewErrParamRequired("Details"))
	}
	if s.Details != nil && len(*s.Details) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Details", 2))
	}
	if s.Entity == nil {
		invalidParams.Add(request.NewErrParamRequired("Entity"))
	}
	if s.Entity != nil {
		if err := s.Entity.Validate(); err != nil {
			invalidParams.AddNested("Entity", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeType sets the ChangeType field's value.
func (s *Change) SetChangeType(v string) *Change {
	s.ChangeType = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *Change) SetDetails(v string) *Change {
	s.Details = &v
	return s
}

// SetEntity sets the Entity field's value.
func (s *Change) SetEntity(v *Entity) *Change {
	s.Entity = v
	return s
}

// A summary of a change set returned in a list of change sets when the ListChangeSets
// action is called.
type ChangeSetSummaryListItem struct {
	_ struct{} `type:"structure"`

	// The ARN associated with the unique identifier for the change set referenced
	// in this request.
	ChangeSetArn *string `min:"1" type:"string"`

	// The unique identifier for a change set.
	ChangeSetId *string `min:"1" type:"string"`

	// The non-unique name for the change set.
	ChangeSetName *string `min:"1" type:"string"`

	// The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set
	// was finished.
	EndTime *string `min:"20" type:"string"`

	// This object is a list of entity IDs (string) that are a part of a change
	// set. The entity ID list is a maximum of 20 entities. It must contain at least
	// one entity.
	EntityIdList []*string `type:"list"`

	// The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set
	// was started.
	StartTime *string `min:"20" type:"string"`

	// The current status of the change set.
	Status *string `type:"string" enum:"ChangeStatus"`
}

// String returns the string representation
func (s ChangeSetSummaryListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeSetSummaryListItem) GoString() string {
	return s.String()
}

// SetChangeSetArn sets the ChangeSetArn field's value.
func (s *ChangeSetSummaryListItem) SetChangeSetArn(v string) *ChangeSetSummaryListItem {
	s.ChangeSetArn = &v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *ChangeSetSummaryListItem) SetChangeSetId(v string) *ChangeSetSummaryListItem {
	s.ChangeSetId = &v
	return s
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *ChangeSetSummaryListItem) SetChangeSetName(v string) *ChangeSetSummaryListItem {
	s.ChangeSetName = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ChangeSetSummaryListItem) SetEndTime(v string) *ChangeSetSummaryListItem {
	s.EndTime = &v
	return s
}

// SetEntityIdList sets the EntityIdList field's value.
func (s *ChangeSetSummaryListItem) SetEntityIdList(v []*string) *ChangeSetSummaryListItem {
	s.EntityIdList = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ChangeSetSummaryListItem) SetStartTime(v string) *ChangeSetSummaryListItem {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChangeSetSummaryListItem) SetStatus(v string) *ChangeSetSummaryListItem {
	s.Status = &v
	return s
}

// This object is a container for common summary information about the change.
// The summary doesn't contain the whole change structure.
type ChangeSummary struct {
	_ struct{} `type:"structure"`

	// The type of the change.
	ChangeType *string `min:"1" type:"string"`

	// The entity to be changed.
	Entity *Entity `type:"structure"`

	// An array of ErrorDetail objects associated with the change.
	ErrorDetailList []*ErrorDetail `type:"list"`
}

// String returns the string representation
func (s ChangeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeSummary) GoString() string {
	return s.String()
}

// SetChangeType sets the ChangeType field's value.
func (s *ChangeSummary) SetChangeType(v string) *ChangeSummary {
	s.ChangeType = &v
	return s
}

// SetEntity sets the Entity field's value.
func (s *ChangeSummary) SetEntity(v *Entity) *ChangeSummary {
	s.Entity = v
	return s
}

// SetErrorDetailList sets the ErrorDetailList field's value.
func (s *ChangeSummary) SetErrorDetailList(v []*ErrorDetail) *ChangeSummary {
	s.ErrorDetailList = v
	return s
}

type DescribeChangeSetInput struct {
	_ struct{} `type:"structure"`

	// Required. The catalog related to the request. Fixed value: AWSMarketplace
	//
	// Catalog is a required field
	Catalog *string `location:"querystring" locationName:"catalog" min:"1" type:"string" required:"true"`

	// Required. The unique identifier for the StartChangeSet request that you want
	// to describe the details for.
	//
	// ChangeSetId is a required field
	ChangeSetId *string `location:"querystring" locationName:"changeSetId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChangeSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChangeSetInput"}
	if s.Catalog == nil {
		invalidParams.Add(request.NewErrParamRequired("Catalog"))
	}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Catalog", 1))
	}
	if s.ChangeSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeSetId"))
	}
	if s.ChangeSetId != nil && len(*s.ChangeSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalog sets the Catalog field's value.
func (s *DescribeChangeSetInput) SetCatalog(v string) *DescribeChangeSetInput {
	s.Catalog = &v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *DescribeChangeSetInput) SetChangeSetId(v string) *DescribeChangeSetInput {
	s.ChangeSetId = &v
	return s
}

type DescribeChangeSetOutput struct {
	_ struct{} `type:"structure"`

	// An array of ChangeSummary objects.
	ChangeSet []*ChangeSummary `type:"list"`

	// The ARN associated with the unique identifier for the change set referenced
	// in this request.
	ChangeSetArn *string `min:"1" type:"string"`

	// Required. The unique identifier for the change set referenced in this request.
	ChangeSetId *string `min:"1" type:"string"`

	// The optional name provided in the StartChangeSet request. If you do not provide
	// a name, one is set by default.
	ChangeSetName *string `min:"1" type:"string"`

	// The date and time, in ISO 8601 format (2018-02-27T13:45:22Z), the request
	// transitioned to a terminal state. The change cannot transition to a different
	// state. Null if the request is not in a terminal state.
	EndTime *string `min:"20" type:"string"`

	// Returned if there is a failure on the change set, but that failure is not
	// related to any of the changes in the request.
	FailureDescription *string `type:"string"`

	// The date and time, in ISO 8601 format (2018-02-27T13:45:22Z), the request
	// started.
	StartTime *string `min:"20" type:"string"`

	// The status of the change request.
	Status *string `type:"string" enum:"ChangeStatus"`
}

// String returns the string representation
func (s DescribeChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChangeSetOutput) GoString() string {
	return s.String()
}

// SetChangeSet sets the ChangeSet field's value.
func (s *DescribeChangeSetOutput) SetChangeSet(v []*ChangeSummary) *DescribeChangeSetOutput {
	s.ChangeSet = v
	return s
}

// SetChangeSetArn sets the ChangeSetArn field's value.
func (s *DescribeChangeSetOutput) SetChangeSetArn(v string) *DescribeChangeSetOutput {
	s.ChangeSetArn = &v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *DescribeChangeSetOutput) SetChangeSetId(v string) *DescribeChangeSetOutput {
	s.ChangeSetId = &v
	return s
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *DescribeChangeSetOutput) SetChangeSetName(v string) *DescribeChangeSetOutput {
	s.ChangeSetName = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeChangeSetOutput) SetEndTime(v string) *DescribeChangeSetOutput {
	s.EndTime = &v
	return s
}

// SetFailureDescription sets the FailureDescription field's value.
func (s *DescribeChangeSetOutput) SetFailureDescription(v string) *DescribeChangeSetOutput {
	s.FailureDescription = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeChangeSetOutput) SetStartTime(v string) *DescribeChangeSetOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeChangeSetOutput) SetStatus(v string) *DescribeChangeSetOutput {
	s.Status = &v
	return s
}

type DescribeEntityInput struct {
	_ struct{} `type:"structure"`

	// Required. The catalog related to the request. Fixed value: AWSMarketplace
	//
	// Catalog is a required field
	Catalog *string `location:"querystring" locationName:"catalog" min:"1" type:"string" required:"true"`

	// Required. The unique ID of the entity to describe.
	//
	// EntityId is a required field
	EntityId *string `location:"querystring" locationName:"entityId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeEntityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEntityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEntityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEntityInput"}
	if s.Catalog == nil {
		invalidParams.Add(request.NewErrParamRequired("Catalog"))
	}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Catalog", 1))
	}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalog sets the Catalog field's value.
func (s *DescribeEntityInput) SetCatalog(v string) *DescribeEntityInput {
	s.Catalog = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *DescribeEntityInput) SetEntityId(v string) *DescribeEntityInput {
	s.EntityId = &v
	return s
}

type DescribeEntityOutput struct {
	_ struct{} `type:"structure"`

	// This stringified JSON object includes the details of the entity.
	Details *string `min:"2" type:"string"`

	// The ARN associated to the unique identifier for the change set referenced
	// in this request.
	EntityArn *string `min:"1" type:"string"`

	// The identifier of the entity, in the format of EntityId@RevisionId.
	EntityIdentifier *string `min:"1" type:"string"`

	// The named type of the entity, in the format of EntityType@Version.
	EntityType *string `min:"1" type:"string"`

	// The last modified date of the entity, in ISO 8601 format (2018-02-27T13:45:22Z).
	LastModifiedDate *string `type:"string"`
}

// String returns the string representation
func (s DescribeEntityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEntityOutput) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *DescribeEntityOutput) SetDetails(v string) *DescribeEntityOutput {
	s.Details = &v
	return s
}

// SetEntityArn sets the EntityArn field's value.
func (s *DescribeEntityOutput) SetEntityArn(v string) *DescribeEntityOutput {
	s.EntityArn = &v
	return s
}

// SetEntityIdentifier sets the EntityIdentifier field's value.
func (s *DescribeEntityOutput) SetEntityIdentifier(v string) *DescribeEntityOutput {
	s.EntityIdentifier = &v
	return s
}

// SetEntityType sets the EntityType field's value.
func (s *DescribeEntityOutput) SetEntityType(v string) *DescribeEntityOutput {
	s.EntityType = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *DescribeEntityOutput) SetLastModifiedDate(v string) *DescribeEntityOutput {
	s.LastModifiedDate = &v
	return s
}

// A product entity contains data that describes your product, its supported
// features, and how it can be used or launched by your customer.
type Entity struct {
	_ struct{} `type:"structure"`

	// The identifier for the entity.
	Identifier *string `min:"1" type:"string"`

	// The type of entity.
	//
	// Type is a required field
	Type *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Entity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Entity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Entity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Entity"}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *Entity) SetIdentifier(v string) *Entity {
	s.Identifier = &v
	return s
}

// SetType sets the Type field's value.
func (s *Entity) SetType(v string) *Entity {
	s.Type = &v
	return s
}

// This object is a container for common summary information about the entity.
// The summary doesn't contain the whole entity structure, but it does contain
// information common across all entities.
type EntitySummary struct {
	_ struct{} `type:"structure"`

	// The ARN associated with the unique identifier for the entity.
	EntityArn *string `min:"1" type:"string"`

	// The unique identifier for the entity.
	EntityId *string `min:"1" type:"string"`

	// The type of the entity.
	EntityType *string `min:"1" type:"string"`

	// The last time the entity was published, using ISO 8601 format (2018-02-27T13:45:22Z).
	LastModifiedDate *string `type:"string"`

	// The name for the entity. This value is not unique. It is defined by the provider.
	Name *string `type:"string"`

	// The visibility status of the entity to subscribers. This value can be Public
	// (everyone can view the entity), Limited (the entity is visible to limited
	// accounts only), or Restricted (the entity was published and then unpublished
	// and only existing subscribers can view it).
	Visibility *string `type:"string"`
}

// String returns the string representation
func (s EntitySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntitySummary) GoString() string {
	return s.String()
}

// SetEntityArn sets the EntityArn field's value.
func (s *EntitySummary) SetEntityArn(v string) *EntitySummary {
	s.EntityArn = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *EntitySummary) SetEntityId(v string) *EntitySummary {
	s.EntityId = &v
	return s
}

// SetEntityType sets the EntityType field's value.
func (s *EntitySummary) SetEntityType(v string) *EntitySummary {
	s.EntityType = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *EntitySummary) SetLastModifiedDate(v string) *EntitySummary {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *EntitySummary) SetName(v string) *EntitySummary {
	s.Name = &v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *EntitySummary) SetVisibility(v string) *EntitySummary {
	s.Visibility = &v
	return s
}

// Details about the error.
type ErrorDetail struct {
	_ struct{} `type:"structure"`

	// The error code that identifies the type of error.
	ErrorCode *string `type:"string"`

	// The message for the error.
	ErrorMessage *string `type:"string"`
}

// String returns the string representation
func (s ErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorDetail) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ErrorDetail) SetErrorCode(v string) *ErrorDetail {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ErrorDetail) SetErrorMessage(v string) *ErrorDetail {
	s.ErrorMessage = &v
	return s
}

// A filter object, used to optionally filter results from calls to the ListEntities
// and ListChangeSets actions.
type Filter struct {
	_ struct{} `type:"structure"`

	// For ListEntities, the supported value for this is an EntityId.
	//
	// For ListChangeSets, the supported values are as follows:
	Name *string `min:"1" type:"string"`

	// ListEntities - This is a list of unique EntityIds.
	//
	// ListChangeSets - The supported filter names and associated ValueLists is
	// as follows:
	//
	//    * ChangeSetName - The supported ValueList is a list of non-unique ChangeSetNames.
	//    These are defined when you call the StartChangeSet action.
	//
	//    * Status - The supported ValueList is a list of statuses for all change
	//    set requests.
	//
	//    * EntityId - The supported ValueList is a list of unique EntityIds.
	//
	//    * BeforeStartTime - The supported ValueList is a list of all change sets
	//    that started before the filter value.
	//
	//    * AfterStartTime - The supported ValueList is a list of all change sets
	//    that started after the filter value.
	//
	//    * BeforeEndTime - The supported ValueList is a list of all change sets
	//    that ended before the filter value.
	//
	//    * AfterEndTime - The supported ValueList is a list of all change sets
	//    that ended after the filter value.
	ValueList []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValueList sets the ValueList field's value.
func (s *Filter) SetValueList(v []*string) *Filter {
	s.ValueList = v
	return s
}

// There was an internal service exception.
type InternalServiceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServiceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServiceException) GoString() string {
	return s.String()
}

func newErrorInternalServiceException(v protocol.ResponseMetadata) error {
	return &InternalServiceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceException) Code() string {
	return "InternalServiceException"
}

// Message returns the exception's message.
func (s *InternalServiceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceException) OrigErr() error {
	return nil
}

func (s *InternalServiceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListChangeSetsInput struct {
	_ struct{} `type:"structure"`

	// The catalog related to the request. Fixed value: AWSMarketplace
	//
	// Catalog is a required field
	Catalog *string `min:"1" type:"string" required:"true"`

	// An array of filter objects.
	FilterList []*Filter `min:"1" type:"list"`

	// The maximum number of results returned by a single call. This value must
	// be provided in the next call to retrieve the next set of results. By default,
	// this value is 20.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `min:"1" type:"string"`

	// An object that contains two attributes, sortBy and sortOrder.
	Sort *Sort `type:"structure"`
}

// String returns the string representation
func (s ListChangeSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChangeSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChangeSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChangeSetsInput"}
	if s.Catalog == nil {
		invalidParams.Add(request.NewErrParamRequired("Catalog"))
	}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Catalog", 1))
	}
	if s.FilterList != nil && len(s.FilterList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterList", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.FilterList != nil {
		for i, v := range s.FilterList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FilterList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Sort != nil {
		if err := s.Sort.Validate(); err != nil {
			invalidParams.AddNested("Sort", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalog sets the Catalog field's value.
func (s *ListChangeSetsInput) SetCatalog(v string) *ListChangeSetsInput {
	s.Catalog = &v
	return s
}

// SetFilterList sets the FilterList field's value.
func (s *ListChangeSetsInput) SetFilterList(v []*Filter) *ListChangeSetsInput {
	s.FilterList = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChangeSetsInput) SetMaxResults(v int64) *ListChangeSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChangeSetsInput) SetNextToken(v string) *ListChangeSetsInput {
	s.NextToken = &v
	return s
}

// SetSort sets the Sort field's value.
func (s *ListChangeSetsInput) SetSort(v *Sort) *ListChangeSetsInput {
	s.Sort = v
	return s
}

type ListChangeSetsOutput struct {
	_ struct{} `type:"structure"`

	// Array of ChangeSetSummaryListItem objects.
	ChangeSetSummaryList []*ChangeSetSummaryListItem `type:"list"`

	// The value of the next token, if it exists. Null if there are no more results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListChangeSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChangeSetsOutput) GoString() string {
	return s.String()
}

// SetChangeSetSummaryList sets the ChangeSetSummaryList field's value.
func (s *ListChangeSetsOutput) SetChangeSetSummaryList(v []*ChangeSetSummaryListItem) *ListChangeSetsOutput {
	s.ChangeSetSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChangeSetsOutput) SetNextToken(v string) *ListChangeSetsOutput {
	s.NextToken = &v
	return s
}

type ListEntitiesInput struct {
	_ struct{} `type:"structure"`

	// The catalog related to the request. Fixed value: AWSMarketplace
	//
	// Catalog is a required field
	Catalog *string `min:"1" type:"string" required:"true"`

	// The type of entities to retrieve.
	//
	// EntityType is a required field
	EntityType *string `min:"1" type:"string" required:"true"`

	// An array of filter objects. Each filter object contains two attributes, filterName
	// and filterValues.
	FilterList []*Filter `min:"1" type:"list"`

	// Specifies the upper limit of the elements on a single page. If a value isn't
	// provided, the default value is 20.
	MaxResults *int64 `min:"1" type:"integer"`

	// The value of the next token, if it exists. Null if there are no more results.
	NextToken *string `min:"1" type:"string"`

	// An object that contains two attributes, sortBy and sortOrder.
	Sort *Sort `type:"structure"`
}

// String returns the string representation
func (s ListEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEntitiesInput"}
	if s.Catalog == nil {
		invalidParams.Add(request.NewErrParamRequired("Catalog"))
	}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Catalog", 1))
	}
	if s.EntityType == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityType"))
	}
	if s.EntityType != nil && len(*s.EntityType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityType", 1))
	}
	if s.FilterList != nil && len(s.FilterList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterList", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.FilterList != nil {
		for i, v := range s.FilterList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FilterList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Sort != nil {
		if err := s.Sort.Validate(); err != nil {
			invalidParams.AddNested("Sort", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalog sets the Catalog field's value.
func (s *ListEntitiesInput) SetCatalog(v string) *ListEntitiesInput {
	s.Catalog = &v
	return s
}

// SetEntityType sets the EntityType field's value.
func (s *ListEntitiesInput) SetEntityType(v string) *ListEntitiesInput {
	s.EntityType = &v
	return s
}

// SetFilterList sets the FilterList field's value.
func (s *ListEntitiesInput) SetFilterList(v []*Filter) *ListEntitiesInput {
	s.FilterList = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEntitiesInput) SetMaxResults(v int64) *ListEntitiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitiesInput) SetNextToken(v string) *ListEntitiesInput {
	s.NextToken = &v
	return s
}

// SetSort sets the Sort field's value.
func (s *ListEntitiesInput) SetSort(v *Sort) *ListEntitiesInput {
	s.Sort = v
	return s
}

type ListEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// Array of EntitySummary object.
	EntitySummaryList []*EntitySummary `type:"list"`

	// The value of the next token if it exists. Null if there is no more result.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEntitiesOutput) GoString() string {
	return s.String()
}

// SetEntitySummaryList sets the EntitySummaryList field's value.
func (s *ListEntitiesOutput) SetEntitySummaryList(v []*EntitySummary) *ListEntitiesOutput {
	s.EntitySummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitiesOutput) SetNextToken(v string) *ListEntitiesOutput {
	s.NextToken = &v
	return s
}

// The resource is currently in use.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource wasn't found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Currently, the specified resource is not supported.
type ResourceNotSupportedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotSupportedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotSupportedException) GoString() string {
	return s.String()
}

func newErrorResourceNotSupportedException(v protocol.ResponseMetadata) error {
	return &ResourceNotSupportedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotSupportedException) Code() string {
	return "ResourceNotSupportedException"
}

// Message returns the exception's message.
func (s *ResourceNotSupportedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotSupportedException) OrigErr() error {
	return nil
}

func (s *ResourceNotSupportedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotSupportedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotSupportedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The maximum number of open requests per account has been exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that contains two attributes, sortBy and sortOrder.
type Sort struct {
	_ struct{} `type:"structure"`

	// For ListEntities, supported attributes include LastModifiedDate (default),
	// Visibility, EntityId, and Name.
	//
	// For ListChangeSets, supported attributes include StartTime and EndTime.
	SortBy *string `min:"1" type:"string"`

	// The sorting order. Can be ASCENDING or DESCENDING. The default value is DESCENDING.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation
func (s Sort) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Sort) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Sort) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Sort"}
	if s.SortBy != nil && len(*s.SortBy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SortBy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSortBy sets the SortBy field's value.
func (s *Sort) SetSortBy(v string) *Sort {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *Sort) SetSortOrder(v string) *Sort {
	s.SortOrder = &v
	return s
}

type StartChangeSetInput struct {
	_ struct{} `type:"structure"`

	// The catalog related to the request. Fixed value: AWSMarketplace
	//
	// Catalog is a required field
	Catalog *string `min:"1" type:"string" required:"true"`

	// Array of change object.
	//
	// ChangeSet is a required field
	ChangeSet []*Change `min:"1" type:"list" required:"true"`

	// Optional case sensitive string of up to 100 ASCII characters. The change
	// set name can be used to filter the list of change sets.
	ChangeSetName *string `min:"1" type:"string"`

	// A unique token to identify the request to ensure idempotency.
	ClientRequestToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartChangeSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartChangeSetInput"}
	if s.Catalog == nil {
		invalidParams.Add(request.NewErrParamRequired("Catalog"))
	}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Catalog", 1))
	}
	if s.ChangeSet == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeSet"))
	}
	if s.ChangeSet != nil && len(s.ChangeSet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSet", 1))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.ChangeSet != nil {
		for i, v := range s.ChangeSet {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ChangeSet", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalog sets the Catalog field's value.
func (s *StartChangeSetInput) SetCatalog(v string) *StartChangeSetInput {
	s.Catalog = &v
	return s
}

// SetChangeSet sets the ChangeSet field's value.
func (s *StartChangeSetInput) SetChangeSet(v []*Change) *StartChangeSetInput {
	s.ChangeSet = v
	return s
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *StartChangeSetInput) SetChangeSetName(v string) *StartChangeSetInput {
	s.ChangeSetName = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartChangeSetInput) SetClientRequestToken(v string) *StartChangeSetInput {
	s.ClientRequestToken = &v
	return s
}

type StartChangeSetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN associated to the unique identifier generated for the request.
	ChangeSetArn *string `min:"1" type:"string"`

	// Unique identifier generated for the request.
	ChangeSetId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartChangeSetOutput) GoString() string {
	return s.String()
}

// SetChangeSetArn sets the ChangeSetArn field's value.
func (s *StartChangeSetOutput) SetChangeSetArn(v string) *StartChangeSetOutput {
	s.ChangeSetArn = &v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *StartChangeSetOutput) SetChangeSetId(v string) *StartChangeSetOutput {
	s.ChangeSetId = &v
	return s
}

// Too many requests.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An error occurred during validation.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ChangeStatusPreparing is a ChangeStatus enum value
	ChangeStatusPreparing = "PREPARING"

	// ChangeStatusApplying is a ChangeStatus enum value
	ChangeStatusApplying = "APPLYING"

	// ChangeStatusSucceeded is a ChangeStatus enum value
	ChangeStatusSucceeded = "SUCCEEDED"

	// ChangeStatusCancelled is a ChangeStatus enum value
	ChangeStatusCancelled = "CANCELLED"

	// ChangeStatusFailed is a ChangeStatus enum value
	ChangeStatusFailed = "FAILED"
)

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "ASCENDING"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "DESCENDING"
)
