// Copyright 2018-2020 opcua authors. All rights reserved.
// Use of this source code is governed by a MIT-style license that can be
// found in the LICENSE file.

package ua

import (
	"testing"
)

func TestAnonymousIdentityToken(t *testing.T) {
	cases := []CodecTestCase{
		{
			Name:   "normal",
			Struct: &AnonymousIdentityToken{PolicyID: "anonymous"},
			Bytes: []byte{
				0x09, 0x00, 0x00, 0x00,
				0x61, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73,
			},
		},
	}
	RunCodecTest(t, cases)
}

func TestUserNameIdentityToken(t *testing.T) {
	cases := []CodecTestCase{
		{
			Name: "normal",
			Struct: &UserNameIdentityToken{
				PolicyID:            "username",
				UserName:            "user",
				Password:            []byte{0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64},
				EncryptionAlgorithm: "plain",
			},
			Bytes: []byte{
				// PolicyID
				0x08, 0x00, 0x00, 0x00, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65,
				// UserName
				0x04, 0x00, 0x00, 0x00, 0x75, 0x73, 0x65, 0x72,
				// Password
				0x08, 0x00, 0x00, 0x00, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
				// EncryptionAlgorithm
				0x05, 0x00, 0x00, 0x00, 0x70, 0x6c, 0x61, 0x69, 0x6e,
			},
		},
	}
	RunCodecTest(t, cases)
}

func TestX509IdentityToken(t *testing.T) {
	cases := []CodecTestCase{
		{
			Name: "normal",
			Struct: &X509IdentityToken{
				PolicyID:        "x509",
				CertificateData: []byte("certificate"),
			},
			Bytes: []byte{
				// PolicyID
				0x04, 0x00, 0x00, 0x00, 0x78, 0x35, 0x30, 0x39,
				// CertificateData
				0x0b, 0x00, 0x00, 0x00, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
			},
		},
	}
	RunCodecTest(t, cases)
}

func TestIssuedIdentityToken(t *testing.T) {
	cases := []CodecTestCase{
		{
			Name: "normal",
			Struct: &IssuedIdentityToken{
				PolicyID:            "issued",
				TokenData:           []byte{0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64},
				EncryptionAlgorithm: "plain",
			},
			Bytes: []byte{
				// PolicyID
				0x06, 0x00, 0x00, 0x00, 0x69, 0x73, 0x73, 0x75, 0x65, 0x64,
				// TokenData
				0x08, 0x00, 0x00, 0x00, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
				// EncryptionAlgorithm
				0x05, 0x00, 0x00, 0x00, 0x70, 0x6c, 0x61, 0x69, 0x6e,
			},
		},
	}
	RunCodecTest(t, cases)
}
