// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/cx/v3beta1/session.proto

package cxpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Sessions_DetectIntent_FullMethodName                = "/google.cloud.dialogflow.cx.v3beta1.Sessions/DetectIntent"
	Sessions_ServerStreamingDetectIntent_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.Sessions/ServerStreamingDetectIntent"
	Sessions_StreamingDetectIntent_FullMethodName       = "/google.cloud.dialogflow.cx.v3beta1.Sessions/StreamingDetectIntent"
	Sessions_MatchIntent_FullMethodName                 = "/google.cloud.dialogflow.cx.v3beta1.Sessions/MatchIntent"
	Sessions_FulfillIntent_FullMethodName               = "/google.cloud.dialogflow.cx.v3beta1.Sessions/FulfillIntent"
	Sessions_SubmitAnswerFeedback_FullMethodName        = "/google.cloud.dialogflow.cx.v3beta1.Sessions/SubmitAnswerFeedback"
)

// SessionsClient is the client API for Sessions service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SessionsClient interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause session
	// entity types to be updated, which in turn might affect results of future
	// queries.
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
	DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error)
	// Processes a natural language query and returns structured, actionable data
	// as a result through server-side streaming. Server-side streaming allows
	// Dialogflow to send [partial
	// responses](https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#partial-response)
	// earlier in a single request.
	ServerStreamingDetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (Sessions_ServerStreamingDetectIntentClient, error)
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
	StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error)
	// Returns preliminary intent match results, doesn't change the session
	// status.
	MatchIntent(ctx context.Context, in *MatchIntentRequest, opts ...grpc.CallOption) (*MatchIntentResponse, error)
	// Fulfills a matched intent returned by
	// [MatchIntent][google.cloud.dialogflow.cx.v3beta1.Sessions.MatchIntent].
	// Must be called after
	// [MatchIntent][google.cloud.dialogflow.cx.v3beta1.Sessions.MatchIntent],
	// with input from
	// [MatchIntentResponse][google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse].
	// Otherwise, the behavior is undefined.
	FulfillIntent(ctx context.Context, in *FulfillIntentRequest, opts ...grpc.CallOption) (*FulfillIntentResponse, error)
	// Updates the feedback received from the user for a single turn of the bot
	// response.
	SubmitAnswerFeedback(ctx context.Context, in *SubmitAnswerFeedbackRequest, opts ...grpc.CallOption) (*AnswerFeedback, error)
}

type sessionsClient struct {
	cc grpc.ClientConnInterface
}

func NewSessionsClient(cc grpc.ClientConnInterface) SessionsClient {
	return &sessionsClient{cc}
}

func (c *sessionsClient) DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error) {
	out := new(DetectIntentResponse)
	err := c.cc.Invoke(ctx, Sessions_DetectIntent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionsClient) ServerStreamingDetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (Sessions_ServerStreamingDetectIntentClient, error) {
	stream, err := c.cc.NewStream(ctx, &Sessions_ServiceDesc.Streams[0], Sessions_ServerStreamingDetectIntent_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &sessionsServerStreamingDetectIntentClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Sessions_ServerStreamingDetectIntentClient interface {
	Recv() (*DetectIntentResponse, error)
	grpc.ClientStream
}

type sessionsServerStreamingDetectIntentClient struct {
	grpc.ClientStream
}

func (x *sessionsServerStreamingDetectIntentClient) Recv() (*DetectIntentResponse, error) {
	m := new(DetectIntentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *sessionsClient) StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error) {
	stream, err := c.cc.NewStream(ctx, &Sessions_ServiceDesc.Streams[1], Sessions_StreamingDetectIntent_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &sessionsStreamingDetectIntentClient{stream}
	return x, nil
}

type Sessions_StreamingDetectIntentClient interface {
	Send(*StreamingDetectIntentRequest) error
	Recv() (*StreamingDetectIntentResponse, error)
	grpc.ClientStream
}

type sessionsStreamingDetectIntentClient struct {
	grpc.ClientStream
}

func (x *sessionsStreamingDetectIntentClient) Send(m *StreamingDetectIntentRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentClient) Recv() (*StreamingDetectIntentResponse, error) {
	m := new(StreamingDetectIntentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *sessionsClient) MatchIntent(ctx context.Context, in *MatchIntentRequest, opts ...grpc.CallOption) (*MatchIntentResponse, error) {
	out := new(MatchIntentResponse)
	err := c.cc.Invoke(ctx, Sessions_MatchIntent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionsClient) FulfillIntent(ctx context.Context, in *FulfillIntentRequest, opts ...grpc.CallOption) (*FulfillIntentResponse, error) {
	out := new(FulfillIntentResponse)
	err := c.cc.Invoke(ctx, Sessions_FulfillIntent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionsClient) SubmitAnswerFeedback(ctx context.Context, in *SubmitAnswerFeedbackRequest, opts ...grpc.CallOption) (*AnswerFeedback, error) {
	out := new(AnswerFeedback)
	err := c.cc.Invoke(ctx, Sessions_SubmitAnswerFeedback_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SessionsServer is the server API for Sessions service.
// All implementations should embed UnimplementedSessionsServer
// for forward compatibility
type SessionsServer interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause session
	// entity types to be updated, which in turn might affect results of future
	// queries.
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
	DetectIntent(context.Context, *DetectIntentRequest) (*DetectIntentResponse, error)
	// Processes a natural language query and returns structured, actionable data
	// as a result through server-side streaming. Server-side streaming allows
	// Dialogflow to send [partial
	// responses](https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#partial-response)
	// earlier in a single request.
	ServerStreamingDetectIntent(*DetectIntentRequest, Sessions_ServerStreamingDetectIntentServer) error
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
	StreamingDetectIntent(Sessions_StreamingDetectIntentServer) error
	// Returns preliminary intent match results, doesn't change the session
	// status.
	MatchIntent(context.Context, *MatchIntentRequest) (*MatchIntentResponse, error)
	// Fulfills a matched intent returned by
	// [MatchIntent][google.cloud.dialogflow.cx.v3beta1.Sessions.MatchIntent].
	// Must be called after
	// [MatchIntent][google.cloud.dialogflow.cx.v3beta1.Sessions.MatchIntent],
	// with input from
	// [MatchIntentResponse][google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse].
	// Otherwise, the behavior is undefined.
	FulfillIntent(context.Context, *FulfillIntentRequest) (*FulfillIntentResponse, error)
	// Updates the feedback received from the user for a single turn of the bot
	// response.
	SubmitAnswerFeedback(context.Context, *SubmitAnswerFeedbackRequest) (*AnswerFeedback, error)
}

// UnimplementedSessionsServer should be embedded to have forward compatible implementations.
type UnimplementedSessionsServer struct {
}

func (UnimplementedSessionsServer) DetectIntent(context.Context, *DetectIntentRequest) (*DetectIntentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetectIntent not implemented")
}
func (UnimplementedSessionsServer) ServerStreamingDetectIntent(*DetectIntentRequest, Sessions_ServerStreamingDetectIntentServer) error {
	return status.Errorf(codes.Unimplemented, "method ServerStreamingDetectIntent not implemented")
}
func (UnimplementedSessionsServer) StreamingDetectIntent(Sessions_StreamingDetectIntentServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamingDetectIntent not implemented")
}
func (UnimplementedSessionsServer) MatchIntent(context.Context, *MatchIntentRequest) (*MatchIntentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MatchIntent not implemented")
}
func (UnimplementedSessionsServer) FulfillIntent(context.Context, *FulfillIntentRequest) (*FulfillIntentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FulfillIntent not implemented")
}
func (UnimplementedSessionsServer) SubmitAnswerFeedback(context.Context, *SubmitAnswerFeedbackRequest) (*AnswerFeedback, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SubmitAnswerFeedback not implemented")
}

// UnsafeSessionsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SessionsServer will
// result in compilation errors.
type UnsafeSessionsServer interface {
	mustEmbedUnimplementedSessionsServer()
}

func RegisterSessionsServer(s grpc.ServiceRegistrar, srv SessionsServer) {
	s.RegisterService(&Sessions_ServiceDesc, srv)
}

func _Sessions_DetectIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetectIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionsServer).DetectIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Sessions_DetectIntent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionsServer).DetectIntent(ctx, req.(*DetectIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Sessions_ServerStreamingDetectIntent_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(DetectIntentRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SessionsServer).ServerStreamingDetectIntent(m, &sessionsServerStreamingDetectIntentServer{stream})
}

type Sessions_ServerStreamingDetectIntentServer interface {
	Send(*DetectIntentResponse) error
	grpc.ServerStream
}

type sessionsServerStreamingDetectIntentServer struct {
	grpc.ServerStream
}

func (x *sessionsServerStreamingDetectIntentServer) Send(m *DetectIntentResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Sessions_StreamingDetectIntent_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SessionsServer).StreamingDetectIntent(&sessionsStreamingDetectIntentServer{stream})
}

type Sessions_StreamingDetectIntentServer interface {
	Send(*StreamingDetectIntentResponse) error
	Recv() (*StreamingDetectIntentRequest, error)
	grpc.ServerStream
}

type sessionsStreamingDetectIntentServer struct {
	grpc.ServerStream
}

func (x *sessionsStreamingDetectIntentServer) Send(m *StreamingDetectIntentResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentServer) Recv() (*StreamingDetectIntentRequest, error) {
	m := new(StreamingDetectIntentRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Sessions_MatchIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MatchIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionsServer).MatchIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Sessions_MatchIntent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionsServer).MatchIntent(ctx, req.(*MatchIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Sessions_FulfillIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FulfillIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionsServer).FulfillIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Sessions_FulfillIntent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionsServer).FulfillIntent(ctx, req.(*FulfillIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Sessions_SubmitAnswerFeedback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubmitAnswerFeedbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionsServer).SubmitAnswerFeedback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Sessions_SubmitAnswerFeedback_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionsServer).SubmitAnswerFeedback(ctx, req.(*SubmitAnswerFeedbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Sessions_ServiceDesc is the grpc.ServiceDesc for Sessions service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Sessions_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.Sessions",
	HandlerType: (*SessionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DetectIntent",
			Handler:    _Sessions_DetectIntent_Handler,
		},
		{
			MethodName: "MatchIntent",
			Handler:    _Sessions_MatchIntent_Handler,
		},
		{
			MethodName: "FulfillIntent",
			Handler:    _Sessions_FulfillIntent_Handler,
		},
		{
			MethodName: "SubmitAnswerFeedback",
			Handler:    _Sessions_SubmitAnswerFeedback_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ServerStreamingDetectIntent",
			Handler:       _Sessions_ServerStreamingDetectIntent_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "StreamingDetectIntent",
			Handler:       _Sessions_StreamingDetectIntent_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/session.proto",
}
